# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetKeyTransactionResult',
    'AwaitableGetKeyTransactionResult',
    'get_key_transaction',
    'get_key_transaction_output',
]

@pulumi.output_type
class GetKeyTransactionResult:
    """
    A collection of values returned by getKeyTransaction.
    """
    def __init__(__self__, account_id=None, domain=None, guid=None, id=None, name=None, type=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if domain and not isinstance(domain, str):
            raise TypeError("Expected argument 'domain' to be a str")
        pulumi.set(__self__, "domain", domain)
        if guid and not isinstance(guid, str):
            raise TypeError("Expected argument 'guid' to be a str")
        pulumi.set(__self__, "guid", guid)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> _builtins.str:
        """
        Domain of the key transaction in New Relic.
        """
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def guid(self) -> _builtins.str:
        """
        GUID of the key transaction in New Relic.
        """
        return pulumi.get(self, "guid")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of the key transaction in New Relic.
        """
        return pulumi.get(self, "type")


class AwaitableGetKeyTransactionResult(GetKeyTransactionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyTransactionResult(
            account_id=self.account_id,
            domain=self.domain,
            guid=self.guid,
            id=self.id,
            name=self.name,
            type=self.type)


def get_key_transaction(account_id: Optional[_builtins.str] = None,
                        guid: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyTransactionResult:
    """
    Use this data source to get information about a specific key transaction in New Relic that already exists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    txn = newrelic.get_key_transaction(name="txn")
    foo = newrelic.AlertPolicy("foo", name="foo")
    foo_alert_condition = newrelic.AlertCondition("foo",
        policy_id=foo.id,
        name="foo",
        type="apm_kt_metric",
        entities=[txn.id],
        metric="error_percentage",
        runbook_url="https://www.example.com",
        terms=[{
            "duration": 5,
            "operator": "below",
            "priority": "critical",
            "threshold": 0.75,
            "time_function": "all",
        }])
    ```


    :param _builtins.str account_id: The account ID you would like to search for key transactions in. Defaults to `account_id` in the `provider{}` (or `NEW_RELIC_ACCOUNT_ID` in your environment) if not specified.
           
           > **NOTE** If the `name` specified in the configuration matches the names of multiple key transactions in the account, the data source will return the first match from the list of all matching key transactions retrieved from the API. However, when using the `guid` argument as the search criterion, only the key transaction with that particular GUID is returned, as each key transaction has a unique GUID.
    :param _builtins.str guid: GUID of the key transaction in New Relic.
    :param _builtins.str name: The name of the key transaction in New Relic.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['guid'] = guid
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('newrelic:index/getKeyTransaction:getKeyTransaction', __args__, opts=opts, typ=GetKeyTransactionResult).value

    return AwaitableGetKeyTransactionResult(
        account_id=pulumi.get(__ret__, 'account_id'),
        domain=pulumi.get(__ret__, 'domain'),
        guid=pulumi.get(__ret__, 'guid'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        type=pulumi.get(__ret__, 'type'))
def get_key_transaction_output(account_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               guid: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[_builtins.str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyTransactionResult]:
    """
    Use this data source to get information about a specific key transaction in New Relic that already exists.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_newrelic as newrelic

    txn = newrelic.get_key_transaction(name="txn")
    foo = newrelic.AlertPolicy("foo", name="foo")
    foo_alert_condition = newrelic.AlertCondition("foo",
        policy_id=foo.id,
        name="foo",
        type="apm_kt_metric",
        entities=[txn.id],
        metric="error_percentage",
        runbook_url="https://www.example.com",
        terms=[{
            "duration": 5,
            "operator": "below",
            "priority": "critical",
            "threshold": 0.75,
            "time_function": "all",
        }])
    ```


    :param _builtins.str account_id: The account ID you would like to search for key transactions in. Defaults to `account_id` in the `provider{}` (or `NEW_RELIC_ACCOUNT_ID` in your environment) if not specified.
           
           > **NOTE** If the `name` specified in the configuration matches the names of multiple key transactions in the account, the data source will return the first match from the list of all matching key transactions retrieved from the API. However, when using the `guid` argument as the search criterion, only the key transaction with that particular GUID is returned, as each key transaction has a unique GUID.
    :param _builtins.str guid: GUID of the key transaction in New Relic.
    :param _builtins.str name: The name of the key transaction in New Relic.
    """
    __args__ = dict()
    __args__['accountId'] = account_id
    __args__['guid'] = guid
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('newrelic:index/getKeyTransaction:getKeyTransaction', __args__, opts=opts, typ=GetKeyTransactionResult)
    return __ret__.apply(lambda __response__: GetKeyTransactionResult(
        account_id=pulumi.get(__response__, 'account_id'),
        domain=pulumi.get(__response__, 'domain'),
        guid=pulumi.get(__response__, 'guid'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        type=pulumi.get(__response__, 'type')))
