# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NrqlDropRuleArgs', 'NrqlDropRule']

@pulumi.input_type
class NrqlDropRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 nrql: pulumi.Input[_builtins.str],
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NrqlDropRule resource.
        :param pulumi.Input[_builtins.str] action: An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        :param pulumi.Input[_builtins.str] nrql: A NRQL string that specifies what data types to drop.
        :param pulumi.Input[_builtins.str] account_id: Account where the drop rule will be put. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] description: The description of the drop rule.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "nrql", nrql)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Input[_builtins.str]:
        """
        A NRQL string that specifies what data types to drop.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "nrql", value)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account where the drop rule will be put. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the drop rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _NrqlDropRuleState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None,
                 pipeline_cloud_rule_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NrqlDropRule resources.
        :param pulumi.Input[_builtins.str] account_id: Account where the drop rule will be put. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] action: An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        :param pulumi.Input[_builtins.str] description: The description of the drop rule.
        :param pulumi.Input[_builtins.str] nrql: A NRQL string that specifies what data types to drop.
        :param pulumi.Input[_builtins.str] pipeline_cloud_rule_entity_id: The ID (GUID) of the corresponding Pipeline Cloud Rule, (migrated upstream by New Relic, in light of the upcoming EOL, as stated in the Deprecation Warning above). This can be used to import the corresponding Pipeline Cloud Rule as a [`PipelineCloudRule`](https://www.terraform.io/providers/newrelic/newrelic/latest/docs/resources/pipeline_cloud_rule) resource, as explained in our Drop Rules EOL Migration Guide.
        :param pulumi.Input[_builtins.str] rule_id: The id, uniquely identifying the rule.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if nrql is not None:
            pulumi.set(__self__, "nrql", nrql)
        if pipeline_cloud_rule_entity_id is not None:
            pulumi.set(__self__, "pipeline_cloud_rule_entity_id", pipeline_cloud_rule_entity_id)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Account where the drop rule will be put. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the drop rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A NRQL string that specifies what data types to drop.
        """
        return pulumi.get(self, "nrql")

    @nrql.setter
    def nrql(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "nrql", value)

    @_builtins.property
    @pulumi.getter(name="pipelineCloudRuleEntityId")
    def pipeline_cloud_rule_entity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID (GUID) of the corresponding Pipeline Cloud Rule, (migrated upstream by New Relic, in light of the upcoming EOL, as stated in the Deprecation Warning above). This can be used to import the corresponding Pipeline Cloud Rule as a [`PipelineCloudRule`](https://www.terraform.io/providers/newrelic/newrelic/latest/docs/resources/pipeline_cloud_rule) resource, as explained in our Drop Rules EOL Migration Guide.
        """
        return pulumi.get(self, "pipeline_cloud_rule_entity_id")

    @pipeline_cloud_rule_entity_id.setter
    def pipeline_cloud_rule_entity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pipeline_cloud_rule_entity_id", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id, uniquely identifying the rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)


@pulumi.type_token("newrelic:index/nrqlDropRule:NrqlDropRule")
class NrqlDropRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        New Relic NRQL drop rules can be imported using a concatenated string of the format

         `<account_id>:<rule_id>`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:index/nrqlDropRule:NrqlDropRule foo 12345:34567
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account where the drop rule will be put. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] action: An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        :param pulumi.Input[_builtins.str] description: The description of the drop rule.
        :param pulumi.Input[_builtins.str] nrql: A NRQL string that specifies what data types to drop.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NrqlDropRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        New Relic NRQL drop rules can be imported using a concatenated string of the format

         `<account_id>:<rule_id>`, e.g.

        bash

        ```sh
        $ pulumi import newrelic:index/nrqlDropRule:NrqlDropRule foo 12345:34567
        ```

        :param str resource_name: The name of the resource.
        :param NrqlDropRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NrqlDropRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 nrql: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NrqlDropRuleArgs.__new__(NrqlDropRuleArgs)

            __props__.__dict__["account_id"] = account_id
            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            if nrql is None and not opts.urn:
                raise TypeError("Missing required property 'nrql'")
            __props__.__dict__["nrql"] = nrql
            __props__.__dict__["pipeline_cloud_rule_entity_id"] = None
            __props__.__dict__["rule_id"] = None
        super(NrqlDropRule, __self__).__init__(
            'newrelic:index/nrqlDropRule:NrqlDropRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            nrql: Optional[pulumi.Input[_builtins.str]] = None,
            pipeline_cloud_rule_entity_id: Optional[pulumi.Input[_builtins.str]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NrqlDropRule':
        """
        Get an existing NrqlDropRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Account where the drop rule will be put. Defaults to the account associated with the API key used.
        :param pulumi.Input[_builtins.str] action: An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        :param pulumi.Input[_builtins.str] description: The description of the drop rule.
        :param pulumi.Input[_builtins.str] nrql: A NRQL string that specifies what data types to drop.
        :param pulumi.Input[_builtins.str] pipeline_cloud_rule_entity_id: The ID (GUID) of the corresponding Pipeline Cloud Rule, (migrated upstream by New Relic, in light of the upcoming EOL, as stated in the Deprecation Warning above). This can be used to import the corresponding Pipeline Cloud Rule as a [`PipelineCloudRule`](https://www.terraform.io/providers/newrelic/newrelic/latest/docs/resources/pipeline_cloud_rule) resource, as explained in our Drop Rules EOL Migration Guide.
        :param pulumi.Input[_builtins.str] rule_id: The id, uniquely identifying the rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NrqlDropRuleState.__new__(_NrqlDropRuleState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["nrql"] = nrql
        __props__.__dict__["pipeline_cloud_rule_entity_id"] = pipeline_cloud_rule_entity_id
        __props__.__dict__["rule_id"] = rule_id
        return NrqlDropRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Account where the drop rule will be put. Defaults to the account associated with the API key used.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[_builtins.str]:
        """
        An action type specifying how to apply the NRQL string (either `drop_data`, `drop_attributes`, or ` drop_attributes_from_metric_aggregates`).
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the drop rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def nrql(self) -> pulumi.Output[_builtins.str]:
        """
        A NRQL string that specifies what data types to drop.
        """
        return pulumi.get(self, "nrql")

    @_builtins.property
    @pulumi.getter(name="pipelineCloudRuleEntityId")
    def pipeline_cloud_rule_entity_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID (GUID) of the corresponding Pipeline Cloud Rule, (migrated upstream by New Relic, in light of the upcoming EOL, as stated in the Deprecation Warning above). This can be used to import the corresponding Pipeline Cloud Rule as a [`PipelineCloudRule`](https://www.terraform.io/providers/newrelic/newrelic/latest/docs/resources/pipeline_cloud_rule) resource, as explained in our Drop Rules EOL Migration Guide.
        """
        return pulumi.get(self, "pipeline_cloud_rule_entity_id")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id, uniquely identifying the rule.
        """
        return pulumi.get(self, "rule_id")

