# Counterfactual Subtheory Citation

## Software Implementation Citation

If you use the counterfactual subtheory implementation in your research, please cite:

```bibtex
@software{logos_counterfactual_implementation,
  author = {Benjamin Brast-McKie},
  title = {Logos Counterfactual Subtheory: Truthmaker Counterfactual Semantics Implementation},
  year = {2024},
  url = {https://github.com/benbrastmckie/ModelChecker},
  version = {1.0.0}
}
```

## Semantic Theory Citation

The counterfactual operators implemented in this subtheory are based on the truthmaker semantics developed in:

```bibtex
@article{brast_mckie_counterfactual_worlds,
  author = {Benjamin Brast-McKie},
  title = {Counterfactual Worlds},
  journal = {Journal of Philosophical Logic},
  year = {2025},
  doi = {10.1007/s10992-025-09793-8}
}
```

## Related Foundational Work

The imposition-based approach to counterfactuals that influenced this implementation:

```bibtex
@article{fine_counterfactuals_2012,
  author = {Kit Fine},
  title = {Counterfactuals without Possible Worlds},
  journal = {Journal of Philosophy},
  volume = {109},
  number = {3},
  pages = {221--246},
  year = {2012},
  doi = {10.5840/jphil2012109312}
}
```

```bibtex
@article{fine_difficulty_2012,
  author = {Kit Fine},
  title = {A Difficulty for the Possible Worlds Analysis of Counterfactuals},
  journal = {Synthese},
  volume = {189},
  number = {1},
  pages = {29--57},
  year = {2012},
  doi = {10.1007/s11229-012-0094-y}
}
```

The general truthmaker semantics framework:

```bibtex
@incollection{fine_truthmaker_2017,
  author = {Kit Fine},
  title = {Truthmaker Semantics},
  booktitle = {A Companion to the Philosophy of Language},
  edition = {2nd},
  publisher = {Wiley-Blackwell},
  year = {2017},
  doi = {10.1002/9781118972090.ch22}
}
```

## Description

This subtheory implements counterfactual operators (⥽, ⥼) within the truthmaker semantics framework, providing an alternative to possible worlds semantics for counterfactual reasoning. The implementation supports both would and might counterfactuals with hyperintensional truthmaker conditions.