# SmoothDev CLI

> AI-powered development assistance for commit messages, pull requests, and release notes.

[![Python 3.12+](https://img.shields.io/badge/python-3.12+-blue.svg)](https://www.python.org/downloads/)
[![PyPI](https://img.shields.io/pypi/v/smooth-cli.svg)](https://pypi.org/project/smooth-cli/)
[![License](https://img.shields.io/badge/license-Proprietary-red.svg)](LICENSE)

## Overview

The SmoothDev CLI (`smooth`) provides AI-powered assistance for common development workflows:

- **Commit Messages**: Generate conventional commit messages from staged changes
- **Pull Requests**: Create professional PR titles and summaries with GitHub integration
- **Release Notes**: Automatically generate release notes from git history

## Installation

**From PyPI** (Recommended):

```bash
pip install smooth-cli
```

## Features

### 📝 Commit Message Generation

Generate conventional commit messages from your staged changes.

**Command:**

```bash
# Stage your changes
git add .

# Generate commit message
smooth commit generate

# Generate and commit
smooth commit generate --commit
```

**Example Output:**

```
feat: add user authentication with Auth0

- Implement Auth0 device flow authentication
- Add token storage and refresh logic
- Create auth command group with login/logout
- Add secure token file permissions (0600)
```

**Features:**

- Analyzes git diff automatically
- Generates conventional commit format (feat, fix, docs, etc.)
- Handles large diffs intelligently
- Provides detailed commit body with bullet points

---

### 🔀 Pull Request Generation

Generate professional PR titles and comprehensive summaries from GitHub PR data.

**Command:**

```bash
# Auto-detects owner/repo from git remote
smooth pr generate --pr-number 42

# On branch "pr-42" - auto-detects everything!
smooth pr generate

# Push directly to GitHub
smooth pr generate --pr-number 42 --push
```

**Example Output:**

```
feat: implement smart defaults and configuration system

# PR Summary

Generated by: *Smoothdev.io*

## Overview

This PR introduces a four-tier configuration precedence system that enables smart defaults
and auto-detection of repository context, significantly reducing the need for repetitive
CLI flags.

## Changes

### Added
- Four-tier configuration precedence (CLI flags → Git context → Repo config → User config)
- Auto-detection of owner/repo from git remotes
- PR number detection from branch names
- Smart tag detection for release notes
- Configuration management commands (`smooth config`)

### Modified
- Updated all commands to support smart defaults
- Enhanced error messages with context information

## Testing

- Added 53 new tests covering auto-detection scenarios
- All existing tests passing
- Coverage maintained at 85%+

## Documentation

- Updated README with smart defaults examples
- Added ADR for configuration system design
- Created user guide for configuration management
```

**Features:**

- Fetches PR data directly from GitHub API
- Generates concise titles (max 250 characters)
- Creates structured summaries with multiple sections
- Clean, markdown-formatted output
- Optional push to GitHub
- Smart defaults reduce required flags

---

### 🚀 Release Notes Generation

Generate comprehensive release notes from git history.

**Command:**

```bash
# Auto-detects latest two tags
smooth release generate

# Specify tags explicitly
smooth release generate --from-tag v1.0.0 --to-tag v1.1.0

# Push to GitHub Releases
smooth release generate --from-tag v1.0.0 --to-tag v1.1.0 --push
```

**Example Output:**

```
# Release v1.1.0

## 🎉 New Features

- **Smart Defaults**: Four-tier configuration precedence system
- **Auto-Detection**: Automatic owner/repo detection from git remotes
- **PR Number Detection**: Extract PR numbers from branch names
- **Config Management**: New `smooth config` command group

## 🐛 Bug Fixes

- Fixed issue with large diff handling in commit generation
- Resolved GitHub API rate limiting edge cases

## 📚 Documentation

- Added comprehensive configuration guide
- Updated README with smart defaults examples
- Created ADR for configuration system

## 🔧 Improvements

- Reduced required CLI flags by 80%
- Enhanced error messages with context
- Improved verbose mode output

## 📊 Statistics

- **Commits**: 47
- **Contributors**: 3
- **Files Changed**: 28

**Features:**

- Automatic tag detection (latest and previous)
- Semantic versioning support
- Categorized changelog (features, fixes, docs, etc.)
- Breaking change detection
- Contributor statistics
- Optional GitHub Releases integration
```

---

### ⚡ Smart Defaults

The CLI automatically detects context from your git repository, eliminating repetitive flags.

**Four-Tier Precedence:**

1. **CLI Flags** - Explicit overrides (highest priority)
2. **Git Context** - Auto-detected from repository
3. **Repository Config** - Team settings (`.smoothdev.json`)
4. **User Config** - Personal defaults (`~/.smoothdevio/config.json`)

**Auto-Detection Features:**

- Owner and repo from git remote URLs
- PR number from branch names (`pr-123`, `123-feature`)
- Latest and previous tags for release notes
- Current branch from git HEAD

**Example:**

```bash
# Before: Required flags every time
smooth pr generate --owner smoothdev-io --repo my-repo --pr-number 42

# After: Auto-detected from git!
smooth pr generate  # On branch "pr-42" in a git repo with remote
```

## Authentication

The CLI uses Auth0 device flow for secure authentication.

### Login

```bash
smooth auth login
```

This will:

1. Display a device code and URL
2. Open your browser to authenticate
3. Store your token securely at `~/.smoothdevio/token.json` (with `0600` permissions)
4. Auto-refresh the token when needed

### Logout

```bash
smooth auth logout
```

### GitHub Token

For commands that push to GitHub (e.g., `--push` flag), set your GitHub token:

```bash
export GITHUB_TOKEN=ghp_your_token_here
```

Or add it to your user config (see Configuration section below).

## Configuration

The CLI uses a four-tier configuration system that automatically resolves settings in this order:

### Configuration Precedence

1. **CLI Flags** (highest priority) - Explicit command-line arguments
2. **Git Context** - Auto-detected from your repository
3. **Repository Config** - Team settings in `.smoothdev.json`
4. **User Config** - Personal defaults in `~/.smoothdevio/config.json`

### User Config

Store personal defaults at `~/.smoothdevio/config.json`:

```json
{
  "github_token": "ghp_your_token_here",
  "defaults": {
    "owner": "your-org",
    "output": "text",
    "verbose": false
  }
}
```

**Initialize user config:**

```bash
smooth config init --owner your-org --output text
```

### Repository Config

Store team settings in `.smoothdev.json` (committed to repo):

```json
{
  "owner": "your-org",
  "repo": "your-repo",
  "defaults": {
    "output": "text",
    "verbose": false
  }
}
```

**Initialize repository config:**

```bash
smooth config init --scope repo --owner your-org --repo your-repo
```

**Security Note**: Repository config cannot contain credentials (`github_token`) to prevent accidental commits.

### Configuration Commands

```bash
# View all configurations
smooth config show

# View specific scope
smooth config show --scope user
smooth config show --scope repo

# Get specific value
smooth config get defaults.owner
smooth config get defaults.owner --scope repo

# Set value
smooth config set defaults.verbose true
smooth config set defaults.output json --scope repo

# Show config file path
smooth config path
smooth config path --scope repo
```

### Environment Variables

- `GITHUB_TOKEN` - GitHub authentication token
- `GH_TOKEN` - Alternative GitHub token variable

## Command Reference

### PR Commands

```bash
# Generate PR title and summary (auto-detects owner/repo from git)
smooth pr generate --pr-number <number>

# On branch "pr-123" - auto-detects everything!
smooth pr generate

# Generate only title
smooth pr generate --pr-number <number> --title

# Generate only summary
smooth pr generate --pr-number <number> --summary

# Push to GitHub
smooth pr generate --pr-number <number> --push

# JSON output
smooth pr generate --pr-number <number> --output json

# Verbose mode (shows where values come from)
smooth pr generate --pr-number <number> --verbose

# Explicit flags still work
smooth pr generate --owner <owner> --repo <repo> --pr-number <number>
```

### Commit Commands

```bash
# Generate commit message from staged changes
smooth commit generate

# Specify custom template
smooth commit generate --template <path>
```

### Release Commands

```bash
# Generate release notes (auto-detects latest two tags)
smooth release generate

# Specify tags explicitly
smooth release generate --from-tag <tag> --to-tag <tag>

# JSON output
smooth release generate --output json

# Verbose mode
smooth release generate --verbose
```

### Config Commands

```bash
# Show all configurations
smooth config show

# Show specific scope
smooth config show --scope user
smooth config show --scope repo

# Get value
smooth config get <key>
smooth config get <key> --scope repo

# Set value
smooth config set <key> <value>
smooth config set <key> <value> --scope repo

# Initialize config
smooth config init --owner <org> --output json
smooth config init --scope repo --owner <org> --repo <repo>

# Show config path
smooth config path
smooth config path --scope repo
```

### Auth Commands

```bash
# Login with Auth0
smooth auth login

# Logout
smooth auth logout
```

## Coming Soon

We're actively developing additional features:

- **API Key Authentication**: Non-interactive authentication for CI/CD pipelines
- **Repository Documentation Generation**: AI-powered README and documentation generation

Stay tuned for updates!

## Development

### Prerequisites

- Python 3.12+
- Poetry 1.7+
- Git
- GitHub CLI (optional, for auth)

### Setup

```bash
# Clone repository
git clone https://github.com/smoothdev-io/sd-smooth-cli.git
cd sd-smooth-cli/src/cli

# Install dependencies
poetry install

# Run tests
poetry run pytest

# Run with coverage
poetry run pytest --cov=smooth --cov-report=html

# Linting
poetry run ruff check .
poetry run ruff format .

# Type checking
poetry run mypy .
```

### Project Structure

```
sd-smooth-cli/
├── src/cli/              # CLI source code
│   ├── cli/              # Core CLI framework
│   │   ├── git_context.py       # Git detection & parsing
│   │   ├── config_manager.py    # Configuration management
│   │   └── context_resolver.py  # Four-tier precedence
│   ├── smooth/           # Command implementations
│   │   ├── commands/     # Command modules
│   │   │   ├── pr.py            # PR generation
│   │   │   ├── release.py       # Release notes
│   │   │   ├── config.py        # Config management
│   │   │   └── ...
│   │   ├── auth/         # Authentication
│   │   └── utils/        # Utilities
│   └── tests/            # Test suite (161 tests)
│       ├── test_git_context.py
│       ├── test_config_manager.py
│       ├── test_context_resolver.py
│       ├── test_pr_auto_detection.py
│       └── test_smart_tag_detection.py
├── docs/                 # Documentation
│   ├── system/           # Feature documentation
│   ├── architecture/     # Architecture docs
│   ├── decisions/        # ADRs
│   ├── api-changes/      # API change log
│   ├── development/      # Development notes
│   └── guides/           # User guides
├── service.json          # Repository metadata
└── README.md             # This file
```

### Testing

```bash
# Run all tests
poetry run pytest

# Run specific test file
poetry run pytest tests/test_pr_generate_output.py

# Run with verbose output
poetry run pytest -v

# Run with coverage
poetry run pytest --cov=smooth --cov-report=html
open htmlcov/index.html
```

### Code Quality

```bash
# Linting
poetry run ruff check .

# Auto-fix
poetry run ruff check . --fix

# Formatting
poetry run ruff format .

# Type checking
poetry run mypy .

# Security scanning
poetry run bandit -r smooth/
```

## License

Proprietary - © 2025 SmoothDev

## Acknowledgments

- Built with [Typer](https://typer.tiangolo.com/) for CLI framework
- Powered by [AWS Bedrock](https://aws.amazon.com/bedrock/) for AI generation
- Integrated with [GitHub API](https://docs.github.com/en/rest) for PR data
- Authenticated via [Auth0](https://auth0.com/) device flow
