############################################################################
# tools/pynuttx/nxgdbmcp/src/gmcp/tools/utils.py
#
# SPDX-License-Identifier: Apache-2.0
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.  The
# ASF licenses this file to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance with the
# License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
# License for the specific language governing permissions and limitations
# under the License.
#
############################################################################

from typing import Optional

from mcp.server.fastmcp import Context

from ..context import get_session


def register_util_tools(gdb_mcp):
    @gdb_mcp.tool()
    async def gdb_disassemble(
        ctx: Context, session_id: str, location: Optional[str] = None, count: int = 10
    ) -> str:
        """Disassemble code"""
        try:
            session = get_session(ctx, session_id)
            command = "disassemble"
            if location:
                command += f" {location}"
            output = await session.execute_command(command)
            return f"Disassembly{f' of {location}' if location else ''}:\n\n{output}"

        except ValueError as e:
            return str(e)
        except Exception as e:
            return f"Failed to disassemble: {str(e)}"

    @gdb_mcp.tool()
    async def gdb_help(
        ctx: Context, session_id: str, command: Optional[str] = None
    ) -> str:
        """Get help for GDB commands"""
        try:
            session = get_session(ctx, session_id)
            if command:
                output = await session.execute_command(f"help {command}")
                return f"Help for '{command}':\n\n{output}"
            else:
                output = await session.execute_command("help")
                return f"GDB help overview:\n\n{output}"

        except ValueError as e:
            return str(e)
        except Exception as e:
            return f"Failed to get help: {str(e)}"
