# What is Nexios?

Nexios is a high-performance Python web framework designed for speed, flexibility, and simplicity. It combines the elegance of Python with the power of a native Rust engine to deliver exceptional performance for modern web applications.

## Key Features

- **Pythonic**: Clean, intuitive API that's easy to learn and use
- **ASGI Compatible**: Fully compatible with ASGI for async support
- **RESTful API Ready**: Built-in support for creating RESTful APIs
- **Extensible**: Easy to extend with custom components and middleware
- **Production Ready**: Battle-tested and ready for production deployments

## Why Choose Nexios?

- **Performance**: Outperforms traditional Python web frameworks thanks to its Rust-based core
- **Simplicity**: Get started quickly with minimal boilerplate code
- **Flexibility**: Works with any ORM and integrates with your existing Python ecosystem
- **Modern**: Built with modern Python features and best practices
- **Scalable**: Designed to handle high traffic and scale with your needs

## Getting Started

Ready to start building with Nexios? Check out our [Quick Start](quick-start.md) guide to create your first Nexios application in minutes.

## Learn More

- [Nexios and ASGI](nexios-and-asgi.md) - Learn how Nexios leverages ASGI
- [Nexios and Async Python](nexios-and-async-python.md) - Master asynchronous programming with Nexios
- [Nexios and FastAPI](nexios-and-fastapi.md) - See how Nexios compares to FastAPI

Join our growing community of developers building fast, scalable web applications with Nexios!