# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AccountNetworkPolicyArgs', 'AccountNetworkPolicy']

@pulumi.input_type
class AccountNetworkPolicyArgs:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 egress: Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']] = None,
                 network_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a AccountNetworkPolicy resource.
        :param pulumi.Input[_builtins.str] account_id: The associated account ID for this Network Policy object
        :param pulumi.Input['AccountNetworkPolicyEgressArgs'] egress: The network policies applying for egress traffic
        :param pulumi.Input[_builtins.str] network_policy_id: The unique identifier for the network policy
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_policy_id is not None:
            pulumi.set(__self__, "network_policy_id", network_policy_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated account ID for this Network Policy object
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']]:
        """
        The network policies applying for egress traffic
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']]):
        pulumi.set(self, "egress", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the network policy
        """
        return pulumi.get(self, "network_policy_id")

    @network_policy_id.setter
    def network_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy_id", value)


@pulumi.input_type
class _AccountNetworkPolicyState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 egress: Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']] = None,
                 network_policy_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AccountNetworkPolicy resources.
        :param pulumi.Input[_builtins.str] account_id: The associated account ID for this Network Policy object
        :param pulumi.Input['AccountNetworkPolicyEgressArgs'] egress: The network policies applying for egress traffic
        :param pulumi.Input[_builtins.str] network_policy_id: The unique identifier for the network policy
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if egress is not None:
            pulumi.set(__self__, "egress", egress)
        if network_policy_id is not None:
            pulumi.set(__self__, "network_policy_id", network_policy_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The associated account ID for this Network Policy object
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def egress(self) -> Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']]:
        """
        The network policies applying for egress traffic
        """
        return pulumi.get(self, "egress")

    @egress.setter
    def egress(self, value: Optional[pulumi.Input['AccountNetworkPolicyEgressArgs']]):
        pulumi.set(self, "egress", value)

    @_builtins.property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique identifier for the network policy
        """
        return pulumi.get(self, "network_policy_id")

    @network_policy_id.setter
    def network_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_policy_id", value)


@pulumi.type_token("databricks:index/accountNetworkPolicy:AccountNetworkPolicy")
class AccountNetworkPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 egress: Optional[pulumi.Input[Union['AccountNetworkPolicyEgressArgs', 'AccountNetworkPolicyEgressArgsDict']]] = None,
                 network_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Network policies control which network destinations can be accessed from the Databricks environment.

        Each Databricks account includes a default policy named `default-policy`. This policy is:

        - Associated with any workspace lacking an explicit network policy assignment
        - Automatically associated with each newly created workspace
        - Reserved and cannot be deleted, but can be updated to customize the default network access rules for your account

        The `default-policy` provides a baseline security configuration that ensures all workspaces have network access controls in place.

        > **Note** This resource can only be used with an account-level provider!

        ## Example Usage

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "network_policy_id"

          to = databricks_account_network_policy.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/accountNetworkPolicy:AccountNetworkPolicy databricks_account_network_policy "network_policy_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The associated account ID for this Network Policy object
        :param pulumi.Input[Union['AccountNetworkPolicyEgressArgs', 'AccountNetworkPolicyEgressArgsDict']] egress: The network policies applying for egress traffic
        :param pulumi.Input[_builtins.str] network_policy_id: The unique identifier for the network policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AccountNetworkPolicyArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Network policies control which network destinations can be accessed from the Databricks environment.

        Each Databricks account includes a default policy named `default-policy`. This policy is:

        - Associated with any workspace lacking an explicit network policy assignment
        - Automatically associated with each newly created workspace
        - Reserved and cannot be deleted, but can be updated to customize the default network access rules for your account

        The `default-policy` provides a baseline security configuration that ensures all workspaces have network access controls in place.

        > **Note** This resource can only be used with an account-level provider!

        ## Example Usage

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "network_policy_id"

          to = databricks_account_network_policy.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/accountNetworkPolicy:AccountNetworkPolicy databricks_account_network_policy "network_policy_id"
        ```

        :param str resource_name: The name of the resource.
        :param AccountNetworkPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AccountNetworkPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 egress: Optional[pulumi.Input[Union['AccountNetworkPolicyEgressArgs', 'AccountNetworkPolicyEgressArgsDict']]] = None,
                 network_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AccountNetworkPolicyArgs.__new__(AccountNetworkPolicyArgs)

            __props__.__dict__["account_id"] = account_id
            __props__.__dict__["egress"] = egress
            __props__.__dict__["network_policy_id"] = network_policy_id
        super(AccountNetworkPolicy, __self__).__init__(
            'databricks:index/accountNetworkPolicy:AccountNetworkPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            egress: Optional[pulumi.Input[Union['AccountNetworkPolicyEgressArgs', 'AccountNetworkPolicyEgressArgsDict']]] = None,
            network_policy_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AccountNetworkPolicy':
        """
        Get an existing AccountNetworkPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: The associated account ID for this Network Policy object
        :param pulumi.Input[Union['AccountNetworkPolicyEgressArgs', 'AccountNetworkPolicyEgressArgsDict']] egress: The network policies applying for egress traffic
        :param pulumi.Input[_builtins.str] network_policy_id: The unique identifier for the network policy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AccountNetworkPolicyState.__new__(_AccountNetworkPolicyState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["egress"] = egress
        __props__.__dict__["network_policy_id"] = network_policy_id
        return AccountNetworkPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The associated account ID for this Network Policy object
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def egress(self) -> pulumi.Output[Optional['outputs.AccountNetworkPolicyEgress']]:
        """
        The network policies applying for egress traffic
        """
        return pulumi.get(self, "egress")

    @_builtins.property
    @pulumi.getter(name="networkPolicyId")
    def network_policy_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The unique identifier for the network policy
        """
        return pulumi.get(self, "network_policy_id")

