# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CleanRoomsCleanRoomArgs', 'CleanRoomsCleanRoom']

@pulumi.input_type
class CleanRoomsCleanRoomArgs:
    def __init__(__self__, *,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_detailed_info: Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CleanRoomsCleanRoom resource.
        :param pulumi.Input[_builtins.str] name: The name of the clean room.
               It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        :param pulumi.Input[_builtins.str] owner: This is the Databricks username of the owner of the local clean room securable for permission management
        :param pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs'] remote_detailed_info: Central clean room details. During creation, users need to specify
               cloud_vendor, region, and collaborators.global_metastore_id.
               This field will not be filled in the ListCleanRooms call
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if remote_detailed_info is not None:
            pulumi.set(__self__, "remote_detailed_info", remote_detailed_info)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room.
        It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the Databricks username of the owner of the local clean room securable for permission management
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="remoteDetailedInfo")
    def remote_detailed_info(self) -> Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']]:
        """
        Central clean room details. During creation, users need to specify
        cloud_vendor, region, and collaborators.global_metastore_id.
        This field will not be filled in the ListCleanRooms call
        """
        return pulumi.get(self, "remote_detailed_info")

    @remote_detailed_info.setter
    def remote_detailed_info(self, value: Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']]):
        pulumi.set(self, "remote_detailed_info", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _CleanRoomsCleanRoomState:
    def __init__(__self__, *,
                 access_restricted: Optional[pulumi.Input[_builtins.str]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 local_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 output_catalog: Optional[pulumi.Input['CleanRoomsCleanRoomOutputCatalogArgs']] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_detailed_info: Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CleanRoomsCleanRoom resources.
        :param pulumi.Input[_builtins.str] access_restricted: (string) - Whether clean room access is restricted due to [CSP](https://docs.databricks.com/en/security/privacy/security-profile.html). Possible values are: `CSP_MISMATCH`, `NO_RESTRICTION`
        :param pulumi.Input[_builtins.int] created_at: (integer) - When the clean room was created, in epoch milliseconds
        :param pulumi.Input[_builtins.str] local_collaborator_alias: (string) - The alias of the collaborator tied to the local clean room
        :param pulumi.Input[_builtins.str] name: The name of the clean room.
               It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        :param pulumi.Input['CleanRoomsCleanRoomOutputCatalogArgs'] output_catalog: (CleanRoomOutputCatalog) - Output catalog of the clean room. It is an output only field. Output catalog is manipulated
               using the separate CreateCleanRoomOutputCatalog API
        :param pulumi.Input[_builtins.str] owner: This is the Databricks username of the owner of the local clean room securable for permission management
        :param pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs'] remote_detailed_info: Central clean room details. During creation, users need to specify
               cloud_vendor, region, and collaborators.global_metastore_id.
               This field will not be filled in the ListCleanRooms call
        :param pulumi.Input[_builtins.str] status: (string) - . Possible values are: `CREATED`, `NOT_CREATED`, `NOT_ELIGIBLE`
        :param pulumi.Input[_builtins.int] updated_at: (integer) - When the clean room was last updated, in epoch milliseconds
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if access_restricted is not None:
            pulumi.set(__self__, "access_restricted", access_restricted)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if local_collaborator_alias is not None:
            pulumi.set(__self__, "local_collaborator_alias", local_collaborator_alias)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if output_catalog is not None:
            pulumi.set(__self__, "output_catalog", output_catalog)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if remote_detailed_info is not None:
            pulumi.set(__self__, "remote_detailed_info", remote_detailed_info)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="accessRestricted")
    def access_restricted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Whether clean room access is restricted due to [CSP](https://docs.databricks.com/en/security/privacy/security-profile.html). Possible values are: `CSP_MISMATCH`, `NO_RESTRICTION`
        """
        return pulumi.get(self, "access_restricted")

    @access_restricted.setter
    def access_restricted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_restricted", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - When the clean room was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="localCollaboratorAlias")
    def local_collaborator_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The alias of the collaborator tied to the local clean room
        """
        return pulumi.get(self, "local_collaborator_alias")

    @local_collaborator_alias.setter
    def local_collaborator_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "local_collaborator_alias", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the clean room.
        It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outputCatalog")
    def output_catalog(self) -> Optional[pulumi.Input['CleanRoomsCleanRoomOutputCatalogArgs']]:
        """
        (CleanRoomOutputCatalog) - Output catalog of the clean room. It is an output only field. Output catalog is manipulated
        using the separate CreateCleanRoomOutputCatalog API
        """
        return pulumi.get(self, "output_catalog")

    @output_catalog.setter
    def output_catalog(self, value: Optional[pulumi.Input['CleanRoomsCleanRoomOutputCatalogArgs']]):
        pulumi.set(self, "output_catalog", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This is the Databricks username of the owner of the local clean room securable for permission management
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="remoteDetailedInfo")
    def remote_detailed_info(self) -> Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']]:
        """
        Central clean room details. During creation, users need to specify
        cloud_vendor, region, and collaborators.global_metastore_id.
        This field will not be filled in the ListCleanRooms call
        """
        return pulumi.get(self, "remote_detailed_info")

    @remote_detailed_info.setter
    def remote_detailed_info(self, value: Optional[pulumi.Input['CleanRoomsCleanRoomRemoteDetailedInfoArgs']]):
        pulumi.set(self, "remote_detailed_info", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - . Possible values are: `CREATED`, `NOT_CREATED`, `NOT_ELIGIBLE`
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        (integer) - When the clean room was last updated, in epoch milliseconds
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/cleanRoomsCleanRoom:CleanRoomsCleanRoom")
class CleanRoomsCleanRoom(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_detailed_info: Optional[pulumi.Input[Union['CleanRoomsCleanRoomRemoteDetailedInfoArgs', 'CleanRoomsCleanRoomRemoteDetailedInfoArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A Clean Room is a secure environment for data collaboration that enables multiple organizations to analyze their data together while maintaining privacy and security. Clean Rooms provide a controlled environment where data can be shared and analyzed without exposing the underlying raw data.

        ## Example Usage

        # Example: Clean Room Resource

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_clean_rooms_clean_room.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomsCleanRoom:CleanRoomsCleanRoom databricks_clean_rooms_clean_room "name"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the clean room.
               It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        :param pulumi.Input[_builtins.str] owner: This is the Databricks username of the owner of the local clean room securable for permission management
        :param pulumi.Input[Union['CleanRoomsCleanRoomRemoteDetailedInfoArgs', 'CleanRoomsCleanRoomRemoteDetailedInfoArgsDict']] remote_detailed_info: Central clean room details. During creation, users need to specify
               cloud_vendor, region, and collaborators.global_metastore_id.
               This field will not be filled in the ListCleanRooms call
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CleanRoomsCleanRoomArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A Clean Room is a secure environment for data collaboration that enables multiple organizations to analyze their data together while maintaining privacy and security. Clean Rooms provide a controlled environment where data can be shared and analyzed without exposing the underlying raw data.

        ## Example Usage

        # Example: Clean Room Resource

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_clean_rooms_clean_room.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/cleanRoomsCleanRoom:CleanRoomsCleanRoom databricks_clean_rooms_clean_room "name"
        ```

        :param str resource_name: The name of the resource.
        :param CleanRoomsCleanRoomArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CleanRoomsCleanRoomArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 remote_detailed_info: Optional[pulumi.Input[Union['CleanRoomsCleanRoomRemoteDetailedInfoArgs', 'CleanRoomsCleanRoomRemoteDetailedInfoArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CleanRoomsCleanRoomArgs.__new__(CleanRoomsCleanRoomArgs)

            __props__.__dict__["comment"] = comment
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["remote_detailed_info"] = remote_detailed_info
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["access_restricted"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["local_collaborator_alias"] = None
            __props__.__dict__["output_catalog"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(CleanRoomsCleanRoom, __self__).__init__(
            'databricks:index/cleanRoomsCleanRoom:CleanRoomsCleanRoom',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_restricted: Optional[pulumi.Input[_builtins.str]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            local_collaborator_alias: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            output_catalog: Optional[pulumi.Input[Union['CleanRoomsCleanRoomOutputCatalogArgs', 'CleanRoomsCleanRoomOutputCatalogArgsDict']]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            remote_detailed_info: Optional[pulumi.Input[Union['CleanRoomsCleanRoomRemoteDetailedInfoArgs', 'CleanRoomsCleanRoomRemoteDetailedInfoArgsDict']]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'CleanRoomsCleanRoom':
        """
        Get an existing CleanRoomsCleanRoom resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_restricted: (string) - Whether clean room access is restricted due to [CSP](https://docs.databricks.com/en/security/privacy/security-profile.html). Possible values are: `CSP_MISMATCH`, `NO_RESTRICTION`
        :param pulumi.Input[_builtins.int] created_at: (integer) - When the clean room was created, in epoch milliseconds
        :param pulumi.Input[_builtins.str] local_collaborator_alias: (string) - The alias of the collaborator tied to the local clean room
        :param pulumi.Input[_builtins.str] name: The name of the clean room.
               It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        :param pulumi.Input[Union['CleanRoomsCleanRoomOutputCatalogArgs', 'CleanRoomsCleanRoomOutputCatalogArgsDict']] output_catalog: (CleanRoomOutputCatalog) - Output catalog of the clean room. It is an output only field. Output catalog is manipulated
               using the separate CreateCleanRoomOutputCatalog API
        :param pulumi.Input[_builtins.str] owner: This is the Databricks username of the owner of the local clean room securable for permission management
        :param pulumi.Input[Union['CleanRoomsCleanRoomRemoteDetailedInfoArgs', 'CleanRoomsCleanRoomRemoteDetailedInfoArgsDict']] remote_detailed_info: Central clean room details. During creation, users need to specify
               cloud_vendor, region, and collaborators.global_metastore_id.
               This field will not be filled in the ListCleanRooms call
        :param pulumi.Input[_builtins.str] status: (string) - . Possible values are: `CREATED`, `NOT_CREATED`, `NOT_ELIGIBLE`
        :param pulumi.Input[_builtins.int] updated_at: (integer) - When the clean room was last updated, in epoch milliseconds
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CleanRoomsCleanRoomState.__new__(_CleanRoomsCleanRoomState)

        __props__.__dict__["access_restricted"] = access_restricted
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["local_collaborator_alias"] = local_collaborator_alias
        __props__.__dict__["name"] = name
        __props__.__dict__["output_catalog"] = output_catalog
        __props__.__dict__["owner"] = owner
        __props__.__dict__["remote_detailed_info"] = remote_detailed_info
        __props__.__dict__["status"] = status
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["workspace_id"] = workspace_id
        return CleanRoomsCleanRoom(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessRestricted")
    def access_restricted(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Whether clean room access is restricted due to [CSP](https://docs.databricks.com/en/security/privacy/security-profile.html). Possible values are: `CSP_MISMATCH`, `NO_RESTRICTION`
        """
        return pulumi.get(self, "access_restricted")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - When the clean room was created, in epoch milliseconds
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="localCollaboratorAlias")
    def local_collaborator_alias(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The alias of the collaborator tied to the local clean room
        """
        return pulumi.get(self, "local_collaborator_alias")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the clean room.
        It should follow [UC securable naming requirements](https://docs.databricks.com/en/data-governance/unity-catalog/index.html#securable-object-naming-requirements)
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outputCatalog")
    def output_catalog(self) -> pulumi.Output['outputs.CleanRoomsCleanRoomOutputCatalog']:
        """
        (CleanRoomOutputCatalog) - Output catalog of the clean room. It is an output only field. Output catalog is manipulated
        using the separate CreateCleanRoomOutputCatalog API
        """
        return pulumi.get(self, "output_catalog")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        This is the Databricks username of the owner of the local clean room securable for permission management
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="remoteDetailedInfo")
    def remote_detailed_info(self) -> pulumi.Output[Optional['outputs.CleanRoomsCleanRoomRemoteDetailedInfo']]:
        """
        Central clean room details. During creation, users need to specify
        cloud_vendor, region, and collaborators.global_metastore_id.
        This field will not be filled in the ListCleanRooms call
        """
        return pulumi.get(self, "remote_detailed_info")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - . Possible values are: `CREATED`, `NOT_CREATED`, `NOT_ELIGIBLE`
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        """
        (integer) - When the clean room was last updated, in epoch milliseconds
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

