# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CredentialArgs', 'Credential']

@pulumi.input_type
class CredentialArgs:
    def __init__(__self__, *,
                 purpose: pulumi.Input[_builtins.str],
                 aws_iam_role: Optional[pulumi.Input['CredentialAwsIamRoleArgs']] = None,
                 azure_managed_identity: Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']] = None,
                 azure_service_principal: Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_gcp_service_account: Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 used_for_managed_storage: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Credential resource.
        :param pulumi.Input[_builtins.str] purpose: Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        :param pulumi.Input[_builtins.bool] force_destroy: Delete credential regardless of its dependencies.
        :param pulumi.Input[_builtins.bool] force_update: Update credential regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.
               
               `aws_iam_role` optional configuration block for credential details for AWS:
        :param pulumi.Input[_builtins.str] name: Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the credential owner.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the credential.
        """
        pulumi.set(__self__, "purpose", purpose)
        if aws_iam_role is not None:
            pulumi.set(__self__, "aws_iam_role", aws_iam_role)
        if azure_managed_identity is not None:
            pulumi.set(__self__, "azure_managed_identity", azure_managed_identity)
        if azure_service_principal is not None:
            pulumi.set(__self__, "azure_service_principal", azure_service_principal)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if databricks_gcp_service_account is not None:
            pulumi.set(__self__, "databricks_gcp_service_account", databricks_gcp_service_account)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if used_for_managed_storage is not None:
            pulumi.set(__self__, "used_for_managed_storage", used_for_managed_storage)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Input[_builtins.str]:
        """
        Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter(name="awsIamRole")
    def aws_iam_role(self) -> Optional[pulumi.Input['CredentialAwsIamRoleArgs']]:
        return pulumi.get(self, "aws_iam_role")

    @aws_iam_role.setter
    def aws_iam_role(self, value: Optional[pulumi.Input['CredentialAwsIamRoleArgs']]):
        pulumi.set(self, "aws_iam_role", value)

    @_builtins.property
    @pulumi.getter(name="azureManagedIdentity")
    def azure_managed_identity(self) -> Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']]:
        return pulumi.get(self, "azure_managed_identity")

    @azure_managed_identity.setter
    def azure_managed_identity(self, value: Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']]):
        pulumi.set(self, "azure_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="azureServicePrincipal")
    def azure_service_principal(self) -> Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']]:
        return pulumi.get(self, "azure_service_principal")

    @azure_service_principal.setter
    def azure_service_principal(self, value: Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']]):
        pulumi.set(self, "azure_service_principal", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="databricksGcpServiceAccount")
    def databricks_gcp_service_account(self) -> Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']]:
        return pulumi.get(self, "databricks_gcp_service_account")

    @databricks_gcp_service_account.setter
    def databricks_gcp_service_account(self, value: Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']]):
        pulumi.set(self, "databricks_gcp_service_account", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete credential regardless of its dependencies.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Update credential regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_name", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.

        `aws_iam_role` optional configuration block for credential details for AWS:
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the credential owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the credential.
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter(name="usedForManagedStorage")
    def used_for_managed_storage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "used_for_managed_storage")

    @used_for_managed_storage.setter
    def used_for_managed_storage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_for_managed_storage", value)


@pulumi.input_type
class _CredentialState:
    def __init__(__self__, *,
                 aws_iam_role: Optional[pulumi.Input['CredentialAwsIamRoleArgs']] = None,
                 azure_managed_identity: Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']] = None,
                 azure_service_principal: Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_gcp_service_account: Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 used_for_managed_storage: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Credential resources.
        :param pulumi.Input[_builtins.str] credential_id: Unique ID of the credential.
        :param pulumi.Input[_builtins.bool] force_destroy: Delete credential regardless of its dependencies.
        :param pulumi.Input[_builtins.bool] force_update: Update credential regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.
               
               `aws_iam_role` optional configuration block for credential details for AWS:
        :param pulumi.Input[_builtins.str] name: Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the credential owner.
        :param pulumi.Input[_builtins.str] purpose: Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the credential.
        """
        if aws_iam_role is not None:
            pulumi.set(__self__, "aws_iam_role", aws_iam_role)
        if azure_managed_identity is not None:
            pulumi.set(__self__, "azure_managed_identity", azure_managed_identity)
        if azure_service_principal is not None:
            pulumi.set(__self__, "azure_service_principal", azure_service_principal)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if credential_id is not None:
            pulumi.set(__self__, "credential_id", credential_id)
        if databricks_gcp_service_account is not None:
            pulumi.set(__self__, "databricks_gcp_service_account", databricks_gcp_service_account)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if isolation_mode is not None:
            pulumi.set(__self__, "isolation_mode", isolation_mode)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if purpose is not None:
            pulumi.set(__self__, "purpose", purpose)
        if read_only is not None:
            pulumi.set(__self__, "read_only", read_only)
        if skip_validation is not None:
            pulumi.set(__self__, "skip_validation", skip_validation)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if used_for_managed_storage is not None:
            pulumi.set(__self__, "used_for_managed_storage", used_for_managed_storage)

    @_builtins.property
    @pulumi.getter(name="awsIamRole")
    def aws_iam_role(self) -> Optional[pulumi.Input['CredentialAwsIamRoleArgs']]:
        return pulumi.get(self, "aws_iam_role")

    @aws_iam_role.setter
    def aws_iam_role(self, value: Optional[pulumi.Input['CredentialAwsIamRoleArgs']]):
        pulumi.set(self, "aws_iam_role", value)

    @_builtins.property
    @pulumi.getter(name="azureManagedIdentity")
    def azure_managed_identity(self) -> Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']]:
        return pulumi.get(self, "azure_managed_identity")

    @azure_managed_identity.setter
    def azure_managed_identity(self, value: Optional[pulumi.Input['CredentialAzureManagedIdentityArgs']]):
        pulumi.set(self, "azure_managed_identity", value)

    @_builtins.property
    @pulumi.getter(name="azureServicePrincipal")
    def azure_service_principal(self) -> Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']]:
        return pulumi.get(self, "azure_service_principal")

    @azure_service_principal.setter
    def azure_service_principal(self, value: Optional[pulumi.Input['CredentialAzureServicePrincipalArgs']]):
        pulumi.set(self, "azure_service_principal", value)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "comment", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Unique ID of the credential.
        """
        return pulumi.get(self, "credential_id")

    @credential_id.setter
    def credential_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_id", value)

    @_builtins.property
    @pulumi.getter(name="databricksGcpServiceAccount")
    def databricks_gcp_service_account(self) -> Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']]:
        return pulumi.get(self, "databricks_gcp_service_account")

    @databricks_gcp_service_account.setter
    def databricks_gcp_service_account(self, value: Optional[pulumi.Input['CredentialDatabricksGcpServiceAccountArgs']]):
        pulumi.set(self, "databricks_gcp_service_account", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Delete credential regardless of its dependencies.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Update credential regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "full_name", value)

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.

        `aws_iam_role` optional configuration block for credential details for AWS:
        """
        return pulumi.get(self, "isolation_mode")

    @isolation_mode.setter
    def isolation_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "isolation_mode", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Username/groupname/sp application_id of the credential owner.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        """
        return pulumi.get(self, "purpose")

    @purpose.setter
    def purpose(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "purpose", value)

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        """
        return pulumi.get(self, "read_only")

    @read_only.setter
    def read_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "read_only", value)

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the credential.
        """
        return pulumi.get(self, "skip_validation")

    @skip_validation.setter
    def skip_validation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "skip_validation", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter(name="usedForManagedStorage")
    def used_for_managed_storage(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "used_for_managed_storage")

    @used_for_managed_storage.setter
    def used_for_managed_storage(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "used_for_managed_storage", value)


@pulumi.type_token("databricks:index/credential:Credential")
class Credential(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_iam_role: Optional[pulumi.Input[Union['CredentialAwsIamRoleArgs', 'CredentialAwsIamRoleArgsDict']]] = None,
                 azure_managed_identity: Optional[pulumi.Input[Union['CredentialAzureManagedIdentityArgs', 'CredentialAzureManagedIdentityArgsDict']]] = None,
                 azure_service_principal: Optional[pulumi.Input[Union['CredentialAzureServicePrincipalArgs', 'CredentialAzureServicePrincipalArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_gcp_service_account: Optional[pulumi.Input[Union['CredentialDatabricksGcpServiceAccountArgs', 'CredentialDatabricksGcpServiceAccountArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 used_for_managed_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        A credential represents an authentication and authorization mechanism for accessing services on your cloud tenant. Each credential is subject to Unity Catalog access-control policies that control which users and groups can access the credential.

        > This resource can only be used with a workspace-level provider!

        The type of credential to be created is determined by the `purpose` field, which should be either `SERVICE` or `STORAGE`.
        The caller must be a metastore admin or have the metastore privilege `CREATE_STORAGE_CREDENTIAL` for storage credentials, or `CREATE_SERVICE_CREDENTIAL` for service credentials. The user who creates the credential can delegate ownership to another user or group to manage permissions on it

        On AWS, the IAM role for a credential requires a trust policy. See [documentation](https://docs.databricks.com/en/connect/unity-catalog/cloud-services/service-credentials.html#step-1-create-an-iam-role) for more details. The data source get_aws_unity_catalog_assume_role_policy can be used to create the necessary AWS Unity Catalog assume role policy.

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.Credential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            purpose="SERVICE",
            comment="Managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        For Azure

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external_mi = databricks.Credential("external_mi",
            name="mi_credential",
            azure_managed_identity={
                "access_connector_id": example["id"],
            },
            purpose="SERVICE",
            comment="Managed identity credential managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external_mi.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        For GCP

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external_gcp_sa = databricks.Credential("external_gcp_sa",
            name="gcp_sa_credential",
            databricks_gcp_service_account={},
            purpose="SERVICE",
            comment="GCP SA credential managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external_gcp_sa.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_credential.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/credential:Credential this <name>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] force_destroy: Delete credential regardless of its dependencies.
        :param pulumi.Input[_builtins.bool] force_update: Update credential regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.
               
               `aws_iam_role` optional configuration block for credential details for AWS:
        :param pulumi.Input[_builtins.str] name: Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the credential owner.
        :param pulumi.Input[_builtins.str] purpose: Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the credential.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CredentialArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A credential represents an authentication and authorization mechanism for accessing services on your cloud tenant. Each credential is subject to Unity Catalog access-control policies that control which users and groups can access the credential.

        > This resource can only be used with a workspace-level provider!

        The type of credential to be created is determined by the `purpose` field, which should be either `SERVICE` or `STORAGE`.
        The caller must be a metastore admin or have the metastore privilege `CREATE_STORAGE_CREDENTIAL` for storage credentials, or `CREATE_SERVICE_CREDENTIAL` for service credentials. The user who creates the credential can delegate ownership to another user or group to manage permissions on it

        On AWS, the IAM role for a credential requires a trust policy. See [documentation](https://docs.databricks.com/en/connect/unity-catalog/cloud-services/service-credentials.html#step-1-create-an-iam-role) for more details. The data source get_aws_unity_catalog_assume_role_policy can be used to create the necessary AWS Unity Catalog assume role policy.

        ## Example Usage

        For AWS

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external = databricks.Credential("external",
            name=external_data_access["name"],
            aws_iam_role={
                "role_arn": external_data_access["arn"],
            },
            purpose="SERVICE",
            comment="Managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        For Azure

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external_mi = databricks.Credential("external_mi",
            name="mi_credential",
            azure_managed_identity={
                "access_connector_id": example["id"],
            },
            purpose="SERVICE",
            comment="Managed identity credential managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external_mi.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        For GCP

        ```python
        import pulumi
        import pulumi_databricks as databricks

        external_gcp_sa = databricks.Credential("external_gcp_sa",
            name="gcp_sa_credential",
            databricks_gcp_service_account={},
            purpose="SERVICE",
            comment="GCP SA credential managed by TF")
        external_creds = databricks.Grants("external_creds",
            credential=external_gcp_sa.id,
            grants=[{
                "principal": "Data Engineers",
                "privileges": ["ACCESS"],
            }])
        ```

        ## Import

        This resource can be imported by name:

        hcl

        import {

          to = databricks_credential.this

          id = "<name>"

        }

        Alternatively, when using `terraform` version 1.4 or earlier, import using the `pulumi import` command:

        bash

        ```sh
        $ pulumi import databricks:index/credential:Credential this <name>
        ```

        :param str resource_name: The name of the resource.
        :param CredentialArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CredentialArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws_iam_role: Optional[pulumi.Input[Union['CredentialAwsIamRoleArgs', 'CredentialAwsIamRoleArgsDict']]] = None,
                 azure_managed_identity: Optional[pulumi.Input[Union['CredentialAzureManagedIdentityArgs', 'CredentialAzureManagedIdentityArgsDict']]] = None,
                 azure_service_principal: Optional[pulumi.Input[Union['CredentialAzureServicePrincipalArgs', 'CredentialAzureServicePrincipalArgsDict']]] = None,
                 comment: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 databricks_gcp_service_account: Optional[pulumi.Input[Union['CredentialDatabricksGcpServiceAccountArgs', 'CredentialDatabricksGcpServiceAccountArgsDict']]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 full_name: Optional[pulumi.Input[_builtins.str]] = None,
                 isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 purpose: Optional[pulumi.Input[_builtins.str]] = None,
                 read_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.int]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 used_for_managed_storage: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CredentialArgs.__new__(CredentialArgs)

            __props__.__dict__["aws_iam_role"] = aws_iam_role
            __props__.__dict__["azure_managed_identity"] = azure_managed_identity
            __props__.__dict__["azure_service_principal"] = azure_service_principal
            __props__.__dict__["comment"] = comment
            __props__.__dict__["created_at"] = created_at
            __props__.__dict__["created_by"] = created_by
            __props__.__dict__["databricks_gcp_service_account"] = databricks_gcp_service_account
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["full_name"] = full_name
            __props__.__dict__["isolation_mode"] = isolation_mode
            __props__.__dict__["metastore_id"] = metastore_id
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            if purpose is None and not opts.urn:
                raise TypeError("Missing required property 'purpose'")
            __props__.__dict__["purpose"] = purpose
            __props__.__dict__["read_only"] = read_only
            __props__.__dict__["skip_validation"] = skip_validation
            __props__.__dict__["updated_at"] = updated_at
            __props__.__dict__["updated_by"] = updated_by
            __props__.__dict__["used_for_managed_storage"] = used_for_managed_storage
            __props__.__dict__["credential_id"] = None
        super(Credential, __self__).__init__(
            'databricks:index/credential:Credential',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws_iam_role: Optional[pulumi.Input[Union['CredentialAwsIamRoleArgs', 'CredentialAwsIamRoleArgsDict']]] = None,
            azure_managed_identity: Optional[pulumi.Input[Union['CredentialAzureManagedIdentityArgs', 'CredentialAzureManagedIdentityArgsDict']]] = None,
            azure_service_principal: Optional[pulumi.Input[Union['CredentialAzureServicePrincipalArgs', 'CredentialAzureServicePrincipalArgsDict']]] = None,
            comment: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            credential_id: Optional[pulumi.Input[_builtins.str]] = None,
            databricks_gcp_service_account: Optional[pulumi.Input[Union['CredentialDatabricksGcpServiceAccountArgs', 'CredentialDatabricksGcpServiceAccountArgsDict']]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            force_update: Optional[pulumi.Input[_builtins.bool]] = None,
            full_name: Optional[pulumi.Input[_builtins.str]] = None,
            isolation_mode: Optional[pulumi.Input[_builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            purpose: Optional[pulumi.Input[_builtins.str]] = None,
            read_only: Optional[pulumi.Input[_builtins.bool]] = None,
            skip_validation: Optional[pulumi.Input[_builtins.bool]] = None,
            updated_at: Optional[pulumi.Input[_builtins.int]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            used_for_managed_storage: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Credential':
        """
        Get an existing Credential resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] credential_id: Unique ID of the credential.
        :param pulumi.Input[_builtins.bool] force_destroy: Delete credential regardless of its dependencies.
        :param pulumi.Input[_builtins.bool] force_update: Update credential regardless of its dependents.
        :param pulumi.Input[_builtins.str] isolation_mode: Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.
               
               `aws_iam_role` optional configuration block for credential details for AWS:
        :param pulumi.Input[_builtins.str] name: Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        :param pulumi.Input[_builtins.str] owner: Username/groupname/sp application_id of the credential owner.
        :param pulumi.Input[_builtins.str] purpose: Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        :param pulumi.Input[_builtins.bool] read_only: Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        :param pulumi.Input[_builtins.bool] skip_validation: Suppress validation errors if any & force save the credential.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CredentialState.__new__(_CredentialState)

        __props__.__dict__["aws_iam_role"] = aws_iam_role
        __props__.__dict__["azure_managed_identity"] = azure_managed_identity
        __props__.__dict__["azure_service_principal"] = azure_service_principal
        __props__.__dict__["comment"] = comment
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["credential_id"] = credential_id
        __props__.__dict__["databricks_gcp_service_account"] = databricks_gcp_service_account
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["full_name"] = full_name
        __props__.__dict__["isolation_mode"] = isolation_mode
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["purpose"] = purpose
        __props__.__dict__["read_only"] = read_only
        __props__.__dict__["skip_validation"] = skip_validation
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["updated_by"] = updated_by
        __props__.__dict__["used_for_managed_storage"] = used_for_managed_storage
        return Credential(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="awsIamRole")
    def aws_iam_role(self) -> pulumi.Output[Optional['outputs.CredentialAwsIamRole']]:
        return pulumi.get(self, "aws_iam_role")

    @_builtins.property
    @pulumi.getter(name="azureManagedIdentity")
    def azure_managed_identity(self) -> pulumi.Output[Optional['outputs.CredentialAzureManagedIdentity']]:
        return pulumi.get(self, "azure_managed_identity")

    @_builtins.property
    @pulumi.getter(name="azureServicePrincipal")
    def azure_service_principal(self) -> pulumi.Output[Optional['outputs.CredentialAzureServicePrincipal']]:
        return pulumi.get(self, "azure_service_principal")

    @_builtins.property
    @pulumi.getter
    def comment(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter(name="credentialId")
    def credential_id(self) -> pulumi.Output[_builtins.str]:
        """
        Unique ID of the credential.
        """
        return pulumi.get(self, "credential_id")

    @_builtins.property
    @pulumi.getter(name="databricksGcpServiceAccount")
    def databricks_gcp_service_account(self) -> pulumi.Output['outputs.CredentialDatabricksGcpServiceAccount']:
        return pulumi.get(self, "databricks_gcp_service_account")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Delete credential regardless of its dependencies.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Update credential regardless of its dependents.
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="fullName")
    def full_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "full_name")

    @_builtins.property
    @pulumi.getter(name="isolationMode")
    def isolation_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Whether the credential is accessible from all workspaces or a specific set of workspaces. Can be `ISOLATION_MODE_ISOLATED` or `ISOLATION_MODE_OPEN`. Setting the credential to `ISOLATION_MODE_ISOLATED` will automatically restrict access to only from the current workspace.

        `aws_iam_role` optional configuration block for credential details for AWS:
        """
        return pulumi.get(self, "isolation_mode")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of Credentials, which must be unique within the databricks_metastore. Change forces creation of a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Username/groupname/sp application_id of the credential owner.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def purpose(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the purpose of the credential. Can be `SERVICE` or `STORAGE`.
        """
        return pulumi.get(self, "purpose")

    @_builtins.property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether the credential is only usable for read operations. Only applicable when purpose is `STORAGE`.
        """
        return pulumi.get(self, "read_only")

    @_builtins.property
    @pulumi.getter(name="skipValidation")
    def skip_validation(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Suppress validation errors if any & force save the credential.
        """
        return pulumi.get(self, "skip_validation")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter(name="usedForManagedStorage")
    def used_for_managed_storage(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "used_for_managed_storage")

