# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseSyncedDatabaseTableArgs', 'DatabaseSyncedDatabaseTable']

@pulumi.input_type
class DatabaseSyncedDatabaseTableArgs:
    def __init__(__self__, *,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DatabaseSyncedDatabaseTable resource.
        :param pulumi.Input[_builtins.str] database_instance_name: Name of the target database instance. This is required when creating synced database tables in standard catalogs.
               This is optional when creating synced database tables in registered catalogs. If this field is specified
               when creating synced database tables in registered catalogs, the database instance name MUST
               match that of the registered catalog (or the request will be rejected)
        :param pulumi.Input[_builtins.str] logical_database_name: Target Postgres database object (logical database) name for this table.
               
               When creating a synced table in a registered Postgres catalog, the
               target Postgres database name is inferred to be that of the registered catalog.
               If this field is specified in this scenario, the Postgres database name MUST
               match that of the registered catalog (or the request will be rejected).
               
               When creating a synced table in a standard catalog, this field is required.
               In this scenario, specifying this field will allow targeting an arbitrary postgres database.
               Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        :param pulumi.Input[_builtins.str] name: Full three-part (catalog, schema, table) name of the table
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if database_instance_name is not None:
            pulumi.set(__self__, "database_instance_name", database_instance_name)
        if logical_database_name is not None:
            pulumi.set(__self__, "logical_database_name", logical_database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the target database instance. This is required when creating synced database tables in standard catalogs.
        This is optional when creating synced database tables in registered catalogs. If this field is specified
        when creating synced database tables in registered catalogs, the database instance name MUST
        match that of the registered catalog (or the request will be rejected)
        """
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="logicalDatabaseName")
    def logical_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target Postgres database object (logical database) name for this table.

        When creating a synced table in a registered Postgres catalog, the
        target Postgres database name is inferred to be that of the registered catalog.
        If this field is specified in this scenario, the Postgres database name MUST
        match that of the registered catalog (or the request will be rejected).

        When creating a synced table in a standard catalog, this field is required.
        In this scenario, specifying this field will allow targeting an arbitrary postgres database.
        Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        """
        return pulumi.get(self, "logical_database_name")

    @logical_database_name.setter
    def logical_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logical_database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full three-part (catalog, schema, table) name of the table
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']]:
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _DatabaseSyncedDatabaseTableState:
    def __init__(__self__, *,
                 data_synchronization_status: Optional[pulumi.Input['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs']] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']] = None,
                 unity_catalog_provisioning_state: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DatabaseSyncedDatabaseTable resources.
        :param pulumi.Input['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs'] data_synchronization_status: (SyncedTableStatus) - Synced Table data synchronization status
        :param pulumi.Input[_builtins.str] database_instance_name: Name of the target database instance. This is required when creating synced database tables in standard catalogs.
               This is optional when creating synced database tables in registered catalogs. If this field is specified
               when creating synced database tables in registered catalogs, the database instance name MUST
               match that of the registered catalog (or the request will be rejected)
        :param pulumi.Input[_builtins.str] effective_database_instance_name: (string) - The name of the database instance that this table is registered to. This field is always returned, and for
               tables inside database catalogs is inferred database instance associated with the catalog
        :param pulumi.Input[_builtins.str] effective_logical_database_name: (string) - The name of the logical database that this table is registered to
        :param pulumi.Input[_builtins.str] logical_database_name: Target Postgres database object (logical database) name for this table.
               
               When creating a synced table in a registered Postgres catalog, the
               target Postgres database name is inferred to be that of the registered catalog.
               If this field is specified in this scenario, the Postgres database name MUST
               match that of the registered catalog (or the request will be rejected).
               
               When creating a synced table in a standard catalog, this field is required.
               In this scenario, specifying this field will allow targeting an arbitrary postgres database.
               Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        :param pulumi.Input[_builtins.str] name: Full three-part (catalog, schema, table) name of the table
        :param pulumi.Input[_builtins.str] unity_catalog_provisioning_state: (string) - The provisioning state of the synced table entity in Unity Catalog. This is distinct from the
               state of the data synchronization pipeline (i.e. the table may be in "ACTIVE" but the pipeline
               may be in "PROVISIONING" as it runs asynchronously). Possible values are: `ACTIVE`, `DEGRADED`, `DELETING`, `FAILED`, `PROVISIONING`, `UPDATING`
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if data_synchronization_status is not None:
            pulumi.set(__self__, "data_synchronization_status", data_synchronization_status)
        if database_instance_name is not None:
            pulumi.set(__self__, "database_instance_name", database_instance_name)
        if effective_database_instance_name is not None:
            pulumi.set(__self__, "effective_database_instance_name", effective_database_instance_name)
        if effective_logical_database_name is not None:
            pulumi.set(__self__, "effective_logical_database_name", effective_logical_database_name)
        if logical_database_name is not None:
            pulumi.set(__self__, "logical_database_name", logical_database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spec is not None:
            pulumi.set(__self__, "spec", spec)
        if unity_catalog_provisioning_state is not None:
            pulumi.set(__self__, "unity_catalog_provisioning_state", unity_catalog_provisioning_state)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="dataSynchronizationStatus")
    def data_synchronization_status(self) -> Optional[pulumi.Input['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs']]:
        """
        (SyncedTableStatus) - Synced Table data synchronization status
        """
        return pulumi.get(self, "data_synchronization_status")

    @data_synchronization_status.setter
    def data_synchronization_status(self, value: Optional[pulumi.Input['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs']]):
        pulumi.set(self, "data_synchronization_status", value)

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the target database instance. This is required when creating synced database tables in standard catalogs.
        This is optional when creating synced database tables in registered catalogs. If this field is specified
        when creating synced database tables in registered catalogs, the database instance name MUST
        match that of the registered catalog (or the request will be rejected)
        """
        return pulumi.get(self, "database_instance_name")

    @database_instance_name.setter
    def database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveDatabaseInstanceName")
    def effective_database_instance_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The name of the database instance that this table is registered to. This field is always returned, and for
        tables inside database catalogs is inferred database instance associated with the catalog
        """
        return pulumi.get(self, "effective_database_instance_name")

    @effective_database_instance_name.setter
    def effective_database_instance_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_database_instance_name", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLogicalDatabaseName")
    def effective_logical_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The name of the logical database that this table is registered to
        """
        return pulumi.get(self, "effective_logical_database_name")

    @effective_logical_database_name.setter
    def effective_logical_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_logical_database_name", value)

    @_builtins.property
    @pulumi.getter(name="logicalDatabaseName")
    def logical_database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target Postgres database object (logical database) name for this table.

        When creating a synced table in a registered Postgres catalog, the
        target Postgres database name is inferred to be that of the registered catalog.
        If this field is specified in this scenario, the Postgres database name MUST
        match that of the registered catalog (or the request will be rejected).

        When creating a synced table in a standard catalog, this field is required.
        In this scenario, specifying this field will allow targeting an arbitrary postgres database.
        Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        """
        return pulumi.get(self, "logical_database_name")

    @logical_database_name.setter
    def logical_database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "logical_database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Full three-part (catalog, schema, table) name of the table
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']]:
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['DatabaseSyncedDatabaseTableSpecArgs']]):
        pulumi.set(self, "spec", value)

    @_builtins.property
    @pulumi.getter(name="unityCatalogProvisioningState")
    def unity_catalog_provisioning_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - The provisioning state of the synced table entity in Unity Catalog. This is distinct from the
        state of the data synchronization pipeline (i.e. the table may be in "ACTIVE" but the pipeline
        may be in "PROVISIONING" as it runs asynchronously). Possible values are: `ACTIVE`, `DEGRADED`, `DELETING`, `FAILED`, `PROVISIONING`, `UPDATING`
        """
        return pulumi.get(self, "unity_catalog_provisioning_state")

    @unity_catalog_provisioning_state.setter
    def unity_catalog_provisioning_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unity_catalog_provisioning_state", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/databaseSyncedDatabaseTable:DatabaseSyncedDatabaseTable")
class DatabaseSyncedDatabaseTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['DatabaseSyncedDatabaseTableSpecArgs', 'DatabaseSyncedDatabaseTableSpecArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Lakebase Synced Database Tables are Postgres tables automatically synced from a source table inside Unity Catalog.
        They can be used to serve realtime queries without the operational overhead of managing ETL pipelines.

        Synced Database Tables can be configured inside either Database Catalogs or Standard Catalogs. Multiple
        Synced Database Tables can be bin packed inside a single pipeline to optimize costs.

        ## Example Usage

        ### Creating a Synced Database Table inside a Database Catalog

        This example creates a Synced Database Table inside a Database Catalog.

        ### Creating a Synced Database Table inside a Standard Catalog

        This example creates a Synced Database Table inside a Standard Catalog.

        ### Creating multiple Synced Database Tables and bin packing them into a single pipeline

        This example creates two Synced Database Tables. The first one specifies a new pipeline spec,
        which generates a new pipeline. The second one utilizes the pipeline ID of the first table.

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_database_synced_database_table.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseSyncedDatabaseTable:DatabaseSyncedDatabaseTable databricks_database_synced_database_table "name"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] database_instance_name: Name of the target database instance. This is required when creating synced database tables in standard catalogs.
               This is optional when creating synced database tables in registered catalogs. If this field is specified
               when creating synced database tables in registered catalogs, the database instance name MUST
               match that of the registered catalog (or the request will be rejected)
        :param pulumi.Input[_builtins.str] logical_database_name: Target Postgres database object (logical database) name for this table.
               
               When creating a synced table in a registered Postgres catalog, the
               target Postgres database name is inferred to be that of the registered catalog.
               If this field is specified in this scenario, the Postgres database name MUST
               match that of the registered catalog (or the request will be rejected).
               
               When creating a synced table in a standard catalog, this field is required.
               In this scenario, specifying this field will allow targeting an arbitrary postgres database.
               Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        :param pulumi.Input[_builtins.str] name: Full three-part (catalog, schema, table) name of the table
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseSyncedDatabaseTableArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Lakebase Synced Database Tables are Postgres tables automatically synced from a source table inside Unity Catalog.
        They can be used to serve realtime queries without the operational overhead of managing ETL pipelines.

        Synced Database Tables can be configured inside either Database Catalogs or Standard Catalogs. Multiple
        Synced Database Tables can be bin packed inside a single pipeline to optimize costs.

        ## Example Usage

        ### Creating a Synced Database Table inside a Database Catalog

        This example creates a Synced Database Table inside a Database Catalog.

        ### Creating a Synced Database Table inside a Standard Catalog

        This example creates a Synced Database Table inside a Standard Catalog.

        ### Creating multiple Synced Database Tables and bin packing them into a single pipeline

        This example creates two Synced Database Tables. The first one specifies a new pipeline spec,
        which generates a new pipeline. The second one utilizes the pipeline ID of the first table.

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_database_synced_database_table.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/databaseSyncedDatabaseTable:DatabaseSyncedDatabaseTable databricks_database_synced_database_table "name"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseSyncedDatabaseTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseSyncedDatabaseTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spec: Optional[pulumi.Input[Union['DatabaseSyncedDatabaseTableSpecArgs', 'DatabaseSyncedDatabaseTableSpecArgsDict']]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseSyncedDatabaseTableArgs.__new__(DatabaseSyncedDatabaseTableArgs)

            __props__.__dict__["database_instance_name"] = database_instance_name
            __props__.__dict__["logical_database_name"] = logical_database_name
            __props__.__dict__["name"] = name
            __props__.__dict__["spec"] = spec
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["data_synchronization_status"] = None
            __props__.__dict__["effective_database_instance_name"] = None
            __props__.__dict__["effective_logical_database_name"] = None
            __props__.__dict__["unity_catalog_provisioning_state"] = None
        super(DatabaseSyncedDatabaseTable, __self__).__init__(
            'databricks:index/databaseSyncedDatabaseTable:DatabaseSyncedDatabaseTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_synchronization_status: Optional[pulumi.Input[Union['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs', 'DatabaseSyncedDatabaseTableDataSynchronizationStatusArgsDict']]] = None,
            database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_database_instance_name: Optional[pulumi.Input[_builtins.str]] = None,
            effective_logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            logical_database_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spec: Optional[pulumi.Input[Union['DatabaseSyncedDatabaseTableSpecArgs', 'DatabaseSyncedDatabaseTableSpecArgsDict']]] = None,
            unity_catalog_provisioning_state: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DatabaseSyncedDatabaseTable':
        """
        Get an existing DatabaseSyncedDatabaseTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DatabaseSyncedDatabaseTableDataSynchronizationStatusArgs', 'DatabaseSyncedDatabaseTableDataSynchronizationStatusArgsDict']] data_synchronization_status: (SyncedTableStatus) - Synced Table data synchronization status
        :param pulumi.Input[_builtins.str] database_instance_name: Name of the target database instance. This is required when creating synced database tables in standard catalogs.
               This is optional when creating synced database tables in registered catalogs. If this field is specified
               when creating synced database tables in registered catalogs, the database instance name MUST
               match that of the registered catalog (or the request will be rejected)
        :param pulumi.Input[_builtins.str] effective_database_instance_name: (string) - The name of the database instance that this table is registered to. This field is always returned, and for
               tables inside database catalogs is inferred database instance associated with the catalog
        :param pulumi.Input[_builtins.str] effective_logical_database_name: (string) - The name of the logical database that this table is registered to
        :param pulumi.Input[_builtins.str] logical_database_name: Target Postgres database object (logical database) name for this table.
               
               When creating a synced table in a registered Postgres catalog, the
               target Postgres database name is inferred to be that of the registered catalog.
               If this field is specified in this scenario, the Postgres database name MUST
               match that of the registered catalog (or the request will be rejected).
               
               When creating a synced table in a standard catalog, this field is required.
               In this scenario, specifying this field will allow targeting an arbitrary postgres database.
               Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        :param pulumi.Input[_builtins.str] name: Full three-part (catalog, schema, table) name of the table
        :param pulumi.Input[_builtins.str] unity_catalog_provisioning_state: (string) - The provisioning state of the synced table entity in Unity Catalog. This is distinct from the
               state of the data synchronization pipeline (i.e. the table may be in "ACTIVE" but the pipeline
               may be in "PROVISIONING" as it runs asynchronously). Possible values are: `ACTIVE`, `DEGRADED`, `DELETING`, `FAILED`, `PROVISIONING`, `UPDATING`
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseSyncedDatabaseTableState.__new__(_DatabaseSyncedDatabaseTableState)

        __props__.__dict__["data_synchronization_status"] = data_synchronization_status
        __props__.__dict__["database_instance_name"] = database_instance_name
        __props__.__dict__["effective_database_instance_name"] = effective_database_instance_name
        __props__.__dict__["effective_logical_database_name"] = effective_logical_database_name
        __props__.__dict__["logical_database_name"] = logical_database_name
        __props__.__dict__["name"] = name
        __props__.__dict__["spec"] = spec
        __props__.__dict__["unity_catalog_provisioning_state"] = unity_catalog_provisioning_state
        __props__.__dict__["workspace_id"] = workspace_id
        return DatabaseSyncedDatabaseTable(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataSynchronizationStatus")
    def data_synchronization_status(self) -> pulumi.Output['outputs.DatabaseSyncedDatabaseTableDataSynchronizationStatus']:
        """
        (SyncedTableStatus) - Synced Table data synchronization status
        """
        return pulumi.get(self, "data_synchronization_status")

    @_builtins.property
    @pulumi.getter(name="databaseInstanceName")
    def database_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the target database instance. This is required when creating synced database tables in standard catalogs.
        This is optional when creating synced database tables in registered catalogs. If this field is specified
        when creating synced database tables in registered catalogs, the database instance name MUST
        match that of the registered catalog (or the request will be rejected)
        """
        return pulumi.get(self, "database_instance_name")

    @_builtins.property
    @pulumi.getter(name="effectiveDatabaseInstanceName")
    def effective_database_instance_name(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The name of the database instance that this table is registered to. This field is always returned, and for
        tables inside database catalogs is inferred database instance associated with the catalog
        """
        return pulumi.get(self, "effective_database_instance_name")

    @_builtins.property
    @pulumi.getter(name="effectiveLogicalDatabaseName")
    def effective_logical_database_name(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The name of the logical database that this table is registered to
        """
        return pulumi.get(self, "effective_logical_database_name")

    @_builtins.property
    @pulumi.getter(name="logicalDatabaseName")
    def logical_database_name(self) -> pulumi.Output[_builtins.str]:
        """
        Target Postgres database object (logical database) name for this table.

        When creating a synced table in a registered Postgres catalog, the
        target Postgres database name is inferred to be that of the registered catalog.
        If this field is specified in this scenario, the Postgres database name MUST
        match that of the registered catalog (or the request will be rejected).

        When creating a synced table in a standard catalog, this field is required.
        In this scenario, specifying this field will allow targeting an arbitrary postgres database.
        Note that this has implications for the `create_database_objects_is_missing` field in `spec`
        """
        return pulumi.get(self, "logical_database_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Full three-part (catalog, schema, table) name of the table
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.DatabaseSyncedDatabaseTableSpec']]:
        return pulumi.get(self, "spec")

    @_builtins.property
    @pulumi.getter(name="unityCatalogProvisioningState")
    def unity_catalog_provisioning_state(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - The provisioning state of the synced table entity in Unity Catalog. This is distinct from the
        state of the data synchronization pipeline (i.e. the table may be in "ACTIVE" but the pipeline
        may be in "PROVISIONING" as it runs asynchronously). Possible values are: `ACTIVE`, `DEGRADED`, `DELETING`, `FAILED`, `PROVISIONING`, `UPDATING`
        """
        return pulumi.get(self, "unity_catalog_provisioning_state")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

