# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ExternalMetadataArgs', 'ExternalMetadata']

@pulumi.input_type
class ExternalMetadataArgs:
    def __init__(__self__, *,
                 entity_type: pulumi.Input[_builtins.str],
                 system_type: pulumi.Input[_builtins.str],
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ExternalMetadata resource.
        :param pulumi.Input[_builtins.str] entity_type: Type of entity within the external system
        :param pulumi.Input[_builtins.str] system_type: Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns: List of columns associated with the external metadata object
        :param pulumi.Input[_builtins.str] description: User-provided free-form text description
        :param pulumi.Input[_builtins.str] name: Name of the external metadata object
        :param pulumi.Input[_builtins.str] owner: Owner of the external metadata object
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of key-value properties attached to the external metadata object
        :param pulumi.Input[_builtins.str] url: URL associated with the external metadata object
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        pulumi.set(__self__, "entity_type", entity_type)
        pulumi.set(__self__, "system_type", system_type)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of entity within the external system
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Input[_builtins.str]:
        """
        Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of columns associated with the external metadata object
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided free-form text description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the external metadata object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Owner of the external metadata object
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value properties attached to the external metadata object
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL associated with the external metadata object
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.input_type
class _ExternalMetadataState:
    def __init__(__self__, *,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_by: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ExternalMetadata resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns: List of columns associated with the external metadata object
        :param pulumi.Input[_builtins.str] create_time: (string) - Time at which this external metadata object was created
        :param pulumi.Input[_builtins.str] created_by: (string) - Username of external metadata object creator
        :param pulumi.Input[_builtins.str] description: User-provided free-form text description
        :param pulumi.Input[_builtins.str] entity_type: Type of entity within the external system
        :param pulumi.Input[_builtins.str] metastore_id: (string) - Unique identifier of parent metastore
        :param pulumi.Input[_builtins.str] name: Name of the external metadata object
        :param pulumi.Input[_builtins.str] owner: Owner of the external metadata object
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of key-value properties attached to the external metadata object
        :param pulumi.Input[_builtins.str] system_type: Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        :param pulumi.Input[_builtins.str] update_time: (string) - Time at which this external metadata object was last modified
        :param pulumi.Input[_builtins.str] updated_by: (string) - Username of user who last modified external metadata object
        :param pulumi.Input[_builtins.str] url: URL associated with the external metadata object
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if metastore_id is not None:
            pulumi.set(__self__, "metastore_id", metastore_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if system_type is not None:
            pulumi.set(__self__, "system_type", system_type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if updated_by is not None:
            pulumi.set(__self__, "updated_by", updated_by)
        if url is not None:
            pulumi.set(__self__, "url", url)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of columns associated with the external metadata object
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "columns", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Time at which this external metadata object was created
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Username of external metadata object creator
        """
        return pulumi.get(self, "created_by")

    @created_by.setter
    def created_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User-provided free-form text description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of entity within the external system
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_type", value)

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Unique identifier of parent metastore
        """
        return pulumi.get(self, "metastore_id")

    @metastore_id.setter
    def metastore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "metastore_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the external metadata object
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Owner of the external metadata object
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value properties attached to the external metadata object
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        """
        return pulumi.get(self, "system_type")

    @system_type.setter
    def system_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_type", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Time at which this external metadata object was last modified
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (string) - Username of user who last modified external metadata object
        """
        return pulumi.get(self, "updated_by")

    @updated_by.setter
    def updated_by(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_by", value)

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URL associated with the external metadata object
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("databricks:index/externalMetadata:ExternalMetadata")
class ExternalMetadata(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        To enrich lineage with workloads that are run outside of Databricks (for example, first mile ETL or last mile BI),
        Unity Catalog is introducing the external metadata object. UC lets you add external metadata objects to augment the data lineage it captures automatically, giving you an end-to-end lineage view in UC.
        This is useful when you want to capture where data came from (for example, Salesforce or MySQL) before it was ingested into UC or where data is being consumed outside UC (for example, Tableau or PowerBI).

        > **Note** This resource can only be used with an workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ExternalMetadata("this",
            name="security_events_stream",
            system_type="KAFKA",
            entity_type="Topic",
            url="https://kafka.com/12345",
            description="A stream of security related events in the critical services.",
            columns=[
                "type",
                "message",
                "details",
                "date",
                "time",
            ],
            properties={
                "topic": "prod.security.events.raw",
                "enabled": "true",
                "format": "zstd",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_external_metadata.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/externalMetadata:ExternalMetadata databricks_external_metadata "name"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns: List of columns associated with the external metadata object
        :param pulumi.Input[_builtins.str] description: User-provided free-form text description
        :param pulumi.Input[_builtins.str] entity_type: Type of entity within the external system
        :param pulumi.Input[_builtins.str] name: Name of the external metadata object
        :param pulumi.Input[_builtins.str] owner: Owner of the external metadata object
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of key-value properties attached to the external metadata object
        :param pulumi.Input[_builtins.str] system_type: Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        :param pulumi.Input[_builtins.str] url: URL associated with the external metadata object
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExternalMetadataArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        To enrich lineage with workloads that are run outside of Databricks (for example, first mile ETL or last mile BI),
        Unity Catalog is introducing the external metadata object. UC lets you add external metadata objects to augment the data lineage it captures automatically, giving you an end-to-end lineage view in UC.
        This is useful when you want to capture where data came from (for example, Salesforce or MySQL) before it was ingested into UC or where data is being consumed outside UC (for example, Tableau or PowerBI).

        > **Note** This resource can only be used with an workspace-level provider!

        ## Example Usage

        ```python
        import pulumi
        import pulumi_databricks as databricks

        this = databricks.ExternalMetadata("this",
            name="security_events_stream",
            system_type="KAFKA",
            entity_type="Topic",
            url="https://kafka.com/12345",
            description="A stream of security related events in the critical services.",
            columns=[
                "type",
                "message",
                "details",
                "date",
                "time",
            ],
            properties={
                "topic": "prod.security.events.raw",
                "enabled": "true",
                "format": "zstd",
            })
        ```

        ## Import

        As of Pulumi v1.5, resources can be imported through configuration.

        hcl

        import {

          id = "name"

          to = databricks_external_metadata.this

        }

        If you are using an older version of Pulumi, import the resource using the `pulumi import` command as follows:

        ```sh
        $ pulumi import databricks:index/externalMetadata:ExternalMetadata databricks_external_metadata "name"
        ```

        :param str resource_name: The name of the resource.
        :param ExternalMetadataArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExternalMetadataArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 system_type: Optional[pulumi.Input[_builtins.str]] = None,
                 url: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExternalMetadataArgs.__new__(ExternalMetadataArgs)

            __props__.__dict__["columns"] = columns
            __props__.__dict__["description"] = description
            if entity_type is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type'")
            __props__.__dict__["entity_type"] = entity_type
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["properties"] = properties
            if system_type is None and not opts.urn:
                raise TypeError("Missing required property 'system_type'")
            __props__.__dict__["system_type"] = system_type
            __props__.__dict__["url"] = url
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["create_time"] = None
            __props__.__dict__["created_by"] = None
            __props__.__dict__["metastore_id"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["updated_by"] = None
        super(ExternalMetadata, __self__).__init__(
            'databricks:index/externalMetadata:ExternalMetadata',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_by: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entity_type: Optional[pulumi.Input[_builtins.str]] = None,
            metastore_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            system_type: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None,
            updated_by: Optional[pulumi.Input[_builtins.str]] = None,
            url: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ExternalMetadata':
        """
        Get an existing ExternalMetadata resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] columns: List of columns associated with the external metadata object
        :param pulumi.Input[_builtins.str] create_time: (string) - Time at which this external metadata object was created
        :param pulumi.Input[_builtins.str] created_by: (string) - Username of external metadata object creator
        :param pulumi.Input[_builtins.str] description: User-provided free-form text description
        :param pulumi.Input[_builtins.str] entity_type: Type of entity within the external system
        :param pulumi.Input[_builtins.str] metastore_id: (string) - Unique identifier of parent metastore
        :param pulumi.Input[_builtins.str] name: Name of the external metadata object
        :param pulumi.Input[_builtins.str] owner: Owner of the external metadata object
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] properties: A map of key-value properties attached to the external metadata object
        :param pulumi.Input[_builtins.str] system_type: Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        :param pulumi.Input[_builtins.str] update_time: (string) - Time at which this external metadata object was last modified
        :param pulumi.Input[_builtins.str] updated_by: (string) - Username of user who last modified external metadata object
        :param pulumi.Input[_builtins.str] url: URL associated with the external metadata object
        :param pulumi.Input[_builtins.str] workspace_id: Workspace ID of the resource
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExternalMetadataState.__new__(_ExternalMetadataState)

        __props__.__dict__["columns"] = columns
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_by"] = created_by
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_type"] = entity_type
        __props__.__dict__["metastore_id"] = metastore_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["properties"] = properties
        __props__.__dict__["system_type"] = system_type
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["updated_by"] = updated_by
        __props__.__dict__["url"] = url
        __props__.__dict__["workspace_id"] = workspace_id
        return ExternalMetadata(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of columns associated with the external metadata object
        """
        return pulumi.get(self, "columns")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Time at which this external metadata object was created
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Username of external metadata object creator
        """
        return pulumi.get(self, "created_by")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        User-provided free-form text description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of entity within the external system
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter(name="metastoreId")
    def metastore_id(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Unique identifier of parent metastore
        """
        return pulumi.get(self, "metastore_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the external metadata object
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Owner of the external metadata object
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of key-value properties attached to the external metadata object
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="systemType")
    def system_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of external system. Possible values are: `AMAZON_REDSHIFT`, `AZURE_SYNAPSE`, `CONFLUENT`, `DATABRICKS`, `GOOGLE_BIGQUERY`, `KAFKA`, `LOOKER`, `MICROSOFT_FABRIC`, `MICROSOFT_SQL_SERVER`, `MONGODB`, `MYSQL`, `ORACLE`, `OTHER`, `POSTGRESQL`, `POWER_BI`, `SALESFORCE`, `SAP`, `SERVICENOW`, `SNOWFLAKE`, `TABLEAU`, `TERADATA`, `WORKDAY`
        """
        return pulumi.get(self, "system_type")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Time at which this external metadata object was last modified
        """
        return pulumi.get(self, "update_time")

    @_builtins.property
    @pulumi.getter(name="updatedBy")
    def updated_by(self) -> pulumi.Output[_builtins.str]:
        """
        (string) - Username of user who last modified external metadata object
        """
        return pulumi.get(self, "updated_by")

    @_builtins.property
    @pulumi.getter
    def url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        URL associated with the external metadata object
        """
        return pulumi.get(self, "url")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Workspace ID of the resource
        """
        return pulumi.get(self, "workspace_id")

