# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetBudgetPolicyResult',
    'AwaitableGetBudgetPolicyResult',
    'get_budget_policy',
    'get_budget_policy_output',
]

@pulumi.output_type
class GetBudgetPolicyResult:
    """
    A collection of values returned by getBudgetPolicy.
    """
    def __init__(__self__, binding_workspace_ids=None, custom_tags=None, id=None, policy_id=None, policy_name=None):
        if binding_workspace_ids and not isinstance(binding_workspace_ids, list):
            raise TypeError("Expected argument 'binding_workspace_ids' to be a list")
        pulumi.set(__self__, "binding_workspace_ids", binding_workspace_ids)
        if custom_tags and not isinstance(custom_tags, list):
            raise TypeError("Expected argument 'custom_tags' to be a list")
        pulumi.set(__self__, "custom_tags", custom_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_id and not isinstance(policy_id, str):
            raise TypeError("Expected argument 'policy_id' to be a str")
        pulumi.set(__self__, "policy_id", policy_id)
        if policy_name and not isinstance(policy_name, str):
            raise TypeError("Expected argument 'policy_name' to be a str")
        pulumi.set(__self__, "policy_name", policy_name)

    @_builtins.property
    @pulumi.getter(name="bindingWorkspaceIds")
    def binding_workspace_ids(self) -> Optional[Sequence[_builtins.int]]:
        """
        (list of integer) - List of workspaces that this budget policy will be exclusively bound to.
        An empty binding implies that this budget policy is open to any workspace in the account
        """
        return pulumi.get(self, "binding_workspace_ids")

    @_builtins.property
    @pulumi.getter(name="customTags")
    def custom_tags(self) -> Optional[Sequence['outputs.GetBudgetPolicyCustomTagResult']]:
        """
        (list of CustomPolicyTag) - A list of tags defined by the customer. At most 20 entries are allowed per policy
        """
        return pulumi.get(self, "custom_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> _builtins.str:
        """
        (string) - The Id of the policy. This field is generated by Databricks and globally unique
        """
        return pulumi.get(self, "policy_id")

    @_builtins.property
    @pulumi.getter(name="policyName")
    def policy_name(self) -> Optional[_builtins.str]:
        """
        (string) - The name of the policy.
        - Must be unique among active policies.
        - Can contain only characters from the ISO 8859-1 (latin1) set.
        - Can't start with reserved keywords such as `databricks:default-policy`
        """
        return pulumi.get(self, "policy_name")


class AwaitableGetBudgetPolicyResult(GetBudgetPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBudgetPolicyResult(
            binding_workspace_ids=self.binding_workspace_ids,
            custom_tags=self.custom_tags,
            id=self.id,
            policy_id=self.policy_id,
            policy_name=self.policy_name)


def get_budget_policy(binding_workspace_ids: Optional[Sequence[_builtins.int]] = None,
                      custom_tags: Optional[Sequence[Union['GetBudgetPolicyCustomTagArgs', 'GetBudgetPolicyCustomTagArgsDict']]] = None,
                      policy_id: Optional[_builtins.str] = None,
                      policy_name: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBudgetPolicyResult:
    """
    This data source can be used to get a single budget policy.

    > **Note** This data source can only be used with an account-level provider!

    ## Example Usage

    Referring to a budget policy by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_budget_policy(policy_id="test")
    ```


    :param Sequence[_builtins.int] binding_workspace_ids: (list of integer) - List of workspaces that this budget policy will be exclusively bound to.
           An empty binding implies that this budget policy is open to any workspace in the account
    :param Sequence[Union['GetBudgetPolicyCustomTagArgs', 'GetBudgetPolicyCustomTagArgsDict']] custom_tags: (list of CustomPolicyTag) - A list of tags defined by the customer. At most 20 entries are allowed per policy
    :param _builtins.str policy_id: The Id of the policy. This field is generated by Databricks and globally unique
    :param _builtins.str policy_name: (string) - The name of the policy.
           - Must be unique among active policies.
           - Can contain only characters from the ISO 8859-1 (latin1) set.
           - Can't start with reserved keywords such as `databricks:default-policy`
    """
    __args__ = dict()
    __args__['bindingWorkspaceIds'] = binding_workspace_ids
    __args__['customTags'] = custom_tags
    __args__['policyId'] = policy_id
    __args__['policyName'] = policy_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getBudgetPolicy:getBudgetPolicy', __args__, opts=opts, typ=GetBudgetPolicyResult).value

    return AwaitableGetBudgetPolicyResult(
        binding_workspace_ids=pulumi.get(__ret__, 'binding_workspace_ids'),
        custom_tags=pulumi.get(__ret__, 'custom_tags'),
        id=pulumi.get(__ret__, 'id'),
        policy_id=pulumi.get(__ret__, 'policy_id'),
        policy_name=pulumi.get(__ret__, 'policy_name'))
def get_budget_policy_output(binding_workspace_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.int]]]] = None,
                             custom_tags: Optional[pulumi.Input[Optional[Sequence[Union['GetBudgetPolicyCustomTagArgs', 'GetBudgetPolicyCustomTagArgsDict']]]]] = None,
                             policy_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             policy_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBudgetPolicyResult]:
    """
    This data source can be used to get a single budget policy.

    > **Note** This data source can only be used with an account-level provider!

    ## Example Usage

    Referring to a budget policy by id:

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_budget_policy(policy_id="test")
    ```


    :param Sequence[_builtins.int] binding_workspace_ids: (list of integer) - List of workspaces that this budget policy will be exclusively bound to.
           An empty binding implies that this budget policy is open to any workspace in the account
    :param Sequence[Union['GetBudgetPolicyCustomTagArgs', 'GetBudgetPolicyCustomTagArgsDict']] custom_tags: (list of CustomPolicyTag) - A list of tags defined by the customer. At most 20 entries are allowed per policy
    :param _builtins.str policy_id: The Id of the policy. This field is generated by Databricks and globally unique
    :param _builtins.str policy_name: (string) - The name of the policy.
           - Must be unique among active policies.
           - Can contain only characters from the ISO 8859-1 (latin1) set.
           - Can't start with reserved keywords such as `databricks:default-policy`
    """
    __args__ = dict()
    __args__['bindingWorkspaceIds'] = binding_workspace_ids
    __args__['customTags'] = custom_tags
    __args__['policyId'] = policy_id
    __args__['policyName'] = policy_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getBudgetPolicy:getBudgetPolicy', __args__, opts=opts, typ=GetBudgetPolicyResult)
    return __ret__.apply(lambda __response__: GetBudgetPolicyResult(
        binding_workspace_ids=pulumi.get(__response__, 'binding_workspace_ids'),
        custom_tags=pulumi.get(__response__, 'custom_tags'),
        id=pulumi.get(__response__, 'id'),
        policy_id=pulumi.get(__response__, 'policy_id'),
        policy_name=pulumi.get(__response__, 'policy_name')))
