# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetEntityTagAssignmentResult',
    'AwaitableGetEntityTagAssignmentResult',
    'get_entity_tag_assignment',
    'get_entity_tag_assignment_output',
]

@pulumi.output_type
class GetEntityTagAssignmentResult:
    """
    A collection of values returned by getEntityTagAssignment.
    """
    def __init__(__self__, entity_name=None, entity_type=None, id=None, tag_key=None, tag_value=None, workspace_id=None):
        if entity_name and not isinstance(entity_name, str):
            raise TypeError("Expected argument 'entity_name' to be a str")
        pulumi.set(__self__, "entity_name", entity_name)
        if entity_type and not isinstance(entity_type, str):
            raise TypeError("Expected argument 'entity_type' to be a str")
        pulumi.set(__self__, "entity_type", entity_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tag_key and not isinstance(tag_key, str):
            raise TypeError("Expected argument 'tag_key' to be a str")
        pulumi.set(__self__, "tag_key", tag_key)
        if tag_value and not isinstance(tag_value, str):
            raise TypeError("Expected argument 'tag_value' to be a str")
        pulumi.set(__self__, "tag_value", tag_value)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="entityName")
    def entity_name(self) -> _builtins.str:
        """
        (string) - The fully qualified name of the entity to which the tag is assigned
        """
        return pulumi.get(self, "entity_name")

    @_builtins.property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> _builtins.str:
        """
        (string) - The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
        """
        return pulumi.get(self, "entity_type")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="tagKey")
    def tag_key(self) -> _builtins.str:
        """
        (string) - The key of the tag
        """
        return pulumi.get(self, "tag_key")

    @_builtins.property
    @pulumi.getter(name="tagValue")
    def tag_value(self) -> Optional[_builtins.str]:
        """
        (string) - The value of the tag
        """
        return pulumi.get(self, "tag_value")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "workspace_id")


class AwaitableGetEntityTagAssignmentResult(GetEntityTagAssignmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEntityTagAssignmentResult(
            entity_name=self.entity_name,
            entity_type=self.entity_type,
            id=self.id,
            tag_key=self.tag_key,
            tag_value=self.tag_value,
            workspace_id=self.workspace_id)


def get_entity_tag_assignment(entity_name: Optional[_builtins.str] = None,
                              entity_type: Optional[_builtins.str] = None,
                              tag_key: Optional[_builtins.str] = None,
                              tag_value: Optional[_builtins.str] = None,
                              workspace_id: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEntityTagAssignmentResult:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str entity_name: The fully qualified name of the entity to which the tag is assigned
    :param _builtins.str entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
    :param _builtins.str tag_key: The key of the tag
    :param _builtins.str tag_value: (string) - The value of the tag
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['entityName'] = entity_name
    __args__['entityType'] = entity_type
    __args__['tagKey'] = tag_key
    __args__['tagValue'] = tag_value
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getEntityTagAssignment:getEntityTagAssignment', __args__, opts=opts, typ=GetEntityTagAssignmentResult).value

    return AwaitableGetEntityTagAssignmentResult(
        entity_name=pulumi.get(__ret__, 'entity_name'),
        entity_type=pulumi.get(__ret__, 'entity_type'),
        id=pulumi.get(__ret__, 'id'),
        tag_key=pulumi.get(__ret__, 'tag_key'),
        tag_value=pulumi.get(__ret__, 'tag_value'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_entity_tag_assignment_output(entity_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     entity_type: Optional[pulumi.Input[_builtins.str]] = None,
                                     tag_key: Optional[pulumi.Input[_builtins.str]] = None,
                                     tag_value: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     workspace_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEntityTagAssignmentResult]:
    """
    Use this data source to access information about an existing resource.

    :param _builtins.str entity_name: The fully qualified name of the entity to which the tag is assigned
    :param _builtins.str entity_type: The type of the entity to which the tag is assigned. Allowed values are: catalogs, schemas, tables, columns, volumes
    :param _builtins.str tag_key: The key of the tag
    :param _builtins.str tag_value: (string) - The value of the tag
    :param _builtins.str workspace_id: Workspace ID of the resource
    """
    __args__ = dict()
    __args__['entityName'] = entity_name
    __args__['entityType'] = entity_type
    __args__['tagKey'] = tag_key
    __args__['tagValue'] = tag_value
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getEntityTagAssignment:getEntityTagAssignment', __args__, opts=opts, typ=GetEntityTagAssignmentResult)
    return __ret__.apply(lambda __response__: GetEntityTagAssignmentResult(
        entity_name=pulumi.get(__response__, 'entity_name'),
        entity_type=pulumi.get(__response__, 'entity_type'),
        id=pulumi.get(__response__, 'id'),
        tag_key=pulumi.get(__response__, 'tag_key'),
        tag_value=pulumi.get(__response__, 'tag_value'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
