# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExternalLocationResult',
    'AwaitableGetExternalLocationResult',
    'get_external_location',
    'get_external_location_output',
]

@pulumi.output_type
class GetExternalLocationResult:
    """
    A collection of values returned by getExternalLocation.
    """
    def __init__(__self__, external_location_info=None, id=None, name=None):
        if external_location_info and not isinstance(external_location_info, dict):
            raise TypeError("Expected argument 'external_location_info' to be a dict")
        pulumi.set(__self__, "external_location_info", external_location_info)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="externalLocationInfo")
    def external_location_info(self) -> 'outputs.GetExternalLocationExternalLocationInfoResult':
        """
        array of objects with information about external location:
        """
        return pulumi.get(self, "external_location_info")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        external location ID - same as name.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")


class AwaitableGetExternalLocationResult(GetExternalLocationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExternalLocationResult(
            external_location_info=self.external_location_info,
            id=self.id,
            name=self.name)


def get_external_location(external_location_info: Optional[Union['GetExternalLocationExternalLocationInfoArgs', 'GetExternalLocationExternalLocationInfoArgsDict']] = None,
                          id: Optional[_builtins.str] = None,
                          name: Optional[_builtins.str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExternalLocationResult:
    """
    Retrieves details about a ExternalLocation that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting details of an existing external location in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_external_location(name="this")
    pulumi.export("createdBy", this.external_location_info.created_by)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * get_external_locations to get names of all external locations
    * ExternalLocation to manage external locations within Unity Catalog.


    :param Union['GetExternalLocationExternalLocationInfoArgs', 'GetExternalLocationExternalLocationInfoArgsDict'] external_location_info: array of objects with information about external location:
    :param _builtins.str id: external location ID - same as name.
    :param _builtins.str name: The name of the external location
    """
    __args__ = dict()
    __args__['externalLocationInfo'] = external_location_info
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getExternalLocation:getExternalLocation', __args__, opts=opts, typ=GetExternalLocationResult).value

    return AwaitableGetExternalLocationResult(
        external_location_info=pulumi.get(__ret__, 'external_location_info'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))
def get_external_location_output(external_location_info: Optional[pulumi.Input[Optional[Union['GetExternalLocationExternalLocationInfoArgs', 'GetExternalLocationExternalLocationInfoArgsDict']]]] = None,
                                 id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                 name: Optional[pulumi.Input[_builtins.str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExternalLocationResult]:
    """
    Retrieves details about a ExternalLocation that were created by Pulumi or manually.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    Getting details of an existing external location in the metastore

    ```python
    import pulumi
    import pulumi_databricks as databricks

    this = databricks.get_external_location(name="this")
    pulumi.export("createdBy", this.external_location_info.created_by)
    ```

    ## Related Resources

    The following resources are used in the same context:

    * get_external_locations to get names of all external locations
    * ExternalLocation to manage external locations within Unity Catalog.


    :param Union['GetExternalLocationExternalLocationInfoArgs', 'GetExternalLocationExternalLocationInfoArgsDict'] external_location_info: array of objects with information about external location:
    :param _builtins.str id: external location ID - same as name.
    :param _builtins.str name: The name of the external location
    """
    __args__ = dict()
    __args__['externalLocationInfo'] = external_location_info
    __args__['id'] = id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getExternalLocation:getExternalLocation', __args__, opts=opts, typ=GetExternalLocationResult)
    return __ret__.apply(lambda __response__: GetExternalLocationResult(
        external_location_info=pulumi.get(__response__, 'external_location_info'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name')))
