# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetNotebookResult',
    'AwaitableGetNotebookResult',
    'get_notebook',
    'get_notebook_output',
]

@pulumi.output_type
class GetNotebookResult:
    """
    A collection of values returned by getNotebook.
    """
    def __init__(__self__, content=None, format=None, id=None, language=None, object_id=None, object_type=None, path=None, workspace_path=None):
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if language and not isinstance(language, str):
            raise TypeError("Expected argument 'language' to be a str")
        pulumi.set(__self__, "language", language)
        if object_id and not isinstance(object_id, int):
            raise TypeError("Expected argument 'object_id' to be a int")
        pulumi.set(__self__, "object_id", object_id)
        if object_type and not isinstance(object_type, str):
            raise TypeError("Expected argument 'object_type' to be a str")
        pulumi.set(__self__, "object_type", object_type)
        if path and not isinstance(path, str):
            raise TypeError("Expected argument 'path' to be a str")
        pulumi.set(__self__, "path", path)
        if workspace_path and not isinstance(workspace_path, str):
            raise TypeError("Expected argument 'workspace_path' to be a str")
        pulumi.set(__self__, "workspace_path", workspace_path)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        notebook content in selected format
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def format(self) -> _builtins.str:
        return pulumi.get(self, "format")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def language(self) -> _builtins.str:
        """
        notebook language
        """
        return pulumi.get(self, "language")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.int:
        """
        notebook object ID
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="objectType")
    def object_type(self) -> _builtins.str:
        """
        notebook object type
        """
        return pulumi.get(self, "object_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="workspacePath")
    def workspace_path(self) -> _builtins.str:
        """
        path on Workspace File System (WSFS) in form of `/Workspace` + `path`
        """
        return pulumi.get(self, "workspace_path")


class AwaitableGetNotebookResult(GetNotebookResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNotebookResult(
            content=self.content,
            format=self.format,
            id=self.id,
            language=self.language,
            object_id=self.object_id,
            object_type=self.object_type,
            path=self.path,
            workspace_path=self.workspace_path)


def get_notebook(format: Optional[_builtins.str] = None,
                 language: Optional[_builtins.str] = None,
                 object_id: Optional[_builtins.int] = None,
                 object_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNotebookResult:
    """
    This data source allows to export a notebook from Databricks Workspace.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    features = databricks.get_notebook(path="/Production/Features",
        format="SOURCE")
    ```


    :param _builtins.str format: Notebook format to export. Either `SOURCE`, `HTML`, `JUPYTER`, or `DBC`.
    :param _builtins.str language: notebook language
    :param _builtins.int object_id: notebook object ID
    :param _builtins.str object_type: notebook object type
    :param _builtins.str path: Notebook path on the workspace
    """
    __args__ = dict()
    __args__['format'] = format
    __args__['language'] = language
    __args__['objectId'] = object_id
    __args__['objectType'] = object_type
    __args__['path'] = path
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('databricks:index/getNotebook:getNotebook', __args__, opts=opts, typ=GetNotebookResult).value

    return AwaitableGetNotebookResult(
        content=pulumi.get(__ret__, 'content'),
        format=pulumi.get(__ret__, 'format'),
        id=pulumi.get(__ret__, 'id'),
        language=pulumi.get(__ret__, 'language'),
        object_id=pulumi.get(__ret__, 'object_id'),
        object_type=pulumi.get(__ret__, 'object_type'),
        path=pulumi.get(__ret__, 'path'),
        workspace_path=pulumi.get(__ret__, 'workspace_path'))
def get_notebook_output(format: Optional[pulumi.Input[_builtins.str]] = None,
                        language: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        object_id: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                        object_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        path: Optional[pulumi.Input[_builtins.str]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNotebookResult]:
    """
    This data source allows to export a notebook from Databricks Workspace.

    > This data source can only be used with a workspace-level provider!

    ## Example Usage

    ```python
    import pulumi
    import pulumi_databricks as databricks

    features = databricks.get_notebook(path="/Production/Features",
        format="SOURCE")
    ```


    :param _builtins.str format: Notebook format to export. Either `SOURCE`, `HTML`, `JUPYTER`, or `DBC`.
    :param _builtins.str language: notebook language
    :param _builtins.int object_id: notebook object ID
    :param _builtins.str object_type: notebook object type
    :param _builtins.str path: Notebook path on the workspace
    """
    __args__ = dict()
    __args__['format'] = format
    __args__['language'] = language
    __args__['objectId'] = object_id
    __args__['objectType'] = object_type
    __args__['path'] = path
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('databricks:index/getNotebook:getNotebook', __args__, opts=opts, typ=GetNotebookResult)
    return __ret__.apply(lambda __response__: GetNotebookResult(
        content=pulumi.get(__response__, 'content'),
        format=pulumi.get(__response__, 'format'),
        id=pulumi.get(__response__, 'id'),
        language=pulumi.get(__response__, 'language'),
        object_id=pulumi.get(__response__, 'object_id'),
        object_type=pulumi.get(__response__, 'object_type'),
        path=pulumi.get(__response__, 'path'),
        workspace_path=pulumi.get(__response__, 'workspace_path')))
