# Generated by Django 4.2.10 on 2024-04-24 05:46

import django.db.models.deletion
from django.db import migrations, models


def attach_openai_config(apps, schema_editor):
    OpenAIProcessorConversationConfig = apps.get_model("database", "OpenAIProcessorConversationConfig")
    openai_processor_conversation_config = OpenAIProcessorConversationConfig.objects.first()
    if openai_processor_conversation_config:
        ChatModelOptions = apps.get_model("database", "ChatModelOptions")
        for chat_model_option in ChatModelOptions.objects.all():
            if chat_model_option.model_type == "openai":
                chat_model_option.openai_config = openai_processor_conversation_config
                chat_model_option.save()


def separate_openai_config(apps, schema_editor):
    pass


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0036_delete_offlinechatprocessorconversationconfig"),
    ]

    operations = [
        migrations.AddField(
            model_name="chatmodeloptions",
            name="openai_config",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="database.openaiprocessorconversationconfig",
            ),
        ),
        migrations.AddField(
            model_name="openaiprocessorconversationconfig",
            name="api_base_url",
            field=models.URLField(blank=True, default=None, null=True),
        ),
        migrations.AddField(
            model_name="openaiprocessorconversationconfig",
            name="name",
            field=models.CharField(default="default", max_length=200),
            preserve_default=False,
        ),
        migrations.RunPython(attach_openai_config, reverse_code=separate_openai_config),
    ]
