# Generated by Django 4.2.3 on 2023-09-22 02:55

import datetime
from django.conf import settings
import django.contrib.postgres.fields
import django.contrib.postgres.indexes
import django.contrib.postgres.search
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import shipdan_model.app_model.accounts
import shipdan_model.app_model.diary
import shipdan_model.app_model.food
import shipdan_model.app_model.notification
import shipdan_model.app_model.oms


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "email",
                    models.EmailField(
                        blank=True, max_length=254, null=True, unique=True
                    ),
                ),
                ("is_staff", models.BooleanField(default=False)),
                ("is_superuser", models.BooleanField(default=False)),
                ("is_active", models.BooleanField(default=True)),
                ("is_ghost", models.BooleanField(default=False)),
                ("last_login", models.DateTimeField(blank=True, null=True)),
                ("date_joined", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "accounts_user",
            },
        ),
        migrations.CreateModel(
            name="ABTest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("version", models.CharField(max_length=30, unique=True)),
                ("seed", models.CharField(max_length=20)),
                ("total_group", models.IntegerField(default=2)),
                ("started_at", models.DateTimeField(default=None, null=True)),
                ("ended_at", models.DateTimeField(default=None, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "accounts_abtest",
            },
        ),
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("zonecode", models.CharField(max_length=10, verbose_name="우편번호")),
                ("sido", models.CharField(max_length=10, verbose_name="도/시 이름")),
                ("sigungu", models.CharField(max_length=10, verbose_name="시/군/구 이름")),
                (
                    "bname",
                    models.CharField(
                        blank=True, default="", max_length=20, verbose_name="법정동/법정리 이름"
                    ),
                ),
                (
                    "bcode",
                    models.CharField(
                        blank=True, default="", max_length=20, verbose_name="법정동 코드"
                    ),
                ),
                (
                    "roadAddress",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="도로명"
                    ),
                ),
                (
                    "buildingName",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="건물명"
                    ),
                ),
                (
                    "jibunAddress",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="지번 주소"
                    ),
                ),
                (
                    "autoRoadAddress",
                    models.CharField(
                        blank=True, default="", max_length=50, verbose_name="대체 도로명주소"
                    ),
                ),
                (
                    "content",
                    models.CharField(
                        blank=True, default="", max_length=100, verbose_name="장소 및 출입방법"
                    ),
                ),
                (
                    "extra",
                    models.CharField(
                        blank=True, default="", max_length=100, verbose_name="상세주소"
                    ),
                ),
            ],
            options={
                "db_table": "accounts_address",
            },
        ),
        migrations.CreateModel(
            name="AirbridgeDevice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("device_uuid", models.CharField(max_length=100)),
                (
                    "os_name",
                    models.CharField(
                        choices=[
                            ("undefined", "UNDEFINED"),
                            ("Android", "ANDROID"),
                            ("iOS", "IOS"),
                        ],
                        max_length=10,
                    ),
                ),
                ("os_version", models.CharField(max_length=20)),
                ("device_model", models.CharField(max_length=50)),
                ("gaid", models.CharField(default=None, max_length=100, null=True)),
                ("ifa", models.CharField(default=None, max_length=100, null=True)),
                ("ifv", models.CharField(default=None, max_length=100, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_airbridgedevice",
            },
        ),
        migrations.CreateModel(
            name="AligoKakaoToken",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.CharField(max_length=250, verbose_name="토큰")),
                ("is_expired", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField()),
                ("expired_at", models.DateTimeField()),
            ],
            options={
                "db_table": "notification_aligokakaotoken",
            },
        ),
        migrations.CreateModel(
            name="Allergy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[
                            (1, "알류"),
                            (2, "우유"),
                            (3, "밀"),
                            (4, "새우"),
                            (5, "게"),
                            (6, "고등어"),
                            (7, "호두"),
                            (8, "돼지고기"),
                            (9, "땅콩"),
                            (10, "조개류"),
                            (11, "복숭아"),
                            (12, "메밀"),
                            (13, "대두"),
                            (14, "잣"),
                            (15, "토마토"),
                            (16, "쇠고기"),
                            (17, "닭고기"),
                            (18, "홍합"),
                            (19, "전복"),
                            (20, "굴"),
                            (21, "오징어"),
                            (22, "아황산류"),
                        ],
                        unique=True,
                    ),
                ),
                ("name", models.CharField(max_length=20, unique=True)),
                (
                    "text",
                    models.CharField(
                        blank=True, help_text="사용자에게 보여질 텍스트", max_length=50, null=True
                    ),
                ),
            ],
            options={
                "db_table": "health_allergy",
            },
        ),
        migrations.CreateModel(
            name="AmazonSNSPlatformApplication",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                ("arn", models.CharField(default=None, max_length=200, null=True)),
            ],
            options={
                "db_table": "airbridge_amazonsnsplatformapplication",
            },
        ),
        migrations.CreateModel(
            name="AmazonSNSPlatformEndpoint",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "arn",
                    models.CharField(
                        default=None, max_length=200, null=True, unique=True
                    ),
                ),
                (
                    "token",
                    models.CharField(
                        default="", help_text="fcm device reg_id", max_length=200
                    ),
                ),
                ("enabled", models.BooleanField(default=True)),
                ("attributes", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_amazonsnsplatformendpoint",
            },
        ),
        migrations.CreateModel(
            name="AmazonSNSSubscription",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "arn",
                    models.CharField(
                        default=None, max_length=200, null=True, unique=True
                    ),
                ),
                ("attributes", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("deleted_at", models.DateTimeField(default=None, null=True)),
            ],
            options={
                "db_table": "notification_amazonsnssubscription",
            },
        ),
        migrations.CreateModel(
            name="AmazonSNSSubscriptionCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField()),
                (
                    "name",
                    models.CharField(
                        default=None, max_length=50, null=True, unique=True
                    ),
                ),
                ("title", models.CharField(max_length=300)),
                ("body", models.CharField(max_length=300)),
                ("description", models.CharField(max_length=200)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_amazonsnssubscriptioncategory",
            },
        ),
        migrations.CreateModel(
            name="AmazonSNSTopic",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                (
                    "arn",
                    models.CharField(
                        default=None, max_length=200, null=True, unique=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("deleted_at", models.DateTimeField(default=None, null=True)),
            ],
            options={
                "db_table": "notification_amazonsnstopic",
            },
        ),
        migrations.CreateModel(
            name="AmplitudeBatchEventResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start_batch", models.IntegerField()),
                ("end_batch", models.IntegerField()),
                ("code", models.IntegerField()),
                ("events_ingested", models.IntegerField(null=True)),
                ("payload_size_bytes", models.BigIntegerField(null=True)),
                (
                    "server_upload_time",
                    models.BigIntegerField(help_text="시간 ms입니다.", null=True),
                ),
                ("error", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "analysis_amplitudebatcheventresult",
            },
        ),
        migrations.CreateModel(
            name="AppTutorialSwitch",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("on", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "core_apptutorialswitch",
            },
        ),
        migrations.CreateModel(
            name="AppVersion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("app_os", models.IntegerField(choices=[(1, "android"), (2, "ios")])),
                ("latest_version", models.CharField(max_length=10)),
                ("required_version", models.CharField(max_length=10)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "core_appversion",
            },
        ),
        migrations.CreateModel(
            name="BodyFat",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.FloatField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "health_bodyfat",
            },
        ),
        migrations.CreateModel(
            name="CommonProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=10, null=True)),
                (
                    "gender",
                    models.IntegerField(
                        blank=True,
                        choices=[(1, "male"), (2, "female")],
                        help_text="1=남자, 2=여자",
                        null=True,
                    ),
                ),
                (
                    "age_range",
                    models.IntegerField(
                        blank=True,
                        choices=[
                            (1, "10대"),
                            (2, "20대"),
                            (3, "30대"),
                            (4, "40대"),
                            (5, "50대"),
                            (6, "60대"),
                            (7, "70대"),
                        ],
                        null=True,
                    ),
                ),
                ("birthday", models.DateField(blank=True, null=True)),
                ("phone", models.CharField(max_length=20, null=True)),
                ("nickname", models.CharField(blank=True, default="", max_length=8)),
                (
                    "avatar",
                    models.ImageField(
                        blank=True,
                        null=True,
                        upload_to=shipdan_model.app_model.accounts.profile_avatar_path,
                    ),
                ),
                ("use_common_avatar", models.BooleanField(default=False)),
                (
                    "one_line_intro",
                    models.CharField(blank=True, default="", max_length=100),
                ),
            ],
            options={
                "db_table": "accounts_commonprofile",
            },
        ),
        migrations.CreateModel(
            name="CookWay",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField(unique=True)),
            ],
            options={
                "db_table": "food_cookway",
            },
        ),
        migrations.CreateModel(
            name="CouponAutomaticPage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(help_text="구분 용입니다.", max_length=100)),
                ("button_text", models.CharField(default="쿠폰 다운로드", max_length=50)),
                (
                    "code",
                    models.CharField(
                        help_text="쿠폰 코드입니다. 쿠폰 템플릿의 코드값과 똑같이 적어주셔야합니다.",
                        max_length=20,
                        unique=True,
                    ),
                ),
                ("content", models.TextField(blank=True, default="")),
                (
                    "is_seen",
                    models.BooleanField(
                        default=False,
                        help_text="started_at, ended_at과 더불어 is_seen도 체크 되어야 유저가 봄",
                    ),
                ),
                (
                    "started_at",
                    models.DateTimeField(help_text="이벤트 시작시간입니다. 쿠폰의 유효기간과는 다른 값입니다."),
                ),
                (
                    "ended_at",
                    models.DateTimeField(help_text="이벤트 끝시간입니다. 쿠폰의 유효기간과는 다른 값입니다."),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_couponautomaticpage",
            },
        ),
        migrations.CreateModel(
            name="CouponCodeMapper",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=20, unique=True)),
                (
                    "coupon_category",
                    models.IntegerField(choices=[(0, "미정"), (1, "이벤트"), (2, "초대코드")]),
                ),
            ],
            options={
                "db_table": "food_payment_couponcodemapper",
            },
        ),
        migrations.CreateModel(
            name="CouponDiscount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField(blank=True, null=True)),
                (
                    "rate",
                    models.FloatField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(1.0),
                        ],
                    ),
                ),
                ("code", models.CharField(default=None, max_length=20, null=True)),
                (
                    "code_for_devel",
                    models.CharField(
                        blank=True,
                        help_text="개발용 코드입니다. 해당 코드에 따라 이벤트 등의 일을 개발합니다.",
                        max_length=50,
                    ),
                ),
                (
                    "coupon_category",
                    models.IntegerField(
                        choices=[(0, "미정"), (2, "초대코드"), (3, "cs"), (4, "초대호스트")],
                        default=0,
                    ),
                ),
                ("content", models.CharField(blank=True, max_length=100)),
                ("started_at", models.DateTimeField(blank=True, null=True)),
                ("ended_at", models.DateTimeField(blank=True, null=True)),
                ("used_at", models.DateTimeField(blank=True, null=True)),
                (
                    "canceled_at",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "min_order_amount",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="쿠폰을 적용할 수 있는 최소 주문 금액 입니다.",
                        null=True,
                    ),
                ),
                (
                    "max_amount",
                    models.IntegerField(
                        default=100000000,
                        help_text="쿠폰이 최대로 적용될 수 있는 할인 금액 입니다. 입력 하지 않으면 임의의 큰 값으로 자동 설정 됩니다.",
                    ),
                ),
                (
                    "actual_discount_amount",
                    models.IntegerField(
                        blank=True, help_text="결제 시 실제로 할인된 금액 입니다.", null=True
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_coupodiscount",
            },
        ),
        migrations.CreateModel(
            name="CouponDiscountTarget",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("reserved_at", models.DateTimeField()),
                (
                    "started_at",
                    models.DateTimeField(
                        blank=True,
                        help_text="비워 있으면 template의 duration과 reserved_at을 기준으로 쿠폰 유효기간을 설정합니다.",
                        null=True,
                    ),
                ),
                ("ended_at", models.DateTimeField(blank=True, null=True)),
                ("emails", models.TextField(default="", help_text="쉼표 없이 한줄씩 적어주세요!")),
                (
                    "invalid_emails",
                    models.TextField(
                        default="",
                        help_text="유저가 없거나(이메일 잘못기입 혹은 회원탈퇴),is active가 False인 유저입니다. 저장 시, 자동으로 기입됩니다.",
                    ),
                ),
                (
                    "is_created",
                    models.BooleanField(
                        default=False, help_text="실제로 생성되면 True로 바뀌며, 추후 업데이트는 불가능합니다."
                    ),
                ),
                (
                    "total_target",
                    models.IntegerField(default=0, help_text="전체 유저수입니다."),
                ),
                (
                    "valid_target",
                    models.IntegerField(default=0, help_text="쿠폰이 생성 예상되는 유저수입니다."),
                ),
                (
                    "total_created",
                    models.IntegerField(default=0, help_text="쿠폰이 최종적으로 생성된 유저수입니다."),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_coupodiscounttarget",
            },
        ),
        migrations.CreateModel(
            name="CouponDiscountTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField(blank=True, null=True)),
                (
                    "rate",
                    models.FloatField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0.0),
                            django.core.validators.MaxValueValidator(1.0),
                        ],
                    ),
                ),
                ("code", models.CharField(default=None, max_length=20, null=True)),
                (
                    "code_for_devel",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="개발용 코드입니다. 해당 코드에 따라 이벤트 등의 일을 개발합니다.",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "coupon_category",
                    models.IntegerField(
                        choices=[(0, "미정"), (2, "초대코드"), (3, "cs"), (4, "초대호스트")],
                        default=0,
                    ),
                ),
                ("content", models.CharField(blank=True, max_length=100)),
                ("started_at", models.DateTimeField(blank=True, null=True)),
                ("ended_at", models.DateTimeField(blank=True, null=True)),
                ("duration", models.DurationField(blank=True, default=None, null=True)),
                (
                    "used",
                    models.BooleanField(
                        default=True, help_text="사용하지 않을 경우 False처리 해주세요. 편합니다."
                    ),
                ),
                (
                    "min_order_amount",
                    models.IntegerField(
                        blank=True,
                        default=0,
                        help_text="쿠폰을 적용할 수 있는 최소 주문 금액 입니다.",
                        null=True,
                    ),
                ),
                (
                    "max_amount",
                    models.IntegerField(
                        default=100000000,
                        help_text="쿠폰이 최대로 적용될 수 있는 할인 금액 입니다. 입력 하지 않으면 임의의 큰 값으로 자동 설정 됩니다.",
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_coupodiscounttemplate",
                "ordering": ["-id"],
            },
        ),
        migrations.CreateModel(
            name="CustomCalorie",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.FloatField(default=2000, help_text="유저가 커스텀한 칼로리")),
                (
                    "is_instead",
                    models.BooleanField(
                        default=True, help_text="진단 칼로리 대신에 식단 생성에 사용할지에 대한 값"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "health_customcalorie",
            },
        ),
        migrations.CreateModel(
            name="DailyActiveUserLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("method", models.CharField(default="GET", max_length=10)),
                ("path", models.CharField(max_length=255)),
                ("param", models.JSONField(default=dict)),
                ("body", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "accounts_dailyactiveuserlog",
            },
        ),
        migrations.CreateModel(
            name="DayDiet",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("day", models.DateField()),
                ("calorie", models.FloatField(default=0)),
                ("carbohydrate", models.FloatField(default=0)),
                ("protein", models.FloatField(default=0)),
                ("fat", models.FloatField(default=0)),
                (
                    "order_deadline",
                    models.DateTimeField(
                        default=datetime.datetime(
                            2099, 12, 30, 15, 0, tzinfo=datetime.timezone.utc
                        ),
                        help_text="주문마감시간",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "diet_daydiet",
            },
        ),
        migrations.CreateModel(
            name="DayDietDeadlineModification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "diet_started_at",
                    models.DateField(help_text="order_deadline을 수정할 DayDiet 기간의 시작일"),
                ),
                (
                    "diet_ended_at",
                    models.DateField(help_text="order_deadline을 수정할 DayDiet 기간의 종료일"),
                ),
                (
                    "deadline",
                    models.DateTimeField(
                        help_text="시작일~종료일에 해당하는 DayDiet들에 대해 지정해주려는 order_deadline"
                    ),
                ),
                (
                    "change_category",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "물류 대행사의 배송불가"),
                            (2, "입점사의 식품 조달 불가"),
                            (3, "기타"),
                        ],
                        default=0,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "diet_daydietdeadlinemodification",
            },
        ),
        migrations.CreateModel(
            name="DayDietFood",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        default=0,
                    ),
                ),
                ("in_cart", models.BooleanField(default=True)),
                ("is_recommended", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                ("in_diet", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "diet_daydietfood",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodChangeEvent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "diet_daydietfoodchangeevent",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodChangeLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "diet_daydietfoodchangelog",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "log_type",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "구매한 식품"),
                            (2, "직접 추가한 식품"),
                            (3, "기존 식품"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "기록 완료"), (-1, "기록 삭제")], default=0
                    ),
                ),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        default=0,
                    ),
                ),
            ],
            options={
                "db_table": "diary_daydietfoodrecord",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecordFood",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("sku", models.CharField(help_text="재고관리코드", max_length=20, null=True)),
                ("name", models.CharField(max_length=255)),
            ],
            options={
                "db_table": "diary_daydietfoodrecordfood",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecordFoodProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("sku", models.CharField(help_text="재고관리코드", max_length=20, null=True)),
                ("name", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "diary_daydietfoodrecordfoodproduct",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecordImage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        upload_to=shipdan_model.app_model.diary.day_diet_food_product_image_path
                    ),
                ),
                ("code", models.IntegerField(default=100)),
                ("code_index", models.IntegerField(default=0)),
            ],
            options={
                "db_table": "diary_daydietfoodrecordimage",
                "ordering": ["code", "code_index"],
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecordNutrient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "calorie",
                    models.FloatField(blank=True, help_text="100g 기준 칼로리", null=True),
                ),
                (
                    "carbohydrate",
                    models.FloatField(blank=True, help_text="100g 기준 탄수화물", null=True),
                ),
                (
                    "protein",
                    models.FloatField(blank=True, help_text="100g 기준 단백질", null=True),
                ),
                (
                    "fat",
                    models.FloatField(blank=True, help_text="100g 기준 지방", null=True),
                ),
                (
                    "sugar",
                    models.FloatField(blank=True, help_text="100g 기준 당류", null=True),
                ),
                (
                    "sodium",
                    models.FloatField(
                        blank=True, help_text="100g 기준 나트륨, mg으로 넣어주세요", null=True
                    ),
                ),
                (
                    "fiber",
                    models.FloatField(blank=True, help_text="100g 기준 식이섬유", null=True),
                ),
                (
                    "saturated_fat",
                    models.FloatField(blank=True, help_text="100g 기준 포화지방", null=True),
                ),
                (
                    "trans_fat",
                    models.FloatField(blank=True, help_text="100g 기준 트랜스지방", null=True),
                ),
                (
                    "cholesterol",
                    models.FloatField(blank=True, help_text="100g 기준 콜레스테롤", null=True),
                ),
                ("proper_gram", models.FloatField(help_text="한끼 그람 수", null=True)),
            ],
            options={
                "db_table": "diary_daydietfoodrecordnutrient",
            },
        ),
        migrations.CreateModel(
            name="DayDietFoodRecordUnit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(default=1, help_text="낮을 수록 높은 우선 순위"),
                ),
                ("total_gram", models.FloatField(help_text="총 그람 수", null=True)),
                (
                    "unit_gram",
                    models.FloatField(default=None, help_text="유닛 그람 수", null=True),
                ),
                ("total_count", models.IntegerField(help_text="총 개수", null=True)),
                (
                    "count_unit",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "개"),
                            (3, "인분"),
                            (2, "조각"),
                            (4, "캔"),
                            (5, "팩"),
                            (6, "포"),
                            (7, "컵"),
                            (8, "알"),
                            (9, "스푼"),
                        ],
                        help_text="개, 몇인분, 조각 등과 같은 단위",
                        null=True,
                    ),
                ),
                (
                    "gram_unit",
                    models.IntegerField(
                        choices=[(1, "g"), (2, "ml")], default=1, help_text="g, ml"
                    ),
                ),
            ],
            options={
                "db_table": "diary_daydietfoodrecordunit",
            },
        ),
        migrations.CreateModel(
            name="DayDietMealExclusion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "diet_daydietmealexclusion",
            },
        ),
        migrations.CreateModel(
            name="DayDietMealTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("meal", models.IntegerField()),
            ],
            options={
                "db_table": "diet_daydietmealtag",
            },
        ),
        migrations.CreateModel(
            name="DayDietRecord",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("day", models.DateField()),
            ],
            options={
                "db_table": "diary_daydietrecord",
            },
        ),
        migrations.CreateModel(
            name="DayDietSurveyComplete",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("answer", models.IntegerField(help_text="complete 상태")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "diet_survey_daydietsurveycomplete",
            },
        ),
        migrations.CreateModel(
            name="Delivery",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("invoice_no", models.TextField(help_text="운송장번호")),
                ("company_code", models.TextField(blank=True, help_text="택배사 코드")),
                ("item_name", models.TextField(blank=True, help_text="상품 이름")),
                ("address", models.TextField(blank=True, help_text="주소")),
                ("estimate", models.TextField(blank=True, help_text="배송 예정시간")),
                ("complete", models.BooleanField(default=False)),
                ("price", models.IntegerField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "delivery_delivery",
            },
        ),
        migrations.CreateModel(
            name="DeliveryLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "level",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "배송준비"),
                            (2, "집하완료"),
                            (3, "배송진행"),
                            (4, "지점도착"),
                            (5, "배송출발"),
                            (6, "배송도착"),
                            (-99, "배송스캔오류"),
                        ],
                        default=0,
                    ),
                ),
                ("time", models.DateTimeField(blank=True, null=True)),
                ("telno", models.TextField(blank=True, default="")),
                ("manPic", models.TextField(blank=True, default="")),
                ("manName", models.TextField(blank=True, default="")),
                ("remark", models.TextField(blank=True, default="")),
                ("where", models.TextField(blank=True, default="")),
                ("kind", models.TextField(blank=True, default="")),
            ],
            options={
                "db_table": "delivery_deliverylog",
            },
        ),
        migrations.CreateModel(
            name="DeliveryPolicy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.JSONField(default=dict)),
                ("target", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "delivery_deliverypolicy",
            },
        ),
        migrations.CreateModel(
            name="DeployRestTime",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("finished_at", models.DateTimeField()),
                ("code", models.IntegerField(default=-3000)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "core_deployresttime",
            },
        ),
        migrations.CreateModel(
            name="Diagnosis",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("start_weight", models.FloatField()),
                ("start_body_fat", models.FloatField(null=True)),
                ("start_muscle", models.FloatField(null=True)),
                ("started_at", models.DateTimeField(auto_now_add=True)),
                ("goal_weight", models.FloatField(help_text="목표 체중")),
                ("goal_body_fat", models.FloatField(help_text="목표 체지방량", null=True)),
                ("goal_muscle", models.FloatField(help_text="목표 근육량", null=True)),
                ("goal_at", models.DateTimeField()),
                (
                    "recommend_calorie",
                    models.FloatField(help_text="권장 하루 섭취 에너지(kcal)"),
                ),
                ("recommend_protein", models.FloatField(help_text="권장 단백질 섭취량(g)")),
                (
                    "recommend_carbohydrate",
                    models.FloatField(help_text="권장 탄수화물 섭취량(g)"),
                ),
                ("recommend_fat", models.FloatField(help_text="권장 지방 섭취량(g)")),
                ("is_checked", models.BooleanField(default=False)),
            ],
            options={
                "db_table": "health_diagnosis",
            },
        ),
        migrations.CreateModel(
            name="DietBundle",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("target_started_at", models.DateTimeField(default=None, null=True)),
                ("target_ended_at", models.DateTimeField(default=None, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "diet_dietbundle",
            },
        ),
        migrations.CreateModel(
            name="DietFoodSurveyRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "diet_survey_dietfoodsurveyrelation",
            },
        ),
        migrations.CreateModel(
            name="DietMealSurveyRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("meal", models.IntegerField()),
            ],
            options={
                "db_table": "diet_survey_dietmealsurveyrelation",
            },
        ),
        migrations.CreateModel(
            name="DietOrderSurvey",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("question_category", models.IntegerField()),
                ("answer", models.JSONField(default=dict)),
                ("extra", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "diet_survey_dietordersurvey",
            },
        ),
        migrations.CreateModel(
            name="DietOrderSurveyComplete",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("answer", models.IntegerField(help_text="complete 상태")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "diet_survey_dietordersurveycomplete",
            },
        ),
        migrations.CreateModel(
            name="DietOrderSurveyRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "diet_survey_dietordersurveyrelation",
            },
        ),
        migrations.CreateModel(
            name="DietPaymentSchedule",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "등록"),
                            (2, "식단 생성 성공"),
                            (3, "식단 생성 실패"),
                            (4, "결제 성공"),
                            (5, "결제 실패"),
                            (6, "건너뜀"),
                            (7, "결제 취소"),
                            (-1, "해지"),
                        ],
                        default=0,
                        help_text="현재 상태, Log의 비정규화 필드",
                    ),
                ),
                ("payment_at", models.DateTimeField()),
                (
                    "coupon_use",
                    models.BooleanField(default=True, help_text="쿠폰 자동 적용 여부"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_dietpaymentschedule",
            },
        ),
        migrations.CreateModel(
            name="DietPaymentScheduleAddress",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("phone", models.CharField(blank=True, default="", max_length=20)),
                (
                    "orderer",
                    models.CharField(
                        blank=True, default="", help_text="주문자 이름", max_length=20
                    ),
                ),
                ("content", models.TextField(blank=True)),
                ("zonecode", models.CharField(max_length=10, verbose_name="우편번호")),
                ("sido", models.CharField(max_length=10, verbose_name="도/시 이름")),
                ("sigungu", models.CharField(max_length=10, verbose_name="시/군/구 이름")),
                (
                    "bname",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="법정동/법정리 이름"
                    ),
                ),
                ("bcode", models.PositiveBigIntegerField(verbose_name="법정동코드")),
                (
                    "roadAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="도로명"
                    ),
                ),
                (
                    "buildingName",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="건물명"
                    ),
                ),
                (
                    "jibunAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="지번"
                    ),
                ),
                (
                    "autoRoadAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="대체 도로명주소"
                    ),
                ),
                (
                    "extra",
                    models.CharField(
                        blank=True, max_length=100, null=True, verbose_name="상세주소"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_dietpaymentscheduleaddress",
            },
        ),
        migrations.CreateModel(
            name="DietPaymentScheduleLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "등록"),
                            (2, "식단 생성 성공"),
                            (3, "식단 생성 실패"),
                            (4, "결제 성공"),
                            (5, "결제 실패"),
                            (6, "건너뜀"),
                            (7, "결제 취소"),
                            (-1, "해지"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "content",
                    models.TextField(blank=True, default="", max_length=255, null=True),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_dietpaymentschedulelog",
            },
        ),
        migrations.CreateModel(
            name="DietPaymentScheduleProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "사용"), (2, "건너뜀"), (-1, "해지")],
                        default=0,
                        help_text="현재 상태",
                    ),
                ),
                (
                    "coupon_use",
                    models.BooleanField(default=True, help_text="쿠폰 자동 적용 현재 상태"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_dietpaymentscheduleprofile",
            },
        ),
        migrations.CreateModel(
            name="Dish",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="dish 이름, 타입과 같은 것을 사용해주세요", max_length=20
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "주식"), (2, "부식"), (3, "간식")],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "food_dish",
            },
        ),
        migrations.CreateModel(
            name="DislikeCategoryLayerParameter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "group",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "메인"),
                            (2, "단백질"),
                            (3, "간식"),
                            (4, "음료"),
                        ],
                        default=1,
                    ),
                ),
                ("code", models.IntegerField(unique=True)),
                ("display", models.CharField(max_length=20)),
                ("is_shown", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "health_dislikecategorylayerparameter",
            },
        ),
        migrations.CreateModel(
            name="EventCouponCode",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=20, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_payment_eventcouponcode",
            },
        ),
        migrations.CreateModel(
            name="FCMDevice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "device_type",
                    models.IntegerField(
                        choices=[
                            (0, "UNDEFINED"),
                            (1, "ANDROID"),
                            (2, "IOS"),
                            (3, "CHROME"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "dev_id",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=50,
                        null=True,
                        verbose_name="Device ID",
                    ),
                ),
                (
                    "reg_id",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=255,
                        null=True,
                        verbose_name="Registration ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, max_length=255, null=True, verbose_name="Name"
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(default=False, verbose_name="Is active?"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_fcmdevice",
            },
        ),
        migrations.CreateModel(
            name="FCMNotification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "identification_for_check",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="app 패키지 쪽 문제로 {timestamp}_{random range timestamp}로 unique 처리",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="amplitude에 사용될 수 있습니다.",
                        max_length=100,
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True, help_text="제목입니다.", max_length=100, null=True
                    ),
                ),
                (
                    "body",
                    models.CharField(
                        blank=True, help_text="내용입니다.", max_length=255, null=True
                    ),
                ),
                ("message_id", models.CharField(blank=True, max_length=100)),
                (
                    "image",
                    models.TextField(
                        blank=True,
                        help_text="프로필 이미지 등 push msg에 사용되는 큰 아이콘",
                        null=True,
                    ),
                ),
                (
                    "icon",
                    models.TextField(blank=True, help_text="작은 아이콘 이미지", null=True),
                ),
                ("link", models.TextField(blank=True, help_text="딥링크 주소", null=True)),
                (
                    "big_image",
                    models.TextField(
                        blank=True, help_text="큰 이미지 notification에 사용합니다.", null=True
                    ),
                ),
                ("data", models.TextField(blank=True, help_text="데이터 메세지 payload입니다")),
                (
                    "topic",
                    models.CharField(
                        blank=True, default="", help_text="topic입니다", max_length=50
                    ),
                ),
                ("is_checked", models.BooleanField(default=False)),
                (
                    "checked_at",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                ("reserved_at", models.DateTimeField(blank=True, null=True)),
                ("is_sent", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "notification_fcmnotification",
            },
        ),
        migrations.CreateModel(
            name="FCMNotificationCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=20, unique=True)),
                (
                    "name",
                    models.CharField(
                        help_text="유저에게는 보이지 않는 해당 카테고리의 이름이니다", max_length=30
                    ),
                ),
                (
                    "content",
                    models.TextField(
                        blank=True, help_text="유저에게는 보이지 않는 해당 카테고리의 설명입니다"
                    ),
                ),
                (
                    "topic",
                    models.CharField(
                        blank=True, default="", help_text="topic입니다", max_length=50
                    ),
                ),
                (
                    "collapse_key",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "stack",
                    models.IntegerField(
                        choices=[
                            (0, "UNDEFINED"),
                            (1, "ALL_STACK"),
                            (2, "LAST_STACK"),
                            (3, "NO_STACK"),
                        ],
                        default=0,
                    ),
                ),
            ],
            options={
                "db_table": "notification_fcmnotificationcategory",
            },
        ),
        migrations.CreateModel(
            name="FCMNotificationTarget",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="amplitude 이벤트 프로퍼티 및 유저 프로퍼티로 들어갈 값입니다.",
                        max_length=20,
                    ),
                ),
                (
                    "content",
                    models.CharField(
                        blank=True,
                        help_text="해당 타겟 이벤트의 설명입니다. 안적으셔 괜찮습니다.",
                        max_length=100,
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True, help_text="제목입니다.", max_length=100, null=True
                    ),
                ),
                (
                    "body",
                    models.CharField(
                        blank=True, help_text="내용입니다.", max_length=255, null=True
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        blank=True,
                        help_text="앱푸시에 보이는 이미지입니다.",
                        null=True,
                        upload_to=shipdan_model.app_model.notification.fcm_notification_image_path,
                    ),
                ),
                (
                    "data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        help_text="데이터 메세지 payload입니다. 필요시 개발자를 불러주세요!",
                        null=True,
                    ),
                ),
                (
                    "filter_event_tos",
                    models.BooleanField(
                        default=False, help_text="체크 시, 이벤트 수신 미동의 유저는 필터링됩니다."
                    ),
                ),
                ("reserved_at", models.DateTimeField()),
                (
                    "is_sent",
                    models.BooleanField(
                        default=False, help_text="실제로 보내지면 True로 바뀌며, 추후 업데이트는 불가능합니다."
                    ),
                ),
                ("emails", models.TextField(default="", help_text="쉼표 없이 한줄씩 적어주세요!")),
                (
                    "invalid_emails",
                    models.TextField(
                        default="",
                        help_text="유저가 없거나(이메일 잘못기입 혹은 회원탈퇴), fcm 디바이스 등록이 되지 않거나, is active가 False인 유저입니다. 저장 시, 자동으로 기입됩니다. 필터는 적용된 값입니다.",
                    ),
                ),
                (
                    "total_target",
                    models.IntegerField(
                        default=0, help_text="invalid_email 중 필터 빼고 적용한 유저수입니다."
                    ),
                ),
                (
                    "valid_target",
                    models.IntegerField(
                        default=0, help_text="total_target에서 필터를 거치고 남은 유저입니다."
                    ),
                ),
                (
                    "total_sent",
                    models.IntegerField(
                        default=0,
                        help_text="fcm 발송 요청완료 수입니다. 단, 이는 실제로 받은 값은 아닙니다. 실제 유저가 받았는지 안받았는지는 알 수 있는 방법은 없습니다.",
                    ),
                ),
                (
                    "total_viewed",
                    models.IntegerField(default=0, help_text="유저가 해당 fcm을 본 경우입니다."),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "notification_fcmnotificationtarget",
            },
        ),
        migrations.CreateModel(
            name="FirstCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20, unique=True)),
            ],
            options={
                "db_table": "food_firstcategory",
            },
        ),
        migrations.CreateModel(
            name="Food",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sku",
                    models.CharField(
                        default=None,
                        help_text="재고관리코드",
                        max_length=20,
                        null=True,
                        unique=True,
                    ),
                ),
                ("name", models.CharField(help_text="제품명", max_length=50)),
            ],
            options={
                "db_table": "food_food",
            },
        ),
        migrations.CreateModel(
            name="FoodBrand",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField(null=True, unique=True)),
                ("name", models.CharField(max_length=20, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_foodbrand",
            },
        ),
        migrations.CreateModel(
            name="FoodCompany",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField(null=True, unique=True)),
                ("name", models.CharField(max_length=20, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_foodcompany",
            },
        ),
        migrations.CreateModel(
            name="FoodDiscount",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField()),
                ("code", models.IntegerField(blank=True, null=True)),
                (
                    "code_for_devel",
                    models.CharField(
                        blank=True,
                        help_text="개발용 코드입니다. 해당 코드에 따라 이벤트 등의 일을 개발합니다.",
                        max_length=10,
                    ),
                ),
                ("content", models.CharField(blank=True, max_length=100)),
                ("started_at", models.DateTimeField(blank=True, null=True)),
                ("ended_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_payment_fooddiscount",
            },
        ),
        migrations.CreateModel(
            name="FoodGroup",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="그룹 이름, 타입과 같은 것을 사용해주세요", max_length=20
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "탄수화물1군"),
                            (2, "탄수화물2군"),
                            (3, "단백질1군"),
                            (4, "단백질2군"),
                            (5, "탄단군"),
                            (6, "식이섬유군"),
                            (7, "기타1군"),
                            (8, "기타2군"),
                        ],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "food_foodgroup",
            },
        ),
        migrations.CreateModel(
            name="FoodMajorClassification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
            ],
            options={
                "db_table": "food_foodmajorclassification",
            },
        ),
        migrations.CreateModel(
            name="FoodMajorSearchCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=40)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
                ("order", models.IntegerField(default=None, null=True, unique=True)),
                (
                    "img",
                    models.ImageField(
                        default=None,
                        null=True,
                        upload_to=shipdan_model.app_model.food.major_search_category_image_path,
                    ),
                ),
                ("is_representative", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "food_foodmajorsearchcategory",
            },
        ),
        migrations.CreateModel(
            name="FoodOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "주문완료"),
                            (2, "결제완료"),
                            (3, "배달완료"),
                            (-10, "주문취소"),
                            (-20, "문제상황"),
                        ],
                        default=0,
                        help_text="주문에 대한 현재 상태를 의미함. FoodOrderState로 처리하는 것이 join비용이 많이 발생하여, 비정규화함.",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_foodorder",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderAddress",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("zonecode", models.CharField(max_length=10, verbose_name="우편번호")),
                ("sido", models.CharField(max_length=10, verbose_name="도/시 이름")),
                ("sigungu", models.CharField(max_length=10, verbose_name="시/군/구 이름")),
                (
                    "bname",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="법정동/법정리 이름"
                    ),
                ),
                ("bcode", models.PositiveBigIntegerField(verbose_name="법정동코드")),
                (
                    "roadAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="도로명"
                    ),
                ),
                (
                    "buildingName",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="건물명"
                    ),
                ),
                (
                    "jibunAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="지번"
                    ),
                ),
                (
                    "autoRoadAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="대체 도로명주소"
                    ),
                ),
                (
                    "extra",
                    models.CharField(
                        blank=True, max_length=100, null=True, verbose_name="상세주소"
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_foodorderaddress",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderCouponTemporaryRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
            ],
            options={
                "db_table": "food_payment_foodordercoupontemporaryrelation",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderPointTemporaryRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_foodorderpointtemporaryrelation",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderPolicy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.JSONField(default=dict)),
                ("target", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_foodorderpolicy",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderRemark",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("phone", models.CharField(blank=True, default="", max_length=20)),
                (
                    "orderer",
                    models.CharField(
                        blank=True, default="", help_text="주문자 이름", max_length=20
                    ),
                ),
                ("content", models.TextField(blank=True)),
            ],
            options={
                "db_table": "food_payment_foodorderremark",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderSheet",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order_sheet",
                    models.FileField(
                        null=True,
                        upload_to=shipdan_model.app_model.oms.order_sheet_path,
                    ),
                ),
                ("started_at", models.DateTimeField(null=True)),
                ("ended_at", models.DateTimeField(null=True)),
                ("request_shipping_date", models.DateField(null=True)),
            ],
            options={
                "db_table": "oms_foodordersheet",
            },
        ),
        migrations.CreateModel(
            name="FoodOrderState",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "주문완료"),
                            (2, "결제완료"),
                            (3, "배달완료"),
                            (-10, "주문취소"),
                            (-20, "문제상황"),
                        ],
                        default=0,
                    ),
                ),
                ("is_complete", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_payment_foodorderstate",
            },
        ),
        migrations.CreateModel(
            name="FoodProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sku",
                    models.CharField(
                        help_text="재고관리코드", max_length=20, null=True, unique=True
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "price",
                    models.IntegerField(
                        help_text="해당 필드는 변경을 해도 의미가 없습니다. 정해진 시간에 origin price와 pricelog를 확인하여 해당 필드가 자동으로 변합니다.",
                        null=True,
                    ),
                ),
                (
                    "origin_price",
                    models.IntegerField(
                        help_text="static한 최초의 가격입니다. 해당 필드는 변경되어서는 안됩니다. 가격변화를 PriceLog에 생성해주시면, 정해진 시간에 price가 적용됩니다.",
                        null=True,
                    ),
                ),
                ("unit_cost", models.IntegerField(default=None, null=True)),
                ("link", models.URLField(max_length=400, null=True)),
                ("is_available", models.BooleanField(default=True)),
                ("is_shown", models.BooleanField(default=False)),
                ("is_approved", models.BooleanField(default=False)),
                ("barcode", models.CharField(blank=True, default="", max_length=30)),
                (
                    "new_product_until",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        help_text="언제까지 신상품이라는 태그를 가질 지",
                        null=True,
                    ),
                ),
                ("checked_at", models.DateTimeField(blank=True, null=True)),
                (
                    "option_string",
                    models.CharField(
                        blank=True, default="", help_text="스크래퍼를 위한 필드", max_length=30
                    ),
                ),
                ("available_until", models.IntegerField(default=168)),
                (
                    "immediate_sold_out_started_at",
                    models.DateTimeField(help_text="immediate sold out", null=True),
                ),
                (
                    "immediate_sold_out_ended_at",
                    models.DateTimeField(help_text="immediate sold out", null=True),
                ),
                (
                    "feature_major",
                    models.CharField(
                        blank=True, default="", help_text="상세 정보를 위한 필드", max_length=500
                    ),
                ),
                (
                    "feature_sub",
                    models.CharField(blank=True, default="", max_length=1000),
                ),
            ],
            options={
                "db_table": "food_foodproduct",
            },
        ),
        migrations.CreateModel(
            name="FoodProductBlock",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                ("is_blocked", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "health_foodproductblock",
            },
        ),
        migrations.CreateModel(
            name="FoodProductBlockLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_blocked", models.BooleanField(default=True)),
                (
                    "reason",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "너무 매웠어요"),
                            (2, "싫어하는 식재료가 포함돼 있어요"),
                            (3, "맛 없어요"),
                            (4, "양이 적어요"),
                        ],
                        default=0,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "extra",
                    models.CharField(blank=True, default="", max_length=255, null=True),
                ),
            ],
            options={
                "db_table": "health_foodproductblocklog",
            },
        ),
        migrations.CreateModel(
            name="FoodProductBookmark",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_marked", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_foodproductbookmark",
            },
        ),
        migrations.CreateModel(
            name="FoodProductChangeRequest",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "요청생성"),
                            (1, "승인대기"),
                            (2, "요청반려"),
                            (3, "승인완료"),
                            (4, "요청취소"),
                        ]
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_foodproductchangerequest",
            },
        ),
        migrations.CreateModel(
            name="FoodProductChangeRequestContent",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sku",
                    models.CharField(
                        default=None, help_text="재고관리코드", max_length=20, null=True
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "serving_per_product",
                    models.IntegerField(help_text="제품당 제공 횟수", null=True),
                ),
                (
                    "total_gram",
                    models.FloatField(blank=True, help_text="총 g", null=True),
                ),
                ("unit_gram", models.FloatField(help_text="단위 그람 수", null=True)),
                (
                    "gram_unit",
                    models.IntegerField(
                        choices=[(1, "g"), (2, "ml")], default=1, help_text="g, ml"
                    ),
                ),
                ("link", models.URLField(max_length=400, null=True)),
            ],
            options={
                "db_table": "oms_foodproductchangerequestcontent",
            },
        ),
        migrations.CreateModel(
            name="FoodProductChangeRequestImage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        null=True,
                        upload_to=shipdan_model.app_model.oms.change_request_image_path,
                    ),
                ),
                ("code", models.IntegerField(default=100)),
            ],
            options={
                "db_table": "oms_foodproductchangerequestimage",
            },
        ),
        migrations.CreateModel(
            name="FoodProductChangeRequestNutrient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("proper_gram", models.FloatField(help_text="적정 그람 수", null=True)),
                (
                    "calorie",
                    models.FloatField(blank=True, help_text="칼로리(kcal)", null=True),
                ),
                (
                    "carbohydrate",
                    models.FloatField(blank=True, help_text="탄수화물(g)", null=True),
                ),
                (
                    "protein",
                    models.FloatField(blank=True, help_text="단백질(g)", null=True),
                ),
                ("fat", models.FloatField(blank=True, help_text="지방(g)", null=True)),
                ("sugar", models.FloatField(blank=True, help_text="당분(g)", null=True)),
                (
                    "sodium",
                    models.FloatField(blank=True, help_text="나트륨(mg)", null=True),
                ),
                ("fiber", models.FloatField(blank=True, help_text="섬유소(g)", null=True)),
                (
                    "saturated_fat",
                    models.FloatField(blank=True, help_text="포화지방(g)", null=True),
                ),
                (
                    "trans_fat",
                    models.FloatField(blank=True, help_text="트랜스지방(g)", null=True),
                ),
                (
                    "cholesterol",
                    models.FloatField(blank=True, help_text="콜레스테롤(g)", null=True),
                ),
            ],
            options={
                "db_table": "oms_foodproductchangerequestnutrient",
            },
        ),
        migrations.CreateModel(
            name="FoodProductCombo",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("is_available", models.BooleanField(default=True)),
                ("checked_at", models.DateTimeField(blank=True, null=True)),
                ("is_shown", models.BooleanField(default=True)),
                (
                    "price",
                    models.IntegerField(
                        help_text="해당 필드는 변경을 해도 의미가 없습니다. 정해진 시간에 origin price와 pricelog를 확인하여 해당 필드가 자동으로 변합니다.",
                        null=True,
                    ),
                ),
                (
                    "origin_price",
                    models.IntegerField(
                        help_text="static한 최초의 가격입니다. 해당 필드는 변경되어서는 안됩니다. 가격변화를 PriceLog에 생성해주시면, 정해진 시간에 price가 적용됩니다.",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "food_foodproductcombo",
            },
        ),
        migrations.CreateModel(
            name="FoodProductComboRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField()),
            ],
            options={
                "db_table": "food_foodproductcomborelation",
            },
        ),
        migrations.CreateModel(
            name="FoodProductLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        default=0,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "diary_foodproductlog",
            },
        ),
        migrations.CreateModel(
            name="FoodProductOrigin",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "랭킹닭컴"),
                            (2, "쿠팡"),
                            (3, "다노샵"),
                            (4, "다신"),
                            (5, "마이프로틴"),
                            (6, "마켓컬리"),
                            (7, "마이쉽단"),
                        ]
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=20)),
                (
                    "img",
                    models.ImageField(
                        null=True,
                        upload_to=shipdan_model.app_model.food.platform_image_path,
                    ),
                ),
                (
                    "is_shown",
                    models.BooleanField(default=False, help_text="사용자에게 보여질 카테고리"),
                ),
            ],
            options={
                "db_table": "food_foodproductorigin",
            },
        ),
        migrations.CreateModel(
            name="FoodProductSKU",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField(unique=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_foodproductsku",
            },
        ),
        migrations.CreateModel(
            name="FoodProductSurveyRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "diet_survey_foodproductsurveyrelation",
            },
        ),
        migrations.CreateModel(
            name="FoodProductTaste",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("taste", models.IntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "health_foodproducttaste",
            },
        ),
        migrations.CreateModel(
            name="FoodPurchaseOrderSheet",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "purchase_order",
                    models.FileField(
                        null=True,
                        upload_to=shipdan_model.app_model.oms.purchase_order_path,
                    ),
                ),
                ("started_at", models.DateTimeField(null=True)),
                ("ended_at", models.DateTimeField(null=True)),
            ],
            options={
                "db_table": "oms_foodpurchaseordersheet",
            },
        ),
        migrations.CreateModel(
            name="FoodSubClassification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
            ],
            options={
                "db_table": "food_foodsubclassification",
            },
        ),
        migrations.CreateModel(
            name="FoodSubSearchCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=40)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
            ],
            options={
                "db_table": "food_foodsubsearchcategory",
            },
        ),
        migrations.CreateModel(
            name="HealthGoal",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("goal_code", models.IntegerField(default=0)),
                ("weight_goal", models.IntegerField(default=0)),
            ],
            options={
                "db_table": "health_goal",
            },
        ),
        migrations.CreateModel(
            name="HealthProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("height", models.FloatField(help_text="현재 신장", null=True)),
                ("goal_weight", models.FloatField(null=True)),
                (
                    "exercise_time",
                    models.FloatField(default=0, help_text="하루 평균 운동 시간"),
                ),
                (
                    "exercise_intensity",
                    models.FloatField(default=0, help_text="운동 강도", null=True),
                ),
                ("job_activity", models.FloatField(null=True)),
                ("sleep_time", models.FloatField(help_text="단위는 시간", null=True)),
            ],
            options={
                "db_table": "health_profile",
            },
        ),
        migrations.CreateModel(
            name="IamportCancelLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("response", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "payment_iamportcancellog",
            },
        ),
        migrations.CreateModel(
            name="IamportCustomerUid",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "card_name",
                    models.CharField(
                        blank=True, default=None, max_length=20, null=True
                    ),
                ),
                ("customer_uid", models.CharField(max_length=50)),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "등록완료"), (-1, "삭제")], default=0
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "iamport_customeruid",
            },
        ),
        migrations.CreateModel(
            name="IamportOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("price", models.IntegerField()),
                (
                    "imp_uid",
                    models.CharField(
                        default=None, max_length=100, null=True, unique=True
                    ),
                ),
                ("merchant_uid", models.CharField(max_length=100)),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "미결제"), (1, "결제완료"), (-1, "결제취소"), (-20, "결제실패")],
                        default=0,
                    ),
                ),
                ("status_description", models.TextField(blank=True, default="")),
                ("name", models.TextField(verbose_name="주문명")),
                ("is_canceled", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_iamportorder",
            },
        ),
        migrations.CreateModel(
            name="IamportScheduleLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("schedule_at", models.FloatField(max_length=60)),
                (
                    "phone_number",
                    models.CharField(blank=True, max_length=15, null=True),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_iamportschedulelog",
            },
        ),
        migrations.CreateModel(
            name="IamportWebhookLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("receipt", models.JSONField(default=dict)),
                (
                    "status",
                    models.IntegerField(
                        choices=[(1, "가상계좌발급완료"), (2, "결제완료"), (3, "결제취소"), (4, "결제실패")]
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "payment_iamportwebhooklog",
            },
        ),
        migrations.CreateModel(
            name="InvitationCouponCode",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.CharField(max_length=20, unique=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_payment_invitationcouponcode",
            },
        ),
        migrations.CreateModel(
            name="KakaoAlimTalk",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("tpl_code", models.TextField(verbose_name="템플릿코드")),
                ("senddate", models.DateTimeField(blank=True, default=None, null=True)),
                ("subject", models.CharField(max_length=50, verbose_name="알림톡제목")),
                ("message", models.TextField(verbose_name="알림톡내용")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("is_sent", models.BooleanField(default=False)),
                ("is_canceled", models.BooleanField(default=False)),
                (
                    "mid",
                    models.IntegerField(
                        help_text="알림톡 전송 시 response 중 message id", null=True
                    ),
                ),
            ],
            options={
                "db_table": "notification_kakaoalimtalk",
            },
        ),
        migrations.CreateModel(
            name="KakaoTemplate",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("templtName", models.CharField(max_length=100, verbose_name="템플릿이름")),
                ("templtContent", models.TextField(verbose_name="템플릿콘텐츠")),
                (
                    "status",
                    models.CharField(
                        choices=[("S", "중단"), ("A", "정상"), ("R", "대기")],
                        max_length=3,
                        verbose_name="승인상태",
                    ),
                ),
                ("templtCode", models.TextField(verbose_name="템플릿코드")),
                ("cdate", models.TextField(verbose_name="템플릿 생성일")),
                ("senderKey", models.TextField(default="", null=True)),
            ],
            options={
                "db_table": "notification_kakaotemplate",
            },
        ),
        migrations.CreateModel(
            name="KakaoTemplateButton",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("ordering", models.CharField(max_length=100, verbose_name="순서")),
                ("name", models.CharField(max_length=100, verbose_name="버튼명")),
                ("linkTypeName", models.CharField(max_length=20, verbose_name="버튼타입명")),
                (
                    "linkType",
                    models.CharField(
                        choices=[
                            ("DS", "배송조희"),
                            ("WL", "웹링크"),
                            ("AL", "앱링크"),
                            ("BK", "봇키워드"),
                            ("MD", "메세지전달"),
                        ],
                        max_length=5,
                        verbose_name="버튼타입",
                    ),
                ),
                ("linkMo", models.TextField(blank=True, verbose_name="모바일웹링크")),
                ("linkPc", models.TextField(blank=True, verbose_name="PC웹링크")),
                ("linkIos", models.TextField(blank=True, verbose_name="IOS앱링크")),
                ("linkAnd", models.TextField(blank=True, verbose_name="안드로이드앱링크")),
            ],
            options={
                "db_table": "notification_kakaotemplatebutton",
            },
        ),
        migrations.CreateModel(
            name="KakaoTemplateVariable",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20, verbose_name="변수명")),
            ],
            options={
                "db_table": "notification_kakaotemplatevariable",
            },
        ),
        migrations.CreateModel(
            name="KeyForResetPassword",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("key", models.CharField(max_length=6)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("is_available", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "accounts_keyforresetpassword",
            },
        ),
        migrations.CreateModel(
            name="MainNotice",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(help_text="공지 제목", max_length=20)),
                (
                    "sub_title",
                    models.CharField(blank=True, help_text="서브 타이틀", max_length=20),
                ),
                (
                    "analytics_property",
                    models.CharField(
                        help_text="엠플리튜드 등 분석툴에서 사용할 user property나 event property에 들어갈 내용. 30자 이내로 영어로 작석바람",
                        max_length=30,
                    ),
                ),
                ("content", models.TextField(blank=True, default="")),
                (
                    "background_img",
                    models.ImageField(
                        blank=True,
                        default=None,
                        help_text="이미지, 현재는 사용계획 없음",
                        null=True,
                        upload_to="mainnotice/background_img",
                    ),
                ),
                (
                    "is_seen",
                    models.BooleanField(
                        default=False,
                        help_text="started_at, ended_at과 더불어 is_seen도 체크 되어야 유저가 봄",
                    ),
                ),
                (
                    "web_seen",
                    models.BooleanField(default=True, help_text="web에서 볼지 안볼지"),
                ),
                (
                    "ios_seen",
                    models.BooleanField(default=True, help_text="ios에서 볼지 안볼지"),
                ),
                (
                    "android_seen",
                    models.BooleanField(default=True, help_text="android에서 볼지 안볼지"),
                ),
                ("started_at", models.DateTimeField(help_text="시작시간")),
                ("ended_at", models.DateTimeField(help_text="끝시간")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "until_code",
                    models.IntegerField(
                        choices=[(0, "영원히"), (1, "일"), (2, "주"), (3, "월")]
                    ),
                ),
                ("until_amount", models.PositiveSmallIntegerField(default=1)),
                ("style", models.JSONField(default=dict)),
                (
                    "link_to",
                    models.TextField(
                        blank=True, default=None, help_text="자세히 보기 주소", null=True
                    ),
                ),
            ],
            options={
                "db_table": "notification_mainnotice",
            },
        ),
        migrations.CreateModel(
            name="MainNoticeButton",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[(1, "닫기"), (2, "그만보기"), (3, "자세히 보기 등")]
                    ),
                ),
                (
                    "content",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="버튼안에 들어갈 글입니다. theme 상황에 따라 안적으셔도 됩니다.",
                        max_length=30,
                    ),
                ),
                ("theme", models.PositiveSmallIntegerField(default=1)),
                ("style", models.JSONField(default=dict)),
            ],
            options={
                "db_table": "notification_mainnoticebutton",
            },
        ),
        migrations.CreateModel(
            name="MainNoticeUserLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("first_viewed", models.DateTimeField(auto_now_add=True)),
                (
                    "never_shown_until",
                    models.DateTimeField(
                        blank=True,
                        default=None,
                        help_text="다시보지 않기를 눌렀을 경우 시간 기입",
                        null=True,
                    ),
                ),
            ],
            options={
                "db_table": "notification_mainnoticeuserlog",
            },
        ),
        migrations.CreateModel(
            name="MealExclusion",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "health_mealexclusion",
            },
        ),
        migrations.CreateModel(
            name="MealTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20, null=True, unique=True)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
            ],
            options={
                "db_table": "diet_mealtag",
            },
        ),
        migrations.CreateModel(
            name="Muscle",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.FloatField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "health_muscle",
            },
        ),
        migrations.CreateModel(
            name="Nutrient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "calorie",
                    models.FloatField(blank=True, help_text="100g 기준 칼로리", null=True),
                ),
                (
                    "carbohydrate",
                    models.FloatField(blank=True, help_text="100g 기준 탄수화물", null=True),
                ),
                (
                    "protein",
                    models.FloatField(blank=True, help_text="100g 기준 단백질", null=True),
                ),
                (
                    "fat",
                    models.FloatField(blank=True, help_text="100g 기준 지방", null=True),
                ),
                (
                    "sugar",
                    models.FloatField(blank=True, help_text="100g 기준 당류", null=True),
                ),
                (
                    "sodium",
                    models.FloatField(
                        blank=True, help_text="100g 기준 나트륨, mg으로 넣어주세요", null=True
                    ),
                ),
                (
                    "fiber",
                    models.FloatField(blank=True, help_text="100g 기준 식이섬유", null=True),
                ),
                (
                    "saturated_fat",
                    models.FloatField(blank=True, help_text="100g 기준 포화지방", null=True),
                ),
                (
                    "trans_fat",
                    models.FloatField(blank=True, help_text="100g 기준 트랜스지방", null=True),
                ),
                (
                    "cholesterol",
                    models.FloatField(blank=True, help_text="100g 기준 콜레스테롤", null=True),
                ),
                ("proper_gram", models.FloatField(help_text="한끼 그람 수", null=True)),
            ],
            options={
                "db_table": "food_nutrient",
            },
        ),
        migrations.CreateModel(
            name="OnboardingAB",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("version", models.CharField(max_length=20)),
                ("code", models.IntegerField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "accounts_onboardingab",
            },
        ),
        migrations.CreateModel(
            name="OnboardingFinish",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "accounts_onboardingfinish",
            },
        ),
        migrations.CreateModel(
            name="OnboardingProcess",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                (
                    "prev_swiper",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                (
                    "next_swiper",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                (
                    "prev_page",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                (
                    "next_page",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                ("is_used", models.BooleanField(default=True)),
                ("is_question", models.BooleanField(default=True)),
                (
                    "ordering",
                    models.IntegerField(default=None, help_text="카테고리 내 순서", null=True),
                ),
            ],
            options={
                "db_table": "accounts_onboardingprocess",
            },
        ),
        migrations.CreateModel(
            name="OnboardingProcessCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=50, unique=True)),
                ("display_name", models.CharField(max_length=50)),
                (
                    "ordering",
                    models.IntegerField(
                        default=None, help_text="카테고리의 순서", null=True, unique=True
                    ),
                ),
                ("is_shown_step", models.BooleanField(default=False)),
            ],
            options={
                "db_table": "accounts_onboardingprocesscategory",
            },
        ),
        migrations.CreateModel(
            name="OnboardingProcessUserRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("answer", models.TextField(blank=True, default="")),
            ],
            options={
                "db_table": "accounts_onboardingprocessuserrelation",
            },
        ),
        migrations.CreateModel(
            name="OperationCompanyInfo",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email_address", models.CharField(max_length=50)),
            ],
            options={
                "db_table": "oms_operationcompanyinfo",
            },
        ),
        migrations.CreateModel(
            name="OperationProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, default="", max_length=10)),
                ("phone", models.CharField(blank=True, default="", max_length=20)),
                (
                    "contact_email",
                    models.EmailField(
                        blank=True,
                        default="",
                        help_text="실제 연락 받을 이메일입니다.",
                        max_length=254,
                    ),
                ),
                (
                    "authority",
                    models.IntegerField(
                        choices=[
                            (1, "shipdan_owner"),
                            (2, "shipdan_member"),
                            (3, "seller_owner"),
                            (4, "seller_member"),
                        ]
                    ),
                ),
            ],
            options={
                "db_table": "oms_operationprofile",
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order_type",
                    models.IntegerField(
                        choices=[(1, "PG")], default=1, help_text="결제 방법"
                    ),
                ),
                (
                    "merchant_uid",
                    models.CharField(
                        blank=True, default=None, max_length=30, null=True, unique=True
                    ),
                ),
                ("imp_uid", models.CharField(blank=True, default="", max_length=100)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("total_price", models.IntegerField(null=True)),
                (
                    "deadline",
                    models.DateTimeField(
                        default=datetime.datetime(
                            2099, 12, 30, 15, 0, tzinfo=datetime.timezone.utc
                        ),
                        help_text="주문마감시간",
                    ),
                ),
            ],
            options={
                "db_table": "payment_order",
            },
        ),
        migrations.CreateModel(
            name="OrderCouponRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_ordercouponrelation",
            },
        ),
        migrations.CreateModel(
            name="OrderDayDietFoodLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                ("price", models.IntegerField()),
                ("unit_cost", models.IntegerField(default=0)),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        default=0,
                    ),
                ),
                ("is_purchased", models.BooleanField(default=False)),
                ("is_recommended", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_orderdaydietfoodlog",
            },
        ),
        migrations.CreateModel(
            name="OrderDayDietLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("day", models.DateField()),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "order_deadline",
                    models.DateTimeField(
                        default=datetime.datetime(
                            2099, 12, 30, 15, 0, tzinfo=datetime.timezone.utc
                        ),
                        help_text="주문마감시간",
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_orderdaydietlog",
            },
        ),
        migrations.CreateModel(
            name="OrderDeadlineModification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order_started_at",
                    models.DateField(help_text="order 기간의 시작일(월요일로 설정)"),
                ),
                (
                    "order_ended_at",
                    models.DateField(
                        help_text="order기간의 종료일(자동으로 일요일로 계산함)", null=True
                    ),
                ),
                (
                    "first_deadline",
                    models.DateTimeField(help_text="기존 금 12시 주문 마감일 -> 변경할 datetime"),
                ),
                (
                    "second_deadline",
                    models.DateTimeField(help_text="기존 차주 월 0시 주문 마감일 -> 변경할 datetime"),
                ),
                (
                    "change_category",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "물류 대행사의 배송불가"),
                            (2, "입점사의 식품 조달 불가"),
                            (3, "기타"),
                        ],
                        default=0,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "payment_order_deadlinemodification",
            },
        ),
        migrations.CreateModel(
            name="OrderDeliveryRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "food_payment_orderdeliveryrelation",
            },
        ),
        migrations.CreateModel(
            name="OrderFoodProductRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("price", models.IntegerField(default=0, null=True)),
                ("quantity", models.IntegerField()),
            ],
            options={
                "db_table": "food_payment_orderfoodproductrelation",
            },
        ),
        migrations.CreateModel(
            name="OrderPaymentNoti",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_noti", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "payment_orderpaymentnoti",
            },
        ),
        migrations.CreateModel(
            name="OrderPointRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_orderpointrelation",
            },
        ),
        migrations.CreateModel(
            name="OrderReleaseOrderInformation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_canceled", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_orderreleaseorderinformation",
            },
        ),
        migrations.CreateModel(
            name="Point",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "category",
                    models.IntegerField(
                        choices=[(0, "미정"), (2, "구매"), (1, "이벤트")], default=0
                    ),
                ),
                ("total_amount", models.IntegerField(null=True)),
                ("remain_amount", models.IntegerField(null=True)),
                (
                    "is_usable",
                    models.BooleanField(
                        help_text="사용 가능 여부입니다. 적립 예정과 적립 완료의 상태를 분리하기 위한 필드입니다."
                    ),
                ),
                ("available_at", models.DateTimeField(help_text="이용 가능한 날짜입니다.")),
                ("expired_at", models.DateTimeField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_point",
            },
        ),
        migrations.CreateModel(
            name="PointLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.IntegerField(null=True)),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "적립 예정"),
                            (2, "적립 완료"),
                            (3, "적립 취소"),
                            (4, "사용"),
                            (5, "사용 취소"),
                            (6, "기한 만료"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "content",
                    models.CharField(
                        blank=True,
                        help_text="적립금 목록에 보여지는 내용입니다.",
                        max_length=100,
                        null=True,
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_pointlog",
            },
        ),
        migrations.CreateModel(
            name="PointPolicy",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.JSONField(default=dict)),
                ("target", models.CharField(max_length=255)),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "food_payment_pointpolicy",
            },
        ),
        migrations.CreateModel(
            name="PossibleAddress",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("zonecode", models.CharField(max_length=10, verbose_name="우편번호")),
                ("sido", models.CharField(max_length=10, verbose_name="도/시 이름")),
                ("sigungu", models.CharField(max_length=10, verbose_name="시/군/구 이름")),
                (
                    "bcode",
                    models.PositiveBigIntegerField(unique=True, verbose_name="법정동코드"),
                ),
                (
                    "bname",
                    models.CharField(
                        blank=True, max_length=20, null=True, verbose_name="법정동/법정리 이름"
                    ),
                ),
                (
                    "roadAddress",
                    models.CharField(
                        blank=True, max_length=50, null=True, verbose_name="도로명"
                    ),
                ),
                ("is_possible", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "delivery_possibleaddress",
            },
        ),
        migrations.CreateModel(
            name="PreferenceFoodCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[
                            (1, "닭고기"),
                            (2, "돼지고기"),
                            (3, "소고기"),
                            (4, "수산식품"),
                            (5, "빵"),
                            (6, "샌드위치"),
                            (7, "디저트"),
                            (8, "분식"),
                            (9, "샐러드"),
                            (10, "도시락"),
                            (11, "볶음밥"),
                            (12, "면류"),
                            (13, "유제품"),
                            (14, "과자"),
                            (15, "시리얼"),
                            (16, "견과류"),
                            (17, "음료"),
                            (18, "탄산음료"),
                            (19, "과채주스"),
                            (20, "보충제 음료"),
                        ],
                        unique=True,
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=20, null=True)),
                (
                    "text",
                    models.CharField(
                        blank=True, help_text="사용자에게 보여질 텍스트", max_length=50, null=True
                    ),
                ),
            ],
            options={
                "db_table": "health_preference_foodcategory",
            },
        ),
        migrations.CreateModel(
            name="PriceLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "price",
                    models.IntegerField(
                        default=None,
                        help_text="해당 필드는 어드민에서 변경하면 안됩니다. 변경 시, 시스템에 큰 혼란이 오게 됩니다. (사실, log가 사라지는 거지, 문제가 되진 않지만 여튼 변경하거나 삭제하면 안됨!)",
                        null=True,
                    ),
                ),
                ("code", models.IntegerField(null=True)),
                ("content", models.CharField(blank=True, default="", max_length=100)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "food_pricelog",
            },
        ),
        migrations.CreateModel(
            name="ProductExceptDay",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "day",
                    models.IntegerField(
                        choices=[
                            (0, "월"),
                            (1, "화"),
                            (2, "수"),
                            (3, "목"),
                            (4, "금"),
                            (5, "토"),
                            (6, "일"),
                        ],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "food_productexceptday",
            },
        ),
        migrations.CreateModel(
            name="ProductImage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "image",
                    models.ImageField(
                        upload_to=shipdan_model.app_model.food.product_image_path
                    ),
                ),
                ("code", models.IntegerField(default=100)),
                ("code_index", models.IntegerField(default=0)),
            ],
            options={
                "db_table": "food_productimage",
                "ordering": ["code", "code_index"],
            },
        ),
        migrations.CreateModel(
            name="PushRoutine",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                (
                    "days",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(
                            choices=[
                                (0, "월"),
                                (1, "화"),
                                (2, "수"),
                                (3, "목"),
                                (4, "금"),
                                (5, "토"),
                                (6, "일"),
                            ]
                        ),
                        size=None,
                    ),
                ),
                (
                    "sent_at",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.TimeField(), size=None
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_pushroutine",
            },
        ),
        migrations.CreateModel(
            name="PushRoutineCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField(unique=True)),
                (
                    "name",
                    models.CharField(
                        default=None, max_length=50, null=True, unique=True
                    ),
                ),
                ("title", models.CharField(max_length=300)),
                ("body", models.CharField(max_length=300)),
                ("description", models.CharField(max_length=200)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_pushroutinecategory",
            },
        ),
        migrations.CreateModel(
            name="PushRoutineCronLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("code", models.IntegerField()),
                ("name", models.CharField(default=None, max_length=50, null=True)),
                ("sent_at", models.DateTimeField()),
                (
                    "res",
                    models.JSONField(
                        default={},
                        help_text="일단 어떻게 사용할지 모르겠어서, 저장. 이것 보단 publish에 대해 저장을 해야할 것 같음.",
                    ),
                ),
            ],
            options={
                "db_table": "notification_pushroutinecronlog",
            },
        ),
        migrations.CreateModel(
            name="ReferenceFatSecret",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.JSONField(default=dict)),
                ("code", models.CharField(help_text="food_id", max_length=100)),
            ],
            options={
                "db_table": "food_referencefatsecret",
            },
        ),
        migrations.CreateModel(
            name="ReferenceFood",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("brand", models.CharField(blank=True, default="", max_length=255)),
                ("company", models.CharField(blank=True, default="", max_length=255)),
            ],
            options={
                "db_table": "food_referencefood",
            },
        ),
        migrations.CreateModel(
            name="ReferenceFoodNutrient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "calorie",
                    models.FloatField(blank=True, help_text="100g 기준 칼로리", null=True),
                ),
                (
                    "carbohydrate",
                    models.FloatField(blank=True, help_text="100g 기준 탄수화물", null=True),
                ),
                (
                    "protein",
                    models.FloatField(blank=True, help_text="100g 기준 단백질", null=True),
                ),
                (
                    "fat",
                    models.FloatField(blank=True, help_text="100g 기준 지방", null=True),
                ),
                (
                    "sugar",
                    models.FloatField(blank=True, help_text="100g 기준 당류", null=True),
                ),
                (
                    "sodium",
                    models.FloatField(
                        blank=True, help_text="100g 기준 나트륨, mg으로 넣어주세요", null=True
                    ),
                ),
                (
                    "fiber",
                    models.FloatField(blank=True, help_text="100g 기준 식이섬유", null=True),
                ),
                (
                    "saturated_fat",
                    models.FloatField(blank=True, help_text="100g 기준 포화지방", null=True),
                ),
                (
                    "trans_fat",
                    models.FloatField(blank=True, help_text="100g 기준 트랜스지방", null=True),
                ),
                (
                    "cholesterol",
                    models.FloatField(blank=True, help_text="100g 기준 콜레스테롤", null=True),
                ),
                ("proper_gram", models.FloatField(help_text="한끼 그람 수", null=True)),
            ],
            options={
                "db_table": "food_referencefoodnutrient",
            },
        ),
        migrations.CreateModel(
            name="ReferenceFoodProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "tsv_name",
                    django.contrib.postgres.search.SearchVectorField(
                        help_text="Gin index 적용을 위한 필드", null=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "food_referencefoodproduct",
            },
        ),
        migrations.CreateModel(
            name="ReferenceFoodUnit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(default=1, help_text="낮을 수록 높은 우선 순위"),
                ),
                ("total_gram", models.FloatField(help_text="총 그람 수", null=True)),
                (
                    "unit_gram",
                    models.FloatField(default=None, help_text="유닛 그람 수", null=True),
                ),
                ("total_count", models.IntegerField(help_text="총 개수", null=True)),
                (
                    "count_unit",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "개"),
                            (3, "인분"),
                            (2, "조각"),
                            (4, "캔"),
                            (5, "팩"),
                            (6, "포"),
                            (7, "컵"),
                            (8, "알"),
                            (9, "스푼"),
                        ],
                        help_text="개, 몇인분, 조각 등과 같은 단위",
                        null=True,
                    ),
                ),
                (
                    "gram_unit",
                    models.IntegerField(
                        choices=[(1, "g"), (2, "ml")], default=1, help_text="g, ml"
                    ),
                ),
            ],
            options={
                "db_table": "food_referencefoodunit",
            },
        ),
        migrations.CreateModel(
            name="ReferenceSafetyKorea",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("data", models.JSONField(default=dict)),
                ("code", models.CharField(help_text="식품코드", max_length=100)),
            ],
            options={
                "db_table": "food_referencesafetykorea",
            },
        ),
        migrations.CreateModel(
            name="ReleaseOrder",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "order_date",
                    models.DateTimeField(
                        auto_created=True, help_text="발주 등록 일시", null=True
                    ),
                ),
                (
                    "order_code",
                    models.CharField(
                        default=None, help_text="오더 코드", max_length=20, null=True
                    ),
                ),
                (
                    "company_order_code",
                    models.CharField(help_text="주문번호", max_length=100),
                ),
                (
                    "shipping_method",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "택배"),
                            (2, "직송"),
                            (3, "새벽배송"),
                            (4, "당일배송"),
                        ],
                        default=3,
                    ),
                ),
                (
                    "order_status",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "출고 요청 전"),
                            (2, "출고 요청"),
                            (3, "송장 등록 완료"),
                            (4, "출고 완료"),
                            (5, "출고 취소"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "request_shipping_dt",
                    models.CharField(
                        help_text="출고 희망일 (YYYYMMDD), 과거 날짜 불가", max_length=8
                    ),
                ),
                (
                    "buyer_name",
                    models.CharField(
                        default="마이쉽단", help_text="주문자명", max_length=100, null=True
                    ),
                ),
                ("receiver_name", models.CharField(help_text="받는분 이름", max_length=100)),
                ("tel1", models.CharField(help_text="받는분 전화번호1", max_length=20)),
                (
                    "tel2",
                    models.CharField(help_text="받는분 전화번호2", max_length=20, null=True),
                ),
                (
                    "zipcode",
                    models.CharField(help_text="받는분 우편번호", max_length=20, null=True),
                ),
                (
                    "shipping_address1",
                    models.CharField(help_text="받는분 주소1", max_length=150),
                ),
                (
                    "shipping_address2",
                    models.CharField(help_text="받는분 주소2", max_length=150, null=True),
                ),
                (
                    "shipping_message",
                    models.CharField(help_text="배송메세지", max_length=150, null=True),
                ),
                ("channel_id", models.IntegerField(help_text="발주 타입 id", null=True)),
                ("memo1", models.CharField(help_text="관리메모1", max_length=500)),
                ("memo2", models.CharField(help_text="관리메모2", max_length=500)),
                ("memo3", models.CharField(help_text="관리메모3", max_length=500)),
                ("memo4", models.CharField(help_text="관리메모4", max_length=500)),
                ("memo5", models.CharField(help_text="관리메모5", max_length=500)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_releaseorder",
            },
        ),
        migrations.CreateModel(
            name="ReleaseOrderItem",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField(default=1)),
                (
                    "item_cd1",
                    models.CharField(
                        blank=True, help_text="상품별 메모1", max_length=50, null=True
                    ),
                ),
                (
                    "item_cd2",
                    models.CharField(
                        blank=True, help_text="상품별 메모2", max_length=50, null=True
                    ),
                ),
                (
                    "item_cd3",
                    models.CharField(
                        blank=True, help_text="상품별 메모3", max_length=50, null=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_releaseorderitem",
            },
        ),
        migrations.CreateModel(
            name="SalesProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "product_id",
                    models.IntegerField(
                        help_text="사방넷 sales_product id", null=True, unique=True
                    ),
                ),
                (
                    "name",
                    models.CharField(help_text="판매상품명", max_length=100, unique=True),
                ),
                (
                    "code",
                    models.CharField(help_text="고유코드", max_length=100, unique=True),
                ),
                (
                    "manage_code1",
                    models.CharField(
                        blank=True, help_text="관리키워드1", max_length=30, null=True
                    ),
                ),
                (
                    "manage_code2",
                    models.CharField(
                        blank=True, help_text="관리키워드2", max_length=30, null=True
                    ),
                ),
                (
                    "manage_code3",
                    models.CharField(
                        blank=True, help_text="관리키워드3", max_length=30, null=True
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True, help_text="상품 설명", max_length=255, null=True
                    ),
                ),
                (
                    "status",
                    models.BooleanField(default=True, help_text="활성화 여부", null=True),
                ),
                (
                    "use_display_period",
                    models.BooleanField(
                        default=True, help_text="유효기간 사용 여부", null=True
                    ),
                ),
                (
                    "start_dt",
                    models.CharField(
                        help_text="유효기간 시작일 (YYYYMMDD)", max_length=8, null=True
                    ),
                ),
                (
                    "end_dt",
                    models.CharField(
                        help_text="유효기간 종료일 (YYYYMMDD)", max_length=8, null=True
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_salesproduct",
            },
        ),
        migrations.CreateModel(
            name="SalesProductShippingProductRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("quantity", models.IntegerField(default=1)),
            ],
            options={
                "db_table": "oms_salesproductshippingproductrelation",
            },
        ),
        migrations.CreateModel(
            name="SampleMeal",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("instance_id", models.IntegerField(null=True)),
                ("combination_code", models.IntegerField(default=0)),
                ("sampling_id", models.IntegerField(null=True, unique=True)),
                ("calorie", models.FloatField(default=0)),
                ("carbohydrate", models.FloatField(default=0)),
                ("protein", models.FloatField(default=0)),
                ("fat", models.FloatField(default=0)),
                ("sodium", models.FloatField(default=0)),
                ("sugar", models.FloatField(default=0)),
                (
                    "total_price",
                    models.IntegerField(blank=True, default=None, null=True),
                ),
                (
                    "state",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "좋음"), (2, "문제 상황"), (3, "임의로 가림")],
                        default=1,
                    ),
                ),
            ],
            options={
                "db_table": "diet_samplemeal",
            },
        ),
        migrations.CreateModel(
            name="SampleMealExceptDay",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "day",
                    models.IntegerField(
                        choices=[
                            (0, "월"),
                            (1, "화"),
                            (2, "수"),
                            (3, "목"),
                            (4, "금"),
                            (5, "토"),
                            (6, "일"),
                        ],
                        unique=True,
                    ),
                ),
            ],
            options={
                "db_table": "diet_samplemealfoodexceptday",
            },
        ),
        migrations.CreateModel(
            name="SampleMealFood",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("sample_meal_instance_id", models.IntegerField(null=True)),
                ("count", models.IntegerField(default=1)),
            ],
            options={
                "db_table": "diet_samplemealfood",
            },
        ),
        migrations.CreateModel(
            name="SearchFoodProductLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("keyword", models.CharField(max_length=255)),
                (
                    "status",
                    models.IntegerField(
                        choices=[(0, "미정"), (2, "검색 완료"), (1, "검색 삭제")], default=0
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "db_table": "diary_searchfoodproductlog",
            },
        ),
        migrations.CreateModel(
            name="SecondCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
            ],
            options={
                "db_table": "food_secondcategory",
            },
        ),
        migrations.CreateModel(
            name="SendAllFCMLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("total_message_count", models.IntegerField()),
                ("success_message_count", models.IntegerField()),
                ("fail_message_count", models.IntegerField()),
                ("time_to_send_all", models.FloatField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="ShippingProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "product_id",
                    models.IntegerField(
                        help_text="사방넷 shipping_product id", null=True, unique=True
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="product_name", max_length=100, unique=True
                    ),
                ),
                (
                    "code",
                    models.CharField(
                        help_text="product_code", max_length=20, unique=True
                    ),
                ),
                (
                    "upc",
                    models.CharField(
                        blank=True, help_text="대표 바코드", max_length=50, null=True
                    ),
                ),
                (
                    "manage_code1",
                    models.CharField(
                        blank=True, help_text="관리키워드1", max_length=30, null=True
                    ),
                ),
                (
                    "manage_code2",
                    models.CharField(
                        blank=True, help_text="관리키워드2", max_length=30, null=True
                    ),
                ),
                (
                    "manage_code3",
                    models.CharField(
                        blank=True, help_text="관리키워드3", max_length=30, null=True
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True, help_text="상품 설명", max_length=250, null=True
                    ),
                ),
                ("single_width", models.IntegerField(help_text="낱개-가로(mm)", null=True)),
                (
                    "single_length",
                    models.IntegerField(help_text="낱개-세로(mm)", null=True),
                ),
                (
                    "single_height",
                    models.IntegerField(help_text="낱개-높이(mm)", null=True),
                ),
                ("box_width", models.IntegerField(help_text="카톤박스-가로(mm)", null=True)),
                ("box_length", models.IntegerField(help_text="카톤박스-세로(mm)", null=True)),
                ("box_height", models.IntegerField(help_text="카톤박스-높이(mm)", null=True)),
                ("box_weight", models.IntegerField(help_text="카톤박스-무게(g)", null=True)),
                ("single_eta", models.IntegerField(help_text="카톤박스-낱개입수", null=True)),
                ("palet_count", models.IntegerField(help_text="팔레트 입수", null=True)),
                (
                    "use_expire_date",
                    models.BooleanField(
                        default=False, help_text="유통기한 사용 여부", null=True
                    ),
                ),
                (
                    "use_make_date",
                    models.BooleanField(
                        default=False, help_text="제조일자 사용 여부", null=True
                    ),
                ),
                (
                    "expire_date_by_make_date",
                    models.IntegerField(help_text="제조일로부터 일수", null=True),
                ),
                (
                    "warning_expire_date",
                    models.IntegerField(help_text="임박재고 전환 기준일", null=True),
                ),
                (
                    "restricted_expire_date",
                    models.IntegerField(help_text="출고불가 기준일", null=True),
                ),
                (
                    "edit_code",
                    models.CharField(help_text="출고편집코드", max_length=20, null=True),
                ),
                (
                    "max_quantity_per_box",
                    models.IntegerField(help_text="최대합포장 수량", null=True),
                ),
                (
                    "status",
                    models.BooleanField(default=True, help_text="활성화 여부", null=True),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_shippingproduct",
            },
        ),
        migrations.CreateModel(
            name="ShippingProductBarcode",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("barcode", models.CharField(help_text="바코드", max_length=100)),
                ("quantity", models.IntegerField(default=1)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_shippingproductbarcode",
            },
        ),
        migrations.CreateModel(
            name="SMSNotification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("receiver", models.CharField(max_length=20, verbose_name="수신자")),
                ("id_aligo", models.IntegerField(null=True)),
                ("content", models.TextField()),
                (
                    "destination",
                    models.CharField(blank=True, max_length=20, verbose_name="고객명"),
                ),
                ("reserved_at", models.DateTimeField(null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "status",
                    models.IntegerField(
                        choices=[
                            (0, "발송대기"),
                            (1, "발송완료"),
                            (2, "예약발송"),
                            (-1, "발송실패"),
                            (-2, "발송실패확인"),
                        ],
                        default=0,
                    ),
                ),
            ],
            options={
                "db_table": "notification_smsnotification",
            },
        ),
        migrations.CreateModel(
            name="SMSNotificationMessage",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=50, verbose_name="제목")),
                ("content", models.TextField(verbose_name="내용")),
            ],
            options={
                "db_table": "notification_smsnotificationmessage",
            },
        ),
        migrations.CreateModel(
            name="StorageMethod",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "code",
                    models.IntegerField(
                        choices=[(0, "냉동"), (1, "냉장"), (2, "상온"), (3, "실온")], default=0
                    ),
                ),
                ("name", models.CharField(max_length=5)),
            ],
            options={
                "db_table": "food_storagemethod",
            },
        ),
        migrations.CreateModel(
            name="SupplyCompany",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(help_text="공급사명", max_length=60)),
                ("code", models.CharField(help_text="공급사 코드", max_length=20)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "oms_supplycompany",
            },
        ),
        migrations.CreateModel(
            name="TemporaryUserLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "db_table": "accounts_temporaryuserlog",
            },
        ),
        migrations.CreateModel(
            name="ThirdCategory",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=20)),
                ("code", models.IntegerField(default=None, null=True, unique=True)),
            ],
            options={
                "db_table": "food_thirdcategory",
            },
        ),
        migrations.CreateModel(
            name="Tos",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "term",
                    models.IntegerField(
                        choices=[
                            (1, "개인정보처리방침"),
                            (2, "홍보성 메세지 수신 동의"),
                            (3, "서비스 이용약관 동의"),
                            (4, "만 14세 이상"),
                            (5, "이벤트 정보 알림 수신 동의"),
                        ]
                    ),
                ),
                ("version", models.IntegerField(default=1)),
                ("publication_date", models.DateField(null=True)),
                ("is_required", models.BooleanField(default=False)),
                ("is_used", models.BooleanField(default=True)),
            ],
            options={
                "db_table": "accounts_tos",
            },
        ),
        migrations.CreateModel(
            name="TotalAmplitudeBatchEventResult",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("total_event", models.IntegerField()),
                (
                    "content",
                    models.CharField(
                        default="", help_text="어떤 내용인지 설명", max_length=100
                    ),
                ),
                ("event_type", models.CharField(default="", max_length=100)),
                (
                    "event_property",
                    models.JSONField(default=dict, help_text="기본 이벤트 프로퍼티"),
                ),
                ("has_error", models.BooleanField(default=False)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "db_table": "analysis_totalamplitudebatcheventresult",
            },
        ),
        migrations.CreateModel(
            name="UserFood",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_foods",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "food_userfood",
            },
        ),
        migrations.CreateModel(
            name="UserFoodProduct",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "data_source_type",
                    models.IntegerField(
                        choices=[(1, "직접 등록"), (2, "외부 등록")], default=1
                    ),
                ),
                (
                    "status",
                    models.IntegerField(choices=[(1, "등록"), (2, "삭제")], default=1),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "food",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="products",
                        to="app_model.userfood",
                    ),
                ),
            ],
            options={
                "db_table": "food_userfoodproduct",
            },
        ),
        migrations.CreateModel(
            name="Weight",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("amount", models.FloatField()),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "profile",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="weights",
                        to="app_model.healthprofile",
                    ),
                ),
            ],
            options={
                "db_table": "health_weight",
            },
        ),
        migrations.CreateModel(
            name="UserResign",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        blank=True,
                        help_text="유저에겐 보여주지 마세요!",
                        max_length=254,
                        null=True,
                    ),
                ),
                ("resigned_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="resign_logs",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "accounts_userresign",
            },
        ),
        migrations.CreateModel(
            name="UserMealTag",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")]
                    ),
                ),
                ("is_shown", models.BooleanField(default=True)),
                (
                    "meal_tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_meal_tags",
                        to="app_model.mealtag",
                    ),
                ),
                (
                    "users",
                    models.ManyToManyField(
                        related_name="meal_tags", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "db_table": "diet_usermealtag",
            },
        ),
        migrations.CreateModel(
            name="UserFoodUnit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(default=1, help_text="낮을 수록 높은 우선 순위"),
                ),
                ("total_gram", models.FloatField(help_text="총 그람 수", null=True)),
                (
                    "unit_gram",
                    models.FloatField(default=None, help_text="유닛 그람 수", null=True),
                ),
                ("total_count", models.IntegerField(help_text="총 개수", null=True)),
                (
                    "count_unit",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "개"),
                            (3, "인분"),
                            (2, "조각"),
                            (4, "캔"),
                            (5, "팩"),
                            (6, "포"),
                            (7, "컵"),
                            (8, "알"),
                            (9, "스푼"),
                        ],
                        help_text="개, 몇인분, 조각 등과 같은 단위",
                        null=True,
                    ),
                ),
                (
                    "gram_unit",
                    models.IntegerField(
                        choices=[(1, "g"), (2, "ml")], default=1, help_text="g, ml"
                    ),
                ),
                (
                    "user_food_product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="units",
                        to="app_model.userfoodproduct",
                    ),
                ),
            ],
            options={
                "db_table": "food_userfoodunit",
            },
        ),
        migrations.CreateModel(
            name="UserFoodProductLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                (
                    "meal",
                    models.IntegerField(
                        choices=[(0, "미정"), (1, "아침"), (2, "점심"), (3, "저녁"), (4, "간식")],
                        default=0,
                    ),
                ),
                (
                    "data_source_type",
                    models.IntegerField(
                        choices=[(1, "직접 등록"), (2, "외부 등록")], default=1
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "food_product",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="logs",
                        to="app_model.userfoodproduct",
                    ),
                ),
            ],
            options={
                "db_table": "diary_userfoodproductlog",
            },
        ),
        migrations.CreateModel(
            name="UserFoodNutrient",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "calorie",
                    models.FloatField(blank=True, help_text="100g 기준 칼로리", null=True),
                ),
                (
                    "carbohydrate",
                    models.FloatField(blank=True, help_text="100g 기준 탄수화물", null=True),
                ),
                (
                    "protein",
                    models.FloatField(blank=True, help_text="100g 기준 단백질", null=True),
                ),
                (
                    "fat",
                    models.FloatField(blank=True, help_text="100g 기준 지방", null=True),
                ),
                (
                    "sugar",
                    models.FloatField(blank=True, help_text="100g 기준 당류", null=True),
                ),
                (
                    "sodium",
                    models.FloatField(
                        blank=True, help_text="100g 기준 나트륨, mg으로 넣어주세요", null=True
                    ),
                ),
                (
                    "fiber",
                    models.FloatField(blank=True, help_text="100g 기준 식이섬유", null=True),
                ),
                (
                    "saturated_fat",
                    models.FloatField(blank=True, help_text="100g 기준 포화지방", null=True),
                ),
                (
                    "trans_fat",
                    models.FloatField(blank=True, help_text="100g 기준 트랜스지방", null=True),
                ),
                (
                    "cholesterol",
                    models.FloatField(blank=True, help_text="100g 기준 콜레스테롤", null=True),
                ),
                ("proper_gram", models.FloatField(help_text="한끼 그람 수", null=True)),
                (
                    "food",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="nutrient",
                        to="app_model.userfood",
                    ),
                ),
            ],
            options={
                "db_table": "food_userfoodnutrient",
            },
        ),
        migrations.CreateModel(
            name="UserABProperty",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("value", models.IntegerField()),
                ("extra", models.JSONField(default=dict)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "ab_test",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ab_properties",
                        to="app_model.abtest",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="ab_properties",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "accounts_userabproperty",
            },
        ),
        migrations.CreateModel(
            name="UnitCostLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "unit_cost",
                    models.IntegerField(
                        default=None,
                        help_text="해당 필드는 어드민에서 변경하면 안됩니다. 변경 시, 시스템에 큰 혼란이 오게 됩니다. (사실, log가 사라지는 거지, 문제가 되진 않지만 여튼 변경하거나 삭제하면 안됨!)",
                        null=True,
                    ),
                ),
                ("code", models.IntegerField(null=True)),
                ("content", models.CharField(blank=True, default="", max_length=100)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "food_product",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="unit_cost_logs",
                        to="app_model.foodproduct",
                    ),
                ),
            ],
            options={
                "db_table": "food_unitcostlog",
            },
        ),
        migrations.CreateModel(
            name="Unit",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(default=1, help_text="낮을 수록 높은 우선 순위"),
                ),
                ("total_gram", models.FloatField(help_text="총 그람 수", null=True)),
                (
                    "unit_gram",
                    models.FloatField(default=None, help_text="유닛 그람 수", null=True),
                ),
                ("total_count", models.IntegerField(help_text="총 개수", null=True)),
                (
                    "count_unit",
                    models.IntegerField(
                        choices=[
                            (0, "미정"),
                            (1, "개"),
                            (3, "인분"),
                            (2, "조각"),
                            (4, "캔"),
                            (5, "팩"),
                            (6, "포"),
                            (7, "컵"),
                            (8, "알"),
                            (9, "스푼"),
                        ],
                        help_text="개, 몇인분, 조각 등과 같은 단위",
                        null=True,
                    ),
                ),
                (
                    "gram_unit",
                    models.IntegerField(
                        choices=[(1, "g"), (2, "ml")], default=1, help_text="g, ml"
                    ),
                ),
                (
                    "food_product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="units",
                        to="app_model.foodproduct",
                    ),
                ),
            ],
            options={
                "db_table": "food_unit",
            },
        ),
        migrations.CreateModel(
            name="TosUserRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("approved", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "tos",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_rels",
                        to="app_model.tos",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="tos_rels",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "accounts_tosuserrelation",
            },
        ),
        migrations.AddConstraint(
            model_name="tos",
            constraint=models.UniqueConstraint(
                fields=("term", "version"), name="unique term and version for tos"
            ),
        ),
        migrations.AddField(
            model_name="thirdcategory",
            name="food",
            field=models.ManyToManyField(
                related_name="categories", to="app_model.food"
            ),
        ),
        migrations.AddField(
            model_name="thirdcategory",
            name="upper",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lowers",
                to="app_model.secondcategory",
            ),
        ),
        migrations.AddField(
            model_name="temporaryuserlog",
            name="changed_from",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="from_user",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="temporaryuserlog",
            name="changed_to",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="temporary_logs",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="smsnotificationmessage",
            name="kakao_templt",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="SMS",
                to="app_model.kakaotemplate",
            ),
        ),
        migrations.AddField(
            model_name="smsnotification",
            name="msg",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="notifications",
                to="app_model.smsnotificationmessage",
            ),
        ),
        migrations.AddField(
            model_name="shippingproductbarcode",
            name="product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="barcodes",
                to="app_model.shippingproduct",
            ),
        ),
        migrations.AddField(
            model_name="shippingproduct",
            name="supply_company",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="shipping_products",
                to="app_model.supplycompany",
            ),
        ),
        migrations.AddField(
            model_name="secondcategory",
            name="upper",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lowers",
                to="app_model.firstcategory",
            ),
        ),
        migrations.AddField(
            model_name="searchfoodproductlog",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="user_search_food_products",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="samplemealfood",
            name="dish",
            field=models.ForeignKey(
                default=0,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sample_meal_foods",
                to="app_model.dish",
                to_field="code",
            ),
        ),
        migrations.AddField(
            model_name="samplemealfood",
            name="food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sample_meal_foods",
                to="app_model.food",
            ),
        ),
        migrations.AddField(
            model_name="samplemealfood",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sample_meal_food_products",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="samplemealfood",
            name="sample_meal",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="foods",
                to="app_model.samplemeal",
            ),
        ),
        migrations.AddField(
            model_name="samplemealexceptday",
            name="sample_meals",
            field=models.ManyToManyField(
                related_name="except_days", to="app_model.samplemeal"
            ),
        ),
        migrations.AddField(
            model_name="samplemeal",
            name="tags",
            field=models.ManyToManyField(
                related_name="sample_meal_tags", to="app_model.mealtag"
            ),
        ),
        migrations.AddField(
            model_name="salesproductshippingproductrelation",
            name="sales_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="shipping_product_rels",
                to="app_model.salesproduct",
            ),
        ),
        migrations.AddField(
            model_name="salesproductshippingproductrelation",
            name="shipping_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="sales_product_rels",
                to="app_model.shippingproduct",
            ),
        ),
        migrations.AddField(
            model_name="salesproduct",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="sales_products",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="releaseorderitem",
            name="release_order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="order_items",
                to="app_model.releaseorder",
            ),
        ),
        migrations.AddField(
            model_name="releaseorderitem",
            name="sales_product",
            field=models.ForeignKey(
                help_text="판매 상품",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="app_model.salesproduct",
            ),
        ),
        migrations.AddField(
            model_name="releaseorder",
            name="order_info",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="release_orders",
                to="app_model.orderreleaseorderinformation",
            ),
        ),
        migrations.AddField(
            model_name="referencesafetykorea",
            name="reference",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="safety",
                to="app_model.referencefood",
            ),
        ),
        migrations.AddField(
            model_name="referencefoodunit",
            name="reference_food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="units",
                to="app_model.referencefoodproduct",
            ),
        ),
        migrations.AddField(
            model_name="referencefoodproduct",
            name="food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="products",
                to="app_model.referencefood",
            ),
        ),
        migrations.AddField(
            model_name="referencefoodnutrient",
            name="food",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="nutrient",
                to="app_model.referencefood",
            ),
        ),
        migrations.AddField(
            model_name="referencefatsecret",
            name="reference",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="fat_secret",
                to="app_model.referencefood",
            ),
        ),
        migrations.AddField(
            model_name="pushroutine",
            name="category",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="push_routines",
                to="app_model.pushroutinecategory",
            ),
        ),
        migrations.AddField(
            model_name="pushroutine",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="push_routines",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="productimage",
            name="product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="images",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="productexceptday",
            name="products",
            field=models.ManyToManyField(
                related_name="except_days", to="app_model.foodproduct"
            ),
        ),
        migrations.AddField(
            model_name="pricelog",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="price_logs",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="preferencefoodcategory",
            name="profiles",
            field=models.ManyToManyField(
                related_name="preference_food_categories", to="app_model.healthprofile"
            ),
        ),
        migrations.AddField(
            model_name="preferencefoodcategory",
            name="third_categories",
            field=models.ManyToManyField(
                related_name="preference_food_categories", to="app_model.thirdcategory"
            ),
        ),
        migrations.AddField(
            model_name="pointlog",
            name="point",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="logs",
                to="app_model.point",
            ),
        ),
        migrations.AddField(
            model_name="point",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="points",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="orderreleaseorderinformation",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="release_order_info",
                to="app_model.order",
            ),
        ),
        migrations.AddField(
            model_name="orderpointrelation",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="points_rels",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="orderpointrelation",
            name="points",
            field=models.ManyToManyField(
                null=True, related_name="order_rels", to="app_model.point"
            ),
        ),
        migrations.AddField(
            model_name="orderpaymentnoti",
            name="order",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="noti",
                to="app_model.order",
            ),
        ),
        migrations.AddField(
            model_name="orderfoodproductrelation",
            name="coupons",
            field=models.ManyToManyField(
                related_name="food_product_rels", to="app_model.coupondiscount"
            ),
        ),
        migrations.AddField(
            model_name="orderfoodproductrelation",
            name="delivery",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="order_food_product_rels",
                to="app_model.delivery",
            ),
        ),
        migrations.AddField(
            model_name="orderfoodproductrelation",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="order_rels",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="orderfoodproductrelation",
            name="order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_rels",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="orderdeliveryrelation",
            name="coupons",
            field=models.ManyToManyField(
                related_name="delivery_rels", to="app_model.coupondiscount"
            ),
        ),
        migrations.AddField(
            model_name="orderdeliveryrelation",
            name="delivery",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="order_rel",
                to="app_model.delivery",
            ),
        ),
        migrations.AddField(
            model_name="orderdeliveryrelation",
            name="order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="delivery_rels",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="orderdaydietlog",
            name="food_order",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_logs",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="orderdaydietlog",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="order_day_diet_logs",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="orderdaydietfoodlog",
            name="day_diet",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="foods",
                to="app_model.orderdaydietlog",
            ),
        ),
        migrations.AddField(
            model_name="orderdaydietfoodlog",
            name="food_product",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="order_day_diet_logs",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="ordercouponrelation",
            name="coupon",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="order_rels",
                to="app_model.coupondiscount",
            ),
        ),
        migrations.AddField(
            model_name="ordercouponrelation",
            name="order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="coupon_rels",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="order",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="orders",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="operationprofile",
            name="company",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="operators",
                to="app_model.foodcompany",
            ),
        ),
        migrations.AddField(
            model_name="operationprofile",
            name="user",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="operation_profile",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="operationcompanyinfo",
            name="company",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="company_info",
                to="app_model.foodcompany",
            ),
        ),
        migrations.AddField(
            model_name="onboardingprocessuserrelation",
            name="process",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="user_rels",
                to="app_model.onboardingprocess",
            ),
        ),
        migrations.AddField(
            model_name="onboardingprocessuserrelation",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="onboarding_process_rels",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="onboardingprocess",
            name="category",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="app_model.onboardingprocesscategory",
            ),
        ),
        migrations.AddField(
            model_name="onboardingfinish",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="onboarding_finished",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="onboardingab",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="onboarding_ab",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="nutrient",
            name="food",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="nutrient",
                to="app_model.food",
            ),
        ),
        migrations.AddField(
            model_name="muscle",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="muscles",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="mealexclusion",
            name="profiles",
            field=models.ManyToManyField(
                related_name="meal_exclusions", to="app_model.healthprofile"
            ),
        ),
        migrations.AddField(
            model_name="mainnoticeuserlog",
            name="main_notice",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="user_logs",
                to="app_model.mainnotice",
            ),
        ),
        migrations.AddField(
            model_name="mainnoticeuserlog",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="main_notice_logs",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="mainnoticebutton",
            name="main_notice",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="buttons",
                to="app_model.mainnotice",
            ),
        ),
        migrations.AddField(
            model_name="keyforresetpassword",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="key_for_password",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="kakaotemplatevariable",
            name="kakao_template",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="variables",
                to="app_model.kakaotemplate",
                verbose_name="연결된 템플릿",
            ),
        ),
        migrations.AddField(
            model_name="kakaotemplatebutton",
            name="kakao_templete",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="buttons",
                to="app_model.kakaotemplate",
            ),
        ),
        migrations.AddField(
            model_name="kakaoalimtalk",
            name="kakao_template",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="kakao_alimtalks",
                to="app_model.kakaotemplate",
            ),
        ),
        migrations.AddField(
            model_name="kakaoalimtalk",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="kakao_alimtalks",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="invitationcouponcode",
            name="user",
            field=models.OneToOneField(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="invitation_code",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="iamportwebhooklog",
            name="iamport_order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="logs",
                to="app_model.iamportorder",
            ),
        ),
        migrations.AddField(
            model_name="iamportschedulelog",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="schedule",
                to="app_model.iamportorder",
            ),
        ),
        migrations.AddField(
            model_name="iamportorder",
            name="customer_uid",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="orders",
                to="app_model.iamportcustomeruid",
            ),
        ),
        migrations.AddField(
            model_name="iamportorder",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="iamport_orders",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="iamportcustomeruid",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="customer_uids",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="iamportcancellog",
            name="iamport_order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="cancel_log",
                to="app_model.iamportorder",
            ),
        ),
        migrations.AddField(
            model_name="healthprofile",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="health_profile",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="healthgoal",
            name="profile",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="goal",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="foodsubsearchcategory",
            name="foods",
            field=models.ManyToManyField(
                related_name="sub_search_categories", to="app_model.food"
            ),
        ),
        migrations.AddField(
            model_name="foodsubsearchcategory",
            name="upper",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lowers",
                to="app_model.foodmajorsearchcategory",
            ),
        ),
        migrations.AddField(
            model_name="foodsubclassification",
            name="foods",
            field=models.ManyToManyField(
                related_name="sub_classifications", to="app_model.food"
            ),
        ),
        migrations.AddField(
            model_name="foodsubclassification",
            name="reference_foods",
            field=models.ManyToManyField(
                related_name="sub_classifications", to="app_model.referencefood"
            ),
        ),
        migrations.AddField(
            model_name="foodsubclassification",
            name="upper",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lowers",
                to="app_model.foodmajorclassification",
            ),
        ),
        migrations.AddField(
            model_name="foodpurchaseordersheet",
            name="company",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="purchase_order_sheets",
                to="app_model.foodcompany",
            ),
        ),
        migrations.AddField(
            model_name="foodproducttaste",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="taste_users",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproducttaste",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_tastes",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="foodproductsurveyrelation",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="survey_relations",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductsurveyrelation",
            name="survey",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_relation",
                to="app_model.dietordersurvey",
            ),
        ),
        migrations.AddField(
            model_name="foodproductsku",
            name="food_product",
            field=models.OneToOneField(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="sku_relation",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductlog",
            name="food_product",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="logs",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductcomborelation",
            name="combo",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="product_rels",
                to="app_model.foodproductcombo",
            ),
        ),
        migrations.AddField(
            model_name="foodproductcomborelation",
            name="product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="combo_rels",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductcombo",
            name="products",
            field=models.ManyToManyField(
                related_name="combos",
                through="app_model.FoodProductComboRelation",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestnutrient",
            name="content",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="nutrient",
                to="app_model.foodproductchangerequestcontent",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestimage",
            name="product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="images",
                to="app_model.foodproductchangerequestcontent",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="allergies",
            field=models.ManyToManyField(to="app_model.allergy"),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="brand",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="app_model.foodbrand",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="change_request",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="content",
                to="app_model.foodproductchangerequest",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="except_days",
            field=models.ManyToManyField(to="app_model.productexceptday"),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="group",
            field=models.ForeignKey(
                blank=True,
                default=0,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                to="app_model.foodgroup",
                to_field="code",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="platform",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="app_model.foodproductorigin",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="storage_method",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="app_model.storagemethod",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="sub_classifications",
            field=models.ManyToManyField(to="app_model.foodsubclassification"),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="sub_search_categories",
            field=models.ManyToManyField(to="app_model.foodsubsearchcategory"),
        ),
        migrations.AddField(
            model_name="foodproductchangerequestcontent",
            name="third_category",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="app_model.thirdcategory",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequest",
            name="approver",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="change_requests_to",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequest",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="change_requests",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductchangerequest",
            name="requester",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="change_requests_from",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="foodproductbookmark",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="bookmarks",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductbookmark",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_bookmarks",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="foodproductblocklog",
            name="block",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="logs",
                to="app_model.foodproductblock",
            ),
        ),
        migrations.AddField(
            model_name="foodproductblock",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_blocks",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodproductblock",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_product_blocks",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="foodproduct",
            name="food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="products",
                to="app_model.food",
            ),
        ),
        migrations.AddField(
            model_name="foodproduct",
            name="origin",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="app_model.foodproductorigin",
            ),
        ),
        migrations.AddField(
            model_name="foodorderstate",
            name="order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="states",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="foodorderremark",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="remark",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="foodorderpointtemporaryrelation",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="points_temp_rel",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="foodorderpointtemporaryrelation",
            name="points",
            field=models.ManyToManyField(
                related_name="food_order_temp_rel", to="app_model.point"
            ),
        ),
        migrations.AddField(
            model_name="foodordercoupontemporaryrelation",
            name="coupons",
            field=models.ManyToManyField(
                related_name="food_order_temp_rel", to="app_model.coupondiscount"
            ),
        ),
        migrations.AddField(
            model_name="foodordercoupontemporaryrelation",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="coupons_temp_rel",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="foodorderaddress",
            name="order_remark",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="address",
                to="app_model.foodorderremark",
            ),
        ),
        migrations.AddField(
            model_name="foodorder",
            name="order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_order",
                to="app_model.order",
            ),
        ),
        migrations.AddField(
            model_name="fooddiscount",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="food_discounts",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="foodbrand",
            name="company",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="brands",
                to="app_model.foodcompany",
            ),
        ),
        migrations.AddField(
            model_name="food",
            name="brand",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="foods",
                to="app_model.foodbrand",
            ),
        ),
        migrations.AddField(
            model_name="food",
            name="dishes",
            field=models.ManyToManyField(related_name="foods", to="app_model.dish"),
        ),
        migrations.AddField(
            model_name="food",
            name="group",
            field=models.ForeignKey(
                blank=True,
                default=0,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="foods",
                to="app_model.foodgroup",
                to_field="code",
            ),
        ),
        migrations.AddField(
            model_name="food",
            name="storage_method",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="app_model.storagemethod",
            ),
        ),
        migrations.AddField(
            model_name="fcmnotification",
            name="category",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="fcm_notifications",
                to="app_model.fcmnotificationcategory",
            ),
        ),
        migrations.AddField(
            model_name="fcmnotification",
            name="target",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="notifications",
                to="app_model.fcmnotificationtarget",
            ),
        ),
        migrations.AddField(
            model_name="fcmnotification",
            name="to",
            field=models.ForeignKey(
                blank=True,
                help_text="단일로 보내는 대상입니다.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="fcm_notifications",
                to="app_model.fcmdevice",
            ),
        ),
        migrations.AddField(
            model_name="fcmdevice",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="fcm_devices",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="eventcouponcode",
            name="coupon_discount_template",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="app_model.coupondiscounttemplate",
            ),
        ),
        migrations.AddField(
            model_name="dislikecategorylayerparameter",
            name="category_codes",
            field=models.ManyToManyField(
                related_name="dislike_layer_parameters", to="app_model.thirdcategory"
            ),
        ),
        migrations.AddField(
            model_name="dislikecategorylayerparameter",
            name="profiles",
            field=models.ManyToManyField(
                related_name="dislike_layer_parameters", to="app_model.healthprofile"
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentscheduleprofile",
            name="address",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_payment_schedule_profile",
                to="app_model.dietpaymentscheduleaddress",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentscheduleprofile",
            name="customer_uid",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_payment_schedule_profile",
                to="app_model.iamportcustomeruid",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentscheduleprofile",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_payment_schedule_profile",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentschedulelog",
            name="schedule",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="logs",
                to="app_model.dietpaymentschedule",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentscheduleaddress",
            name="user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_payment_schedule_addresses",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentschedule",
            name="address",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_payment_schedules",
                to="app_model.dietpaymentscheduleaddress",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentschedule",
            name="customer_uid",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_payment_schedules",
                to="app_model.iamportcustomeruid",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentschedule",
            name="diet_bundle",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_payment_schedule",
                to="app_model.dietbundle",
            ),
        ),
        migrations.AddField(
            model_name="dietpaymentschedule",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_payment_schedules",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dietordersurveyrelation",
            name="diet_order",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="survey_relations",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="dietordersurveyrelation",
            name="survey",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_order_relation",
                to="app_model.dietordersurvey",
            ),
        ),
        migrations.AddField(
            model_name="dietordersurveycomplete",
            name="diet_order",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="surveys_completed",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="dietordersurveycomplete",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_order_surveys_completed",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dietordersurvey",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_order_surveys",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dietmealsurveyrelation",
            name="day_diet",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="meal_survey_relations",
                to="app_model.orderdaydietlog",
            ),
        ),
        migrations.AddField(
            model_name="dietmealsurveyrelation",
            name="survey",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_meal_relation",
                to="app_model.dietordersurvey",
            ),
        ),
        migrations.AddField(
            model_name="dietfoodsurveyrelation",
            name="day_diet_food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="survey_relations",
                to="app_model.orderdaydietfoodlog",
            ),
        ),
        migrations.AddField(
            model_name="dietfoodsurveyrelation",
            name="survey",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_food_relation",
                to="app_model.dietordersurvey",
            ),
        ),
        migrations.AddField(
            model_name="dietbundle",
            name="day_diet_records",
            field=models.ManyToManyField(
                related_name="diet_bundles", to="app_model.daydietrecord"
            ),
        ),
        migrations.AddField(
            model_name="dietbundle",
            name="day_diets",
            field=models.ManyToManyField(
                related_name="diet_bundles", to="app_model.daydiet"
            ),
        ),
        migrations.AddField(
            model_name="dietbundle",
            name="food_order",
            field=models.OneToOneField(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="diet_bundle",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="dietbundle",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diet_bundles",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="diagnosis",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="diagnoses",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="deliverylog",
            name="delivery",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="logs",
                to="app_model.delivery",
            ),
        ),
        migrations.AddField(
            model_name="daydietsurveycomplete",
            name="day_diet",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="survey_completed",
                to="app_model.orderdaydietlog",
            ),
        ),
        migrations.AddField(
            model_name="daydietsurveycomplete",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diet_surveys_completed",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="daydietrecord",
            name="diagnosis",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diet_records",
                to="app_model.diagnosis",
            ),
        ),
        migrations.AddField(
            model_name="daydietrecord",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diet_records",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="daydietmealtag",
            name="day_diet",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="tags",
                to="app_model.daydiet",
            ),
        ),
        migrations.AddField(
            model_name="daydietmealtag",
            name="tag",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="meals",
                to="app_model.mealtag",
            ),
        ),
        migrations.AddField(
            model_name="daydietmealexclusion",
            name="day_diets",
            field=models.ManyToManyField(
                related_name="meal_exclusions", to="app_model.daydiet"
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordunit",
            name="food_product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="units",
                to="app_model.daydietfoodrecordfoodproduct",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordnutrient",
            name="food",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="nutrient",
                to="app_model.daydietfoodrecordfood",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordimage",
            name="product",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="images",
                to="app_model.daydietfoodrecordfoodproduct",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordfoodproduct",
            name="food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="products",
                to="app_model.daydietfoodrecordfood",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordfood",
            name="brand",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="record_foods",
                to="app_model.foodbrand",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordfood",
            name="dishes",
            field=models.ManyToManyField(
                related_name="record_foods", to="app_model.dish"
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordfood",
            name="group",
            field=models.ForeignKey(
                blank=True,
                default=0,
                null=True,
                on_delete=django.db.models.deletion.SET_DEFAULT,
                related_name="record_foods",
                to="app_model.foodgroup",
                to_field="code",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecordfood",
            name="storage_method",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="app_model.storagemethod",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecord",
            name="day_diet_record",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="foods",
                to="app_model.daydietrecord",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecord",
            name="food_product",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_records",
                to="app_model.daydietfoodrecordfoodproduct",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecord",
            name="food_product_log",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_records",
                to="app_model.foodproductlog",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecord",
            name="order_day_diet_food_log",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_records",
                to="app_model.orderdaydietfoodlog",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodrecord",
            name="user_food_product_log",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_records",
                to="app_model.userfoodproductlog",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodchangelog",
            name="change_event",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="change_logs",
                to="app_model.daydietfoodchangeevent",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodchangelog",
            name="day_diet_food",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="change_logs",
                to="app_model.daydietfood",
            ),
        ),
        migrations.AddField(
            model_name="daydietfoodchangeevent",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diet_change_events",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="daydietfood",
            name="day_diet",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="foods",
                to="app_model.daydiet",
            ),
        ),
        migrations.AddField(
            model_name="daydietfood",
            name="dish",
            field=models.ForeignKey(
                default=0,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diet_foods",
                to="app_model.dish",
                to_field="code",
            ),
        ),
        migrations.AddField(
            model_name="daydietfood",
            name="food_product",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diet_food_products",
                to="app_model.foodproduct",
            ),
        ),
        migrations.AddField(
            model_name="daydietfood",
            name="prev_replacement",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="next_replacements",
                to="app_model.daydietfood",
            ),
        ),
        migrations.AddField(
            model_name="daydiet",
            name="order",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="day_diets",
                to="app_model.foodorder",
            ),
        ),
        migrations.AddField(
            model_name="daydiet",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="day_diets",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="dailyactiveuserlog",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="dau_logs",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="customcalorie",
            name="profile",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="custom_calorie",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="coupondiscounttarget",
            name="coupon_discount_template",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="coupon_discount_target",
                to="app_model.coupondiscounttemplate",
            ),
        ),
        migrations.AddField(
            model_name="coupondiscount",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="coupon_discounts",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="cookway",
            name="foods",
            field=models.ManyToManyField(related_name="cook_ways", to="app_model.food"),
        ),
        migrations.AddField(
            model_name="commonprofile",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="common_profile",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="bodyfat",
            name="profile",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="body_fats",
                to="app_model.healthprofile",
            ),
        ),
        migrations.AddField(
            model_name="amplitudebatcheventresult",
            name="upper",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="lowers",
                to="app_model.totalamplitudebatcheventresult",
            ),
        ),
        migrations.AddField(
            model_name="amazonsnssubscription",
            name="category",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="subscriptions",
                to="app_model.amazonsnssubscriptioncategory",
            ),
        ),
        migrations.AddField(
            model_name="amazonsnssubscription",
            name="endpoint",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="subscriptions",
                to="app_model.amazonsnsplatformendpoint",
            ),
        ),
        migrations.AddField(
            model_name="amazonsnssubscription",
            name="topic",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="subscriptions",
                to="app_model.amazonsnstopic",
            ),
        ),
        migrations.AddField(
            model_name="amazonsnssubscription",
            name="user",
            field=models.ForeignKey(
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="amazon_sns_subscriptions",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="amazonsnsplatformendpoint",
            name="fcm_device",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="amazon_endpoint",
                to="app_model.fcmdevice",
            ),
        ),
        migrations.AddField(
            model_name="amazonsnsplatformendpoint",
            name="platform_application",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="endpoints",
                to="app_model.amazonsnsplatformapplication",
            ),
        ),
        migrations.AddField(
            model_name="allergy",
            name="foods",
            field=models.ManyToManyField(related_name="allergies", to="app_model.food"),
        ),
        migrations.AddField(
            model_name="allergy",
            name="profiles",
            field=models.ManyToManyField(
                related_name="allergies", to="app_model.healthprofile"
            ),
        ),
        migrations.AddField(
            model_name="airbridgedevice",
            name="user",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="airbridge_devices",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="address",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="address",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="groups",
            field=models.ManyToManyField(
                blank=True,
                help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                related_name="user_set",
                related_query_name="user",
                to="auth.group",
                verbose_name="groups",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="user_permissions",
            field=models.ManyToManyField(
                blank=True,
                help_text="Specific permissions for this user.",
                related_name="user_set",
                related_query_name="user",
                to="auth.permission",
                verbose_name="user permissions",
            ),
        ),
        migrations.AddConstraint(
            model_name="usermealtag",
            constraint=models.UniqueConstraint(
                fields=("meal_tag", "meal"), name="unique tag and meal"
            ),
        ),
        migrations.AddConstraint(
            model_name="userabproperty",
            constraint=models.UniqueConstraint(
                fields=("user", "ab_test"),
                name="unique user and ab_test for UserABProperty",
            ),
        ),
        migrations.AddConstraint(
            model_name="thirdcategory",
            constraint=models.UniqueConstraint(
                fields=("name", "upper"), name="third category name and upper unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="secondcategory",
            constraint=models.UniqueConstraint(
                fields=("name", "upper"), name="second category name and upper unique"
            ),
        ),
        migrations.AddIndex(
            model_name="referencefoodproduct",
            index=django.contrib.postgres.indexes.GinIndex(
                fields=["tsv_name"], name="food_refere_tsv_nam_beb672_gin"
            ),
        ),
        migrations.AddConstraint(
            model_name="onboardingprocess",
            constraint=models.UniqueConstraint(
                fields=("category", "ordering"),
                name="unique category and ordering for onboarding process",
            ),
        ),
        migrations.AddConstraint(
            model_name="mainnoticebutton",
            constraint=models.UniqueConstraint(
                fields=("main_notice", "code"),
                name="unique main notice and button code",
            ),
        ),
        migrations.AddConstraint(
            model_name="foodproductbookmark",
            constraint=models.UniqueConstraint(
                fields=("profile", "food_product"),
                name="unique profile and food_product for bookmark",
            ),
        ),
        migrations.AddConstraint(
            model_name="foodorderstate",
            constraint=models.UniqueConstraint(
                fields=("order", "status"), name="food order state unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="dietpaymentschedule",
            constraint=models.UniqueConstraint(
                fields=("user", "payment_at"),
                name="DietPaymentSchedule user payment_at unique",
            ),
        ),
        migrations.AddConstraint(
            model_name="daydietrecord",
            constraint=models.UniqueConstraint(
                fields=("user", "day"), name="unique user and day for DayDietRecord"
            ),
        ),
        migrations.AddConstraint(
            model_name="daydietmealtag",
            constraint=models.UniqueConstraint(
                fields=("tag", "day_diet", "meal"), name="unique tag, day_diet and meal"
            ),
        ),
        migrations.AddConstraint(
            model_name="daydietfood",
            constraint=models.UniqueConstraint(
                fields=("day_diet", "food_product", "meal", "dish"),
                name="unique day_diet, food, meal and dish",
            ),
        ),
        migrations.AddConstraint(
            model_name="daydiet",
            constraint=models.UniqueConstraint(
                fields=("user", "day"), name="unique user and day"
            ),
        ),
    ]
