# Generated by Django 4.2.3 on 2023-10-24 07:21

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ("app_model", "0002_dietpaymentscheduleprofile_consecutive_week_and_more"),
    ]

    operations = [
        migrations.CreateModel(
            name="Dialog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200, unique=True)),
                ("path", models.TextField(blank=True, default="/")),
                (
                    "dialog_type",
                    models.CharField(
                        choices=[
                            ("undefined", "미정"),
                            ("modal", "모달"),
                            ("bottomsheet", "바텀시트"),
                            ("system_modal", "시스템 모달"),
                        ],
                        default="undefined",
                        max_length=20,
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(default=1, help_text="낮을 수록 높은 우선 순위"),
                ),
                (
                    "frequency",
                    models.CharField(
                        choices=[
                            ("undefined", "미정"),
                            ("forever", "영원히"),
                            ("day", "일"),
                            ("week", "주"),
                            ("month", "월"),
                        ],
                        default="forever",
                        max_length=20,
                    ),
                ),
                (
                    "count",
                    models.IntegerField(default=1, help_text="frequency 당 몇 번 봐야 하는지"),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "db_table": "notification_dialog",
            },
        ),
        migrations.CreateModel(
            name="DialogUserRelationLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("count", models.IntegerField(default=1)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "dialog",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_relation_logs",
                        to="app_model.dialog",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dialog_relation_logs",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "notification_dialoguserrelationlog",
            },
        ),
        migrations.CreateModel(
            name="DialogUserRelation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "count",
                    models.IntegerField(
                        default=0, help_text="Dialog의 frequency 기간 동안 본 횟수(현재)"
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("last_seen", models.DateTimeField(auto_now=True)),
                (
                    "dialog",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="user_relations",
                        to="app_model.dialog",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dialog_relations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "db_table": "notification_dialoguserrelation",
            },
        ),
        migrations.AddConstraint(
            model_name="dialoguserrelation",
            constraint=models.UniqueConstraint(
                fields=("user", "dialog"), name="DialogUserRelation user, dialog unique"
            ),
        ),
    ]
