from setuptools import find_packages, setup

setup(
    name='orbitronomy',
    packages=find_packages(),
    version='0.2.7',
    description="The Orbitronomy library is designed to simplify the process of plotting, calculating, visualizing, and animating the orbits of celestial bodies in 3D space. It employs Kepler's elliptical orbit equations and Keplerian Elements, in conjunction with PyAstronomy, to perform precise orbital calculations. For 3D plotting, it integrates the capabilities of Matplotlib, enhancing its utility in astronomical simulations and analyses.",
    long_description=open('README.md').read(),
    long_description_content_type='text/markdown',
    author='Storm',
    url='https://github.com/strumberr/Orbitronomy',
    project_urls={
        'Source': 'https://github.com/strumberr/Orbitronomy/tree/main/orbitronomy',
        'Tracker': 'https://github.com/strumberr/Orbitronomy/issues',
    },
    include_package_data=True, 
    install_requires=[
        'bidict==0.22.1',
        'certifi',
        'charset-normalizer==3.3.2',
        'contourpy==1.2.0',
        'cycler==0.12.1',
        'docutils==0.20.1',
        'fonttools==4.45.0',
        'idna==3.4',
        'importlib-metadata==6.8.0',
        'iniconfig==2.0.0',
        'jaraco.classes==3.3.0',
        'keyring==24.3.0',
        'kiwisolver==1.4.5',
        'markdown-it-py==3.0.0',
        'matplotlib==3.8.2',
        'mdurl==0.1.2',
        'more-itertools==10.1.0',
        'nh3==0.2.14',
        'numpy==1.26.2',
        'packaging==23.2',
        'Pillow==10.1.0',
        'pkginfo==1.9.6',
        'pluggy==1.3.0',
        'PyAstronomy==0.20.0',
        'Pygments==2.17.1',
        'pyparsing==3.1.1',
        'python-dateutil==2.8.2',
        'quantities==0.14.1',
        'readme-renderer==42.0',
        'requests==2.31.0',
        'requests-toolbelt==1.0.0',
        'rfc3986==2.0.0',
        'rich==13.7.0',
        'scipy==1.11.4',
        'six==1.16.0',
        'twine==4.0.2',
        'urllib3==2.1.0',
        'zipp==3.17.0',
    ],
    setup_requires=['pytest'],
    tests_require=['pytest'],
    test_suite='tests',
)

