<div align="center" markdown>
<a name="readme-top"></a>

![cherries](https://socialify.git.ci/liblaf/cherries/image?description=1&forks=1&issues=1&language=1&logo=https%3A%2F%2Fraw.githubusercontent.com%2Fmicrosoft%2Ffluentui-emoji%2Frefs%2Fheads%2Fmain%2Fassets%2FCherries%2F3D%2Fcherries_3d.png&name=1&owner=1&pattern=Transparent&pulls=1&stargazers=1&theme=Auto)

**[Explore the docs »](https://liblaf.github.io/cherries/)**

<!-- tangerine-start: badges/python.md -->

[![codecov](https://codecov.io/gh/liblaf/cherries/graph/badge.svg)](https://codecov.io/gh/liblaf/cherries)
[![MegaLinter](https://github.com/liblaf/cherries/actions/workflows/mega-linter.yaml/badge.svg)](https://github.com/liblaf/cherries/actions/workflows/mega-linter.yaml)
[![Test](https://github.com/liblaf/cherries/actions/workflows/test.yaml/badge.svg)](https://github.com/liblaf/cherries/actions/workflows/test.yaml)
[![pre-commit.ci status](https://results.pre-commit.ci/badge/github/liblaf/cherries/main.svg)](https://results.pre-commit.ci/latest/github/liblaf/cherries/main)
[![CodSpeed Badge](https://img.shields.io/endpoint?url=https://codspeed.io/badge.json)](https://codspeed.io/liblaf/cherries)
[![Ruff](https://img.shields.io/endpoint?url=https://raw.githubusercontent.com/astral-sh/ruff/main/assets/badge/v2.json)](https://github.com/astral-sh/ruff)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/liblaf-cherries?logo=PyPI&label=Downloads)](https://pypi.org/project/liblaf-cherries)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/liblaf-cherries?logo=Python&label=Python)](https://pypi.org/project/liblaf-cherries)
[![PyPI - Version](https://img.shields.io/pypi/v/liblaf-cherries?logo=PyPI&label=PyPI)](https://pypi.org/project/liblaf-cherries)

<!-- tangerine-end -->

[Changelog](https://github.com/liblaf/cherries/blob/main/CHANGELOG.md) · [Report Bug](https://github.com/liblaf/cherries/issues) · [Request Feature](https://github.com/liblaf/cherries/issues)

![](https://cdn.jsdelivr.net/gh/andreasbm/readme/assets/lines/rainbow.png)

</div>

## ✨ Features

- 🧪 **Experiment Tracking:** Seamlessly log parameters, metrics, and artifacts with automatic integration to Comet.ml, DVC, and local storage;
- 🔄 **Automated Versioning:** Automatic Git commits with detailed metadata including inputs, outputs, and parameters for full experiment reproducibility;
- 🧩 **Plugin Architecture:** Extensible plugin system with dependency-aware execution order and support for custom integrations;
- 📊 **Rich Configuration:** Pydantic-based configuration with automatic asset tracking for inputs and outputs using type annotations;
- 🤖 **Smart Automation:** Automatic detection of experiment directories, asset management, and intelligent logging configuration;
- ⚡ **Quick Setup:** Simple initialization script for DVC configuration and ready-to-use experiment templates;

## 📦 Installation

To install `liblaf-cherries`, run the following command:

```bash
uv add liblaf-cherries
```

## ⌨️ Local Development

You can use Github Codespaces for online development:

[![](https://github.com/codespaces/badge.svg)](https://codespaces.new/liblaf/cherries)

Or clone it for local development:

```bash
gh repo clone liblaf/cherries
cd cherries
mise run install
```

## 🤝 Contributing

Contributions of all types are more than welcome, if you are interested in contributing code, feel free to check out our GitHub [Issues](https://github.com/liblaf/cherries/issues) to get stuck in to show us what you're made of.

[![PR Welcome](https://img.shields.io/badge/%F0%9F%A4%AF%20PR%20WELCOME-%E2%86%92-ffcb47?labelColor=black&style=for-the-badge)](https://github.com/liblaf/cherries/pulls)

[![Contributors](https://contrib.nn.ci/api?repo=liblaf/cherries)](https://github.com/liblaf/cherries/graphs/contributors)

## 🔗 More Projects

<!-- tangerine-start: projects/fruits.md -->

- **[🍇 Grapes](https://github.com/liblaf/grapes)** - Supercharge your Python with rich logging, precise timing, and seamless serialization.
- **[🍉 Melon](https://github.com/liblaf/melon)** - A comprehensive Python library for 3D mesh processing with advanced I/O capabilities, proximity analysis, and integration with external mesh processing tools.
- **[🍊 Tangerine](https://github.com/liblaf/tangerine)** - Squeeze dynamic content into your files with Tangerine's template magic.
- **[🍋‍🟩 Lime](https://github.com/liblaf/lime)** - AI-powered Git commit assistant and repository documentation generator
- **[🍎 Apple](https://github.com/liblaf/apple)** - A JAX and Warp library for differentiable physics simulation, featuring elastic energy models and finite element methods.
- **[🍒 Cherries](https://github.com/liblaf/cherries)** - Sweet experiment tracking with Comet, DVC, and Git integration.
<!-- tangerine-end -->

---

#### 📝 License

Copyright © 2025 [liblaf](https://github.com/liblaf). <br />
This project is [MIT](https://github.com/liblaf/cherries/blob/main/LICENSE) licensed.
