# Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License"). You
# may not use this file except in compliance with the License. A copy of
# the License is located at
#
#     http://aws.amazon.com/apache2.0/
#
# or in the "license" file accompanying this file. This file is
# distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF
# ANY KIND, either express or implied. See the License for the specific
# language governing permissions and limitations under the License.
"""Module containing Enums for the feature_processor module."""
from __future__ import absolute_import

from enum import Enum


class FeatureProcessorMode(Enum):
    """Enum of feature_processor modes."""

    PYSPARK = "pyspark"  # Execute a pyspark job.
    PYTHON = "python"  # Execute a regular python script.


class FeatureProcessorPipelineExecutionStatus(Enum):
    """Enum of feature_processor pipeline execution status."""

    EXECUTING = "Executing"
    STOPPING = "Stopping"
    STOPPED = "Stopped"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
