# geo_qua

Это Python-библиотека для решения квадратных уравнений и работы с геометрическими последовательностями.

## Установка

Вы можете установить библиотеку через `pip` с PyPI:

```bash
pip install geo_qua
```

## Использование

### Решение квадратных уравнений

Класс QuadraticSolver используется для решения квадратных уравнений вида ax^2 + bx + c = 0.

Пример использования:

```python
from geo_qua.QuadraticSolver import Quadratic

# Создаем объект решателя с коэффициентами a=1, b=-3, c=2
solver = Quadratic(1, -3, 2)

# Решаем уравнение
roots = solver.solve()

print(f"Корни: {roots}")
```

Методы:
- __init__(a, b, c) — Инициализирует коэффициенты квадратного уравнения.
- calculate_discriminant() — Вычисляет дискриминант уравнения.
- solve() — Решает уравнение и возвращает корни:
  - два вещественных корня для D > 0
  - один корень для D = 0
  - два комплексных корня для D < 0

## Геометрическая последовательность

Класс GeometricSequence позволяет работать с геометрическими последовательностями. Вы можете вычислять 
n-й член последовательности и сумму первых n членов.

Пример использования:

```python
from geo_qua.GeometricSequence import Geometric

# Создаем геометрическую последовательность с первым членом a1=2 и знаменателем q=3
sequence = Geometric(a1=2, q=3)

# Вычисляем 5-й член
nth_term = sequence.nth_term(5)
print(f"5-й член: {nth_term}")

# Вычисляем сумму первых 5 членов
sum_terms = sequence.sum_of_terms(5)
print(f"Сумма первых 5 членов: {sum_terms}")

# Проверяем, является ли число членом последовательности
is_member = sequence.is_member(54)
print(f"Число 54 является членом последовательности: {is_member}")
```

Методы:
- __init__(a1, q) — Инициализирует первый член и знаменатель.
- nth_term(n) — Возвращает n-й член последовательности.
- sum_of_terms(n) — Возвращает сумму первых n членов последовательности.
- is_member(x) — Проверяет, является ли число x членом последовательности.

## Тесты

Вы можете запустить юнит-тесты для этой библиотеки, чтобы убедиться, что всё работает корректно.

## Запуск тестов

Для запуска тестов используйте команду:

```bash
python -m unittest discover
```