# Sensei MCP Documentation

This directory contains historical planning documents, development guides, and archived materials.

---

## 📁 Directory Structure

### `archive/` - Historical Planning Documents

Version-specific planning, implementation tracking, and release documentation.

**v0.5.0 (2025-01-23)**
- `V0.5.0_ROADMAP.md` - Initial feature planning
- `V0.5.0_IMPLEMENTATION_STATUS.md` - Development tracking
- `V0.5.0_FEATURE_1_SUMMARY.md` - Interactive Discovery feature summary
- `V0.5.0_TESTING_SUMMARY.md` - Comprehensive test report (67 tests)
- `PERSONA_GAP_ANALYSIS.md` - Analysis leading to Database Architect persona

**v0.4.0 (2025-01-23)**
- `V0.4.0_ROADMAP.md` - Analytics & Team Collaboration planning
- `V0.4.0_IMPLEMENTATION_STATUS.md` - Implementation tracking

**v0.3.0 (2025-01-22)**
- `V0.3.0_RELEASE_SUMMARY.md` - Multi-Persona Orchestrator release summary

### `planning/` - Future Planning

- `FUTURE_ROADMAP_SUMMARY.md` - Long-term roadmap and feature ideas

### `development/` - Developer Documentation

- `PUBLISHING.md` - Publishing process and PyPI deployment
- `manual-tasks.md` - Manual task reference and checklists

---

## 📖 User-Facing Documentation

For user documentation, see the root directory:
- [`../README.md`](../README.md) - Main documentation
- [`../CHANGELOG.md`](../CHANGELOG.md) - Version history
- [`../UPGRADING.md`](../UPGRADING.md) - Upgrade guides
- [`../CONTRIBUTING.md`](../CONTRIBUTING.md) - Contribution guidelines

---

## 🔍 Finding Information

**Looking for release notes?** → `../CHANGELOG.md`
**Planning a contribution?** → `../CONTRIBUTING.md`
**Upgrading versions?** → `../UPGRADING.md`
**Understanding past decisions?** → `archive/v{version}/`
**Future features?** → `planning/FUTURE_ROADMAP_SUMMARY.md`

---

Made with 🥋 by [amarodeabreu](https://github.com/amarodeabreu)
