# Sensei MCP v0.4.0 Roadmap 🎭

**Status:** Planning Phase
**Target Release:** TBD (After gathering v0.3.0 user feedback)
**Theme:** **Discoverability, Analytics, and Team Collaboration**

---

## 🎯 Executive Summary

v0.3.0 gave users 22 expert personas. **v0.4.0 makes those personas more accessible, measurable, and shareable.**

**Core Philosophy:**
- ✅ Wait for real user feedback before building speculatively
- ✅ Optimize existing 22 personas rather than adding more
- ✅ Lower adoption barriers through better discoverability
- ✅ Enable team collaboration and knowledge sharing
- ✅ Provide data-driven insights on persona effectiveness

---

## 🎭 Personas Consulted for Roadmap

**Roundtable participants:**
1. **Skill Orchestrator** - Overall synthesis and prioritization
2. **Pragmatic Architect** - Technical foundations and evolutionary approach
3. **Product Engineering Lead** - User value and adoption metrics
4. **DevX Champion** - Developer experience and onboarding
5. **Platform Builder** - APIs, integrations, and extensibility

**Consensus:** Focus on making existing capabilities more discoverable and useful, not adding complexity.

---

## 🚀 Top 3 Features for v0.4.0

### 1. Session Analytics & Insights 📊

**Problem:** Users don't know which personas are most helpful or how their decisions evolve over time.

**Solution:** New MCP tool providing data-driven insights.

**Features:**
```python
get_session_insights(
    session_id="my-project",
    time_range="last_30_days"  # or "all_time"
)
```

**Returns:**
- **Consultation patterns**: Most/least used personas, frequency trends
- **Persona effectiveness**: Which personas appear in successful decisions
- **Decision lineage**: How constraints and patterns evolved
- **Context distribution**: CRISIS vs ARCHITECTURAL vs TECHNICAL queries
- **Time-to-decision**: How long between question and decision record
- **Collaboration metrics**: How often multi-persona synthesis is used

**User Value:**
- "Which personas should I consult for security questions?"
- "Am I over-relying on one perspective?"
- "How has our architecture evolved over time?"

**Technical Implementation:**
- Analyze existing `consultations` array in session state
- Aggregate statistics from `decisions`, `constraints`, `patterns`
- No new data storage needed - leverage existing session memory
- Optional: Export to JSON/CSV for external analysis

**Effort:** Medium (1-2 days)

---

### 2. Interactive Persona Discovery 🔍

**Problem:** Users don't know what personas exist or how to use them effectively.

**Solution:** Enhanced discoverability through CLI wizard, examples, and quick references.

**Features:**

**A. CLI Demo Mode**
```bash
sensei-mcp --demo
# Interactive walkthrough:
# 1. "Let me show you 5 example consultations"
# 2. Shows real query → persona selection → synthesis
# 3. "Try it yourself with this wizard..."
```

**B. Enhanced `list_available_skills()`**
```python
list_available_skills(format="detailed")
# Returns for each persona:
# - Name and category
# - One-line expertise summary
# - 2-3 example queries
# - When to consult them
# - Related personas
```

**C. Persona Quick Cards**
```
Snarky Senior Engineer
├─ Expertise: Pragmatic shipping, BS detection, production-grade code
├─ Example: "Should we rewrite this in Rust?"
├─ Example: "Our microservices architecture is too complex"
├─ Best for: Reality checks, cutting through hype, pragmatic decisions
└─ Works well with: Pragmatic Architect, Platform Builder
```

**D. Context Hints**
```python
# When user queries don't match expected context:
get_engineering_guidance(
    query="SQL injection in our auth endpoint"
)
# Returns hint: "💡 This looks like a security question.
#               Consider: security-sentinel, compliance-guardian"
```

**User Value:**
- New users understand capabilities immediately
- Reduced time-to-first-value
- Better persona selection = better guidance

**Technical Implementation:**
- Add `demo_mode()` function with pre-written scenarios
- Enhance PersonaRegistry with metadata (examples, when-to-use)
- Add YAML frontmatter: `examples:`, `use_when:`, `related:`
- Simple string matching for context hints

**Effort:** Low-Medium (2-3 days)

---

### 3. Team Collaboration Features 🤝

**Problem:** Individual users get value, but teams can't share decision-making context.

**Solution:** Export, share, and merge capabilities for team workflows.

**Features:**

**A. Export Consultation Reports**
```python
export_consultation(
    consultation_id="consult_42",
    format="markdown"  # or "json", "pdf"
)
# Returns shareable report:
# - Query and context
# - Personas consulted with perspectives
# - Synthesis and recommendation
# - Link to session for full context
```

**B. Session Summary Reports**
```python
export_session_summary(
    session_id="my-project",
    format="markdown",
    include=["decisions", "consultations", "constraints"]
)
# Generates team-ready report:
# - Architecture Decision Records (ADRs)
# - Consultation history
# - Active constraints and patterns
```

**C. Session Merge (Team Sync)**
```python
merge_sessions(
    source_sessions=["alice-session", "bob-session"],
    target_session="team-session",
    conflict_resolution="latest"  # or "manual", "all"
)
# Combines multiple individual sessions into team view
# Preserves attribution (who made which decision)
```

**D. CI/CD Integration Guide**
```yaml
# .github/workflows/architecture-review.yml
- name: Sensei Architecture Review
  run: |
    uvx sensei-mcp get_engineering_guidance \
      --query "Review staged changes for architecture issues" \
      --mode crisis \
      --session-id ${{ github.repository }}
```

**User Value:**
- Teams share architectural knowledge
- Onboard new engineers faster (read consultation history)
- Document decision-making process
- Integrate into PR reviews and CI/CD

**Technical Implementation:**
- Markdown templating for reports
- JSON export already supported by session format
- Merge logic: combine consultations/decisions arrays, dedupe constraints
- CI/CD guide in docs (no code changes needed)

**Effort:** Medium (3-4 days)

---

## 💡 Quick Wins (Can Ship Incrementally)

These can be added in patch releases (v0.4.1, v0.4.2, etc.):

### A. Persona Effectiveness Scoring
```python
# In get_session_insights()
{
  "persona_effectiveness": {
    "security-sentinel": {
      "consultations": 15,
      "decisions_influenced": 8,  # Appeared in 8 decisions
      "avg_synthesis_confidence": 0.85
    }
  }
}
```

### B. Favorite Personas
```python
set_favorite_personas(
    session_id="my-project",
    personas=["snarky-senior-engineer", "security-sentinel"]
)
# Auto-include favorites in orchestrated mode
```

### C. Consultation Templates
```python
# Pre-built templates for common scenarios
use_template(
    template="security-review",
    code=read_file("auth.py")
)
# Auto-selects: security-sentinel, compliance-guardian, sre
```

### D. Performance Dashboard
```python
get_performance_stats()
# Returns:
# - Average response time
# - Cache hit rate
# - Persona load times
# - Session size metrics
```

### E. Query History
```python
get_query_history(session_id="my-project", limit=10)
# Shows recent queries with one-line summaries
# Quick way to resume previous discussions
```

---

## 🚫 What NOT to Build in v0.4.0

**Rejected Ideas & Why:**

### Custom Persona Creation
**Why not:** Too complex for v0.4.0. Need to see how users utilize existing 22 personas first.
**Revisit:** v0.5.0+ if users request specific expertise not covered

### ML-Based Improvements
**Why not:** Premature without usage data. Current regex-based context detection works well.
**Revisit:** v0.5.0+ with real usage patterns to train on

### New Personas (#23-30)
**Why not:** 22 is plenty. Focus on making existing personas more discoverable/useful.
**Revisit:** Based on user feedback gaps in expertise coverage

### Major Architecture Changes
**Why not:** v0.3.0 architecture is solid (0ms cached loads, 102 tests passing).
**Revisit:** Only if performance/scalability issues emerge

### Async MCP Tools
**Why not:** Current sync implementation works fine (<200ms response).
**Revisit:** If response times exceed 500ms under production load

### User Feedback Mechanism
**Why not:** Can't build feedback system without users first.
**Revisit:** v0.4.0+ after 100+ active users

---

## 📅 Proposed Timeline

### Phase 1: User Feedback (2-4 weeks after v0.3.0 launch)
- Monitor GitHub issues
- Observe actual persona usage patterns
- Identify adoption blockers
- Validate/adjust v0.4.0 roadmap

### Phase 2: Development (1-2 weeks)
- **Week 1:** Session Analytics + Interactive Discovery
- **Week 2:** Team Collaboration Features
- Continuous testing throughout

### Phase 3: Testing & Documentation (3-5 days)
- Integration tests for new tools
- Update README with v0.4.0 examples
- Write migration guide
- Performance validation

### Phase 4: Release (1 day)
- Tag v0.4.0
- Publish to PyPI
- Announce to users
- Update documentation

**Total Estimated Time:** 4-6 weeks after v0.3.0 launch

---

## 📊 Success Metrics

**How we'll measure v0.4.0 success:**

### User Adoption
- ✅ 50% of users try `get_session_insights()` within first week
- ✅ 30% of users export at least one consultation report
- ✅ Demo mode used by 80% of new installations

### Engagement
- ✅ Average consultations per user increases 20%
- ✅ More diverse persona usage (not just Snarky)
- ✅ Session sharing becomes common team practice

### Developer Experience
- ✅ Time-to-first-value decreases from 30min to 10min
- ✅ GitHub issues about "how to use" decrease 40%
- ✅ User-generated examples/guides appear

### Technical
- ✅ All tests passing (targeting 120+ tests)
- ✅ No performance degradation
- ✅ Zero breaking changes from v0.3.0

---

## 🎭 Consensus from Roundtable

### All Personas Agree On:
1. ✅ Wait for user feedback before building speculatively
2. ✅ Focus on discoverability and accessibility
3. ✅ Enable team collaboration (biggest ROI)
4. ✅ Provide analytics for data-driven improvement
5. ✅ No breaking changes - evolutionary approach

### Key Tensions Resolved:

**Build vs Polish:**
- **Tension:** New features vs improving existing?
- **Resolution:** Do both - analytics is new capability, discovery is polish
- **Decision:** 60% new features, 40% UX improvements

**User-Facing vs Infrastructure:**
- **Tension:** Visible user features vs backend capabilities?
- **Resolution:** Lead with user-visible (demo mode), include infrastructure (analytics)
- **Decision:** All 3 top features have clear user value

**Speed vs Completeness:**
- **Tension:** Ship quick wins vs fully-featured release?
- **Resolution:** Ship top 3 as v0.4.0, quick wins as v0.4.x patches
- **Decision:** Don't delay v0.4.0 for nice-to-haves

---

## 🔄 Feedback Incorporation Plan

**After v0.3.0 launches, we'll track:**

### Quantitative Data
- Which personas are consulted most/least
- Which modes are used (orchestrated, quick, crisis, standards)
- Session sizes and consultation frequency
- Query patterns and context distribution

### Qualitative Feedback
- GitHub issues about feature requests
- User testimonials about what works well
- Pain points in adoption/onboarding
- Requests for new personas or capabilities

### Adjustment Criteria
**We'll adjust v0.4.0 roadmap if:**
- >30% of users request a specific feature not in roadmap
- Analytics show personas are barely used (discovery problem)
- Performance issues emerge requiring architecture changes
- Security/compliance requirements necessitate new features

---

## 🚀 Getting to v0.4.0

### Immediate Actions (Post v0.3.0 Launch)
1. ✅ Monitor PyPI downloads and version adoption
2. ✅ Set up basic analytics (if possible via MCP)
3. ✅ Create "Share your experience" GitHub discussion
4. ✅ Engage with early adopters for feedback

### Pre-Development
1. Validate roadmap with 5-10 users (if available)
2. Prototype demo mode for UX testing
3. Design analytics schema and report formats
4. Write specs for each feature

### Development
1. Feature 1: Session Analytics (TDD approach)
2. Feature 2: Interactive Discovery (user testing)
3. Feature 3: Team Collaboration (dogfood internally)
4. Quick wins as time permits

### Launch
1. Comprehensive testing (target 120+ tests)
2. Documentation updates
3. Migration guide (v0.3.0 → v0.4.0)
4. Release announcement with examples

---

## 📚 Documentation Needs for v0.4.0

**New Documentation:**
- Session Analytics guide with example queries
- Interactive demo mode walkthrough
- Team collaboration best practices
- CI/CD integration examples
- Persona quick reference cards

**Updated Documentation:**
- README.md with v0.4.0 features
- CHANGELOG.md with release notes
- UPGRADING.md for v0.3.0 → v0.4.0 migration
- API reference with new tools

---

## 🎯 V0.4.0 in One Sentence

**"Make Sensei's 22 expert personas more discoverable, measurable, and shareable for individual developers and teams."**

---

## 🔗 Related Documents

- **v0.3.0 Release:** V0.3.0_RELEASE_SUMMARY.md
- **Current Limitations:** LIMITATIONS_ASSESSMENT.md
- **Persona Consultations:** IMPLEMENTATION_PERSONAS.md
- **Changelog:** CHANGELOG.md
- **Upgrade Guide:** UPGRADING.md

---

**Personas Consulted:**
- **Skill Orchestrator** ✅ - Overall synthesis and coordination
- **Pragmatic Architect** ✅ - Technical foundations and evolution
- **Product Engineering Lead** ✅ - User value and adoption
- **DevX Champion** ✅ - Developer experience and onboarding
- **Platform Builder** ✅ - APIs and extensibility

**Status:** Ready for user feedback validation
**Next Review:** After v0.3.0 has 2-4 weeks of production usage

---

Made with 🎭 by the Sensei Multi-Persona Team
