# Prompt 4 – Integrate Summaries & Microfacts into Retrieval

```text
Workspace root: /home/basnijholt/aijournal2
Branch: ab-testing

Background
----------
The capture pipeline generates structured artifacts:
- Stage 2: `derived/summaries/<DATE>.yaml` (daily summaries)
- Stage 3: `derived/microfacts/<DATE>.yaml` (microfacts + claim proposals)

However, retrieval (Stage 6) only indexes normalized entry chunks. Chat/advice search therefore cannot surface summaries or microfacts—everything the model sees comes from raw paragraphs. Packs include those artifacts, but live retrieval does not.

Current Retrieval Stack
-----------------------
- `src/aijournal/commands/index.py` / `src/aijournal/pipelines/index.py` build `derived/index/chroma/` (chunk index) plus SQLite metadata, loading only `NormalizedEntry` YAML.
- `src/aijournal/services/chunk_index.py` persists those chunks in ChromaDB.
- `src/aijournal/services/retriever.py` queries that collection for chat/advice.
- `src/aijournal/services/microfacts/index.py` maintains a separate Chroma index used only inside Stage 3 for semantic dedupe; chat/advice never touch it.

Goal
----
Make summaries and microfacts first-class retrieval units so chat/advice (and any future consumers of the chunk index) can search/cite them alongside raw entry chunks.

Detailed Requirements
---------------------
1. **Chunk Generation**
   - Extend the indexing pipeline so that for each day we also read `derived/summaries/<DATE>.yaml` and `derived/microfacts/<DATE>.yaml` (if present).
   - Convert each summary bullet/highlight/todo and each microfact statement into textual chunks suitable for embedding.
   - Enrich chunk metadata (e.g., `chunk_type: summary | microfact | entry`) so downstream code can distinguish them.

2. **Storage**
   - Store the new chunks in the existing chunk index (`derived/index/chroma/…`) so the retriever automatically sees them. Ensure IDs are unique (e.g., `summary-2025-11-14-01`, `microfact-2025-11-16-02`).
   - Include provenance metadata: date, original file path, and (for microfacts) fact ID.

3. **Retrieval Updates**
   - Update `Retriever`/result formatting so search returns chunks with their `chunk_type`, enabling chat/advice prompts to cite summaries/microfacts explicitly.
   - Adjust chat/advice prompts to reference these (e.g., mention “Summary” or “Microfact” in the context labels, or adopt new citation tags if useful).

4. **Configuration & Telemetry**
   - Add config toggles (e.g., `config.index.include_summaries`, `config.index.include_microfacts`) defaulting to true.
   - Extend index-rebuild/tail telemetry to log how many summary/microfact chunks were generated per run.

5. **Backfill & Graceful Degradation**
   - Document a rebuild procedure so existing workspaces can ingest historical summaries/microfacts.
   - If summary/microfact files are missing for a date, skip without error.

6. **Testing**
   - Unit tests that:
     - Generate chunks from a sample summary/microfact YAML and assert metadata correctness.
     - Ensure retriever can fetch the new chunk types.
   - Integration test (pytest) running capture + index rebuild in a temp workspace, asserting that `derived/index/chroma/meta.json` reflects summary/microfact chunks.

7. **Documentation**
   - Update `ARCHITECTURE.md`, `README.md`, and any workflow docs to note that Stage 6 now indexes summaries/microfacts.
   - Mention the new config knobs and rebuild instructions.

Constraints
-----------
- Existing entry chunks must remain untouched; summaries/microfacts are additive.
- No breaking changes: workspaces without summaries/microfacts must still index raw entries without errors.
- Reuse existing embedding/backfill logic where possible (avoid duplicating code paths).

Success Criteria
----------------
- Running `uv run aijournal ops index rebuild` logs summary/microfact chunk counts, and the resulting index contains them.
- `uv run aijournal ops index search "focus block" --top 5` can return summary/microfact hits with clear labels.
- Chat/advice transcripts can cite these new chunk types.

Deliverables
------------
1. Code implementing chunk generation/storage/retrieval changes.
2. Config + telemetry updates and documentation.
3. Automated tests (unit + integration) covering the new functionality.
4. Short validation report summarizing how the feature was verified end-to-end.
```

