# mypy-boto3-globalaccelerator

[![PyPI - mypy-boto3-globalaccelerator](https://img.shields.io/pypi/v/mypy-boto3-globalaccelerator.svg?color=blue)](https://pypi.org/project/mypy-boto3-globalaccelerator)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-globalaccelerator.svg?color=blue)](https://pypi.org/project/mypy-boto3-globalaccelerator)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.GlobalAccelerator 1.16.23](https://boto3.amazonaws.com/v1/documentation/api/1.16.23/reference/services/globalaccelerator.html#GlobalAccelerator) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-globalaccelerator](#mypy-boto3-globalaccelerator)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `GlobalAccelerator` service.

```bash
python -m pip install boto3-stubs[globalaccelerator]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[globalaccelerator]` in your environment: `python -m pip install 'boto3-stubs[globalaccelerator]'`

Both type checking and auto-complete should work for `GlobalAccelerator` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[globalaccelerator]` in your environment: `python -m pip install 'boto3-stubs[globalaccelerator]'`

Both type checking and auto-complete should work for `GlobalAccelerator` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[globalaccelerator]` in your environment: `python -m pip install 'boto3-stubs[globalaccelerator]'`
- Run `mypy` as usual

Type checking should work for `GlobalAccelerator` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[globalaccelerator]` in your environment: `python -m pip install 'boto3-stubs[globalaccelerator]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GlobalAccelerator` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`GlobalAcceleratorClient` provides annotations for `boto3.client("globalaccelerator")`.

```python
import boto3

from mypy_boto3_globalaccelerator import GlobalAcceleratorClient

client: GlobalAcceleratorClient = boto3.client("globalaccelerator")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GlobalAcceleratorClient = session.client("globalaccelerator")
```

### Paginators annotations

`mypy_boto3_globalaccelerator.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_globalaccelerator import GlobalAcceleratorClient
from mypy_boto3_globalaccelerator.paginator import (
    ListAcceleratorsPaginator,
    ListEndpointGroupsPaginator,
    ListListenersPaginator,
)

client: GlobalAcceleratorClient = boto3.client("globalaccelerator")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_accelerators_paginator: ListAcceleratorsPaginator = client.get_paginator("list_accelerators")
list_endpoint_groups_paginator: ListEndpointGroupsPaginator = client.get_paginator("list_endpoint_groups")
list_listeners_paginator: ListListenersPaginator = client.get_paginator("list_listeners")
```







### Typed dictionations

`mypy_boto3_globalaccelerator.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_globalaccelerator.type_defs import (
    AcceleratorAttributesTypeDef,
    AcceleratorTypeDef,
    AdvertiseByoipCidrResponseTypeDef,
    ByoipCidrEventTypeDef,
    ByoipCidrTypeDef,
    CidrAuthorizationContextTypeDef,
    CreateAcceleratorResponseTypeDef,
    CreateEndpointGroupResponseTypeDef,
    CreateListenerResponseTypeDef,
    DeprovisionByoipCidrResponseTypeDef,
    DescribeAcceleratorAttributesResponseTypeDef,
    DescribeAcceleratorResponseTypeDef,
    DescribeEndpointGroupResponseTypeDef,
    DescribeListenerResponseTypeDef,
    EndpointConfigurationTypeDef,
    EndpointDescriptionTypeDef,
    EndpointGroupTypeDef,
    IpSetTypeDef,
    ListAcceleratorsResponseTypeDef,
    ListByoipCidrsResponseTypeDef,
    ListEndpointGroupsResponseTypeDef,
    ListenerTypeDef,
    ListListenersResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PortOverrideTypeDef,
    PortRangeTypeDef,
    ProvisionByoipCidrResponseTypeDef,
    TagTypeDef,
    UpdateAcceleratorAttributesResponseTypeDef,
    UpdateAcceleratorResponseTypeDef,
    UpdateEndpointGroupResponseTypeDef,
    UpdateListenerResponseTypeDef,
    WithdrawByoipCidrResponseTypeDef,
)

def get_structure() -> AcceleratorAttributesTypeDef:
    return {
      ...
    }
```
