from edc_constants.constants import (
    DEAD,
    MALIGNANCY,
    NOT_APPLICABLE,
    OTHER,
    OTHER_PLEASE_SPECIFY_TEXT,
    TUBERCULOSIS,
    UNKNOWN,
)
from edc_constants.disease_constants import (
    ANAEMIA,
    BACTERAEMIA_SEPSIS,
    BACTERIAL_PNEUMONIA,
    CM_RELAPSE_IRIS,
    COVID_19,
    CRYPTOCOCCAL_MENINGITIS,
    NEUTROPAENIA,
    PNEUMONIA,
    RENAL_IMPAIRMENT,
    TB_PULMONARY,
    THROMBOCYTOPENIA,
)

list_data = {
    "edc_adverse_event.aeclassification": [
        ("cm_possible", "Possible cryptococcal meningitis"),
        ("cm_confirmed", "Confirmed cryptococcal meningitis"),
        (ANAEMIA, "Anaemia"),
        (NEUTROPAENIA, "Neutropaenia"),
        (THROMBOCYTOPENIA, "Thrombocytopenia"),
        (RENAL_IMPAIRMENT, "Renal impairment"),
        (BACTERAEMIA_SEPSIS, "Bacteraemia/sepsis"),
        (TUBERCULOSIS, "TB"),
        (PNEUMONIA, "Pneumonia"),
        ("gastroenteritis", "Gastroenteritis"),
        ("liver_injury_drug", "Drug-induced liver injury"),
        (OTHER, "Other"),
        (NOT_APPLICABLE, "Not applicable"),
    ],
    "edc_adverse_event.saereason": [
        (NOT_APPLICABLE, "Not applicable"),
        (DEAD, "Death"),
        ("life_threatening", "Life-threatening"),
        ("significant_disability", "Significant disability"),
        ("in-patient_hospitalization", "In-patient hospitalization or prolongation"),
        (
            "medically_important_event",
            "Medically important event (e.g. Bacteraemia, "
            "recurrence of symptoms not requiring admission)",
        ),
    ],
    "edc_adverse_event.causeofdeath": [
        (CRYPTOCOCCAL_MENINGITIS, "Cryptococcal meningitis"),
        (BACTERAEMIA_SEPSIS, "Bacteraemia/sepsis"),
        (BACTERIAL_PNEUMONIA, "Bacterial pneumonia"),
        (COVID_19, "COVID-19"),
        (CM_RELAPSE_IRIS, "Cryptococcal meningitis relapse/IRIS"),
        ("iris_non_cm", "IRIS non-CM"),
        (TB_PULMONARY, "TB - Pulmonary"),
        ("tb_meningitis", "TB - Meningitis"),
        ("tb_disseminated", "TB - Disseminated"),
        ("art_toxicity", "ART toxicity"),
        (MALIGNANCY, "Malignancy"),
        ("diarrhea_wasting", "Diarrhea/wasting"),
        ("pcp", "PCP"),
        ("toxoplasmosis", "Toxoplasmosis"),
        (UNKNOWN, "Unknown"),
        (OTHER, OTHER_PLEASE_SPECIFY_TEXT),
    ],
}
