# Generated by Django 3.2.7 on 2021-11-09 00:58

import uuid

import _socket
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_identifier.managers
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_sites.models
import simple_history.models
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("effect_lists", "0001_initial"),
        ("edc_action_item", "0028_auto_20210203_0706"),
        ("edc_protocol_incident", "0003_auto_20211104_1456"),
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="ProtocolDeviationViolation",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "short_description",
                    models.CharField(
                        help_text='Max 35 characters. Note: If this occurrence is a "violation" there is additional space below for a more detailed description',
                        max_length=35,
                        null=True,
                        verbose_name="Provide a short description of this occurrence",
                    ),
                ),
                (
                    "report_type",
                    models.CharField(
                        choices=[
                            ("protocol_violation", "Protocol violation"),
                            ("protocol_deviation", "Protocol deviation"),
                        ],
                        max_length=25,
                        verbose_name="Type of occurrence",
                    ),
                ),
                (
                    "safety_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on safety of the participant?",
                    ),
                ),
                (
                    "safety_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "study_outcomes_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on study outcomes?",
                    ),
                ),
                (
                    "study_outcomes_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "violation_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date violation occurred",
                    ),
                ),
                (
                    "violation_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "violation_description",
                    models.TextField(
                        blank=True,
                        help_text="Describe in full. Explain how the violation happened, what occurred, etc.",
                        null=True,
                        verbose_name="Describe the violation",
                    ),
                ),
                (
                    "violation_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Explain the reason why the violation occurred",
                    ),
                ),
                (
                    "corrective_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Corrective action date and time",
                    ),
                ),
                (
                    "corrective_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Corrective action taken"
                    ),
                ),
                (
                    "preventative_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Preventative action date and time",
                    ),
                ),
                (
                    "preventative_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Preventative action taken"
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                (
                    "violation_type",
                    models.CharField(
                        choices=[
                            (
                                "failure_to_obtain_informed_consent",
                                "Failure to obtain informed consent",
                            ),
                            (
                                "enrollment_of_ineligible_patient",
                                "Enrollment of ineligible patient",
                            ),
                            (
                                "screening_procedure not done",
                                "Screening procedure required by protocol not done",
                            ),
                            (
                                "screening_or_on-study_procedure",
                                "Screening or on-study procedure/lab work required not done",
                            ),
                            (
                                "incorrect_research_treatment",
                                "Incorrect research treatment given to patient",
                            ),
                            (
                                "procedure_not_completed",
                                "On-study procedure required by protocol not completed",
                            ),
                            ("visit_non-compliance", "Visit non-compliance"),
                            ("medication_stopped_early", "Medication stopped early"),
                            ("medication_noncompliance", "Medication_noncompliance"),
                            (
                                "national_regulations_not_met",
                                "Standard WPD, ICH-GCP, local/national regulations not met",
                            ),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="Type of violation",
                    ),
                ),
                (
                    "violation_type_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "action_required_old",
                    models.CharField(
                        choices=[
                            ("remain_on_study", "Participant to remain on trial"),
                            ("to_be_withdrawn", "Participant to be withdrawn from trial"),
                            (
                                "remain_on_study_modified",
                                "Patient remains on study but data analysis will be modified",
                            ),
                        ],
                        max_length=45,
                        null=True,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="effect_prn_action_item",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "action_required",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_protocol_incident.actionsrequired",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "violation",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_protocol_incident.protocolviolations",
                        verbose_name="Type of violation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Protocol Deviation/Violation",
                "verbose_name_plural": "Protocol Deviations/Violations",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
        ),
        migrations.CreateModel(
            name="OnSchedule",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            managers=[
                (
                    "on_site",
                    edc_sites.models.CurrentSiteManager(),
                ),
                ("objects", edc_identifier.managers.SubjectIdentifierManager()),
            ],
        ),
        migrations.CreateModel(
            name="LossToFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "last_seen_datetime",
                    models.DateField(verbose_name="Date participant last seen"),
                ),
                (
                    "number_consecutive_missed_visits",
                    models.DateField(
                        null=True, verbose_name="Number of consecutive visits missed"
                    ),
                ),
                (
                    "last_missed_visit_datetime",
                    models.DateField(
                        null=True, verbose_name="Date of last missed visit report submitted"
                    ),
                ),
                (
                    "home_visited",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has a home visit been made",
                    ),
                ),
                (
                    "home_visit_detail",
                    models.TextField(
                        null=True,
                        verbose_name="If YES, provide any further details of the home visit",
                    ),
                ),
                (
                    "loss_category",
                    models.CharField(
                        choices=[
                            ("unknown_address", "Changed to an unknown address"),
                            ("never_returned", "Did not return despite reminders"),
                            ("bad_contact_details", "Inaccurate contact details"),
                            ("OTHER", "Other, please specify ..."),
                        ],
                        max_length=25,
                        verbose_name="Category of loss to follow up",
                    ),
                ),
                (
                    "loss_category_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        null=True,
                        verbose_name="Please give details of the circumstances that have led to this decision.",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Loss to Follow Ups",
            },
        ),
        migrations.CreateModel(
            name="HistoricalProtocolDeviationViolation",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "short_description",
                    models.CharField(
                        help_text='Max 35 characters. Note: If this occurrence is a "violation" there is additional space below for a more detailed description',
                        max_length=35,
                        null=True,
                        verbose_name="Provide a short description of this occurrence",
                    ),
                ),
                (
                    "report_type",
                    models.CharField(
                        choices=[
                            ("protocol_violation", "Protocol violation"),
                            ("protocol_deviation", "Protocol deviation"),
                        ],
                        max_length=25,
                        verbose_name="Type of occurrence",
                    ),
                ),
                (
                    "safety_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on safety of the participant?",
                    ),
                ),
                (
                    "safety_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "study_outcomes_impact",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=25,
                        verbose_name="Could this occurrence have an impact on study outcomes?",
                    ),
                ),
                (
                    "study_outcomes_impact_details",
                    models.TextField(
                        blank=True, null=True, verbose_name='If "Yes", provide details'
                    ),
                ),
                (
                    "violation_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date violation occurred",
                    ),
                ),
                (
                    "violation_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "violation_description",
                    models.TextField(
                        blank=True,
                        help_text="Describe in full. Explain how the violation happened, what occurred, etc.",
                        null=True,
                        verbose_name="Describe the violation",
                    ),
                ),
                (
                    "violation_reason",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Explain the reason why the violation occurred",
                    ),
                ),
                (
                    "corrective_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Corrective action date and time",
                    ),
                ),
                (
                    "corrective_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Corrective action taken"
                    ),
                ),
                (
                    "preventative_action_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Preventative action date and time",
                    ),
                ),
                (
                    "preventative_action",
                    models.TextField(
                        blank=True, null=True, verbose_name="Preventative action taken"
                    ),
                ),
                (
                    "report_status",
                    models.CharField(
                        choices=[
                            ("open", "Open. Some information is still pending."),
                            ("closed", "Closed. This report is complete"),
                        ],
                        max_length=25,
                        verbose_name="What is the status of this report?",
                    ),
                ),
                (
                    "report_closed_datetime",
                    models.DateTimeField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date and time report closed.",
                    ),
                ),
                (
                    "violation_type",
                    models.CharField(
                        choices=[
                            (
                                "failure_to_obtain_informed_consent",
                                "Failure to obtain informed consent",
                            ),
                            (
                                "enrollment_of_ineligible_patient",
                                "Enrollment of ineligible patient",
                            ),
                            (
                                "screening_procedure not done",
                                "Screening procedure required by protocol not done",
                            ),
                            (
                                "screening_or_on-study_procedure",
                                "Screening or on-study procedure/lab work required not done",
                            ),
                            (
                                "incorrect_research_treatment",
                                "Incorrect research treatment given to patient",
                            ),
                            (
                                "procedure_not_completed",
                                "On-study procedure required by protocol not completed",
                            ),
                            ("visit_non-compliance", "Visit non-compliance"),
                            ("medication_stopped_early", "Medication stopped early"),
                            ("medication_noncompliance", "Medication_noncompliance"),
                            (
                                "national_regulations_not_met",
                                "Standard WPD, ICH-GCP, local/national regulations not met",
                            ),
                            ("OTHER", "Other"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=75,
                        verbose_name="Type of violation",
                    ),
                ),
                (
                    "violation_type_other",
                    models.CharField(
                        blank=True,
                        max_length=75,
                        null=True,
                        verbose_name="If other, please specify",
                    ),
                ),
                (
                    "action_required_old",
                    models.CharField(
                        choices=[
                            ("remain_on_study", "Participant to remain on trial"),
                            ("to_be_withdrawn", "Participant to be withdrawn from trial"),
                            (
                                "remain_on_study_modified",
                                "Patient remains on study but data analysis will be modified",
                            ),
                        ],
                        max_length=45,
                        null=True,
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "action_required",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_protocol_incident.actionsrequired",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "violation",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_protocol_incident.protocolviolations",
                        verbose_name="Type of violation",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Protocol Deviation/Violation",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalOnSchedule",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "onschedule_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical on schedule",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalLossToFollowup",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=django.utils.timezone.now, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "last_seen_datetime",
                    models.DateField(verbose_name="Date participant last seen"),
                ),
                (
                    "number_consecutive_missed_visits",
                    models.DateField(
                        null=True, verbose_name="Number of consecutive visits missed"
                    ),
                ),
                (
                    "last_missed_visit_datetime",
                    models.DateField(
                        null=True, verbose_name="Date of last missed visit report submitted"
                    ),
                ),
                (
                    "home_visited",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Has a home visit been made",
                    ),
                ),
                (
                    "home_visit_detail",
                    models.TextField(
                        null=True,
                        verbose_name="If YES, provide any further details of the home visit",
                    ),
                ),
                (
                    "loss_category",
                    models.CharField(
                        choices=[
                            ("unknown_address", "Changed to an unknown address"),
                            ("never_returned", "Did not return despite reminders"),
                            ("bad_contact_details", "Inaccurate contact details"),
                            ("OTHER", "Other, please specify ..."),
                        ],
                        max_length=25,
                        verbose_name="Category of loss to follow up",
                    ),
                ),
                (
                    "loss_category_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        null=True,
                        verbose_name="Please give details of the circumstances that have led to this decision.",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Loss to Follow Ups",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalEndOfStudy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(db_index=True, max_length=50)),
                ("tracking_identifier", models.CharField(db_index=True, max_length=32)),
                ("action_identifier", models.CharField(db_index=True, max_length=50)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date patient was terminated from the study",
                    ),
                ),
                (
                    "other_offschedule_reason",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of death, if applicable",
                    ),
                ),
                (
                    "ltfu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date lost to followup, if applicable",
                    ),
                ),
                (
                    "transferred_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="If transferred, has the patient provided consent to be followed-up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="Please provide further details if possible",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "offschedule_reason",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_lists.offstudyreasons",
                        verbose_name="Reason patient was terminated from the study",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical End of Study",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="EndOfStudy",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50, unique=True)),
                ("tracking_identifier", models.CharField(max_length=32, unique=True)),
                ("action_identifier", models.CharField(max_length=50, unique=True)),
                (
                    "parent_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to parent reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                (
                    "related_action_identifier",
                    models.CharField(
                        blank=True,
                        help_text="action identifier that links to related reference model instance.",
                        max_length=30,
                        null=True,
                    ),
                ),
                ("action_item_reason", models.TextField(editable=False, null=True)),
                ("report_datetime", models.DateTimeField(editable=False)),
                (
                    "offschedule_datetime",
                    models.DateTimeField(
                        null=True,
                        validators=[edc_model.validators.date.datetime_not_future],
                        verbose_name="Date patient was terminated from the study",
                    ),
                ),
                (
                    "other_offschedule_reason",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="If OTHER, please specify",
                    ),
                ),
                (
                    "death_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of death, if applicable",
                    ),
                ),
                (
                    "ltfu_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date lost to followup, if applicable",
                    ),
                ),
                (
                    "transferred_consent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="If transferred, has the patient provided consent to be followed-up?",
                    ),
                ),
                (
                    "comment",
                    models.TextField(
                        blank=True,
                        max_length=500,
                        null=True,
                        verbose_name="Please provide further details if possible",
                    ),
                ),
                (
                    "action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "offschedule_reason",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_lists.offstudyreasons",
                        verbose_name="Reason patient was terminated from the study",
                    ),
                ),
                (
                    "parent_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "related_action_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="edc_action_item.actionitem",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "End of Study",
                "verbose_name_plural": "End of Study",
                "abstract": False,
            },
            managers=[
                (
                    "on_site",
                    edc_sites.models.CurrentSiteManager(),
                ),
                ("objects", edc_identifier.managers.SubjectIdentifierManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="protocoldeviationviolation",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="effect_prn__subject_8756fb_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="onschedule",
            index=models.Index(
                fields=["id", "subject_identifier", "onschedule_datetime", "site"],
                name="effect_prn__id_677d9e_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="losstofollowup",
            index=models.Index(
                fields=["subject_identifier", "action_identifier", "site", "id"],
                name="effect_prn__subject_268741_idx",
            ),
        ),
        migrations.AddIndex(
            model_name="endofstudy",
            index=models.Index(
                fields=["id", "subject_identifier", "offschedule_datetime", "site"],
                name="effect_prn__id_ee8065_idx",
            ),
        ),
    ]
