# Generated by Django 3.2.9 on 2021-11-18 15:21

import uuid

import _socket
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_crypto_fields.fields.encrypted_char_field
import django_revision.revision_field
import edc_model.validators.date
import edc_model_fields.fields.other_charfield
import edc_screening.model_mixins.screening_fields_model_mixin
import edc_sites.models
import edc_utils.date
import simple_history.models
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="SubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        unique=True,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        editable=False,
                        max_length=50,
                        unique=True,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not suitable for the study",
                    ),
                ),
                (
                    "unsuitable_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="Does the study coordinator agree that the patient is not suitable for the study?",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                ("refused", models.BooleanField(default=False, editable=False)),
                (
                    "willing_to_participate",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is the patient willing to participate in the study if found eligible?",
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does the patient have capacity to provide informed consent for participation?",
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Is the patient HIV sero-positive",
                    ),
                ),
                (
                    "cd4_value",
                    models.IntegerField(
                        help_text="Eligible if CD4 count <100 cells/μL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Most recent CD4 count",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Most recent CD4 count date",
                    ),
                ),
                (
                    "pregnant_or_bf",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male or post-menopausal"),
                            ("not_evaluated", "Not evaluated"),
                        ],
                        default="not_evaluated",
                        max_length=15,
                        verbose_name="Is the patient pregnant or breastfeeding?",
                    ),
                ),
                (
                    "serum_crag_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=15,
                        verbose_name="Serum/plasma CrAg result",
                    ),
                ),
                (
                    "serum_crag_date",
                    models.DateField(
                        blank=True,
                        help_text="Test must have been performed within the last 14 days",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of serum/plasma CrAg result",
                    ),
                ),
                (
                    "lp_done",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, provide date below",
                        max_length=15,
                        null=True,
                        verbose_name="Was LP done?",
                    ),
                ),
                (
                    "lp_date",
                    models.DateField(
                        blank=True,
                        help_text="LP date must be after AFTER serum/plasma CrAg result",
                        null=True,
                        verbose_name="LP date",
                    ),
                ),
                (
                    "lp_declined",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="If LP not done, was LP declined?",
                    ),
                ),
                (
                    "csf_crag_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="If result is `pending`, report on DAY 1 / baseline visit or when available.",
                        max_length=15,
                        verbose_name="CSF CrAg result",
                    ),
                ),
                (
                    "prior_cm_epidose",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Has the patient had a prior episode of CM?",
                    ),
                ),
                (
                    "prior_cm_epidose_date",
                    models.DateField(blank=True, null=True, verbose_name="CM episode date"),
                ),
                (
                    "reaction_to_study_drugs",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Has the patient had any serious reaction to flucytosine or fluconazole?",
                    ),
                ),
                (
                    "on_fluconazole",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Is the patent already taking high-dose fluconazole treatment (800-1200 mg/day) for ≥1 week?",
                    ),
                ),
                (
                    "contraindicated_meds",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Is the patient taking any contraindicated concomitant medications (see below)?",
                    ),
                ),
                (
                    "meningitis_symptoms",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        help_text="i.e. a progressively severe headache OR a headache and marked nuchal rigidity OR a head- ache and vomiting OR seizures OR a Glasgow Coma Scale (GCS) score of <15?",
                        max_length=25,
                        verbose_name="Has the patient had clinical symptoms/ signs of symptomatic meningitis at any time since CrAg screening?",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Based on clinical examination, does the patient have jaundice?",
                    ),
                ),
                (
                    "csf_cm_value",
                    models.CharField(
                        choices=[
                            ("POS", "CM Positive"),
                            ("NEG", "CM Negative"),
                            ("N/A", "Not applicable"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        help_text="i.e. positive microscopy with India Ink, culture, or CrAg test) at any time between the CrAg test and screening for eligibility, or during the first 2 weeks of antifungal treatment, while the patient remained without clinical symptoms/ signs of meningitis as described in 15 above (late withdrawal criterion)",
                        max_length=25,
                        verbose_name="CSF result for CM?",
                    ),
                ),
                (
                    "csf_cm_date",
                    models.DateField(blank=True, null=True, verbose_name="CSF date"),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Screening",
                "verbose_name_plural": "Subject Screening",
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
                (
                    "objects",
                    edc_screening.model_mixins.ScreeningManager(),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                ("screening_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            ("dont_want_blood_drawn", "I don't want to have the blood drawn"),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_screening.subjectscreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "Subject Refusal",
                "verbose_name_plural": "Subject Refusals",
            },
            managers=[
                ("on_site", edc_sites.models.CurrentSiteManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalSubjectScreening",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                ("subject_identifier", models.CharField(max_length=50)),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                (
                    "slug",
                    models.CharField(
                        db_index=True,
                        default="",
                        editable=False,
                        help_text="a field used for quick search",
                        max_length=250,
                        null=True,
                    ),
                ),
                (
                    "reference",
                    models.UUIDField(
                        db_index=True,
                        default=uuid.uuid4,
                        editable=False,
                        verbose_name="Reference",
                    ),
                ),
                (
                    "screening_identifier",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        max_length=50,
                        verbose_name="Screening ID",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="Date and time of report.",
                        verbose_name="Report Date and Time",
                    ),
                ),
                (
                    "initials",
                    django_crypto_fields.fields.encrypted_char_field.EncryptedCharField(
                        blank=True,
                        help_text="Use UPPERCASE letters only. May be 2 or 3 letters. (Encryption: RSA local)",
                        max_length=71,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[A-Z]{1,3}", "Invalid format"
                            ),
                            django.core.validators.MinLengthValidator(2),
                            django.core.validators.MaxLengthValidator(3),
                        ],
                    ),
                ),
                (
                    "gender",
                    models.CharField(choices=[("M", "Male"), ("F", "Female")], max_length=10),
                ),
                (
                    "age_in_years",
                    models.IntegerField(
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(110),
                        ]
                    ),
                ),
                (
                    "unsuitable_for_study",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="No",
                        help_text="If YES, patient NOT eligible, please give reason below.",
                        max_length=5,
                        verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
                    ),
                ),
                (
                    "reasons_unsuitable",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not suitable for the study",
                    ),
                ),
                (
                    "unsuitable_agreed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="Does the study coordinator agree that the patient is not suitable for the study?",
                    ),
                ),
                ("eligible", models.BooleanField(default=False, editable=False)),
                (
                    "reasons_ineligible",
                    models.TextField(
                        editable=False,
                        max_length=150,
                        null=True,
                        verbose_name="Reason not eligible",
                    ),
                ),
                (
                    "eligibility_datetime",
                    models.DateTimeField(
                        editable=False,
                        help_text="Date and time eligibility was determined",
                        null=True,
                    ),
                ),
                ("consented", models.BooleanField(default=False, editable=False)),
                ("refused", models.BooleanField(default=False, editable=False)),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "willing_to_participate",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Is the patient willing to participate in the study if found eligible?",
                    ),
                ),
                (
                    "consent_ability",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=25,
                        verbose_name="Does the patient have capacity to provide informed consent for participation?",
                    ),
                ),
                (
                    "hiv_pos",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        null=True,
                        verbose_name="Is the patient HIV sero-positive",
                    ),
                ),
                (
                    "cd4_value",
                    models.IntegerField(
                        help_text="Eligible if CD4 count <100 cells/μL",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Most recent CD4 count",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Most recent CD4 count date",
                    ),
                ),
                (
                    "pregnant_or_bf",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("N/A", "Not Applicable: e.g. male or post-menopausal"),
                            ("not_evaluated", "Not evaluated"),
                        ],
                        default="not_evaluated",
                        max_length=15,
                        verbose_name="Is the patient pregnant or breastfeeding?",
                    ),
                ),
                (
                    "serum_crag_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=15,
                        verbose_name="Serum/plasma CrAg result",
                    ),
                ),
                (
                    "serum_crag_date",
                    models.DateField(
                        blank=True,
                        help_text="Test must have been performed within the last 14 days",
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date of serum/plasma CrAg result",
                    ),
                ),
                (
                    "lp_done",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="If YES, provide date below",
                        max_length=15,
                        null=True,
                        verbose_name="Was LP done?",
                    ),
                ),
                (
                    "lp_date",
                    models.DateField(
                        blank=True,
                        help_text="LP date must be after AFTER serum/plasma CrAg result",
                        null=True,
                        verbose_name="LP date",
                    ),
                ),
                (
                    "lp_declined",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="If LP not done, was LP declined?",
                    ),
                ),
                (
                    "csf_crag_value",
                    models.CharField(
                        choices=[
                            ("POS", "Positive"),
                            ("NEG", "Negative"),
                            ("IND", "Indeterminate"),
                            ("PENDING", "Pending"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        help_text="If result is `pending`, report on DAY 1 / baseline visit or when available.",
                        max_length=15,
                        verbose_name="CSF CrAg result",
                    ),
                ),
                (
                    "prior_cm_epidose",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Has the patient had a prior episode of CM?",
                    ),
                ),
                (
                    "prior_cm_epidose_date",
                    models.DateField(blank=True, null=True, verbose_name="CM episode date"),
                ),
                (
                    "reaction_to_study_drugs",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Has the patient had any serious reaction to flucytosine or fluconazole?",
                    ),
                ),
                (
                    "on_fluconazole",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Is the patent already taking high-dose fluconazole treatment (800-1200 mg/day) for ≥1 week?",
                    ),
                ),
                (
                    "contraindicated_meds",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Is the patient taking any contraindicated concomitant medications (see below)?",
                    ),
                ),
                (
                    "meningitis_symptoms",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        help_text="i.e. a progressively severe headache OR a headache and marked nuchal rigidity OR a head- ache and vomiting OR seizures OR a Glasgow Coma Scale (GCS) score of <15?",
                        max_length=25,
                        verbose_name="Has the patient had clinical symptoms/ signs of symptomatic meningitis at any time since CrAg screening?",
                    ),
                ),
                (
                    "jaundice",
                    models.CharField(
                        choices=[
                            ("Yes", "Yes"),
                            ("No", "No"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        max_length=25,
                        verbose_name="Based on clinical examination, does the patient have jaundice?",
                    ),
                ),
                (
                    "csf_cm_value",
                    models.CharField(
                        choices=[
                            ("POS", "CM Positive"),
                            ("NEG", "CM Negative"),
                            ("N/A", "Not applicable"),
                            ("not_answered", "Not answered"),
                        ],
                        default="not_answered",
                        help_text="i.e. positive microscopy with India Ink, culture, or CrAg test) at any time between the CrAg test and screening for eligibility, or during the first 2 weeks of antifungal treatment, while the patient remained without clinical symptoms/ signs of meningitis as described in 15 above (late withdrawal criterion)",
                        max_length=25,
                        verbose_name="CSF result for CM?",
                    ),
                ),
                (
                    "csf_cm_date",
                    models.DateField(blank=True, null=True, verbose_name="CSF date"),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Screening",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSubjectRefusal",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "subject_identifier_as_pk",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "subject_identifier_aka",
                    models.CharField(
                        editable=False,
                        help_text="track a previously allocated identifier.",
                        max_length=50,
                        null=True,
                        verbose_name="Subject Identifier a.k.a",
                    ),
                ),
                ("subject_identifier", models.CharField(editable=False, max_length=50)),
                ("screening_identifier", models.CharField(editable=False, max_length=50)),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow, verbose_name="Report Date and Time"
                    ),
                ),
                (
                    "reason",
                    models.CharField(
                        choices=[
                            ("dont_have_time", "I don't have time"),
                            ("must_consult_spouse", "I need to consult my spouse"),
                            ("dont_want_blood_drawn", "I don't want to have the blood drawn"),
                            ("dont_want_to_join", "I don't want to take part"),
                            (
                                "need_to_think_about_it",
                                "I haven't had a chance to think about it",
                            ),
                            ("OTHER", "Other, please specify"),
                        ],
                        max_length=25,
                        verbose_name="Reason for refusal to join",
                    ),
                ),
                (
                    "other_reason",
                    edc_model_fields.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_screening",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_screening.subjectscreening",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Subject Refusal",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
