# Generated by Django 3.2.8 on 2022-03-22 18:29

import uuid

import _socket
import django.contrib.sites.managers
import django.core.validators
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.date_estimated
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
from django.conf import settings
from django.db import migrations, models
import django.utils.timezone


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("sites", "0002_alter_domain_unique"),
        ("effect_lists", "0006_auto_20220322_2029"),
        ("effect_subject", "0026_auto_20220309_1441"),
    ]

    operations = [
        migrations.CreateModel(
            name="AdherenceStageFour",
            fields=[],
            options={
                "verbose_name": "Adherence: Week 4+",
                "verbose_name_plural": "Adherence: Week 4+",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_subject.adherence",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="AdherenceStageOne",
            fields=[],
            options={
                "verbose_name": "Adherence: Day 1",
                "verbose_name_plural": "Adherence: Day 1",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_subject.adherence",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="AdherenceStageThree",
            fields=[],
            options={
                "verbose_name": "Adherence: Day 14",
                "verbose_name_plural": "Adherence: Day 14",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_subject.adherence",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="AdherenceStageTwo",
            fields=[],
            options={
                "verbose_name": "Adherence: Day 3/9",
                "verbose_name_plural": "Adherence: Day 3/9",
                "proxy": True,
                "indexes": [],
                "constraints": [],
            },
            bases=("effect_subject.adherence",),
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.RemoveField(
            model_name="followup",
            name="adherence_counselling",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="assessment_type",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="assessment_type_other",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="hospitalized",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="info_source",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="info_source_other",
        ),
        migrations.RemoveField(
            model_name="followup",
            name="survival_status",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="adherence_counselling",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="assessment_type",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="assessment_type_other",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="hospitalized",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="info_source",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="info_source_other",
        ),
        migrations.RemoveField(
            model_name="historicalfollowup",
            name="survival_status",
        ),
        migrations.AddField(
            model_name="adherence",
            name="adherence_counselling",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="adherence_counselling_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="adherence_narrative",
            field=models.TextField(
                blank=True, null=True, verbose_name="Medication adherence narrative:"
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="any_fluconazole_doses_missed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                default="N/A",
                max_length=15,
                verbose_name="Have any Fluconazole doses been missed since the last visit?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="any_flucytosine_doses_missed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                default="N/A",
                max_length=15,
                verbose_name="Have any Flucytosine doses been missed since the last visit?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the patient?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_issued_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_match_pill_count",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the patient adherence diary match the pill count?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_match_pill_count_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was patient adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="diary_returned_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="fluconazole_doses_missed",
            field=models.IntegerField(
                default=0,
                help_text="This should be measured in single doses (1 dose per day)",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(14),
                ],
                verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="flucytosine_doses_missed",
            field=models.IntegerField(
                default=0,
                help_text="This should be measured in single doses (4 doses per day)",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(56),
                ],
                verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="opinion_art_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="opinion_fluconazole_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="pill_count_conducted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was a pill count conducted?",
            ),
        ),
        migrations.AddField(
            model_name="adherence",
            name="pill_count_conducted_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="adherence_counselling",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="adherence_counselling_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="adherence_narrative",
            field=models.TextField(
                blank=True, null=True, verbose_name="Medication adherence narrative:"
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="any_fluconazole_doses_missed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                default="N/A",
                max_length=15,
                verbose_name="Have any Fluconazole doses been missed since the last visit?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="any_flucytosine_doses_missed",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                default="N/A",
                max_length=15,
                verbose_name="Have any Flucytosine doses been missed since the last visit?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_issued",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was an adherence diary issued to the patient?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_issued_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_match_pill_count",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Did the patient adherence diary match the pill count?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_match_pill_count_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_returned",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was patient adherence diary received and stored in patient records?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="diary_returned_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="fluconazole_doses_missed",
            field=models.IntegerField(
                default=0,
                help_text="This should be measured in single doses (1 dose per day)",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(14),
                ],
                verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="flucytosine_doses_missed",
            field=models.IntegerField(
                default=0,
                help_text="This should be measured in single doses (4 doses per day)",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(56),
                ],
                verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="opinion_art_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="opinion_fluconazole_adherent",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="pill_count_conducted",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                max_length=15,
                verbose_name="Was a pill count conducted?",
            ),
        ),
        migrations.AddField(
            model_name="historicaladherence",
            name="pill_count_conducted_reason_no",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If 'No', please specify reason ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="assessment_type",
            field=models.CharField(
                choices=[
                    ("telephone", "Telephone"),
                    ("in_person", "In person"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                default="-",
                max_length=15,
                verbose_name="Was this a telephone or an in person visit?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="assessment_type_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="assessment_who",
            field=models.CharField(
                choices=[
                    ("patient", "Patient"),
                    ("next_of_kin", "Next of kin"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                default="-",
                max_length=15,
                verbose_name="Who did you speak to?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="assessment_who_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="historicalsubjectvisit",
            name="hospitalized",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                help_text="If yes, complete AE Initial report.",
                max_length=15,
                verbose_name="Has the patient been hospitalized since the last assessment?",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="assessment_type",
            field=models.CharField(
                choices=[
                    ("telephone", "Telephone"),
                    ("in_person", "In person"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                default="-",
                max_length=15,
                verbose_name="Was this a telephone or an in person visit?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="assessment_type_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="assessment_who",
            field=models.CharField(
                choices=[
                    ("patient", "Patient"),
                    ("next_of_kin", "Next of kin"),
                    ("OTHER", "Other, please specify below ..."),
                ],
                default="-",
                max_length=15,
                verbose_name="Who did you speak to?",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="assessment_who_other",
            field=edc_model.models.fields.other_charfield.OtherCharField(
                blank=True,
                max_length=35,
                null=True,
                verbose_name="If other, please specify ...",
            ),
        ),
        migrations.AddField(
            model_name="subjectvisit",
            name="hospitalized",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                default="N/A",
                help_text="If yes, complete AE Initial report.",
                max_length=15,
                verbose_name="Has the patient been hospitalized since the last assessment?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectvisit",
            name="info_source",
            field=models.CharField(
                choices=[
                    ("patient", "Patient"),
                    (
                        "patient_representative",
                        "Patient representative (e.g., next of kin, relative, guardian)",
                    ),
                    ("hospital_notes", "Hospital notes"),
                    ("outpatient_cards", "Outpatient cards"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What is the MAIN source of this information?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectvisit",
            name="info_source",
            field=models.CharField(
                choices=[
                    ("patient", "Patient"),
                    (
                        "patient_representative",
                        "Patient representative (e.g., next of kin, relative, guardian)",
                    ),
                    ("hospital_notes", "Hospital notes"),
                    ("outpatient_cards", "Outpatient cards"),
                    ("N/A", "Not applicable (if missed)"),
                    ("OTHER", "Other"),
                ],
                max_length=25,
                verbose_name="What is the MAIN source of this information?",
            ),
        ),
        migrations.CreateModel(
            name="PatientHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "fluconazole_1w_prior_rando",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Fluconazole taken within 1 week prior to randomization?",
                    ),
                ),
                (
                    "fluconazole_days",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If YES, number of days Fluconazole taken:",
                    ),
                ),
                (
                    "fluconazole_dose",
                    models.CharField(
                        choices=[
                            ("800mg", "Fluconazole, 800mg/d"),
                            ("1200mg", "Fluconazole, 1200mg/d"),
                            ("OTHER", "Other Fluconazole dose, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in mg/d",
                        max_length=25,
                        verbose_name="If YES, Fluconazole dose (if taken < 1 week prior to randomisation):",
                    ),
                ),
                (
                    "fluconazole_dose_other",
                    models.IntegerField(
                        blank=True,
                        help_text="in mg/d",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Other Fluconazole dose (if taken < 1 week prior to randomisation):",
                    ),
                ),
                (
                    "fluconazole_dose_other_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="Other Fluconazole dose reason:",
                    ),
                ),
                (
                    "current_arv_decision",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("art_continued", "ART continued"),
                            ("art_stopped", "ART stopped"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="What decision was made at admission regarding their <u>current</u> ART regimen?",
                    ),
                ),
                (
                    "reported_neuro_abnormality",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Must be confirmed as not related to CM",
                        max_length=5,
                        verbose_name="Is there any reported neurological abnormality following examination by a medical practitioner?",
                    ),
                ),
                (
                    "neuro_abnormality_details",
                    models.TextField(verbose_name="Details of neurological abnormality?"),
                ),
                (
                    "abnormal_lung_exam",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Abnormal lung exam:",
                    ),
                ),
                (
                    "any_medications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Other medication?",
                    ),
                ),
                (
                    "specify_steroid_other",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If STEROID, specify type and dose of steroid ...",
                    ),
                ),
                (
                    "specify_medications_other",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If OTHER, specify ...",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "specify_medications",
                    models.ManyToManyField(blank=True, to="effect_lists.Medication"),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Patient History",
                "verbose_name_plural": "Patient History",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="MedicalHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "tb_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Previous diagnosis of Tuberculosis?",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("pulmonary", "Pulmonary"),
                            ("extra_pulmonary", "Extra-pulmonary"),
                            ("both", "Both"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="If YES, site of TB?",
                    ),
                ),
                (
                    "tb_tx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Are you currently taking TB treatment?",
                    ),
                ),
                (
                    "tb_dx_ago",
                    models.CharField(
                        choices=[
                            ("lte_5_yrs", "During past 5 years (no longer on treatment)"),
                            ("gt_5_yrs", "More than 5 years ago (no longer on treatment)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="If NO, when was TB diagnosis?",
                    ),
                ),
                (
                    "taking_rifampicin",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If YES, are you currently also taking Rifampicin?",
                    ),
                ),
                (
                    "rifampicin_started_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when did you first start taking Rifampicin?",
                    ),
                ),
                (
                    "previous_oi",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Previous opportunistic infection other than TB?",
                    ),
                ),
                (
                    "previous_oi_name",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If YES, specify opportunistic infection name?",
                    ),
                ),
                (
                    "previous_oi_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, what was the date of the previous opportunistic infection diagnosis?",
                    ),
                ),
                (
                    "new_hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Is this a new HIV diagnosis?",
                    ),
                ),
                (
                    "hiv_dx_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date HIV diagnosis first known",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "Medical History",
                "verbose_name_plural": "Medical History",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.CreateModel(
            name="HistoricalPatientHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "fluconazole_1w_prior_rando",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Fluconazole taken within 1 week prior to randomization?",
                    ),
                ),
                (
                    "fluconazole_days",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="If YES, number of days Fluconazole taken:",
                    ),
                ),
                (
                    "fluconazole_dose",
                    models.CharField(
                        choices=[
                            ("800mg", "Fluconazole, 800mg/d"),
                            ("1200mg", "Fluconazole, 1200mg/d"),
                            ("OTHER", "Other Fluconazole dose, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        help_text="in mg/d",
                        max_length=25,
                        verbose_name="If YES, Fluconazole dose (if taken < 1 week prior to randomisation):",
                    ),
                ),
                (
                    "fluconazole_dose_other",
                    models.IntegerField(
                        blank=True,
                        help_text="in mg/d",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(1)],
                        verbose_name="Other Fluconazole dose (if taken < 1 week prior to randomisation):",
                    ),
                ),
                (
                    "fluconazole_dose_other_reason",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="Other Fluconazole dose reason:",
                    ),
                ),
                (
                    "current_arv_decision",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("art_continued", "ART continued"),
                            ("art_stopped", "ART stopped"),
                        ],
                        default="N/A",
                        max_length=25,
                        verbose_name="What decision was made at admission regarding their <u>current</u> ART regimen?",
                    ),
                ),
                (
                    "reported_neuro_abnormality",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        help_text="Must be confirmed as not related to CM",
                        max_length=5,
                        verbose_name="Is there any reported neurological abnormality following examination by a medical practitioner?",
                    ),
                ),
                (
                    "neuro_abnormality_details",
                    models.TextField(verbose_name="Details of neurological abnormality?"),
                ),
                (
                    "abnormal_lung_exam",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Abnormal lung exam:",
                    ),
                ),
                (
                    "any_medications",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Other medication?",
                    ),
                ),
                (
                    "specify_steroid_other",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If STEROID, specify type and dose of steroid ...",
                    ),
                ),
                (
                    "specify_medications_other",
                    models.TextField(
                        blank=True,
                        max_length=150,
                        null=True,
                        verbose_name="If OTHER, specify ...",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Patient History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalMedicalHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "tb_history",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Previous diagnosis of Tuberculosis?",
                    ),
                ),
                (
                    "tb_site",
                    models.CharField(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("pulmonary", "Pulmonary"),
                            ("extra_pulmonary", "Extra-pulmonary"),
                            ("both", "Both"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="If YES, site of TB?",
                    ),
                ),
                (
                    "tb_tx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Are you currently taking TB treatment?",
                    ),
                ),
                (
                    "tb_dx_ago",
                    models.CharField(
                        choices=[
                            ("lte_5_yrs", "During past 5 years (no longer on treatment)"),
                            ("gt_5_yrs", "More than 5 years ago (no longer on treatment)"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=15,
                        verbose_name="If NO, when was TB diagnosis?",
                    ),
                ),
                (
                    "taking_rifampicin",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If YES, are you currently also taking Rifampicin?",
                    ),
                ),
                (
                    "rifampicin_started_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when did you first start taking Rifampicin?",
                    ),
                ),
                (
                    "previous_oi",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Previous opportunistic infection other than TB?",
                    ),
                ),
                (
                    "previous_oi_name",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If YES, specify opportunistic infection name?",
                    ),
                ),
                (
                    "previous_oi_dx_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, what was the date of the previous opportunistic infection diagnosis?",
                    ),
                ),
                (
                    "new_hiv_dx",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Is this a new HIV diagnosis?",
                    ),
                ),
                (
                    "hiv_dx_date",
                    models.DateField(
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Date HIV diagnosis first known",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Medical History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalArvHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "taking_arv_at_crag",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Was the patient taking ART at time of CrAg test?",
                    ),
                ),
                (
                    "ever_taken_arv",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If NO, has the patient ever been on ART prior to CrAg test?",
                    ),
                ),
                (
                    "initial_arv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when did the patient <u>start</u> ART for the first time.",
                    ),
                ),
                (
                    "initial_arv_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If YES, is this ART date estimated?",
                    ),
                ),
                (
                    "initial_arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "has_switched_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="Has the patient ever switched ART regimen?",
                    ),
                ),
                (
                    "current_arv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when was their <u>current or most recent</u> ART regimen started?",
                    ),
                ),
                (
                    "current_arv_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If YES, is this ART date estimated?",
                    ),
                ),
                (
                    "current_arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "current_arv_is_defaulted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="'DEFAULTED' means no ART for at least one month.",
                        max_length=5,
                        verbose_name="Has the patient <u>now</u> defaulted from their ART regimen?",
                    ),
                ),
                (
                    "current_arv_defaulted_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If the patient has DEFAULTED, on what date did they default from their <u>most recent</u> ART regimen?",
                    ),
                ),
                (
                    "current_arv_defaulted_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If DEFAULTED, is this date estimated?",
                    ),
                ),
                (
                    "current_arv_is_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If the patient is currently on ART, are they ADHERENT to their <u>current</u> ART regimen?",
                    ),
                ),
                (
                    "current_arv_tablets_missed",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(31),
                        ],
                        verbose_name="If not ADHERENT, how many doses missed in the last month?",
                    ),
                ),
                (
                    "last_viral_load",
                    models.DecimalField(
                        blank=True,
                        decimal_places=3,
                        help_text="copies/mL",
                        max_digits=10,
                        null=True,
                        verbose_name="Last Viral Load, if known?",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Viral Load date",
                    ),
                ),
                (
                    "vl_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the subject's Viral Load date estimated?",
                    ),
                ),
                (
                    "last_cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(99),
                        ],
                        verbose_name="Last CD4, if known?",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="CD4 date",
                    ),
                ),
                (
                    "cd4_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the subject's CD4 date estimated?",
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical ARV History",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAdherenceStageTwo",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
                    ),
                ),
                (
                    "adherence_counselling_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_issued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was an adherence diary issued to the patient?",
                    ),
                ),
                (
                    "diary_issued_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "any_fluconazole_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Fluconazole doses been missed since the last visit?",
                    ),
                ),
                (
                    "fluconazole_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (1 dose per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(14),
                        ],
                        verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
                    ),
                ),
                (
                    "any_flucytosine_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Flucytosine doses been missed since the last visit?",
                    ),
                ),
                (
                    "flucytosine_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (4 doses per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(56),
                        ],
                        verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
                    ),
                ),
                (
                    "pill_count_conducted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was a pill count conducted?",
                    ),
                ),
                (
                    "pill_count_conducted_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_returned",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was patient adherence diary received and stored in patient records?",
                    ),
                ),
                (
                    "diary_returned_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_match_pill_count",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did the patient adherence diary match the pill count?",
                    ),
                ),
                (
                    "diary_match_pill_count_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "opinion_fluconazole_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
                    ),
                ),
                (
                    "opinion_art_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
                    ),
                ),
                (
                    "adherence_narrative",
                    models.TextField(
                        blank=True, null=True, verbose_name="Medication adherence narrative:"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Adherence: Day 3/9",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAdherenceStageThree",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
                    ),
                ),
                (
                    "adherence_counselling_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_issued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was an adherence diary issued to the patient?",
                    ),
                ),
                (
                    "diary_issued_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "any_fluconazole_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Fluconazole doses been missed since the last visit?",
                    ),
                ),
                (
                    "fluconazole_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (1 dose per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(14),
                        ],
                        verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
                    ),
                ),
                (
                    "any_flucytosine_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Flucytosine doses been missed since the last visit?",
                    ),
                ),
                (
                    "flucytosine_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (4 doses per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(56),
                        ],
                        verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
                    ),
                ),
                (
                    "pill_count_conducted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was a pill count conducted?",
                    ),
                ),
                (
                    "pill_count_conducted_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_returned",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was patient adherence diary received and stored in patient records?",
                    ),
                ),
                (
                    "diary_returned_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_match_pill_count",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did the patient adherence diary match the pill count?",
                    ),
                ),
                (
                    "diary_match_pill_count_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "opinion_fluconazole_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
                    ),
                ),
                (
                    "opinion_art_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
                    ),
                ),
                (
                    "adherence_narrative",
                    models.TextField(
                        blank=True, null=True, verbose_name="Medication adherence narrative:"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Adherence: Day 14",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAdherenceStageOne",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
                    ),
                ),
                (
                    "adherence_counselling_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_issued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was an adherence diary issued to the patient?",
                    ),
                ),
                (
                    "diary_issued_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "any_fluconazole_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Fluconazole doses been missed since the last visit?",
                    ),
                ),
                (
                    "fluconazole_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (1 dose per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(14),
                        ],
                        verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
                    ),
                ),
                (
                    "any_flucytosine_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Flucytosine doses been missed since the last visit?",
                    ),
                ),
                (
                    "flucytosine_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (4 doses per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(56),
                        ],
                        verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
                    ),
                ),
                (
                    "pill_count_conducted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was a pill count conducted?",
                    ),
                ),
                (
                    "pill_count_conducted_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_returned",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was patient adherence diary received and stored in patient records?",
                    ),
                ),
                (
                    "diary_returned_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_match_pill_count",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did the patient adherence diary match the pill count?",
                    ),
                ),
                (
                    "diary_match_pill_count_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "opinion_fluconazole_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
                    ),
                ),
                (
                    "opinion_art_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
                    ),
                ),
                (
                    "adherence_narrative",
                    models.TextField(
                        blank=True, null=True, verbose_name="Medication adherence narrative:"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Adherence: Day 1",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalAdherenceStageFour",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "adherence_counselling",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Has appropriate adherence counselling been given as per the trial SOP?",
                    ),
                ),
                (
                    "adherence_counselling_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_issued",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was an adherence diary issued to the patient?",
                    ),
                ),
                (
                    "diary_issued_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "any_fluconazole_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Fluconazole doses been missed since the last visit?",
                    ),
                ),
                (
                    "fluconazole_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (1 dose per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(14),
                        ],
                        verbose_name="If 'Yes', number of Fluconazole doses missed since last visit:",
                    ),
                ),
                (
                    "any_flucytosine_doses_missed",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("unknown", "Unknown")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Have any Flucytosine doses been missed since the last visit?",
                    ),
                ),
                (
                    "flucytosine_doses_missed",
                    models.IntegerField(
                        default=0,
                        help_text="This should be measured in single doses (4 doses per day)",
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(56),
                        ],
                        verbose_name="If 'Yes', number of Flucytosine doses missed since last visit:",
                    ),
                ),
                (
                    "pill_count_conducted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was a pill count conducted?",
                    ),
                ),
                (
                    "pill_count_conducted_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_returned",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Was patient adherence diary received and stored in patient records?",
                    ),
                ),
                (
                    "diary_returned_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "diary_match_pill_count",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did the patient adherence diary match the pill count?",
                    ),
                ),
                (
                    "diary_match_pill_count_reason_no",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If 'No', please specify reason ...",
                    ),
                ),
                (
                    "opinion_fluconazole_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to Fluconazole?",
                    ),
                ),
                (
                    "opinion_art_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        default="N/A",
                        max_length=15,
                        verbose_name="In the clinician’s opinion, is the patient 90% adherent to ART?",
                    ),
                ),
                (
                    "adherence_narrative",
                    models.TextField(
                        blank=True, null=True, verbose_name="Medication adherence narrative:"
                    ),
                ),
                ("history_date", models.DateTimeField()),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Adherence: Week 4+",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": "history_date",
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="ArvHistory",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "taking_arv_at_crag",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=5,
                        verbose_name="Was the patient taking ART at time of CrAg test?",
                    ),
                ),
                (
                    "ever_taken_arv",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If NO, has the patient ever been on ART prior to CrAg test?",
                    ),
                ),
                (
                    "initial_arv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when did the patient <u>start</u> ART for the first time.",
                    ),
                ),
                (
                    "initial_arv_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If YES, is this ART date estimated?",
                    ),
                ),
                (
                    "initial_arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "has_switched_regimen",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="Has the patient ever switched ART regimen?",
                    ),
                ),
                (
                    "current_arv_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If YES, when was their <u>current or most recent</u> ART regimen started?",
                    ),
                ),
                (
                    "current_arv_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If YES, is this ART date estimated?",
                    ),
                ),
                (
                    "current_arv_regimen_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "current_arv_is_defaulted",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        help_text="'DEFAULTED' means no ART for at least one month.",
                        max_length=5,
                        verbose_name="Has the patient <u>now</u> defaulted from their ART regimen?",
                    ),
                ),
                (
                    "current_arv_defaulted_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="If the patient has DEFAULTED, on what date did they default from their <u>most recent</u> ART regimen?",
                    ),
                ),
                (
                    "current_arv_defaulted_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="If DEFAULTED, is this date estimated?",
                    ),
                ),
                (
                    "current_arv_is_adherent",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=5,
                        verbose_name="If the patient is currently on ART, are they ADHERENT to their <u>current</u> ART regimen?",
                    ),
                ),
                (
                    "current_arv_tablets_missed",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(31),
                        ],
                        verbose_name="If not ADHERENT, how many doses missed in the last month?",
                    ),
                ),
                (
                    "last_viral_load",
                    models.DecimalField(
                        blank=True,
                        decimal_places=3,
                        help_text="copies/mL",
                        max_digits=10,
                        null=True,
                        verbose_name="Last Viral Load, if known?",
                    ),
                ),
                (
                    "viral_load_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="Viral Load date",
                    ),
                ),
                (
                    "vl_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the subject's Viral Load date estimated?",
                    ),
                ),
                (
                    "last_cd4",
                    models.IntegerField(
                        blank=True,
                        help_text="acceptable units are mm<sup>3</sup>",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(99),
                        ],
                        verbose_name="Last CD4, if known?",
                    ),
                ),
                (
                    "cd4_date",
                    models.DateField(
                        blank=True,
                        null=True,
                        validators=[edc_model.validators.date.date_not_future],
                        verbose_name="CD4 date",
                    ),
                ),
                (
                    "cd4_date_estimated",
                    edc_model.models.fields.date_estimated.IsDateEstimatedFieldNa(
                        choices=[
                            ("N/A", "Not applicable"),
                            ("not_estimated", "No."),
                            ("D", "Yes, estimated the Day"),
                            ("MD", "Yes, estimated Month and Day"),
                            ("YMD", "Yes, estimated Year, Month and Day"),
                        ],
                        default="N/A",
                        help_text="If the exact date is not known, please indicate which part of the date is estimated.",
                        max_length=25,
                        verbose_name="Is the subject's CD4 date estimated?",
                    ),
                ),
                (
                    "current_arv_regimen",
                    models.ManyToManyField(
                        related_name="current_arv",
                        to="effect_lists.ArvRegimens",
                        verbose_name="If YES, what is their current or most recent ART regimen?",
                    ),
                ),
                (
                    "initial_arv_regimen",
                    models.ManyToManyField(
                        related_name="initial_arv",
                        to="effect_lists.ArvRegimens",
                        verbose_name="If YES, which drugs were prescribed for their <u>first</u> ART regimen?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "ARV History",
                "verbose_name_plural": "ARV History",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="patienthistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_bb6b06_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="medicalhistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_f522cc_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="arvhistory",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_1087ec_idx"
            ),
        ),
    ]
