# Generated by Django 3.2.13 on 2022-07-25 11:24

import _socket
from django.conf import settings
import django.contrib.sites.managers
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_audit_fields.fields.hostname_modification_field
import django_audit_fields.fields.userfield
import django_audit_fields.fields.uuid_auto_field
import django_audit_fields.models.audit_model_mixin
import django_revision.revision_field
import edc_model.models.fields.other_charfield
import edc_model.validators.date
import edc_protocol.validators
import edc_utils.date
import edc_visit_tracking.managers
import simple_history.models
import uuid
import django.utils.timezone


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("effect_lists", "0011_auto_20220725_1324"),
        ("sites", "0002_alter_domain_unique"),
        ("effect_subject", "0082_auto_20220719_1427"),
    ]

    operations = [
        migrations.AddField(
            model_name="healtheconomics",
            name="accommodation_month",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much does your household spend on rent (or house loan/mortgage) and utilities in a month?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="education_years",
            field=models.IntegerField(
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(30),
                ],
                verbose_name="How many years of education did you compete?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="educational_attainment",
            field=models.CharField(
                choices=[
                    ("no_schooling_completed", "No schooling completed"),
                    ("nursery_to_8th_grade", "Nursery school to 8th grade"),
                    ("some_high_school_no_diploma", "Some high school, no diploma"),
                    (
                        "high_school_grad_diploma_or_equiv",
                        "High school graduate, diploma or the equivalent (for example: GED)",
                    ),
                    ("some_college_no_degree", "Some college credit, no degree"),
                    (
                        "trade_technical_vocational_training",
                        "Trade/technical/vocational training",
                    ),
                    ("associate_degree", "Associate degree"),
                    ("bachelors_degree", "Bachelor's degree"),
                    ("masters_degree", "Master's degree"),
                    ("professional_degree", "Professional degree"),
                    ("doctorate_degree", "Doctorate degree"),
                ],
                max_length=50,
                null=True,
                verbose_name="What is your highest education certificate?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="food_month",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much does your household spend on food in a month?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="higher_education",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to higher education?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="higher_education_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(15),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="highest_earner",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Are you the person who earns the highest income in your household?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="large_items_year",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much have you spent on large items (e.g., furniture, electrical items, cars) in the last year?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="monthly_household_income",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="What is the total income in your household per month?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="occupation",
            field=models.CharField(
                max_length=50, null=True, verbose_name="What is your occupation/profession?"
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="primary_school",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to primary/elementary school?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="primary_school_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(12),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="profession_highest_earner",
            field=models.CharField(
                blank=True,
                max_length=50,
                null=True,
                verbose_name="If NO, what is the profession of the person who earns the highest income?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="secondary_school",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to secondary school?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="secondary_school_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(10),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="healtheconomics",
            name="welfare",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Do you receive any welfare or social service support?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="accommodation_month",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much does your household spend on rent (or house loan/mortgage) and utilities in a month?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="education_years",
            field=models.IntegerField(
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(30),
                ],
                verbose_name="How many years of education did you compete?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="educational_attainment",
            field=models.CharField(
                choices=[
                    ("no_schooling_completed", "No schooling completed"),
                    ("nursery_to_8th_grade", "Nursery school to 8th grade"),
                    ("some_high_school_no_diploma", "Some high school, no diploma"),
                    (
                        "high_school_grad_diploma_or_equiv",
                        "High school graduate, diploma or the equivalent (for example: GED)",
                    ),
                    ("some_college_no_degree", "Some college credit, no degree"),
                    (
                        "trade_technical_vocational_training",
                        "Trade/technical/vocational training",
                    ),
                    ("associate_degree", "Associate degree"),
                    ("bachelors_degree", "Bachelor's degree"),
                    ("masters_degree", "Master's degree"),
                    ("professional_degree", "Professional degree"),
                    ("doctorate_degree", "Doctorate degree"),
                ],
                max_length=50,
                null=True,
                verbose_name="What is your highest education certificate?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="food_month",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much does your household spend on food in a month?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="higher_education",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to higher education?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="higher_education_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(15),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="highest_earner",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Are you the person who earns the highest income in your household?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="large_items_year",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="How much have you spent on large items (e.g., furniture, electrical items, cars) in the last year?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="monthly_household_income",
            field=models.IntegerField(
                help_text="In rands or shillings",
                null=True,
                validators=[django.core.validators.MinValueValidator(0)],
                verbose_name="What is the total income in your household per month?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="occupation",
            field=models.CharField(
                max_length=50, null=True, verbose_name="What is your occupation/profession?"
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="primary_school",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to primary/elementary school?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="primary_school_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(12),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="profession_highest_earner",
            field=models.CharField(
                blank=True,
                max_length=50,
                null=True,
                verbose_name="If NO, what is the profession of the person who earns the highest income?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="secondary_school",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Did you go to secondary school?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="secondary_school_years",
            field=models.IntegerField(
                blank=True,
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(10),
                ],
                verbose_name="If YES, for how many years?",
            ),
        ),
        migrations.AddField(
            model_name="historicalhealtheconomics",
            name="welfare",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                max_length=15,
                null=True,
                verbose_name="Do you receive any welfare or social service support?",
            ),
        ),
        migrations.CreateModel(
            name="HistoricalHealthEconomicsEvent",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        db_index=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "history_id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False
                    ),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "buy_meds",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the past period since your treatment, did you buy any drugs or have a drug refill?",
                    ),
                ),
                (
                    "arv_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on antiretroviral drugs?",
                    ),
                ),
                (
                    "meds_other_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on other drugs for relief?",
                    ),
                ),
                (
                    "arv_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on antiretroviral drugs, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "meds_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on other drugs for relief, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "health_activities",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Since your last study visit, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "health_activities_detail",
                    models.CharField(
                        blank=True,
                        max_length=145,
                        null=True,
                        verbose_name="If YES, what was the activity?",
                    ),
                ),
                (
                    "health_activities_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "health_activities_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others"),
                            ("free", "Free"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If YES, how did you pay or who paid for these activities?",
                    ),
                ),
                (
                    "routine_activities_disrupted_days",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Over the past period since your treatment, how many days were your normal activities disrupted through illness?",
                    ),
                ),
                (
                    "healthcare_month",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify below ..."),
                        ],
                        max_length=45,
                        verbose_name="What would you be doing in your life, if you had not come to the hospital or clinic?",
                    ),
                ),
                (
                    "routine_activities_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "time_off_days",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        verbose_name="How much time did you take off work to come to this appointment?",
                    ),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How much time did you spend at the hospital or clinic?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you lose earnings as a result?",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you ask anyone else, such as your family member, friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If YES, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "childcare_source_time_off_days",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="If YES, how much time did a family member, friend take off work to look after your child or children?",
                    ),
                ),
                (
                    "transport_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "transport_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much will you spend on transport in total (coming to the health care facility and going back home)?",
                    ),
                ),
                (
                    "food_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much did you spend on food while you were here today?",
                    ),
                ),
                (
                    "buy_meds_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you get any drugs on your visit today?",
                    ),
                ),
                (
                    "arv_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on antiretroviral drugs?",
                    ),
                ),
                (
                    "meds_other_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on other drugs for relief?",
                    ),
                ),
                (
                    "arv_payee_today",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on antiretroviral drugs, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "meds_other_payee_today",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on other drugs for relief, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "health_activities_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you spend money on other activities (not drugs) relating to your health today?",
                    ),
                ),
                (
                    "health_activities_detail_today",
                    models.CharField(
                        blank=True,
                        max_length=145,
                        null=True,
                        verbose_name="If YES, what was the activity?",
                    ),
                ),
                (
                    "health_activities_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend?",
                    ),
                ),
                (
                    "admitted_admin",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you pay for any administrative fees/charges at the hospital when you got admitted?",
                    ),
                ),
                (
                    "admitted_admin_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you pay in hospital charges?",
                    ),
                ),
                (
                    "admitted_investigations",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you pay any money to have any tests/investigations done while admitted?",
                    ),
                ),
                (
                    "admitted_investigations_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you pay?",
                    ),
                ),
                (
                    "admitted_food_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="On the day you were admitted, how much money did you spend on food?",
                    ),
                ),
                (
                    "admitted_other_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="While you were admitted, how much money did you spend on other items such as airtime, toiletries (soap/shampoo, toothbrush/toothpaste, bucket/basin for washing, toilet paper), clothes and cups/plates?",
                    ),
                ),
                (
                    "admitted_time_off",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you have to take time off work because of being admitted?",
                    ),
                ),
                (
                    "admitted_carers",
                    models.IntegerField(
                        verbose_name="How many family members or friends stayed with you in hospital to look after you during your hospital stay?"
                    ),
                ),
                (
                    "admitted_visitors",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How many family members or friends visited you during your hospital stay?",
                    ),
                ),
                (
                    "admitted_kith_kin_time_off",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did a family member/friend have to take time off work to stay with you or to come see you during your hospital stay?",
                    ),
                ),
                (
                    "admitted_kith_kin_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much does this person normally earn per month?",
                    ),
                ),
                (
                    "sell_to_pay",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "borrow_to_pay",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you take any loans to pay for your visit or treatment?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="effect_subject.subjectvisit",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Health Economics: Health Event",
                "verbose_name_plural": "historical Health Economics: Health Event",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HealthEconomicsEvent",
            fields=[
                (
                    "revision",
                    django_revision.revision_field.RevisionField(
                        blank=True,
                        editable=False,
                        help_text="System field. Git repository tag:branch:commit.",
                        max_length=75,
                        null=True,
                        verbose_name="Revision",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "modified",
                    models.DateTimeField(blank=True, default=django.utils.timezone.now),
                ),
                (
                    "user_created",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user created",
                    ),
                ),
                (
                    "user_modified",
                    django_audit_fields.fields.userfield.UserField(
                        blank=True,
                        help_text="Updated by admin.save_model",
                        max_length=50,
                        verbose_name="user modified",
                    ),
                ),
                (
                    "hostname_created",
                    models.CharField(
                        blank=True,
                        default=_socket.gethostname,
                        help_text="System field. (modified on create only)",
                        max_length=60,
                    ),
                ),
                (
                    "hostname_modified",
                    django_audit_fields.fields.hostname_modification_field.HostnameModificationField(
                        blank=True,
                        help_text="System field. (modified on every save)",
                        max_length=50,
                    ),
                ),
                ("device_created", models.CharField(blank=True, max_length=10)),
                ("device_modified", models.CharField(blank=True, max_length=10)),
                (
                    "id",
                    django_audit_fields.fields.uuid_auto_field.UUIDAutoField(
                        blank=True,
                        editable=False,
                        help_text="System auto field. UUID primary key.",
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "report_datetime",
                    models.DateTimeField(
                        default=edc_utils.date.get_utcnow,
                        help_text="If reporting today, use today's date/time, otherwise use the date/time this information was reported.",
                        validators=[
                            edc_protocol.validators.datetime_not_before_study_start,
                            edc_model.validators.date.datetime_not_future,
                        ],
                        verbose_name="Report Date",
                    ),
                ),
                ("consent_model", models.CharField(editable=False, max_length=50, null=True)),
                (
                    "consent_version",
                    models.CharField(editable=False, max_length=10, null=True),
                ),
                (
                    "crf_status",
                    models.CharField(
                        choices=[
                            ("INCOMPLETE", "Incomplete (some data pending)"),
                            ("COMPLETE", "Complete"),
                        ],
                        default="COMPLETE",
                        help_text="If some data is still pending, flag this CRF as incomplete",
                        max_length=25,
                        verbose_name="CRF status",
                    ),
                ),
                (
                    "crf_status_comments",
                    models.TextField(
                        blank=True,
                        help_text="for example, why some data is still pending",
                        null=True,
                        verbose_name="Any comments related to status of this CRF",
                    ),
                ),
                (
                    "buy_meds",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Over the past period since your treatment, did you buy any drugs or have a drug refill?",
                    ),
                ),
                (
                    "arv_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on antiretroviral drugs?",
                    ),
                ),
                (
                    "meds_other_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on other drugs for relief?",
                    ),
                ),
                (
                    "arv_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on antiretroviral drugs, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "meds_other_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on other drugs for relief, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "health_activities",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Since your last study visit, did you spend money on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "health_activities_detail",
                    models.CharField(
                        blank=True,
                        max_length=145,
                        null=True,
                        verbose_name="If YES, what was the activity?",
                    ),
                ),
                (
                    "health_activities_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much was spent on other activities (not drugs) relating to your health?",
                    ),
                ),
                (
                    "health_activities_payee",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others"),
                            ("free", "Free"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If YES, how did you pay or who paid for these activities?",
                    ),
                ),
                (
                    "routine_activities_disrupted_days",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="Over the past period since your treatment, how many days were your normal activities disrupted through illness?",
                    ),
                ),
                (
                    "healthcare_month",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much in total has been spent on your healthcare in the last month?",
                    ),
                ),
                (
                    "routine_activities",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify below ..."),
                        ],
                        max_length=45,
                        verbose_name="What would you be doing in your life, if you had not come to the hospital or clinic?",
                    ),
                ),
                (
                    "routine_activities_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "time_off_days",
                    models.DecimalField(
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        verbose_name="How much time did you take off work to come to this appointment?",
                    ),
                ),
                (
                    "travel_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How long did it take you to reach here?",
                    ),
                ),
                (
                    "hospital_time",
                    models.CharField(
                        help_text="in hours and minutes (format HH:MM)",
                        max_length=5,
                        validators=[
                            django.core.validators.RegexValidator(
                                "^([0-9]{1,3}h([0-5]?[0-9]m)?)$",
                                message="Invalid format. Expected something like 1h20m, 11h5m, etc",
                            )
                        ],
                        verbose_name="How much time did you spend at the hospital or clinic?",
                    ),
                ),
                (
                    "lost_income",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you lose earnings as a result?",
                    ),
                ),
                (
                    "lost_income_amount",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you lose?",
                    ),
                ),
                (
                    "childcare",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No"), ("N/A", "Not applicable")],
                        default="N/A",
                        max_length=15,
                        verbose_name="Did you ask anyone else, such as your family member, friend to look after your child/children in order to come here?",
                    ),
                ),
                (
                    "childcare_source",
                    models.CharField(
                        choices=[
                            ("working", "Working"),
                            ("studying", "Studying"),
                            ("caring_for_children", "Caring for children"),
                            ("house_maintenance", "House maintenance"),
                            ("nothing", "Nothing"),
                            ("OTHER", "Other, please specify below ..."),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If YES, what would they have been doing if they had not stayed to look after your child or children?",
                    ),
                ),
                (
                    "childcare_source_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "childcare_source_time_off_days",
                    models.DecimalField(
                        blank=True,
                        decimal_places=1,
                        help_text="in days. (1,2,3 etc. If half-day 0.5)",
                        max_digits=4,
                        null=True,
                        verbose_name="If YES, how much time did a family member, friend take off work to look after your child or children?",
                    ),
                ),
                (
                    "transport_other",
                    edc_model.models.fields.other_charfield.OtherCharField(
                        blank=True,
                        max_length=35,
                        null=True,
                        verbose_name="If other, please specify ...",
                    ),
                ),
                (
                    "transport_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much will you spend on transport in total (coming to the health care facility and going back home)?",
                    ),
                ),
                (
                    "food_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How much did you spend on food while you were here today?",
                    ),
                ),
                (
                    "buy_meds_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you get any drugs on your visit today?",
                    ),
                ),
                (
                    "arv_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on antiretroviral drugs?",
                    ),
                ),
                (
                    "meds_other_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend on other drugs for relief?",
                    ),
                ),
                (
                    "arv_payee_today",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on antiretroviral drugs, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "meds_other_payee_today",
                    models.CharField(
                        choices=[
                            ("own_cash", "Own cash"),
                            ("insurance", "Insurance"),
                            ("relative", "Relative or others paying for drugs"),
                            ("free", "Free drugs from the pharmacy"),
                            ("N/A", "Not applicable"),
                        ],
                        default="N/A",
                        max_length=45,
                        verbose_name="If spent on other drugs for relief, how did you pay or who paid for them?",
                    ),
                ),
                (
                    "health_activities_today",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you spend money on other activities (not drugs) relating to your health today?",
                    ),
                ),
                (
                    "health_activities_detail_today",
                    models.CharField(
                        blank=True,
                        max_length=145,
                        null=True,
                        verbose_name="If YES, what was the activity?",
                    ),
                ),
                (
                    "health_activities_spend_today",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you spend?",
                    ),
                ),
                (
                    "admitted_admin",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you pay for any administrative fees/charges at the hospital when you got admitted?",
                    ),
                ),
                (
                    "admitted_admin_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you pay in hospital charges?",
                    ),
                ),
                (
                    "admitted_investigations",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you pay any money to have any tests/investigations done while admitted?",
                    ),
                ),
                (
                    "admitted_investigations_spend",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much did you pay?",
                    ),
                ),
                (
                    "admitted_food_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="On the day you were admitted, how much money did you spend on food?",
                    ),
                ),
                (
                    "admitted_other_spend",
                    models.IntegerField(
                        help_text="In rands or shillings",
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="While you were admitted, how much money did you spend on other items such as airtime, toiletries (soap/shampoo, toothbrush/toothpaste, bucket/basin for washing, toilet paper), clothes and cups/plates?",
                    ),
                ),
                (
                    "admitted_time_off",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you have to take time off work because of being admitted?",
                    ),
                ),
                (
                    "admitted_carers",
                    models.IntegerField(
                        verbose_name="How many family members or friends stayed with you in hospital to look after you during your hospital stay?"
                    ),
                ),
                (
                    "admitted_visitors",
                    models.IntegerField(
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="How many family members or friends visited you during your hospital stay?",
                    ),
                ),
                (
                    "admitted_kith_kin_time_off",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did a family member/friend have to take time off work to stay with you or to come see you during your hospital stay?",
                    ),
                ),
                (
                    "admitted_kith_kin_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much does this person normally earn per month?",
                    ),
                ),
                (
                    "sell_to_pay",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you sell anything to pay for your visit today?",
                    ),
                ),
                (
                    "borrow_to_pay",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Did you take any loans to pay for your visit or treatment?",
                    ),
                ),
                (
                    "health_insurance",
                    models.CharField(
                        choices=[("Yes", "Yes"), ("No", "No")],
                        max_length=15,
                        verbose_name="Do you have private healthcare insurance?",
                    ),
                ),
                (
                    "health_insurance_month",
                    models.IntegerField(
                        blank=True,
                        help_text="In rands or shillings",
                        null=True,
                        validators=[django.core.validators.MinValueValidator(0)],
                        verbose_name="If YES, how much do you pay towards your contributions to healthcare insurance every month?",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="+",
                        to="sites.site",
                    ),
                ),
                (
                    "subject_visit",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="effect_subject.subjectvisit",
                    ),
                ),
                (
                    "transport",
                    models.ManyToManyField(
                        help_text="If more than one, select all that apply.",
                        to="effect_lists.Transport",
                        verbose_name="Which form of transport did you use to come to the hospital/clinic today?",
                    ),
                ),
            ],
            options={
                "verbose_name": "Health Economics: Health Event",
                "verbose_name_plural": "Health Economics: Health Event",
                "ordering": ("-modified", "-created"),
                "get_latest_by": "modified",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "export", "import"),
            },
            managers=[
                ("on_site", django.contrib.sites.managers.CurrentSiteManager()),
                ("objects", edc_visit_tracking.managers.CrfModelManager()),
            ],
        ),
        migrations.AddIndex(
            model_name="healtheconomicsevent",
            index=models.Index(
                fields=["subject_visit", "site", "id"], name="effect_subj_subject_fa6edc_idx"
            ),
        ),
    ]
