# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
from inspect import getfullargspec
import json
import pprint
import re  # noqa: F401
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Optional
from scope_client.api_bindings.models.examples_config import ExamplesConfig
from scope_client.api_bindings.models.keywords_config import KeywordsConfig
from scope_client.api_bindings.models.pii_config import PIIConfig
from scope_client.api_bindings.models.regex_config import RegexConfig
from scope_client.api_bindings.models.toxicity_config import ToxicityConfig
from typing import Union, Any, List, Set, TYPE_CHECKING, Optional, Dict
from typing_extensions import Literal, Self
from pydantic import Field

CONFIG_ANY_OF_SCHEMAS = ["ExamplesConfig", "KeywordsConfig", "PIIConfig", "RegexConfig", "ToxicityConfig"]

class Config(BaseModel):
    """
    Config for the rule
    """

    # data type: KeywordsConfig
    anyof_schema_1_validator: Optional[KeywordsConfig] = None
    # data type: RegexConfig
    anyof_schema_2_validator: Optional[RegexConfig] = None
    # data type: ExamplesConfig
    anyof_schema_3_validator: Optional[ExamplesConfig] = None
    # data type: ToxicityConfig
    anyof_schema_4_validator: Optional[ToxicityConfig] = None
    # data type: PIIConfig
    anyof_schema_5_validator: Optional[PIIConfig] = None
    if TYPE_CHECKING:
        actual_instance: Optional[Union[ExamplesConfig, KeywordsConfig, PIIConfig, RegexConfig, ToxicityConfig]] = None
    else:
        actual_instance: Any = None
    any_of_schemas: Set[str] = { "ExamplesConfig", "KeywordsConfig", "PIIConfig", "RegexConfig", "ToxicityConfig" }

    model_config = {
        "validate_assignment": True,
        "protected_namespaces": (),
    }

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        if v is None:
            return v

        instance = Config.model_construct()
        error_messages = []
        # validate data type: KeywordsConfig
        if not isinstance(v, KeywordsConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `KeywordsConfig`")
        else:
            return v

        # validate data type: RegexConfig
        if not isinstance(v, RegexConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `RegexConfig`")
        else:
            return v

        # validate data type: ExamplesConfig
        if not isinstance(v, ExamplesConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ExamplesConfig`")
        else:
            return v

        # validate data type: ToxicityConfig
        if not isinstance(v, ToxicityConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `ToxicityConfig`")
        else:
            return v

        # validate data type: PIIConfig
        if not isinstance(v, PIIConfig):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PIIConfig`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when setting the actual_instance in Config with anyOf schemas: ExamplesConfig, KeywordsConfig, PIIConfig, RegexConfig, ToxicityConfig. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Dict[str, Any]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        if json_str is None:
            return instance

        error_messages = []
        # anyof_schema_1_validator: Optional[KeywordsConfig] = None
        try:
            instance.actual_instance = KeywordsConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_2_validator: Optional[RegexConfig] = None
        try:
            instance.actual_instance = RegexConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_3_validator: Optional[ExamplesConfig] = None
        try:
            instance.actual_instance = ExamplesConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_4_validator: Optional[ToxicityConfig] = None
        try:
            instance.actual_instance = ToxicityConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))
        # anyof_schema_5_validator: Optional[PIIConfig] = None
        try:
            instance.actual_instance = PIIConfig.from_json(json_str)
            return instance
        except (ValidationError, ValueError) as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Config with anyOf schemas: ExamplesConfig, KeywordsConfig, PIIConfig, RegexConfig, ToxicityConfig. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], ExamplesConfig, KeywordsConfig, PIIConfig, RegexConfig, ToxicityConfig]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


