# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.metrics_column_list_parameter_schema_allowed_column_types_inner import MetricsColumnListParameterSchemaAllowedColumnTypesInner
from scope_client.api_bindings.models.scope_schema_tag import ScopeSchemaTag
from typing import Optional, Set
from typing_extensions import Self

class MetricsColumnParameterSchema(BaseModel):
    """
    MetricsColumnParameterSchema
    """ # noqa: E501
    parameter_key: StrictStr = Field(description="Name of the parameter.")
    optional: Optional[StrictBool] = Field(default=False, description="Boolean denoting if the parameter is optional.")
    friendly_name: StrictStr = Field(description="User facing name of the parameter.")
    description: StrictStr = Field(description="Description of the parameter.")
    parameter_type: Optional[StrictStr] = 'column'
    tag_hints: Optional[List[ScopeSchemaTag]] = Field(default=None, description="List of tags that are applicable to this parameter. Datasets with columns that have matching tags can be inferred this way.")
    source_dataset_parameter_key: StrictStr = Field(description="Name of the parameter that provides the dataset to be used for this column.")
    allowed_column_types: Optional[List[MetricsColumnListParameterSchemaAllowedColumnTypesInner]] = None
    allow_any_column_type: Optional[StrictBool] = Field(default=False, description="Indicates if this metric parameter can accept any column type.")
    __properties: ClassVar[List[str]] = ["parameter_key", "optional", "friendly_name", "description", "parameter_type", "tag_hints", "source_dataset_parameter_key", "allowed_column_types", "allow_any_column_type"]

    @field_validator('parameter_type')
    def parameter_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['column']):
            raise ValueError("must be one of enum values ('column')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of MetricsColumnParameterSchema from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in allowed_column_types (list)
        _items = []
        if self.allowed_column_types:
            for _item_allowed_column_types in self.allowed_column_types:
                if _item_allowed_column_types:
                    _items.append(_item_allowed_column_types.to_dict())
            _dict['allowed_column_types'] = _items
        # set to None if allowed_column_types (nullable) is None
        # and model_fields_set contains the field
        if self.allowed_column_types is None and "allowed_column_types" in self.model_fields_set:
            _dict['allowed_column_types'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of MetricsColumnParameterSchema from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "parameter_key": obj.get("parameter_key"),
            "optional": obj.get("optional") if obj.get("optional") is not None else False,
            "friendly_name": obj.get("friendly_name"),
            "description": obj.get("description"),
            "parameter_type": obj.get("parameter_type") if obj.get("parameter_type") is not None else 'column',
            "tag_hints": obj.get("tag_hints"),
            "source_dataset_parameter_key": obj.get("source_dataset_parameter_key"),
            "allowed_column_types": [MetricsColumnListParameterSchemaAllowedColumnTypesInner.from_dict(_item) for _item in obj["allowed_column_types"]] if obj.get("allowed_column_types") is not None else None,
            "allow_any_column_type": obj.get("allow_any_column_type") if obj.get("allow_any_column_type") is not None else False
        })
        return _obj


