# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.dataset_locator import DatasetLocator
from scope_client.api_bindings.models.model_problem_type import ModelProblemType
from scope_client.api_bindings.models.post_dataset_join_spec import PostDatasetJoinSpec
from scope_client.api_bindings.models.put_dataset_schema import PutDatasetSchema
from typing import Optional, Set
from typing_extensions import Self

class PostDataset(BaseModel):
    """
    PostDataset
    """ # noqa: E501
    name: Optional[StrictStr] = None
    dataset_locator: Optional[DatasetLocator] = None
    dataset_schema: Optional[PutDatasetSchema] = None
    dataset_join_spec: Optional[PostDatasetJoinSpec] = None
    model_problem_type: ModelProblemType = Field(description="Model problem type associated with the dataset.")
    __properties: ClassVar[List[str]] = ["name", "dataset_locator", "dataset_schema", "dataset_join_spec", "model_problem_type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostDataset from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dataset_locator
        if self.dataset_locator:
            _dict['dataset_locator'] = self.dataset_locator.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataset_schema
        if self.dataset_schema:
            _dict['dataset_schema'] = self.dataset_schema.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dataset_join_spec
        if self.dataset_join_spec:
            _dict['dataset_join_spec'] = self.dataset_join_spec.to_dict()
        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict['name'] = None

        # set to None if dataset_locator (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_locator is None and "dataset_locator" in self.model_fields_set:
            _dict['dataset_locator'] = None

        # set to None if dataset_schema (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_schema is None and "dataset_schema" in self.model_fields_set:
            _dict['dataset_schema'] = None

        # set to None if dataset_join_spec (nullable) is None
        # and model_fields_set contains the field
        if self.dataset_join_spec is None and "dataset_join_spec" in self.model_fields_set:
            _dict['dataset_join_spec'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostDataset from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "dataset_locator": DatasetLocator.from_dict(obj["dataset_locator"]) if obj.get("dataset_locator") is not None else None,
            "dataset_schema": PutDatasetSchema.from_dict(obj["dataset_schema"]) if obj.get("dataset_schema") is not None else None,
            "dataset_join_spec": PostDatasetJoinSpec.from_dict(obj["dataset_join_spec"]) if obj.get("dataset_join_spec") is not None else None,
            "model_problem_type": obj.get("model_problem_type")
        })
        return _obj


