# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.alert_rule_interval import AlertRuleInterval
from scope_client.api_bindings.models.post_metrics_query_time_range import PostMetricsQueryTimeRange
from scope_client.api_bindings.models.result_filter import ResultFilter
from typing import Optional, Set
from typing_extensions import Self

class PostMetricsQuery(BaseModel):
    """
    PostMetricsQuery
    """ # noqa: E501
    query: StrictStr = Field(description="Query for retrieving the metrics.")
    time_range: PostMetricsQueryTimeRange = Field(description="Time range to filter the metrics by.")
    interval: Optional[AlertRuleInterval] = None
    limit: Optional[StrictInt] = Field(default=50, description="Limit the number of metrics returned. Defaults to 50.")
    result_filter: Optional[ResultFilter] = None
    __properties: ClassVar[List[str]] = ["query", "time_range", "interval", "limit", "result_filter"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostMetricsQuery from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of time_range
        if self.time_range:
            _dict['time_range'] = self.time_range.to_dict()
        # override the default output from pydantic by calling `to_dict()` of interval
        if self.interval:
            _dict['interval'] = self.interval.to_dict()
        # override the default output from pydantic by calling `to_dict()` of result_filter
        if self.result_filter:
            _dict['result_filter'] = self.result_filter.to_dict()
        # set to None if interval (nullable) is None
        # and model_fields_set contains the field
        if self.interval is None and "interval" in self.model_fields_set:
            _dict['interval'] = None

        # set to None if result_filter (nullable) is None
        # and model_fields_set contains the field
        if self.result_filter is None and "result_filter" in self.model_fields_set:
            _dict['result_filter'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostMetricsQuery from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "query": obj.get("query"),
            "time_range": PostMetricsQueryTimeRange.from_dict(obj["time_range"]) if obj.get("time_range") is not None else None,
            "interval": AlertRuleInterval.from_dict(obj["interval"]) if obj.get("interval") is not None else None,
            "limit": obj.get("limit") if obj.get("limit") is not None else 50,
            "result_filter": ResultFilter.from_dict(obj["result_filter"]) if obj.get("result_filter") is not None else None
        })
        return _obj


