# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from scope_client.api_bindings.models.new_rule_request import NewRuleRequest
from typing import Optional, Set
from typing_extensions import Self

class UpdateModelTaskRulesJobSpec(BaseModel):
    """
    UpdateModelTaskRulesJobSpec
    """ # noqa: E501
    job_type: Optional[StrictStr] = 'update_model_task_rules'
    scope_model_id: StrictStr = Field(description="The id of the model to update the task rules.")
    rules_to_enable: Optional[List[StrictStr]] = Field(default=None, description="The list of rule IDs to enable on the task.")
    rules_to_disable: Optional[List[StrictStr]] = Field(default=None, description="The list of rule IDs to disable on the task.")
    rules_to_archive: Optional[List[StrictStr]] = Field(default=None, description="The list of rule IDs to archive on the task.")
    rules_to_add: Optional[List[NewRuleRequest]] = Field(default=None, description="The new rules to add to the task.")
    __properties: ClassVar[List[str]] = ["job_type", "scope_model_id", "rules_to_enable", "rules_to_disable", "rules_to_archive", "rules_to_add"]

    @field_validator('job_type')
    def job_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['update_model_task_rules']):
            raise ValueError("must be one of enum values ('update_model_task_rules')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of UpdateModelTaskRulesJobSpec from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rules_to_add (list)
        _items = []
        if self.rules_to_add:
            for _item_rules_to_add in self.rules_to_add:
                if _item_rules_to_add:
                    _items.append(_item_rules_to_add.to_dict())
            _dict['rules_to_add'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of UpdateModelTaskRulesJobSpec from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "job_type": obj.get("job_type") if obj.get("job_type") is not None else 'update_model_task_rules',
            "scope_model_id": obj.get("scope_model_id"),
            "rules_to_enable": obj.get("rules_to_enable"),
            "rules_to_disable": obj.get("rules_to_disable"),
            "rules_to_archive": obj.get("rules_to_archive"),
            "rules_to_add": [NewRuleRequest.from_dict(_item) for _item in obj["rules_to_add"]] if obj.get("rules_to_add") is not None else None
        })
        return _obj


