# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    """AI-based intelligent analysis template details

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of intelligent analysis template.
        :type Definition: int
        :param _Name: Intelligent analysis template name.
        :type Name: str
        :param _Comment: Intelligent analysis template description.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    """Details of a video content recognition template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        :param _Name: Name of a video content recognition template.
        :type Name: str
        :param _Comment: Description of a video content recognition template.
        :type Comment: str
        :param _FaceConfigure: Face recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Activity(AbstractModel):
    """A subtask of a scheme.

    """

    def __init__(self):
        r"""
        :param _ActivityType: The subtask type.
<li>`input`: The start.</li>
<li>`output`: The end.</li>
<li>`action-trans`: Transcoding.</li>
<li>`action-samplesnapshot`: Sampled screencapturing.</li>
<li>`action-AIAnalysis`: Content analysis.</li>
<li>`action-AIRecognition`: Content recognition.</li>
<li>`action-aiReview`: Content moderation.</li>
<li>`action-animated-graphics`: Animated screenshot generation.</li>
<li>`action-image-sprite`: Image sprite generation.</li>
<li>`action-snapshotByTimeOffset`: Time point screencapturing.</li>
<li>`action-adaptive-substream`: Adaptive bitrate streaming.</li>
Note: This field may return null, indicating that no valid values can be obtained.
        :type ActivityType: str
        :param _ReardriveIndex: The indexes of the subsequent actions.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReardriveIndex: list of int
        :param _ActivityPara: The parameters of a subtask.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ActivityPara: :class:`tencentcloud.mps.v20190612.models.ActivityPara`
        """
        self._ActivityType = None
        self._ReardriveIndex = None
        self._ActivityPara = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ReardriveIndex(self):
        return self._ReardriveIndex

    @ReardriveIndex.setter
    def ReardriveIndex(self, ReardriveIndex):
        self._ReardriveIndex = ReardriveIndex

    @property
    def ActivityPara(self):
        return self._ActivityPara

    @ActivityPara.setter
    def ActivityPara(self, ActivityPara):
        self._ActivityPara = ActivityPara


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        self._ReardriveIndex = params.get("ReardriveIndex")
        if params.get("ActivityPara") is not None:
            self._ActivityPara = ActivityPara()
            self._ActivityPara._deserialize(params.get("ActivityPara"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityPara(AbstractModel):
    """A subtask of a scheme.

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: A transcoding task.
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _AnimatedGraphicTask: An animated screenshot generation task.
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _SnapshotByTimeOffsetTask: A time point screencapturing task.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _SampleSnapshotTask: A sampled screencapturing task.
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _ImageSpriteTask: An image sprite generation task.
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _AdaptiveDynamicStreamingTask: An adaptive bitrate streaming task.
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _AiContentReviewTask: A content moderation task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: A content analysis task.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: A content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTaskInput()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = AnimatedGraphicTaskInput()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTaskInput()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = SampleSnapshotTaskInput()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = ImageSpriteTaskInput()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTaskInput()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResItem(AbstractModel):
    """The execution results of the subtasks of a scheme.

    """

    def __init__(self):
        r"""
        :param _TranscodeTask: The result of a transcoding task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: The result of an animated image generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: The result of a time point screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _SampleSnapshotTask: The result of a sampled screenshot task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: The result of an image sprite task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: The result of an adaptive bitrate streaming task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        :param _RecognitionTask: The result of a content recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RecognitionTask: :class:`tencentcloud.mps.v20190612.models.ScheduleRecognitionTaskResult`
        :param _ReviewTask: The result of a content moderation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ReviewTask: :class:`tencentcloud.mps.v20190612.models.ScheduleReviewTaskResult`
        :param _AnalysisTask: The result of a content analysis task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AnalysisTask: :class:`tencentcloud.mps.v20190612.models.ScheduleAnalysisTaskResult`
        """
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None
        self._RecognitionTask = None
        self._ReviewTask = None
        self._AnalysisTask = None

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask

    @property
    def RecognitionTask(self):
        return self._RecognitionTask

    @RecognitionTask.setter
    def RecognitionTask(self, RecognitionTask):
        self._RecognitionTask = RecognitionTask

    @property
    def ReviewTask(self):
        return self._ReviewTask

    @ReviewTask.setter
    def ReviewTask(self, ReviewTask):
        self._ReviewTask = ReviewTask

    @property
    def AnalysisTask(self):
        return self._AnalysisTask

    @AnalysisTask.setter
    def AnalysisTask(self, AnalysisTask):
        self._AnalysisTask = AnalysisTask


    def _deserialize(self, params):
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSampleSnapshotResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        if params.get("RecognitionTask") is not None:
            self._RecognitionTask = ScheduleRecognitionTaskResult()
            self._RecognitionTask._deserialize(params.get("RecognitionTask"))
        if params.get("ReviewTask") is not None:
            self._ReviewTask = ScheduleReviewTaskResult()
            self._ReviewTask._deserialize(params.get("ReviewTask"))
        if params.get("AnalysisTask") is not None:
            self._AnalysisTask = ScheduleAnalysisTaskResult()
            self._AnalysisTask._deserialize(params.get("AnalysisTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ActivityResult(AbstractModel):
    """The execution result of a scheme.

    """

    def __init__(self):
        r"""
        :param _ActivityType: The type of the scheme’s subtask.
<li>Transcode: Transcoding</li>
<li>SampleSnapshot: Sampled screenshot</li>
<li>AnimatedGraphics: Animated image generating</li>
<li>SnapshotByTimeOffset: Time point screenshot</li>
<li>ImageSprites: Image sprite generating</li>
<li>AdaptiveDynamicStreaming: Adaptive bitrate streaming</li>
<li>AiContentReview: Content moderation</li>
<li>AIRecognition: Content recognition</li>
<li>AIAnalysis: Content analysis</li>
        :type ActivityType: str
        :param _ActivityResItem: The execution results of the subtasks of the scheme.
        :type ActivityResItem: :class:`tencentcloud.mps.v20190612.models.ActivityResItem`
        """
        self._ActivityType = None
        self._ActivityResItem = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def ActivityResItem(self):
        return self._ActivityResItem

    @ActivityResItem.setter
    def ActivityResItem(self, ActivityResItem):
        self._ActivityResItem = ActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("ActivityResItem") is not None:
            self._ActivityResItem = ActivityResItem()
            self._ActivityResItem._deserialize(params.get("ActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    """Adaptive bitrate streaming information

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive bitrate streaming specification.
        :type Definition: int
        :param _Package: Container format. Valid values: HLS, MPEG-DASH.
        :type Package: str
        :param _Path: Playback address.
        :type Path: str
        :param _Storage: Storage location of adaptive bitrate streaming files.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Package = None
        self._Path = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._Path = params.get("Path")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    """Input parameter type of adaptive bitrate streaming

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive bitrate streaming template ID.
        :type Definition: int
        :param _WatermarkSet: List of up to 10 image or text watermarks.
        :type WatermarkSet: list of WatermarkInput
        :param _OutputStorage: 
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: The relative or absolute output path of the manifest file after being transcoded to adaptive bitrate streaming. If this parameter is left empty, a relative path in the following format will be used by default: `{inputName}_adaptiveDynamicStreaming_{definition}.{format}`.
        :type OutputObjectPath: str
        :param _SubStreamObjectName: The relative output path of the substream file after being transcoded to adaptive bitrate streaming. If this parameter is left empty, a relative path in the following format will be used by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}.{format}`.
        :type SubStreamObjectName: str
        :param _SegmentObjectName: The relative output path of the segment file after being transcoded to adaptive bitrate streaming (in HLS format only). If this parameter is left empty, a relative path in the following format will be used by default: `{inputName}_adaptiveDynamicStreaming_{definition}_{subStreamNumber}_{segmentNumber}.{format}`.
        :type SegmentObjectName: str
        :param _AddOnSubtitles: 
Note: This field may return·null, indicating that no valid values can be obtained.
        :type AddOnSubtitles: list of AddOnSubtitle
        :param _DrmInfo: 
Note: This field may return·null, indicating that no valid values can be obtained.
        :type DrmInfo: :class:`tencentcloud.mps.v20190612.models.DrmInfo`
        """
        self._Definition = None
        self._WatermarkSet = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._SubStreamObjectName = None
        self._SegmentObjectName = None
        self._AddOnSubtitles = None
        self._DrmInfo = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def SubStreamObjectName(self):
        return self._SubStreamObjectName

    @SubStreamObjectName.setter
    def SubStreamObjectName(self, SubStreamObjectName):
        self._SubStreamObjectName = SubStreamObjectName

    @property
    def SegmentObjectName(self):
        return self._SegmentObjectName

    @SegmentObjectName.setter
    def SegmentObjectName(self, SegmentObjectName):
        self._SegmentObjectName = SegmentObjectName

    @property
    def AddOnSubtitles(self):
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles

    @property
    def DrmInfo(self):
        return self._DrmInfo

    @DrmInfo.setter
    def DrmInfo(self, DrmInfo):
        self._DrmInfo = DrmInfo


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._SubStreamObjectName = params.get("SubStreamObjectName")
        self._SegmentObjectName = params.get("SegmentObjectName")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        if params.get("DrmInfo") is not None:
            self._DrmInfo = DrmInfo()
            self._DrmInfo._deserialize(params.get("DrmInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    """Details of an adaptive bitrate streaming template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _Name: Name of an adaptive bitrate streaming template.
        :type Name: str
        :param _Comment: Description of an adaptive bitrate streaming template.
        :type Comment: str
        :param _Format: Adaptive bitrate streaming format. Valid values:
<li>HLS;</li>
<li>MPEG-DASH.</li>
        :type Format: str
        :param _StreamInfos: Parameter information of input streams for transcoding to adaptive bitrate streaming. Up to 10 streams can be input.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    """Adaptive bitrate streaming parameter template

    """

    def __init__(self):
        r"""
        :param _Video: Video parameter information.
        :type Video: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _Audio: Audio parameter information.
        :type Audio: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _RemoveAudio: Whether to remove audio stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type RemoveAudio: int
        :param _RemoveVideo: Whether to remove video stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type RemoveVideo: int
        """
        self._Video = None
        self._Audio = None
        self._RemoveAudio = None
        self._RemoveVideo = None

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo


    def _deserialize(self, params):
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddOnSubtitle(AbstractModel):
    """The information of the subtitles to add.

    """

    def __init__(self):
        r"""
        :param _Type: The mode. Valid values:
<li>`subtitle-stream`: Add a subtitle track.</li>
<li>`close-caption-708`: Embed CEA-708 subtitles in SEI frames.</li>
<li>`close-caption-608`: Embed CEA-608 subtitles in SEI frames.</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Subtitle: The subtitle file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._Type = None
        self._Subtitle = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = MediaInputInfo()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    """Intelligent analysis results

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Classification: intelligent categorization</li>
<li>Cover: intelligent cover generating</li>
<li>Tag: intelligent tagging</li>
<li>FrameTag: intelligent frame-specific tagging</li>
<li>Highlight: intelligent highlight generating</li>
        :type Type: str
        :param _ClassificationTask: Query result of intelligent categorization task in video content analysis, which is valid if task type is `Classification`.
        :type ClassificationTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: Query result of intelligent cover generating task in video content analysis, which is valid if task type is `Cover`.
        :type CoverTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverResult`
        :param _TagTask: Query result of intelligent tagging task in video content analysis, which is valid if task type is `Tag`.
        :type TagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: Query result of intelligent frame-specific tagging task in video content analysis, which is valid if task type is `FrameTag`.
        :type FrameTagTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: The result of a highlight generation task. This parameter is valid if `Type` is `Highlight`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HighlightTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    """Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video categorization template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    """Result information of intelligent categorization

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: List of intelligently generated video categories.
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        """
        self._ClassificationSet = None

    @property
    def ClassificationSet(self):
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    """Result type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent categorization task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationInput`
        :param _Output: Output of intelligent categorization task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskClassificationOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    """Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video cover generating template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    """Result information of intelligent cover generating

    """

    def __init__(self):
        r"""
        :param _CoverSet: List of intelligently generated covers.
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _OutputStorage: Storage location of intelligently generated cover.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._CoverSet = None
        self._OutputStorage = None

    @property
    def CoverSet(self):
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    """Result type of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent cover generating task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverInput`
        :param _Output: Output of intelligent cover generating task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskCoverOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    """Input type of intelligent frame-specific tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent frame-specific video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    """Result information of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of frame-specific video tags.
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    """Result type of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent frame-specific tagging task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagInput`
        :param _Output: Output of intelligent frame-specific tagging task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskFrameTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    """The input of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _Definition: The ID of the intelligent highlight generation template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    """The output of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _HighlightSet: A list of the highlight segments generated.
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _OutputStorage: The storage location of the highlight segments.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._HighlightSet = None
        self._OutputStorage = None

    @property
    def HighlightSet(self):
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    """The result of an intelligent highlight generation task.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: `PROCESSING`, `SUCCESS`, `FAIL`.
        :type Status: str
        :param _ErrCode: Error code. `0`: The task succeeded; other values: The task failed.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the intelligent highlight generation task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightInput`
        :param _Output: The output of the intelligent highlight generation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskHighlightOutput`
        """
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    """AI video intelligent analysis input parameter types

    """

    def __init__(self):
        r"""
        :param _Definition: Video content analysis template ID.
        :type Definition: int
        :param _ExtendedParameter: An extended parameter, whose value is a stringfied JSON.
Note: This parameter is for customers with special requirements. It needs to be customized offline.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExtendedParameter: str
        """
        self._Definition = None
        self._ExtendedParameter = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ExtendedParameter(self):
        return self._ExtendedParameter

    @ExtendedParameter.setter
    def ExtendedParameter(self, ExtendedParameter):
        self._ExtendedParameter = ExtendedParameter


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ExtendedParameter = params.get("ExtendedParameter")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    """Input type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    """Result information of intelligent tagging

    """

    def __init__(self):
        r"""
        :param _TagSet: List of intelligently generated video tags.
        :type TagSet: list of MediaAiAnalysisTagItem
        """
        self._TagSet = None

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    """Result type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent tagging task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagInput`
        :param _Output: Output of intelligent tagging task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskTagOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    """Content audit result

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Porn (in images)</li>
<li>Terrorism (in images)</li>
<li>Political (in images)</li>
<li>Porn.Asr</li>
<li>Porn.Ocr</li>
<li>Political.Asr</li>
<li>Political.Ocr</li>
<li>Terrorism.Ocr</li>
<li>Prohibited.Asr</li>
<li>Prohibited.Ocr</li>
        :type Type: str
        :param _SampleRate: Sample rate, which indicates the number of video frames captured per second for audit
        :type SampleRate: float
        :param _Duration: Audited video duration in seconds.
        :type Duration: float
        :param _PornTask: Query result of an intelligent porn information detection in image task in video content audit, which is valid when task type is `Porn`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornResult`
        :param _TerrorismTask: The result of detecting terrorism content in images, which is valid when the task type is `Terrorism`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: The result of detecting politically sensitive information in images, which is valid when the task type is `Political`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: Query result of an ASR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Asr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: Query result of an OCR-based porn information detection in text task in video content audit, which is valid when task type is `Porn.Ocr`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: The result of detecting politically sensitive information based on ASR, which is valid when the task type is `Political.Asr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: The result of detecting politically sensitive information based on OCR, which is valid when the task type is `Political.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: The result of detecting terrorism content based on OCR, which is valid when task type is `Terrorism.Ocr`.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedAsrTask: Query result of ASR-based prohibited information detection in speech task in video content audit, which is valid if task type is `Prohibited.Asr`.
        :type ProhibitedAsrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedAsrResult`
        :param _ProhibitedOcrTask: Query result of OCR-based prohibited information detection in text task in video content audit, which is valid if task type is `Prohibited.Ocr`.
        :type ProhibitedOcrTask: :class:`tencentcloud.mps.v20190612.models.AiReviewTaskProhibitedOcrResult`
        """
        self._Type = None
        self._SampleRate = None
        self._Duration = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedAsrTask = None
        self._ProhibitedOcrTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def PornTask(self):
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedAsrTask(self):
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask

    @property
    def ProhibitedOcrTask(self):
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SampleRate = params.get("SampleRate")
        self._Duration = params.get("Duration")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    """Task type of intelligent content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Video content audit template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiQualityControlTaskInput(AbstractModel):
    """The parameters for a video quality control task.

    """

    def __init__(self):
        r"""
        :param _Definition: The ID of the quality control template.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Definition: int
        :param _ChannelExtPara: The channel extension parameter, which is a serialized JSON string.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ChannelExtPara: str
        """
        self._Definition = None
        self._ChannelExtPara = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ChannelExtPara(self):
        return self._ChannelExtPara

    @ChannelExtPara.setter
    def ChannelExtPara(self, ChannelExtPara):
        self._ChannelExtPara = ChannelExtPara


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ChannelExtPara = params.get("ChannelExtPara")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    """Intelligent recognition result.

    """

    def __init__(self):
        r"""
        :param _Type: The task type. Valid values:
<li>FaceRecognition: Face recognition</li>
<li>AsrWordsRecognition: Speech keyword recognition</li>
<li>OcrWordsRecognition: Text keyword recognition</li>
<li>AsrFullTextRecognition: Full speech recognition</li>
<li>OcrFullTextRecognition: Full text recognition</li>
<li>TransTextRecognition: Speech translation</li>
        :type Type: str
        :param _FaceTask: Face recognition result, which is valid when `Type` is 
 `FaceRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type FaceTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: Speech keyword recognition result, which is valid when `Type` is
 `AsrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: Full speech recognition result, which is valid when `Type` is
 `AsrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResult`
        :param _OcrWordsTask: Text keyword recognition result, which is valid when `Type` is
 `OcrWordsRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrWordsTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: Full text recognition result, which is valid when `Type` is
 `OcrFullTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResult`
        :param _TransTextTask: The translation result. This parameter is valid only if `Type` is
 `TransTextRecognition`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TransTextTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResult`
        """
        self._Type = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._TransTextTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceTask(self):
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def OcrWordsTask(self):
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def TransTextTask(self):
        return self._TransTextTask

    @TransTextTask.setter
    def TransTextTask(self, TransTextTask):
        self._TransTextTask = TransTextTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("TransTextTask") is not None:
            self._TransTextTask = AiRecognitionTaskTransTextResult()
            self._TransTextTask._deserialize(params.get("TransTextTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    """Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a full speech recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: Output information of a full speech recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrFullTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    """Input for full speech recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full speech recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    """Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of full speech recognition segments.
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SubtitlePath: Subtitles file address.
        :type SubtitlePath: str
        :param _OutputStorage: Subtitles file storage location.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._SegmentSet = None
        self._SubtitlePath = None
        self._OutputStorage = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    """Full speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Text: Recognized text.
        :type Text: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    """Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a speech keyword recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: Output information of a speech keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskAsrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    """Input for speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Speech keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    """Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Speech keyword.
        :type Word: str
        :param _SegmentSet: List of time segments that contain the speech keyword.
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    """Output of speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Speech keyword recognition result set.
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    """Speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    """Face recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a face recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultInput`
        :param _Output: Output information of a face recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskFaceResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    """Face recognition input.

    """

    def __init__(self):
        r"""
        :param _Definition: Face recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    """Face recognition result

    """

    def __init__(self):
        r"""
        :param _Id: Unique ID of a figure.
        :type Id: str
        :param _Type: Figure library type, indicating to which figure library the recognized figure belongs:
<li>Default: Default figure library;</li>
<li>UserDefine: Custom figure library.</li>
        :type Type: str
        :param _Name: Name of a figure.
        :type Name: str
        :param _SegmentSet: Result set of segments that contain a figure.
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        :param _Gender: The person’s gender.
<li>Male</li>
<li>Female</li>
Note: This field may return null, indicating that no valid value can be obtained.
        :type Gender: str
        :param _Birthday: The person’s birth date.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Birthday: str
        :param _Profession: The person’s job or job title.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Profession: str
        :param _SchoolOfGraduation: The college the person graduated from.
Note: This field may return null, indicating that no valid value can be obtained.
        :type SchoolOfGraduation: str
        :param _Abstract: The person’s profile.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Abstract: str
        :param _PlaceOfBirth: The person’s place of birth.
Note: This field may return null, indicating that no valid value can be obtained.
        :type PlaceOfBirth: str
        :param _PersonType: Whether the person is a politician or artist.
<li>Politician</li>
<li>Artist</li>
Note: This field may return null, indicating that no valid value can be obtained.
        :type PersonType: str
        :param _Remark: Sensitivity
<li>Normal</li>
<li>Sensitive</li>
Note: This field may return null, indicating that no valid value can be obtained.
        :type Remark: str
        :param _Url: The screenshot URL.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Url: str
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None
        self._Gender = None
        self._Birthday = None
        self._Profession = None
        self._SchoolOfGraduation = None
        self._Abstract = None
        self._PlaceOfBirth = None
        self._PersonType = None
        self._Remark = None
        self._Url = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def Gender(self):
        return self._Gender

    @Gender.setter
    def Gender(self, Gender):
        self._Gender = Gender

    @property
    def Birthday(self):
        return self._Birthday

    @Birthday.setter
    def Birthday(self, Birthday):
        self._Birthday = Birthday

    @property
    def Profession(self):
        return self._Profession

    @Profession.setter
    def Profession(self, Profession):
        self._Profession = Profession

    @property
    def SchoolOfGraduation(self):
        return self._SchoolOfGraduation

    @SchoolOfGraduation.setter
    def SchoolOfGraduation(self, SchoolOfGraduation):
        self._SchoolOfGraduation = SchoolOfGraduation

    @property
    def Abstract(self):
        return self._Abstract

    @Abstract.setter
    def Abstract(self, Abstract):
        self._Abstract = Abstract

    @property
    def PlaceOfBirth(self):
        return self._PlaceOfBirth

    @PlaceOfBirth.setter
    def PlaceOfBirth(self, PlaceOfBirth):
        self._PlaceOfBirth = PlaceOfBirth

    @property
    def PersonType(self):
        return self._PersonType

    @PersonType.setter
    def PersonType(self, PersonType):
        self._PersonType = PersonType

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._Gender = params.get("Gender")
        self._Birthday = params.get("Birthday")
        self._Profession = params.get("Profession")
        self._SchoolOfGraduation = params.get("SchoolOfGraduation")
        self._Abstract = params.get("Abstract")
        self._PlaceOfBirth = params.get("PlaceOfBirth")
        self._PersonType = params.get("PersonType")
        self._Remark = params.get("Remark")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    """Output of intelligent face recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Intelligent face recognition result set.
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    """Face recognition result segment

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    """Input parameter type of video content recognition

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    """Full text recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a full text recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: Output information of a full text recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrFullTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    """Input for full text recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full text recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    """Output of full text recognition.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: Full text recognition result set.
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        """
        self._SegmentSet = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    """Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _TextSet: Recognition segment result set.
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    """Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _Text: Recognized text.
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    """Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of a text keyword recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: Output information of a text keyword recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskOcrWordsResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    """Input for text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Text keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    """Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Text keyword.
        :type Word: str
        :param _SegmentSet: List of segments that contain a text keyword.
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    """Output of text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Text keyword recognition result set.
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    """Text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a recognition segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a recognition segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of a recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResult(AbstractModel):
    """The translation result.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. `0` indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the translation task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultInput`
        :param _Output: The output of the translation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskTransTextResultOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskTransTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskTransTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultInput(AbstractModel):
    """The translation input.

    """

    def __init__(self):
        r"""
        :param _Definition: The translation template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextResultOutput(AbstractModel):
    """The translation result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: The translated segments.
        :type SegmentSet: list of AiRecognitionTaskTransTextSegmentItem
        :param _SubtitlePath: The subtitle URL.
        :type SubtitlePath: str
        :param _OutputStorage: The subtitle storage location.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._SegmentSet = None
        self._SubtitlePath = None
        self._OutputStorage = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SubtitlePath(self):
        return self._SubtitlePath

    @SubtitlePath.setter
    def SubtitlePath(self, SubtitlePath):
        self._SubtitlePath = SubtitlePath

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskTransTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SubtitlePath = params.get("SubtitlePath")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskTransTextSegmentItem(AbstractModel):
    """The translated segments.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for a segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: The start time offset (seconds) of a segment.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end time offset (seconds) of a segment.
        :type EndTimeOffset: float
        :param _Text: The text transcript.
        :type Text: str
        :param _Trans: The translation.
        :type Trans: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None
        self._Trans = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def Trans(self):
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        self._Trans = params.get("Trans")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    """The input parameters for ASR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    """The information about the sensitive content detected based on ASR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the ASR-based detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on ASR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on ASR.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    """The input parameters for OCR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    """The information about the sensitive content detected based on OCR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the OCR-based detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on OCR.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    """The input parameters for the detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    """The sensitive information detected.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive content. The relationship between the values of this parameter and those of the `LabelSet` parameter in [PoliticalImgReviewTemplateInfo](https://intl.cloud.tencent.com/document/api/862/37615?from_cn_redirect=1#AiReviewPoliticalTaskOutput) is as follows:
violation_photo:
<li>violation_photo (banned icons)</li>
Other values (politician/entertainment/sport/entrepreneur/scholar/celebrity/military):
<li>politician</li>
        :type Label: str
        :param _SegmentSet: The video segments that contain sensitive information.
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    """Input parameter type of an ASR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: ID of a porn information detection template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    """ASR-detected porn information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the ASR-detected porn information in text from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the ASR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the ASR-detected porn information in text.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    """Input parameter type of an OCR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: ID of a porn information detection template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    """OCR-detected porn information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the OCR-detected porn information in text from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the OCR-detected porn information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the OCR-detected porn information in text.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    """Input parameter type of a porn information detection task during content audit

    """

    def __init__(self):
        r"""
        :param _Definition: The ID of a porn detection template.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    """Porn information detection result

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of the detected porn information in video from 0 to 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for the detected porn information. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _Label: Tag of the detected porn information in video. Valid values:
<li>porn: Porn.</li>
<li>sexy: Sexiness.</li>
<li>vulgar: Vulgarity.</li>
<li>intimacy: Intimacy.</li>
        :type Label: str
        :param _SegmentSet: List of video segments that contain the detected porn information.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    """Input parameter type of ASR-based prohibited information detection in speech task in content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    """ASR-detected prohibited information in speech

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of ASR-detected prohibited information in speech between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for ASR-detected prohibited information in speech. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the ASR-detected prohibited information in speech.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    """Input parameter type of OCR-based prohibited information detection in text task in content audit

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    """OCR-detected prohibited information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of OCR-detected prohibited information in text between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for OCR-detected prohibited information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain the OCR-detected prohibited information in text.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    """The result of ASR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for ASR-based detection of politically sensitive information.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: The output of ASR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    """The result of OCR-based detection of politically sensitive information.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: The input parameter for OCR-based detection of politically sensitive information.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: The output of OCR-based detection of politically sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    """The result of sensitive information detection.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for sensitive information detection.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskInput`
        :param _Output: The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPoliticalTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    """Result type of an ASR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an ASR-based porn information detection in text task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskInput`
        :param _Output: Output of an ASR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    """Result type of an OCR-based porn information detection in text task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an OCR-based porn information detection in text task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskInput`
        :param _Output: Output of an OCR-based porn information detection in text task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    """Result type of a porn information detection task during content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for a porn information detection task during content audit.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskInput`
        :param _Output: Output of a porn information detection task during content audit.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewPornTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    """Result type of ASR-based prohibited information detection in speech task in content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of ASR-based prohibited information detection in speech task in content audit
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: Output of ASR-based prohibited information detection in speech task in content audit
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedAsrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    """Result type of OCR-based prohibited information detection in text task in content audit

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of OCR-based prohibited information detection in text task in content audit
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: Output of OCR-based prohibited information detection in text task in content audit
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewProhibitedOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    """The result of OCR-based detection of terrorism content.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for OCR-based detection of terrorism content.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: The output of OCR-based detection of terrorism content.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismOcrTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    """The result of sensitive information detection.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: The input parameter for sensitive information detection.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskInput`
        :param _Output: The output of sensitive information detection.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AiReviewTerrorismTaskOutput`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    """The input parameter for OCR-based detection of sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    """The information about the sensitive content detected based on OCR.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the OCR-based detection of sensitive information. Value range: 1-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected based on OCR. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: The video segments that contain sensitive information detected based on OCR.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    """The input parameter for the detection of sensitive information.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    """The information about the sensitive content detected.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the detection of sensitive information. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive information detected. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive content. Valid values:
<li>guns</li>
<li>crowd</li>
<li>police</li>
<li>bloody</li>
<li>banners (sensitive flags)</li>
<li>militant</li>
<li>explosion</li>
<li>terrorists</li>
<li>scenario (sensitive scenes) </li>
        :type Label: str
        :param _SegmentSet: The video segments that contain sensitive information.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    """AI-based sample management - face information.

    """

    def __init__(self):
        r"""
        :param _FaceId: Face image ID.
        :type FaceId: str
        :param _Url: Face image address.
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    """AI-based sample management - face data operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset. The `reset` operation will clear the existing face data of a figure and add `FaceContents` as the specified face data.
        :type Type: str
        :param _FaceIds: Face ID set. This field is required when `Type` is `delete`.
        :type FaceIds: list of str
        :param _FaceContents: String set generated by [Base64-encoding](https://tools.ietf.org/html/rfc4648) the face image.
<li>This field is required when `Type` is `add` or `reset`;</li>
<li>Array length limit: 5 images.</li>
Note: The image must be a relatively clear full-face photo of a figure in at least 200 * 200 px.
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    """AI-based sample management - face information failing to be processed.

    """

    def __init__(self):
        r"""
        :param _Index: Corresponds to incorrect image subscripts in the `FaceContents` input parameter, starting from 0.
        :type Index: int
        :param _ErrCode: Error code. Valid values:
<li>0: Succeeded;</li>
<li>Other values: Failed.</li>
        :type ErrCode: int
        :param _Message: Error description.
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    """AI-based sample management - figure information.

    """

    def __init__(self):
        r"""
        :param _PersonId: Figure ID.
        :type PersonId: str
        :param _Name: Name of a figure.
        :type Name: str
        :param _Description: Figure description.
        :type Description: str
        :param _FaceInfoSet: Face information.
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: Figure tag.
        :type TagSet: list of str
        :param _UsageSet: Use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    """AI-based sample management - tag operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset.
        :type Type: str
        :param _Tags: Tag. Length limit: 128 characters.
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    """AI-based sample management - keyword output information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword.
        :type Keyword: str
        :param _TagSet: Keyword tag.
        :type TagSet: list of str
        :param _UsageSet: Keyword use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    """AI-based sample management - keyword input information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword. Length limit: 20 characters.
        :type Keyword: str
        :param _Tags: Keyword tag
<li>Array length limit: 20 tags;</li>
<li>Tag length limit: 128 characters.</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    """Type of an animated image generating task.

    """

    def __init__(self):
        r"""
        :param _Definition: Animated image generating template ID.
        :type Definition: int
        :param _StartTimeOffset: Start time of an animated image in a video in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time of an animated image in a video in seconds.
        :type EndTimeOffset: float
        :param _OutputStorage: Target bucket of a generated animated image file. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path to a generated animated image file, which can be a relative path or an absolute path. If this parameter is left empty, the following relative path will be used by default: `{inputName}_animatedGraphic_{definition}.{format}`.
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    """Details of an animated image generating template.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Name of an animated image generating template.
        :type Name: str
        :param _Comment: Description of an animated image generating template.
        :type Comment: str
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: Enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: Disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format.
        :type Format: str
        :param _Fps: Frame rate.
        :type Fps: int
        :param _Quality: Image quality.
        :type Quality: float
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ArtifactRepairConfig(AbstractModel):
    """Artifact removal (smoothing) configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>weak</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    """Control parameter of a full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormat: Format of the generated subtitles file. If this parameter is left empty or an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :type SubtitleFormat: str
        """
        self._Switch = None
        self._SubtitleFormat = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    """Control parameter of a full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full speech recognition task. Valid values:
<li>ON: Enables an intelligent full speech recognition task;</li>
<li>OFF: Disables an intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormat: Format of the generated subtitles file. If an empty string is entered, no subtitles files will be generated. Valid value:
<li>vtt: Generates a WebVTT subtitles file.</li>
        :type SubtitleFormat: str
        """
        self._Switch = None
        self._SubtitleFormat = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormat = params.get("SubtitleFormat")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    """Speech keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    """Speech keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a speech keyword recognition task. Valid values:
<li>ON: Enables a speech keyword recognition task;</li>
<li>OFF: Disables a speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioBeautifyConfig(AbstractModel):
    """The audio improvement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        :param _Types: The audio improvement options. You can specify multiple options. Valid values:
<li>`declick`: Noise removal.</li>
<li>`deesser`: De-essing.</li>
Default: `declick`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Types: list of str
        """
        self._Switch = None
        self._Types = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Types(self):
        return self._Types

    @Types.setter
    def Types(self, Types):
        self._Types = Types


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Types = params.get("Types")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioDenoiseConfig(AbstractModel):
    """The noise reduction configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioEnhanceConfig(AbstractModel):
    """The audio enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Denoise: The audio noise reduction configuration.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Denoise: :class:`tencentcloud.mps.v20190612.models.AudioDenoiseConfig`
        :param _Separate: The audio separation configuration.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Separate: :class:`tencentcloud.mps.v20190612.models.AudioSeparateConfig`
        :param _VolumeBalance: The volume equalization configuration.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type VolumeBalance: :class:`tencentcloud.mps.v20190612.models.VolumeBalanceConfig`
        :param _Beautify: The audio improvement configuration.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Beautify: :class:`tencentcloud.mps.v20190612.models.AudioBeautifyConfig`
        """
        self._Denoise = None
        self._Separate = None
        self._VolumeBalance = None
        self._Beautify = None

    @property
    def Denoise(self):
        return self._Denoise

    @Denoise.setter
    def Denoise(self, Denoise):
        self._Denoise = Denoise

    @property
    def Separate(self):
        return self._Separate

    @Separate.setter
    def Separate(self, Separate):
        self._Separate = Separate

    @property
    def VolumeBalance(self):
        return self._VolumeBalance

    @VolumeBalance.setter
    def VolumeBalance(self, VolumeBalance):
        self._VolumeBalance = VolumeBalance

    @property
    def Beautify(self):
        return self._Beautify

    @Beautify.setter
    def Beautify(self, Beautify):
        self._Beautify = Beautify


    def _deserialize(self, params):
        if params.get("Denoise") is not None:
            self._Denoise = AudioDenoiseConfig()
            self._Denoise._deserialize(params.get("Denoise"))
        if params.get("Separate") is not None:
            self._Separate = AudioSeparateConfig()
            self._Separate._deserialize(params.get("Separate"))
        if params.get("VolumeBalance") is not None:
            self._VolumeBalance = VolumeBalanceConfig()
            self._VolumeBalance._deserialize(params.get("VolumeBalance"))
        if params.get("Beautify") is not None:
            self._Beautify = AudioBeautifyConfig()
            self._Beautify._deserialize(params.get("Beautify"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioSeparateConfig(AbstractModel):
    """The audio separation configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>`ON`</li>
<li>`OFF` </li>
Default value: `ON`.
        :type Switch: str
        :param _Type: The scenario. Valid values:
<li>`normal`: Separate voice and background audio.</li>
<li>`music`: Separate vocals and instrumentals.</li>
Default value: `normal`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Track: The output audio track. Valid values:
<li>`vocal`: Voice.</li>
<li>`background`: Output background audio if the scenario is `normal`, and output instrumentals if the scenario is `music`.</li>
Default value: `vocal`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Track: str
        """
        self._Switch = None
        self._Type = None
        self._Track = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Track(self):
        return self._Track

    @Track.setter
    def Track(self, Track):
        self._Track = Track


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Track = params.get("Track")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    """Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: Audio stream codec.
When the outer `Container` parameter is `mp3`, the valid value is:
<li>libmp3lame.</li>
When the outer `Container` parameter is `ogg` or `flac`, the valid value is:
<li>flac.</li>
When the outer `Container` parameter is `m4a`, the valid values include:
<li>libfdk_aac;</li>
<li>libmp3lame;</li>
<li>ac3.</li>
When the outer `Container` parameter is `mp4` or `flv`, the valid values include:
<li>libfdk_aac: more suitable for mp4;</li>
<li>libmp3lame: more suitable for flv.</li>
When the outer `Container` parameter is `hls`, the valid values include:
<li>libfdk_aac;</li>
<li>libmp3lame.</li>
        :type Codec: str
        :param _Bitrate: Audio stream bitrate in Kbps. Value range: 0 and [26, 256].
If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :type Bitrate: int
        :param _SampleRate: Audio stream sample rate. Valid values:
<li>32,000</li>
<li>44,100</li>
<li>48,000</li>
In Hz.
        :type SampleRate: int
        :param _AudioChannel: Audio channel system. Valid values:
<li>1: Mono</li>
<li>2: Dual</li>
<li>6: Stereo</li>
When the media is packaged in audio format (FLAC, OGG, MP3, M4A), the sound channel cannot be set to stereo.
Default value: 2
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    """Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: Audio stream codec.
When the outer `Container` parameter is `mp3`, the valid value is:
<li>libmp3lame.</li>
When the outer `Container` parameter is `ogg` or `flac`, the valid value is:
<li>flac.</li>
When the outer `Container` parameter is `m4a`, the valid values include:
<li>libfdk_aac;</li>
<li>libmp3lame;</li>
<li>ac3.</li>
When the outer `Container` parameter is `mp4` or `flv`, the valid values include:
<li>libfdk_aac: More suitable for mp4;</li>
<li>libmp3lame: More suitable for flv;</li>
<li>mp2.</li>
When the outer `Container` parameter is `hls`, the valid values include:
<li>libfdk_aac;</li>
<li>libmp3lame.</li>
        :type Codec: str
        :param _Bitrate: Audio stream bitrate in Kbps. Value range: 0 and [26, 256]. If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :type Bitrate: int
        :param _SampleRate: Audio stream sample rate. Valid values:
<li>32,000</li>
<li>44,100</li>
<li>48,000</li>
In Hz.
        :type SampleRate: int
        :param _AudioChannel: Audio channel system. Valid values:
<li>1: Mono</li>
<li>2: Dual</li>
<li>6: Stereo</li>
When the media is packaged in audio format (FLAC, OGG, MP3, M4A), the sound channel cannot be set to stereo.
        :type AudioChannel: int
        :param _StreamSelects: The audio tracks to retain. All audio tracks are retained by default.
        :type StreamSelects: list of int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None
        self._StreamSelects = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel

    @property
    def StreamSelects(self):
        return self._StreamSelects

    @StreamSelects.setter
    def StreamSelects(self, StreamSelects):
        self._StreamSelects = StreamSelects


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        self._StreamSelects = params.get("StreamSelects")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsS3FileUploadTrigger(AbstractModel):
    """An AWS S3 file upload trigger.

    """

    def __init__(self):
        r"""
        :param _S3Bucket: The AWS S3 bucket bound to the scheme.
        :type S3Bucket: str
        :param _S3Region: The region of the AWS S3 bucket.
        :type S3Region: str
        :param _Dir: The bucket directory bound. It must be an absolute path that starts and ends with `/`, such as `/movie/201907/`. If you do not specify this, the root directory will be bound.	
        :type Dir: str
        :param _Formats: The file formats that will trigger the scheme, such as ["mp4", "flv", "mov"]. If you do not specify this, the upload of files in any format will trigger the scheme.	
        :type Formats: list of str
        :param _S3SecretId: The key ID of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretId: str
        :param _S3SecretKey: The key of the AWS S3 bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type S3SecretKey: str
        :param _AwsSQS: The SQS queue of the AWS S3 bucket.
Note: The queue must be in the same region as the bucket.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AwsSQS: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        """
        self._S3Bucket = None
        self._S3Region = None
        self._Dir = None
        self._Formats = None
        self._S3SecretId = None
        self._S3SecretKey = None
        self._AwsSQS = None

    @property
    def S3Bucket(self):
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def Dir(self):
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey

    @property
    def AwsSQS(self):
        return self._AwsSQS

    @AwsSQS.setter
    def AwsSQS(self, AwsSQS):
        self._AwsSQS = AwsSQS


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        if params.get("AwsSQS") is not None:
            self._AwsSQS = AwsSQS()
            self._AwsSQS._deserialize(params.get("AwsSQS"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsSQS(AbstractModel):
    """The information of an AWS SQS queue.

    """

    def __init__(self):
        r"""
        :param _SQSRegion: The region of the SQS queue.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type SQSRegion: str
        :param _SQSQueueName: The name of the SQS queue.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type SQSQueueName: str
        :param _S3SecretId: The key ID required to read from/write to the SQS queue.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type S3SecretId: str
        :param _S3SecretKey: The key required to read from/write to the SQS queue.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type S3SecretKey: str
        """
        self._SQSRegion = None
        self._SQSQueueName = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def SQSRegion(self):
        return self._SQSRegion

    @SQSRegion.setter
    def SQSRegion(self, SQSRegion):
        self._SQSRegion = SQSRegion

    @property
    def SQSQueueName(self):
        return self._SQSQueueName

    @SQSQueueName.setter
    def SQSQueueName(self, SQSQueueName):
        self._SQSQueueName = SQSQueueName

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._SQSRegion = params.get("SQSRegion")
        self._SQSQueueName = params.get("SQSQueueName")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    """Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ColorEnhanceConfig(AbstractModel):
    """Color enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>weak</li>
<li>normal</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioItem(AbstractModel):
    """The audio element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _AudioOperations: The operations performed, such as muting.
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def AudioOperations(self):
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioOperation(AbstractModel):
    """The audio operations of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The operation type. Valid values:
<li>`Volume`: Volume adjustment. </li>
        :type Type: str
        :param _Volume:  The volume level. This parameter is valid if `Type` is `Volume`. Value range: 0–5. 
<li>If the parameter value is `0`, the video will be muted. </li>
<li>If the parameter value is smaller than 1, the volume will be reduced. </li>
<li>If the parameter value is `1`, the original volume will be kept. </li>
<li>If the parameter value is greater than 1, the volume will be increased. </li>
        :type Volume: float
        """
        self._Type = None
        self._Volume = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Volume(self):
        return self._Volume

    @Volume.setter
    def Volume(self, Volume):
        self._Volume = Volume


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Volume = params.get("Volume")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeAudioStream(AbstractModel):
    """The audio stream information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Codec: The codec of the audio stream. Valid values:
<li>`AAC`: AAC (default), which is used for the MP4 container. </li>
<li>`MP3`: MP3 codec, which is used for the MP3 container. </li>
        :type Codec: str
        :param _SampleRate: The sample rate (Hz) of the audio stream.
<li>16000 (default)</li>
<li>32000</li>
<li>44100</li>
<li>48000</li>
        :type SampleRate: int
        :param _AudioChannel: The number of sound channels. Valid values:
u200c<li>`1`: Mono. </li>
<li>`2`: Dual (default). </li>
        :type AudioChannel: int
        """
        self._Codec = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeCanvas(AbstractModel):
    """The canvas information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Color: The RGB value of the background color. The format is #RRGGBB, such as `#F0F0F0`. 
Default value: `#000000` (black).
        :type Color: str
        :param _Width: The canvas width (px), which is the width of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as wide as the first video.
        :type Width: int
        :param _Height: The canvas height (px), which is the height of the output video. Value range: 0–3840.  
The default value is `0`, which means that the canvas is as high as the first video.
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeEmptyItem(AbstractModel):
    """The placeholder element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Duration: The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates 3.5 seconds. </li>
        :type Duration: str
        """
        self._Duration = None

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageItem(AbstractModel):
    """The image element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type XPos: str
        :param _YPos: The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type YPos: str
        :param _Width: The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Width: str
        :param _Height: The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the video will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Height: str
        :param _ImageOperations: The image operations, such as image rotation.
        :type ImageOperations: list of ComposeImageOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeImageOperation(AbstractModel):
    """The image operations of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The type. Valid values:
u200c<li>`Rotate`: Image rotation. </li>
<li>`Flip`: Image flipping. </li>
        :type Type: str
        :param _RotateAngle: This is valid if `Type` is `Rotate`. The angle of rotation around the image center. Value range: 0–360.
        :type RotateAngle: float
        :param _FlipType: This is valid if `Type` is `Flip`. How to flip the image. Valid values:xa0
u200c<li>`Horizental`: Flip horizontally. </li>
<li>`Vertical`: Flip vertically. </li>
        :type FlipType: str
        """
        self._Type = None
        self._RotateAngle = None
        self._FlipType = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def RotateAngle(self):
        return self._RotateAngle

    @RotateAngle.setter
    def RotateAngle(self, RotateAngle):
        self._RotateAngle = RotateAngle

    @property
    def FlipType(self):
        return self._FlipType

    @FlipType.setter
    def FlipType(self, FlipType):
        self._FlipType = FlipType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._RotateAngle = params.get("RotateAngle")
        self._FlipType = params.get("FlipType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaConfig(AbstractModel):
    """The information of a video editing/compositing task.

    The figure below outlines the relationships among tracks, elements, and the timeline.

    ![image](https://ie-mps-1258344699.cos.ap-nanjing.tencentcos.cn/common/cloud/EditMedia-Compose-Track-Item.png)

    """

    def __init__(self):
        r"""
        :param _TargetInfo: The information of the output video.
        :type TargetInfo: :class:`tencentcloud.mps.v20190612.models.ComposeTargetInfo`
        :param _Canvas: The canvas information of the output video.
        :type Canvas: :class:`tencentcloud.mps.v20190612.models.ComposeCanvas`
        :param _Styles: The global styles. This parameter is used together with `Tracks` to specify styles, such as the subtitle style.
        :type Styles: list of ComposeStyles
        :param _Tracks: The information of media tracks (consisting of video, audio, image, and text elements) used to composite the video. About tracks and the timeline:
<ul><li>The timeline of a track is the same as the timeline of the output video. </li><li>The elements of different tracks are overlaid at the same time point in the timeline.</li><ul><li>Video, image, and text elements are overlaid according to their track number, with the first track on top. </li><li>Audio elements are mixed. </li></ul></ul>Note: The different elements of the same track cannot be overlaid (except subtitles).
        :type Tracks: list of ComposeMediaTrack
        """
        self._TargetInfo = None
        self._Canvas = None
        self._Styles = None
        self._Tracks = None

    @property
    def TargetInfo(self):
        return self._TargetInfo

    @TargetInfo.setter
    def TargetInfo(self, TargetInfo):
        self._TargetInfo = TargetInfo

    @property
    def Canvas(self):
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Styles(self):
        return self._Styles

    @Styles.setter
    def Styles(self, Styles):
        self._Styles = Styles

    @property
    def Tracks(self):
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks


    def _deserialize(self, params):
        if params.get("TargetInfo") is not None:
            self._TargetInfo = ComposeTargetInfo()
            self._TargetInfo._deserialize(params.get("TargetInfo"))
        if params.get("Canvas") is not None:
            self._Canvas = ComposeCanvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Styles") is not None:
            self._Styles = []
            for item in params.get("Styles"):
                obj = ComposeStyles()
                obj._deserialize(item)
                self._Styles.append(obj)
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = ComposeMediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaItem(AbstractModel):
    """The element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The element type. Valid values:
<li>`Video` </li>
<li>`Audio` </li>
<li>`Image` </li>
<li>`Transition` </li>
<li>`Subtitle` </li>
<li>`Empty` </li>
        :type Type: str
        :param _Video: The information of the video element, which is valid if `Type` is `Video`.
        :type Video: :class:`tencentcloud.mps.v20190612.models.ComposeVideoItem`
        :param _Audio: The information of the audio element, which is valid if `Type` is `Audio`.
        :type Audio: :class:`tencentcloud.mps.v20190612.models.ComposeAudioItem`
        :param _Image: The information of the image element, which is valid if `Type` is `Image`.
        :type Image: :class:`tencentcloud.mps.v20190612.models.ComposeImageItem`
        :param _Transition: The information of the transition element, which is valid if `Type` is `Transition`.
        :type Transition: :class:`tencentcloud.mps.v20190612.models.ComposeTransitionItem`
        :param _Subtitle: The information of the subtitle element, which is valid if `Type` is `Subtitle`.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleItem`
        :param _Empty: The information of the empty element, which is valid if `Type` is `Empty`. An empty element is used as a placeholder in the timeline.
        :type Empty: :class:`tencentcloud.mps.v20190612.models.ComposeEmptyItem`
        """
        self._Type = None
        self._Video = None
        self._Audio = None
        self._Image = None
        self._Transition = None
        self._Subtitle = None
        self._Empty = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def Image(self):
        return self._Image

    @Image.setter
    def Image(self, Image):
        self._Image = Image

    @property
    def Transition(self):
        return self._Transition

    @Transition.setter
    def Transition(self, Transition):
        self._Transition = Transition

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle

    @property
    def Empty(self):
        return self._Empty

    @Empty.setter
    def Empty(self, Empty):
        self._Empty = Empty


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Video") is not None:
            self._Video = ComposeVideoItem()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = ComposeAudioItem()
            self._Audio._deserialize(params.get("Audio"))
        if params.get("Image") is not None:
            self._Image = ComposeImageItem()
            self._Image._deserialize(params.get("Image"))
        if params.get("Transition") is not None:
            self._Transition = ComposeTransitionItem()
            self._Transition._deserialize(params.get("Transition"))
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleItem()
            self._Subtitle._deserialize(params.get("Subtitle"))
        if params.get("Empty") is not None:
            self._Empty = ComposeEmptyItem()
            self._Empty._deserialize(params.get("Empty"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTrack(AbstractModel):
    """The track information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The track type. Valid values:<ul><li>`Video`: Video track. A video track can consist of the following elements:</li><ul><li>Video</li><li>Image</li><li>Transition</li><li>Empty</li></ul><li>`Audio`: Audio track. An audio track can consist of the following elements:</li><ul><li>Audio</li><li>Transition</li><li>Empty</li></ul><li>`Title`: Text track. A text track can consist of the following elements: </li><ul><li>Subtitle</li></ul>
        :type Type: str
        :param _Items: The elements of a track.
        :type Items: list of ComposeMediaItem
        """
        self._Type = None
        self._Items = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Items(self):
        return self._Items

    @Items.setter
    def Items(self, Items):
        self._Items = Items


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("Items") is not None:
            self._Items = []
            for item in params.get("Items"):
                obj = ComposeMediaItem()
                obj._deserialize(item)
                self._Items.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSourceMedia(AbstractModel):
    """The material source of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _FileId: The material ID, which can be found in `FileInfos`.
        :type FileId: str
        :param _StartTime: The start time of the material. The following two formats are supported.
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
Default value: `0s`.
        :type StartTime: str
        :param _EndTime: The end time of the material. This parameter and `StartTime` determine which time segment of the material is used. The following two formats are supported:
<li>If the value of this parameter ends with `s`, it specifies the time in seconds. For example, `3.5s` indicates the time when 3.5 seconds of the material elapses.</li>
u200c<li>If the value of this parameter ends with `%`, it specifies the time as a percentage of the material's duration. For example, `10%` indicates the time when 10% of the material's duration elapses. </li>
If the track duration is set, the default value is `StartTime` plus the track duration. If not, the default value is `StartTime` plus 1 second.
Note: `EndTime` must be at least 0.02 seconds later than `StartTime`.

        :type EndTime: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeStyles(AbstractModel):
    """The style information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Id: The style ID, which identifies an element style.
Note: The style ID can be up to 32 characters long and can contain letters, digits, and special characters -_
        :type Id: str
        :param _Type: The type. Valid values:
<li>`Subtitle`: The subtitle style. </li>
        :type Type: str
        :param _Subtitle: The subtitle style details. This parameter is valid if `Type` is `Subtitle`.
        :type Subtitle: :class:`tencentcloud.mps.v20190612.models.ComposeSubtitleStyle`
        """
        self._Id = None
        self._Type = None
        self._Subtitle = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Subtitle(self):
        return self._Subtitle

    @Subtitle.setter
    def Subtitle(self, Subtitle):
        self._Subtitle = Subtitle


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        if params.get("Subtitle") is not None:
            self._Subtitle = ComposeSubtitleStyle()
            self._Subtitle._deserialize(params.get("Subtitle"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleItem(AbstractModel):
    """The subtitle element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _StyleId: The subtitle style ID, which corresponds to the `Id` field of `ComposeStyles`.
        :type StyleId: str
        :param _Text: The subtitle text.
        :type Text: str
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.	
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        """
        self._StyleId = None
        self._Text = None
        self._TrackTime = None

    @property
    def StyleId(self):
        return self._StyleId

    @StyleId.setter
    def StyleId(self, StyleId):
        self._StyleId = StyleId

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime


    def _deserialize(self, params):
        self._StyleId = params.get("StyleId")
        self._Text = params.get("Text")
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeSubtitleStyle(AbstractModel):
    """The subtitle style of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Height: The subtitle height. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
The default value is the value of `FontSize`.
        :type Height: str
        :param _MarginBottom: The bottom margin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas height. For example, `10%` means that the margin is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
Default value: `0px`.
        :type MarginBottom: str
        :param _FontType: The font type. Valid values:
<li>`SimHei`(default): Chinese font Heiti. </li>
<Li>`SimSun`: Chinese font Songti. </li>
        :type FontType: str
        :param _FontSize: The font size. Two formats are supported:
u200c<li>If the value ends with %, it specifies the size as a percentage of the canvas height. For example, `10%` means that the size is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the size in pixels. For example, `100px` means that the size is 100 pixels. </li>
Default value: `2%`.
        :type FontSize: str
        :param _FontBold: Whether to bold the text (some fonts may not support bold). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type FontBold: int
        :param _FontItalic: Whether to italicize the text (some fonts may not support italics). Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type FontItalic: int
        :param _FontColor: The font color (#RRGGBBAA).  
Default value: `0x000000FF` (black).  
Note: `AA` in the color notation defines the opacity of the color. It's optional.

        :type FontColor: str
        :param _FontAlign: The text alignment. Valid values:
<li>`Center`(default) </li>
<li>`Left` </li>
<li>`Right` </li>
        :type FontAlign: str
        :param _FontAlignMargin: The margin for left/right align.
<li>If `FontAlign` is `Left`, this parameter specifies the left margin of the subtitles. </li>
<li>If `FontAlign` is `Right`, this parameter specifies the right margin of the subtitles. </li>
Two formats are supported:
u200c<li>If the value ends with %, it specifies the margin as a percentage of the canvas width. For example, `10%` means that the margin is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the margin in pixels. For example, `100px` means that the margin is 100 pixels. </li>
        :type FontAlignMargin: str
        :param _BorderWidth: The subtitle border width. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas height. For example, `10%` means that the width is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the width is 100 pixels. </li>
The default value is `0`, which means the subtitles will have no borders.
        :type BorderWidth: str
        :param _BorderColor: The border color, whose format is the same as that for `FontColor`. This parameter is valid if `BorderWidth` is not `0`.
        :type BorderColor: str
        :param _BottomColor: The text background color, whose format is the same as that for `FontColor`.  
The default value is an empty string, which means the subtitles will not have a background color.
        :type BottomColor: str
        """
        self._Height = None
        self._MarginBottom = None
        self._FontType = None
        self._FontSize = None
        self._FontBold = None
        self._FontItalic = None
        self._FontColor = None
        self._FontAlign = None
        self._FontAlignMargin = None
        self._BorderWidth = None
        self._BorderColor = None
        self._BottomColor = None

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def MarginBottom(self):
        return self._MarginBottom

    @MarginBottom.setter
    def MarginBottom(self, MarginBottom):
        self._MarginBottom = MarginBottom

    @property
    def FontType(self):
        return self._FontType

    @FontType.setter
    def FontType(self, FontType):
        self._FontType = FontType

    @property
    def FontSize(self):
        return self._FontSize

    @FontSize.setter
    def FontSize(self, FontSize):
        self._FontSize = FontSize

    @property
    def FontBold(self):
        return self._FontBold

    @FontBold.setter
    def FontBold(self, FontBold):
        self._FontBold = FontBold

    @property
    def FontItalic(self):
        return self._FontItalic

    @FontItalic.setter
    def FontItalic(self, FontItalic):
        self._FontItalic = FontItalic

    @property
    def FontColor(self):
        return self._FontColor

    @FontColor.setter
    def FontColor(self, FontColor):
        self._FontColor = FontColor

    @property
    def FontAlign(self):
        return self._FontAlign

    @FontAlign.setter
    def FontAlign(self, FontAlign):
        self._FontAlign = FontAlign

    @property
    def FontAlignMargin(self):
        return self._FontAlignMargin

    @FontAlignMargin.setter
    def FontAlignMargin(self, FontAlignMargin):
        self._FontAlignMargin = FontAlignMargin

    @property
    def BorderWidth(self):
        return self._BorderWidth

    @BorderWidth.setter
    def BorderWidth(self, BorderWidth):
        self._BorderWidth = BorderWidth

    @property
    def BorderColor(self):
        return self._BorderColor

    @BorderColor.setter
    def BorderColor(self, BorderColor):
        self._BorderColor = BorderColor

    @property
    def BottomColor(self):
        return self._BottomColor

    @BottomColor.setter
    def BottomColor(self, BottomColor):
        self._BottomColor = BottomColor


    def _deserialize(self, params):
        self._Height = params.get("Height")
        self._MarginBottom = params.get("MarginBottom")
        self._FontType = params.get("FontType")
        self._FontSize = params.get("FontSize")
        self._FontBold = params.get("FontBold")
        self._FontItalic = params.get("FontItalic")
        self._FontColor = params.get("FontColor")
        self._FontAlign = params.get("FontAlign")
        self._FontAlignMargin = params.get("FontAlignMargin")
        self._BorderWidth = params.get("BorderWidth")
        self._BorderColor = params.get("BorderColor")
        self._BottomColor = params.get("BottomColor")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTargetInfo(AbstractModel):
    """The output video information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Container: The container. Valid values:
<li>`mp4` (default), for video files. </li>
<li>`mp3`, for audio files. </li>
        :type Container: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>`0` (default): No. </li>
<li>`1`: Yes. </li>
        :type RemoveAudio: int
        :param _VideoStream: The information of the output video stream.
        :type VideoStream: :class:`tencentcloud.mps.v20190612.models.ComposeVideoStream`
        :param _AudioStream: The information of the output audio stream.
        :type AudioStream: :class:`tencentcloud.mps.v20190612.models.ComposeAudioStream`
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoStream = None
        self._AudioStream = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoStream(self):
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoStream") is not None:
            self._VideoStream = ComposeVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = ComposeAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTrackTime(AbstractModel):
    """The time information of an element on the output video track of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Start: The time when the element starts on the track.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` indicates the time when 3.5 seconds of the video elapses.</li>
Note: If this parameter is not specified, the start time will be the end time of the previous element. Therefore, you can also use the placeholder parameter `ComposeEmptyItem` to configure the start time.
        :type Start: str
        :param _Duration: The element duration.
<li>The value of this parameter ends with `s`, which means seconds. For example, `3.5s` means 3.5 seconds.</li>
The default value is the material duration, which is determined by `EndTime` and `StartTime` of `ComposeSourceMedia`. If `ComposeSourceMedia` is not specified, the duration will be 1 second.
        :type Duration: str
        """
        self._Start = None
        self._Duration = None

    @property
    def Start(self):
        return self._Start

    @Start.setter
    def Start(self, Start):
        self._Start = Start

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Start = params.get("Start")
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionItem(AbstractModel):
    """The transition element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Duration: The element duration. <li>The value of this parameter ends with `s`, which means seconds. For example, `3s` indicates 3 seconds. </li>
Default value: `1s`.
Note
<li>The number before `s` must be an integer. Non-integers will be rounded down to the nearest integer. </li>
<li>The transition element must be between two non-empty elements. </li>
<li>The duration of the transition element must be shorter than that of the preceding element and the following element. </li>
u200c<li>The start time of the following element on the track will be automatically changed to the end time of the preceding element minus the duration of the transition element. </li>
        :type Duration: str
        :param _Transitions: The transition effects.
The default transition effect is fade.
Note: You can add at most one image transition and one audio transition.
        :type Transitions: list of ComposeTransitionOperation
        """
        self._Duration = None
        self._Transitions = None

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Transitions(self):
        return self._Transitions

    @Transitions.setter
    def Transitions(self, Transitions):
        self._Transitions = Transitions


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        if params.get("Transitions") is not None:
            self._Transitions = []
            for item in params.get("Transitions"):
                obj = ComposeTransitionOperation()
                obj._deserialize(item)
                self._Transitions.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeTransitionOperation(AbstractModel):
    """The transition information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _Type: The transition type.

The image transition, which connects two video segments.
<li>`ImageFadeInFadeOut` </li>
u200c<li>`BowTieHorizontal` </li>
u200c<li>`BowTieVertical` </li>
u200c<li>`ButterflyWaveScrawler` </li>
<li>`Cannabisleaf` </li>
<li>`Circle` </li>
<li>`CircleCrop` </li>
u200c<li>`Circleopen` </li>
<li>`Crosswarp` </li>
<li>`Cube` </li>
<li>`DoomScreenTransition` </li>
<li>`Doorway` </li>
<li>`Dreamy` </li>
<li>`DreamyZoom` </li>
<li>`FilmBurn` </li>
<li>`GlitchMemories` </li>
<li>`Heart` </li>
<li>`InvertedPageCurl` </li>
<li>`Luma` </li>
<li>`Mosaic` </li>
<li>`Pinwheel` </li>
<li>`PolarFunction` </li>
<li>`PolkaDotsCurtain` </li>
<li>`Radial` </li>
<li>`RotateScaleFade` </li>
<li>`Squeeze` </li>
<li>`Swap` </li>
<li>`Swirl` </li>
<li>`UndulatingBurnOutSwirl` </li>
<li>`Windowblinds` </li>
<li>`WipeDown` </li>
<li>`WipeLeft` </li>
<li>`WipeRight` </li>
<li>`WipeUp` </li>
<li>`ZoomInCircles` </li> 
The audio transition, which connects two audio segments.
<li>`AudioFadeInFadeOut` </li>
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoItem(AbstractModel):
    """The video element information of a video editing/compositing task.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: The media information of the element.
        :type SourceMedia: :class:`tencentcloud.mps.v20190612.models.ComposeSourceMedia`
        :param _TrackTime: The time of the element in the timeline. If this is not specified, the element will follow the previous element.
        :type TrackTime: :class:`tencentcloud.mps.v20190612.models.ComposeTrackTime`
        :param _XPos: The horizontal distance of the element's center from the canvas origin. Two formats are supported:
<li>If the value ends with %, it specifies the distance as a percentage of the canvas width. For example, `10%` means that the distance is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type XPos: str
        :param _YPos: The vertical distance of the element's center from the canvas origin. Two formats are supported:
u200c<li>If the value ends with %, it specifies the distance as a percentage of the canvas height. For example, `10%` means that the distance is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the distance in pixels. For example, `100px` means that the distance is 100 pixels. </li>
Default value: `50%`.
        :type YPos: str
        :param _Width: The width of the video segment. Two formats are supported:
u200c<li>If the value ends with %, it specifies the width as a percentage of the canvas width. For example, `10%` means that the video width is 10% of the canvas width. </li>
u200c<li>If the value ends with px, it specifies the width in pixels. For example, `100px` means that the video width is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Width: str
        :param _Height: The height of the element. Two formats are supported:
u200c<li>If the value ends with %, it specifies the height as a percentage of the canvas height. For example, `10%` means that the height is 10% of the canvas height. </li>
u200c<li>If the value ends with px, it specifies the height in pixels. For example, `100px` means that the height is 100 pixels. </li>
If one or both parameters are empty or set to `0`:
<li>If both `Width` and `Height` are empty, the original width and height of the element will be kept. </li>
<li>If `Width` is empty and `Height` is not, the width will be auto scaled. </li>
<li>If `Width` is not empty and `Height` is, the height will be auto scaled. </li>
        :type Height: str
        :param _ImageOperations: The image operations, such as image rotation.
        :type ImageOperations: list of ComposeImageOperation
        :param _AudioOperations: The audio operations, such as muting.
        :type AudioOperations: list of ComposeAudioOperation
        """
        self._SourceMedia = None
        self._TrackTime = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._ImageOperations = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def TrackTime(self):
        return self._TrackTime

    @TrackTime.setter
    def TrackTime(self, TrackTime):
        self._TrackTime = TrackTime

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ImageOperations(self):
        return self._ImageOperations

    @ImageOperations.setter
    def ImageOperations(self, ImageOperations):
        self._ImageOperations = ImageOperations

    @property
    def AudioOperations(self):
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        if params.get("SourceMedia") is not None:
            self._SourceMedia = ComposeSourceMedia()
            self._SourceMedia._deserialize(params.get("SourceMedia"))
        if params.get("TrackTime") is not None:
            self._TrackTime = ComposeTrackTime()
            self._TrackTime._deserialize(params.get("TrackTime"))
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        if params.get("ImageOperations") is not None:
            self._ImageOperations = []
            for item in params.get("ImageOperations"):
                obj = ComposeImageOperation()
                obj._deserialize(item)
                self._ImageOperations.append(obj)
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = ComposeAudioOperation()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeVideoStream(AbstractModel):
    """The video stream information of a video edit/compositing task.

    """

    def __init__(self):
        r"""
        :param _Codec: The codec. Valid values:
<li>`H.264` (default) </li>
        :type Codec: str
        :param _Fps: The video frame rate (Hz). Value range: 0–60.  
The default value is `0`, which means that the frame rate will be the same as that of the first video.
        :type Fps: int
        """
        self._Codec = None
        self._Fps = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    """Details of a content audit template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a content audit template.
        :type Definition: int
        :param _Name: Name of a content audit template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of a content audit template. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Porn information detection control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: The parameters for detecting sensitive information.
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Custom content audit control parameter.
Note: This field may return null, indicating that no valid values can be obtained.
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _Type: The template type. Valid values:
* Preset
* Custom
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._CreateTime = None
        self._UpdateTime = None
        self._Type = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosFileUploadTrigger(AbstractModel):
    """Input rule bound to COS.

    """

    def __init__(self):
        r"""
        :param _Bucket: Name of the COS bucket bound to a workflow, such as `TopRankVideo-125xxx88`.
        :type Bucket: str
        :param _Region: Region of the COS bucket bound to a workflow, such as `ap-chongiqng`.
        :type Region: str
        :param _Dir: Input path directory bound to a workflow, such as `/movie/201907/`. If this parameter is left empty, the `/` root directory will be used.
        :type Dir: str
        :param _Formats: Format list of files that can trigger a workflow, such as ["mp4", "flv", "mov"]. If this parameter is left empty, files in all formats can trigger the workflow.
        :type Formats: list of str
        """
        self._Bucket = None
        self._Region = None
        self._Dir = None
        self._Formats = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Dir(self):
        return self._Dir

    @Dir.setter
    def Dir(self, Dir):
        self._Dir = Dir

    @property
    def Formats(self):
        return self._Formats

    @Formats.setter
    def Formats(self, Formats):
        self._Formats = Formats


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Dir = params.get("Dir")
        self._Formats = params.get("Formats")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosInputInfo(AbstractModel):
    """The information of the COS object to process.

    """

    def __init__(self):
        r"""
        :param _Bucket: The COS bucket of the object to process, such as `TopRankVideo-125xxx88`.
        :type Bucket: str
        :param _Region: The region of the COS bucket, such as `ap-chongqing`.
        :type Region: str
        :param _Object: The path of the object to process, such as `/movie/201907/WildAnimal.mov`.
        :type Object: str
        """
        self._Bucket = None
        self._Region = None
        self._Object = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Object(self):
        return self._Object

    @Object.setter
    def Object(self, Object):
        self._Object = Object


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        self._Object = params.get("Object")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CosOutputStorage(AbstractModel):
    """The information of the output COS object after media processing.

    """

    def __init__(self):
        r"""
        :param _Bucket: The bucket to which the output file of media processing is saved, such as `TopRankVideo-125xxx88`. If this parameter is left empty, the value of the upper layer will be inherited.
        :type Bucket: str
        :param _Region: The region of the output bucket, such as `ap-chongqing`. If this parameter is left empty, the value of the upper layer will be inherited.
        :type Region: str
        """
        self._Bucket = None
        self._Region = None

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region


    def _deserialize(self, params):
        self._Bucket = params.get("Bucket")
        self._Region = params.get("Region")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    """Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    """CreateAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Video content analysis template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Video content analysis template description. Length limit: 256 characters.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    """CreateAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    """CreateAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a video content recognition template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of a video content recognition template. Length limit: 256 characters.
        :type Comment: str
        :param _FaceConfigure: Face recognition control parameter.
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    """CreateAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Format: Adaptive bitrate streaming format. Valid values:
<li>HLS,</li>
<li>MPEG-DASH.</li>
        :type Format: str
        :param _StreamInfos: Parameter information of output substreams for transcoding to adaptive bitrate streaming. Up to 10 substreams can be output.
Note: the frame rate of each substream must be consistent; otherwise, the frame rate of the first substream is used as the output frame rate.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Name: Template name. Length limit: 64 characters.
        :type Name: str
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: 0.
        :type DisableHigherVideoResolution: int
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Format = None
        self._StreamInfos = None
        self._Name = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Name = params.get("Name")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    """CreateAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Fps: Video frame rate in Hz. Value range: [1, 30].
        :type Fps: int
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a video stream in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format. Valid values: gif; webp. Default value: gif.
        :type Format: str
        :param _Quality: Image quality. Value range: [1, 100]. Default value: 75.
        :type Quality: float
        :param _Name: Name of an animated image generating template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Fps = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    """CreateAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    """CreateContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: The name of the content moderation template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: The template description. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Control parameter for porn information
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfo`
        :param _TerrorismConfigure: Control parameter for terrorism information
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: Control parameter for politically sensitive information
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this parameter is not supported yet.
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Custom content moderation parameters.
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfo`
        """
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    """CreateContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the content moderation template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTemplateRequest(AbstractModel):
    """CreateImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampling type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _RowCount: Subimage row count of an image sprite.
        :type RowCount: int
        :param _ColumnCount: Subimage column count of an image sprite.
        :type ColumnCount: int
        :param _Name: Name of an image sprite generating template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Subimage width of an image sprite in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Subimage height of an image sprite in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :type FillType: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    """CreateImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreatePersonSampleRequest(AbstractModel):
    """CreatePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of an image. Length limit: 20 characters
        :type Name: str
        :param _Usages: Image usage. Valid values:
1. Recognition: used for content recognition; equivalent to `Recognition.Face`
2. Review: used for inappropriate information recognition; equivalent to `Review.Face`
3. All: equivalent to 1+2
        :type Usages: list of str
        :param _Description: Image description. Length limit: 1,024 characters
        :type Description: str
        :param _FaceContents: [Base64](https://tools.ietf.org/html/rfc4648) string converted from an image. Only JPEG and PNG images are supported. Array length limit: 5 images
Note: the image must be a relatively clear facial feature photo of one person with a size of at least 200 x 200 pixels.
        :type FaceContents: list of str
        :param _Tags: Image tag
<li>Array length limit: 20 tags</li>
<li>Tag length limit: 128 characters</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    """CreatePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _Person: Image information
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: Information of images that failed the verification by facial feature positioning
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    """CreateSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampled screencapturing type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _Name: Name of a sampled screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    """CreateSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateScheduleRequest(AbstractModel):
    """CreateSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleName: The scheme name (max 128 characters). This name should be unique across your account.
        :type ScheduleName: str
        :param _Trigger: The trigger of the scheme. If a file is uploaded to the specified bucket, the scheme will be triggered.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: The subtasks of the scheme.
        :type Activities: list of Activity
        :param _OutputStorage: The bucket to save the output file. If you do not specify this parameter, the bucket in `Trigger` will be used.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :type OutputDir: str
        :param _TaskNotifyConfig: The notification configuration. If you do not specify this parameter, notifications will not be sent.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None

    @property
    def ScheduleName(self):
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig


    def _deserialize(self, params):
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateScheduleResponse(AbstractModel):
    """CreateSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ScheduleId = None
        self._RequestId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a time point screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values: jpg (default), png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    """CreateTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Container: Container format. Valid values: mp4; flv; hls; mp3; flac; ogg; m4a. Among them, mp3, flac, ogg, and m4a are for audio files.
        :type Container: str
        :param _Name: Name of a transcoding template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
Default value: 0.
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter. This field is required when `RemoveVideo` is 0.
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _AudioTemplate: Audio stream configuration parameter. This field is required when `RemoveAudio` is 0.
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _TEHDConfig: TESHD transcoding parameter. To enable it, please contact your Tencent Cloud sales rep.
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        :param _EnhanceConfig: Audio/Video enhancement configuration.
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    """CreateTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    """CreateWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Watermarking type. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark;</li>
<li>svg: SVG watermark.</li>
        :type Type: str
        :param _Name: Watermarking template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _CoordinateOrigin: Origin position. Valid values:
<li>TopLeft: The origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text;</li>
<li>TopRight: The origin of coordinates is in the top-right corner of the video, and the origin of the watermark is in the top-right corner of the image or text;</li>
<li>BottomLeft: The origin of coordinates is in the bottom-left corner of the video, and the origin of the watermark is in the bottom-left corner of the image or text;</li>
<li>BottomRight: The origin of coordinates is in the bottom-right corner of the video, and the origin of the watermark is in the bottom-right corner of the image or text.</li>
Default value: TopLeft.
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :type XPos: str
        :param _YPos: The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :type YPos: str
        :param _ImageTemplate: Image watermarking template. This field is required and valid only when `Type` is `image`.
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInput`
        :param _TextTemplate: Text watermarking template. This field is required and valid only when `Type` is `text`.
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG watermarking template. This field is required and valid only when `Type` is `svg`.
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInput`
        """
        self._Type = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    """CreateWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a watermarking template.
        :type Definition: int
        :param _ImageUrl: Watermark image address. This field is valid only when `Type` is `image`.
        :type ImageUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    """CreateWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
7. All: ASR- and OCR-based content recognition and inappropriate information detection; equivalent to 1+2+3+4
        :type Usages: list of str
        :param _Words: Keyword. Array length limit: 100.
        :type Words: list of AiSampleWordInfo
        """
        self._Usages = None
        self._Words = None

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    """CreateWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWorkflowRequest(AbstractModel):
    """CreateWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowName: Workflow name of up to 128 characters, which must be unique for the same user.
        :type WorkflowName: str
        :param _Trigger: Triggering rule bound to a workflow. If an uploaded video hits the rule for the object, the workflow will be triggered.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _OutputStorage: The location to save the output file of media processing. If this parameter is left empty, the storage location in `Trigger` will be inherited.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this, the file will be saved to the trigger directory.
        :type OutputDir: str
        :param _MediaProcessTask: The media processing parameters to use.
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: Type parameter of a video content audit task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: Video content analysis task parameter.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: Type parameter of a video content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _TaskNotifyConfig: Event notification configuration for a task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TaskPriority: Workflow priority. The higher the value, the higher the priority. Value range: [-10, 10]. If this parameter is left empty, 0 will be used.
        :type TaskPriority: int
        """
        self._WorkflowName = None
        self._Trigger = None
        self._OutputStorage = None
        self._OutputDir = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._TaskNotifyConfig = None
        self._TaskPriority = None

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def MediaProcessTask(self):
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TaskPriority(self):
        return self._TaskPriority

    @TaskPriority.setter
    def TaskPriority(self, TaskPriority):
        self._TaskPriority = TaskPriority


    def _deserialize(self, params):
        self._WorkflowName = params.get("WorkflowName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TaskPriority = params.get("TaskPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWorkflowResponse(AbstractModel):
    """CreateWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WorkflowId = None
        self._RequestId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._RequestId = params.get("RequestId")


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    """DeleteAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    """DeleteAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    """DeleteAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    """DeleteAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    """DeleteAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    """DeleteAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    """DeleteContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the content moderation template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    """DeleteContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    """DeleteImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    """DeleteImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    """DeletePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _PersonId: Image ID
        :type PersonId: str
        """
        self._PersonId = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    """DeletePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    """DeleteSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    """DeleteSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteScheduleRequest(AbstractModel):
    """DeleteSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteScheduleResponse(AbstractModel):
    """DeleteSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    """DeleteTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    """DeleteTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    """DeleteWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a watermarking template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    """DeleteWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    """DeleteWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Keywords: Keyword. Array length limit: 100 words.
        :type Keywords: list of str
        """
        self._Keywords = None

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    """DeleteWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWorkflowRequest(AbstractModel):
    """DeleteWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWorkflowResponse(AbstractModel):
    """DeleteWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    """DescribeAIAnalysisTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of video content analysis templates. Array length limit: 10.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    """DescribeAIAnalysisTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: List of video content analysis template details.
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    """DescribeAIRecognitionTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of video content recognition templates. Array length limit: 10.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 50.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    """DescribeAIRecognitionTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: List of video content recognition template details.
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of adaptive bitrate streaming templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: List of adaptive bitrate streaming template details.
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    """DescribeAnimatedGraphicsTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of animated image generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    """DescribeAnimatedGraphicsTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: List of animated image generating template details.
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    """DescribeContentReviewTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: The IDs of the content moderation templates to query. Array length limit: 50.
        :type Definitions: list of int
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 50.
        :type Limit: int
        :param _Type: The filter for querying templates. If this parameter is left empty, both preset and custom templates are returned. Valid values:
* Preset
* Custom
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    """DescribeContentReviewTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ContentReviewTemplateSet: List of content audit template details.
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    """DescribeImageSpriteTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of image sprite generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    """DescribeImageSpriteTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: List of image sprite generating template details.
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaMetaDataRequest(AbstractModel):
    """DescribeMediaMetaData request structure.

    """

    def __init__(self):
        r"""
        :param _InputInfo: Input information of file for metadata getting.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        """
        self._InputInfo = None

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaMetaDataResponse(AbstractModel):
    """DescribeMediaMetaData response structure.

    """

    def __init__(self):
        r"""
        :param _MetaData: Media metadata.
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MetaData = None
        self._RequestId = None

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._RequestId = params.get("RequestId")


class DescribePersonSamplesRequest(AbstractModel):
    """DescribePersonSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Type of images to pull. Valid values:
<li>UserDefine: custom image library</li>
<li>Default: default image library</li>

Default value: UserDefine. Samples in the custom image library will be pulled.
Note: you can pull the default image library only using the image name or a combination of the image name and ID, and only one face image is returned.
        :type Type: str
        :param _PersonIds: Image ID. Array length limit: 100
        :type PersonIds: list of str
        :param _Names: Image name. Array length limit: 20
        :type Names: list of str
        :param _Tags: Image tag. Array length limit: 20
        :type Tags: list of str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    """DescribePersonSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _PersonSet: Image information
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    """DescribeSampleSnapshotTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of sampled screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    """DescribeSampleSnapshotTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: List of sampled screencapturing template details.
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSchedulesRequest(AbstractModel):
    """DescribeSchedules request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleIds: The IDs of the schemes to query. Array length limit: 100.
        :type ScheduleIds: list of int
        :param _TriggerType: The trigger type. Valid values:
<li>`CosFileUpload`: The scheme is triggered when a file is uploaded to Tencent Cloud Object Storage (COS).</li>
<li>`AwsS3FileUpload`: The scheme is triggered when a file is uploaded to AWS S3.</li>
If you do not specify this parameter or leave it empty, all schemes will be returned regardless of the trigger type.
        :type TriggerType: str
        :param _Status: The scheme status. Valid values:
<li>`Enabled`</li>
<li>`Disabled`</li>
If you do not specify this parameter, all schemes will be returned regardless of the status.
        :type Status: str
        :param _Offset: The pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: The maximum number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._ScheduleIds = None
        self._TriggerType = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def ScheduleIds(self):
        return self._ScheduleIds

    @ScheduleIds.setter
    def ScheduleIds(self, ScheduleIds):
        self._ScheduleIds = ScheduleIds

    @property
    def TriggerType(self):
        return self._TriggerType

    @TriggerType.setter
    def TriggerType(self, TriggerType):
        self._TriggerType = TriggerType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._ScheduleIds = params.get("ScheduleIds")
        self._TriggerType = params.get("TriggerType")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSchedulesResponse(AbstractModel):
    """DescribeSchedules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _ScheduleInfoSet: The information of the schemes.
        :type ScheduleInfoSet: list of SchedulesInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScheduleInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScheduleInfoSet(self):
        return self._ScheduleInfoSet

    @ScheduleInfoSet.setter
    def ScheduleInfoSet(self, ScheduleInfoSet):
        self._ScheduleInfoSet = ScheduleInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScheduleInfoSet") is not None:
            self._ScheduleInfoSet = []
            for item in params.get("ScheduleInfoSet"):
                obj = SchedulesInfo()
                obj._deserialize(item)
                self._ScheduleInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of time point screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        """
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: List of time point screencapturing template details.
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: The task type. Valid values:
<li>WorkflowTask</li>
<li>EditMediaTask</li>
<li>LiveStreamProcessTask</li>
<li>ScheduleTask (scheme)</li>
        :type TaskType: str
        :param _Status: Task status. Valid values:
<li>WAITING: Waiting;</li>
<li>PROCESSING: Processing;</li>
<li>FINISH: Completed.</li>
        :type Status: str
        :param _CreateTime: Creation time of a task in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _BeginProcessTime: Start time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type BeginProcessTime: str
        :param _FinishTime: End time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type FinishTime: str
        :param _EditMediaTask: Video editing task information. This field has a value only when `TaskType` is `EditMediaTask`.
        :type EditMediaTask: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        :param _WorkflowTask: Information of a video processing task. This field has a value only when `TaskType` is `WorkflowTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkflowTask: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        :param _LiveStreamProcessTask: Information of a live stream processing task. This field has a value only when `TaskType` is `LiveStreamProcessTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type LiveStreamProcessTask: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessTask`
        :param _TaskNotifyConfig: Event notification information of a task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Task flow priority. Value range: [-10, 10].
        :type TasksPriority: int
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _ExtInfo: Extended information field, used in specific scenarios.
        :type ExtInfo: str
        :param _ScheduleTask: The information of a scheme. This parameter is valid only if `TaskType` is `ScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScheduleTask: :class:`tencentcloud.mps.v20190612.models.ScheduleTask`
        :param _LiveScheduleTask: The information of a live scheme. This parameter is valid only if `TaskType` is `LiveScheduleTask`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type LiveScheduleTask: :class:`tencentcloud.mps.v20190612.models.LiveScheduleTask`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._EditMediaTask = None
        self._WorkflowTask = None
        self._LiveStreamProcessTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._ExtInfo = None
        self._ScheduleTask = None
        self._LiveScheduleTask = None
        self._RequestId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def EditMediaTask(self):
        return self._EditMediaTask

    @EditMediaTask.setter
    def EditMediaTask(self, EditMediaTask):
        self._EditMediaTask = EditMediaTask

    @property
    def WorkflowTask(self):
        return self._WorkflowTask

    @WorkflowTask.setter
    def WorkflowTask(self, WorkflowTask):
        self._WorkflowTask = WorkflowTask

    @property
    def LiveStreamProcessTask(self):
        return self._LiveStreamProcessTask

    @LiveStreamProcessTask.setter
    def LiveStreamProcessTask(self, LiveStreamProcessTask):
        self._LiveStreamProcessTask = LiveStreamProcessTask

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def ScheduleTask(self):
        return self._ScheduleTask

    @ScheduleTask.setter
    def ScheduleTask(self, ScheduleTask):
        self._ScheduleTask = ScheduleTask

    @property
    def LiveScheduleTask(self):
        return self._LiveScheduleTask

    @LiveScheduleTask.setter
    def LiveScheduleTask(self, LiveScheduleTask):
        self._LiveScheduleTask = LiveScheduleTask

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        if params.get("EditMediaTask") is not None:
            self._EditMediaTask = EditMediaTask()
            self._EditMediaTask._deserialize(params.get("EditMediaTask"))
        if params.get("WorkflowTask") is not None:
            self._WorkflowTask = WorkflowTask()
            self._WorkflowTask._deserialize(params.get("WorkflowTask"))
        if params.get("LiveStreamProcessTask") is not None:
            self._LiveStreamProcessTask = LiveStreamProcessTask()
            self._LiveStreamProcessTask._deserialize(params.get("LiveStreamProcessTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        if params.get("ScheduleTask") is not None:
            self._ScheduleTask = ScheduleTask()
            self._ScheduleTask._deserialize(params.get("ScheduleTask"))
        if params.get("LiveScheduleTask") is not None:
            self._LiveScheduleTask = LiveScheduleTask()
            self._LiveScheduleTask._deserialize(params.get("LiveScheduleTask"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    """DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _Status: Filter: Task status. Valid values: WAITING (waiting), PROCESSING (processing), FINISH (completed).
        :type Status: str
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _ScrollToken: Scrolling identifier which is used for pulling in batches. If a single request cannot pull all the data entries, the API will return `ScrollToken`, and if the next request carries it, the next pull will start from the next entry.
        :type ScrollToken: str
        """
        self._Status = None
        self._Limit = None
        self._ScrollToken = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Limit = params.get("Limit")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    """DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TaskSet: Task overview list.
        :type TaskSet: list of TaskSimpleInfo
        :param _ScrollToken: Scrolling identifier. If a request does not return all the data entries, this field indicates the ID of the next entry. If this field is an empty string, there is no more data.
        :type ScrollToken: str
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskSet = None
        self._ScrollToken = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def TaskSet(self):
        return self._TaskSet

    @TaskSet.setter
    def TaskSet(self, TaskSet):
        self._TaskSet = TaskSet

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskSet") is not None:
            self._TaskSet = []
            for item in params.get("TaskSet"):
                obj = TaskSimpleInfo()
                obj._deserialize(item)
                self._TaskSet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTemplatesRequest(AbstractModel):
    """DescribeTranscodeTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of transcoding templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Type: Template type filter. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _ContainerType: Container format filter. Valid values:
<li>Video: Video container format that can contain both video stream and audio stream;</li>
<li>PureAudio: Audio container format that can contain only audio stream.</li>
        :type ContainerType: str
        :param _TEHDType: TESHD filter, which is used to filter common transcoding or ultra-fast HD transcoding templates. Valid values:
<li>Common: Common transcoding template;</li>
<li>TEHD: TESHD template.</li>
        :type TEHDType: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _TranscodeType: The template type (replacing `TEHDType`). Valid values:
<li>Common: Common transcoding template</li>
<li>TEHD: TESHD template</li>
<li>Enhance: Audio/Video enhancement template.</li>
This parameter is left empty by default, which indicates to return all types of templates.
        :type TranscodeType: str
        """
        self._Definitions = None
        self._Type = None
        self._ContainerType = None
        self._TEHDType = None
        self._Offset = None
        self._Limit = None
        self._TranscodeType = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ContainerType(self):
        return self._ContainerType

    @ContainerType.setter
    def ContainerType(self, ContainerType):
        self._ContainerType = ContainerType

    @property
    def TEHDType(self):
        return self._TEHDType

    @TEHDType.setter
    def TEHDType(self, TEHDType):
        self._TEHDType = TEHDType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def TranscodeType(self):
        return self._TranscodeType

    @TranscodeType.setter
    def TranscodeType(self, TranscodeType):
        self._TranscodeType = TranscodeType


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._ContainerType = params.get("ContainerType")
        self._TEHDType = params.get("TEHDType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._TranscodeType = params.get("TranscodeType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTemplatesResponse(AbstractModel):
    """DescribeTranscodeTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _TranscodeTemplateSet: List of transcoding template details.
        :type TranscodeTemplateSet: list of TranscodeTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranscodeTemplateSet(self):
        return self._TranscodeTemplateSet

    @TranscodeTemplateSet.setter
    def TranscodeTemplateSet(self, TranscodeTemplateSet):
        self._TranscodeTemplateSet = TranscodeTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranscodeTemplateSet") is not None:
            self._TranscodeTemplateSet = []
            for item in params.get("TranscodeTemplateSet"):
                obj = TranscodeTemplate()
                obj._deserialize(item)
                self._TranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWatermarkTemplatesRequest(AbstractModel):
    """DescribeWatermarkTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: Unique ID filter of watermarking templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Type: Watermark type filter. Valid values:
<li>image: Image watermark;</li>
<li>text: Text watermark.</li>
        :type Type: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries
<li>Default value: 10;</li>
<li>Maximum value: 100.</li>
        :type Limit: int
        """
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWatermarkTemplatesResponse(AbstractModel):
    """DescribeWatermarkTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WatermarkTemplateSet: List of watermarking template details.
        :type WatermarkTemplateSet: list of WatermarkTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WatermarkTemplateSet(self):
        return self._WatermarkTemplateSet

    @WatermarkTemplateSet.setter
    def WatermarkTemplateSet(self, WatermarkTemplateSet):
        self._WatermarkTemplateSet = WatermarkTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WatermarkTemplateSet") is not None:
            self._WatermarkTemplateSet = []
            for item in params.get("WatermarkTemplateSet"):
                obj = WatermarkTemplate()
                obj._deserialize(item)
                self._WatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWordSamplesRequest(AbstractModel):
    """DescribeWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Keywords: Keyword filter. Array length limit: 100 words.
        :type Keywords: list of str
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
You can select multiple elements, which are connected by OR logic. If a usage contains any element in this parameter, the keyword sample will be used.
        :type Usages: list of str
        :param _Tags: Tag filter. Array length limit: 20 words.
        :type Tags: list of str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._Keywords = None
        self._Usages = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._Usages = params.get("Usages")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWordSamplesResponse(AbstractModel):
    """DescribeWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _WordSet: Keyword information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WordSet: list of AiSampleWord
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WordSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WordSet(self):
        return self._WordSet

    @WordSet.setter
    def WordSet(self, WordSet):
        self._WordSet = WordSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WordSet") is not None:
            self._WordSet = []
            for item in params.get("WordSet"):
                obj = AiSampleWord()
                obj._deserialize(item)
                self._WordSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWorkflowsRequest(AbstractModel):
    """DescribeWorkflows request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowIds: Workflow ID filter. Array length limit: 100.
        :type WorkflowIds: list of int
        :param _Status: Workflow status. Valid values:
<li>Enabled: Enabled,</li>
<li>Disabled: Disabled.</li>
If this parameter is left empty, the workflow status will not be distinguished.
        :type Status: str
        :param _Offset: Paging offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._WorkflowIds = None
        self._Status = None
        self._Offset = None
        self._Limit = None

    @property
    def WorkflowIds(self):
        return self._WorkflowIds

    @WorkflowIds.setter
    def WorkflowIds(self, WorkflowIds):
        self._WorkflowIds = WorkflowIds

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._WorkflowIds = params.get("WorkflowIds")
        self._Status = params.get("Status")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWorkflowsResponse(AbstractModel):
    """DescribeWorkflows response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WorkflowInfoSet: Workflow information array.
        :type WorkflowInfoSet: list of WorkflowInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WorkflowInfoSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WorkflowInfoSet(self):
        return self._WorkflowInfoSet

    @WorkflowInfoSet.setter
    def WorkflowInfoSet(self, WorkflowInfoSet):
        self._WorkflowInfoSet = WorkflowInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WorkflowInfoSet") is not None:
            self._WorkflowInfoSet = []
            for item in params.get("WorkflowInfoSet"):
                obj = WorkflowInfo()
                obj._deserialize(item)
                self._WorkflowInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DisableScheduleRequest(AbstractModel):
    """DisableSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableScheduleResponse(AbstractModel):
    """DisableSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DisableWorkflowRequest(AbstractModel):
    """DisableWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DisableWorkflowResponse(AbstractModel):
    """DisableWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DrmInfo(AbstractModel):
    """The DRM encryption details.

    """

    def __init__(self):
        r"""
        :param _Type: The encryption type.
<li>`simpleaes`: AES-128 encryption.</li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        :param _SimpleAesDrm: The AES-128 encryption details.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type SimpleAesDrm: :class:`tencentcloud.mps.v20190612.models.SimpleAesDrm`
        """
        self._Type = None
        self._SimpleAesDrm = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SimpleAesDrm(self):
        return self._SimpleAesDrm

    @SimpleAesDrm.setter
    def SimpleAesDrm(self, SimpleAesDrm):
        self._SimpleAesDrm = SimpleAesDrm


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("SimpleAesDrm") is not None:
            self._SimpleAesDrm = SimpleAesDrm()
            self._SimpleAesDrm._deserialize(params.get("SimpleAesDrm"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaFileInfo(AbstractModel):
    """VOD video file editing information

    """

    def __init__(self):
        r"""
        :param _InputInfo: Video input information.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _StartTimeOffset: The start offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end offset (seconds) for video clipping. This parameter is valid for video clipping tasks.
        :type EndTimeOffset: float
        :param _Id: The ID of the material associated with an element. This parameter is required for video compositing tasks.

Note: The ID can be up to 32 characters long and can contain letters, digits, and special characters -_
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Id: str
        """
        self._InputInfo = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Id = None

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaOutputConfig(AbstractModel):
    """Configuration for output files of video editing

    """

    def __init__(self):
        r"""
        :param _Container: The container. Valid values: `mp4` (default), `hls`, `mov`, `flv`, `avi`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Container: str
        :param _Type: The clip mode. Valid values: `normal` (default), `fast`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Container = None
        self._Type = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaRequest(AbstractModel):
    """EditMedia request structure.

    """

    def __init__(self):
        r"""
        :param _FileInfos: Information of input video file.
        :type FileInfos: list of EditMediaFileInfo
        :param _OutputStorage: The storage location of the media processing output file.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: The path to save the media processing output file.

Note: For complex compositing tasks, the filename can be up to 64 characters long and can only contain digits, letters, and special characters -_

        :type OutputObjectPath: str
        :param _OutputConfig: The output settings for a video clipping task.
        :type OutputConfig: :class:`tencentcloud.mps.v20190612.models.EditMediaOutputConfig`
        :param _ComposeConfig: The settings for a video compositing task.

Note: If this parameter is not empty, the task is a video compositing task. Otherwise, the task is a video clipping task.
        :type ComposeConfig: :class:`tencentcloud.mps.v20190612.models.ComposeMediaConfig`
        :param _TaskNotifyConfig: Event notification information of task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Task priority. The higher the value, the higher the priority. Value range: -10–10. If this parameter is left empty, 0 will be used.
        :type TasksPriority: int
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last three days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        """
        self._FileInfos = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._OutputConfig = None
        self._ComposeConfig = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def FileInfos(self):
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def OutputConfig(self):
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def ComposeConfig(self):
        return self._ComposeConfig

    @ComposeConfig.setter
    def ComposeConfig(self, ComposeConfig):
        self._ComposeConfig = ComposeConfig

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = EditMediaOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        if params.get("ComposeConfig") is not None:
            self._ComposeConfig = ComposeMediaConfig()
            self._ComposeConfig._deserialize(params.get("ComposeConfig"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaResponse(AbstractModel):
    """EditMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video editing task ID, which can be used to query the status of an editing task.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class EditMediaTask(AbstractModel):
    """Video editing task information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _Status: Task status. Valid values:
<li>PROCESSING: processing;</li>
<li>FINISH: completed.</li>
        :type Status: str
        :param _ErrCode: Error code
<li>0: success;</li>
<li>Other values: failure.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of video editing task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.EditMediaTaskInput`
        :param _Output: Output of video editing task.
        :type Output: :class:`tencentcloud.mps.v20190612.models.EditMediaTaskOutput`
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = EditMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = EditMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskInput(AbstractModel):
    """Input of video editing task.

    """

    def __init__(self):
        r"""
        :param _FileInfoSet: Information of input video file.
        :type FileInfoSet: list of EditMediaFileInfo
        """
        self._FileInfoSet = None

    @property
    def FileInfoSet(self):
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet


    def _deserialize(self, params):
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskOutput(AbstractModel):
    """Output of video editing task

    """

    def __init__(self):
        r"""
        :param _OutputStorage: Target storage of edited file.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: Path of edited video file.
        :type Path: str
        """
        self._OutputStorage = None
        self._Path = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Path = params.get("Path")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableScheduleRequest(AbstractModel):
    """EnableSchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        """
        self._ScheduleId = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableScheduleResponse(AbstractModel):
    """EnableSchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnableWorkflowRequest(AbstractModel):
    """EnableWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        """
        self._WorkflowId = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnableWorkflowResponse(AbstractModel):
    """EnableWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class EnhanceConfig(AbstractModel):
    """Audio/Video enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _VideoEnhance: Video enhancement configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VideoEnhance: :class:`tencentcloud.mps.v20190612.models.VideoEnhanceConfig`
        :param _AudioEnhance: The audio enhancement configuration.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type AudioEnhance: :class:`tencentcloud.mps.v20190612.models.AudioEnhanceConfig`
        """
        self._VideoEnhance = None
        self._AudioEnhance = None

    @property
    def VideoEnhance(self):
        return self._VideoEnhance

    @VideoEnhance.setter
    def VideoEnhance(self, VideoEnhance):
        self._VideoEnhance = VideoEnhance

    @property
    def AudioEnhance(self):
        return self._AudioEnhance

    @AudioEnhance.setter
    def AudioEnhance(self, AudioEnhance):
        self._AudioEnhance = AudioEnhance


    def _deserialize(self, params):
        if params.get("VideoEnhance") is not None:
            self._VideoEnhance = VideoEnhanceConfig()
            self._VideoEnhance._deserialize(params.get("VideoEnhance"))
        if params.get("AudioEnhance") is not None:
            self._AudioEnhance = AudioEnhanceConfig()
            self._AudioEnhance._deserialize(params.get("AudioEnhance"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionRequest(AbstractModel):
    """ExecuteFunction request structure.

    """

    def __init__(self):
        r"""
        :param _FunctionName: Name of called backend API.
        :type FunctionName: str
        :param _FunctionArg: API parameter. Parameter format will depend on the actual function definition.
        :type FunctionArg: str
        """
        self._FunctionName = None
        self._FunctionArg = None

    @property
    def FunctionName(self):
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionArg(self):
        return self._FunctionArg

    @FunctionArg.setter
    def FunctionArg(self, FunctionArg):
        self._FunctionArg = FunctionArg


    def _deserialize(self, params):
        self._FunctionName = params.get("FunctionName")
        self._FunctionArg = params.get("FunctionArg")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionResponse(AbstractModel):
    """ExecuteFunction response structure.

    """

    def __init__(self):
        r"""
        :param _Result: Packed string, which will vary according to the custom API.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class FaceConfigureInfo(AbstractModel):
    """Control parameter of a face recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a face recognition task. Valid values:
<li>ON: Enables an intelligent face recognition task;</li>
<li>OFF: Disables an intelligent face recognition task.</li>
        :type Switch: str
        :param _Score: Face recognition filter score. If this score is reached or exceeded, a recognition result will be returned. Value range: 0-100. Default value: 95.
        :type Score: float
        :param _DefaultLibraryLabelSet: The default face filter labels, which specify the types of faces to return. If this parameter is left empty, the detection results for all labels are returned. Valid values:
<li>entertainment (people in the entertainment industry)</li>
<li>sport (sports celebrities)</li>
<li>politician</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: Custom face tags for filter, which specify the face recognition results to return. If this parameter is not specified or left empty, the recognition results for all custom face tags are returned.
Up to 100 tags are allowed, each containing no more than 16 characters.
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: Figure library. Valid values:
<li>Default: Default figure library;</li>
<li>UserDefine: Custom figure library.</li>
<li>All: Both default and custom figure libraries will be used.</li>
Default value: All (both default and custom figure libraries will be used.)
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceConfigureInfoForUpdate(AbstractModel):
    """Control parameter of a face recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a face recognition task. Valid values:
<li>ON: Enables an intelligent face recognition task;</li>
<li>OFF: Disables an intelligent face recognition task.</li>
        :type Switch: str
        :param _Score: Face recognition filter score. If this score is reached or exceeded, a recognition result will be returned. Value range: 0-100.
        :type Score: float
        :param _DefaultLibraryLabelSet: The default face filter labels, which specify the types of faces to return. If this parameter is left empty, the detection results for all labels are returned. Valid values:
<li>entertainment (people in the entertainment industry)</li>
<li>sport (sports celebrities)</li>
<li>politician</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: Custom face tags for filter, which specify the face recognition results to return. If this parameter is not specified or left empty, the recognition results for all custom face tags are returned.
Up to 100 tags are allowed, each containing no more than 16 characters.
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: Figure library. Valid values:
<li>Default: Default figure library;</li>
<li>UserDefine: Custom figure library.</li>
<li>All: Both default and custom figure libraries will be used.</li>
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceEnhanceConfig(AbstractModel):
    """Face enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Intensity: The strength. Value range: 0.0-1.0
Default value: 0.0.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Intensity: float
        """
        self._Switch = None
        self._Intensity = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Intensity(self):
        return self._Intensity

    @Intensity.setter
    def Intensity(self, Intensity):
        self._Intensity = Intensity


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Intensity = params.get("Intensity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameRateConfig(AbstractModel):
    """Frame interpolation configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Fps: The frame rate (Hz). Value range: [0, 100].
Default value: 0.
Note: For transcoding, this parameter will overwrite `Fps` of `VideoTemplate`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Fps: int
        """
        self._Switch = None
        self._Fps = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Fps = params.get("Fps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameTagConfigureInfo(AbstractModel):
    """Control parameter of intelligent frame-specific tagging task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent frame-specific tagging task. Valid values:
<li>ON: enables intelligent frame-specific tagging task;</li>
<li>OFF: disables intelligent frame-specific tagging task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FrameTagConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent frame-specific tagging task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent frame-specific tagging task. Valid values:
<li>ON: enables intelligent frame-specific tagging task;</li>
<li>OFF: disables intelligent frame-specific tagging task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HdrConfig(AbstractModel):
    """HDR configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>HDR10</li>
<li>HLG</li>
Default value: HDR10.
Note: The video codec must be `libx265`.
Note: The bit depth for video encoding is 10 bits.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HeadTailParameter(AbstractModel):
    """Opening and closing credits parameters

    """

    def __init__(self):
        r"""
        :param _HeadSet: The opening segments.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type HeadSet: list of MediaInputInfo
        :param _TailSet: The closing segments.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type TailSet: list of MediaInputInfo
        """
        self._HeadSet = None
        self._TailSet = None

    @property
    def HeadSet(self):
        return self._HeadSet

    @HeadSet.setter
    def HeadSet(self, HeadSet):
        self._HeadSet = HeadSet

    @property
    def TailSet(self):
        return self._TailSet

    @TailSet.setter
    def TailSet(self, TailSet):
        self._TailSet = TailSet


    def _deserialize(self, params):
        if params.get("HeadSet") is not None:
            self._HeadSet = []
            for item in params.get("HeadSet"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._HeadSet.append(obj)
        if params.get("TailSet") is not None:
            self._TailSet = []
            for item in params.get("TailSet"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._TailSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class HighlightSegmentItem(AbstractModel):
    """The information of a highlight segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score.
        :type Confidence: float
        :param _StartTimeOffset: The start time offset of the segment.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end time offset of the segment.
        :type EndTimeOffset: float
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageQualityEnhanceConfig(AbstractModel):
    """Overall enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>weak</li>
<li>normal</li>
<li>strong</li>
Default value: weak.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSpriteTaskInput(AbstractModel):
    """Input parameter type of an image sprite generating task

    """

    def __init__(self):
        r"""
        :param _Definition: ID of an image sprite generating template.
        :type Definition: int
        :param _OutputStorage: Target bucket of a generated image sprite. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path to a generated image sprite file, which can be a relative path or an absolute path. If this parameter is left empty, the following relative path will be used by default: `{inputName}_imageSprite_{definition}_{number}.{format}`.
        :type OutputObjectPath: str
        :param _WebVttObjectName: Output path to the WebVTT file after an image sprite is generated, which can only be a relative path. If this parameter is left empty, the following relative path will be used by default: `{inputName}_imageSprite_{definition}.{format}`.
        :type WebVttObjectName: str
        :param _ObjectNumberFormat: Rule of the `{number}` variable in the image sprite output path.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ObjectNumberFormat: :class:`tencentcloud.mps.v20190612.models.NumberFormat`
        """
        self._Definition = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._WebVttObjectName = None
        self._ObjectNumberFormat = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def WebVttObjectName(self):
        return self._WebVttObjectName

    @WebVttObjectName.setter
    def WebVttObjectName(self, WebVttObjectName):
        self._WebVttObjectName = WebVttObjectName

    @property
    def ObjectNumberFormat(self):
        return self._ObjectNumberFormat

    @ObjectNumberFormat.setter
    def ObjectNumberFormat(self, ObjectNumberFormat):
        self._ObjectNumberFormat = ObjectNumberFormat


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        self._WebVttObjectName = params.get("WebVttObjectName")
        if params.get("ObjectNumberFormat") is not None:
            self._ObjectNumberFormat = NumberFormat()
            self._ObjectNumberFormat._deserialize(params.get("ObjectNumberFormat"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageSpriteTemplate(AbstractModel):
    """Details of an image sprite generating template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Name of an image sprite generating template.
        :type Name: str
        :param _Width: Subimage width of an image sprite.
        :type Width: int
        :param _Height: Subimage height of an image sprite.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _SampleType: Sampling type.
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
        :type SampleInterval: int
        :param _RowCount: Subimage row count of an image sprite.
        :type RowCount: int
        :param _ColumnCount: Subimage column count of an image sprite.
        :type ColumnCount: int
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: Stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: Fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :type FillType: str
        :param _Comment: Template description.
        :type Comment: str
        :param _Format: The image format.
        :type Format: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._CreateTime = None
        self._UpdateTime = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkInput(AbstractModel):
    """Input parameter of an image watermarking template

    """

    def __init__(self):
        r"""
        :param _ImageContent: String generated by [Base64-encoding](https://tools.ietf.org/html/rfc4648) a watermark image. JPEG and PNG images are supported.
        :type ImageContent: str
        :param _Width: Watermark width. % and px formats are supported:
<li>If the string ends in %, the `Width` of the watermark will be the specified percentage of the video width. For example, `10%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in px, the `Width` of the watermark will be in pixels. For example, `100px` means that `Width` is 100 pixels. Value range: [8, 4096].</li>
Default value: 10%.
        :type Width: str
        :param _Height: Watermark height. % and px formats are supported:
<li>If the string ends in %, the `Height` of the watermark will be the specified percentage of the video height. For example, `10%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in px, the `Height` of the watermark will be in pixels. For example, `100px` means that `Height` is 100 pixels. Value range: 0 or [8, 4096].</li>
Default value: 0px, which means that `Height` will be proportionally scaled according to the aspect ratio of the original watermark image.
        :type Height: str
        :param _RepeatType: Repeat type of an animated watermark. Valid values:
<li>once: no longer appears after watermark playback ends.</li>
<li>repeat_last_frame: stays on the last frame after watermark playback ends.</li>
<li>repeat (default): repeats the playback until the video ends.</li>
        :type RepeatType: str
        """
        self._ImageContent = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageContent(self):
        return self._ImageContent

    @ImageContent.setter
    def ImageContent(self, ImageContent):
        self._ImageContent = ImageContent

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageContent = params.get("ImageContent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkInputForUpdate(AbstractModel):
    """Input parameter of an image watermarking template

    """

    def __init__(self):
        r"""
        :param _ImageContent: String generated by [Base64-encoding](https://tools.ietf.org/html/rfc4648) a watermark image. JPEG and PNG images are supported.
        :type ImageContent: str
        :param _Width: Watermark width. % and px formats are supported:
<li>If the string ends in %, the `Width` of the watermark will be the specified percentage of the video width. For example, `10%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in px, the `Width` of the watermark will be in pixels. For example, `100px` means that `Width` is 100 pixels. Value range: [8, 4096].</li>
        :type Width: str
        :param _Height: Watermark height. % and px formats are supported:
<li>If the string ends in %, the `Height` of the watermark will be the specified percentage of the video height. For example, `10%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in px, the `Height` of the watermark will be in pixels. For example, `100px` means that `Height` is 100 pixels. Value range: 0 or [8, 4096].</li>
Default value: 0px, which means that `Height` will be proportionally scaled according to the aspect ratio of the original watermark image.
        :type Height: str
        :param _RepeatType: Repeat type of an animated watermark. Valid values:
<li>once: no longer appears after watermark playback ends.</li>
<li>repeat_last_frame: stays on the last frame after watermark playback ends.</li>
<li>repeat (default): repeats the playback until the video ends.</li>
        :type RepeatType: str
        """
        self._ImageContent = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageContent(self):
        return self._ImageContent

    @ImageContent.setter
    def ImageContent(self, ImageContent):
        self._ImageContent = ImageContent

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageContent = params.get("ImageContent")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ImageWatermarkTemplate(AbstractModel):
    """Image watermarking template

    """

    def __init__(self):
        r"""
        :param _ImageUrl: Watermark image address.
        :type ImageUrl: str
        :param _Width: Watermark width. % and px formats are supported:
<li>If the string ends in %, the `Width` of the watermark will be the specified percentage of the video width; for example, `10%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in px, the `Width` of the watermark will be in px; for example, `100px` means that `Width` is 100 px.</li>
        :type Width: str
        :param _Height: Watermark height. % and px formats are supported:
<li>If the string ends in %, the `Height` of the watermark will be the specified percentage of the video height. For example, `10%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in px, the `Height` of the watermark will be in pixels. For example, `100px` means that `Height` is 100 pixels.</li>
`0px` means that `Height` will be proportionally scaled according to the video width.
        :type Height: str
        :param _RepeatType: Repeat type of an animated watermark. Valid values:
<li>once: no longer appears after watermark playback ends.</li>
<li>repeat_last_frame: stays on the last frame after watermark playback ends.</li>
<li>repeat (default): repeats the playback until the video ends.</li>
        :type RepeatType: str
        """
        self._ImageUrl = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveActivityResItem(AbstractModel):
    """The output of a live scheme subtask.

    """

    def __init__(self):
        r"""
        :param _LiveRecordTask: The output of a live recording task.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type LiveRecordTask: :class:`tencentcloud.mps.v20190612.models.LiveScheduleLiveRecordTaskResult`
        """
        self._LiveRecordTask = None

    @property
    def LiveRecordTask(self):
        return self._LiveRecordTask

    @LiveRecordTask.setter
    def LiveRecordTask(self, LiveRecordTask):
        self._LiveRecordTask = LiveRecordTask


    def _deserialize(self, params):
        if params.get("LiveRecordTask") is not None:
            self._LiveRecordTask = LiveScheduleLiveRecordTaskResult()
            self._LiveRecordTask._deserialize(params.get("LiveRecordTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveActivityResult(AbstractModel):
    """The output of a live scheme subtask.

    """

    def __init__(self):
        r"""
        :param _ActivityType: The task type.
<li>`LiveRecord`: Live recording. </li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type ActivityType: str
        :param _LiveActivityResItem: The task output.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type LiveActivityResItem: :class:`tencentcloud.mps.v20190612.models.LiveActivityResItem`
        """
        self._ActivityType = None
        self._LiveActivityResItem = None

    @property
    def ActivityType(self):
        return self._ActivityType

    @ActivityType.setter
    def ActivityType(self, ActivityType):
        self._ActivityType = ActivityType

    @property
    def LiveActivityResItem(self):
        return self._LiveActivityResItem

    @LiveActivityResItem.setter
    def LiveActivityResItem(self, LiveActivityResItem):
        self._LiveActivityResItem = LiveActivityResItem


    def _deserialize(self, params):
        self._ActivityType = params.get("ActivityType")
        if params.get("LiveActivityResItem") is not None:
            self._LiveActivityResItem = LiveActivityResItem()
            self._LiveActivityResItem._deserialize(params.get("LiveActivityResItem"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordFile(AbstractModel):
    """The information of a live recording file.

    """

    def __init__(self):
        r"""
        :param _Url: The URL of the recording file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Url: str
        :param _Size: The size of the recording file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Size: int
        :param _Duration: The duration of the recording file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Duration: int
        :param _StartTime: The recording start time in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: The recording end time in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type EndTime: str
        """
        self._Url = None
        self._Size = None
        self._Duration = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._Size = params.get("Size")
        self._Duration = params.get("Duration")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordResult(AbstractModel):
    """The live recording result.

    """

    def __init__(self):
        r"""
        :param _OutputStorage: The storage of the recording file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _FileList: The recording segments.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FileList: list of LiveRecordFile
        """
        self._OutputStorage = None
        self._FileList = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def FileList(self):
        return self._FileList

    @FileList.setter
    def FileList(self, FileList):
        self._FileList = FileList


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        if params.get("FileList") is not None:
            self._FileList = []
            for item in params.get("FileList"):
                obj = LiveRecordFile()
                obj._deserialize(item)
                self._FileList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveRecordTaskInput(AbstractModel):
    """The input parameters of a live recording task.

    """

    def __init__(self):
        r"""
        :param _Definition: The live recording template ID.
        :type Definition: int
        :param _OutputStorage: The storage of the recording file. If this parameter is left empty, the `OutputStorage` value of the parent folder will be inherited.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: The output path of the recording file.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type OutputObjectPath: str
        """
        self._Definition = None
        self._OutputStorage = None
        self._OutputObjectPath = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveScheduleLiveRecordTaskResult(AbstractModel):
    """The result of a live scheme's live recording task.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: `PROCESSING`, `SUCCESS`, `FAIL`.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value indicates the task has failed. For details, see [Error Codes](https://www.tencentcloud.com/document/product/1041/40249).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type ErrCodeExt: str
        :param _ErrCode: The error code. `0` indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: The error message.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: The input of a live recording task.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Input: :class:`tencentcloud.mps.v20190612.models.LiveRecordTaskInput`
        :param _Output: The output of a live recording task.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.LiveRecordResult`
        :param _BeginProcessTime: The time when the task was started, in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type BeginProcessTime: str
        :param _FinishTime: The time when the task was completed, in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = LiveRecordTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = LiveRecordResult()
            self._Output._deserialize(params.get("Output"))
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveScheduleTask(AbstractModel):
    """The information of a live scheme subtask.

    """

    def __init__(self):
        r"""
        :param _TaskId: The ID of a live scheme subtask.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type TaskId: str
        :param _Status: The task status. Valid values:
<li>`PROCESSING`</li>
<li>`FINISH` </li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Status: str
        :param _ErrCode: If the value returned is not `0`, there was a source error. If `0` is returned, refer to the error codes of the corresponding task type.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: If there was a source error, this parameter is the error message. For other errors, refer to the error messages of the corresponding task type.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Url: The URL of the live stream.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Url: str
        :param _LiveActivityResultSet: The task output.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type LiveActivityResultSet: list of LiveActivityResult
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Url = None
        self._LiveActivityResultSet = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def LiveActivityResultSet(self):
        return self._LiveActivityResultSet

    @LiveActivityResultSet.setter
    def LiveActivityResultSet(self, LiveActivityResultSet):
        self._LiveActivityResultSet = LiveActivityResultSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Url = params.get("Url")
        if params.get("LiveActivityResultSet") is not None:
            self._LiveActivityResultSet = []
            for item in params.get("LiveActivityResultSet"):
                obj = LiveActivityResult()
                obj._deserialize(item)
                self._LiveActivityResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiRecognitionResultInfo(AbstractModel):
    """Live stream AI recognition results

    """

    def __init__(self):
        r"""
        :param _ResultSet: Content recognition result list.
        :type ResultSet: list of LiveStreamAiRecognitionResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = LiveStreamAiRecognitionResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiRecognitionResultItem(AbstractModel):
    """AI-based live stream recognition result

    """

    def __init__(self):
        r"""
        :param _Type: The result type. Valid values:
<li>FaceRecognition: Face recognition</li>
<li>AsrWordsRecognition: Speech keyword recognition</li>
<li>OcrWordsRecognition: Text keyword recognition</li>
<li>AsrFullTextRecognition: Full speech recognition</li>
<li>OcrFullTextRecognition: Full text recognition</li>
<li>TransTextRecognition: Speech translation</li>
        :type Type: str
        :param _FaceRecognitionResultSet: Face recognition result, which is valid when `Type` is
`FaceRecognition`.
        :type FaceRecognitionResultSet: list of LiveStreamFaceRecognitionResult
        :param _AsrWordsRecognitionResultSet: Speech keyword recognition result, which is valid when `Type` is
`AsrWordsRecognition`.
        :type AsrWordsRecognitionResultSet: list of LiveStreamAsrWordsRecognitionResult
        :param _OcrWordsRecognitionResultSet: Text keyword recognition result, which is valid when `Type` is
`OcrWordsRecognition`.
        :type OcrWordsRecognitionResultSet: list of LiveStreamOcrWordsRecognitionResult
        :param _AsrFullTextRecognitionResultSet: Full speech recognition result, which is valid when `Type` is
`AsrFullTextRecognition`.
        :type AsrFullTextRecognitionResultSet: list of LiveStreamAsrFullTextRecognitionResult
        :param _OcrFullTextRecognitionResultSet: Full text recognition result, which is valid when `Type` is
`OcrFullTextRecognition`.
        :type OcrFullTextRecognitionResultSet: list of LiveStreamOcrFullTextRecognitionResult
        :param _TransTextRecognitionResultSet: The translation result. This parameter is valid only if `Type` is `TransTextRecognition`.
        :type TransTextRecognitionResultSet: list of LiveStreamTransTextRecognitionResult
        """
        self._Type = None
        self._FaceRecognitionResultSet = None
        self._AsrWordsRecognitionResultSet = None
        self._OcrWordsRecognitionResultSet = None
        self._AsrFullTextRecognitionResultSet = None
        self._OcrFullTextRecognitionResultSet = None
        self._TransTextRecognitionResultSet = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceRecognitionResultSet(self):
        return self._FaceRecognitionResultSet

    @FaceRecognitionResultSet.setter
    def FaceRecognitionResultSet(self, FaceRecognitionResultSet):
        self._FaceRecognitionResultSet = FaceRecognitionResultSet

    @property
    def AsrWordsRecognitionResultSet(self):
        return self._AsrWordsRecognitionResultSet

    @AsrWordsRecognitionResultSet.setter
    def AsrWordsRecognitionResultSet(self, AsrWordsRecognitionResultSet):
        self._AsrWordsRecognitionResultSet = AsrWordsRecognitionResultSet

    @property
    def OcrWordsRecognitionResultSet(self):
        return self._OcrWordsRecognitionResultSet

    @OcrWordsRecognitionResultSet.setter
    def OcrWordsRecognitionResultSet(self, OcrWordsRecognitionResultSet):
        self._OcrWordsRecognitionResultSet = OcrWordsRecognitionResultSet

    @property
    def AsrFullTextRecognitionResultSet(self):
        return self._AsrFullTextRecognitionResultSet

    @AsrFullTextRecognitionResultSet.setter
    def AsrFullTextRecognitionResultSet(self, AsrFullTextRecognitionResultSet):
        self._AsrFullTextRecognitionResultSet = AsrFullTextRecognitionResultSet

    @property
    def OcrFullTextRecognitionResultSet(self):
        return self._OcrFullTextRecognitionResultSet

    @OcrFullTextRecognitionResultSet.setter
    def OcrFullTextRecognitionResultSet(self, OcrFullTextRecognitionResultSet):
        self._OcrFullTextRecognitionResultSet = OcrFullTextRecognitionResultSet

    @property
    def TransTextRecognitionResultSet(self):
        return self._TransTextRecognitionResultSet

    @TransTextRecognitionResultSet.setter
    def TransTextRecognitionResultSet(self, TransTextRecognitionResultSet):
        self._TransTextRecognitionResultSet = TransTextRecognitionResultSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("FaceRecognitionResultSet") is not None:
            self._FaceRecognitionResultSet = []
            for item in params.get("FaceRecognitionResultSet"):
                obj = LiveStreamFaceRecognitionResult()
                obj._deserialize(item)
                self._FaceRecognitionResultSet.append(obj)
        if params.get("AsrWordsRecognitionResultSet") is not None:
            self._AsrWordsRecognitionResultSet = []
            for item in params.get("AsrWordsRecognitionResultSet"):
                obj = LiveStreamAsrWordsRecognitionResult()
                obj._deserialize(item)
                self._AsrWordsRecognitionResultSet.append(obj)
        if params.get("OcrWordsRecognitionResultSet") is not None:
            self._OcrWordsRecognitionResultSet = []
            for item in params.get("OcrWordsRecognitionResultSet"):
                obj = LiveStreamOcrWordsRecognitionResult()
                obj._deserialize(item)
                self._OcrWordsRecognitionResultSet.append(obj)
        if params.get("AsrFullTextRecognitionResultSet") is not None:
            self._AsrFullTextRecognitionResultSet = []
            for item in params.get("AsrFullTextRecognitionResultSet"):
                obj = LiveStreamAsrFullTextRecognitionResult()
                obj._deserialize(item)
                self._AsrFullTextRecognitionResultSet.append(obj)
        if params.get("OcrFullTextRecognitionResultSet") is not None:
            self._OcrFullTextRecognitionResultSet = []
            for item in params.get("OcrFullTextRecognitionResultSet"):
                obj = LiveStreamOcrFullTextRecognitionResult()
                obj._deserialize(item)
                self._OcrFullTextRecognitionResultSet.append(obj)
        if params.get("TransTextRecognitionResultSet") is not None:
            self._TransTextRecognitionResultSet = []
            for item in params.get("TransTextRecognitionResultSet"):
                obj = LiveStreamTransTextRecognitionResult()
                obj._deserialize(item)
                self._TransTextRecognitionResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImagePoliticalResult(AbstractModel):
    """The result of detecting sensitive information in live streaming videos.

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: Start PTS time of a suspected segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of a suspected segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: The confidence score for the detected sensitive segments.
        :type Confidence: float
        :param _Suggestion: Suggestion for porn information detection of a suspected segment. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive information. Valid values:
<li>politician</li>
<li>violation_photo (banned icons)</li>
        :type Label: str
        :param _Name: The name of a sensitive person or banned icon.
        :type Name: str
        :param _AreaCoordSet: The pixel coordinates of the detected sensitive people or banned icons. The format is [x1, y1, x2, y2], which indicates the coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _Url: URL of a suspected image (which will not be permanently stored
and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Name = None
        self._AreaCoordSet = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Name = params.get("Name")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImagePornResult(AbstractModel):
    """Result of porn information detection in image in AI-based live stream content audit

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: Start PTS time of a suspected segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of a suspected segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Score of a suspected porn segment.
        :type Confidence: float
        :param _Suggestion: Suggestion for porn information detection of a suspected segment. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: Tag of the detected porn information in video. Valid values:
<li>porn: Porn.</li>
<li>sexy: Sexiness.</li>
<li>vulgar: Vulgarity.</li>
<li>intimacy: Intimacy.</li>
        :type Label: str
        :param _Url: URL of a suspected image (which will not be permanently stored
and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewImageTerrorismResult(AbstractModel):
    """The result of detecting sensitive information in live streaming videos.

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: Start PTS time of a suspected segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of a suspected segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: The confidence score for the detected sensitive segments.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive segments. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: The labels for the detected sensitive content. Valid values:
<li>guns</li>
<li>crowd</li>
<li>police</li>
<li>bloody</li>
<li>banners (sensitive flags)</li>
<li>militant</li>
<li>explosion</li>
<li>terrorists</li>
        :type Label: str
        :param _Url: URL of a suspected image (which will not be permanently stored
and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewResultInfo(AbstractModel):
    """Result of AI-based live stream audit

    """

    def __init__(self):
        r"""
        :param _ResultSet: List of content audit results.
        :type ResultSet: list of LiveStreamAiReviewResultItem
        """
        self._ResultSet = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = LiveStreamAiReviewResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewResultItem(AbstractModel):
    """Result of AI-based live stream audit

    """

    def __init__(self):
        r"""
        :param _Type: The type of moderation result. Valid values:
<li>ImagePorn</li>
<li>ImageTerrorism</li>
<li>ImagePolitical</li>
<li>VoicePorn</li>
        :type Type: str
        :param _ImagePornResultSet: Result of porn information detection in image, which is valid when `Type` is `ImagePorn`.
        :type ImagePornResultSet: list of LiveStreamAiReviewImagePornResult
        :param _ImageTerrorismResultSet: The result of detecting sensitive information in images, which is valid if `Type` is `ImageTerrorism`.
        :type ImageTerrorismResultSet: list of LiveStreamAiReviewImageTerrorismResult
        :param _ImagePoliticalResultSet: The result of detecting sensitive information in images, which is valid if `Type` is `ImagePolitical`.
        :type ImagePoliticalResultSet: list of LiveStreamAiReviewImagePoliticalResult
        :param _VoicePornResultSet: The result for moderation of pornographic content in audio. This parameter is valid if `Type` is `VoicePorn`.
        :type VoicePornResultSet: list of LiveStreamAiReviewVoicePornResult
        """
        self._Type = None
        self._ImagePornResultSet = None
        self._ImageTerrorismResultSet = None
        self._ImagePoliticalResultSet = None
        self._VoicePornResultSet = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ImagePornResultSet(self):
        return self._ImagePornResultSet

    @ImagePornResultSet.setter
    def ImagePornResultSet(self, ImagePornResultSet):
        self._ImagePornResultSet = ImagePornResultSet

    @property
    def ImageTerrorismResultSet(self):
        return self._ImageTerrorismResultSet

    @ImageTerrorismResultSet.setter
    def ImageTerrorismResultSet(self, ImageTerrorismResultSet):
        self._ImageTerrorismResultSet = ImageTerrorismResultSet

    @property
    def ImagePoliticalResultSet(self):
        return self._ImagePoliticalResultSet

    @ImagePoliticalResultSet.setter
    def ImagePoliticalResultSet(self, ImagePoliticalResultSet):
        self._ImagePoliticalResultSet = ImagePoliticalResultSet

    @property
    def VoicePornResultSet(self):
        return self._VoicePornResultSet

    @VoicePornResultSet.setter
    def VoicePornResultSet(self, VoicePornResultSet):
        self._VoicePornResultSet = VoicePornResultSet


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ImagePornResultSet") is not None:
            self._ImagePornResultSet = []
            for item in params.get("ImagePornResultSet"):
                obj = LiveStreamAiReviewImagePornResult()
                obj._deserialize(item)
                self._ImagePornResultSet.append(obj)
        if params.get("ImageTerrorismResultSet") is not None:
            self._ImageTerrorismResultSet = []
            for item in params.get("ImageTerrorismResultSet"):
                obj = LiveStreamAiReviewImageTerrorismResult()
                obj._deserialize(item)
                self._ImageTerrorismResultSet.append(obj)
        if params.get("ImagePoliticalResultSet") is not None:
            self._ImagePoliticalResultSet = []
            for item in params.get("ImagePoliticalResultSet"):
                obj = LiveStreamAiReviewImagePoliticalResult()
                obj._deserialize(item)
                self._ImagePoliticalResultSet.append(obj)
        if params.get("VoicePornResultSet") is not None:
            self._VoicePornResultSet = []
            for item in params.get("VoicePornResultSet"):
                obj = LiveStreamAiReviewVoicePornResult()
                obj._deserialize(item)
                self._VoicePornResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAiReviewVoicePornResult(AbstractModel):
    """Result of porn information detection in speech in AI-based live stream content audit

    """

    def __init__(self):
        r"""
        :param _StartPtsTime: Start PTS time of a suspected segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of a suspected segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Score of a suspected porn segment.
        :type Confidence: float
        :param _Suggestion: Suggestion for porn information detection of a suspected segment. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: Tag of the detected porn information in video. Valid values:
<li>sexual_moan: Sexual moans.</li>
        :type Label: str
        """
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Suggestion = None
        self._Label = None

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label


    def _deserialize(self, params):
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAsrFullTextRecognitionResult(AbstractModel):
    """ASR-based full live stream recognition

    """

    def __init__(self):
        r"""
        :param _Text: Recognized text.
        :type Text: str
        :param _StartPtsTime: Start PTS time of recognized segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of recognized segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Confidence of recognized segment. Value range: 0–100.
        :type Confidence: float
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamAsrWordsRecognitionResult(AbstractModel):
    """AI-based ASR-based live streaming keyword recognition result

    """

    def __init__(self):
        r"""
        :param _Word: Speech keyword.
        :type Word: str
        :param _StartPtsTime: Start PTS time of recognized segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of recognized segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Confidence of recognized segment. Value range: 0–100.
        :type Confidence: float
        """
        self._Word = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Word = params.get("Word")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamFaceRecognitionResult(AbstractModel):
    """AI-based live streaming face recognition result

    """

    def __init__(self):
        r"""
        :param _Id: Unique ID of figure.
        :type Id: str
        :param _Name: Figure name.
        :type Name: str
        :param _Type: Figure library type, indicating to which figure library the recognized figure belongs:
<li>Default: default figure library</li><li>UserDefine: custom figure library</li>
        :type Type: str
        :param _StartPtsTime: Start PTS time of recognized segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of recognized segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Confidence of recognized segment. Value range: 0–100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._Id = None
        self._Name = None
        self._Type = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Name = params.get("Name")
        self._Type = params.get("Type")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamOcrFullTextRecognitionResult(AbstractModel):
    """OCR-based full live stream recognition

    """

    def __init__(self):
        r"""
        :param _Text: Speech text.
        :type Text: str
        :param _StartPtsTime: Start PTS time of recognized segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of recognized segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Confidence of recognized segment. Value range: 0–100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamOcrWordsRecognitionResult(AbstractModel):
    """AI-based OCR-based live streaming keyword recognition result

    """

    def __init__(self):
        r"""
        :param _Word: Text keyword.
        :type Word: str
        :param _StartPtsTime: Start PTS time of recognized segment in seconds.
        :type StartPtsTime: float
        :param _EndPtsTime: End PTS time of recognized segment in seconds.
        :type EndPtsTime: float
        :param _Confidence: Confidence of recognized segment. Value range: 0–100.
        :type Confidence: float
        :param _AreaCoords: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoords: list of int
        """
        self._Word = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._AreaCoords = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoords(self):
        return self._AreaCoords

    @AreaCoords.setter
    def AreaCoords(self, AreaCoords):
        self._AreaCoords = AreaCoords


    def _deserialize(self, params):
        self._Word = params.get("Word")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._AreaCoords = params.get("AreaCoords")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamProcessErrorInfo(AbstractModel):
    """Information of a live stream processing error

    """

    def __init__(self):
        r"""
        :param _ErrCode: Error code:
<li>0: No error;</li>
<li>If this parameter is not 0, an error has occurred. Please see the error message (`Message`).</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        """
        self._ErrCode = None
        self._Message = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamProcessTask(AbstractModel):
    """Information of a live stream processing task

    """

    def __init__(self):
        r"""
        :param _TaskId: The media processing task ID.
        :type TaskId: str
        :param _Status: Task flow status. Valid values:
<li>PROCESSING: Processing;</li>
<li>FINISH: Completed.</li>
        :type Status: str
        :param _ErrCode: Error code. 0: success; other values: failure.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Url: Live stream URL.
        :type Url: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Url = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamTaskNotifyConfig(AbstractModel):
    """Event notification configuration of a task.

    """

    def __init__(self):
        r"""
        :param _CmqModel: CMQ model. There are two types: `Queue` and `Topic`. Currently, only `Queue` is supported.
        :type CmqModel: str
        :param _CmqRegion: CMQ region, such as `sh` and `bj`.
        :type CmqRegion: str
        :param _QueueName: This parameter is valid when the model is `Queue`, indicating the name of the CMQ queue for receiving event notifications.
        :type QueueName: str
        :param _TopicName: This parameter is valid when the model is `Topic`, indicating the name of the CMQ topic for receiving event notifications.
        :type TopicName: str
        :param _NotifyType: The notification type, `CMQ` by default. If this parameter is set to `URL`, HTTP callbacks are sent to the URL specified by `NotifyUrl`.

<font color="red">Note: If you do not pass this parameter or pass in an empty string, `CMQ` will be used. To use a different notification type, specify this parameter accordingly.</font>
        :type NotifyType: str
        :param _NotifyUrl: HTTP callback URL, required if `NotifyType` is set to `URL`
        :type NotifyUrl: str
        """
        self._CmqModel = None
        self._CmqRegion = None
        self._QueueName = None
        self._TopicName = None
        self._NotifyType = None
        self._NotifyUrl = None

    @property
    def CmqModel(self):
        return self._CmqModel

    @CmqModel.setter
    def CmqModel(self, CmqModel):
        self._CmqModel = CmqModel

    @property
    def CmqRegion(self):
        return self._CmqRegion

    @CmqRegion.setter
    def CmqRegion(self, CmqRegion):
        self._CmqRegion = CmqRegion

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def NotifyType(self):
        return self._NotifyType

    @NotifyType.setter
    def NotifyType(self, NotifyType):
        self._NotifyType = NotifyType

    @property
    def NotifyUrl(self):
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl


    def _deserialize(self, params):
        self._CmqModel = params.get("CmqModel")
        self._CmqRegion = params.get("CmqRegion")
        self._QueueName = params.get("QueueName")
        self._TopicName = params.get("TopicName")
        self._NotifyType = params.get("NotifyType")
        self._NotifyUrl = params.get("NotifyUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LiveStreamTransTextRecognitionResult(AbstractModel):
    """The live stream translation result.

    """

    def __init__(self):
        r"""
        :param _Text: The text transcript.
        :type Text: str
        :param _StartPtsTime: The PTS (seconds) of the start of a segment.
        :type StartPtsTime: float
        :param _EndPtsTime: The PTS (seconds) of the end of a segment.
        :type EndPtsTime: float
        :param _Confidence: The confidence score for a segment. Value range: 0-100.
        :type Confidence: float
        :param _Trans: The translation.
        :type Trans: str
        """
        self._Text = None
        self._StartPtsTime = None
        self._EndPtsTime = None
        self._Confidence = None
        self._Trans = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text

    @property
    def StartPtsTime(self):
        return self._StartPtsTime

    @StartPtsTime.setter
    def StartPtsTime(self, StartPtsTime):
        self._StartPtsTime = StartPtsTime

    @property
    def EndPtsTime(self):
        return self._EndPtsTime

    @EndPtsTime.setter
    def EndPtsTime(self, EndPtsTime):
        self._EndPtsTime = EndPtsTime

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Trans(self):
        return self._Trans

    @Trans.setter
    def Trans(self, Trans):
        self._Trans = Trans


    def _deserialize(self, params):
        self._Text = params.get("Text")
        self._StartPtsTime = params.get("StartPtsTime")
        self._EndPtsTime = params.get("EndPtsTime")
        self._Confidence = params.get("Confidence")
        self._Trans = params.get("Trans")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class LowLightEnhanceConfig(AbstractModel):
    """Low-light enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>normal</li>
Default value: normal.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManageTaskRequest(AbstractModel):
    """ManageTask request structure.

    """

    def __init__(self):
        r"""
        :param _OperationType: Operation type. Valid values:
<ul>
<li>Abort: task termination. Description:
<ul><li>If the [task type](https://intl.cloud.tencent.com/document/product/862/37614?from_cn_redirect=1#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) is live stream processing (`LiveStreamProcessTask`), tasks whose [task status](https://intl.cloud.tencent.com/document/product/862/37614?from_cn_redirect=1#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) is `WAITING` or `PROCESSING` can be terminated.</li>
<li>For other [task types](https://intl.cloud.tencent.com/document/product/862/37614?from_cn_redirect=1#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0), only tasks whose [task status](https://intl.cloud.tencent.com/document/product/862/37614?from_cn_redirect=1#3.-.E8.BE.93.E5.87.BA.E5.8F.82.E6.95.B0) is `WAITING` can be terminated.</li></ul>
</li></ul>
        :type OperationType: str
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        """
        self._OperationType = None
        self._TaskId = None

    @property
    def OperationType(self):
        return self._OperationType

    @OperationType.setter
    def OperationType(self, OperationType):
        self._OperationType = OperationType

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._OperationType = params.get("OperationType")
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ManageTaskResponse(AbstractModel):
    """ManageTask response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MediaAiAnalysisClassificationItem(AbstractModel):
    """Intelligent categorization result

    """

    def __init__(self):
        r"""
        :param _Classification: Name of intelligently generated category.
        :type Classification: str
        :param _Confidence: Confidence of intelligently generated category between 0 and 100.
        :type Confidence: float
        """
        self._Classification = None
        self._Confidence = None

    @property
    def Classification(self):
        return self._Classification

    @Classification.setter
    def Classification(self, Classification):
        self._Classification = Classification

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Classification = params.get("Classification")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisCoverItem(AbstractModel):
    """Information of intelligently generated cover

    """

    def __init__(self):
        r"""
        :param _CoverPath: Storage path of intelligently generated cover.
        :type CoverPath: str
        :param _Confidence: Confidence of intelligently generated cover between 0 and 100.
        :type Confidence: float
        """
        self._CoverPath = None
        self._Confidence = None

    @property
    def CoverPath(self):
        return self._CoverPath

    @CoverPath.setter
    def CoverPath(self, CoverPath):
        self._CoverPath = CoverPath

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._CoverPath = params.get("CoverPath")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisFrameTagItem(AbstractModel):
    """Result information of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _Tag: Frame-specific tag name.
        :type Tag: str
        :param _CategorySet: 
        :type CategorySet: list of str
        :param _Confidence: Confidence of intelligently generated frame-specific tag between 0 and 100.
        :type Confidence: float
        """
        self._Tag = None
        self._CategorySet = None
        self._Confidence = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def CategorySet(self):
        return self._CategorySet

    @CategorySet.setter
    def CategorySet(self, CategorySet):
        self._CategorySet = CategorySet

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._CategorySet = params.get("CategorySet")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisFrameTagSegmentItem(AbstractModel):
    """List of frame-specific tag segments

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of frame-specific tag.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of frame-specific tag.
        :type EndTimeOffset: float
        :param _TagSet: List of tags in time period.
        :type TagSet: list of MediaAiAnalysisFrameTagItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TagSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisFrameTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisHighlightItem(AbstractModel):
    """The information of intelligently generated highlight segments.

    """

    def __init__(self):
        r"""
        :param _HighlightPath: The URL of the highlight segments.
        :type HighlightPath: str
        :param _CovImgPath: The URL of the thumbnail.
        :type CovImgPath: str
        :param _Confidence: The confidence score. Value range: 0-100.
        :type Confidence: float
        :param _Duration: The duration of the highlights.
        :type Duration: float
        :param _SegmentSet: A list of the highlight segments.
        :type SegmentSet: list of HighlightSegmentItem
        """
        self._HighlightPath = None
        self._CovImgPath = None
        self._Confidence = None
        self._Duration = None
        self._SegmentSet = None

    @property
    def HighlightPath(self):
        return self._HighlightPath

    @HighlightPath.setter
    def HighlightPath(self, HighlightPath):
        self._HighlightPath = HighlightPath

    @property
    def CovImgPath(self):
        return self._CovImgPath

    @CovImgPath.setter
    def CovImgPath(self, CovImgPath):
        self._CovImgPath = CovImgPath

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._HighlightPath = params.get("HighlightPath")
        self._CovImgPath = params.get("CovImgPath")
        self._Confidence = params.get("Confidence")
        self._Duration = params.get("Duration")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = HighlightSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAiAnalysisTagItem(AbstractModel):
    """Result information of intelligent tagging

    """

    def __init__(self):
        r"""
        :param _Tag: Tag name.
        :type Tag: str
        :param _Confidence: Confidence of tag between 0 and 100.
        :type Confidence: float
        """
        self._Tag = None
        self._Confidence = None

    @property
    def Tag(self):
        return self._Tag

    @Tag.setter
    def Tag(self, Tag):
        self._Tag = Tag

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._Tag = params.get("Tag")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAnimatedGraphicsItem(AbstractModel):
    """Result information of an animated image generating task

    """

    def __init__(self):
        r"""
        :param _Storage: Storage location of a generated animated image file.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: Path to a generated animated image file.
        :type Path: str
        :param _Definition: ID of an animated image generating template. For more information, please see [Animated Image Generating Parameter Template](https://intl.cloud.tencent.com/document/product/266/33481?from_cn_redirect=1#.E8.BD.AC.E5.8A.A8.E5.9B.BE.E6.A8.A1.E6.9D.BF).
        :type Definition: int
        :param _Container: Animated image format, such as gif.
        :type Container: str
        :param _Height: Height of an animated image in px.
        :type Height: int
        :param _Width: Width of an animated image in px.
        :type Width: int
        :param _Bitrate: Bitrate of an animated image in bps.
        :type Bitrate: int
        :param _Size: Size of an animated image in bytes.
        :type Size: int
        :param _Md5: MD5 value of an animated image.
        :type Md5: str
        :param _StartTimeOffset: Start time offset of an animated image in the video in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of an animated image in the video in seconds.
        :type EndTimeOffset: float
        """
        self._Storage = None
        self._Path = None
        self._Definition = None
        self._Container = None
        self._Height = None
        self._Width = None
        self._Bitrate = None
        self._Size = None
        self._Md5 = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        self._Path = params.get("Path")
        self._Definition = params.get("Definition")
        self._Container = params.get("Container")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Bitrate = params.get("Bitrate")
        self._Size = params.get("Size")
        self._Md5 = params.get("Md5")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaAudioStreamItem(AbstractModel):
    """Information of the audio stream in a VOD file

    """

    def __init__(self):
        r"""
        :param _Bitrate: Bitrate of an audio stream in bps.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bitrate: int
        :param _SamplingRate: Sample rate of an audio stream in Hz.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SamplingRate: int
        :param _Codec: Audio stream codec, such as aac.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Codec: str
        :param _Channel: Number of sound channels, e.g., 2
Note: this field may return `null`, indicating that no valid value was found.
        :type Channel: int
        """
        self._Bitrate = None
        self._SamplingRate = None
        self._Codec = None
        self._Channel = None

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SamplingRate(self):
        return self._SamplingRate

    @SamplingRate.setter
    def SamplingRate(self, SamplingRate):
        self._SamplingRate = SamplingRate

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Channel(self):
        return self._Channel

    @Channel.setter
    def Channel(self, Channel):
        self._Channel = Channel


    def _deserialize(self, params):
        self._Bitrate = params.get("Bitrate")
        self._SamplingRate = params.get("SamplingRate")
        self._Codec = params.get("Codec")
        self._Channel = params.get("Channel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewAsrTextSegmentItem(AbstractModel):
    """Suspected segment identified during ASR-based text audit during content audit

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a suspected segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a suspected segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a suspected segment.
        :type Confidence: float
        :param _Suggestion: Suggestion for suspected segment audit. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _KeywordSet: List of suspected keywords.
        :type KeywordSet: list of str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewOcrTextSegmentItem(AbstractModel):
    """Suspected segment identified during OCR-based text audit during content audit

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a suspected segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a suspected segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of a suspected segment.
        :type Confidence: float
        :param _Suggestion: Suggestion for suspected segment audit. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _KeywordSet: List of suspected keywords.
        :type KeywordSet: list of str
        :param _AreaCoordSet: Zone coordinates (at the pixel level) of suspected text: [x1, y1, x2, y2], i.e., the coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _Url: URL of a suspected image (which will not be permanently stored
and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None
        self._AreaCoordSet = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewPoliticalSegmentItem(AbstractModel):
    """The information about the sensitive segments detected.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a suspected segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a suspected segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: The confidence score for the detected sensitive segments.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the sensitive segments. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Name: The name of a sensitive person or banned icon.
        :type Name: str
        :param _Label: The labels for the detected sensitive segments. The relationship between the values of this parameter and those of the `LabelSet` parameter in [PoliticalImgReviewTemplateInfo](https://intl.cloud.tencent.com/document/api/862/37615?from_cn_redirect=1#PoliticalImgReviewTemplateInfo) is as follows:
violation_photo:
<li>violation_photo (banned icons)</li>
politician:
<li>nation_politician (state leader)</li>
<li>province_politician (provincial officials)</li>
<li>bureau_politician (bureau-level officials)</li>
<li>county_politician (county-level officials)</li>
<li>rural_politician (township-level officials)</li>
<li>sensitive_politician (sensitive people)</li>
<li>foreign_politician (state leaders of other countries)</li>
entertainment:
<li>sensitive_entertainment (sensitive people in the entertainment industry</li>
sport:
<li>sensitive_sport (sensitive sports celebrities)</li>
entrepreneur:
<li>sensitive_entrepreneur</li>
scholar:
<li>sensitive_scholar</li>
celebrity:
<li>sensitive_celebrity</li>
<li>historical_celebrity (sensitive historical figures)</li>
military:
<li>sensitive_military (sensitive people in military)</li>
        :type Label: str
        :param _Url: URL of a suspected image (which will not be permanently stored
 and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _AreaCoordSet: The pixel coordinates of the detected sensitive people or banned icons. The format is [x1, y1, x2, y2], which indicates the coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Suggestion = None
        self._Name = None
        self._Label = None
        self._Url = None
        self._AreaCoordSet = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Name = params.get("Name")
        self._Label = params.get("Label")
        self._Url = params.get("Url")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaContentReviewSegmentItem(AbstractModel):
    """The information about the detected pornographic/sensitive segments.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of a suspected segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of a suspected segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Score of a suspected porn segment.
        :type Confidence: float
        :param _Label: Tag of porn information detection result of a suspected segment.
        :type Label: str
        :param _Suggestion: Suggestion for porn information detection of a suspected segment. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _Url: URL of a suspected image (which will not be permanently stored
 and will be deleted after `PicUrlExpireTime`).
        :type Url: str
        :param _PicUrlExpireTime: Expiration time of a suspected image URL in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type PicUrlExpireTime: str
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._Label = None
        self._Suggestion = None
        self._Url = None
        self._PicUrlExpireTime = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def PicUrlExpireTime(self):
        return self._PicUrlExpireTime

    @PicUrlExpireTime.setter
    def PicUrlExpireTime(self, PicUrlExpireTime):
        self._PicUrlExpireTime = PicUrlExpireTime


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._Label = params.get("Label")
        self._Suggestion = params.get("Suggestion")
        self._Url = params.get("Url")
        self._PicUrlExpireTime = params.get("PicUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaImageSpriteItem(AbstractModel):
    """Image sprite information

    """

    def __init__(self):
        r"""
        :param _Definition: Image sprite specification. For more information, please see [Image Sprite Parameter Template](https://intl.cloud.tencent.com/document/product/266/33480?from_cn_redirect=1#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF).
        :type Definition: int
        :param _Height: Subimage height of an image sprite.
        :type Height: int
        :param _Width: Subimage width of an image sprite.
        :type Width: int
        :param _TotalCount: Total number of subimages in each image sprite.
        :type TotalCount: int
        :param _ImagePathSet: Path to each image sprite.
        :type ImagePathSet: list of str
        :param _WebVttPath: Path to a WebVtt file for the position-time relationship among subimages in an image sprite. The WebVtt file indicates the corresponding time points of each subimage and their coordinates in the image sprite, which is typically used by the player for implementing preview.
        :type WebVttPath: str
        :param _Storage: Storage location of an image sprite file.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._Height = None
        self._Width = None
        self._TotalCount = None
        self._ImagePathSet = None
        self._WebVttPath = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImagePathSet(self):
        return self._ImagePathSet

    @ImagePathSet.setter
    def ImagePathSet(self, ImagePathSet):
        self._ImagePathSet = ImagePathSet

    @property
    def WebVttPath(self):
        return self._WebVttPath

    @WebVttPath.setter
    def WebVttPath(self, WebVttPath):
        self._WebVttPath = WebVttPath

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._TotalCount = params.get("TotalCount")
        self._ImagePathSet = params.get("ImagePathSet")
        self._WebVttPath = params.get("WebVttPath")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaInputInfo(AbstractModel):
    """The information of the object to process.

    """

    def __init__(self):
        r"""
        :param _Type: The input type. Valid values:
<li>`COS`: A COS bucket address.</li>
<li> `URL`: A URL.</li>
<li> `AWS-S3`: An AWS S3 bucket address. Currently, this type is only supported for transcoding tasks.</li>
        :type Type: str
        :param _CosInputInfo: The information of the COS object to process. This parameter is valid and required when `Type` is `COS`.
        :type CosInputInfo: :class:`tencentcloud.mps.v20190612.models.CosInputInfo`
        :param _UrlInputInfo: The URL of the object to process. This parameter is valid and required when `Type` is `URL`.
Note: This field may return null, indicating that no valid value can be obtained.
        :type UrlInputInfo: :class:`tencentcloud.mps.v20190612.models.UrlInputInfo`
        :param _S3InputInfo: The information of the AWS S3 object processed. This parameter is required if `Type` is `AWS-S3`.
Note: This field may return null, indicating that no valid value can be obtained.
        :type S3InputInfo: :class:`tencentcloud.mps.v20190612.models.S3InputInfo`
        """
        self._Type = None
        self._CosInputInfo = None
        self._UrlInputInfo = None
        self._S3InputInfo = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CosInputInfo(self):
        return self._CosInputInfo

    @CosInputInfo.setter
    def CosInputInfo(self, CosInputInfo):
        self._CosInputInfo = CosInputInfo

    @property
    def UrlInputInfo(self):
        return self._UrlInputInfo

    @UrlInputInfo.setter
    def UrlInputInfo(self, UrlInputInfo):
        self._UrlInputInfo = UrlInputInfo

    @property
    def S3InputInfo(self):
        return self._S3InputInfo

    @S3InputInfo.setter
    def S3InputInfo(self, S3InputInfo):
        self._S3InputInfo = S3InputInfo


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("CosInputInfo") is not None:
            self._CosInputInfo = CosInputInfo()
            self._CosInputInfo._deserialize(params.get("CosInputInfo"))
        if params.get("UrlInputInfo") is not None:
            self._UrlInputInfo = UrlInputInfo()
            self._UrlInputInfo._deserialize(params.get("UrlInputInfo"))
        if params.get("S3InputInfo") is not None:
            self._S3InputInfo = S3InputInfo()
            self._S3InputInfo._deserialize(params.get("S3InputInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaMetaData(AbstractModel):
    """Metadata of a VOD media file

    """

    def __init__(self):
        r"""
        :param _Size: Size of an uploaded media file in bytes (which is the sum of size of m3u8 and ts files if the video is in HLS format).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Size: int
        :param _Container: Container, such as m4a and mp4.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Container: str
        :param _Bitrate: Sum of the average bitrate of a video stream and that of an audio stream in bps.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bitrate: int
        :param _Height: Maximum value of the height of a video stream in px.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Height: int
        :param _Width: Maximum value of the width of a video stream in px.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Width: int
        :param _Duration: Video duration in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Duration: float
        :param _Rotate: Selected angle during video recording in degrees.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Rotate: int
        :param _VideoStreamSet: Video stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VideoStreamSet: list of MediaVideoStreamItem
        :param _AudioStreamSet: Audio stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioStreamSet: list of MediaAudioStreamItem
        :param _VideoDuration: Video duration in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VideoDuration: float
        :param _AudioDuration: Audio duration in seconds.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioDuration: float
        """
        self._Size = None
        self._Container = None
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Duration = None
        self._Rotate = None
        self._VideoStreamSet = None
        self._AudioStreamSet = None
        self._VideoDuration = None
        self._AudioDuration = None

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Rotate(self):
        return self._Rotate

    @Rotate.setter
    def Rotate(self, Rotate):
        self._Rotate = Rotate

    @property
    def VideoStreamSet(self):
        return self._VideoStreamSet

    @VideoStreamSet.setter
    def VideoStreamSet(self, VideoStreamSet):
        self._VideoStreamSet = VideoStreamSet

    @property
    def AudioStreamSet(self):
        return self._AudioStreamSet

    @AudioStreamSet.setter
    def AudioStreamSet(self, AudioStreamSet):
        self._AudioStreamSet = AudioStreamSet

    @property
    def VideoDuration(self):
        return self._VideoDuration

    @VideoDuration.setter
    def VideoDuration(self, VideoDuration):
        self._VideoDuration = VideoDuration

    @property
    def AudioDuration(self):
        return self._AudioDuration

    @AudioDuration.setter
    def AudioDuration(self, AudioDuration):
        self._AudioDuration = AudioDuration


    def _deserialize(self, params):
        self._Size = params.get("Size")
        self._Container = params.get("Container")
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Duration = params.get("Duration")
        self._Rotate = params.get("Rotate")
        if params.get("VideoStreamSet") is not None:
            self._VideoStreamSet = []
            for item in params.get("VideoStreamSet"):
                obj = MediaVideoStreamItem()
                obj._deserialize(item)
                self._VideoStreamSet.append(obj)
        if params.get("AudioStreamSet") is not None:
            self._AudioStreamSet = []
            for item in params.get("AudioStreamSet"):
                obj = MediaAudioStreamItem()
                obj._deserialize(item)
                self._AudioStreamSet.append(obj)
        self._VideoDuration = params.get("VideoDuration")
        self._AudioDuration = params.get("AudioDuration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskAdaptiveDynamicStreamingResult(AbstractModel):
    """Result type of adaptive bitrate streaming task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of an adaptive bitrate streaming task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingTaskInput`
        :param _Output: Output of an adaptive bitrate streaming task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.AdaptiveDynamicStreamingInfoItem`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AdaptiveDynamicStreamingTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AdaptiveDynamicStreamingInfoItem()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskAnimatedGraphicResult(AbstractModel):
    """Result type of an animated image generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an animated image generating task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AnimatedGraphicTaskInput`
        :param _Output: Output of an animated image generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaAnimatedGraphicsItem`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AnimatedGraphicTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaAnimatedGraphicsItem()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskImageSpriteResult(AbstractModel):
    """Result type of an image sprite generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an image sprite generating task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.ImageSpriteTaskInput`
        :param _Output: Output of an image sprite generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaImageSpriteItem`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = ImageSpriteTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaImageSpriteItem()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskInput(AbstractModel):
    """The type of media processing task.

    """

    def __init__(self):
        r"""
        :param _TranscodeTaskSet: List of transcoding tasks.
        :type TranscodeTaskSet: list of TranscodeTaskInput
        :param _AnimatedGraphicTaskSet: List of animated image generating tasks.
        :type AnimatedGraphicTaskSet: list of AnimatedGraphicTaskInput
        :param _SnapshotByTimeOffsetTaskSet: List of time point screencapturing tasks.
        :type SnapshotByTimeOffsetTaskSet: list of SnapshotByTimeOffsetTaskInput
        :param _SampleSnapshotTaskSet: List of sampled screencapturing tasks.
        :type SampleSnapshotTaskSet: list of SampleSnapshotTaskInput
        :param _ImageSpriteTaskSet: List of image sprite generating tasks.
        :type ImageSpriteTaskSet: list of ImageSpriteTaskInput
        :param _AdaptiveDynamicStreamingTaskSet: List of adaptive bitrate streaming tasks.
        :type AdaptiveDynamicStreamingTaskSet: list of AdaptiveDynamicStreamingTaskInput
        """
        self._TranscodeTaskSet = None
        self._AnimatedGraphicTaskSet = None
        self._SnapshotByTimeOffsetTaskSet = None
        self._SampleSnapshotTaskSet = None
        self._ImageSpriteTaskSet = None
        self._AdaptiveDynamicStreamingTaskSet = None

    @property
    def TranscodeTaskSet(self):
        return self._TranscodeTaskSet

    @TranscodeTaskSet.setter
    def TranscodeTaskSet(self, TranscodeTaskSet):
        self._TranscodeTaskSet = TranscodeTaskSet

    @property
    def AnimatedGraphicTaskSet(self):
        return self._AnimatedGraphicTaskSet

    @AnimatedGraphicTaskSet.setter
    def AnimatedGraphicTaskSet(self, AnimatedGraphicTaskSet):
        self._AnimatedGraphicTaskSet = AnimatedGraphicTaskSet

    @property
    def SnapshotByTimeOffsetTaskSet(self):
        return self._SnapshotByTimeOffsetTaskSet

    @SnapshotByTimeOffsetTaskSet.setter
    def SnapshotByTimeOffsetTaskSet(self, SnapshotByTimeOffsetTaskSet):
        self._SnapshotByTimeOffsetTaskSet = SnapshotByTimeOffsetTaskSet

    @property
    def SampleSnapshotTaskSet(self):
        return self._SampleSnapshotTaskSet

    @SampleSnapshotTaskSet.setter
    def SampleSnapshotTaskSet(self, SampleSnapshotTaskSet):
        self._SampleSnapshotTaskSet = SampleSnapshotTaskSet

    @property
    def ImageSpriteTaskSet(self):
        return self._ImageSpriteTaskSet

    @ImageSpriteTaskSet.setter
    def ImageSpriteTaskSet(self, ImageSpriteTaskSet):
        self._ImageSpriteTaskSet = ImageSpriteTaskSet

    @property
    def AdaptiveDynamicStreamingTaskSet(self):
        return self._AdaptiveDynamicStreamingTaskSet

    @AdaptiveDynamicStreamingTaskSet.setter
    def AdaptiveDynamicStreamingTaskSet(self, AdaptiveDynamicStreamingTaskSet):
        self._AdaptiveDynamicStreamingTaskSet = AdaptiveDynamicStreamingTaskSet


    def _deserialize(self, params):
        if params.get("TranscodeTaskSet") is not None:
            self._TranscodeTaskSet = []
            for item in params.get("TranscodeTaskSet"):
                obj = TranscodeTaskInput()
                obj._deserialize(item)
                self._TranscodeTaskSet.append(obj)
        if params.get("AnimatedGraphicTaskSet") is not None:
            self._AnimatedGraphicTaskSet = []
            for item in params.get("AnimatedGraphicTaskSet"):
                obj = AnimatedGraphicTaskInput()
                obj._deserialize(item)
                self._AnimatedGraphicTaskSet.append(obj)
        if params.get("SnapshotByTimeOffsetTaskSet") is not None:
            self._SnapshotByTimeOffsetTaskSet = []
            for item in params.get("SnapshotByTimeOffsetTaskSet"):
                obj = SnapshotByTimeOffsetTaskInput()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTaskSet.append(obj)
        if params.get("SampleSnapshotTaskSet") is not None:
            self._SampleSnapshotTaskSet = []
            for item in params.get("SampleSnapshotTaskSet"):
                obj = SampleSnapshotTaskInput()
                obj._deserialize(item)
                self._SampleSnapshotTaskSet.append(obj)
        if params.get("ImageSpriteTaskSet") is not None:
            self._ImageSpriteTaskSet = []
            for item in params.get("ImageSpriteTaskSet"):
                obj = ImageSpriteTaskInput()
                obj._deserialize(item)
                self._ImageSpriteTaskSet.append(obj)
        if params.get("AdaptiveDynamicStreamingTaskSet") is not None:
            self._AdaptiveDynamicStreamingTaskSet = []
            for item in params.get("AdaptiveDynamicStreamingTaskSet"):
                obj = AdaptiveDynamicStreamingTaskInput()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTaskSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskResult(AbstractModel):
    """Query result type of a task

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Transcode: Transcoding</li>
<li>AnimatedGraphics: Animated image generating</li>
<li>SnapshotByTimeOffset: Time point screencapturing</li>
<li>SampleSnapshot: Sampled screencapturing</li>
<li>ImageSprites: Image sprite generating</li>
<li>CoverBySnapshot: Screencapturing for cover image</li>
<li>AdaptiveDynamicStreaming: Adaptive bitrate streaming</li>
        :type Type: str
        :param _TranscodeTask: Query result of a transcoding task, which is valid when task type is `Transcode`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TranscodeTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskTranscodeResult`
        :param _AnimatedGraphicTask: Query result of an animated image generating task, which is valid when task type is `AnimatedGraphics`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AnimatedGraphicTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAnimatedGraphicResult`
        :param _SnapshotByTimeOffsetTask: Query result of a time point screencapturing task, which is valid when task type is `SnapshotByTimeOffset`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSnapshotByTimeOffsetResult`
        :param _SampleSnapshotTask: Query result of a sampled screencapturing task, which is valid when task type is `SampleSnapshot`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SampleSnapshotTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskSampleSnapshotResult`
        :param _ImageSpriteTask: Query result of an image sprite generating task, which is valid when task type is `ImageSprite`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSpriteTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskImageSpriteResult`
        :param _AdaptiveDynamicStreamingTask: Query result of an adaptive bitrate streaming task, which is valid if the task type is `AdaptiveDynamicStreaming`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AdaptiveDynamicStreamingTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskAdaptiveDynamicStreamingResult`
        """
        self._Type = None
        self._TranscodeTask = None
        self._AnimatedGraphicTask = None
        self._SnapshotByTimeOffsetTask = None
        self._SampleSnapshotTask = None
        self._ImageSpriteTask = None
        self._AdaptiveDynamicStreamingTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def AnimatedGraphicTask(self):
        return self._AnimatedGraphicTask

    @AnimatedGraphicTask.setter
    def AnimatedGraphicTask(self, AnimatedGraphicTask):
        self._AnimatedGraphicTask = AnimatedGraphicTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def SampleSnapshotTask(self):
        return self._SampleSnapshotTask

    @SampleSnapshotTask.setter
    def SampleSnapshotTask(self, SampleSnapshotTask):
        self._SampleSnapshotTask = SampleSnapshotTask

    @property
    def ImageSpriteTask(self):
        return self._ImageSpriteTask

    @ImageSpriteTask.setter
    def ImageSpriteTask(self, ImageSpriteTask):
        self._ImageSpriteTask = ImageSpriteTask

    @property
    def AdaptiveDynamicStreamingTask(self):
        return self._AdaptiveDynamicStreamingTask

    @AdaptiveDynamicStreamingTask.setter
    def AdaptiveDynamicStreamingTask(self, AdaptiveDynamicStreamingTask):
        self._AdaptiveDynamicStreamingTask = AdaptiveDynamicStreamingTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = MediaProcessTaskTranscodeResult()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("AnimatedGraphicTask") is not None:
            self._AnimatedGraphicTask = MediaProcessTaskAnimatedGraphicResult()
            self._AnimatedGraphicTask._deserialize(params.get("AnimatedGraphicTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = MediaProcessTaskSnapshotByTimeOffsetResult()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("SampleSnapshotTask") is not None:
            self._SampleSnapshotTask = MediaProcessTaskSampleSnapshotResult()
            self._SampleSnapshotTask._deserialize(params.get("SampleSnapshotTask"))
        if params.get("ImageSpriteTask") is not None:
            self._ImageSpriteTask = MediaProcessTaskImageSpriteResult()
            self._ImageSpriteTask._deserialize(params.get("ImageSpriteTask"))
        if params.get("AdaptiveDynamicStreamingTask") is not None:
            self._AdaptiveDynamicStreamingTask = MediaProcessTaskAdaptiveDynamicStreamingResult()
            self._AdaptiveDynamicStreamingTask._deserialize(params.get("AdaptiveDynamicStreamingTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskSampleSnapshotResult(AbstractModel):
    """Result type of a sampled screencapturing task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for a sampled screencapturing task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.SampleSnapshotTaskInput`
        :param _Output: Output of a sampled screencapturing task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaSampleSnapshotItem`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = SampleSnapshotTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaSampleSnapshotItem()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskSnapshotByTimeOffsetResult(AbstractModel):
    """Result type of a time point screencapturing task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for a time point screencapturing task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.SnapshotByTimeOffsetTaskInput`
        :param _Output: Output of a time point screencapturing task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaSnapshotByTimeOffsetItem`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = SnapshotByTimeOffsetTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaSnapshotByTimeOffsetItem()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaProcessTaskTranscodeResult(AbstractModel):
    """Result type of a transcoding task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; otherwise it is failed. This parameter is no longer recommended. Consider using the new error code parameter ErrCodeExt.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for a transcoding task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.TranscodeTaskInput`
        :param _Output: Output of a transcoding task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.MediaTranscodeItem`
        :param _Progress: Transcoding progress. Value range: 0-100
Note: This field may return `null`, indicating that no valid value was found.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = TranscodeTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = MediaTranscodeItem()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSampleSnapshotItem(AbstractModel):
    """Information of a sampled screenshot

    """

    def __init__(self):
        r"""
        :param _Definition: Sampled screenshot specification ID. For more information, please see [Sampled Screencapturing Parameter Template](https://intl.cloud.tencent.com/document/product/266/33480?from_cn_redirect=1#.E9.87.87.E6.A0.B7.E6.88.AA.E5.9B.BE.E6.A8.A1.E6.9D.BF).
        :type Definition: int
        :param _SampleType: Sample type. Valid values:
<li>Percent: Samples at the specified percentage interval.</li>
<li>Time: Samples at the specified time interval.</li>
        :type SampleType: str
        :param _Interval: Sampling interval
<li>If `SampleType` is `Percent`, this value means taking a screenshot at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, this value means taking a screenshot at an interval of the specified time (in seconds). The first screenshot is always the first video frame.</li>
        :type Interval: int
        :param _Storage: Storage location of a generated screenshot file.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _ImagePathSet: List of paths to generated screenshots.
        :type ImagePathSet: list of str
        :param _WaterMarkDefinition: List of watermarking template IDs if the screenshots are watermarked.
        :type WaterMarkDefinition: list of int
        """
        self._Definition = None
        self._SampleType = None
        self._Interval = None
        self._Storage = None
        self._ImagePathSet = None
        self._WaterMarkDefinition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage

    @property
    def ImagePathSet(self):
        return self._ImagePathSet

    @ImagePathSet.setter
    def ImagePathSet(self, ImagePathSet):
        self._ImagePathSet = ImagePathSet

    @property
    def WaterMarkDefinition(self):
        return self._WaterMarkDefinition

    @WaterMarkDefinition.setter
    def WaterMarkDefinition(self, WaterMarkDefinition):
        self._WaterMarkDefinition = WaterMarkDefinition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SampleType = params.get("SampleType")
        self._Interval = params.get("Interval")
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        self._ImagePathSet = params.get("ImagePathSet")
        self._WaterMarkDefinition = params.get("WaterMarkDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSnapshotByTimeOffsetItem(AbstractModel):
    """Information of the time point screenshots in a VOD file

    """

    def __init__(self):
        r"""
        :param _Definition: Specification of a time point screenshot. For more information, please see [Parameter Template for Time Point Screencapturing](https://intl.cloud.tencent.com/document/product/266/33480?from_cn_redirect=1#.E6.97.B6.E9.97.B4.E7.82.B9.E6.88.AA.E5.9B.BE.E6.A8.A1.E6.9D.BF).
        :type Definition: int
        :param _PicInfoSet: Information set of screenshots of the same specification. Each element represents a screenshot.
        :type PicInfoSet: list of MediaSnapshotByTimePicInfoItem
        :param _Storage: Location of a time point screenshot file.
        :type Storage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        """
        self._Definition = None
        self._PicInfoSet = None
        self._Storage = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def PicInfoSet(self):
        return self._PicInfoSet

    @PicInfoSet.setter
    def PicInfoSet(self, PicInfoSet):
        self._PicInfoSet = PicInfoSet

    @property
    def Storage(self):
        return self._Storage

    @Storage.setter
    def Storage(self, Storage):
        self._Storage = Storage


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("PicInfoSet") is not None:
            self._PicInfoSet = []
            for item in params.get("PicInfoSet"):
                obj = MediaSnapshotByTimePicInfoItem()
                obj._deserialize(item)
                self._PicInfoSet.append(obj)
        if params.get("Storage") is not None:
            self._Storage = TaskOutputStorage()
            self._Storage._deserialize(params.get("Storage"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaSnapshotByTimePicInfoItem(AbstractModel):
    """Information of a time point screenshot

    """

    def __init__(self):
        r"""
        :param _TimeOffset: The timestamp (seconds) of the screenshot.
        :type TimeOffset: float
        :param _Path: Path to the screenshot.
        :type Path: str
        :param _WaterMarkDefinition: List of watermarking template IDs if the screenshots are watermarked.
        :type WaterMarkDefinition: list of int
        """
        self._TimeOffset = None
        self._Path = None
        self._WaterMarkDefinition = None

    @property
    def TimeOffset(self):
        return self._TimeOffset

    @TimeOffset.setter
    def TimeOffset(self, TimeOffset):
        self._TimeOffset = TimeOffset

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def WaterMarkDefinition(self):
        return self._WaterMarkDefinition

    @WaterMarkDefinition.setter
    def WaterMarkDefinition(self, WaterMarkDefinition):
        self._WaterMarkDefinition = WaterMarkDefinition


    def _deserialize(self, params):
        self._TimeOffset = params.get("TimeOffset")
        self._Path = params.get("Path")
        self._WaterMarkDefinition = params.get("WaterMarkDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaTranscodeItem(AbstractModel):
    """Transcoding information

    """

    def __init__(self):
        r"""
        :param _OutputStorage: Target bucket of an output file.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _Path: Path to an output video file.
        :type Path: str
        :param _Definition: Transcoding specification ID. For more information, please see [Transcoding Parameter Template](https://intl.cloud.tencent.com/document/product/266/33478?from_cn_redirect=1#.E8.BD.AC.E7.A0.81.E6.A8.A1.E6.9D.BF).
        :type Definition: int
        :param _Bitrate: Sum of the average bitrate of a video stream and that of an audio stream in bps.
        :type Bitrate: int
        :param _Height: Maximum value of the height of a video stream in px.
        :type Height: int
        :param _Width: Maximum value of the width of a video stream in px.
        :type Width: int
        :param _Size: Total size of a media file in bytes (which is the sum of size of m3u8 and ts files if the video is in HLS format).
        :type Size: int
        :param _Duration: Video duration in seconds.
        :type Duration: float
        :param _Container: Container, such as m4a and mp4.
        :type Container: str
        :param _Md5: MD5 value of a video.
        :type Md5: str
        :param _AudioStreamSet: Audio stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AudioStreamSet: list of MediaAudioStreamItem
        :param _VideoStreamSet: Video stream information.
Note: This field may return null, indicating that no valid values can be obtained.
        :type VideoStreamSet: list of MediaVideoStreamItem
        """
        self._OutputStorage = None
        self._Path = None
        self._Definition = None
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Size = None
        self._Duration = None
        self._Container = None
        self._Md5 = None
        self._AudioStreamSet = None
        self._VideoStreamSet = None

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def AudioStreamSet(self):
        return self._AudioStreamSet

    @AudioStreamSet.setter
    def AudioStreamSet(self, AudioStreamSet):
        self._AudioStreamSet = AudioStreamSet

    @property
    def VideoStreamSet(self):
        return self._VideoStreamSet

    @VideoStreamSet.setter
    def VideoStreamSet(self, VideoStreamSet):
        self._VideoStreamSet = VideoStreamSet


    def _deserialize(self, params):
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._Path = params.get("Path")
        self._Definition = params.get("Definition")
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Size = params.get("Size")
        self._Duration = params.get("Duration")
        self._Container = params.get("Container")
        self._Md5 = params.get("Md5")
        if params.get("AudioStreamSet") is not None:
            self._AudioStreamSet = []
            for item in params.get("AudioStreamSet"):
                obj = MediaAudioStreamItem()
                obj._deserialize(item)
                self._AudioStreamSet.append(obj)
        if params.get("VideoStreamSet") is not None:
            self._VideoStreamSet = []
            for item in params.get("VideoStreamSet"):
                obj = MediaVideoStreamItem()
                obj._deserialize(item)
                self._VideoStreamSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class MediaVideoStreamItem(AbstractModel):
    """Information of the video stream in a VOD file

    """

    def __init__(self):
        r"""
        :param _Bitrate: Bitrate of a video stream in bps.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Bitrate: int
        :param _Height: Height of a video stream in px.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Height: int
        :param _Width: Width of a video stream in px.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Width: int
        :param _Codec: Video stream codec, such as h264.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Codec: str
        :param _Fps: Frame rate in Hz.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Fps: int
        :param _ColorPrimaries: Color primaries
Note: this field may return `null`, indicating that no valid value was found.
        :type ColorPrimaries: str
        :param _ColorSpace: Color space
Note: this field may return `null`, indicating that no valid value was found.
        :type ColorSpace: str
        :param _ColorTransfer: Color transfer
Note: this field may return `null`, indicating that no valid value was found.
        :type ColorTransfer: str
        :param _HdrType: HDR type
Note: This field may return `null`, indicating that no valid value was found.
        :type HdrType: str
        """
        self._Bitrate = None
        self._Height = None
        self._Width = None
        self._Codec = None
        self._Fps = None
        self._ColorPrimaries = None
        self._ColorSpace = None
        self._ColorTransfer = None
        self._HdrType = None

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def ColorPrimaries(self):
        return self._ColorPrimaries

    @ColorPrimaries.setter
    def ColorPrimaries(self, ColorPrimaries):
        self._ColorPrimaries = ColorPrimaries

    @property
    def ColorSpace(self):
        return self._ColorSpace

    @ColorSpace.setter
    def ColorSpace(self, ColorSpace):
        self._ColorSpace = ColorSpace

    @property
    def ColorTransfer(self):
        return self._ColorTransfer

    @ColorTransfer.setter
    def ColorTransfer(self, ColorTransfer):
        self._ColorTransfer = ColorTransfer

    @property
    def HdrType(self):
        return self._HdrType

    @HdrType.setter
    def HdrType(self, HdrType):
        self._HdrType = HdrType


    def _deserialize(self, params):
        self._Bitrate = params.get("Bitrate")
        self._Height = params.get("Height")
        self._Width = params.get("Width")
        self._Codec = params.get("Codec")
        self._Fps = params.get("Fps")
        self._ColorPrimaries = params.get("ColorPrimaries")
        self._ColorSpace = params.get("ColorSpace")
        self._ColorTransfer = params.get("ColorTransfer")
        self._HdrType = params.get("HdrType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIAnalysisTemplateRequest(AbstractModel):
    """ModifyAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        :param _Name: Video content analysis template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Video content analysis template description. Length limit: 256 characters.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.mps.v20190612.models.ClassificationConfigureInfoForUpdate`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.mps.v20190612.models.TagConfigureInfoForUpdate`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.mps.v20190612.models.CoverConfigureInfoForUpdate`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.mps.v20190612.models.FrameTagConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfoForUpdate()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfoForUpdate()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfoForUpdate()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfoForUpdate()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIAnalysisTemplateResponse(AbstractModel):
    """ModifyAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAIRecognitionTemplateRequest(AbstractModel):
    """ModifyAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a video content recognition template.
        :type Definition: int
        :param _Name: Name of a video content recognition template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of a video content recognition template. Length limit: 256 characters.
        :type Comment: str
        :param _FaceConfigure: Face recognition control parameter.
        :type FaceConfigure: :class:`tencentcloud.mps.v20190612.models.FaceConfigureInfoForUpdate`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
        :type OcrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.OcrFullTextConfigureInfoForUpdate`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
        :type OcrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.OcrWordsConfigureInfoForUpdate`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
        :type AsrFullTextConfigure: :class:`tencentcloud.mps.v20190612.models.AsrFullTextConfigureInfoForUpdate`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
        :type AsrWordsConfigure: :class:`tencentcloud.mps.v20190612.models.AsrWordsConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfoForUpdate()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfoForUpdate()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfoForUpdate()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfoForUpdate()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfoForUpdate()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAIRecognitionTemplateResponse(AbstractModel):
    """ModifyAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """ModifyAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an adaptive bitrate streaming template.
        :type Definition: int
        :param _Name: Template name. Length limit: 64 characters.
        :type Name: str
        :param _Format: Adaptive bitrate streaming format. Valid values:
<li>HLS,</li>
<li>MPEG-DASH.</li>
        :type Format: str
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoResolution: int
        :param _StreamInfos: Parameter information of input streams for transcoding to adaptive bitrate streaming. Up to 10 streams can be input.
Note: the frame rate of each stream must be consistent; otherwise, the frame rate of the first stream is used as the output frame rate.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Definition = None
        self._Name = None
        self._Format = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._StreamInfos = None
        self._Comment = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Format = params.get("Format")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """ModifyAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyAnimatedGraphicsTemplateRequest(AbstractModel):
    """ModifyAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _Name: Name of an animated image generating template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a video stream in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format. Valid values: gif, webp.
        :type Format: str
        :param _Fps: Video frame rate in Hz. Value range: [1, 30].
        :type Fps: int
        :param _Quality: Image quality. Value range: [1, 100]. Default value: 75.
        :type Quality: float
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._Comment = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyAnimatedGraphicsTemplateResponse(AbstractModel):
    """ModifyAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyContentReviewTemplateRequest(AbstractModel):
    """ModifyContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the content moderation template.
        :type Definition: int
        :param _Name: The name of the content moderation template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: The template description. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Control parameter for porn information
        :type PornConfigure: :class:`tencentcloud.mps.v20190612.models.PornConfigureInfoForUpdate`
        :param _TerrorismConfigure: Control parameter for terrorism information
        :type TerrorismConfigure: :class:`tencentcloud.mps.v20190612.models.TerrorismConfigureInfoForUpdate`
        :param _PoliticalConfigure: Control parameter for politically sensitive information
        :type PoliticalConfigure: :class:`tencentcloud.mps.v20190612.models.PoliticalConfigureInfoForUpdate`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this parameter is not supported yet.
        :type ProhibitedConfigure: :class:`tencentcloud.mps.v20190612.models.ProhibitedConfigureInfoForUpdate`
        :param _UserDefineConfigure: Custom content moderation parameters.
        :type UserDefineConfigure: :class:`tencentcloud.mps.v20190612.models.UserDefineConfigureInfoForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfoForUpdate()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfoForUpdate()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfoForUpdate()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfoForUpdate()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfoForUpdate()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyContentReviewTemplateResponse(AbstractModel):
    """ModifyContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyImageSpriteTemplateRequest(AbstractModel):
    """ModifyImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _Name: Name of an image sprite generating template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Subimage width of an image sprite in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Subimage height of an image sprite in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _SampleType: Sampling type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _RowCount: Subimage row count of an image sprite.
        :type RowCount: int
        :param _ColumnCount: Subimage column count of an image sprite.
        :type ColumnCount: int
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :type FillType: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _Format: The image format. Valid values: jpg, png, webp.
        :type Format: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._FillType = None
        self._Comment = None
        self._Format = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._FillType = params.get("FillType")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyImageSpriteTemplateResponse(AbstractModel):
    """ModifyImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyPersonSampleRequest(AbstractModel):
    """ModifyPersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _PersonId: Image ID
        :type PersonId: str
        :param _Name: Name. Length limit: 128 characters.
        :type Name: str
        :param _Description: Description. Length limit: 1,024 characters.
        :type Description: str
        :param _Usages: Image usage. Valid values:
1. Recognition: used for content recognition; equivalent to `Recognition.Face`
2. Review: used for inappropriate information recognition; equivalent to `Review.Face`
3. All: used for content recognition and inappropriate information recognition; equivalent to 1+2
        :type Usages: list of str
        :param _FaceOperationInfo: Information of operations on facial features
        :type FaceOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleFaceOperation`
        :param _TagOperationInfo: Tag operation information.
        :type TagOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleTagOperation`
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._Usages = None
        self._FaceOperationInfo = None
        self._TagOperationInfo = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def FaceOperationInfo(self):
        return self._FaceOperationInfo

    @FaceOperationInfo.setter
    def FaceOperationInfo(self, FaceOperationInfo):
        self._FaceOperationInfo = FaceOperationInfo

    @property
    def TagOperationInfo(self):
        return self._TagOperationInfo

    @TagOperationInfo.setter
    def TagOperationInfo(self, TagOperationInfo):
        self._TagOperationInfo = TagOperationInfo


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        self._Usages = params.get("Usages")
        if params.get("FaceOperationInfo") is not None:
            self._FaceOperationInfo = AiSampleFaceOperation()
            self._FaceOperationInfo._deserialize(params.get("FaceOperationInfo"))
        if params.get("TagOperationInfo") is not None:
            self._TagOperationInfo = AiSampleTagOperation()
            self._TagOperationInfo._deserialize(params.get("TagOperationInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyPersonSampleResponse(AbstractModel):
    """ModifyPersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _Person: Image information
        :type Person: :class:`tencentcloud.mps.v20190612.models.AiSamplePerson`
        :param _FailFaceInfoSet: Information of images that failed the verification by facial feature positioning.
Note: this field may return `null`, indicating that no valid values can be obtained.
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class ModifySampleSnapshotTemplateRequest(AbstractModel):
    """ModifySampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _Name: Name of a sampled screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _SampleType: Sampled screencapturing type. Valid values:
<li>Percent: By percent.</li>
<li>Time: By time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _Format: The image format. Valid values: jpg, png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._SampleType = None
        self._SampleInterval = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySampleSnapshotTemplateResponse(AbstractModel):
    """ModifySampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyScheduleRequest(AbstractModel):
    """ModifySchedule request structure.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        :param _ScheduleName: The scheme name.
        :type ScheduleName: str
        :param _Trigger: The trigger of the scheme.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: The subtasks of the scheme.
Note: You need to pass in the full list of subtasks even if you want to change only some of the subtasks.
        :type Activities: list of Activity
        :param _OutputStorage: The bucket to save the output file.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`.
Note: If this parameter is left empty, the current `OutputDir` value will be invalidated.
        :type OutputDir: str
        :param _TaskNotifyConfig: The notification configuration.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        self._ScheduleId = None
        self._ScheduleName = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def ScheduleName(self):
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._ScheduleName = params.get("ScheduleName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyScheduleResponse(AbstractModel):
    """ModifySchedule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifySnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """ModifySnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        :param _Name: Name of a time point screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Image width in px. Value range: [128, 4,096].
        :type Width: int
        :param _Height: Image height in px. Value range: [128, 4,096].
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values: jpg, png, webp.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Definition = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifySnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """ModifySnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyTranscodeTemplateRequest(AbstractModel):
    """ModifyTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding template.
        :type Definition: int
        :param _Container: Container format. Valid values: mp4; flv; hls; mp3; flac; ogg; m4a. Among them, mp3, flac, ogg, and m4a are for audio files.
        :type Container: str
        :param _Name: Name of a transcoding template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: Retain</li>
<li>1: Remove</li>
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter.
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfoForUpdate`
        :param _AudioTemplate: Audio stream configuration parameter.
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfoForUpdate`
        :param _TEHDConfig: TESHD transcoding parameter. To enable it, please contact your Tencent Cloud sales rep.
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfigForUpdate`
        :param _EnhanceConfig: Audio/Video enhancement settings.
        :type EnhanceConfig: :class:`tencentcloud.mps.v20190612.models.EnhanceConfig`
        """
        self._Definition = None
        self._Container = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._EnhanceConfig = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def EnhanceConfig(self):
        return self._EnhanceConfig

    @EnhanceConfig.setter
    def EnhanceConfig(self, EnhanceConfig):
        self._EnhanceConfig = EnhanceConfig


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Container = params.get("Container")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfoForUpdate()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfoForUpdate()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfigForUpdate()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("EnhanceConfig") is not None:
            self._EnhanceConfig = EnhanceConfig()
            self._EnhanceConfig._deserialize(params.get("EnhanceConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyTranscodeTemplateResponse(AbstractModel):
    """ModifyTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ModifyWatermarkTemplateRequest(AbstractModel):
    """ModifyWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a watermarking template.
        :type Definition: int
        :param _Name: Watermarking template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _CoordinateOrigin: Origin position. Valid values:
<li>TopLeft: The origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text;</li>
<li>TopRight: The origin of coordinates is in the top-right corner of the video, and the origin of the watermark is in the top-right corner of the image or text;</li>
<li>BottomLeft: The origin of coordinates is in the bottom-left corner of the video, and the origin of the watermark is in the bottom-left corner of the image or text;</li>
<li>BottomRight: The origin of coordinates is in the bottom-right corner of the video, and the origin of the watermark is in the bottom-right corner of the image or text.</li>
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
        :type XPos: str
        :param _YPos: The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
        :type YPos: str
        :param _ImageTemplate: Image watermarking template. This field is valid only for image watermarking templates.
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.ImageWatermarkInputForUpdate`
        :param _TextTemplate: Text watermarking template. This field is valid only for text watermarking templates.
        :type TextTemplate: :class:`tencentcloud.mps.v20190612.models.TextWatermarkTemplateInputForUpdate`
        :param _SvgTemplate: SVG watermarking template. This field is required when `Type` is `svg` and is invalid when `Type` is `image` or `text`.
        :type SvgTemplate: :class:`tencentcloud.mps.v20190612.models.SvgWatermarkInputForUpdate`
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInputForUpdate()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInputForUpdate()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInputForUpdate()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWatermarkTemplateResponse(AbstractModel):
    """ModifyWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _ImageUrl: Image watermark address. This field is valid only when `ImageTemplate.ImageContent` is non-empty.
        :type ImageUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageUrl = None
        self._RequestId = None

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class ModifyWordSampleRequest(AbstractModel):
    """ModifyWordSample request structure.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword. Length limit: 128 characters.
        :type Keyword: str
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
7. All: equivalent to 1+2+3+4
        :type Usages: list of str
        :param _TagOperationInfo: Tag operation information.
        :type TagOperationInfo: :class:`tencentcloud.mps.v20190612.models.AiSampleTagOperation`
        """
        self._Keyword = None
        self._Usages = None
        self._TagOperationInfo = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def TagOperationInfo(self):
        return self._TagOperationInfo

    @TagOperationInfo.setter
    def TagOperationInfo(self, TagOperationInfo):
        self._TagOperationInfo = TagOperationInfo


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Usages = params.get("Usages")
        if params.get("TagOperationInfo") is not None:
            self._TagOperationInfo = AiSampleTagOperation()
            self._TagOperationInfo._deserialize(params.get("TagOperationInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ModifyWordSampleResponse(AbstractModel):
    """ModifyWordSample response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class MosaicInput(AbstractModel):
    """The mosaic effect parameters to use in a media processing task.

    """

    def __init__(self):
        r"""
        :param _CoordinateOrigin: Origin position, which currently can only be:
<li>TopLeft: the origin of coordinates is in the top-left corner of the video, and the origin of the blur is in the top-left corner of the image or text.</li>
Default value: TopLeft.
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the blur relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the blur will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the blur will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :type XPos: str
        :param _YPos: Vertical position of the origin of blur relative to the origin of coordinates of video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the blur will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the blur will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :type YPos: str
        :param _Width: Blur width. % and px formats are supported:
<li>If the string ends in %, the `Width` of the blur will be the specified percentage of the video width; for example, `10%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in px, the `Width` of the blur will be in px; for example, `100px` means that `Width` is 100 px.</li>
Default value: 10%.
        :type Width: str
        :param _Height: Blur height. % and px formats are supported:
<li>If the string ends in %, the `Height` of the blur will be the specified percentage of the video height; for example, `10%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in px, the `Height` of the blur will be in px; for example, `100px` means that `Height` is 100 px.</li>
Default value: 10%.
        :type Height: str
        :param _StartTimeOffset: Start time offset of blur in seconds. If this parameter is left empty or 0 is entered, the blur will appear upon the first video frame.
<li>If this parameter is left empty or 0 is entered, the blur will appear upon the first video frame;</li>
<li>If this value is greater than 0 (e.g., n), the blur will appear at second n after the first video frame;</li>
<li>If this value is smaller than 0 (e.g., -n), the blur will appear at second n before the last video frame.</li>
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of blur in seconds.
<li>If this parameter is left empty or 0 is entered, the blur will exist till the last video frame;</li>
<li>If this value is greater than 0 (e.g., n), the blur will exist till second n;</li>
<li>If this value is smaller than 0 (e.g., -n), the blur will exist till second n before the last video frame.</li>
        :type EndTimeOffset: float
        """
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._Width = None
        self._Height = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class NumberFormat(AbstractModel):
    """Rule of the `{number}` variable in the output file name.

    """

    def __init__(self):
        r"""
        :param _InitialValue: Start value of the `{number}` variable. Default value: 0.
        :type InitialValue: int
        :param _Increment: Increment of the `{number}` variable. Default value: 1.
        :type Increment: int
        :param _MinLength: Minimum length of the `{number}` variable. A placeholder will be used if the variable length is below the minimum requirement. Default value: 1.
        :type MinLength: int
        :param _PlaceHolder: Placeholder used when the `{number}` variable length is below the minimum requirement. Default value: 0.
        :type PlaceHolder: str
        """
        self._InitialValue = None
        self._Increment = None
        self._MinLength = None
        self._PlaceHolder = None

    @property
    def InitialValue(self):
        return self._InitialValue

    @InitialValue.setter
    def InitialValue(self, InitialValue):
        self._InitialValue = InitialValue

    @property
    def Increment(self):
        return self._Increment

    @Increment.setter
    def Increment(self, Increment):
        self._Increment = Increment

    @property
    def MinLength(self):
        return self._MinLength

    @MinLength.setter
    def MinLength(self, MinLength):
        self._MinLength = MinLength

    @property
    def PlaceHolder(self):
        return self._PlaceHolder

    @PlaceHolder.setter
    def PlaceHolder(self, PlaceHolder):
        self._PlaceHolder = PlaceHolder


    def _deserialize(self, params):
        self._InitialValue = params.get("InitialValue")
        self._Increment = params.get("Increment")
        self._MinLength = params.get("MinLength")
        self._PlaceHolder = params.get("PlaceHolder")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrFullTextConfigureInfo(AbstractModel):
    """Control parameter of a full text recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full text recognition task. Valid values:
<li>ON: Enables an intelligent full text recognition task;</li>
<li>OFF: Disables an intelligent full text recognition task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrFullTextConfigureInfoForUpdate(AbstractModel):
    """Control parameter of a full text recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a full text recognition task. Valid values:
<li>ON: Enables an intelligent full text recognition task;</li>
<li>OFF: Disables an intelligent full text recognition task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrWordsConfigureInfo(AbstractModel):
    """Text keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a text keyword recognition task. Valid values:
<li>ON: Enables a text keyword recognition task;</li>
<li>OFF: Disables a text keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OcrWordsConfigureInfoForUpdate(AbstractModel):
    """Text keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a text keyword recognition task. Valid values:
<li>ON: Enables a text keyword recognition task;</li>
<li>OFF: Disables a text keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class OverrideTranscodeParameter(AbstractModel):
    """Custom specification parameters for video processing, which are used to override corresponding parameters in templates.

    """

    def __init__(self):
        r"""
        :param _Container: Container format. Valid values: mp4, flv, hls, mp3, flac, ogg, and m4a; mp3, flac, ogg, and m4a are formats of audio files.
        :type Container: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter.
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfoForUpdate`
        :param _AudioTemplate: Audio stream configuration parameter.
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfoForUpdate`
        :param _TEHDConfig: The TSC transcoding parameters.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfigForUpdate`
        :param _SubtitleTemplate: The subtitle settings.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubtitleTemplate: :class:`tencentcloud.mps.v20190612.models.SubtitleTemplate`
        :param _AddonAudioStream: The information of the external audio track to add.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AddonAudioStream: list of MediaInputInfo
        :param _StdExtInfo: An extended field for transcoding.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type StdExtInfo: str
        :param _AddOnSubtitles: The subtitle file to add.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type AddOnSubtitles: list of AddOnSubtitle
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._SubtitleTemplate = None
        self._AddonAudioStream = None
        self._StdExtInfo = None
        self._AddOnSubtitles = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def SubtitleTemplate(self):
        return self._SubtitleTemplate

    @SubtitleTemplate.setter
    def SubtitleTemplate(self, SubtitleTemplate):
        self._SubtitleTemplate = SubtitleTemplate

    @property
    def AddonAudioStream(self):
        return self._AddonAudioStream

    @AddonAudioStream.setter
    def AddonAudioStream(self, AddonAudioStream):
        self._AddonAudioStream = AddonAudioStream

    @property
    def StdExtInfo(self):
        return self._StdExtInfo

    @StdExtInfo.setter
    def StdExtInfo(self, StdExtInfo):
        self._StdExtInfo = StdExtInfo

    @property
    def AddOnSubtitles(self):
        return self._AddOnSubtitles

    @AddOnSubtitles.setter
    def AddOnSubtitles(self, AddOnSubtitles):
        self._AddOnSubtitles = AddOnSubtitles


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfoForUpdate()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfoForUpdate()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfigForUpdate()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        if params.get("SubtitleTemplate") is not None:
            self._SubtitleTemplate = SubtitleTemplate()
            self._SubtitleTemplate._deserialize(params.get("SubtitleTemplate"))
        if params.get("AddonAudioStream") is not None:
            self._AddonAudioStream = []
            for item in params.get("AddonAudioStream"):
                obj = MediaInputInfo()
                obj._deserialize(item)
                self._AddonAudioStream.append(obj)
        self._StdExtInfo = params.get("StdExtInfo")
        if params.get("AddOnSubtitles") is not None:
            self._AddOnSubtitles = []
            for item in params.get("AddOnSubtitles"):
                obj = AddOnSubtitle()
                obj._deserialize(item)
                self._AddOnSubtitles.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseLiveStreamProcessNotificationRequest(AbstractModel):
    """ParseLiveStreamProcessNotification request structure.

    """

    def __init__(self):
        r"""
        :param _Content: Live stream event notification obtained from CMQ.
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseLiveStreamProcessNotificationResponse(AbstractModel):
    """ParseLiveStreamProcessNotification response structure.

    """

    def __init__(self):
        r"""
        :param _NotificationType: Result type of live stream processing. Valid values:
<li>AiReviewResult: Content audit result;</li>
<li>ProcessEof: Live stream processing has been completed.</li>
        :type NotificationType: str
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        :param _ProcessEofInfo: Information of a live stream processing error, which is valid when `NotificationType` is `ProcessEof`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ProcessEofInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamProcessErrorInfo`
        :param _AiReviewResultInfo: Content audit result, which is valid when `NotificationType` is `AiReviewResult`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AiReviewResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiReviewResultInfo`
        :param _AiRecognitionResultInfo: Content recognition result, which is valid if `NotificationType` is `AiRecognitionResult`.
        :type AiRecognitionResultInfo: :class:`tencentcloud.mps.v20190612.models.LiveStreamAiRecognitionResultInfo`
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._NotificationType = None
        self._TaskId = None
        self._ProcessEofInfo = None
        self._AiReviewResultInfo = None
        self._AiRecognitionResultInfo = None
        self._SessionId = None
        self._SessionContext = None
        self._RequestId = None

    @property
    def NotificationType(self):
        return self._NotificationType

    @NotificationType.setter
    def NotificationType(self, NotificationType):
        self._NotificationType = NotificationType

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ProcessEofInfo(self):
        return self._ProcessEofInfo

    @ProcessEofInfo.setter
    def ProcessEofInfo(self, ProcessEofInfo):
        self._ProcessEofInfo = ProcessEofInfo

    @property
    def AiReviewResultInfo(self):
        return self._AiReviewResultInfo

    @AiReviewResultInfo.setter
    def AiReviewResultInfo(self, AiReviewResultInfo):
        self._AiReviewResultInfo = AiReviewResultInfo

    @property
    def AiRecognitionResultInfo(self):
        return self._AiRecognitionResultInfo

    @AiRecognitionResultInfo.setter
    def AiRecognitionResultInfo(self, AiRecognitionResultInfo):
        self._AiRecognitionResultInfo = AiRecognitionResultInfo

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._NotificationType = params.get("NotificationType")
        self._TaskId = params.get("TaskId")
        if params.get("ProcessEofInfo") is not None:
            self._ProcessEofInfo = LiveStreamProcessErrorInfo()
            self._ProcessEofInfo._deserialize(params.get("ProcessEofInfo"))
        if params.get("AiReviewResultInfo") is not None:
            self._AiReviewResultInfo = LiveStreamAiReviewResultInfo()
            self._AiReviewResultInfo._deserialize(params.get("AiReviewResultInfo"))
        if params.get("AiRecognitionResultInfo") is not None:
            self._AiRecognitionResultInfo = LiveStreamAiRecognitionResultInfo()
            self._AiRecognitionResultInfo._deserialize(params.get("AiRecognitionResultInfo"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._RequestId = params.get("RequestId")


class ParseNotificationRequest(AbstractModel):
    """ParseNotification request structure.

    """

    def __init__(self):
        r"""
        :param _Content: Event notification obtained from CMQ.
        :type Content: str
        """
        self._Content = None

    @property
    def Content(self):
        return self._Content

    @Content.setter
    def Content(self, Content):
        self._Content = Content


    def _deserialize(self, params):
        self._Content = params.get("Content")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ParseNotificationResponse(AbstractModel):
    """ParseNotification response structure.

    """

    def __init__(self):
        r"""
        :param _EventType: The event type. Valid values:
<li>WorkflowTask</li>
<li>EditMediaTask</li>
<li>ScheduleTask (scheme)</li>
        :type EventType: str
        :param _WorkflowTaskEvent: The information of a video processing task. Information will be returned only if `EventType` is `WorkflowTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WorkflowTaskEvent: :class:`tencentcloud.mps.v20190612.models.WorkflowTask`
        :param _EditMediaTaskEvent: The information of a video editing task. Information will be returned only if `EventType` is `EditMediaTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EditMediaTaskEvent: :class:`tencentcloud.mps.v20190612.models.EditMediaTask`
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _ScheduleTaskEvent: The information of a scheme. Information will be returned only if `EventType` is `ScheduleTask`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScheduleTaskEvent: :class:`tencentcloud.mps.v20190612.models.ScheduleTask`
        :param _Timestamp: - The expiration time (Unix timestamp) of the notification's signature.
- By default, notifications sent by MPS expire after 10 minutes. If the expiration time specified has elapsed, a notification will be considered invalid. This can prevent replay attacks.
- The format of this parameter is a decimal Unix timestamp, i.e., the number of seconds that have elapsed since 00:00 (UTC/GMT time) on January 1, 1970.

        :type Timestamp: int
        :param _Sign: The notification signature. Sign = MD5 (Timestamp + NotifyKey) MPS concatenates `Timestamp` and `NotifyKey` in `TaskNotifyConfig` and calculates a signature using the MD5 algorithm. This signature is included in the notification sent to your backend server. If the signature in the notification matches your own calculation result, it indicates that the notification is from MPS.
        :type Sign: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventType = None
        self._WorkflowTaskEvent = None
        self._EditMediaTaskEvent = None
        self._SessionId = None
        self._SessionContext = None
        self._ScheduleTaskEvent = None
        self._Timestamp = None
        self._Sign = None
        self._RequestId = None

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def WorkflowTaskEvent(self):
        return self._WorkflowTaskEvent

    @WorkflowTaskEvent.setter
    def WorkflowTaskEvent(self, WorkflowTaskEvent):
        self._WorkflowTaskEvent = WorkflowTaskEvent

    @property
    def EditMediaTaskEvent(self):
        return self._EditMediaTaskEvent

    @EditMediaTaskEvent.setter
    def EditMediaTaskEvent(self, EditMediaTaskEvent):
        self._EditMediaTaskEvent = EditMediaTaskEvent

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ScheduleTaskEvent(self):
        return self._ScheduleTaskEvent

    @ScheduleTaskEvent.setter
    def ScheduleTaskEvent(self, ScheduleTaskEvent):
        self._ScheduleTaskEvent = ScheduleTaskEvent

    @property
    def Timestamp(self):
        return self._Timestamp

    @Timestamp.setter
    def Timestamp(self, Timestamp):
        self._Timestamp = Timestamp

    @property
    def Sign(self):
        return self._Sign

    @Sign.setter
    def Sign(self, Sign):
        self._Sign = Sign

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._EventType = params.get("EventType")
        if params.get("WorkflowTaskEvent") is not None:
            self._WorkflowTaskEvent = WorkflowTask()
            self._WorkflowTaskEvent._deserialize(params.get("WorkflowTaskEvent"))
        if params.get("EditMediaTaskEvent") is not None:
            self._EditMediaTaskEvent = EditMediaTask()
            self._EditMediaTaskEvent._deserialize(params.get("EditMediaTaskEvent"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        if params.get("ScheduleTaskEvent") is not None:
            self._ScheduleTaskEvent = ScheduleTask()
            self._ScheduleTaskEvent._deserialize(params.get("ScheduleTaskEvent"))
        self._Timestamp = params.get("Timestamp")
        self._Sign = params.get("Sign")
        self._RequestId = params.get("RequestId")


class PoliticalAsrReviewTemplateInfo(AbstractModel):
    """The parameters for detecting sensitive information based on ASR.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information based on ASR. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalAsrReviewTemplateInfoForUpdate(AbstractModel):
    """The parameters for detecting sensitive information based on ASR.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information based on ASR. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalConfigureInfo(AbstractModel):
    """The parameters for detecting sensitive information.

    """

    def __init__(self):
        r"""
        :param _ImgReviewInfo: The parameters for detecting sensitive information in images.
        :type ImgReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalImgReviewTemplateInfo`
        :param _AsrReviewInfo: The parameters for detecting sensitive information based on ASR.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalAsrReviewTemplateInfo`
        :param _OcrReviewInfo: The parameters for detecting sensitive information based on OCR.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalOcrReviewTemplateInfo`
        """
        self._ImgReviewInfo = None
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def ImgReviewInfo(self):
        return self._ImgReviewInfo

    @ImgReviewInfo.setter
    def ImgReviewInfo(self, ImgReviewInfo):
        self._ImgReviewInfo = ImgReviewInfo

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("ImgReviewInfo") is not None:
            self._ImgReviewInfo = PoliticalImgReviewTemplateInfo()
            self._ImgReviewInfo._deserialize(params.get("ImgReviewInfo"))
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = PoliticalAsrReviewTemplateInfo()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = PoliticalOcrReviewTemplateInfo()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalConfigureInfoForUpdate(AbstractModel):
    """The parameters for detecting sensitive information.

    """

    def __init__(self):
        r"""
        :param _ImgReviewInfo: The parameters for detecting sensitive information in images.
        :type ImgReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalImgReviewTemplateInfoForUpdate`
        :param _AsrReviewInfo: The parameters for detecting sensitive information based on ASR.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalAsrReviewTemplateInfoForUpdate`
        :param _OcrReviewInfo: The parameters for detecting sensitive information based on OCR.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PoliticalOcrReviewTemplateInfoForUpdate`
        """
        self._ImgReviewInfo = None
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def ImgReviewInfo(self):
        return self._ImgReviewInfo

    @ImgReviewInfo.setter
    def ImgReviewInfo(self, ImgReviewInfo):
        self._ImgReviewInfo = ImgReviewInfo

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("ImgReviewInfo") is not None:
            self._ImgReviewInfo = PoliticalImgReviewTemplateInfoForUpdate()
            self._ImgReviewInfo._deserialize(params.get("ImgReviewInfo"))
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = PoliticalAsrReviewTemplateInfoForUpdate()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = PoliticalOcrReviewTemplateInfoForUpdate()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalImgReviewTemplateInfo(AbstractModel):
    """The parameters for detecting sensitive information in images.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information in images. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _LabelSet: The filter labels for sensitive information detection in images, which specify the types of sensitive information to return. If this parameter is left empty, the detection results for all labels are returned. Valid values:
<li>violation_photo (banned icons)</li>
<li>politician</li>
<li>entertainment (people in the entertainment industry)</li>
<li>sport (people in the sports industry)</li>
<li>entrepreneur</li>
<li>scholar</li>
<li>celebrity</li>
<li>military (people in military)</li>
        :type LabelSet: list of str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 97 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 95 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._LabelSet = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalImgReviewTemplateInfoForUpdate(AbstractModel):
    """The parameters for detecting sensitive information in images.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information in images. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _LabelSet: The filter labels for sensitive information detection in images, which specify the types of sensitive information to return. If this parameter is left empty, the detection results for all labels are returned. Valid values:
<li>violation_photo (banned icons)</li>
<li>politician</li>
<li>entertainment (people in the entertainment industry)</li>
<li>sport (people in the sports industry)</li>
<li>entrepreneur</li>
<li>scholar</li>
<li>celebrity</li>
<li>military (people in military)</li>
        :type LabelSet: list of str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._LabelSet = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalOcrReviewTemplateInfo(AbstractModel):
    """The parameters for detecting sensitive information based on OCR.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information based on OCR. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PoliticalOcrReviewTemplateInfoForUpdate(AbstractModel):
    """The parameters for detecting sensitive information based on OCR.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to detect sensitive information based on OCR. Valid values:
<li>ON</li>
<li>OFF</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornAsrReviewTemplateInfo(AbstractModel):
    """Control parameter of a porn information detection in speech task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in speech task. Valid values:
<li>ON: Enables a porn information detection in speech task;</li>
<li>OFF: Disables a porn information detection in speech task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornAsrReviewTemplateInfoForUpdate(AbstractModel):
    """Control parameter of a porn information detection in speech task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in speech task. Valid values:
<li>ON: Enables a porn information detection in speech task;</li>
<li>OFF: Disables a porn information detection in speech task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornConfigureInfo(AbstractModel):
    """Control parameter of a porn information detection task

    """

    def __init__(self):
        r"""
        :param _ImgReviewInfo: Control parameter of porn information detection in image.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImgReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornImgReviewTemplateInfo`
        :param _AsrReviewInfo: Control parameter of porn information detection in speech.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornAsrReviewTemplateInfo`
        :param _OcrReviewInfo: Control parameter of porn information detection in text.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornOcrReviewTemplateInfo`
        """
        self._ImgReviewInfo = None
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def ImgReviewInfo(self):
        return self._ImgReviewInfo

    @ImgReviewInfo.setter
    def ImgReviewInfo(self, ImgReviewInfo):
        self._ImgReviewInfo = ImgReviewInfo

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("ImgReviewInfo") is not None:
            self._ImgReviewInfo = PornImgReviewTemplateInfo()
            self._ImgReviewInfo._deserialize(params.get("ImgReviewInfo"))
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = PornAsrReviewTemplateInfo()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = PornOcrReviewTemplateInfo()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornConfigureInfoForUpdate(AbstractModel):
    """Control parameter of a porn information detection task.

    """

    def __init__(self):
        r"""
        :param _ImgReviewInfo: Control parameter of porn information detection in image.
        :type ImgReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornImgReviewTemplateInfoForUpdate`
        :param _AsrReviewInfo: Control parameter of porn information detection in speech.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornAsrReviewTemplateInfoForUpdate`
        :param _OcrReviewInfo: Control parameter of porn information detection in text.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.PornOcrReviewTemplateInfoForUpdate`
        """
        self._ImgReviewInfo = None
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def ImgReviewInfo(self):
        return self._ImgReviewInfo

    @ImgReviewInfo.setter
    def ImgReviewInfo(self, ImgReviewInfo):
        self._ImgReviewInfo = ImgReviewInfo

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("ImgReviewInfo") is not None:
            self._ImgReviewInfo = PornImgReviewTemplateInfoForUpdate()
            self._ImgReviewInfo._deserialize(params.get("ImgReviewInfo"))
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = PornAsrReviewTemplateInfoForUpdate()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = PornOcrReviewTemplateInfoForUpdate()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornImgReviewTemplateInfo(AbstractModel):
    """Control parameter of a porn information detection in image task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in image task. Valid values:
<li>ON: Enables a porn information detection in image task;</li>
<li>OFF: Disables a porn information detection in image task.</li>
        :type Switch: str
        :param _LabelSet: Filter tag for porn information detection in image. If an audit result contains the selected tag, it will be returned; if the filter tag is empty, all audit results will be returned. Valid values:
<li>porn: Porn;</li>
<li>vulgar: Vulgarity;</li>
<li>intimacy: Intimacy;</li>
<li>sexy: Sexiness.</li>
        :type LabelSet: list of str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 90 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 0 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._LabelSet = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornImgReviewTemplateInfoForUpdate(AbstractModel):
    """Control parameter of a porn information detection in image task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in image task. Valid values:
<li>ON: Enables a porn information detection in image task;</li>
<li>OFF: Disables a porn information detection in image task.</li>
        :type Switch: str
        :param _LabelSet: Filter tag for porn information detection in image. If an audit result contains the selected tag, it will be returned; if the filter tag is empty, all audit results will be returned. Valid values:
<li>porn: Porn;</li>
<li>vulgar: Vulgarity;</li>
<li>intimacy: Intimacy;</li>
<li>sexy: Sexiness.</li>
        :type LabelSet: list of str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._LabelSet = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornOcrReviewTemplateInfo(AbstractModel):
    """Control parameter of a porn information detection in text task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in text task. Valid values:
<li>ON: Enables a porn information detection in text task;</li>
<li>OFF: Disables a porn information detection in text task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class PornOcrReviewTemplateInfoForUpdate(AbstractModel):
    """Control parameter of a porn information detection in text task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of a porn information detection in text task. Valid values:
<li>ON: Enables a porn information detection in text task;</li>
<li>OFF: Disables a porn information detection in text task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. Value range: 0-100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. Value range: 0-100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessLiveStreamRequest(AbstractModel):
    """ProcessLiveStream request structure.

    """

    def __init__(self):
        r"""
        :param _Url: Live stream URL, which must be a live stream file address. RTMP, HLS, and FLV are supported.
        :type Url: str
        :param _TaskNotifyConfig: Event notification information of a task, which is used to specify the live stream processing result.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.LiveStreamTaskNotifyConfig`
        :param _OutputStorage: Target bucket of a live stream processing output file. This parameter is required if a file will be output.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: Target directory of a live stream processing output file, such as `/movie/201909/`. If this parameter is left empty, the `/` directory will be used.
        :type OutputDir: str
        :param _AiContentReviewTask: Type parameter of a video content audit task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiRecognitionTask: Type parameter of video content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _AiAnalysisTask: 
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiQualityControlTask: 
        :type AiQualityControlTask: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _ScheduleId: The live scheme ID.
Note 1:
<li>If an output storage (`OutputStorage`) and directory (`OutputDir`) are specified for a subtask of the scheme, those output settings will be applied. </li>
u200c<li>If an output storage (`OutputStorage`) and directory (`OutputDir`) are not specified for a subtask of the scheme, the output parameters specified for `ProcessLiveStream` (if any) will be applied. </li>
Note 2: If `TaskNotifyConfig` is specified when `ProcessLiveStream` is called, the specified settings will be applied instead of the default callback settings of the scheme.
        :type ScheduleId: int
        """
        self._Url = None
        self._TaskNotifyConfig = None
        self._OutputStorage = None
        self._OutputDir = None
        self._AiContentReviewTask = None
        self._AiRecognitionTask = None
        self._AiAnalysisTask = None
        self._AiQualityControlTask = None
        self._SessionId = None
        self._SessionContext = None
        self._ScheduleId = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiQualityControlTask(self):
        return self._AiQualityControlTask

    @AiQualityControlTask.setter
    def AiQualityControlTask(self, AiQualityControlTask):
        self._AiQualityControlTask = AiQualityControlTask

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = LiveStreamTaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiQualityControlTask") is not None:
            self._AiQualityControlTask = AiQualityControlTaskInput()
            self._AiQualityControlTask._deserialize(params.get("AiQualityControlTask"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._ScheduleId = params.get("ScheduleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessLiveStreamResponse(AbstractModel):
    """ProcessLiveStream response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ProcessMediaRequest(AbstractModel):
    """ProcessMedia request structure.

    """

    def __init__(self):
        r"""
        :param _InputInfo: The information of the file to process.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _OutputStorage: The storage location of the media processing output file. If this parameter is left empty, the storage location in `InputInfo` will be inherited.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the media processing output file, which must start and end with `/`, such as `/movie/201907/`.
If you do not specify this parameter, the file will be saved to the directory specified in `InputInfo`.
        :type OutputDir: str
        :param _ScheduleId: The scheme ID.
Note 1: About `OutputStorage` and `OutputDir`
<li>If an output storage and directory are specified for a subtask of the scheme, those output settings will be applied.</li>
<li>If an output storage and directory are not specified for the subtasks of a scheme, the output parameters passed in the `ProcessMedia` API will be applied.</li>
Note 2: If `TaskNotifyConfig` is specified, the specified settings will be used instead of the default callback settings of the scheme.

Note 3: The trigger configured for a scheme is for automatically starting a scheme. It stops working when you manually call this API to start a scheme.
        :type ScheduleId: int
        :param _MediaProcessTask: The media processing parameters to use.
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: Type parameter of a video content audit task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: Video content analysis task parameter.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: Type parameter of a video content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _AiQualityControlTask: The parameters of a quality control task.
        :type AiQualityControlTask: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        :param _TaskNotifyConfig: Event notification information of a task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _TasksPriority: Task flow priority. The higher the value, the higher the priority. Value range: [-10, 10]. If this parameter is left empty, 0 will be used.
        :type TasksPriority: int
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last three days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or an empty string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _TaskType: The task type.
<li> `Online` (default): A task that is executed immediately.</li>
<li> `Offline`: A task that is executed when the system is idle (within three days by default).</li>
        :type TaskType: str
        """
        self._InputInfo = None
        self._OutputStorage = None
        self._OutputDir = None
        self._ScheduleId = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._AiQualityControlTask = None
        self._TaskNotifyConfig = None
        self._TasksPriority = None
        self._SessionId = None
        self._SessionContext = None
        self._TaskType = None

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def MediaProcessTask(self):
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def AiQualityControlTask(self):
        return self._AiQualityControlTask

    @AiQualityControlTask.setter
    def AiQualityControlTask(self, AiQualityControlTask):
        self._AiQualityControlTask = AiQualityControlTask

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType


    def _deserialize(self, params):
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        self._ScheduleId = params.get("ScheduleId")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("AiQualityControlTask") is not None:
            self._AiQualityControlTask = AiQualityControlTaskInput()
            self._AiQualityControlTask._deserialize(params.get("AiQualityControlTask"))
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TaskType = params.get("TaskType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProcessMediaResponse(AbstractModel):
    """ProcessMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ProhibitedAsrReviewTemplateInfo(AbstractModel):
    """Control parameter of prohibited information detection in speech task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of prohibited information detection in speech task. Valid values:
<li>ON: enables prohibited information detection in speech task;</li>
<li>OFF: disables prohibited information detection in speech task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0–100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0–100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProhibitedAsrReviewTemplateInfoForUpdate(AbstractModel):
    """Control parameter of prohibited information detection in speech task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of prohibited information detection in speech task. Valid values:
<li>ON: enables prohibited information detection in speech task;</li>
<li>OFF: disables prohibited information detection in speech task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0–100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0–100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProhibitedConfigureInfo(AbstractModel):
    """Control parameter of prohibited information detection task

    """

    def __init__(self):
        r"""
        :param _AsrReviewInfo: Control parameter of prohibited information detection in speech.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.ProhibitedAsrReviewTemplateInfo`
        :param _OcrReviewInfo: Control parameter of prohibited information detection in text.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.ProhibitedOcrReviewTemplateInfo`
        """
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = ProhibitedAsrReviewTemplateInfo()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = ProhibitedOcrReviewTemplateInfo()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProhibitedConfigureInfoForUpdate(AbstractModel):
    """Control parameter of prohibited information detection task

    """

    def __init__(self):
        r"""
        :param _AsrReviewInfo: Control parameter of prohibited information detection in speech.
        :type AsrReviewInfo: :class:`tencentcloud.mps.v20190612.models.ProhibitedAsrReviewTemplateInfoForUpdate`
        :param _OcrReviewInfo: Control parameter of prohibited information detection in text.
        :type OcrReviewInfo: :class:`tencentcloud.mps.v20190612.models.ProhibitedOcrReviewTemplateInfoForUpdate`
        """
        self._AsrReviewInfo = None
        self._OcrReviewInfo = None

    @property
    def AsrReviewInfo(self):
        return self._AsrReviewInfo

    @AsrReviewInfo.setter
    def AsrReviewInfo(self, AsrReviewInfo):
        self._AsrReviewInfo = AsrReviewInfo

    @property
    def OcrReviewInfo(self):
        return self._OcrReviewInfo

    @OcrReviewInfo.setter
    def OcrReviewInfo(self, OcrReviewInfo):
        self._OcrReviewInfo = OcrReviewInfo


    def _deserialize(self, params):
        if params.get("AsrReviewInfo") is not None:
            self._AsrReviewInfo = ProhibitedAsrReviewTemplateInfoForUpdate()
            self._AsrReviewInfo._deserialize(params.get("AsrReviewInfo"))
        if params.get("OcrReviewInfo") is not None:
            self._OcrReviewInfo = ProhibitedOcrReviewTemplateInfoForUpdate()
            self._OcrReviewInfo._deserialize(params.get("OcrReviewInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProhibitedOcrReviewTemplateInfo(AbstractModel):
    """Control parameter of prohibited information detection in text task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of prohibited information detection in text task. Valid values:
<li>ON: enables prohibited information detection in text task;</li>
<li>OFF: disables prohibited information detection in text task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0–100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0–100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ProhibitedOcrReviewTemplateInfoForUpdate(AbstractModel):
    """Control parameter of prohibited information detection in text task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of prohibited information detection in text task. Valid values:
<li>ON: enables prohibited information detection in text task;</li>
<li>OFF: disables prohibited information detection in text task.</li>
        :type Switch: str
        :param _BlockConfidence: Threshold score for violation. If this score is reached or exceeded during intelligent audit, it will be deemed that a suspected violation has occurred. If this parameter is left empty, 100 will be used by default. Value range: 0–100.
        :type BlockConfidence: int
        :param _ReviewConfidence: Threshold score for human audit. If this score is reached or exceeded during intelligent audit, human audit will be considered necessary. If this parameter is left empty, 75 will be used by default. Value range: 0–100.
        :type ReviewConfidence: int
        """
        self._Switch = None
        self._BlockConfidence = None
        self._ReviewConfidence = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def BlockConfidence(self):
        return self._BlockConfidence

    @BlockConfidence.setter
    def BlockConfidence(self, BlockConfidence):
        self._BlockConfidence = BlockConfidence

    @property
    def ReviewConfidence(self):
        return self._ReviewConfidence

    @ReviewConfidence.setter
    def ReviewConfidence(self, ReviewConfidence):
        self._ReviewConfidence = ReviewConfidence


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._BlockConfidence = params.get("BlockConfidence")
        self._ReviewConfidence = params.get("ReviewConfidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QualityControlData(AbstractModel):
    """The quality check output.

    """

    def __init__(self):
        r"""
        :param _NoAudio: Whether there is an audio track. `true` indicates that there isn't.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NoAudio: bool
        :param _NoVideo: Whether there is a video track. `true` indicates that there isn't.
Note: This field may return null, indicating that no valid values can be obtained.
        :type NoVideo: bool
        :param _QualityEvaluationScore: The no-reference video quality score. Value range: 0-100.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QualityEvaluationScore: int
        :param _QualityControlResultSet: The issues detected by quality control.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QualityControlResultSet: list of QualityControlResult
        """
        self._NoAudio = None
        self._NoVideo = None
        self._QualityEvaluationScore = None
        self._QualityControlResultSet = None

    @property
    def NoAudio(self):
        return self._NoAudio

    @NoAudio.setter
    def NoAudio(self, NoAudio):
        self._NoAudio = NoAudio

    @property
    def NoVideo(self):
        return self._NoVideo

    @NoVideo.setter
    def NoVideo(self, NoVideo):
        self._NoVideo = NoVideo

    @property
    def QualityEvaluationScore(self):
        return self._QualityEvaluationScore

    @QualityEvaluationScore.setter
    def QualityEvaluationScore(self, QualityEvaluationScore):
        self._QualityEvaluationScore = QualityEvaluationScore

    @property
    def QualityControlResultSet(self):
        return self._QualityControlResultSet

    @QualityControlResultSet.setter
    def QualityControlResultSet(self, QualityControlResultSet):
        self._QualityControlResultSet = QualityControlResultSet


    def _deserialize(self, params):
        self._NoAudio = params.get("NoAudio")
        self._NoVideo = params.get("NoVideo")
        self._QualityEvaluationScore = params.get("QualityEvaluationScore")
        if params.get("QualityControlResultSet") is not None:
            self._QualityControlResultSet = []
            for item in params.get("QualityControlResultSet"):
                obj = QualityControlResult()
                obj._deserialize(item)
                self._QualityControlResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QualityControlItem(AbstractModel):
    """The information of a checked segment in quality control.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score. Value range: 0-100.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Confidence: int
        :param _StartTimeOffset: The start timestamp (second) of the segment.
        :type StartTimeOffset: float
        :param _EndTimeOffset: The end timestamp (second) of the segment.
        :type EndTimeOffset: float
        :param _AreaCoordSet: The coordinates (px) of the top left and bottom right corner.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AreaCoordSet: list of int
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._AreaCoordSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class QualityControlResult(AbstractModel):
    """The issues detected by quality control.

    """

    def __init__(self):
        r"""
        :param _Type: The issue type. Valid values:
`Jitter`
`Blur`
`LowLighting`
`HighLighting` (overexposure)
`CrashScreen` (video corruption)
`BlackWhiteEdge`
`SolidColorScreen` (blank screen)
`Noise`
`Mosaic` (pixelation)
`QRCode`
`AppletCode` (Weixin Mini Program code)
`BarCode`
`LowVoice`
`HighVoice`
`NoVoice`
`LowEvaluation` (low no-reference video quality score)
        :type Type: str
        :param _QualityControlItems: The information of a checked segment in quality control.
        :type QualityControlItems: list of QualityControlItem
        """
        self._Type = None
        self._QualityControlItems = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def QualityControlItems(self):
        return self._QualityControlItems

    @QualityControlItems.setter
    def QualityControlItems(self, QualityControlItems):
        self._QualityControlItems = QualityControlItems


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("QualityControlItems") is not None:
            self._QualityControlItems = []
            for item in params.get("QualityControlItems"):
                obj = QualityControlItem()
                obj._deserialize(item)
                self._QualityControlItems.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RawImageWatermarkInput(AbstractModel):
    """Input parameter of image watermark template

    """

    def __init__(self):
        r"""
        :param _ImageContent: Input content of watermark image. JPEG and PNG images are supported.
        :type ImageContent: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _Width: Watermark width. % and px formats are supported:
<li>If the string ends in %, the `Width` of the watermark will be the specified percentage of the video width; for example, `10%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in px, the `Width` of the watermark will be in px; for example, `100px` means that `Width` is 100 px.</li>
Default value: 10%.
        :type Width: str
        :param _Height: Watermark height. % and px formats are supported:
<li>If the string ends in %, the `Height` of the watermark will be the specified percentage of the video height; for example, `10%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in px, the `Height` of the watermark will be in px; for example, `100px` means that `Height` is 100 px.</li>
Default value: 0 px, which means that `Height` will be proportionally scaled according to the aspect ratio of the original watermark image.
        :type Height: str
        :param _RepeatType: Repeat type of an animated watermark. Valid values:
<li>`once`: no longer appears after watermark playback ends.</li>
<li>`repeat_last_frame`: stays on the last frame after watermark playback ends.</li>
<li>`repeat` (default): repeats the playback until the video ends.</li>
        :type RepeatType: str
        """
        self._ImageContent = None
        self._Width = None
        self._Height = None
        self._RepeatType = None

    @property
    def ImageContent(self):
        return self._ImageContent

    @ImageContent.setter
    def ImageContent(self, ImageContent):
        self._ImageContent = ImageContent

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def RepeatType(self):
        return self._RepeatType

    @RepeatType.setter
    def RepeatType(self, RepeatType):
        self._RepeatType = RepeatType


    def _deserialize(self, params):
        if params.get("ImageContent") is not None:
            self._ImageContent = MediaInputInfo()
            self._ImageContent._deserialize(params.get("ImageContent"))
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._RepeatType = params.get("RepeatType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RawTranscodeParameter(AbstractModel):
    """Specifications for custom transcoding

    """

    def __init__(self):
        r"""
        :param _Container: Container. Valid values: mp4; flv; hls; mp3; flac; ogg; m4a. Among them, mp3, flac, ogg, and m4a are for audio files.
        :type Container: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: retain;</li>
<li>1: remove.</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: retain;</li>
<li>1: remove.</li>
Default value: 0.
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter. This field is required when `RemoveVideo` is 0.
        :type VideoTemplate: :class:`tencentcloud.mps.v20190612.models.VideoTemplateInfo`
        :param _AudioTemplate: Audio stream configuration parameter. This field is required when `RemoveAudio` is 0.
        :type AudioTemplate: :class:`tencentcloud.mps.v20190612.models.AudioTemplateInfo`
        :param _TEHDConfig: TESHD transcoding parameter.
        :type TEHDConfig: :class:`tencentcloud.mps.v20190612.models.TEHDConfig`
        """
        self._Container = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class RawWatermarkParameter(AbstractModel):
    """Custom watermark specifications.

    """

    def __init__(self):
        r"""
        :param _Type: Watermark type. Valid values:
<li>image: image watermark.</li>
        :type Type: str
        :param _CoordinateOrigin: Origin position, which currently can only be:
<li>TopLeft: the origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text.</li>
Default value: TopLeft.
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :type XPos: str
        :param _YPos: The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :type YPos: str
        :param _ImageTemplate: Image watermark template. This field is required when `Type` is `image` and is invalid when `Type` is `text`.
        :type ImageTemplate: :class:`tencentcloud.mps.v20190612.models.RawImageWatermarkInput`
        """
        self._Type = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = RawImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetWorkflowRequest(AbstractModel):
    """ResetWorkflow request structure.

    """

    def __init__(self):
        r"""
        :param _WorkflowId: Workflow ID.
        :type WorkflowId: int
        :param _WorkflowName: Workflow name of up to 128 characters, which must be unique for the same user.
        :type WorkflowName: str
        :param _Trigger: Triggering rule bound to a workflow. If an uploaded video hits the rule for the object, the workflow will be triggered.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _OutputStorage: Output configuration of a video processing output file. If this parameter is left empty, the storage location in `Trigger` will be inherited.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: Target directory of a video processing output file, such as `/movie/201907/`. If this parameter is left empty, the file will be outputted to the same directory where the source file is located, i.e.; `{inputDir}`.
        :type OutputDir: str
        :param _MediaProcessTask: Parameter of a video processing task.
        :type MediaProcessTask: :class:`tencentcloud.mps.v20190612.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: Type parameter of a video content audit task.
        :type AiContentReviewTask: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: Video content analysis task parameter.
        :type AiAnalysisTask: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: Type parameter of a video content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _TaskPriority: Workflow priority. The higher the value, the higher the priority. Value range: [-10, 10]. If this parameter is left empty, 0 will be used.
        :type TaskPriority: int
        :param _TaskNotifyConfig: Event notification information of a task. If this parameter is left empty, no event notifications will be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        """
        self._WorkflowId = None
        self._WorkflowName = None
        self._Trigger = None
        self._OutputStorage = None
        self._OutputDir = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._TaskPriority = None
        self._TaskNotifyConfig = None

    @property
    def WorkflowId(self):
        return self._WorkflowId

    @WorkflowId.setter
    def WorkflowId(self, WorkflowId):
        self._WorkflowId = WorkflowId

    @property
    def WorkflowName(self):
        return self._WorkflowName

    @WorkflowName.setter
    def WorkflowName(self, WorkflowName):
        self._WorkflowName = WorkflowName

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def MediaProcessTask(self):
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def TaskPriority(self):
        return self._TaskPriority

    @TaskPriority.setter
    def TaskPriority(self, TaskPriority):
        self._TaskPriority = TaskPriority

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig


    def _deserialize(self, params):
        self._WorkflowId = params.get("WorkflowId")
        self._WorkflowName = params.get("WorkflowName")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        self._TaskPriority = params.get("TaskPriority")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ResetWorkflowResponse(AbstractModel):
    """ResetWorkflow response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class S3InputInfo(AbstractModel):
    """The AWS S3 storage information of a source file.

    """

    def __init__(self):
        r"""
        :param _S3Bucket: The AWS S3 bucket.
        :type S3Bucket: str
        :param _S3Region: The region of the AWS S3 bucket.
        :type S3Region: str
        :param _S3Object: The path of the AWS S3 object.
        :type S3Object: str
        :param _S3SecretId: The key ID required to access the AWS S3 object.
        :type S3SecretId: str
        :param _S3SecretKey: The key required to access the AWS S3 object.
        :type S3SecretKey: str
        """
        self._S3Bucket = None
        self._S3Region = None
        self._S3Object = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def S3Bucket(self):
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def S3Object(self):
        return self._S3Object

    @S3Object.setter
    def S3Object(self, S3Object):
        self._S3Object = S3Object

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._S3Object = params.get("S3Object")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class S3OutputStorage(AbstractModel):
    """The AWS S3 storage information of an output file.

    """

    def __init__(self):
        r"""
        :param _S3Bucket: The AWS S3 bucket.
        :type S3Bucket: str
        :param _S3Region: The region of the AWS S3 bucket.
        :type S3Region: str
        :param _S3SecretId: The key ID required to upload files to the AWS S3 object.
        :type S3SecretId: str
        :param _S3SecretKey: The key required to upload files to the AWS S3 object.
        :type S3SecretKey: str
        """
        self._S3Bucket = None
        self._S3Region = None
        self._S3SecretId = None
        self._S3SecretKey = None

    @property
    def S3Bucket(self):
        return self._S3Bucket

    @S3Bucket.setter
    def S3Bucket(self, S3Bucket):
        self._S3Bucket = S3Bucket

    @property
    def S3Region(self):
        return self._S3Region

    @S3Region.setter
    def S3Region(self, S3Region):
        self._S3Region = S3Region

    @property
    def S3SecretId(self):
        return self._S3SecretId

    @S3SecretId.setter
    def S3SecretId(self, S3SecretId):
        self._S3SecretId = S3SecretId

    @property
    def S3SecretKey(self):
        return self._S3SecretKey

    @S3SecretKey.setter
    def S3SecretKey(self, S3SecretKey):
        self._S3SecretKey = S3SecretKey


    def _deserialize(self, params):
        self._S3Bucket = params.get("S3Bucket")
        self._S3Region = params.get("S3Region")
        self._S3SecretId = params.get("S3SecretId")
        self._S3SecretKey = params.get("S3SecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SampleSnapshotTaskInput(AbstractModel):
    """Input parameter type of a sampled screencapturing task.

    """

    def __init__(self):
        r"""
        :param _Definition: Sampled screencapturing template ID.
        :type Definition: int
        :param _WatermarkSet: List of up to 10 image or text watermarks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WatermarkSet: list of WatermarkInput
        :param _OutputStorage: Target bucket of a sampled screenshot. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path to a generated sampled screenshot, which can be a relative path or an absolute path. If this parameter is left empty, the following relative path will be used by default: `{inputName}_sampleSnapshot_{definition}_{number}.{format}`.
        :type OutputObjectPath: str
        :param _ObjectNumberFormat: Rule of the `{number}` variable in the sampled screenshot output path.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ObjectNumberFormat: :class:`tencentcloud.mps.v20190612.models.NumberFormat`
        """
        self._Definition = None
        self._WatermarkSet = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._ObjectNumberFormat = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def ObjectNumberFormat(self):
        return self._ObjectNumberFormat

    @ObjectNumberFormat.setter
    def ObjectNumberFormat(self, ObjectNumberFormat):
        self._ObjectNumberFormat = ObjectNumberFormat


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        if params.get("ObjectNumberFormat") is not None:
            self._ObjectNumberFormat = NumberFormat()
            self._ObjectNumberFormat._deserialize(params.get("ObjectNumberFormat"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SampleSnapshotTemplate(AbstractModel):
    """Details of a sampled screencapturing template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Name of a sampled screencapturing template.
        :type Name: str
        :param _Comment: Template description.
        :type Comment: str
        :param _Width: Maximum value of the width (or long side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: Enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: Disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Image format.
        :type Format: str
        :param _SampleType: Sampled screencapturing type.
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
        :type SampleInterval: int
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: Stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: Fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: Fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: Fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._SampleType = None
        self._SampleInterval = None
        self._CreateTime = None
        self._UpdateTime = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleAnalysisTaskResult(AbstractModel):
    """The result of a content analysis task of a scheme.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. 0 indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the content analysis task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiAnalysisTaskInput`
        :param _Output: The output of the content analysis task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: list of AiAnalysisResult
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = []
            for item in params.get("Output"):
                obj = AiAnalysisResult()
                obj._deserialize(item)
                self._Output.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleQualityControlTaskResult(AbstractModel):
    """The result of a quality control task.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: `PROCESSING`, `SUCCESS`, `FAIL`.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value indicates the task has failed. For details, see [Error Codes](https://www.tencentcloud.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. `0` indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the quality control task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiQualityControlTaskInput`
        :param _Output: The output of the quality control task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.mps.v20190612.models.QualityControlData`
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiQualityControlTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = QualityControlData()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleRecognitionTaskResult(AbstractModel):
    """The result of a content recognition task of a scheme.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. 0 indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the content recognition task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiRecognitionTaskInput`
        :param _Output: The output of the content recognition task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: list of AiRecognitionResult
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = []
            for item in params.get("Output"):
                obj = AiRecognitionResult()
                obj._deserialize(item)
                self._Output.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleReviewTaskResult(AbstractModel):
    """The result of a content moderation task of a scheme.

    """

    def __init__(self):
        r"""
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; any other value returned indicates the task has failed. For details, see [Error Codes](https://intl.cloud.tencent.com/document/product/1041/40249).
        :type ErrCodeExt: str
        :param _ErrCode: The error code. 0 indicates the task is successful; other values indicate the task has failed. This parameter is not recommended. Please use `ErrCodeExt` instead.
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _Input: The input of the content moderation task.
        :type Input: :class:`tencentcloud.mps.v20190612.models.AiContentReviewTaskInput`
        :param _Output: The output of the content moderation task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: list of AiContentReviewResult
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiContentReviewTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = []
            for item in params.get("Output"):
                obj = AiContentReviewResult()
                obj._deserialize(item)
                self._Output.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScheduleTask(AbstractModel):
    """The information of a scheme.

    """

    def __init__(self):
        r"""
        :param _TaskId: The scheme ID.
        :type TaskId: str
        :param _Status: The scheme status. Valid values:
<li>PROCESSING</li>
<li>FINISH</li>
        :type Status: str
        :param _ErrCode: If the value returned is not 0, there was a source error. If 0 is returned, refer to the error codes of the corresponding task type.
        :type ErrCode: int
        :param _Message: If there was a source error, this parameter is the error message. For other errors, refer to the error messages of the corresponding task type.
        :type Message: str
        :param _InputInfo: The information of the file processed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type InputInfo: :class:`tencentcloud.mps.v20190612.models.MediaInputInfo`
        :param _MetaData: The metadata of the source video.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MetaData: :class:`tencentcloud.mps.v20190612.models.MediaMetaData`
        :param _ActivityResultSet: The output of the scheme.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ActivityResultSet: list of ActivityResult
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._InputInfo = None
        self._MetaData = None
        self._ActivityResultSet = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def InputInfo(self):
        return self._InputInfo

    @InputInfo.setter
    def InputInfo(self, InputInfo):
        self._InputInfo = InputInfo

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def ActivityResultSet(self):
        return self._ActivityResultSet

    @ActivityResultSet.setter
    def ActivityResultSet(self, ActivityResultSet):
        self._ActivityResultSet = ActivityResultSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("InputInfo") is not None:
            self._InputInfo = MediaInputInfo()
            self._InputInfo._deserialize(params.get("InputInfo"))
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        if params.get("ActivityResultSet") is not None:
            self._ActivityResultSet = []
            for item in params.get("ActivityResultSet"):
                obj = ActivityResult()
                obj._deserialize(item)
                self._ActivityResultSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SchedulesInfo(AbstractModel):
    """The details of a scheme.

    """

    def __init__(self):
        r"""
        :param _ScheduleId: The scheme ID.
        :type ScheduleId: int
        :param _ScheduleName: The scheme name.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScheduleName: str
        :param _Type: The scheme type. Valid values:
 <li>`Preset`</li>
<li>`Custom` </li>
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Status: The scheme status. Valid values:
`Enabled`
`Disabled`
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param _Trigger: The trigger of the scheme.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Trigger: :class:`tencentcloud.mps.v20190612.models.WorkflowTrigger`
        :param _Activities: The subtasks of the scheme.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Activities: list of Activity
        :param _OutputStorage: The bucket to save the output file.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputDir: The directory to save the output file.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputDir: str
        :param _TaskNotifyConfig: The notification configuration.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskNotifyConfig: :class:`tencentcloud.mps.v20190612.models.TaskNotifyConfig`
        :param _CreateTime: The creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid values can be obtained.
        :type CreateTime: str
        :param _UpdateTime: The last updated time in [ISO date format](https://intl.cloud.tencent.com/document/product/862/37710?from_cn_redirect=1#52).
Note: This field may return null, indicating that no valid values can be obtained.
        :type UpdateTime: str
        """
        self._ScheduleId = None
        self._ScheduleName = None
        self._Type = None
        self._Status = None
        self._Trigger = None
        self._Activities = None
        self._OutputStorage = None
        self._OutputDir = None
        self._TaskNotifyConfig = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def ScheduleId(self):
        return self._ScheduleId

    @ScheduleId.setter
    def ScheduleId(self, ScheduleId):
        self._ScheduleId = ScheduleId

    @property
    def ScheduleName(self):
        return self._ScheduleName

    @ScheduleName.setter
    def ScheduleName(self, ScheduleName):
        self._ScheduleName = ScheduleName

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Trigger(self):
        return self._Trigger

    @Trigger.setter
    def Trigger(self, Trigger):
        self._Trigger = Trigger

    @property
    def Activities(self):
        return self._Activities

    @Activities.setter
    def Activities(self, Activities):
        self._Activities = Activities

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputDir(self):
        return self._OutputDir

    @OutputDir.setter
    def OutputDir(self, OutputDir):
        self._OutputDir = OutputDir

    @property
    def TaskNotifyConfig(self):
        return self._TaskNotifyConfig

    @TaskNotifyConfig.setter
    def TaskNotifyConfig(self, TaskNotifyConfig):
        self._TaskNotifyConfig = TaskNotifyConfig

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._ScheduleId = params.get("ScheduleId")
        self._ScheduleName = params.get("ScheduleName")
        self._Type = params.get("Type")
        self._Status = params.get("Status")
        if params.get("Trigger") is not None:
            self._Trigger = WorkflowTrigger()
            self._Trigger._deserialize(params.get("Trigger"))
        if params.get("Activities") is not None:
            self._Activities = []
            for item in params.get("Activities"):
                obj = Activity()
                obj._deserialize(item)
                self._Activities.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputDir = params.get("OutputDir")
        if params.get("TaskNotifyConfig") is not None:
            self._TaskNotifyConfig = TaskNotifyConfig()
            self._TaskNotifyConfig._deserialize(params.get("TaskNotifyConfig"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ScratchRepairConfig(AbstractModel):
    """Banding removal configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Intensity: The strength. Value range: 0.0-1.0
Default value: 0.0
Note: This field may return null, indicating that no valid values can be obtained.
        :type Intensity: float
        """
        self._Switch = None
        self._Intensity = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Intensity(self):
        return self._Intensity

    @Intensity.setter
    def Intensity(self, Intensity):
        self._Intensity = Intensity


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Intensity = params.get("Intensity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SharpEnhanceConfig(AbstractModel):
    """Detail enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Intensity: The strength. Value range: 0.0-1.0
Default value: 0.0
Note: This field may return null, indicating that no valid values can be obtained.
        :type Intensity: float
        """
        self._Switch = None
        self._Intensity = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Intensity(self):
        return self._Intensity

    @Intensity.setter
    def Intensity(self, Intensity):
        self._Intensity = Intensity


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Intensity = params.get("Intensity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SimpleAesDrm(AbstractModel):
    """The AES-128 encryption details.

    """

    def __init__(self):
        r"""
        :param _Uri: The URI of decryption key.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Uri: str
        :param _Key: The encryption key (a 32-byte string).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Key: str
        :param _Vector: The initialization vector for encryption (a 32-byte string).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Vector: str
        """
        self._Uri = None
        self._Key = None
        self._Vector = None

    @property
    def Uri(self):
        return self._Uri

    @Uri.setter
    def Uri(self, Uri):
        self._Uri = Uri

    @property
    def Key(self):
        return self._Key

    @Key.setter
    def Key(self, Key):
        self._Key = Key

    @property
    def Vector(self):
        return self._Vector

    @Vector.setter
    def Vector(self, Vector):
        self._Vector = Vector


    def _deserialize(self, params):
        self._Uri = params.get("Uri")
        self._Key = params.get("Key")
        self._Vector = params.get("Vector")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SnapshotByTimeOffsetTaskInput(AbstractModel):
    """Input parameter type of a time point screencapturing task

    """

    def __init__(self):
        r"""
        :param _Definition: ID of a time point screencapturing template.
        :type Definition: int
        :param _ExtTimeOffsetSet: List of screenshot time points in the format of `s` or `%`:
<li>If the string ends in `s`, it means that the time point is in seconds; for example, `3.5s` means that the time point is the 3.5th second;</li>
<li>If the string ends in `%`, it means that the time point is the specified percentage of the video duration; for example, `10%` means that the time point is 10% of the video duration.</li>
        :type ExtTimeOffsetSet: list of str
        :param _TimeOffsetSet: List of time points of screenshots in <font color=red>seconds</font>.
        :type TimeOffsetSet: list of float
        :param _WatermarkSet: List of up to 10 image or text watermarks.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WatermarkSet: list of WatermarkInput
        :param _OutputStorage: Target bucket of a generated time point screenshot file. If this parameter is left empty, the `OutputStorage` value of the upper folder will be inherited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type OutputStorage: :class:`tencentcloud.mps.v20190612.models.TaskOutputStorage`
        :param _OutputObjectPath: Output path to a generated time point screenshot, which can be a relative path or an absolute path. If this parameter is left empty, the following relative path will be used by default: `{inputName}_snapshotByTimeOffset_{definition}_{number}.{format}`.
        :type OutputObjectPath: str
        :param _ObjectNumberFormat: Rule of the `{number}` variable in the time point screenshot output path.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ObjectNumberFormat: :class:`tencentcloud.mps.v20190612.models.NumberFormat`
        """
        self._Definition = None
        self._ExtTimeOffsetSet = None
        self._TimeOffsetSet = None
        self._WatermarkSet = None
        self._OutputStorage = None
        self._OutputObjectPath = None
        self._ObjectNumberFormat = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ExtTimeOffsetSet(self):
        return self._ExtTimeOffsetSet

    @ExtTimeOffsetSet.setter
    def ExtTimeOffsetSet(self, ExtTimeOffsetSet):
        self._ExtTimeOffsetSet = ExtTimeOffsetSet

    @property
    def TimeOffsetSet(self):
        return self._TimeOffsetSet

    @TimeOffsetSet.setter
    def TimeOffsetSet(self, TimeOffsetSet):
        self._TimeOffsetSet = TimeOffsetSet

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def OutputStorage(self):
        return self._OutputStorage

    @OutputStorage.setter
    def OutputStorage(self, OutputStorage):
        self._OutputStorage = OutputStorage

    @property
    def OutputObjectPath(self):
        return self._OutputObjectPath

    @OutputObjectPath.setter
    def OutputObjectPath(self, OutputObjectPath):
        self._OutputObjectPath = OutputObjectPath

    @property
    def ObjectNumberFormat(self):
        return self._ObjectNumberFormat

    @ObjectNumberFormat.setter
    def ObjectNumberFormat(self, ObjectNumberFormat):
        self._ObjectNumberFormat = ObjectNumberFormat


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ExtTimeOffsetSet = params.get("ExtTimeOffsetSet")
        self._TimeOffsetSet = params.get("TimeOffsetSet")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("OutputStorage") is not None:
            self._OutputStorage = TaskOutputStorage()
            self._OutputStorage._deserialize(params.get("OutputStorage"))
        self._OutputObjectPath = params.get("OutputObjectPath")
        if params.get("ObjectNumberFormat") is not None:
            self._ObjectNumberFormat = NumberFormat()
            self._ObjectNumberFormat._deserialize(params.get("ObjectNumberFormat"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SnapshotByTimeOffsetTemplate(AbstractModel):
    """Details of a time point screencapturing template.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: Preset template;</li>
<li>Custom: Custom template.</li>
        :type Type: str
        :param _Name: Name of a time point screencapturing template.
        :type Name: str
        :param _Comment: Template description.
        :type Comment: str
        :param _Width: Maximum value of the width (or long side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: Enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: Disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Image format.
        :type Format: str
        :param _CreateTime: Creation time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of a template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type UpdateTime: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: Stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: Fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: Fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: Fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._CreateTime = None
        self._UpdateTime = None
        self._FillType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SubtitleTemplate(AbstractModel):
    """The subtitle settings.

    """

    def __init__(self):
        r"""
        :param _Path: The URL of the subtitles to add to the video.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Path: str
        :param _StreamIndex: The subtitle track to add to the video. If both `Path` and `StreamIndex` are specified, `Path` will be used. You need to specify at least one of the two parameters.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type StreamIndex: int
        :param _FontType: The font. Valid values:
<li>`hei.ttf`: Heiti.</li>
<li>`song.ttf`: Songti.</li>
<li>`simkai.ttf`: Kaiti.</li>
<li>`arial.ttf`: Arial.</li>
The default is `hei.ttf`.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FontType: str
        :param _FontSize: The font size (pixels). If this is not specified, the font size in the subtitle file will be used.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FontSize: str
        :param _FontColor: The font color in 0xRRGGBB format. Default value: 0xFFFFFF (white).
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FontColor: str
        :param _FontAlpha: The text transparency. Value range: 0-1.
<li>`0`: Fully transparent.</li>
<li>`1`: Fully opaque.</li>
Default value: 1.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type FontAlpha: float
        """
        self._Path = None
        self._StreamIndex = None
        self._FontType = None
        self._FontSize = None
        self._FontColor = None
        self._FontAlpha = None

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def StreamIndex(self):
        return self._StreamIndex

    @StreamIndex.setter
    def StreamIndex(self, StreamIndex):
        self._StreamIndex = StreamIndex

    @property
    def FontType(self):
        return self._FontType

    @FontType.setter
    def FontType(self, FontType):
        self._FontType = FontType

    @property
    def FontSize(self):
        return self._FontSize

    @FontSize.setter
    def FontSize(self, FontSize):
        self._FontSize = FontSize

    @property
    def FontColor(self):
        return self._FontColor

    @FontColor.setter
    def FontColor(self, FontColor):
        self._FontColor = FontColor

    @property
    def FontAlpha(self):
        return self._FontAlpha

    @FontAlpha.setter
    def FontAlpha(self, FontAlpha):
        self._FontAlpha = FontAlpha


    def _deserialize(self, params):
        self._Path = params.get("Path")
        self._StreamIndex = params.get("StreamIndex")
        self._FontType = params.get("FontType")
        self._FontSize = params.get("FontSize")
        self._FontColor = params.get("FontColor")
        self._FontAlpha = params.get("FontAlpha")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SuperResolutionConfig(AbstractModel):
    """Super resolution configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable the feature. Valid values:
<li>ON</li>
<li>OFF</li>
Default value: ON.
        :type Switch: str
        :param _Type: The strength. Valid values:
<li>lq: For low-resolution videos with obvious noise</li>
<li>hq: For high-resolution videos</li>
Default value: lq.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Type: str
        :param _Size: The ratio of the target resolution to the original resolution. Valid values:
<li>2</li>
Default value: 2.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Size: int
        """
        self._Switch = None
        self._Type = None
        self._Size = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        self._Size = params.get("Size")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SvgWatermarkInput(AbstractModel):
    """Input parameter of an SVG watermarking template

    """

    def __init__(self):
        r"""
        :param _Width: Watermark width, which supports six formats of px, %, W%, H%, S%, and L%:
<li>If the string ends in px, the `Width` of the watermark will be in px; for example, `100px` means that `Width` is 100 px; if `0px` is entered
 and `Height` is not `0px`, the watermark width will be proportionally scaled based on the source SVG image; if `0px` is entered for both `Width` and `Height`, the watermark width will be the width of the source SVG image;</li>
<li>If the string ends in `W%`, the `Width` of the watermark will be the specified percentage of the video width; for example, `10W%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in `H%`, the `Width` of the watermark will be the specified percentage of the video height; for example, `10H%` means that `Width` is 10% of the video height;</li>
<li>If the string ends in `S%`, the `Width` of the watermark will be the specified percentage of the short side of the video; for example, `10S%` means that `Width` is 10% of the short side of the video;</li>
<li>If the string ends in `L%`, the `Width` of the watermark will be the specified percentage of the long side of the video; for example, `10L%` means that `Width` is 10% of the long side of the video;</li>
<li>If the string ends in %, the meaning is the same as `W%`.</li>
Default value: 10W%.
        :type Width: str
        :param _Height: Watermark height, which supports six formats of px, %, W%, H%, S%, and L%:
<li>If the string ends in px, the `Height` of the watermark will be in px; for example, `100px` means that `Height` is 100 px; if `0px` is entered
 and `Width` is not `0px`, the watermark height will be proportionally scaled based on the source SVG image; if `0px` is entered for both `Width` and `Height`, the watermark height will be the height of the source SVG image;</li>
<li>If the string ends in `W%`, the `Height` of the watermark will be the specified percentage of the video width; for example, `10W%` means that `Height` is 10% of the video width;</li>
<li>If the string ends in `H%`, the `Height` of the watermark will be the specified percentage of the video height; for example, `10H%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in `S%`, the `Height` of the watermark will be the specified percentage of the short side of the video; for example, `10S%` means that `Height` is 10% of the short side of the video;</li>
<li>If the string ends in `L%`, the `Height` of the watermark will be the specified percentage of the long side of the video; for example, `10L%` means that `Height` is 10% of the long side of the video;</li>
<li>If the string ends in %, the meaning is the same as `H%`.</li>
Default value: 0 px.
        :type Height: str
        """
        self._Width = None
        self._Height = None

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class SvgWatermarkInputForUpdate(AbstractModel):
    """Input parameter of an SVG watermarking template

    """

    def __init__(self):
        r"""
        :param _Width: Watermark width, which supports six formats of px, %, W%, H%, S%, and L%:
<li>If the string ends in px, the `Width` of the watermark will be in px; for example, `100px` means that `Width` is 100 px; if `0px` is entered
 and `Height` is not `0px`, the watermark width will be proportionally scaled based on the source SVG image; if `0px` is entered for both `Width` and `Height`, the watermark width will be the width of the source SVG image;</li>
<li>If the string ends in `W%`, the `Width` of the watermark will be the specified percentage of the video width; for example, `10W%` means that `Width` is 10% of the video width;</li>
<li>If the string ends in `H%`, the `Width` of the watermark will be the specified percentage of the video height; for example, `10H%` means that `Width` is 10% of the video height;</li>
<li>If the string ends in `S%`, the `Width` of the watermark will be the specified percentage of the short side of the video; for example, `10S%` means that `Width` is 10% of the short side of the video;</li>
<li>If the string ends in `L%`, the `Width` of the watermark will be the specified percentage of the long side of the video; for example, `10L%` means that `Width` is 10% of the long side of the video;</li>
<li>If the string ends in %, the meaning is the same as `W%`.</li>
Default value: 10W%.
        :type Width: str
        :param _Height: Watermark height, which supports six formats of px, %, W%, H%, S%, and L%:
<li>If the string ends in px, the `Height` of the watermark will be in px; for example, `100px` means that `Height` is 100 px; if `0px` is entered
 and `Width` is not `0px`, the watermark height will be proportionally scaled based on the source SVG image; if `0px` is entered for both `Width` and `Height`, the watermark height will be the height of the source SVG image;</li>
<li>If the string ends in `W%`, the `Height` of the watermark will be the specified percentage of the video width; for example, `10W%` means that `Height` is 10% of the video width;</li>
<li>If the string ends in `H%`, the `Height` of the watermark will be the specified percentage of the video height; for example, `10H%` means that `Height` is 10% of the video height;</li>
<li>If the string ends in `S%`, the `Height` of the watermark will be the specified percentage of the short side of the video; for example, `10S%` means that `Height` is 10% of the short side of the video;</li>
<li>If the string ends in `L%`, the `Height` of the watermark will be the specified percentage of the long side of the video; for example, `10L%` means that `Height` is 10% of the long side of the video;</li>
<li>If the string ends in %, the meaning is the same as `H%`.
Default value: 0 px.
        :type Height: str
        """
        self._Width = None
        self._Height = None

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TEHDConfig(AbstractModel):
    """TESHD parameter configuration.

    """

    def __init__(self):
        r"""
        :param _Type: TESHD type. Valid values:
<li>TEHD-100: TESHD-100.</li>
If this parameter is left empty, TESHD will not be enabled.
        :type Type: str
        :param _MaxVideoBitrate: Maximum bitrate, which is valid when `Type` is `TESHD`.
If this parameter is left empty or 0 is entered, there will be no upper limit for bitrate.
        :type MaxVideoBitrate: int
        """
        self._Type = None
        self._MaxVideoBitrate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MaxVideoBitrate(self):
        return self._MaxVideoBitrate

    @MaxVideoBitrate.setter
    def MaxVideoBitrate(self, MaxVideoBitrate):
        self._MaxVideoBitrate = MaxVideoBitrate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._MaxVideoBitrate = params.get("MaxVideoBitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TEHDConfigForUpdate(AbstractModel):
    """TESHD parameter configuration.

    """

    def __init__(self):
        r"""
        :param _Type: The TSC type. Valid values:
<li>`TEHD-100`: TSC-100 (video TSC). </li>
<li>`TEHD-200`: TSC-200 (audio TSC). </li>
If this parameter is left blank, no modification will be made.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type Type: str
        :param _MaxVideoBitrate: The maximum video bitrate. If this parameter is not specified, no modifications will be made.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type MaxVideoBitrate: int
        """
        self._Type = None
        self._MaxVideoBitrate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def MaxVideoBitrate(self):
        return self._MaxVideoBitrate

    @MaxVideoBitrate.setter
    def MaxVideoBitrate(self, MaxVideoBitrate):
        self._MaxVideoBitrate = MaxVideoBitrate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._MaxVideoBitrate = params.get("MaxVideoBitrate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TagConfigureInfo(AbstractModel):
    """Control parameter of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent tagging task. Valid values:
<li>ON: enables intelligent tagging task;</li>
<li>OFF: disables intelligent tagging task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TagConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent tagging task. Valid values:
<li>ON: enables intelligent tagging task;</li>
<li>OFF: disables intelligent tagging task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskNotifyConfig(AbstractModel):
    """Event notification configuration of a task.

    """

    def __init__(self):
        r"""
        :param _NotifyType: The notification type. Valid values:
<li>`CMQ`: This value is no longer used. Please use `TDMQ-CMQ` instead.</li>
<li>`TDMQ-CMQ`: Message queue</li>
<li>`URL`: If `NotifyType` is set to `URL`, HTTP callbacks are sent to the URL specified by `NotifyUrl`. HTTP and JSON are used for the callbacks. The packet contains the response parameters of the `ParseNotification` API.</li>
<li>`SCF`: This notification type is not recommended. You need to configure it in the SCF console.</li>
<li>`AWS-SQS`: AWS queue. This type is only supported for AWS tasks, and the queue must be in the same region as the AWS bucket.</li>
<font color="red">Note: If you do not pass this parameter or pass in an empty string, `CMQ` will be used. To use a different notification type, specify this parameter accordingly.</font>
        :type NotifyType: str
        :param _NotifyMode: Workflow notification method. Valid values: Finish, Change. If this parameter is left empty, `Finish` will be used.
        :type NotifyMode: str
        :param _NotifyUrl: HTTP callback URL, required if `NotifyType` is set to `URL`
        :type NotifyUrl: str
        :param _CmqModel: The CMQ or TDMQ-CMQ model. Valid values: Queue, Topic.
        :type CmqModel: str
        :param _CmqRegion: The CMQ or TDMQ-CMQ region, such as `sh` (Shanghai) or `bj` (Beijing).
        :type CmqRegion: str
        :param _TopicName: The CMQ or TDMQ-CMQ topic to receive notifications. This parameter is valid when `CmqModel` is `Topic`.
        :type TopicName: str
        :param _QueueName: The CMQ or TDMQ-CMQ queue to receive notifications. This parameter is valid when `CmqModel` is `Queue`.
        :type QueueName: str
        :param _AwsSQS: The AWS SQS queue. This parameter is required if `NotifyType` is `AWS-SQS`.

Note: This field may return null, indicating that no valid values can be obtained.
        :type AwsSQS: :class:`tencentcloud.mps.v20190612.models.AwsSQS`
        :param _NotifyKey: The key used to generate the callback signature.
Note: This field may return·null, indicating that no valid values can be obtained.
        :type NotifyKey: str
        """
        self._NotifyType = None
        self._NotifyMode = None
        self._NotifyUrl = None
        self._CmqModel = None
        self._CmqRegion = None
        self._TopicName = None
        self._QueueName = None
        self._AwsSQS = None
        self._NotifyKey = None

    @property
    def NotifyType(self):
        return self._NotifyType

    @NotifyType.setter
    def NotifyType(self, NotifyType):
        self._NotifyType = NotifyType

    @property
    def NotifyMode(self):
        return self._NotifyMode

    @NotifyMode.setter
    def NotifyMode(self, NotifyMode):
        self._NotifyMode = NotifyMode

    @property
    def NotifyUrl(self):
        return self._NotifyUrl

    @NotifyUrl.setter
    def NotifyUrl(self, NotifyUrl):
        self._NotifyUrl = NotifyUrl

    @property
    def CmqModel(self):
        return self._CmqModel

    @CmqModel.setter
    def CmqModel(self, CmqModel):
        self._CmqModel = CmqModel

    @property
    def CmqRegion(self):
        return self._CmqRegion

    @CmqRegion.setter
    def CmqRegion(self, CmqRegion):
        self._CmqRegion = CmqRegion

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName

    @property
    def QueueName(self):
        return self._QueueName

    @QueueName.setter
    def QueueName(self, QueueName):
        self._QueueName = QueueName

    @property
    def AwsSQS(self):
        return self._AwsSQS

    @AwsSQS.setter
    def AwsSQS(self, AwsSQS):
        self._AwsSQS = AwsSQS

    @property
    def NotifyKey(self):
        return self._NotifyKey

    @NotifyKey.setter
    def NotifyKey(self, NotifyKey):
        self._NotifyKey = NotifyKey


    def _deserialize(self, params):
        self._NotifyType = params.get("NotifyType")
        self._NotifyMode = params.get("NotifyMode")
        self._NotifyUrl = params.get("NotifyUrl")
        self._CmqModel = params.get("CmqModel")
        self._CmqRegion = params.get("CmqRegion")
        self._TopicName = params.get("TopicName")
        self._QueueName = params.get("QueueName")
        if params.get("AwsSQS") is not None:
            self._AwsSQS = AwsSQS()
            self._AwsSQS._deserialize(params.get("AwsSQS"))
        self._NotifyKey = params.get("NotifyKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class TaskOutputStorage(AbstractModel):
    """The information of the media processing output object.

    """

    def __init__(self):
        r"""
        :param _Type: The storage type for a media processing output file. Valid values:
<li>`COS`: Tencent Cloud COS</li>
<li>`>AWS-S3`: AWS S3. This type is only supported for AWS tasks, and the output bucket must be in the same region as the bucket of the source file.</li>
        :type Type: str
        :param _CosOutputStorage: The location to save the output object in COS. This parameter is valid and required when `Type` is COS.
Note: This field may return null, indicating that no valid value can be obtained.
        :type CosOutputStorage: :class:`tencentcloud.mps.v20190612.models.CosOutputStorage`
        :param _S3OutputStorage: The AWS S3 bucket to save the output file. This parameter is required if `Type` is `AWS-S3`.
Note: This field may return null, indicating that no valid value can be obtained.
        :type S3OutputStorage: :class:`tencentcloud.mps.v20190612.models.S3OutputStorage`
        """
        self._Type = None
        self._CosOutputStorage = None
        self._S3OutputStorage = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def CosOutputStorage(self):
        return self._CosOutputStorag