# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class ABTestConfig(AbstractModel):
    """Canary project configuration

    """

    def __init__(self):
        r"""
        :param _ProjectName: Canary project name
        :type ProjectName: str
        :param _Status: Valid values: `true` (in canary upgrade); `false` (not in canary upgrade).
        :type Status: bool
        """
        self._ProjectName = None
        self._Status = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessChildRuleInfo(AbstractModel):
    """Container runtime security - Sub-policy information

    """

    def __init__(self):
        r"""
        :param _RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param _ProcessPath: Process path
        :type ProcessPath: str
        :param _RuleId: Sub-policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param _RuleLevel: Severity. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleLevel: str
        """
        self._RuleMode = None
        self._ProcessPath = None
        self._RuleId = None
        self._RuleLevel = None

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel


    def _deserialize(self, params):
        self._RuleMode = params.get("RuleMode")
        self._ProcessPath = params.get("ProcessPath")
        self._RuleId = params.get("RuleId")
        self._RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventDescription(AbstractModel):
    """Description of the abnormal container process event at runtime

    """

    def __init__(self):
        r"""
        :param _Description: Event rule
        :type Description: str
        :param _Solution: Solution
        :type Solution: str
        :param _Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _MatchRule: Details of the hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessChildRuleInfo`
        :param _RuleName: Name of the hit rule. Valid values: `PROXY_TOOL` (proxy); `TRANSFER_CONTROL` (lateral movement); `ATTACK_CMD` (malicious command); `REVERSE_SHELL` (reverse shell); `FILELESS` (fileless execution); `RISK_CMD` (high-risk command); `ABNORMAL_CHILD_PROC` (unusual start found in the child process of the sensitive service); `USER_DEFINED_RULE` (custom rule).
        :type RuleName: str
        :param _RuleId: ID of the hit rule
        :type RuleId: str
        :param _OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        :param _GroupName: Name of the hit policy. Valid values: `SYSTEM_DEFINED_RULE` (preset policy); name of the custom policy.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GroupName: str
        """
        self._Description = None
        self._Solution = None
        self._Remark = None
        self._MatchRule = None
        self._RuleName = None
        self._RuleId = None
        self._OperationTime = None
        self._GroupName = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MatchRule(self):
        return self._MatchRule

    @MatchRule.setter
    def MatchRule(self, MatchRule):
        self._MatchRule = MatchRule

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def OperationTime(self):
        return self._OperationTime

    @OperationTime.setter
    def OperationTime(self, OperationTime):
        self._OperationTime = OperationTime

    @property
    def GroupName(self):
        return self._GroupName

    @GroupName.setter
    def GroupName(self, GroupName):
        self._GroupName = GroupName


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Solution = params.get("Solution")
        self._Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self._MatchRule = AbnormalProcessChildRuleInfo()
            self._MatchRule._deserialize(params.get("MatchRule"))
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        self._OperationTime = params.get("OperationTime")
        self._GroupName = params.get("GroupName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventInfo(AbstractModel):
    """Container runtime security - Information of the abnormal process

    """

    def __init__(self):
        r"""
        :param _ProcessPath: Process directory
        :type ProcessPath: str
        :param _EventType: Event type. `MALICE_PROCESS_START`: Malicious process startup.
        :type EventType: str
        :param _MatchRuleName: Name of the hit rule. Valid values: `PROXY_TOOL` (proxy); `TRANSFER_CONTROL` (lateral movement); `ATTACK_CMD` (malicious command); `REVERSE_SHELL` (reverse shell); `FILELESS` (fileless execution); `RISK_CMD` (high-risk command); `ABNORMAL_CHILD_PROC` (unusual start found in the child process of the sensitive service); `USER_DEFINED_RULE` (custom rule).
        :type MatchRuleName: str
        :param _FoundTime: Generation time
        :type FoundTime: str
        :param _ContainerName: Container name
        :type ContainerName: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _Behavior: Action execution result. `BEHAVIOR_NONE`: None.
    `BEHAVIOR_ALERT`: Alert.
    `BEHAVIOR_RELEASE`: Allow.
    `BEHAVIOR_HOLDUP_FAILED`: Failed to block.
    `BEHAVIOR_HOLDUP_SUCCESSED`: Blocked.
        :type Behavior: str
        :param _Status: Status. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
        :type Status: str
        :param _Id: Unique event ID
        :type Id: str
        :param _ImageId: Image ID, which is used for redirect.
        :type ImageId: str
        :param _ContainerId: Container ID, which is used for redirect.
        :type ContainerId: str
        :param _Solution: Event solution
        :type Solution: str
        :param _Description: Event description
        :type Description: str
        :param _MatchRuleId: Hit policy ID
        :type MatchRuleId: str
        :param _MatchAction: Action of the hit rule:
`RULE_MODE_RELEASE`: Allow.
`RULE_MODE_ALERT`: Alert.
`RULE_MODE_HOLDUP`: Block.
        :type MatchAction: str
        :param _MatchProcessPath: Information of the process that hits the rule
        :type MatchProcessPath: str
        :param _RuleExist: Whether the rule exists
        :type RuleExist: bool
        :param _EventCount: Number of events
        :type EventCount: int
        :param _LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param _RuleId: Rule group ID
        :type RuleId: str
        :param _MatchGroupName: Name of the hit policy. Valid values: `SYSTEM_DEFINED_RULE` (preset policy); name of the custom policy.
        :type MatchGroupName: str
        :param _MatchRuleLevel: Level of the hit rule. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
        :type MatchRuleLevel: str
        :param _ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetStatus: str
        :param _ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerNetSubStatus: str
        :param _ContainerIsolateOperationSrc: Container isolation operation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerIsolateOperationSrc: str
        :param _ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        :param _ClusterID: Cluster ID
        :type ClusterID: str
        :param _NodeType: Node type. Values: `NORMAL` (general node), `SUPER` (super node).
        :type NodeType: str
        :param _PodName: Pod name
        :type PodName: str
        :param _PodIP: Pod IP
        :type PodIP: str
        :param _NodeUniqueID: Cluster ID
        :type NodeUniqueID: str
        :param _PublicIP: Node public IP
        :type PublicIP: str
        :param _NodeName: Node name
        :type NodeName: str
        :param _NodeID: Node ID
        :type NodeID: str
        :param _HostID: uuid
        :type HostID: str
        :param _HostIP: Private IP of the node
        :type HostIP: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        """
        self._ProcessPath = None
        self._EventType = None
        self._MatchRuleName = None
        self._FoundTime = None
        self._ContainerName = None
        self._ImageName = None
        self._Behavior = None
        self._Status = None
        self._Id = None
        self._ImageId = None
        self._ContainerId = None
        self._Solution = None
        self._Description = None
        self._MatchRuleId = None
        self._MatchAction = None
        self._MatchProcessPath = None
        self._RuleExist = None
        self._EventCount = None
        self._LatestFoundTime = None
        self._RuleId = None
        self._MatchGroupName = None
        self._MatchRuleLevel = None
        self._ContainerNetStatus = None
        self._ContainerNetSubStatus = None
        self._ContainerIsolateOperationSrc = None
        self._ContainerStatus = None
        self._ClusterID = None
        self._NodeType = None
        self._PodName = None
        self._PodIP = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._NodeName = None
        self._NodeID = None
        self._HostID = None
        self._HostIP = None
        self._ClusterName = None

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def MatchRuleName(self):
        return self._MatchRuleName

    @MatchRuleName.setter
    def MatchRuleName(self, MatchRuleName):
        self._MatchRuleName = MatchRuleName

    @property
    def FoundTime(self):
        return self._FoundTime

    @FoundTime.setter
    def FoundTime(self, FoundTime):
        self._FoundTime = FoundTime

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def Behavior(self):
        return self._Behavior

    @Behavior.setter
    def Behavior(self, Behavior):
        self._Behavior = Behavior

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MatchRuleId(self):
        return self._MatchRuleId

    @MatchRuleId.setter
    def MatchRuleId(self, MatchRuleId):
        self._MatchRuleId = MatchRuleId

    @property
    def MatchAction(self):
        return self._MatchAction

    @MatchAction.setter
    def MatchAction(self, MatchAction):
        self._MatchAction = MatchAction

    @property
    def MatchProcessPath(self):
        return self._MatchProcessPath

    @MatchProcessPath.setter
    def MatchProcessPath(self, MatchProcessPath):
        self._MatchProcessPath = MatchProcessPath

    @property
    def RuleExist(self):
        return self._RuleExist

    @RuleExist.setter
    def RuleExist(self, RuleExist):
        self._RuleExist = RuleExist

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def LatestFoundTime(self):
        return self._LatestFoundTime

    @LatestFoundTime.setter
    def LatestFoundTime(self, LatestFoundTime):
        self._LatestFoundTime = LatestFoundTime

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def MatchGroupName(self):
        return self._MatchGroupName

    @MatchGroupName.setter
    def MatchGroupName(self, MatchGroupName):
        self._MatchGroupName = MatchGroupName

    @property
    def MatchRuleLevel(self):
        return self._MatchRuleLevel

    @MatchRuleLevel.setter
    def MatchRuleLevel(self, MatchRuleLevel):
        self._MatchRuleLevel = MatchRuleLevel

    @property
    def ContainerNetStatus(self):
        return self._ContainerNetStatus

    @ContainerNetStatus.setter
    def ContainerNetStatus(self, ContainerNetStatus):
        self._ContainerNetStatus = ContainerNetStatus

    @property
    def ContainerNetSubStatus(self):
        return self._ContainerNetSubStatus

    @ContainerNetSubStatus.setter
    def ContainerNetSubStatus(self, ContainerNetSubStatus):
        self._ContainerNetSubStatus = ContainerNetSubStatus

    @property
    def ContainerIsolateOperationSrc(self):
        return self._ContainerIsolateOperationSrc

    @ContainerIsolateOperationSrc.setter
    def ContainerIsolateOperationSrc(self, ContainerIsolateOperationSrc):
        self._ContainerIsolateOperationSrc = ContainerIsolateOperationSrc

    @property
    def ContainerStatus(self):
        return self._ContainerStatus

    @ContainerStatus.setter
    def ContainerStatus(self, ContainerStatus):
        self._ContainerStatus = ContainerStatus

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ProcessPath = params.get("ProcessPath")
        self._EventType = params.get("EventType")
        self._MatchRuleName = params.get("MatchRuleName")
        self._FoundTime = params.get("FoundTime")
        self._ContainerName = params.get("ContainerName")
        self._ImageName = params.get("ImageName")
        self._Behavior = params.get("Behavior")
        self._Status = params.get("Status")
        self._Id = params.get("Id")
        self._ImageId = params.get("ImageId")
        self._ContainerId = params.get("ContainerId")
        self._Solution = params.get("Solution")
        self._Description = params.get("Description")
        self._MatchRuleId = params.get("MatchRuleId")
        self._MatchAction = params.get("MatchAction")
        self._MatchProcessPath = params.get("MatchProcessPath")
        self._RuleExist = params.get("RuleExist")
        self._EventCount = params.get("EventCount")
        self._LatestFoundTime = params.get("LatestFoundTime")
        self._RuleId = params.get("RuleId")
        self._MatchGroupName = params.get("MatchGroupName")
        self._MatchRuleLevel = params.get("MatchRuleLevel")
        self._ContainerNetStatus = params.get("ContainerNetStatus")
        self._ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self._ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self._ContainerStatus = params.get("ContainerStatus")
        self._ClusterID = params.get("ClusterID")
        self._NodeType = params.get("NodeType")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._NodeName = params.get("NodeName")
        self._NodeID = params.get("NodeID")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessEventTendencyInfo(AbstractModel):
    """Trend of pending abnormal process events

    """

    def __init__(self):
        r"""
        :param _Date: Date
        :type Date: str
        :param _ProxyToolEventCount: Number of pending proxy events
        :type ProxyToolEventCount: int
        :param _TransferControlEventCount: Number of pending lateral movement events
        :type TransferControlEventCount: int
        :param _AttackCmdEventCount: Number of pending malicious command events
        :type AttackCmdEventCount: int
        :param _ReverseShellEventCount: Number of pending reverse shell events
        :type ReverseShellEventCount: int
        :param _FilelessEventCount: Number of pending fileless execution events
        :type FilelessEventCount: int
        :param _RiskCmdEventCount: Number of pending high-risk command events
        :type RiskCmdEventCount: int
        :param _AbnormalChildProcessEventCount: Number of pending events of unusual startups found in the child process of the sensitive service
        :type AbnormalChildProcessEventCount: int
        :param _UserDefinedRuleEventCount: Number of pending custom rule events
        :type UserDefinedRuleEventCount: int
        """
        self._Date = None
        self._ProxyToolEventCount = None
        self._TransferControlEventCount = None
        self._AttackCmdEventCount = None
        self._ReverseShellEventCount = None
        self._FilelessEventCount = None
        self._RiskCmdEventCount = None
        self._AbnormalChildProcessEventCount = None
        self._UserDefinedRuleEventCount = None

    @property
    def Date(self):
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def ProxyToolEventCount(self):
        return self._ProxyToolEventCount

    @ProxyToolEventCount.setter
    def ProxyToolEventCount(self, ProxyToolEventCount):
        self._ProxyToolEventCount = ProxyToolEventCount

    @property
    def TransferControlEventCount(self):
        return self._TransferControlEventCount

    @TransferControlEventCount.setter
    def TransferControlEventCount(self, TransferControlEventCount):
        self._TransferControlEventCount = TransferControlEventCount

    @property
    def AttackCmdEventCount(self):
        return self._AttackCmdEventCount

    @AttackCmdEventCount.setter
    def AttackCmdEventCount(self, AttackCmdEventCount):
        self._AttackCmdEventCount = AttackCmdEventCount

    @property
    def ReverseShellEventCount(self):
        return self._ReverseShellEventCount

    @ReverseShellEventCount.setter
    def ReverseShellEventCount(self, ReverseShellEventCount):
        self._ReverseShellEventCount = ReverseShellEventCount

    @property
    def FilelessEventCount(self):
        return self._FilelessEventCount

    @FilelessEventCount.setter
    def FilelessEventCount(self, FilelessEventCount):
        self._FilelessEventCount = FilelessEventCount

    @property
    def RiskCmdEventCount(self):
        return self._RiskCmdEventCount

    @RiskCmdEventCount.setter
    def RiskCmdEventCount(self, RiskCmdEventCount):
        self._RiskCmdEventCount = RiskCmdEventCount

    @property
    def AbnormalChildProcessEventCount(self):
        return self._AbnormalChildProcessEventCount

    @AbnormalChildProcessEventCount.setter
    def AbnormalChildProcessEventCount(self, AbnormalChildProcessEventCount):
        self._AbnormalChildProcessEventCount = AbnormalChildProcessEventCount

    @property
    def UserDefinedRuleEventCount(self):
        return self._UserDefinedRuleEventCount

    @UserDefinedRuleEventCount.setter
    def UserDefinedRuleEventCount(self, UserDefinedRuleEventCount):
        self._UserDefinedRuleEventCount = UserDefinedRuleEventCount


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._ProxyToolEventCount = params.get("ProxyToolEventCount")
        self._TransferControlEventCount = params.get("TransferControlEventCount")
        self._AttackCmdEventCount = params.get("AttackCmdEventCount")
        self._ReverseShellEventCount = params.get("ReverseShellEventCount")
        self._FilelessEventCount = params.get("FilelessEventCount")
        self._RiskCmdEventCount = params.get("RiskCmdEventCount")
        self._AbnormalChildProcessEventCount = params.get("AbnormalChildProcessEventCount")
        self._UserDefinedRuleEventCount = params.get("UserDefinedRuleEventCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessRuleInfo(AbstractModel):
    """Runtime security - Abnormal process detection policy

    """

    def __init__(self):
        r"""
        :param _IsEnable: Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param _ImageIds: IDs of associated images. An empty array indicates all images.
        :type ImageIds: list of str
        :param _ChildRules: Array of sub-policies of the user policy
        :type ChildRules: list of AbnormalProcessChildRuleInfo
        :param _RuleName: Policy name
        :type RuleName: str
        :param _RuleId: Policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param _SystemChildRules: Array of sub-policies of the preset policy
        :type SystemChildRules: list of AbnormalProcessSystemChildRuleInfo
        :param _IsDefault: Whether it is the default preset policy
        :type IsDefault: bool
        """
        self._IsEnable = None
        self._ImageIds = None
        self._ChildRules = None
        self._RuleName = None
        self._RuleId = None
        self._SystemChildRules = None
        self._IsDefault = None

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def ImageIds(self):
        return self._ImageIds

    @ImageIds.setter
    def ImageIds(self, ImageIds):
        self._ImageIds = ImageIds

    @property
    def ChildRules(self):
        return self._ChildRules

    @ChildRules.setter
    def ChildRules(self, ChildRules):
        self._ChildRules = ChildRules

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SystemChildRules(self):
        return self._SystemChildRules

    @SystemChildRules.setter
    def SystemChildRules(self, SystemChildRules):
        self._SystemChildRules = SystemChildRules

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._IsEnable = params.get("IsEnable")
        self._ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self._ChildRules = []
            for item in params.get("ChildRules"):
                obj = AbnormalProcessChildRuleInfo()
                obj._deserialize(item)
                self._ChildRules.append(obj)
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self._SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AbnormalProcessSystemChildRuleInfo()
                obj._deserialize(item)
                self._SystemChildRules.append(obj)
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalProcessSystemChildRuleInfo(AbstractModel):
    """Information of the sub-policy of the preset policy for abnormal processes

    """

    def __init__(self):
        r"""
        :param _RuleId: Sub-policy ID
        :type RuleId: str
        :param _IsEnable: Sub-policy status. Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param _RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param _RuleType: Behavior type detected by the sub-policy
`PROXY_TOOL`: Proxy.
`TRANSFER_CONTROL`: Lateral movement.
`ATTACK_CMD`: Malicious command.
`REVERSE_SHELL`: Reverse shell.
`FILELESS`: Fileless execution.
`RISK_CMD`: High-risk command.
`ABNORMAL_CHILD_PROC`: Unusual start found in the child process of the sensitive service.
        :type RuleType: str
        :param _RuleLevel: Severity. Valid values: `HIGH` (high); `MIDDLE` (medium); `LOW` (low).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleLevel: str
        """
        self._RuleId = None
        self._IsEnable = None
        self._RuleMode = None
        self._RuleType = None
        self._RuleLevel = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType

    @property
    def RuleLevel(self):
        return self._RuleLevel

    @RuleLevel.setter
    def RuleLevel(self, RuleLevel):
        self._RuleLevel = RuleLevel


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._IsEnable = params.get("IsEnable")
        self._RuleMode = params.get("RuleMode")
        self._RuleType = params.get("RuleType")
        self._RuleLevel = params.get("RuleLevel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlChildRuleInfo(AbstractModel):
    """Container runtime security - Information of the access control sub-policy

    """

    def __init__(self):
        r"""
        :param _RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param _ProcessPath: Process path
        :type ProcessPath: str
        :param _TargetFilePath: Accessed file path, which is valid only for access control.
        :type TargetFilePath: str
        :param _RuleId: Sub-policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        """
        self._RuleMode = None
        self._ProcessPath = None
        self._TargetFilePath = None
        self._RuleId = None

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def ProcessPath(self):
        return self._ProcessPath

    @ProcessPath.setter
    def ProcessPath(self, ProcessPath):
        self._ProcessPath = ProcessPath

    @property
    def TargetFilePath(self):
        return self._TargetFilePath

    @TargetFilePath.setter
    def TargetFilePath(self, TargetFilePath):
        self._TargetFilePath = TargetFilePath

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId


    def _deserialize(self, params):
        self._RuleMode = params.get("RuleMode")
        self._ProcessPath = params.get("ProcessPath")
        self._TargetFilePath = params.get("TargetFilePath")
        self._RuleId = params.get("RuleId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventDescription(AbstractModel):
    """Description of the container access control event at runtime

    """

    def __init__(self):
        r"""
        :param _Description: Event rule
        :type Description: str
        :param _Solution: Solution
        :type Solution: str
        :param _Remark: Event remarks
Note: This field may return null, indicating that no valid values can be obtained.
        :type Remark: str
        :param _MatchRule: Details of the hit rule
        :type MatchRule: :class:`tencentcloud.tcss.v20201101.models.AccessControlChildRuleInfo`
        :param _RuleName: Name of the hit rule
        :type RuleName: str
        :param _RuleId: ID of the hit rule
        :type RuleId: str
        :param _OperationTime: Last processing time of the event
Note: This field may return null, indicating that no valid values can be obtained.
        :type OperationTime: str
        """
        self._Description = None
        self._Solution = None
        self._Remark = None
        self._MatchRule = None
        self._RuleName = None
        self._RuleId = None
        self._OperationTime = None

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Remark(self):
        return self._Remark

    @Remark.setter
    def Remark(self, Remark):
        self._Remark = Remark

    @property
    def MatchRule(self):
        return self._MatchRule

    @MatchRule.setter
    def MatchRule(self, MatchRule):
        self._MatchRule = MatchRule

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def OperationTime(self):
        return self._OperationTime

    @OperationTime.setter
    def OperationTime(self, OperationTime):
        self._OperationTime = OperationTime


    def _deserialize(self, params):
        self._Description = params.get("Description")
        self._Solution = params.get("Solution")
        self._Remark = params.get("Remark")
        if params.get("MatchRule") is not None:
            self._MatchRule = AccessControlChildRuleInfo()
            self._MatchRule._deserialize(params.get("MatchRule"))
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        self._OperationTime = params.get("OperationTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlEventInfo(AbstractModel):
    """Container runtime security - Information of the access control event

    """

    def __init__(self):
        r"""
        :param _ProcessName: Process name
        :type ProcessName: str
        :param _MatchRuleName: Name of the hit rule
        :type MatchRuleName: str
        :param _FoundTime: Generation time
        :type FoundTime: str
        :param _ContainerName: Container name
        :type ContainerName: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _Behavior: Action execution result. `BEHAVIOR_NONE`: None.
    `BEHAVIOR_ALERT`: Alert.
    `BEHAVIOR_RELEASE`: Allow.
    `BEHAVIOR_HOLDUP_FAILED`: Failed to block.
    `BEHAVIOR_HOLDUP_SUCCESSED`: Blocked.
        :type Behavior: str
        :param _Status: Status. `0`: Pending. `EVENT_UNDEAL`: Pending.
    `EVENT_DEALED`: Processed.
    `EVENT_INGNORE`: Ignored.
        :type Status: str
        :param _Id: Unique event ID
        :type Id: str
        :param _FileName: Filename
        :type FileName: str
        :param _EventType: Event type. `FILE_ABNORMAL_READ`: Abnormal file read.
        :type EventType: str
        :param _ImageId: Image ID, which is used for redirect.
        :type ImageId: str
        :param _ContainerId: Container ID, which is used for redirect.
        :type ContainerId: str
        :param _Solution: Event solution
        :type Solution: str
        :param _Description: Event description
        :type Description: str
        :param _MatchRuleId: Hit policy ID
        :type MatchRuleId: str
        :param _MatchAction: Action of the hit rule:
`RULE_MODE_RELEASE`: Allow.
`RULE_MODE_ALERT`: Alert.
`RULE_MODE_HOLDUP`: Block.
        :type MatchAction: str
        :param _MatchProcessPath: Information of the process that hits the rule
        :type MatchProcessPath: str
        :param _MatchFilePath: Information of the file that hits the rule
        :type MatchFilePath: str
        :param _FilePath: File path containing the name
        :type FilePath: str
        :param _RuleExist: Whether the rule exists
        :type RuleExist: bool
        :param _EventCount: Number of events
        :type EventCount: int
        :param _LatestFoundTime: Last generation time
        :type LatestFoundTime: str
        :param _RuleId: Rule group ID
        :type RuleId: str
        :param _ContainerNetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type ContainerNetStatus: str
        :param _ContainerNetSubStatus: Sub-status of the container
"AGENT_OFFLINE"       // The agent is offline.
"NODE_DESTROYED"      // The node is terminated.
"CONTAINER_EXITED"    // The container exited.
"CONTAINER_DESTROYED" // The container was terminated.
"SHARED_HOST"         // The container shares the network with the server.
"RESOURCE_LIMIT"      // The number of resources to be isolated exceeds the limit.
"UNKNOW"              // The reason is unknown.
        :type ContainerNetSubStatus: str
        :param _ContainerIsolateOperationSrc: Container isolation operation source
        :type ContainerIsolateOperationSrc: str
        :param _ContainerStatus: Container status
`RUNNING`: Running.
`PAUSED`: Paused.
`STOPPED`: Stopped.
`CREATED`: Created.
`DESTROYED`: Terminated.
`RESTARTING`: Restarting.
`REMOVING`: Removing.
        :type ContainerStatus: str
        :param _NodeName: Node name: For super nodes, the node_id is displayed.
        :type NodeName: str
        :param _PodName: Pod name
        :type PodName: str
        :param _PodIP: Pod IP
        :type PodIP: str
        :param _NodeType: Node type. Values: `NORMAL` (general node), `SUPER` (super node).
        :type NodeType: str
        :param _ClusterID: Cluster ID
        :type ClusterID: str
        :param _NodeUniqueID: Node unique ID. It's used for super nodes.
        :type NodeUniqueID: str
        :param _PublicIP: Node public IP
        :type PublicIP: str
        :param _NodeID: Node ID
        :type NodeID: str
        :param _HostID: uuid
        :type HostID: str
        :param _HostIP: Private IP of the node
        :type HostIP: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        """
        self._ProcessName = None
        self._MatchRuleName = None
        self._FoundTime = None
        self._ContainerName = None
        self._ImageName = None
        self._Behavior = None
        self._Status = None
        self._Id = None
        self._FileName = None
        self._EventType = None
        self._ImageId = None
        self._ContainerId = None
        self._Solution = None
        self._Description = None
        self._MatchRuleId = None
        self._MatchAction = None
        self._MatchProcessPath = None
        self._MatchFilePath = None
        self._FilePath = None
        self._RuleExist = None
        self._EventCount = None
        self._LatestFoundTime = None
        self._RuleId = None
        self._ContainerNetStatus = None
        self._ContainerNetSubStatus = None
        self._ContainerIsolateOperationSrc = None
        self._ContainerStatus = None
        self._NodeName = None
        self._PodName = None
        self._PodIP = None
        self._NodeType = None
        self._ClusterID = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._NodeID = None
        self._HostID = None
        self._HostIP = None
        self._ClusterName = None

    @property
    def ProcessName(self):
        return self._ProcessName

    @ProcessName.setter
    def ProcessName(self, ProcessName):
        self._ProcessName = ProcessName

    @property
    def MatchRuleName(self):
        return self._MatchRuleName

    @MatchRuleName.setter
    def MatchRuleName(self, MatchRuleName):
        self._MatchRuleName = MatchRuleName

    @property
    def FoundTime(self):
        return self._FoundTime

    @FoundTime.setter
    def FoundTime(self, FoundTime):
        self._FoundTime = FoundTime

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def Behavior(self):
        return self._Behavior

    @Behavior.setter
    def Behavior(self, Behavior):
        self._Behavior = Behavior

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def MatchRuleId(self):
        return self._MatchRuleId

    @MatchRuleId.setter
    def MatchRuleId(self, MatchRuleId):
        self._MatchRuleId = MatchRuleId

    @property
    def MatchAction(self):
        return self._MatchAction

    @MatchAction.setter
    def MatchAction(self, MatchAction):
        self._MatchAction = MatchAction

    @property
    def MatchProcessPath(self):
        return self._MatchProcessPath

    @MatchProcessPath.setter
    def MatchProcessPath(self, MatchProcessPath):
        self._MatchProcessPath = MatchProcessPath

    @property
    def MatchFilePath(self):
        return self._MatchFilePath

    @MatchFilePath.setter
    def MatchFilePath(self, MatchFilePath):
        self._MatchFilePath = MatchFilePath

    @property
    def FilePath(self):
        return self._FilePath

    @FilePath.setter
    def FilePath(self, FilePath):
        self._FilePath = FilePath

    @property
    def RuleExist(self):
        return self._RuleExist

    @RuleExist.setter
    def RuleExist(self, RuleExist):
        self._RuleExist = RuleExist

    @property
    def EventCount(self):
        return self._EventCount

    @EventCount.setter
    def EventCount(self, EventCount):
        self._EventCount = EventCount

    @property
    def LatestFoundTime(self):
        return self._LatestFoundTime

    @LatestFoundTime.setter
    def LatestFoundTime(self, LatestFoundTime):
        self._LatestFoundTime = LatestFoundTime

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ContainerNetStatus(self):
        return self._ContainerNetStatus

    @ContainerNetStatus.setter
    def ContainerNetStatus(self, ContainerNetStatus):
        self._ContainerNetStatus = ContainerNetStatus

    @property
    def ContainerNetSubStatus(self):
        return self._ContainerNetSubStatus

    @ContainerNetSubStatus.setter
    def ContainerNetSubStatus(self, ContainerNetSubStatus):
        self._ContainerNetSubStatus = ContainerNetSubStatus

    @property
    def ContainerIsolateOperationSrc(self):
        return self._ContainerIsolateOperationSrc

    @ContainerIsolateOperationSrc.setter
    def ContainerIsolateOperationSrc(self, ContainerIsolateOperationSrc):
        self._ContainerIsolateOperationSrc = ContainerIsolateOperationSrc

    @property
    def ContainerStatus(self):
        return self._ContainerStatus

    @ContainerStatus.setter
    def ContainerStatus(self, ContainerStatus):
        self._ContainerStatus = ContainerStatus

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName


    def _deserialize(self, params):
        self._ProcessName = params.get("ProcessName")
        self._MatchRuleName = params.get("MatchRuleName")
        self._FoundTime = params.get("FoundTime")
        self._ContainerName = params.get("ContainerName")
        self._ImageName = params.get("ImageName")
        self._Behavior = params.get("Behavior")
        self._Status = params.get("Status")
        self._Id = params.get("Id")
        self._FileName = params.get("FileName")
        self._EventType = params.get("EventType")
        self._ImageId = params.get("ImageId")
        self._ContainerId = params.get("ContainerId")
        self._Solution = params.get("Solution")
        self._Description = params.get("Description")
        self._MatchRuleId = params.get("MatchRuleId")
        self._MatchAction = params.get("MatchAction")
        self._MatchProcessPath = params.get("MatchProcessPath")
        self._MatchFilePath = params.get("MatchFilePath")
        self._FilePath = params.get("FilePath")
        self._RuleExist = params.get("RuleExist")
        self._EventCount = params.get("EventCount")
        self._LatestFoundTime = params.get("LatestFoundTime")
        self._RuleId = params.get("RuleId")
        self._ContainerNetStatus = params.get("ContainerNetStatus")
        self._ContainerNetSubStatus = params.get("ContainerNetSubStatus")
        self._ContainerIsolateOperationSrc = params.get("ContainerIsolateOperationSrc")
        self._ContainerStatus = params.get("ContainerStatus")
        self._NodeName = params.get("NodeName")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._NodeType = params.get("NodeType")
        self._ClusterID = params.get("ClusterID")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._NodeID = params.get("NodeID")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ClusterName = params.get("ClusterName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlRuleInfo(AbstractModel):
    """Container runtime - Access control policy information

    """

    def __init__(self):
        r"""
        :param _IsEnable: Switch. Valid values: `true` (on); `false` (off).
        :type IsEnable: bool
        :param _ImageIds: IDs of associated images. An empty array indicates all images.
        :type ImageIds: list of str
        :param _ChildRules: Array of sub-policies of the user policy
        :type ChildRules: list of AccessControlChildRuleInfo
        :param _RuleName: Policy name
        :type RuleName: str
        :param _RuleId: Policy ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: str
        :param _SystemChildRules: Array of sub-policies of the preset policy
        :type SystemChildRules: list of AccessControlSystemChildRuleInfo
        :param _IsDefault: Whether it is the default preset policy
        :type IsDefault: bool
        """
        self._IsEnable = None
        self._ImageIds = None
        self._ChildRules = None
        self._RuleName = None
        self._RuleId = None
        self._SystemChildRules = None
        self._IsDefault = None

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def ImageIds(self):
        return self._ImageIds

    @ImageIds.setter
    def ImageIds(self, ImageIds):
        self._ImageIds = ImageIds

    @property
    def ChildRules(self):
        return self._ChildRules

    @ChildRules.setter
    def ChildRules(self, ChildRules):
        self._ChildRules = ChildRules

    @property
    def RuleName(self):
        return self._RuleName

    @RuleName.setter
    def RuleName(self, RuleName):
        self._RuleName = RuleName

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def SystemChildRules(self):
        return self._SystemChildRules

    @SystemChildRules.setter
    def SystemChildRules(self, SystemChildRules):
        self._SystemChildRules = SystemChildRules

    @property
    def IsDefault(self):
        return self._IsDefault

    @IsDefault.setter
    def IsDefault(self, IsDefault):
        self._IsDefault = IsDefault


    def _deserialize(self, params):
        self._IsEnable = params.get("IsEnable")
        self._ImageIds = params.get("ImageIds")
        if params.get("ChildRules") is not None:
            self._ChildRules = []
            for item in params.get("ChildRules"):
                obj = AccessControlChildRuleInfo()
                obj._deserialize(item)
                self._ChildRules.append(obj)
        self._RuleName = params.get("RuleName")
        self._RuleId = params.get("RuleId")
        if params.get("SystemChildRules") is not None:
            self._SystemChildRules = []
            for item in params.get("SystemChildRules"):
                obj = AccessControlSystemChildRuleInfo()
                obj._deserialize(item)
                self._SystemChildRules.append(obj)
        self._IsDefault = params.get("IsDefault")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccessControlSystemChildRuleInfo(AbstractModel):
    """Container runtime security - Information of the sub-policy of the preset access control policy

    """

    def __init__(self):
        r"""
        :param _RuleId: Sub-policy ID
        :type RuleId: str
        :param _RuleMode: Policy mode. `RULE_MODE_RELEASE`: Allow.
   `RULE_MODE_ALERT`: Alert.
   `RULE_MODE_HOLDUP`: Block.
        :type RuleMode: str
        :param _IsEnable: Sub-policy status. Valid values: `true` (enabled); `false` (disabled).
        :type IsEnable: bool
        :param _RuleType: Intrusion behavior type detected by the sub-policy
`CHANGE_CRONTAB`: Tampering with the scheduled task.
`CHANGE_SYS_BIN`: Tampering with the system program.
`CHANGE_USRCFG`: Tampering with user configuration.
        :type RuleType: str
        """
        self._RuleId = None
        self._RuleMode = None
        self._IsEnable = None
        self._RuleType = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RuleMode(self):
        return self._RuleMode

    @RuleMode.setter
    def RuleMode(self, RuleMode):
        self._RuleMode = RuleMode

    @property
    def IsEnable(self):
        return self._IsEnable

    @IsEnable.setter
    def IsEnable(self, IsEnable):
        self._IsEnable = IsEnable

    @property
    def RuleType(self):
        return self._RuleType

    @RuleType.setter
    def RuleType(self, RuleType):
        self._RuleType = RuleType


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._RuleMode = params.get("RuleMode")
        self._IsEnable = params.get("IsEnable")
        self._RuleType = params.get("RuleType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param _ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param _PodSelector: Pod selector
        :type PodSelector: str
        :param _Namespace: Namespace
        :type Namespace: str
        :param _Description: Policy description
        :type Description: str
        :param _CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self._ClusterId = None
        self._PolicyName = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._PodSelector = None
        self._Namespace = None
        self._Description = None
        self._CustomPolicy = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        self._PodSelector = params.get("PodSelector")
        self._Namespace = params.get("Namespace")
        self._Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddAndPublishNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param _Description: Policy description
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAndPublishNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddAndPublishNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """AddAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Repository name
        :type Name: str
        :param _Username: Username
        :type Username: str
        :param _Password: Password
        :type Password: str
        :param _Url: Repository URL
        :type Url: str
        :param _RegistryType: Repository type, which can be `harbor`.
        :type RegistryType: str
        :param _NetType: Network type, which can be `public` (public network).
        :type NetType: str
        :param _RegistryVersion: Repository version
        :type RegistryVersion: str
        :param _RegistryRegion: Region. Default value: `default`.
        :type RegistryRegion: str
        :param _SpeedLimit: Speed limit
        :type SpeedLimit: int
        :param _Insecure: Valid values: `0` (secure mode with certificate verification, which is the default value); `1` (unsecure mode that skips certificate verification).
        :type Insecure: int
        """
        self._Name = None
        self._Username = None
        self._Password = None
        self._Url = None
        self._RegistryType = None
        self._NetType = None
        self._RegistryVersion = None
        self._RegistryRegion = None
        self._SpeedLimit = None
        self._Insecure = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegistryVersion(self):
        return self._RegistryVersion

    @RegistryVersion.setter
    def RegistryVersion(self, RegistryVersion):
        self._RegistryVersion = RegistryVersion

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def SpeedLimit(self):
        return self._SpeedLimit

    @SpeedLimit.setter
    def SpeedLimit(self, SpeedLimit):
        self._SpeedLimit = SpeedLimit

    @property
    def Insecure(self):
        return self._Insecure

    @Insecure.setter
    def Insecure(self, Insecure):
        self._Insecure = Insecure


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._Url = params.get("Url")
        self._RegistryType = params.get("RegistryType")
        self._NetType = params.get("NetType")
        self._RegistryVersion = params.get("RegistryVersion")
        self._RegistryRegion = params.get("RegistryRegion")
        self._SpeedLimit = params.get("SpeedLimit")
        self._Insecure = params.get("Insecure")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """AddAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param _HealthCheckErr: Connection error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type HealthCheckErr: str
        :param _NameRepeatErr: Name error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type NameRepeatErr: str
        :param _RegistryId: Unique repository ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HealthCheckErr = None
        self._NameRepeatErr = None
        self._RegistryId = None
        self._RequestId = None

    @property
    def HealthCheckErr(self):
        return self._HealthCheckErr

    @HealthCheckErr.setter
    def HealthCheckErr(self, HealthCheckErr):
        self._HealthCheckErr = HealthCheckErr

    @property
    def NameRepeatErr(self):
        return self._NameRepeatErr

    @NameRepeatErr.setter
    def NameRepeatErr(self, NameRepeatErr):
        self._NameRepeatErr = NameRepeatErr

    @property
    def RegistryId(self):
        return self._RegistryId

    @RegistryId.setter
    def RegistryId(self, RegistryId):
        self._RegistryId = RegistryId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HealthCheckErr = params.get("HealthCheckErr")
        self._NameRepeatErr = params.get("NameRepeatErr")
        self._RegistryId = params.get("RegistryId")
        self._RequestId = params.get("RequestId")


class AddComplianceAssetPolicySetToWhitelistRequest(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _AssetPolicySetList: List of asset IDs and check item IDs
        :type AssetPolicySetList: list of ComplianceAssetPolicySetItem
        """
        self._AssetPolicySetList = None

    @property
    def AssetPolicySetList(self):
        return self._AssetPolicySetList

    @AssetPolicySetList.setter
    def AssetPolicySetList(self, AssetPolicySetList):
        self._AssetPolicySetList = AssetPolicySetList


    def _deserialize(self, params):
        if params.get("AssetPolicySetList") is not None:
            self._AssetPolicySetList = []
            for item in params.get("AssetPolicySetList"):
                obj = ComplianceAssetPolicySetItem()
                obj._deserialize(item)
                self._AssetPolicySetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddComplianceAssetPolicySetToWhitelistResponse(AbstractModel):
    """AddComplianceAssetPolicySetToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCompliancePolicyAssetSetToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: Check item ID
        :type CustomerPolicyItemId: int
        :param _CustomerAssetItemIdSet: List of IDs of assets to be ignored in the specified check item
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemId = None
        self._CustomerAssetItemIdSet = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def CustomerAssetItemIdSet(self):
        return self._CustomerAssetItemIdSet

    @CustomerAssetItemIdSet.setter
    def CustomerAssetItemIdSet(self, CustomerAssetItemIdSet):
        self._CustomerAssetItemIdSet = CustomerAssetItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyAssetSetToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyAssetSetToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddCompliancePolicyItemToWhitelistRequest(AbstractModel):
    """AddCompliancePolicyItemToWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemIdSet: List of IDs of check items to be ignored
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemIdSet = None

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddCompliancePolicyItemToWhitelistResponse(AbstractModel):
    """AddCompliancePolicyItemToWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditAbnormalProcessRuleRequest(AbstractModel):
    """AddEditAbnormalProcessRule request structure.

    """

    def __init__(self):
        r"""
        :param _RuleInfo: Information of the added policy. The policy ID is empty here but cannot be empty when you edit a policy.
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param _EventId: Required only when an item is allowed
        :type EventId: str
        """
        self._RuleInfo = None
        self._EventId = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = AbnormalProcessRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAbnormalProcessRuleResponse(AbstractModel):
    """AddEditAbnormalProcessRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditAccessControlRuleRequest(AbstractModel):
    """AddEditAccessControlRule request structure.

    """

    def __init__(self):
        r"""
        :param _RuleInfo: Information of the added policy. The policy ID is empty here but cannot be empty when you edit a policy.
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param _EventId: Used only for an allowed item
        :type EventId: str
        """
        self._RuleInfo = None
        self._EventId = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = AccessControlRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditAccessControlRuleResponse(AbstractModel):
    """AddEditAccessControlRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditImageAutoAuthorizedRuleRequest(AbstractModel):
    """AddEditImageAutoAuthorizedRule request structure.

    """

    def __init__(self):
        r"""
        :param _RangeType: Scope. Valid values: `MANUAL` (specified servers); `ALL` (all images).
        :type RangeType: str
        :param _MaxDailyCount: Maximum number of image licenses per day. `0`: Unlimited.
        :type MaxDailyCount: int
        :param _IsEnabled: Whether the rule takes effect. Valid values: `0` (no); `1` (yes).
        :type IsEnabled: int
        :param _HostIdSet: IDs of specified servers. This parameter is required when the scope is `MANUAL` and `HostIdFilters` is empty.
        :type HostIdSet: list of str
        :param _RuleId: Rule ID, which is required during editing.
        :type RuleId: int
        :param _HostIdFilters: Filter. This parameter is required when the scope is `MANUAL` and `HostIdSet` is empty.
        :type HostIdFilters: list of AssetFilters
        :param _ExcludeHostIdSet: Specified server IDs to be excluded
        :type ExcludeHostIdSet: list of str
        """
        self._RangeType = None
        self._MaxDailyCount = None
        self._IsEnabled = None
        self._HostIdSet = None
        self._RuleId = None
        self._HostIdFilters = None
        self._ExcludeHostIdSet = None

    @property
    def RangeType(self):
        return self._RangeType

    @RangeType.setter
    def RangeType(self, RangeType):
        self._RangeType = RangeType

    @property
    def MaxDailyCount(self):
        return self._MaxDailyCount

    @MaxDailyCount.setter
    def MaxDailyCount(self, MaxDailyCount):
        self._MaxDailyCount = MaxDailyCount

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def HostIdSet(self):
        return self._HostIdSet

    @HostIdSet.setter
    def HostIdSet(self, HostIdSet):
        self._HostIdSet = HostIdSet

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def HostIdFilters(self):
        return self._HostIdFilters

    @HostIdFilters.setter
    def HostIdFilters(self, HostIdFilters):
        self._HostIdFilters = HostIdFilters

    @property
    def ExcludeHostIdSet(self):
        return self._ExcludeHostIdSet

    @ExcludeHostIdSet.setter
    def ExcludeHostIdSet(self, ExcludeHostIdSet):
        self._ExcludeHostIdSet = ExcludeHostIdSet


    def _deserialize(self, params):
        self._RangeType = params.get("RangeType")
        self._MaxDailyCount = params.get("MaxDailyCount")
        self._IsEnabled = params.get("IsEnabled")
        self._HostIdSet = params.get("HostIdSet")
        self._RuleId = params.get("RuleId")
        if params.get("HostIdFilters") is not None:
            self._HostIdFilters = []
            for item in params.get("HostIdFilters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._HostIdFilters.append(obj)
        self._ExcludeHostIdSet = params.get("ExcludeHostIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditImageAutoAuthorizedRuleResponse(AbstractModel):
    """AddEditImageAutoAuthorizedRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditReverseShellWhiteListRequest(AbstractModel):
    """AddEditReverseShellWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListInfo: Information of the allowed item to be added or edited. When an allowed item is added, `WhiteListInfo.id` can be empty; when an allowed item is edited, `WhiteListInfo.id` cannot be empty.
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param _EventId: Used only when an event is added to the allowlist
        :type EventId: str
        """
        self._WhiteListInfo = None
        self._EventId = None

    @property
    def WhiteListInfo(self):
        return self._WhiteListInfo

    @WhiteListInfo.setter
    def WhiteListInfo(self, WhiteListInfo):
        self._WhiteListInfo = WhiteListInfo

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        if params.get("WhiteListInfo") is not None:
            self._WhiteListInfo = ReverseShellWhiteListInfo()
            self._WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditReverseShellWhiteListResponse(AbstractModel):
    """AddEditReverseShellWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditRiskSyscallWhiteListRequest(AbstractModel):
    """AddEditRiskSyscallWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Used only when an event is added to the allowlist
        :type EventId: str
        :param _WhiteListInfo: Information of the allowed item to be added or edited. When an allowed item is added, `WhiteListInfo.id` can be empty; when an allowed item is edited, `WhiteListInfo.id` cannot be empty.
        :type WhiteListInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        """
        self._EventId = None
        self._WhiteListInfo = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId

    @property
    def WhiteListInfo(self):
        return self._WhiteListInfo

    @WhiteListInfo.setter
    def WhiteListInfo(self, WhiteListInfo):
        self._WhiteListInfo = WhiteListInfo


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        if params.get("WhiteListInfo") is not None:
            self._WhiteListInfo = RiskSyscallWhiteListInfo()
            self._WhiteListInfo._deserialize(params.get("WhiteListInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditRiskSyscallWhiteListResponse(AbstractModel):
    """AddEditRiskSyscallWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEditWarningRulesRequest(AbstractModel):
    """AddEditWarningRules request structure.

    """

    def __init__(self):
        r"""
        :param _WarningRules: Alert switch policy
        :type WarningRules: list of WarningRule
        """
        self._WarningRules = None

    @property
    def WarningRules(self):
        return self._WarningRules

    @WarningRules.setter
    def WarningRules(self, WarningRules):
        self._WarningRules = WarningRules


    def _deserialize(self, params):
        if params.get("WarningRules") is not None:
            self._WarningRules = []
            for item in params.get("WarningRules"):
                obj = WarningRule()
                obj._deserialize(item)
                self._WarningRules.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEditWarningRulesResponse(AbstractModel):
    """AddEditWarningRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddEscapeWhiteListRequest(AbstractModel):
    """AddEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _EventType: Allowed event type
   `ESCAPE_CGROUPS`: Cgroup escape.
   `ESCAPE_TAMPER_SENSITIVE_FILE`: File tamper escape.
   `ESCAPE_DOCKER_API`: Docker API access escape.
   `ESCAPE_VUL_OCCURRED`: Vulnerability exploit.
   `MOUNT_SENSITIVE_PTAH`: Sensitive path mount.
   `PRIVILEGE_CONTAINER_START`: Privileged container.
   `PRIVILEGE`: Program privilege escalation escape.
        :type EventType: list of str
        :param _ImageIDs: Array of allowed image IDs
        :type ImageIDs: list of str
        """
        self._EventType = None
        self._ImageIDs = None

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def ImageIDs(self):
        return self._ImageIDs

    @ImageIDs.setter
    def ImageIDs(self, ImageIDs):
        self._ImageIDs = ImageIDs


    def _deserialize(self, params):
        self._EventType = params.get("EventType")
        self._ImageIDs = params.get("ImageIDs")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddEscapeWhiteListResponse(AbstractModel):
    """AddEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddIgnoreVulRequest(AbstractModel):
    """AddIgnoreVul request structure.

    """

    def __init__(self):
        r"""
        :param _List: List of POC IDs
        :type List: list of ModifyIgnoreVul
        """
        self._List = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddIgnoreVulResponse(AbstractModel):
    """AddIgnoreVul response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _FromPolicyRule: Inbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type FromPolicyRule: int
        :param _ToPolicyRule: Outbound rule

`1`: Allow all.

`2`: Reject all.

`3`: Custom.
        :type ToPolicyRule: int
        :param _PodSelector: Pod selector
        :type PodSelector: str
        :param _Namespace: Namespace
        :type Namespace: str
        :param _Description: Policy description
        :type Description: str
        :param _CustomPolicy: Custom rule
        :type CustomPolicy: list of NetworkCustomPolicy
        """
        self._ClusterId = None
        self._PolicyName = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._PodSelector = None
        self._Namespace = None
        self._Description = None
        self._CustomPolicy = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        self._PodSelector = params.get("PodSelector")
        self._Namespace = params.get("Namespace")
        self._Description = params.get("Description")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AddNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param _Description: Policy description
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AddNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """AddNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class AffectedNodeItem(AbstractModel):
    """Structure of the affected node type

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _InstanceId: Instance ID
        :type InstanceId: str
        :param _PrivateIpAddresses: Private IP
        :type PrivateIpAddresses: str
        :param _InstanceRole: Node role, such as `Master` and `Work`.
        :type InstanceRole: str
        :param _ClusterVersion: K8s version
        :type ClusterVersion: str
        :param _ContainerRuntime: Runtime component. Valid values: `docker`, `containerd`.
        :type ContainerRuntime: str
        :param _Region: Region
        :type Region: str
        :param _VerifyInfo: Verification information of the check result
        :type VerifyInfo: str
        :param _NodeName: Node name
        :type NodeName: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._InstanceId = None
        self._PrivateIpAddresses = None
        self._InstanceRole = None
        self._ClusterVersion = None
        self._ContainerRuntime = None
        self._Region = None
        self._VerifyInfo = None
        self._NodeName = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def PrivateIpAddresses(self):
        return self._PrivateIpAddresses

    @PrivateIpAddresses.setter
    def PrivateIpAddresses(self, PrivateIpAddresses):
        self._PrivateIpAddresses = PrivateIpAddresses

    @property
    def InstanceRole(self):
        return self._InstanceRole

    @InstanceRole.setter
    def InstanceRole(self, InstanceRole):
        self._InstanceRole = InstanceRole

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ContainerRuntime(self):
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._InstanceId = params.get("InstanceId")
        self._PrivateIpAddresses = params.get("PrivateIpAddresses")
        self._InstanceRole = params.get("InstanceRole")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._Region = params.get("Region")
        self._VerifyInfo = params.get("VerifyInfo")
        self._NodeName = params.get("NodeName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AffectedWorkloadItem(AbstractModel):
    """Affected workload item in the cluster security check

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _WorkloadName: Workload name
        :type WorkloadName: str
        :param _WorkloadType: Workload type
        :type WorkloadType: str
        :param _Region: Region
        :type Region: str
        :param _VerifyInfo: Verification information of the check result
        :type VerifyInfo: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._WorkloadName = None
        self._WorkloadType = None
        self._Region = None
        self._VerifyInfo = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def WorkloadName(self):
        return self._WorkloadName

    @WorkloadName.setter
    def WorkloadName(self, WorkloadName):
        self._WorkloadName = WorkloadName

    @property
    def WorkloadType(self):
        return self._WorkloadType

    @WorkloadType.setter
    def WorkloadType(self, WorkloadType):
        self._WorkloadType = WorkloadType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._WorkloadName = params.get("WorkloadName")
        self._WorkloadType = params.get("WorkloadType")
        self._Region = params.get("Region")
        self._VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetClusterListItem(AbstractModel):
    """List of clusters

    """

    def __init__(self):
        r"""
        :param _ClusterID: Cluster ID
        :type ClusterID: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _Status: Cluster status
`CSR_RUNNING`: Running
`CSR_EXCEPTION`: Abnormal
`CSR_DEL`: Deleted
        :type Status: str
        :param _BindRuleName: Bound rule name
        :type BindRuleName: str
        :param _ClusterType: Cluster type:
`CT_TKE`: TKE cluster
`CT_USER_CREATE`: External cluster
`CT_TKE_SERVERLESS`: TKE Serverless cluster
        :type ClusterType: str
        :param _ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param _MemLimit: MEM usage
        :type MemLimit: int
        :param _CpuLimit: cpu
        :type CpuLimit: int
        """
        self._ClusterID = None
        self._ClusterName = None
        self._Status = None
        self._BindRuleName = None
        self._ClusterType = None
        self._ClusterVersion = None
        self._MemLimit = None
        self._CpuLimit = None

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def BindRuleName(self):
        return self._BindRuleName

    @BindRuleName.setter
    def BindRuleName(self, BindRuleName):
        self._BindRuleName = BindRuleName

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def MemLimit(self):
        return self._MemLimit

    @MemLimit.setter
    def MemLimit(self, MemLimit):
        self._MemLimit = MemLimit

    @property
    def CpuLimit(self):
        return self._CpuLimit

    @CpuLimit.setter
    def CpuLimit(self, CpuLimit):
        self._CpuLimit = CpuLimit


    def _deserialize(self, params):
        self._ClusterID = params.get("ClusterID")
        self._ClusterName = params.get("ClusterName")
        self._Status = params.get("Status")
        self._BindRuleName = params.get("BindRuleName")
        self._ClusterType = params.get("ClusterType")
        self._ClusterVersion = params.get("ClusterVersion")
        self._MemLimit = params.get("MemLimit")
        self._CpuLimit = params.get("CpuLimit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetFilters(AbstractModel):
    """TCSS
    Key-value pair filter for conditional filtering queries, such as filter ID, name, and status
    If more than one filter exists, the logical relationship between these filters is `AND`.
    If multiple values exist in one filter, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param _Name: Filter name
        :type Name: str
        :param _Values: One or more filter values
        :type Values: list of str
        :param _ExactMatch: Whether to use fuzzy query
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AssetSimpleImageInfo(AbstractModel):
    """Brief information of the image

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _ContainerCnt: Number of associated containers
        :type ContainerCnt: int
        :param _ScanTime: Last scan time
        :type ScanTime: str
        :param _Size: Image size
        :type Size: int
        """
        self._ImageID = None
        self._ImageName = None
        self._ContainerCnt = None
        self._ScanTime = None
        self._Size = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ImageName = params.get("ImageName")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ScanTime = params.get("ScanTime")
        self._Size = params.get("Size")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedImageInfo(AbstractModel):
    """Result of the automatic image licensing

    """

    def __init__(self):
        r"""
        :param _ImageId: Image ID
        :type ImageId: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _AuthorizedTime: Licensing time
        :type AuthorizedTime: str
        :param _Status: Licensing result. Valid values: `SUCCESS` (success); `REACH_LIMIT` (reaching the upper limit on licenses); `LICENSE_INSUFFICIENT` (insufficient licenses).
        :type Status: str
        :param _IsAuthorized: Whether it is licensed. Valid values: `1` (yes); `0` (no).
        :type IsAuthorized: int
        """
        self._ImageId = None
        self._ImageName = None
        self._AuthorizedTime = None
        self._Status = None
        self._IsAuthorized = None

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def AuthorizedTime(self):
        return self._AuthorizedTime

    @AuthorizedTime.setter
    def AuthorizedTime(self, AuthorizedTime):
        self._AuthorizedTime = AuthorizedTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized


    def _deserialize(self, params):
        self._ImageId = params.get("ImageId")
        self._ImageName = params.get("ImageName")
        self._AuthorizedTime = params.get("AuthorizedTime")
        self._Status = params.get("Status")
        self._IsAuthorized = params.get("IsAuthorized")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AutoAuthorizedRuleHostInfo(AbstractModel):
    """List of servers licensed based on the automatic image licensing rule

    """

    def __init__(self):
        r"""
        :param _HostID: Server ID
        :type HostID: str
        :param _HostIP: Server IP, which is the private IP
        :type HostIP: str
        :param _HostName: Server name
        :type HostName: str
        :param _ImageCnt: Number of images
        :type ImageCnt: int
        :param _ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param _PublicIp: Public IP
        :type PublicIp: str
        :param _InstanceID: Server instance ID
        :type InstanceID: str
        :param _MachineType: Server source. Valid values: `CVM`, `ECM`, `LH`, `BM`, `Other`. The first four values indicate Tencent Cloud instances, while the last one indicates non-Tencent Cloud instances.
        :type MachineType: str
        :param _DockerVersion: Docker version
        :type DockerVersion: str
        :param _Status: Agent status
        :type Status: str
        """
        self._HostID = None
        self._HostIP = None
        self._HostName = None
        self._ImageCnt = None
        self._ContainerCnt = None
        self._PublicIp = None
        self._InstanceID = None
        self._MachineType = None
        self._DockerVersion = None
        self._Status = None

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._HostName = params.get("HostName")
        self._ImageCnt = params.get("ImageCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._PublicIp = params.get("PublicIp")
        self._InstanceID = params.get("InstanceID")
        self._MachineType = params.get("MachineType")
        self._DockerVersion = params.get("DockerVersion")
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaInstanceInfo(AbstractModel):
    """Optional information of the security log Kafka

    """

    def __init__(self):
        r"""
        :param _InstanceID: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceID: str
        :param _InstanceName: Instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _TopicList: Topic list
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of CKafkaTopicInfo
        :param _RouteList: Route list
Note: This field may return null, indicating that no valid values can be obtained.
        :type RouteList: list of CkafkaRouteInfo
        :param _KafkaVersion: Kafka version number
Note: This field may return null, indicating that no valid values can be obtained.
        :type KafkaVersion: str
        """
        self._InstanceID = None
        self._InstanceName = None
        self._TopicList = None
        self._RouteList = None
        self._KafkaVersion = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def TopicList(self):
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList

    @property
    def RouteList(self):
        return self._RouteList

    @RouteList.setter
    def RouteList(self, RouteList):
        self._RouteList = RouteList

    @property
    def KafkaVersion(self):
        return self._KafkaVersion

    @KafkaVersion.setter
    def KafkaVersion(self, KafkaVersion):
        self._KafkaVersion = KafkaVersion


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._InstanceName = params.get("InstanceName")
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = CKafkaTopicInfo()
                obj._deserialize(item)
                self._TopicList.append(obj)
        if params.get("RouteList") is not None:
            self._RouteList = []
            for item in params.get("RouteList"):
                obj = CkafkaRouteInfo()
                obj._deserialize(item)
                self._RouteList.append(obj)
        self._KafkaVersion = params.get("KafkaVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CKafkaTopicInfo(AbstractModel):
    """CKafka topic information

    """

    def __init__(self):
        r"""
        :param _TopicID: Topic ID
        :type TopicID: str
        :param _TopicName: Topic name
        :type TopicName: str
        """
        self._TopicID = None
        self._TopicName = None

    @property
    def TopicID(self):
        return self._TopicID

    @TopicID.setter
    def TopicID(self, TopicID):
        self._TopicID = TopicID

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicID = params.get("TopicID")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlRequest(AbstractModel):
    """CheckNetworkFirewallPolicyYaml request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _Yaml: Base64-encoded NetworkPolicy YAML string
        :type Yaml: str
        :param _Description: Policy description
        :type Description: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckNetworkFirewallPolicyYamlResponse(AbstractModel):
    """CheckNetworkFirewallPolicyYaml response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CheckRepeatAssetImageRegistryRequest(AbstractModel):
    """CheckRepeatAssetImageRegistry request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Repository name
        :type Name: str
        """
        self._Name = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CheckRepeatAssetImageRegistryResponse(AbstractModel):
    """CheckRepeatAssetImageRegistry response structure.

    """

    def __init__(self):
        r"""
        :param _IsRepeat: Whether it is repeated
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsRepeat: bool
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsRepeat = None
        self._RequestId = None

    @property
    def IsRepeat(self):
        return self._IsRepeat

    @IsRepeat.setter
    def IsRepeat(self, IsRepeat):
        self._IsRepeat = IsRepeat

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsRepeat = params.get("IsRepeat")
        self._RequestId = params.get("RequestId")


class CkafkaRouteInfo(AbstractModel):
    """CKafka route details

    """

    def __init__(self):
        r"""
        :param _RouteID: Route ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type RouteID: int
        :param _Domain: Domain name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _DomainPort: Domain port
Note: This field may return null, indicating that no valid values can be obtained.
        :type DomainPort: int
        :param _Vip: VIP
Note: This field may return null, indicating that no valid values can be obtained.
        :type Vip: str
        :param _VipType: VIP type
Note: This field may return null, indicating that no valid values can be obtained.
        :type VipType: int
        :param _AccessType: Access type
// `0`: PLAINTEXT (plaintext method, which does not carry user information and is supported for legacy versions and Community Edition)
	// `1`: SASL_PLAINTEXT (plaintext method, which authenticates the login through SASL before data start and is supported only for Community Edition)
	// `2`: SSL (SSL-encrypted communication, which does not carry user information and is supported for legacy versions and Community Edition)
	// `3`: SASL_SSL (SSL-encrypted communication, which authenticates the login through SASL before data start and is supported only for Community Edition)
Note: This field may return null, indicating that no valid values can be obtained.
        :type AccessType: int
        """
        self._RouteID = None
        self._Domain = None
        self._DomainPort = None
        self._Vip = None
        self._VipType = None
        self._AccessType = None

    @property
    def RouteID(self):
        return self._RouteID

    @RouteID.setter
    def RouteID(self, RouteID):
        self._RouteID = RouteID

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DomainPort(self):
        return self._DomainPort

    @DomainPort.setter
    def DomainPort(self, DomainPort):
        self._DomainPort = DomainPort

    @property
    def Vip(self):
        return self._Vip

    @Vip.setter
    def Vip(self, Vip):
        self._Vip = Vip

    @property
    def VipType(self):
        return self._VipType

    @VipType.setter
    def VipType(self, VipType):
        self._VipType = VipType

    @property
    def AccessType(self):
        return self._AccessType

    @AccessType.setter
    def AccessType(self, AccessType):
        self._AccessType = AccessType


    def _deserialize(self, params):
        self._RouteID = params.get("RouteID")
        self._Domain = params.get("Domain")
        self._DomainPort = params.get("DomainPort")
        self._Vip = params.get("Vip")
        self._VipType = params.get("VipType")
        self._AccessType = params.get("AccessType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsLogsetInfo(AbstractModel):
    """CLS logset information

    """

    def __init__(self):
        r"""
        :param _LogsetID: Logset ID
        :type LogsetID: str
        :param _LogsetName: Logset name
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogsetName: str
        :param _TopicList: List of CLS topics
Note: This field may return null, indicating that no valid values can be obtained.
        :type TopicList: list of ClsTopicInfo
        """
        self._LogsetID = None
        self._LogsetName = None
        self._TopicList = None

    @property
    def LogsetID(self):
        return self._LogsetID

    @LogsetID.setter
    def LogsetID(self, LogsetID):
        self._LogsetID = LogsetID

    @property
    def LogsetName(self):
        return self._LogsetName

    @LogsetName.setter
    def LogsetName(self, LogsetName):
        self._LogsetName = LogsetName

    @property
    def TopicList(self):
        return self._TopicList

    @TopicList.setter
    def TopicList(self, TopicList):
        self._TopicList = TopicList


    def _deserialize(self, params):
        self._LogsetID = params.get("LogsetID")
        self._LogsetName = params.get("LogsetName")
        if params.get("TopicList") is not None:
            self._TopicList = []
            for item in params.get("TopicList"):
                obj = ClsTopicInfo()
                obj._deserialize(item)
                self._TopicList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClsTopicInfo(AbstractModel):
    """CLS topic information

    """

    def __init__(self):
        r"""
        :param _TopicID: Topic ID
        :type TopicID: str
        :param _TopicName: Topic name
        :type TopicName: str
        """
        self._TopicID = None
        self._TopicName = None

    @property
    def TopicID(self):
        return self._TopicID

    @TopicID.setter
    def TopicID(self, TopicID):
        self._TopicID = TopicID

    @property
    def TopicName(self):
        return self._TopicName

    @TopicName.setter
    def TopicName(self, TopicName):
        self._TopicName = TopicName


    def _deserialize(self, params):
        self._TopicID = params.get("TopicID")
        self._TopicName = params.get("TopicName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckItem(AbstractModel):
    """Details of a cluster security check item

    """

    def __init__(self):
        r"""
        :param _CheckItemId: Unique ID of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckItemId: int
        :param _Name: Name of the risk item
        :type Name: str
        :param _ItemDetail: Detailed description of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type ItemDetail: str
        :param _RiskLevel: Severity. Valid values: `Serious` (critical); `High` (high); `Middle` (medium); `Hint` (prompt).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskLevel: str
        :param _RiskTarget: Check target and risky target. Valid values: `Runc`, `Kubelet`, `Containerd`, `Pods`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskTarget: str
        :param _RiskType: Risk type. Valid values: `CVERisk` (vulnerability risk); `ConfigRisk` (configuration risk).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskType: str
        :param _RiskAttribute: Risk type of the check item. Valid values: `PrivilegePromotion` (privilege escalation); `RefuseService` (service rejected); `DirectoryEscape` (directory traversal); `UnauthorizedAccess` (unauthorized access); `PrivilegeAndAccessControl` (permissions, privileges, and access controls); `SensitiveInfoLeak` (sensitive data leakage).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskAttribute: str
        :param _RiskProperty: Risk characteristic and tag. Valid values: `ExistEXP` (an EXP exists); `ExistPOC` (a POC exists); `NoNeedReboot` (restart not required); `ServerRestart` (service restart); `RemoteInfoLeak` (remote information leakage); `RemoteRefuseService` (remote denial of service); `RemoteExploit` (remote exploit); `RemoteExecute` (remote execution).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskProperty: str
        :param _CVENumber: CVE No.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVENumber: str
        :param _DiscoverTime: Disclosure time
Note: This field may return null, indicating that no valid values can be obtained.
        :type DiscoverTime: str
        :param _Solution: Solution
Note: This field may return null, indicating that no valid values can be obtained.
        :type Solution: str
        :param _CVSS: CVSS information, which is used for drawing.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVSS: str
        :param _CVSSScore: CVSS score
Note: This field may return null, indicating that no valid values can be obtained.
        :type CVSSScore: str
        :param _RelateLink: Reference link
Note: This field may return null, indicating that no valid values can be obtained.
        :type RelateLink: str
        :param _AffectedType: Affected type. Valid values: `Node`, `Workload`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedType: str
        :param _AffectedVersion: Affected version information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AffectedVersion: str
        :param _IgnoredAssetNum: Number of ignored assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoredAssetNum: int
        :param _IsIgnored: Whether to ignore the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsIgnored: bool
        :param _RiskAssessment: Impact assessment
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskAssessment: str
        """
        self._CheckItemId = None
        self._Name = None
        self._ItemDetail = None
        self._RiskLevel = None
        self._RiskTarget = None
        self._RiskType = None
        self._RiskAttribute = None
        self._RiskProperty = None
        self._CVENumber = None
        self._DiscoverTime = None
        self._Solution = None
        self._CVSS = None
        self._CVSSScore = None
        self._RelateLink = None
        self._AffectedType = None
        self._AffectedVersion = None
        self._IgnoredAssetNum = None
        self._IsIgnored = None
        self._RiskAssessment = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def ItemDetail(self):
        return self._ItemDetail

    @ItemDetail.setter
    def ItemDetail(self, ItemDetail):
        self._ItemDetail = ItemDetail

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def RiskTarget(self):
        return self._RiskTarget

    @RiskTarget.setter
    def RiskTarget(self, RiskTarget):
        self._RiskTarget = RiskTarget

    @property
    def RiskType(self):
        return self._RiskType

    @RiskType.setter
    def RiskType(self, RiskType):
        self._RiskType = RiskType

    @property
    def RiskAttribute(self):
        return self._RiskAttribute

    @RiskAttribute.setter
    def RiskAttribute(self, RiskAttribute):
        self._RiskAttribute = RiskAttribute

    @property
    def RiskProperty(self):
        return self._RiskProperty

    @RiskProperty.setter
    def RiskProperty(self, RiskProperty):
        self._RiskProperty = RiskProperty

    @property
    def CVENumber(self):
        return self._CVENumber

    @CVENumber.setter
    def CVENumber(self, CVENumber):
        self._CVENumber = CVENumber

    @property
    def DiscoverTime(self):
        return self._DiscoverTime

    @DiscoverTime.setter
    def DiscoverTime(self, DiscoverTime):
        self._DiscoverTime = DiscoverTime

    @property
    def Solution(self):
        return self._Solution

    @Solution.setter
    def Solution(self, Solution):
        self._Solution = Solution

    @property
    def CVSS(self):
        return self._CVSS

    @CVSS.setter
    def CVSS(self, CVSS):
        self._CVSS = CVSS

    @property
    def CVSSScore(self):
        return self._CVSSScore

    @CVSSScore.setter
    def CVSSScore(self, CVSSScore):
        self._CVSSScore = CVSSScore

    @property
    def RelateLink(self):
        return self._RelateLink

    @RelateLink.setter
    def RelateLink(self, RelateLink):
        self._RelateLink = RelateLink

    @property
    def AffectedType(self):
        return self._AffectedType

    @AffectedType.setter
    def AffectedType(self, AffectedType):
        self._AffectedType = AffectedType

    @property
    def AffectedVersion(self):
        return self._AffectedVersion

    @AffectedVersion.setter
    def AffectedVersion(self, AffectedVersion):
        self._AffectedVersion = AffectedVersion

    @property
    def IgnoredAssetNum(self):
        return self._IgnoredAssetNum

    @IgnoredAssetNum.setter
    def IgnoredAssetNum(self, IgnoredAssetNum):
        self._IgnoredAssetNum = IgnoredAssetNum

    @property
    def IsIgnored(self):
        return self._IsIgnored

    @IsIgnored.setter
    def IsIgnored(self, IsIgnored):
        self._IsIgnored = IsIgnored

    @property
    def RiskAssessment(self):
        return self._RiskAssessment

    @RiskAssessment.setter
    def RiskAssessment(self, RiskAssessment):
        self._RiskAssessment = RiskAssessment


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Name = params.get("Name")
        self._ItemDetail = params.get("ItemDetail")
        self._RiskLevel = params.get("RiskLevel")
        self._RiskTarget = params.get("RiskTarget")
        self._RiskType = params.get("RiskType")
        self._RiskAttribute = params.get("RiskAttribute")
        self._RiskProperty = params.get("RiskProperty")
        self._CVENumber = params.get("CVENumber")
        self._DiscoverTime = params.get("DiscoverTime")
        self._Solution = params.get("Solution")
        self._CVSS = params.get("CVSS")
        self._CVSSScore = params.get("CVSSScore")
        self._RelateLink = params.get("RelateLink")
        self._AffectedType = params.get("AffectedType")
        self._AffectedVersion = params.get("AffectedVersion")
        self._IgnoredAssetNum = params.get("IgnoredAssetNum")
        self._IsIgnored = params.get("IsIgnored")
        self._RiskAssessment = params.get("RiskAssessment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCheckTaskItem(AbstractModel):
    """Input parameters for a cluster check task

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the specified cluster to be scanned
        :type ClusterId: str
        :param _ClusterRegion: Cluster region
        :type ClusterRegion: str
        :param _NodeIp: IP of the specified node to be scanned
        :type NodeIp: str
        :param _WorkloadName: Name of the specified workload to be scanned
        :type WorkloadName: str
        """
        self._ClusterId = None
        self._ClusterRegion = None
        self._NodeIp = None
        self._WorkloadName = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterRegion(self):
        return self._ClusterRegion

    @ClusterRegion.setter
    def ClusterRegion(self, ClusterRegion):
        self._ClusterRegion = ClusterRegion

    @property
    def NodeIp(self):
        return self._NodeIp

    @NodeIp.setter
    def NodeIp(self, NodeIp):
        self._NodeIp = NodeIp

    @property
    def WorkloadName(self):
        return self._WorkloadName

    @WorkloadName.setter
    def WorkloadName(self, WorkloadName):
        self._WorkloadName = WorkloadName


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterRegion = params.get("ClusterRegion")
        self._NodeIp = params.get("NodeIp")
        self._WorkloadName = params.get("WorkloadName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCreateComponentItem(AbstractModel):
    """Input parameters for `CreateCheckComponent`, which are used to batch install defenders.

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the cluster for which to install the component
        :type ClusterId: str
        :param _ClusterRegion: Cluster region
        :type ClusterRegion: str
        """
        self._ClusterId = None
        self._ClusterRegion = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterRegion(self):
        return self._ClusterRegion

    @ClusterRegion.setter
    def ClusterRegion(self, ClusterRegion):
        self._ClusterRegion = ClusterRegion


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterRegion = params.get("ClusterRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterCustomParameters(AbstractModel):
    """Custom parameters of the cluster

    """

    def __init__(self):
        r"""
        :param _Name: Parameter name
        :type Name: str
        :param _Values: Parameter value
        :type Values: list of str
        """
        self._Name = None
        self._Values = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterInfoItem(AbstractModel):
    """Response parameters structure of the cluster asset

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param _ClusterOs: Cluster OS
        :type ClusterOs: str
        :param _ClusterType: Cluster type
        :type ClusterType: str
        :param _ClusterNodeNum: Number of nodes in the cluster
        :type ClusterNodeNum: int
        :param _Region: Cluster region
        :type Region: str
        :param _DefenderStatus: Status of the monitoring component. Valid values: `Defender_Uninstall`, `Defender_Normal`, `Defender_Error`, `Defender_Installing`.
        :type DefenderStatus: str
        :param _ClusterStatus: Cluster status
        :type ClusterStatus: str
        :param _ClusterCheckMode: Cluster check mode. Valid values: `Cluster_Normal`, `Cluster_Actived`.
        :type ClusterCheckMode: str
        :param _ClusterAutoCheck: Whether automatic and regular check is enabled
        :type ClusterAutoCheck: bool
        :param _DefenderErrorReason: Cause of the failure to deploy the defender. When it is `UserDaemonSetNotReady`, `UnreadyNodeNum` is changed to "The defenders on N nodes are ready". If it is another value, the error message is directly displayed.
        :type DefenderErrorReason: str
        :param _UnreadyNodeNum: Number of nodes where the defender is not ready
        :type UnreadyNodeNum: int
        :param _SeriousRiskCount: Number of critical check items
        :type SeriousRiskCount: int
        :param _HighRiskCount: Number of high-risk check items
        :type HighRiskCount: int
        :param _MiddleRiskCount: Number of medium-risk check items
        :type MiddleRiskCount: int
        :param _HintRiskCount: Number of prompt-risk check items
        :type HintRiskCount: int
        :param _CheckFailReason: Check failure cause
        :type CheckFailReason: str
        :param _CheckStatus: Check status. Valid values: `Task_Running`, `NoRisk`, `HasRisk`, `Uncheck`, `Task_Error`.
        :type CheckStatus: str
        :param _TaskCreateTime: Task creation time and check time
        :type TaskCreateTime: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ClusterVersion = None
        self._ClusterOs = None
        self._ClusterType = None
        self._ClusterNodeNum = None
        self._Region = None
        self._DefenderStatus = None
        self._ClusterStatus = None
        self._ClusterCheckMode = None
        self._ClusterAutoCheck = None
        self._DefenderErrorReason = None
        self._UnreadyNodeNum = None
        self._SeriousRiskCount = None
        self._HighRiskCount = None
        self._MiddleRiskCount = None
        self._HintRiskCount = None
        self._CheckFailReason = None
        self._CheckStatus = None
        self._TaskCreateTime = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ClusterOs(self):
        return self._ClusterOs

    @ClusterOs.setter
    def ClusterOs(self, ClusterOs):
        self._ClusterOs = ClusterOs

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def ClusterNodeNum(self):
        return self._ClusterNodeNum

    @ClusterNodeNum.setter
    def ClusterNodeNum(self, ClusterNodeNum):
        self._ClusterNodeNum = ClusterNodeNum

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def DefenderStatus(self):
        return self._DefenderStatus

    @DefenderStatus.setter
    def DefenderStatus(self, DefenderStatus):
        self._DefenderStatus = DefenderStatus

    @property
    def ClusterStatus(self):
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterCheckMode(self):
        return self._ClusterCheckMode

    @ClusterCheckMode.setter
    def ClusterCheckMode(self, ClusterCheckMode):
        self._ClusterCheckMode = ClusterCheckMode

    @property
    def ClusterAutoCheck(self):
        return self._ClusterAutoCheck

    @ClusterAutoCheck.setter
    def ClusterAutoCheck(self, ClusterAutoCheck):
        self._ClusterAutoCheck = ClusterAutoCheck

    @property
    def DefenderErrorReason(self):
        return self._DefenderErrorReason

    @DefenderErrorReason.setter
    def DefenderErrorReason(self, DefenderErrorReason):
        self._DefenderErrorReason = DefenderErrorReason

    @property
    def UnreadyNodeNum(self):
        return self._UnreadyNodeNum

    @UnreadyNodeNum.setter
    def UnreadyNodeNum(self, UnreadyNodeNum):
        self._UnreadyNodeNum = UnreadyNodeNum

    @property
    def SeriousRiskCount(self):
        return self._SeriousRiskCount

    @SeriousRiskCount.setter
    def SeriousRiskCount(self, SeriousRiskCount):
        self._SeriousRiskCount = SeriousRiskCount

    @property
    def HighRiskCount(self):
        return self._HighRiskCount

    @HighRiskCount.setter
    def HighRiskCount(self, HighRiskCount):
        self._HighRiskCount = HighRiskCount

    @property
    def MiddleRiskCount(self):
        return self._MiddleRiskCount

    @MiddleRiskCount.setter
    def MiddleRiskCount(self, MiddleRiskCount):
        self._MiddleRiskCount = MiddleRiskCount

    @property
    def HintRiskCount(self):
        return self._HintRiskCount

    @HintRiskCount.setter
    def HintRiskCount(self, HintRiskCount):
        self._HintRiskCount = HintRiskCount

    @property
    def CheckFailReason(self):
        return self._CheckFailReason

    @CheckFailReason.setter
    def CheckFailReason(self, CheckFailReason):
        self._CheckFailReason = CheckFailReason

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def TaskCreateTime(self):
        return self._TaskCreateTime

    @TaskCreateTime.setter
    def TaskCreateTime(self, TaskCreateTime):
        self._TaskCreateTime = TaskCreateTime


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ClusterOs = params.get("ClusterOs")
        self._ClusterType = params.get("ClusterType")
        self._ClusterNodeNum = params.get("ClusterNodeNum")
        self._Region = params.get("Region")
        self._DefenderStatus = params.get("DefenderStatus")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterCheckMode = params.get("ClusterCheckMode")
        self._ClusterAutoCheck = params.get("ClusterAutoCheck")
        self._DefenderErrorReason = params.get("DefenderErrorReason")
        self._UnreadyNodeNum = params.get("UnreadyNodeNum")
        self._SeriousRiskCount = params.get("SeriousRiskCount")
        self._HighRiskCount = params.get("HighRiskCount")
        self._MiddleRiskCount = params.get("MiddleRiskCount")
        self._HintRiskCount = params.get("HintRiskCount")
        self._CheckFailReason = params.get("CheckFailReason")
        self._CheckStatus = params.get("CheckStatus")
        self._TaskCreateTime = params.get("TaskCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClusterRiskItem(AbstractModel):
    """A risk item is a check item with an issue found in the check, with certain information of the check result.

    """

    def __init__(self):
        r"""
        :param _CheckItem: Check item information
        :type CheckItem: :class:`tencentcloud.tcss.v20201101.models.ClusterCheckItem`
        :param _VerifyInfo: Verification information
        :type VerifyInfo: str
        :param _ErrorMessage: Event description and check error message
        :type ErrorMessage: str
        :param _AffectedClusterCount: Number of affected clusters
        :type AffectedClusterCount: int
        :param _AffectedNodeCount: Number of affected nodes
        :type AffectedNodeCount: int
        """
        self._CheckItem = None
        self._VerifyInfo = None
        self._ErrorMessage = None
        self._AffectedClusterCount = None
        self._AffectedNodeCount = None

    @property
    def CheckItem(self):
        return self._CheckItem

    @CheckItem.setter
    def CheckItem(self, CheckItem):
        self._CheckItem = CheckItem

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def ErrorMessage(self):
        return self._ErrorMessage

    @ErrorMessage.setter
    def ErrorMessage(self, ErrorMessage):
        self._ErrorMessage = ErrorMessage

    @property
    def AffectedClusterCount(self):
        return self._AffectedClusterCount

    @AffectedClusterCount.setter
    def AffectedClusterCount(self, AffectedClusterCount):
        self._AffectedClusterCount = AffectedClusterCount

    @property
    def AffectedNodeCount(self):
        return self._AffectedNodeCount

    @AffectedNodeCount.setter
    def AffectedNodeCount(self, AffectedNodeCount):
        self._AffectedNodeCount = AffectedNodeCount


    def _deserialize(self, params):
        if params.get("CheckItem") is not None:
            self._CheckItem = ClusterCheckItem()
            self._CheckItem._deserialize(params.get("CheckItem"))
        self._VerifyInfo = params.get("VerifyInfo")
        self._ErrorMessage = params.get("ErrorMessage")
        self._AffectedClusterCount = params.get("AffectedClusterCount")
        self._AffectedNodeCount = params.get("AffectedNodeCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAffectedAsset(AbstractModel):
    """Information of the asset affected by the check item

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Unique ID of the customer asset
        :type CustomerAssetId: int
        :param _AssetName: Asset name
        :type AssetName: str
        :param _AssetType: Asset type
        :type AssetType: str
        :param _CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _NodeName: Node name
        :type NodeName: str
        :param _LastCheckTime: Last check time in the format of "YYYY-MM-DD HH:m::SS"

It is "0000-00-00 00:00:00" if no check has been performed.
        :type LastCheckTime: str
        :param _CheckResult: Check result. Valid values:

`RESULT_FAILED`: Failed.

`RESULT_PASSED`: Passed.
        :type CheckResult: str
        :param _HostIP: Server IP
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostIP: str
        :param _ImageTag: Image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param _VerifyInfo: Verification information of the check item
Note: This field may return null, indicating that no valid values can be obtained.
        :type VerifyInfo: str
        :param _InstanceId: Instance ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type InstanceId: str
        """
        self._CustomerAssetId = None
        self._AssetName = None
        self._AssetType = None
        self._CheckStatus = None
        self._NodeName = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._HostIP = None
        self._ImageTag = None
        self._VerifyInfo = None
        self._InstanceId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetName = params.get("AssetName")
        self._AssetType = params.get("AssetType")
        self._CheckStatus = params.get("CheckStatus")
        self._NodeName = params.get("NodeName")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._HostIP = params.get("HostIP")
        self._ImageTag = params.get("ImageTag")
        self._VerifyInfo = params.get("VerifyInfo")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetDetailInfo(AbstractModel):
    """Asset details

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param _AssetType: Asset type
        :type AssetType: str
        :param _AssetName: Asset name
        :type AssetName: str
        :param _NodeName: Node name of the asset
        :type NodeName: str
        :param _HostName: Server name of the asset
        :type HostName: str
        :param _HostIP: Server IP of the asset
        :type HostIP: str
        :param _CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _PassedPolicyItemCount: Number of check items that the asset passed
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: Number of check items that the asset failed
        :type FailedPolicyItemCount: int
        :param _LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param _CheckResult: Check result. Valid values:
`RESULT_FAILED`: Failed.
`RESULT_PASSED`: Passed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param _AssetStatus: Asset status
        :type AssetStatus: str
        :param _AssetCreateTime: Asset creation time
`ASSET_NORMAL`: Running.
`ASSET_PAUSED`: Suspended.
`ASSET_STOPPED`: Stopped.
`ASSET_ABNORMAL`: Abnormal.
        :type AssetCreateTime: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._AssetName = None
        self._NodeName = None
        self._HostName = None
        self._HostIP = None
        self._CheckStatus = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._AssetStatus = None
        self._AssetCreateTime = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def AssetStatus(self):
        return self._AssetStatus

    @AssetStatus.setter
    def AssetStatus(self, AssetStatus):
        self._AssetStatus = AssetStatus

    @property
    def AssetCreateTime(self):
        return self._AssetCreateTime

    @AssetCreateTime.setter
    def AssetCreateTime(self, AssetCreateTime):
        self._AssetCreateTime = AssetCreateTime


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._AssetName = params.get("AssetName")
        self._NodeName = params.get("NodeName")
        self._HostName = params.get("HostName")
        self._HostIP = params.get("HostIP")
        self._CheckStatus = params.get("CheckStatus")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._AssetStatus = params.get("AssetStatus")
        self._AssetCreateTime = params.get("AssetCreateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetInfo(AbstractModel):
    """Asset information

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param _AssetType: Asset type
        :type AssetType: str
        :param _AssetName: Asset name
        :type AssetName: str
        :param _ImageTag: This field is the image tag when the asset is an image.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param _HostIP: Server IP of the asset
        :type HostIP: str
        :param _NodeName: Node name of the asset
        :type NodeName: str
        :param _CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _PassedPolicyItemCount: Number of check items that the asset passed
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: Number of check items that the asset failed
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedPolicyItemCount: int
        :param _LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param _CheckResult: Check result. Valid values:
`RESULT_FAILED`: Failed.
`RESULT_PASSED`: Passed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param _InstanceId: Node instance ID
Note: This field may return `null`, indicating that no valid values can be obtained.
        :type InstanceId: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._AssetName = None
        self._ImageTag = None
        self._HostIP = None
        self._NodeName = None
        self._CheckStatus = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._LastCheckTime = None
        self._CheckResult = None
        self._InstanceId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._AssetName = params.get("AssetName")
        self._ImageTag = params.get("ImageTag")
        self._HostIP = params.get("HostIP")
        self._NodeName = params.get("NodeName")
        self._CheckStatus = params.get("CheckStatus")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckResult = params.get("CheckResult")
        self._InstanceId = params.get("InstanceId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicyItem(AbstractModel):
    """Information of a check item

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: Unique ID of the customer check item
        :type CustomerPolicyItemId: int
        :param _BasePolicyItemId: Original ID of the check item
        :type BasePolicyItemId: int
        :param _Name: Check item name
        :type Name: str
        :param _Category: Category of the check item
        :type Category: str
        :param _BenchmarkStandardId: Compliance standard ID
        :type BenchmarkStandardId: int
        :param _BenchmarkStandardName: Compliance standard name
        :type BenchmarkStandardName: str
        :param _RiskLevel: Severity
        :type RiskLevel: str
        :param _CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _CheckResult: Check result
`RESULT_PASSED`: Passed.
`RESULT_FAILED`: Failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param _WhitelistId: Allowed item ID of the check item. If it exists and is not `0`, the check item is ignored.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WhitelistId: int
        :param _FixSuggestion: Handling suggestion
        :type FixSuggestion: str
        :param _LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param _VerifyInfo: Verification information
Note: This field may return null, indicating that no valid values can be obtained.
        :type VerifyInfo: str
        """
        self._CustomerPolicyItemId = None
        self._BasePolicyItemId = None
        self._Name = None
        self._Category = None
        self._BenchmarkStandardId = None
        self._BenchmarkStandardName = None
        self._RiskLevel = None
        self._CheckStatus = None
        self._CheckResult = None
        self._WhitelistId = None
        self._FixSuggestion = None
        self._LastCheckTime = None
        self._VerifyInfo = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def BasePolicyItemId(self):
        return self._BasePolicyItemId

    @BasePolicyItemId.setter
    def BasePolicyItemId(self, BasePolicyItemId):
        self._BasePolicyItemId = BasePolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def BenchmarkStandardId(self):
        return self._BenchmarkStandardId

    @BenchmarkStandardId.setter
    def BenchmarkStandardId(self, BenchmarkStandardId):
        self._BenchmarkStandardId = BenchmarkStandardId

    @property
    def BenchmarkStandardName(self):
        return self._BenchmarkStandardName

    @BenchmarkStandardName.setter
    def BenchmarkStandardName(self, BenchmarkStandardName):
        self._BenchmarkStandardName = BenchmarkStandardName

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def WhitelistId(self):
        return self._WhitelistId

    @WhitelistId.setter
    def WhitelistId(self, WhitelistId):
        self._WhitelistId = WhitelistId

    @property
    def FixSuggestion(self):
        return self._FixSuggestion

    @FixSuggestion.setter
    def FixSuggestion(self, FixSuggestion):
        self._FixSuggestion = FixSuggestion

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def VerifyInfo(self):
        return self._VerifyInfo

    @VerifyInfo.setter
    def VerifyInfo(self, VerifyInfo):
        self._VerifyInfo = VerifyInfo


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._BasePolicyItemId = params.get("BasePolicyItemId")
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._BenchmarkStandardId = params.get("BenchmarkStandardId")
        self._BenchmarkStandardName = params.get("BenchmarkStandardName")
        self._RiskLevel = params.get("RiskLevel")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckResult = params.get("CheckResult")
        self._WhitelistId = params.get("WhitelistId")
        self._FixSuggestion = params.get("FixSuggestion")
        self._LastCheckTime = params.get("LastCheckTime")
        self._VerifyInfo = params.get("VerifyInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetPolicySetItem(AbstractModel):
    """List of asset IDs and check item IDs

    """

    def __init__(self):
        r"""
        :param _CustomerAssetItemId: Asset ID
        :type CustomerAssetItemId: int
        :param _CustomerPolicyItemIdSet: List of IDs of check items to be ignored in the specified asset. If it is empty, it indicates all.
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._CustomerAssetItemId = None
        self._CustomerPolicyItemIdSet = None

    @property
    def CustomerAssetItemId(self):
        return self._CustomerAssetItemId

    @CustomerAssetItemId.setter
    def CustomerAssetItemId(self, CustomerAssetItemId):
        self._CustomerAssetItemId = CustomerAssetItemId

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._CustomerAssetItemId = params.get("CustomerAssetItemId")
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceAssetSummary(AbstractModel):
    """Asset overview

    """

    def __init__(self):
        r"""
        :param _AssetType: Asset type
        :type AssetType: str
        :param _IsCustomerFirstCheck: Whether it is the first check. This parameter is used together with `CheckStatus`.
        :type IsCustomerFirstCheck: bool
        :param _CheckStatus: Check status

`CHECK_UNINIT`: Feature not enabled.

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _CheckProgress: Check progress. Value range: 0-100. This field is valid only if the check is running.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckProgress: float
        :param _PassedPolicyItemCount: Number of check items that the asset passed
        :type PassedPolicyItemCount: int
        :param _FailedPolicyItemCount: Number of check items that the asset failed
        :type FailedPolicyItemCount: int
        :param _FailedCriticalPolicyItemCount: Number of critical check items that the asset failed
        :type FailedCriticalPolicyItemCount: int
        :param _FailedHighRiskPolicyItemCount: Number of high-risk check items that the asset failed
        :type FailedHighRiskPolicyItemCount: int
        :param _FailedMediumRiskPolicyItemCount: Number of medium-risk check items that the asset failed
        :type FailedMediumRiskPolicyItemCount: int
        :param _FailedLowRiskPolicyItemCount: Number of low-risk check items that the asset failed
        :type FailedLowRiskPolicyItemCount: int
        :param _NoticePolicyItemCount: Number of prompt check items of the asset
        :type NoticePolicyItemCount: int
        :param _PassedAssetCount: Number of assets that passed the check
        :type PassedAssetCount: int
        :param _FailedAssetCount: Number of assets that failed the check
        :type FailedAssetCount: int
        :param _AssetPassedRate: Asset compliance rate. Value range: 0-100.
        :type AssetPassedRate: float
        :param _ScanFailedAssetCount: Number of assets that failed the check
        :type ScanFailedAssetCount: int
        :param _CheckCostTime: Last check duration in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckCostTime: float
        :param _LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param _PeriodRule: Scheduled check rule
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param _OpenPolicyItemCount: Total number of enabled check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type OpenPolicyItemCount: int
        :param _IgnoredPolicyItemCount: Total number of ignored check items
Note: This field may return null, indicating that no valid values can be obtained.
        :type IgnoredPolicyItemCount: int
        """
        self._AssetType = None
        self._IsCustomerFirstCheck = None
        self._CheckStatus = None
        self._CheckProgress = None
        self._PassedPolicyItemCount = None
        self._FailedPolicyItemCount = None
        self._FailedCriticalPolicyItemCount = None
        self._FailedHighRiskPolicyItemCount = None
        self._FailedMediumRiskPolicyItemCount = None
        self._FailedLowRiskPolicyItemCount = None
        self._NoticePolicyItemCount = None
        self._PassedAssetCount = None
        self._FailedAssetCount = None
        self._AssetPassedRate = None
        self._ScanFailedAssetCount = None
        self._CheckCostTime = None
        self._LastCheckTime = None
        self._PeriodRule = None
        self._OpenPolicyItemCount = None
        self._IgnoredPolicyItemCount = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def IsCustomerFirstCheck(self):
        return self._IsCustomerFirstCheck

    @IsCustomerFirstCheck.setter
    def IsCustomerFirstCheck(self, IsCustomerFirstCheck):
        self._IsCustomerFirstCheck = IsCustomerFirstCheck

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckProgress(self):
        return self._CheckProgress

    @CheckProgress.setter
    def CheckProgress(self, CheckProgress):
        self._CheckProgress = CheckProgress

    @property
    def PassedPolicyItemCount(self):
        return self._PassedPolicyItemCount

    @PassedPolicyItemCount.setter
    def PassedPolicyItemCount(self, PassedPolicyItemCount):
        self._PassedPolicyItemCount = PassedPolicyItemCount

    @property
    def FailedPolicyItemCount(self):
        return self._FailedPolicyItemCount

    @FailedPolicyItemCount.setter
    def FailedPolicyItemCount(self, FailedPolicyItemCount):
        self._FailedPolicyItemCount = FailedPolicyItemCount

    @property
    def FailedCriticalPolicyItemCount(self):
        return self._FailedCriticalPolicyItemCount

    @FailedCriticalPolicyItemCount.setter
    def FailedCriticalPolicyItemCount(self, FailedCriticalPolicyItemCount):
        self._FailedCriticalPolicyItemCount = FailedCriticalPolicyItemCount

    @property
    def FailedHighRiskPolicyItemCount(self):
        return self._FailedHighRiskPolicyItemCount

    @FailedHighRiskPolicyItemCount.setter
    def FailedHighRiskPolicyItemCount(self, FailedHighRiskPolicyItemCount):
        self._FailedHighRiskPolicyItemCount = FailedHighRiskPolicyItemCount

    @property
    def FailedMediumRiskPolicyItemCount(self):
        return self._FailedMediumRiskPolicyItemCount

    @FailedMediumRiskPolicyItemCount.setter
    def FailedMediumRiskPolicyItemCount(self, FailedMediumRiskPolicyItemCount):
        self._FailedMediumRiskPolicyItemCount = FailedMediumRiskPolicyItemCount

    @property
    def FailedLowRiskPolicyItemCount(self):
        return self._FailedLowRiskPolicyItemCount

    @FailedLowRiskPolicyItemCount.setter
    def FailedLowRiskPolicyItemCount(self, FailedLowRiskPolicyItemCount):
        self._FailedLowRiskPolicyItemCount = FailedLowRiskPolicyItemCount

    @property
    def NoticePolicyItemCount(self):
        return self._NoticePolicyItemCount

    @NoticePolicyItemCount.setter
    def NoticePolicyItemCount(self, NoticePolicyItemCount):
        self._NoticePolicyItemCount = NoticePolicyItemCount

    @property
    def PassedAssetCount(self):
        return self._PassedAssetCount

    @PassedAssetCount.setter
    def PassedAssetCount(self, PassedAssetCount):
        self._PassedAssetCount = PassedAssetCount

    @property
    def FailedAssetCount(self):
        return self._FailedAssetCount

    @FailedAssetCount.setter
    def FailedAssetCount(self, FailedAssetCount):
        self._FailedAssetCount = FailedAssetCount

    @property
    def AssetPassedRate(self):
        return self._AssetPassedRate

    @AssetPassedRate.setter
    def AssetPassedRate(self, AssetPassedRate):
        self._AssetPassedRate = AssetPassedRate

    @property
    def ScanFailedAssetCount(self):
        return self._ScanFailedAssetCount

    @ScanFailedAssetCount.setter
    def ScanFailedAssetCount(self, ScanFailedAssetCount):
        self._ScanFailedAssetCount = ScanFailedAssetCount

    @property
    def CheckCostTime(self):
        return self._CheckCostTime

    @CheckCostTime.setter
    def CheckCostTime(self, CheckCostTime):
        self._CheckCostTime = CheckCostTime

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def PeriodRule(self):
        return self._PeriodRule

    @PeriodRule.setter
    def PeriodRule(self, PeriodRule):
        self._PeriodRule = PeriodRule

    @property
    def OpenPolicyItemCount(self):
        return self._OpenPolicyItemCount

    @OpenPolicyItemCount.setter
    def OpenPolicyItemCount(self, OpenPolicyItemCount):
        self._OpenPolicyItemCount = OpenPolicyItemCount

    @property
    def IgnoredPolicyItemCount(self):
        return self._IgnoredPolicyItemCount

    @IgnoredPolicyItemCount.setter
    def IgnoredPolicyItemCount(self, IgnoredPolicyItemCount):
        self._IgnoredPolicyItemCount = IgnoredPolicyItemCount


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._IsCustomerFirstCheck = params.get("IsCustomerFirstCheck")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckProgress = params.get("CheckProgress")
        self._PassedPolicyItemCount = params.get("PassedPolicyItemCount")
        self._FailedPolicyItemCount = params.get("FailedPolicyItemCount")
        self._FailedCriticalPolicyItemCount = params.get("FailedCriticalPolicyItemCount")
        self._FailedHighRiskPolicyItemCount = params.get("FailedHighRiskPolicyItemCount")
        self._FailedMediumRiskPolicyItemCount = params.get("FailedMediumRiskPolicyItemCount")
        self._FailedLowRiskPolicyItemCount = params.get("FailedLowRiskPolicyItemCount")
        self._NoticePolicyItemCount = params.get("NoticePolicyItemCount")
        self._PassedAssetCount = params.get("PassedAssetCount")
        self._FailedAssetCount = params.get("FailedAssetCount")
        self._AssetPassedRate = params.get("AssetPassedRate")
        self._ScanFailedAssetCount = params.get("ScanFailedAssetCount")
        self._CheckCostTime = params.get("CheckCostTime")
        self._LastCheckTime = params.get("LastCheckTime")
        if params.get("PeriodRule") is not None:
            self._PeriodRule = CompliancePeriodTaskRule()
            self._PeriodRule._deserialize(params.get("PeriodRule"))
        self._OpenPolicyItemCount = params.get("OpenPolicyItemCount")
        self._IgnoredPolicyItemCount = params.get("IgnoredPolicyItemCount")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandard(AbstractModel):
    """Information of a compliance standard

    """

    def __init__(self):
        r"""
        :param _StandardId: Compliance standard ID
        :type StandardId: int
        :param _Name: Compliance standard name
        :type Name: str
        :param _PolicyItemCount: Number of items contained in the compliance standard
        :type PolicyItemCount: int
        :param _Enabled: Whether to enable the standard
        :type Enabled: bool
        :param _Description: Description of the standard
        :type Description: str
        """
        self._StandardId = None
        self._Name = None
        self._PolicyItemCount = None
        self._Enabled = None
        self._Description = None

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def PolicyItemCount(self):
        return self._PolicyItemCount

    @PolicyItemCount.setter
    def PolicyItemCount(self, PolicyItemCount):
        self._PolicyItemCount = PolicyItemCount

    @property
    def Enabled(self):
        return self._Enabled

    @Enabled.setter
    def Enabled(self, Enabled):
        self._Enabled = Enabled

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._StandardId = params.get("StandardId")
        self._Name = params.get("Name")
        self._PolicyItemCount = params.get("PolicyItemCount")
        self._Enabled = params.get("Enabled")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceBenchmarkStandardEnable(AbstractModel):
    """Whether to enable the compliance standard

    """

    def __init__(self):
        r"""
        :param _StandardId: Compliance standard ID
        :type StandardId: int
        :param _Enable: Whether to enable the compliance standard
        :type Enable: bool
        """
        self._StandardId = None
        self._Enable = None

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._StandardId = params.get("StandardId")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceContainerDetailInfo(AbstractModel):
    """Container asset details

    """

    def __init__(self):
        r"""
        :param _ContainerId: Container ID on the server
        :type ContainerId: str
        :param _PodName: Pod name of the container
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodName: str
        """
        self._ContainerId = None
        self._PodName = None

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName


    def _deserialize(self, params):
        self._ContainerId = params.get("ContainerId")
        self._PodName = params.get("PodName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceFilters(AbstractModel):
    """Key-value pair filter for conditional filtering queries, such as filter ID, name, and status. If more than one filter exists, the logical relationship between these filters is `AND`. If multiple values exist in one filter, the logical relationship between these values is `OR`.

    """

    def __init__(self):
        r"""
        :param _Name: Filter name
        :type Name: str
        :param _Values: One or more filter values
        :type Values: list of str
        :param _ExactMatch: Whether to use fuzzy query. Default value: `true`.
        :type ExactMatch: bool
        """
        self._Name = None
        self._Values = None
        self._ExactMatch = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Values(self):
        return self._Values

    @Values.setter
    def Values(self, Values):
        self._Values = Values

    @property
    def ExactMatch(self):
        return self._ExactMatch

    @ExactMatch.setter
    def ExactMatch(self, ExactMatch):
        self._ExactMatch = ExactMatch


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Values = params.get("Values")
        self._ExactMatch = params.get("ExactMatch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceHostDetailInfo(AbstractModel):
    """Server asset details

    """

    def __init__(self):
        r"""
        :param _DockerVersion: Docker version on the server
Note: This field may return null, indicating that no valid values can be obtained.
        :type DockerVersion: str
        :param _K8SVersion: K8s version on the server
Note: This field may return null, indicating that no valid values can be obtained.
        :type K8SVersion: str
        """
        self._DockerVersion = None
        self._K8SVersion = None

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def K8SVersion(self):
        return self._K8SVersion

    @K8SVersion.setter
    def K8SVersion(self, K8SVersion):
        self._K8SVersion = K8SVersion


    def _deserialize(self, params):
        self._DockerVersion = params.get("DockerVersion")
        self._K8SVersion = params.get("K8SVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceImageDetailInfo(AbstractModel):
    """Image asset details

    """

    def __init__(self):
        r"""
        :param _ImageId: Image ID on the server
        :type ImageId: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _ImageTag: Image tag
        :type ImageTag: str
        :param _Repository: Path of the remote repository of the image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Repository: str
        """
        self._ImageId = None
        self._ImageName = None
        self._ImageTag = None
        self._Repository = None

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def Repository(self):
        return self._Repository

    @Repository.setter
    def Repository(self, Repository):
        self._Repository = Repository


    def _deserialize(self, params):
        self._ImageId = params.get("ImageId")
        self._ImageName = params.get("ImageName")
        self._ImageTag = params.get("ImageTag")
        self._Repository = params.get("Repository")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceK8SDetailInfo(AbstractModel):
    """K8s asset details

    """

    def __init__(self):
        r"""
        :param _ClusterName: K8s cluster name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterName: str
        :param _ClusterVersion: K8s cluster version
Note: This field may return null, indicating that no valid values can be obtained.
        :type ClusterVersion: str
        """
        self._ClusterName = None
        self._ClusterVersion = None

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion


    def _deserialize(self, params):
        self._ClusterName = params.get("ClusterName")
        self._ClusterVersion = params.get("ClusterVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTask(AbstractModel):
    """Information of a scheduled task of the compliance baseline check

    """

    def __init__(self):
        r"""
        :param _PeriodTaskId: Scheduled task ID
        :type PeriodTaskId: int
        :param _AssetType: Asset type
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param _LastTriggerTime: Last trigger time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastTriggerTime: str
        :param _TotalPolicyItemCount: Total number of check items
        :type TotalPolicyItemCount: int
        :param _PeriodRule: Cycle settings
        :type PeriodRule: :class:`tencentcloud.tcss.v20201101.models.CompliancePeriodTaskRule`
        :param _BenchmarkStandardSet: List of compliance standards
        :type BenchmarkStandardSet: list of ComplianceBenchmarkStandard
        """
        self._PeriodTaskId = None
        self._AssetType = None
        self._LastTriggerTime = None
        self._TotalPolicyItemCount = None
        self._PeriodRule = None
        self._BenchmarkStandardSet = None

    @property
    def PeriodTaskId(self):
        return self._PeriodTaskId

    @PeriodTaskId.setter
    def PeriodTaskId(self, PeriodTaskId):
        self._PeriodTaskId = PeriodTaskId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def LastTriggerTime(self):
        return self._LastTriggerTime

    @LastTriggerTime.setter
    def LastTriggerTime(self, LastTriggerTime):
        self._LastTriggerTime = LastTriggerTime

    @property
    def TotalPolicyItemCount(self):
        return self._TotalPolicyItemCount

    @TotalPolicyItemCount.setter
    def TotalPolicyItemCount(self, TotalPolicyItemCount):
        self._TotalPolicyItemCount = TotalPolicyItemCount

    @property
    def PeriodRule(self):
        return self._PeriodRule

    @PeriodRule.setter
    def PeriodRule(self, PeriodRule):
        self._PeriodRule = PeriodRule

    @property
    def BenchmarkStandardSet(self):
        return self._BenchmarkStandardSet

    @BenchmarkStandardSet.setter
    def BenchmarkStandardSet(self, BenchmarkStandardSet):
        self._BenchmarkStandardSet = BenchmarkStandardSet


    def _deserialize(self, params):
        self._PeriodTaskId = params.get("PeriodTaskId")
        self._AssetType = params.get("AssetType")
        self._LastTriggerTime = params.get("LastTriggerTime")
        self._TotalPolicyItemCount = params.get("TotalPolicyItemCount")
        if params.get("PeriodRule") is not None:
            self._PeriodRule = CompliancePeriodTaskRule()
            self._PeriodRule._deserialize(params.get("PeriodRule"))
        if params.get("BenchmarkStandardSet") is not None:
            self._BenchmarkStandardSet = []
            for item in params.get("BenchmarkStandardSet"):
                obj = ComplianceBenchmarkStandard()
                obj._deserialize(item)
                self._BenchmarkStandardSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePeriodTaskRule(AbstractModel):
    """Cycle of a scheduled task

    """

    def __init__(self):
        r"""
        :param _Frequency: Execution frequency (days). Valid values: `1`, `3`, `7`.
        :type Frequency: int
        :param _ExecutionTime: Execution time in the format of "HH:mm:SS"
        :type ExecutionTime: str
        :param _Enable: Whether to enable
Note: This field may return null, indicating that no valid values can be obtained.
        :type Enable: bool
        """
        self._Frequency = None
        self._ExecutionTime = None
        self._Enable = None

    @property
    def Frequency(self):
        return self._Frequency

    @Frequency.setter
    def Frequency(self, Frequency):
        self._Frequency = Frequency

    @property
    def ExecutionTime(self):
        return self._ExecutionTime

    @ExecutionTime.setter
    def ExecutionTime(self, ExecutionTime):
        self._ExecutionTime = ExecutionTime

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable


    def _deserialize(self, params):
        self._Frequency = params.get("Frequency")
        self._ExecutionTime = params.get("ExecutionTime")
        self._Enable = params.get("Enable")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyAssetSetItem(AbstractModel):
    """List of check item IDs and asset IDs

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: Check item ID
        :type CustomerPolicyItemId: int
        :param _CustomerAssetItemIdSet: List of IDs of assets to be ignored in the specified check item. If it is empty, it indicates all.
        :type CustomerAssetItemIdSet: list of int non-negative
        """
        self._CustomerPolicyItemId = None
        self._CustomerAssetItemIdSet = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def CustomerAssetItemIdSet(self):
        return self._CustomerAssetItemIdSet

    @CustomerAssetItemIdSet.setter
    def CustomerAssetItemIdSet(self, CustomerAssetItemIdSet):
        self._CustomerAssetItemIdSet = CustomerAssetItemIdSet


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._CustomerAssetItemIdSet = params.get("CustomerAssetItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CompliancePolicyItemSummary(AbstractModel):
    """Aggregated information of a check item

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: Unique ID of the customer check item
        :type CustomerPolicyItemId: int
        :param _BasePolicyItemId: Original ID of the check item
        :type BasePolicyItemId: int
        :param _Name: Check item name
        :type Name: str
        :param _Category: Category of the check item, which is an enumerated string.
        :type Category: str
        :param _BenchmarkStandardName: Compliance standard
        :type BenchmarkStandardName: str
        :param _RiskLevel: Severity. Valid values: `RISK_CRITICAL`, `RISK_HIGH`, `RISK_MEDIUM`, `RISK_LOW`, `RISK_NOTICE`.
        :type RiskLevel: str
        :param _AssetType: Asset type of the check item
        :type AssetType: str
        :param _LastCheckTime: Last check time
Note: This field may return null, indicating that no valid values can be obtained.
        :type LastCheckTime: str
        :param _CheckStatus: Check status

`CHECK_INIT`: To be checked.

`CHECK_RUNNING`: Checking.

`CHECK_FINISHED`: Checked.

`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _CheckResult: Check result. Valid values: `RESULT_PASSED`: Passed.

`RESULT_FAILED`: Failed.
Note: This field may return null, indicating that no valid values can be obtained.
        :type CheckResult: str
        :param _PassedAssetCount: Number of assets that passed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type PassedAssetCount: int
        :param _FailedAssetCount: Number of assets that failed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailedAssetCount: int
        :param _WhitelistId: Allowed item ID of the check item. If it exists and is not `0`, the check item is ignored.
Note: This field may return null, indicating that no valid values can be obtained.
        :type WhitelistId: int
        :param _FixSuggestion: Handling suggestion
        :type FixSuggestion: str
        :param _BenchmarkStandardId: Compliance standard ID
        :type BenchmarkStandardId: int
        :param _ApplicableVersion: TCSS editions that support this check item
Note: This field may return `null`, indicating that no valid value was found.
        :type ApplicableVersion: str
        """
        self._CustomerPolicyItemId = None
        self._BasePolicyItemId = None
        self._Name = None
        self._Category = None
        self._BenchmarkStandardName = None
        self._RiskLevel = None
        self._AssetType = None
        self._LastCheckTime = None
        self._CheckStatus = None
        self._CheckResult = None
        self._PassedAssetCount = None
        self._FailedAssetCount = None
        self._WhitelistId = None
        self._FixSuggestion = None
        self._BenchmarkStandardId = None
        self._ApplicableVersion = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def BasePolicyItemId(self):
        return self._BasePolicyItemId

    @BasePolicyItemId.setter
    def BasePolicyItemId(self, BasePolicyItemId):
        self._BasePolicyItemId = BasePolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Category(self):
        return self._Category

    @Category.setter
    def Category(self, Category):
        self._Category = Category

    @property
    def BenchmarkStandardName(self):
        return self._BenchmarkStandardName

    @BenchmarkStandardName.setter
    def BenchmarkStandardName(self, BenchmarkStandardName):
        self._BenchmarkStandardName = BenchmarkStandardName

    @property
    def RiskLevel(self):
        return self._RiskLevel

    @RiskLevel.setter
    def RiskLevel(self, RiskLevel):
        self._RiskLevel = RiskLevel

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def LastCheckTime(self):
        return self._LastCheckTime

    @LastCheckTime.setter
    def LastCheckTime(self, LastCheckTime):
        self._LastCheckTime = LastCheckTime

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def CheckResult(self):
        return self._CheckResult

    @CheckResult.setter
    def CheckResult(self, CheckResult):
        self._CheckResult = CheckResult

    @property
    def PassedAssetCount(self):
        return self._PassedAssetCount

    @PassedAssetCount.setter
    def PassedAssetCount(self, PassedAssetCount):
        self._PassedAssetCount = PassedAssetCount

    @property
    def FailedAssetCount(self):
        return self._FailedAssetCount

    @FailedAssetCount.setter
    def FailedAssetCount(self, FailedAssetCount):
        self._FailedAssetCount = FailedAssetCount

    @property
    def WhitelistId(self):
        return self._WhitelistId

    @WhitelistId.setter
    def WhitelistId(self, WhitelistId):
        self._WhitelistId = WhitelistId

    @property
    def FixSuggestion(self):
        return self._FixSuggestion

    @FixSuggestion.setter
    def FixSuggestion(self, FixSuggestion):
        self._FixSuggestion = FixSuggestion

    @property
    def BenchmarkStandardId(self):
        return self._BenchmarkStandardId

    @BenchmarkStandardId.setter
    def BenchmarkStandardId(self, BenchmarkStandardId):
        self._BenchmarkStandardId = BenchmarkStandardId

    @property
    def ApplicableVersion(self):
        return self._ApplicableVersion

    @ApplicableVersion.setter
    def ApplicableVersion(self, ApplicableVersion):
        self._ApplicableVersion = ApplicableVersion


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._BasePolicyItemId = params.get("BasePolicyItemId")
        self._Name = params.get("Name")
        self._Category = params.get("Category")
        self._BenchmarkStandardName = params.get("BenchmarkStandardName")
        self._RiskLevel = params.get("RiskLevel")
        self._AssetType = params.get("AssetType")
        self._LastCheckTime = params.get("LastCheckTime")
        self._CheckStatus = params.get("CheckStatus")
        self._CheckResult = params.get("CheckResult")
        self._PassedAssetCount = params.get("PassedAssetCount")
        self._FailedAssetCount = params.get("FailedAssetCount")
        self._WhitelistId = params.get("WhitelistId")
        self._FixSuggestion = params.get("FixSuggestion")
        self._BenchmarkStandardId = params.get("BenchmarkStandardId")
        self._ApplicableVersion = params.get("ApplicableVersion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceScanFailedAsset(AbstractModel):
    """Information of the asset that failed the check

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param _AssetType: Asset type
        :type AssetType: str
        :param _CheckStatus: Check status
`CHECK_INIT`: To be checked.
`CHECK_RUNNING`: Checking.
`CHECK_FINISHED`: Checked.
`CHECK_FAILED`: Check failed.
        :type CheckStatus: str
        :param _AssetName: Asset name
        :type AssetName: str
        :param _FailureReason: Cause of the asset check failure
        :type FailureReason: str
        :param _Suggestion: Suggestion for handling the check failure
        :type Suggestion: str
        :param _CheckTime: Check time
        :type CheckTime: str
        """
        self._CustomerAssetId = None
        self._AssetType = None
        self._CheckStatus = None
        self._AssetName = None
        self._FailureReason = None
        self._Suggestion = None
        self._CheckTime = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def AssetName(self):
        return self._AssetName

    @AssetName.setter
    def AssetName(self, AssetName):
        self._AssetName = AssetName

    @property
    def FailureReason(self):
        return self._FailureReason

    @FailureReason.setter
    def FailureReason(self, FailureReason):
        self._FailureReason = FailureReason

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def CheckTime(self):
        return self._CheckTime

    @CheckTime.setter
    def CheckTime(self, CheckTime):
        self._CheckTime = CheckTime


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._AssetType = params.get("AssetType")
        self._CheckStatus = params.get("CheckStatus")
        self._AssetName = params.get("AssetName")
        self._FailureReason = params.get("FailureReason")
        self._Suggestion = params.get("Suggestion")
        self._CheckTime = params.get("CheckTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComplianceWhitelistItem(AbstractModel):
    """Allowed item

    """

    def __init__(self):
        r"""
        :param _WhitelistItemId: Allowed item ID
        :type WhitelistItemId: int
        :param _CustomerPolicyItemId: ID of the customer check item
        :type CustomerPolicyItemId: int
        :param _Name: Check item name
        :type Name: str
        :param _StandardName: Compliance standard name
        :type StandardName: str
        :param _StandardId: Compliance standard ID
        :type StandardId: int
        :param _AffectedAssetCount: Number of assets affected by the check item
        :type AffectedAssetCount: int
        :param _LastUpdateTime: Last update time
        :type LastUpdateTime: str
        :param _InsertTime: Allowed time
        :type InsertTime: str
        """
        self._WhitelistItemId = None
        self._CustomerPolicyItemId = None
        self._Name = None
        self._StandardName = None
        self._StandardId = None
        self._AffectedAssetCount = None
        self._LastUpdateTime = None
        self._InsertTime = None

    @property
    def WhitelistItemId(self):
        return self._WhitelistItemId

    @WhitelistItemId.setter
    def WhitelistItemId(self, WhitelistItemId):
        self._WhitelistItemId = WhitelistItemId

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def StandardName(self):
        return self._StandardName

    @StandardName.setter
    def StandardName(self, StandardName):
        self._StandardName = StandardName

    @property
    def StandardId(self):
        return self._StandardId

    @StandardId.setter
    def StandardId(self, StandardId):
        self._StandardId = StandardId

    @property
    def AffectedAssetCount(self):
        return self._AffectedAssetCount

    @AffectedAssetCount.setter
    def AffectedAssetCount(self, AffectedAssetCount):
        self._AffectedAssetCount = AffectedAssetCount

    @property
    def LastUpdateTime(self):
        return self._LastUpdateTime

    @LastUpdateTime.setter
    def LastUpdateTime(self, LastUpdateTime):
        self._LastUpdateTime = LastUpdateTime

    @property
    def InsertTime(self):
        return self._InsertTime

    @InsertTime.setter
    def InsertTime(self, InsertTime):
        self._InsertTime = InsertTime


    def _deserialize(self, params):
        self._WhitelistItemId = params.get("WhitelistItemId")
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._Name = params.get("Name")
        self._StandardName = params.get("StandardName")
        self._StandardId = params.get("StandardId")
        self._AffectedAssetCount = params.get("AffectedAssetCount")
        self._LastUpdateTime = params.get("LastUpdateTime")
        self._InsertTime = params.get("InsertTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentInfo(AbstractModel):
    """Container component information

    """

    def __init__(self):
        r"""
        :param _Name: Name
        :type Name: str
        :param _Version: Version
        :type Version: str
        """
        self._Name = None
        self._Version = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Version = params.get("Version")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComponentsInfo(AbstractModel):
    """Component information

    """

    def __init__(self):
        r"""
        :param _Component: Component name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Component: str
        :param _Version: Component version information
Note: This field may return null, indicating that no valid values can be obtained.
        :type Version: str
        :param _FixedVersion: Fixed version
Note: This field may return·`null`, indicating that no valid values can be obtained.
        :type FixedVersion: str
        :param _Path: Path
Note: This field may return·`null`, indicating that no valid values can be obtained.
        :type Path: str
        :param _Type: Type
Note: This field may return·`null`, indicating that no valid values can be obtained.
        :type Type: str
        :param _Name: Add-on name
Note: This field may return null, indicating that no valid values can be obtained.
        :type Name: str
        """
        self._Component = None
        self._Version = None
        self._FixedVersion = None
        self._Path = None
        self._Type = None
        self._Name = None

    @property
    def Component(self):
        warnings.warn("parameter `Component` is deprecated", DeprecationWarning) 

        return self._Component

    @Component.setter
    def Component(self, Component):
        warnings.warn("parameter `Component` is deprecated", DeprecationWarning) 

        self._Component = Component

    @property
    def Version(self):
        return self._Version

    @Version.setter
    def Version(self, Version):
        self._Version = Version

    @property
    def FixedVersion(self):
        return self._FixedVersion

    @FixedVersion.setter
    def FixedVersion(self, FixedVersion):
        self._FixedVersion = FixedVersion

    @property
    def Path(self):
        return self._Path

    @Path.setter
    def Path(self, Path):
        self._Path = Path

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name


    def _deserialize(self, params):
        self._Component = params.get("Component")
        self._Version = params.get("Version")
        self._FixedVersion = params.get("FixedVersion")
        self._Path = params.get("Path")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyRequest(AbstractModel):
    """ConfirmNetworkFirewallPolicy request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmNetworkFirewallPolicyResponse(AbstractModel):
    """ConfirmNetworkFirewallPolicy response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the confirmation task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ContainerInfo(AbstractModel):
    """List of containers

    """

    def __init__(self):
        r"""
        :param _ContainerID: Container ID
        :type ContainerID: str
        :param _ContainerName: Container name
        :type ContainerName: str
        :param _Status: Container status
        :type Status: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _RunAs: Operator
        :type RunAs: str
        :param _Cmd: Command line
        :type Cmd: str
        :param _CPUUsage: CPU utilization * 1000
        :type CPUUsage: int
        :param _RamUsage: Memory usage in KB
        :type RamUsage: int
        :param _ImageName: Image name
        :type ImageName: str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _POD: Image ID
        :type POD: str
        :param _HostID: Server ID
        :type HostID: str
        :param _HostIP: Server IP
        :type HostIP: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _HostName: Server name
        :type HostName: str
        :param _PublicIp: Public IP
        :type PublicIp: str
        :param _NetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type NetStatus: str
        :param _NetSubStatus: Sub-status of the network
        :type NetSubStatus: str
        :param _IsolateSource: Isolation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateSource: str
        :param _IsolateTime: Isolation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateTime: str
        :param _NodeID: Super node ID
        :type NodeID: str
        :param _PodIP: Pod IP
        :type PodIP: str
        :param _PodName: Pod name
        :type PodName: str
        :param _NodeType: Node type. Valid values: `NORMAL` (general node), `SUPER` (super node)
        :type NodeType: str
        :param _NodeUniqueID: UID of the super node
        :type NodeUniqueID: str
        :param _PodCpu: Number of CPU cores used by the pod
        :type PodCpu: int
        :param _PodMem: Memory specification of the Pod
        :type PodMem: int
        :param _ClusterName: 
        :type ClusterName: str
        :param _ClusterID: 
        :type ClusterID: str
        :param _PodUid: 
        :type PodUid: str
        """
        self._ContainerID = None
        self._ContainerName = None
        self._Status = None
        self._CreateTime = None
        self._RunAs = None
        self._Cmd = None
        self._CPUUsage = None
        self._RamUsage = None
        self._ImageName = None
        self._ImageID = None
        self._POD = None
        self._HostID = None
        self._HostIP = None
        self._UpdateTime = None
        self._HostName = None
        self._PublicIp = None
        self._NetStatus = None
        self._NetSubStatus = None
        self._IsolateSource = None
        self._IsolateTime = None
        self._NodeID = None
        self._PodIP = None
        self._PodName = None
        self._NodeType = None
        self._NodeUniqueID = None
        self._PodCpu = None
        self._PodMem = None
        self._ClusterName = None
        self._ClusterID = None
        self._PodUid = None

    @property
    def ContainerID(self):
        return self._ContainerID

    @ContainerID.setter
    def ContainerID(self, ContainerID):
        self._ContainerID = ContainerID

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def RunAs(self):
        return self._RunAs

    @RunAs.setter
    def RunAs(self, RunAs):
        self._RunAs = RunAs

    @property
    def Cmd(self):
        return self._Cmd

    @Cmd.setter
    def Cmd(self, Cmd):
        self._Cmd = Cmd

    @property
    def CPUUsage(self):
        return self._CPUUsage

    @CPUUsage.setter
    def CPUUsage(self, CPUUsage):
        self._CPUUsage = CPUUsage

    @property
    def RamUsage(self):
        return self._RamUsage

    @RamUsage.setter
    def RamUsage(self, RamUsage):
        self._RamUsage = RamUsage

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def POD(self):
        return self._POD

    @POD.setter
    def POD(self, POD):
        self._POD = POD

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def NetStatus(self):
        return self._NetStatus

    @NetStatus.setter
    def NetStatus(self, NetStatus):
        self._NetStatus = NetStatus

    @property
    def NetSubStatus(self):
        return self._NetSubStatus

    @NetSubStatus.setter
    def NetSubStatus(self, NetSubStatus):
        self._NetSubStatus = NetSubStatus

    @property
    def IsolateSource(self):
        return self._IsolateSource

    @IsolateSource.setter
    def IsolateSource(self, IsolateSource):
        self._IsolateSource = IsolateSource

    @property
    def IsolateTime(self):
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PodCpu(self):
        return self._PodCpu

    @PodCpu.setter
    def PodCpu(self, PodCpu):
        self._PodCpu = PodCpu

    @property
    def PodMem(self):
        return self._PodMem

    @PodMem.setter
    def PodMem(self, PodMem):
        self._PodMem = PodMem

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def PodUid(self):
        return self._PodUid

    @PodUid.setter
    def PodUid(self, PodUid):
        self._PodUid = PodUid


    def _deserialize(self, params):
        self._ContainerID = params.get("ContainerID")
        self._ContainerName = params.get("ContainerName")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._RunAs = params.get("RunAs")
        self._Cmd = params.get("Cmd")
        self._CPUUsage = params.get("CPUUsage")
        self._RamUsage = params.get("RamUsage")
        self._ImageName = params.get("ImageName")
        self._ImageID = params.get("ImageID")
        self._POD = params.get("POD")
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._UpdateTime = params.get("UpdateTime")
        self._HostName = params.get("HostName")
        self._PublicIp = params.get("PublicIp")
        self._NetStatus = params.get("NetStatus")
        self._NetSubStatus = params.get("NetSubStatus")
        self._IsolateSource = params.get("IsolateSource")
        self._IsolateTime = params.get("IsolateTime")
        self._NodeID = params.get("NodeID")
        self._PodIP = params.get("PodIP")
        self._PodName = params.get("PodName")
        self._NodeType = params.get("NodeType")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PodCpu = params.get("PodCpu")
        self._PodMem = params.get("PodMem")
        self._ClusterName = params.get("ClusterName")
        self._ClusterID = params.get("ClusterID")
        self._PodUid = params.get("PodUid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerMount(AbstractModel):
    """Container mount information

    """

    def __init__(self):
        r"""
        :param _Type: Mount type: `bind`.
        :type Type: str
        :param _Source: Host path
        :type Source: str
        :param _Destination: Path in the container
        :type Destination: str
        :param _Mode: Mode
        :type Mode: str
        :param _RW: Read/Write permission
        :type RW: bool
        :param _Propagation: Propagation type
        :type Propagation: str
        :param _Name: Name
        :type Name: str
        :param _Driver: Driver
        :type Driver: str
        """
        self._Type = None
        self._Source = None
        self._Destination = None
        self._Mode = None
        self._RW = None
        self._Propagation = None
        self._Name = None
        self._Driver = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Source(self):
        return self._Source

    @Source.setter
    def Source(self, Source):
        self._Source = Source

    @property
    def Destination(self):
        return self._Destination

    @Destination.setter
    def Destination(self, Destination):
        self._Destination = Destination

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def RW(self):
        return self._RW

    @RW.setter
    def RW(self, RW):
        self._RW = RW

    @property
    def Propagation(self):
        return self._Propagation

    @Propagation.setter
    def Propagation(self, Propagation):
        self._Propagation = Propagation

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Driver(self):
        return self._Driver

    @Driver.setter
    def Driver(self, Driver):
        self._Driver = Driver


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Source = params.get("Source")
        self._Destination = params.get("Destination")
        self._Mode = params.get("Mode")
        self._RW = params.get("RW")
        self._Propagation = params.get("Propagation")
        self._Name = params.get("Name")
        self._Driver = params.get("Driver")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContainerNetwork(AbstractModel):
    """Container network information

    """

    def __init__(self):
        r"""
        :param _EndpointID: Endpoint ID
        :type EndpointID: str
        :param _Mode: Mode: `bridge`.
        :type Mode: str
        :param _Name: Network name
        :type Name: str
        :param _NetworkID: Network ID
        :type NetworkID: str
        :param _Gateway: Gateway
        :type Gateway: str
        :param _Ipv4: IPv4 address
        :type Ipv4: str
        :param _Ipv6: IPv6 address
        :type Ipv6: str
        :param _MAC: MAC address
        :type MAC: str
        """
        self._EndpointID = None
        self._Mode = None
        self._Name = None
        self._NetworkID = None
        self._Gateway = None
        self._Ipv4 = None
        self._Ipv6 = None
        self._MAC = None

    @property
    def EndpointID(self):
        return self._EndpointID

    @EndpointID.setter
    def EndpointID(self, EndpointID):
        self._EndpointID = EndpointID

    @property
    def Mode(self):
        return self._Mode

    @Mode.setter
    def Mode(self, Mode):
        self._Mode = Mode

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def NetworkID(self):
        return self._NetworkID

    @NetworkID.setter
    def NetworkID(self, NetworkID):
        self._NetworkID = NetworkID

    @property
    def Gateway(self):
        return self._Gateway

    @Gateway.setter
    def Gateway(self, Gateway):
        self._Gateway = Gateway

    @property
    def Ipv4(self):
        return self._Ipv4

    @Ipv4.setter
    def Ipv4(self, Ipv4):
        self._Ipv4 = Ipv4

    @property
    def Ipv6(self):
        return self._Ipv6

    @Ipv6.setter
    def Ipv6(self, Ipv6):
        self._Ipv6 = Ipv6

    @property
    def MAC(self):
        return self._MAC

    @MAC.setter
    def MAC(self, MAC):
        self._MAC = MAC


    def _deserialize(self, params):
        self._EndpointID = params.get("EndpointID")
        self._Mode = params.get("Mode")
        self._Name = params.get("Name")
        self._NetworkID = params.get("NetworkID")
        self._Gateway = params.get("Gateway")
        self._Ipv4 = params.get("Ipv4")
        self._Ipv6 = params.get("Ipv6")
        self._MAC = params.get("MAC")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobRequest(AbstractModel):
    """CreateAbnormalProcessRulesExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions
<li>`RuleType` - String  - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        :param _ExportField: Fields to export
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAbnormalProcessRulesExportJobResponse(AbstractModel):
    """CreateAbnormalProcessRulesExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the exportation task. You can query the task progress by using this ID in the console.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateAccessControlsRuleExportJobRequest(AbstractModel):
    """CreateAccessControlsRuleExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter conditions
<li>`RuleType` - String  - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: list of str
        :param _ExportField: Fields to export
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAccessControlsRuleExportJobResponse(AbstractModel):
    """CreateAccessControlsRuleExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the exportation task. You can query the task progress by using this ID in the console.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskOneKeyRequest(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey request structure.

    """

    def __init__(self):
        r"""
        :param _All: Whether to scan all images
        :type All: bool
        :param _Images: List of scanned images
        :type Images: list of ImageInfo
        :param _ScanType: Array of scan types
        :type ScanType: list of str
        :param _Id: List of IDs of scanned images
        :type Id: list of int non-negative
        """
        self._All = None
        self._Images = None
        self._ScanType = None
        self._Id = None

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._ScanType = params.get("ScanType")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskOneKeyResponse(AbstractModel):
    """CreateAssetImageRegistryScanTaskOneKey response structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: 
        :type TaskID: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageRegistryScanTaskRequest(AbstractModel):
    """CreateAssetImageRegistryScanTask request structure.

    """

    def __init__(self):
        r"""
        :param _All: Whether to scan all images
        :type All: bool
        :param _Images: List of scanned images
        :type Images: list of ImageInfo
        :param _ScanType: Array of scan types
        :type ScanType: list of str
        :param _Id: List of scanned images
        :type Id: list of int non-negative
        :param _Filters: Filter
        :type Filters: list of AssetFilters
        :param _ExcludeImageList: List of images not to be scanned, which is used together with `Filters`.
        :type ExcludeImageList: list of int non-negative
        :param _OnlyScanLatest: Whether to scan only the latest repository images, which is used together with `Filters`.
        :type OnlyScanLatest: bool
        """
        self._All = None
        self._Images = None
        self._ScanType = None
        self._Id = None
        self._Filters = None
        self._ExcludeImageList = None
        self._OnlyScanLatest = None

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExcludeImageList(self):
        return self._ExcludeImageList

    @ExcludeImageList.setter
    def ExcludeImageList(self, ExcludeImageList):
        self._ExcludeImageList = ExcludeImageList

    @property
    def OnlyScanLatest(self):
        return self._OnlyScanLatest

    @OnlyScanLatest.setter
    def OnlyScanLatest(self, OnlyScanLatest):
        self._OnlyScanLatest = OnlyScanLatest


    def _deserialize(self, params):
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._ScanType = params.get("ScanType")
        self._Id = params.get("Id")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExcludeImageList = params.get("ExcludeImageList")
        self._OnlyScanLatest = params.get("OnlyScanLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageRegistryScanTaskResponse(AbstractModel):
    """CreateAssetImageRegistryScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: 
        :type TaskID: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageScanSettingRequest(AbstractModel):
    """CreateAssetImageScanSetting request structure.

    """

    def __init__(self):
        r"""
        :param _Enable: Switch
        :type Enable: bool
        :param _ScanTime: Scan time
        :type ScanTime: str
        :param _ScanPeriod: Scan cycle
        :type ScanPeriod: int
        :param _ScanVirus: Trojan scan
        :type ScanVirus: bool
        :param _ScanRisk: Sensitive data scan
        :type ScanRisk: bool
        :param _ScanVul: Vulnerability scan
        :type ScanVul: bool
        :param _All: All images
        :type All: bool
        :param _Images: Custom image
        :type Images: list of str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._ScanVul = None
        self._All = None
        self._Images = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        self._ScanVul = params.get("ScanVul")
        self._All = params.get("All")
        self._Images = params.get("Images")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanSettingResponse(AbstractModel):
    """CreateAssetImageScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateAssetImageScanTaskRequest(AbstractModel):
    """CreateAssetImageScanTask request structure.

    """

    def __init__(self):
        r"""
        :param _All: Whether to scan all images.
        :type All: bool
        :param _Images: List of images to be scanned.
        :type Images: list of str
        :param _ScanVul: Scan for vulnerabilities.
        :type ScanVul: bool
        :param _ScanVirus: Scan for trojans.
        :type ScanVirus: bool
        :param _ScanRisk: Scan for risks.
        :type ScanRisk: bool
        :param _Filters: Filter
        :type Filters: list of AssetFilters
        :param _ExcludeImageIds: Specified image IDs to be excluded
        :type ExcludeImageIds: list of str
        """
        self._All = None
        self._Images = None
        self._ScanVul = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._Filters = None
        self._ExcludeImageIds = None

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ExcludeImageIds(self):
        return self._ExcludeImageIds

    @ExcludeImageIds.setter
    def ExcludeImageIds(self, ExcludeImageIds):
        self._ExcludeImageIds = ExcludeImageIds


    def _deserialize(self, params):
        self._All = params.get("All")
        self._Images = params.get("Images")
        self._ScanVul = params.get("ScanVul")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._ExcludeImageIds = params.get("ExcludeImageIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageScanTaskResponse(AbstractModel):
    """CreateAssetImageScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: Task ID
        :type TaskID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateAssetImageVirusExportJobRequest(AbstractModel):
    """CreateAssetImageVirusExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Filters: Number of results to be returned. Default value: `10`. Maximum value: `10000`.
        :type Filters: list of AssetFilters
        :param _Limit: Offset. Default value: `0`.
        :type Limit: int
        :param _Offset: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Offset: int
        :param _By: Sorting field
        :type By: str
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAssetImageVirusExportJobResponse(AbstractModel):
    """CreateAssetImageVirusExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateCheckComponentRequest(AbstractModel):
    """CreateCheckComponent request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterInfoList: Information of the list of clusters for installation
        :type ClusterInfoList: list of ClusterCreateComponentItem
        """
        self._ClusterInfoList = None

    @property
    def ClusterInfoList(self):
        return self._ClusterInfoList

    @ClusterInfoList.setter
    def ClusterInfoList(self, ClusterInfoList):
        self._ClusterInfoList = ClusterInfoList


    def _deserialize(self, params):
        if params.get("ClusterInfoList") is not None:
            self._ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = ClusterCreateComponentItem()
                obj._deserialize(item)
                self._ClusterInfoList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCheckComponentResponse(AbstractModel):
    """CreateCheckComponent response structure.

    """

    def __init__(self):
        r"""
        :param _InstallResult: Valid values: `InstallSucc` (installed successfully); `InstallFailed` (failed to install).
        :type InstallResult: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstallResult = None
        self._RequestId = None

    @property
    def InstallResult(self):
        return self._InstallResult

    @InstallResult.setter
    def InstallResult(self, InstallResult):
        self._InstallResult = InstallResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstallResult = params.get("InstallResult")
        self._RequestId = params.get("RequestId")


class CreateClusterCheckTaskRequest(AbstractModel):
    """CreateClusterCheckTask request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterCheckTaskList: Information of the specified cluster to be scanned
        :type ClusterCheckTaskList: list of ClusterCheckTaskItem
        """
        self._ClusterCheckTaskList = None

    @property
    def ClusterCheckTaskList(self):
        return self._ClusterCheckTaskList

    @ClusterCheckTaskList.setter
    def ClusterCheckTaskList(self, ClusterCheckTaskList):
        self._ClusterCheckTaskList = ClusterCheckTaskList


    def _deserialize(self, params):
        if params.get("ClusterCheckTaskList") is not None:
            self._ClusterCheckTaskList = []
            for item in params.get("ClusterCheckTaskList"):
                obj = ClusterCheckTaskItem()
                obj._deserialize(item)
                self._ClusterCheckTaskList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClusterCheckTaskResponse(AbstractModel):
    """CreateClusterCheckTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _CreateResult: Result of creating the check task. Valid values: `Succ` (success); others (failure cause).
        :type CreateResult: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._CreateResult = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CreateResult(self):
        return self._CreateResult

    @CreateResult.setter
    def CreateResult(self, CreateResult):
        self._CreateResult = CreateResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CreateResult = params.get("CreateResult")
        self._RequestId = params.get("RequestId")


class CreateComplianceTaskRequest(AbstractModel):
    """CreateComplianceTask request structure.

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: List of asset types to be scanned
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
A valid value must be entered for the `AssetTypeSet`, `PolicySetId`, or `PeriodTaskId` parameter.
        :type AssetTypeSet: list of str
        :param _PolicySetId: Policy set ID
        :type PolicySetId: int
        :param _PeriodTaskId: Scheduled task ID
        :type PeriodTaskId: int
        """
        self._AssetTypeSet = None
        self._PolicySetId = None
        self._PeriodTaskId = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def PolicySetId(self):
        return self._PolicySetId

    @PolicySetId.setter
    def PolicySetId(self, PolicySetId):
        self._PolicySetId = PolicySetId

    @property
    def PeriodTaskId(self):
        return self._PeriodTaskId

    @PeriodTaskId.setter
    def PeriodTaskId(self, PeriodTaskId):
        self._PeriodTaskId = PeriodTaskId


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._PolicySetId = params.get("PolicySetId")
        self._PeriodTaskId = params.get("PeriodTaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComplianceTaskResponse(AbstractModel):
    """CreateComplianceTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created compliance check task
        :type TaskId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class CreateComponentExportJobRequest(AbstractModel):
    """CreateComponentExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self._ImageID = None
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateComponentExportJobResponse(AbstractModel):
    """CreateComponentExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateDefenceVulExportJobRequest(AbstractModel):
    """CreateDefenceVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateDefenceVulExportJobResponse(AbstractModel):
    """CreateDefenceVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEmergencyVulExportJobRequest(AbstractModel):
    """CreateEmergencyVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEmergencyVulExportJobResponse(AbstractModel):
    """CreateEmergencyVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEscapeEventsExportJobRequest(AbstractModel):
    """CreateEscapeEventsExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field: `latest_found_time`.
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeEventsExportJobResponse(AbstractModel):
    """CreateEscapeEventsExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateEscapeWhiteListExportJobRequest(AbstractModel):
    """CreateEscapeWhiteListExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>EventType- String - Required: No - Allowed event type. Valid values: `ESCAPE_CGROUPS` (cgroup escape); `ESCAPE_TAMPER_SENSITIVE_FILE` (file tamper escape); `ESCAPE_DOCKER_API` (Docker API access escape); `ESCAPE_VUL_OCCURRED` (vulnerability exploit); `MOUNT_SENSITIVE_PTAH` (sensitive path mount); `PRIVILEGE_CONTAINER_START` (privileged container); `PRIVILEGE` (program privilege escalation escape).</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field. Valid values: `HostCount` (number of servers); `ContainerCount` (number of containers); `UpdateTime` (update time).
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEscapeWhiteListExportJobResponse(AbstractModel):
    """CreateEscapeWhiteListExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateExportComplianceStatusListJobRequest(AbstractModel):
    """CreateExportComplianceStatusListJob request structure.

    """

    def __init__(self):
        r"""
        :param _AssetType: Asset type of the information to be exported
        :type AssetType: str
        :param _ExportByAsset: Export by check item or asset. Valid values: `true` (export by asset); `false` (export by check item).
        :type ExportByAsset: bool
        :param _ExportAll: Valid values: `true` (export all); `false` (export based on the `IdList`).
        :type ExportAll: bool
        :param _IdList: List of IDs of assets or check items to be exported, which is determined by the value of `ExportByAsset`.
        :type IdList: list of int non-negative
        """
        self._AssetType = None
        self._ExportByAsset = None
        self._ExportAll = None
        self._IdList = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def ExportByAsset(self):
        return self._ExportByAsset

    @ExportByAsset.setter
    def ExportByAsset(self, ExportByAsset):
        self._ExportByAsset = ExportByAsset

    @property
    def ExportAll(self):
        return self._ExportAll

    @ExportAll.setter
    def ExportAll(self, ExportAll):
        self._ExportAll = ExportAll

    @property
    def IdList(self):
        return self._IdList

    @IdList.setter
    def IdList(self, IdList):
        self._IdList = IdList


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._ExportByAsset = params.get("ExportByAsset")
        self._ExportAll = params.get("ExportAll")
        self._IdList = params.get("IdList")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateExportComplianceStatusListJobResponse(AbstractModel):
    """CreateExportComplianceStatusListJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the created export task
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateHostExportJobRequest(AbstractModel):
    """CreateHostExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>`Status` - String - Optional - Agent status. Values: `ALL`; `UNINSTALL` (Not installed); `OFFLINE`, `ONLINE`. Default to `All` if it's not specified. </li>
<li>`HostName` - String - Optional - Server name</li>
<li>`Group - String - Optional - Server group</li>
<li>`HostIP` - String - Optional - Server IP</li>
<li>`HostID - String - Optional - Server ID</li>
<li>`DockerVersion` - String - Optional - Docker version</li>
<li>`MachineType` - String - Optional - Server type. Values: `ALL`; `CVM` (Cloud Virtual Machine); `ECM` (Edge Computing Machine); `LH` (Lighthouse), `BM` (Cloud Bare Metal); `Other` (non-Tencent Cloud server). Default to `ALL` if it's not specified.</li>
<li>`DockerStatus` - String - Optional - Docker installation status. Values: `ALL`; `INSTALL` (Installed); `UNINSTALL` (Not installed)</li>
<li>`ProjectID` - String - Optional - Project ID</li>
<li>`Tag:xxx(tag:key)` - String - Optional - Tag key-value pair; Example: `Filters":[{"Name":"tag:tke-kind","Values":["service"]}]`</li>
        :type Filters: list of AssetFilters
        :param _Limit: Offset. Default value: `0`.
        :type Limit: int
        :param _Offset: The number of results to return. Default value: 10. Maximum value: 10,000.
        :type Offset: int
        :param _By: Sorting field
        :type By: str
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHostExportJobResponse(AbstractModel):
    """CreateHostExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateImageExportJobRequest(AbstractModel):
    """CreateImageExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of RunTimeFilters
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._By = None
        self._Order = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageExportJobResponse(AbstractModel):
    """CreateImageExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalEventExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>TimeRange - String - Optional - Time range. Example: ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>`MatchRules` - String - Optional - Hit rule</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
<li>`Status` - String - Optional - Event status</li>
<li>`MatchRuleType` - String - Optional - Hit rule type</li>
<li>`ClusterRunningStatus` - String - Optional - Cluster running status</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`ClusterID` - String - Optional - Cluster ID</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalEventExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleExportJobRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>`RuleType` - String - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field
        :type By: list of str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleExportJobResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _RuleInfo: Rule details
        :type RuleInfo: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param _CopySrcRuleID: The ID of the copy rule (for copy rule scenarios)
        :type CopySrcRuleID: str
        :param _EventID: Event ID (for adding events to an allowlist)
        :type EventID: int
        """
        self._RuleInfo = None
        self._CopySrcRuleID = None
        self._EventID = None

    @property
    def RuleInfo(self):
        return self._RuleInfo

    @RuleInfo.setter
    def RuleInfo(self, RuleInfo):
        self._RuleInfo = RuleInfo

    @property
    def CopySrcRuleID(self):
        return self._CopySrcRuleID

    @CopySrcRuleID.setter
    def CopySrcRuleID(self, CopySrcRuleID):
        self._CopySrcRuleID = CopySrcRuleID

    @property
    def EventID(self):
        return self._EventID

    @EventID.setter
    def EventID(self, EventID):
        self._EventID = EventID


    def _deserialize(self, params):
        if params.get("RuleInfo") is not None:
            self._RuleInfo = K8sApiAbnormalRuleInfo()
            self._RuleInfo._deserialize(params.get("RuleInfo"))
        self._CopySrcRuleID = params.get("CopySrcRuleID")
        self._EventID = params.get("EventID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """CreateK8sApiAbnormalRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _RuleID: Rule ID
        :type RuleID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleID = None
        self._RequestId = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallClusterRefreshRequest(AbstractModel):
    """CreateNetworkFirewallClusterRefresh request structure.

    """


class CreateNetworkFirewallClusterRefreshResponse(AbstractModel):
    """CreateNetworkFirewallClusterRefresh response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """CreateNetworkFirewallPolicyDiscover response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallPublishRequest(AbstractModel):
    """CreateNetworkFirewallPublish request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallPublishResponse(AbstractModel):
    """CreateNetworkFirewallPublish response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateNetworkFirewallUndoPublishRequest(AbstractModel):
    """CreateNetworkFirewallUndoPublish request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateNetworkFirewallUndoPublishResponse(AbstractModel):
    """CreateNetworkFirewallUndoPublish response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class CreateOrModifyPostPayCoresRequest(AbstractModel):
    """CreateOrModifyPostPayCores request structure.

    """

    def __init__(self):
        r"""
        :param _CoresCnt: Upper limit for elastic billing. Minimum value: `500`.
        :type CoresCnt: int
        """
        self._CoresCnt = None

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt


    def _deserialize(self, params):
        self._CoresCnt = params.get("CoresCnt")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateOrModifyPostPayCoresResponse(AbstractModel):
    """CreateOrModifyPostPayCores response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateProcessEventsExportJobRequest(AbstractModel):
    """CreateProcessEventsExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of AssetFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field: `latest_found_time`.
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcessEventsExportJobResponse(AbstractModel):
    """CreateProcessEventsExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateRefreshTaskRequest(AbstractModel):
    """CreateRefreshTask request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterIDs: 
        :type ClusterIDs: list of str
        :param _IsSyncListOnly: 
        :type IsSyncListOnly: bool
        """
        self._ClusterIDs = None
        self._IsSyncListOnly = None

    @property
    def ClusterIDs(self):
        return self._ClusterIDs

    @ClusterIDs.setter
    def ClusterIDs(self, ClusterIDs):
        self._ClusterIDs = ClusterIDs

    @property
    def IsSyncListOnly(self):
        return self._IsSyncListOnly

    @IsSyncListOnly.setter
    def IsSyncListOnly(self, IsSyncListOnly):
        self._IsSyncListOnly = IsSyncListOnly


    def _deserialize(self, params):
        self._ClusterIDs = params.get("ClusterIDs")
        self._IsSyncListOnly = params.get("IsSyncListOnly")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRefreshTaskResponse(AbstractModel):
    """CreateRefreshTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created cluster check task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _CreateResult: Result of creating the check task. Valid values: `Succ`, `Failed`.
        :type CreateResult: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._CreateResult = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def CreateResult(self):
        return self._CreateResult

    @CreateResult.setter
    def CreateResult(self, CreateResult):
        self._CreateResult = CreateResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._CreateResult = params.get("CreateResult")
        self._RequestId = params.get("RequestId")


class CreateRiskDnsEventExportJobRequest(AbstractModel):
    """CreateRiskDnsEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>`EventStatus` - String - Optional - Event status. Values: `EVENT_UNDEAL` (Pending); `EVENT_DEALED` (Handled); `EVENT_IGNORE` (Ignored); `EVENT_ADD_WHITE` (Added to the allowlist)</li>
<li>`ContainerStatus` - String - Optional - Container running status. `CREATED`, `RUNNING`, `PAUSED`, `STOPPED`, `RESTARTING`: `REMOVING`, `DESTROYED (Terminated)</li>
<li>`ContainerNetStatus` - String - Optional - Container network status. Values: `NORMAL`, `ISOLATED`, `ISOLATE_FAILED` (Isolation failed`; `RESTORE_FAILED` (Failed to restore from isolation), `RESTORING` (Restoring); `ISOLATING`</li>
<li>`EventType` - String - Optional - Event type. Values: `DOMAIN` (Malicious domain); `IP` (Malicious IP)</li>
<li>`TimeRange` - String - Optional - Time range, where the first value represents the start time and the second value represents the end time</li>
<li>`RiskDns` - String - Optional - Malicious domain. </li>
<li>`RiskIP`- String - Optional - Malicious IP. </li>
<li>`ContainerName` - String - Optional - Container name. </li>
<li>`ContainerID` - String - Optional - Container ID. </li>
<li>`ImageName` - String - Optional - Image name. </li>
<li>`ImageID` - String - Optional - Image ID. </li>
<li>`HostName` - String - Optional - Server name. </li>
<li>`HostIP` - String - Optional - Private IP. </li>
<li>`PublicIP` - String - Optional - Public IP. </li>
        :type Filters: list of RunTimeFilters
        :param _Limit: The number of results displayed per page. The maximum value is 100,000.
        :type Limit: int
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Order: Sort order: `asc`, `desc`
        :type Order: str
        :param _By: Sorting field: Number of events: EventCount
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRiskDnsEventExportJobResponse(AbstractModel):
    """CreateRiskDnsEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: ID of the exportation job. You can query the job progress by using this ID on the console.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateSearchTemplateRequest(AbstractModel):
    """CreateSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SearchTemplate: Search template
        :type SearchTemplate: :class:`tencentcloud.tcss.v20201101.models.SearchTemplate`
        """
        self._SearchTemplate = None

    @property
    def SearchTemplate(self):
        return self._SearchTemplate

    @SearchTemplate.setter
    def SearchTemplate(self, SearchTemplate):
        self._SearchTemplate = SearchTemplate


    def _deserialize(self, params):
        if params.get("SearchTemplate") is not None:
            self._SearchTemplate = SearchTemplate()
            self._SearchTemplate._deserialize(params.get("SearchTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSearchTemplateResponse(AbstractModel):
    """CreateSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSystemVulExportJobRequest(AbstractModel):
    """CreateSystemVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CategoryType- string - Required: No - Sub-type of the vulnerability</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSystemVulExportJobResponse(AbstractModel):
    """CreateSystemVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVirusScanAgainRequest(AbstractModel):
    """CreateVirusScanAgain request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: str
        :param _ContainerIds: Set of IDs of containers to be scanned
        :type ContainerIds: list of str
        :param _TimeoutAll: Whether to scan all timed-out containers
        :type TimeoutAll: bool
        :param _Timeout: New timeout period
        :type Timeout: int
        """
        self._TaskId = None
        self._ContainerIds = None
        self._TimeoutAll = None
        self._Timeout = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ContainerIds(self):
        return self._ContainerIds

    @ContainerIds.setter
    def ContainerIds(self, ContainerIds):
        self._ContainerIds = ContainerIds

    @property
    def TimeoutAll(self):
        return self._TimeoutAll

    @TimeoutAll.setter
    def TimeoutAll(self, TimeoutAll):
        self._TimeoutAll = TimeoutAll

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ContainerIds = params.get("ContainerIds")
        self._TimeoutAll = params.get("TimeoutAll")
        self._Timeout = params.get("Timeout")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanAgainResponse(AbstractModel):
    """CreateVirusScanAgain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateVirusScanTaskRequest(AbstractModel):
    """CreateVirusScanTask request structure.

    """

    def __init__(self):
        r"""
        :param _ScanPathAll: Whether to scan all paths
        :type ScanPathAll: bool
        :param _ScanRangeType: Scanning scope. Valid values: `0` (container); `1` (server).
        :type ScanRangeType: int
        :param _ScanRangeAll: Valid values: `true` (all); `false` (specified).
        :type ScanRangeAll: bool
        :param _Timeout: Timeout period in hours
        :type Timeout: int
        :param _ScanPathType: Valid when `ScanPathAll` is `false`. Valid values: `0` (scan the following paths); `1` (scan all paths except the following).
        :type ScanPathType: int
        :param _ScanIds: ID of the specified container or server to be scanned, which is based on `ScanRangeType`.
        :type ScanIds: list of str
        :param _ScanPath: Specified path to be excluded or scanned
        :type ScanPath: list of str
        :param _ScanPathMode: Path scanning mode: 
`SCAN_PATH_ALL`: Scan all paths
`SCAN_PATH_DEFAULT`: Scan the default path
`SCAN_PATH_USER_DEFINE`: Scan the custom path

        :type ScanPathMode: str
        """
        self._ScanPathAll = None
        self._ScanRangeType = None
        self._ScanRangeAll = None
        self._Timeout = None
        self._ScanPathType = None
        self._ScanIds = None
        self._ScanPath = None
        self._ScanPathMode = None

    @property
    def ScanPathAll(self):
        return self._ScanPathAll

    @ScanPathAll.setter
    def ScanPathAll(self, ScanPathAll):
        self._ScanPathAll = ScanPathAll

    @property
    def ScanRangeType(self):
        return self._ScanRangeType

    @ScanRangeType.setter
    def ScanRangeType(self, ScanRangeType):
        self._ScanRangeType = ScanRangeType

    @property
    def ScanRangeAll(self):
        return self._ScanRangeAll

    @ScanRangeAll.setter
    def ScanRangeAll(self, ScanRangeAll):
        self._ScanRangeAll = ScanRangeAll

    @property
    def Timeout(self):
        return self._Timeout

    @Timeout.setter
    def Timeout(self, Timeout):
        self._Timeout = Timeout

    @property
    def ScanPathType(self):
        return self._ScanPathType

    @ScanPathType.setter
    def ScanPathType(self, ScanPathType):
        self._ScanPathType = ScanPathType

    @property
    def ScanIds(self):
        return self._ScanIds

    @ScanIds.setter
    def ScanIds(self, ScanIds):
        self._ScanIds = ScanIds

    @property
    def ScanPath(self):
        return self._ScanPath

    @ScanPath.setter
    def ScanPath(self, ScanPath):
        self._ScanPath = ScanPath

    @property
    def ScanPathMode(self):
        return self._ScanPathMode

    @ScanPathMode.setter
    def ScanPathMode(self, ScanPathMode):
        self._ScanPathMode = ScanPathMode


    def _deserialize(self, params):
        self._ScanPathAll = params.get("ScanPathAll")
        self._ScanRangeType = params.get("ScanRangeType")
        self._ScanRangeAll = params.get("ScanRangeAll")
        self._Timeout = params.get("Timeout")
        self._ScanPathType = params.get("ScanPathType")
        self._ScanIds = params.get("ScanIds")
        self._ScanPath = params.get("ScanPath")
        self._ScanPathMode = params.get("ScanPathMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVirusScanTaskResponse(AbstractModel):
    """CreateVirusScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: Task ID
        :type TaskID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class CreateVulContainerExportJobRequest(AbstractModel):
    """CreateVulContainerExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _PocID: POC ID
        :type PocID: str
        :param _Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- String - Required: No - Container name</li>
        :type Filters: list of RunTimeFilters
        """
        self._PocID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulContainerExportJobResponse(AbstractModel):
    """CreateVulContainerExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulDefenceEventExportJobRequest(AbstractModel):
    """CreateVulDefenceEventExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_IGNORE` (ignored); `EVENT_DEFENDED` (defended).</li>
<li>ContainerStatus- String - Required: No - Container status. Valid values: `CREATED` (created); `RUNNING` (running); `PAUSED` (suspended); 	`STOPPED` (stopped); `RESTARTING` (restarting); `REMOVING` (removing); `DESTROYED` (terminated).</li>
<li>ContainerNetStatus- String - Required: No - Container network status. Valid values: `NORMAL` (not isolated); `ISOLATED` (isolated); `ISOLATE_FAILED` (isolation failed); `RESTORE_FAILED` (recovery failed); `RESTORING` (recovering); `ISOLATING` (isolating).</li>
<li>EventType - String - Required: No - Intrusion status. Valid values: `EVENT_DEFENDED` (defended successfully); `EVENT_ATTACK` (attack attempt).</li>
<li>TimeRange- String - Required: No - Time range. The first value indicates the start time, and the second the end time.</li>
<li>VulName- string - Required: No - Vulnerability name</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>SourceIP- string - Required: No - Attacker IP</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>HostName- string - Required: No - Server name</li>
<li>HostIP- string - Required: No - Private IP</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Maximum value: `100000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field: `EventCount` (number of events).
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceEventExportJobResponse(AbstractModel):
    """CreateVulDefenceEventExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulDefenceHostExportJobRequest(AbstractModel):
    """CreateVulDefenceHostExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>Status- String - Required: No - Plugin status. Valid values: `SUCCESS` (normal); `FAIL` (abnormal); `NO_DEFENCE` (not defended).</li>
<li>KeyWords- string - Required: No - Server name/IP</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Maximum value: `100000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field. Valid values: `ModifyTime` (update time); `CreateTime` (first enablement time).
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulDefenceHostExportJobResponse(AbstractModel):
    """CreateVulDefenceHostExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulExportJobRequest(AbstractModel):
    """CreateVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10000`. Maximum value: `10000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self._ImageID = None
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulExportJobResponse(AbstractModel):
    """CreateVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulImageExportJobRequest(AbstractModel):
    """CreateVulImageExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _PocID: POC ID
        :type PocID: str
        :param _Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>OnlyAffectedNewestImage- Bool- Required: No - Show only vulnerabilities that affect the latest image tags</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ClientIP- string - Required: No - Private IP</li>
<li>PublicIP- string - Required: No - Public IP</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>HostName- string - Required: No - Server name</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._PocID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulImageExportJobResponse(AbstractModel):
    """CreateVulImageExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class CreateVulScanTaskRequest(AbstractModel):
    """CreateVulScanTask request structure.

    """

    def __init__(self):
        r"""
        :param _LocalImageScanType: Local image scan scope. Valid values: `ALL` (all local images); `NOT_SCAN` (all licensed but not scanned local images); `IMAGEIDS` (IDs of specified local images).
        :type LocalImageScanType: str
        :param _LocalImageIDs: Scan by licensed local image ID, with a higher priority than scan by licensed local image that meets the condition.
        :type LocalImageIDs: list of str
        :param _RegistryImageScanType: Repository image scan scope. Valid values: `ALL` (all repository images); `NOT_SCAN` (all licensed but not scanned repository images); `IMAGEIDS` (IDs of specified repository images).
        :type RegistryImageScanType: str
        :param _RegistryImageIDs: Scan by licensed repository image ID, with a higher priority than scan by licensed repository image that meets the condition.
        :type RegistryImageIDs: list of int non-negative
        :param _LocalTaskID: ID of the task to scan local images again for vulnerabilities
        :type LocalTaskID: int
        :param _RegistryTaskID: ID of the task to scan repository images again for vulnerabilities
        :type RegistryTaskID: int
        """
        self._LocalImageScanType = None
        self._LocalImageIDs = None
        self._RegistryImageScanType = None
        self._RegistryImageIDs = None
        self._LocalTaskID = None
        self._RegistryTaskID = None

    @property
    def LocalImageScanType(self):
        return self._LocalImageScanType

    @LocalImageScanType.setter
    def LocalImageScanType(self, LocalImageScanType):
        self._LocalImageScanType = LocalImageScanType

    @property
    def LocalImageIDs(self):
        return self._LocalImageIDs

    @LocalImageIDs.setter
    def LocalImageIDs(self, LocalImageIDs):
        self._LocalImageIDs = LocalImageIDs

    @property
    def RegistryImageScanType(self):
        return self._RegistryImageScanType

    @RegistryImageScanType.setter
    def RegistryImageScanType(self, RegistryImageScanType):
        self._RegistryImageScanType = RegistryImageScanType

    @property
    def RegistryImageIDs(self):
        return self._RegistryImageIDs

    @RegistryImageIDs.setter
    def RegistryImageIDs(self, RegistryImageIDs):
        self._RegistryImageIDs = RegistryImageIDs

    @property
    def LocalTaskID(self):
        return self._LocalTaskID

    @LocalTaskID.setter
    def LocalTaskID(self, LocalTaskID):
        self._LocalTaskID = LocalTaskID

    @property
    def RegistryTaskID(self):
        return self._RegistryTaskID

    @RegistryTaskID.setter
    def RegistryTaskID(self, RegistryTaskID):
        self._RegistryTaskID = RegistryTaskID


    def _deserialize(self, params):
        self._LocalImageScanType = params.get("LocalImageScanType")
        self._LocalImageIDs = params.get("LocalImageIDs")
        self._RegistryImageScanType = params.get("RegistryImageScanType")
        self._RegistryImageIDs = params.get("RegistryImageIDs")
        self._LocalTaskID = params.get("LocalTaskID")
        self._RegistryTaskID = params.get("RegistryTaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVulScanTaskResponse(AbstractModel):
    """CreateVulScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _LocalTaskID: ID of the task to scan local images again for vulnerabilities
        :type LocalTaskID: int
        :param _RegistryTaskID: ID of the task to scan repository images again for vulnerabilities
        :type RegistryTaskID: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LocalTaskID = None
        self._RegistryTaskID = None
        self._RequestId = None

    @property
    def LocalTaskID(self):
        return self._LocalTaskID

    @LocalTaskID.setter
    def LocalTaskID(self, LocalTaskID):
        self._LocalTaskID = LocalTaskID

    @property
    def RegistryTaskID(self):
        return self._RegistryTaskID

    @RegistryTaskID.setter
    def RegistryTaskID(self, RegistryTaskID):
        self._RegistryTaskID = RegistryTaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LocalTaskID = params.get("LocalTaskID")
        self._RegistryTaskID = params.get("RegistryTaskID")
        self._RequestId = params.get("RequestId")


class CreateWebVulExportJobRequest(AbstractModel):
    """CreateWebVulExportJob request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `50000`. Maximum value: `50000`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CategoryType- string - Required: No - Sub-type of the vulnerability</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWebVulExportJobResponse(AbstractModel):
    """CreateWebVulExportJob response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DeleteAbnormalProcessRulesRequest(AbstractModel):
    """DeleteAbnormalProcessRules request structure.

    """

    def __init__(self):
        r"""
        :param _RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        """
        self._RuleIdSet = None

    @property
    def RuleIdSet(self):
        return self._RuleIdSet

    @RuleIdSet.setter
    def RuleIdSet(self, RuleIdSet):
        self._RuleIdSet = RuleIdSet


    def _deserialize(self, params):
        self._RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAbnormalProcessRulesResponse(AbstractModel):
    """DeleteAbnormalProcessRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAccessControlRulesRequest(AbstractModel):
    """DeleteAccessControlRules request structure.

    """

    def __init__(self):
        r"""
        :param _RuleIdSet: Policy IDs
        :type RuleIdSet: list of str
        """
        self._RuleIdSet = None

    @property
    def RuleIdSet(self):
        return self._RuleIdSet

    @RuleIdSet.setter
    def RuleIdSet(self, RuleIdSet):
        self._RuleIdSet = RuleIdSet


    def _deserialize(self, params):
        self._RuleIdSet = params.get("RuleIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAccessControlRulesResponse(AbstractModel):
    """DeleteAccessControlRules response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteComplianceAssetPolicySetFromWhitelistRequest(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _AssetItemId: Asset ID
        :type AssetItemId: int
        :param _CustomerPolicyItemIdSet: List of IDs of check items to be ignored in the specified asset
        :type CustomerPolicyItemIdSet: list of int non-negative
        """
        self._AssetItemId = None
        self._CustomerPolicyItemIdSet = None

    @property
    def AssetItemId(self):
        return self._AssetItemId

    @AssetItemId.setter
    def AssetItemId(self, AssetItemId):
        self._AssetItemId = AssetItemId

    @property
    def CustomerPolicyItemIdSet(self):
        return self._CustomerPolicyItemIdSet

    @CustomerPolicyItemIdSet.setter
    def CustomerPolicyItemIdSet(self, CustomerPolicyItemIdSet):
        self._CustomerPolicyItemIdSet = CustomerPolicyItemIdSet


    def _deserialize(self, params):
        self._AssetItemId = params.get("AssetItemId")
        self._CustomerPolicyItemIdSet = params.get("CustomerPolicyItemIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteComplianceAssetPolicySetFromWhitelistResponse(AbstractModel):
    """DeleteComplianceAssetPolicySetFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCompliancePolicyAssetSetFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _PolicyAssetSetList: List of check item IDs and asset IDs
        :type PolicyAssetSetList: list of CompliancePolicyAssetSetItem
        """
        self._PolicyAssetSetList = None

    @property
    def PolicyAssetSetList(self):
        return self._PolicyAssetSetList

    @PolicyAssetSetList.setter
    def PolicyAssetSetList(self, PolicyAssetSetList):
        self._PolicyAssetSetList = PolicyAssetSetList


    def _deserialize(self, params):
        if params.get("PolicyAssetSetList") is not None:
            self._PolicyAssetSetList = []
            for item in params.get("PolicyAssetSetList"):
                obj = CompliancePolicyAssetSetItem()
                obj._deserialize(item)
                self._PolicyAssetSetList.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyAssetSetFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyAssetSetFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCompliancePolicyItemFromWhitelistRequest(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist request structure.

    """

    def __init__(self):
        r"""
        :param _WhitelistIdSet: List of IDs of specified allowed items
        :type WhitelistIdSet: list of int non-negative
        """
        self._WhitelistIdSet = None

    @property
    def WhitelistIdSet(self):
        return self._WhitelistIdSet

    @WhitelistIdSet.setter
    def WhitelistIdSet(self, WhitelistIdSet):
        self._WhitelistIdSet = WhitelistIdSet


    def _deserialize(self, params):
        self._WhitelistIdSet = params.get("WhitelistIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCompliancePolicyItemFromWhitelistResponse(AbstractModel):
    """DeleteCompliancePolicyItemFromWhitelist response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEscapeWhiteListRequest(AbstractModel):
    """DeleteEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _IDSet: Array of allowed item IDs
        :type IDSet: list of int
        """
        self._IDSet = None

    @property
    def IDSet(self):
        return self._IDSet

    @IDSet.setter
    def IDSet(self, IDSet):
        self._IDSet = IDSet


    def _deserialize(self, params):
        self._IDSet = params.get("IDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEscapeWhiteListResponse(AbstractModel):
    """DeleteEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteIgnoreVulRequest(AbstractModel):
    """DeleteIgnoreVul request structure.

    """

    def __init__(self):
        r"""
        :param _List: List of POC IDs
        :type List: list of ModifyIgnoreVul
        """
        self._List = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ModifyIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteIgnoreVulResponse(AbstractModel):
    """DeleteIgnoreVul response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteK8sApiAbnormalRuleRequest(AbstractModel):
    """DeleteK8sApiAbnormalRule request structure.

    """

    def __init__(self):
        r"""
        :param _RuleIDSet: Rule ID set
        :type RuleIDSet: list of str
        """
        self._RuleIDSet = None

    @property
    def RuleIDSet(self):
        return self._RuleIDSet

    @RuleIDSet.setter
    def RuleIDSet(self, RuleIDSet):
        self._RuleIDSet = RuleIDSet


    def _deserialize(self, params):
        self._RuleIDSet = params.get("RuleIDSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteK8sApiAbnormalRuleResponse(AbstractModel):
    """DeleteK8sApiAbnormalRule response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMachineRequest(AbstractModel):
    """DeleteMachine request structure.

    """

    def __init__(self):
        r"""
        :param _Uuid: Agent UUID
        :type Uuid: str
        """
        self._Uuid = None

    @property
    def Uuid(self):
        return self._Uuid

    @Uuid.setter
    def Uuid(self, Uuid):
        self._Uuid = Uuid


    def _deserialize(self, params):
        self._Uuid = params.get("Uuid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMachineResponse(AbstractModel):
    """DeleteMachine response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Id: Array of cluster IDs
        :type Id: list of int non-negative
        """
        self._ClusterId = None
        self._Id = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DeleteNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the created task. `0` indicates that the creation failed.
        :type TaskId: int
        :param _Result: Result of creating the deletion task. Valid values: `Succ`, `Failed`.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._Result = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class DeleteReverseShellEventsRequest(AbstractModel):
    """DeleteReverseShellEvents request structure.

    """

    def __init__(self):
        r"""
        :param _EventIdSet: Event IDs
        :type EventIdSet: list of str
        """
        self._EventIdSet = None

    @property
    def EventIdSet(self):
        return self._EventIdSet

    @EventIdSet.setter
    def EventIdSet(self, EventIdSet):
        self._EventIdSet = EventIdSet


    def _deserialize(self, params):
        self._EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellEventsResponse(AbstractModel):
    """DeleteReverseShellEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReverseShellWhiteListsRequest(AbstractModel):
    """DeleteReverseShellWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListIdSet: IDs of allowed items
        :type WhiteListIdSet: list of str
        """
        self._WhiteListIdSet = None

    @property
    def WhiteListIdSet(self):
        return self._WhiteListIdSet

    @WhiteListIdSet.setter
    def WhiteListIdSet(self, WhiteListIdSet):
        self._WhiteListIdSet = WhiteListIdSet


    def _deserialize(self, params):
        self._WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReverseShellWhiteListsResponse(AbstractModel):
    """DeleteReverseShellWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskSyscallEventsRequest(AbstractModel):
    """DeleteRiskSyscallEvents request structure.

    """

    def __init__(self):
        r"""
        :param _EventIdSet: Event IDs
        :type EventIdSet: list of str
        """
        self._EventIdSet = None

    @property
    def EventIdSet(self):
        return self._EventIdSet

    @EventIdSet.setter
    def EventIdSet(self, EventIdSet):
        self._EventIdSet = EventIdSet


    def _deserialize(self, params):
        self._EventIdSet = params.get("EventIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallEventsResponse(AbstractModel):
    """DeleteRiskSyscallEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRiskSyscallWhiteListsRequest(AbstractModel):
    """DeleteRiskSyscallWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListIdSet: IDs of allowed items
        :type WhiteListIdSet: list of str
        """
        self._WhiteListIdSet = None

    @property
    def WhiteListIdSet(self):
        return self._WhiteListIdSet

    @WhiteListIdSet.setter
    def WhiteListIdSet(self, WhiteListIdSet):
        self._WhiteListIdSet = WhiteListIdSet


    def _deserialize(self, params):
        self._WhiteListIdSet = params.get("WhiteListIdSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRiskSyscallWhiteListsResponse(AbstractModel):
    """DeleteRiskSyscallWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSearchTemplateRequest(AbstractModel):
    """DeleteSearchTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Template ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSearchTemplateResponse(AbstractModel):
    """DeleteSearchTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeABTestConfigRequest(AbstractModel):
    """DescribeABTestConfig request structure.

    """

    def __init__(self):
        r"""
        :param _ProjectName: Canary project name
        :type ProjectName: str
        """
        self._ProjectName = None

    @property
    def ProjectName(self):
        return self._ProjectName

    @ProjectName.setter
    def ProjectName(self, ProjectName):
        self._ProjectName = ProjectName


    def _deserialize(self, params):
        self._ProjectName = params.get("ProjectName")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeABTestConfigResponse(AbstractModel):
    """DescribeABTestConfig response structure.

    """

    def __init__(self):
        r"""
        :param _Config: Canary project configuration
        :type Config: list of ABTestConfig
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Config = None
        self._RequestId = None

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Config") is not None:
            self._Config = []
            for item in params.get("Config"):
                obj = ABTestConfig()
                obj._deserialize(item)
                self._Config.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessDetailRequest(AbstractModel):
    """DescribeAbnormalProcessDetail request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Unique event ID
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessDetailResponse(AbstractModel):
    """DescribeAbnormalProcessDetail response structure.

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessEventDescription`
        :param _AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = AbnormalProcessEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventTendencyRequest(AbstractModel):
    """DescribeAbnormalProcessEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventTendencyResponse(AbstractModel):
    """DescribeAbnormalProcessEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param _List: Trend of pending abnormal process events
        :type List: list of AbnormalProcessEventTendencyInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AbnormalProcessEventTendencyInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsExportRequest(AbstractModel):
    """DescribeAbnormalProcessEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsExportResponse(AbstractModel):
    """DescribeAbnormalProcessEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessEventsRequest(AbstractModel):
    """DescribeAbnormalProcessEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessEventsResponse(AbstractModel):
    """DescribeAbnormalProcessEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _EventSet: Array of abnormal processes
        :type EventSet: list of AbnormalProcessEventInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = AbnormalProcessEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessLevelSummaryRequest(AbstractModel):
    """DescribeAbnormalProcessLevelSummary request structure.

    """


class DescribeAbnormalProcessLevelSummaryResponse(AbstractModel):
    """DescribeAbnormalProcessLevelSummary response structure.

    """

    def __init__(self):
        r"""
        :param _HighLevelEventCount: Number of pending high-risk events of abnormal processes
        :type HighLevelEventCount: int
        :param _MediumLevelEventCount: Number of pending medium-risk events of abnormal processes
        :type MediumLevelEventCount: int
        :param _LowLevelEventCount: Number of pending low-risk events of abnormal processes
        :type LowLevelEventCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HighLevelEventCount = None
        self._MediumLevelEventCount = None
        self._LowLevelEventCount = None
        self._RequestId = None

    @property
    def HighLevelEventCount(self):
        return self._HighLevelEventCount

    @HighLevelEventCount.setter
    def HighLevelEventCount(self, HighLevelEventCount):
        self._HighLevelEventCount = HighLevelEventCount

    @property
    def MediumLevelEventCount(self):
        return self._MediumLevelEventCount

    @MediumLevelEventCount.setter
    def MediumLevelEventCount(self, MediumLevelEventCount):
        self._MediumLevelEventCount = MediumLevelEventCount

    @property
    def LowLevelEventCount(self):
        return self._LowLevelEventCount

    @LowLevelEventCount.setter
    def LowLevelEventCount(self, LowLevelEventCount):
        self._LowLevelEventCount = LowLevelEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HighLevelEventCount = params.get("HighLevelEventCount")
        self._MediumLevelEventCount = params.get("MediumLevelEventCount")
        self._LowLevelEventCount = params.get("LowLevelEventCount")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRuleDetailRequest(AbstractModel):
    """DescribeAbnormalProcessRuleDetail request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Unique policy ID
        :type RuleId: str
        :param _ImageId: Image ID, which is used when an image is added to the allowlist.
        :type ImageId: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self._RuleId = None
        self._ImageId = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ImageId = params.get("ImageId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRuleDetailResponse(AbstractModel):
    """DescribeAbnormalProcessRuleDetail response structure.

    """

    def __init__(self):
        r"""
        :param _RuleDetail: Details of the abnormal process policy
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AbnormalProcessRuleInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleDetail = None
        self._RequestId = None

    @property
    def RuleDetail(self):
        return self._RuleDetail

    @RuleDetail.setter
    def RuleDetail(self, RuleDetail):
        self._RuleDetail = RuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self._RuleDetail = AbnormalProcessRuleInfo()
            self._RuleDetail._deserialize(params.get("RuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesExportRequest(AbstractModel):
    """DescribeAbnormalProcessRulesExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesExportResponse(AbstractModel):
    """DescribeAbnormalProcessRulesExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAbnormalProcessRulesRequest(AbstractModel):
    """DescribeAbnormalProcessRules request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAbnormalProcessRulesResponse(AbstractModel):
    """DescribeAbnormalProcessRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _RuleSet: List of abnormal process policies
        :type RuleSet: list of RuleBaseInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessControlDetailRequest(AbstractModel):
    """DescribeAccessControlDetail request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Unique event ID
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlDetailResponse(AbstractModel):
    """DescribeAccessControlDetail response structure.

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _TamperedFileInfo: Information tampered with
        :type TamperedFileInfo: :class:`tencentcloud.tcss.v20201101.models.FileAttributeInfo`
        :param _EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlEventDescription`
        :param _ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._TamperedFileInfo = None
        self._EventDetail = None
        self._ParentProcessInfo = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def TamperedFileInfo(self):
        return self._TamperedFileInfo

    @TamperedFileInfo.setter
    def TamperedFileInfo(self, TamperedFileInfo):
        self._TamperedFileInfo = TamperedFileInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("TamperedFileInfo") is not None:
            self._TamperedFileInfo = FileAttributeInfo()
            self._TamperedFileInfo._deserialize(params.get("TamperedFileInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = AccessControlEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeAccessControlEventsExportRequest(AbstractModel):
    """DescribeAccessControlEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsExportResponse(AbstractModel):
    """DescribeAccessControlEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeAccessControlEventsRequest(AbstractModel):
    """DescribeAccessControlEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlEventsResponse(AbstractModel):
    """DescribeAccessControlEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _EventSet: Array of access control events
        :type EventSet: list of AccessControlEventInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = AccessControlEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRuleDetailRequest(AbstractModel):
    """DescribeAccessControlRuleDetail request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Unique policy ID
        :type RuleId: str
        :param _ImageId: Image ID, which is used only when allowing an event.
        :type ImageId: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self._RuleId = None
        self._ImageId = None
        self._Limit = None
        self._Offset = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._ImageId = params.get("ImageId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRuleDetailResponse(AbstractModel):
    """DescribeAccessControlRuleDetail response structure.

    """

    def __init__(self):
        r"""
        :param _RuleDetail: Runtime policy details
        :type RuleDetail: :class:`tencentcloud.tcss.v20201101.models.AccessControlRuleInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleDetail = None
        self._RequestId = None

    @property
    def RuleDetail(self):
        return self._RuleDetail

    @RuleDetail.setter
    def RuleDetail(self, RuleDetail):
        self._RuleDetail = RuleDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleDetail") is not None:
            self._RuleDetail = AccessControlRuleInfo()
            self._RuleDetail._deserialize(params.get("RuleDetail"))
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRulesExportRequest(AbstractModel):
    """DescribeAccessControlRulesExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesExportResponse(AbstractModel):
    """DescribeAccessControlRulesExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAccessControlRulesRequest(AbstractModel):
    """DescribeAccessControlRules request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAccessControlRulesResponse(AbstractModel):
    """DescribeAccessControlRules response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _RuleSet: List of access control policies
        :type RuleSet: list of RuleBaseInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = RuleBaseInfo()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAffectedClusterCountRequest(AbstractModel):
    """DescribeAffectedClusterCount request structure.

    """


class DescribeAffectedClusterCountResponse(AbstractModel):
    """DescribeAffectedClusterCount response structure.

    """

    def __init__(self):
        r"""
        :param _SeriousRiskClusterCount: Number of critical clusters
        :type SeriousRiskClusterCount: int
        :param _HighRiskClusterCount: Number of high-risk clusters
        :type HighRiskClusterCount: int
        :param _MiddleRiskClusterCount: Number of medium-risk clusters
        :type MiddleRiskClusterCount: int
        :param _HintRiskClusterCount: Number of low-risk clusters
        :type HintRiskClusterCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SeriousRiskClusterCount = None
        self._HighRiskClusterCount = None
        self._MiddleRiskClusterCount = None
        self._HintRiskClusterCount = None
        self._RequestId = None

    @property
    def SeriousRiskClusterCount(self):
        return self._SeriousRiskClusterCount

    @SeriousRiskClusterCount.setter
    def SeriousRiskClusterCount(self, SeriousRiskClusterCount):
        self._SeriousRiskClusterCount = SeriousRiskClusterCount

    @property
    def HighRiskClusterCount(self):
        return self._HighRiskClusterCount

    @HighRiskClusterCount.setter
    def HighRiskClusterCount(self, HighRiskClusterCount):
        self._HighRiskClusterCount = HighRiskClusterCount

    @property
    def MiddleRiskClusterCount(self):
        return self._MiddleRiskClusterCount

    @MiddleRiskClusterCount.setter
    def MiddleRiskClusterCount(self, MiddleRiskClusterCount):
        self._MiddleRiskClusterCount = MiddleRiskClusterCount

    @property
    def HintRiskClusterCount(self):
        return self._HintRiskClusterCount

    @HintRiskClusterCount.setter
    def HintRiskClusterCount(self, HintRiskClusterCount):
        self._HintRiskClusterCount = HintRiskClusterCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SeriousRiskClusterCount = params.get("SeriousRiskClusterCount")
        self._HighRiskClusterCount = params.get("HighRiskClusterCount")
        self._MiddleRiskClusterCount = params.get("MiddleRiskClusterCount")
        self._HintRiskClusterCount = params.get("HintRiskClusterCount")
        self._RequestId = params.get("RequestId")


class DescribeAffectedNodeListRequest(AbstractModel):
    """DescribeAffectedNodeList request structure.

    """

    def __init__(self):
        r"""
        :param _CheckItemId: Unique ID of the check item
        :type CheckItemId: int
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `InstanceId`, `PrivateIpAddresses`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._CheckItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedNodeListResponse(AbstractModel):
    """DescribeAffectedNodeList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of affected nodes
        :type TotalCount: int
        :param _AffectedNodeList: List of affected nodes
        :type AffectedNodeList: list of AffectedNodeItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AffectedNodeList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AffectedNodeList(self):
        return self._AffectedNodeList

    @AffectedNodeList.setter
    def AffectedNodeList(self, AffectedNodeList):
        self._AffectedNodeList = AffectedNodeList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AffectedNodeList") is not None:
            self._AffectedNodeList = []
            for item in params.get("AffectedNodeList"):
                obj = AffectedNodeItem()
                obj._deserialize(item)
                self._AffectedNodeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAffectedWorkloadListRequest(AbstractModel):
    """DescribeAffectedWorkloadList request structure.

    """

    def __init__(self):
        r"""
        :param _CheckItemId: Unique ID of the check item
        :type CheckItemId: int
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `WorkloadType`, `ClusterId`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._CheckItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def CheckItemId(self):
        return self._CheckItemId

    @CheckItemId.setter
    def CheckItemId(self, CheckItemId):
        self._CheckItemId = CheckItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._CheckItemId = params.get("CheckItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAffectedWorkloadListResponse(AbstractModel):
    """DescribeAffectedWorkloadList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of affected workloads
        :type TotalCount: int
        :param _AffectedWorkloadList: List of affected workloads
        :type AffectedWorkloadList: list of AffectedWorkloadItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AffectedWorkloadList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AffectedWorkloadList(self):
        return self._AffectedWorkloadList

    @AffectedWorkloadList.setter
    def AffectedWorkloadList(self, AffectedWorkloadList):
        self._AffectedWorkloadList = AffectedWorkloadList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AffectedWorkloadList") is not None:
            self._AffectedWorkloadList = []
            for item in params.get("AffectedWorkloadList"):
                obj = AffectedWorkloadItem()
                obj._deserialize(item)
                self._AffectedWorkloadList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAgentDaemonSetCmdRequest(AbstractModel):
    """DescribeAgentDaemonSetCmd request structure.

    """

    def __init__(self):
        r"""
        :param _IsCloud: Whether it is from Tencent Cloud
        :type IsCloud: bool
        :param _NetType: Network type. Valid values: `basic` (classic network); `private` (VPC); `public` (public network); `direct` (Direct Connect).
        :type NetType: str
        :param _RegionCode: Region, which is required when `NetType` is `direct`.
        :type RegionCode: str
        :param _VpcId: VpcId, which is required when `NetType` is `direct`.
        :type VpcId: str
        :param _ExpireDate: Command validity, which is required for non-Tencent Cloud instances.
        :type ExpireDate: str
        :param _ClusterCustomParameters: Custom parameters of the cluster
        :type ClusterCustomParameters: list of ClusterCustomParameters
        """
        self._IsCloud = None
        self._NetType = None
        self._RegionCode = None
        self._VpcId = None
        self._ExpireDate = None
        self._ClusterCustomParameters = None

    @property
    def IsCloud(self):
        return self._IsCloud

    @IsCloud.setter
    def IsCloud(self, IsCloud):
        self._IsCloud = IsCloud

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def ClusterCustomParameters(self):
        return self._ClusterCustomParameters

    @ClusterCustomParameters.setter
    def ClusterCustomParameters(self, ClusterCustomParameters):
        self._ClusterCustomParameters = ClusterCustomParameters


    def _deserialize(self, params):
        self._IsCloud = params.get("IsCloud")
        self._NetType = params.get("NetType")
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._ExpireDate = params.get("ExpireDate")
        if params.get("ClusterCustomParameters") is not None:
            self._ClusterCustomParameters = []
            for item in params.get("ClusterCustomParameters"):
                obj = ClusterCustomParameters()
                obj._deserialize(item)
                self._ClusterCustomParameters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentDaemonSetCmdResponse(AbstractModel):
    """DescribeAgentDaemonSetCmd response structure.

    """

    def __init__(self):
        r"""
        :param _Command: Installation command
        :type Command: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Command = None
        self._RequestId = None

    @property
    def Command(self):
        return self._Command

    @Command.setter
    def Command(self, Command):
        self._Command = Command

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Command = params.get("Command")
        self._RequestId = params.get("RequestId")


class DescribeAgentInstallCommandRequest(AbstractModel):
    """DescribeAgentInstallCommand request structure.

    """

    def __init__(self):
        r"""
        :param _IsCloud: Whether it is from Tencent Cloud
        :type IsCloud: bool
        :param _NetType: Network type. Valid values: `basic` (classic network); `private` (VPC); `public` (public network); `direct` (Direct Connect).
        :type NetType: str
        :param _RegionCode: Region, which is required when `NetType` is `direct`.
        :type RegionCode: str
        :param _VpcId: VpcId, which is required when `NetType` is `direct`.
        :type VpcId: str
        :param _ExpireDate: Command validity, which is required for non-Tencent Cloud instances.
        :type ExpireDate: str
        :param _TagIds: Tag ID list, which is valid only when `IsCloud` is `false`.
        :type TagIds: list of int non-negative
        """
        self._IsCloud = None
        self._NetType = None
        self._RegionCode = None
        self._VpcId = None
        self._ExpireDate = None
        self._TagIds = None

    @property
    def IsCloud(self):
        return self._IsCloud

    @IsCloud.setter
    def IsCloud(self, IsCloud):
        self._IsCloud = IsCloud

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegionCode(self):
        return self._RegionCode

    @RegionCode.setter
    def RegionCode(self, RegionCode):
        self._RegionCode = RegionCode

    @property
    def VpcId(self):
        return self._VpcId

    @VpcId.setter
    def VpcId(self, VpcId):
        self._VpcId = VpcId

    @property
    def ExpireDate(self):
        return self._ExpireDate

    @ExpireDate.setter
    def ExpireDate(self, ExpireDate):
        self._ExpireDate = ExpireDate

    @property
    def TagIds(self):
        return self._TagIds

    @TagIds.setter
    def TagIds(self, TagIds):
        self._TagIds = TagIds


    def _deserialize(self, params):
        self._IsCloud = params.get("IsCloud")
        self._NetType = params.get("NetType")
        self._RegionCode = params.get("RegionCode")
        self._VpcId = params.get("VpcId")
        self._ExpireDate = params.get("ExpireDate")
        self._TagIds = params.get("TagIds")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAgentInstallCommandResponse(AbstractModel):
    """DescribeAgentInstallCommand response structure.

    """

    def __init__(self):
        r"""
        :param _LinuxCommand: Linux installation command
        :type LinuxCommand: str
        :param _WindowsCommand: Windows installation command (Windows 2008 or later)
        :type WindowsCommand: str
        :param _WindowsStepOne: Step 1 in the Window installation command (Windows 2003)
        :type WindowsStepOne: str
        :param _WindowsStepTwo: Step 2 in the Window installation command (Windows 2003)
        :type WindowsStepTwo: str
        :param _WindowsDownloadUrl: Download URL of the agent for Windows
        :type WindowsDownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LinuxCommand = None
        self._WindowsCommand = None
        self._WindowsStepOne = None
        self._WindowsStepTwo = None
        self._WindowsDownloadUrl = None
        self._RequestId = None

    @property
    def LinuxCommand(self):
        return self._LinuxCommand

    @LinuxCommand.setter
    def LinuxCommand(self, LinuxCommand):
        self._LinuxCommand = LinuxCommand

    @property
    def WindowsCommand(self):
        return self._WindowsCommand

    @WindowsCommand.setter
    def WindowsCommand(self, WindowsCommand):
        self._WindowsCommand = WindowsCommand

    @property
    def WindowsStepOne(self):
        return self._WindowsStepOne

    @WindowsStepOne.setter
    def WindowsStepOne(self, WindowsStepOne):
        self._WindowsStepOne = WindowsStepOne

    @property
    def WindowsStepTwo(self):
        return self._WindowsStepTwo

    @WindowsStepTwo.setter
    def WindowsStepTwo(self, WindowsStepTwo):
        self._WindowsStepTwo = WindowsStepTwo

    @property
    def WindowsDownloadUrl(self):
        return self._WindowsDownloadUrl

    @WindowsDownloadUrl.setter
    def WindowsDownloadUrl(self, WindowsDownloadUrl):
        self._WindowsDownloadUrl = WindowsDownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._LinuxCommand = params.get("LinuxCommand")
        self._WindowsCommand = params.get("WindowsCommand")
        self._WindowsStepOne = params.get("WindowsStepOne")
        self._WindowsStepTwo = params.get("WindowsStepTwo")
        self._WindowsDownloadUrl = params.get("WindowsDownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetAppServiceListRequest(AbstractModel):
    """DescribeAssetAppServiceList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetAppServiceListResponse(AbstractModel):
    """DescribeAssetAppServiceList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of database services
        :type List: list of ServiceInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetClusterListRequest(AbstractModel):
    """DescribeAssetClusterList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>`ClusterID` - String - Optional - Cluster ID</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`Status` - String - Optional - Cluster status</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field.
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetClusterListResponse(AbstractModel):
    """DescribeAssetClusterList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Cluster list
        :type List: list of AssetClusterListItem
        :param _TotalCount: Total number of clusters
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AssetClusterListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetComponentListRequest(AbstractModel):
    """DescribeAssetComponentList request structure.

    """

    def __init__(self):
        r"""
        :param _ContainerID: Container ID
        :type ContainerID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
        :type Filters: list of AssetFilters
        """
        self._ContainerID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ContainerID(self):
        return self._ContainerID

    @ContainerID.setter
    def ContainerID(self, ContainerID):
        self._ContainerID = ContainerID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ContainerID = params.get("ContainerID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetComponentListResponse(AbstractModel):
    """DescribeAssetComponentList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of components
        :type List: list of ComponentInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ComponentInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetContainerDetailRequest(AbstractModel):
    """DescribeAssetContainerDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ContainerId: Container ID
        :type ContainerId: str
        """
        self._ContainerId = None

    @property
    def ContainerId(self):
        return self._ContainerId

    @ContainerId.setter
    def ContainerId(self, ContainerId):
        self._ContainerId = ContainerId


    def _deserialize(self, params):
        self._ContainerId = params.get("ContainerId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerDetailResponse(AbstractModel):
    """DescribeAssetContainerDetail response structure.

    """

    def __init__(self):
        r"""
        :param _HostID: Server ID
        :type HostID: str
        :param _HostIP: Server IP
        :type HostIP: str
        :param _ContainerName: Container name
        :type ContainerName: str
        :param _Status: Status
        :type Status: str
        :param _RunAs: Operator
        :type RunAs: str
        :param _Cmd: Command line
        :type Cmd: str
        :param _CPUUsage: CPU utilization * 1000
        :type CPUUsage: int
        :param _RamUsage: Memory usage in KB
        :type RamUsage: int
        :param _ImageName: Image name
        :type ImageName: str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _POD: Pod
        :type POD: str
        :param _K8sMaster: K8s master node
        :type K8sMaster: str
        :param _ProcessCnt: Number of processes in the container
        :type ProcessCnt: int
        :param _PortCnt: Number of ports in the container
        :type PortCnt: int
        :param _ComponentCnt: Number of components
        :type ComponentCnt: int
        :param _AppCnt: Number of applications
        :type AppCnt: int
        :param _WebServiceCnt: Number of web services
        :type WebServiceCnt: int
        :param _Mounts: Mount
        :type Mounts: list of ContainerMount
        :param _Network: Container network information
        :type Network: :class:`tencentcloud.tcss.v20201101.models.ContainerNetwork`
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _ImageCreateTime: Image creation time
        :type ImageCreateTime: str
        :param _ImageSize: Image size
        :type ImageSize: int
        :param _HostStatus: Server status. Valid values: `offline`, `online`, `pause`.
        :type HostStatus: str
        :param _NetStatus: Network status
`NORMAL`: 	Not isolated.
`ISOLATED`: 		Isolated.
`ISOLATING`: 		Isolating.
`ISOLATE_FAILED`: 	Isolation failed.
`RESTORING`: Recovering.
`RESTORE_FAILED`: Recovery failed.
        :type NetStatus: str
        :param _NetSubStatus: Sub-status of the network
        :type NetSubStatus: str
        :param _IsolateSource: Isolation source
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateSource: str
        :param _IsolateTime: Isolation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsolateTime: str
        :param _NodeID: Node ID
        :type NodeID: str
        :param _NodeName: Node name
        :type NodeName: str
        :param _NodeSubNetID: Node subnet ID
        :type NodeSubNetID: str
        :param _NodeSubNetName: Node subnet name
        :type NodeSubNetName: str
        :param _NodeSubNetCIDR: Subnet IP range
        :type NodeSubNetCIDR: str
        :param _PodName: Pod name
        :type PodName: str
        :param _PodIP: Pod IP
        :type PodIP: str
        :param _PodStatus: Pod status
        :type PodStatus: str
        :param _ClusterID: Cluster ID
        :type ClusterID: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _NodeType: Node type. Values: `NORMAL` (default), `SUPER`
        :type NodeType: str
        :param _NodeUniqueID: UID of the super node
        :type NodeUniqueID: str
        :param _PublicIP: Public IP
        :type PublicIP: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._HostID = None
        self._HostIP = None
        self._ContainerName = None
        self._Status = None
        self._RunAs = None
        self._Cmd = None
        self._CPUUsage = None
        self._RamUsage = None
        self._ImageName = None
        self._ImageID = None
        self._POD = None
        self._K8sMaster = None
        self._ProcessCnt = None
        self._PortCnt = None
        self._ComponentCnt = None
        self._AppCnt = None
        self._WebServiceCnt = None
        self._Mounts = None
        self._Network = None
        self._CreateTime = None
        self._ImageCreateTime = None
        self._ImageSize = None
        self._HostStatus = None
        self._NetStatus = None
        self._NetSubStatus = None
        self._IsolateSource = None
        self._IsolateTime = None
        self._NodeID = None
        self._NodeName = None
        self._NodeSubNetID = None
        self._NodeSubNetName = None
        self._NodeSubNetCIDR = None
        self._PodName = None
        self._PodIP = None
        self._PodStatus = None
        self._ClusterID = None
        self._ClusterName = None
        self._NodeType = None
        self._NodeUniqueID = None
        self._PublicIP = None
        self._RequestId = None

    @property
    def HostID(self):
        return self._HostID

    @HostID.setter
    def HostID(self, HostID):
        self._HostID = HostID

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def ContainerName(self):
        return self._ContainerName

    @ContainerName.setter
    def ContainerName(self, ContainerName):
        self._ContainerName = ContainerName

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RunAs(self):
        return self._RunAs

    @RunAs.setter
    def RunAs(self, RunAs):
        self._RunAs = RunAs

    @property
    def Cmd(self):
        return self._Cmd

    @Cmd.setter
    def Cmd(self, Cmd):
        self._Cmd = Cmd

    @property
    def CPUUsage(self):
        return self._CPUUsage

    @CPUUsage.setter
    def CPUUsage(self, CPUUsage):
        self._CPUUsage = CPUUsage

    @property
    def RamUsage(self):
        return self._RamUsage

    @RamUsage.setter
    def RamUsage(self, RamUsage):
        self._RamUsage = RamUsage

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def POD(self):
        return self._POD

    @POD.setter
    def POD(self, POD):
        self._POD = POD

    @property
    def K8sMaster(self):
        return self._K8sMaster

    @K8sMaster.setter
    def K8sMaster(self, K8sMaster):
        self._K8sMaster = K8sMaster

    @property
    def ProcessCnt(self):
        return self._ProcessCnt

    @ProcessCnt.setter
    def ProcessCnt(self, ProcessCnt):
        self._ProcessCnt = ProcessCnt

    @property
    def PortCnt(self):
        return self._PortCnt

    @PortCnt.setter
    def PortCnt(self, PortCnt):
        self._PortCnt = PortCnt

    @property
    def ComponentCnt(self):
        return self._ComponentCnt

    @ComponentCnt.setter
    def ComponentCnt(self, ComponentCnt):
        self._ComponentCnt = ComponentCnt

    @property
    def AppCnt(self):
        return self._AppCnt

    @AppCnt.setter
    def AppCnt(self, AppCnt):
        self._AppCnt = AppCnt

    @property
    def WebServiceCnt(self):
        return self._WebServiceCnt

    @WebServiceCnt.setter
    def WebServiceCnt(self, WebServiceCnt):
        self._WebServiceCnt = WebServiceCnt

    @property
    def Mounts(self):
        return self._Mounts

    @Mounts.setter
    def Mounts(self, Mounts):
        self._Mounts = Mounts

    @property
    def Network(self):
        return self._Network

    @Network.setter
    def Network(self, Network):
        self._Network = Network

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def ImageCreateTime(self):
        return self._ImageCreateTime

    @ImageCreateTime.setter
    def ImageCreateTime(self, ImageCreateTime):
        self._ImageCreateTime = ImageCreateTime

    @property
    def ImageSize(self):
        return self._ImageSize

    @ImageSize.setter
    def ImageSize(self, ImageSize):
        self._ImageSize = ImageSize

    @property
    def HostStatus(self):
        return self._HostStatus

    @HostStatus.setter
    def HostStatus(self, HostStatus):
        self._HostStatus = HostStatus

    @property
    def NetStatus(self):
        return self._NetStatus

    @NetStatus.setter
    def NetStatus(self, NetStatus):
        self._NetStatus = NetStatus

    @property
    def NetSubStatus(self):
        return self._NetSubStatus

    @NetSubStatus.setter
    def NetSubStatus(self, NetSubStatus):
        self._NetSubStatus = NetSubStatus

    @property
    def IsolateSource(self):
        return self._IsolateSource

    @IsolateSource.setter
    def IsolateSource(self, IsolateSource):
        self._IsolateSource = IsolateSource

    @property
    def IsolateTime(self):
        return self._IsolateTime

    @IsolateTime.setter
    def IsolateTime(self, IsolateTime):
        self._IsolateTime = IsolateTime

    @property
    def NodeID(self):
        return self._NodeID

    @NodeID.setter
    def NodeID(self, NodeID):
        self._NodeID = NodeID

    @property
    def NodeName(self):
        return self._NodeName

    @NodeName.setter
    def NodeName(self, NodeName):
        self._NodeName = NodeName

    @property
    def NodeSubNetID(self):
        return self._NodeSubNetID

    @NodeSubNetID.setter
    def NodeSubNetID(self, NodeSubNetID):
        self._NodeSubNetID = NodeSubNetID

    @property
    def NodeSubNetName(self):
        return self._NodeSubNetName

    @NodeSubNetName.setter
    def NodeSubNetName(self, NodeSubNetName):
        self._NodeSubNetName = NodeSubNetName

    @property
    def NodeSubNetCIDR(self):
        return self._NodeSubNetCIDR

    @NodeSubNetCIDR.setter
    def NodeSubNetCIDR(self, NodeSubNetCIDR):
        self._NodeSubNetCIDR = NodeSubNetCIDR

    @property
    def PodName(self):
        return self._PodName

    @PodName.setter
    def PodName(self, PodName):
        self._PodName = PodName

    @property
    def PodIP(self):
        return self._PodIP

    @PodIP.setter
    def PodIP(self, PodIP):
        self._PodIP = PodIP

    @property
    def PodStatus(self):
        return self._PodStatus

    @PodStatus.setter
    def PodStatus(self, PodStatus):
        self._PodStatus = PodStatus

    @property
    def ClusterID(self):
        return self._ClusterID

    @ClusterID.setter
    def ClusterID(self, ClusterID):
        self._ClusterID = ClusterID

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def NodeType(self):
        return self._NodeType

    @NodeType.setter
    def NodeType(self, NodeType):
        self._NodeType = NodeType

    @property
    def NodeUniqueID(self):
        return self._NodeUniqueID

    @NodeUniqueID.setter
    def NodeUniqueID(self, NodeUniqueID):
        self._NodeUniqueID = NodeUniqueID

    @property
    def PublicIP(self):
        return self._PublicIP

    @PublicIP.setter
    def PublicIP(self, PublicIP):
        self._PublicIP = PublicIP

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._HostID = params.get("HostID")
        self._HostIP = params.get("HostIP")
        self._ContainerName = params.get("ContainerName")
        self._Status = params.get("Status")
        self._RunAs = params.get("RunAs")
        self._Cmd = params.get("Cmd")
        self._CPUUsage = params.get("CPUUsage")
        self._RamUsage = params.get("RamUsage")
        self._ImageName = params.get("ImageName")
        self._ImageID = params.get("ImageID")
        self._POD = params.get("POD")
        self._K8sMaster = params.get("K8sMaster")
        self._ProcessCnt = params.get("ProcessCnt")
        self._PortCnt = params.get("PortCnt")
        self._ComponentCnt = params.get("ComponentCnt")
        self._AppCnt = params.get("AppCnt")
        self._WebServiceCnt = params.get("WebServiceCnt")
        if params.get("Mounts") is not None:
            self._Mounts = []
            for item in params.get("Mounts"):
                obj = ContainerMount()
                obj._deserialize(item)
                self._Mounts.append(obj)
        if params.get("Network") is not None:
            self._Network = ContainerNetwork()
            self._Network._deserialize(params.get("Network"))
        self._CreateTime = params.get("CreateTime")
        self._ImageCreateTime = params.get("ImageCreateTime")
        self._ImageSize = params.get("ImageSize")
        self._HostStatus = params.get("HostStatus")
        self._NetStatus = params.get("NetStatus")
        self._NetSubStatus = params.get("NetSubStatus")
        self._IsolateSource = params.get("IsolateSource")
        self._IsolateTime = params.get("IsolateTime")
        self._NodeID = params.get("NodeID")
        self._NodeName = params.get("NodeName")
        self._NodeSubNetID = params.get("NodeSubNetID")
        self._NodeSubNetName = params.get("NodeSubNetName")
        self._NodeSubNetCIDR = params.get("NodeSubNetCIDR")
        self._PodName = params.get("PodName")
        self._PodIP = params.get("PodIP")
        self._PodStatus = params.get("PodStatus")
        self._ClusterID = params.get("ClusterID")
        self._ClusterName = params.get("ClusterName")
        self._NodeType = params.get("NodeType")
        self._NodeUniqueID = params.get("NodeUniqueID")
        self._PublicIP = params.get("PublicIP")
        self._RequestId = params.get("RequestId")


class DescribeAssetContainerListRequest(AbstractModel):
    """DescribeAssetContainerList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter condition
<li>`ContainerName`: String - Required: No - Container name</li>
<li>`Status` - String - Required: No - Container status. Values: `0` (created); `1` (running); `2` (paused); `3` (restarting); `4` (removing); `5` (exited); `6` (dead).</li>
<li>`Runas`: String - Required: No - Operator</li>
<li>`ImageName`: String - Required: No - Image name</li>
<li>`HostIP`: String - Required: No - Server IP</li>
<li>`OrderBy` - String - Required: No - Sorting field, which supports dynamic sorting by `cpu_usage` or `mem_usage` such as ["cpu_usage","+"]. '+' indicates ascending, and '-' indicates descending.</li>
<li>`NetStatus`: String - Required: No - Container network status. Values: `normal`, `isolated`, `isolating`, `isolate_failed`, `restoring`, `restore_failed`.</li>
<li>`PodID`: String - Required: No- Pod ID </li>
<li>`NodeUniqueID`: String - Required: No - Super Node</li>
<li>`PodUid`: String - Required: No - Pod</li>
<li>`PodIP`: String - Required: No - Pod IP</li>
<li>`NodeType`: String - Required: No - Values: `NORMAL` (general nodes), `SUPER` (super nodes)</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetContainerListResponse(AbstractModel):
    """DescribeAssetContainerList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of containers
        :type List: list of ContainerInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ContainerInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetDBServiceListRequest(AbstractModel):
    """DescribeAssetDBServiceList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetDBServiceListResponse(AbstractModel):
    """DescribeAssetDBServiceList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of database services
        :type List: list of ServiceInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetHostDetailRequest(AbstractModel):
    """DescribeAssetHostDetail request structure.

    """

    def __init__(self):
        r"""
        :param _HostId: Server ID
        :type HostId: str
        """
        self._HostId = None

    @property
    def HostId(self):
        return self._HostId

    @HostId.setter
    def HostId(self, HostId):
        self._HostId = HostId


    def _deserialize(self, params):
        self._HostId = params.get("HostId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostDetailResponse(AbstractModel):
    """DescribeAssetHostDetail response structure.

    """

    def __init__(self):
        r"""
        :param _UUID: TCSS UUID
        :type UUID: str
        :param _UpdateTime: Update time
        :type UpdateTime: str
        :param _HostName: Server name
        :type HostName: str
        :param _Group: Server group
        :type Group: str
        :param _HostIP: Server IP
        :type HostIP: str
        :param _OsName: OS
        :type OsName: str
        :param _AgentVersion: Agent version
        :type AgentVersion: str
        :param _KernelVersion: Kernel version
        :type KernelVersion: str
        :param _DockerVersion: Docker version
        :type DockerVersion: str
        :param _DockerAPIVersion: Docker API version
        :type DockerAPIVersion: str
        :param _DockerGoVersion: Docker version for Go
        :type DockerGoVersion: str
        :param _DockerFileSystemDriver: Docker file system type
        :type DockerFileSystemDriver: str
        :param _DockerRootDir: Docker root directory
        :type DockerRootDir: str
        :param _ImageCnt: Number of images
        :type ImageCnt: int
        :param _ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param _K8sMasterIP: K8s IP
        :type K8sMasterIP: str
        :param _K8sVersion: K8s version
        :type K8sVersion: str
        :param _KubeProxyVersion: kube proxy
        :type KubeProxyVersion: str
        :param _Status: Valid values: `UNINSTALL` (not installed); `OFFLINE` (offline); `ONLINE` (defended).
        :type Status: str
        :param _IsContainerd: Whether it is Containerd
        :type IsContainerd: bool
        :param _MachineType: Server source. Valid values: `TENCENTCLOUD` (Tencent Cloud instance); `OTHERCLOUD` (non-Tencent Cloud instance).
        :type MachineType: str
        :param _PublicIp: Public IP
        :type PublicIp: str
        :param _InstanceID: Server instance ID
        :type InstanceID: str
        :param _RegionID: Region ID
        :type RegionID: int
        :param _Project: Project
        :type Project: :class:`tencentcloud.tcss.v20201101.models.ProjectInfo`
        :param _Tags: Tags
        :type Tags: list of TagInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UUID = None
        self._UpdateTime = None
        self._HostName = None
        self._Group = None
        self._HostIP = None
        self._OsName = None
        self._AgentVersion = None
        self._KernelVersion = None
        self._DockerVersion = None
        self._DockerAPIVersion = None
        self._DockerGoVersion = None
        self._DockerFileSystemDriver = None
        self._DockerRootDir = None
        self._ImageCnt = None
        self._ContainerCnt = None
        self._K8sMasterIP = None
        self._K8sVersion = None
        self._KubeProxyVersion = None
        self._Status = None
        self._IsContainerd = None
        self._MachineType = None
        self._PublicIp = None
        self._InstanceID = None
        self._RegionID = None
        self._Project = None
        self._Tags = None
        self._RequestId = None

    @property
    def UUID(self):
        return self._UUID

    @UUID.setter
    def UUID(self, UUID):
        self._UUID = UUID

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def HostName(self):
        return self._HostName

    @HostName.setter
    def HostName(self, HostName):
        self._HostName = HostName

    @property
    def Group(self):
        return self._Group

    @Group.setter
    def Group(self, Group):
        self._Group = Group

    @property
    def HostIP(self):
        return self._HostIP

    @HostIP.setter
    def HostIP(self, HostIP):
        self._HostIP = HostIP

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def AgentVersion(self):
        return self._AgentVersion

    @AgentVersion.setter
    def AgentVersion(self, AgentVersion):
        self._AgentVersion = AgentVersion

    @property
    def KernelVersion(self):
        return self._KernelVersion

    @KernelVersion.setter
    def KernelVersion(self, KernelVersion):
        self._KernelVersion = KernelVersion

    @property
    def DockerVersion(self):
        return self._DockerVersion

    @DockerVersion.setter
    def DockerVersion(self, DockerVersion):
        self._DockerVersion = DockerVersion

    @property
    def DockerAPIVersion(self):
        return self._DockerAPIVersion

    @DockerAPIVersion.setter
    def DockerAPIVersion(self, DockerAPIVersion):
        self._DockerAPIVersion = DockerAPIVersion

    @property
    def DockerGoVersion(self):
        return self._DockerGoVersion

    @DockerGoVersion.setter
    def DockerGoVersion(self, DockerGoVersion):
        self._DockerGoVersion = DockerGoVersion

    @property
    def DockerFileSystemDriver(self):
        return self._DockerFileSystemDriver

    @DockerFileSystemDriver.setter
    def DockerFileSystemDriver(self, DockerFileSystemDriver):
        self._DockerFileSystemDriver = DockerFileSystemDriver

    @property
    def DockerRootDir(self):
        return self._DockerRootDir

    @DockerRootDir.setter
    def DockerRootDir(self, DockerRootDir):
        self._DockerRootDir = DockerRootDir

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def K8sMasterIP(self):
        return self._K8sMasterIP

    @K8sMasterIP.setter
    def K8sMasterIP(self, K8sMasterIP):
        self._K8sMasterIP = K8sMasterIP

    @property
    def K8sVersion(self):
        return self._K8sVersion

    @K8sVersion.setter
    def K8sVersion(self, K8sVersion):
        self._K8sVersion = K8sVersion

    @property
    def KubeProxyVersion(self):
        return self._KubeProxyVersion

    @KubeProxyVersion.setter
    def KubeProxyVersion(self, KubeProxyVersion):
        self._KubeProxyVersion = KubeProxyVersion

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def IsContainerd(self):
        return self._IsContainerd

    @IsContainerd.setter
    def IsContainerd(self, IsContainerd):
        self._IsContainerd = IsContainerd

    @property
    def MachineType(self):
        return self._MachineType

    @MachineType.setter
    def MachineType(self, MachineType):
        self._MachineType = MachineType

    @property
    def PublicIp(self):
        return self._PublicIp

    @PublicIp.setter
    def PublicIp(self, PublicIp):
        self._PublicIp = PublicIp

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID

    @property
    def Project(self):
        return self._Project

    @Project.setter
    def Project(self, Project):
        self._Project = Project

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UUID = params.get("UUID")
        self._UpdateTime = params.get("UpdateTime")
        self._HostName = params.get("HostName")
        self._Group = params.get("Group")
        self._HostIP = params.get("HostIP")
        self._OsName = params.get("OsName")
        self._AgentVersion = params.get("AgentVersion")
        self._KernelVersion = params.get("KernelVersion")
        self._DockerVersion = params.get("DockerVersion")
        self._DockerAPIVersion = params.get("DockerAPIVersion")
        self._DockerGoVersion = params.get("DockerGoVersion")
        self._DockerFileSystemDriver = params.get("DockerFileSystemDriver")
        self._DockerRootDir = params.get("DockerRootDir")
        self._ImageCnt = params.get("ImageCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._K8sMasterIP = params.get("K8sMasterIP")
        self._K8sVersion = params.get("K8sVersion")
        self._KubeProxyVersion = params.get("KubeProxyVersion")
        self._Status = params.get("Status")
        self._IsContainerd = params.get("IsContainerd")
        self._MachineType = params.get("MachineType")
        self._PublicIp = params.get("PublicIp")
        self._InstanceID = params.get("InstanceID")
        self._RegionID = params.get("RegionID")
        if params.get("Project") is not None:
            self._Project = ProjectInfo()
            self._Project._deserialize(params.get("Project"))
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = TagInfo()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetHostListRequest(AbstractModel):
    """DescribeAssetHostList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filters.
<li>`Status` - String - Optional - Agent status. Values: `ALL`; `UNINSTALL` (Not installed); `OFFLINE`, `ONLINE`. Default to `All` if it's not specified. </li>
<li>`HostName` - String - Optional - Server name</li>
<li>`Group - String - Optional - Server group</li>
<li>`HostIP` - String - Optional - Server IP</li>
<li>`HostID - String - Optional - Server ID</li>
<li>`DockerVersion` - String - Optional - Docker version</li>
<li>`MachineType` - String - Optional - Server type. Values: `ALL`; `CVM` (Cloud Virtual Machine); `ECM` (Edge Computing Machine); `LH` (Lighthouse), `BM` (Cloud Bare Metal); `Other` (non-Tencent Cloud server). Default to `ALL` if it's not specified.</li>
<li>`DockerStatus` - String - Optional - Docker installation status. Values: `ALL`; `INSTALL` (Installed); `UNINSTALL` (Not installed)</li>
<li>`ProjectID` - String - Optional - Project ID</li>
<li>`Tag:xxx(tag:key)` - String - Optional - Tag key-value pair; Example: `Filters":[{"Name":"tag:tke-kind","Values":["service"]}]`</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetHostListResponse(AbstractModel):
    """DescribeAssetHostList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of servers
        :type List: list of HostInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = HostInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageBindRuleInfoRequest(AbstractModel):
    """DescribeAssetImageBindRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"EventType","Values":[""]}]
EventType. Valid values:
`FILE_ABNORMAL_READ`: Access control.
`MALICE_PROCESS_START`: Malicious process startup.
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageBindRuleInfoResponse(AbstractModel):
    """DescribeAssetImageBindRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _ImageBindRuleSet: List of rules bound to images
        :type ImageBindRuleSet: list of ImagesBindRuleInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageBindRuleSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageBindRuleSet(self):
        return self._ImageBindRuleSet

    @ImageBindRuleSet.setter
    def ImageBindRuleSet(self, ImageBindRuleSet):
        self._ImageBindRuleSet = ImageBindRuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageBindRuleSet") is not None:
            self._ImageBindRuleSet = []
            for item in params.get("ImageBindRuleSet"):
                obj = ImagesBindRuleInfo()
                obj._deserialize(item)
                self._ImageBindRuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAssetImageDetailRequest(AbstractModel):
    """DescribeAssetImageDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        """
        self._ImageID = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageDetailResponse(AbstractModel):
    """DescribeAssetImageDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _ImageName: Image name
        :type ImageName: str
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _Size: Image size
        :type Size: int
        :param _HostCnt: Number of associated servers
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCnt: int
        :param _ContainerCnt: Number of associated containers
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerCnt: int
        :param _ScanTime: Last scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanTime: str
        :param _VulCnt: Number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulCnt: int
        :param _RiskCnt: Number of risky behaviors
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskCnt: int
        :param _SensitiveInfoCnt: Number of sensitive data items
Note: This field may return null, indicating that no valid values can be obtained.
        :type SensitiveInfoCnt: int
        :param _IsTrustImage: Whether it is a trusted image
        :type IsTrustImage: bool
        :param _OsName: Image system
        :type OsName: str
        :param _AgentError: Image scan error in the agent
Note: This field may return null, indicating that no valid values can be obtained.
        :type AgentError: str
        :param _ScanError: Image scan error on the backend
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanError: str
        :param _Architecture: System architecture
Note: This field may return null, indicating that no valid values can be obtained.
        :type Architecture: str
        :param _Author: Author
Note: This field may return null, indicating that no valid values can be obtained.
        :type Author: str
        :param _BuildHistory: Build history
Note: This field may return null, indicating that no valid values can be obtained.
        :type BuildHistory: str
        :param _ScanVirusProgress: Trojan scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusProgress: int
        :param _ScanVulProgress: Vulnerability scan progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulProgress: int
        :param _ScanRiskProgress: Sensitive data scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskProgress: int
        :param _ScanVirusError: Trojan scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusError: str
        :param _ScanVulError: Vulnerability scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulError: str
        :param _ScanRiskError: Sensitive data error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskError: str
        :param _ScanStatus: Image scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: str
        :param _VirusCnt: Number of viruses and trojans
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusCnt: int
        :param _Status: Image scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: int
        :param _RemainScanTime: Remaining scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type RemainScanTime: int
        :param _IsAuthorized: Valid values: `1` (licensed); `0` (unlicensed).
        :type IsAuthorized: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageID = None
        self._ImageName = None
        self._CreateTime = None
        self._Size = None
        self._HostCnt = None
        self._ContainerCnt = None
        self._ScanTime = None
        self._VulCnt = None
        self._RiskCnt = None
        self._SensitiveInfoCnt = None
        self._IsTrustImage = None
        self._OsName = None
        self._AgentError = None
        self._ScanError = None
        self._Architecture = None
        self._Author = None
        self._BuildHistory = None
        self._ScanVirusProgress = None
        self._ScanVulProgress = None
        self._ScanRiskProgress = None
        self._ScanVirusError = None
        self._ScanVulError = None
        self._ScanRiskError = None
        self._ScanStatus = None
        self._VirusCnt = None
        self._Status = None
        self._RemainScanTime = None
        self._IsAuthorized = None
        self._RequestId = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def VulCnt(self):
        return self._VulCnt

    @VulCnt.setter
    def VulCnt(self, VulCnt):
        self._VulCnt = VulCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def SensitiveInfoCnt(self):
        return self._SensitiveInfoCnt

    @SensitiveInfoCnt.setter
    def SensitiveInfoCnt(self, SensitiveInfoCnt):
        self._SensitiveInfoCnt = SensitiveInfoCnt

    @property
    def IsTrustImage(self):
        return self._IsTrustImage

    @IsTrustImage.setter
    def IsTrustImage(self, IsTrustImage):
        self._IsTrustImage = IsTrustImage

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def AgentError(self):
        return self._AgentError

    @AgentError.setter
    def AgentError(self, AgentError):
        self._AgentError = AgentError

    @property
    def ScanError(self):
        return self._ScanError

    @ScanError.setter
    def ScanError(self, ScanError):
        self._ScanError = ScanError

    @property
    def Architecture(self):
        return self._Architecture

    @Architecture.setter
    def Architecture(self, Architecture):
        self._Architecture = Architecture

    @property
    def Author(self):
        return self._Author

    @Author.setter
    def Author(self, Author):
        self._Author = Author

    @property
    def BuildHistory(self):
        return self._BuildHistory

    @BuildHistory.setter
    def BuildHistory(self, BuildHistory):
        self._BuildHistory = BuildHistory

    @property
    def ScanVirusProgress(self):
        return self._ScanVirusProgress

    @ScanVirusProgress.setter
    def ScanVirusProgress(self, ScanVirusProgress):
        self._ScanVirusProgress = ScanVirusProgress

    @property
    def ScanVulProgress(self):
        return self._ScanVulProgress

    @ScanVulProgress.setter
    def ScanVulProgress(self, ScanVulProgress):
        self._ScanVulProgress = ScanVulProgress

    @property
    def ScanRiskProgress(self):
        return self._ScanRiskProgress

    @ScanRiskProgress.setter
    def ScanRiskProgress(self, ScanRiskProgress):
        self._ScanRiskProgress = ScanRiskProgress

    @property
    def ScanVirusError(self):
        return self._ScanVirusError

    @ScanVirusError.setter
    def ScanVirusError(self, ScanVirusError):
        self._ScanVirusError = ScanVirusError

    @property
    def ScanVulError(self):
        return self._ScanVulError

    @ScanVulError.setter
    def ScanVulError(self, ScanVulError):
        self._ScanVulError = ScanVulError

    @property
    def ScanRiskError(self):
        return self._ScanRiskError

    @ScanRiskError.setter
    def ScanRiskError(self, ScanRiskError):
        self._ScanRiskError = ScanRiskError

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def VirusCnt(self):
        return self._VirusCnt

    @VirusCnt.setter
    def VirusCnt(self, VirusCnt):
        self._VirusCnt = VirusCnt

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RemainScanTime(self):
        return self._RemainScanTime

    @RemainScanTime.setter
    def RemainScanTime(self, RemainScanTime):
        self._RemainScanTime = RemainScanTime

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._ImageName = params.get("ImageName")
        self._CreateTime = params.get("CreateTime")
        self._Size = params.get("Size")
        self._HostCnt = params.get("HostCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ScanTime = params.get("ScanTime")
        self._VulCnt = params.get("VulCnt")
        self._RiskCnt = params.get("RiskCnt")
        self._SensitiveInfoCnt = params.get("SensitiveInfoCnt")
        self._IsTrustImage = params.get("IsTrustImage")
        self._OsName = params.get("OsName")
        self._AgentError = params.get("AgentError")
        self._ScanError = params.get("ScanError")
        self._Architecture = params.get("Architecture")
        self._Author = params.get("Author")
        self._BuildHistory = params.get("BuildHistory")
        self._ScanVirusProgress = params.get("ScanVirusProgress")
        self._ScanVulProgress = params.get("ScanVulProgress")
        self._ScanRiskProgress = params.get("ScanRiskProgress")
        self._ScanVirusError = params.get("ScanVirusError")
        self._ScanVulError = params.get("ScanVulError")
        self._ScanRiskError = params.get("ScanRiskError")
        self._ScanStatus = params.get("ScanStatus")
        self._VirusCnt = params.get("VirusCnt")
        self._Status = params.get("Status")
        self._RemainScanTime = params.get("RemainScanTime")
        self._IsAuthorized = params.get("IsAuthorized")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageHostListRequest(AbstractModel):
    """DescribeAssetImageHostList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter. Valid values: `ImageID`, `HostID`.
        :type Filters: list of AssetFilters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageHostListResponse(AbstractModel):
    """DescribeAssetImageHostList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of images
        :type List: list of ImageHost
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageHost()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageListExportRequest(AbstractModel):
    """DescribeAssetImageListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListExportResponse(AbstractModel):
    """DescribeAssetImageListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageListRequest(AbstractModel):
    """DescribeAssetImageList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>ImageName- String - Required: No - Image name</li>
<li>ScanStatus - String - Required: No - Image scanning status. Valid values: `notScan`, `scanning`, `scanned`, `scanErr`.</li>
<li>ImageID- String - Required: No - Image ID</li>
<li>SecurityRisk- String - Required: No - Security risks. Valid values: `VulCnt`, `VirusCnt`, `RiskCnt`, `IsTrustImage`.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageListResponse(AbstractModel):
    """DescribeAssetImageList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of images
        :type List: list of ImagesInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImagesInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryAssetStatusRequest(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus request structure.

    """


class DescribeAssetImageRegistryAssetStatusResponse(AbstractModel):
    """DescribeAssetImageRegistryAssetStatus response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Update progress. Valid values: `doing` (updating); `success` (updated successfully); `failed` (failed to update).
        :type Status: str
        :param _Err: Error message
Note: This field may return null, indicating that no valid values can be obtained.
        :type Err: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._Err = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Err(self):
        return self._Err

    @Err.setter
    def Err(self, Err):
        self._Err = Err

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._Err = params.get("Err")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Id: List of repository IDs
        :type Id: int
        :param _ImageId: Image ID
        :type ImageId: str
        """
        self._Id = None
        self._ImageId = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._ImageId = params.get("ImageId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ImageDigest: Image digest
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageDigest: str
        :param _ImageRepoAddress: Image address
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageRepoAddress: str
        :param _RegistryType: Image type
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryType: str
        :param _ImageName: Repository name
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageName: str
        :param _ImageTag: Image tag
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageTag: str
        :param _ScanTime: Scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanTime: str
        :param _ScanStatus: Scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanStatus: str
        :param _VulCnt: Number of vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type VulCnt: int
        :param _VirusCnt: Number of viruses and trojans
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusCnt: int
        :param _RiskCnt: Number of risky behaviors
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskCnt: int
        :param _SentiveInfoCnt: Number of sensitive data items
Note: This field may return null, indicating that no valid values can be obtained.
        :type SentiveInfoCnt: int
        :param _OsName: Image system
Note: This field may return null, indicating that no valid values can be obtained.
        :type OsName: str
        :param _ScanVirusError: Trojan scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusError: str
        :param _ScanVulError: Vulnerability scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulError: str
        :param _LayerInfo: Layer file information
Note: This field may return null, indicating that no valid values can be obtained.
        :type LayerInfo: str
        :param _InstanceId: Instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceId: str
        :param _InstanceName: Instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param _ScanRiskError: High-risk scan error
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskError: str
        :param _ScanVirusProgress: Trojan scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVirusProgress: int
        :param _ScanVulProgress: Vulnerability scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanVulProgress: int
        :param _ScanRiskProgress: Sensitive data scanning progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRiskProgress: int
        :param _ScanRemainTime: Remaining scan time in seconds
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRemainTime: int
        :param _CveStatus: CVE scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type CveStatus: str
        :param _RiskStatus: High-risk scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type RiskStatus: str
        :param _VirusStatus: Trojan scanning status
Note: This field may return null, indicating that no valid values can be obtained.
        :type VirusStatus: str
        :param _Progress: Overall progress
Note: This field may return null, indicating that no valid values can be obtained.
        :type Progress: int
        :param _IsAuthorized: Licensing status
Note: This field may return null, indicating that no valid values can be obtained.
        :type IsAuthorized: int
        :param _ImageSize: Image size
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageSize: int
        :param _ImageId: Image ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageId: str
        :param _RegistryRegion: Image region
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryRegion: str
        :param _ImageCreateTime: Image creation time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageCreateTime: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageDigest = None
        self._ImageRepoAddress = None
        self._RegistryType = None
        self._ImageName = None
        self._ImageTag = None
        self._ScanTime = None
        self._ScanStatus = None
        self._VulCnt = None
        self._VirusCnt = None
        self._RiskCnt = None
        self._SentiveInfoCnt = None
        self._OsName = None
        self._ScanVirusError = None
        self._ScanVulError = None
        self._LayerInfo = None
        self._InstanceId = None
        self._InstanceName = None
        self._Namespace = None
        self._ScanRiskError = None
        self._ScanVirusProgress = None
        self._ScanVulProgress = None
        self._ScanRiskProgress = None
        self._ScanRemainTime = None
        self._CveStatus = None
        self._RiskStatus = None
        self._VirusStatus = None
        self._Progress = None
        self._IsAuthorized = None
        self._ImageSize = None
        self._ImageId = None
        self._RegistryRegion = None
        self._ImageCreateTime = None
        self._RequestId = None

    @property
    def ImageDigest(self):
        return self._ImageDigest

    @ImageDigest.setter
    def ImageDigest(self, ImageDigest):
        self._ImageDigest = ImageDigest

    @property
    def ImageRepoAddress(self):
        return self._ImageRepoAddress

    @ImageRepoAddress.setter
    def ImageRepoAddress(self, ImageRepoAddress):
        self._ImageRepoAddress = ImageRepoAddress

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def ImageName(self):
        return self._ImageName

    @ImageName.setter
    def ImageName(self, ImageName):
        self._ImageName = ImageName

    @property
    def ImageTag(self):
        return self._ImageTag

    @ImageTag.setter
    def ImageTag(self, ImageTag):
        self._ImageTag = ImageTag

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanStatus(self):
        return self._ScanStatus

    @ScanStatus.setter
    def ScanStatus(self, ScanStatus):
        self._ScanStatus = ScanStatus

    @property
    def VulCnt(self):
        return self._VulCnt

    @VulCnt.setter
    def VulCnt(self, VulCnt):
        self._VulCnt = VulCnt

    @property
    def VirusCnt(self):
        return self._VirusCnt

    @VirusCnt.setter
    def VirusCnt(self, VirusCnt):
        self._VirusCnt = VirusCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def SentiveInfoCnt(self):
        return self._SentiveInfoCnt

    @SentiveInfoCnt.setter
    def SentiveInfoCnt(self, SentiveInfoCnt):
        self._SentiveInfoCnt = SentiveInfoCnt

    @property
    def OsName(self):
        return self._OsName

    @OsName.setter
    def OsName(self, OsName):
        self._OsName = OsName

    @property
    def ScanVirusError(self):
        return self._ScanVirusError

    @ScanVirusError.setter
    def ScanVirusError(self, ScanVirusError):
        self._ScanVirusError = ScanVirusError

    @property
    def ScanVulError(self):
        return self._ScanVulError

    @ScanVulError.setter
    def ScanVulError(self, ScanVulError):
        self._ScanVulError = ScanVulError

    @property
    def LayerInfo(self):
        return self._LayerInfo

    @LayerInfo.setter
    def LayerInfo(self, LayerInfo):
        self._LayerInfo = LayerInfo

    @property
    def InstanceId(self):
        return self._InstanceId

    @InstanceId.setter
    def InstanceId(self, InstanceId):
        self._InstanceId = InstanceId

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def ScanRiskError(self):
        return self._ScanRiskError

    @ScanRiskError.setter
    def ScanRiskError(self, ScanRiskError):
        self._ScanRiskError = ScanRiskError

    @property
    def ScanVirusProgress(self):
        return self._ScanVirusProgress

    @ScanVirusProgress.setter
    def ScanVirusProgress(self, ScanVirusProgress):
        self._ScanVirusProgress = ScanVirusProgress

    @property
    def ScanVulProgress(self):
        return self._ScanVulProgress

    @ScanVulProgress.setter
    def ScanVulProgress(self, ScanVulProgress):
        self._ScanVulProgress = ScanVulProgress

    @property
    def ScanRiskProgress(self):
        return self._ScanRiskProgress

    @ScanRiskProgress.setter
    def ScanRiskProgress(self, ScanRiskProgress):
        self._ScanRiskProgress = ScanRiskProgress

    @property
    def ScanRemainTime(self):
        return self._ScanRemainTime

    @ScanRemainTime.setter
    def ScanRemainTime(self, ScanRemainTime):
        self._ScanRemainTime = ScanRemainTime

    @property
    def CveStatus(self):
        return self._CveStatus

    @CveStatus.setter
    def CveStatus(self, CveStatus):
        self._CveStatus = CveStatus

    @property
    def RiskStatus(self):
        return self._RiskStatus

    @RiskStatus.setter
    def RiskStatus(self, RiskStatus):
        self._RiskStatus = RiskStatus

    @property
    def VirusStatus(self):
        return self._VirusStatus

    @VirusStatus.setter
    def VirusStatus(self, VirusStatus):
        self._VirusStatus = VirusStatus

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def IsAuthorized(self):
        return self._IsAuthorized

    @IsAuthorized.setter
    def IsAuthorized(self, IsAuthorized):
        self._IsAuthorized = IsAuthorized

    @property
    def ImageSize(self):
        return self._ImageSize

    @ImageSize.setter
    def ImageSize(self, ImageSize):
        self._ImageSize = ImageSize

    @property
    def ImageId(self):
        return self._ImageId

    @ImageId.setter
    def ImageId(self, ImageId):
        self._ImageId = ImageId

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def ImageCreateTime(self):
        return self._ImageCreateTime

    @ImageCreateTime.setter
    def ImageCreateTime(self, ImageCreateTime):
        self._ImageCreateTime = ImageCreateTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageDigest = params.get("ImageDigest")
        self._ImageRepoAddress = params.get("ImageRepoAddress")
        self._RegistryType = params.get("RegistryType")
        self._ImageName = params.get("ImageName")
        self._ImageTag = params.get("ImageTag")
        self._ScanTime = params.get("ScanTime")
        self._ScanStatus = params.get("ScanStatus")
        self._VulCnt = params.get("VulCnt")
        self._VirusCnt = params.get("VirusCnt")
        self._RiskCnt = params.get("RiskCnt")
        self._SentiveInfoCnt = params.get("SentiveInfoCnt")
        self._OsName = params.get("OsName")
        self._ScanVirusError = params.get("ScanVirusError")
        self._ScanVulError = params.get("ScanVulError")
        self._LayerInfo = params.get("LayerInfo")
        self._InstanceId = params.get("InstanceId")
        self._InstanceName = params.get("InstanceName")
        self._Namespace = params.get("Namespace")
        self._ScanRiskError = params.get("ScanRiskError")
        self._ScanVirusProgress = params.get("ScanVirusProgress")
        self._ScanVulProgress = params.get("ScanVulProgress")
        self._ScanRiskProgress = params.get("ScanRiskProgress")
        self._ScanRemainTime = params.get("ScanRemainTime")
        self._CveStatus = params.get("CveStatus")
        self._RiskStatus = params.get("RiskStatus")
        self._VirusStatus = params.get("VirusStatus")
        self._Progress = params.get("Progress")
        self._IsAuthorized = params.get("IsAuthorized")
        self._ImageSize = params.get("ImageSize")
        self._ImageId = params.get("ImageId")
        self._RegistryRegion = params.get("RegistryRegion")
        self._ImageCreateTime = params.get("ImageCreateTime")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Sorting field
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _OnlyShowLatest: Whether to show only the latest repository images. Default value: `false`.
        :type OnlyShowLatest: bool
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None
        self._OnlyShowLatest = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OnlyShowLatest(self):
        return self._OnlyShowLatest

    @OnlyShowLatest.setter
    def OnlyShowLatest(self, OnlyShowLatest):
        self._OnlyShowLatest = OnlyShowLatest


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter field
`IsAuthorized` (whether licensed). Valid values: `all` (all); `0` (unlicensed); `1` (licensed).
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _OnlyShowLatest: Whether to show only the latest repository images. Default value: `false`.
        :type OnlyShowLatest: bool
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None
        self._OnlyShowLatest = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def OnlyShowLatest(self):
        return self._OnlyShowLatest

    @OnlyShowLatest.setter
    def OnlyShowLatest(self, OnlyShowLatest):
        self._OnlyShowLatest = OnlyShowLatest


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._OnlyShowLatest = params.get("OnlyShowLatest")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of image repositories
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageRepoInfo
        :param _TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRepoInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryDetailRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail request structure.

    """

    def __init__(self):
        r"""
        :param _RegistryId: Unique repository ID
        :type RegistryId: int
        """
        self._RegistryId = None

    @property
    def RegistryId(self):
        return self._RegistryId

    @RegistryId.setter
    def RegistryId(self, RegistryId):
        self._RegistryId = RegistryId


    def _deserialize(self, params):
        self._RegistryId = params.get("RegistryId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRegistryDetailResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryDetail response structure.

    """

    def __init__(self):
        r"""
        :param _Name: Repository name
        :type Name: str
        :param _Username: Username
        :type Username: str
        :param _Password: Password
        :type Password: str
        :param _Url: Repository URL
        :type Url: str
        :param _RegistryType: Repository type, which can be `harbor`.
        :type RegistryType: str
        :param _RegistryVersion: Repository version
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryVersion: str
        :param _NetType: Network type, which can be `public` (public network).
        :type NetType: str
        :param _RegistryRegion: Region. Default value: `default`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RegistryRegion: str
        :param _SpeedLimit: Speed limit
Note: This field may return null, indicating that no valid values can be obtained.
        :type SpeedLimit: int
        :param _Insecure: Valid values: `0` (secure mode with certificate verification, which is the default value); `1` (unsecure mode that skips certificate verification).
Note: This field may return null, indicating that no valid values can be obtained.
        :type Insecure: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Name = None
        self._Username = None
        self._Password = None
        self._Url = None
        self._RegistryType = None
        self._RegistryVersion = None
        self._NetType = None
        self._RegistryRegion = None
        self._SpeedLimit = None
        self._Insecure = None
        self._RequestId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Username(self):
        return self._Username

    @Username.setter
    def Username(self, Username):
        self._Username = Username

    @property
    def Password(self):
        return self._Password

    @Password.setter
    def Password(self, Password):
        self._Password = Password

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def RegistryVersion(self):
        return self._RegistryVersion

    @RegistryVersion.setter
    def RegistryVersion(self, RegistryVersion):
        self._RegistryVersion = RegistryVersion

    @property
    def NetType(self):
        return self._NetType

    @NetType.setter
    def NetType(self, NetType):
        self._NetType = NetType

    @property
    def RegistryRegion(self):
        return self._RegistryRegion

    @RegistryRegion.setter
    def RegistryRegion(self, RegistryRegion):
        self._RegistryRegion = RegistryRegion

    @property
    def SpeedLimit(self):
        return self._SpeedLimit

    @SpeedLimit.setter
    def SpeedLimit(self, SpeedLimit):
        self._SpeedLimit = SpeedLimit

    @property
    def Insecure(self):
        return self._Insecure

    @Insecure.setter
    def Insecure(self, Insecure):
        self._Insecure = Insecure

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Username = params.get("Username")
        self._Password = params.get("Password")
        self._Url = params.get("Url")
        self._RegistryType = params.get("RegistryType")
        self._RegistryVersion = params.get("RegistryVersion")
        self._NetType = params.get("NetType")
        self._RegistryRegion = params.get("RegistryRegion")
        self._SpeedLimit = params.get("SpeedLimit")
        self._Insecure = params.get("Insecure")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRegistryListRequest(AbstractModel):
    """DescribeAssetImageRegistryRegistryList request structure.

    """


class DescribeAssetImageRegistryRegistryListResponse(AbstractModel):
    """DescribeAssetImageRegistryRegistryList response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskInfoListRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image ID
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _By: Sorting field: `Level`.
        :type By: str
        :param _Order: Sorting order. Valid values: `+`, `-`.
        :type Order: str
        :param _Id: Image ID
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._By = None
        self._Order = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._By = params.get("By")
        self._Order = params.get("Order")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskInfoListResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskInfoList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageRisk
        :param _TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRisk()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: Image ID
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryRiskListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryScanStatusOneKeyRequest(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey request structure.

    """

    def __init__(self):
        r"""
        :param _Images: List of images for which to get the progress
        :type Images: list of ImageInfo
        :param _All: Whether to get all images
        :type All: bool
        :param _Id: List of IDs of images for which to get the progress
        :type Id: list of int non-negative
        """
        self._Images = None
        self._All = None
        self._Id = None

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._All = params.get("All")
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryScanStatusOneKeyResponse(AbstractModel):
    """DescribeAssetImageRegistryScanStatusOneKey response structure.

    """

    def __init__(self):
        r"""
        :param _ImageTotal: Number of images
        :type ImageTotal: int
        :param _ImageScanCnt: Number of scanned images
        :type ImageScanCnt: int
        :param _ImageStatus: Scanning progress list
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageStatus: list of ImageProgress
        :param _SuccessCount: Number of successfully scanned images
        :type SuccessCount: int
        :param _RiskCount: Number of risks
        :type RiskCount: int
        :param _Schedule: Scanning progress
        :type Schedule: int
        :param _Status: Scanning status
        :type Status: str
        :param _ScanRemainTime: Remaining scan time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanRemainTime: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageTotal = None
        self._ImageScanCnt = None
        self._ImageStatus = None
        self._SuccessCount = None
        self._RiskCount = None
        self._Schedule = None
        self._Status = None
        self._ScanRemainTime = None
        self._RequestId = None

    @property
    def ImageTotal(self):
        return self._ImageTotal

    @ImageTotal.setter
    def ImageTotal(self, ImageTotal):
        self._ImageTotal = ImageTotal

    @property
    def ImageScanCnt(self):
        return self._ImageScanCnt

    @ImageScanCnt.setter
    def ImageScanCnt(self, ImageScanCnt):
        self._ImageScanCnt = ImageScanCnt

    @property
    def ImageStatus(self):
        return self._ImageStatus

    @ImageStatus.setter
    def ImageStatus(self, ImageStatus):
        self._ImageStatus = ImageStatus

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def RiskCount(self):
        return self._RiskCount

    @RiskCount.setter
    def RiskCount(self, RiskCount):
        self._RiskCount = RiskCount

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ScanRemainTime(self):
        return self._ScanRemainTime

    @ScanRemainTime.setter
    def ScanRemainTime(self, ScanRemainTime):
        self._ScanRemainTime = ScanRemainTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageTotal = params.get("ImageTotal")
        self._ImageScanCnt = params.get("ImageScanCnt")
        if params.get("ImageStatus") is not None:
            self._ImageStatus = []
            for item in params.get("ImageStatus"):
                obj = ImageProgress()
                obj._deserialize(item)
                self._ImageStatus.append(obj)
        self._SuccessCount = params.get("SuccessCount")
        self._RiskCount = params.get("RiskCount")
        self._Schedule = params.get("Schedule")
        self._Status = params.get("Status")
        self._ScanRemainTime = params.get("ScanRemainTime")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistrySummaryRequest(AbstractModel):
    """DescribeAssetImageRegistrySummary request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: 
        :type Filters: list of AssetFilters
        """
        self._Filters = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistrySummaryResponse(AbstractModel):
    """DescribeAssetImageRegistrySummary response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: Image ID
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVirusListRequest(AbstractModel):
    """DescribeAssetImageRegistryVirusList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: Image ID
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVirusListResponse(AbstractModel):
    """DescribeAssetImageRegistryVirusList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageVirus
        :param _TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVirus()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListExportRequest(AbstractModel):
    """DescribeAssetImageRegistryVulListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: Image ID
        :type Id: int
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListExportResponse(AbstractModel):
    """DescribeAssetImageRegistryVulListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRegistryVulListRequest(AbstractModel):
    """DescribeAssetImageRegistryVulList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Vulnerability level</li>
<li>Name - String - Required: No - Vulnerability name</li>
        :type Filters: list of AssetFilters
        :param _ImageInfo: Image information
        :type ImageInfo: :class:`tencentcloud.tcss.v20201101.models.ImageInfo`
        :param _Id: Image ID
        :type Id: int
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._ImageInfo = None
        self._Id = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def ImageInfo(self):
        return self._ImageInfo

    @ImageInfo.setter
    def ImageInfo(self, ImageInfo):
        self._ImageInfo = ImageInfo

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        if params.get("ImageInfo") is not None:
            self._ImageInfo = ImageInfo()
            self._ImageInfo._deserialize(params.get("ImageInfo"))
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRegistryVulListResponse(AbstractModel):
    """DescribeAssetImageRegistryVulList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of image vulnerabilities
Note: This field may return null, indicating that no valid values can be obtained.
        :type List: list of ImageVul
        :param _TotalCount: Total number
Note: This field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRiskListExportRequest(AbstractModel):
    """DescribeAssetImageRiskListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Filters: Filter
<li>Level- String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Behavior - String - Required: No - Risky behavior. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Type - String - Required: No - Risk type. Valid values: `1`, `2`.</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListExportResponse(AbstractModel):
    """DescribeAssetImageRiskListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageRiskListRequest(AbstractModel):
    """DescribeAssetImageRiskList request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Behavior - String - Required: No - Risky behavior. Valid values: `1`, `2`, `3`, `4`.</li>
<li>Type - String - Required: No - Risk type. Valid values: `1`, `2`.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageRiskListResponse(AbstractModel):
    """DescribeAssetImageRiskList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of viruses in the image
        :type List: list of ImageRiskInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageRiskInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanSettingRequest(AbstractModel):
    """DescribeAssetImageScanSetting request structure.

    """


class DescribeAssetImageScanSettingResponse(AbstractModel):
    """DescribeAssetImageScanSetting response structure.

    """

    def __init__(self):
        r"""
        :param _Enable: Switch
        :type Enable: bool
        :param _ScanTime: Scan time, which is a complete time and parsed as hour/minute/second in time zone 0 on the backend.
        :type ScanTime: str
        :param _ScanPeriod: Scan interval
        :type ScanPeriod: int
        :param _ScanVirus: Trojan scan
        :type ScanVirus: bool
        :param _ScanRisk: Sensitive data scan
        :type ScanRisk: bool
        :param _ScanVul: Vulnerability scan
        :type ScanVul: bool
        :param _All: Scan of all images
        :type All: bool
        :param _Images: Scan of specified images
        :type Images: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanVirus = None
        self._ScanRisk = None
        self._ScanVul = None
        self._All = None
        self._Images = None
        self._RequestId = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanVirus(self):
        return self._ScanVirus

    @ScanVirus.setter
    def ScanVirus(self, ScanVirus):
        self._ScanVirus = ScanVirus

    @property
    def ScanRisk(self):
        return self._ScanRisk

    @ScanRisk.setter
    def ScanRisk(self, ScanRisk):
        self._ScanRisk = ScanRisk

    @property
    def ScanVul(self):
        return self._ScanVul

    @ScanVul.setter
    def ScanVul(self, ScanVul):
        self._ScanVul = ScanVul

    @property
    def All(self):
        return self._All

    @All.setter
    def All(self, All):
        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanVirus = params.get("ScanVirus")
        self._ScanRisk = params.get("ScanRisk")
        self._ScanVul = params.get("ScanVul")
        self._All = params.get("All")
        self._Images = params.get("Images")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanStatusRequest(AbstractModel):
    """DescribeAssetImageScanStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: Task ID
        :type TaskID: str
        """
        self._TaskID = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageScanStatusResponse(AbstractModel):
    """DescribeAssetImageScanStatus response structure.

    """

    def __init__(self):
        r"""
        :param _ImageTotal: Number of images
        :type ImageTotal: int
        :param _ImageScanCnt: Number of scanned images
        :type ImageScanCnt: int
        :param _Status: Scanning status
        :type Status: str
        :param _Schedule: Scanning progress, the value of which is calculated as `ImageScanCnt`/`ImageTotal` * 100.
        :type Schedule: int
        :param _SuccessCount: Number of successfully scanned images
        :type SuccessCount: int
        :param _RiskCount: Number of risks
        :type RiskCount: int
        :param _LeftSeconds: Remaining scan time
        :type LeftSeconds: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageTotal = None
        self._ImageScanCnt = None
        self._Status = None
        self._Schedule = None
        self._SuccessCount = None
        self._RiskCount = None
        self._LeftSeconds = None
        self._RequestId = None

    @property
    def ImageTotal(self):
        return self._ImageTotal

    @ImageTotal.setter
    def ImageTotal(self, ImageTotal):
        self._ImageTotal = ImageTotal

    @property
    def ImageScanCnt(self):
        return self._ImageScanCnt

    @ImageScanCnt.setter
    def ImageScanCnt(self, ImageScanCnt):
        self._ImageScanCnt = ImageScanCnt

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def Schedule(self):
        return self._Schedule

    @Schedule.setter
    def Schedule(self, Schedule):
        self._Schedule = Schedule

    @property
    def SuccessCount(self):
        return self._SuccessCount

    @SuccessCount.setter
    def SuccessCount(self, SuccessCount):
        self._SuccessCount = SuccessCount

    @property
    def RiskCount(self):
        return self._RiskCount

    @RiskCount.setter
    def RiskCount(self, RiskCount):
        self._RiskCount = RiskCount

    @property
    def LeftSeconds(self):
        return self._LeftSeconds

    @LeftSeconds.setter
    def LeftSeconds(self, LeftSeconds):
        self._LeftSeconds = LeftSeconds

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ImageTotal = params.get("ImageTotal")
        self._ImageScanCnt = params.get("ImageScanCnt")
        self._Status = params.get("Status")
        self._Schedule = params.get("Schedule")
        self._SuccessCount = params.get("SuccessCount")
        self._RiskCount = params.get("RiskCount")
        self._LeftSeconds = params.get("LeftSeconds")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageScanTaskRequest(AbstractModel):
    """DescribeAssetImageScanTask request structure.

    """


class DescribeAssetImageScanTaskResponse(AbstractModel):
    """DescribeAssetImageScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskID: Task ID
        :type TaskID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskID = None
        self._RequestId = None

    @property
    def TaskID(self):
        return self._TaskID

    @TaskID.setter
    def TaskID(self, TaskID):
        self._TaskID = TaskID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskID = params.get("TaskID")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageSimpleListRequest(AbstractModel):
    """DescribeAssetImageSimpleList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Keywords- String - Required: No - Image name/ID</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageSimpleListResponse(AbstractModel):
    """DescribeAssetImageSimpleList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of images
        :type List: list of AssetSimpleImageInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AssetSimpleImageInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVirusListExportRequest(AbstractModel):
    """DescribeAssetImageVirusListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Fields supported in the list
        :type ExportField: list of str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Filters: Filter
<li>Name- String - Required: No - Image name</li>
<li>RiskLevel - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListExportResponse(AbstractModel):
    """DescribeAssetImageVirusListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param _JobId: Task ID
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVirusListRequest(AbstractModel):
    """DescribeAssetImageVirusList request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Name- String - Required: No - Image name</li>
<li>RiskLevel - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVirusListResponse(AbstractModel):
    """DescribeAssetImageVirusList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of viruses in the image
        :type List: list of ImageVirusInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _VirusScanStatus: Virus scanning status
`0`: Not scanned.
`1`: Scanning.
`2`: Scanned.
`3`: Scan error.
`4`: Scan canceled.
        :type VirusScanStatus: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._VirusScanStatus = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def VirusScanStatus(self):
        return self._VirusScanStatus

    @VirusScanStatus.setter
    def VirusScanStatus(self, VirusScanStatus):
        self._VirusScanStatus = VirusScanStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageVirusInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._VirusScanStatus = params.get("VirusScanStatus")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVulListExportRequest(AbstractModel):
    """DescribeAssetImageVulListExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Name- String - Required: No - Vulnerability name</li>
<li>Level - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        """
        self._ExportField = None
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListExportResponse(AbstractModel):
    """DescribeAssetImageVulListExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel file download URL
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeAssetImageVulListRequest(AbstractModel):
    """DescribeAssetImageVulList request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Name- String - Required: No - Vulnerability name</li>
<li>Level - String - Required: No - Risk level. Valid values: `1`, `2`, `3`, `4`.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field: `Level`.
        :type By: str
        :param _Order: Sorting order. Valid values: `+`, `-`.
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetImageVulListResponse(AbstractModel):
    """DescribeAssetImageVulList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of image vulnerabilities
        :type List: list of ImagesVul
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImagesVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetPortListRequest(AbstractModel):
    """DescribeAssetPortList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>All - String - Required: No - Optional field for the fuzzy query</li>
<li>RunAs - String - Required: No - Operator</li>
<li>ContainerID - String - Required: No - Container ID</li>
<li>HostID- String - Required: Yes - Server ID</li>
<li>HostIP- string - Required: No - Server IP</li>
<li>ProcessName- string - Required: No - Process name</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetPortListResponse(AbstractModel):
    """DescribeAssetPortList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of ports
        :type List: list of PortInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PortInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetProcessListRequest(AbstractModel):
    """DescribeAssetProcessList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>RunAs - String - Required: No - Operator</li>
<li>ContainerID - String - Required: No - Container ID</li>
<li>HostID- String - Required: Yes - Server ID</li>
<li>HostIP- string - Required: No - Server IP</li>
<li>ProcessName- string - Required: No - Process name</li>
<li>Pid- string - Required: No - Process ID (associated process)</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetProcessListResponse(AbstractModel):
    """DescribeAssetProcessList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of ports
        :type List: list of ProcessInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ProcessInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAssetSummaryRequest(AbstractModel):
    """DescribeAssetSummary request structure.

    """


class DescribeAssetSummaryResponse(AbstractModel):
    """DescribeAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param _AppCnt: Number of applications
        :type AppCnt: int
        :param _ContainerCnt: Number of containers
        :type ContainerCnt: int
        :param _ContainerPause: Number of paused containers
        :type ContainerPause: int
        :param _ContainerRunning: Number of running containers
        :type ContainerRunning: int
        :param _ContainerStop: Number of stopped containers
        :type ContainerStop: int
        :param _CreateTime: Creation time
        :type CreateTime: str
        :param _DbCnt: Number of databases
        :type DbCnt: int
        :param _ImageCnt: Number of images
        :type ImageCnt: int
        :param _HostOnline: Number of online servers
        :type HostOnline: int
        :param _HostCnt: Number of servers
        :type HostCnt: int
        :param _ImageHasRiskInfoCnt: Number of images at risk
        :type ImageHasRiskInfoCnt: int
        :param _ImageHasVirusCnt: Number of images with viruses
        :type ImageHasVirusCnt: int
        :param _ImageHasVulsCnt: Number of images with vulnerabilities
        :type ImageHasVulsCnt: int
        :param _ImageUntrustCnt: Number of untrusted images
        :type ImageUntrustCnt: int
        :param _ListenPortCnt: Number of listened ports
        :type ListenPortCnt: int
        :param _ProcessCnt: Number of processes
        :type ProcessCnt: int
        :param _WebServiceCnt: Number of web services
        :type WebServiceCnt: int
        :param _LatestImageScanTime: Last image scan time
        :type LatestImageScanTime: str
        :param _ImageUnsafeCnt: Number of images at risk
        :type ImageUnsafeCnt: int
        :param _HostUnInstallCnt: Number of servers not installed with the agent
        :type HostUnInstallCnt: int
        :param _SuperNodeCnt: Number of super nodes
        :type SuperNodeCnt: int
        :param _SuperNodeRunningCnt: Number of running super nodes
        :type SuperNodeRunningCnt: int
        :param _TodayNewImageCnt: 
        :type TodayNewImageCnt: int
        :param _TodayUnsafeImageCnt: 
        :type TodayUnsafeImageCnt: int
        :param _RecommendedFixImageCnt: 
        :type RecommendedFixImageCnt: int
        :param _ScannedImageCnt: 
        :type ScannedImageCnt: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AppCnt = None
        self._ContainerCnt = None
        self._ContainerPause = None
        self._ContainerRunning = None
        self._ContainerStop = None
        self._CreateTime = None
        self._DbCnt = None
        self._ImageCnt = None
        self._HostOnline = None
        self._HostCnt = None
        self._ImageHasRiskInfoCnt = None
        self._ImageHasVirusCnt = None
        self._ImageHasVulsCnt = None
        self._ImageUntrustCnt = None
        self._ListenPortCnt = None
        self._ProcessCnt = None
        self._WebServiceCnt = None
        self._LatestImageScanTime = None
        self._ImageUnsafeCnt = None
        self._HostUnInstallCnt = None
        self._SuperNodeCnt = None
        self._SuperNodeRunningCnt = None
        self._TodayNewImageCnt = None
        self._TodayUnsafeImageCnt = None
        self._RecommendedFixImageCnt = None
        self._ScannedImageCnt = None
        self._RequestId = None

    @property
    def AppCnt(self):
        return self._AppCnt

    @AppCnt.setter
    def AppCnt(self, AppCnt):
        self._AppCnt = AppCnt

    @property
    def ContainerCnt(self):
        return self._ContainerCnt

    @ContainerCnt.setter
    def ContainerCnt(self, ContainerCnt):
        self._ContainerCnt = ContainerCnt

    @property
    def ContainerPause(self):
        return self._ContainerPause

    @ContainerPause.setter
    def ContainerPause(self, ContainerPause):
        self._ContainerPause = ContainerPause

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ContainerStop(self):
        return self._ContainerStop

    @ContainerStop.setter
    def ContainerStop(self, ContainerStop):
        self._ContainerStop = ContainerStop

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def DbCnt(self):
        return self._DbCnt

    @DbCnt.setter
    def DbCnt(self, DbCnt):
        self._DbCnt = DbCnt

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def HostOnline(self):
        return self._HostOnline

    @HostOnline.setter
    def HostOnline(self, HostOnline):
        self._HostOnline = HostOnline

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def ImageHasRiskInfoCnt(self):
        return self._ImageHasRiskInfoCnt

    @ImageHasRiskInfoCnt.setter
    def ImageHasRiskInfoCnt(self, ImageHasRiskInfoCnt):
        self._ImageHasRiskInfoCnt = ImageHasRiskInfoCnt

    @property
    def ImageHasVirusCnt(self):
        return self._ImageHasVirusCnt

    @ImageHasVirusCnt.setter
    def ImageHasVirusCnt(self, ImageHasVirusCnt):
        self._ImageHasVirusCnt = ImageHasVirusCnt

    @property
    def ImageHasVulsCnt(self):
        return self._ImageHasVulsCnt

    @ImageHasVulsCnt.setter
    def ImageHasVulsCnt(self, ImageHasVulsCnt):
        self._ImageHasVulsCnt = ImageHasVulsCnt

    @property
    def ImageUntrustCnt(self):
        return self._ImageUntrustCnt

    @ImageUntrustCnt.setter
    def ImageUntrustCnt(self, ImageUntrustCnt):
        self._ImageUntrustCnt = ImageUntrustCnt

    @property
    def ListenPortCnt(self):
        return self._ListenPortCnt

    @ListenPortCnt.setter
    def ListenPortCnt(self, ListenPortCnt):
        self._ListenPortCnt = ListenPortCnt

    @property
    def ProcessCnt(self):
        return self._ProcessCnt

    @ProcessCnt.setter
    def ProcessCnt(self, ProcessCnt):
        self._ProcessCnt = ProcessCnt

    @property
    def WebServiceCnt(self):
        return self._WebServiceCnt

    @WebServiceCnt.setter
    def WebServiceCnt(self, WebServiceCnt):
        self._WebServiceCnt = WebServiceCnt

    @property
    def LatestImageScanTime(self):
        return self._LatestImageScanTime

    @LatestImageScanTime.setter
    def LatestImageScanTime(self, LatestImageScanTime):
        self._LatestImageScanTime = LatestImageScanTime

    @property
    def ImageUnsafeCnt(self):
        return self._ImageUnsafeCnt

    @ImageUnsafeCnt.setter
    def ImageUnsafeCnt(self, ImageUnsafeCnt):
        self._ImageUnsafeCnt = ImageUnsafeCnt

    @property
    def HostUnInstallCnt(self):
        return self._HostUnInstallCnt

    @HostUnInstallCnt.setter
    def HostUnInstallCnt(self, HostUnInstallCnt):
        self._HostUnInstallCnt = HostUnInstallCnt

    @property
    def SuperNodeCnt(self):
        return self._SuperNodeCnt

    @SuperNodeCnt.setter
    def SuperNodeCnt(self, SuperNodeCnt):
        self._SuperNodeCnt = SuperNodeCnt

    @property
    def SuperNodeRunningCnt(self):
        return self._SuperNodeRunningCnt

    @SuperNodeRunningCnt.setter
    def SuperNodeRunningCnt(self, SuperNodeRunningCnt):
        self._SuperNodeRunningCnt = SuperNodeRunningCnt

    @property
    def TodayNewImageCnt(self):
        return self._TodayNewImageCnt

    @TodayNewImageCnt.setter
    def TodayNewImageCnt(self, TodayNewImageCnt):
        self._TodayNewImageCnt = TodayNewImageCnt

    @property
    def TodayUnsafeImageCnt(self):
        return self._TodayUnsafeImageCnt

    @TodayUnsafeImageCnt.setter
    def TodayUnsafeImageCnt(self, TodayUnsafeImageCnt):
        self._TodayUnsafeImageCnt = TodayUnsafeImageCnt

    @property
    def RecommendedFixImageCnt(self):
        return self._RecommendedFixImageCnt

    @RecommendedFixImageCnt.setter
    def RecommendedFixImageCnt(self, RecommendedFixImageCnt):
        self._RecommendedFixImageCnt = RecommendedFixImageCnt

    @property
    def ScannedImageCnt(self):
        return self._ScannedImageCnt

    @ScannedImageCnt.setter
    def ScannedImageCnt(self, ScannedImageCnt):
        self._ScannedImageCnt = ScannedImageCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AppCnt = params.get("AppCnt")
        self._ContainerCnt = params.get("ContainerCnt")
        self._ContainerPause = params.get("ContainerPause")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ContainerStop = params.get("ContainerStop")
        self._CreateTime = params.get("CreateTime")
        self._DbCnt = params.get("DbCnt")
        self._ImageCnt = params.get("ImageCnt")
        self._HostOnline = params.get("HostOnline")
        self._HostCnt = params.get("HostCnt")
        self._ImageHasRiskInfoCnt = params.get("ImageHasRiskInfoCnt")
        self._ImageHasVirusCnt = params.get("ImageHasVirusCnt")
        self._ImageHasVulsCnt = params.get("ImageHasVulsCnt")
        self._ImageUntrustCnt = params.get("ImageUntrustCnt")
        self._ListenPortCnt = params.get("ListenPortCnt")
        self._ProcessCnt = params.get("ProcessCnt")
        self._WebServiceCnt = params.get("WebServiceCnt")
        self._LatestImageScanTime = params.get("LatestImageScanTime")
        self._ImageUnsafeCnt = params.get("ImageUnsafeCnt")
        self._HostUnInstallCnt = params.get("HostUnInstallCnt")
        self._SuperNodeCnt = params.get("SuperNodeCnt")
        self._SuperNodeRunningCnt = params.get("SuperNodeRunningCnt")
        self._TodayNewImageCnt = params.get("TodayNewImageCnt")
        self._TodayUnsafeImageCnt = params.get("TodayUnsafeImageCnt")
        self._RecommendedFixImageCnt = params.get("RecommendedFixImageCnt")
        self._ScannedImageCnt = params.get("ScannedImageCnt")
        self._RequestId = params.get("RequestId")


class DescribeAssetSyncLastTimeRequest(AbstractModel):
    """DescribeAssetSyncLastTime request structure.

    """


class DescribeAssetSyncLastTimeResponse(AbstractModel):
    """DescribeAssetSyncLastTime response structure.

    """

    def __init__(self):
        r"""
        :param _AssetSyncLastTime: Last asset sync time
        :type AssetSyncLastTime: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssetSyncLastTime = None
        self._RequestId = None

    @property
    def AssetSyncLastTime(self):
        return self._AssetSyncLastTime

    @AssetSyncLastTime.setter
    def AssetSyncLastTime(self, AssetSyncLastTime):
        self._AssetSyncLastTime = AssetSyncLastTime

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._AssetSyncLastTime = params.get("AssetSyncLastTime")
        self._RequestId = params.get("RequestId")


class DescribeAssetWebServiceListRequest(AbstractModel):
    """DescribeAssetWebServiceList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Keywords- String - Required: No - Optional field for the fuzzy query</li>
<li>Type- String - Required: No - Server status. "Apache"
"Jboss"
"lighttpd"
"Nginx"
"Tomcat"</li>
        :type Filters: list of AssetFilters
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAssetWebServiceListResponse(AbstractModel):
    """DescribeAssetWebServiceList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of servers
        :type List: list of ServiceInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ServiceInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeAutoAuthorizedRuleHostRequest(AbstractModel):
    """DescribeAutoAuthorizedRuleHost request structure.

    """

    def __init__(self):
        r"""
        :param _RuleId: Rule ID
        :type RuleId: int
        :param _Limit: Number of results to be returned. Default value: `all`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting field
        :type Order: str
        :param _By: Sorting order. Valid values: `asc`, `desc`.
        :type By: str
        """
        self._RuleId = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._RuleId = params.get("RuleId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAutoAuthorizedRuleHostResponse(AbstractModel):
    """DescribeAutoAuthorizedRuleHost response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of servers licensed based on the automatic image licensing rule
        :type List: list of AutoAuthorizedRuleHostInfo
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AutoAuthorizedRuleHostInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCheckItemListRequest(AbstractModel):
    """DescribeCheckItemList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name. Valid values: `risk_level` (risk level); `risk_target` (check target and risky target); `risk_type` (risk type); `risk_attri` (risk type of the check item).
        :type Filters: list of ComplianceFilters
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCheckItemListResponse(AbstractModel):
    """DescribeCheckItemList response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterCheckItems: Array of check item details
        :type ClusterCheckItems: list of ClusterCheckItem
        :param _TotalCount: Total number of check items
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterCheckItems = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterCheckItems(self):
        return self._ClusterCheckItems

    @ClusterCheckItems.setter
    def ClusterCheckItems(self, ClusterCheckItems):
        self._ClusterCheckItems = ClusterCheckItems

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterCheckItems") is not None:
            self._ClusterCheckItems = []
            for item in params.get("ClusterCheckItems"):
                obj = ClusterCheckItem()
                obj._deserialize(item)
                self._ClusterCheckItems.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeClusterDetailRequest(AbstractModel):
    """DescribeClusterDetail request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        """
        self._ClusterId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClusterDetailResponse(AbstractModel):
    """DescribeClusterDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _ClusterName: Cluster name
        :type ClusterName: str
        :param _ScanTaskProgress: Progress of the current cluster scan task. `100` indicates that the scan is completed.
        :type ScanTaskProgress: int
        :param _ClusterVersion: Cluster version
        :type ClusterVersion: str
        :param _ContainerRuntime: Runtime component
        :type ContainerRuntime: str
        :param _ClusterNodeNum: Number of nodes in the cluster
        :type ClusterNodeNum: int
        :param _ClusterStatus: Cluster status. Valid values: `Running`, `Creating`, `Abnormal`.
        :type ClusterStatus: str
        :param _ClusterType: Cluster type. Valid values: `MANAGED_CLUSTER` (managed cluster); `INDEPENDENT_CLUSTER` (self-deployed cluster).
        :type ClusterType: str
        :param _Region: Cluster region
        :type Region: str
        :param _SeriousRiskCount: Number of critical check items
        :type SeriousRiskCount: int
        :param _HighRiskCount: Number of high-risk check items
        :type HighRiskCount: int
        :param _MiddleRiskCount: Number of medium-risk check items
        :type MiddleRiskCount: int
        :param _HintRiskCount: Number of prompt-risk check items
        :type HintRiskCount: int
        :param _CheckStatus: Status of the check task
        :type CheckStatus: str
        :param _DefenderStatus: Status of the defender
        :type DefenderStatus: str
        :param _TaskCreateTime: Creation time of the scan task
        :type TaskCreateTime: str
        :param _NetworkType: Network type. Valid values: `PublicNetwork` (public network); `VPCNetwork` (VPC).
        :type NetworkType: str
        :param _ApiServerAddress: API server address
        :type ApiServerAddress: str
        :param _NodeCount: Number of nodes
        :type NodeCount: int
        :param _NamespaceCount: Number of namespaces
        :type NamespaceCount: int
        :param _WorkloadCount: Number of workloads
        :type WorkloadCount: int
        :param _PodCount: Number of Pods
        :type PodCount: int
        :param _ServiceCount: Number of Services
        :type ServiceCount: int
        :param _IngressCount: Number of Ingresses
        :type IngressCount: int
        :param _MasterIps: IPs of the primary nodes
        :type MasterIps: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._ClusterName = None
        self._ScanTaskProgress = None
        self._ClusterVersion = None
        self._ContainerRuntime = None
        self._ClusterNodeNum = None
        self._ClusterStatus = None
        self._ClusterType = None
        self._Region = None
        self._SeriousRiskCount = None
        self._HighRiskCount = None
        self._MiddleRiskCount = None
        self._HintRiskCount = None
        self._CheckStatus = None
        self._DefenderStatus = None
        self._TaskCreateTime = None
        self._NetworkType = None
        self._ApiServerAddress = None
        self._NodeCount = None
        self._NamespaceCount = None
        self._WorkloadCount = None
        self._PodCount = None
        self._ServiceCount = None
        self._IngressCount = None
        self._MasterIps = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def ClusterName(self):
        return self._ClusterName

    @ClusterName.setter
    def ClusterName(self, ClusterName):
        self._ClusterName = ClusterName

    @property
    def ScanTaskProgress(self):
        return self._ScanTaskProgress

    @ScanTaskProgress.setter
    def ScanTaskProgress(self, ScanTaskProgress):
        self._ScanTaskProgress = ScanTaskProgress

    @property
    def ClusterVersion(self):
        return self._ClusterVersion

    @ClusterVersion.setter
    def ClusterVersion(self, ClusterVersion):
        self._ClusterVersion = ClusterVersion

    @property
    def ContainerRuntime(self):
        return self._ContainerRuntime

    @ContainerRuntime.setter
    def ContainerRuntime(self, ContainerRuntime):
        self._ContainerRuntime = ContainerRuntime

    @property
    def ClusterNodeNum(self):
        return self._ClusterNodeNum

    @ClusterNodeNum.setter
    def ClusterNodeNum(self, ClusterNodeNum):
        self._ClusterNodeNum = ClusterNodeNum

    @property
    def ClusterStatus(self):
        return self._ClusterStatus

    @ClusterStatus.setter
    def ClusterStatus(self, ClusterStatus):
        self._ClusterStatus = ClusterStatus

    @property
    def ClusterType(self):
        return self._ClusterType

    @ClusterType.setter
    def ClusterType(self, ClusterType):
        self._ClusterType = ClusterType

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def SeriousRiskCount(self):
        return self._SeriousRiskCount

    @SeriousRiskCount.setter
    def SeriousRiskCount(self, SeriousRiskCount):
        self._SeriousRiskCount = SeriousRiskCount

    @property
    def HighRiskCount(self):
        return self._HighRiskCount

    @HighRiskCount.setter
    def HighRiskCount(self, HighRiskCount):
        self._HighRiskCount = HighRiskCount

    @property
    def MiddleRiskCount(self):
        return self._MiddleRiskCount

    @MiddleRiskCount.setter
    def MiddleRiskCount(self, MiddleRiskCount):
        self._MiddleRiskCount = MiddleRiskCount

    @property
    def HintRiskCount(self):
        return self._HintRiskCount

    @HintRiskCount.setter
    def HintRiskCount(self, HintRiskCount):
        self._HintRiskCount = HintRiskCount

    @property
    def CheckStatus(self):
        return self._CheckStatus

    @CheckStatus.setter
    def CheckStatus(self, CheckStatus):
        self._CheckStatus = CheckStatus

    @property
    def DefenderStatus(self):
        return self._DefenderStatus

    @DefenderStatus.setter
    def DefenderStatus(self, DefenderStatus):
        self._DefenderStatus = DefenderStatus

    @property
    def TaskCreateTime(self):
        return self._TaskCreateTime

    @TaskCreateTime.setter
    def TaskCreateTime(self, TaskCreateTime):
        self._TaskCreateTime = TaskCreateTime

    @property
    def NetworkType(self):
        return self._NetworkType

    @NetworkType.setter
    def NetworkType(self, NetworkType):
        self._NetworkType = NetworkType

    @property
    def ApiServerAddress(self):
        return self._ApiServerAddress

    @ApiServerAddress.setter
    def ApiServerAddress(self, ApiServerAddress):
        self._ApiServerAddress = ApiServerAddress

    @property
    def NodeCount(self):
        return self._NodeCount

    @NodeCount.setter
    def NodeCount(self, NodeCount):
        self._NodeCount = NodeCount

    @property
    def NamespaceCount(self):
        return self._NamespaceCount

    @NamespaceCount.setter
    def NamespaceCount(self, NamespaceCount):
        self._NamespaceCount = NamespaceCount

    @property
    def WorkloadCount(self):
        return self._WorkloadCount

    @WorkloadCount.setter
    def WorkloadCount(self, WorkloadCount):
        self._WorkloadCount = WorkloadCount

    @property
    def PodCount(self):
        return self._PodCount

    @PodCount.setter
    def PodCount(self, PodCount):
        self._PodCount = PodCount

    @property
    def ServiceCount(self):
        return self._ServiceCount

    @ServiceCount.setter
    def ServiceCount(self, ServiceCount):
        self._ServiceCount = ServiceCount

    @property
    def IngressCount(self):
        return self._IngressCount

    @IngressCount.setter
    def IngressCount(self, IngressCount):
        self._IngressCount = IngressCount

    @property
    def MasterIps(self):
        return self._MasterIps

    @MasterIps.setter
    def MasterIps(self, MasterIps):
        self._MasterIps = MasterIps

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._ClusterName = params.get("ClusterName")
        self._ScanTaskProgress = params.get("ScanTaskProgress")
        self._ClusterVersion = params.get("ClusterVersion")
        self._ContainerRuntime = params.get("ContainerRuntime")
        self._ClusterNodeNum = params.get("ClusterNodeNum")
        self._ClusterStatus = params.get("ClusterStatus")
        self._ClusterType = params.get("ClusterType")
        self._Region = params.get("Region")
        self._SeriousRiskCount = params.get("SeriousRiskCount")
        self._HighRiskCount = params.get("HighRiskCount")
        self._MiddleRiskCount = params.get("MiddleRiskCount")
        self._HintRiskCount = params.get("HintRiskCount")
        self._CheckStatus = params.get("CheckStatus")
        self._DefenderStatus = params.get("DefenderStatus")
        self._TaskCreateTime = params.get("TaskCreateTime")
        self._NetworkType = params.get("NetworkType")
        self._ApiServerAddress = params.get("ApiServerAddress")
        self._NodeCount = params.get("NodeCount")
        self._NamespaceCount = params.get("NamespaceCount")
        self._WorkloadCount = params.get("WorkloadCount")
        self._PodCount = params.get("PodCount")
        self._ServiceCount = params.get("ServiceCount")
        self._IngressCount = params.get("IngressCount")
        self._MasterIps = params.get("MasterIps")
        self._RequestId = params.get("RequestId")


class DescribeClusterSummaryRequest(AbstractModel):
    """DescribeClusterSummary request structure.

    """


class DescribeClusterSummaryResponse(AbstractModel):
    """DescribeClusterSummary response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of clusters
        :type TotalCount: int
        :param _RiskClusterCount: Number of clusters at risk
        :type RiskClusterCount: int
        :param _UncheckClusterCount: Number of clusters not checked
        :type UncheckClusterCount: int
        :param _ManagedClusterCount: Number of managed clusters
        :type ManagedClusterCount: int
        :param _IndependentClusterCount: Number of self-deployed clusters
        :type IndependentClusterCount: int
        :param _NoRiskClusterCount: Number of clusters involving no risks
        :type NoRiskClusterCount: int
        :param _CheckedClusterCount: Number of checked clusters
        :type CheckedClusterCount: int
        :param _AutoCheckClusterCount: Number of clusters automatically checked
        :type AutoCheckClusterCount: int
        :param _ManualCheckClusterCount: Number of clusters manually checked
        :type ManualCheckClusterCount: int
        :param _FailedClusterCount: Number of clusters that failed the check
        :type FailedClusterCount: int
        :param _NotImportedClusterCount: Number of clusters not imported
        :type NotImportedClusterCount: int
        :param _ServerlessClusterCount: Number of EKS clusters
        :type ServerlessClusterCount: int
        :param _TkeClusterCount: 
        :type TkeClusterCount: int
        :param _UserCreateTencentClusterCount: 
        :type UserCreateTencentClusterCount: int
        :param _UserCreateHybridClusterCount: 
        :type UserCreateHybridClusterCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RiskClusterCount = None
        self._UncheckClusterCount = None
        self._ManagedClusterCount = None
        self._IndependentClusterCount = None
        self._NoRiskClusterCount = None
        self._CheckedClusterCount = None
        self._AutoCheckClusterCount = None
        self._ManualCheckClusterCount = None
        self._FailedClusterCount = None
        self._NotImportedClusterCount = None
        self._ServerlessClusterCount = None
        self._TkeClusterCount = None
        self._UserCreateTencentClusterCount = None
        self._UserCreateHybridClusterCount = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RiskClusterCount(self):
        return self._RiskClusterCount

    @RiskClusterCount.setter
    def RiskClusterCount(self, RiskClusterCount):
        self._RiskClusterCount = RiskClusterCount

    @property
    def UncheckClusterCount(self):
        return self._UncheckClusterCount

    @UncheckClusterCount.setter
    def UncheckClusterCount(self, UncheckClusterCount):
        self._UncheckClusterCount = UncheckClusterCount

    @property
    def ManagedClusterCount(self):
        return self._ManagedClusterCount

    @ManagedClusterCount.setter
    def ManagedClusterCount(self, ManagedClusterCount):
        self._ManagedClusterCount = ManagedClusterCount

    @property
    def IndependentClusterCount(self):
        return self._IndependentClusterCount

    @IndependentClusterCount.setter
    def IndependentClusterCount(self, IndependentClusterCount):
        self._IndependentClusterCount = IndependentClusterCount

    @property
    def NoRiskClusterCount(self):
        return self._NoRiskClusterCount

    @NoRiskClusterCount.setter
    def NoRiskClusterCount(self, NoRiskClusterCount):
        self._NoRiskClusterCount = NoRiskClusterCount

    @property
    def CheckedClusterCount(self):
        return self._CheckedClusterCount

    @CheckedClusterCount.setter
    def CheckedClusterCount(self, CheckedClusterCount):
        self._CheckedClusterCount = CheckedClusterCount

    @property
    def AutoCheckClusterCount(self):
        return self._AutoCheckClusterCount

    @AutoCheckClusterCount.setter
    def AutoCheckClusterCount(self, AutoCheckClusterCount):
        self._AutoCheckClusterCount = AutoCheckClusterCount

    @property
    def ManualCheckClusterCount(self):
        return self._ManualCheckClusterCount

    @ManualCheckClusterCount.setter
    def ManualCheckClusterCount(self, ManualCheckClusterCount):
        self._ManualCheckClusterCount = ManualCheckClusterCount

    @property
    def FailedClusterCount(self):
        return self._FailedClusterCount

    @FailedClusterCount.setter
    def FailedClusterCount(self, FailedClusterCount):
        self._FailedClusterCount = FailedClusterCount

    @property
    def NotImportedClusterCount(self):
        return self._NotImportedClusterCount

    @NotImportedClusterCount.setter
    def NotImportedClusterCount(self, NotImportedClusterCount):
        self._NotImportedClusterCount = NotImportedClusterCount

    @property
    def ServerlessClusterCount(self):
        return self._ServerlessClusterCount

    @ServerlessClusterCount.setter
    def ServerlessClusterCount(self, ServerlessClusterCount):
        self._ServerlessClusterCount = ServerlessClusterCount

    @property
    def TkeClusterCount(self):
        return self._TkeClusterCount

    @TkeClusterCount.setter
    def TkeClusterCount(self, TkeClusterCount):
        self._TkeClusterCount = TkeClusterCount

    @property
    def UserCreateTencentClusterCount(self):
        return self._UserCreateTencentClusterCount

    @UserCreateTencentClusterCount.setter
    def UserCreateTencentClusterCount(self, UserCreateTencentClusterCount):
        self._UserCreateTencentClusterCount = UserCreateTencentClusterCount

    @property
    def UserCreateHybridClusterCount(self):
        return self._UserCreateHybridClusterCount

    @UserCreateHybridClusterCount.setter
    def UserCreateHybridClusterCount(self, UserCreateHybridClusterCount):
        self._UserCreateHybridClusterCount = UserCreateHybridClusterCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._RiskClusterCount = params.get("RiskClusterCount")
        self._UncheckClusterCount = params.get("UncheckClusterCount")
        self._ManagedClusterCount = params.get("ManagedClusterCount")
        self._IndependentClusterCount = params.get("IndependentClusterCount")
        self._NoRiskClusterCount = params.get("NoRiskClusterCount")
        self._CheckedClusterCount = params.get("CheckedClusterCount")
        self._AutoCheckClusterCount = params.get("AutoCheckClusterCount")
        self._ManualCheckClusterCount = params.get("ManualCheckClusterCount")
        self._FailedClusterCount = params.get("FailedClusterCount")
        self._NotImportedClusterCount = params.get("NotImportedClusterCount")
        self._ServerlessClusterCount = params.get("ServerlessClusterCount")
        self._TkeClusterCount = params.get("TkeClusterCount")
        self._UserCreateTencentClusterCount = params.get("UserCreateTencentClusterCount")
        self._UserCreateHybridClusterCount = params.get("UserCreateHybridClusterCount")
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetDetailInfoRequest(AbstractModel):
    """DescribeComplianceAssetDetailInfo request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        """
        self._CustomerAssetId = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetDetailInfoResponse(AbstractModel):
    """DescribeComplianceAssetDetailInfo response structure.

    """

    def __init__(self):
        r"""
        :param _AssetDetailInfo: Asset details
        :type AssetDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceAssetDetailInfo`
        :param _ContainerDetailInfo: This field is returned when the asset is a container.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ContainerDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceContainerDetailInfo`
        :param _ImageDetailInfo: This field is returned when the asset is an image.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceImageDetailInfo`
        :param _HostDetailInfo: This field is returned when the asset is a server.
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceHostDetailInfo`
        :param _K8SDetailInfo: This field is returned when the asset is a K8s asset.
Note: This field may return null, indicating that no valid values can be obtained.
        :type K8SDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ComplianceK8SDetailInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AssetDetailInfo = None
        self._ContainerDetailInfo = None
        self._ImageDetailInfo = None
        self._HostDetailInfo = None
        self._K8SDetailInfo = None
        self._RequestId = None

    @property
    def AssetDetailInfo(self):
        return self._AssetDetailInfo

    @AssetDetailInfo.setter
    def AssetDetailInfo(self, AssetDetailInfo):
        self._AssetDetailInfo = AssetDetailInfo

    @property
    def ContainerDetailInfo(self):
        return self._ContainerDetailInfo

    @ContainerDetailInfo.setter
    def ContainerDetailInfo(self, ContainerDetailInfo):
        self._ContainerDetailInfo = ContainerDetailInfo

    @property
    def ImageDetailInfo(self):
        return self._ImageDetailInfo

    @ImageDetailInfo.setter
    def ImageDetailInfo(self, ImageDetailInfo):
        self._ImageDetailInfo = ImageDetailInfo

    @property
    def HostDetailInfo(self):
        return self._HostDetailInfo

    @HostDetailInfo.setter
    def HostDetailInfo(self, HostDetailInfo):
        self._HostDetailInfo = HostDetailInfo

    @property
    def K8SDetailInfo(self):
        return self._K8SDetailInfo

    @K8SDetailInfo.setter
    def K8SDetailInfo(self, K8SDetailInfo):
        self._K8SDetailInfo = K8SDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AssetDetailInfo") is not None:
            self._AssetDetailInfo = ComplianceAssetDetailInfo()
            self._AssetDetailInfo._deserialize(params.get("AssetDetailInfo"))
        if params.get("ContainerDetailInfo") is not None:
            self._ContainerDetailInfo = ComplianceContainerDetailInfo()
            self._ContainerDetailInfo._deserialize(params.get("ContainerDetailInfo"))
        if params.get("ImageDetailInfo") is not None:
            self._ImageDetailInfo = ComplianceImageDetailInfo()
            self._ImageDetailInfo._deserialize(params.get("ImageDetailInfo"))
        if params.get("HostDetailInfo") is not None:
            self._HostDetailInfo = ComplianceHostDetailInfo()
            self._HostDetailInfo._deserialize(params.get("HostDetailInfo"))
        if params.get("K8SDetailInfo") is not None:
            self._K8SDetailInfo = ComplianceK8SDetailInfo()
            self._K8SDetailInfo._deserialize(params.get("K8SDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetListRequest(AbstractModel):
    """DescribeComplianceAssetList request structure.

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: List of asset types
        :type AssetTypeSet: list of str
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Query filter
        :type Filters: list of ComplianceFilters
        """
        self._AssetTypeSet = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetListResponse(AbstractModel):
    """DescribeComplianceAssetList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of assets
        :type TotalCount: int
        :param _AssetInfoList: List of assets
Note: This field may return null, indicating that no valid values can be obtained.
        :type AssetInfoList: list of ComplianceAssetInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AssetInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AssetInfoList(self):
        return self._AssetInfoList

    @AssetInfoList.setter
    def AssetInfoList(self, AssetInfoList):
        self._AssetInfoList = AssetInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AssetInfoList") is not None:
            self._AssetInfoList = []
            for item in params.get("AssetInfoList"):
                obj = ComplianceAssetInfo()
                obj._deserialize(item)
                self._AssetInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceAssetPolicyItemListRequest(AbstractModel):
    """DescribeComplianceAssetPolicyItemList request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerAssetId: Customer asset ID
        :type CustomerAssetId: int
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be obtained. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Filter list, which is supported by the `Name` field.
RiskLevel
        :type Filters: list of ComplianceFilters
        """
        self._CustomerAssetId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def CustomerAssetId(self):
        return self._CustomerAssetId

    @CustomerAssetId.setter
    def CustomerAssetId(self, CustomerAssetId):
        self._CustomerAssetId = CustomerAssetId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._CustomerAssetId = params.get("CustomerAssetId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceAssetPolicyItemListResponse(AbstractModel):
    """DescribeComplianceAssetPolicyItemList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of check items, which is `0` if the baseline check is not enabled.
        :type TotalCount: int
        :param _AssetPolicyItemList: List of check items of an asset
        :type AssetPolicyItemList: list of ComplianceAssetPolicyItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AssetPolicyItemList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AssetPolicyItemList(self):
        return self._AssetPolicyItemList

    @AssetPolicyItemList.setter
    def AssetPolicyItemList(self, AssetPolicyItemList):
        self._AssetPolicyItemList = AssetPolicyItemList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AssetPolicyItemList") is not None:
            self._AssetPolicyItemList = []
            for item in params.get("AssetPolicyItemList"):
                obj = ComplianceAssetPolicyItem()
                obj._deserialize(item)
                self._AssetPolicyItemList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCompliancePeriodTaskListRequest(AbstractModel):
    """DescribeCompliancePeriodTaskList request structure.

    """

    def __init__(self):
        r"""
        :param _AssetType: Asset type. Valid values:
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        """
        self._AssetType = None
        self._Offset = None
        self._Limit = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePeriodTaskListResponse(AbstractModel):
    """DescribeCompliancePeriodTaskList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of scheduled tasks
        :type TotalCount: int
        :param _PeriodTaskSet: List of scheduled task information
        :type PeriodTaskSet: list of CompliancePeriodTask
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PeriodTaskSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PeriodTaskSet(self):
        return self._PeriodTaskSet

    @PeriodTaskSet.setter
    def PeriodTaskSet(self, PeriodTaskSet):
        self._PeriodTaskSet = PeriodTaskSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PeriodTaskSet") is not None:
            self._PeriodTaskSet = []
            for item in params.get("PeriodTaskSet"):
                obj = CompliancePeriodTask()
                obj._deserialize(item)
                self._PeriodTaskSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedAssetListRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: `CustomerPolicyItemId` returned by `DescribeComplianceTaskPolicyItemSummaryList`, which indicates the check item ID.
        :type CustomerPolicyItemId: int
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Filter
Name - String
Name. Valid values: `NodeName`, `CheckResult`.
        :type Filters: list of ComplianceFilters
        """
        self._CustomerPolicyItemId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedAssetListResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedAssetList response structure.

    """

    def __init__(self):
        r"""
        :param _AffectedAssetList: List of assets affected by each check item
        :type AffectedAssetList: list of ComplianceAffectedAsset
        :param _TotalCount: Total number of assets affected by the check item
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._AffectedAssetList = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def AffectedAssetList(self):
        return self._AffectedAssetList

    @AffectedAssetList.setter
    def AffectedAssetList(self, AffectedAssetList):
        self._AffectedAssetList = AffectedAssetList

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("AffectedAssetList") is not None:
            self._AffectedAssetList = []
            for item in params.get("AffectedAssetList"):
                obj = ComplianceAffectedAsset()
                obj._deserialize(item)
                self._AffectedAssetList.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCompliancePolicyItemAffectedSummaryRequest(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary request structure.

    """

    def __init__(self):
        r"""
        :param _CustomerPolicyItemId: `CustomerPolicyItemId` returned by `DescribeComplianceTaskPolicyItemSummaryList`, which indicates the check item ID.
        :type CustomerPolicyItemId: int
        """
        self._CustomerPolicyItemId = None

    @property
    def CustomerPolicyItemId(self):
        return self._CustomerPolicyItemId

    @CustomerPolicyItemId.setter
    def CustomerPolicyItemId(self, CustomerPolicyItemId):
        self._CustomerPolicyItemId = CustomerPolicyItemId


    def _deserialize(self, params):
        self._CustomerPolicyItemId = params.get("CustomerPolicyItemId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCompliancePolicyItemAffectedSummaryResponse(AbstractModel):
    """DescribeCompliancePolicyItemAffectedSummary response structure.

    """

    def __init__(self):
        r"""
        :param _PolicyItemSummary: Aggregated information of the assets affected by each check item
        :type PolicyItemSummary: :class:`tencentcloud.tcss.v20201101.models.CompliancePolicyItemSummary`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PolicyItemSummary = None
        self._RequestId = None

    @property
    def PolicyItemSummary(self):
        return self._PolicyItemSummary

    @PolicyItemSummary.setter
    def PolicyItemSummary(self, PolicyItemSummary):
        self._PolicyItemSummary = PolicyItemSummary

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PolicyItemSummary") is not None:
            self._PolicyItemSummary = CompliancePolicyItemSummary()
            self._PolicyItemSummary._deserialize(params.get("PolicyItemSummary"))
        self._RequestId = params.get("RequestId")


class DescribeComplianceScanFailedAssetListRequest(AbstractModel):
    """DescribeComplianceScanFailedAssetList request structure.

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: List of asset types
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetTypeSet: list of str
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Query filter
        :type Filters: list of ComplianceFilters
        """
        self._AssetTypeSet = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceScanFailedAssetListResponse(AbstractModel):
    """DescribeComplianceScanFailedAssetList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of assets that failed the check
        :type TotalCount: int
        :param _ScanFailedAssetList: List of aggregated information of each type of asset that failed the check
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanFailedAssetList: list of ComplianceScanFailedAsset
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ScanFailedAssetList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ScanFailedAssetList(self):
        return self._ScanFailedAssetList

    @ScanFailedAssetList.setter
    def ScanFailedAssetList(self, ScanFailedAssetList):
        self._ScanFailedAssetList = ScanFailedAssetList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ScanFailedAssetList") is not None:
            self._ScanFailedAssetList = []
            for item in params.get("ScanFailedAssetList"):
                obj = ComplianceScanFailedAsset()
                obj._deserialize(item)
                self._ScanFailedAssetList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceTaskAssetSummaryRequest(AbstractModel):
    """DescribeComplianceTaskAssetSummary request structure.

    """

    def __init__(self):
        r"""
        :param _AssetTypeSet: List of asset types
`ASSET_CONTAINER`: Container.
`ASSET_IMAGE`: Image.
`ASSET_HOST`: Server.
`ASSET_K8S`: K8s asset.
        :type AssetTypeSet: list of str
        """
        self._AssetTypeSet = None

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet


    def _deserialize(self, params):
        self._AssetTypeSet = params.get("AssetTypeSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskAssetSummaryResponse(AbstractModel):
    """DescribeComplianceTaskAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param _Status: Status

`USER_UNINIT`: Not initialized.
`USER_INITIALIZING`: Initializing.
`USER_NORMAL`: Normal.
        :type Status: str
        :param _AssetSummaryList: List of aggregated information of each type of asset
        :type AssetSummaryList: list of ComplianceAssetSummary
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Status = None
        self._AssetSummaryList = None
        self._RequestId = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def AssetSummaryList(self):
        return self._AssetSummaryList

    @AssetSummaryList.setter
    def AssetSummaryList(self, AssetSummaryList):
        self._AssetSummaryList = AssetSummaryList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Status = params.get("Status")
        if params.get("AssetSummaryList") is not None:
            self._AssetSummaryList = []
            for item in params.get("AssetSummaryList"):
                obj = ComplianceAssetSummary()
                obj._deserialize(item)
                self._AssetSummaryList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceTaskPolicyItemSummaryListRequest(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList request structure.

    """

    def __init__(self):
        r"""
        :param _AssetType: Asset type, which indicates to only query check items related to the specified asset type.

`ASSET_CONTAINER`: Container.

`ASSET_IMAGE`: Image.

`ASSET_HOST`: Server.

`ASSET_K8S`: K8s asset.
        :type AssetType: str
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Filter
Name - String
Name. Valid values: `ItemType`, `StandardId`, `RiskLevel`.
`ClusterName` is also available for K8s assets.
        :type Filters: list of ComplianceFilters
        """
        self._AssetType = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def AssetType(self):
        return self._AssetType

    @AssetType.setter
    def AssetType(self, AssetType):
        self._AssetType = AssetType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._AssetType = params.get("AssetType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceTaskPolicyItemSummaryListResponse(AbstractModel):
    """DescribeComplianceTaskPolicyItemSummaryList response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the last compliance check task, which is the source of the displayed data.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskId: int
        :param _TotalCount: Total number of check items
        :type TotalCount: int
        :param _PolicyItemSummaryList: List of the aggregated information of each check item
        :type PolicyItemSummaryList: list of CompliancePolicyItemSummary
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._TotalCount = None
        self._PolicyItemSummaryList = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PolicyItemSummaryList(self):
        return self._PolicyItemSummaryList

    @PolicyItemSummaryList.setter
    def PolicyItemSummaryList(self, PolicyItemSummaryList):
        self._PolicyItemSummaryList = PolicyItemSummaryList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._TotalCount = params.get("TotalCount")
        if params.get("PolicyItemSummaryList") is not None:
            self._PolicyItemSummaryList = []
            for item in params.get("PolicyItemSummaryList"):
                obj = CompliancePolicyItemSummary()
                obj._deserialize(item)
                self._PolicyItemSummaryList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeComplianceWhitelistItemListRequest(AbstractModel):
    """DescribeComplianceWhitelistItemList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Initial offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be obtained. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _AssetTypeSet: List of asset types
        :type AssetTypeSet: list of str
        :param _Filters: Query filter
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._AssetTypeSet = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def AssetTypeSet(self):
        return self._AssetTypeSet

    @AssetTypeSet.setter
    def AssetTypeSet(self, AssetTypeSet):
        self._AssetTypeSet = AssetTypeSet

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._AssetTypeSet = params.get("AssetTypeSet")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeComplianceWhitelistItemListResponse(AbstractModel):
    """DescribeComplianceWhitelistItemList response structure.

    """

    def __init__(self):
        r"""
        :param _WhitelistItemSet: Allowlist
        :type WhitelistItemSet: list of ComplianceWhitelistItem
        :param _TotalCount: Total number of allowed items
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WhitelistItemSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def WhitelistItemSet(self):
        return self._WhitelistItemSet

    @WhitelistItemSet.setter
    def WhitelistItemSet(self, WhitelistItemSet):
        self._WhitelistItemSet = WhitelistItemSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhitelistItemSet") is not None:
            self._WhitelistItemSet = []
            for item in params.get("WhitelistItemSet"):
                obj = ComplianceWhitelistItem()
                obj._deserialize(item)
                self._WhitelistItemSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeContainerAssetSummaryRequest(AbstractModel):
    """DescribeContainerAssetSummary request structure.

    """


class DescribeContainerAssetSummaryResponse(AbstractModel):
    """DescribeContainerAssetSummary response structure.

    """

    def __init__(self):
        r"""
        :param _ContainerTotalCnt: Total number of containers
        :type ContainerTotalCnt: int
        :param _ContainerRunningCnt: Number of running containers
        :type ContainerRunningCnt: int
        :param _ContainerPauseCnt: Number of suspended containers
        :type ContainerPauseCnt: int
        :param _ContainerStopped: Number of stopped containers
        :type ContainerStopped: int
        :param _ImageCnt: Number of local images
        :type ImageCnt: int
        :param _HostCnt: Number of server nodes
        :type HostCnt: int
        :param _HostRunningCnt: Number of running nodes on the server
        :type HostRunningCnt: int
        :param _HostOfflineCnt: Number of offline nodes on the server
        :type HostOfflineCnt: int
        :param _ImageRegistryCnt: Number of image repositories
        :type ImageRegistryCnt: int
        :param _ImageTotalCnt: Total number of images
        :type ImageTotalCnt: int
        :param _HostUnInstallCnt: Number of servers not installed with the agent
        :type HostUnInstallCnt: int
        :param _HostSuperNodeCnt: Number of super nodes
        :type HostSuperNodeCnt: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ContainerTotalCnt = None
        self._ContainerRunningCnt = None
        self._ContainerPauseCnt = None
        self._ContainerStopped = None
        self._ImageCnt = None
        self._HostCnt = None
        self._HostRunningCnt = None
        self._HostOfflineCnt = None
        self._ImageRegistryCnt = None
        self._ImageTotalCnt = None
        self._HostUnInstallCnt = None
        self._HostSuperNodeCnt = None
        self._RequestId = None

    @property
    def ContainerTotalCnt(self):
        return self._ContainerTotalCnt

    @ContainerTotalCnt.setter
    def ContainerTotalCnt(self, ContainerTotalCnt):
        self._ContainerTotalCnt = ContainerTotalCnt

    @property
    def ContainerRunningCnt(self):
        return self._ContainerRunningCnt

    @ContainerRunningCnt.setter
    def ContainerRunningCnt(self, ContainerRunningCnt):
        self._ContainerRunningCnt = ContainerRunningCnt

    @property
    def ContainerPauseCnt(self):
        return self._ContainerPauseCnt

    @ContainerPauseCnt.setter
    def ContainerPauseCnt(self, ContainerPauseCnt):
        self._ContainerPauseCnt = ContainerPauseCnt

    @property
    def ContainerStopped(self):
        return self._ContainerStopped

    @ContainerStopped.setter
    def ContainerStopped(self, ContainerStopped):
        self._ContainerStopped = ContainerStopped

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def HostCnt(self):
        return self._HostCnt

    @HostCnt.setter
    def HostCnt(self, HostCnt):
        self._HostCnt = HostCnt

    @property
    def HostRunningCnt(self):
        return self._HostRunningCnt

    @HostRunningCnt.setter
    def HostRunningCnt(self, HostRunningCnt):
        self._HostRunningCnt = HostRunningCnt

    @property
    def HostOfflineCnt(self):
        return self._HostOfflineCnt

    @HostOfflineCnt.setter
    def HostOfflineCnt(self, HostOfflineCnt):
        self._HostOfflineCnt = HostOfflineCnt

    @property
    def ImageRegistryCnt(self):
        return self._ImageRegistryCnt

    @ImageRegistryCnt.setter
    def ImageRegistryCnt(self, ImageRegistryCnt):
        self._ImageRegistryCnt = ImageRegistryCnt

    @property
    def ImageTotalCnt(self):
        return self._ImageTotalCnt

    @ImageTotalCnt.setter
    def ImageTotalCnt(self, ImageTotalCnt):
        self._ImageTotalCnt = ImageTotalCnt

    @property
    def HostUnInstallCnt(self):
        return self._HostUnInstallCnt

    @HostUnInstallCnt.setter
    def HostUnInstallCnt(self, HostUnInstallCnt):
        self._HostUnInstallCnt = HostUnInstallCnt

    @property
    def HostSuperNodeCnt(self):
        return self._HostSuperNodeCnt

    @HostSuperNodeCnt.setter
    def HostSuperNodeCnt(self, HostSuperNodeCnt):
        self._HostSuperNodeCnt = HostSuperNodeCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContainerTotalCnt = params.get("ContainerTotalCnt")
        self._ContainerRunningCnt = params.get("ContainerRunningCnt")
        self._ContainerPauseCnt = params.get("ContainerPauseCnt")
        self._ContainerStopped = params.get("ContainerStopped")
        self._ImageCnt = params.get("ImageCnt")
        self._HostCnt = params.get("HostCnt")
        self._HostRunningCnt = params.get("HostRunningCnt")
        self._HostOfflineCnt = params.get("HostOfflineCnt")
        self._ImageRegistryCnt = params.get("ImageRegistryCnt")
        self._ImageTotalCnt = params.get("ImageTotalCnt")
        self._HostUnInstallCnt = params.get("HostUnInstallCnt")
        self._HostSuperNodeCnt = params.get("HostSuperNodeCnt")
        self._RequestId = params.get("RequestId")


class DescribeContainerSecEventSummaryRequest(AbstractModel):
    """DescribeContainerSecEventSummary request structure.

    """


class DescribeContainerSecEventSummaryResponse(AbstractModel):
    """DescribeContainerSecEventSummary response structure.

    """

    def __init__(self):
        r"""
        :param _UnhandledEscapeCnt: Pending escape event
        :type UnhandledEscapeCnt: int
        :param _UnhandledReverseShellCnt: Pending reverse shell event
        :type UnhandledReverseShellCnt: int
        :param _UnhandledRiskSyscallCnt: Pending high-risk syscall
        :type UnhandledRiskSyscallCnt: int
        :param _UnhandledAbnormalProcessCnt: Pending abnormal process
        :type UnhandledAbnormalProcessCnt: int
        :param _UnhandledFileCnt: Pending file tampering event
        :type UnhandledFileCnt: int
        :param _UnhandledVirusEventCnt: Pending trojan event
        :type UnhandledVirusEventCnt: int
        :param _UnhandledMaliciousConnectionEventCnt: Unhandled malicious outgoing connections
        :type UnhandledMaliciousConnectionEventCnt: int
        :param _UnhandledK8sApiEventCnt: Unhandled K8sApi events
Note: This field may return `null`, indicating that no valid value was found.
        :type UnhandledK8sApiEventCnt: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UnhandledEscapeCnt = None
        self._UnhandledReverseShellCnt = None
        self._UnhandledRiskSyscallCnt = None
        self._UnhandledAbnormalProcessCnt = None
        self._UnhandledFileCnt = None
        self._UnhandledVirusEventCnt = None
        self._UnhandledMaliciousConnectionEventCnt = None
        self._UnhandledK8sApiEventCnt = None
        self._RequestId = None

    @property
    def UnhandledEscapeCnt(self):
        return self._UnhandledEscapeCnt

    @UnhandledEscapeCnt.setter
    def UnhandledEscapeCnt(self, UnhandledEscapeCnt):
        self._UnhandledEscapeCnt = UnhandledEscapeCnt

    @property
    def UnhandledReverseShellCnt(self):
        return self._UnhandledReverseShellCnt

    @UnhandledReverseShellCnt.setter
    def UnhandledReverseShellCnt(self, UnhandledReverseShellCnt):
        self._UnhandledReverseShellCnt = UnhandledReverseShellCnt

    @property
    def UnhandledRiskSyscallCnt(self):
        return self._UnhandledRiskSyscallCnt

    @UnhandledRiskSyscallCnt.setter
    def UnhandledRiskSyscallCnt(self, UnhandledRiskSyscallCnt):
        self._UnhandledRiskSyscallCnt = UnhandledRiskSyscallCnt

    @property
    def UnhandledAbnormalProcessCnt(self):
        return self._UnhandledAbnormalProcessCnt

    @UnhandledAbnormalProcessCnt.setter
    def UnhandledAbnormalProcessCnt(self, UnhandledAbnormalProcessCnt):
        self._UnhandledAbnormalProcessCnt = UnhandledAbnormalProcessCnt

    @property
    def UnhandledFileCnt(self):
        return self._UnhandledFileCnt

    @UnhandledFileCnt.setter
    def UnhandledFileCnt(self, UnhandledFileCnt):
        self._UnhandledFileCnt = UnhandledFileCnt

    @property
    def UnhandledVirusEventCnt(self):
        return self._UnhandledVirusEventCnt

    @UnhandledVirusEventCnt.setter
    def UnhandledVirusEventCnt(self, UnhandledVirusEventCnt):
        self._UnhandledVirusEventCnt = UnhandledVirusEventCnt

    @property
    def UnhandledMaliciousConnectionEventCnt(self):
        return self._UnhandledMaliciousConnectionEventCnt

    @UnhandledMaliciousConnectionEventCnt.setter
    def UnhandledMaliciousConnectionEventCnt(self, UnhandledMaliciousConnectionEventCnt):
        self._UnhandledMaliciousConnectionEventCnt = UnhandledMaliciousConnectionEventCnt

    @property
    def UnhandledK8sApiEventCnt(self):
        return self._UnhandledK8sApiEventCnt

    @UnhandledK8sApiEventCnt.setter
    def UnhandledK8sApiEventCnt(self, UnhandledK8sApiEventCnt):
        self._UnhandledK8sApiEventCnt = UnhandledK8sApiEventCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UnhandledEscapeCnt = params.get("UnhandledEscapeCnt")
        self._UnhandledReverseShellCnt = params.get("UnhandledReverseShellCnt")
        self._UnhandledRiskSyscallCnt = params.get("UnhandledRiskSyscallCnt")
        self._UnhandledAbnormalProcessCnt = params.get("UnhandledAbnormalProcessCnt")
        self._UnhandledFileCnt = params.get("UnhandledFileCnt")
        self._UnhandledVirusEventCnt = params.get("UnhandledVirusEventCnt")
        self._UnhandledMaliciousConnectionEventCnt = params.get("UnhandledMaliciousConnectionEventCnt")
        self._UnhandledK8sApiEventCnt = params.get("UnhandledK8sApiEventCnt")
        self._RequestId = params.get("RequestId")


class DescribeESAggregationsRequest(AbstractModel):
    """DescribeESAggregations request structure.

    """

    def __init__(self):
        r"""
        :param _Query: ES aggregation condition in JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESAggregationsResponse(AbstractModel):
    """DescribeESAggregations response structure.

    """

    def __init__(self):
        r"""
        :param _Data: ES aggregation result in JSON
        :type Data: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeESHitsRequest(AbstractModel):
    """DescribeESHits request structure.

    """

    def __init__(self):
        r"""
        :param _Query: ES query condition in JSON
        :type Query: str
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Maximum value: `100`.
        :type Limit: int
        """
        self._Query = None
        self._Offset = None
        self._Limit = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Query = params.get("Query")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeESHitsResponse(AbstractModel):
    """DescribeESHits response structure.

    """

    def __init__(self):
        r"""
        :param _Data: ES query result in JSON
        :type Data: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeEmergencyVulListRequest(AbstractModel):
    """DescribeEmergencyVulList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEmergencyVulListResponse(AbstractModel):
    """DescribeEmergencyVulList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of vulnerabilities
        :type TotalCount: int
        :param _List: List of vulnerabilities
        :type List: list of EmergencyVulInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EmergencyVulInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventDetailRequest(AbstractModel):
    """DescribeEscapeEventDetail request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Unique event ID
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventDetailResponse(AbstractModel):
    """DescribeEscapeEventDetail response structure.

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.EscapeEventDescription`
        :param _ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._EventDetail = None
        self._ParentProcessInfo = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = EscapeEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventInfoRequest(AbstractModel):
    """DescribeEscapeEventInfo request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter - status. Valid values: `EVENT_UNDEAL` (pending); `EVENT_DEALED` (processed); `EVENT_INGNORE` (ignored).
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventInfoResponse(AbstractModel):
    """DescribeEscapeEventInfo response structure.

    """

    def __init__(self):
        r"""
        :param _EventSet: Array of escape events
        :type EventSet: list of EscapeEventInfo
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = EscapeEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventTendencyRequest(AbstractModel):
    """DescribeEscapeEventTendency request structure.

    """

    def __init__(self):
        r"""
        :param _EndTime: End time
        :type EndTime: str
        :param _StartTime: Start time
        :type StartTime: str
        """
        self._EndTime = None
        self._StartTime = None

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime


    def _deserialize(self, params):
        self._EndTime = params.get("EndTime")
        self._StartTime = params.get("StartTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventTendencyResponse(AbstractModel):
    """DescribeEscapeEventTendency response structure.

    """

    def __init__(self):
        r"""
        :param _List: Trend of pending escape events
        :type List: list of EscapeEventTendencyInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EscapeEventTendencyInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventTypeSummaryRequest(AbstractModel):
    """DescribeEscapeEventTypeSummary request structure.

    """


class DescribeEscapeEventTypeSummaryResponse(AbstractModel):
    """DescribeEscapeEventTypeSummary response structure.

    """

    def __init__(self):
        r"""
        :param _ContainerEscapeEventCount: Number of container escape events
        :type ContainerEscapeEventCount: int
        :param _ProcessPrivilegeEventCount: Number of program privilege escalation events
        :type ProcessPrivilegeEventCount: int
        :param _RiskContainerEventCount: Number of risky container events
        :type RiskContainerEventCount: int
        :param _PendingEscapeEventCount: Number of pending escape events
        :type PendingEscapeEventCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ContainerEscapeEventCount = None
        self._ProcessPrivilegeEventCount = None
        self._RiskContainerEventCount = None
        self._PendingEscapeEventCount = None
        self._RequestId = None

    @property
    def ContainerEscapeEventCount(self):
        return self._ContainerEscapeEventCount

    @ContainerEscapeEventCount.setter
    def ContainerEscapeEventCount(self, ContainerEscapeEventCount):
        self._ContainerEscapeEventCount = ContainerEscapeEventCount

    @property
    def ProcessPrivilegeEventCount(self):
        return self._ProcessPrivilegeEventCount

    @ProcessPrivilegeEventCount.setter
    def ProcessPrivilegeEventCount(self, ProcessPrivilegeEventCount):
        self._ProcessPrivilegeEventCount = ProcessPrivilegeEventCount

    @property
    def RiskContainerEventCount(self):
        return self._RiskContainerEventCount

    @RiskContainerEventCount.setter
    def RiskContainerEventCount(self, RiskContainerEventCount):
        self._RiskContainerEventCount = RiskContainerEventCount

    @property
    def PendingEscapeEventCount(self):
        return self._PendingEscapeEventCount

    @PendingEscapeEventCount.setter
    def PendingEscapeEventCount(self, PendingEscapeEventCount):
        self._PendingEscapeEventCount = PendingEscapeEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ContainerEscapeEventCount = params.get("ContainerEscapeEventCount")
        self._ProcessPrivilegeEventCount = params.get("ProcessPrivilegeEventCount")
        self._RiskContainerEventCount = params.get("RiskContainerEventCount")
        self._PendingEscapeEventCount = params.get("PendingEscapeEventCount")
        self._RequestId = params.get("RequestId")


class DescribeEscapeEventsExportRequest(AbstractModel):
    """DescribeEscapeEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param _ExportField: Export field
        :type ExportField: list of str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._ExportField = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._ExportField = params.get("ExportField")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeEventsExportResponse(AbstractModel):
    """DescribeEscapeEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._RequestId = params.get("RequestId")


class DescribeEscapeRuleInfoRequest(AbstractModel):
    """DescribeEscapeRuleInfo request structure.

    """


class DescribeEscapeRuleInfoResponse(AbstractModel):
    """DescribeEscapeRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _RuleSet: Rule information
        :type RuleSet: list of EscapeRule
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RuleSet = None
        self._RequestId = None

    @property
    def RuleSet(self):
        return self._RuleSet

    @RuleSet.setter
    def RuleSet(self, RuleSet):
        self._RuleSet = RuleSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("RuleSet") is not None:
            self._RuleSet = []
            for item in params.get("RuleSet"):
                obj = EscapeRule()
                obj._deserialize(item)
                self._RuleSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeEscapeSafeStateRequest(AbstractModel):
    """DescribeEscapeSafeState request structure.

    """


class DescribeEscapeSafeStateResponse(AbstractModel):
    """DescribeEscapeSafeState response structure.

    """

    def __init__(self):
        r"""
        :param _IsSafe: Valid values: `Unsafe` (at risk); `Safe` (no risks); `UnKnown` (unknown risks).
        :type IsSafe: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsSafe = None
        self._RequestId = None

    @property
    def IsSafe(self):
        return self._IsSafe

    @IsSafe.setter
    def IsSafe(self, IsSafe):
        self._IsSafe = IsSafe

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsSafe = params.get("IsSafe")
        self._RequestId = params.get("RequestId")


class DescribeEscapeWhiteListRequest(AbstractModel):
    """DescribeEscapeWhiteList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>EventType- String - Required: No - Allowed event type. Valid values: `ESCAPE_CGROUPS` (cgroup escape); `ESCAPE_TAMPER_SENSITIVE_FILE` (file tamper escape); `ESCAPE_DOCKER_API` (Docker API access escape); `ESCAPE_VUL_OCCURRED` (vulnerability exploit); `MOUNT_SENSITIVE_PTAH` (sensitive path mount); `PRIVILEGE_CONTAINER_START` (privileged container); `PRIVILEGE` (program privilege escalation escape).</li>
<li>ImageName- string - Required: No - Image name</li>
<li>ImageID- string - Required: No - Image ID</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field. Valid values: `HostCount` (number of servers); `ContainerCount` (number of containers); `UpdateTime` (update time).
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEscapeWhiteListResponse(AbstractModel):
    """DescribeEscapeWhiteList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: Allowlist of escapes
        :type List: list of EscapeWhiteListInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = EscapeWhiteListInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportJobDownloadURLRequest(AbstractModel):
    """DescribeExportJobDownloadURL request structure.

    """

    def __init__(self):
        r"""
        :param _JobID: Job ID
        :type JobID: str
        """
        self._JobID = None

    @property
    def JobID(self):
        return self._JobID

    @JobID.setter
    def JobID(self, JobID):
        self._JobID = JobID


    def _deserialize(self, params):
        self._JobID = params.get("JobID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobDownloadURLResponse(AbstractModel):
    """DescribeExportJobDownloadURL response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadURL: Download URL
        :type DownloadURL: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadURL = None
        self._RequestId = None

    @property
    def DownloadURL(self):
        return self._DownloadURL

    @DownloadURL.setter
    def DownloadURL(self, DownloadURL):
        self._DownloadURL = DownloadURL

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadURL = params.get("DownloadURL")
        self._RequestId = params.get("RequestId")


class DescribeExportJobManageListRequest(AbstractModel):
    """DescribeExportJobManageList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>ExportStatus- String - Optional - Export status. Value: `RUNNING` (Exporting); `SUCCESS` (Exported); `FAILURE` (Failed to export)
<li>ExportSource- String - Optional - Source of the exportation task. Values: `LocalImage` (Local image).
</li>
        :type Filters: list of RunTimeFilters
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field
InsertTime: Creation time
        :type By: str
        """
        self._Filters = None
        self._Offset = None
        self._Limit = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobManageListResponse(AbstractModel):
    """DescribeExportJobManageList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total count
        :type TotalCount: int
        :param _List: Job list
        :type List: list of ExportJobInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ExportJobInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeExportJobResultRequest(AbstractModel):
    """DescribeExportJobResult request structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Value of the `JobId` field returned by `CreateExportComplianceStatusListJob`
        :type JobId: str
        """
        self._JobId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeExportJobResultResponse(AbstractModel):
    """DescribeExportJobResult response structure.

    """

    def __init__(self):
        r"""
        :param _ExportStatus: Export status. Valid values: `SUCCESS`, `FAILURE`, `RUNNING`.
        :type ExportStatus: str
        :param _DownloadURL: Download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadURL: str
        :param _ExportProgress: Export progress when `ExportStatus` is `RUNNING`. Value range: Floating points between `0` and `100`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExportProgress: float
        :param _FailureMsg: Failure cause
Note: This field may return null, indicating that no valid values can be obtained.
        :type FailureMsg: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ExportStatus = None
        self._DownloadURL = None
        self._ExportProgress = None
        self._FailureMsg = None
        self._RequestId = None

    @property
    def ExportStatus(self):
        return self._ExportStatus

    @ExportStatus.setter
    def ExportStatus(self, ExportStatus):
        self._ExportStatus = ExportStatus

    @property
    def DownloadURL(self):
        return self._DownloadURL

    @DownloadURL.setter
    def DownloadURL(self, DownloadURL):
        self._DownloadURL = DownloadURL

    @property
    def ExportProgress(self):
        return self._ExportProgress

    @ExportProgress.setter
    def ExportProgress(self, ExportProgress):
        self._ExportProgress = ExportProgress

    @property
    def FailureMsg(self):
        return self._FailureMsg

    @FailureMsg.setter
    def FailureMsg(self, FailureMsg):
        self._FailureMsg = FailureMsg

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ExportStatus = params.get("ExportStatus")
        self._DownloadURL = params.get("DownloadURL")
        self._ExportProgress = params.get("ExportProgress")
        self._FailureMsg = params.get("FailureMsg")
        self._RequestId = params.get("RequestId")


class DescribeImageAuthorizedInfoRequest(AbstractModel):
    """DescribeImageAuthorizedInfo request structure.

    """


class DescribeImageAuthorizedInfoResponse(AbstractModel):
    """DescribeImageAuthorizedInfo response structure.

    """

    def __init__(self):
        r"""
        :param _TotalAuthorizedCnt: Total number of valid image licenses
        :type TotalAuthorizedCnt: int
        :param _UsedAuthorizedCnt: Number of used image licenses
        :type UsedAuthorizedCnt: int
        :param _ScannedImageCnt: Number of images with scan enabled
        :type ScannedImageCnt: int
        :param _NotScannedImageCnt: Number of images with scan not enabled
        :type NotScannedImageCnt: int
        :param _NotScannedLocalImageCnt: Number of local images with scan not enabled
        :type NotScannedLocalImageCnt: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalAuthorizedCnt = None
        self._UsedAuthorizedCnt = None
        self._ScannedImageCnt = None
        self._NotScannedImageCnt = None
        self._NotScannedLocalImageCnt = None
        self._RequestId = None

    @property
    def TotalAuthorizedCnt(self):
        return self._TotalAuthorizedCnt

    @TotalAuthorizedCnt.setter
    def TotalAuthorizedCnt(self, TotalAuthorizedCnt):
        self._TotalAuthorizedCnt = TotalAuthorizedCnt

    @property
    def UsedAuthorizedCnt(self):
        return self._UsedAuthorizedCnt

    @UsedAuthorizedCnt.setter
    def UsedAuthorizedCnt(self, UsedAuthorizedCnt):
        self._UsedAuthorizedCnt = UsedAuthorizedCnt

    @property
    def ScannedImageCnt(self):
        return self._ScannedImageCnt

    @ScannedImageCnt.setter
    def ScannedImageCnt(self, ScannedImageCnt):
        self._ScannedImageCnt = ScannedImageCnt

    @property
    def NotScannedImageCnt(self):
        return self._NotScannedImageCnt

    @NotScannedImageCnt.setter
    def NotScannedImageCnt(self, NotScannedImageCnt):
        self._NotScannedImageCnt = NotScannedImageCnt

    @property
    def NotScannedLocalImageCnt(self):
        return self._NotScannedLocalImageCnt

    @NotScannedLocalImageCnt.setter
    def NotScannedLocalImageCnt(self, NotScannedLocalImageCnt):
        self._NotScannedLocalImageCnt = NotScannedLocalImageCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalAuthorizedCnt = params.get("TotalAuthorizedCnt")
        self._UsedAuthorizedCnt = params.get("UsedAuthorizedCnt")
        self._ScannedImageCnt = params.get("ScannedImageCnt")
        self._NotScannedImageCnt = params.get("NotScannedImageCnt")
        self._NotScannedLocalImageCnt = params.get("NotScannedLocalImageCnt")
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedLogListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedLogList request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: ID of the automatic licensing task
        :type TaskId: int
        :param _Filters: `Status` (licensing result). Valid values: `SUCCESS` (success); `REACH_LIMIT` (reaching the upper limit on licenses); `LICENSE_INSUFFICIENT` (insufficient licenses).
        :type Filters: list of AssetFilters
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _By: Sorting field: `AuthorizedTime`.
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._TaskId = None
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._By = None
        self._Order = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedLogListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedLogList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: List of automatically licensed images
        :type List: list of AutoAuthorizedImageInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = AutoAuthorizedImageInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedRuleRequest(AbstractModel):
    """DescribeImageAutoAuthorizedRule request structure.

    """


class DescribeImageAutoAuthorizedRuleResponse(AbstractModel):
    """DescribeImageAutoAuthorizedRule response structure.

    """

    def __init__(self):
        r"""
        :param _IsEnabled: Whether the rule takes effect. Valid values: `0` (no); `1` (yes).
        :type IsEnabled: int
        :param _RangeType: Scope. Valid values: `MANUAL` (specified servers); `ALL` (all images).
Note: This field may return null, indicating that no valid values can be obtained.
        :type RangeType: str
        :param _HostCount: Number of servers when the scope is `MANUAL`
Note: This field may return null, indicating that no valid values can be obtained.
        :type HostCount: int
        :param _MaxDailyCount: Maximum number of image licenses per day. `0`: Unlimited.
Note: This field may return null, indicating that no valid values can be obtained.
        :type MaxDailyCount: int
        :param _RuleId: Rule ID, which is `0` if not specified.
Note: This field may return null, indicating that no valid values can be obtained.
        :type RuleId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._IsEnabled = None
        self._RangeType = None
        self._HostCount = None
        self._MaxDailyCount = None
        self._RuleId = None
        self._RequestId = None

    @property
    def IsEnabled(self):
        return self._IsEnabled

    @IsEnabled.setter
    def IsEnabled(self, IsEnabled):
        self._IsEnabled = IsEnabled

    @property
    def RangeType(self):
        return self._RangeType

    @RangeType.setter
    def RangeType(self, RangeType):
        self._RangeType = RangeType

    @property
    def HostCount(self):
        return self._HostCount

    @HostCount.setter
    def HostCount(self, HostCount):
        self._HostCount = HostCount

    @property
    def MaxDailyCount(self):
        return self._MaxDailyCount

    @MaxDailyCount.setter
    def MaxDailyCount(self, MaxDailyCount):
        self._MaxDailyCount = MaxDailyCount

    @property
    def RuleId(self):
        return self._RuleId

    @RuleId.setter
    def RuleId(self, RuleId):
        self._RuleId = RuleId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._IsEnabled = params.get("IsEnabled")
        self._RangeType = params.get("RangeType")
        self._HostCount = params.get("HostCount")
        self._MaxDailyCount = params.get("MaxDailyCount")
        self._RuleId = params.get("RuleId")
        self._RequestId = params.get("RequestId")


class DescribeImageAutoAuthorizedTaskListRequest(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _Filters: Filter field
`Status` (licensing result). Valid values: `ALLSUCCSESS` (licensing succeeded); `PARTIALFAIL` (failed to license some images); `ALLFAIL` (failed to license all images).
Licensing method. Valid values: `AUTO` (automatic licensing); `MANUAL` (manual licensing).
Image source. Valid values: `LOCAL` (local image); `REGISTRY` (repository image).
        :type Filters: list of AssetFilters
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self._StartTime = None
        self._EndTime = None
        self._Filters = None
        self._Limit = None
        self._Offset = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageAutoAuthorizedTaskListResponse(AbstractModel):
    """DescribeImageAutoAuthorizedTaskList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of automatic licensing tasks
        :type List: list of ImageAutoAuthorizedTask
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageAutoAuthorizedTask()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeImageComponentListRequest(AbstractModel):
    """DescribeImageComponentList request structure.

    """

    def __init__(self):
        r"""
        :param _ImageID: Image ID
        :type ImageID: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>ComponentName- String - Required: No - Image component name</li><li>ComponentVersion- String - Required: No - Image component version</li><li>ComponentType- String - Required: No - Image component type</li><li>VulLevel- String - Required: No - Vulnerability severity</li><li>HasVul- String - Required: No - Whether there is a vulnerability. Valid values: `true` (yes); `false` (no). If `ComponentName` is not passed in or is `ALL`, it indicates all.</li>
        :type Filters: list of AssetFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `desc`, `asc`.
        :type Order: str
        """
        self._ImageID = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ImageID(self):
        return self._ImageID

    @ImageID.setter
    def ImageID(self, ImageID):
        self._ImageID = ImageID

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ImageID = params.get("ImageID")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageComponentListResponse(AbstractModel):
    """DescribeImageComponentList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: List of image components
        :type List: list of ImageComponent
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ImageComponent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageRegistryNamespaceListRequest(AbstractModel):
    """DescribeImageRegistryNamespaceList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Initial offset of the query. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned by the query. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Filters: Query filter. The `Name` field can be "Namespace".
        :type Filters: list of AssetFilters
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = AssetFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRegistryNamespaceListResponse(AbstractModel):
    """DescribeImageRegistryNamespaceList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of namespaces that can be returned
        :type TotalCount: int
        :param _NamespaceList: List of namespaces
        :type NamespaceList: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._NamespaceList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NamespaceList(self):
        return self._NamespaceList

    @NamespaceList.setter
    def NamespaceList(self, NamespaceList):
        self._NamespaceList = NamespaceList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._NamespaceList = params.get("NamespaceList")
        self._RequestId = params.get("RequestId")


class DescribeImageRegistryTimingScanTaskRequest(AbstractModel):
    """DescribeImageRegistryTimingScanTask request structure.

    """


class DescribeImageRegistryTimingScanTaskResponse(AbstractModel):
    """DescribeImageRegistryTimingScanTask response structure.

    """

    def __init__(self):
        r"""
        :param _Enable: Scheduled scan switch
Note: This field may return null, indicating that no valid values can be obtained.
        :type Enable: bool
        :param _ScanTime: Scheduled scan time
        :type ScanTime: str
        :param _ScanPeriod: Scheduled scan interval
        :type ScanPeriod: int
        :param _ScanType: Array of scan types
Note: This field may return null, indicating that no valid values can be obtained.
        :type ScanType: list of str
        :param _All: Scan of all images
        :type All: bool
        :param _Images: Scan of specified images
Note: This field may return null, indicating that no valid values can be obtained.
        :type Images: list of ImageInfo
        :param _Id: ID of the specified image
Note: This field may return null, indicating that no valid values can be obtained.
        :type Id: list of int non-negative
        :param _Latest: Whether to scan the latest image tag
Note: This field may return·`null`, indicating that no valid values can be obtained.
        :type Latest: bool
        :param _ScanEndTime: 
        :type ScanEndTime: str
        :param _RegistryType: 
        :type RegistryType: list of str
        :param _ContainerRunning: 
        :type ContainerRunning: bool
        :param _ScanScope: 
        :type ScanScope: int
        :param _Namespace: 
        :type Namespace: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Enable = None
        self._ScanTime = None
        self._ScanPeriod = None
        self._ScanType = None
        self._All = None
        self._Images = None
        self._Id = None
        self._Latest = None
        self._ScanEndTime = None
        self._RegistryType = None
        self._ContainerRunning = None
        self._ScanScope = None
        self._Namespace = None
        self._RequestId = None

    @property
    def Enable(self):
        return self._Enable

    @Enable.setter
    def Enable(self, Enable):
        self._Enable = Enable

    @property
    def ScanTime(self):
        return self._ScanTime

    @ScanTime.setter
    def ScanTime(self, ScanTime):
        self._ScanTime = ScanTime

    @property
    def ScanPeriod(self):
        return self._ScanPeriod

    @ScanPeriod.setter
    def ScanPeriod(self, ScanPeriod):
        self._ScanPeriod = ScanPeriod

    @property
    def ScanType(self):
        return self._ScanType

    @ScanType.setter
    def ScanType(self, ScanType):
        self._ScanType = ScanType

    @property
    def All(self):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        return self._All

    @All.setter
    def All(self, All):
        warnings.warn("parameter `All` is deprecated", DeprecationWarning) 

        self._All = All

    @property
    def Images(self):
        return self._Images

    @Images.setter
    def Images(self, Images):
        self._Images = Images

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Latest(self):
        return self._Latest

    @Latest.setter
    def Latest(self, Latest):
        self._Latest = Latest

    @property
    def ScanEndTime(self):
        return self._ScanEndTime

    @ScanEndTime.setter
    def ScanEndTime(self, ScanEndTime):
        self._ScanEndTime = ScanEndTime

    @property
    def RegistryType(self):
        return self._RegistryType

    @RegistryType.setter
    def RegistryType(self, RegistryType):
        self._RegistryType = RegistryType

    @property
    def ContainerRunning(self):
        return self._ContainerRunning

    @ContainerRunning.setter
    def ContainerRunning(self, ContainerRunning):
        self._ContainerRunning = ContainerRunning

    @property
    def ScanScope(self):
        return self._ScanScope

    @ScanScope.setter
    def ScanScope(self, ScanScope):
        self._ScanScope = ScanScope

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Enable = params.get("Enable")
        self._ScanTime = params.get("ScanTime")
        self._ScanPeriod = params.get("ScanPeriod")
        self._ScanType = params.get("ScanType")
        self._All = params.get("All")
        if params.get("Images") is not None:
            self._Images = []
            for item in params.get("Images"):
                obj = ImageInfo()
                obj._deserialize(item)
                self._Images.append(obj)
        self._Id = params.get("Id")
        self._Latest = params.get("Latest")
        self._ScanEndTime = params.get("ScanEndTime")
        self._RegistryType = params.get("RegistryType")
        self._ContainerRunning = params.get("ContainerRunning")
        self._ScanScope = params.get("ScanScope")
        self._Namespace = params.get("Namespace")
        self._RequestId = params.get("RequestId")


class DescribeImageRiskSummaryRequest(AbstractModel):
    """DescribeImageRiskSummary request structure.

    """


class DescribeImageRiskSummaryResponse(AbstractModel):
    """DescribeImageRiskSummary response structure.

    """

    def __init__(self):
        r"""
        :param _VulnerabilityCnt: Vulnerability
        :type VulnerabilityCnt: list of RunTimeRiskInfo
        :param _MalwareVirusCnt: Virus and trojan
        :type MalwareVirusCnt: list of RunTimeRiskInfo
        :param _RiskCnt: Sensitive data
        :type RiskCnt: list of RunTimeRiskInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._VulnerabilityCnt = None
        self._MalwareVirusCnt = None
        self._RiskCnt = None
        self._RequestId = None

    @property
    def VulnerabilityCnt(self):
        return self._VulnerabilityCnt

    @VulnerabilityCnt.setter
    def VulnerabilityCnt(self, VulnerabilityCnt):
        self._VulnerabilityCnt = VulnerabilityCnt

    @property
    def MalwareVirusCnt(self):
        return self._MalwareVirusCnt

    @MalwareVirusCnt.setter
    def MalwareVirusCnt(self, MalwareVirusCnt):
        self._MalwareVirusCnt = MalwareVirusCnt

    @property
    def RiskCnt(self):
        return self._RiskCnt

    @RiskCnt.setter
    def RiskCnt(self, RiskCnt):
        self._RiskCnt = RiskCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("VulnerabilityCnt") is not None:
            self._VulnerabilityCnt = []
            for item in params.get("VulnerabilityCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._VulnerabilityCnt.append(obj)
        if params.get("MalwareVirusCnt") is not None:
            self._MalwareVirusCnt = []
            for item in params.get("MalwareVirusCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._MalwareVirusCnt.append(obj)
        if params.get("RiskCnt") is not None:
            self._RiskCnt = []
            for item in params.get("RiskCnt"):
                obj = RunTimeRiskInfo()
                obj._deserialize(item)
                self._RiskCnt.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageRiskTendencyRequest(AbstractModel):
    """DescribeImageRiskTendency request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageRiskTendencyResponse(AbstractModel):
    """DescribeImageRiskTendency response structure.

    """

    def __init__(self):
        r"""
        :param _ImageRiskTendencySet: List of new risk trends of local images
        :type ImageRiskTendencySet: list of ImageRiskTendencyInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageRiskTendencySet = None
        self._RequestId = None

    @property
    def ImageRiskTendencySet(self):
        return self._ImageRiskTendencySet

    @ImageRiskTendencySet.setter
    def ImageRiskTendencySet(self, ImageRiskTendencySet):
        self._ImageRiskTendencySet = ImageRiskTendencySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageRiskTendencySet") is not None:
            self._ImageRiskTendencySet = []
            for item in params.get("ImageRiskTendencySet"):
                obj = ImageRiskTendencyInfo()
                obj._deserialize(item)
                self._ImageRiskTendencySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSimpleListRequest(AbstractModel):
    """DescribeImageSimpleList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: `IsAuthorized` (whether it is licensed). Valid values: `0` (no); `1` (yes); none (all).
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSimpleListResponse(AbstractModel):
    """DescribeImageSimpleList response structure.

    """

    def __init__(self):
        r"""
        :param _ImageList: List of images
        :type ImageList: list of ImageSimpleInfo
        :param _ImageCnt: Number of images
        :type ImageCnt: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageList = None
        self._ImageCnt = None
        self._RequestId = None

    @property
    def ImageList(self):
        return self._ImageList

    @ImageList.setter
    def ImageList(self, ImageList):
        self._ImageList = ImageList

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageList") is not None:
            self._ImageList = []
            for item in params.get("ImageList"):
                obj = ImageSimpleInfo()
                obj._deserialize(item)
                self._ImageList.append(obj)
        self._ImageCnt = params.get("ImageCnt")
        self._RequestId = params.get("RequestId")


class DescribeIndexListRequest(AbstractModel):
    """DescribeIndexList request structure.

    """


class DescribeIndexListResponse(AbstractModel):
    """DescribeIndexList response structure.

    """

    def __init__(self):
        r"""
        :param _Data: ES index information
        :type Data: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeInspectionReportRequest(AbstractModel):
    """DescribeInspectionReport request structure.

    """


class DescribeInspectionReportResponse(AbstractModel):
    """DescribeInspectionReport response structure.

    """

    def __init__(self):
        r"""
        :param _ReportName: Report name
        :type ReportName: str
        :param _ReportUrl: Download URL
        :type ReportUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReportName = None
        self._ReportUrl = None
        self._RequestId = None

    @property
    def ReportName(self):
        return self._ReportName

    @ReportName.setter
    def ReportName(self, ReportName):
        self._ReportName = ReportName

    @property
    def ReportUrl(self):
        return self._ReportUrl

    @ReportUrl.setter
    def ReportUrl(self, ReportUrl):
        self._ReportUrl = ReportUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReportName = params.get("ReportName")
        self._ReportUrl = params.get("ReportUrl")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo request structure.

    """

    def __init__(self):
        r"""
        :param _ID: Event ID
        :type ID: int
        """
        self._ID = None

    @property
    def ID(self):
        return self._ID

    @ID.setter
    def ID(self, ID):
        self._ID = ID


    def _deserialize(self, params):
        self._ID = params.get("ID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Info: Event details
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalEventInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = K8sApiAbnormalEventInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalEventListRequest(AbstractModel):
    """DescribeK8sApiAbnormalEventList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>TimeRange - String - Optional - Time range. Example: ["2022-03-31 16:55:00", "2022-03-31 17:00:00"]</li>
<li>`MatchRules` - String - Optional - Hit rule</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
<li>`Status` - String - Optional - Event status</li>
<li>`MatchRuleType` - String - Optional - Hit rule type</li>
<li>`ClusterRunningStatus` - String - Optional - Cluster running status</li>
<li>`ClusterName` - String - Optional - Cluster name</li>
<li>`ClusterID` - String - Optional - Cluster ID</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field
`LatestFoundTime`: Last creation time
`AlarmCount`: Number of alarms
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalEventListResponse(AbstractModel):
    """DescribeK8sApiAbnormalEventList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Event list
        :type List: list of K8sApiAbnormalEventListItem
        :param _TotalCount: Total count
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalEventListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleInfoRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo request structure.

    """

    def __init__(self):
        r"""
        :param _RuleID: Rule ID
        :type RuleID: str
        """
        self._RuleID = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleInfoResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleInfo response structure.

    """

    def __init__(self):
        r"""
        :param _Info: Rule details
        :type Info: :class:`tencentcloud.tcss.v20201101.models.K8sApiAbnormalRuleInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Info = None
        self._RequestId = None

    @property
    def Info(self):
        return self._Info

    @Info.setter
    def Info(self, Info):
        self._Info = Info

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Info") is not None:
            self._Info = K8sApiAbnormalRuleInfo()
            self._Info._deserialize(params.get("Info"))
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleList request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filters.
<li>`RuleType` - String - Optional - Rule type</li>
<li>`Status` - String - Optional - Status</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Offset: Offset. Default value: 0
        :type Offset: int
        :param _Order: Sort order
        :type Order: str
        :param _By: Sorting field.
<li>`UpdateTime` - String - Optional - Last updated</li>
<li>`EffectClusterCount` - String - Optional - Number of clusters affected</li>
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleList response structure.

    """

    def __init__(self):
        r"""
        :param _List: Rule list
        :type List: list of K8sApiAbnormalRuleListItem
        :param _TotalCount: Total count
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleListItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalRuleScopeListRequest(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList request structure.

    """

    def __init__(self):
        r"""
        :param _RuleID: Rule ID
        :type RuleID: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: The number of results returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Filters: Filters.
<li>`Action` - String - Optional - Filter by action</li>
<li>`RiskLevel` - String - Optional - Threat level</li>
        :type Filters: list of RunTimeFilters
        """
        self._RuleID = None
        self._Offset = None
        self._Limit = None
        self._Filters = None

    @property
    def RuleID(self):
        return self._RuleID

    @RuleID.setter
    def RuleID(self, RuleID):
        self._RuleID = RuleID

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._RuleID = params.get("RuleID")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalRuleScopeListResponse(AbstractModel):
    """DescribeK8sApiAbnormalRuleScopeList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total count
        :type TotalCount: int
        :param _List: List
        :type List: list of K8sApiAbnormalRuleScopeInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalRuleScopeInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalSummaryRequest(AbstractModel):
    """DescribeK8sApiAbnormalSummary request structure.

    """


class DescribeK8sApiAbnormalSummaryResponse(AbstractModel):
    """DescribeK8sApiAbnormalSummary response structure.

    """

    def __init__(self):
        r"""
        :param _UnhandleEventCount: The number of pending events
        :type UnhandleEventCount: int
        :param _UnhandleHighLevelEventCount: The number of pending high-risk events
        :type UnhandleHighLevelEventCount: int
        :param _UnhandleMediumLevelEventCount: The number of pending medium-risk events
        :type UnhandleMediumLevelEventCount: int
        :param _UnhandleLowLevelEventCount: The number of pending low-risk events
        :type UnhandleLowLevelEventCount: int
        :param _UnhandleNoticeLevelEventCount: The number of pending notice-level events
        :type UnhandleNoticeLevelEventCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._UnhandleEventCount = None
        self._UnhandleHighLevelEventCount = None
        self._UnhandleMediumLevelEventCount = None
        self._UnhandleLowLevelEventCount = None
        self._UnhandleNoticeLevelEventCount = None
        self._RequestId = None

    @property
    def UnhandleEventCount(self):
        return self._UnhandleEventCount

    @UnhandleEventCount.setter
    def UnhandleEventCount(self, UnhandleEventCount):
        self._UnhandleEventCount = UnhandleEventCount

    @property
    def UnhandleHighLevelEventCount(self):
        return self._UnhandleHighLevelEventCount

    @UnhandleHighLevelEventCount.setter
    def UnhandleHighLevelEventCount(self, UnhandleHighLevelEventCount):
        self._UnhandleHighLevelEventCount = UnhandleHighLevelEventCount

    @property
    def UnhandleMediumLevelEventCount(self):
        return self._UnhandleMediumLevelEventCount

    @UnhandleMediumLevelEventCount.setter
    def UnhandleMediumLevelEventCount(self, UnhandleMediumLevelEventCount):
        self._UnhandleMediumLevelEventCount = UnhandleMediumLevelEventCount

    @property
    def UnhandleLowLevelEventCount(self):
        return self._UnhandleLowLevelEventCount

    @UnhandleLowLevelEventCount.setter
    def UnhandleLowLevelEventCount(self, UnhandleLowLevelEventCount):
        self._UnhandleLowLevelEventCount = UnhandleLowLevelEventCount

    @property
    def UnhandleNoticeLevelEventCount(self):
        return self._UnhandleNoticeLevelEventCount

    @UnhandleNoticeLevelEventCount.setter
    def UnhandleNoticeLevelEventCount(self, UnhandleNoticeLevelEventCount):
        self._UnhandleNoticeLevelEventCount = UnhandleNoticeLevelEventCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._UnhandleEventCount = params.get("UnhandleEventCount")
        self._UnhandleHighLevelEventCount = params.get("UnhandleHighLevelEventCount")
        self._UnhandleMediumLevelEventCount = params.get("UnhandleMediumLevelEventCount")
        self._UnhandleLowLevelEventCount = params.get("UnhandleLowLevelEventCount")
        self._UnhandleNoticeLevelEventCount = params.get("UnhandleNoticeLevelEventCount")
        self._RequestId = params.get("RequestId")


class DescribeK8sApiAbnormalTendencyRequest(AbstractModel):
    """DescribeK8sApiAbnormalTendency request structure.

    """

    def __init__(self):
        r"""
        :param _TendencyPeriod: Trend period (default value: 7 days)
        :type TendencyPeriod: int
        """
        self._TendencyPeriod = None

    @property
    def TendencyPeriod(self):
        return self._TendencyPeriod

    @TendencyPeriod.setter
    def TendencyPeriod(self, TendencyPeriod):
        self._TendencyPeriod = TendencyPeriod


    def _deserialize(self, params):
        self._TendencyPeriod = params.get("TendencyPeriod")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeK8sApiAbnormalTendencyResponse(AbstractModel):
    """DescribeK8sApiAbnormalTendency response structure.

    """

    def __init__(self):
        r"""
        :param _List: Trend list
        :type List: list of K8sApiAbnormalTendencyItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = K8sApiAbnormalTendencyItem()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLogStorageStatisticRequest(AbstractModel):
    """DescribeLogStorageStatistic request structure.

    """


class DescribeLogStorageStatisticResponse(AbstractModel):
    """DescribeLogStorageStatistic response structure.

    """

    def __init__(self):
        r"""
        :param _TotalSize: Total capacity in GB
        :type TotalSize: int
        :param _UsedSize: Used capacity in GB
        :type UsedSize: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalSize = None
        self._UsedSize = None
        self._RequestId = None

    @property
    def TotalSize(self):
        return self._TotalSize

    @TotalSize.setter
    def TotalSize(self, TotalSize):
        self._TotalSize = TotalSize

    @property
    def UsedSize(self):
        return self._UsedSize

    @UsedSize.setter
    def UsedSize(self, UsedSize):
        self._UsedSize = UsedSize

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalSize = params.get("TotalSize")
        self._UsedSize = params.get("UsedSize")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallAuditRecordRequest(AbstractModel):
    """DescribeNetworkFirewallAuditRecord request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - Action
Name. Valid values: `publish`, `unpublish`, `confirm`, `add`, `update`, `delete`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallAuditRecordResponse(AbstractModel):
    """DescribeNetworkFirewallAuditRecord response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of cluster audits
        :type TotalCount: int
        :param _AuditList: Audit details of the cluster
        :type AuditList: list of NetworkAuditRecord
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AuditList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AuditList(self):
        return self._AuditList

    @AuditList.setter
    def AuditList(self, AuditList):
        self._AuditList = AuditList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AuditList") is not None:
            self._AuditList = []
            for item in params.get("AuditList"):
                obj = NetworkAuditRecord()
                obj._deserialize(item)
                self._AuditList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterListRequest(AbstractModel):
    """DescribeNetworkFirewallClusterList request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterListResponse(AbstractModel):
    """DescribeNetworkFirewallClusterList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of clusters
        :type TotalCount: int
        :param _ClusterInfoList: Cluster details
        :type ClusterInfoList: list of NetworkClusterInfoItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterInfoList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterInfoList(self):
        return self._ClusterInfoList

    @ClusterInfoList.setter
    def ClusterInfoList(self, ClusterInfoList):
        self._ClusterInfoList = ClusterInfoList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterInfoList") is not None:
            self._ClusterInfoList = []
            for item in params.get("ClusterInfoList"):
                obj = NetworkClusterInfoItem()
                obj._deserialize(item)
                self._ClusterInfoList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallClusterRefreshStatusRequest(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallClusterRefreshStatusResponse(AbstractModel):
    """DescribeNetworkFirewallClusterRefreshStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallNamespaceLabelListRequest(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallNamespaceLabelListResponse(AbstractModel):
    """DescribeNetworkFirewallNamespaceLabelList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of clusters
        :type TotalCount: int
        :param _ClusterNamespaceLabelList: Cluster namespace label details
        :type ClusterNamespaceLabelList: list of NetworkClusterNamespaceLabelInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ClusterNamespaceLabelList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ClusterNamespaceLabelList(self):
        return self._ClusterNamespaceLabelList

    @ClusterNamespaceLabelList.setter
    def ClusterNamespaceLabelList(self, ClusterNamespaceLabelList):
        self._ClusterNamespaceLabelList = ClusterNamespaceLabelList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ClusterNamespaceLabelList") is not None:
            self._ClusterNamespaceLabelList = []
            for item in params.get("ClusterNamespaceLabelList"):
                obj = NetworkClusterNamespaceLabelInfo()
                obj._deserialize(item)
                self._ClusterNamespaceLabelList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPodLabelsListRequest(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPodLabelsListResponse(AbstractModel):
    """DescribeNetworkFirewallPodLabelsList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of cluster Pods
        :type TotalCount: int
        :param _PodList: Details of the cluster Pod
Note: This field may return null, indicating that no valid values can be obtained.
        :type PodList: list of NetworkClusterPodInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PodList = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PodList(self):
        return self._PodList

    @PodList.setter
    def PodList(self, PodList):
        self._PodList = PodList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PodList") is not None:
            self._PodList = []
            for item in params.get("PodList"):
                obj = NetworkClusterPodInfo()
                obj._deserialize(item)
                self._PodList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Policy ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _Namespace: Namespace
Note: This field may return null, indicating that no valid values can be obtained.
        :type Namespace: str
        :param _FromPolicyRule: Inbound type
        :type FromPolicyRule: int
        :param _ToPolicyRule: Outbound type
        :type ToPolicyRule: int
        :param _CustomPolicy: Custom rule
Note: This field may return null, indicating that no valid values can be obtained.
        :type CustomPolicy: list of NetworkCustomPolicy
        :param _PodSelector: Pod selector
        :type PodSelector: str
        :param _Description: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _PolicyCreateTime: Policy creation time
        :type PolicyCreateTime: str
        :param _PolicySourceType: Policy source type. Valid values: `System` (synched from the cluster); `Manual` (added manually).
        :type PolicySourceType: str
        :param _NetworkPolicyPlugin: Network plugin of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkPolicyPlugin: str
        :param _PublishStatus: Network policy status
        :type PublishStatus: str
        :param _PublishResult: Policy publishing result
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublishResult: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Namespace = None
        self._FromPolicyRule = None
        self._ToPolicyRule = None
        self._CustomPolicy = None
        self._PodSelector = None
        self._Description = None
        self._PolicyCreateTime = None
        self._PolicySourceType = None
        self._NetworkPolicyPlugin = None
        self._PublishStatus = None
        self._PublishResult = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Namespace(self):
        return self._Namespace

    @Namespace.setter
    def Namespace(self, Namespace):
        self._Namespace = Namespace

    @property
    def FromPolicyRule(self):
        return self._FromPolicyRule

    @FromPolicyRule.setter
    def FromPolicyRule(self, FromPolicyRule):
        self._FromPolicyRule = FromPolicyRule

    @property
    def ToPolicyRule(self):
        return self._ToPolicyRule

    @ToPolicyRule.setter
    def ToPolicyRule(self, ToPolicyRule):
        self._ToPolicyRule = ToPolicyRule

    @property
    def CustomPolicy(self):
        return self._CustomPolicy

    @CustomPolicy.setter
    def CustomPolicy(self, CustomPolicy):
        self._CustomPolicy = CustomPolicy

    @property
    def PodSelector(self):
        return self._PodSelector

    @PodSelector.setter
    def PodSelector(self, PodSelector):
        self._PodSelector = PodSelector

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PolicyCreateTime(self):
        return self._PolicyCreateTime

    @PolicyCreateTime.setter
    def PolicyCreateTime(self, PolicyCreateTime):
        self._PolicyCreateTime = PolicyCreateTime

    @property
    def PolicySourceType(self):
        return self._PolicySourceType

    @PolicySourceType.setter
    def PolicySourceType(self, PolicySourceType):
        self._PolicySourceType = PolicySourceType

    @property
    def NetworkPolicyPlugin(self):
        return self._NetworkPolicyPlugin

    @NetworkPolicyPlugin.setter
    def NetworkPolicyPlugin(self, NetworkPolicyPlugin):
        self._NetworkPolicyPlugin = NetworkPolicyPlugin

    @property
    def PublishStatus(self):
        return self._PublishStatus

    @PublishStatus.setter
    def PublishStatus(self, PublishStatus):
        self._PublishStatus = PublishStatus

    @property
    def PublishResult(self):
        return self._PublishResult

    @PublishResult.setter
    def PublishResult(self, PublishResult):
        self._PublishResult = PublishResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Namespace = params.get("Namespace")
        self._FromPolicyRule = params.get("FromPolicyRule")
        self._ToPolicyRule = params.get("ToPolicyRule")
        if params.get("CustomPolicy") is not None:
            self._CustomPolicy = []
            for item in params.get("CustomPolicy"):
                obj = NetworkCustomPolicy()
                obj._deserialize(item)
                self._CustomPolicy.append(obj)
        self._PodSelector = params.get("PodSelector")
        self._Description = params.get("Description")
        self._PolicyCreateTime = params.get("PolicyCreateTime")
        self._PolicySourceType = params.get("PolicySourceType")
        self._NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self._PublishStatus = params.get("PublishStatus")
        self._PublishResult = params.get("PublishResult")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyDiscoverRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyDiscoverResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyDiscover response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyListRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyList request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `ClusterName`, `ClusterId`, `ClusterType`, `Region`, `ClusterCheckMode`, `ClusterAutoCheck`.
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyListResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of clusters
        :type TotalCount: int
        :param _NetPolicy: Cluster details
        :type NetPolicy: list of NetworkPolicyInfoItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._NetPolicy = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def NetPolicy(self):
        return self._NetPolicy

    @NetPolicy.setter
    def NetPolicy(self, NetPolicy):
        self._NetPolicy = NetPolicy

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("NetPolicy") is not None:
            self._NetPolicy = []
            for item in params.get("NetPolicy"):
                obj = NetworkPolicyInfoItem()
                obj._deserialize(item)
                self._NetPolicy.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyStatusRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyStatusResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyStatus response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Task status. Valid values: `Task_Running`, `Task_Succ`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param _TaskResult: Task result, such as `NameRepeat` and `K8sRuleIngressPortError`.
Note: This field may return null, indicating that no valid values can be obtained.
        :type TaskResult: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._TaskResult = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def TaskResult(self):
        return self._TaskResult

    @TaskResult.setter
    def TaskResult(self, TaskResult):
        self._TaskResult = TaskResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._TaskResult = params.get("TaskResult")
        self._RequestId = params.get("RequestId")


class DescribeNetworkFirewallPolicyYamlDetailRequest(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Id: Policy ID
        :type Id: int
        """
        self._Id = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id


    def _deserialize(self, params):
        self._Id = params.get("Id")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeNetworkFirewallPolicyYamlDetailResponse(AbstractModel):
    """DescribeNetworkFirewallPolicyYamlDetail response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: Cluster ID
        :type ClusterId: str
        :param _PolicyName: Policy name
        :type PolicyName: str
        :param _Yaml: Base64-encoded YAML string
Note: This field may return null, indicating that no valid values can be obtained.
        :type Yaml: str
        :param _Description: Policy description
Note: This field may return null, indicating that no valid values can be obtained.
        :type Description: str
        :param _PolicyCreateTime: Policy creation time
        :type PolicyCreateTime: str
        :param _PolicySourceType: Policy source type. Valid values: `System` (synched from the cluster); `Manual` (added manually).
        :type PolicySourceType: str
        :param _NetworkPolicyPlugin: Network plugin of the network policy
Note: This field may return null, indicating that no valid values can be obtained.
        :type NetworkPolicyPlugin: str
        :param _PublishStatus: Network policy status
        :type PublishStatus: str
        :param _PublishResult: Policy publishing result
Note: This field may return null, indicating that no valid values can be obtained.
        :type PublishResult: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterId = None
        self._PolicyName = None
        self._Yaml = None
        self._Description = None
        self._PolicyCreateTime = None
        self._PolicySourceType = None
        self._NetworkPolicyPlugin = None
        self._PublishStatus = None
        self._PublishResult = None
        self._RequestId = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def PolicyName(self):
        return self._PolicyName

    @PolicyName.setter
    def PolicyName(self, PolicyName):
        self._PolicyName = PolicyName

    @property
    def Yaml(self):
        return self._Yaml

    @Yaml.setter
    def Yaml(self, Yaml):
        self._Yaml = Yaml

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def PolicyCreateTime(self):
        return self._PolicyCreateTime

    @PolicyCreateTime.setter
    def PolicyCreateTime(self, PolicyCreateTime):
        self._PolicyCreateTime = PolicyCreateTime

    @property
    def PolicySourceType(self):
        return self._PolicySourceType

    @PolicySourceType.setter
    def PolicySourceType(self, PolicySourceType):
        self._PolicySourceType = PolicySourceType

    @property
    def NetworkPolicyPlugin(self):
        return self._NetworkPolicyPlugin

    @NetworkPolicyPlugin.setter
    def NetworkPolicyPlugin(self, NetworkPolicyPlugin):
        self._NetworkPolicyPlugin = NetworkPolicyPlugin

    @property
    def PublishStatus(self):
        return self._PublishStatus

    @PublishStatus.setter
    def PublishStatus(self, PublishStatus):
        self._PublishStatus = PublishStatus

    @property
    def PublishResult(self):
        return self._PublishResult

    @PublishResult.setter
    def PublishResult(self, PublishResult):
        self._PublishResult = PublishResult

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._PolicyName = params.get("PolicyName")
        self._Yaml = params.get("Yaml")
        self._Description = params.get("Description")
        self._PolicyCreateTime = params.get("PolicyCreateTime")
        self._PolicySourceType = params.get("PolicySourceType")
        self._NetworkPolicyPlugin = params.get("NetworkPolicyPlugin")
        self._PublishStatus = params.get("PublishStatus")
        self._PublishResult = params.get("PublishResult")
        self._RequestId = params.get("RequestId")


class DescribeNewestVulRequest(AbstractModel):
    """DescribeNewestVul request structure.

    """


class DescribeNewestVulResponse(AbstractModel):
    """DescribeNewestVul response structure.

    """

    def __init__(self):
        r"""
        :param _PocID: POC ID
        :type PocID: str
        :param _VulName: Vulnerability name
        :type VulName: str
        :param _SubmitTime: Disclosure time
        :type SubmitTime: str
        :param _Status: Emergency vulnerability risk information. Valid values: `NOT_SCAN` (not scanned); `SCANNING` (scanning); `SCANNED` (scanned).
        :type Status: str
        :param _CVEID: Vulnerability CVE ID
        :type CVEID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PocID = None
        self._VulName = None
        self._SubmitTime = None
        self._Status = None
        self._CVEID = None
        self._RequestId = None

    @property
    def PocID(self):
        return self._PocID

    @PocID.setter
    def PocID(self, PocID):
        self._PocID = PocID

    @property
    def VulName(self):
        return self._VulName

    @VulName.setter
    def VulName(self, VulName):
        self._VulName = VulName

    @property
    def SubmitTime(self):
        return self._SubmitTime

    @SubmitTime.setter
    def SubmitTime(self, SubmitTime):
        self._SubmitTime = SubmitTime

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CVEID(self):
        return self._CVEID

    @CVEID.setter
    def CVEID(self, CVEID):
        self._CVEID = CVEID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PocID = params.get("PocID")
        self._VulName = params.get("VulName")
        self._SubmitTime = params.get("SubmitTime")
        self._Status = params.get("Status")
        self._CVEID = params.get("CVEID")
        self._RequestId = params.get("RequestId")


class DescribePostPayDetailRequest(AbstractModel):
    """DescribePostPayDetail request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        """
        self._Limit = None
        self._Offset = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePostPayDetailResponse(AbstractModel):
    """DescribePostPayDetail response structure.

    """

    def __init__(self):
        r"""
        :param _SoftQuotaDayDetail: Elastic billing details
Note: This field may return null, indicating that no valid values can be obtained.
        :type SoftQuotaDayDetail: list of SoftQuotaDayInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SoftQuotaDayDetail = None
        self._RequestId = None

    @property
    def SoftQuotaDayDetail(self):
        return self._SoftQuotaDayDetail

    @SoftQuotaDayDetail.setter
    def SoftQuotaDayDetail(self, SoftQuotaDayDetail):
        self._SoftQuotaDayDetail = SoftQuotaDayDetail

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SoftQuotaDayDetail") is not None:
            self._SoftQuotaDayDetail = []
            for item in params.get("SoftQuotaDayDetail"):
                obj = SoftQuotaDayInfo()
                obj._deserialize(item)
                self._SoftQuotaDayDetail.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProVersionInfoRequest(AbstractModel):
    """DescribeProVersionInfo request structure.

    """


class DescribeProVersionInfoResponse(AbstractModel):
    """DescribeProVersionInfo response structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time of the Pro Edition, which is not empty only when the edition is purchased.
Note: This field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: End time of the Pro Edition, which is not empty only when more resources are purchased.
Note: This field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        :param _CoresCnt: Number of cores to be purchased
        :type CoresCnt: int
        :param _MaxPostPayCoresCnt: Upper limit for elastic billing
        :type MaxPostPayCoresCnt: int
        :param _ResourceId: Resource ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type ResourceId: str
        :param _BuyStatus: Purchase status
`Pending`: To be purchased.
`Normal`: Purchased.
`Isolate`: Isolated.
        :type BuyStatus: str
        :param _IsPurchased: Whether it has been purchased before. Valid values: `false` (no); `true` (yes).
        :type IsPurchased: bool
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StartTime = None
        self._EndTime = None
        self._CoresCnt = None
        self._MaxPostPayCoresCnt = None
        self._ResourceId = None
        self._BuyStatus = None
        self._IsPurchased = None
        self._RequestId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt

    @property
    def MaxPostPayCoresCnt(self):
        return self._MaxPostPayCoresCnt

    @MaxPostPayCoresCnt.setter
    def MaxPostPayCoresCnt(self, MaxPostPayCoresCnt):
        self._MaxPostPayCoresCnt = MaxPostPayCoresCnt

    @property
    def ResourceId(self):
        return self._ResourceId

    @ResourceId.setter
    def ResourceId(self, ResourceId):
        self._ResourceId = ResourceId

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def IsPurchased(self):
        return self._IsPurchased

    @IsPurchased.setter
    def IsPurchased(self, IsPurchased):
        self._IsPurchased = IsPurchased

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._CoresCnt = params.get("CoresCnt")
        self._MaxPostPayCoresCnt = params.get("MaxPostPayCoresCnt")
        self._ResourceId = params.get("ResourceId")
        self._BuyStatus = params.get("BuyStatus")
        self._IsPurchased = params.get("IsPurchased")
        self._RequestId = params.get("RequestId")


class DescribePromotionActivityRequest(AbstractModel):
    """DescribePromotionActivity request structure.

    """

    def __init__(self):
        r"""
        :param _ActiveID: Promotion ID
        :type ActiveID: int
        """
        self._ActiveID = None

    @property
    def ActiveID(self):
        return self._ActiveID

    @ActiveID.setter
    def ActiveID(self, ActiveID):
        self._ActiveID = ActiveID


    def _deserialize(self, params):
        self._ActiveID = params.get("ActiveID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePromotionActivityResponse(AbstractModel):
    """DescribePromotionActivity response structure.

    """

    def __init__(self):
        r"""
        :param _List: Promotion content
        :type List: list of PromotionActivityContent
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = PromotionActivityContent()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePublicKeyRequest(AbstractModel):
    """DescribePublicKey request structure.

    """


class DescribePublicKeyResponse(AbstractModel):
    """DescribePublicKey response structure.

    """

    def __init__(self):
        r"""
        :param _PublicKey: Public key
        :type PublicKey: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PublicKey = None
        self._RequestId = None

    @property
    def PublicKey(self):
        return self._PublicKey

    @PublicKey.setter
    def PublicKey(self, PublicKey):
        self._PublicKey = PublicKey

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._PublicKey = params.get("PublicKey")
        self._RequestId = params.get("RequestId")


class DescribePurchaseStateInfoRequest(AbstractModel):
    """DescribePurchaseStateInfo request structure.

    """


class DescribePurchaseStateInfoResponse(AbstractModel):
    """DescribePurchaseStateInfo response structure.

    """

    def __init__(self):
        r"""
        :param _State: Valid values: `0` (available for trial and purchase); `1` (available for purchase only after failed trial review or trial expiration); `2` (trial effective); `3` (Pro Edition effective); `4` (Pro Edition expired).
        :type State: int
        :param _CoresCnt: Total number of cores
Note: This field may return null, indicating that no valid values can be obtained.
        :type CoresCnt: int
        :param _AuthorizedCoresCnt: Number of purchased cores
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuthorizedCoresCnt: int
        :param _ImageCnt: Number of images
Note: This field may return null, indicating that no valid values can be obtained.
        :type ImageCnt: int
        :param _AuthorizedImageCnt: Number of licensed images
Note: This field may return null, indicating that no valid values can be obtained.
        :type AuthorizedImageCnt: int
        :param _PurchasedAuthorizedCnt: Number of purchased image licenses
Note: This field may return null, indicating that no valid values can be obtained.
        :type PurchasedAuthorizedCnt: int
        :param _ExpirationTime: Expiration time
Note: This field may return null, indicating that no valid values can be obtained.
        :type ExpirationTime: str
        :param _AutomaticRenewal: Valid values: `0` (initial status, which is the default value and not set by the user); `1` (auto-renewal); `2` (no auto-renewal, which is specified by the user).
Note: This field may return null, indicating that no valid values can be obtained.
        :type AutomaticRenewal: int
        :param _GivenAuthorizedCnt: Number of free image licenses during the trial, which may expire.
Note: This field may return null, indicating that no valid values can be obtained.
        :type GivenAuthorizedCnt: int
        :param _BeginTime: Start time
Note: This field may return null, indicating that no valid values can be obtained.
        :type BeginTime: str
        :param _SubState: Sub-status, the meaning of which is subject to the `State` field.
Valid values when `State` is `4`: `ISOLATE` (isolated); `DESTROED` (terminated).
Note: This field may return null, indicating that no valid values can be obtained.
        :type SubState: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._State = None
        self._CoresCnt = None
        self._AuthorizedCoresCnt = None
        self._ImageCnt = None
        self._AuthorizedImageCnt = None
        self._PurchasedAuthorizedCnt = None
        self._ExpirationTime = None
        self._AutomaticRenewal = None
        self._GivenAuthorizedCnt = None
        self._BeginTime = None
        self._SubState = None
        self._RequestId = None

    @property
    def State(self):
        return self._State

    @State.setter
    def State(self, State):
        self._State = State

    @property
    def CoresCnt(self):
        return self._CoresCnt

    @CoresCnt.setter
    def CoresCnt(self, CoresCnt):
        self._CoresCnt = CoresCnt

    @property
    def AuthorizedCoresCnt(self):
        return self._AuthorizedCoresCnt

    @AuthorizedCoresCnt.setter
    def AuthorizedCoresCnt(self, AuthorizedCoresCnt):
        self._AuthorizedCoresCnt = AuthorizedCoresCnt

    @property
    def ImageCnt(self):
        return self._ImageCnt

    @ImageCnt.setter
    def ImageCnt(self, ImageCnt):
        self._ImageCnt = ImageCnt

    @property
    def AuthorizedImageCnt(self):
        return self._AuthorizedImageCnt

    @AuthorizedImageCnt.setter
    def AuthorizedImageCnt(self, AuthorizedImageCnt):
        self._AuthorizedImageCnt = AuthorizedImageCnt

    @property
    def PurchasedAuthorizedCnt(self):
        return self._PurchasedAuthorizedCnt

    @PurchasedAuthorizedCnt.setter
    def PurchasedAuthorizedCnt(self, PurchasedAuthorizedCnt):
        self._PurchasedAuthorizedCnt = PurchasedAuthorizedCnt

    @property
    def ExpirationTime(self):
        return self._ExpirationTime

    @ExpirationTime.setter
    def ExpirationTime(self, ExpirationTime):
        self._ExpirationTime = ExpirationTime

    @property
    def AutomaticRenewal(self):
        return self._AutomaticRenewal

    @AutomaticRenewal.setter
    def AutomaticRenewal(self, AutomaticRenewal):
        self._AutomaticRenewal = AutomaticRenewal

    @property
    def GivenAuthorizedCnt(self):
        return self._GivenAuthorizedCnt

    @GivenAuthorizedCnt.setter
    def GivenAuthorizedCnt(self, GivenAuthorizedCnt):
        self._GivenAuthorizedCnt = GivenAuthorizedCnt

    @property
    def BeginTime(self):
        return self._BeginTime

    @BeginTime.setter
    def BeginTime(self, BeginTime):
        self._BeginTime = BeginTime

    @property
    def SubState(self):
        return self._SubState

    @SubState.setter
    def SubState(self, SubState):
        self._SubState = SubState

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._State = params.get("State")
        self._CoresCnt = params.get("CoresCnt")
        self._AuthorizedCoresCnt = params.get("AuthorizedCoresCnt")
        self._ImageCnt = params.get("ImageCnt")
        self._AuthorizedImageCnt = params.get("AuthorizedImageCnt")
        self._PurchasedAuthorizedCnt = params.get("PurchasedAuthorizedCnt")
        self._ExpirationTime = params.get("ExpirationTime")
        self._AutomaticRenewal = params.get("AutomaticRenewal")
        self._GivenAuthorizedCnt = params.get("GivenAuthorizedCnt")
        self._BeginTime = params.get("BeginTime")
        self._SubState = params.get("SubState")
        self._RequestId = params.get("RequestId")


class DescribeRefreshTaskRequest(AbstractModel):
    """DescribeRefreshTask request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID
        :type TaskId: int
        """
        self._TaskId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRefreshTaskResponse(AbstractModel):
    """DescribeRefreshTask response structure.

    """

    def __init__(self):
        r"""
        :param _TaskStatus: Refresh task status. Valid values: `Task_New`, `Task_Running`, `Task_Finish`, `Task_Error`, `Task_NoExist`.
        :type TaskStatus: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskStatus = None
        self._RequestId = None

    @property
    def TaskStatus(self):
        return self._TaskStatus

    @TaskStatus.setter
    def TaskStatus(self, TaskStatus):
        self._TaskStatus = TaskStatus

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskStatus = params.get("TaskStatus")
        self._RequestId = params.get("RequestId")


class DescribeReverseShellDetailRequest(AbstractModel):
    """DescribeReverseShellDetail request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Unique event ID
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellDetailResponse(AbstractModel):
    """DescribeReverseShellDetail response structure.

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.ReverseShellEventDescription`
        :param _AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = ReverseShellEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventsExportRequest(AbstractModel):
    """DescribeReverseShellEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsExportResponse(AbstractModel):
    """DescribeReverseShellEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeReverseShellEventsRequest(AbstractModel):
    """DescribeReverseShellEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameters
`InnerNetAlarmShow` - int - Required: Values: `1` (show private network alert); `0` (do not show)
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellEventsResponse(AbstractModel):
    """DescribeReverseShellEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _EventSet: Array of reverse shells
        :type EventSet: list of ReverseShellEventInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = ReverseShellEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListDetailRequest(AbstractModel):
    """DescribeReverseShellWhiteListDetail request structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListId: Allowed item ID
        :type WhiteListId: str
        """
        self._WhiteListId = None

    @property
    def WhiteListId(self):
        return self._WhiteListId

    @WhiteListId.setter
    def WhiteListId(self, WhiteListId):
        self._WhiteListId = WhiteListId


    def _deserialize(self, params):
        self._WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListDetailResponse(AbstractModel):
    """DescribeReverseShellWhiteListDetail response structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListDetailInfo: Basic information of the event
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.ReverseShellWhiteListInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WhiteListDetailInfo = None
        self._RequestId = None

    @property
    def WhiteListDetailInfo(self):
        return self._WhiteListDetailInfo

    @WhiteListDetailInfo.setter
    def WhiteListDetailInfo(self, WhiteListDetailInfo):
        self._WhiteListDetailInfo = WhiteListDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self._WhiteListDetailInfo = ReverseShellWhiteListInfo()
            self._WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeReverseShellWhiteListsRequest(AbstractModel):
    """DescribeReverseShellWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReverseShellWhiteListsResponse(AbstractModel):
    """DescribeReverseShellWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _WhiteListSet: Allowlist
        :type WhiteListSet: list of ReverseShellWhiteListBaseInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteListSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteListSet(self):
        return self._WhiteListSet

    @WhiteListSet.setter
    def WhiteListSet(self, WhiteListSet):
        self._WhiteListSet = WhiteListSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self._WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = ReverseShellWhiteListBaseInfo()
                obj._deserialize(item)
                self._WhiteListSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRiskListRequest(AbstractModel):
    """DescribeRiskList request structure.

    """

    def __init__(self):
        r"""
        :param _ClusterId: ID of the cluster to be queried. If it is not specified, all risk items will be queried.
        :type ClusterId: str
        :param _Offset: Offset
        :type Offset: int
        :param _Limit: Maximum number of records per query
        :type Limit: int
        :param _Filters: Name - String
Name. Valid values: `RiskLevel` (risk level); `RiskTarget` (check target and risky target); `RiskType` (risk type); `RiskAttribute` (risk type of the check item).
        :type Filters: list of ComplianceFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        """
        self._ClusterId = None
        self._Offset = None
        self._Limit = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def ClusterId(self):
        return self._ClusterId

    @ClusterId.setter
    def ClusterId(self, ClusterId):
        self._ClusterId = ClusterId

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._ClusterId = params.get("ClusterId")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = ComplianceFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskListResponse(AbstractModel):
    """DescribeRiskList response structure.

    """

    def __init__(self):
        r"""
        :param _ClusterRiskItems: Array of risk details
        :type ClusterRiskItems: list of ClusterRiskItem
        :param _TotalCount: Total number of risk items
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClusterRiskItems = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def ClusterRiskItems(self):
        return self._ClusterRiskItems

    @ClusterRiskItems.setter
    def ClusterRiskItems(self, ClusterRiskItems):
        self._ClusterRiskItems = ClusterRiskItems

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClusterRiskItems") is not None:
            self._ClusterRiskItems = []
            for item in params.get("ClusterRiskItems"):
                obj = ClusterRiskItem()
                obj._deserialize(item)
                self._ClusterRiskItems.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallDetailRequest(AbstractModel):
    """DescribeRiskSyscallDetail request structure.

    """

    def __init__(self):
        r"""
        :param _EventId: Unique event ID
        :type EventId: str
        """
        self._EventId = None

    @property
    def EventId(self):
        return self._EventId

    @EventId.setter
    def EventId(self, EventId):
        self._EventId = EventId


    def _deserialize(self, params):
        self._EventId = params.get("EventId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallDetailResponse(AbstractModel):
    """DescribeRiskSyscallDetail response structure.

    """

    def __init__(self):
        r"""
        :param _EventBaseInfo: Basic information of the event
        :type EventBaseInfo: :class:`tencentcloud.tcss.v20201101.models.RunTimeEventBaseInfo`
        :param _ProcessInfo: Process information
        :type ProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailInfo`
        :param _ParentProcessInfo: Parent process information
        :type ParentProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessDetailBaseInfo`
        :param _EventDetail: Event description
        :type EventDetail: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallEventDescription`
        :param _AncestorProcessInfo: Ancestor process information
Note: This field may return null, indicating that no valid values can be obtained.
        :type AncestorProcessInfo: :class:`tencentcloud.tcss.v20201101.models.ProcessBaseInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventBaseInfo = None
        self._ProcessInfo = None
        self._ParentProcessInfo = None
        self._EventDetail = None
        self._AncestorProcessInfo = None
        self._RequestId = None

    @property
    def EventBaseInfo(self):
        return self._EventBaseInfo

    @EventBaseInfo.setter
    def EventBaseInfo(self, EventBaseInfo):
        self._EventBaseInfo = EventBaseInfo

    @property
    def ProcessInfo(self):
        return self._ProcessInfo

    @ProcessInfo.setter
    def ProcessInfo(self, ProcessInfo):
        self._ProcessInfo = ProcessInfo

    @property
    def ParentProcessInfo(self):
        return self._ParentProcessInfo

    @ParentProcessInfo.setter
    def ParentProcessInfo(self, ParentProcessInfo):
        self._ParentProcessInfo = ParentProcessInfo

    @property
    def EventDetail(self):
        return self._EventDetail

    @EventDetail.setter
    def EventDetail(self, EventDetail):
        self._EventDetail = EventDetail

    @property
    def AncestorProcessInfo(self):
        return self._AncestorProcessInfo

    @AncestorProcessInfo.setter
    def AncestorProcessInfo(self, AncestorProcessInfo):
        self._AncestorProcessInfo = AncestorProcessInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventBaseInfo") is not None:
            self._EventBaseInfo = RunTimeEventBaseInfo()
            self._EventBaseInfo._deserialize(params.get("EventBaseInfo"))
        if params.get("ProcessInfo") is not None:
            self._ProcessInfo = ProcessDetailInfo()
            self._ProcessInfo._deserialize(params.get("ProcessInfo"))
        if params.get("ParentProcessInfo") is not None:
            self._ParentProcessInfo = ProcessDetailBaseInfo()
            self._ParentProcessInfo._deserialize(params.get("ParentProcessInfo"))
        if params.get("EventDetail") is not None:
            self._EventDetail = RiskSyscallEventDescription()
            self._EventDetail._deserialize(params.get("EventDetail"))
        if params.get("AncestorProcessInfo") is not None:
            self._AncestorProcessInfo = ProcessBaseInfo()
            self._AncestorProcessInfo._deserialize(params.get("AncestorProcessInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsExportRequest(AbstractModel):
    """DescribeRiskSyscallEventsExport request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        :param _ExportField: Export field
        :type ExportField: list of str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None
        self._ExportField = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def ExportField(self):
        return self._ExportField

    @ExportField.setter
    def ExportField(self, ExportField):
        self._ExportField = ExportField


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        self._ExportField = params.get("ExportField")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsExportResponse(AbstractModel):
    """DescribeRiskSyscallEventsExport response structure.

    """

    def __init__(self):
        r"""
        :param _DownloadUrl: Excel download URL
Note: This field may return null, indicating that no valid values can be obtained.
        :type DownloadUrl: str
        :param _JobId: Task ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DownloadUrl = None
        self._JobId = None
        self._RequestId = None

    @property
    def DownloadUrl(self):
        return self._DownloadUrl

    @DownloadUrl.setter
    def DownloadUrl(self, DownloadUrl):
        self._DownloadUrl = DownloadUrl

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DownloadUrl = params.get("DownloadUrl")
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallEventsRequest(AbstractModel):
    """DescribeRiskSyscallEvents request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallEventsResponse(AbstractModel):
    """DescribeRiskSyscallEvents response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _EventSet: Array of high-risk syscalls
        :type EventSet: list of RiskSyscallEventInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._EventSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def EventSet(self):
        return self._EventSet

    @EventSet.setter
    def EventSet(self, EventSet):
        self._EventSet = EventSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("EventSet") is not None:
            self._EventSet = []
            for item in params.get("EventSet"):
                obj = RiskSyscallEventInfo()
                obj._deserialize(item)
                self._EventSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallNamesRequest(AbstractModel):
    """DescribeRiskSyscallNames request structure.

    """


class DescribeRiskSyscallNamesResponse(AbstractModel):
    """DescribeRiskSyscallNames response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _SyscallNames: List of syscall names
        :type SyscallNames: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SyscallNames = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SyscallNames(self):
        return self._SyscallNames

    @SyscallNames.setter
    def SyscallNames(self, SyscallNames):
        self._SyscallNames = SyscallNames

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._SyscallNames = params.get("SyscallNames")
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListDetailRequest(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail request structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListId: Allowed item ID
        :type WhiteListId: str
        """
        self._WhiteListId = None

    @property
    def WhiteListId(self):
        return self._WhiteListId

    @WhiteListId.setter
    def WhiteListId(self, WhiteListId):
        self._WhiteListId = WhiteListId


    def _deserialize(self, params):
        self._WhiteListId = params.get("WhiteListId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListDetailResponse(AbstractModel):
    """DescribeRiskSyscallWhiteListDetail response structure.

    """

    def __init__(self):
        r"""
        :param _WhiteListDetailInfo: Basic information of the allowlist
        :type WhiteListDetailInfo: :class:`tencentcloud.tcss.v20201101.models.RiskSyscallWhiteListInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._WhiteListDetailInfo = None
        self._RequestId = None

    @property
    def WhiteListDetailInfo(self):
        return self._WhiteListDetailInfo

    @WhiteListDetailInfo.setter
    def WhiteListDetailInfo(self, WhiteListDetailInfo):
        self._WhiteListDetailInfo = WhiteListDetailInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("WhiteListDetailInfo") is not None:
            self._WhiteListDetailInfo = RiskSyscallWhiteListInfo()
            self._WhiteListDetailInfo._deserialize(params.get("WhiteListDetailInfo"))
        self._RequestId = params.get("RequestId")


class DescribeRiskSyscallWhiteListsRequest(AbstractModel):
    """DescribeRiskSyscallWhiteLists request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter parameter. "Filters":[{"Name":"Status","Values":["2"]}]
        :type Filters: list of RunTimeFilters
        :param _Order: Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRiskSyscallWhiteListsResponse(AbstractModel):
    """DescribeRiskSyscallWhiteLists response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of events
        :type TotalCount: int
        :param _WhiteListSet: Allowlist
        :type WhiteListSet: list of RiskSyscallWhiteListBaseInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WhiteListSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WhiteListSet(self):
        return self._WhiteListSet

    @WhiteListSet.setter
    def WhiteListSet(self, WhiteListSet):
        self._WhiteListSet = WhiteListSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WhiteListSet") is not None:
            self._WhiteListSet = []
            for item in params.get("WhiteListSet"):
                obj = RiskSyscallWhiteListBaseInfo()
                obj._deserialize(item)
                self._WhiteListSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeScanIgnoreVulListRequest(AbstractModel):
    """DescribeScanIgnoreVulList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>CVEID- string - Required: No - CVE No.</li>
<li>VulName- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order. Valid values: `DESC`, `ASC`.
        :type Order: str
        :param _By: Sorting field: `UpdateTime`.
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeScanIgnoreVulListResponse(AbstractModel):
    """DescribeScanIgnoreVulList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: List of vulnerabilities
        :type List: list of ScanIgnoreVul
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = ScanIgnoreVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSearchExportListRequest(AbstractModel):
    """DescribeSearchExportList request structure.

    """

    def __init__(self):
        r"""
        :param _Query: ES query condition in JSON
        :type Query: str
        """
        self._Query = None

    @property
    def Query(self):
        return self._Query

    @Query.setter
    def Query(self, Query):
        self._Query = Query


    def _deserialize(self, params):
        self._Query = params.get("Query")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchExportListResponse(AbstractModel):
    """DescribeSearchExportList response structure.

    """

    def __init__(self):
        r"""
        :param _JobId: Export task ID, which is used to query the task progress on the frontend.
        :type JobId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._JobId = None
        self._RequestId = None

    @property
    def JobId(self):
        return self._JobId

    @JobId.setter
    def JobId(self, JobId):
        self._JobId = JobId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._JobId = params.get("JobId")
        self._RequestId = params.get("RequestId")


class DescribeSearchLogsRequest(AbstractModel):
    """DescribeSearchLogs request structure.

    """


class DescribeSearchLogsResponse(AbstractModel):
    """DescribeSearchLogs response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Historical search records, the latest ten of which are retained.
        :type Data: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Data = params.get("Data")
        self._RequestId = params.get("RequestId")


class DescribeSearchTemplatesRequest(AbstractModel):
    """DescribeSearchTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        """
        self._Offset = None
        self._Limit = None

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSearchTemplatesResponse(AbstractModel):
    """DescribeSearchTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: Template list
        :type List: list of SearchTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SearchTemplate()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecEventsTendencyRequest(AbstractModel):
    """DescribeSecEventsTendency request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        """
        self._StartTime = None
        self._EndTime = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecEventsTendencyResponse(AbstractModel):
    """DescribeSecEventsTendency response structure.

    """

    def __init__(self):
        r"""
        :param _EventTendencySet: List of trends of security events at runtime
        :type EventTendencySet: list of SecTendencyEventInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._EventTendencySet = None
        self._RequestId = None

    @property
    def EventTendencySet(self):
        return self._EventTendencySet

    @EventTendencySet.setter
    def EventTendencySet(self, EventTendencySet):
        self._EventTendencySet = EventTendencySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("EventTendencySet") is not None:
            self._EventTendencySet = []
            for item in params.get("EventTendencySet"):
                obj = SecTendencyEventInfo()
                obj._deserialize(item)
                self._EventTendencySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogAlertMsgRequest(AbstractModel):
    """DescribeSecLogAlertMsg request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Alert type
Log storage alert: log_reserve_full
Log storage period alert: log_save_day_limit
Unavailable Kafka instance/public domain name: kafka_instance_domain_unavailable
Incorrect Kafka username/password: kafka_user_passwd_wrong
Kafka backend error field: kafka_field_wrong
        :type Type: list of str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogAlertMsgResponse(AbstractModel):
    """DescribeSecLogAlertMsg response structure.

    """

    def __init__(self):
        r"""
        :param _List: Alert message queue
        :type List: list of SecLogAlertMsgInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogAlertMsgInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogCleanSettingInfoRequest(AbstractModel):
    """DescribeSecLogCleanSettingInfo request structure.

    """


class DescribeSecLogCleanSettingInfoResponse(AbstractModel):
    """DescribeSecLogCleanSettingInfo response structure.

    """

    def __init__(self):
        r"""
        :param _ReservesLimit: Minimum storage for triggering clearing
        :type ReservesLimit: int
        :param _ReservesDeadline: Storage limit for stopping clearing
        :type ReservesDeadline: int
        :param _DayLimit: Storage period for triggering clearing
        :type DayLimit: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ReservesLimit = None
        self._ReservesDeadline = None
        self._DayLimit = None
        self._RequestId = None

    @property
    def ReservesLimit(self):
        return self._ReservesLimit

    @ReservesLimit.setter
    def ReservesLimit(self, ReservesLimit):
        self._ReservesLimit = ReservesLimit

    @property
    def ReservesDeadline(self):
        return self._ReservesDeadline

    @ReservesDeadline.setter
    def ReservesDeadline(self, ReservesDeadline):
        self._ReservesDeadline = ReservesDeadline

    @property
    def DayLimit(self):
        return self._DayLimit

    @DayLimit.setter
    def DayLimit(self, DayLimit):
        self._DayLimit = DayLimit

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ReservesLimit = params.get("ReservesLimit")
        self._ReservesDeadline = params.get("ReservesDeadline")
        self._DayLimit = params.get("DayLimit")
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryClsOptions request structure.

    """

    def __init__(self):
        r"""
        :param _ClsRegion: Region
        :type ClsRegion: str
        """
        self._ClsRegion = None

    @property
    def ClsRegion(self):
        return self._ClsRegion

    @ClsRegion.setter
    def ClsRegion(self, ClsRegion):
        self._ClsRegion = ClsRegion


    def _deserialize(self, params):
        self._ClsRegion = params.get("ClsRegion")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryClsOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryClsOptions response structure.

    """

    def __init__(self):
        r"""
        :param _LogSetList: List of optional CLS logsets, which is returned only when `ClsRegion` is not empty.
        :type LogSetList: list of ClsLogsetInfo
        :param _RegionList: List of optional regions, which is returned only when `ClsRegion` is empty.
        :type RegionList: list of RegionInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LogSetList = None
        self._RegionList = None
        self._RequestId = None

    @property
    def LogSetList(self):
        return self._LogSetList

    @LogSetList.setter
    def LogSetList(self, LogSetList):
        self._LogSetList = LogSetList

    @property
    def RegionList(self):
        return self._RegionList

    @RegionList.setter
    def RegionList(self, RegionList):
        self._RegionList = RegionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogSetList") is not None:
            self._LogSetList = []
            for item in params.get("LogSetList"):
                obj = ClsLogsetInfo()
                obj._deserialize(item)
                self._LogSetList.append(obj)
        if params.get("RegionList") is not None:
            self._RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._RegionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryClsSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryClsSetting request structure.

    """


class DescribeSecLogDeliveryClsSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryClsSetting response structure.

    """

    def __init__(self):
        r"""
        :param _LogTypeList: List of log types
        :type LogTypeList: list of SecLogDeliveryClsSettingInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LogTypeList = None
        self._RequestId = None

    @property
    def LogTypeList(self):
        return self._LogTypeList

    @LogTypeList.setter
    def LogTypeList(self, LogTypeList):
        self._LogTypeList = LogTypeList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LogTypeList") is not None:
            self._LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryClsSettingInfo()
                obj._deserialize(item)
                self._LogTypeList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaOptionsRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions request structure.

    """

    def __init__(self):
        r"""
        :param _RegionID: Region. If this field was left blank, return all available regions.
        :type RegionID: str
        """
        self._RegionID = None

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID


    def _deserialize(self, params):
        self._RegionID = params.get("RegionID")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogDeliveryKafkaOptionsResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaOptions response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceList: Instance list
        :type InstanceList: list of CKafkaInstanceInfo
        :param _RegionList: Region list
        :type RegionList: list of RegionInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceList = None
        self._RegionList = None
        self._RequestId = None

    @property
    def InstanceList(self):
        return self._InstanceList

    @InstanceList.setter
    def InstanceList(self, InstanceList):
        self._InstanceList = InstanceList

    @property
    def RegionList(self):
        return self._RegionList

    @RegionList.setter
    def RegionList(self, RegionList):
        self._RegionList = RegionList

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("InstanceList") is not None:
            self._InstanceList = []
            for item in params.get("InstanceList"):
                obj = CKafkaInstanceInfo()
                obj._deserialize(item)
                self._InstanceList.append(obj)
        if params.get("RegionList") is not None:
            self._RegionList = []
            for item in params.get("RegionList"):
                obj = RegionInfo()
                obj._deserialize(item)
                self._RegionList.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogDeliveryKafkaSettingRequest(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting request structure.

    """


class DescribeSecLogDeliveryKafkaSettingResponse(AbstractModel):
    """DescribeSecLogDeliveryKafkaSetting response structure.

    """

    def __init__(self):
        r"""
        :param _InstanceID: Message queue instance ID
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceID: str
        :param _InstanceName: Message queue instance name
Note: This field may return null, indicating that no valid values can be obtained.
        :type InstanceName: str
        :param _Domain: Domain
Note: This field may return null, indicating that no valid values can be obtained.
        :type Domain: str
        :param _LogTypeList: List of log types
Note: This field may return null, indicating that no valid values can be obtained.
        :type LogTypeList: list of SecLogDeliveryKafkaSettingInfo
        :param _User: Username
Note: This field may return null, indicating that no valid values can be obtained.
        :type User: str
        :param _RegionID: Region ID
Note: This field may return `null`, indicating that no valid value was found.
        :type RegionID: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._InstanceID = None
        self._InstanceName = None
        self._Domain = None
        self._LogTypeList = None
        self._User = None
        self._RegionID = None
        self._RequestId = None

    @property
    def InstanceID(self):
        return self._InstanceID

    @InstanceID.setter
    def InstanceID(self, InstanceID):
        self._InstanceID = InstanceID

    @property
    def InstanceName(self):
        return self._InstanceName

    @InstanceName.setter
    def InstanceName(self, InstanceName):
        self._InstanceName = InstanceName

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def LogTypeList(self):
        return self._LogTypeList

    @LogTypeList.setter
    def LogTypeList(self, LogTypeList):
        self._LogTypeList = LogTypeList

    @property
    def User(self):
        return self._User

    @User.setter
    def User(self, User):
        self._User = User

    @property
    def RegionID(self):
        return self._RegionID

    @RegionID.setter
    def RegionID(self, RegionID):
        self._RegionID = RegionID

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._InstanceID = params.get("InstanceID")
        self._InstanceName = params.get("InstanceName")
        self._Domain = params.get("Domain")
        if params.get("LogTypeList") is not None:
            self._LogTypeList = []
            for item in params.get("LogTypeList"):
                obj = SecLogDeliveryKafkaSettingInfo()
                obj._deserialize(item)
                self._LogTypeList.append(obj)
        self._User = params.get("User")
        self._RegionID = params.get("RegionID")
        self._RequestId = params.get("RequestId")


class DescribeSecLogJoinObjectListRequest(AbstractModel):
    """DescribeSecLogJoinObjectList request structure.

    """

    def __init__(self):
        r"""
        :param _LogType: Log type
Container bash: "container_bash",
Container startup: "container_launch",
K8s API: "k8s_api"
        :type LogType: str
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filters.
<li>`Status` - String - Optional - Host status</li>
<li>`HostIP` - String - Optional - Private IP of the host</li>
<li>`PublicIP` - String - Optional - Public IP of the host</li>
<li>`HostName - String - Optional - Host name</li>
        :type Filters: list of RunTimeFilters
        :param _By: Sorting field
        :type By: str
        :param _Order: Sorting order
        :type Order: str
        """
        self._LogType = None
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._By = None
        self._Order = None

    @property
    def LogType(self):
        return self._LogType

    @LogType.setter
    def LogType(self, LogType):
        self._LogType = LogType

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order


    def _deserialize(self, params):
        self._LogType = params.get("LogType")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._By = params.get("By")
        self._Order = params.get("Order")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSecLogJoinObjectListResponse(AbstractModel):
    """DescribeSecLogJoinObjectList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _List: List of accessed objects
        :type List: list of SecLogJoinObjectInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogJoinObjectInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogJoinTypeListRequest(AbstractModel):
    """DescribeSecLogJoinTypeList request structure.

    """


class DescribeSecLogJoinTypeListResponse(AbstractModel):
    """DescribeSecLogJoinTypeList response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of log access types
        :type List: list of SecLogJoinInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SecLogJoinInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSecLogKafkaUINRequest(AbstractModel):
    """DescribeSecLogKafkaUIN request structure.

    """


class DescribeSecLogKafkaUINResponse(AbstractModel):
    """DescribeSecLogKafkaUIN response structure.

    """

    def __init__(self):
        r"""
        :param _DstUIN: Target UIN
Note: This field may return null, indicating that no valid values can be obtained.
        :type DstUIN: str
        :param _Status: Licensing status
Note: This field may return null, indicating that no valid values can be obtained.
        :type Status: bool
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DstUIN = None
        self._Status = None
        self._RequestId = None

    @property
    def DstUIN(self):
        return self._DstUIN

    @DstUIN.setter
    def DstUIN(self, DstUIN):
        self._DstUIN = DstUIN

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DstUIN = params.get("DstUIN")
        self._Status = params.get("Status")
        self._RequestId = params.get("RequestId")


class DescribeSecLogVasInfoRequest(AbstractModel):
    """DescribeSecLogVasInfo request structure.

    """


class DescribeSecLogVasInfoResponse(AbstractModel):
    """DescribeSecLogVasInfo response structure.

    """

    def __init__(self):
        r"""
        :param _BuyStatus: Purchase status
`Pending`: To be purchased.
`Normal`: Purchased.
`Isolate`: Isolated.
        :type BuyStatus: str
        :param _LogSaveMonth: Storage period in months
        :type LogSaveMonth: int
        :param _StartTime: Start time
        :type StartTime: str
        :param _EndTime: End time
        :type EndTime: str
        :param _LogCapacity: Storage capacity (GB)
        :type LogCapacity: int
        :param _ResourceID: Resource ID
        :type ResourceID: str
        :param _IsPurchased: Whether it has been purchased before. Valid values: `false` (no); `true` (yes).
        :type IsPurchased: bool
        :param _TrialCapacity: Trial storage capacity (GB)
        :type TrialCapacity: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._BuyStatus = None
        self._LogSaveMonth = None
        self._StartTime = None
        self._EndTime = None
        self._LogCapacity = None
        self._ResourceID = None
        self._IsPurchased = None
        self._TrialCapacity = None
        self._RequestId = None

    @property
    def BuyStatus(self):
        return self._BuyStatus

    @BuyStatus.setter
    def BuyStatus(self, BuyStatus):
        self._BuyStatus = BuyStatus

    @property
    def LogSaveMonth(self):
        return self._LogSaveMonth

    @LogSaveMonth.setter
    def LogSaveMonth(self, LogSaveMonth):
        self._LogSaveMonth = LogSaveMonth

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def LogCapacity(self):
        return self._LogCapacity

    @LogCapacity.setter
    def LogCapacity(self, LogCapacity):
        self._LogCapacity = LogCapacity

    @property
    def ResourceID(self):
        return self._ResourceID

    @ResourceID.setter
    def ResourceID(self, ResourceID):
        self._ResourceID = ResourceID

    @property
    def IsPurchased(self):
        return self._IsPurchased

    @IsPurchased.setter
    def IsPurchased(self, IsPurchased):
        self._IsPurchased = IsPurchased

    @property
    def TrialCapacity(self):
        return self._TrialCapacity

    @TrialCapacity.setter
    def TrialCapacity(self, TrialCapacity):
        self._TrialCapacity = TrialCapacity

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._BuyStatus = params.get("BuyStatus")
        self._LogSaveMonth = params.get("LogSaveMonth")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._LogCapacity = params.get("LogCapacity")
        self._ResourceID = params.get("ResourceID")
        self._IsPurchased = params.get("IsPurchased")
        self._TrialCapacity = params.get("TrialCapacity")
        self._RequestId = params.get("RequestId")


class DescribeSupportDefenceVulRequest(AbstractModel):
    """DescribeSupportDefenceVul request structure.

    """

    def __init__(self):
        r"""
        :param _Filters: Filter
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>Name- string - Required: No - Vulnerability name</li>
        :type Filters: list of RunTimeFilters
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Order: Sorting order. Valid values: `asc`, `desc`.
        :type Order: str
        :param _By: Sorting field. Disclosure time: `SubmitTime`.
        :type By: str
        """
        self._Filters = None
        self._Limit = None
        self._Offset = None
        self._Order = None
        self._By = None

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSupportDefenceVulResponse(AbstractModel):
    """DescribeSupportDefenceVul response structure.

    """

    def __init__(self):
        r"""
        :param _List: List of vulnerabilities that can be prevented
        :type List: list of SupportDefenceVul
        :param _TotalCount: Total number
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._List = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = SupportDefenceVul()
                obj._deserialize(item)
                self._List.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSystemVulListRequest(AbstractModel):
    """DescribeSystemVulList request structure.

    """

    def __init__(self):
        r"""
        :param _Limit: Number of results to be returned. Default value: `10`. Maximum value: `100`.
        :type Limit: int
        :param _Offset: Offset. Default value: `0`.
        :type Offset: int
        :param _Filters: Filter
<li>OnlyAffectedContainer- string - Required: No - Show only vulnerabilities that affect containers. Valid values: `true`, `false`.</li>
<li>OnlyAffectedNewestImage-string - Required: No - Show only vulnerabilities that affect the latest image tags. Valid values: `true`, `false`.</li>
<li>Level- String - Required: No - Severity. Valid values: `CRITICAL` (critical); `HIGH` (high); `MIDDLE` (medium); `LOW` (low).</li>
<li>Tags- string - Required: No - Vulnerability tag. Valid values: `POC`, `EXP`.</li>
<li>CanBeFixed- string - Required: No - Whether the vulnerability can be fixed. Valid values: `true`, `false`.</li>
<li>CVEID- string - Required: No - CVE No.</li>
<li>ImageID- string - Required: No - Image ID</li>
<li>ImageName- String - Required: No - Image name</li>
<li>ContainerID- string - Required: No - Container ID</li>
<li>ContainerName- string - Required: No - Container name</li>
<li>ComponentName- string - Required: No - Component name</li>
<li>ComponentVersion- string - Required: No - Component version</li>
<li>Name- string - Required: No - Vulnerability name</li>
<li>FocusOnType - string - Required: No - Urgency. Valid values: `ALL` (all); `SERIOUS_LEVEL (critical and high risks); `IS_SUGGEST` (high-priority); `POC_EXP` (POC/EXP); `NETWORK_EXP` (remote EXP).</li>
        :type Filters: list of RunTimeFilters
        :param _Order: Sorting order
        :type Order: str
        :param _By: Sorting field
        :type By: str
        """
        self._Limit = None
        self._Offset = None
        self._Filters = None
        self._Order = None
        self._By = None

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters

    @property
    def Order(self):
        return self._Order

    @Order.setter
    def Order(self, Order):
        self._Order = Order

    @property
    def By(self):
        return self._By

    @By.setter
    def By(self, By):
        self._By = By


    def _deserialize(self, params):
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        if params.get("Filters") is not None:
            self._Filters = []
            for item in params.get("Filters"):
                obj = RunTimeFilters()
                obj._deserialize(item)
                self._Filters.append(obj)
        self._Order = params.get("Order")
        self._By = params.get("By")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSystemVulListResponse(AbstractModel):
    """DescribeSystemVulList response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of vulnerabilities
        :type TotalCount: int
        :param _List: List of vulnerabilities
        :type List: list of VulInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._List = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def List(self):
        return self._List

    @List.setter
    def List(self, List):
        self._List = List

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("List") is not None:
            self._List = []
            for item in params.get("List"):
                obj = VulInfo()
                obj._deserialize(item)
                self._List.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskResultSummaryRequest(AbstractModel):
    """DescribeTaskResultSummary request structure.

    """


class DescribeTaskResultSummaryResponse(AbstractModel):
    """DescribeTaskResultSummary response structure.

    """

    def __init__(self):
   