# -*- coding: utf8 -*-
# Copyright (c) 2017-2021 THL A29 Limited, a Tencent company. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import warnings

from tencentcloud.common.abstract_model import AbstractModel


class AIAnalysisTemplateItem(AbstractModel):
    """AI-based intelligent analysis template details

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of intelligent analysis template.
        :type Definition: int
        :param _Name: Intelligent analysis template name.
        :type Name: str
        :param _Comment: Intelligent analysis template description.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: Control parameter of an intelligent highlight generating task.
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AIRecognitionTemplateItem(AbstractModel):
    """Video content recognition template details

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content recognition template.
        :type Definition: int
        :param _Name: Video content recognition template name.
        :type Name: str
        :param _Comment: Video content recognition template description.
        :type Comment: str
        :param _HeadTailConfigure: Control parameter of opening and closing credits recognition.
Note: this field may return null, indicating that no valid values can be obtained.
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: Control parameter of splitting recognition.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: Face recognition control parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Full text recognition control parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Text keyword recognition control parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Full speech recognition control parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Speech keyword recognition control parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _ObjectConfigure: Control parameter of object recognition.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: Screencapturing interval in seconds.
        :type ScreenshotInterval: float
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadTailConfigure(self):
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def ObjectConfigure(self):
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfo(AbstractModel):
    """Control parameters for detecting low brightness and overexposure of video.

    """

    def __init__(self):
        r"""
        :param _Switch: low brightness and overexposure inspection switch, optional values: 
<li>ON: enabled;</li> 
<li>OFF: disabled.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AbnormalLightingConfigureInfoForUpdate(AbstractModel):
    """Control parameters for detecting low brightness and overexposure of video.

    """

    def __init__(self):
        r"""
        :param _Switch: low brightness and overexposure inspection switch, optional values: 
<li>ON: enabled;</li> 
<li>OFF: disabled.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AccelerateAreaInfo(AbstractModel):
    """Acceleration region information of the domain name

    """

    def __init__(self):
        r"""
        :param _Area: Acceleration region. Valid values:
<li>Chinese Mainland</li>
<li>Outside Chinese Mainland</li>
        :type Area: str
        :param _TencentDisableReason: Reason why acceleration is disabled by Tencent Cloud. Valid values:
<li>ForLegalReasons: legal reasons</li>
<li>ForOverdueBills: overdue payment</li>
        :type TencentDisableReason: str
        :param _TencentEdgeDomain: CNAME of the acceleration domain name
        :type TencentEdgeDomain: str
        """
        self._Area = None
        self._TencentDisableReason = None
        self._TencentEdgeDomain = None

    @property
    def Area(self):
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def TencentDisableReason(self):
        return self._TencentDisableReason

    @TencentDisableReason.setter
    def TencentDisableReason(self, TencentDisableReason):
        self._TencentDisableReason = TencentDisableReason

    @property
    def TencentEdgeDomain(self):
        return self._TencentEdgeDomain

    @TencentEdgeDomain.setter
    def TencentEdgeDomain(self, TencentEdgeDomain):
        self._TencentEdgeDomain = TencentEdgeDomain


    def _deserialize(self, params):
        self._Area = params.get("Area")
        self._TencentDisableReason = params.get("TencentDisableReason")
        self._TencentEdgeDomain = params.get("TencentEdgeDomain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingInfoItem(AbstractModel):
    """Adaptive bitrate streaming information

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive bitrate streaming specification.
        :type Definition: int
        :param _Package: The packaging format. Valid values:
<li>`HLS`</li>
<li>`DASH`</li>
        :type Package: str
        :param _DrmType: Encryption type.
        :type DrmType: str
        :param _Url: Playback address.
        :type Url: str
        :param _Size: File size (bytes)
<li>If the file is an HLS file, the value of this parameter is the sum of the size of the M3U8 and TS files.</li>
<li>If the file is a DASH file, the value of this parameter is the sum of the size of the MPD and segment files.</li>
<li><font color=red>Note</font>: For adaptive bitrate streaming files generated before 2022-01-10T16:00:00Z, the value of this parameter is `0`.</li>
        :type Size: int
        :param _DigitalWatermarkType: Digital watermark type. Optional values:
<li>Trace means traceability watermark processing; </li>
<li>CopyRight means copyright watermark processing; </li>
<li>None means no digital watermark processing. </li>
        :type DigitalWatermarkType: str
        :param _SubStreamSet: The information of the streams.
        :type SubStreamSet: list of MediaSubStreamInfoItem
        :param _CopyRightWatermarkText: Copyright Information.
        :type CopyRightWatermarkText: str
        """
        self._Definition = None
        self._Package = None
        self._DrmType = None
        self._Url = None
        self._Size = None
        self._DigitalWatermarkType = None
        self._SubStreamSet = None
        self._CopyRightWatermarkText = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Package(self):
        return self._Package

    @Package.setter
    def Package(self, Package):
        self._Package = Package

    @property
    def DrmType(self):
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def Size(self):
        return self._Size

    @Size.setter
    def Size(self, Size):
        self._Size = Size

    @property
    def DigitalWatermarkType(self):
        return self._DigitalWatermarkType

    @DigitalWatermarkType.setter
    def DigitalWatermarkType(self, DigitalWatermarkType):
        self._DigitalWatermarkType = DigitalWatermarkType

    @property
    def SubStreamSet(self):
        return self._SubStreamSet

    @SubStreamSet.setter
    def SubStreamSet(self, SubStreamSet):
        self._SubStreamSet = SubStreamSet

    @property
    def CopyRightWatermarkText(self):
        return self._CopyRightWatermarkText

    @CopyRightWatermarkText.setter
    def CopyRightWatermarkText(self, CopyRightWatermarkText):
        self._CopyRightWatermarkText = CopyRightWatermarkText


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Package = params.get("Package")
        self._DrmType = params.get("DrmType")
        self._Url = params.get("Url")
        self._Size = params.get("Size")
        self._DigitalWatermarkType = params.get("DigitalWatermarkType")
        if params.get("SubStreamSet") is not None:
            self._SubStreamSet = []
            for item in params.get("SubStreamSet"):
                obj = MediaSubStreamInfoItem()
                obj._deserialize(item)
                self._SubStreamSet.append(obj)
        self._CopyRightWatermarkText = params.get("CopyRightWatermarkText")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTaskInput(AbstractModel):
    """Input parameter type of adaptive bitrate streaming

    """

    def __init__(self):
        r"""
        :param _Definition: Adaptive bitrate streaming template ID.
        :type Definition: int
        :param _WatermarkSet: List of up to 10 image or text watermarks.
Note: this field may return null, indicating that no valid values can be obtained.
        :type WatermarkSet: list of WatermarkInput
        :param _TraceWatermark: Digital watermark.
        :type TraceWatermark: :class:`tencentcloud.vod.v20180717.models.TraceWatermarkInput`
        :param _CopyRightWatermark: CopyRight Watermark.
        :type CopyRightWatermark: :class:`tencentcloud.vod.v20180717.models.CopyRightWatermarkInput`
        :param _SubtitleSet: List of subtitle IDs (maximum: 16)
        :type SubtitleSet: list of str
        """
        self._Definition = None
        self._WatermarkSet = None
        self._TraceWatermark = None
        self._CopyRightWatermark = None
        self._SubtitleSet = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet

    @property
    def TraceWatermark(self):
        return self._TraceWatermark

    @TraceWatermark.setter
    def TraceWatermark(self, TraceWatermark):
        self._TraceWatermark = TraceWatermark

    @property
    def CopyRightWatermark(self):
        return self._CopyRightWatermark

    @CopyRightWatermark.setter
    def CopyRightWatermark(self, CopyRightWatermark):
        self._CopyRightWatermark = CopyRightWatermark

    @property
    def SubtitleSet(self):
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        if params.get("TraceWatermark") is not None:
            self._TraceWatermark = TraceWatermarkInput()
            self._TraceWatermark._deserialize(params.get("TraceWatermark"))
        if params.get("CopyRightWatermark") is not None:
            self._CopyRightWatermark = CopyRightWatermarkInput()
            self._CopyRightWatermark._deserialize(params.get("CopyRightWatermark"))
        self._SubtitleSet = params.get("SubtitleSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveDynamicStreamingTemplate(AbstractModel):
    """Details of a transcoding to adaptive bitrate streaming template

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a transcoding to adaptive bitrate streaming template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _Name: Name of a transcoding to adaptive bitrate streaming template.
        :type Name: str
        :param _Comment: Description of a transcoding to adaptive bitrate streaming template.
        :type Comment: str
        :param _Format: Adaptive bitstream format. Valid value:
<li>HLS.</li>
        :type Format: str
        :param _DrmType: The DRM type. Valid values:
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
If this parameter is an empty string, it indicates that the video is not protected by DRM.
        :type DrmType: str
        :param _DrmKeyProvider: The provider of the DRM key. Valid values:
<li>SDMC</li>
<li>VOD</li>
The default is `VOD`.
        :type DrmKeyProvider: str
        :param _StreamInfos: Parameter information of input stream for adaptive bitrate streaming. Up to 10 streams can be input.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type DisableHigherVideoResolution: int
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        :param _SegmentType: The segment type. This parameter is valid only if `Format` is `HLS`.
        :type SegmentType: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Format = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._StreamInfos = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._CreateTime = None
        self._UpdateTime = None
        self._SegmentType = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def DrmType(self):
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Format = params.get("Format")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AdaptiveStreamTemplate(AbstractModel):
    """Adaptive bitrate streaming parameter template

    """

    def __init__(self):
        r"""
        :param _Video: Video parameter information.
        :type Video: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _Audio: Audio parameter information.
        :type Audio: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _RemoveAudio: Whether to remove audio stream. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
        :type RemoveAudio: int
        :param _RemoveVideo: Whether to remove a video stream. Valid values:
<li>0: no</li>
<li>1: yes</li>
        :type RemoveVideo: int
        :param _TEHDConfig: TESHD transcoding parameters
Note: This field may return `null`, indicating that no valid value was found.
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        """
        self._Video = None
        self._Audio = None
        self._RemoveAudio = None
        self._RemoveVideo = None
        self._TEHDConfig = None

    @property
    def Video(self):
        return self._Video

    @Video.setter
    def Video(self, Video):
        self._Video = Video

    @property
    def Audio(self):
        return self._Audio

    @Audio.setter
    def Audio(self, Audio):
        self._Audio = Audio

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig


    def _deserialize(self, params):
        if params.get("Video") is not None:
            self._Video = VideoTemplateInfo()
            self._Video._deserialize(params.get("Video"))
        if params.get("Audio") is not None:
            self._Audio = AudioTemplateInfo()
            self._Audio._deserialize(params.get("Audio"))
        self._RemoveAudio = params.get("RemoveAudio")
        self._RemoveVideo = params.get("RemoveVideo")
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisResult(AbstractModel):
    """Intelligent analysis result

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>Classification: intelligent categorization</li>
<li>Cover: intelligent cover generating</li>
<li>Tag: intelligent tagging</li>
<li>FrameTag: intelligent frame tagging</li>
<li>Highlight: intelligent highlight generating</li>
        :type Type: str
        :param _ClassificationTask: Query result of intelligent categorization task in video content analysis, which is valid if task type is `Classification`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClassificationTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationResult`
        :param _CoverTask: Query result of intelligent cover generating task in video content analysis, which is valid if task type is `Cover`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CoverTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverResult`
        :param _TagTask: Query result of intelligent tagging task in video content analysis, which is valid if task type is `Tag`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagResult`
        :param _FrameTagTask: Query result of intelligent frame-specific tagging task in video content analysis, which is valid if task type is `FrameTag`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FrameTagTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagResult`
        :param _HighlightTask: Query result of an intelligent highlight generating task in video content analysis, which is valid when task type is `Highlight`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type HighlightTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightResult`
        """
        self._Type = None
        self._ClassificationTask = None
        self._CoverTask = None
        self._TagTask = None
        self._FrameTagTask = None
        self._HighlightTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassificationTask(self):
        return self._ClassificationTask

    @ClassificationTask.setter
    def ClassificationTask(self, ClassificationTask):
        self._ClassificationTask = ClassificationTask

    @property
    def CoverTask(self):
        return self._CoverTask

    @CoverTask.setter
    def CoverTask(self, CoverTask):
        self._CoverTask = CoverTask

    @property
    def TagTask(self):
        return self._TagTask

    @TagTask.setter
    def TagTask(self, TagTask):
        self._TagTask = TagTask

    @property
    def FrameTagTask(self):
        return self._FrameTagTask

    @FrameTagTask.setter
    def FrameTagTask(self, FrameTagTask):
        self._FrameTagTask = FrameTagTask

    @property
    def HighlightTask(self):
        return self._HighlightTask

    @HighlightTask.setter
    def HighlightTask(self, HighlightTask):
        self._HighlightTask = HighlightTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("ClassificationTask") is not None:
            self._ClassificationTask = AiAnalysisTaskClassificationResult()
            self._ClassificationTask._deserialize(params.get("ClassificationTask"))
        if params.get("CoverTask") is not None:
            self._CoverTask = AiAnalysisTaskCoverResult()
            self._CoverTask._deserialize(params.get("CoverTask"))
        if params.get("TagTask") is not None:
            self._TagTask = AiAnalysisTaskTagResult()
            self._TagTask._deserialize(params.get("TagTask"))
        if params.get("FrameTagTask") is not None:
            self._FrameTagTask = AiAnalysisTaskFrameTagResult()
            self._FrameTagTask._deserialize(params.get("FrameTagTask"))
        if params.get("HighlightTask") is not None:
            self._HighlightTask = AiAnalysisTaskHighlightResult()
            self._HighlightTask._deserialize(params.get("HighlightTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationInput(AbstractModel):
    """Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video categorization template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationOutput(AbstractModel):
    """Result information of intelligent categorization

    """

    def __init__(self):
        r"""
        :param _ClassificationSet: List of intelligently generated video categories
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `ClassificationSetFileUrl`.
        :type ClassificationSet: list of MediaAiAnalysisClassificationItem
        :param _ClassificationSetFileUrl: URL to the file for intelligently generated video categories. The file is in JSON format and has the same data structure as `ClassificationSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `ClassificationSetFileUrlExpireTime`.
        :type ClassificationSetFileUrl: str
        :param _ClassificationSetFileUrlExpireTime: Expiration time of the URL to the file for intelligently generated video categories, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type ClassificationSetFileUrlExpireTime: str
        """
        self._ClassificationSet = None
        self._ClassificationSetFileUrl = None
        self._ClassificationSetFileUrlExpireTime = None

    @property
    def ClassificationSet(self):
        return self._ClassificationSet

    @ClassificationSet.setter
    def ClassificationSet(self, ClassificationSet):
        self._ClassificationSet = ClassificationSet

    @property
    def ClassificationSetFileUrl(self):
        return self._ClassificationSetFileUrl

    @ClassificationSetFileUrl.setter
    def ClassificationSetFileUrl(self, ClassificationSetFileUrl):
        self._ClassificationSetFileUrl = ClassificationSetFileUrl

    @property
    def ClassificationSetFileUrlExpireTime(self):
        return self._ClassificationSetFileUrlExpireTime

    @ClassificationSetFileUrlExpireTime.setter
    def ClassificationSetFileUrlExpireTime(self, ClassificationSetFileUrlExpireTime):
        self._ClassificationSetFileUrlExpireTime = ClassificationSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ClassificationSet") is not None:
            self._ClassificationSet = []
            for item in params.get("ClassificationSet"):
                obj = MediaAiAnalysisClassificationItem()
                obj._deserialize(item)
                self._ClassificationSet.append(obj)
        self._ClassificationSetFileUrl = params.get("ClassificationSetFileUrl")
        self._ClassificationSetFileUrlExpireTime = params.get("ClassificationSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskClassificationResult(AbstractModel):
    """Result type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent categorization task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationInput`
        :param _Output: Output of intelligent categorization task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskClassificationOutput`
        :param _Progress: The progress of an intelligent categorization task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the intelligent classification task started to be executed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the intelligent classification task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskClassificationInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskClassificationOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverInput(AbstractModel):
    """Input type of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video cover generating template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverOutput(AbstractModel):
    """Result information of intelligent cover generating

    """

    def __init__(self):
        r"""
        :param _CoverSet: List of intelligently generated thumbnails
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `CoverSetFileUrl`.
        :type CoverSet: list of MediaAiAnalysisCoverItem
        :param _CoverSetFileUrl: URL to the file for intelligently generated thumbnails. The file is in JSON format and has the same data structure as `CoverSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `CoverSetFileUrlExpireTime`.
        :type CoverSetFileUrl: str
        :param _CoverSetFileUrlExpireTime: Expiration time of the URL to the file for intelligently generated thumbnails, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type CoverSetFileUrlExpireTime: str
        """
        self._CoverSet = None
        self._CoverSetFileUrl = None
        self._CoverSetFileUrlExpireTime = None

    @property
    def CoverSet(self):
        return self._CoverSet

    @CoverSet.setter
    def CoverSet(self, CoverSet):
        self._CoverSet = CoverSet

    @property
    def CoverSetFileUrl(self):
        return self._CoverSetFileUrl

    @CoverSetFileUrl.setter
    def CoverSetFileUrl(self, CoverSetFileUrl):
        self._CoverSetFileUrl = CoverSetFileUrl

    @property
    def CoverSetFileUrlExpireTime(self):
        return self._CoverSetFileUrlExpireTime

    @CoverSetFileUrlExpireTime.setter
    def CoverSetFileUrlExpireTime(self, CoverSetFileUrlExpireTime):
        self._CoverSetFileUrlExpireTime = CoverSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("CoverSet") is not None:
            self._CoverSet = []
            for item in params.get("CoverSet"):
                obj = MediaAiAnalysisCoverItem()
                obj._deserialize(item)
                self._CoverSet.append(obj)
        self._CoverSetFileUrl = params.get("CoverSetFileUrl")
        self._CoverSetFileUrlExpireTime = params.get("CoverSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskCoverResult(AbstractModel):
    """Result type of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent cover generating task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverInput`
        :param _Output: Output of intelligent cover generating task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskCoverOutput`
        :param _Progress: The progress of an intelligent thumbnail generation task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the smart cover task started to be executed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the smart cover task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskCoverInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskCoverOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagInput(AbstractModel):
    """Input type of intelligent frame-specific tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent frame-specific video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagOutput(AbstractModel):
    """Result information of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of frame-specific video tags
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaAiAnalysisFrameTagSegmentItem
        :param _SegmentSetFileUrl: URL to the file for frame-specific video tags. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for frame-specific video tags, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaAiAnalysisFrameTagSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskFrameTagResult(AbstractModel):
    """Result type of intelligent frame-specific tagging

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent frame-specific tagging task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagInput`
        :param _Output: Output of intelligent frame-specific tagging task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskFrameTagOutput`
        :param _Progress: The progress of an intelligent labeling by frame task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the intelligent frame labeling task started execution, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the intelligent frame labeling task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskFrameTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskFrameTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightInput(AbstractModel):
    """Input type of an intelligent highlight generating task

    """

    def __init__(self):
        r"""
        :param _Definition: ID of an intelligent highlight generating template.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightOutput(AbstractModel):
    """Information of the intelligent highlight generating result

    """

    def __init__(self):
        r"""
        :param _HighlightSet: List of intelligently generated highlights
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `HighlightSetFileUrl`.
        :type HighlightSet: list of MediaAiAnalysisHighlightItem
        :param _HighlightSetFileUrl: URL to the file for intelligently generated highlights. The file is in JSON format and has the same data structure as `HighlightSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `HighlightSetFileUrlExpireTime`.
        :type HighlightSetFileUrl: str
        :param _HighlightSetFileUrlExpireTime: Expiration time of the URL to the file for intelligently generated highlights, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type HighlightSetFileUrlExpireTime: str
        """
        self._HighlightSet = None
        self._HighlightSetFileUrl = None
        self._HighlightSetFileUrlExpireTime = None

    @property
    def HighlightSet(self):
        return self._HighlightSet

    @HighlightSet.setter
    def HighlightSet(self, HighlightSet):
        self._HighlightSet = HighlightSet

    @property
    def HighlightSetFileUrl(self):
        return self._HighlightSetFileUrl

    @HighlightSetFileUrl.setter
    def HighlightSetFileUrl(self, HighlightSetFileUrl):
        self._HighlightSetFileUrl = HighlightSetFileUrl

    @property
    def HighlightSetFileUrlExpireTime(self):
        return self._HighlightSetFileUrlExpireTime

    @HighlightSetFileUrlExpireTime.setter
    def HighlightSetFileUrlExpireTime(self, HighlightSetFileUrlExpireTime):
        self._HighlightSetFileUrlExpireTime = HighlightSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("HighlightSet") is not None:
            self._HighlightSet = []
            for item in params.get("HighlightSet"):
                obj = MediaAiAnalysisHighlightItem()
                obj._deserialize(item)
                self._HighlightSet.append(obj)
        self._HighlightSetFileUrl = params.get("HighlightSetFileUrl")
        self._HighlightSetFileUrlExpireTime = params.get("HighlightSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskHighlightResult(AbstractModel):
    """Result type of an intelligent highlight generating task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for an intelligent highlight generating task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightInput`
        :param _Output: Output of an intelligent highlight generating task.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskHighlightOutput`
        :param _Progress: The progress of an intelligent highlight generation task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the smart highlight task started execution, in [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time the smart highlight task completed, in [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskHighlightInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskHighlightOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskInput(AbstractModel):
    """Input parameter type of AI-based intelligent video analysis

    """

    def __init__(self):
        r"""
        :param _Definition: Video content analysis template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagInput(AbstractModel):
    """Input type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video tagging template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagOutput(AbstractModel):
    """Result information of intelligent tagging

    """

    def __init__(self):
        r"""
        :param _TagSet: List of intelligently generated video tags
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `TagSetFileUrl`.
        :type TagSet: list of MediaAiAnalysisTagItem
        :param _TagSetFileUrl: URL to the file for intelligently generated video tags. The file is in JSON format and has the same data structure as `TagSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `TagSetFileUrlExpireTime`.
        :type TagSetFileUrl: str
        :param _TagSetFileUrlExpireTime: Expiration time of the URL to the file for intelligently generated video tags, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type TagSetFileUrlExpireTime: str
        """
        self._TagSet = None
        self._TagSetFileUrl = None
        self._TagSetFileUrlExpireTime = None

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def TagSetFileUrl(self):
        return self._TagSetFileUrl

    @TagSetFileUrl.setter
    def TagSetFileUrl(self, TagSetFileUrl):
        self._TagSetFileUrl = TagSetFileUrl

    @property
    def TagSetFileUrlExpireTime(self):
        return self._TagSetFileUrlExpireTime

    @TagSetFileUrlExpireTime.setter
    def TagSetFileUrlExpireTime(self, TagSetFileUrlExpireTime):
        self._TagSetFileUrlExpireTime = TagSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("TagSet") is not None:
            self._TagSet = []
            for item in params.get("TagSet"):
                obj = MediaAiAnalysisTagItem()
                obj._deserialize(item)
                self._TagSet.append(obj)
        self._TagSetFileUrl = params.get("TagSetFileUrl")
        self._TagSetFileUrlExpireTime = params.get("TagSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiAnalysisTaskTagResult(AbstractModel):
    """Result type of intelligent tagging task

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input of intelligent tagging task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagInput`
        :param _Output: Output of intelligent tagging task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskTagOutput`
        :param _Progress: The progress of an intelligent labeling task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the smart label task started executing, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the smart label task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiAnalysisTaskTagInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiAnalysisTaskTagOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewResult(AbstractModel):
    """Intelligent recognition result

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>`Porn`: porn information recognition in images</li>
<li>`Terrorism`: terrorism information recognition in images</li>
<li>`Political`: politically sensitive information recognition in images</li>
<li>`Porn.Asr`: ASR-based porn information recognition in speech</li>
<li>`Porn.Ocr`: OCR-based porn information recognition in text</li>
<li>`Political.Asr`: ASR-based politically sensitive information recognition in speech</li>
<li>`Political.Ocr`: OCR-based politically sensitive information recognition in text</li>
<li>`Terrorism.Ocr`: OCR-based terrorism information recognition in text</li>
<li>`Prohibited.Asr`: ASR-based prohibited information recognition in speech</li>
<li>`Prohibited.Ocr`: OCR-based prohibited information recognition in text</li>
        :type Type: str
        :param _PornTask: Result for intelligent recognition of pornographic content in images. This parameter is valid when `Type` is `Porn`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PornTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornResult`
        :param _TerrorismTask: Result for intelligent recognition of terrorism content in images. This parameter is valid when `Type` is `Terrorism`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type TerrorismTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismResult`
        :param _PoliticalTask: Result for intelligent recognition of politically sensitive content in images. This parameter is valid when `Type` is `Political`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PoliticalTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalResult`
        :param _PornAsrTask: Result for ASR-based recognition of pornographic content. This parameter is valid when `Type` is `Porn.Asr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PornAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornAsrResult`
        :param _PornOcrTask: Result for OCR-based recognition of pornographic content. This parameter is valid when `Type` is `Porn.Ocr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PornOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPornOcrResult`
        :param _PoliticalAsrTask: Result for ASR-based recognition of politically sensitive content. This parameter is valid when `Type` is `Political.Asr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PoliticalAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalAsrResult`
        :param _PoliticalOcrTask: Result for OCR-based recognition of politically sensitive content. This parameter is valid when `Type` is `Political.Ocr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type PoliticalOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskPoliticalOcrResult`
        :param _TerrorismOcrTask: Result for OCR-based recognition of terrorism content. This parameter is valid when `Type` is `Terrorism.Ocr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type TerrorismOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskTerrorismOcrResult`
        :param _ProhibitedOcrTask: Result for OCR-based recognition of banned content. This parameter is valid when `Type` is `Prohibited.Ocr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type ProhibitedOcrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedOcrResult`
        :param _ProhibitedAsrTask: Result for ASR-based recognition of banned content. This parameter is valid when `Type` is `Prohibited.Asr`.
Note: This field may return `null`, indicating that no valid value can be found.
        :type ProhibitedAsrTask: :class:`tencentcloud.vod.v20180717.models.AiReviewTaskProhibitedAsrResult`
        """
        self._Type = None
        self._PornTask = None
        self._TerrorismTask = None
        self._PoliticalTask = None
        self._PornAsrTask = None
        self._PornOcrTask = None
        self._PoliticalAsrTask = None
        self._PoliticalOcrTask = None
        self._TerrorismOcrTask = None
        self._ProhibitedOcrTask = None
        self._ProhibitedAsrTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornTask(self):
        return self._PornTask

    @PornTask.setter
    def PornTask(self, PornTask):
        self._PornTask = PornTask

    @property
    def TerrorismTask(self):
        return self._TerrorismTask

    @TerrorismTask.setter
    def TerrorismTask(self, TerrorismTask):
        self._TerrorismTask = TerrorismTask

    @property
    def PoliticalTask(self):
        return self._PoliticalTask

    @PoliticalTask.setter
    def PoliticalTask(self, PoliticalTask):
        self._PoliticalTask = PoliticalTask

    @property
    def PornAsrTask(self):
        return self._PornAsrTask

    @PornAsrTask.setter
    def PornAsrTask(self, PornAsrTask):
        self._PornAsrTask = PornAsrTask

    @property
    def PornOcrTask(self):
        return self._PornOcrTask

    @PornOcrTask.setter
    def PornOcrTask(self, PornOcrTask):
        self._PornOcrTask = PornOcrTask

    @property
    def PoliticalAsrTask(self):
        return self._PoliticalAsrTask

    @PoliticalAsrTask.setter
    def PoliticalAsrTask(self, PoliticalAsrTask):
        self._PoliticalAsrTask = PoliticalAsrTask

    @property
    def PoliticalOcrTask(self):
        return self._PoliticalOcrTask

    @PoliticalOcrTask.setter
    def PoliticalOcrTask(self, PoliticalOcrTask):
        self._PoliticalOcrTask = PoliticalOcrTask

    @property
    def TerrorismOcrTask(self):
        return self._TerrorismOcrTask

    @TerrorismOcrTask.setter
    def TerrorismOcrTask(self, TerrorismOcrTask):
        self._TerrorismOcrTask = TerrorismOcrTask

    @property
    def ProhibitedOcrTask(self):
        return self._ProhibitedOcrTask

    @ProhibitedOcrTask.setter
    def ProhibitedOcrTask(self, ProhibitedOcrTask):
        self._ProhibitedOcrTask = ProhibitedOcrTask

    @property
    def ProhibitedAsrTask(self):
        return self._ProhibitedAsrTask

    @ProhibitedAsrTask.setter
    def ProhibitedAsrTask(self, ProhibitedAsrTask):
        self._ProhibitedAsrTask = ProhibitedAsrTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornTask") is not None:
            self._PornTask = AiReviewTaskPornResult()
            self._PornTask._deserialize(params.get("PornTask"))
        if params.get("TerrorismTask") is not None:
            self._TerrorismTask = AiReviewTaskTerrorismResult()
            self._TerrorismTask._deserialize(params.get("TerrorismTask"))
        if params.get("PoliticalTask") is not None:
            self._PoliticalTask = AiReviewTaskPoliticalResult()
            self._PoliticalTask._deserialize(params.get("PoliticalTask"))
        if params.get("PornAsrTask") is not None:
            self._PornAsrTask = AiReviewTaskPornAsrResult()
            self._PornAsrTask._deserialize(params.get("PornAsrTask"))
        if params.get("PornOcrTask") is not None:
            self._PornOcrTask = AiReviewTaskPornOcrResult()
            self._PornOcrTask._deserialize(params.get("PornOcrTask"))
        if params.get("PoliticalAsrTask") is not None:
            self._PoliticalAsrTask = AiReviewTaskPoliticalAsrResult()
            self._PoliticalAsrTask._deserialize(params.get("PoliticalAsrTask"))
        if params.get("PoliticalOcrTask") is not None:
            self._PoliticalOcrTask = AiReviewTaskPoliticalOcrResult()
            self._PoliticalOcrTask._deserialize(params.get("PoliticalOcrTask"))
        if params.get("TerrorismOcrTask") is not None:
            self._TerrorismOcrTask = AiReviewTaskTerrorismOcrResult()
            self._TerrorismOcrTask._deserialize(params.get("TerrorismOcrTask"))
        if params.get("ProhibitedOcrTask") is not None:
            self._ProhibitedOcrTask = AiReviewTaskProhibitedOcrResult()
            self._ProhibitedOcrTask._deserialize(params.get("ProhibitedOcrTask"))
        if params.get("ProhibitedAsrTask") is not None:
            self._ProhibitedAsrTask = AiReviewTaskProhibitedAsrResult()
            self._ProhibitedAsrTask._deserialize(params.get("ProhibitedAsrTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiContentReviewTaskInput(AbstractModel):
    """Type of intelligent recognition task

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent recognition template ID
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionResult(AbstractModel):
    """Intelligent recognition result.

    """

    def __init__(self):
        r"""
        :param _Type: Task type. Valid values:
<li>FaceRecognition: face recognition,</li>
<li>AsrWordsRecognition: speech keyword recognition,</li>
<li>OcrWordsRecognition: text keyword recognition,</li>
<li>AsrFullTextRecognition: full speech recognition,</li>
<li>OcrFullTextRecognition: full text recognition,</li>
<li>HeadTailRecognition: video opening and ending credits recognition,</li>
<li>ObjectRecognition: object recognition.</li>
        :type Type: str
        :param _HeadTailTask: Video opening and ending credits recognition result, which is valid when `Type` is
 `HeadTailRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type HeadTailTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResult`
        :param _SegmentTask: Video splitting recognition result, which is valid when `Type` is
 `SegmentRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SegmentTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResult`
        :param _FaceTask: Face recognition result, which is valid when `Type` is 
 `FaceRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FaceTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResult`
        :param _AsrWordsTask: Speech keyword recognition result, which is valid when `Type` is
 `AsrWordsRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AsrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResult`
        :param _AsrFullTextTask: Full speech recognition result, which is valid when `Type` is
 `AsrFullTextRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AsrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResult`
        :param _OcrWordsTask: Text keyword recognition result, which is valid when `Type` is
 `OcrWordsRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OcrWordsTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResult`
        :param _OcrFullTextTask: Full text recognition result, which is valid when `Type` is
 `OcrFullTextRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OcrFullTextTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResult`
        :param _ObjectTask: Object recognition result, which is valid when `Type` is
 `ObjectRecognition`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ObjectTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResult`
        """
        self._Type = None
        self._HeadTailTask = None
        self._SegmentTask = None
        self._FaceTask = None
        self._AsrWordsTask = None
        self._AsrFullTextTask = None
        self._OcrWordsTask = None
        self._OcrFullTextTask = None
        self._ObjectTask = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HeadTailTask(self):
        return self._HeadTailTask

    @HeadTailTask.setter
    def HeadTailTask(self, HeadTailTask):
        self._HeadTailTask = HeadTailTask

    @property
    def SegmentTask(self):
        return self._SegmentTask

    @SegmentTask.setter
    def SegmentTask(self, SegmentTask):
        self._SegmentTask = SegmentTask

    @property
    def FaceTask(self):
        return self._FaceTask

    @FaceTask.setter
    def FaceTask(self, FaceTask):
        self._FaceTask = FaceTask

    @property
    def AsrWordsTask(self):
        return self._AsrWordsTask

    @AsrWordsTask.setter
    def AsrWordsTask(self, AsrWordsTask):
        self._AsrWordsTask = AsrWordsTask

    @property
    def AsrFullTextTask(self):
        return self._AsrFullTextTask

    @AsrFullTextTask.setter
    def AsrFullTextTask(self, AsrFullTextTask):
        self._AsrFullTextTask = AsrFullTextTask

    @property
    def OcrWordsTask(self):
        return self._OcrWordsTask

    @OcrWordsTask.setter
    def OcrWordsTask(self, OcrWordsTask):
        self._OcrWordsTask = OcrWordsTask

    @property
    def OcrFullTextTask(self):
        return self._OcrFullTextTask

    @OcrFullTextTask.setter
    def OcrFullTextTask(self, OcrFullTextTask):
        self._OcrFullTextTask = OcrFullTextTask

    @property
    def ObjectTask(self):
        return self._ObjectTask

    @ObjectTask.setter
    def ObjectTask(self, ObjectTask):
        self._ObjectTask = ObjectTask


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("HeadTailTask") is not None:
            self._HeadTailTask = AiRecognitionTaskHeadTailResult()
            self._HeadTailTask._deserialize(params.get("HeadTailTask"))
        if params.get("SegmentTask") is not None:
            self._SegmentTask = AiRecognitionTaskSegmentResult()
            self._SegmentTask._deserialize(params.get("SegmentTask"))
        if params.get("FaceTask") is not None:
            self._FaceTask = AiRecognitionTaskFaceResult()
            self._FaceTask._deserialize(params.get("FaceTask"))
        if params.get("AsrWordsTask") is not None:
            self._AsrWordsTask = AiRecognitionTaskAsrWordsResult()
            self._AsrWordsTask._deserialize(params.get("AsrWordsTask"))
        if params.get("AsrFullTextTask") is not None:
            self._AsrFullTextTask = AiRecognitionTaskAsrFullTextResult()
            self._AsrFullTextTask._deserialize(params.get("AsrFullTextTask"))
        if params.get("OcrWordsTask") is not None:
            self._OcrWordsTask = AiRecognitionTaskOcrWordsResult()
            self._OcrWordsTask._deserialize(params.get("OcrWordsTask"))
        if params.get("OcrFullTextTask") is not None:
            self._OcrFullTextTask = AiRecognitionTaskOcrFullTextResult()
            self._OcrFullTextTask._deserialize(params.get("OcrFullTextTask"))
        if params.get("ObjectTask") is not None:
            self._ObjectTask = AiRecognitionTaskObjectResult()
            self._ObjectTask._deserialize(params.get("ObjectTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResult(AbstractModel):
    """Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of full speech recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultInput`
        :param _Output: Output information of full speech recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrFullTextResultOutput`
        :param _Progress: Speech full-text recognition task progress, value range [0-100].
        :type Progress: int
        :param _BeginProcessTime: The time when the full-text speech recognition task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the speech full-text recognition task was completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultInput(AbstractModel):
    """Input of full speech recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full speech recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutput(AbstractModel):
    """Full speech recognition result.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of full-text speech recognition segments
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type SegmentSet: list of AiRecognitionTaskAsrFullTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file of the list for full-text speech recognition segments. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: The expiration time of the URLs of full-text speech recognition segments in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format).
        :type SegmentSetFileUrlExpireTime: str
        :param _SubtitleSet: The subtitle files generated, whose format is determined by the `SubtitleFormats` parameter of [AsrFullTextConfigureInfo](https://intl.cloud.tencent.com/document/api/266/31773?from_cn_redirect=1#AsrFullTextConfigureInfo).
        :type SubtitleSet: list of AiRecognitionTaskAsrFullTextResultOutputSubtitleItem
        :param _SubtitleUrl: The URLs of the subtitle files generated, whose format is determined by the `SubtitleFormats` parameter of [AsrFullTextConfigureInfo](https://intl.cloud.tencent.com/document/api/266/31773?from_cn_redirect=1#AsrFullTextConfigureInfo).
        :type SubtitleUrl: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None
        self._SubtitleSet = None
        self._SubtitleUrl = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime

    @property
    def SubtitleSet(self):
        return self._SubtitleSet

    @SubtitleSet.setter
    def SubtitleSet(self, SubtitleSet):
        self._SubtitleSet = SubtitleSet

    @property
    def SubtitleUrl(self):
        return self._SubtitleUrl

    @SubtitleUrl.setter
    def SubtitleUrl(self, SubtitleUrl):
        self._SubtitleUrl = SubtitleUrl


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        if params.get("SubtitleSet") is not None:
            self._SubtitleSet = []
            for item in params.get("SubtitleSet"):
                obj = AiRecognitionTaskAsrFullTextResultOutputSubtitleItem()
                obj._deserialize(item)
                self._SubtitleSet.append(obj)
        self._SubtitleUrl = params.get("SubtitleUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextResultOutputSubtitleItem(AbstractModel):
    """The subtitle information.

    """

    def __init__(self):
        r"""
        :param _Format: The format of the subtitle files. Valid values:
<li>vtt</li>
<li>srt</li>
        :type Format: str
        :param _Url: The URL of a subtitle file.
        :type Url: str
        """
        self._Format = None
        self._Url = None

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Format = params.get("Format")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrFullTextSegmentItem(AbstractModel):
    """Full speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Text: Recognized text.
        :type Text: str
        """
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResult(AbstractModel):
    """Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of speech keyword recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultInput`
        :param _Output: Output information of speech keyword recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskAsrWordsResultOutput`
        :param _Progress: The progress of a speech keyword recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the speech keyword recognition task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the speech keyword recognition task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskAsrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskAsrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultInput(AbstractModel):
    """Input of speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Speech keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultItem(AbstractModel):
    """Speech keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Speech keyword.
        :type Word: str
        :param _SegmentSet: List of time segments that contain the speech keyword.
        :type SegmentSet: list of AiRecognitionTaskAsrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskAsrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsResultOutput(AbstractModel):
    """Output of speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Speech keyword recognition result set
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type ResultSet: list of AiRecognitionTaskAsrWordsResultItem
        :param _ResultSetFileUrl: URL to the file of the speech keyword recognition result set. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: Expiration time of the URL to the file of the speech keyword recognition result set, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskAsrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskAsrWordsSegmentItem(AbstractModel):
    """Speech recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResult(AbstractModel):
    """Face recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of face recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultInput`
        :param _Output: Output information of face recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskFaceResultOutput`
        :param _Progress: The progress of a face recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the face recognition task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the face recognition task was completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskFaceResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskFaceResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultInput(AbstractModel):
    """Face recognition input.

    """

    def __init__(self):
        r"""
        :param _Definition: Face recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultItem(AbstractModel):
    """Face recognition result

    """

    def __init__(self):
        r"""
        :param _Id: Unique ID of figure.
        :type Id: str
        :param _Type: Figure library type, indicating to which figure library the recognized figure belongs:
<li>Default: default figure library;</li>
<li>UserDefine: custom figure library.</li>
        :type Type: str
        :param _Name: Figure name.
        :type Name: str
        :param _SegmentSet: Result set of segments that contain a figure.
        :type SegmentSet: list of AiRecognitionTaskFaceSegmentItem
        """
        self._Id = None
        self._Type = None
        self._Name = None
        self._SegmentSet = None

    @property
    def Id(self):
        return self._Id

    @Id.setter
    def Id(self, Id):
        self._Id = Id

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Id = params.get("Id")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskFaceSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceResultOutput(AbstractModel):
    """Output of intelligent face recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Intelligent face recognition result set
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type ResultSet: list of AiRecognitionTaskFaceResultItem
        :param _ResultSetFileUrl: URL to the file of the intelligent face recognition result set. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: Expiration time of the URL to the file of the intelligent face recognition result set, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskFaceResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskFaceSegmentItem(AbstractModel):
    """Face recognition result segment

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResult(AbstractModel):
    """Video opening and ending credits recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of video opening and ending credits recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultInput`
        :param _Output: Output information of video opening and ending credits recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskHeadTailResultOutput`
        :param _Progress: The progress of an opening/closing segment recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the video start and end recognition task starts, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the video start and end recognition task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskHeadTailResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskHeadTailResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultInput(AbstractModel):
    """Input of video opening and ending credits recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Video opening and ending credits recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskHeadTailResultOutput(AbstractModel):
    """Output of video opening and ending credits recognition.

    """

    def __init__(self):
        r"""
        :param _HeadConfidence: Confidence of recognized opening credits. Value range: 0-100.
        :type HeadConfidence: float
        :param _HeadTimeOffset: End time point of video opening credits in seconds.
        :type HeadTimeOffset: float
        :param _TailConfidence: Confidence of recognized closing credits. Value range: 0-100.
        :type TailConfidence: float
        :param _TailTimeOffset: Start time point of video closing credits in seconds.
        :type TailTimeOffset: float
        """
        self._HeadConfidence = None
        self._HeadTimeOffset = None
        self._TailConfidence = None
        self._TailTimeOffset = None

    @property
    def HeadConfidence(self):
        return self._HeadConfidence

    @HeadConfidence.setter
    def HeadConfidence(self, HeadConfidence):
        self._HeadConfidence = HeadConfidence

    @property
    def HeadTimeOffset(self):
        return self._HeadTimeOffset

    @HeadTimeOffset.setter
    def HeadTimeOffset(self, HeadTimeOffset):
        self._HeadTimeOffset = HeadTimeOffset

    @property
    def TailConfidence(self):
        return self._TailConfidence

    @TailConfidence.setter
    def TailConfidence(self, TailConfidence):
        self._TailConfidence = TailConfidence

    @property
    def TailTimeOffset(self):
        return self._TailTimeOffset

    @TailTimeOffset.setter
    def TailTimeOffset(self, TailTimeOffset):
        self._TailTimeOffset = TailTimeOffset


    def _deserialize(self, params):
        self._HeadConfidence = params.get("HeadConfidence")
        self._HeadTimeOffset = params.get("HeadTimeOffset")
        self._TailConfidence = params.get("TailConfidence")
        self._TailTimeOffset = params.get("TailTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskInput(AbstractModel):
    """Input parameter type of video content recognition

    """

    def __init__(self):
        r"""
        :param _Definition: Intelligent video recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResult(AbstractModel):
    """Object recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of object recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultInput`
        :param _Output: Output information of object recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskObjectResultOutput`
        :param _Progress: The progress of an object recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the object recognition task started execution, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the object recognition task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskObjectResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskObjectResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultInput(AbstractModel):
    """Input type of object recognition task.

    """

    def __init__(self):
        r"""
        :param _Definition: Object recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultItem(AbstractModel):
    """Single-object recognition result.

    """

    def __init__(self):
        r"""
        :param _Name: Name of recognized object.
        :type Name: str
        :param _SegmentSet: List of segments that contain an object.
        :type SegmentSet: list of AiRecognitionTaskObjectSeqmentItem
        :param _RecognitionSegmentSet: List of fragments in which the object appears.
        :type RecognitionSegmentSet: list of AiRecognitionTaskObjectSegmentItem
        """
        self._Name = None
        self._SegmentSet = None
        self._RecognitionSegmentSet = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SegmentSet(self):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        warnings.warn("parameter `SegmentSet` is deprecated", DeprecationWarning) 

        self._SegmentSet = SegmentSet

    @property
    def RecognitionSegmentSet(self):
        return self._RecognitionSegmentSet

    @RecognitionSegmentSet.setter
    def RecognitionSegmentSet(self, RecognitionSegmentSet):
        self._RecognitionSegmentSet = RecognitionSegmentSet


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskObjectSeqmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        if params.get("RecognitionSegmentSet") is not None:
            self._RecognitionSegmentSet = []
            for item in params.get("RecognitionSegmentSet"):
                obj = AiRecognitionTaskObjectSegmentItem()
                obj._deserialize(item)
                self._RecognitionSegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectResultOutput(AbstractModel):
    """Output of intelligent object recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Intelligent object recognition result set
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type ResultSet: list of AiRecognitionTaskObjectResultItem
        :param _ResultSetFileUrl: URL to the file of the object recognition result set. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: Expiration time of the URL to the object recognition result set, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskObjectResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSegmentItem(AbstractModel):
    """Object recognition result fragment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Identifies the offset time of the beginning of the segment, in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: Offset time to identify the end of the segment, in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Identify segment confidence. Value: 0~100.
        :type Confidence: float
        :param _AreaCoordSet: The area coordinates of the recognition result. The array contains 4 elements [x1, y1, x2, y2], which in turn represent the horizontal and vertical coordinates of the upper left point and lower right point of the area.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskObjectSeqmentItem(AbstractModel):
    """Object recognition result segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResult(AbstractModel):
    """Full text recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of full text recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultInput`
        :param _Output: Output information of full text recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrFullTextResultOutput`
        :param _Progress: The progress of a full text recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the full text recognition task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the full text recognition task was completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrFullTextResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrFullTextResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultInput(AbstractModel):
    """Input of full text recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Full text recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextResultOutput(AbstractModel):
    """Output of full text recognition.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: Full-text recognition result set
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type SegmentSet: list of AiRecognitionTaskOcrFullTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file of the full-text recognition result set. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file of the full-text recognition result set, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentItem(AbstractModel):
    """Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _TextSet: Recognition segment result set.
        :type TextSet: list of AiRecognitionTaskOcrFullTextSegmentTextItem
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._TextSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def TextSet(self):
        return self._TextSet

    @TextSet.setter
    def TextSet(self, TextSet):
        self._TextSet = TextSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("TextSet") is not None:
            self._TextSet = []
            for item in params.get("TextSet"):
                obj = AiRecognitionTaskOcrFullTextSegmentTextItem()
                obj._deserialize(item)
                self._TextSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrFullTextSegmentTextItem(AbstractModel):
    """Full text recognition segment.

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        :param _Text: Recognized text.
        :type Text: str
        """
        self._Confidence = None
        self._AreaCoordSet = None
        self._Text = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResult(AbstractModel):
    """Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of text keyword recognition task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultInput`
        :param _Output: Output information of text keyword recognition task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskOcrWordsResultOutput`
        :param _Progress: The progress of a text keyword recognition task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the text keyword recognition task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the text keyword recognition task is completed, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskOcrWordsResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskOcrWordsResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultInput(AbstractModel):
    """Input of text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Definition: Text keyword recognition template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultItem(AbstractModel):
    """Text keyword recognition result.

    """

    def __init__(self):
        r"""
        :param _Word: Text keyword.
        :type Word: str
        :param _SegmentSet: List of segments that contain a text keyword.
        :type SegmentSet: list of AiRecognitionTaskOcrWordsSegmentItem
        """
        self._Word = None
        self._SegmentSet = None

    @property
    def Word(self):
        return self._Word

    @Word.setter
    def Word(self, Word):
        self._Word = Word

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet


    def _deserialize(self, params):
        self._Word = params.get("Word")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskOcrWordsSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsResultOutput(AbstractModel):
    """Output of text keyword recognition.

    """

    def __init__(self):
        r"""
        :param _ResultSet: Text keyword recognition result set
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type ResultSet: list of AiRecognitionTaskOcrWordsResultItem
        :param _ResultSetFileUrl: URL to the file of the text keyword recognition result set. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type ResultSetFileUrl: str
        :param _ResultSetFileUrlExpireTime: Expiration time of the URL to the file of the text keyword recognition result set, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type ResultSetFileUrlExpireTime: str
        """
        self._ResultSet = None
        self._ResultSetFileUrl = None
        self._ResultSetFileUrlExpireTime = None

    @property
    def ResultSet(self):
        return self._ResultSet

    @ResultSet.setter
    def ResultSet(self, ResultSet):
        self._ResultSet = ResultSet

    @property
    def ResultSetFileUrl(self):
        return self._ResultSetFileUrl

    @ResultSetFileUrl.setter
    def ResultSetFileUrl(self, ResultSetFileUrl):
        self._ResultSetFileUrl = ResultSetFileUrl

    @property
    def ResultSetFileUrlExpireTime(self):
        return self._ResultSetFileUrlExpireTime

    @ResultSetFileUrlExpireTime.setter
    def ResultSetFileUrlExpireTime(self, ResultSetFileUrlExpireTime):
        self._ResultSetFileUrlExpireTime = ResultSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("ResultSet") is not None:
            self._ResultSet = []
            for item in params.get("ResultSet"):
                obj = AiRecognitionTaskOcrWordsResultItem()
                obj._deserialize(item)
                self._ResultSet.append(obj)
        self._ResultSetFileUrl = params.get("ResultSetFileUrl")
        self._ResultSetFileUrlExpireTime = params.get("ResultSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskOcrWordsSegmentItem(AbstractModel):
    """Text recognition segment.

    """

    def __init__(self):
        r"""
        :param _StartTimeOffset: Start time offset of recognized segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of recognition segment in seconds.
        :type EndTimeOffset: float
        :param _Confidence: Confidence of recognized segment. Value range: 0-100.
        :type Confidence: float
        :param _AreaCoordSet: Zone coordinates of recognition result. The array contains four elements: [x1,y1,x2,y2], i.e., the horizontal and vertical coordinates of the top-left and bottom-right corners.
        :type AreaCoordSet: list of int
        """
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._Confidence = None
        self._AreaCoordSet = None

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._Confidence = params.get("Confidence")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResult(AbstractModel):
    """Video splitting results.

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input information of video splitting task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultInput`
        :param _Output: Output information of video splitting task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskSegmentResultOutput`
        :param _Progress: The progress of a video splitting task. Value range: 0-100.
        :type Progress: int
        :param _BeginProcessTime: The time when the video detachment task started, using [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type BeginProcessTime: str
        :param _FinishTime: The time when the video stripping task is completed is in [ISO date format](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type FinishTime: str
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None
        self._BeginProcessTime = None
        self._FinishTime = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiRecognitionTaskSegmentResultInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiRecognitionTaskSegmentResultOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultInput(AbstractModel):
    """Input of video splitting.

    """

    def __init__(self):
        r"""
        :param _Definition: Video splitting template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentResultOutput(AbstractModel):
    """Output of video splitting.

    """

    def __init__(self):
        r"""
        :param _SegmentSet: List of split video segments
<font color=red>Note</font>: this list displays up to the first 100 results. You can get all the results from the file whose URL is `SegmentSetFileUrl`.
        :type SegmentSet: list of AiRecognitionTaskSegmentSegmentItem
        :param _SegmentSetFileUrl: URL to the file of the list for split video segments. The file format is JSON, and the data structure is the same as `SegmentSet`. The file will be deleted upon the expiration time `SegmentSetFileUrlExpireTime`, instead of being stored permanently.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file of the list for split video segments, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = AiRecognitionTaskSegmentSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiRecognitionTaskSegmentSegmentItem(AbstractModel):
    """Split video segment.

    """

    def __init__(self):
        r"""
        :param _FileId: File ID, which is valid only when a VOD file is processed and the subsegments generated through segmentation are also VOD files.
        :type FileId: str
        :param _SegmentUrl: Split video segment URL.
        :type SegmentUrl: str
        :param _Confidence: Confidence of split segment. Value range: 0-100.
        :type Confidence: float
        :param _StartTimeOffset: Start time offset of split segment in seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of split segment in seconds.
        :type EndTimeOffset: float
        :param _CovImgUrl: Split cover image URL.
        :type CovImgUrl: str
        :param _SpecialInfo: Special field, which should be ignored.
        :type SpecialInfo: str
        """
        self._FileId = None
        self._SegmentUrl = None
        self._Confidence = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._CovImgUrl = None
        self._SpecialInfo = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SegmentUrl(self):
        return self._SegmentUrl

    @SegmentUrl.setter
    def SegmentUrl(self, SegmentUrl):
        self._SegmentUrl = SegmentUrl

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def CovImgUrl(self):
        return self._CovImgUrl

    @CovImgUrl.setter
    def CovImgUrl(self, CovImgUrl):
        self._CovImgUrl = CovImgUrl

    @property
    def SpecialInfo(self):
        return self._SpecialInfo

    @SpecialInfo.setter
    def SpecialInfo(self, SpecialInfo):
        self._SpecialInfo = SpecialInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SegmentUrl = params.get("SegmentUrl")
        self._Confidence = params.get("Confidence")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        self._CovImgUrl = params.get("CovImgUrl")
        self._SpecialInfo = params.get("SpecialInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskInput(AbstractModel):
    """Input parameters for ASR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of politically sensitive content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalAsrTaskOutput(AbstractModel):
    """Output for ASR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the ASR-detected politically sensitive content. Value range: 0-100
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the ASR-detected politically sensitive content. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain ASR-detected politically sensitive content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain ASR-detected politically sensitive content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain ASR-detected politically sensitive content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskInput(AbstractModel):
    """Input parameters for OCR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of politically sensitive content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalOcrTaskOutput(AbstractModel):
    """Output for OCR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the OCR-detected politically sensitive content. Value range: 0-100
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the OCR-detected politically sensitive content. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain OCR-detected politically sensitive content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain OCR-detected politically sensitive content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain OCR-detected politically sensitive content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskInput(AbstractModel):
    """Input parameters for intelligent recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of politically sensitive content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPoliticalTaskOutput(AbstractModel):
    """Output for intelligent recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the detected politically sensitive content. Value range: 0-100
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the detected politically sensitive content
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: Labels for the detected politically sensitive content. The relationship between the values of this parameter and those of the `LabelSet` parameter in [PoliticalImgReviewTemplateInfo](https://intl.cloud.tencent.com/document/api/266/31773?from_cn_redirect=1#PoliticalImgReviewTemplateInfo) is as follows:
violation_photo:
<li>`violation_photo`: banned images</li>
Other values (politician/entertainment/sport/entrepreneur/scholar/celebrity/military):
<li>`politician`: politically sensitive people</li>
        :type Label: str
        :param _SegmentSet: List of video segments that contain detected politically sensitive content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewPoliticalSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain detected politically sensitive content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain politically sensitive content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewPoliticalSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskInput(AbstractModel):
    """Input parameters for ASR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of pornographic content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornAsrTaskOutput(AbstractModel):
    """Output for ASR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the ASR-detected pornographic content
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the ASR-detected pornographic content
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain ASR-detected pornographic content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain ASR-detected pornographic content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain ASR-detected pornographic content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskInput(AbstractModel):
    """Input parameters for OCR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of pornographic content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornOcrTaskOutput(AbstractModel):
    """Output for OCR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the OCR-detected pornographic content
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the OCR-detected pornographic content
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain OCR-detected pornographic content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain OCR-detected pornographic content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain OCR-detected pornographic content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskInput(AbstractModel):
    """Input parameters for intelligent recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of pornographic content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewPornTaskOutput(AbstractModel):
    """Output for intelligent recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the detected pornographic content. Value range: 0-100
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the detected pornographic content. Valid values:
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _Label: Labels for the detected pornographic content. Valid values:
<li>porn</li>
<li>sexy</li>
<li>vulgar</li>
<li>intimacy</li>
        :type Label: str
        :param _SegmentSet: List of video segments that contain detected pornographic content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain detected pornographic content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain detected pornographic content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskInput(AbstractModel):
    """Input parameters for ASR-based recognition of banned content

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedAsrTaskOutput(AbstractModel):
    """ASR-detected prohibited information in speech

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of ASR-detected prohibited information in speech between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for ASR-detected prohibited information in speech. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain ASR-detected prohibited information
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewAsrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain ASR-detected prohibited information. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain ASR-detected prohibited information, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewAsrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskInput(AbstractModel):
    """Input parameters for OCR-based recognition of banned content

    """

    def __init__(self):
        r"""
        :param _Definition: Prohibited information detection template ID.
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewProhibitedOcrTaskOutput(AbstractModel):
    """OCR-detected prohibited information in text

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of OCR-detected prohibited information in text between 0 and 100.
        :type Confidence: float
        :param _Suggestion: Suggestion for OCR-detected prohibited information in text. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain OCR-detected prohibited information
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain OCR-detected prohibited information. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL for video segments that contain OCR-detected prohibited information, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalAsrResult(AbstractModel):
    """Result for ASR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for ASR-based recognition of politically sensitive content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskInput`
        :param _Output: Output for ASR-based recognition of politically sensitive content
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalAsrTaskOutput`
        :param _Progress: The progress of an ASR-based moderation task (politically sensitive content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalOcrResult(AbstractModel):
    """Result for OCR-based recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for OCR-based recognition of politically sensitive content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskInput`
        :param _Output: Output for OCR-based recognition of politically sensitive content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalOcrTaskOutput`
        :param _Progress: Audio and video review OCR text involves the task progress of inappropriate information, the value range is [0-100].
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPoliticalResult(AbstractModel):
    """Result for intelligent recognition of politically sensitive content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for intelligent recognition of politically sensitive content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskInput`
        :param _Output: Output for intelligent recognition of politically sensitive content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPoliticalTaskOutput`
        :param _Progress: The progress of a moderation task (politically sensitive content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPoliticalTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPoliticalTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornAsrResult(AbstractModel):
    """Result for ASR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for ASR-based recognition of pornographic content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskInput`
        :param _Output: Output for ASR-based recognition of pornographic content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornAsrTaskOutput`
        :param _Progress: The progress of an ASR-based moderation task (pornographic content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornOcrResult(AbstractModel):
    """Result for OCR-based recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for OCR-based recognition of pornographic content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskInput`
        :param _Output: Output for OCR-based recognition of pornographic content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornOcrTaskOutput`
        :param _Progress: The progress of an OCR-based moderation task (pornographic content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskPornResult(AbstractModel):
    """Result for intelligent recognition of pornographic content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for intelligent recognition of pornographic content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskInput`
        :param _Output: Output for intelligent recognition of pornographic content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewPornTaskOutput`
        :param _Progress: The progress of a moderation task (pornographic content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewPornTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewPornTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedAsrResult(AbstractModel):
    """Result for ASR-based recognition of banned content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for ASR-based recognition of banned content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskInput`
        :param _Output: Output for ASR-based recognition of banned content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedAsrTaskOutput`
        :param _Progress: The progress of an ASR-based moderation task (banned content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedAsrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedAsrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskProhibitedOcrResult(AbstractModel):
    """Result for OCR-based recognition of banned content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for OCR-based recognition of banned content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskInput`
        :param _Output: Output for OCR-based recognition of banned content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewProhibitedOcrTaskOutput`
        :param _Progress: The progress of an OCR-based moderation task (banned content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewProhibitedOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewProhibitedOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismOcrResult(AbstractModel):
    """Result for OCR-based recognition of terrorism content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _Input: Input for OCR-based recognition of terrorism content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskInput`
        :param _Output: Output for OCR-based recognition of terrorism content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismOcrTaskOutput`
        :param _Progress: The progress of an OCR-based moderation task (terrorist content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismOcrTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismOcrTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTaskTerrorismResult(AbstractModel):
    """Result for intelligent recognition of terrorism content

    """

    def __init__(self):
        r"""
        :param _Status: Task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _ErrCode: Error code. 0 indicates the task is successful; other values indicate failure. You’re not recommended to use this parameter, but to use the new parameter `ErrCodeExt`.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Input: Input for intelligent recognition of terrorism content
        :type Input: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskInput`
        :param _Output: Output for intelligent recognition of terrorism content
Note: This field may return `null`, indicating that no valid value can be found.
        :type Output: :class:`tencentcloud.vod.v20180717.models.AiReviewTerrorismTaskOutput`
        :param _Progress: The progress of a moderation task (terrorist content). Value range: 0-100.
        :type Progress: int
        """
        self._Status = None
        self._ErrCodeExt = None
        self._ErrCode = None
        self._Message = None
        self._Input = None
        self._Output = None
        self._Progress = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress


    def _deserialize(self, params):
        self._Status = params.get("Status")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        if params.get("Input") is not None:
            self._Input = AiReviewTerrorismTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = AiReviewTerrorismTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._Progress = params.get("Progress")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskInput(AbstractModel):
    """Input parameters for OCR-based recognition of terrorism content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of terrorism content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismOcrTaskOutput(AbstractModel):
    """Output for OCR-based recognition of terrorism content

    """

    def __init__(self):
        r"""
        :param _Confidence: Confidence score for the OCR-detected terrorism content. Value range: 0-100
        :type Confidence: float
        :param _Suggestion: Processing suggestion for the OCR-detected terrorism content
<li>pass</li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _SegmentSet: List of video segments that contain OCR-detected terrorism content
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewOcrTextSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain OCR-detected terrorism content. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain OCR-detected terrorism content, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewOcrTextSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskInput(AbstractModel):
    """Input parameters for intelligent recognition of terrorism content

    """

    def __init__(self):
        r"""
        :param _Definition: ID of the template for recognition of terrorism content
        :type Definition: int
        """
        self._Definition = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiReviewTerrorismTaskOutput(AbstractModel):
    """Terrorism information

    """

    def __init__(self):
        r"""
        :param _Confidence: Score of detected terrorism information in a video between 0 and 100.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Confidence: float
        :param _Suggestion: Suggestion for detected terrorism information. Valid values:
<li>pass.</li>
<li>review.</li>
<li>block.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type Suggestion: str
        :param _Label: Tag of the detected terrorism information in a video. Valid values:
<li>`guns`: weapons and guns</li>
<li>`crowd`: crowds</li>
<li>`police`: police forces</li>
<li>`bloody`: bloody images</li>
<li>`banners`: terrorism flags</li>
<li>`militant`: militants</li>
<li>`explosion`: explosions and fires</li>
<li>`terrorists`: terrorists</li>
<li>`scenario`: terrorism images</li>
        :type Label: str
        :param _SegmentSet: List of video segments that contain terrorism information
<font color=red>Note</font>: This list displays the first 100 results at most. You can get all the results from the file at the URL specified by `SegmentSetFileUrl`.
        :type SegmentSet: list of MediaContentReviewSegmentItem
        :param _SegmentSetFileUrl: URL to the file for video segments that contain terrorism information. The file is in JSON format and has the same data structure as `SegmentSet`. Instead of being saved permanently, the file is deleted upon the expiration time specified by `SegmentSetFileUrlExpireTime`.
        :type SegmentSetFileUrl: str
        :param _SegmentSetFileUrlExpireTime: Expiration time of the URL to the file for video segments that contain terrorism information, in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format)
        :type SegmentSetFileUrlExpireTime: str
        """
        self._Confidence = None
        self._Suggestion = None
        self._Label = None
        self._SegmentSet = None
        self._SegmentSetFileUrl = None
        self._SegmentSetFileUrlExpireTime = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def Label(self):
        return self._Label

    @Label.setter
    def Label(self, Label):
        self._Label = Label

    @property
    def SegmentSet(self):
        return self._SegmentSet

    @SegmentSet.setter
    def SegmentSet(self, SegmentSet):
        self._SegmentSet = SegmentSet

    @property
    def SegmentSetFileUrl(self):
        return self._SegmentSetFileUrl

    @SegmentSetFileUrl.setter
    def SegmentSetFileUrl(self, SegmentSetFileUrl):
        self._SegmentSetFileUrl = SegmentSetFileUrl

    @property
    def SegmentSetFileUrlExpireTime(self):
        return self._SegmentSetFileUrlExpireTime

    @SegmentSetFileUrlExpireTime.setter
    def SegmentSetFileUrlExpireTime(self, SegmentSetFileUrlExpireTime):
        self._SegmentSetFileUrlExpireTime = SegmentSetFileUrlExpireTime


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._Label = params.get("Label")
        if params.get("SegmentSet") is not None:
            self._SegmentSet = []
            for item in params.get("SegmentSet"):
                obj = MediaContentReviewSegmentItem()
                obj._deserialize(item)
                self._SegmentSet.append(obj)
        self._SegmentSetFileUrl = params.get("SegmentSetFileUrl")
        self._SegmentSetFileUrlExpireTime = params.get("SegmentSetFileUrlExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceInfo(AbstractModel):
    """AI-based sample management - face information.

    """

    def __init__(self):
        r"""
        :param _FaceId: Face image ID.
        :type FaceId: str
        :param _Url: Face image address.
        :type Url: str
        """
        self._FaceId = None
        self._Url = None

    @property
    def FaceId(self):
        return self._FaceId

    @FaceId.setter
    def FaceId(self, FaceId):
        self._FaceId = FaceId

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._FaceId = params.get("FaceId")
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFaceOperation(AbstractModel):
    """AI-based sample management - face data operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset. The `reset` operation will clear the existing face data of a figure and add `FaceContents` as the specified face data.
        :type Type: str
        :param _FaceIds: Face ID set, which is required if `Type` is `delete`.
        :type FaceIds: list of str
        :param _FaceContents: Face image [Base64](https://tools.ietf.org/html/rfc4648) Encoded string collection, only supports jpeg and png image formats. 
<li>When Type is add or reset, this field is required;</li>
<li>Array length limit: 5 pictures. </li>
Note: The picture must be a clear frontal photo of a single person, with a pixel size of no less than 200*200.
        :type FaceContents: list of str
        """
        self._Type = None
        self._FaceIds = None
        self._FaceContents = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def FaceIds(self):
        return self._FaceIds

    @FaceIds.setter
    def FaceIds(self, FaceIds):
        self._FaceIds = FaceIds

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._FaceIds = params.get("FaceIds")
        self._FaceContents = params.get("FaceContents")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleFailFaceInfo(AbstractModel):
    """AI-based sample management - face information failed to be processed.

    """

    def __init__(self):
        r"""
        :param _Index: It corresponds to incorrect image subscripts in the `FaceContents` input parameter, starting from 0.
        :type Index: int
        :param _ErrCode: Error code. Valid values:
<li>0: success;</li>
<li>Other values: failure.</li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        """
        self._Index = None
        self._ErrCode = None
        self._Message = None

    @property
    def Index(self):
        return self._Index

    @Index.setter
    def Index(self, Index):
        self._Index = Index

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message


    def _deserialize(self, params):
        self._Index = params.get("Index")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSamplePerson(AbstractModel):
    """AI-based sample management - figure information.

    """

    def __init__(self):
        r"""
        :param _PersonId: Figure ID.
        :type PersonId: str
        :param _Name: Figure name.
        :type Name: str
        :param _Description: Figure description.
        :type Description: str
        :param _FaceInfoSet: Face information.
        :type FaceInfoSet: list of AiSampleFaceInfo
        :param _TagSet: Figure tag.
        :type TagSet: list of str
        :param _UsageSet: Use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._PersonId = None
        self._Name = None
        self._Description = None
        self._FaceInfoSet = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceInfoSet(self):
        return self._FaceInfoSet

    @FaceInfoSet.setter
    def FaceInfoSet(self, FaceInfoSet):
        self._FaceInfoSet = FaceInfoSet

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        if params.get("FaceInfoSet") is not None:
            self._FaceInfoSet = []
            for item in params.get("FaceInfoSet"):
                obj = AiSampleFaceInfo()
                obj._deserialize(item)
                self._FaceInfoSet.append(obj)
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleTagOperation(AbstractModel):
    """AI-based sample management - tag operation.

    """

    def __init__(self):
        r"""
        :param _Type: Operation type. Valid values: add, delete, reset.
        :type Type: str
        :param _Tags: Tag. Length limit: 128 characters.
        :type Tags: list of str
        """
        self._Type = None
        self._Tags = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWord(AbstractModel):
    """AI-based sample management - keyword output information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword.
        :type Keyword: str
        :param _TagSet: Keyword tag.
        :type TagSet: list of str
        :param _UsageSet: Keyword use case.
        :type UsageSet: list of str
        :param _CreateTime: Creation time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Keyword = None
        self._TagSet = None
        self._UsageSet = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def TagSet(self):
        return self._TagSet

    @TagSet.setter
    def TagSet(self, TagSet):
        self._TagSet = TagSet

    @property
    def UsageSet(self):
        return self._UsageSet

    @UsageSet.setter
    def UsageSet(self, UsageSet):
        self._UsageSet = UsageSet

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._TagSet = params.get("TagSet")
        self._UsageSet = params.get("UsageSet")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AiSampleWordInfo(AbstractModel):
    """AI-based sample management - keyword input information.

    """

    def __init__(self):
        r"""
        :param _Keyword: Keyword. Length limit: 20 characters.
        :type Keyword: str
        :param _Tags: Keyword tag
<li>Array length limit: 20 tags;</li>
<li>Tag length limit: 128 characters.</li>
        :type Tags: list of str
        """
        self._Keyword = None
        self._Tags = None

    @property
    def Keyword(self):
        return self._Keyword

    @Keyword.setter
    def Keyword(self, Keyword):
        self._Keyword = Keyword

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Keyword = params.get("Keyword")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicTaskInput(AbstractModel):
    """Animated image generating task type

    """

    def __init__(self):
        r"""
        :param _Definition: Animated image generating template ID
        :type Definition: int
        :param _StartTimeOffset: Start time offset of an animated image in the video, in seconds.
<li>If this parameter is left empty or set to 0, the animated image will start at the same time as the video.</li>
<li>If this parameter is set to a positive number (n for example), the animated image will start at the nth second of the video.</li>
<li>If this parameter is set to a negative number (-n for example), the animated image will start at the nth second before the end of the video.</li>
        :type StartTimeOffset: float
        :param _EndTimeOffset: End time offset of an animated image in the video, in seconds.
<li>If this parameter is left empty or set to 0, the animated image will end at the same time as the video.</li>
<li>If this parameter is set to a positive number (n for example), the animated image will end at the nth second of the video.</li>
<li>If this parameter is set to a negative number (-n for example), the animated image will end at the nth second before the end of the video.</li>
        :type EndTimeOffset: float
        """
        self._Definition = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AnimatedGraphicsTemplate(AbstractModel):
    """Details of an animated image generating template.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _Type: Template type. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _Name: Name of an animated image generating template.
        :type Name: str
        :param _Comment: Description of an animated image generating template.
        :type Comment: str
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format.
        :type Format: str
        :param _Fps: Frame rate.
        :type Fps: int
        :param _Quality: Image quality.
        :type Quality: float
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Type = None
        self._Name = None
        self._Comment = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Fps = None
        self._Quality = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Type = params.get("Type")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Fps = params.get("Fps")
        self._Quality = params.get("Quality")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadRequest(AbstractModel):
    """ApplyUpload request structure.

    """

    def __init__(self):
        r"""
        :param _MediaType: Media type. For the detailed valid values, please see [Upload Overview](https://intl.cloud.tencent.com/document/product/266/9760?from_cn_redirect=1#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B).
        :type MediaType: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _MediaName: Media name.
        :type MediaName: str
        :param _CoverType: Cover type. For the detailed valid values, please see [Upload Overview](https://intl.cloud.tencent.com/document/product/266/9760?from_cn_redirect=1#.E6.96.87.E4.BB.B6.E7.B1.BB.E5.9E.8B).
        :type CoverType: str
        :param _Procedure: Subsequent task operation on a media file, i.e., after a media file is uploaded, task flow operations will be initiated automatically. This parameter value is a task flow template name. VOD supports [creating task flow templates](https://intl.cloud.tencent.com/document/product/266/33819?from_cn_redirect=1) and naming the templates.
        :type Procedure: str
        :param _ExpireTime: Expiration time of a media file in ISO 8601 format. For more information, please see [Notes on ISO Date Format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type ExpireTime: str
        :param _StorageRegion: Specifies upload region. This is only applicable to users that have special requirements for the upload region.
        :type StorageRegion: str
        :param _ClassId: Category ID, which is used to categorize the media for management. A category can be created and its ID can be obtained by using the [category creating](https://intl.cloud.tencent.com/document/product/266/7812?from_cn_redirect=1) API.
<li>Default value: 0, which means "Other".</li>
        :type ClassId: int
        :param _SourceContext: Source context, which is used to pass through the user request information. The [upload callback](https://intl.cloud.tencent.com/document/product/266/7830?from_cn_redirect=1) API will return the value of this field. It can contain up to 250 characters.
        :type SourceContext: str
        :param _SessionContext: Session context, which is used to pass through the user request information. If the `Procedure` parameter is specified, the [task flow status change callback](https://intl.cloud.tencent.com/document/product/266/9636?from_cn_redirect=1) API will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _ExtInfo: Reserved parameter for special purposes.
        :type ExtInfo: str
        """
        self._MediaType = None
        self._SubAppId = None
        self._MediaName = None
        self._CoverType = None
        self._Procedure = None
        self._ExpireTime = None
        self._StorageRegion = None
        self._ClassId = None
        self._SourceContext = None
        self._SessionContext = None
        self._ExtInfo = None

    @property
    def MediaType(self):
        return self._MediaType

    @MediaType.setter
    def MediaType(self, MediaType):
        self._MediaType = MediaType

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def MediaName(self):
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def CoverType(self):
        return self._CoverType

    @CoverType.setter
    def CoverType(self, CoverType):
        self._CoverType = CoverType

    @property
    def Procedure(self):
        return self._Procedure

    @Procedure.setter
    def Procedure(self, Procedure):
        self._Procedure = Procedure

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def StorageRegion(self):
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SourceContext(self):
        return self._SourceContext

    @SourceContext.setter
    def SourceContext(self, SourceContext):
        self._SourceContext = SourceContext

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._MediaType = params.get("MediaType")
        self._SubAppId = params.get("SubAppId")
        self._MediaName = params.get("MediaName")
        self._CoverType = params.get("CoverType")
        self._Procedure = params.get("Procedure")
        self._ExpireTime = params.get("ExpireTime")
        self._StorageRegion = params.get("StorageRegion")
        self._ClassId = params.get("ClassId")
        self._SourceContext = params.get("SourceContext")
        self._SessionContext = params.get("SessionContext")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ApplyUploadResponse(AbstractModel):
    """ApplyUpload response structure.

    """

    def __init__(self):
        r"""
        :param _StorageBucket: Storage bucket, which is used as the `bucket_name` in the URL of the upload API.
        :type StorageBucket: str
        :param _StorageRegion: Storage region, which is used as the `Region` in the `Host` of the upload API.
        :type StorageRegion: str
        :param _VodSessionKey: VOD session, which is used to confirm the `VodSessionKey` parameter of the upload API.
        :type VodSessionKey: str
        :param _MediaStoragePath: Media storage path, which is used as the `Key` of the stored media of the upload API.
Note: this field may return null, indicating that no valid values can be obtained.
        :type MediaStoragePath: str
        :param _CoverStoragePath: Cover storage path, which is used as the `Key` of the stored cover of the upload API.
Note: this field may return null, indicating that no valid values can be obtained.
        :type CoverStoragePath: str
        :param _TempCertificate: Temporary credential, which is used for authentication of the upload API.
        :type TempCertificate: :class:`tencentcloud.vod.v20180717.models.TempCertificate`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StorageBucket = None
        self._StorageRegion = None
        self._VodSessionKey = None
        self._MediaStoragePath = None
        self._CoverStoragePath = None
        self._TempCertificate = None
        self._RequestId = None

    @property
    def StorageBucket(self):
        return self._StorageBucket

    @StorageBucket.setter
    def StorageBucket(self, StorageBucket):
        self._StorageBucket = StorageBucket

    @property
    def StorageRegion(self):
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def VodSessionKey(self):
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def MediaStoragePath(self):
        return self._MediaStoragePath

    @MediaStoragePath.setter
    def MediaStoragePath(self, MediaStoragePath):
        self._MediaStoragePath = MediaStoragePath

    @property
    def CoverStoragePath(self):
        return self._CoverStoragePath

    @CoverStoragePath.setter
    def CoverStoragePath(self, CoverStoragePath):
        self._CoverStoragePath = CoverStoragePath

    @property
    def TempCertificate(self):
        return self._TempCertificate

    @TempCertificate.setter
    def TempCertificate(self, TempCertificate):
        self._TempCertificate = TempCertificate

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._StorageBucket = params.get("StorageBucket")
        self._StorageRegion = params.get("StorageRegion")
        self._VodSessionKey = params.get("VodSessionKey")
        self._MediaStoragePath = params.get("MediaStoragePath")
        self._CoverStoragePath = params.get("CoverStoragePath")
        if params.get("TempCertificate") is not None:
            self._TempCertificate = TempCertificate()
            self._TempCertificate._deserialize(params.get("TempCertificate"))
        self._RequestId = params.get("RequestId")


class ArtifactRepairInfo(AbstractModel):
    """Artifact removal (smoothing) configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable artifact removal. Valid values:
<li>`ON`</li>
<li>`OFF</li>
        :type Switch: str
        :param _Type: The artifact removal type. This parameter is valid only if `Switch` is `ON`. Valid values:
<li>`weak`</li>
<li>`strong`</li>
Default value: `weak`.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfo(AbstractModel):
    """Control parameter of full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of full speech recognition task. Valid values:
<li>ON: enables intelligent full speech recognition task;</li>
<li>OFF: disables intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormats: The formats of the subtitle files generated. If this parameter is not passed or an empty string is passed in, no subtitles files will be generated. Valid values:
<li>vtt</li>
<li>srt</li>
        :type SubtitleFormats: list of str
        :param _SubtitleFormat: The format of the subtitle file generated. If this parameter is not passed or an empty string is passed in, no subtitles files will be generated. Valid values:
<li>vtt</li>
<li>srt</li>
<font color='red'>Note: This parameter has been deprecated. Please use `SubtitleFormats` instead.</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: Media source language value range: <li>zh: Mandarin </li> <li>en: English</li> <li>ja: Japanese </li> <li>zh-ca: Cantonese</li><font color=red>Note：</font> If it fills in an empty string or leave this parameter blank, it will be automatically recognized (it is recommended to fill in the language corresponding to the media to improve the recognition accuracy).
        :type SrcLanguage: str
        """
        self._Switch = None
        self._SubtitleFormats = None
        self._SubtitleFormat = None
        self._SrcLanguage = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormats(self):
        return self._SubtitleFormats

    @SubtitleFormats.setter
    def SubtitleFormats(self, SubtitleFormats):
        self._SubtitleFormats = SubtitleFormats

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._SubtitleFormats = params.get("SubtitleFormats")
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrFullTextConfigureInfoForUpdate(AbstractModel):
    """Control parameter of full speech recognition task.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of full speech recognition task. Valid values:
<li>ON: enables intelligent full speech recognition task;</li>
<li>OFF: disables intelligent full speech recognition task.</li>
        :type Switch: str
        :param _SubtitleFormatsOperation: The modification information of the subtitle format list.
        :type SubtitleFormatsOperation: :class:`tencentcloud.vod.v20180717.models.SubtitleFormatsOperation`
        :param _SubtitleFormat: The format of the subtitle file generated. <font color='red'>If you pass in an empty string</font>, no subtitle files will be generated. Valid values:
<li>vtt</li>
<li>srt</li>
<font color='red'>Note: This parameter has been deprecated. Please use `SubtitleFormatsOperation` instead.</font>
        :type SubtitleFormat: str
        :param _SrcLanguage: Media source language value range: <li>zh: Mandarin </li> <li>en: English</li> <li>ja: Japanese </li> <li>zh-ca: Cantonese</li>
        :type SrcLanguage: str
        """
        self._Switch = None
        self._SubtitleFormatsOperation = None
        self._SubtitleFormat = None
        self._SrcLanguage = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def SubtitleFormatsOperation(self):
        return self._SubtitleFormatsOperation

    @SubtitleFormatsOperation.setter
    def SubtitleFormatsOperation(self, SubtitleFormatsOperation):
        self._SubtitleFormatsOperation = SubtitleFormatsOperation

    @property
    def SubtitleFormat(self):
        return self._SubtitleFormat

    @SubtitleFormat.setter
    def SubtitleFormat(self, SubtitleFormat):
        self._SubtitleFormat = SubtitleFormat

    @property
    def SrcLanguage(self):
        return self._SrcLanguage

    @SrcLanguage.setter
    def SrcLanguage(self, SrcLanguage):
        self._SrcLanguage = SrcLanguage


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("SubtitleFormatsOperation") is not None:
            self._SubtitleFormatsOperation = SubtitleFormatsOperation()
            self._SubtitleFormatsOperation._deserialize(params.get("SubtitleFormatsOperation"))
        self._SubtitleFormat = params.get("SubtitleFormat")
        self._SrcLanguage = params.get("SrcLanguage")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfo(AbstractModel):
    """Speech keyword recognition control parameter.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of speech keyword recognition task. Valid values:
<li>ON: enables speech keyword recognition task;</li>
<li>OFF: disables speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AsrWordsConfigureInfoForUpdate(AbstractModel):
    """Control parameter of speech keyword recognition.

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of speech keyword recognition task. Valid values:
<li>ON: enables speech keyword recognition task;</li>
<li>OFF: disables speech keyword recognition task.</li>
        :type Switch: str
        :param _LabelSet: Keyword filter tag, which specifies the keyword tag that needs to be returned. If this parameter is left empty or a blank value is entered, all results will be returned.
There can be up to 10 tags, each with a length limit of 16 characters.
        :type LabelSet: list of str
        """
        self._Switch = None
        self._LabelSet = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def LabelSet(self):
        return self._LabelSet

    @LabelSet.setter
    def LabelSet(self, LabelSet):
        self._LabelSet = LabelSet


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._LabelSet = params.get("LabelSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesRequest(AbstractModel):
    """AttachMediaSubtitles request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: Unique ID of the media file
        :type FileId: str
        :param _Operation: Operation. Valid values:
<li>`Attach`: associates subtitles.</li>
<li>`Detach`: disassociates subtitles.</li>
        :type Operation: str
        :param _AdaptiveDynamicStreamingDefinition: [Adaptive bitrate streaming template ID](https://intl.cloud.tencent.com/document/product/266/34071?from_cn_redirect=1#zsy)
        :type AdaptiveDynamicStreamingDefinition: int
        :param _SubtitleIds: Unique IDs of the subtitles
        :type SubtitleIds: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._FileId = None
        self._Operation = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._SubtitleIds = None
        self._SubAppId = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Operation(self):
        return self._Operation

    @Operation.setter
    def Operation(self, Operation):
        self._Operation = Operation

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def SubtitleIds(self):
        return self._SubtitleIds

    @SubtitleIds.setter
    def SubtitleIds(self, SubtitleIds):
        self._SubtitleIds = SubtitleIds

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Operation = params.get("Operation")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        self._SubtitleIds = params.get("SubtitleIds")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AttachMediaSubtitlesResponse(AbstractModel):
    """AttachMediaSubtitles response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class AudioDenoiseInfo(AbstractModel):
    """Noise removal configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable noise removal. Valid values:
<li>`ON`</li>
<li>`OFF`</li>
        :type Switch: str
        :param _Type: The noise removal type. This parameter is valid only if `Switch` is `ON`. Valid values:
<li>`weak`</li>
<li>`normal`</li>
<li>`strong`</li>
Default value: `weak`.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfo(AbstractModel):
    """Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: The audio codec.
If `Container` is `mp3`, the valid value is:
<li>`libmp3lame`</li>
If `Container` is `ogg` or `flac`, the valid value is:
<li>`flac`</li>
If `Container` is `m4a`, the valid values are:
<li>`libfdk_aac`</li>
<li>`libmp3lame`</li>
<li>`ac3`</li>
If `Container` is `mp4` or `flv`, the valid values are:
<li>`libfdk_aac` (Recommended for MP4)</li>
<li>`libmp3lame` (Recommended for FLV)</li>
<li>`mp2`</li>
If `Container` is `hls`, the valid value is:
<li>`libfdk_aac`</li>
If `Format` is `HLS` or `MPEG-DASH`, the valid value is:
<li>`libfdk_aac`</li>
If `Container` is `wav`, the valid value is:
<li>`pcm16`</li>
        :type Codec: str
        :param _Bitrate: Audio stream bitrate in Kbps. Value range: 0 and [26, 256].
If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :type Bitrate: int
        :param _SampleRate: The audio sample rate. Valid values:
<li>`16000` (valid only if `Codec` is `pcm16`)</li>
<li>`32000`</li>
<li>`44100`</li>
<li>`48000`</li>
Unit: Hz.
        :type SampleRate: int
        :param _AudioChannel: Audio channel system. Valid values:
<li>1: mono-channel</li>
<li>2: dual-channel</li>
<li>6: stereo</li>
You cannot set the sound channel as stereo for media files in container formats for audios (FLAC, OGG, MP3, M4A).
Default value: 2
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTemplateInfoForUpdate(AbstractModel):
    """Audio stream configuration parameter

    """

    def __init__(self):
        r"""
        :param _Codec: The audio codec.
If `Container` is `mp3`, the valid value is:
<li>`libmp3lame`</li>
If `Container` is `ogg` or `flac`, the valid value is:
<li>`flac`</li>
If `Container` is `m4a`, the valid values are:
<li>`libfdk_aac`</li>
<li>`libmp3lame`</li>
<li>`ac3`</li>
If `Container` is `mp4` or `flv`, the valid values are:
<li>`libfdk_aac` (Recommended for MP4)</li>
<li>`libmp3lame` (Recommended for FLV)</li>
<li>`mp2`</li>
If `Container` is `hls`, the valid value is:
<li>`libfdk_aac`</li>
If `Format` is `HLS` or `MPEG-DASH`, the valid value is:
<li>`libfdk_aac`</li>
If `Container` is `wav`, the valid value is:
<li>`pcm16`</li>
        :type Codec: str
        :param _Bitrate: Audio stream bitrate in Kbps. Value range: 0 and [26, 256]. If the value is 0, the bitrate of the audio stream will be the same as that of the original audio.
        :type Bitrate: int
        :param _SampleRate: The audio sample rate. Valid values:
<li>`16000` (valid only if `Codec` is `pcm16`)</li>
<li>`32000`</li>
<li>`44100`</li>
<li>`48000`</li>
Unit: Hz.
        :type SampleRate: int
        :param _AudioChannel: Audio channel system. Valid values:
<li>1: mono-channel</li>
<li>2: dual-channel</li>
<li>6: stereo</li>
You cannot set the sound channel as stereo for media files in container formats for audios (FLAC, OGG, MP3, M4A).
        :type AudioChannel: int
        """
        self._Codec = None
        self._Bitrate = None
        self._SampleRate = None
        self._AudioChannel = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def SampleRate(self):
        return self._SampleRate

    @SampleRate.setter
    def SampleRate(self, SampleRate):
        self._SampleRate = SampleRate

    @property
    def AudioChannel(self):
        return self._AudioChannel

    @AudioChannel.setter
    def AudioChannel(self, AudioChannel):
        self._AudioChannel = AudioChannel


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._SampleRate = params.get("SampleRate")
        self._AudioChannel = params.get("AudioChannel")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTrackItem(AbstractModel):
    """Audio segment information of audio track.

    """

    def __init__(self):
        r"""
        :param _SourceMedia: Source of media material for audio segment, which can be:
<li>ID of VOD media files</li>
<li>Download URL of other media files</li>
Note: when a download URL of other media files is used as the material source and access control (such as hotlink protection) is enabled, the URL needs to carry access control parameters (such as hotlink protection signature).
        :type SourceMedia: str
        :param _SourceMediaStartTime: Start time of audio segment in material file in seconds. Default value: 0, which means to start capturing from the beginning position of the material.
        :type SourceMediaStartTime: float
        :param _Duration: Audio segment duration in seconds. By default, the length of the material will be used, which means that the entire material will be captured.
        :type Duration: float
        :param _TargetDuration: The target audio duration, in seconds.
<li>If `TargetDuration` is empty or `0`, the target duration is the same as `Duration`.</li>
<li>If `TargetDuration` is a value greater than 0, the playback speed will be changed to make the final audio duration the same as the value of `TargetDuration`.</li>
        :type TargetDuration: float
        :param _AudioOperations: Operation on audio segment, such as volume adjustment.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AudioOperations: list of AudioTransform
        """
        self._SourceMedia = None
        self._SourceMediaStartTime = None
        self._Duration = None
        self._TargetDuration = None
        self._AudioOperations = None

    @property
    def SourceMedia(self):
        return self._SourceMedia

    @SourceMedia.setter
    def SourceMedia(self, SourceMedia):
        self._SourceMedia = SourceMedia

    @property
    def SourceMediaStartTime(self):
        return self._SourceMediaStartTime

    @SourceMediaStartTime.setter
    def SourceMediaStartTime(self, SourceMediaStartTime):
        self._SourceMediaStartTime = SourceMediaStartTime

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration

    @property
    def TargetDuration(self):
        return self._TargetDuration

    @TargetDuration.setter
    def TargetDuration(self, TargetDuration):
        self._TargetDuration = TargetDuration

    @property
    def AudioOperations(self):
        return self._AudioOperations

    @AudioOperations.setter
    def AudioOperations(self, AudioOperations):
        self._AudioOperations = AudioOperations


    def _deserialize(self, params):
        self._SourceMedia = params.get("SourceMedia")
        self._SourceMediaStartTime = params.get("SourceMediaStartTime")
        self._Duration = params.get("Duration")
        self._TargetDuration = params.get("TargetDuration")
        if params.get("AudioOperations") is not None:
            self._AudioOperations = []
            for item in params.get("AudioOperations"):
                obj = AudioTransform()
                obj._deserialize(item)
                self._AudioOperations.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioTransform(AbstractModel):
    """Audio operation

    """

    def __init__(self):
        r"""
        :param _Type: Audio operation type. Valid values:
<li>Volume: volume adjustment.</li>
        :type Type: str
        :param _VolumeParam: Volume adjustment parameter, which is valid if `Type` is `Volume`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type VolumeParam: :class:`tencentcloud.vod.v20180717.models.AudioVolumeParam`
        """
        self._Type = None
        self._VolumeParam = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def VolumeParam(self):
        return self._VolumeParam

    @VolumeParam.setter
    def VolumeParam(self, VolumeParam):
        self._VolumeParam = VolumeParam


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("VolumeParam") is not None:
            self._VolumeParam = AudioVolumeParam()
            self._VolumeParam._deserialize(params.get("VolumeParam"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AudioVolumeParam(AbstractModel):
    """Audio gain adjustment parameter

    """

    def __init__(self):
        r"""
        :param _Mute: Whether to mute. Valid values: 0, 1.
<li>0: not muted.</li>
<li>1: muted.</li>
Default value: 0.
        :type Mute: int
        :param _Gain: Audio gain. Value range: 0-10.
<li>If the value is greater than 1, the volume will be increased.</li>
<li>If the value is smaller than 1, the volume will be decreased.</li>
<li>0 and 1: no change.</li>
Default value: 0.
        :type Gain: float
        """
        self._Mute = None
        self._Gain = None

    @property
    def Mute(self):
        return self._Mute

    @Mute.setter
    def Mute(self, Mute):
        self._Mute = Mute

    @property
    def Gain(self):
        return self._Gain

    @Gain.setter
    def Gain(self, Gain):
        self._Gain = Gain


    def _deserialize(self, params):
        self._Mute = params.get("Mute")
        self._Gain = params.get("Gain")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Authentication(AbstractModel):
    """Timestamp hotlink protection configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Anti-hotlink configuration switch, value: <li>on: on; </li> <li>off: off. </li>
        :type Switch: str
        :param _TypeA: Timestamp hotlink protection mode A configuration
        :type TypeA: :class:`tencentcloud.vod.v20180717.models.AuthenticationTypeA`
        :param _TypeB: Timestamp hotlink protection mode B configuration
        :type TypeB: :class:`tencentcloud.vod.v20180717.models.AuthenticationTypeB`
        :param _TypeC: Timestamp hotlink protection mode C configuration
        :type TypeC: :class:`tencentcloud.vod.v20180717.models.AuthenticationTypeC`
        :param _TypeD: Timestamp hotlink protection mode D configuration
        :type TypeD: :class:`tencentcloud.vod.v20180717.models.AuthenticationTypeD`
        """
        self._Switch = None
        self._TypeA = None
        self._TypeB = None
        self._TypeC = None
        self._TypeD = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def TypeA(self):
        return self._TypeA

    @TypeA.setter
    def TypeA(self, TypeA):
        self._TypeA = TypeA

    @property
    def TypeB(self):
        return self._TypeB

    @TypeB.setter
    def TypeB(self, TypeB):
        self._TypeB = TypeB

    @property
    def TypeC(self):
        return self._TypeC

    @TypeC.setter
    def TypeC(self, TypeC):
        self._TypeC = TypeC

    @property
    def TypeD(self):
        return self._TypeD

    @TypeD.setter
    def TypeD(self, TypeD):
        self._TypeD = TypeD


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("TypeA") is not None:
            self._TypeA = AuthenticationTypeA()
            self._TypeA._deserialize(params.get("TypeA"))
        if params.get("TypeB") is not None:
            self._TypeB = AuthenticationTypeB()
            self._TypeB._deserialize(params.get("TypeB"))
        if params.get("TypeC") is not None:
            self._TypeC = AuthenticationTypeC()
            self._TypeC._deserialize(params.get("TypeC"))
        if params.get("TypeD") is not None:
            self._TypeD = AuthenticationTypeD()
            self._TypeD._deserialize(params.get("TypeD"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticationTypeA(AbstractModel):
    """Configuration of timestamp anti-hotlinking mode A; The access URL format of timestamp anti-hotlinking mode A is: http://DomainName/Filename?sign=timestamp-rand-uid-md5hash; where timestamp is a decimal UNIX timestamp; rand is a random character String, consisting of 0 ~ 100 uppercase and lowercase letters and numbers; uid is 0; md5hash: MD5 (file path-timestamp-rand-uid-custom key).

    """

    def __init__(self):
        r"""
        :param _SecretKey: The key to calculate the signature; only uppercase and lowercase letters and numbers are allowed, with a length of 6~32 characters.
        :type SecretKey: str
        :param _SignParam: Signature parameter name setting; only uppercase and lowercase letters, numbers or underscores are allowed, the length is 1~100 characters, and it cannot start with a number.
        :type SignParam: str
        :param _ExpireTime: Signature expiration time setting; the unit is seconds, and the maximum value can be set to 630720000.
        :type ExpireTime: int
        :param _FileExtensions: File extension list settings for authentication/non-authentication; if the character * is included, it means all files.
        :type FileExtensions: list of str
        :param _FilterType: whitelist: whitelist, indicating that all types except the FileExtensions list will be authenticated; blacklist: blacklist, indicating that only the types in FileExtensions will be authenticated.
        :type FilterType: str
        :param _BackupSecretKey: Alternate key for calculating signature; only uppercase and lowercase letters and numbers are allowed, length 6~32 characters.
        :type BackupSecretKey: str
        """
        self._SecretKey = None
        self._SignParam = None
        self._ExpireTime = None
        self._FileExtensions = None
        self._FilterType = None
        self._BackupSecretKey = None

    @property
    def SecretKey(self):
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def SignParam(self):
        return self._SignParam

    @SignParam.setter
    def SignParam(self, SignParam):
        self._SignParam = SignParam

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileExtensions(self):
        return self._FileExtensions

    @FileExtensions.setter
    def FileExtensions(self, FileExtensions):
        self._FileExtensions = FileExtensions

    @property
    def FilterType(self):
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def BackupSecretKey(self):
        return self._BackupSecretKey

    @BackupSecretKey.setter
    def BackupSecretKey(self, BackupSecretKey):
        self._BackupSecretKey = BackupSecretKey


    def _deserialize(self, params):
        self._SecretKey = params.get("SecretKey")
        self._SignParam = params.get("SignParam")
        self._ExpireTime = params.get("ExpireTime")
        self._FileExtensions = params.get("FileExtensions")
        self._FilterType = params.get("FilterType")
        self._BackupSecretKey = params.get("BackupSecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticationTypeB(AbstractModel):
    """Timestamp hotlink protection mode B configuration

    """

    def __init__(self):
        r"""
        :param _SecretKey: The key to calculate the signature; only uppercase and lowercase letters and numbers are allowed, with a length of 6~32 characters.
        :type SecretKey: str
        :param _ExpireTime: Signature expiration time setting; the unit is seconds, and the maximum value can be set to 630720000.
        :type ExpireTime: int
        :param _FileExtensions: File extension list settings for authentication/non-authentication; if the character * is included, it means all files.
        :type FileExtensions: list of str
        :param _FilterType: whitelist: whitelist, indicating that all types except the FileExtensions list will be authenticated; blacklist: blacklist, indicating that only the types in FileExtensions will be authenticated.
        :type FilterType: str
        :param _BackupSecretKey: Alternate key for calculating signature; only uppercase and lowercase letters and numbers are allowed, length 6~32 characters.
        :type BackupSecretKey: str
        """
        self._SecretKey = None
        self._ExpireTime = None
        self._FileExtensions = None
        self._FilterType = None
        self._BackupSecretKey = None

    @property
    def SecretKey(self):
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileExtensions(self):
        return self._FileExtensions

    @FileExtensions.setter
    def FileExtensions(self, FileExtensions):
        self._FileExtensions = FileExtensions

    @property
    def FilterType(self):
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def BackupSecretKey(self):
        return self._BackupSecretKey

    @BackupSecretKey.setter
    def BackupSecretKey(self, BackupSecretKey):
        self._BackupSecretKey = BackupSecretKey


    def _deserialize(self, params):
        self._SecretKey = params.get("SecretKey")
        self._ExpireTime = params.get("ExpireTime")
        self._FileExtensions = params.get("FileExtensions")
        self._FilterType = params.get("FilterType")
        self._BackupSecretKey = params.get("BackupSecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticationTypeC(AbstractModel):
    """Timestamp anti-hotlinking mode C configuration; The access URL format of timestamp anti-hotlinking mode C is: http://DomainName/md5hash/timestamp/FileName; where timestamp is a hexadecimal UNIX timestamp; md5hash: MD5 (custom password key + file path + timestamp).

    """

    def __init__(self):
        r"""
        :param _SecretKey: The key to calculate the signature; only uppercase and lowercase letters and numbers are allowed, with a length of 6~32 characters.
        :type SecretKey: str
        :param _ExpireTime: Signature expiration time setting; the unit is seconds, and the maximum value can be set to 630720000.
        :type ExpireTime: int
        :param _FileExtensions: File extension list settings for authentication/non-authentication; if the character * is included, it means all files.
        :type FileExtensions: list of str
        :param _FilterType: whitelist: whitelist, indicating that all types except the FileExtensions list will be authenticated; blacklist: blacklist, indicating that only the types in FileExtensions will be authenticated.
        :type FilterType: str
        :param _TimeFormat: Timestamp base setting: <li>dec: decimal</li> <li>hex: hexadecimal</li>
        :type TimeFormat: str
        :param _BackupSecretKey: Alternate key for calculating signature; only uppercase and lowercase letters and numbers are allowed, length 6~32 characters.
        :type BackupSecretKey: str
        """
        self._SecretKey = None
        self._ExpireTime = None
        self._FileExtensions = None
        self._FilterType = None
        self._TimeFormat = None
        self._BackupSecretKey = None

    @property
    def SecretKey(self):
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileExtensions(self):
        return self._FileExtensions

    @FileExtensions.setter
    def FileExtensions(self, FileExtensions):
        self._FileExtensions = FileExtensions

    @property
    def FilterType(self):
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def TimeFormat(self):
        return self._TimeFormat

    @TimeFormat.setter
    def TimeFormat(self, TimeFormat):
        self._TimeFormat = TimeFormat

    @property
    def BackupSecretKey(self):
        return self._BackupSecretKey

    @BackupSecretKey.setter
    def BackupSecretKey(self, BackupSecretKey):
        self._BackupSecretKey = BackupSecretKey


    def _deserialize(self, params):
        self._SecretKey = params.get("SecretKey")
        self._ExpireTime = params.get("ExpireTime")
        self._FileExtensions = params.get("FileExtensions")
        self._FilterType = params.get("FilterType")
        self._TimeFormat = params.get("TimeFormat")
        self._BackupSecretKey = params.get("BackupSecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AuthenticationTypeD(AbstractModel):
    """Timestamp anti-hotlinking mode D configuration; The access URL format of timestamp anti-hotlinking mode D is: http://DomainName/FileName?sign=md5hash&t=timestamp; where timestamp is a decimal or hexadecimal UNIX timestamp; md5hash: MD5 (custom key + file path + timestamp).

    """

    def __init__(self):
        r"""
        :param _SecretKey: The key to calculate the signature; only uppercase and lowercase letters and numbers are allowed, with a length of 6~32 characters.
        :type SecretKey: str
        :param _ExpireTime: Signature expiration time setting; the unit is seconds, and the maximum value can be set to 630720000.
        :type ExpireTime: int
        :param _FileExtensions: File extension list settings for authentication/non-authentication; if the character * is included, it means all files.
        :type FileExtensions: list of str
        :param _FilterType: whitelist: whitelist, indicating that all types except the FileExtensions list will be authenticated; blacklist: blacklist, indicating that only the types in FileExtensions will be authenticated.
        :type FilterType: str
        :param _SignParam: Signature parameter name setting; only uppercase and lowercase letters, numbers or underscores are allowed, the length is 1~100 characters, and it cannot start with a number.
        :type SignParam: str
        :param _TimeParam: Timestamp parameter name setting; only uppercase and lowercase letters, numbers or underscores are allowed, the length is 1~100 characters, and it cannot start with a number.
        :type TimeParam: str
        :param _TimeFormat: Timestamp base setting: <li>dec: decimal</li> <li>hex: hexadecimal</li>
        :type TimeFormat: str
        :param _BackupSecretKey: Alternate key for calculating signature; only uppercase and lowercase letters and numbers are allowed, length 6~32 characters.
        :type BackupSecretKey: str
        """
        self._SecretKey = None
        self._ExpireTime = None
        self._FileExtensions = None
        self._FilterType = None
        self._SignParam = None
        self._TimeParam = None
        self._TimeFormat = None
        self._BackupSecretKey = None

    @property
    def SecretKey(self):
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def FileExtensions(self):
        return self._FileExtensions

    @FileExtensions.setter
    def FileExtensions(self, FileExtensions):
        self._FileExtensions = FileExtensions

    @property
    def FilterType(self):
        return self._FilterType

    @FilterType.setter
    def FilterType(self, FilterType):
        self._FilterType = FilterType

    @property
    def SignParam(self):
        return self._SignParam

    @SignParam.setter
    def SignParam(self, SignParam):
        self._SignParam = SignParam

    @property
    def TimeParam(self):
        return self._TimeParam

    @TimeParam.setter
    def TimeParam(self, TimeParam):
        self._TimeParam = TimeParam

    @property
    def TimeFormat(self):
        return self._TimeFormat

    @TimeFormat.setter
    def TimeFormat(self, TimeFormat):
        self._TimeFormat = TimeFormat

    @property
    def BackupSecretKey(self):
        return self._BackupSecretKey

    @BackupSecretKey.setter
    def BackupSecretKey(self, BackupSecretKey):
        self._BackupSecretKey = BackupSecretKey


    def _deserialize(self, params):
        self._SecretKey = params.get("SecretKey")
        self._ExpireTime = params.get("ExpireTime")
        self._FileExtensions = params.get("FileExtensions")
        self._FilterType = params.get("FilterType")
        self._SignParam = params.get("SignParam")
        self._TimeParam = params.get("TimeParam")
        self._TimeFormat = params.get("TimeFormat")
        self._BackupSecretKey = params.get("BackupSecretKey")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class AwsPrivateAccess(AbstractModel):
    """Origin access authentication for S3 bucket.

    """

    def __init__(self):
        r"""
        :param _Switch: AWS S3 return-to-origin authentication configuration switch, the values u200bu200bare: <li>on: on; </li> <li>off: off. </li>
        :type Switch: str
        :param _AccessKey: Access ID.
        :type AccessKey: str
        :param _SecretKey: Key.
        :type SecretKey: str
        :param _Region: Region.
        :type Region: str
        :param _Bucket: BucketName.
        :type Bucket: str
        """
        self._Switch = None
        self._AccessKey = None
        self._SecretKey = None
        self._Region = None
        self._Bucket = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def AccessKey(self):
        return self._AccessKey

    @AccessKey.setter
    def AccessKey(self, AccessKey):
        self._AccessKey = AccessKey

    @property
    def SecretKey(self):
        return self._SecretKey

    @SecretKey.setter
    def SecretKey(self, SecretKey):
        self._SecretKey = SecretKey

    @property
    def Region(self):
        return self._Region

    @Region.setter
    def Region(self, Region):
        self._Region = Region

    @property
    def Bucket(self):
        return self._Bucket

    @Bucket.setter
    def Bucket(self, Bucket):
        self._Bucket = Bucket


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._AccessKey = params.get("AccessKey")
        self._SecretKey = params.get("SecretKey")
        self._Region = params.get("Region")
        self._Bucket = params.get("Bucket")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfo(AbstractModel):
    """Control parameters for video screen black border, white border, black screen, and white screen detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen black border, white border, black screen, white screen detection switch, optional values: 
<li>ON: turn on; </li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlackWhiteEdgeConfigureInfoForUpdate(AbstractModel):
    """Control parameters for video screen black border, white border, black screen, and white screen detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen black border, white border, black screen, white screen detection switch, optional values: 
<li>ON: turn on; </li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfo(AbstractModel):
    """Control parameters for video blur detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen blur detection switch, optional values:
<li>ON: turn on;</li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class BlurConfigureInfoForUpdate(AbstractModel):
    """Control parameters for video blur detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen blur detection switch, optional values:
<li>ON: turn on;</li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CDNCertInfo(AbstractModel):
    """Domain https acceleration configuration, the default is off

    """

    def __init__(self):
        r"""
        :param _CertId: The server certificate ID is automatically generated during certificate hosting by SSL Certificate Management.
        :type CertId: str
        :param _Certificate: Server certificate information.
        :type Certificate: str
        :param _PrivateKey: Server key information.
        :type PrivateKey: str
        :param _ExpireTime: Certificate expiration time; no need to fill in when configured as an input parameter.
        :type ExpireTime: str
        """
        self._CertId = None
        self._Certificate = None
        self._PrivateKey = None
        self._ExpireTime = None

    @property
    def CertId(self):
        return self._CertId

    @CertId.setter
    def CertId(self, CertId):
        self._CertId = CertId

    @property
    def Certificate(self):
        return self._Certificate

    @Certificate.setter
    def Certificate(self, Certificate):
        self._Certificate = Certificate

    @property
    def PrivateKey(self):
        return self._PrivateKey

    @PrivateKey.setter
    def PrivateKey(self, PrivateKey):
        self._PrivateKey = PrivateKey

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._CertId = params.get("CertId")
        self._Certificate = params.get("Certificate")
        self._PrivateKey = params.get("PrivateKey")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CDNDomainConfig(AbstractModel):
    """CDN Domain Config

    """

    def __init__(self):
        r"""
        :param _Area: Domain name acceleration areas: <li>mainland: acceleration within China; </li> <li>overseas: acceleration outside China; </li> <li>global: global acceleration. </li>
        :type Area: str
        :param _Origin: Origin Server Configuration
        :type Origin: :class:`tencentcloud.vod.v20180717.models.Origin`
        :param _IpFilter: IP blocklist/allowlist configuration. This is disabled by default.
        :type IpFilter: :class:`tencentcloud.vod.v20180717.models.IpFilter`
        :param _UserAgentFilter: UserAgent:blacklist/whitelist configuration.
        :type UserAgentFilter: :class:`tencentcloud.vod.v20180717.models.UserAgentFilter`
        :param _FollowRedirect: Back to the source 301/302 status code automatically follows the configuration, the default is off
        :type FollowRedirect: :class:`tencentcloud.vod.v20180717.models.FollowRedirect`
        :param _RequestHeader: Custom request header configuration. This is disabled by default.
        :type RequestHeader: :class:`tencentcloud.vod.v20180717.models.RequestHeader`
        :param _ResponseHeader: Custom response header configuration. This is disabled by default.
        :type ResponseHeader: :class:`tencentcloud.vod.v20180717.models.ResponseHeader`
        :param _Cache: Node cache expiration time configuration.
        :type Cache: :class:`tencentcloud.vod.v20180717.models.Cache`
        :param _Https: Domain name HTTPS acceleration configuration. This is disabled by default.
        :type Https: :class:`tencentcloud.vod.v20180717.models.Https`
        :param _Authentication: Timestamp hotlink protection configuration.
        :type Authentication: :class:`tencentcloud.vod.v20180717.models.Authentication`
        :param _ForceRedirect: Access protocol forced redirect configuration. This is disabled by default.
        :type ForceRedirect: :class:`tencentcloud.vod.v20180717.models.ForceRedirect`
        :param _Referer: Referer blacklist/whitelist configuration. This is disabled by default.
        :type Referer: :class:`tencentcloud.vod.v20180717.models.Referer`
        :param _MaxAge: Browser cache rule configuration, which is used to set the default value of MaxAge and is disabled by default.
        :type MaxAge: :class:`tencentcloud.vod.v20180717.models.MaxAge`
        :param _Ipv6Access: IPv6 access configuration.
        :type Ipv6Access: :class:`tencentcloud.vod.v20180717.models.Ipv6Access`
        :param _Quic: QUIC configuration item.
        :type Quic: :class:`tencentcloud.vod.v20180717.models.Quic`
        :param _AwsPrivateAccess: Origin access authentication for S3 bucket.
        :type AwsPrivateAccess: :class:`tencentcloud.vod.v20180717.models.AwsPrivateAccess`
        :param _OssPrivateAccess: Access authentication configuration for OSS origin.
        :type OssPrivateAccess: :class:`tencentcloud.vod.v20180717.models.OssPrivateAccess`
        :param _HwPrivateAccess: Access authentication for Huawei Cloud OBS origin
        :type HwPrivateAccess: :class:`tencentcloud.vod.v20180717.models.HwPrivateAccess`
        :param _OthersPrivateAccess: Origin-pull authentication for other origins.
        :type OthersPrivateAccess: :class:`tencentcloud.vod.v20180717.models.OthersPrivateAccess`
        """
        self._Area = None
        self._Origin = None
        self._IpFilter = None
        self._UserAgentFilter = None
        self._FollowRedirect = None
        self._RequestHeader = None
        self._ResponseHeader = None
        self._Cache = None
        self._Https = None
        self._Authentication = None
        self._ForceRedirect = None
        self._Referer = None
        self._MaxAge = None
        self._Ipv6Access = None
        self._Quic = None
        self._AwsPrivateAccess = None
        self._OssPrivateAccess = None
        self._HwPrivateAccess = None
        self._OthersPrivateAccess = None

    @property
    def Area(self):
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Origin(self):
        return self._Origin

    @Origin.setter
    def Origin(self, Origin):
        self._Origin = Origin

    @property
    def IpFilter(self):
        return self._IpFilter

    @IpFilter.setter
    def IpFilter(self, IpFilter):
        self._IpFilter = IpFilter

    @property
    def UserAgentFilter(self):
        return self._UserAgentFilter

    @UserAgentFilter.setter
    def UserAgentFilter(self, UserAgentFilter):
        self._UserAgentFilter = UserAgentFilter

    @property
    def FollowRedirect(self):
        return self._FollowRedirect

    @FollowRedirect.setter
    def FollowRedirect(self, FollowRedirect):
        self._FollowRedirect = FollowRedirect

    @property
    def RequestHeader(self):
        return self._RequestHeader

    @RequestHeader.setter
    def RequestHeader(self, RequestHeader):
        self._RequestHeader = RequestHeader

    @property
    def ResponseHeader(self):
        return self._ResponseHeader

    @ResponseHeader.setter
    def ResponseHeader(self, ResponseHeader):
        self._ResponseHeader = ResponseHeader

    @property
    def Cache(self):
        return self._Cache

    @Cache.setter
    def Cache(self, Cache):
        self._Cache = Cache

    @property
    def Https(self):
        return self._Https

    @Https.setter
    def Https(self, Https):
        self._Https = Https

    @property
    def Authentication(self):
        return self._Authentication

    @Authentication.setter
    def Authentication(self, Authentication):
        self._Authentication = Authentication

    @property
    def ForceRedirect(self):
        return self._ForceRedirect

    @ForceRedirect.setter
    def ForceRedirect(self, ForceRedirect):
        self._ForceRedirect = ForceRedirect

    @property
    def Referer(self):
        return self._Referer

    @Referer.setter
    def Referer(self, Referer):
        self._Referer = Referer

    @property
    def MaxAge(self):
        return self._MaxAge

    @MaxAge.setter
    def MaxAge(self, MaxAge):
        self._MaxAge = MaxAge

    @property
    def Ipv6Access(self):
        return self._Ipv6Access

    @Ipv6Access.setter
    def Ipv6Access(self, Ipv6Access):
        self._Ipv6Access = Ipv6Access

    @property
    def Quic(self):
        return self._Quic

    @Quic.setter
    def Quic(self, Quic):
        self._Quic = Quic

    @property
    def AwsPrivateAccess(self):
        return self._AwsPrivateAccess

    @AwsPrivateAccess.setter
    def AwsPrivateAccess(self, AwsPrivateAccess):
        self._AwsPrivateAccess = AwsPrivateAccess

    @property
    def OssPrivateAccess(self):
        return self._OssPrivateAccess

    @OssPrivateAccess.setter
    def OssPrivateAccess(self, OssPrivateAccess):
        self._OssPrivateAccess = OssPrivateAccess

    @property
    def HwPrivateAccess(self):
        return self._HwPrivateAccess

    @HwPrivateAccess.setter
    def HwPrivateAccess(self, HwPrivateAccess):
        self._HwPrivateAccess = HwPrivateAccess

    @property
    def OthersPrivateAccess(self):
        return self._OthersPrivateAccess

    @OthersPrivateAccess.setter
    def OthersPrivateAccess(self, OthersPrivateAccess):
        self._OthersPrivateAccess = OthersPrivateAccess


    def _deserialize(self, params):
        self._Area = params.get("Area")
        if params.get("Origin") is not None:
            self._Origin = Origin()
            self._Origin._deserialize(params.get("Origin"))
        if params.get("IpFilter") is not None:
            self._IpFilter = IpFilter()
            self._IpFilter._deserialize(params.get("IpFilter"))
        if params.get("UserAgentFilter") is not None:
            self._UserAgentFilter = UserAgentFilter()
            self._UserAgentFilter._deserialize(params.get("UserAgentFilter"))
        if params.get("FollowRedirect") is not None:
            self._FollowRedirect = FollowRedirect()
            self._FollowRedirect._deserialize(params.get("FollowRedirect"))
        if params.get("RequestHeader") is not None:
            self._RequestHeader = RequestHeader()
            self._RequestHeader._deserialize(params.get("RequestHeader"))
        if params.get("ResponseHeader") is not None:
            self._ResponseHeader = ResponseHeader()
            self._ResponseHeader._deserialize(params.get("ResponseHeader"))
        if params.get("Cache") is not None:
            self._Cache = Cache()
            self._Cache._deserialize(params.get("Cache"))
        if params.get("Https") is not None:
            self._Https = Https()
            self._Https._deserialize(params.get("Https"))
        if params.get("Authentication") is not None:
            self._Authentication = Authentication()
            self._Authentication._deserialize(params.get("Authentication"))
        if params.get("ForceRedirect") is not None:
            self._ForceRedirect = ForceRedirect()
            self._ForceRedirect._deserialize(params.get("ForceRedirect"))
        if params.get("Referer") is not None:
            self._Referer = Referer()
            self._Referer._deserialize(params.get("Referer"))
        if params.get("MaxAge") is not None:
            self._MaxAge = MaxAge()
            self._MaxAge._deserialize(params.get("MaxAge"))
        if params.get("Ipv6Access") is not None:
            self._Ipv6Access = Ipv6Access()
            self._Ipv6Access._deserialize(params.get("Ipv6Access"))
        if params.get("Quic") is not None:
            self._Quic = Quic()
            self._Quic._deserialize(params.get("Quic"))
        if params.get("AwsPrivateAccess") is not None:
            self._AwsPrivateAccess = AwsPrivateAccess()
            self._AwsPrivateAccess._deserialize(params.get("AwsPrivateAccess"))
        if params.get("OssPrivateAccess") is not None:
            self._OssPrivateAccess = OssPrivateAccess()
            self._OssPrivateAccess._deserialize(params.get("OssPrivateAccess"))
        if params.get("HwPrivateAccess") is not None:
            self._HwPrivateAccess = HwPrivateAccess()
            self._HwPrivateAccess._deserialize(params.get("HwPrivateAccess"))
        if params.get("OthersPrivateAccess") is not None:
            self._OthersPrivateAccess = OthersPrivateAccess()
            self._OthersPrivateAccess._deserialize(params.get("OthersPrivateAccess"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CDNDomainConfigForUpdate(AbstractModel):
    """CDN domain config for update

    """

    def __init__(self):
        r"""
        :param _Area: Domain name acceleration areas: <li>mainland: acceleration within China; </li> <li>overseas: acceleration outside China; </li> <li>global: global acceleration. </li>
        :type Area: str
        :param _Origin: Origin Server Configuration.
        :type Origin: :class:`tencentcloud.vod.v20180717.models.Origin`
        :param _IpFilter: IP blocklist/allowlist configuration. This is disabled by default.
        :type IpFilter: :class:`tencentcloud.vod.v20180717.models.IpFilter`
        :param _UserAgentFilter: UserAgent:blacklist/whitelist configuration.
        :type UserAgentFilter: :class:`tencentcloud.vod.v20180717.models.UserAgentFilter`
        :param _FollowRedirect: Back to the source 301/302 status code automatically follows the configuration, the default is off
        :type FollowRedirect: :class:`tencentcloud.vod.v20180717.models.FollowRedirect`
        :param _RequestHeader: Custom request header configuration. This is disabled by default.
        :type RequestHeader: :class:`tencentcloud.vod.v20180717.models.RequestHeader`
        :param _ResponseHeader: Custom response header configuration. This is disabled by default.
        :type ResponseHeader: :class:`tencentcloud.vod.v20180717.models.ResponseHeader`
        :param _Cache: Node cache expiration time configuration.
        :type Cache: :class:`tencentcloud.vod.v20180717.models.Cache`
        :param _Https: Domain name HTTPS acceleration configuration. This is disabled by default.
        :type Https: :class:`tencentcloud.vod.v20180717.models.Https`
        :param _Authentication: Timestamp hotlink protection configuration.
        :type Authentication: :class:`tencentcloud.vod.v20180717.models.Authentication`
        :param _ForceRedirect: Access protocol forced redirect configuration. This is disabled by default.
        :type ForceRedirect: :class:`tencentcloud.vod.v20180717.models.ForceRedirect`
        :param _Referer: Referer blacklist/whitelist configuration. This is disabled by default.
        :type Referer: :class:`tencentcloud.vod.v20180717.models.Referer`
        :param _MaxAge: Browser cache rule configuration, which is used to set the default value of MaxAge and is disabled by default.
        :type MaxAge: :class:`tencentcloud.vod.v20180717.models.MaxAge`
        :param _Ipv6Access: IPv6 access configuration.
        :type Ipv6Access: :class:`tencentcloud.vod.v20180717.models.Ipv6Access`
        :param _Quic: QUIC configuration item.
        :type Quic: :class:`tencentcloud.vod.v20180717.models.Quic`
        :param _AwsPrivateAccess: Origin access authentication for S3 bucket.
        :type AwsPrivateAccess: :class:`tencentcloud.vod.v20180717.models.AwsPrivateAccess`
        :param _OssPrivateAccess: Access authentication configuration for OSS origin.
        :type OssPrivateAccess: :class:`tencentcloud.vod.v20180717.models.OssPrivateAccess`
        :param _HwPrivateAccess: Access authentication for Huawei Cloud OBS origin
        :type HwPrivateAccess: :class:`tencentcloud.vod.v20180717.models.HwPrivateAccess`
        :param _OthersPrivateAccess: Origin-pull authentication for other origins.
        :type OthersPrivateAccess: :class:`tencentcloud.vod.v20180717.models.OthersPrivateAccess`
        """
        self._Area = None
        self._Origin = None
        self._IpFilter = None
        self._UserAgentFilter = None
        self._FollowRedirect = None
        self._RequestHeader = None
        self._ResponseHeader = None
        self._Cache = None
        self._Https = None
        self._Authentication = None
        self._ForceRedirect = None
        self._Referer = None
        self._MaxAge = None
        self._Ipv6Access = None
        self._Quic = None
        self._AwsPrivateAccess = None
        self._OssPrivateAccess = None
        self._HwPrivateAccess = None
        self._OthersPrivateAccess = None

    @property
    def Area(self):
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Origin(self):
        return self._Origin

    @Origin.setter
    def Origin(self, Origin):
        self._Origin = Origin

    @property
    def IpFilter(self):
        return self._IpFilter

    @IpFilter.setter
    def IpFilter(self, IpFilter):
        self._IpFilter = IpFilter

    @property
    def UserAgentFilter(self):
        return self._UserAgentFilter

    @UserAgentFilter.setter
    def UserAgentFilter(self, UserAgentFilter):
        self._UserAgentFilter = UserAgentFilter

    @property
    def FollowRedirect(self):
        return self._FollowRedirect

    @FollowRedirect.setter
    def FollowRedirect(self, FollowRedirect):
        self._FollowRedirect = FollowRedirect

    @property
    def RequestHeader(self):
        return self._RequestHeader

    @RequestHeader.setter
    def RequestHeader(self, RequestHeader):
        self._RequestHeader = RequestHeader

    @property
    def ResponseHeader(self):
        return self._ResponseHeader

    @ResponseHeader.setter
    def ResponseHeader(self, ResponseHeader):
        self._ResponseHeader = ResponseHeader

    @property
    def Cache(self):
        return self._Cache

    @Cache.setter
    def Cache(self, Cache):
        self._Cache = Cache

    @property
    def Https(self):
        return self._Https

    @Https.setter
    def Https(self, Https):
        self._Https = Https

    @property
    def Authentication(self):
        return self._Authentication

    @Authentication.setter
    def Authentication(self, Authentication):
        self._Authentication = Authentication

    @property
    def ForceRedirect(self):
        return self._ForceRedirect

    @ForceRedirect.setter
    def ForceRedirect(self, ForceRedirect):
        self._ForceRedirect = ForceRedirect

    @property
    def Referer(self):
        return self._Referer

    @Referer.setter
    def Referer(self, Referer):
        self._Referer = Referer

    @property
    def MaxAge(self):
        return self._MaxAge

    @MaxAge.setter
    def MaxAge(self, MaxAge):
        self._MaxAge = MaxAge

    @property
    def Ipv6Access(self):
        return self._Ipv6Access

    @Ipv6Access.setter
    def Ipv6Access(self, Ipv6Access):
        self._Ipv6Access = Ipv6Access

    @property
    def Quic(self):
        return self._Quic

    @Quic.setter
    def Quic(self, Quic):
        self._Quic = Quic

    @property
    def AwsPrivateAccess(self):
        return self._AwsPrivateAccess

    @AwsPrivateAccess.setter
    def AwsPrivateAccess(self, AwsPrivateAccess):
        self._AwsPrivateAccess = AwsPrivateAccess

    @property
    def OssPrivateAccess(self):
        return self._OssPrivateAccess

    @OssPrivateAccess.setter
    def OssPrivateAccess(self, OssPrivateAccess):
        self._OssPrivateAccess = OssPrivateAccess

    @property
    def HwPrivateAccess(self):
        return self._HwPrivateAccess

    @HwPrivateAccess.setter
    def HwPrivateAccess(self, HwPrivateAccess):
        self._HwPrivateAccess = HwPrivateAccess

    @property
    def OthersPrivateAccess(self):
        return self._OthersPrivateAccess

    @OthersPrivateAccess.setter
    def OthersPrivateAccess(self, OthersPrivateAccess):
        self._OthersPrivateAccess = OthersPrivateAccess


    def _deserialize(self, params):
        self._Area = params.get("Area")
        if params.get("Origin") is not None:
            self._Origin = Origin()
            self._Origin._deserialize(params.get("Origin"))
        if params.get("IpFilter") is not None:
            self._IpFilter = IpFilter()
            self._IpFilter._deserialize(params.get("IpFilter"))
        if params.get("UserAgentFilter") is not None:
            self._UserAgentFilter = UserAgentFilter()
            self._UserAgentFilter._deserialize(params.get("UserAgentFilter"))
        if params.get("FollowRedirect") is not None:
            self._FollowRedirect = FollowRedirect()
            self._FollowRedirect._deserialize(params.get("FollowRedirect"))
        if params.get("RequestHeader") is not None:
            self._RequestHeader = RequestHeader()
            self._RequestHeader._deserialize(params.get("RequestHeader"))
        if params.get("ResponseHeader") is not None:
            self._ResponseHeader = ResponseHeader()
            self._ResponseHeader._deserialize(params.get("ResponseHeader"))
        if params.get("Cache") is not None:
            self._Cache = Cache()
            self._Cache._deserialize(params.get("Cache"))
        if params.get("Https") is not None:
            self._Https = Https()
            self._Https._deserialize(params.get("Https"))
        if params.get("Authentication") is not None:
            self._Authentication = Authentication()
            self._Authentication._deserialize(params.get("Authentication"))
        if params.get("ForceRedirect") is not None:
            self._ForceRedirect = ForceRedirect()
            self._ForceRedirect._deserialize(params.get("ForceRedirect"))
        if params.get("Referer") is not None:
            self._Referer = Referer()
            self._Referer._deserialize(params.get("Referer"))
        if params.get("MaxAge") is not None:
            self._MaxAge = MaxAge()
            self._MaxAge._deserialize(params.get("MaxAge"))
        if params.get("Ipv6Access") is not None:
            self._Ipv6Access = Ipv6Access()
            self._Ipv6Access._deserialize(params.get("Ipv6Access"))
        if params.get("Quic") is not None:
            self._Quic = Quic()
            self._Quic._deserialize(params.get("Quic"))
        if params.get("AwsPrivateAccess") is not None:
            self._AwsPrivateAccess = AwsPrivateAccess()
            self._AwsPrivateAccess._deserialize(params.get("AwsPrivateAccess"))
        if params.get("OssPrivateAccess") is not None:
            self._OssPrivateAccess = OssPrivateAccess()
            self._OssPrivateAccess._deserialize(params.get("OssPrivateAccess"))
        if params.get("HwPrivateAccess") is not None:
            self._HwPrivateAccess = HwPrivateAccess()
            self._HwPrivateAccess._deserialize(params.get("HwPrivateAccess"))
        if params.get("OthersPrivateAccess") is not None:
            self._OthersPrivateAccess = OthersPrivateAccess()
            self._OthersPrivateAccess._deserialize(params.get("OthersPrivateAccess"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CDNDomainInfo(AbstractModel):
    """CDN domain name information

    """

    def __init__(self):
        r"""
        :param _Domain: Domain.
        :type Domain: str
        :param _DeployStatus: Deployment status.
        :type DeployStatus: str
        :param _Cname: Cname record.
        :type Cname: str
        :param _CreateTime: Create Time
        :type CreateTime: str
        :param _Config: CDN domain name configuration information. 
Note: This field may return null, indicating that no valid value can be obtained.
        :type Config: :class:`tencentcloud.vod.v20180717.models.CDNDomainConfig`
        """
        self._Domain = None
        self._DeployStatus = None
        self._Cname = None
        self._CreateTime = None
        self._Config = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def DeployStatus(self):
        return self._DeployStatus

    @DeployStatus.setter
    def DeployStatus(self, DeployStatus):
        self._DeployStatus = DeployStatus

    @property
    def Cname(self):
        return self._Cname

    @Cname.setter
    def Cname(self, Cname):
        self._Cname = Cname

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._DeployStatus = params.get("DeployStatus")
        self._Cname = params.get("Cname")
        self._CreateTime = params.get("CreateTime")
        if params.get("Config") is not None:
            self._Config = CDNDomainConfig()
            self._Config._deserialize(params.get("Config"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Cache(AbstractModel):
    """Node cache expiration time configuration

    """

    def __init__(self):
        r"""
        :param _RuleCache: Path cache configuration.
        :type RuleCache: list of RuleCache
        """
        self._RuleCache = None

    @property
    def RuleCache(self):
        return self._RuleCache

    @RuleCache.setter
    def RuleCache(self, RuleCache):
        self._RuleCache = RuleCache


    def _deserialize(self, params):
        if params.get("RuleCache") is not None:
            self._RuleCache = []
            for item in params.get("RuleCache"):
                obj = RuleCache()
                obj._deserialize(item)
                self._RuleCache.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfigCache(AbstractModel):
    """Path cache configuration

    """

    def __init__(self):
        r"""
        :param _Switch: Path cache configuration switch, the values u200bu200bare: <li>on: on; </li> <li>off: off. </li>
        :type Switch: str
        :param _CacheTime: Cache expiration time settings<li>Unit: second. The maximum value is 365 days.</li>
        :type CacheTime: int
        :param _CompareMaxAge: Advanced cache expiration configuration. When enabled, the max-age value returned by the origin site will be compared with the cache expiration time set in CacheRules, and the minimum value will be used to cache the node. Values: <li>on: enabled; </li> <li >off: off. </li>
        :type CompareMaxAge: str
        :param _IgnoreCacheControl: Force caching, values: <li>on: on; </li> <li>off: off. </li>
        :type IgnoreCacheControl: str
        :param _IgnoreSetCookie: When the origin site returns the Set-Cookie header, whether the node caches the header and body: <li>on: on, does not cache the header and body;</li> <li>off: off, follows user customization Node caching rules. </li>
        :type IgnoreSetCookie: str
        """
        self._Switch = None
        self._CacheTime = None
        self._CompareMaxAge = None
        self._IgnoreCacheControl = None
        self._IgnoreSetCookie = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def CacheTime(self):
        return self._CacheTime

    @CacheTime.setter
    def CacheTime(self, CacheTime):
        self._CacheTime = CacheTime

    @property
    def CompareMaxAge(self):
        return self._CompareMaxAge

    @CompareMaxAge.setter
    def CompareMaxAge(self, CompareMaxAge):
        self._CompareMaxAge = CompareMaxAge

    @property
    def IgnoreCacheControl(self):
        return self._IgnoreCacheControl

    @IgnoreCacheControl.setter
    def IgnoreCacheControl(self, IgnoreCacheControl):
        self._IgnoreCacheControl = IgnoreCacheControl

    @property
    def IgnoreSetCookie(self):
        return self._IgnoreSetCookie

    @IgnoreSetCookie.setter
    def IgnoreSetCookie(self, IgnoreSetCookie):
        self._IgnoreSetCookie = IgnoreSetCookie


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._CacheTime = params.get("CacheTime")
        self._CompareMaxAge = params.get("CompareMaxAge")
        self._IgnoreCacheControl = params.get("IgnoreCacheControl")
        self._IgnoreSetCookie = params.get("IgnoreSetCookie")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfigFollowOrigin(AbstractModel):
    """Path cache configuration follows the origin server configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: The path cache follows the origin site configuration switch. The values u200bu200bare: <li>on: on; </li> <li>off: off. </li>
        :type Switch: str
        :param _HeuristicCache: Heuristic cache configuration
        :type HeuristicCache: :class:`tencentcloud.vod.v20180717.models.HeuristicCache`
        """
        self._Switch = None
        self._HeuristicCache = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def HeuristicCache(self):
        return self._HeuristicCache

    @HeuristicCache.setter
    def HeuristicCache(self, HeuristicCache):
        self._HeuristicCache = HeuristicCache


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        if params.get("HeuristicCache") is not None:
            self._HeuristicCache = HeuristicCache()
            self._HeuristicCache._deserialize(params.get("HeuristicCache"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CacheConfigNoCache(AbstractModel):
    """Path cache/no cache configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Path cache does not cache configuration configuration switch, value: <li>on: on; </li> <li>off: off. </li>
        :type Switch: str
        :param _Revalidate: Always return to the origin site for verification, value: <li>on: on; </li> <li>off: off. </li>
        :type Revalidate: str
        """
        self._Switch = None
        self._Revalidate = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Revalidate(self):
        return self._Revalidate

    @Revalidate.setter
    def Revalidate(self, Revalidate):
        self._Revalidate = Revalidate


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Revalidate = params.get("Revalidate")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class Canvas(AbstractModel):
    """Canvas information. When a video is composed, if the source material (video or image) cannot fill the output video window, the background will be drawn with the set canvas.

    """

    def __init__(self):
        r"""
        :param _Color: Background color. Valid values:
<li>Black: black background</li>
<li>White: white background</li>
Default value: Black.
        :type Color: str
        :param _Width: Canvas width, that is, the width of the output video, value range: 0~3840, unit: px. 
Default value: 0, which means the video width is the same as the first video clip of the first video track.
        :type Width: int
        :param _Height: Canvas height, that is, the height (or long side) of the output video, value range: 0~3840, unit: px. 
Default value: 0, which means the video height is consistent with the first video clip of the first video track.
        :type Height: int
        """
        self._Color = None
        self._Width = None
        self._Height = None

    @property
    def Color(self):
        return self._Color

    @Color.setter
    def Color(self, Color):
        self._Color = Color

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height


    def _deserialize(self, params):
        self._Color = params.get("Color")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CdnLogInfo(AbstractModel):
    """CDN log information

    """

    def __init__(self):
        r"""
        :param _Date: Log date in the format of `yyyy-MM-dd`, such as 2018-03-01.
        :type Date: str
        :param _Name: Log name in the format of date and time-domain name,
such as 2018120101-test.vod2.mqcloud.com.
        :type Name: str
        :param _Url: Log download link, which is valid for 24 hours.
        :type Url: str
        :param _StartTime: Log start time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=)
        :type StartTime: str
        :param _EndTime: Log end time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=)
        :type EndTime: str
        """
        self._Date = None
        self._Name = None
        self._Url = None
        self._StartTime = None
        self._EndTime = None

    @property
    def Date(self):
        return self._Date

    @Date.setter
    def Date(self, Date):
        self._Date = Date

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._Date = params.get("Date")
        self._Name = params.get("Name")
        self._Url = params.get("Url")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfo(AbstractModel):
    """Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClassificationConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent categorization task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent categorization task. Valid values:
<li>ON: enables intelligent categorization task;</li>
<li>OFF: disables intelligent categorization task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipFileInfo2017(AbstractModel):
    """Information of file generated by video clipping (v2017)

    """

    def __init__(self):
        r"""
        :param _ErrCode: Error code
<li>0: success;</li>
<li>Other values: failure.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: Error description.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _FileId: Output target file ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileId: str
        :param _FileUrl: Output target file address.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileUrl: str
        :param _FileType: Output target file type.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ClipTask2017(AbstractModel):
    """The details of a video editing task. This parameter is only valid for tasks initiated by the v2017 video editing API.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video clipping task ID.
        :type TaskId: str
        :param _SrcFileId: ID of source file for video clipping task.
        :type SrcFileId: str
        :param _FileInfo: Information of file output by video clipping.
        :type FileInfo: :class:`tencentcloud.vod.v20180717.models.ClipFileInfo2017`
        """
        self._TaskId = None
        self._SrcFileId = None
        self._FileInfo = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SrcFileId(self):
        return self._SrcFileId

    @SrcFileId.setter
    def SrcFileId(self, SrcFileId):
        self._SrcFileId = SrcFileId

    @property
    def FileInfo(self):
        return self._FileInfo

    @FileInfo.setter
    def FileInfo(self, FileInfo):
        self._FileInfo = FileInfo


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SrcFileId = params.get("SrcFileId")
        if params.get("FileInfo") is not None:
            self._FileInfo = ClipFileInfo2017()
            self._FileInfo._deserialize(params.get("FileInfo"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneCDNDomainRequest(AbstractModel):
    """CloneCDNDomain request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain
        :type Domain: str
        :param _ReferenceDomain: The cloned domain.
        :type ReferenceDomain: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._ReferenceDomain = None
        self._SubAppId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def ReferenceDomain(self):
        return self._ReferenceDomain

    @ReferenceDomain.setter
    def ReferenceDomain(self, ReferenceDomain):
        self._ReferenceDomain = ReferenceDomain

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._ReferenceDomain = params.get("ReferenceDomain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CloneCDNDomainResponse(AbstractModel):
    """CloneCDNDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ColorEnhanceInfo(AbstractModel):
    """Color enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable color enhancement. Valid values:
<li>`ON`</li>
<li>`OFF`</li>
        :type Switch: str
        :param _Type: The color enhancement type. This parameter is valid only if `Switch` is `ON`.
<li>`weak`</li>
<li>`normal`</li>
<li>`strong`</li>
Default value: `weak`.
        :type Type: str
        """
        self._Switch = None
        self._Type = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadRequest(AbstractModel):
    """CommitUpload request structure.

    """

    def __init__(self):
        r"""
        :param _VodSessionKey: VOD session, which takes the returned value (VodSessionKey) of the `ApplyUpload` API.
        :type VodSessionKey: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._VodSessionKey = None
        self._SubAppId = None

    @property
    def VodSessionKey(self):
        return self._VodSessionKey

    @VodSessionKey.setter
    def VodSessionKey(self, VodSessionKey):
        self._VodSessionKey = VodSessionKey

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._VodSessionKey = params.get("VodSessionKey")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CommitUploadResponse(AbstractModel):
    """CommitUpload response structure.

    """

    def __init__(self):
        r"""
        :param _FileId: Unique ID of media file.
        :type FileId: str
        :param _MediaUrl: The media playback URL.
        :type MediaUrl: str
        :param _CoverUrl: The thumbnail URL.
        :type CoverUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._FileId = None
        self._MediaUrl = None
        self._CoverUrl = None
        self._RequestId = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MediaUrl(self):
        return self._MediaUrl

    @MediaUrl.setter
    def MediaUrl(self, MediaUrl):
        self._MediaUrl = MediaUrl

    @property
    def CoverUrl(self):
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._MediaUrl = params.get("MediaUrl")
        self._CoverUrl = params.get("CoverUrl")
        self._RequestId = params.get("RequestId")


class ComposeMediaOutput(AbstractModel):
    """Information of output media file.

    """

    def __init__(self):
        r"""
        :param _FileName: Filename of up to 64 characters.
        :type FileName: str
        :param _Description: Description, which can contain up to 128 characters.
        :type Description: str
        :param _ClassId: Category ID, which is used to categorize the media for management. A category can be created and its ID can be obtained by using the [category creating](https://intl.cloud.tencent.com/document/product/266/7812?from_cn_redirect=1) API.
<li>Default value: 0, which means "Other".</li>
        :type ClassId: int
        :param _ExpireTime: Expiration time of output media file in ISO 8601 format, after which the file will be deleted. Files will never expire by default. For more information, please see [Notes on ISO Date Format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type ExpireTime: str
        :param _Container: Container. Valid values: mp4, mp3. mp3 is for audio files.
        :type Container: str
        :param _VideoStream: Information of output video.
Note: this field may return null, indicating that no valid values can be obtained.
        :type VideoStream: :class:`tencentcloud.vod.v20180717.models.OutputVideoStream`
        :param _AudioStream: Information of output audio.
Note: this field may return null, indicating that no valid values can be obtained.
        :type AudioStream: :class:`tencentcloud.vod.v20180717.models.OutputAudioStream`
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
Default value: 0.
        :type RemoveAudio: int
        """
        self._FileName = None
        self._Description = None
        self._ClassId = None
        self._ExpireTime = None
        self._Container = None
        self._VideoStream = None
        self._AudioStream = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def FileName(self):
        return self._FileName

    @FileName.setter
    def FileName(self, FileName):
        self._FileName = FileName

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def VideoStream(self):
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def AudioStream(self):
        return self._AudioStream

    @AudioStream.setter
    def AudioStream(self, AudioStream):
        self._AudioStream = AudioStream

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._FileName = params.get("FileName")
        self._Description = params.get("Description")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        self._Container = params.get("Container")
        if params.get("VideoStream") is not None:
            self._VideoStream = OutputVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("AudioStream") is not None:
            self._AudioStream = OutputAudioStream()
            self._AudioStream._deserialize(params.get("AudioStream"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaRequest(AbstractModel):
    """ComposeMedia request structure.

    """

    def __init__(self):
        r"""
        :param _Tracks: List of input media tracks, including video, audio, and image tracks. <li>Input tracks are synced to the output media file.</li><li>Input tracks are synced to each other. Videos and images in higher tracks are superimposed over those in lower tracks. Audio tracks are mixed.</li><li>There can be up to 10 tracks for video, audio, and images each.</li><li>The total number of clips in all tracks cannot exceed 500.</li>
        :type Tracks: list of MediaTrack
        :param _Output: Information of output media file.
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Canvas: Canvas used for composing video file.
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _SessionContext: Used to pass through user request information. `ComposeMediaComplete` callback will return the value of this parameter. It contains up to 1,000 characters.
        :type SessionContext: str
        :param _SessionId: Used to identify duplicate requests. After you send a request, if any request with the same `SessionId` has already been sent in the last three days (72 hours), an error message will be returned. `SessionId` contains up to 50 characters. If this parameter is not carried or is an empty string, no deduplication will be performed.
        :type SessionId: str
        """
        self._Tracks = None
        self._Output = None
        self._SubAppId = None
        self._Canvas = None
        self._SessionContext = None
        self._SessionId = None

    @property
    def Tracks(self):
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Canvas(self):
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        self._SubAppId = params.get("SubAppId")
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaResponse(AbstractModel):
    """ComposeMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Media file composing task ID, which can be used to query the status of composing task (with task type being `MakeMedia`).
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ComposeMediaTask(AbstractModel):
    """Media file composing task information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _Status: Task flow status. Valid values:
<li>PROCESSING: processing;</li>
<li>FINISH: completed.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param _ErrCode: Error code
<li>0: success;</li>
<li>Other values: failure.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Progress: Progress of a media file composing task. Value range: [0, 100]
        :type Progress: int
        :param _Input: Input of media file composing task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Input: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskInput`
        :param _Output: Output of media file composing task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTaskOutput`
        :param _MetaData: The metadata of the output video.
Note: This field may return `null`, indicating that no valid value was found.
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        :param _SessionId: ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is not carried or is left empty, no deduplication will be performed.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this parameter. It can contain up to 1000 characters.
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._MetaData = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = ComposeMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskInput(AbstractModel):
    """Input of media file composing task.

    """

    def __init__(self):
        r"""
        :param _Tracks: List of input media tracks, i.e., information of multiple tracks composed of video, audio, image, and other materials.
        :type Tracks: list of MediaTrack
        :param _Canvas: Canvas used for composing video file.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Canvas: :class:`tencentcloud.vod.v20180717.models.Canvas`
        :param _Output: Information of output media file.
        :type Output: :class:`tencentcloud.vod.v20180717.models.ComposeMediaOutput`
        """
        self._Tracks = None
        self._Canvas = None
        self._Output = None

    @property
    def Tracks(self):
        return self._Tracks

    @Tracks.setter
    def Tracks(self, Tracks):
        self._Tracks = Tracks

    @property
    def Canvas(self):
        return self._Canvas

    @Canvas.setter
    def Canvas(self, Canvas):
        self._Canvas = Canvas

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output


    def _deserialize(self, params):
        if params.get("Tracks") is not None:
            self._Tracks = []
            for item in params.get("Tracks"):
                obj = MediaTrack()
                obj._deserialize(item)
                self._Tracks.append(obj)
        if params.get("Canvas") is not None:
            self._Canvas = Canvas()
            self._Canvas._deserialize(params.get("Canvas"))
        if params.get("Output") is not None:
            self._Output = ComposeMediaOutput()
            self._Output._deserialize(params.get("Output"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ComposeMediaTaskOutput(AbstractModel):
    """Output of media file composing task.

    """

    def __init__(self):
        r"""
        :param _FileType: File type, such as mp4 and mp3.
        :type FileType: str
        :param _FileId: Media file ID.
        :type FileId: str
        :param _FileUrl: Media file playback address.
        :type FileUrl: str
        :param _MediaName: Filename of up to 64 characters.
        :type MediaName: str
        :param _ClassId: Category ID, which is used to categorize the media for management. A category can be created and its ID can be obtained by using the [category creating](https://intl.cloud.tencent.com/document/product/266/7812?from_cn_redirect=1) API.
<li>Default value: 0, which means "Other".</li>
        :type ClassId: int
        :param _ExpireTime: Expiration time of output media file in ISO 8601 format, after which the file will be deleted. Files will never expire by default. For more information, please see [Notes on ISO Date Format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type ExpireTime: str
        """
        self._FileType = None
        self._FileId = None
        self._FileUrl = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def MediaName(self):
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._FileType = params.get("FileType")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatFileInfo2017(AbstractModel):
    """Information of source file for video splicing (v2017)

    """

    def __init__(self):
        r"""
        :param _ErrCode: Error code
<li>0: success;</li>
<li>Other values: failure.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _FileId: ID of source file for video splicing.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileId: str
        :param _FileUrl: Address of source file for video splicing.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileUrl: str
        :param _FileType: Format of source file for video splicing.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileType: str
        """
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._FileUrl = None
        self._FileType = None

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType


    def _deserialize(self, params):
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._FileUrl = params.get("FileUrl")
        self._FileType = params.get("FileType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConcatTask2017(AbstractModel):
    """The details of a video splicing task. This parameter is only valid for tasks initiated by the v2017 video splicing API.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video splicing task ID.
        :type TaskId: str
        :param _FileInfoSet: Information of source file for video splicing.
        :type FileInfoSet: list of ConcatFileInfo2017
        """
        self._TaskId = None
        self._FileInfoSet = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def FileInfoSet(self):
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = ConcatFileInfo2017()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsRequest(AbstractModel):
    """ConfirmEvents request structure.

    """

    def __init__(self):
        r"""
        :param _EventHandles: Event handler, i.e., the `EventSet. EventHandle` field in the output parameters of the [event notification pulling](https://intl.cloud.tencent.com/document/product/266/33433?from_cn_redirect=1) API.
Array length limit: 16.
        :type EventHandles: list of str
        :param _ExtInfo: Reserved field for special purposes.
        :type ExtInfo: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._EventHandles = None
        self._ExtInfo = None
        self._SubAppId = None

    @property
    def EventHandles(self):
        return self._EventHandles

    @EventHandles.setter
    def EventHandles(self, EventHandles):
        self._EventHandles = EventHandles

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._EventHandles = params.get("EventHandles")
        self._ExtInfo = params.get("ExtInfo")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ConfirmEventsResponse(AbstractModel):
    """ConfirmEvents response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class ContentReviewOcrResult(AbstractModel):
    """The result for OCR-based image moderation.

    """

    def __init__(self):
        r"""
        :param _Confidence: The confidence score for the OCR-based moderation result. Value range: 0-100.
        :type Confidence: float
        :param _Suggestion: The suggestion for handling the suspicious content detected based on OCR. Valid values:
<li>pass/li>
<li>review</li>
<li>block</li>
        :type Suggestion: str
        :param _KeywordSet: The list of suspicious keywords detected based on OCR.
        :type KeywordSet: list of str
        :param _AreaCoordSet: The coordinates (pixel) of the top-left and bottom-right corners of the frame where a suspicious keyword appears. Format: [x1, y1, x2, y2].
        :type AreaCoordSet: list of int
        """
        self._Confidence = None
        self._Suggestion = None
        self._KeywordSet = None
        self._AreaCoordSet = None

    @property
    def Confidence(self):
        return self._Confidence

    @Confidence.setter
    def Confidence(self, Confidence):
        self._Confidence = Confidence

    @property
    def Suggestion(self):
        return self._Suggestion

    @Suggestion.setter
    def Suggestion(self, Suggestion):
        self._Suggestion = Suggestion

    @property
    def KeywordSet(self):
        return self._KeywordSet

    @KeywordSet.setter
    def KeywordSet(self, KeywordSet):
        self._KeywordSet = KeywordSet

    @property
    def AreaCoordSet(self):
        return self._AreaCoordSet

    @AreaCoordSet.setter
    def AreaCoordSet(self, AreaCoordSet):
        self._AreaCoordSet = AreaCoordSet


    def _deserialize(self, params):
        self._Confidence = params.get("Confidence")
        self._Suggestion = params.get("Suggestion")
        self._KeywordSet = params.get("KeywordSet")
        self._AreaCoordSet = params.get("AreaCoordSet")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewResult(AbstractModel):
    """The result for intelligent image moderation.

    """

    def __init__(self):
        r"""
        :param _Type: The result type. Valid values:
<li>Porn.Image: Pornographic content in the image</li>
<li>Terrorism.Image: Terrorist content in the image</li>
<li>Political.Image: Politically sensitive content in the image</li>
<li>Porn.Ocr: Pornographic content in the image based on OCR</li>
<li>Terrorism.Ocr: Terrorist content in the image based on OCR</li>
<li>Political.Ocr: Politically sensitive content in the image based on OCR</li>
        :type Type: str
        :param _PornImageResult: The pornographic content detected in the image. This parameter is valid if `Type` is `Porn.Image`.
Note: This field may return `null`, indicating that no valid value was found.
        :type PornImageResult: :class:`tencentcloud.vod.v20180717.models.PornImageResult`
        :param _TerrorismImageResult: The terrorist content detected in the image. This parameter is valid if `Type` is `Terrorism.Image`.
Note: This field may return `null`, indicating that no valid value was found.
        :type TerrorismImageResult: :class:`tencentcloud.vod.v20180717.models.TerrorismImageResult`
        :param _PoliticalImageResult: The politically sensitive content detected in the image. This parameter is valid if `Type` is `Political.Image`.
Note: This field may return `null`, indicating that no valid value was found.
        :type PoliticalImageResult: :class:`tencentcloud.vod.v20180717.models.PoliticalImageResult`
        :param _PornOcrResult: The pornographic content detected in the image based on OCR. This parameter is valid if `Type` is `Porn.Ocr`.
Note: This field may return `null`, indicating that no valid value was found.
        :type PornOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _TerrorismOcrResult: The terrorist content detected in the image based on OCR. This parameter is valid if `Type` is `Terrorism.Ocr`.
Note: This field may return `null`, indicating that no valid value was found.
        :type TerrorismOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        :param _PoliticalOcrResult: The politically sensitive content detected in the image based on OCR. This parameter is valid if `Type` is `Political.Ocr`.
Note: This field may return `null`, indicating that no valid value was found.
        :type PoliticalOcrResult: :class:`tencentcloud.vod.v20180717.models.ContentReviewOcrResult`
        """
        self._Type = None
        self._PornImageResult = None
        self._TerrorismImageResult = None
        self._PoliticalImageResult = None
        self._PornOcrResult = None
        self._TerrorismOcrResult = None
        self._PoliticalOcrResult = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PornImageResult(self):
        return self._PornImageResult

    @PornImageResult.setter
    def PornImageResult(self, PornImageResult):
        self._PornImageResult = PornImageResult

    @property
    def TerrorismImageResult(self):
        return self._TerrorismImageResult

    @TerrorismImageResult.setter
    def TerrorismImageResult(self, TerrorismImageResult):
        self._TerrorismImageResult = TerrorismImageResult

    @property
    def PoliticalImageResult(self):
        return self._PoliticalImageResult

    @PoliticalImageResult.setter
    def PoliticalImageResult(self, PoliticalImageResult):
        self._PoliticalImageResult = PoliticalImageResult

    @property
    def PornOcrResult(self):
        return self._PornOcrResult

    @PornOcrResult.setter
    def PornOcrResult(self, PornOcrResult):
        self._PornOcrResult = PornOcrResult

    @property
    def TerrorismOcrResult(self):
        return self._TerrorismOcrResult

    @TerrorismOcrResult.setter
    def TerrorismOcrResult(self, TerrorismOcrResult):
        self._TerrorismOcrResult = TerrorismOcrResult

    @property
    def PoliticalOcrResult(self):
        return self._PoliticalOcrResult

    @PoliticalOcrResult.setter
    def PoliticalOcrResult(self, PoliticalOcrResult):
        self._PoliticalOcrResult = PoliticalOcrResult


    def _deserialize(self, params):
        self._Type = params.get("Type")
        if params.get("PornImageResult") is not None:
            self._PornImageResult = PornImageResult()
            self._PornImageResult._deserialize(params.get("PornImageResult"))
        if params.get("TerrorismImageResult") is not None:
            self._TerrorismImageResult = TerrorismImageResult()
            self._TerrorismImageResult._deserialize(params.get("TerrorismImageResult"))
        if params.get("PoliticalImageResult") is not None:
            self._PoliticalImageResult = PoliticalImageResult()
            self._PoliticalImageResult._deserialize(params.get("PoliticalImageResult"))
        if params.get("PornOcrResult") is not None:
            self._PornOcrResult = ContentReviewOcrResult()
            self._PornOcrResult._deserialize(params.get("PornOcrResult"))
        if params.get("TerrorismOcrResult") is not None:
            self._TerrorismOcrResult = ContentReviewOcrResult()
            self._TerrorismOcrResult._deserialize(params.get("TerrorismOcrResult"))
        if params.get("PoliticalOcrResult") is not None:
            self._PoliticalOcrResult = ContentReviewOcrResult()
            self._PoliticalOcrResult._deserialize(params.get("PoliticalOcrResult"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ContentReviewTemplateItem(AbstractModel):
    """Intelligent recognition template details

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an intelligent recognition template
        :type Definition: int
        :param _Name: Name of an intelligent recognition template. Max 64 characters
        :type Name: str
        :param _Comment: Description of an intelligent recognition template. Max 256 characters
        :type Comment: str
        :param _PornConfigure: Parameters for recognition of pornographic content
Note: This field may return `null`, indicating that no valid value can be found.
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: Parameters for recognition of terrorism content
Note: This field may return `null`, indicating that no valid value can be found.
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: Parameters for recognition of politically sensitive content
Note: This field may return `null`, indicating that no valid value can be found.
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Custom recognition parameters
Note: This field may return `null`, indicating that no valid value can be found.
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ReviewWallSwitch: Whether to subject the recognition result to human review
<li>ON</li>
<li>OFF</li>
        :type ReviewWallSwitch: str
        :param _ScreenshotInterval: Frame capturing interval in seconds. If this parameter is left empty, 1 second will be used by default. Minimum value: 0.5 seconds.
        :type ScreenshotInterval: float
        :param _CreateTime: Creation time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _UpdateTime: Last modified time of template in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type UpdateTime: str
        """
        self._Definition = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ReviewWallSwitch = None
        self._ScreenshotInterval = None
        self._CreateTime = None
        self._UpdateTime = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ReviewWallSwitch(self):
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def ScreenshotInterval(self):
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def UpdateTime(self):
        return self._UpdateTime

    @UpdateTime.setter
    def UpdateTime(self, UpdateTime):
        self._UpdateTime = UpdateTime


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        self._CreateTime = params.get("CreateTime")
        self._UpdateTime = params.get("UpdateTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CopyRightWatermarkInput(AbstractModel):
    """Copyright watermark parameters

    """

    def __init__(self):
        r"""
        :param _Text: Copyright information, maximum length is 200 characters.
        :type Text: str
        """
        self._Text = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskInput(AbstractModel):
    """Input parameter type of cover generating task

    """

    def __init__(self):
        r"""
        :param _Definition: Time point screencapturing template ID.
        :type Definition: int
        :param _PositionType: Screencapturing mode. Valid values:
<li>Time: screencaptures by time point</li>
<li>Percent: screencaptures by percentage</li>
        :type PositionType: str
        :param _PositionValue: Screenshot position:
<li>For time point screencapturing, this means to take a screenshot at a specified time point (in seconds) and use it as the cover</li>
<li>For percentage screencapturing, this value means to take a screenshot at a specified percentage of the video duration and use it as the cover</li>
        :type PositionValue: float
        :param _WatermarkSet: List of up to 10 image or text watermarks.
Note: this field may return null, indicating that no valid values can be obtained.
        :type WatermarkSet: list of WatermarkInput
        """
        self._Definition = None
        self._PositionType = None
        self._PositionValue = None
        self._WatermarkSet = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def PositionType(self):
        return self._PositionType

    @PositionType.setter
    def PositionType(self, PositionType):
        self._PositionType = PositionType

    @property
    def PositionValue(self):
        return self._PositionValue

    @PositionValue.setter
    def PositionValue(self, PositionValue):
        self._PositionValue = PositionValue

    @property
    def WatermarkSet(self):
        return self._WatermarkSet

    @WatermarkSet.setter
    def WatermarkSet(self, WatermarkSet):
        self._WatermarkSet = WatermarkSet


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._PositionType = params.get("PositionType")
        self._PositionValue = params.get("PositionValue")
        if params.get("WatermarkSet") is not None:
            self._WatermarkSet = []
            for item in params.get("WatermarkSet"):
                obj = WatermarkInput()
                obj._deserialize(item)
                self._WatermarkSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverBySnapshotTaskOutput(AbstractModel):
    """Output type of cover generating task

    """

    def __init__(self):
        r"""
        :param _CoverUrl: Cover URL.
        :type CoverUrl: str
        """
        self._CoverUrl = None

    @property
    def CoverUrl(self):
        return self._CoverUrl

    @CoverUrl.setter
    def CoverUrl(self, CoverUrl):
        self._CoverUrl = CoverUrl


    def _deserialize(self, params):
        self._CoverUrl = params.get("CoverUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfo(AbstractModel):
    """Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CoverConfigureInfoForUpdate(AbstractModel):
    """Control parameter of intelligent cover generating task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of intelligent cover generating task. Valid values:
<li>ON: enables intelligent cover generating task;</li>
<li>OFF: disables intelligent cover generating task.</li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfo(AbstractModel):
    """Control parameters for video screen blur detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen distortion detection switch, optional values:
<li>ON: turn on;</li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CrashScreenConfigureInfoForUpdate(AbstractModel):
    """Control parameters for video screen blur detection.

    """

    def __init__(self):
        r"""
        :param _Switch: Video screen distortion detection switch, optional values:
<li>ON: turn on;</li>
<li>OFF: turn off. </li>
        :type Switch: str
        """
        self._Switch = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateRequest(AbstractModel):
    """CreateAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Video content analysis template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Video content analysis template description. Length limit: 256 characters.
        :type Comment: str
        :param _ClassificationConfigure: Control parameter of intelligent categorization task.
        :type ClassificationConfigure: :class:`tencentcloud.vod.v20180717.models.ClassificationConfigureInfo`
        :param _TagConfigure: Control parameter of intelligent tagging task.
        :type TagConfigure: :class:`tencentcloud.vod.v20180717.models.TagConfigureInfo`
        :param _CoverConfigure: Control parameter of intelligent cover generating task.
        :type CoverConfigure: :class:`tencentcloud.vod.v20180717.models.CoverConfigureInfo`
        :param _FrameTagConfigure: Control parameter of intelligent frame-specific tagging task.
        :type FrameTagConfigure: :class:`tencentcloud.vod.v20180717.models.FrameTagConfigureInfo`
        :param _HighlightConfigure: Control parameter of an intelligent highlight generating task.
        :type HighlightConfigure: :class:`tencentcloud.vod.v20180717.models.HighlightsConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ClassificationConfigure = None
        self._TagConfigure = None
        self._CoverConfigure = None
        self._FrameTagConfigure = None
        self._HighlightConfigure = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ClassificationConfigure(self):
        return self._ClassificationConfigure

    @ClassificationConfigure.setter
    def ClassificationConfigure(self, ClassificationConfigure):
        self._ClassificationConfigure = ClassificationConfigure

    @property
    def TagConfigure(self):
        return self._TagConfigure

    @TagConfigure.setter
    def TagConfigure(self, TagConfigure):
        self._TagConfigure = TagConfigure

    @property
    def CoverConfigure(self):
        return self._CoverConfigure

    @CoverConfigure.setter
    def CoverConfigure(self, CoverConfigure):
        self._CoverConfigure = CoverConfigure

    @property
    def FrameTagConfigure(self):
        return self._FrameTagConfigure

    @FrameTagConfigure.setter
    def FrameTagConfigure(self, FrameTagConfigure):
        self._FrameTagConfigure = FrameTagConfigure

    @property
    def HighlightConfigure(self):
        return self._HighlightConfigure

    @HighlightConfigure.setter
    def HighlightConfigure(self, HighlightConfigure):
        self._HighlightConfigure = HighlightConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("ClassificationConfigure") is not None:
            self._ClassificationConfigure = ClassificationConfigureInfo()
            self._ClassificationConfigure._deserialize(params.get("ClassificationConfigure"))
        if params.get("TagConfigure") is not None:
            self._TagConfigure = TagConfigureInfo()
            self._TagConfigure._deserialize(params.get("TagConfigure"))
        if params.get("CoverConfigure") is not None:
            self._CoverConfigure = CoverConfigureInfo()
            self._CoverConfigure._deserialize(params.get("CoverConfigure"))
        if params.get("FrameTagConfigure") is not None:
            self._FrameTagConfigure = FrameTagConfigureInfo()
            self._FrameTagConfigure._deserialize(params.get("FrameTagConfigure"))
        if params.get("HighlightConfigure") is not None:
            self._HighlightConfigure = HighlightsConfigureInfo()
            self._HighlightConfigure._deserialize(params.get("HighlightConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIAnalysisTemplateResponse(AbstractModel):
    """CreateAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAIRecognitionTemplateRequest(AbstractModel):
    """CreateAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Video content recognition template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of video content recognition template. Length limit: 256 characters.
        :type Comment: str
        :param _HeadTailConfigure: Control parameter of video opening and ending credits recognition.
        :type HeadTailConfigure: :class:`tencentcloud.vod.v20180717.models.HeadTailConfigureInfo`
        :param _SegmentConfigure: Control parameter of video splitting recognition.
        :type SegmentConfigure: :class:`tencentcloud.vod.v20180717.models.SegmentConfigureInfo`
        :param _FaceConfigure: Control parameter of face recognition.
        :type FaceConfigure: :class:`tencentcloud.vod.v20180717.models.FaceConfigureInfo`
        :param _OcrFullTextConfigure: Control parameter of full text recognition.
        :type OcrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.OcrFullTextConfigureInfo`
        :param _OcrWordsConfigure: Control parameter of text keyword recognition.
        :type OcrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.OcrWordsConfigureInfo`
        :param _AsrFullTextConfigure: Control parameter of full speech recognition.
        :type AsrFullTextConfigure: :class:`tencentcloud.vod.v20180717.models.AsrFullTextConfigureInfo`
        :param _AsrWordsConfigure: Control parameter of speech keyword recognition.
        :type AsrWordsConfigure: :class:`tencentcloud.vod.v20180717.models.AsrWordsConfigureInfo`
        :param _ObjectConfigure: Control parameter of object recognition.
        :type ObjectConfigure: :class:`tencentcloud.vod.v20180717.models.ObjectConfigureInfo`
        :param _ScreenshotInterval: Frame capturing interval in seconds. If this parameter is left empty, 1 second will be used by default. Minimum value: 0.5 seconds.
        :type ScreenshotInterval: float
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._HeadTailConfigure = None
        self._SegmentConfigure = None
        self._FaceConfigure = None
        self._OcrFullTextConfigure = None
        self._OcrWordsConfigure = None
        self._AsrFullTextConfigure = None
        self._AsrWordsConfigure = None
        self._ObjectConfigure = None
        self._ScreenshotInterval = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadTailConfigure(self):
        return self._HeadTailConfigure

    @HeadTailConfigure.setter
    def HeadTailConfigure(self, HeadTailConfigure):
        self._HeadTailConfigure = HeadTailConfigure

    @property
    def SegmentConfigure(self):
        return self._SegmentConfigure

    @SegmentConfigure.setter
    def SegmentConfigure(self, SegmentConfigure):
        self._SegmentConfigure = SegmentConfigure

    @property
    def FaceConfigure(self):
        return self._FaceConfigure

    @FaceConfigure.setter
    def FaceConfigure(self, FaceConfigure):
        self._FaceConfigure = FaceConfigure

    @property
    def OcrFullTextConfigure(self):
        return self._OcrFullTextConfigure

    @OcrFullTextConfigure.setter
    def OcrFullTextConfigure(self, OcrFullTextConfigure):
        self._OcrFullTextConfigure = OcrFullTextConfigure

    @property
    def OcrWordsConfigure(self):
        return self._OcrWordsConfigure

    @OcrWordsConfigure.setter
    def OcrWordsConfigure(self, OcrWordsConfigure):
        self._OcrWordsConfigure = OcrWordsConfigure

    @property
    def AsrFullTextConfigure(self):
        return self._AsrFullTextConfigure

    @AsrFullTextConfigure.setter
    def AsrFullTextConfigure(self, AsrFullTextConfigure):
        self._AsrFullTextConfigure = AsrFullTextConfigure

    @property
    def AsrWordsConfigure(self):
        return self._AsrWordsConfigure

    @AsrWordsConfigure.setter
    def AsrWordsConfigure(self, AsrWordsConfigure):
        self._AsrWordsConfigure = AsrWordsConfigure

    @property
    def ObjectConfigure(self):
        return self._ObjectConfigure

    @ObjectConfigure.setter
    def ObjectConfigure(self, ObjectConfigure):
        self._ObjectConfigure = ObjectConfigure

    @property
    def ScreenshotInterval(self):
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("HeadTailConfigure") is not None:
            self._HeadTailConfigure = HeadTailConfigureInfo()
            self._HeadTailConfigure._deserialize(params.get("HeadTailConfigure"))
        if params.get("SegmentConfigure") is not None:
            self._SegmentConfigure = SegmentConfigureInfo()
            self._SegmentConfigure._deserialize(params.get("SegmentConfigure"))
        if params.get("FaceConfigure") is not None:
            self._FaceConfigure = FaceConfigureInfo()
            self._FaceConfigure._deserialize(params.get("FaceConfigure"))
        if params.get("OcrFullTextConfigure") is not None:
            self._OcrFullTextConfigure = OcrFullTextConfigureInfo()
            self._OcrFullTextConfigure._deserialize(params.get("OcrFullTextConfigure"))
        if params.get("OcrWordsConfigure") is not None:
            self._OcrWordsConfigure = OcrWordsConfigureInfo()
            self._OcrWordsConfigure._deserialize(params.get("OcrWordsConfigure"))
        if params.get("AsrFullTextConfigure") is not None:
            self._AsrFullTextConfigure = AsrFullTextConfigureInfo()
            self._AsrFullTextConfigure._deserialize(params.get("AsrFullTextConfigure"))
        if params.get("AsrWordsConfigure") is not None:
            self._AsrWordsConfigure = AsrWordsConfigureInfo()
            self._AsrWordsConfigure._deserialize(params.get("AsrWordsConfigure"))
        if params.get("ObjectConfigure") is not None:
            self._ObjectConfigure = ObjectConfigureInfo()
            self._ObjectConfigure._deserialize(params.get("ObjectConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAIRecognitionTemplateResponse(AbstractModel):
    """CreateAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content recognition template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Format: The adaptive bitrate streaming format. Valid values:
<li>HLS</li>
<li>MPEG-DASH</li>
        :type Format: str
        :param _StreamInfos: Parameter information of output substream for adaptive bitrate streaming. Up to 10 substreams can be output.
Note: the frame rate of all substreams must be the same; otherwise, the frame rate of the first substream will be used as the output frame rate.
        :type StreamInfos: list of AdaptiveStreamTemplate
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Template name. Length limit: 64 characters.
        :type Name: str
        :param _DrmType: DRM scheme type, value range:
<li>SimpleAES</li>
<li>Widevine</li>
<li>FairPlay</li>
The default value is an empty string. It is an empty string, indicating that the video will not be DRM protected.
        :type DrmType: str
        :param _DrmKeyProvider: The provider of the DRM key. Valid values:
<li>SDMC</li>
<li>VOD</li>
The default is `VOD`.
        :type DrmKeyProvider: str
        :param _DisableHigherVideoBitrate: Whether to prohibit transcoding video from low bitrate to high bitrate. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: no.
        :type DisableHigherVideoBitrate: int
        :param _DisableHigherVideoResolution: Whether to prohibit transcoding from low resolution to high resolution. Valid values:
<li>0: no,</li>
<li>1: yes.</li>
Default value: no.
        :type DisableHigherVideoResolution: int
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _SegmentType: The segment type. This parameter is valid only if `Format` is `HLS`. Valid values:
<li>ts: TS segment</li>
<li>fmp4: fMP4 segment</li>
Default: ts
        :type SegmentType: str
        """
        self._Format = None
        self._StreamInfos = None
        self._SubAppId = None
        self._Name = None
        self._DrmType = None
        self._DrmKeyProvider = None
        self._DisableHigherVideoBitrate = None
        self._DisableHigherVideoResolution = None
        self._Comment = None
        self._SegmentType = None

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def DrmType(self):
        return self._DrmType

    @DrmType.setter
    def DrmType(self, DrmType):
        self._DrmType = DrmType

    @property
    def DrmKeyProvider(self):
        return self._DrmKeyProvider

    @DrmKeyProvider.setter
    def DrmKeyProvider(self, DrmKeyProvider):
        self._DrmKeyProvider = DrmKeyProvider

    @property
    def DisableHigherVideoBitrate(self):
        return self._DisableHigherVideoBitrate

    @DisableHigherVideoBitrate.setter
    def DisableHigherVideoBitrate(self, DisableHigherVideoBitrate):
        self._DisableHigherVideoBitrate = DisableHigherVideoBitrate

    @property
    def DisableHigherVideoResolution(self):
        return self._DisableHigherVideoResolution

    @DisableHigherVideoResolution.setter
    def DisableHigherVideoResolution(self, DisableHigherVideoResolution):
        self._DisableHigherVideoResolution = DisableHigherVideoResolution

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Format = params.get("Format")
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = AdaptiveStreamTemplate()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._DrmType = params.get("DrmType")
        self._DrmKeyProvider = params.get("DrmKeyProvider")
        self._DisableHigherVideoBitrate = params.get("DisableHigherVideoBitrate")
        self._DisableHigherVideoResolution = params.get("DisableHigherVideoResolution")
        self._Comment = params.get("Comment")
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """CreateAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of adaptive bitrate streaming template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateAnimatedGraphicsTemplateRequest(AbstractModel):
    """CreateAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Fps: Video frame rate in Hz. Value range: [1, 30].
        :type Fps: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Width: Maximum value of the width (or long side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of an animated image in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Animated image format. Valid values: gif; webp. Default value: gif.
        :type Format: str
        :param _Quality: Image quality. Value range: [1, 100]. Default value: 75.
        :type Quality: float
        :param _Name: Name of an animated image generating template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Fps = None
        self._SubAppId = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Quality = None
        self._Name = None
        self._Comment = None

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Quality(self):
        return self._Quality

    @Quality.setter
    def Quality(self, Quality):
        self._Quality = Quality

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Fps = params.get("Fps")
        self._SubAppId = params.get("SubAppId")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Quality = params.get("Quality")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateAnimatedGraphicsTemplateResponse(AbstractModel):
    """CreateAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateCDNDomainRequest(AbstractModel):
    """CreateCDNDomain request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain
        :type Domain: str
        :param _Config: Domain Config
        :type Config: :class:`tencentcloud.vod.v20180717.models.CDNDomainConfig`
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._Config = None
        self._SubAppId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Config(self):
        return self._Config

    @Config.setter
    def Config(self, Config):
        self._Config = Config

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("Config") is not None:
            self._Config = CDNDomainConfig()
            self._Config._deserialize(params.get("Config"))
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateCDNDomainResponse(AbstractModel):
    """CreateCDNDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateClassRequest(AbstractModel):
    """CreateClass request structure.

    """

    def __init__(self):
        r"""
        :param _ParentId: Parent category ID. For a first-level category, enter `-1`.
        :type ParentId: int
        :param _ClassName: Category name. Length limit: 1-64 characters.
        :type ClassName: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._ParentId = None
        self._ClassName = None
        self._SubAppId = None

    @property
    def ParentId(self):
        return self._ParentId

    @ParentId.setter
    def ParentId(self, ParentId):
        self._ParentId = ParentId

    @property
    def ClassName(self):
        return self._ClassName

    @ClassName.setter
    def ClassName(self, ClassName):
        self._ClassName = ClassName

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ParentId = params.get("ParentId")
        self._ClassName = params.get("ClassName")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateClassResponse(AbstractModel):
    """CreateClass response structure.

    """

    def __init__(self):
        r"""
        :param _ClassId: Category ID
        :type ClassId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClassId = None
        self._RequestId = None

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._RequestId = params.get("RequestId")


class CreateContentReviewTemplateRequest(AbstractModel):
    """CreateContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _ReviewWallSwitch: Whether to allow the recognition result to enter the intelligent recognition platform (for human recognition).
<li>ON: yes</li>
<li>OFF: no</li>
        :type ReviewWallSwitch: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Name of an intelligent content recognition template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Description of an intelligent content recognition template. Length limit: 256 characters.
        :type Comment: str
        :param _PornConfigure: Control parameter for porn information.
        :type PornConfigure: :class:`tencentcloud.vod.v20180717.models.PornConfigureInfo`
        :param _TerrorismConfigure: Control parameter for terrorism information.
        :type TerrorismConfigure: :class:`tencentcloud.vod.v20180717.models.TerrorismConfigureInfo`
        :param _PoliticalConfigure: Control parameter for politically sensitive information.
        :type PoliticalConfigure: :class:`tencentcloud.vod.v20180717.models.PoliticalConfigureInfo`
        :param _ProhibitedConfigure: Control parameter of prohibited information detection. Prohibited information includes:
<li>Abusive;</li>
<li>Drug-related.</li>
        :type ProhibitedConfigure: :class:`tencentcloud.vod.v20180717.models.ProhibitedConfigureInfo`
        :param _UserDefineConfigure: Control parameter for custom intelligent content recognition.
        :type UserDefineConfigure: :class:`tencentcloud.vod.v20180717.models.UserDefineConfigureInfo`
        :param _ScreenshotInterval: Frame capturing interval in seconds. If this parameter is left empty, 1 second will be used by default. Minimum value: 0.5 seconds.
        :type ScreenshotInterval: float
        """
        self._ReviewWallSwitch = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._PornConfigure = None
        self._TerrorismConfigure = None
        self._PoliticalConfigure = None
        self._ProhibitedConfigure = None
        self._UserDefineConfigure = None
        self._ScreenshotInterval = None

    @property
    def ReviewWallSwitch(self):
        return self._ReviewWallSwitch

    @ReviewWallSwitch.setter
    def ReviewWallSwitch(self, ReviewWallSwitch):
        self._ReviewWallSwitch = ReviewWallSwitch

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def PornConfigure(self):
        return self._PornConfigure

    @PornConfigure.setter
    def PornConfigure(self, PornConfigure):
        self._PornConfigure = PornConfigure

    @property
    def TerrorismConfigure(self):
        return self._TerrorismConfigure

    @TerrorismConfigure.setter
    def TerrorismConfigure(self, TerrorismConfigure):
        self._TerrorismConfigure = TerrorismConfigure

    @property
    def PoliticalConfigure(self):
        return self._PoliticalConfigure

    @PoliticalConfigure.setter
    def PoliticalConfigure(self, PoliticalConfigure):
        self._PoliticalConfigure = PoliticalConfigure

    @property
    def ProhibitedConfigure(self):
        return self._ProhibitedConfigure

    @ProhibitedConfigure.setter
    def ProhibitedConfigure(self, ProhibitedConfigure):
        self._ProhibitedConfigure = ProhibitedConfigure

    @property
    def UserDefineConfigure(self):
        return self._UserDefineConfigure

    @UserDefineConfigure.setter
    def UserDefineConfigure(self, UserDefineConfigure):
        self._UserDefineConfigure = UserDefineConfigure

    @property
    def ScreenshotInterval(self):
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval


    def _deserialize(self, params):
        self._ReviewWallSwitch = params.get("ReviewWallSwitch")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("PornConfigure") is not None:
            self._PornConfigure = PornConfigureInfo()
            self._PornConfigure._deserialize(params.get("PornConfigure"))
        if params.get("TerrorismConfigure") is not None:
            self._TerrorismConfigure = TerrorismConfigureInfo()
            self._TerrorismConfigure._deserialize(params.get("TerrorismConfigure"))
        if params.get("PoliticalConfigure") is not None:
            self._PoliticalConfigure = PoliticalConfigureInfo()
            self._PoliticalConfigure._deserialize(params.get("PoliticalConfigure"))
        if params.get("ProhibitedConfigure") is not None:
            self._ProhibitedConfigure = ProhibitedConfigureInfo()
            self._ProhibitedConfigure._deserialize(params.get("ProhibitedConfigure"))
        if params.get("UserDefineConfigure") is not None:
            self._UserDefineConfigure = UserDefineConfigureInfo()
            self._UserDefineConfigure._deserialize(params.get("UserDefineConfigure"))
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateContentReviewTemplateResponse(AbstractModel):
    """CreateContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an intelligent recognition template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateDomainVerifyRecordRequest(AbstractModel):
    """CreateDomainVerifyRecord request structure.

    """


class CreateDomainVerifyRecordResponse(AbstractModel):
    """CreateDomainVerifyRecord response structure.

    """

    def __init__(self):
        r"""
        :param _DNSVerifyInfo: DNS Verify Information
        :type DNSVerifyInfo: :class:`tencentcloud.vod.v20180717.models.DNSVerifyInfo`
        :param _FileVerifyInfo: File Verify Information
        :type FileVerifyInfo: :class:`tencentcloud.vod.v20180717.models.FileVerifyInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DNSVerifyInfo = None
        self._FileVerifyInfo = None
        self._RequestId = None

    @property
    def DNSVerifyInfo(self):
        return self._DNSVerifyInfo

    @DNSVerifyInfo.setter
    def DNSVerifyInfo(self, DNSVerifyInfo):
        self._DNSVerifyInfo = DNSVerifyInfo

    @property
    def FileVerifyInfo(self):
        return self._FileVerifyInfo

    @FileVerifyInfo.setter
    def FileVerifyInfo(self, FileVerifyInfo):
        self._FileVerifyInfo = FileVerifyInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DNSVerifyInfo") is not None:
            self._DNSVerifyInfo = DNSVerifyInfo()
            self._DNSVerifyInfo._deserialize(params.get("DNSVerifyInfo"))
        if params.get("FileVerifyInfo") is not None:
            self._FileVerifyInfo = FileVerifyInfo()
            self._FileVerifyInfo._deserialize(params.get("FileVerifyInfo"))
        self._RequestId = params.get("RequestId")


class CreateEnhanceMediaTemplateRequest(AbstractModel):
    """CreateEnhanceMediaTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Container: Output file encapsulation format, optional values: mp4, flv, hls.
        :type Container: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Audio and video quality rebirth template name, length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description information, length limit: 256 characters.
        :type Comment: str
        :param _RebuildVideoInfo: Audio and picture quality regeneration video control control information.
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: Audio and video quality regeneration audio control information.
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: Output target video control information.
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: Output target audio control information.
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: Whether to remove video data, optional values:
<li>0: Keep</li>
<li>1: Remove</li>
Default value 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data, optional values:
<li>0: Keep</li>
<li>1: Remove</li>
Default value 0.
        :type RemoveAudio: int
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateEnhanceMediaTemplateResponse(AbstractModel):
    """CreateEnhanceMediaTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Enhance Media Template ID.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateHeadTailTemplateRequest(AbstractModel):
    """CreateHeadTailTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Template name, length limit is 64 characters.
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Comment: Template description information, length limit is 256 characters.
        :type Comment: str
        :param _HeadCandidateSet: Title candidate list, fill in the FileId of the video. When transcoding, the title closest to the aspect ratio of the feature film will be automatically selected (when the aspect ratio is the same, the front candidate will take precedence). Supports up to 5 candidate titles.
        :type HeadCandidateSet: list of str
        :param _TailCandidateSet: Ending candidate list, fill in the FileId of the video. When transcoding, the ending with the aspect ratio closest to the feature film will be automatically selected (when the aspect ratio is the same, the front candidate will take precedence). Supports up to 5 candidate endings.
        :type TailCandidateSet: list of str
        :param _FillType: Padding method. When the video stream configuration width and height parameters are inconsistent with the aspect ratio of the original video, the transcoding processing method is "padding". Optional filling method:
<li> stretch: stretch, stretch each frame to fill the entire screen, which may cause the transcoded video to be "squashed" or "stretched";</li> 
<li> gauss: Gaussian blur, keep the video aspect ratio unchanged, use Gaussian blur for the remaining edges; </li>
<li> white: leave blank, keep the video aspect ratio unchanged, use the remaining edges for the edge Use white filling; </li>
<li> black: Leave black, keep the video aspect ratio unchanged, and fill the remaining edges with black. </li>
Default value: stretch.
        :type FillType: str
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._HeadCandidateSet = None
        self._TailCandidateSet = None
        self._FillType = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def HeadCandidateSet(self):
        return self._HeadCandidateSet

    @HeadCandidateSet.setter
    def HeadCandidateSet(self, HeadCandidateSet):
        self._HeadCandidateSet = HeadCandidateSet

    @property
    def TailCandidateSet(self):
        return self._TailCandidateSet

    @TailCandidateSet.setter
    def TailCandidateSet(self, TailCandidateSet):
        self._TailCandidateSet = TailCandidateSet

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        self._HeadCandidateSet = params.get("HeadCandidateSet")
        self._TailCandidateSet = params.get("TailCandidateSet")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateHeadTailTemplateResponse(AbstractModel):
    """CreateHeadTailTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Head Tail Template Number
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageProcessingTemplateRequest(AbstractModel):
    """CreateImageProcessingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Operations: An array of image processing operations. The operations will be performed in the specified order.
<li>Length limit: 10.</li>
        :type Operations: list of ImageOperation
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: The name of the image processing template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: The template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Operations = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Operations(self):
        return self._Operations

    @Operations.setter
    def Operations(self, Operations):
        self._Operations = Operations

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        if params.get("Operations") is not None:
            self._Operations = []
            for item in params.get("Operations"):
                obj = ImageOperation()
                obj._deserialize(item)
                self._Operations.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageProcessingTemplateResponse(AbstractModel):
    """CreateImageProcessingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateImageSpriteTask2017(AbstractModel):
    """The details of an image sprite task. This parameter is only valid for tasks initiated by the v2017 image sprite API.

    """

    def __init__(self):
        r"""
        :param _TaskId: Image sprite generating task ID.
        :type TaskId: str
        :param _ErrCode: Error code
<li>0: success;</li>
<li>Other values: failure.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _FileId: ID of generated image sprite file.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileId: str
        :param _Definition: Image sprite specification. For more information, please see [Image Sprite Generating Template](https://intl.cloud.tencent.com/document/product/266/33480?from_cn_redirect=1#.E9.9B.AA.E7.A2.A7.E5.9B.BE.E6.A8.A1.E6.9D.BF).
Note: this field may return null, indicating that no valid values can be obtained.
        :type Definition: int
        :param _TotalCount: Total number of subimages in image sprite.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TotalCount: int
        :param _ImageSpriteUrlSet: Address of output image sprite.
Note: this field may return null, indicating that no valid values can be obtained.
        :type ImageSpriteUrlSet: list of str
        :param _WebVttUrl: Address of WebVtt file for the position-time relationship among subimages in an image sprite.
Note: this field may return null, indicating that no valid values can be obtained.
        :type WebVttUrl: str
        """
        self._TaskId = None
        self._ErrCode = None
        self._Message = None
        self._FileId = None
        self._Definition = None
        self._TotalCount = None
        self._ImageSpriteUrlSet = None
        self._WebVttUrl = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteUrlSet(self):
        return self._ImageSpriteUrlSet

    @ImageSpriteUrlSet.setter
    def ImageSpriteUrlSet(self, ImageSpriteUrlSet):
        self._ImageSpriteUrlSet = ImageSpriteUrlSet

    @property
    def WebVttUrl(self):
        return self._WebVttUrl

    @WebVttUrl.setter
    def WebVttUrl(self, WebVttUrl):
        self._WebVttUrl = WebVttUrl


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._FileId = params.get("FileId")
        self._Definition = params.get("Definition")
        self._TotalCount = params.get("TotalCount")
        self._ImageSpriteUrlSet = params.get("ImageSpriteUrlSet")
        self._WebVttUrl = params.get("WebVttUrl")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateRequest(AbstractModel):
    """CreateImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampling type. Valid values:
<li>Percent: by percent.</li>
<li>Time: by time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _RowCount: The number of rows of small images in the sprite image. 
Note: The number of rows of the small image will affect the height of the final large image. The maximum height of the large image is 15,000 pixels. The height of the large image is the product of the number of rows of the small image and the height of the small image.
        :type RowCount: int
        :param _ColumnCount: The number of columns of small images in the sprite image. 
Note: The number of columns of the small image will affect the width of the final large image. The maximum width of the large image is 15,000 pixels. The width of the large image is the product of the number of columns of the small image and the width of the small image.
        :type ColumnCount: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Name of an image sprite generating template. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
Default value: black.
        :type FillType: str
        :param _Width: The maximum value of the width (or long side) of the small image in the sprite image, value range: 0 and [128, 4096], unit: px. 
<li>When Width and Height are both 0, the resolution is from the same source;</li>
<li>When Width is 0 and Height is non-0, Width is scaled proportionally;</li>
< li>When Width is non-0 and Height is 0, the Height is scaled proportionally; </li>
<li>When both Width and Height are non-0, the resolution is specified by the user. </li>
Default value: 0. 
Note: The width of the small image will affect the width of the final large image. The maximum width of the large image is 15,000 pixels. The width of the large image is the product of the number of columns of the small image and the width of the small image.
        :type Width: int
        :param _Height: The maximum value of the height (or short side) of the small image in the sprite image, value range: 0 and [128, 4096], unit: px. 
<li>When Width and Height are both 0, the resolution is from the same source;</li>
<li>When Width is 0 and Height is non-0, Width is scaled proportionally;</li>
< li>When Width is non-0 and Height is 0, the Height is scaled proportionally; </li>
<li>When both Width and Height are non-0, the resolution is specified by the user. </li>
Default value: 0. 
Note: The height of the small image will affect the height of the final large image. The maximum height of the large image is 15,000 pixels. The height of the large image is the product of the number of rows of the small image and the height of the small image.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: The image format. Valid values:
<li> jpg</li>
<li> png</li>
<li> webp</li>
Default: jpg
        :type Format: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._RowCount = None
        self._ColumnCount = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._FillType = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def RowCount(self):
        return self._RowCount

    @RowCount.setter
    def RowCount(self, RowCount):
        self._RowCount = RowCount

    @property
    def ColumnCount(self):
        return self._ColumnCount

    @ColumnCount.setter
    def ColumnCount(self, ColumnCount):
        self._ColumnCount = ColumnCount

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._RowCount = params.get("RowCount")
        self._ColumnCount = params.get("ColumnCount")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateImageSpriteTemplateResponse(AbstractModel):
    """CreateImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateJustInTimeTranscodeTemplateRequest(AbstractModel):
    """CreateJustInTimeTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Template name, the length is limited to 64 characters.
        :type Name: str
        :param _VideoConfigure: Video parameter configuration.
        :type VideoConfigure: :class:`tencentcloud.vod.v20180717.models.VideoConfigureInfo`
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _WatermarkConfigure: Watermark parameter configuration.
        :type WatermarkConfigure: :class:`tencentcloud.vod.v20180717.models.WatermarkConfigureInfo`
        :param _Comment: Template description, the length is limited to 256 characters.
        :type Comment: str
        """
        self._Name = None
        self._VideoConfigure = None
        self._SubAppId = None
        self._WatermarkConfigure = None
        self._Comment = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def VideoConfigure(self):
        return self._VideoConfigure

    @VideoConfigure.setter
    def VideoConfigure(self, VideoConfigure):
        self._VideoConfigure = VideoConfigure

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def WatermarkConfigure(self):
        return self._WatermarkConfigure

    @WatermarkConfigure.setter
    def WatermarkConfigure(self, WatermarkConfigure):
        self._WatermarkConfigure = WatermarkConfigure

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("VideoConfigure") is not None:
            self._VideoConfigure = VideoConfigureInfo()
            self._VideoConfigure._deserialize(params.get("VideoConfigure"))
        self._SubAppId = params.get("SubAppId")
        if params.get("WatermarkConfigure") is not None:
            self._WatermarkConfigure = WatermarkConfigureInfo()
            self._WatermarkConfigure._deserialize(params.get("WatermarkConfigure"))
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateJustInTimeTranscodeTemplateResponse(AbstractModel):
    """CreateJustInTimeTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreatePersonSampleRequest(AbstractModel):
    """CreatePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Name of a sample. Length limit: 20 characters.
        :type Name: str
        :param _Usages: Usage of a sample. Valid values:
1. Recognition: used for content recognition; equivalent to `Recognition.Face`
2. Review: used for inappropriate information recognition; equivalent to `Review.Face`
3. All: equivalent to 1+2.
        :type Usages: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Description: Description of a sample. Length limit: 1024 characters.
        :type Description: str
        :param _FaceContents: String generated after the sample image is encoded by [Base64](https://tools.ietf.org/html/rfc4648). Only JPEG and PNG images are supported. Array length limit: 5 images.
Note: the image must be a relatively clear full-face photo of a person and has a resolution of no less than 200 x 200.
        :type FaceContents: list of str
        :param _Tags: Tags of a sample
<li>Array length limit: 20 tags</li>
<li>Length limit of a tag: 128 characters</li>
        :type Tags: list of str
        """
        self._Name = None
        self._Usages = None
        self._SubAppId = None
        self._Description = None
        self._FaceContents = None
        self._Tags = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description

    @property
    def FaceContents(self):
        return self._FaceContents

    @FaceContents.setter
    def FaceContents(self, FaceContents):
        self._FaceContents = FaceContents

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Usages = params.get("Usages")
        self._SubAppId = params.get("SubAppId")
        self._Description = params.get("Description")
        self._FaceContents = params.get("FaceContents")
        self._Tags = params.get("Tags")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreatePersonSampleResponse(AbstractModel):
    """CreatePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _Person: Information of a sample.
        :type Person: :class:`tencentcloud.vod.v20180717.models.AiSamplePerson`
        :param _FailFaceInfoSet: Information of samples that failed the verification by facial feature positioning.
        :type FailFaceInfoSet: list of AiSampleFailFaceInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Person = None
        self._FailFaceInfoSet = None
        self._RequestId = None

    @property
    def Person(self):
        return self._Person

    @Person.setter
    def Person(self, Person):
        self._Person = Person

    @property
    def FailFaceInfoSet(self):
        return self._FailFaceInfoSet

    @FailFaceInfoSet.setter
    def FailFaceInfoSet(self, FailFaceInfoSet):
        self._FailFaceInfoSet = FailFaceInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Person") is not None:
            self._Person = AiSamplePerson()
            self._Person._deserialize(params.get("Person"))
        if params.get("FailFaceInfoSet") is not None:
            self._FailFaceInfoSet = []
            for item in params.get("FailFaceInfoSet"):
                obj = AiSampleFailFaceInfo()
                obj._deserialize(item)
                self._FailFaceInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class CreateProcedureTemplateRequest(AbstractModel):
    """CreateProcedureTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Task flow name (up to 20 characters).
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _MediaProcessTask: Parameter of video processing task.
        :type MediaProcessTask: :class:`tencentcloud.vod.v20180717.models.MediaProcessTaskInput`
        :param _AiContentReviewTask: The information of the intelligent moderation task\*.
<font color=red>\*: This parameter is used by our old moderation templates and is not recommended. Please use `ReviewAudioVideoTask` instead.</font> 
        :type AiContentReviewTask: :class:`tencentcloud.vod.v20180717.models.AiContentReviewTaskInput`
        :param _AiAnalysisTask: Parameter of AI-based content analysis task.
        :type AiAnalysisTask: :class:`tencentcloud.vod.v20180717.models.AiAnalysisTaskInput`
        :param _AiRecognitionTask: Type parameter of AI-based content recognition task.
        :type AiRecognitionTask: :class:`tencentcloud.vod.v20180717.models.AiRecognitionTaskInput`
        :param _ReviewAudioVideoTask: The information of the moderation task.
        :type ReviewAudioVideoTask: :class:`tencentcloud.vod.v20180717.models.ProcedureReviewAudioVideoTaskInput`
        """
        self._Name = None
        self._SubAppId = None
        self._Comment = None
        self._MediaProcessTask = None
        self._AiContentReviewTask = None
        self._AiAnalysisTask = None
        self._AiRecognitionTask = None
        self._ReviewAudioVideoTask = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def MediaProcessTask(self):
        return self._MediaProcessTask

    @MediaProcessTask.setter
    def MediaProcessTask(self, MediaProcessTask):
        self._MediaProcessTask = MediaProcessTask

    @property
    def AiContentReviewTask(self):
        return self._AiContentReviewTask

    @AiContentReviewTask.setter
    def AiContentReviewTask(self, AiContentReviewTask):
        self._AiContentReviewTask = AiContentReviewTask

    @property
    def AiAnalysisTask(self):
        return self._AiAnalysisTask

    @AiAnalysisTask.setter
    def AiAnalysisTask(self, AiAnalysisTask):
        self._AiAnalysisTask = AiAnalysisTask

    @property
    def AiRecognitionTask(self):
        return self._AiRecognitionTask

    @AiRecognitionTask.setter
    def AiRecognitionTask(self, AiRecognitionTask):
        self._AiRecognitionTask = AiRecognitionTask

    @property
    def ReviewAudioVideoTask(self):
        return self._ReviewAudioVideoTask

    @ReviewAudioVideoTask.setter
    def ReviewAudioVideoTask(self, ReviewAudioVideoTask):
        self._ReviewAudioVideoTask = ReviewAudioVideoTask


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._Comment = params.get("Comment")
        if params.get("MediaProcessTask") is not None:
            self._MediaProcessTask = MediaProcessTaskInput()
            self._MediaProcessTask._deserialize(params.get("MediaProcessTask"))
        if params.get("AiContentReviewTask") is not None:
            self._AiContentReviewTask = AiContentReviewTaskInput()
            self._AiContentReviewTask._deserialize(params.get("AiContentReviewTask"))
        if params.get("AiAnalysisTask") is not None:
            self._AiAnalysisTask = AiAnalysisTaskInput()
            self._AiAnalysisTask._deserialize(params.get("AiAnalysisTask"))
        if params.get("AiRecognitionTask") is not None:
            self._AiRecognitionTask = AiRecognitionTaskInput()
            self._AiRecognitionTask._deserialize(params.get("AiRecognitionTask"))
        if params.get("ReviewAudioVideoTask") is not None:
            self._ReviewAudioVideoTask = ProcedureReviewAudioVideoTaskInput()
            self._ReviewAudioVideoTask._deserialize(params.get("ReviewAudioVideoTask"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateProcedureTemplateResponse(AbstractModel):
    """CreateProcedureTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateQualityInspectTemplateRequest(AbstractModel):
    """CreateQualityInspectTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Media quality inspect template name.Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _ScreenshotInterval: Frame interval, unit in seconds, minimum value is 1. When not filled, the default frame interval is 1 second.
        :type ScreenshotInterval: float
        :param _JitterConfigure: Control parameters for detecting video jitter and ghosting.
        :type JitterConfigure: :class:`tencentcloud.vod.v20180717.models.JitterConfigureInfo`
        :param _BlurConfigure: Control parameters for detecting video blur.
        :type BlurConfigure: :class:`tencentcloud.vod.v20180717.models.BlurConfigureInfo`
        :param _AbnormalLightingConfigure: Control parameters for detecting low brightness and overexposure of video.
        :type AbnormalLightingConfigure: :class:`tencentcloud.vod.v20180717.models.AbnormalLightingConfigureInfo`
        :param _CrashScreenConfigure: Control parameters for detecting video crash.
        :type CrashScreenConfigure: :class:`tencentcloud.vod.v20180717.models.CrashScreenConfigureInfo`
        :param _BlackWhiteEdgeConfigure: Control parameters for detecting video black edges, white edges, black screen, and white screen.
        :type BlackWhiteEdgeConfigure: :class:`tencentcloud.vod.v20180717.models.BlackWhiteEdgeConfigureInfo`
        :param _NoiseConfigure: Control parameters for detecting video noise.
        :type NoiseConfigure: :class:`tencentcloud.vod.v20180717.models.NoiseConfigureInfo`
        :param _MosaicConfigure: Control parameters for detecting video mosaic.
        :type MosaicConfigure: :class:`tencentcloud.vod.v20180717.models.MosaicConfigureInfo`
        :param _QRCodeConfigure: Control parameters for QR code detection in video.
        :type QRCodeConfigure: :class:`tencentcloud.vod.v20180717.models.QRCodeConfigureInfo`
        :param _VoiceConfigure: Control parameters for audio (mutes, bass, blast sound).
        :type VoiceConfigure: :class:`tencentcloud.vod.v20180717.models.VoiceConfigureInfo`
        :param _QualityEvaluationConfigure: Control parameters for video quality evaluation.
        :type QualityEvaluationConfigure: :class:`tencentcloud.vod.v20180717.models.QualityEvaluationConfigureInfo`
        """
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._ScreenshotInterval = None
        self._JitterConfigure = None
        self._BlurConfigure = None
        self._AbnormalLightingConfigure = None
        self._CrashScreenConfigure = None
        self._BlackWhiteEdgeConfigure = None
        self._NoiseConfigure = None
        self._MosaicConfigure = None
        self._QRCodeConfigure = None
        self._VoiceConfigure = None
        self._QualityEvaluationConfigure = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def ScreenshotInterval(self):
        return self._ScreenshotInterval

    @ScreenshotInterval.setter
    def ScreenshotInterval(self, ScreenshotInterval):
        self._ScreenshotInterval = ScreenshotInterval

    @property
    def JitterConfigure(self):
        return self._JitterConfigure

    @JitterConfigure.setter
    def JitterConfigure(self, JitterConfigure):
        self._JitterConfigure = JitterConfigure

    @property
    def BlurConfigure(self):
        return self._BlurConfigure

    @BlurConfigure.setter
    def BlurConfigure(self, BlurConfigure):
        self._BlurConfigure = BlurConfigure

    @property
    def AbnormalLightingConfigure(self):
        return self._AbnormalLightingConfigure

    @AbnormalLightingConfigure.setter
    def AbnormalLightingConfigure(self, AbnormalLightingConfigure):
        self._AbnormalLightingConfigure = AbnormalLightingConfigure

    @property
    def CrashScreenConfigure(self):
        return self._CrashScreenConfigure

    @CrashScreenConfigure.setter
    def CrashScreenConfigure(self, CrashScreenConfigure):
        self._CrashScreenConfigure = CrashScreenConfigure

    @property
    def BlackWhiteEdgeConfigure(self):
        return self._BlackWhiteEdgeConfigure

    @BlackWhiteEdgeConfigure.setter
    def BlackWhiteEdgeConfigure(self, BlackWhiteEdgeConfigure):
        self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigure

    @property
    def NoiseConfigure(self):
        return self._NoiseConfigure

    @NoiseConfigure.setter
    def NoiseConfigure(self, NoiseConfigure):
        self._NoiseConfigure = NoiseConfigure

    @property
    def MosaicConfigure(self):
        return self._MosaicConfigure

    @MosaicConfigure.setter
    def MosaicConfigure(self, MosaicConfigure):
        self._MosaicConfigure = MosaicConfigure

    @property
    def QRCodeConfigure(self):
        return self._QRCodeConfigure

    @QRCodeConfigure.setter
    def QRCodeConfigure(self, QRCodeConfigure):
        self._QRCodeConfigure = QRCodeConfigure

    @property
    def VoiceConfigure(self):
        return self._VoiceConfigure

    @VoiceConfigure.setter
    def VoiceConfigure(self, VoiceConfigure):
        self._VoiceConfigure = VoiceConfigure

    @property
    def QualityEvaluationConfigure(self):
        return self._QualityEvaluationConfigure

    @QualityEvaluationConfigure.setter
    def QualityEvaluationConfigure(self, QualityEvaluationConfigure):
        self._QualityEvaluationConfigure = QualityEvaluationConfigure


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._ScreenshotInterval = params.get("ScreenshotInterval")
        if params.get("JitterConfigure") is not None:
            self._JitterConfigure = JitterConfigureInfo()
            self._JitterConfigure._deserialize(params.get("JitterConfigure"))
        if params.get("BlurConfigure") is not None:
            self._BlurConfigure = BlurConfigureInfo()
            self._BlurConfigure._deserialize(params.get("BlurConfigure"))
        if params.get("AbnormalLightingConfigure") is not None:
            self._AbnormalLightingConfigure = AbnormalLightingConfigureInfo()
            self._AbnormalLightingConfigure._deserialize(params.get("AbnormalLightingConfigure"))
        if params.get("CrashScreenConfigure") is not None:
            self._CrashScreenConfigure = CrashScreenConfigureInfo()
            self._CrashScreenConfigure._deserialize(params.get("CrashScreenConfigure"))
        if params.get("BlackWhiteEdgeConfigure") is not None:
            self._BlackWhiteEdgeConfigure = BlackWhiteEdgeConfigureInfo()
            self._BlackWhiteEdgeConfigure._deserialize(params.get("BlackWhiteEdgeConfigure"))
        if params.get("NoiseConfigure") is not None:
            self._NoiseConfigure = NoiseConfigureInfo()
            self._NoiseConfigure._deserialize(params.get("NoiseConfigure"))
        if params.get("MosaicConfigure") is not None:
            self._MosaicConfigure = MosaicConfigureInfo()
            self._MosaicConfigure._deserialize(params.get("MosaicConfigure"))
        if params.get("QRCodeConfigure") is not None:
            self._QRCodeConfigure = QRCodeConfigureInfo()
            self._QRCodeConfigure._deserialize(params.get("QRCodeConfigure"))
        if params.get("VoiceConfigure") is not None:
            self._VoiceConfigure = VoiceConfigureInfo()
            self._VoiceConfigure._deserialize(params.get("VoiceConfigure"))
        if params.get("QualityEvaluationConfigure") is not None:
            self._QualityEvaluationConfigure = QualityEvaluationConfigureInfo()
            self._QualityEvaluationConfigure._deserialize(params.get("QualityEvaluationConfigure"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateQualityInspectTemplateResponse(AbstractModel):
    """CreateQualityInspectTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Media quality inspect template ID.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRebuildMediaTemplateRequest(AbstractModel):
    """CreateRebuildMediaTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Container: The output container format. Valid values: `mp4`, `flv`, `hls`.
        :type Container: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: The remaster template name.
        :type Name: str
        :param _Comment: The template description.
        :type Comment: str
        :param _RebuildVideoInfo: The video remaster parameters.
        :type RebuildVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildVideoInfo`
        :param _RebuildAudioInfo: The audio remaster parameters.
        :type RebuildAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildAudioInfo`
        :param _TargetVideoInfo: The output video parameters.
        :type TargetVideoInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetVideoStream`
        :param _TargetAudioInfo: The output audio parameters.
        :type TargetAudioInfo: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTargetAudioStream`
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>`0`: No</li>
<li>`1`: Yes</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>`0`: No</li>
<li>`1`: Yes</li>
Default value: 0.
        :type RemoveAudio: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RebuildVideoInfo = None
        self._RebuildAudioInfo = None
        self._TargetVideoInfo = None
        self._TargetAudioInfo = None
        self._RemoveVideo = None
        self._RemoveAudio = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RebuildVideoInfo(self):
        return self._RebuildVideoInfo

    @RebuildVideoInfo.setter
    def RebuildVideoInfo(self, RebuildVideoInfo):
        self._RebuildVideoInfo = RebuildVideoInfo

    @property
    def RebuildAudioInfo(self):
        return self._RebuildAudioInfo

    @RebuildAudioInfo.setter
    def RebuildAudioInfo(self, RebuildAudioInfo):
        self._RebuildAudioInfo = RebuildAudioInfo

    @property
    def TargetVideoInfo(self):
        return self._TargetVideoInfo

    @TargetVideoInfo.setter
    def TargetVideoInfo(self, TargetVideoInfo):
        self._TargetVideoInfo = TargetVideoInfo

    @property
    def TargetAudioInfo(self):
        return self._TargetAudioInfo

    @TargetAudioInfo.setter
    def TargetAudioInfo(self, TargetAudioInfo):
        self._TargetAudioInfo = TargetAudioInfo

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        if params.get("RebuildVideoInfo") is not None:
            self._RebuildVideoInfo = RebuildVideoInfo()
            self._RebuildVideoInfo._deserialize(params.get("RebuildVideoInfo"))
        if params.get("RebuildAudioInfo") is not None:
            self._RebuildAudioInfo = RebuildAudioInfo()
            self._RebuildAudioInfo._deserialize(params.get("RebuildAudioInfo"))
        if params.get("TargetVideoInfo") is not None:
            self._TargetVideoInfo = RebuildMediaTargetVideoStream()
            self._TargetVideoInfo._deserialize(params.get("TargetVideoInfo"))
        if params.get("TargetAudioInfo") is not None:
            self._TargetAudioInfo = RebuildMediaTargetAudioStream()
            self._TargetAudioInfo._deserialize(params.get("TargetAudioInfo"))
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRebuildMediaTemplateResponse(AbstractModel):
    """CreateRebuildMediaTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Rebuild Media Template ID.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateReviewTemplateRequest(AbstractModel):
    """CreateReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Labels: The violation labels to use. Valid values: <li>`Porn`: Pornographic content</li> <li>`Terror`: Terrorist content</li> <li>`Moan`: Moaning</li>
        :type Labels: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: str
        :param _Name: 
        :type Name: str
        :param _Comment: 
        :type Comment: str
        """
        self._Labels = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None

    @property
    def Labels(self):
        return self._Labels

    @Labels.setter
    def Labels(self, Labels):
        self._Labels = Labels

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Labels = params.get("Labels")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateReviewTemplateResponse(AbstractModel):
    """CreateReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: 
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateRoundPlayRequest(AbstractModel):
    """CreateRoundPlay request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The playback start time, in [ISO 8601 date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type StartTime: str
        :param _RoundPlaylist: The files on the list.
<li>Array length limit: 100.</li>
        :type RoundPlaylist: list of RoundPlayListItemInfo
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: The playlist name (not longer than 64 characters).
        :type Name: str
        :param _Desc: The playlist description (not longer than 256 characters).
        :type Desc: str
        :param _PlayBackMode: Play mode, optional values:
<li>Loop: Play the playlist in a loop;</li>
<li>Linear: Play once, stop playing after the playlist is played. </li>
Default value: Loop.
        :type PlayBackMode: str
        """
        self._StartTime = None
        self._RoundPlaylist = None
        self._SubAppId = None
        self._Name = None
        self._Desc = None
        self._PlayBackMode = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def RoundPlaylist(self):
        return self._RoundPlaylist

    @RoundPlaylist.setter
    def RoundPlaylist(self, RoundPlaylist):
        self._RoundPlaylist = RoundPlaylist

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Desc(self):
        return self._Desc

    @Desc.setter
    def Desc(self, Desc):
        self._Desc = Desc

    @property
    def PlayBackMode(self):
        return self._PlayBackMode

    @PlayBackMode.setter
    def PlayBackMode(self, PlayBackMode):
        self._PlayBackMode = PlayBackMode


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        if params.get("RoundPlaylist") is not None:
            self._RoundPlaylist = []
            for item in params.get("RoundPlaylist"):
                obj = RoundPlayListItemInfo()
                obj._deserialize(item)
                self._RoundPlaylist.append(obj)
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Desc = params.get("Desc")
        self._PlayBackMode = params.get("PlayBackMode")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateRoundPlayResponse(AbstractModel):
    """CreateRoundPlay response structure.

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: The playlist ID, which is unique.
        :type RoundPlayId: str
        :param _Url: The playlist URL.
        :type Url: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RoundPlayId = None
        self._Url = None
        self._RequestId = None

    @property
    def RoundPlayId(self):
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._Url = params.get("Url")
        self._RequestId = params.get("RequestId")


class CreateSampleSnapshotTemplateRequest(AbstractModel):
    """CreateSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SampleType: Sampled screencapturing type. Valid values:
<li>Percent: by percent.</li>
<li>Time: by time interval.</li>
        :type SampleType: str
        :param _SampleInterval: Sampling interval.
<li>If `SampleType` is `Percent`, sampling will be performed at an interval of the specified percentage.</li>
<li>If `SampleType` is `Time`, sampling will be performed at the specified time interval in seconds.</li>
        :type SampleInterval: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Name of a sampled screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Maximum value of the width (or long side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Image format. Valid values: jpg, png. Default value: jpg.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._SampleType = None
        self._SampleInterval = None
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SampleType(self):
        return self._SampleType

    @SampleType.setter
    def SampleType(self, SampleType):
        self._SampleType = SampleType

    @property
    def SampleInterval(self):
        return self._SampleInterval

    @SampleInterval.setter
    def SampleInterval(self, SampleInterval):
        self._SampleInterval = SampleInterval

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SampleType = params.get("SampleType")
        self._SampleInterval = params.get("SampleInterval")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSampleSnapshotTemplateResponse(AbstractModel):
    """CreateSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Name of a time point screencapturing template. Length limit: 64 characters.
        :type Name: str
        :param _Width: Maximum value of the width (or long side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Width: int
        :param _Height: Maximum value of the height (or short side) of a screenshot in px. Value range: 0 and [128, 4,096].
<li>If both `Width` and `Height` are 0, the resolution will be the same as that of the source video;</li>
<li>If `Width` is 0, but `Height` is not 0, `Width` will be proportionally scaled;</li>
<li>If `Width` is not 0, but `Height` is 0, `Height` will be proportionally scaled;</li>
<li>If both `Width` and `Height` are not 0, the custom resolution will be used.</li>
Default value: 0.
        :type Height: int
        :param _ResolutionAdaptive: Resolution adaption. Valid values:
<li>open: enabled. In this case, `Width` represents the long side of a video, while `Height` the short side;</li>
<li>close: disabled. In this case, `Width` represents the width of a video, while `Height` the height.</li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Format: Image format. Valid values: jpg, png. Default value: jpg.
        :type Format: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _FillType: Fill type. "Fill" refers to the way of processing a screenshot when its aspect ratio is different from that of the source video. The following fill types are supported:
<li> stretch: stretch. The screenshot will be stretched frame by frame to match the aspect ratio of the source video, which may make the screenshot "shorter" or "longer";</li>
<li>black: fill with black. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with black color blocks.</li>
<li>white: fill with white. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with white color blocks.</li>
<li>gauss: fill with Gaussian blur. This option retains the aspect ratio of the source video for the screenshot and fills the unmatched area with Gaussian blur.</li>
Default value: black.
        :type FillType: str
        """
        self._SubAppId = None
        self._Name = None
        self._Width = None
        self._Height = None
        self._ResolutionAdaptive = None
        self._Format = None
        self._Comment = None
        self._FillType = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Format(self):
        return self._Format

    @Format.setter
    def Format(self, Format):
        self._Format = Format

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def FillType(self):
        return self._FillType

    @FillType.setter
    def FillType(self, FillType):
        self._FillType = FillType


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Format = params.get("Format")
        self._Comment = params.get("Comment")
        self._FillType = params.get("FillType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """CreateSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a time point screencapturing template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateStorageRegionRequest(AbstractModel):
    """CreateStorageRegion request structure.

    """

    def __init__(self):
        r"""
        :param _StorageRegion: The region to enable storage in, which must be a storage region supported by VOD.
        :type StorageRegion: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._StorageRegion = None
        self._SubAppId = None

    @property
    def StorageRegion(self):
        return self._StorageRegion

    @StorageRegion.setter
    def StorageRegion(self, StorageRegion):
        self._StorageRegion = StorageRegion

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StorageRegion = params.get("StorageRegion")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateStorageRegionResponse(AbstractModel):
    """CreateStorageRegion response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateSubAppIdRequest(AbstractModel):
    """CreateSubAppId request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Subapplication name. Length limit: 40 characters.
        :type Name: str
        :param _Description: Subapplication overview. Length limit: 300 characters.
        :type Description: str
        """
        self._Name = None
        self._Description = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Description(self):
        return self._Description

    @Description.setter
    def Description(self, Description):
        self._Description = Description


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._Description = params.get("Description")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSubAppIdResponse(AbstractModel):
    """CreateSubAppId response structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: ID of created subapplication.
        :type SubAppId: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubAppId = None
        self._RequestId = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RequestId = params.get("RequestId")


class CreateSuperPlayerConfigRequest(AbstractModel):
    """CreateSuperPlayerConfig request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Player configuration name, which can contain up to 64 letters, digits, underscores, and hyphens (such as test_ABC-123) and must be unique under a user.
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _AudioVideoType: Type of audio/video played. Valid values:
<li>AdaptiveDynamicStreaming</li>
<li>Transcode</li>
<li>Original</li>
Default value: `AdaptiveDynamicStream`
        :type AudioVideoType: str
        :param _DrmSwitch: Whether to allow only adaptive bitrate streaming playback protected by DRM. Valid values:
<li>`ON`: allow only adaptive bitrate streaming playback protected by DRM</li>
<li>`OFF`: allow adaptive bitrate streaming playback not protected by DRM</li>
Default value: `OFF`
This parameter is valid when `AudioVideoType` is `AdaptiveDynamicStream`.
        :type DrmSwitch: str
        :param _AdaptiveDynamicStreamingDefinition: ID of the adaptive bitrate streaming template allowed for playback not protected by DRM.

This parameter is required if `AudioVideoType` is `AdaptiveDynamicStream` and `DrmSwitch` is `OFF`.
        :type AdaptiveDynamicStreamingDefinition: int
        :param _DrmStreamingsInfo: Content of the adaptive bitrate streaming template allowed for playback protected by DRM.

This parameter is required if `AudioVideoType` is `AdaptiveDynamicStream` and `DrmSwitch` is `ON`.
        :type DrmStreamingsInfo: :class:`tencentcloud.vod.v20180717.models.DrmStreamingsInfo`
        :param _TranscodeDefinition: ID of the transcoding template allowed for playback

This parameter is required if `AudioVideoType` is `Transcode`.
        :type TranscodeDefinition: int
        :param _ImageSpriteDefinition: ID of the image sprite generating template that allows output.
        :type ImageSpriteDefinition: int
        :param _ResolutionNames: The player displays names for substreams of different resolutions. If left unfilled or filled in a blank array, the default configuration is used:
<li>MinEdgeLength: 240, Name: smooth;</li>
<li>MinEdgeLength: 480, Name: SD; </li>
<li>MinEdgeLength: 720, Name: HD; </li>
<li>MinEdgeLength: 1080, Name: Full HD; </li>
<li>MinEdgeLength: 1440, Name: 2K; </li>
<li>MinEdgeLength: 2160, Name: 4K; </li>
<li>MinEdgeLength: 4320, Name: 8K. </li>
        :type ResolutionNames: list of ResolutionNameInfo
        :param _Domain: Domain name used for playback. If it is left empty or set to `Default`, the domain name configured in [Default Distribution Configuration](https://intl.cloud.tencent.com/document/product/266/33373?from_cn_redirect=1) will be used.
        :type Domain: str
        :param _Scheme: Scheme used for playback. If it is left empty or set to `Default`, the scheme configured in [Default Distribution Configuration](https://intl.cloud.tencent.com/document/product/266/33373?from_cn_redirect=1) will be used. Other valid values:
<li>HTTP;</li>
<li>HTTPS.</li>
        :type Scheme: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        """
        self._Name = None
        self._SubAppId = None
        self._AudioVideoType = None
        self._DrmSwitch = None
        self._AdaptiveDynamicStreamingDefinition = None
        self._DrmStreamingsInfo = None
        self._TranscodeDefinition = None
        self._ImageSpriteDefinition = None
        self._ResolutionNames = None
        self._Domain = None
        self._Scheme = None
        self._Comment = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def AudioVideoType(self):
        return self._AudioVideoType

    @AudioVideoType.setter
    def AudioVideoType(self, AudioVideoType):
        self._AudioVideoType = AudioVideoType

    @property
    def DrmSwitch(self):
        return self._DrmSwitch

    @DrmSwitch.setter
    def DrmSwitch(self, DrmSwitch):
        self._DrmSwitch = DrmSwitch

    @property
    def AdaptiveDynamicStreamingDefinition(self):
        return self._AdaptiveDynamicStreamingDefinition

    @AdaptiveDynamicStreamingDefinition.setter
    def AdaptiveDynamicStreamingDefinition(self, AdaptiveDynamicStreamingDefinition):
        self._AdaptiveDynamicStreamingDefinition = AdaptiveDynamicStreamingDefinition

    @property
    def DrmStreamingsInfo(self):
        return self._DrmStreamingsInfo

    @DrmStreamingsInfo.setter
    def DrmStreamingsInfo(self, DrmStreamingsInfo):
        self._DrmStreamingsInfo = DrmStreamingsInfo

    @property
    def TranscodeDefinition(self):
        return self._TranscodeDefinition

    @TranscodeDefinition.setter
    def TranscodeDefinition(self, TranscodeDefinition):
        self._TranscodeDefinition = TranscodeDefinition

    @property
    def ImageSpriteDefinition(self):
        return self._ImageSpriteDefinition

    @ImageSpriteDefinition.setter
    def ImageSpriteDefinition(self, ImageSpriteDefinition):
        self._ImageSpriteDefinition = ImageSpriteDefinition

    @property
    def ResolutionNames(self):
        return self._ResolutionNames

    @ResolutionNames.setter
    def ResolutionNames(self, ResolutionNames):
        self._ResolutionNames = ResolutionNames

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def Scheme(self):
        return self._Scheme

    @Scheme.setter
    def Scheme(self, Scheme):
        self._Scheme = Scheme

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        self._AudioVideoType = params.get("AudioVideoType")
        self._DrmSwitch = params.get("DrmSwitch")
        self._AdaptiveDynamicStreamingDefinition = params.get("AdaptiveDynamicStreamingDefinition")
        if params.get("DrmStreamingsInfo") is not None:
            self._DrmStreamingsInfo = DrmStreamingsInfo()
            self._DrmStreamingsInfo._deserialize(params.get("DrmStreamingsInfo"))
        self._TranscodeDefinition = params.get("TranscodeDefinition")
        self._ImageSpriteDefinition = params.get("ImageSpriteDefinition")
        if params.get("ResolutionNames") is not None:
            self._ResolutionNames = []
            for item in params.get("ResolutionNames"):
                obj = ResolutionNameInfo()
                obj._deserialize(item)
                self._ResolutionNames.append(obj)
        self._Domain = params.get("Domain")
        self._Scheme = params.get("Scheme")
        self._Comment = params.get("Comment")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateSuperPlayerConfigResponse(AbstractModel):
    """CreateSuperPlayerConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateTranscodeTemplateRequest(AbstractModel):
    """CreateTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Container: The container format. Valid values: `mp4`, `flv`, `hls`, `mp3`, `flac`, `ogg`, `m4a`, `wav` ( `mp3`, `flac`, `ogg`, `m4a`, and `wav` are audio file formats).
        :type Container: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Transcoding template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _RemoveVideo: Whether to remove video data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
Default value: 0.
        :type RemoveVideo: int
        :param _RemoveAudio: Whether to remove audio data. Valid values:
<li>0: retain</li>
<li>1: remove</li>
Default value: 0.
        :type RemoveAudio: int
        :param _VideoTemplate: Video stream configuration parameter. This field is required when `RemoveVideo` is 0.
        :type VideoTemplate: :class:`tencentcloud.vod.v20180717.models.VideoTemplateInfo`
        :param _AudioTemplate: Audio stream configuration parameter. This field is required when `RemoveAudio` is 0.
        :type AudioTemplate: :class:`tencentcloud.vod.v20180717.models.AudioTemplateInfo`
        :param _TEHDConfig: TESHD transcoding parameter.
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.TEHDConfig`
        :param _SegmentType: The segment type. This parameter is valid only if `Container` is `hls`. Valid values:
<li>ts: TS segment</li>
<li>fmp4: fMP4 segment</li>
Default: ts
        :type SegmentType: str
        """
        self._Container = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._RemoveVideo = None
        self._RemoveAudio = None
        self._VideoTemplate = None
        self._AudioTemplate = None
        self._TEHDConfig = None
        self._SegmentType = None

    @property
    def Container(self):
        return self._Container

    @Container.setter
    def Container(self, Container):
        self._Container = Container

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def RemoveVideo(self):
        return self._RemoveVideo

    @RemoveVideo.setter
    def RemoveVideo(self, RemoveVideo):
        self._RemoveVideo = RemoveVideo

    @property
    def RemoveAudio(self):
        return self._RemoveAudio

    @RemoveAudio.setter
    def RemoveAudio(self, RemoveAudio):
        self._RemoveAudio = RemoveAudio

    @property
    def VideoTemplate(self):
        return self._VideoTemplate

    @VideoTemplate.setter
    def VideoTemplate(self, VideoTemplate):
        self._VideoTemplate = VideoTemplate

    @property
    def AudioTemplate(self):
        return self._AudioTemplate

    @AudioTemplate.setter
    def AudioTemplate(self, AudioTemplate):
        self._AudioTemplate = AudioTemplate

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig

    @property
    def SegmentType(self):
        return self._SegmentType

    @SegmentType.setter
    def SegmentType(self, SegmentType):
        self._SegmentType = SegmentType


    def _deserialize(self, params):
        self._Container = params.get("Container")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._RemoveVideo = params.get("RemoveVideo")
        self._RemoveAudio = params.get("RemoveAudio")
        if params.get("VideoTemplate") is not None:
            self._VideoTemplate = VideoTemplateInfo()
            self._VideoTemplate._deserialize(params.get("VideoTemplate"))
        if params.get("AudioTemplate") is not None:
            self._AudioTemplate = AudioTemplateInfo()
            self._AudioTemplate._deserialize(params.get("AudioTemplate"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = TEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        self._SegmentType = params.get("SegmentType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateTranscodeTemplateResponse(AbstractModel):
    """CreateTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of transcoding template.
        :type Definition: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._RequestId = params.get("RequestId")


class CreateVodDomainRequest(AbstractModel):
    """CreateVodDomain request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name to add to VOD. Note: a wildcard domain name is not supported.
        :type Domain: str
        :param _AccelerateArea: Region to enable acceleration. Valid values:
<li>`Chinese Mainland`</li>
<li>`Outside Chinese Mainland`</li>
<li>`Global`</li>
If `AccelerateArea` is not specified, VOD will enable acceleration in or outside Chinese mainland based on the regional information a user has configured with Tencent Cloud.
        :type AccelerateArea: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._AccelerateArea = None
        self._SubAppId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def AccelerateArea(self):
        return self._AccelerateArea

    @AccelerateArea.setter
    def AccelerateArea(self, AccelerateArea):
        self._AccelerateArea = AccelerateArea

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._AccelerateArea = params.get("AccelerateArea")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateVodDomainResponse(AbstractModel):
    """CreateVodDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class CreateWatermarkTemplateRequest(AbstractModel):
    """CreateWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Type: Watermarking type. Valid values:
<li>image: image watermark;</li>
<li>text: text watermark;</li>
<li>svg: SVG watermark.</li>
        :type Type: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Name: Watermarking template name. Length limit: 64 characters.
        :type Name: str
        :param _Comment: Template description. Length limit: 256 characters.
        :type Comment: str
        :param _CoordinateOrigin: Origin position. Valid values:
<li>TopLeft: the origin of coordinates is in the top-left corner of the video, and the origin of the watermark is in the top-left corner of the image or text;</li>
<li>TopRight: the origin of coordinates is in the top-right corner of the video, and the origin of the watermark is in the top-right corner of the image or text;</li>
<li>BottomLeft: the origin of coordinates is in the bottom-left corner of the video, and the origin of the watermark is in the bottom-left corner of the image or text;</li>
<li>BottomRight: the origin of coordinates is in the bottom-right corner of the video, and the origin of the watermark is in the bottom-right corner of the image or text.</li>
Default value: TopLeft.
        :type CoordinateOrigin: str
        :param _XPos: The horizontal position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `XPos` of the watermark will be the specified percentage of the video width; for example, `10%` means that `XPos` is 10% of the video width;</li>
<li>If the string ends in px, the `XPos` of the watermark will be the specified px; for example, `100px` means that `XPos` is 100 px.</li>
Default value: 0 px.
        :type XPos: str
        :param _YPos: The vertical position of the origin of the watermark relative to the origin of coordinates of the video. % and px formats are supported:
<li>If the string ends in %, the `YPos` of the watermark will be the specified percentage of the video height; for example, `10%` means that `YPos` is 10% of the video height;</li>
<li>If the string ends in px, the `YPos` of the watermark will be the specified px; for example, `100px` means that `YPos` is 100 px.</li>
Default value: 0 px.
        :type YPos: str
        :param _ImageTemplate: Image watermarking template. This field is required when `Type` is `image` and is invalid when `Type` is `text`.
        :type ImageTemplate: :class:`tencentcloud.vod.v20180717.models.ImageWatermarkInput`
        :param _TextTemplate: Text watermarking template. This field is required when `Type` is `text` and is invalid when `Type` is `image`.
        :type TextTemplate: :class:`tencentcloud.vod.v20180717.models.TextWatermarkTemplateInput`
        :param _SvgTemplate: SVG watermarking template. This field is required when `Type` is `svg` and is invalid when `Type` is `image` or `text`.
        :type SvgTemplate: :class:`tencentcloud.vod.v20180717.models.SvgWatermarkInput`
        """
        self._Type = None
        self._SubAppId = None
        self._Name = None
        self._Comment = None
        self._CoordinateOrigin = None
        self._XPos = None
        self._YPos = None
        self._ImageTemplate = None
        self._TextTemplate = None
        self._SvgTemplate = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Comment(self):
        return self._Comment

    @Comment.setter
    def Comment(self, Comment):
        self._Comment = Comment

    @property
    def CoordinateOrigin(self):
        return self._CoordinateOrigin

    @CoordinateOrigin.setter
    def CoordinateOrigin(self, CoordinateOrigin):
        self._CoordinateOrigin = CoordinateOrigin

    @property
    def XPos(self):
        return self._XPos

    @XPos.setter
    def XPos(self, XPos):
        self._XPos = XPos

    @property
    def YPos(self):
        return self._YPos

    @YPos.setter
    def YPos(self, YPos):
        self._YPos = YPos

    @property
    def ImageTemplate(self):
        return self._ImageTemplate

    @ImageTemplate.setter
    def ImageTemplate(self, ImageTemplate):
        self._ImageTemplate = ImageTemplate

    @property
    def TextTemplate(self):
        return self._TextTemplate

    @TextTemplate.setter
    def TextTemplate(self, TextTemplate):
        self._TextTemplate = TextTemplate

    @property
    def SvgTemplate(self):
        return self._SvgTemplate

    @SvgTemplate.setter
    def SvgTemplate(self, SvgTemplate):
        self._SvgTemplate = SvgTemplate


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._SubAppId = params.get("SubAppId")
        self._Name = params.get("Name")
        self._Comment = params.get("Comment")
        self._CoordinateOrigin = params.get("CoordinateOrigin")
        self._XPos = params.get("XPos")
        self._YPos = params.get("YPos")
        if params.get("ImageTemplate") is not None:
            self._ImageTemplate = ImageWatermarkInput()
            self._ImageTemplate._deserialize(params.get("ImageTemplate"))
        if params.get("TextTemplate") is not None:
            self._TextTemplate = TextWatermarkTemplateInput()
            self._TextTemplate._deserialize(params.get("TextTemplate"))
        if params.get("SvgTemplate") is not None:
            self._SvgTemplate = SvgWatermarkInput()
            self._SvgTemplate._deserialize(params.get("SvgTemplate"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWatermarkTemplateResponse(AbstractModel):
    """CreateWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of watermarking template.
        :type Definition: int
        :param _ImageUrl: Watermark image address. This field is valid only when `Type` is `image`.
        :type ImageUrl: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Definition = None
        self._ImageUrl = None
        self._RequestId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ImageUrl(self):
        return self._ImageUrl

    @ImageUrl.setter
    def ImageUrl(self, ImageUrl):
        self._ImageUrl = ImageUrl

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._ImageUrl = params.get("ImageUrl")
        self._RequestId = params.get("RequestId")


class CreateWordSamplesRequest(AbstractModel):
    """CreateWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
7. All: ASR- and OCR-based content recognition and inappropriate information recognition; equivalent to 1+2+3+4
        :type Usages: list of str
        :param _Words: Keyword. Array length limit: 100.
        :type Words: list of AiSampleWordInfo
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Usages = None
        self._Words = None
        self._SubAppId = None

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Words(self):
        return self._Words

    @Words.setter
    def Words(self, Words):
        self._Words = Words

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Usages = params.get("Usages")
        if params.get("Words") is not None:
            self._Words = []
            for item in params.get("Words"):
                obj = AiSampleWordInfo()
                obj._deserialize(item)
                self._Words.append(obj)
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class CreateWordSamplesResponse(AbstractModel):
    """CreateWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DNSVerifyInfo(AbstractModel):
    """DNS verification information

    """

    def __init__(self):
        r"""
        :param _SubDomain: sub-parsing.
        :type SubDomain: str
        :param _Record: parse value.
        :type Record: str
        :param _RecordType: parsing type.
        :type RecordType: str
        """
        self._SubDomain = None
        self._Record = None
        self._RecordType = None

    @property
    def SubDomain(self):
        return self._SubDomain

    @SubDomain.setter
    def SubDomain(self, SubDomain):
        self._SubDomain = SubDomain

    @property
    def Record(self):
        return self._Record

    @Record.setter
    def Record(self, Record):
        self._Record = Record

    @property
    def RecordType(self):
        return self._RecordType

    @RecordType.setter
    def RecordType(self, RecordType):
        self._RecordType = RecordType


    def _deserialize(self, params):
        self._SubDomain = params.get("SubDomain")
        self._Record = params.get("Record")
        self._RecordType = params.get("RecordType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateRequest(AbstractModel):
    """DeleteAIAnalysisTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content analysis template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIAnalysisTemplateResponse(AbstractModel):
    """DeleteAIAnalysisTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAIRecognitionTemplateRequest(AbstractModel):
    """DeleteAIRecognitionTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of video content recognition template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAIRecognitionTemplateResponse(AbstractModel):
    """DeleteAIRecognitionTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAdaptiveDynamicStreamingTemplateRequest(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of adaptive bitrate streaming template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAdaptiveDynamicStreamingTemplateResponse(AbstractModel):
    """DeleteAdaptiveDynamicStreamingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteAnimatedGraphicsTemplateRequest(AbstractModel):
    """DeleteAnimatedGraphicsTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an animated image generating template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteAnimatedGraphicsTemplateResponse(AbstractModel):
    """DeleteAnimatedGraphicsTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteCDNDomainRequest(AbstractModel):
    """DeleteCDNDomain request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain.
        :type Domain: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._SubAppId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteCDNDomainResponse(AbstractModel):
    """DeleteCDNDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteClassRequest(AbstractModel):
    """DeleteClass request structure.

    """

    def __init__(self):
        r"""
        :param _ClassId: Category ID
        :type ClassId: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._ClassId = None
        self._SubAppId = None

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._ClassId = params.get("ClassId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteClassResponse(AbstractModel):
    """DeleteClass response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteContentReviewTemplateRequest(AbstractModel):
    """DeleteContentReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an intelligent content recognition template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteContentReviewTemplateResponse(AbstractModel):
    """DeleteContentReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteEnhanceMediaTemplateRequest(AbstractModel):
    """DeleteEnhanceMediaTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Enhance Media Template ID
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteEnhanceMediaTemplateResponse(AbstractModel):
    """DeleteEnhanceMediaTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteHeadTailTemplateRequest(AbstractModel):
    """DeleteHeadTailTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Head Tail Template Number.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteHeadTailTemplateResponse(AbstractModel):
    """DeleteHeadTailTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageProcessingTemplateRequest(AbstractModel):
    """DeleteImageProcessingTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The template ID.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageProcessingTemplateResponse(AbstractModel):
    """DeleteImageProcessingTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteImageSpriteTemplateRequest(AbstractModel):
    """DeleteImageSpriteTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of an image sprite generating template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteImageSpriteTemplateResponse(AbstractModel):
    """DeleteImageSpriteTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteJustInTimeTranscodeTemplateRequest(AbstractModel):
    """DeleteJustInTimeTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Template name.
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteJustInTimeTranscodeTemplateResponse(AbstractModel):
    """DeleteJustInTimeTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteMediaRequest(AbstractModel):
    """DeleteMedia request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: Unique media file ID.
        :type FileId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _DeleteParts: Content to be deleted. The default value is "[]", which indicates to delete the media file and all its corresponding files generated by video processing.
        :type DeleteParts: list of MediaDeleteItem
        """
        self._FileId = None
        self._SubAppId = None
        self._DeleteParts = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DeleteParts(self):
        return self._DeleteParts

    @DeleteParts.setter
    def DeleteParts(self, DeleteParts):
        self._DeleteParts = DeleteParts


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        if params.get("DeleteParts") is not None:
            self._DeleteParts = []
            for item in params.get("DeleteParts"):
                obj = MediaDeleteItem()
                obj._deserialize(item)
                self._DeleteParts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteMediaResponse(AbstractModel):
    """DeleteMedia response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeletePersonSampleRequest(AbstractModel):
    """DeletePersonSample request structure.

    """

    def __init__(self):
        r"""
        :param _PersonId: ID of a sample.
        :type PersonId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._PersonId = None
        self._SubAppId = None

    @property
    def PersonId(self):
        return self._PersonId

    @PersonId.setter
    def PersonId(self, PersonId):
        self._PersonId = PersonId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._PersonId = params.get("PersonId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeletePersonSampleResponse(AbstractModel):
    """DeletePersonSample response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteProcedureTemplateRequest(AbstractModel):
    """DeleteProcedureTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Task flow name.
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteProcedureTemplateResponse(AbstractModel):
    """DeleteProcedureTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteQualityInspectTemplateRequest(AbstractModel):
    """DeleteQualityInspectTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Media quality inspection template ID.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteQualityInspectTemplateResponse(AbstractModel):
    """DeleteQualityInspectTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRebuildMediaTemplateRequest(AbstractModel):
    """DeleteRebuildMediaTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Rebuild Media Template ID.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRebuildMediaTemplateResponse(AbstractModel):
    """DeleteRebuildMediaTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteReviewTemplateRequest(AbstractModel):
    """DeleteReviewTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: The unique ID of the moderation template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteReviewTemplateResponse(AbstractModel):
    """DeleteReviewTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteRoundPlayRequest(AbstractModel):
    """DeleteRoundPlay request structure.

    """

    def __init__(self):
        r"""
        :param _RoundPlayId: The playlist ID, which is unique.
        :type RoundPlayId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._RoundPlayId = None
        self._SubAppId = None

    @property
    def RoundPlayId(self):
        return self._RoundPlayId

    @RoundPlayId.setter
    def RoundPlayId(self, RoundPlayId):
        self._RoundPlayId = RoundPlayId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._RoundPlayId = params.get("RoundPlayId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteRoundPlayResponse(AbstractModel):
    """DeleteRoundPlay response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSampleSnapshotTemplateRequest(AbstractModel):
    """DeleteSampleSnapshotTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a sampled screencapturing template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSampleSnapshotTemplateResponse(AbstractModel):
    """DeleteSampleSnapshotTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSnapshotByTimeOffsetTemplateRequest(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of a specified time point screencapturing template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSnapshotByTimeOffsetTemplateResponse(AbstractModel):
    """DeleteSnapshotByTimeOffsetTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteSuperPlayerConfigRequest(AbstractModel):
    """DeleteSuperPlayerConfig request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Player configuration name.
        :type Name: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Name = None
        self._SubAppId = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Name = params.get("Name")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteSuperPlayerConfigResponse(AbstractModel):
    """DeleteSuperPlayerConfig response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteTranscodeTemplateRequest(AbstractModel):
    """DeleteTranscodeTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of transcoding template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteTranscodeTemplateResponse(AbstractModel):
    """DeleteTranscodeTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteVodDomainRequest(AbstractModel):
    """DeleteVodDomain request structure.

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name to delete from VOD
        :type Domain: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domain = None
        self._SubAppId = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteVodDomainResponse(AbstractModel):
    """DeleteVodDomain response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWatermarkTemplateRequest(AbstractModel):
    """DeleteWatermarkTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _Definition: Unique ID of watermarking template.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Definition = None
        self._SubAppId = None

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWatermarkTemplateResponse(AbstractModel):
    """DeleteWatermarkTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DeleteWordSamplesRequest(AbstractModel):
    """DeleteWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _Keywords: Keyword. Array length limit: 100 words.
        :type Keywords: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Keywords = None
        self._SubAppId = None

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Keywords = params.get("Keywords")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DeleteWordSamplesResponse(AbstractModel):
    """DeleteWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._RequestId = None

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._RequestId = params.get("RequestId")


class DescribeAIAnalysisTemplatesRequest(AbstractModel):
    """DescribeAIAnalysisTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of video content analysis templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIAnalysisTemplatesResponse(AbstractModel):
    """DescribeAIAnalysisTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIAnalysisTemplateSet: List of video content analysis template details.
        :type AIAnalysisTemplateSet: list of AIAnalysisTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIAnalysisTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIAnalysisTemplateSet(self):
        return self._AIAnalysisTemplateSet

    @AIAnalysisTemplateSet.setter
    def AIAnalysisTemplateSet(self, AIAnalysisTemplateSet):
        self._AIAnalysisTemplateSet = AIAnalysisTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIAnalysisTemplateSet") is not None:
            self._AIAnalysisTemplateSet = []
            for item in params.get("AIAnalysisTemplateSet"):
                obj = AIAnalysisTemplateItem()
                obj._deserialize(item)
                self._AIAnalysisTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAIRecognitionTemplatesRequest(AbstractModel):
    """DescribeAIRecognitionTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of video content recognition templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAIRecognitionTemplatesResponse(AbstractModel):
    """DescribeAIRecognitionTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AIRecognitionTemplateSet: List of video content recognition template details.
        :type AIRecognitionTemplateSet: list of AIRecognitionTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AIRecognitionTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AIRecognitionTemplateSet(self):
        return self._AIRecognitionTemplateSet

    @AIRecognitionTemplateSet.setter
    def AIRecognitionTemplateSet(self, AIRecognitionTemplateSet):
        self._AIRecognitionTemplateSet = AIRecognitionTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AIRecognitionTemplateSet") is not None:
            self._AIRecognitionTemplateSet = []
            for item in params.get("AIRecognitionTemplateSet"):
                obj = AIRecognitionTemplateItem()
                obj._deserialize(item)
                self._AIRecognitionTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAdaptiveDynamicStreamingTemplatesRequest(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of transcoding to adaptive bitrate streaming templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paged offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAdaptiveDynamicStreamingTemplatesResponse(AbstractModel):
    """DescribeAdaptiveDynamicStreamingTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AdaptiveDynamicStreamingTemplateSet: List of transcoding to adaptive bitrate streaming template details.
        :type AdaptiveDynamicStreamingTemplateSet: list of AdaptiveDynamicStreamingTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AdaptiveDynamicStreamingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AdaptiveDynamicStreamingTemplateSet(self):
        return self._AdaptiveDynamicStreamingTemplateSet

    @AdaptiveDynamicStreamingTemplateSet.setter
    def AdaptiveDynamicStreamingTemplateSet(self, AdaptiveDynamicStreamingTemplateSet):
        self._AdaptiveDynamicStreamingTemplateSet = AdaptiveDynamicStreamingTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AdaptiveDynamicStreamingTemplateSet") is not None:
            self._AdaptiveDynamicStreamingTemplateSet = []
            for item in params.get("AdaptiveDynamicStreamingTemplateSet"):
                obj = AdaptiveDynamicStreamingTemplate()
                obj._deserialize(item)
                self._AdaptiveDynamicStreamingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAllClassRequest(AbstractModel):
    """DescribeAllClass request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAllClassResponse(AbstractModel):
    """DescribeAllClass response structure.

    """

    def __init__(self):
        r"""
        :param _ClassInfoSet: Category information set
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClassInfoSet: list of MediaClassInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClassInfoSet = None
        self._RequestId = None

    @property
    def ClassInfoSet(self):
        return self._ClassInfoSet

    @ClassInfoSet.setter
    def ClassInfoSet(self, ClassInfoSet):
        self._ClassInfoSet = ClassInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClassInfoSet") is not None:
            self._ClassInfoSet = []
            for item in params.get("ClassInfoSet"):
                obj = MediaClassInfo()
                obj._deserialize(item)
                self._ClassInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeAnimatedGraphicsTemplatesRequest(AbstractModel):
    """DescribeAnimatedGraphicsTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of animated image generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paged offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeAnimatedGraphicsTemplatesResponse(AbstractModel):
    """DescribeAnimatedGraphicsTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _AnimatedGraphicsTemplateSet: List of animated image generating template details.
        :type AnimatedGraphicsTemplateSet: list of AnimatedGraphicsTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._AnimatedGraphicsTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def AnimatedGraphicsTemplateSet(self):
        return self._AnimatedGraphicsTemplateSet

    @AnimatedGraphicsTemplateSet.setter
    def AnimatedGraphicsTemplateSet(self, AnimatedGraphicsTemplateSet):
        self._AnimatedGraphicsTemplateSet = AnimatedGraphicsTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("AnimatedGraphicsTemplateSet") is not None:
            self._AnimatedGraphicsTemplateSet = []
            for item in params.get("AnimatedGraphicsTemplateSet"):
                obj = AnimatedGraphicsTemplate()
                obj._deserialize(item)
                self._AnimatedGraphicsTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNDomainsRequest(AbstractModel):
    """DescribeCDNDomains request structure.

    """

    def __init__(self):
        r"""
        :param _Domains: List of domain. If this field is left blank, all domain information will be listed by default.
        :type Domains: list of str
        :param _Limit: The maximum number of returned results for pagination fetching. Default value: 20.
        :type Limit: int
        :param _Offset: The starting offset of paged pull. Default value: 0.
        :type Offset: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domains = None
        self._Limit = None
        self._Offset = None
        self._SubAppId = None

    @property
    def Domains(self):
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNDomainsResponse(AbstractModel):
    """DescribeCDNDomains response structure.

    """

    def __init__(self):
        r"""
        :param _DomainSet: Domain information list.
        :type DomainSet: list of CDNDomainInfo
        :param _TotalCount: The total number of CDN domains under the current application.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DomainSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def DomainSet(self):
        return self._DomainSet

    @DomainSet.setter
    def DomainSet(self, DomainSet):
        self._DomainSet = DomainSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("DomainSet") is not None:
            self._DomainSet = []
            for item in params.get("DomainSet"):
                obj = CDNDomainInfo()
                obj._deserialize(item)
                self._DomainSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeCDNStatDetailsRequest(AbstractModel):
    """DescribeCDNStatDetails request structure.

    """

    def __init__(self):
        r"""
        :param _Metric: Query indicators, the values u200bu200bare:
<li>Traffic: traffic, unit is Byte. </li>
<li>Bandwidth: Bandwidth, unit is Bps. </li>
<li>Requests: Number of requests. </li>
<li>QUICRequests: Number of QUIC requests. </li>
<li>IpVisit: Number of IP visits. </li>
        :type Metric: str
        :param _StartTime: Start time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type StartTime: str
        :param _EndTime: End time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _DomainNames: List of domain names. The usage data of up to 20 domain names can be queried at a time. The usage data of all domain names is returned by default.
        :type DomainNames: list of str
        :param _Area: Service region. Valid values:
<li>Chinese Mainland</li>
<li>Asia Pacific Region 1: Hong Kong (China), Macao (China), Singapore, Vietnam, and Thailand</li>
<li>Asia Pacific Region 2: Taiwan (China), Japan, Malaysia, Indonesia, and South Korea</li>
<li>Asia Pacific Region 3: Philippines, India, Australia, and other Asia Pacific countries and regions</li>
<li>Middle East</li>
<li>Europe</li>
<li>North America</li>
<li>South America</li>
<li>Africa</li>
Default value: Chinese Mainland
        :type Area: str
        :param _Districts: District where users are located. When `Area` is `Chinese Mainland`, valid values for `Districts` are as follows. Otherwise, `Districts` can be ignored.
<li>Beijing</li>
<li>Inner Mongolia</li>
<li>Shanxi</li>
<li>Hebei</li>
<li>Tianjin</li>
<li>Ningxia</li>
<li>Shaanxi</li>
<li>Gansu</li>
<li>Qinghai</li>
<li>Xinjiang</li>
<li>Heilongjiang</li>
<li>Jilin</li>
<li>Liaoning</li>
<li>Fujian</li>
<li>Jiangsu</li>
<li>Anhui</li>
<li>Shandong</li>
<li>Shanghai</li>
<li>Zhejiang</li>
<li>Henan</li>
<li>Hubei</li>
<li>Jiangxi</li>
<li>Hunan</li>
<li>Guizhou</li>
<li>Yunnan</li>
<li>Chongqing</li>
<li>Sichuan</li>
<li>Tibet</li>
<li>Guangdong</li>
<li>Guangxi</li>
<li>Hainan</li>
<li>Hong Kong, Macao and Taiwan</li>
<li>Outside Chinese Mainland</li>
<li>Other</li>
        :type Districts: list of str
        :param _Isps: ISP of users. When `Area` is `Chinese Mainland`, valid values for `Isps` are as follows. Otherwise, `Isps` can be ignored.
<li>China Telecom</li>
<li>China Unicom</li>
<li>CERNET</li>
<li>Great Wall Broadband Network</li>
<li>China Mobile</li>
<li>China Mobile Tietong</li>
<li>ISPs outside Chinese Mainland</li>
<li>Other ISPs</li>
        :type Isps: list of str
        :param _DataInterval: Time granularity of every piece of data in minutes. Valid values:
<li>5: 5-minute granularity. The data at 5-minute granularity in the query period will be returned.</li>
<li>1440: 1-day granularity. The data at 1-day granularity in the query period will be returned. If the query period is larger than 24 hours, only data at 1-day granularity can be queried.</li>
If the difference between `StartTime` and `EndTime` is larger than 24 hours, the default value of `DataInterval` is 1440.
        :type DataInterval: int
        """
        self._Metric = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._DomainNames = None
        self._Area = None
        self._Districts = None
        self._Isps = None
        self._DataInterval = None

    @property
    def Metric(self):
        return self._Metric

    @Metric.setter
    def Metric(self, Metric):
        self._Metric = Metric

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DomainNames(self):
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames

    @property
    def Area(self):
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area

    @property
    def Districts(self):
        return self._Districts

    @Districts.setter
    def Districts(self, Districts):
        self._Districts = Districts

    @property
    def Isps(self):
        return self._Isps

    @Isps.setter
    def Isps(self, Isps):
        self._Isps = Isps

    @property
    def DataInterval(self):
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval


    def _deserialize(self, params):
        self._Metric = params.get("Metric")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._DomainNames = params.get("DomainNames")
        self._Area = params.get("Area")
        self._Districts = params.get("Districts")
        self._Isps = params.get("Isps")
        self._DataInterval = params.get("DataInterval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNStatDetailsResponse(AbstractModel):
    """DescribeCDNStatDetails response structure.

    """

    def __init__(self):
        r"""
        :param _DataInterval: Time granularity of every piece of data in minutes.
        :type DataInterval: int
        :param _Data: CDN usage statistics.
        :type Data: list of StatDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCDNUsageDataRequest(AbstractModel):
    """DescribeCDNUsageData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type StartTime: str
        :param _EndTime: End date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I). The end date must be after the start date.
        :type EndTime: str
        :param _DataType: CDN statistics type. Valid values:
<li>Flux: traffic in bytes.</li>
<li>Bandwidth: bandwidth in bps.</li>
        :type DataType: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _DataInterval: Time granularity of usage data in minutes. Valid values:
<li>5: 5-minute granularity. The data at 5-minute granularity in the query period will be returned.</li>
<li>60: 1-hour granularity. The data at 1-hour granularity in the query period will be returned.</li>
<li>1440: 1-day granularity. The data at 1-day granularity in the query period will be returned.</li>
Default value: 1440. Data at 1-day granularity will be returned.
        :type DataInterval: int
        :param _DomainNames: List of domain names. The usage data of up to 20 domain names can be queried at a time. You can specify multiple domain names and query their combined usage data. The usage data of all domain names will be returned by default.
        :type DomainNames: list of str
        """
        self._StartTime = None
        self._EndTime = None
        self._DataType = None
        self._SubAppId = None
        self._DataInterval = None
        self._DomainNames = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def DataType(self):
        return self._DataType

    @DataType.setter
    def DataType(self, DataType):
        self._DataType = DataType

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def DataInterval(self):
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def DomainNames(self):
        return self._DomainNames

    @DomainNames.setter
    def DomainNames(self, DomainNames):
        self._DomainNames = DomainNames


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._DataType = params.get("DataType")
        self._SubAppId = params.get("SubAppId")
        self._DataInterval = params.get("DataInterval")
        self._DomainNames = params.get("DomainNames")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCDNUsageDataResponse(AbstractModel):
    """DescribeCDNUsageData response structure.

    """

    def __init__(self):
        r"""
        :param _DataInterval: Time granularity in minutes.
        :type DataInterval: int
        :param _Data: CDN statistics.
        :type Data: list of StatDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._DataInterval = None
        self._Data = None
        self._RequestId = None

    @property
    def DataInterval(self):
        return self._DataInterval

    @DataInterval.setter
    def DataInterval(self, DataInterval):
        self._DataInterval = DataInterval

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._DataInterval = params.get("DataInterval")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeCdnLogsRequest(AbstractModel):
    """DescribeCdnLogs request structure.

    """

    def __init__(self):
        r"""
        :param _DomainName: Domain name.
        :type DomainName: str
        :param _StartTime: Start time for log acquisition in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type StartTime: str
        :param _EndTime: End time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F), which must be after the start time.
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Limit: Maximum return results of pulling paginated queries. Default value: 100; maximum value: 1000
        :type Limit: int
        :param _Offset: Page number offset from the beginning of paginated queries. Default value: 0
        :type Offset: int
        """
        self._DomainName = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Limit = None
        self._Offset = None

    @property
    def DomainName(self):
        return self._DomainName

    @DomainName.setter
    def DomainName(self, DomainName):
        self._DomainName = DomainName

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset


    def _deserialize(self, params):
        self._DomainName = params.get("DomainName")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeCdnLogsResponse(AbstractModel):
    """DescribeCdnLogs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of log download links
Note: this field may return `null`, indicating that no valid value is obtained.
        :type TotalCount: int
        :param _OverseaCdnLogs: Log download list for CDN nodes outside Mainland China. If global acceleration is not enabled for the domain name, ignore this parameter.
Note: this field may return null, indicating that no valid values can be obtained.
        :type OverseaCdnLogs: list of CdnLogInfo
        :param _DomesticCdnLogs: Log download list for CDN nodes in Mainland China.
Note: this field may return null, indicating that no valid values can be obtained.
        :type DomesticCdnLogs: list of CdnLogInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._OverseaCdnLogs = None
        self._DomesticCdnLogs = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def OverseaCdnLogs(self):
        return self._OverseaCdnLogs

    @OverseaCdnLogs.setter
    def OverseaCdnLogs(self, OverseaCdnLogs):
        self._OverseaCdnLogs = OverseaCdnLogs

    @property
    def DomesticCdnLogs(self):
        return self._DomesticCdnLogs

    @DomesticCdnLogs.setter
    def DomesticCdnLogs(self, DomesticCdnLogs):
        self._DomesticCdnLogs = DomesticCdnLogs

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("OverseaCdnLogs") is not None:
            self._OverseaCdnLogs = []
            for item in params.get("OverseaCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._OverseaCdnLogs.append(obj)
        if params.get("DomesticCdnLogs") is not None:
            self._DomesticCdnLogs = []
            for item in params.get("DomesticCdnLogs"):
                obj = CdnLogInfo()
                obj._deserialize(item)
                self._DomesticCdnLogs.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeClientUploadAccelerationUsageDataRequest(AbstractModel):
    """DescribeClientUploadAccelerationUsageData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format).
        :type StartTime: str
        :param _EndTime: The end date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format). The end date must be later than the start date.
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: The client upload acceleration type. Valid values:
<li> AccelerationWithHTTP: Acceleration of HTTP transmission</li>
<li> AccelerationWithQUIC: Acceleration of QUIC transmission</li>
If you do not specify this parameter, the usage of both types will be queried.
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeClientUploadAccelerationUsageDataResponse(AbstractModel):
    """DescribeClientUploadAccelerationUsageData response structure.

    """

    def __init__(self):
        r"""
        :param _ClientUploadAccelerationUsageDataSet: The usage of client upload acceleration.
        :type ClientUploadAccelerationUsageDataSet: list of StatDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ClientUploadAccelerationUsageDataSet = None
        self._RequestId = None

    @property
    def ClientUploadAccelerationUsageDataSet(self):
        return self._ClientUploadAccelerationUsageDataSet

    @ClientUploadAccelerationUsageDataSet.setter
    def ClientUploadAccelerationUsageDataSet(self, ClientUploadAccelerationUsageDataSet):
        self._ClientUploadAccelerationUsageDataSet = ClientUploadAccelerationUsageDataSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ClientUploadAccelerationUsageDataSet") is not None:
            self._ClientUploadAccelerationUsageDataSet = []
            for item in params.get("ClientUploadAccelerationUsageDataSet"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._ClientUploadAccelerationUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeContentReviewTemplatesRequest(AbstractModel):
    """DescribeContentReviewTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique IDs for filters of an intelligent content recognition template. Array length limit: 100.
        :type Definitions: list of int
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeContentReviewTemplatesResponse(AbstractModel):
    """DescribeContentReviewTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ContentReviewTemplateSet: List of intelligent content recognition template details.
        :type ContentReviewTemplateSet: list of ContentReviewTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ContentReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ContentReviewTemplateSet(self):
        return self._ContentReviewTemplateSet

    @ContentReviewTemplateSet.setter
    def ContentReviewTemplateSet(self, ContentReviewTemplateSet):
        self._ContentReviewTemplateSet = ContentReviewTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ContentReviewTemplateSet") is not None:
            self._ContentReviewTemplateSet = []
            for item in params.get("ContentReviewTemplateSet"):
                obj = ContentReviewTemplateItem()
                obj._deserialize(item)
                self._ContentReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDailyPlayStatFileListRequest(AbstractModel):
    """DescribeDailyPlayStatFileList request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type StartTime: str
        :param _EndTime: End date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDailyPlayStatFileListResponse(AbstractModel):
    """DescribeDailyPlayStatFileList response structure.

    """

    def __init__(self):
        r"""
        :param _PlayStatFileSet: List of playback statistics files.
        :type PlayStatFileSet: list of PlayStatFileInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PlayStatFileSet = None
        self._RequestId = None

    @property
    def PlayStatFileSet(self):
        return self._PlayStatFileSet

    @PlayStatFileSet.setter
    def PlayStatFileSet(self, PlayStatFileSet):
        self._PlayStatFileSet = PlayStatFileSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatFileSet") is not None:
            self._PlayStatFileSet = []
            for item in params.get("PlayStatFileSet"):
                obj = PlayStatFileInfo()
                obj._deserialize(item)
                self._PlayStatFileSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeDrmKeyProviderInfoRequest(AbstractModel):
    """DescribeDrmKeyProviderInfo request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeDrmKeyProviderInfoResponse(AbstractModel):
    """DescribeDrmKeyProviderInfo response structure.

    """

    def __init__(self):
        r"""
        :param _SDMCInfo: The DRM key information provided by SDMC.
Note: This field may return null, indicating that no valid values can be obtained.
        :type SDMCInfo: :class:`tencentcloud.vod.v20180717.models.SDMCDrmKeyProviderInfo`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SDMCInfo = None
        self._RequestId = None

    @property
    def SDMCInfo(self):
        return self._SDMCInfo

    @SDMCInfo.setter
    def SDMCInfo(self, SDMCInfo):
        self._SDMCInfo = SDMCInfo

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SDMCInfo") is not None:
            self._SDMCInfo = SDMCDrmKeyProviderInfo()
            self._SDMCInfo._deserialize(params.get("SDMCInfo"))
        self._RequestId = params.get("RequestId")


class DescribeEnhanceMediaTemplatesRequest(AbstractModel):
    """DescribeEnhanceMediaTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: List of Enhance media templates. Length limit: 100.
        :type Definitions: list of int
        :param _Type: Template type filter conditions, optional values:
<li>Preset: system preset template;</li>
<li>Custom: user-defined template. </li>
        :type Type: str
        :param _Offset: Paging offset, default value: 0.
        :type Offset: int
        :param _Limit: Returns the number of records, default value: 10, maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeEnhanceMediaTemplatesResponse(AbstractModel):
    """DescribeEnhanceMediaTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records matching the filter criteria.
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: Detailed list of Rebuild Media templates.
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesRequest(AbstractModel):
    """DescribeFileAttributes request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: The file ID.
        :type FileId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _SessionId: The session ID, which is used for de-duplication. If there was a request with the same session ID in the last three days, an error will be returned for the current request. The session ID can contain up to 50 characters. If you do not pass this parameter or pass in an empty string, duplicate sessions will not be identified.
        :type SessionId: str
        :param _SessionContext: The source context, which is used to pass through user request information. The `ProcedureStateChanged` callback will return the value of this parameter. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _TasksPriority: The task priority. The higher the value, the higher the priority. Value range: -10-10. If this parameter is left empty, 0 will be used.
        :type TasksPriority: int
        :param _ExtInfo: A reserved parameter.
        :type ExtInfo: str
        """
        self._FileId = None
        self._SubAppId = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesResponse(AbstractModel):
    """DescribeFileAttributes response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class DescribeFileAttributesTask(AbstractModel):
    """The information of a task to get file attributes.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID.
        :type TaskId: str
        :param _Status: The task status. Valid values: PROCESSING, SUCCESS, FAIL.
        :type Status: str
        :param _ErrCode: The error code. `0` indicates the task is successful. Other values indicate that the task failed.
<li>`40000`: Invalid input parameter.</li>
<li>`60000`: Source file error (e.g., video data is corrupted).</li>
<li>`70000`: Internal server error. Please try again.</li>
        :type ErrCode: int
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; other values indicate that the task failed. For details, see [Video processing error codes](https://intl.cloud.tencent.com/document/product/266/39145?lang=en&pg=#video-processing).
        :type ErrCodeExt: str
        :param _Message: The error message.
        :type Message: str
        :param _Progress: The task progress. Value range: 0-100.
        :type Progress: int
        :param _FileId: The file ID
        :type FileId: str
        :param _Output: The output of the task to get file attributes.
Note: This field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTaskOutput`
        :param _SessionId: The session ID, which is used for de-duplication. If there was a request with the same session ID in the last seven days, an error will be returned for the current request. The session ID can contain up to 50 characters. If you do not pass this parameter or pass in an empty string, duplicate sessions will not be identified.
        :type SessionId: str
        :param _SessionContext: The source context, which is used to pass through user request information. The `ProcedureStateChanged` callback will return the value of this parameter. It can contain up to 1,000 characters.
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._FileId = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        self._FileId = params.get("FileId")
        if params.get("Output") is not None:
            self._Output = DescribeFileAttributesTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeFileAttributesTaskOutput(AbstractModel):
    """The output of a task to get file attributes.

    """

    def __init__(self):
        r"""
        :param _Md5: The MD5 hash of the file.
        :type Md5: str
        :param _Sha1: The Sha1 value of the media file.
        :type Sha1: str
        """
        self._Md5 = None
        self._Sha1 = None

    @property
    def Md5(self):
        return self._Md5

    @Md5.setter
    def Md5(self, Md5):
        self._Md5 = Md5

    @property
    def Sha1(self):
        return self._Sha1

    @Sha1.setter
    def Sha1(self, Sha1):
        self._Sha1 = Sha1


    def _deserialize(self, params):
        self._Md5 = params.get("Md5")
        self._Sha1 = params.get("Sha1")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesRequest(AbstractModel):
    """DescribeHeadTailTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Head Tail template number, array length limit: 100.
        :type Definitions: list of int
        :param _Offset: Paging offset, default value: 0.
        :type Offset: int
        :param _Limit: Returns the number of records, default value: 10, maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeHeadTailTemplatesResponse(AbstractModel):
    """DescribeHeadTailTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records matching the filter criteria.
        :type TotalCount: int
        :param _HeadTailTemplateSet: Head Tail Template Details.
        :type HeadTailTemplateSet: list of HeadTailTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._HeadTailTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def HeadTailTemplateSet(self):
        return self._HeadTailTemplateSet

    @HeadTailTemplateSet.setter
    def HeadTailTemplateSet(self, HeadTailTemplateSet):
        self._HeadTailTemplateSet = HeadTailTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("HeadTailTemplateSet") is not None:
            self._HeadTailTemplateSet = []
            for item in params.get("HeadTailTemplateSet"):
                obj = HeadTailTemplate()
                obj._deserialize(item)
                self._HeadTailTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageProcessingTemplatesRequest(AbstractModel):
    """DescribeImageProcessingTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: The IDs of the templates to query. Length limit: 100.
        :type Definitions: list of int non-negative
        :param _Type: The template type. Valid values:
<li>Preset</li>
<li>Custom</li>
        :type Type: str
        :param _Offset: The offset. Default value: 0.
        :type Offset: int
        :param _Limit: The number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageProcessingTemplatesResponse(AbstractModel):
    """DescribeImageProcessingTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _ImageProcessingTemplateSet: The information of the queried image processing templates.
        :type ImageProcessingTemplateSet: list of ImageProcessingTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageProcessingTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageProcessingTemplateSet(self):
        return self._ImageProcessingTemplateSet

    @ImageProcessingTemplateSet.setter
    def ImageProcessingTemplateSet(self, ImageProcessingTemplateSet):
        self._ImageProcessingTemplateSet = ImageProcessingTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageProcessingTemplateSet") is not None:
            self._ImageProcessingTemplateSet = []
            for item in params.get("ImageProcessingTemplateSet"):
                obj = ImageProcessingTemplate()
                obj._deserialize(item)
                self._ImageProcessingTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageReviewUsageDataRequest(AbstractModel):
    """DescribeImageReviewUsageData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format).
        :type StartTime: str
        :param _EndTime: The end date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format). The end date must be later than the start date.
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageReviewUsageDataResponse(AbstractModel):
    """DescribeImageReviewUsageData response structure.

    """

    def __init__(self):
        r"""
        :param _ImageReviewUsageDataSet: The image recognition usage statistics (the number of times the image recognition feature is used in the time period specified).
        :type ImageReviewUsageDataSet: list of ImageReviewUsageDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._ImageReviewUsageDataSet = None
        self._RequestId = None

    @property
    def ImageReviewUsageDataSet(self):
        return self._ImageReviewUsageDataSet

    @ImageReviewUsageDataSet.setter
    def ImageReviewUsageDataSet(self, ImageReviewUsageDataSet):
        self._ImageReviewUsageDataSet = ImageReviewUsageDataSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("ImageReviewUsageDataSet") is not None:
            self._ImageReviewUsageDataSet = []
            for item in params.get("ImageReviewUsageDataSet"):
                obj = ImageReviewUsageDataItem()
                obj._deserialize(item)
                self._ImageReviewUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeImageSpriteTemplatesRequest(AbstractModel):
    """DescribeImageSpriteTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of image sprite generating templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paged offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeImageSpriteTemplatesResponse(AbstractModel):
    """DescribeImageSpriteTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ImageSpriteTemplateSet: List of image sprite generating template details.
        :type ImageSpriteTemplateSet: list of ImageSpriteTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ImageSpriteTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ImageSpriteTemplateSet(self):
        return self._ImageSpriteTemplateSet

    @ImageSpriteTemplateSet.setter
    def ImageSpriteTemplateSet(self, ImageSpriteTemplateSet):
        self._ImageSpriteTemplateSet = ImageSpriteTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ImageSpriteTemplateSet") is not None:
            self._ImageSpriteTemplateSet = []
            for item in params.get("ImageSpriteTemplateSet"):
                obj = ImageSpriteTemplate()
                obj._deserialize(item)
                self._ImageSpriteTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeJustInTimeTranscodeTemplatesRequest(AbstractModel):
    """DescribeJustInTimeTranscodeTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Names: Template name filter condition, array length limit: 100.
        :type Names: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: Template type filter conditions, optional values:
<li>Preset: system preset task flow template;</li>
<li>Custom: user-defined task flow template. </li>
        :type Type: str
        :param _Offset: Paging offset, default value: 0.
        :type Offset: int
        :param _Limit: Returns the number of records, default value: 10, maximum value: 100.
        :type Limit: int
        """
        self._Names = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Names = params.get("Names")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeJustInTimeTranscodeTemplatesResponse(AbstractModel):
    """DescribeJustInTimeTranscodeTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records matching the filter criteria.
        :type TotalCount: int
        :param _JustInTimeTranscodeTemplateSet: Template details list.
        :type JustInTimeTranscodeTemplateSet: list of JustInTimeTranscodeTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._JustInTimeTranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def JustInTimeTranscodeTemplateSet(self):
        return self._JustInTimeTranscodeTemplateSet

    @JustInTimeTranscodeTemplateSet.setter
    def JustInTimeTranscodeTemplateSet(self, JustInTimeTranscodeTemplateSet):
        self._JustInTimeTranscodeTemplateSet = JustInTimeTranscodeTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("JustInTimeTranscodeTemplateSet") is not None:
            self._JustInTimeTranscodeTemplateSet = []
            for item in params.get("JustInTimeTranscodeTemplateSet"):
                obj = JustInTimeTranscodeTemplate()
                obj._deserialize(item)
                self._JustInTimeTranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeLicenseUsageDataRequest(AbstractModel):
    """DescribeLicenseUsageData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: The start date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format).
        :type StartTime: str
        :param _EndTime: The end date for the query in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732#iso-date-format). The end date must be later than the start date.
        :type EndTime: str
        :param _LicenseType: The license type, which is DRM by default. Valid values:
<li> DRM</li>
        :type LicenseType: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._LicenseType = None
        self._SubAppId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def LicenseType(self):
        return self._LicenseType

    @LicenseType.setter
    def LicenseType(self, LicenseType):
        self._LicenseType = LicenseType

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._LicenseType = params.get("LicenseType")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeLicenseUsageDataResponse(AbstractModel):
    """DescribeLicenseUsageData response structure.

    """

    def __init__(self):
        r"""
        :param _LicenseUsageDataSet: The license request statistics (the number of license requests in the time period specified)
        :type LicenseUsageDataSet: list of LicenseUsageDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._LicenseUsageDataSet = None
        self._RequestId = None

    @property
    def LicenseUsageDataSet(self):
        return self._LicenseUsageDataSet

    @LicenseUsageDataSet.setter
    def LicenseUsageDataSet(self, LicenseUsageDataSet):
        self._LicenseUsageDataSet = LicenseUsageDataSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("LicenseUsageDataSet") is not None:
            self._LicenseUsageDataSet = []
            for item in params.get("LicenseUsageDataSet"):
                obj = LicenseUsageDataItem()
                obj._deserialize(item)
                self._LicenseUsageDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaInfosRequest(AbstractModel):
    """DescribeMediaInfos request structure.

    """

    def __init__(self):
        r"""
        :param _FileIds: List of media file IDs. N starts from 0 and can be up to 19.
        :type FileIds: list of str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Filters: The types of information to return. You can specify multiple information types. `N` starts from 0. If you do not specify this parameter, all information will be returned. The supported information types are as follows:
<li>`basicInfo` (basic information)</li>
<li>`metaData` (video metadata)</li>
<li>`transcodeInfo` (transcoding information)</li>
<li>`animatedGraphicsInfo` (animated image information)</li>
<li>`imageSpriteInfo` (image sprite information)</li>
<li>`snapshotByTimeOffsetInfo` (time point screenshot information)</li>
<li>`sampleSnapshotInfo` (sampled screenshot information)</li>
<li>`keyFrameDescInfo` (timestamp information)</li>
<li>`adaptiveDynamicStreamingInfo` (adaptive bitrate information)</li>
<li>`miniProgramReviewInfo` (WeChat Mini Program moderation information)</li>
<li>`subtitleInfo` (subtitle information)</li>
<li>`reviewInfo` (moderation information)</li>
        :type Filters: list of str
        """
        self._FileIds = None
        self._SubAppId = None
        self._Filters = None

    @property
    def FileIds(self):
        return self._FileIds

    @FileIds.setter
    def FileIds(self, FileIds):
        self._FileIds = FileIds

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Filters(self):
        return self._Filters

    @Filters.setter
    def Filters(self, Filters):
        self._Filters = Filters


    def _deserialize(self, params):
        self._FileIds = params.get("FileIds")
        self._SubAppId = params.get("SubAppId")
        self._Filters = params.get("Filters")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaInfosResponse(AbstractModel):
    """DescribeMediaInfos response structure.

    """

    def __init__(self):
        r"""
        :param _MediaInfoSet: Media file information list.
        :type MediaInfoSet: list of MediaInfo
        :param _NotExistFileIdSet: List of IDs of files that do not exist.
        :type NotExistFileIdSet: list of str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MediaInfoSet = None
        self._NotExistFileIdSet = None
        self._RequestId = None

    @property
    def MediaInfoSet(self):
        return self._MediaInfoSet

    @MediaInfoSet.setter
    def MediaInfoSet(self, MediaInfoSet):
        self._MediaInfoSet = MediaInfoSet

    @property
    def NotExistFileIdSet(self):
        return self._NotExistFileIdSet

    @NotExistFileIdSet.setter
    def NotExistFileIdSet(self, NotExistFileIdSet):
        self._NotExistFileIdSet = NotExistFileIdSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaInfoSet") is not None:
            self._MediaInfoSet = []
            for item in params.get("MediaInfoSet"):
                obj = MediaInfo()
                obj._deserialize(item)
                self._MediaInfoSet.append(obj)
        self._NotExistFileIdSet = params.get("NotExistFileIdSet")
        self._RequestId = params.get("RequestId")


class DescribeMediaPlayStatDetailsRequest(AbstractModel):
    """DescribeMediaPlayStatDetails request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: The ID of the media file.
        :type FileId: str
        :param _StartTime: The start time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type StartTime: str
        :param _EndTime: The end time in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Interval: Granularity. Valid values:
<li>Hour</li>
<li>Day</li>
The default value depends on the time period queried. If the time period is shorter than one day, the default value is `Hour`; if the time period is one day or longer, the default value is `Day`.
        :type Interval: str
        """
        self._FileId = None
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Interval = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Interval = params.get("Interval")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaPlayStatDetailsResponse(AbstractModel):
    """DescribeMediaPlayStatDetails response structure.

    """

    def __init__(self):
        r"""
        :param _PlayStatInfoSet: The playback statistics.
        :type PlayStatInfoSet: list of PlayStatInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._PlayStatInfoSet = None
        self._RequestId = None

    @property
    def PlayStatInfoSet(self):
        return self._PlayStatInfoSet

    @PlayStatInfoSet.setter
    def PlayStatInfoSet(self, PlayStatInfoSet):
        self._PlayStatInfoSet = PlayStatInfoSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("PlayStatInfoSet") is not None:
            self._PlayStatInfoSet = []
            for item in params.get("PlayStatInfoSet"):
                obj = PlayStatInfo()
                obj._deserialize(item)
                self._PlayStatInfoSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeMediaProcessUsageDataRequest(AbstractModel):
    """DescribeMediaProcessUsageData request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F).
        :type StartTime: str
        :param _EndTime: End date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#iso-.E6.97.A5.E6.9C.9F.E6.A0.BC.E5.BC.8F). The end date must be on or after the start date.
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: Query the video processing task type. Currently supported task types include:
<li> Transcoding: Normal transcoding</li>
<li> Transcoding-TESHD: Extremely fast high-definition transcoding</li>
<li> Editing : Video editing</li>
<li> Editing-TESHD: Extremely fast high-definition video editing</li>
<li> AdaptiveBitrateStreaming: Adaptive bitrate streaming</li>
<li> ContentAudit: Content audit</li> li>
<li> ContentRecognition: Content recognition</li>
<li> RemoveWatermark: Remove watermark</li>
<li> ExtractTraceWatermark: Extract watermark</li>
<li> AddTraceWatermark: Add watermark </li>
<li> RebuildMedia: Rebirth of audio and video quality</li>
<li> QualityInspect: Media quality inspection</li>
<li> VideoHighlight: Smart video collection</li>
< li> VideoTag: Video smart tag</li>
<li> VideoClassification: Video smart classification</li>
<li> VideoCover: Video smart cover</li>
<li> VideoSegment: Video smart split </li>
<li>Transcode: transcoding, including normal transcoding, high-speed HD and video editing (not recommended)</li>
        :type Type: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Type = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeMediaProcessUsageDataResponse(AbstractModel):
    """DescribeMediaProcessUsageData response structure.

    """

    def __init__(self):
        r"""
        :param _MediaProcessDataSet: Overview of video processing statistics, which displays the overview and details of queried tasks.
        :type MediaProcessDataSet: list of TaskStatData
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MediaProcessDataSet = None
        self._RequestId = None

    @property
    def MediaProcessDataSet(self):
        return self._MediaProcessDataSet

    @MediaProcessDataSet.setter
    def MediaProcessDataSet(self, MediaProcessDataSet):
        self._MediaProcessDataSet = MediaProcessDataSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("MediaProcessDataSet") is not None:
            self._MediaProcessDataSet = []
            for item in params.get("MediaProcessDataSet"):
                obj = TaskStatData()
                obj._deserialize(item)
                self._MediaProcessDataSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribePersonSamplesRequest(AbstractModel):
    """DescribePersonSamples request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: Type of samples to pull. Valid values:
<li>UserDefine: custom sample library</li>
<li>Default: default sample library</li>

Default value: UserDefine. Samples in the custom sample library will be pulled.
Note: samples from the default library can only be pulled by providing the name or both the ID and name of a sample. Only one face image will be returned.
        :type Type: str
        :param _PersonIds: IDs of samples. Array length limit: 100.
        :type PersonIds: list of str
        :param _Names: Names of samples. Array length limit: 20.
        :type Names: list of str
        :param _Tags: Tags of a sample. Array length limit: 20.
        :type Tags: list of str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Type = None
        self._PersonIds = None
        self._Names = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def PersonIds(self):
        return self._PersonIds

    @PersonIds.setter
    def PersonIds(self, PersonIds):
        self._PersonIds = PersonIds

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._PersonIds = params.get("PersonIds")
        self._Names = params.get("Names")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribePersonSamplesResponse(AbstractModel):
    """DescribePersonSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _PersonSet: Figure information.
        :type PersonSet: list of AiSamplePerson
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PersonSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PersonSet(self):
        return self._PersonSet

    @PersonSet.setter
    def PersonSet(self, PersonSet):
        self._PersonSet = PersonSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PersonSet") is not None:
            self._PersonSet = []
            for item in params.get("PersonSet"):
                obj = AiSamplePerson()
                obj._deserialize(item)
                self._PersonSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeProcedureTemplatesRequest(AbstractModel):
    """DescribeProcedureTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Names: Name filter of task flow template. Array length limit: 100.
        :type Names: list of str
        :param _Type: Filter of task flow template types. Valid values:
<li>Preset: preset task flow template;</li>
<li>Custom: custom task flow template.</li>
        :type Type: str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Names = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Names = params.get("Names")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeProcedureTemplatesResponse(AbstractModel):
    """DescribeProcedureTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _ProcedureTemplateSet: List of task flow template details.
        :type ProcedureTemplateSet: list of ProcedureTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ProcedureTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ProcedureTemplateSet(self):
        return self._ProcedureTemplateSet

    @ProcedureTemplateSet.setter
    def ProcedureTemplateSet(self, ProcedureTemplateSet):
        self._ProcedureTemplateSet = ProcedureTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ProcedureTemplateSet") is not None:
            self._ProcedureTemplateSet = []
            for item in params.get("ProcedureTemplateSet"):
                obj = ProcedureTemplate()
                obj._deserialize(item)
                self._ProcedureTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeQualityInspectTemplatesRequest(AbstractModel):
    """DescribeQualityInspectTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Media quality inspect template list. Length limit: 100.
        :type Definitions: list of int
        :param _Type: Template type filter conditions, optional values: <li>Preset: system preset template;</li> <li>Custom: user-defined template. </li>
        :type Type: str
        :param _Offset: Paging offset, default value: 0.
        :type Offset: int
        :param _Limit: Back record count, default value: 10, maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeQualityInspectTemplatesResponse(AbstractModel):
    """DescribeQualityInspectTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Comply with the filter conditions, the total number of records.
        :type TotalCount: int
        :param _QualityInspectTemplateSet: Media quality inspect template details list.
        :type QualityInspectTemplateSet: list of QualityInspectTemplateItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._QualityInspectTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def QualityInspectTemplateSet(self):
        return self._QualityInspectTemplateSet

    @QualityInspectTemplateSet.setter
    def QualityInspectTemplateSet(self, QualityInspectTemplateSet):
        self._QualityInspectTemplateSet = QualityInspectTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("QualityInspectTemplateSet") is not None:
            self._QualityInspectTemplateSet = []
            for item in params.get("QualityInspectTemplateSet"):
                obj = QualityInspectTemplateItem()
                obj._deserialize(item)
                self._QualityInspectTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRebuildMediaTemplatesRequest(AbstractModel):
    """DescribeRebuildMediaTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _Definitions: List of rebuild media templates.
        :type Definitions: list of int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: The template type. Valid values:
<li>`Preset`</li>
<li>`Custom`</li>
        :type Type: str
        :param _Offset: The pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: The maximum number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._Definitions = None
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Definitions = params.get("Definitions")
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRebuildMediaTemplatesResponse(AbstractModel):
    """DescribeRebuildMediaTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _RebuildMediaTemplateSet: Rebuild media template details list.
        :type RebuildMediaTemplateSet: list of RebuildMediaTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RebuildMediaTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RebuildMediaTemplateSet(self):
        return self._RebuildMediaTemplateSet

    @RebuildMediaTemplateSet.setter
    def RebuildMediaTemplateSet(self, RebuildMediaTemplateSet):
        self._RebuildMediaTemplateSet = RebuildMediaTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RebuildMediaTemplateSet") is not None:
            self._RebuildMediaTemplateSet = []
            for item in params.get("RebuildMediaTemplateSet"):
                obj = RebuildMediaTemplate()
                obj._deserialize(item)
                self._RebuildMediaTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewDetailsRequest(AbstractModel):
    """DescribeReviewDetails request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type StartTime: str
        :param _EndTime: End date in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I). The end date must be after the start date.
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewDetailsResponse(AbstractModel):
    """DescribeReviewDetails response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Times of initiating intelligent content recognition tasks.
        :type TotalCount: int
        :param _TotalDuration: Duration of intelligent recognition content.
        :type TotalDuration: int
        :param _Data: Data of intelligent recognition content duration. One piece of data is collected every day.
        :type Data: list of StatDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TotalDuration = None
        self._Data = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TotalDuration(self):
        return self._TotalDuration

    @TotalDuration.setter
    def TotalDuration(self, TotalDuration):
        self._TotalDuration = TotalDuration

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        self._TotalDuration = params.get("TotalDuration")
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeReviewTemplatesRequest(AbstractModel):
    """DescribeReviewTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: The audit template uniquely identifies the filtering conditions, and the array length limit is: 100.
        :type Definitions: list of int
        :param _Type: The template type. Valid values:
<li>Preset</li>
<li>Custom</li>
        :type Type: str
        :param _Offset: The pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: The number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeReviewTemplatesResponse(AbstractModel):
    """DescribeReviewTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _ReviewTemplateSet: The details of the moderation templates.
        :type ReviewTemplateSet: list of ReviewTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._ReviewTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def ReviewTemplateSet(self):
        return self._ReviewTemplateSet

    @ReviewTemplateSet.setter
    def ReviewTemplateSet(self, ReviewTemplateSet):
        self._ReviewTemplateSet = ReviewTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("ReviewTemplateSet") is not None:
            self._ReviewTemplateSet = []
            for item in params.get("ReviewTemplateSet"):
                obj = ReviewTemplate()
                obj._deserialize(item)
                self._ReviewTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeRoundPlaysRequest(AbstractModel):
    """DescribeRoundPlays request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _RoundPlayIds: The playlist IDs. Array length limit: 100.
        :type RoundPlayIds: list of str
        :param _Offset: 
        :type Offset: int
        :param _Limit: The number of records to return. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._RoundPlayIds = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def RoundPlayIds(self):
        return self._RoundPlayIds

    @RoundPlayIds.setter
    def RoundPlayIds(self, RoundPlayIds):
        self._RoundPlayIds = RoundPlayIds

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._RoundPlayIds = params.get("RoundPlayIds")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeRoundPlaysResponse(AbstractModel):
    """DescribeRoundPlays response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: The total number of records that meet the conditions.
        :type TotalCount: int
        :param _RoundPlaySet: The information of the playlists.
        :type RoundPlaySet: list of RoundPlayInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._RoundPlaySet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RoundPlaySet(self):
        return self._RoundPlaySet

    @RoundPlaySet.setter
    def RoundPlaySet(self, RoundPlaySet):
        self._RoundPlaySet = RoundPlaySet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("RoundPlaySet") is not None:
            self._RoundPlaySet = []
            for item in params.get("RoundPlaySet"):
                obj = RoundPlayInfo()
                obj._deserialize(item)
                self._RoundPlaySet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSampleSnapshotTemplatesRequest(AbstractModel):
    """DescribeSampleSnapshotTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of sampled screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paged offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSampleSnapshotTemplatesResponse(AbstractModel):
    """DescribeSampleSnapshotTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SampleSnapshotTemplateSet: List of sampled screencapturing template details.
        :type SampleSnapshotTemplateSet: list of SampleSnapshotTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SampleSnapshotTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SampleSnapshotTemplateSet(self):
        return self._SampleSnapshotTemplateSet

    @SampleSnapshotTemplateSet.setter
    def SampleSnapshotTemplateSet(self, SampleSnapshotTemplateSet):
        self._SampleSnapshotTemplateSet = SampleSnapshotTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SampleSnapshotTemplateSet") is not None:
            self._SampleSnapshotTemplateSet = []
            for item in params.get("SampleSnapshotTemplateSet"):
                obj = SampleSnapshotTemplate()
                obj._deserialize(item)
                self._SampleSnapshotTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSnapshotByTimeOffsetTemplatesRequest(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of time point screencapturing templates. Array length limit: 100.
        :type Definitions: list of int non-negative
        :param _Offset: Paged offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Definitions = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSnapshotByTimeOffsetTemplatesResponse(AbstractModel):
    """DescribeSnapshotByTimeOffsetTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _SnapshotByTimeOffsetTemplateSet: List of time point screencapturing template details.
        :type SnapshotByTimeOffsetTemplateSet: list of SnapshotByTimeOffsetTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._SnapshotByTimeOffsetTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def SnapshotByTimeOffsetTemplateSet(self):
        return self._SnapshotByTimeOffsetTemplateSet

    @SnapshotByTimeOffsetTemplateSet.setter
    def SnapshotByTimeOffsetTemplateSet(self, SnapshotByTimeOffsetTemplateSet):
        self._SnapshotByTimeOffsetTemplateSet = SnapshotByTimeOffsetTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("SnapshotByTimeOffsetTemplateSet") is not None:
            self._SnapshotByTimeOffsetTemplateSet = []
            for item in params.get("SnapshotByTimeOffsetTemplateSet"):
                obj = SnapshotByTimeOffsetTemplate()
                obj._deserialize(item)
                self._SnapshotByTimeOffsetTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageDataRequest(AbstractModel):
    """DescribeStorageData request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageDataResponse(AbstractModel):
    """DescribeStorageData response structure.

    """

    def __init__(self):
        r"""
        :param _MediaCount: Total number of current media files.
        :type MediaCount: int
        :param _TotalStorage: Total current storage capacity in bytes.
        :type TotalStorage: int
        :param _StandardStorage: Current Standard storage capacity in bytes.
        :type StandardStorage: int
        :param _InfrequentStorage: Current Standard_IA storage capacity in bytes.
        :type InfrequentStorage: int
        :param _ArchiveStorage: The current ARCHIVE storage usage in bytes.
        :type ArchiveStorage: int
        :param _DeepArchiveStorage: The current DEEP ARCHIVE storage usage in bytes.
        :type DeepArchiveStorage: int
        :param _StorageStat: Storage usage by billing region.
        :type StorageStat: list of StorageStatData
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._MediaCount = None
        self._TotalStorage = None
        self._StandardStorage = None
        self._InfrequentStorage = None
        self._ArchiveStorage = None
        self._DeepArchiveStorage = None
        self._StorageStat = None
        self._RequestId = None

    @property
    def MediaCount(self):
        return self._MediaCount

    @MediaCount.setter
    def MediaCount(self, MediaCount):
        self._MediaCount = MediaCount

    @property
    def TotalStorage(self):
        return self._TotalStorage

    @TotalStorage.setter
    def TotalStorage(self, TotalStorage):
        self._TotalStorage = TotalStorage

    @property
    def StandardStorage(self):
        return self._StandardStorage

    @StandardStorage.setter
    def StandardStorage(self, StandardStorage):
        self._StandardStorage = StandardStorage

    @property
    def InfrequentStorage(self):
        return self._InfrequentStorage

    @InfrequentStorage.setter
    def InfrequentStorage(self, InfrequentStorage):
        self._InfrequentStorage = InfrequentStorage

    @property
    def ArchiveStorage(self):
        return self._ArchiveStorage

    @ArchiveStorage.setter
    def ArchiveStorage(self, ArchiveStorage):
        self._ArchiveStorage = ArchiveStorage

    @property
    def DeepArchiveStorage(self):
        return self._DeepArchiveStorage

    @DeepArchiveStorage.setter
    def DeepArchiveStorage(self, DeepArchiveStorage):
        self._DeepArchiveStorage = DeepArchiveStorage

    @property
    def StorageStat(self):
        return self._StorageStat

    @StorageStat.setter
    def StorageStat(self, StorageStat):
        self._StorageStat = StorageStat

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._MediaCount = params.get("MediaCount")
        self._TotalStorage = params.get("TotalStorage")
        self._StandardStorage = params.get("StandardStorage")
        self._InfrequentStorage = params.get("InfrequentStorage")
        self._ArchiveStorage = params.get("ArchiveStorage")
        self._DeepArchiveStorage = params.get("DeepArchiveStorage")
        if params.get("StorageStat") is not None:
            self._StorageStat = []
            for item in params.get("StorageStat"):
                obj = StorageStatData()
                obj._deserialize(item)
                self._StorageStat.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageDetailsRequest(AbstractModel):
    """DescribeStorageDetails request structure.

    """

    def __init__(self):
        r"""
        :param _StartTime: Start time in ISO 8601 format. For more information, please see [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type StartTime: str
        :param _EndTime: End time in ISO 8601 format, which should be larger than the start time. For more information, please see [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?lang=en&pg=).
        :type EndTime: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Interval: Time granularity. Valid values:
<li>Minute: 5-minute granularity</li>
<li>Day: 1-day granularity</li>
The value is set according to query period length by default. 5-minute granularity is set for periods no longer than 1 day, and 1-day granularity is set for periods longer than 1 day.
        :type Interval: str
        :param _StorageType: Queryed storage type, valid values:
<li>TotalStorage: total storage amount, the sum of standard, low-frequency, archive and deep archive storage amounts, excluding early deletion amount. </li>
<li>StandardStorage: Standard storage. </li>
<li>InfrequentStorage: low-frequency storage. </li>
<li>ArchiveStorage: archive storage. </li>
<li>DeepArchiveStorage: deep archive storage. </li>
<li>DeletedInfrequentStorage: The amount of early deletion of low-frequency storage. </li>
<li>DeletedArchiveStorage: The amount of archives deleted in advance. </li>
<li>DeletedDeepArchiveStorage: The amount of deep archive deletion in advance. 
<li>ArchiveStandardRetrieval: Archive standard retrieval amount. </li>
<li>ArchiveExpeditedRetrieval: archive quick retrieval amount. </li>
<li>ArchiveBulkRetrieval: Archive batch retrieval amount. </li>
<li>DeepArchiveStandardRetrieval: Deep archive standard retrieval amount. </li>
<li>DeepArchiveBulkRetrieval: Deep archive batch retrieval amount. </li>
<li>InfrequentRetrieval: Low-frequency storage retrieval amount. </li>
The default value is TotalStorage.
        :type StorageType: str
        :param _Area: Storage region to query. Valid values:
<li>Chinese Mainland</li>
<li>Outside Chinese Mainland</li>
Default value: Chinese Mainland
        :type Area: str
        """
        self._StartTime = None
        self._EndTime = None
        self._SubAppId = None
        self._Interval = None
        self._StorageType = None
        self._Area = None

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Interval(self):
        return self._Interval

    @Interval.setter
    def Interval(self, Interval):
        self._Interval = Interval

    @property
    def StorageType(self):
        return self._StorageType

    @StorageType.setter
    def StorageType(self, StorageType):
        self._StorageType = StorageType

    @property
    def Area(self):
        return self._Area

    @Area.setter
    def Area(self, Area):
        self._Area = Area


    def _deserialize(self, params):
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        self._SubAppId = params.get("SubAppId")
        self._Interval = params.get("Interval")
        self._StorageType = params.get("StorageType")
        self._Area = params.get("Area")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageDetailsResponse(AbstractModel):
    """DescribeStorageDetails response structure.

    """

    def __init__(self):
        r"""
        :param _Data: Storage statistics with one piece of data for every 5 minutes or 1 day.
        :type Data: list of StatDataItem
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Data = None
        self._RequestId = None

    @property
    def Data(self):
        return self._Data

    @Data.setter
    def Data(self, Data):
        self._Data = Data

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("Data") is not None:
            self._Data = []
            for item in params.get("Data"):
                obj = StatDataItem()
                obj._deserialize(item)
                self._Data.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeStorageRegionsRequest(AbstractModel):
    """DescribeStorageRegions request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._SubAppId = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeStorageRegionsResponse(AbstractModel):
    """DescribeStorageRegions response structure.

    """

    def __init__(self):
        r"""
        :param _StorageRegionInfos: The information of the storage regions.
        :type StorageRegionInfos: list of StorageRegionInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._StorageRegionInfos = None
        self._RequestId = None

    @property
    def StorageRegionInfos(self):
        return self._StorageRegionInfos

    @StorageRegionInfos.setter
    def StorageRegionInfos(self, StorageRegionInfos):
        self._StorageRegionInfos = StorageRegionInfos

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("StorageRegionInfos") is not None:
            self._StorageRegionInfos = []
            for item in params.get("StorageRegionInfos"):
                obj = StorageRegionInfo()
                obj._deserialize(item)
                self._StorageRegionInfos.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeSubAppIdsRequest(AbstractModel):
    """DescribeSubAppIds request structure.

    """

    def __init__(self):
        r"""
        :param _Name: Subapplication name.
        :type Name: str
        :param _Tags: Tag information. You can query the list of subapplications with specified tags.
        :type Tags: list of ResourceTag
        :param _Offset: Page number offset from the beginning of paginated queries. Default value: 0.
        :type Offset: int
        :param _Limit: Maximum return results of pulling paginated queries. Default: 200; maximum: 200.
        :type Limit: int
        """
        self._Name = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def Name(self):
        return self._Name

    @Name.setter
    def Name(self, Name):
        self._Name = Name

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._Name = params.get("Name")
        if params.get("Tags") is not None:
            self._Tags = []
            for item in params.get("Tags"):
                obj = ResourceTag()
                obj._deserialize(item)
                self._Tags.append(obj)
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSubAppIdsResponse(AbstractModel):
    """DescribeSubAppIds response structure.

    """

    def __init__(self):
        r"""
        :param _SubAppIdInfoSet: Subapplication information set.
        :type SubAppIdInfoSet: list of SubAppIdInfo
        :param _TotalCount: Total number of subapplications.
        :type TotalCount: int
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._SubAppIdInfoSet = None
        self._TotalCount = None
        self._RequestId = None

    @property
    def SubAppIdInfoSet(self):
        return self._SubAppIdInfoSet

    @SubAppIdInfoSet.setter
    def SubAppIdInfoSet(self, SubAppIdInfoSet):
        self._SubAppIdInfoSet = SubAppIdInfoSet

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("SubAppIdInfoSet") is not None:
            self._SubAppIdInfoSet = []
            for item in params.get("SubAppIdInfoSet"):
                obj = SubAppIdInfo()
                obj._deserialize(item)
                self._SubAppIdInfoSet.append(obj)
        self._TotalCount = params.get("TotalCount")
        self._RequestId = params.get("RequestId")


class DescribeSuperPlayerConfigsRequest(AbstractModel):
    """DescribeSuperPlayerConfigs request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Names: Player configuration name filter. Array length limit: 100.
        :type Names: list of str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _Type: Player configuration type filter. Valid values:
<li>Preset: preset configuration;</li>
<li>Custom: custom configuration.</li>
        :type Type: str
        """
        self._SubAppId = None
        self._Names = None
        self._Offset = None
        self._Limit = None
        self._Type = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Names(self):
        return self._Names

    @Names.setter
    def Names(self, Names):
        self._Names = Names

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Names = params.get("Names")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeSuperPlayerConfigsResponse(AbstractModel):
    """DescribeSuperPlayerConfigs response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _PlayerConfigSet: Player configuration array.
        :type PlayerConfigSet: list of PlayerConfig
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._PlayerConfigSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def PlayerConfigSet(self):
        return self._PlayerConfigSet

    @PlayerConfigSet.setter
    def PlayerConfigSet(self, PlayerConfigSet):
        self._PlayerConfigSet = PlayerConfigSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("PlayerConfigSet") is not None:
            self._PlayerConfigSet = []
            for item in params.get("PlayerConfigSet"):
                obj = PlayerConfig()
                obj._deserialize(item)
                self._PlayerConfigSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeTaskDetailRequest(AbstractModel):
    """DescribeTaskDetail request structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Video processing task ID.
        :type TaskId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._TaskId = None
        self._SubAppId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTaskDetailResponse(AbstractModel):
    """DescribeTaskDetail response structure.

    """

    def __init__(self):
        r"""
        :param _TaskType: The task type. Valid values:
<li>`Procedure`: Video processing</li>
<li>`EditMedia`: Video editing</li>
<li>`SplitMedia`: Video splitting</li>
<li>`ComposeMedia`: Media file production</li>
<li>`WechatPublish`: Weixin publishing</li>
<li>`WechatMiniProgramPublish`: Publishing videos on Weixin Mini Program</li>
<li>`PullUpload`: Pulling media files for upload</li>
<li>`FastClipMedia`: Quick clipping</li>
<li>`RemoveWatermarkTask`: Watermark removal</li>
<li>`DescribeFileAttributesTask`: Getting file attributes</li>
<li> `ReviewAudioVideo`: Moderation</li>
<li>`ExtractTraceWatermark`: Digital watermark extraction</li>
<li>`QualityEnhance`: Enhance audio/video</li>
        :type TaskType: str
        :param _Status: Task status. Valid values:
<li>WAITING: waiting;</li>
<li>PROCESSING: processing;</li>
<li>FINISH: completed.</li>
        :type Status: str
        :param _CreateTime: Creation time of task in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type CreateTime: str
        :param _BeginProcessTime: Start time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type BeginProcessTime: str
        :param _FinishTime: End time of task execution in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
        :type FinishTime: str
        :param _ProcedureTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProcedureTask: :class:`tencentcloud.vod.v20180717.models.ProcedureTask`
        :param _EditMediaTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type EditMediaTask: :class:`tencentcloud.vod.v20180717.models.EditMediaTask`
        :param _WechatPublishTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type WechatPublishTask: :class:`tencentcloud.vod.v20180717.models.WechatPublishTask`
        :param _ComposeMediaTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ComposeMediaTask: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTask`
        :param _SplitMediaTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type SplitMediaTask: :class:`tencentcloud.vod.v20180717.models.SplitMediaTask`
        :param _WechatMiniProgramPublishTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type WechatMiniProgramPublishTask: :class:`tencentcloud.vod.v20180717.models.WechatMiniProgramPublishTask`
        :param _PullUploadTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type PullUploadTask: :class:`tencentcloud.vod.v20180717.models.PullUploadTask`
        :param _TranscodeTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type TranscodeTask: :class:`tencentcloud.vod.v20180717.models.TranscodeTask2017`
        :param _ConcatTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ConcatTask: :class:`tencentcloud.vod.v20180717.models.ConcatTask2017`
        :param _ClipTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClipTask: :class:`tencentcloud.vod.v20180717.models.ClipTask2017`
        :param _CreateImageSpriteTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateImageSpriteTask: :class:`tencentcloud.vod.v20180717.models.CreateImageSpriteTask2017`
        :param _SnapshotByTimeOffsetTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type SnapshotByTimeOffsetTask: :class:`tencentcloud.vod.v20180717.models.SnapshotByTimeOffsetTask2017`
        :param _RemoveWatermarkTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type RemoveWatermarkTask: :class:`tencentcloud.vod.v20180717.models.RemoveWatermarkTask`
        :param _RebuildMediaTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type RebuildMediaTask: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTask`
        :param _ExtractTraceWatermarkTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtractTraceWatermarkTask: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTask`
        :param _ExtractCopyRightWatermarkTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtractCopyRightWatermarkTask: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTask`
        :param _ReviewAudioVideoTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ReviewAudioVideoTask: :class:`tencentcloud.vod.v20180717.models.ReviewAudioVideoTask`
        :param _ReduceMediaBitrateTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ReduceMediaBitrateTask: :class:`tencentcloud.vod.v20180717.models.ReduceMediaBitrateTask`
        :param _DescribeFileAttributesTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type DescribeFileAttributesTask: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTask`
        :param _QualityInspectTask: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type QualityInspectTask: :class:`tencentcloud.vod.v20180717.models.QualityInspectTask`
        :param _QualityEnhanceTask: Media Quality Enhance task information. This field has a value only when TaskType is QualityEnhance.
Note: This field may return null, indicating that no valid value can be obtained.
        :type QualityEnhanceTask: :class:`tencentcloud.vod.v20180717.models.QualityEnhanceTask`
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskType = None
        self._Status = None
        self._CreateTime = None
        self._BeginProcessTime = None
        self._FinishTime = None
        self._ProcedureTask = None
        self._EditMediaTask = None
        self._WechatPublishTask = None
        self._ComposeMediaTask = None
        self._SplitMediaTask = None
        self._WechatMiniProgramPublishTask = None
        self._PullUploadTask = None
        self._TranscodeTask = None
        self._ConcatTask = None
        self._ClipTask = None
        self._CreateImageSpriteTask = None
        self._SnapshotByTimeOffsetTask = None
        self._RemoveWatermarkTask = None
        self._RebuildMediaTask = None
        self._ExtractTraceWatermarkTask = None
        self._ExtractCopyRightWatermarkTask = None
        self._ReviewAudioVideoTask = None
        self._ReduceMediaBitrateTask = None
        self._DescribeFileAttributesTask = None
        self._QualityInspectTask = None
        self._QualityEnhanceTask = None
        self._RequestId = None

    @property
    def TaskType(self):
        return self._TaskType

    @TaskType.setter
    def TaskType(self, TaskType):
        self._TaskType = TaskType

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def BeginProcessTime(self):
        return self._BeginProcessTime

    @BeginProcessTime.setter
    def BeginProcessTime(self, BeginProcessTime):
        self._BeginProcessTime = BeginProcessTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def ProcedureTask(self):
        return self._ProcedureTask

    @ProcedureTask.setter
    def ProcedureTask(self, ProcedureTask):
        self._ProcedureTask = ProcedureTask

    @property
    def EditMediaTask(self):
        return self._EditMediaTask

    @EditMediaTask.setter
    def EditMediaTask(self, EditMediaTask):
        self._EditMediaTask = EditMediaTask

    @property
    def WechatPublishTask(self):
        return self._WechatPublishTask

    @WechatPublishTask.setter
    def WechatPublishTask(self, WechatPublishTask):
        self._WechatPublishTask = WechatPublishTask

    @property
    def ComposeMediaTask(self):
        return self._ComposeMediaTask

    @ComposeMediaTask.setter
    def ComposeMediaTask(self, ComposeMediaTask):
        self._ComposeMediaTask = ComposeMediaTask

    @property
    def SplitMediaTask(self):
        return self._SplitMediaTask

    @SplitMediaTask.setter
    def SplitMediaTask(self, SplitMediaTask):
        self._SplitMediaTask = SplitMediaTask

    @property
    def WechatMiniProgramPublishTask(self):
        return self._WechatMiniProgramPublishTask

    @WechatMiniProgramPublishTask.setter
    def WechatMiniProgramPublishTask(self, WechatMiniProgramPublishTask):
        self._WechatMiniProgramPublishTask = WechatMiniProgramPublishTask

    @property
    def PullUploadTask(self):
        return self._PullUploadTask

    @PullUploadTask.setter
    def PullUploadTask(self, PullUploadTask):
        self._PullUploadTask = PullUploadTask

    @property
    def TranscodeTask(self):
        return self._TranscodeTask

    @TranscodeTask.setter
    def TranscodeTask(self, TranscodeTask):
        self._TranscodeTask = TranscodeTask

    @property
    def ConcatTask(self):
        return self._ConcatTask

    @ConcatTask.setter
    def ConcatTask(self, ConcatTask):
        self._ConcatTask = ConcatTask

    @property
    def ClipTask(self):
        return self._ClipTask

    @ClipTask.setter
    def ClipTask(self, ClipTask):
        self._ClipTask = ClipTask

    @property
    def CreateImageSpriteTask(self):
        return self._CreateImageSpriteTask

    @CreateImageSpriteTask.setter
    def CreateImageSpriteTask(self, CreateImageSpriteTask):
        self._CreateImageSpriteTask = CreateImageSpriteTask

    @property
    def SnapshotByTimeOffsetTask(self):
        return self._SnapshotByTimeOffsetTask

    @SnapshotByTimeOffsetTask.setter
    def SnapshotByTimeOffsetTask(self, SnapshotByTimeOffsetTask):
        self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask

    @property
    def RemoveWatermarkTask(self):
        return self._RemoveWatermarkTask

    @RemoveWatermarkTask.setter
    def RemoveWatermarkTask(self, RemoveWatermarkTask):
        self._RemoveWatermarkTask = RemoveWatermarkTask

    @property
    def RebuildMediaTask(self):
        return self._RebuildMediaTask

    @RebuildMediaTask.setter
    def RebuildMediaTask(self, RebuildMediaTask):
        self._RebuildMediaTask = RebuildMediaTask

    @property
    def ExtractTraceWatermarkTask(self):
        return self._ExtractTraceWatermarkTask

    @ExtractTraceWatermarkTask.setter
    def ExtractTraceWatermarkTask(self, ExtractTraceWatermarkTask):
        self._ExtractTraceWatermarkTask = ExtractTraceWatermarkTask

    @property
    def ExtractCopyRightWatermarkTask(self):
        return self._ExtractCopyRightWatermarkTask

    @ExtractCopyRightWatermarkTask.setter
    def ExtractCopyRightWatermarkTask(self, ExtractCopyRightWatermarkTask):
        self._ExtractCopyRightWatermarkTask = ExtractCopyRightWatermarkTask

    @property
    def ReviewAudioVideoTask(self):
        return self._ReviewAudioVideoTask

    @ReviewAudioVideoTask.setter
    def ReviewAudioVideoTask(self, ReviewAudioVideoTask):
        self._ReviewAudioVideoTask = ReviewAudioVideoTask

    @property
    def ReduceMediaBitrateTask(self):
        return self._ReduceMediaBitrateTask

    @ReduceMediaBitrateTask.setter
    def ReduceMediaBitrateTask(self, ReduceMediaBitrateTask):
        self._ReduceMediaBitrateTask = ReduceMediaBitrateTask

    @property
    def DescribeFileAttributesTask(self):
        return self._DescribeFileAttributesTask

    @DescribeFileAttributesTask.setter
    def DescribeFileAttributesTask(self, DescribeFileAttributesTask):
        self._DescribeFileAttributesTask = DescribeFileAttributesTask

    @property
    def QualityInspectTask(self):
        return self._QualityInspectTask

    @QualityInspectTask.setter
    def QualityInspectTask(self, QualityInspectTask):
        self._QualityInspectTask = QualityInspectTask

    @property
    def QualityEnhanceTask(self):
        return self._QualityEnhanceTask

    @QualityEnhanceTask.setter
    def QualityEnhanceTask(self, QualityEnhanceTask):
        self._QualityEnhanceTask = QualityEnhanceTask

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskType = params.get("TaskType")
        self._Status = params.get("Status")
        self._CreateTime = params.get("CreateTime")
        self._BeginProcessTime = params.get("BeginProcessTime")
        self._FinishTime = params.get("FinishTime")
        if params.get("ProcedureTask") is not None:
            self._ProcedureTask = ProcedureTask()
            self._ProcedureTask._deserialize(params.get("ProcedureTask"))
        if params.get("EditMediaTask") is not None:
            self._EditMediaTask = EditMediaTask()
            self._EditMediaTask._deserialize(params.get("EditMediaTask"))
        if params.get("WechatPublishTask") is not None:
            self._WechatPublishTask = WechatPublishTask()
            self._WechatPublishTask._deserialize(params.get("WechatPublishTask"))
        if params.get("ComposeMediaTask") is not None:
            self._ComposeMediaTask = ComposeMediaTask()
            self._ComposeMediaTask._deserialize(params.get("ComposeMediaTask"))
        if params.get("SplitMediaTask") is not None:
            self._SplitMediaTask = SplitMediaTask()
            self._SplitMediaTask._deserialize(params.get("SplitMediaTask"))
        if params.get("WechatMiniProgramPublishTask") is not None:
            self._WechatMiniProgramPublishTask = WechatMiniProgramPublishTask()
            self._WechatMiniProgramPublishTask._deserialize(params.get("WechatMiniProgramPublishTask"))
        if params.get("PullUploadTask") is not None:
            self._PullUploadTask = PullUploadTask()
            self._PullUploadTask._deserialize(params.get("PullUploadTask"))
        if params.get("TranscodeTask") is not None:
            self._TranscodeTask = TranscodeTask2017()
            self._TranscodeTask._deserialize(params.get("TranscodeTask"))
        if params.get("ConcatTask") is not None:
            self._ConcatTask = ConcatTask2017()
            self._ConcatTask._deserialize(params.get("ConcatTask"))
        if params.get("ClipTask") is not None:
            self._ClipTask = ClipTask2017()
            self._ClipTask._deserialize(params.get("ClipTask"))
        if params.get("CreateImageSpriteTask") is not None:
            self._CreateImageSpriteTask = CreateImageSpriteTask2017()
            self._CreateImageSpriteTask._deserialize(params.get("CreateImageSpriteTask"))
        if params.get("SnapshotByTimeOffsetTask") is not None:
            self._SnapshotByTimeOffsetTask = SnapshotByTimeOffsetTask2017()
            self._SnapshotByTimeOffsetTask._deserialize(params.get("SnapshotByTimeOffsetTask"))
        if params.get("RemoveWatermarkTask") is not None:
            self._RemoveWatermarkTask = RemoveWatermarkTask()
            self._RemoveWatermarkTask._deserialize(params.get("RemoveWatermarkTask"))
        if params.get("RebuildMediaTask") is not None:
            self._RebuildMediaTask = RebuildMediaTask()
            self._RebuildMediaTask._deserialize(params.get("RebuildMediaTask"))
        if params.get("ExtractTraceWatermarkTask") is not None:
            self._ExtractTraceWatermarkTask = ExtractTraceWatermarkTask()
            self._ExtractTraceWatermarkTask._deserialize(params.get("ExtractTraceWatermarkTask"))
        if params.get("ExtractCopyRightWatermarkTask") is not None:
            self._ExtractCopyRightWatermarkTask = ExtractCopyRightWatermarkTask()
            self._ExtractCopyRightWatermarkTask._deserialize(params.get("ExtractCopyRightWatermarkTask"))
        if params.get("ReviewAudioVideoTask") is not None:
            self._ReviewAudioVideoTask = ReviewAudioVideoTask()
            self._ReviewAudioVideoTask._deserialize(params.get("ReviewAudioVideoTask"))
        if params.get("ReduceMediaBitrateTask") is not None:
            self._ReduceMediaBitrateTask = ReduceMediaBitrateTask()
            self._ReduceMediaBitrateTask._deserialize(params.get("ReduceMediaBitrateTask"))
        if params.get("DescribeFileAttributesTask") is not None:
            self._DescribeFileAttributesTask = DescribeFileAttributesTask()
            self._DescribeFileAttributesTask._deserialize(params.get("DescribeFileAttributesTask"))
        if params.get("QualityInspectTask") is not None:
            self._QualityInspectTask = QualityInspectTask()
            self._QualityInspectTask._deserialize(params.get("QualityInspectTask"))
        if params.get("QualityEnhanceTask") is not None:
            self._QualityEnhanceTask = QualityEnhanceTask()
            self._QualityEnhanceTask._deserialize(params.get("QualityEnhanceTask"))
        self._RequestId = params.get("RequestId")


class DescribeTasksRequest(AbstractModel):
    """DescribeTasks request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Status: Filter: Task status. Valid values: WAITING (waiting), PROCESSING (processing), FINISH (completed).
        :type Status: str
        :param _FileId: Filter: file ID.
        :type FileId: str
        :param _CreateTime: Filter: task creation time.
        :type CreateTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _FinishTime: Filter: task end time.
        :type FinishTime: :class:`tencentcloud.vod.v20180717.models.TimeRange`
        :param _Sort: Sort field. Valid values:
<li>`CreateTime`: task creation time</li>
<li>`FinishTime`: task end time</li>
        :type Sort: :class:`tencentcloud.vod.v20180717.models.SortBy`
        :param _Limit: Number of entries to be returned. Default value: 10. Maximum value: 100.
        :type Limit: int
        :param _ScrollToken: Scrolling identifier which is used for pulling in batches. If a single request cannot pull all the data entries, the API will return `ScrollToken`, and if the next request carries it, the next pull will start from the next entry.
        :type ScrollToken: str
        """
        self._SubAppId = None
        self._Status = None
        self._FileId = None
        self._CreateTime = None
        self._FinishTime = None
        self._Sort = None
        self._Limit = None
        self._ScrollToken = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def FinishTime(self):
        return self._FinishTime

    @FinishTime.setter
    def FinishTime(self, FinishTime):
        self._FinishTime = FinishTime

    @property
    def Sort(self):
        return self._Sort

    @Sort.setter
    def Sort(self, Sort):
        self._Sort = Sort

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Status = params.get("Status")
        self._FileId = params.get("FileId")
        if params.get("CreateTime") is not None:
            self._CreateTime = TimeRange()
            self._CreateTime._deserialize(params.get("CreateTime"))
        if params.get("FinishTime") is not None:
            self._FinishTime = TimeRange()
            self._FinishTime._deserialize(params.get("FinishTime"))
        if params.get("Sort") is not None:
            self._Sort = SortBy()
            self._Sort._deserialize(params.get("Sort"))
        self._Limit = params.get("Limit")
        self._ScrollToken = params.get("ScrollToken")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTasksResponse(AbstractModel):
    """DescribeTasks response structure.

    """

    def __init__(self):
        r"""
        :param _TaskSet: Task overview list.
        :type TaskSet: list of TaskSimpleInfo
        :param _ScrollToken: Scrolling identifier. If a request does not return all the data entries, this field indicates the ID of the next entry. If this field is empty, there is no more data.
        :type ScrollToken: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskSet = None
        self._ScrollToken = None
        self._RequestId = None

    @property
    def TaskSet(self):
        return self._TaskSet

    @TaskSet.setter
    def TaskSet(self, TaskSet):
        self._TaskSet = TaskSet

    @property
    def ScrollToken(self):
        return self._ScrollToken

    @ScrollToken.setter
    def ScrollToken(self, ScrollToken):
        self._ScrollToken = ScrollToken

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        if params.get("TaskSet") is not None:
            self._TaskSet = []
            for item in params.get("TaskSet"):
                obj = TaskSimpleInfo()
                obj._deserialize(item)
                self._TaskSet.append(obj)
        self._ScrollToken = params.get("ScrollToken")
        self._RequestId = params.get("RequestId")


class DescribeTranscodeTemplatesRequest(AbstractModel):
    """DescribeTranscodeTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Definitions: Unique ID filter of transcoding templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Type: Template type filter. Valid values:
<li>Preset: preset template;</li>
<li>Custom: custom template.</li>
        :type Type: str
        :param _ContainerType: Container filter. Valid values:
<li>Video: video container that can contain both video stream and audio stream;</li>
<li>PureAudio: audio container that can contain only audio stream.</li>
        :type ContainerType: str
        :param _TEHDType: TESHD filter, which is used to filter common transcoding or ultra-fast HD transcoding templates. Valid values:
<li>Common: Common transcoding template;</li>
<li>TEHD: TESHD template.</li>
        :type TEHDType: str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of returned entries. Default value: 10. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Definitions = None
        self._Type = None
        self._ContainerType = None
        self._TEHDType = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ContainerType(self):
        return self._ContainerType

    @ContainerType.setter
    def ContainerType(self, ContainerType):
        self._ContainerType = ContainerType

    @property
    def TEHDType(self):
        return self._TEHDType

    @TEHDType.setter
    def TEHDType(self, TEHDType):
        self._TEHDType = TEHDType

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Definitions = params.get("Definitions")
        self._Type = params.get("Type")
        self._ContainerType = params.get("ContainerType")
        self._TEHDType = params.get("TEHDType")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeTranscodeTemplatesResponse(AbstractModel):
    """DescribeTranscodeTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _TranscodeTemplateSet: List of transcoding template details.
Note: this field may return null, indicating that no valid values can be obtained.
        :type TranscodeTemplateSet: list of TranscodeTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._TranscodeTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def TranscodeTemplateSet(self):
        return self._TranscodeTemplateSet

    @TranscodeTemplateSet.setter
    def TranscodeTemplateSet(self, TranscodeTemplateSet):
        self._TranscodeTemplateSet = TranscodeTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("TranscodeTemplateSet") is not None:
            self._TranscodeTemplateSet = []
            for item in params.get("TranscodeTemplateSet"):
                obj = TranscodeTemplate()
                obj._deserialize(item)
                self._TranscodeTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeVodDomainsRequest(AbstractModel):
    """DescribeVodDomains request structure.

    """

    def __init__(self):
        r"""
        :param _Domains: Domain name list. When this field is left blank, all domain name information will be listed by default. The limitations of this field are as follows:
<li>The maximum number of domain names is 20. </li>
        :type Domains: list of str
        :param _Limit: Maximum results to return for pulling paginated queries. Default value: 20
        :type Limit: int
        :param _Offset: Page number offset from the beginning of paginated queries. Default value: 0
        :type Offset: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        """
        self._Domains = None
        self._Limit = None
        self._Offset = None
        self._SubAppId = None

    @property
    def Domains(self):
        return self._Domains

    @Domains.setter
    def Domains(self, Domains):
        self._Domains = Domains

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId


    def _deserialize(self, params):
        self._Domains = params.get("Domains")
        self._Limit = params.get("Limit")
        self._Offset = params.get("Offset")
        self._SubAppId = params.get("SubAppId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeVodDomainsResponse(AbstractModel):
    """DescribeVodDomains response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Total number of domain names
        :type TotalCount: int
        :param _DomainSet: Domain name information list
        :type DomainSet: list of DomainDetailInfo
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._DomainSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def DomainSet(self):
        return self._DomainSet

    @DomainSet.setter
    def DomainSet(self, DomainSet):
        self._DomainSet = DomainSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("DomainSet") is not None:
            self._DomainSet = []
            for item in params.get("DomainSet"):
                obj = DomainDetailInfo()
                obj._deserialize(item)
                self._DomainSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWatermarkTemplatesRequest(AbstractModel):
    """DescribeWatermarkTemplates request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Type: Watermark type filter. Valid values:
<li>image: image watermark;</li>
<li>text: text watermark.</li>
        :type Type: str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Definitions: Unique ID filter of watermarking templates. Array length limit: 100.
        :type Definitions: list of int
        :param _Limit: Number of returned entries
<li>Default value: 10;</li>
<li>Maximum value: 100.</li>
        :type Limit: int
        """
        self._SubAppId = None
        self._Type = None
        self._Offset = None
        self._Definitions = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Definitions(self):
        return self._Definitions

    @Definitions.setter
    def Definitions(self, Definitions):
        self._Definitions = Definitions

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Type = params.get("Type")
        self._Offset = params.get("Offset")
        self._Definitions = params.get("Definitions")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWatermarkTemplatesResponse(AbstractModel):
    """DescribeWatermarkTemplates response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WatermarkTemplateSet: List of watermarking template details.
Note: this field may return null, indicating that no valid values can be obtained.
        :type WatermarkTemplateSet: list of WatermarkTemplate
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WatermarkTemplateSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WatermarkTemplateSet(self):
        return self._WatermarkTemplateSet

    @WatermarkTemplateSet.setter
    def WatermarkTemplateSet(self, WatermarkTemplateSet):
        self._WatermarkTemplateSet = WatermarkTemplateSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WatermarkTemplateSet") is not None:
            self._WatermarkTemplateSet = []
            for item in params.get("WatermarkTemplateSet"):
                obj = WatermarkTemplate()
                obj._deserialize(item)
                self._WatermarkTemplateSet.append(obj)
        self._RequestId = params.get("RequestId")


class DescribeWordSamplesRequest(AbstractModel):
    """DescribeWordSamples request structure.

    """

    def __init__(self):
        r"""
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _Usages: <b>Keyword usage. Valid values:</b>
1. Recognition.Ocr: OCR-based content recognition
2. Recognition.Asr: ASR-based content recognition
3. Review.Ocr: OCR-based inappropriate information recognition
4. Review.Asr: ASR-based inappropriate information recognition
<b>Valid values can also be:</b>
5. Recognition: ASR- and OCR-based content recognition; equivalent to 1+2
6. Review: ASR- and OCR-based inappropriate information recognition; equivalent to 3+4
You can select multiple elements, which are connected by OR logic. If a use case contains any element in this parameter, the keyword sample will be used.
        :type Usages: list of str
        :param _Keywords: Keyword filter. Array length limit: 100 words.
        :type Keywords: list of str
        :param _Tags: Tag filter. Array length limit: 20 words.
        :type Tags: list of str
        :param _Offset: Pagination offset. Default value: 0.
        :type Offset: int
        :param _Limit: Number of entries to be returned. Default value: 100. Maximum value: 100.
        :type Limit: int
        """
        self._SubAppId = None
        self._Usages = None
        self._Keywords = None
        self._Tags = None
        self._Offset = None
        self._Limit = None

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def Usages(self):
        return self._Usages

    @Usages.setter
    def Usages(self, Usages):
        self._Usages = Usages

    @property
    def Keywords(self):
        return self._Keywords

    @Keywords.setter
    def Keywords(self, Keywords):
        self._Keywords = Keywords

    @property
    def Tags(self):
        return self._Tags

    @Tags.setter
    def Tags(self, Tags):
        self._Tags = Tags

    @property
    def Offset(self):
        return self._Offset

    @Offset.setter
    def Offset(self, Offset):
        self._Offset = Offset

    @property
    def Limit(self):
        return self._Limit

    @Limit.setter
    def Limit(self, Limit):
        self._Limit = Limit


    def _deserialize(self, params):
        self._SubAppId = params.get("SubAppId")
        self._Usages = params.get("Usages")
        self._Keywords = params.get("Keywords")
        self._Tags = params.get("Tags")
        self._Offset = params.get("Offset")
        self._Limit = params.get("Limit")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DescribeWordSamplesResponse(AbstractModel):
    """DescribeWordSamples response structure.

    """

    def __init__(self):
        r"""
        :param _TotalCount: Number of eligible entries.
        :type TotalCount: int
        :param _WordSet: Keyword information.
        :type WordSet: list of AiSampleWord
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TotalCount = None
        self._WordSet = None
        self._RequestId = None

    @property
    def TotalCount(self):
        return self._TotalCount

    @TotalCount.setter
    def TotalCount(self, TotalCount):
        self._TotalCount = TotalCount

    @property
    def WordSet(self):
        return self._WordSet

    @WordSet.setter
    def WordSet(self, WordSet):
        self._WordSet = WordSet

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TotalCount = params.get("TotalCount")
        if params.get("WordSet") is not None:
            self._WordSet = []
            for item in params.get("WordSet"):
                obj = AiSampleWord()
                obj._deserialize(item)
                self._WordSet.append(obj)
        self._RequestId = params.get("RequestId")


class DomainDetailInfo(AbstractModel):
    """Domain name information

    """

    def __init__(self):
        r"""
        :param _Domain: Domain name
        :type Domain: str
        :param _AccelerateAreaInfos: Acceleration region information
Note: this field may return `null`, indicating that no valid value is obtained.
        :type AccelerateAreaInfos: list of AccelerateAreaInfo
        :param _DeployStatus: Deployment status. Valid values:
<li>Online</li>
<li>Deploying</li>
<li>Locked: you cannot change the deployment status of locked domain names</li>
        :type DeployStatus: str
        :param _HTTPSConfig: HTTPS configuration information
Note: this field may return `null`, indicating that no valid value is obtained.
        :type HTTPSConfig: :class:`tencentcloud.vod.v20180717.models.DomainHTTPSConfig`
        :param _UrlSignatureAuthPolicy: [Key hotlink protection](https://intl.cloud.tencent.com/document/product/266/33986) configuration
Note: this field may return `null`, indicating that no valid value is obtained.
        :type UrlSignatureAuthPolicy: :class:`tencentcloud.vod.v20180717.models.UrlSignatureAuthPolicy`
        :param _RefererAuthPolicy: [Referer hotlink protection](https://intl.cloud.tencent.com/document/product/266/33985) configuration
Note: this field may return `null`, indicating that no valid value is obtained.
        :type RefererAuthPolicy: :class:`tencentcloud.vod.v20180717.models.RefererAuthPolicy`
        :param _CreateTime: The time when the domain name was added in the VOD system
<li>The time is in [ISO 8601 date format](https://intl.cloud.tencent.com/document/product/266/11732).</li>
        :type CreateTime: str
        :param _QUICConfig: The QUIC configuration for the domain.
Note: This field may return null, indicating that no valid values can be obtained.
        :type QUICConfig: :class:`tencentcloud.vod.v20180717.models.DomainQUICConfig`
        """
        self._Domain = None
        self._AccelerateAreaInfos = None
        self._DeployStatus = None
        self._HTTPSConfig = None
        self._UrlSignatureAuthPolicy = None
        self._RefererAuthPolicy = None
        self._CreateTime = None
        self._QUICConfig = None

    @property
    def Domain(self):
        return self._Domain

    @Domain.setter
    def Domain(self, Domain):
        self._Domain = Domain

    @property
    def AccelerateAreaInfos(self):
        return self._AccelerateAreaInfos

    @AccelerateAreaInfos.setter
    def AccelerateAreaInfos(self, AccelerateAreaInfos):
        self._AccelerateAreaInfos = AccelerateAreaInfos

    @property
    def DeployStatus(self):
        return self._DeployStatus

    @DeployStatus.setter
    def DeployStatus(self, DeployStatus):
        self._DeployStatus = DeployStatus

    @property
    def HTTPSConfig(self):
        return self._HTTPSConfig

    @HTTPSConfig.setter
    def HTTPSConfig(self, HTTPSConfig):
        self._HTTPSConfig = HTTPSConfig

    @property
    def UrlSignatureAuthPolicy(self):
        return self._UrlSignatureAuthPolicy

    @UrlSignatureAuthPolicy.setter
    def UrlSignatureAuthPolicy(self, UrlSignatureAuthPolicy):
        self._UrlSignatureAuthPolicy = UrlSignatureAuthPolicy

    @property
    def RefererAuthPolicy(self):
        return self._RefererAuthPolicy

    @RefererAuthPolicy.setter
    def RefererAuthPolicy(self, RefererAuthPolicy):
        self._RefererAuthPolicy = RefererAuthPolicy

    @property
    def CreateTime(self):
        return self._CreateTime

    @CreateTime.setter
    def CreateTime(self, CreateTime):
        self._CreateTime = CreateTime

    @property
    def QUICConfig(self):
        return self._QUICConfig

    @QUICConfig.setter
    def QUICConfig(self, QUICConfig):
        self._QUICConfig = QUICConfig


    def _deserialize(self, params):
        self._Domain = params.get("Domain")
        if params.get("AccelerateAreaInfos") is not None:
            self._AccelerateAreaInfos = []
            for item in params.get("AccelerateAreaInfos"):
                obj = AccelerateAreaInfo()
                obj._deserialize(item)
                self._AccelerateAreaInfos.append(obj)
        self._DeployStatus = params.get("DeployStatus")
        if params.get("HTTPSConfig") is not None:
            self._HTTPSConfig = DomainHTTPSConfig()
            self._HTTPSConfig._deserialize(params.get("HTTPSConfig"))
        if params.get("UrlSignatureAuthPolicy") is not None:
            self._UrlSignatureAuthPolicy = UrlSignatureAuthPolicy()
            self._UrlSignatureAuthPolicy._deserialize(params.get("UrlSignatureAuthPolicy"))
        if params.get("RefererAuthPolicy") is not None:
            self._RefererAuthPolicy = RefererAuthPolicy()
            self._RefererAuthPolicy._deserialize(params.get("RefererAuthPolicy"))
        self._CreateTime = params.get("CreateTime")
        if params.get("QUICConfig") is not None:
            self._QUICConfig = DomainQUICConfig()
            self._QUICConfig._deserialize(params.get("QUICConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainHTTPSConfig(AbstractModel):
    """HTTPS configuration information of the domain name

    """

    def __init__(self):
        r"""
        :param _CertExpireTime: Time when the certificate expires
<li>The time is in [ISO 8601 date format](https://intl.cloud.tencent.com/document/product/266/11732).</li>
        :type CertExpireTime: str
        :param _CloudCertId: Certificate ID in Tencent Cloud SSL product.
        :type CloudCertId: str
        """
        self._CertExpireTime = None
        self._CloudCertId = None

    @property
    def CertExpireTime(self):
        return self._CertExpireTime

    @CertExpireTime.setter
    def CertExpireTime(self, CertExpireTime):
        self._CertExpireTime = CertExpireTime

    @property
    def CloudCertId(self):
        return self._CloudCertId

    @CloudCertId.setter
    def CloudCertId(self, CloudCertId):
        self._CloudCertId = CloudCertId


    def _deserialize(self, params):
        self._CertExpireTime = params.get("CertExpireTime")
        self._CloudCertId = params.get("CloudCertId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DomainQUICConfig(AbstractModel):
    """The QUIC configuration of a domain.

    """

    def __init__(self):
        r"""
        :param _Status: The QUIC status. Valid values:
<li>`Enabled`</li>
<li>`Disabled`</li>
        :type Status: str
        """
        self._Status = None

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status


    def _deserialize(self, params):
        self._Status = params.get("Status")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrmStreamingsInfo(AbstractModel):
    """DRM-protected adaptive bitstream playback information

    """

    def __init__(self):
        r"""
        :param _SimpleAesDefinition: ID of the adaptive bitrate streaming template whose protection type is SimpleAES.
        :type SimpleAesDefinition: int
        :param _WidevineDefinition: The ID of the adaptive bitrate streaming template that encrypts the streams by Widewine.
        :type WidevineDefinition: int
        :param _FairPlayDefinition: The ID of the adaptive bitrate streaming template that encrypts the streams by FairPlay.
        :type FairPlayDefinition: int
        """
        self._SimpleAesDefinition = None
        self._WidevineDefinition = None
        self._FairPlayDefinition = None

    @property
    def SimpleAesDefinition(self):
        return self._SimpleAesDefinition

    @SimpleAesDefinition.setter
    def SimpleAesDefinition(self, SimpleAesDefinition):
        self._SimpleAesDefinition = SimpleAesDefinition

    @property
    def WidevineDefinition(self):
        return self._WidevineDefinition

    @WidevineDefinition.setter
    def WidevineDefinition(self, WidevineDefinition):
        self._WidevineDefinition = WidevineDefinition

    @property
    def FairPlayDefinition(self):
        return self._FairPlayDefinition

    @FairPlayDefinition.setter
    def FairPlayDefinition(self, FairPlayDefinition):
        self._FairPlayDefinition = FairPlayDefinition


    def _deserialize(self, params):
        self._SimpleAesDefinition = params.get("SimpleAesDefinition")
        self._WidevineDefinition = params.get("WidevineDefinition")
        self._FairPlayDefinition = params.get("FairPlayDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DrmStreamingsInfoForUpdate(AbstractModel):
    """Modification object of DRM-protected adaptive bitstream playback information

    """

    def __init__(self):
        r"""
        :param _SimpleAesDefinition: ID of the adaptive bitrate streaming template whose protection type is SimpleAES.
        :type SimpleAesDefinition: int
        :param _WidevineDefinition: The ID of the adaptive bitrate streaming template that encrypts the streams by Widewine.
        :type WidevineDefinition: int
        :param _FairPlayDefinition: The ID of the adaptive bitrate streaming template that encrypts the streams by FairPlay.
        :type FairPlayDefinition: int
        """
        self._SimpleAesDefinition = None
        self._WidevineDefinition = None
        self._FairPlayDefinition = None

    @property
    def SimpleAesDefinition(self):
        return self._SimpleAesDefinition

    @SimpleAesDefinition.setter
    def SimpleAesDefinition(self, SimpleAesDefinition):
        self._SimpleAesDefinition = SimpleAesDefinition

    @property
    def WidevineDefinition(self):
        return self._WidevineDefinition

    @WidevineDefinition.setter
    def WidevineDefinition(self, WidevineDefinition):
        self._WidevineDefinition = WidevineDefinition

    @property
    def FairPlayDefinition(self):
        return self._FairPlayDefinition

    @FairPlayDefinition.setter
    def FairPlayDefinition(self, FairPlayDefinition):
        self._FairPlayDefinition = FairPlayDefinition


    def _deserialize(self, params):
        self._SimpleAesDefinition = params.get("SimpleAesDefinition")
        self._WidevineDefinition = params.get("WidevineDefinition")
        self._FairPlayDefinition = params.get("FairPlayDefinition")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class DynamicRangeInfo(AbstractModel):
    """Dynamic range information.

    """

    def __init__(self):
        r"""
        :param _Type: The dynamic range information. Valid values:
<li>`SDR`: Standard Dynamic Range</li>
<li>`HDR`: High Dynamic Range</li>
        :type Type: str
        :param _HDRType: The HDR type. This parameter is valid only if `Type` is `HDR`. Valid values:
<li>`hdr10`</li>
<li>`hlg`</li>
        :type HDRType: str
        """
        self._Type = None
        self._HDRType = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def HDRType(self):
        return self._HDRType

    @HDRType.setter
    def HDRType(self, HDRType):
        self._HDRType = HDRType


    def _deserialize(self, params):
        self._Type = params.get("Type")
        self._HDRType = params.get("HDRType")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaFileInfo(AbstractModel):
    """VOD video file editing information

    """

    def __init__(self):
        r"""
        :param _FileId: Video ID.
        :type FileId: str
        :param _StartTimeOffset: Offset time of the start of the video clip, unit: seconds.
        :type StartTimeOffset: float
        :param _EndTimeOffset: Offset time at the end of the video clip, unit: seconds.
        :type EndTimeOffset: float
        """
        self._FileId = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaOutputConfig(AbstractModel):
    """Result file output of edited video.

    """

    def __init__(self):
        r"""
        :param _MediaName: Output file name, up to 64 characters. By default, the generated file name is specified by the system.
        :type MediaName: str
        :param _Type: Output file format, optional values: mp4, hls. The default is mp4.
        :type Type: str
        :param _ClassId: Classification ID is used to classify media. You can create a classification through the Create Classification interface to obtain the classification ID. 
<li>Default value: 0, indicating other categories. </li>
        :type ClassId: int
        :param _ExpireTime: The expiration time of the output file. The file will be deleted after this time. The default is permanent and not expired. The format is expressed in accordance with the ISO 8601 standard. For details, see [ISO Date Format Description](https://www.tencentcloud.com/document/product/266/11732#iso-date-format).
        :type ExpireTime: str
        :param _VideoStream: Output video information.
        :type VideoStream: :class:`tencentcloud.vod.v20180717.models.EditMediaVideoStream`
        :param _TEHDConfig: TSC Transcoding Config.
        :type TEHDConfig: :class:`tencentcloud.vod.v20180717.models.EditMediaTEHDConfig`
        """
        self._MediaName = None
        self._Type = None
        self._ClassId = None
        self._ExpireTime = None
        self._VideoStream = None
        self._TEHDConfig = None

    @property
    def MediaName(self):
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime

    @property
    def VideoStream(self):
        return self._VideoStream

    @VideoStream.setter
    def VideoStream(self, VideoStream):
        self._VideoStream = VideoStream

    @property
    def TEHDConfig(self):
        return self._TEHDConfig

    @TEHDConfig.setter
    def TEHDConfig(self, TEHDConfig):
        self._TEHDConfig = TEHDConfig


    def _deserialize(self, params):
        self._MediaName = params.get("MediaName")
        self._Type = params.get("Type")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        if params.get("VideoStream") is not None:
            self._VideoStream = EditMediaVideoStream()
            self._VideoStream._deserialize(params.get("VideoStream"))
        if params.get("TEHDConfig") is not None:
            self._TEHDConfig = EditMediaTEHDConfig()
            self._TEHDConfig._deserialize(params.get("TEHDConfig"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaRequest(AbstractModel):
    """EditMedia request structure.

    """

    def __init__(self):
        r"""
        :param _InputType: Input the type of video. The possible values u200bu200bare File and Stream.
        :type InputType: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _FileInfos: Input video file information, required when InputType is File.
        :type FileInfos: list of EditMediaFileInfo
        :param _StreamInfos: nput stream information, required when InputType is Stream.
        :type StreamInfos: list of EditMediaStreamInfo
        :param _Definition: EditMedia template ID. The values u200bu200bare 10 and 20. If left blank, the 10 template is used. 
<li>10: When splicing, the input with the highest resolution is used as the benchmark;</li>
<li>20: When splicing, the input with the highest code rate is used as the benchmark. </li>
        :type Definition: int
        :param _ProcedureName: Task flow template name, if you want Fill in when executing the task flow on the generated new video.
        :type ProcedureName: str
        :param _OutputConfig: The file configuration generated after editing.
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.EditMediaOutputConfig`
        :param _SessionContext: Identifies the source context, which is used to transparently transmit user request information. This field value will be returned in the EditMediaComplete callback and task flow status change callback, with a maximum length of 1000 characters.
        :type SessionContext: str
        :param _TasksPriority: The priority of the task. The larger the value, the higher the priority. The value range is -10 to 10. If left blank, it means 0.
        :type TasksPriority: int
        :param _SessionId: The identification code used for task deduplication. If there is a request with the same identification code within three days, this request will return an error. The maximum length is 50 characters, without or with an empty string to indicate no deduplication.
        :type SessionId: str
        :param _ExtInfo: Reserved fields, used for special purposes.
        :type ExtInfo: str
        """
        self._InputType = None
        self._SubAppId = None
        self._FileInfos = None
        self._StreamInfos = None
        self._Definition = None
        self._ProcedureName = None
        self._OutputConfig = None
        self._SessionContext = None
        self._TasksPriority = None
        self._SessionId = None
        self._ExtInfo = None

    @property
    def InputType(self):
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def FileInfos(self):
        return self._FileInfos

    @FileInfos.setter
    def FileInfos(self, FileInfos):
        self._FileInfos = FileInfos

    @property
    def StreamInfos(self):
        return self._StreamInfos

    @StreamInfos.setter
    def StreamInfos(self, StreamInfos):
        self._StreamInfos = StreamInfos

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def ProcedureName(self):
        return self._ProcedureName

    @ProcedureName.setter
    def ProcedureName(self, ProcedureName):
        self._ProcedureName = ProcedureName

    @property
    def OutputConfig(self):
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._InputType = params.get("InputType")
        self._SubAppId = params.get("SubAppId")
        if params.get("FileInfos") is not None:
            self._FileInfos = []
            for item in params.get("FileInfos"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfos.append(obj)
        if params.get("StreamInfos") is not None:
            self._StreamInfos = []
            for item in params.get("StreamInfos"):
                obj = EditMediaStreamInfo()
                obj._deserialize(item)
                self._StreamInfos.append(obj)
        self._Definition = params.get("Definition")
        self._ProcedureName = params.get("ProcedureName")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = EditMediaOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._SessionId = params.get("SessionId")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaResponse(AbstractModel):
    """EditMedia response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID of the video editing. You can use this ID to query the status of the editing task (task type is EditMedia).
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class EditMediaStreamInfo(AbstractModel):
    """Video stream editing information

    """

    def __init__(self):
        r"""
        :param _StreamId: ID of recorded stream
        :type StreamId: str
        :param _StartTime: Start time of stream clipping in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
Note: this field may return null, indicating that no valid values can be obtained.
        :type StartTime: str
        :param _EndTime: End time of stream clipping in [ISO date format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
Note: this field may return null, indicating that no valid values can be obtained.
        :type EndTime: str
        """
        self._StreamId = None
        self._StartTime = None
        self._EndTime = None

    @property
    def StreamId(self):
        return self._StreamId

    @StreamId.setter
    def StreamId(self, StreamId):
        self._StreamId = StreamId

    @property
    def StartTime(self):
        return self._StartTime

    @StartTime.setter
    def StartTime(self, StartTime):
        self._StartTime = StartTime

    @property
    def EndTime(self):
        return self._EndTime

    @EndTime.setter
    def EndTime(self, EndTime):
        self._EndTime = EndTime


    def _deserialize(self, params):
        self._StreamId = params.get("StreamId")
        self._StartTime = params.get("StartTime")
        self._EndTime = params.get("EndTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTEHDConfig(AbstractModel):
    """EditMediaT TSC Transcoding Config.

    """

    def __init__(self):
        r"""
        :param _Type: TSC Transcoding type, optional values: <li>TEHD-100 means TSC Transcoding-definition-100;</li> <li>OFF means turning off TSC Transcoding-definition. </li>Leave it blank to indicate OFF.
        :type Type: str
        """
        self._Type = None

    @property
    def Type(self):
        return self._Type

    @Type.setter
    def Type(self, Type):
        self._Type = Type


    def _deserialize(self, params):
        self._Type = params.get("Type")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTask(AbstractModel):
    """Video editing task information

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _Status: Task flow status. Valid values:
<li>PROCESSING: processing;</li>
<li>FINISH: completed.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type Status: str
        :param _ErrCode: Error code. 0: success; other values: failure.
<li>40000: invalid input parameter. Please check it;</li>
<li>60000: invalid source file (e.g., video data is corrupted). Please check whether the source file is normal;</li>
<li>70000: internal service error. Please try again.</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ErrCode: int
        :param _ErrCodeExt: Error code. An empty string indicates the task is successful; other values indicate failure. For details, see [Video Processing Error Codes](https://intl.cloud.tencent.com/zh/document/product/266/39145).
        :type ErrCodeExt: str
        :param _Message: Error message.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Message: str
        :param _Progress: Progress of a video editing task. Value range: [0, 100]
        :type Progress: int
        :param _Input: Input of video editing task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Input: :class:`tencentcloud.vod.v20180717.models.EditMediaTaskInput`
        :param _Output: Output of video editing task.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.EditMediaTaskOutput`
        :param _MetaData: The metadata of the output video.
        :type MetaData: :class:`tencentcloud.vod.v20180717.models.MediaMetaData`
        :param _ProcedureTaskId: The task ID for the task type `Procedure`. If a task flow (`ProcedureName`) is specified by [EditMedia](https://intl.cloud.tencent.com/document/api/266/34783?from_cn_redirect=1), and the task flow includes one or more of `MediaProcessTask`, `AiAnalysisTask`, and `AiRecognitionTask`, the task specified by this parameter will be executed.
        :type ProcedureTaskId: str
        :param _ReviewAudioVideoTaskId: The task ID for the task type `ReviewAudioVideo`. If a task flow (`ProcedureName`) is specified by [EditMedia](https://intl.cloud.tencent.com/document/api/266/34783?from_cn_redirect=1), and the task flow includes `ReviewAudioVideoTask`, the task specified by this parameter will be executed.
        :type ReviewAudioVideoTaskId: str
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or a blank string is entered, no deduplication will be performed.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SessionId: str
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
Note: this field may return null, indicating that no valid values can be obtained.
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._ErrCodeExt = None
        self._Message = None
        self._Progress = None
        self._Input = None
        self._Output = None
        self._MetaData = None
        self._ProcedureTaskId = None
        self._ReviewAudioVideoTaskId = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def Progress(self):
        return self._Progress

    @Progress.setter
    def Progress(self, Progress):
        self._Progress = Progress

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def MetaData(self):
        return self._MetaData

    @MetaData.setter
    def MetaData(self, MetaData):
        self._MetaData = MetaData

    @property
    def ProcedureTaskId(self):
        return self._ProcedureTaskId

    @ProcedureTaskId.setter
    def ProcedureTaskId(self, ProcedureTaskId):
        self._ProcedureTaskId = ProcedureTaskId

    @property
    def ReviewAudioVideoTaskId(self):
        return self._ReviewAudioVideoTaskId

    @ReviewAudioVideoTaskId.setter
    def ReviewAudioVideoTaskId(self, ReviewAudioVideoTaskId):
        self._ReviewAudioVideoTaskId = ReviewAudioVideoTaskId

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._ErrCodeExt = params.get("ErrCodeExt")
        self._Message = params.get("Message")
        self._Progress = params.get("Progress")
        if params.get("Input") is not None:
            self._Input = EditMediaTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = EditMediaTaskOutput()
            self._Output._deserialize(params.get("Output"))
        if params.get("MetaData") is not None:
            self._MetaData = MediaMetaData()
            self._MetaData._deserialize(params.get("MetaData"))
        self._ProcedureTaskId = params.get("ProcedureTaskId")
        self._ReviewAudioVideoTaskId = params.get("ReviewAudioVideoTaskId")
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskInput(AbstractModel):
    """Input of video editing task.

    """

    def __init__(self):
        r"""
        :param _InputType: Input video source type. Valid values: File, Stream.
        :type InputType: str
        :param _FileInfoSet: Information of input video file. This field has a value only when `InputType` is `File`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileInfoSet: list of EditMediaFileInfo
        :param _StreamInfoSet: Input stream information. This field has a value only when `InputType` is `Stream`.
Note: this field may return null, indicating that no valid values can be obtained.
        :type StreamInfoSet: list of EditMediaStreamInfo
        """
        self._InputType = None
        self._FileInfoSet = None
        self._StreamInfoSet = None

    @property
    def InputType(self):
        return self._InputType

    @InputType.setter
    def InputType(self, InputType):
        self._InputType = InputType

    @property
    def FileInfoSet(self):
        return self._FileInfoSet

    @FileInfoSet.setter
    def FileInfoSet(self, FileInfoSet):
        self._FileInfoSet = FileInfoSet

    @property
    def StreamInfoSet(self):
        return self._StreamInfoSet

    @StreamInfoSet.setter
    def StreamInfoSet(self, StreamInfoSet):
        self._StreamInfoSet = StreamInfoSet


    def _deserialize(self, params):
        self._InputType = params.get("InputType")
        if params.get("FileInfoSet") is not None:
            self._FileInfoSet = []
            for item in params.get("FileInfoSet"):
                obj = EditMediaFileInfo()
                obj._deserialize(item)
                self._FileInfoSet.append(obj)
        if params.get("StreamInfoSet") is not None:
            self._StreamInfoSet = []
            for item in params.get("StreamInfoSet"):
                obj = EditMediaStreamInfo()
                obj._deserialize(item)
                self._StreamInfoSet.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaTaskOutput(AbstractModel):
    """Output of video editing task

    """

    def __init__(self):
        r"""
        :param _FileType: File type, such as mp4 and flv.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileType: str
        :param _FileUrl: Media file playback address.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileUrl: str
        :param _FileId: Media file ID.
Note: this field may return null, indicating that no valid values can be obtained.
        :type FileId: str
        :param _MediaName: Output filename of up to 64 characters, which is generated by the system by default.
Note: this field may return null, indicating that no valid values can be obtained.
        :type MediaName: str
        :param _ClassId: Category ID, which is used to categorize the media for management. A category can be created and its ID can be obtained by using the [category creating](https://intl.cloud.tencent.com/document/product/266/7812?from_cn_redirect=1) API.
<li>Default value: 0, which means "Other".</li>
Note: this field may return null, indicating that no valid values can be obtained.
        :type ClassId: int
        :param _ExpireTime: Expiration time of output media file in ISO 8601 format, after which the file will be deleted. Files will never expire by default. For more information, please see [Notes on ISO Date Format](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I).
Note: this field may return null, indicating that no valid values can be obtained.
        :type ExpireTime: str
        """
        self._FileType = None
        self._FileUrl = None
        self._FileId = None
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None

    @property
    def FileType(self):
        return self._FileType

    @FileType.setter
    def FileType(self, FileType):
        self._FileType = FileType

    @property
    def FileUrl(self):
        return self._FileUrl

    @FileUrl.setter
    def FileUrl(self, FileUrl):
        self._FileUrl = FileUrl

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def MediaName(self):
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._FileType = params.get("FileType")
        self._FileUrl = params.get("FileUrl")
        self._FileId = params.get("FileId")
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EditMediaVideoStream(AbstractModel):
    """Video stream configuration information

    """

    def __init__(self):
        r"""
        :param _Codec: The encoding format of the video stream, optional values:
<li>libx264: H.264 encoding;</li>
<li>libx265: H.265 encoding;</li>
<li>av1: AOMedia Video 1 encoding;</li>
<li>H.266: H.266 encoding. </li>
        :type Codec: str
        :param _Bitrate: The bit rate of the video stream, value range: 0 and [128, 35000], unit: kbps. 
When the value is 0 or left blank, it means automatically selecting the best video bit rate.
        :type Bitrate: int
        :param _ResolutionAdaptive: Resolution adaptive, optional values:
<li>open: open, at this time, Width represents the long side of the video, and Height represents the short side of the video;</li>
<li>close: closed, at this time , Width represents the width of the video, and Height represents the height of the video. </li>
Default value: open.
        :type ResolutionAdaptive: str
        :param _Width: Resolution adaptive, optional values:
<li>open: open, at this time, Width represents the long side of the video, and Height represents the short side of the video;</li>
<li>close: closed, at this time , Width represents the width of the video, and Height represents the height of the video. </li>
Default value: open.
        :type Width: int
        :param _Height: The maximum value of the video stream height (or short side), value range: 0 and [128, 4096], unit: px. 
<li>When Width and Height are both 0, the resolution is based on the base resolution;</li>
<li>When Width is 0 and Height is non-0, Width is scaled according to the base resolution;</li> li>
<li>When Width is non-0 and Height is 0, the Height is scaled according to the base resolution; </li>
<li>When both Width and Height are non-0, the resolution is specified by the user. </li>
Default value: 0.
        :type Height: int
        :param _Fps: Video frame rate, value range: [0, 100], unit: Hz. 
When the value is 0, the frame rate will be automatically set for the video. 
The default value is 0.
        :type Fps: int
        """
        self._Codec = None
        self._Bitrate = None
        self._ResolutionAdaptive = None
        self._Width = None
        self._Height = None
        self._Fps = None

    @property
    def Codec(self):
        return self._Codec

    @Codec.setter
    def Codec(self, Codec):
        self._Codec = Codec

    @property
    def Bitrate(self):
        return self._Bitrate

    @Bitrate.setter
    def Bitrate(self, Bitrate):
        self._Bitrate = Bitrate

    @property
    def ResolutionAdaptive(self):
        return self._ResolutionAdaptive

    @ResolutionAdaptive.setter
    def ResolutionAdaptive(self, ResolutionAdaptive):
        self._ResolutionAdaptive = ResolutionAdaptive

    @property
    def Width(self):
        return self._Width

    @Width.setter
    def Width(self, Width):
        self._Width = Width

    @property
    def Height(self):
        return self._Height

    @Height.setter
    def Height(self, Height):
        self._Height = Height

    @property
    def Fps(self):
        return self._Fps

    @Fps.setter
    def Fps(self, Fps):
        self._Fps = Fps


    def _deserialize(self, params):
        self._Codec = params.get("Codec")
        self._Bitrate = params.get("Bitrate")
        self._ResolutionAdaptive = params.get("ResolutionAdaptive")
        self._Width = params.get("Width")
        self._Height = params.get("Height")
        self._Fps = params.get("Fps")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EmptyTrackItem(AbstractModel):
    """Empty track segment used as placeholder on time axis. If you want a period of silence between two audio segments, you can use `EmptyTrackItem` to hold the place.

    """

    def __init__(self):
        r"""
        :param _Duration: Duration in seconds.
        :type Duration: float
        """
        self._Duration = None

    @property
    def Duration(self):
        return self._Duration

    @Duration.setter
    def Duration(self, Duration):
        self._Duration = Duration


    def _deserialize(self, params):
        self._Duration = params.get("Duration")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnhanceMediaByTemplateRequest(AbstractModel):
    """EnhanceMediaByTemplate request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: File ID.
        :type FileId: str
        :param _Definition: Enhance Media Template ID.
        :type Definition: int
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _StartTimeOffset: Starting offset time, unit: seconds, leaving it blank means intercepting from the beginning of the video.
        :type StartTimeOffset: float
        :param _EndTimeOffset: End offset time, unit: seconds, leaving it blank means intercepting to the end of the video.
        :type EndTimeOffset: float
        :param _OutputConfig: File configuration after Enhance.
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.RebuildMediaOutputConfig`
        :param _SessionId: The identification code used for deduplication. If there is a request for the same identification code within three days, this request will return an error. The maximum length is 50 characters, without or with an empty string to indicate no deduplication.
        :type SessionId: str
        :param _SessionContext: Source context, used to transparently transmit user request information. The task flow status change callback will return the value of this field, which can be up to 1000 characters.
        :type SessionContext: str
        :param _TasksPriority: The priority of the task. The larger the value, the higher the priority. The value range is -10 to 10. If left blank, it means 0.
        :type TasksPriority: int
        :param _ExtInfo: Reserved fields, used for special purposes.
        :type ExtInfo: str
        """
        self._FileId = None
        self._Definition = None
        self._SubAppId = None
        self._StartTimeOffset = None
        self._EndTimeOffset = None
        self._OutputConfig = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def StartTimeOffset(self):
        return self._StartTimeOffset

    @StartTimeOffset.setter
    def StartTimeOffset(self, StartTimeOffset):
        self._StartTimeOffset = StartTimeOffset

    @property
    def EndTimeOffset(self):
        return self._EndTimeOffset

    @EndTimeOffset.setter
    def EndTimeOffset(self, EndTimeOffset):
        self._EndTimeOffset = EndTimeOffset

    @property
    def OutputConfig(self):
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        self._StartTimeOffset = params.get("StartTimeOffset")
        self._EndTimeOffset = params.get("EndTimeOffset")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = RebuildMediaOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnhanceMediaByTemplateResponse(AbstractModel):
    """EnhanceMediaByTemplate response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID of the Enhance Media. You can use this ID to query the status of the EnhanceMedia task.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class EnhanceMediaQualityOutputConfig(AbstractModel):
    """Remaster result file output

    """

    def __init__(self):
        r"""
        :param _MediaName: Output file name, up to 64 characters. The system will specify the file name by default
        :type MediaName: str
        :param _ClassId: Category ID, used for media classification management, can be obtained by [creating a category](https://intl.cloud.tencent.com/document/product/266/7812?from_cn_redirect=1) interface, create a category, get the category ID.
<li>Default value: 0, which means other categories.</li>
        :type ClassId: int
        :param _ExpireTime: The expiration time of the output file, the file will be deleted after this time, the default is never to expire, the format is in accordance with the ISO 8601 standard, see [ISO date format description](https://intl.cloud.tencent.com/document/product/266/11732?from_cn_redirect=1#I)。
        :type ExpireTime: str
        """
        self._MediaName = None
        self._ClassId = None
        self._ExpireTime = None

    @property
    def MediaName(self):
        return self._MediaName

    @MediaName.setter
    def MediaName(self, MediaName):
        self._MediaName = MediaName

    @property
    def ClassId(self):
        return self._ClassId

    @ClassId.setter
    def ClassId(self, ClassId):
        self._ClassId = ClassId

    @property
    def ExpireTime(self):
        return self._ExpireTime

    @ExpireTime.setter
    def ExpireTime(self, ExpireTime):
        self._ExpireTime = ExpireTime


    def _deserialize(self, params):
        self._MediaName = params.get("MediaName")
        self._ClassId = params.get("ClassId")
        self._ExpireTime = params.get("ExpireTime")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnhanceMediaQualityRequest(AbstractModel):
    """EnhanceMediaQuality request structure.

    """

    def __init__(self):
        r"""
        :param _FileId: Media file ID, that is, the globally unique identifier of the file on VOD, which is assigned by the VOD backend after successful upload. This field can be obtained from [video upload completion event notification](https://intl.cloud.tencent.com/document/product/266/7830?from_cn_redirect=1) or [vod console](https://console.cloud.tencent.com/vod/media).
        :type FileId: str
        :param _Definition: Remaster template ID, please contact Tencent Cloud for details
        :type Definition: int
        :param _SubAppId: <b>VOD [Subapplication](https://intl.cloud.tencent.com/document/product/266/14574?from_cn_redirect=1) ID. If you want to access resources in the Subapplication, enter the Subapplication ID in this field; otherwise, you do not need to fill in this field.</b>
        :type SubAppId: int
        :param _OutputConfig: Configuration of media files after Remaster
        :type OutputConfig: :class:`tencentcloud.vod.v20180717.models.EnhanceMediaQualityOutputConfig`
        :param _SessionId: The identification code used for deduplication. If there has been a request with the same identification code within three days, this request will return an error. Up to 50 characters, without or with an empty string means no deduplication
        :type SessionId: str
        :param _SessionContext: Source context, used to pass through user request information, Remaster completion callback will return this field value, up to 1000 characters
        :type SessionContext: str
        :param _TasksPriority: The priority of the task, the higher the value, the higher the priority, the range is -10 to 10, not filled in means 0
        :type TasksPriority: int
        """
        self._FileId = None
        self._Definition = None
        self._SubAppId = None
        self._OutputConfig = None
        self._SessionId = None
        self._SessionContext = None
        self._TasksPriority = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def Definition(self):
        return self._Definition

    @Definition.setter
    def Definition(self, Definition):
        self._Definition = Definition

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def OutputConfig(self):
        return self._OutputConfig

    @OutputConfig.setter
    def OutputConfig(self, OutputConfig):
        self._OutputConfig = OutputConfig

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        self._Definition = params.get("Definition")
        self._SubAppId = params.get("SubAppId")
        if params.get("OutputConfig") is not None:
            self._OutputConfig = EnhanceMediaQualityOutputConfig()
            self._OutputConfig._deserialize(params.get("OutputConfig"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        self._TasksPriority = params.get("TasksPriority")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class EnhanceMediaQualityResponse(AbstractModel):
    """EnhanceMediaQuality response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Remaster task ID
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class EventContent(AbstractModel):
    """Event notification content, where TranscodeCompleteEvent, ConcatCompleteEvent, ClipCompleteEvent, CreateImageSpriteCompleteEvent, and SnapshotByTimeOffsetCompleteEvent are event notifications for tasks that are initiated by v2017-compatible APIs.

    """

    def __init__(self):
        r"""
        :param _EventHandle: Event handler. The caller must call `ConfirmEvents` to confirm that the message has been received, and the confirmation is valid for 30 seconds. After the confirmation expires, the event can be obtained again.
        :type EventHandle: str
        :param _EventType: <b>Supported event types:</b><li>`NewFileUpload`: Video uploaded.</li><li>`ProcedureStateChanged`: Task flow status changed.</li><li>`FileDeleted`: Video deleted.</li><li>`RestoreMediaComplete`: Video retrieved.</li><li>`PullComplete`: Finished video pulling.</li><li>`EditMediaComplete`: Finished video editing.</li><li>`SplitMediaComplete`: Finished video splitting.</li><li>`ComposeMediaComplete`: Finished producing the media file.</li><li>`WechatMiniProgramPublishComplete`: Finished publishing on Weixin Mini Program.</li><li>`RemoveWatermark`: Watermark removed.</li><li>`RebuildMediaComplete`: Finished audio/video remastering.</li><li>`ReviewAudioVideoComplete`: Finished moderation.</li><li>`ExtractTraceWatermarkComplete`: Finished digital watermark extraction.</li><li>`DescribeFileAttributesComplete`: Finished getting file attributes.</li><li>`QualityEnhanceComplete`: FinishedQualityEnhance.</li><b>v2017 task types:</b><li>`TranscodeComplete`: Finished video transcoding.</li><li>`ConcatComplete`: Finished video splicing.</li><li>`ClipComplete`: Finished video clipping.</li><li>`CreateImageSpriteComplete`: Finished image sprite generation.</li><li>`CreateSnapshotByTimeOffsetComplete`: Finished time point screencapturing.</li>
        :type EventType: str
        :param _FileUploadEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type FileUploadEvent: :class:`tencentcloud.vod.v20180717.models.FileUploadTask`
        :param _ProcedureStateChangeEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ProcedureStateChangeEvent: :class:`tencentcloud.vod.v20180717.models.ProcedureTask`
        :param _FileDeleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type FileDeleteEvent: :class:`tencentcloud.vod.v20180717.models.FileDeleteTask`
        :param _PullCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type PullCompleteEvent: :class:`tencentcloud.vod.v20180717.models.PullUploadTask`
        :param _EditMediaCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type EditMediaCompleteEvent: :class:`tencentcloud.vod.v20180717.models.EditMediaTask`
        :param _SplitMediaCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type SplitMediaCompleteEvent: :class:`tencentcloud.vod.v20180717.models.SplitMediaTask`
        :param _ComposeMediaCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ComposeMediaCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ComposeMediaTask`
        :param _ClipCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ClipCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ClipTask2017`
        :param _TranscodeCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type TranscodeCompleteEvent: :class:`tencentcloud.vod.v20180717.models.TranscodeTask2017`
        :param _CreateImageSpriteCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type CreateImageSpriteCompleteEvent: :class:`tencentcloud.vod.v20180717.models.CreateImageSpriteTask2017`
        :param _ConcatCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ConcatCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ConcatTask2017`
        :param _SnapshotByTimeOffsetCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type SnapshotByTimeOffsetCompleteEvent: :class:`tencentcloud.vod.v20180717.models.SnapshotByTimeOffsetTask2017`
        :param _WechatPublishCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type WechatPublishCompleteEvent: :class:`tencentcloud.vod.v20180717.models.WechatPublishTask`
        :param _WechatMiniProgramPublishCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type WechatMiniProgramPublishCompleteEvent: :class:`tencentcloud.vod.v20180717.models.WechatMiniProgramPublishTask`
        :param _RemoveWatermarkCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type RemoveWatermarkCompleteEvent: :class:`tencentcloud.vod.v20180717.models.RemoveWatermarkTask`
        :param _RestoreMediaCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type RestoreMediaCompleteEvent: :class:`tencentcloud.vod.v20180717.models.RestoreMediaTask`
        :param _RebuildMediaCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type RebuildMediaCompleteEvent: :class:`tencentcloud.vod.v20180717.models.RebuildMediaTask`
        :param _ExtractTraceWatermarkCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtractTraceWatermarkCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTask`
        :param _ExtractCopyRightWatermarkCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ExtractCopyRightWatermarkCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTask`
        :param _ReviewAudioVideoCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ReviewAudioVideoCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ReviewAudioVideoTask`
        :param _ReduceMediaBitrateCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type ReduceMediaBitrateCompleteEvent: :class:`tencentcloud.vod.v20180717.models.ReduceMediaBitrateTask`
        :param _DescribeFileAttributesCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type DescribeFileAttributesCompleteEvent: :class:`tencentcloud.vod.v20180717.models.DescribeFileAttributesTask`
        :param _QualityInspectCompleteEvent: 
Note: This field may return null, indicating that no valid value can be obtained.
        :type QualityInspectCompleteEvent: :class:`tencentcloud.vod.v20180717.models.QualityInspectTask`
        :param _QualityEnhanceCompleteEvent: Remaster completion event, valid when the event type is QualityEnhanceComplete.
Pay attention to: this field may return null, indicating that no valid value can be obtained
        :type QualityEnhanceCompleteEvent: :class:`tencentcloud.vod.v20180717.models.QualityEnhanceTask`
        """
        self._EventHandle = None
        self._EventType = None
        self._FileUploadEvent = None
        self._ProcedureStateChangeEvent = None
        self._FileDeleteEvent = None
        self._PullCompleteEvent = None
        self._EditMediaCompleteEvent = None
        self._SplitMediaCompleteEvent = None
        self._ComposeMediaCompleteEvent = None
        self._ClipCompleteEvent = None
        self._TranscodeCompleteEvent = None
        self._CreateImageSpriteCompleteEvent = None
        self._ConcatCompleteEvent = None
        self._SnapshotByTimeOffsetCompleteEvent = None
        self._WechatPublishCompleteEvent = None
        self._WechatMiniProgramPublishCompleteEvent = None
        self._RemoveWatermarkCompleteEvent = None
        self._RestoreMediaCompleteEvent = None
        self._RebuildMediaCompleteEvent = None
        self._ExtractTraceWatermarkCompleteEvent = None
        self._ExtractCopyRightWatermarkCompleteEvent = None
        self._ReviewAudioVideoCompleteEvent = None
        self._ReduceMediaBitrateCompleteEvent = None
        self._DescribeFileAttributesCompleteEvent = None
        self._QualityInspectCompleteEvent = None
        self._QualityEnhanceCompleteEvent = None

    @property
    def EventHandle(self):
        return self._EventHandle

    @EventHandle.setter
    def EventHandle(self, EventHandle):
        self._EventHandle = EventHandle

    @property
    def EventType(self):
        return self._EventType

    @EventType.setter
    def EventType(self, EventType):
        self._EventType = EventType

    @property
    def FileUploadEvent(self):
        return self._FileUploadEvent

    @FileUploadEvent.setter
    def FileUploadEvent(self, FileUploadEvent):
        self._FileUploadEvent = FileUploadEvent

    @property
    def ProcedureStateChangeEvent(self):
        return self._ProcedureStateChangeEvent

    @ProcedureStateChangeEvent.setter
    def ProcedureStateChangeEvent(self, ProcedureStateChangeEvent):
        self._ProcedureStateChangeEvent = ProcedureStateChangeEvent

    @property
    def FileDeleteEvent(self):
        return self._FileDeleteEvent

    @FileDeleteEvent.setter
    def FileDeleteEvent(self, FileDeleteEvent):
        self._FileDeleteEvent = FileDeleteEvent

    @property
    def PullCompleteEvent(self):
        return self._PullCompleteEvent

    @PullCompleteEvent.setter
    def PullCompleteEvent(self, PullCompleteEvent):
        self._PullCompleteEvent = PullCompleteEvent

    @property
    def EditMediaCompleteEvent(self):
        return self._EditMediaCompleteEvent

    @EditMediaCompleteEvent.setter
    def EditMediaCompleteEvent(self, EditMediaCompleteEvent):
        self._EditMediaCompleteEvent = EditMediaCompleteEvent

    @property
    def SplitMediaCompleteEvent(self):
        return self._SplitMediaCompleteEvent

    @SplitMediaCompleteEvent.setter
    def SplitMediaCompleteEvent(self, SplitMediaCompleteEvent):
        self._SplitMediaCompleteEvent = SplitMediaCompleteEvent

    @property
    def ComposeMediaCompleteEvent(self):
        return self._ComposeMediaCompleteEvent

    @ComposeMediaCompleteEvent.setter
    def ComposeMediaCompleteEvent(self, ComposeMediaCompleteEvent):
        self._ComposeMediaCompleteEvent = ComposeMediaCompleteEvent

    @property
    def ClipCompleteEvent(self):
        return self._ClipCompleteEvent

    @ClipCompleteEvent.setter
    def ClipCompleteEvent(self, ClipCompleteEvent):
        self._ClipCompleteEvent = ClipCompleteEvent

    @property
    def TranscodeCompleteEvent(self):
        return self._TranscodeCompleteEvent

    @TranscodeCompleteEvent.setter
    def TranscodeCompleteEvent(self, TranscodeCompleteEvent):
        self._TranscodeCompleteEvent = TranscodeCompleteEvent

    @property
    def CreateImageSpriteCompleteEvent(self):
        return self._CreateImageSpriteCompleteEvent

    @CreateImageSpriteCompleteEvent.setter
    def CreateImageSpriteCompleteEvent(self, CreateImageSpriteCompleteEvent):
        self._CreateImageSpriteCompleteEvent = CreateImageSpriteCompleteEvent

    @property
    def ConcatCompleteEvent(self):
        return self._ConcatCompleteEvent

    @ConcatCompleteEvent.setter
    def ConcatCompleteEvent(self, ConcatCompleteEvent):
        self._ConcatCompleteEvent = ConcatCompleteEvent

    @property
    def SnapshotByTimeOffsetCompleteEvent(self):
        return self._SnapshotByTimeOffsetCompleteEvent

    @SnapshotByTimeOffsetCompleteEvent.setter
    def SnapshotByTimeOffsetCompleteEvent(self, SnapshotByTimeOffsetCompleteEvent):
        self._SnapshotByTimeOffsetCompleteEvent = SnapshotByTimeOffsetCompleteEvent

    @property
    def WechatPublishCompleteEvent(self):
        return self._WechatPublishCompleteEvent

    @WechatPublishCompleteEvent.setter
    def WechatPublishCompleteEvent(self, WechatPublishCompleteEvent):
        self._WechatPublishCompleteEvent = WechatPublishCompleteEvent

    @property
    def WechatMiniProgramPublishCompleteEvent(self):
        return self._WechatMiniProgramPublishCompleteEvent

    @WechatMiniProgramPublishCompleteEvent.setter
    def WechatMiniProgramPublishCompleteEvent(self, WechatMiniProgramPublishCompleteEvent):
        self._WechatMiniProgramPublishCompleteEvent = WechatMiniProgramPublishCompleteEvent

    @property
    def RemoveWatermarkCompleteEvent(self):
        return self._RemoveWatermarkCompleteEvent

    @RemoveWatermarkCompleteEvent.setter
    def RemoveWatermarkCompleteEvent(self, RemoveWatermarkCompleteEvent):
        self._RemoveWatermarkCompleteEvent = RemoveWatermarkCompleteEvent

    @property
    def RestoreMediaCompleteEvent(self):
        return self._RestoreMediaCompleteEvent

    @RestoreMediaCompleteEvent.setter
    def RestoreMediaCompleteEvent(self, RestoreMediaCompleteEvent):
        self._RestoreMediaCompleteEvent = RestoreMediaCompleteEvent

    @property
    def RebuildMediaCompleteEvent(self):
        return self._RebuildMediaCompleteEvent

    @RebuildMediaCompleteEvent.setter
    def RebuildMediaCompleteEvent(self, RebuildMediaCompleteEvent):
        self._RebuildMediaCompleteEvent = RebuildMediaCompleteEvent

    @property
    def ExtractTraceWatermarkCompleteEvent(self):
        return self._ExtractTraceWatermarkCompleteEvent

    @ExtractTraceWatermarkCompleteEvent.setter
    def ExtractTraceWatermarkCompleteEvent(self, ExtractTraceWatermarkCompleteEvent):
        self._ExtractTraceWatermarkCompleteEvent = ExtractTraceWatermarkCompleteEvent

    @property
    def ExtractCopyRightWatermarkCompleteEvent(self):
        return self._ExtractCopyRightWatermarkCompleteEvent

    @ExtractCopyRightWatermarkCompleteEvent.setter
    def ExtractCopyRightWatermarkCompleteEvent(self, ExtractCopyRightWatermarkCompleteEvent):
        self._ExtractCopyRightWatermarkCompleteEvent = ExtractCopyRightWatermarkCompleteEvent

    @property
    def ReviewAudioVideoCompleteEvent(self):
        return self._ReviewAudioVideoCompleteEvent

    @ReviewAudioVideoCompleteEvent.setter
    def ReviewAudioVideoCompleteEvent(self, ReviewAudioVideoCompleteEvent):
        self._ReviewAudioVideoCompleteEvent = ReviewAudioVideoCompleteEvent

    @property
    def ReduceMediaBitrateCompleteEvent(self):
        return self._ReduceMediaBitrateCompleteEvent

    @ReduceMediaBitrateCompleteEvent.setter
    def ReduceMediaBitrateCompleteEvent(self, ReduceMediaBitrateCompleteEvent):
        self._ReduceMediaBitrateCompleteEvent = ReduceMediaBitrateCompleteEvent

    @property
    def DescribeFileAttributesCompleteEvent(self):
        return self._DescribeFileAttributesCompleteEvent

    @DescribeFileAttributesCompleteEvent.setter
    def DescribeFileAttributesCompleteEvent(self, DescribeFileAttributesCompleteEvent):
        self._DescribeFileAttributesCompleteEvent = DescribeFileAttributesCompleteEvent

    @property
    def QualityInspectCompleteEvent(self):
        return self._QualityInspectCompleteEvent

    @QualityInspectCompleteEvent.setter
    def QualityInspectCompleteEvent(self, QualityInspectCompleteEvent):
        self._QualityInspectCompleteEvent = QualityInspectCompleteEvent

    @property
    def QualityEnhanceCompleteEvent(self):
        return self._QualityEnhanceCompleteEvent

    @QualityEnhanceCompleteEvent.setter
    def QualityEnhanceCompleteEvent(self, QualityEnhanceCompleteEvent):
        self._QualityEnhanceCompleteEvent = QualityEnhanceCompleteEvent


    def _deserialize(self, params):
        self._EventHandle = params.get("EventHandle")
        self._EventType = params.get("EventType")
        if params.get("FileUploadEvent") is not None:
            self._FileUploadEvent = FileUploadTask()
            self._FileUploadEvent._deserialize(params.get("FileUploadEvent"))
        if params.get("ProcedureStateChangeEvent") is not None:
            self._ProcedureStateChangeEvent = ProcedureTask()
            self._ProcedureStateChangeEvent._deserialize(params.get("ProcedureStateChangeEvent"))
        if params.get("FileDeleteEvent") is not None:
            self._FileDeleteEvent = FileDeleteTask()
            self._FileDeleteEvent._deserialize(params.get("FileDeleteEvent"))
        if params.get("PullCompleteEvent") is not None:
            self._PullCompleteEvent = PullUploadTask()
            self._PullCompleteEvent._deserialize(params.get("PullCompleteEvent"))
        if params.get("EditMediaCompleteEvent") is not None:
            self._EditMediaCompleteEvent = EditMediaTask()
            self._EditMediaCompleteEvent._deserialize(params.get("EditMediaCompleteEvent"))
        if params.get("SplitMediaCompleteEvent") is not None:
            self._SplitMediaCompleteEvent = SplitMediaTask()
            self._SplitMediaCompleteEvent._deserialize(params.get("SplitMediaCompleteEvent"))
        if params.get("ComposeMediaCompleteEvent") is not None:
            self._ComposeMediaCompleteEvent = ComposeMediaTask()
            self._ComposeMediaCompleteEvent._deserialize(params.get("ComposeMediaCompleteEvent"))
        if params.get("ClipCompleteEvent") is not None:
            self._ClipCompleteEvent = ClipTask2017()
            self._ClipCompleteEvent._deserialize(params.get("ClipCompleteEvent"))
        if params.get("TranscodeCompleteEvent") is not None:
            self._TranscodeCompleteEvent = TranscodeTask2017()
            self._TranscodeCompleteEvent._deserialize(params.get("TranscodeCompleteEvent"))
        if params.get("CreateImageSpriteCompleteEvent") is not None:
            self._CreateImageSpriteCompleteEvent = CreateImageSpriteTask2017()
            self._CreateImageSpriteCompleteEvent._deserialize(params.get("CreateImageSpriteCompleteEvent"))
        if params.get("ConcatCompleteEvent") is not None:
            self._ConcatCompleteEvent = ConcatTask2017()
            self._ConcatCompleteEvent._deserialize(params.get("ConcatCompleteEvent"))
        if params.get("SnapshotByTimeOffsetCompleteEvent") is not None:
            self._SnapshotByTimeOffsetCompleteEvent = SnapshotByTimeOffsetTask2017()
            self._SnapshotByTimeOffsetCompleteEvent._deserialize(params.get("SnapshotByTimeOffsetCompleteEvent"))
        if params.get("WechatPublishCompleteEvent") is not None:
            self._WechatPublishCompleteEvent = WechatPublishTask()
            self._WechatPublishCompleteEvent._deserialize(params.get("WechatPublishCompleteEvent"))
        if params.get("WechatMiniProgramPublishCompleteEvent") is not None:
            self._WechatMiniProgramPublishCompleteEvent = WechatMiniProgramPublishTask()
            self._WechatMiniProgramPublishCompleteEvent._deserialize(params.get("WechatMiniProgramPublishCompleteEvent"))
        if params.get("RemoveWatermarkCompleteEvent") is not None:
            self._RemoveWatermarkCompleteEvent = RemoveWatermarkTask()
            self._RemoveWatermarkCompleteEvent._deserialize(params.get("RemoveWatermarkCompleteEvent"))
        if params.get("RestoreMediaCompleteEvent") is not None:
            self._RestoreMediaCompleteEvent = RestoreMediaTask()
            self._RestoreMediaCompleteEvent._deserialize(params.get("RestoreMediaCompleteEvent"))
        if params.get("RebuildMediaCompleteEvent") is not None:
            self._RebuildMediaCompleteEvent = RebuildMediaTask()
            self._RebuildMediaCompleteEvent._deserialize(params.get("RebuildMediaCompleteEvent"))
        if params.get("ExtractTraceWatermarkCompleteEvent") is not None:
            self._ExtractTraceWatermarkCompleteEvent = ExtractTraceWatermarkTask()
            self._ExtractTraceWatermarkCompleteEvent._deserialize(params.get("ExtractTraceWatermarkCompleteEvent"))
        if params.get("ExtractCopyRightWatermarkCompleteEvent") is not None:
            self._ExtractCopyRightWatermarkCompleteEvent = ExtractCopyRightWatermarkTask()
            self._ExtractCopyRightWatermarkCompleteEvent._deserialize(params.get("ExtractCopyRightWatermarkCompleteEvent"))
        if params.get("ReviewAudioVideoCompleteEvent") is not None:
            self._ReviewAudioVideoCompleteEvent = ReviewAudioVideoTask()
            self._ReviewAudioVideoCompleteEvent._deserialize(params.get("ReviewAudioVideoCompleteEvent"))
        if params.get("ReduceMediaBitrateCompleteEvent") is not None:
            self._ReduceMediaBitrateCompleteEvent = ReduceMediaBitrateTask()
            self._ReduceMediaBitrateCompleteEvent._deserialize(params.get("ReduceMediaBitrateCompleteEvent"))
        if params.get("DescribeFileAttributesCompleteEvent") is not None:
            self._DescribeFileAttributesCompleteEvent = DescribeFileAttributesTask()
            self._DescribeFileAttributesCompleteEvent._deserialize(params.get("DescribeFileAttributesCompleteEvent"))
        if params.get("QualityInspectCompleteEvent") is not None:
            self._QualityInspectCompleteEvent = QualityInspectTask()
            self._QualityInspectCompleteEvent._deserialize(params.get("QualityInspectCompleteEvent"))
        if params.get("QualityEnhanceCompleteEvent") is not None:
            self._QualityEnhanceCompleteEvent = QualityEnhanceTask()
            self._QualityEnhanceCompleteEvent._deserialize(params.get("QualityEnhanceCompleteEvent"))
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionRequest(AbstractModel):
    """ExecuteFunction request structure.

    """

    def __init__(self):
        r"""
        :param _FunctionName: Name of called backend API.
        :type FunctionName: str
        :param _FunctionArg: API parameter. For specific parameter format, negotiate with the backend before calling.
        :type FunctionArg: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _SessionContext: The source context which is used to pass through the user request information. The task flow status change callback will return the value of this field. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _SessionId: The ID used for deduplication. If there was a request with the same ID in the last seven days, the current request will return an error. The ID can contain up to 50 characters. If this parameter is left empty or a blank string is entered, no deduplication will be performed.
        :type SessionId: str
        :param _ExtInfo: Reserved field for special purposes.
        :type ExtInfo: str
        """
        self._FunctionName = None
        self._FunctionArg = None
        self._SubAppId = None
        self._SessionContext = None
        self._SessionId = None
        self._ExtInfo = None

    @property
    def FunctionName(self):
        return self._FunctionName

    @FunctionName.setter
    def FunctionName(self, FunctionName):
        self._FunctionName = FunctionName

    @property
    def FunctionArg(self):
        return self._FunctionArg

    @FunctionArg.setter
    def FunctionArg(self, FunctionArg):
        self._FunctionArg = FunctionArg

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._FunctionName = params.get("FunctionName")
        self._FunctionArg = params.get("FunctionArg")
        self._SubAppId = params.get("SubAppId")
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExecuteFunctionResponse(AbstractModel):
    """ExecuteFunction response structure.

    """

    def __init__(self):
        r"""
        :param _Result: String generated by packaging processing result. For specifications, negotiate with the backend.
Note: this field may return null, indicating that no valid values can be obtained.
        :type Result: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._Result = None
        self._RequestId = None

    @property
    def Result(self):
        return self._Result

    @Result.setter
    def Result(self, Result):
        self._Result = Result

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._Result = params.get("Result")
        self._RequestId = params.get("RequestId")


class ExtractCopyRightWatermarkRequest(AbstractModel):
    """ExtractCopyRightWatermark request structure.

    """

    def __init__(self):
        r"""
        :param _Url: The media URL from which the watermark needs to be extracted.
        :type Url: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _SessionContext: Identifies the source context, which is used to transparently transmit user request information. This field value will be returned in the ExtractCopyRightWatermarkComplete callback and task flow status change callback, with a maximum length of 1000 characters.
        :type SessionContext: str
        :param _SessionId: The identification code used for task deduplication. If there is a request with the same identification code within three days, this request will return an error. The maximum length is 50 characters, without or with an empty string to indicate no deduplication.
        :type SessionId: str
        :param _TasksPriority: The priority of the task. The larger the value, the higher the priority. The value range is -10 to 10. If left blank, it means 0.
        :type TasksPriority: int
        :param _ExtInfo: Reserved fields, used for special purposes.
        :type ExtInfo: str
        """
        self._Url = None
        self._SubAppId = None
        self._SessionContext = None
        self._SessionId = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._SubAppId = params.get("SubAppId")
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractCopyRightWatermarkResponse(AbstractModel):
    """ExtractCopyRightWatermark response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExtractCopyRightWatermarkTask(AbstractModel):
    """Extract copyright watermark

    """

    def __init__(self):
        r"""
        :param _TaskId: Task ID.
        :type TaskId: str
        :param _Status: Task status, values:
<li>PROCESSING: Processing;</li>
<li>FINISH: Completed. </li>
        :type Status: str
        :param _ErrCode: Error code, 0 means success, other values u200bu200bmean failure:
<li>40000: The input parameters are illegal, please check the input parameters;</li>
<li>60000: Source file error (such as video data damage), Please confirm whether the source file is normal;</li>
<li>70000: Internal service error, it is recommended to try again. </li>
        :type ErrCode: int
        :param _Message: Error message.
        :type Message: str
        :param _ErrCodeExt: Error code. An empty string indicates success. Other values u200bu200bindicate failure. For values, please refer to [Video Processing Error Code](https://www.tencentcloud.com/document/product/266/39145) list.
        :type ErrCodeExt: str
        :param _Input: Extract copyright watermark task input information.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Input: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTaskInput`
        :param _Output: Extract copyright watermark task output information.
Note: This field may return null, indicating that no valid value can be obtained.
        :type Output: :class:`tencentcloud.vod.v20180717.models.ExtractCopyRightWatermarkTaskOutput`
        :param _SessionId: Identification code used for deduplication. If there is a request for the same identification code within seven days, this request will return an error. The maximum length is 50 characters, without or with an empty string to indicate no deduplication.
        :type SessionId: str
        :param _SessionContext: Source context, used to transparently transmit user request information. The task flow status change callback will return the value of this field, which can be up to 1000 characters.
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._ErrCodeExt = None
        self._Input = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._ErrCodeExt = params.get("ErrCodeExt")
        if params.get("Input") is not None:
            self._Input = ExtractCopyRightWatermarkTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ExtractCopyRightWatermarkTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractCopyRightWatermarkTaskInput(AbstractModel):
    """Extract copyright watermark task input

    """

    def __init__(self):
        r"""
        :param _Url: The media URL from which the watermark needs to be extracted.
        :type Url: str
        """
        self._Url = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url


    def _deserialize(self, params):
        self._Url = params.get("Url")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractCopyRightWatermarkTaskOutput(AbstractModel):
    """Extract copyright watermark output information

    """

    def __init__(self):
        r"""
        :param _Text: Copyright information
        :type Text: str
        """
        self._Text = None

    @property
    def Text(self):
        return self._Text

    @Text.setter
    def Text(self, Text):
        self._Text = Text


    def _deserialize(self, params):
        self._Text = params.get("Text")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractTraceWatermarkRequest(AbstractModel):
    """ExtractTraceWatermark request structure.

    """

    def __init__(self):
        r"""
        :param _Url: The URL of the media on which digital watermark extraction is to be performed.
        :type Url: str
        :param _FileId: The ID of the file specified by `Url`.
<li><font color=red>Note</font>: This parameter is required.</li>
        :type FileId: str
        :param _SubAppId: <b>The VOD [application](https://intl.cloud.tencent.com/document/product/266/14574) ID. For customers who activate VOD service from December 25, 2023, if they want to access resources in a VOD application (whether it's the default application or a newly created one), they must fill in this field with the application ID.</b>
        :type SubAppId: int
        :param _SessionContext: The source context, which is used to pass through user request information. The `ExtractTraceWatermarkComplete` callback and the `ProcedureStateChanged` callback will return the value of this parameter. It can contain up to 1,000 characters.
        :type SessionContext: str
        :param _SessionId: The session ID, which is used for de-duplication. If there was a request with the same session ID in the last three days, an error will be returned for the current request. The session ID can contain up to 50 characters. If you do not pass this parameter or pass in an empty string, duplicate sessions will not be identified.
        :type SessionId: str
        :param _TasksPriority: The task priority, which can be a value from -10 to 10. The higher the value, the higher the priority. If this parameter is left empty, 0 will be used.
        :type TasksPriority: int
        :param _ExtInfo: A reserved parameter.
        :type ExtInfo: str
        """
        self._Url = None
        self._FileId = None
        self._SubAppId = None
        self._SessionContext = None
        self._SessionId = None
        self._TasksPriority = None
        self._ExtInfo = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def SubAppId(self):
        return self._SubAppId

    @SubAppId.setter
    def SubAppId(self, SubAppId):
        self._SubAppId = SubAppId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def TasksPriority(self):
        return self._TasksPriority

    @TasksPriority.setter
    def TasksPriority(self, TasksPriority):
        self._TasksPriority = TasksPriority

    @property
    def ExtInfo(self):
        return self._ExtInfo

    @ExtInfo.setter
    def ExtInfo(self, ExtInfo):
        self._ExtInfo = ExtInfo


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._FileId = params.get("FileId")
        self._SubAppId = params.get("SubAppId")
        self._SessionContext = params.get("SessionContext")
        self._SessionId = params.get("SessionId")
        self._TasksPriority = params.get("TasksPriority")
        self._ExtInfo = params.get("ExtInfo")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractTraceWatermarkResponse(AbstractModel):
    """ExtractTraceWatermark response structure.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID.
        :type TaskId: str
        :param _RequestId: The unique request ID, which is returned for each request. RequestId is required for locating a problem.
        :type RequestId: str
        """
        self._TaskId = None
        self._RequestId = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def RequestId(self):
        return self._RequestId

    @RequestId.setter
    def RequestId(self, RequestId):
        self._RequestId = RequestId


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._RequestId = params.get("RequestId")


class ExtractTraceWatermarkTask(AbstractModel):
    """A digital watermark extraction task.

    """

    def __init__(self):
        r"""
        :param _TaskId: The task ID.
        :type TaskId: str
        :param _Status: The task status. Valid values:
<li>PROCESSING</li>
<li>FINISH</li>
        :type Status: str
        :param _ErrCode: The error code. `0` indicates the task is successful. Other values indicate that the task failed.
<li>40000: Invalid input parameter.</li>
<li>60000: Source file error (e.g., video data is corrupted).</li>
<li>70000: Internal server error. Please try again.</li>
        :type ErrCode: int
        :param _Message: The error message.
        :type Message: str
        :param _ErrCodeExt: The error code. An empty string indicates the task is successful; other values indicate that the task failed. For details, see [Video processing error codes](https://intl.cloud.tencent.com/document/product/266/39145?lang=en&pg=#video-processing).
        :type ErrCodeExt: str
        :param _Input: The information of a digital watermark extraction task.
        :type Input: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTaskInput`
        :param _Output: The output of a digital watermark extraction task.
        :type Output: :class:`tencentcloud.vod.v20180717.models.ExtractTraceWatermarkTaskOutput`
        :param _SessionId: The session ID, which is used for de-duplication. If there was a request with the same session ID in the last seven days, an error will be returned for the current request. The session ID can contain up to 50 characters. If you do not pass this parameter or pass in an empty string, duplicate sessions will not be identified.
        :type SessionId: str
        :param _SessionContext: The source context, which is used to pass through user request information. The `ProcedureStateChanged` callback will return the value of this parameter. It can contain up to 1,000 characters.
        :type SessionContext: str
        """
        self._TaskId = None
        self._Status = None
        self._ErrCode = None
        self._Message = None
        self._ErrCodeExt = None
        self._Input = None
        self._Output = None
        self._SessionId = None
        self._SessionContext = None

    @property
    def TaskId(self):
        return self._TaskId

    @TaskId.setter
    def TaskId(self, TaskId):
        self._TaskId = TaskId

    @property
    def Status(self):
        return self._Status

    @Status.setter
    def Status(self, Status):
        self._Status = Status

    @property
    def ErrCode(self):
        return self._ErrCode

    @ErrCode.setter
    def ErrCode(self, ErrCode):
        self._ErrCode = ErrCode

    @property
    def Message(self):
        return self._Message

    @Message.setter
    def Message(self, Message):
        self._Message = Message

    @property
    def ErrCodeExt(self):
        return self._ErrCodeExt

    @ErrCodeExt.setter
    def ErrCodeExt(self, ErrCodeExt):
        self._ErrCodeExt = ErrCodeExt

    @property
    def Input(self):
        return self._Input

    @Input.setter
    def Input(self, Input):
        self._Input = Input

    @property
    def Output(self):
        return self._Output

    @Output.setter
    def Output(self, Output):
        self._Output = Output

    @property
    def SessionId(self):
        return self._SessionId

    @SessionId.setter
    def SessionId(self, SessionId):
        self._SessionId = SessionId

    @property
    def SessionContext(self):
        return self._SessionContext

    @SessionContext.setter
    def SessionContext(self, SessionContext):
        self._SessionContext = SessionContext


    def _deserialize(self, params):
        self._TaskId = params.get("TaskId")
        self._Status = params.get("Status")
        self._ErrCode = params.get("ErrCode")
        self._Message = params.get("Message")
        self._ErrCodeExt = params.get("ErrCodeExt")
        if params.get("Input") is not None:
            self._Input = ExtractTraceWatermarkTaskInput()
            self._Input._deserialize(params.get("Input"))
        if params.get("Output") is not None:
            self._Output = ExtractTraceWatermarkTaskOutput()
            self._Output._deserialize(params.get("Output"))
        self._SessionId = params.get("SessionId")
        self._SessionContext = params.get("SessionContext")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractTraceWatermarkTaskInput(AbstractModel):
    """The input of digital watermark extraction.

    """

    def __init__(self):
        r"""
        :param _Url: The URL of the media on which digital watermark extraction is to be performed.
        :type Url: str
        :param _FileId: Media file ID. The original media file ID corresponding to the URL.
        :type FileId: str
        """
        self._Url = None
        self._FileId = None

    @property
    def Url(self):
        return self._Url

    @Url.setter
    def Url(self, Url):
        self._Url = Url

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId


    def _deserialize(self, params):
        self._Url = params.get("Url")
        self._FileId = params.get("FileId")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class ExtractTraceWatermarkTaskOutput(AbstractModel):
    """The output of digital watermark extraction.

    """

    def __init__(self):
        r"""
        :param _Uv: The distributor’s user ID, which is a six-digit hex number. This parameter is relevant when [digital watermarks](https://intl.cloud.tencent.com/document/product/266/75789?from_cn_redirect=1) are used.
        :type Uv: str
        :param _Uid: This parameter has been deprecated.
        :type Uid: str
        """
        self._Uv = None
        self._Uid = None

    @property
    def Uv(self):
        return self._Uv

    @Uv.setter
    def Uv(self, Uv):
        self._Uv = Uv

    @property
    def Uid(self):
        return self._Uid

    @Uid.setter
    def Uid(self, Uid):
        self._Uid = Uid


    def _deserialize(self, params):
        self._Uv = params.get("Uv")
        self._Uid = params.get("Uid")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceConfigureInfo(AbstractModel):
    """Control parameter of face recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of face recognition task. Valid values:
<li>ON: enables intelligent face recognition task;</li>
<li>OFF: disables intelligent face recognition task.</li>
        :type Switch: str
        :param _Score: Face recognition filter score. If this score is reached or exceeded, a recognition result will be returned. Value range: 0–100. Default value: 95.
        :type Score: float
        :param _DefaultLibraryLabelSet: Default face filter labels, which specify the types of faces to return. If this parameter is left empty, the recognition results for all labels are returned. Valid values:
<li>`entertainment`: people in the entertainment industry</li>
<li>`sport`: sports celebrities</li>
<li>`politician`: politically sensitive people</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: Custom face labels for filtering. After you specify a label, callbacks of face images without this label will be returned. If this parameter is not specified or left empty, callbacks of all face images will be returned.
You can specify up to 100 labels, with each containing up to 16 characters.
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: Figure library. Valid values:
<li>Default: default figure library;</li>
<li>UserDefine: custom figure library.</li>
<li>All: both default and custom figure libraries will be used.</li>
Default value: All (both default and custom figure libraries will be used.)
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceConfigureInfoForUpdate(AbstractModel):
    """Control parameter of face recognition task

    """

    def __init__(self):
        r"""
        :param _Switch: Switch of face recognition task. Valid values:
<li>ON: enables intelligent face recognition task;</li>
<li>OFF: disables intelligent face recognition task.</li>
        :type Switch: str
        :param _Score: Face recognition filter score. If this score is reached or exceeded, a recognition result will be returned. Value range: 0–100.
        :type Score: float
        :param _DefaultLibraryLabelSet: Default face filter labels, which specify the types of faces to return. If this parameter is left empty or an empty value is entered, the recognition results for all labels are returned. Valid values:
<li>`entertainment`: people in the entertainment industry</li>
<li>`sport`: sports celebrities</li>
<li>`politician`: politically sensitive people</li>
        :type DefaultLibraryLabelSet: list of str
        :param _UserDefineLibraryLabelSet: Custom face labels for filtering. After you specify a label, callbacks of face images without this label will be returned. If this parameter is not specified or left empty, callbacks of all face images will be returned.
You can specify up to 100 labels, with each containing up to 16 characters.
        :type UserDefineLibraryLabelSet: list of str
        :param _FaceLibrary: Figure library. Valid values:
<li>Default: default figure library;</li>
<li>UserDefine: custom figure library.</li>
<li>All: both default and custom figure libraries will be used.</li>
        :type FaceLibrary: str
        """
        self._Switch = None
        self._Score = None
        self._DefaultLibraryLabelSet = None
        self._UserDefineLibraryLabelSet = None
        self._FaceLibrary = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Score(self):
        return self._Score

    @Score.setter
    def Score(self, Score):
        self._Score = Score

    @property
    def DefaultLibraryLabelSet(self):
        return self._DefaultLibraryLabelSet

    @DefaultLibraryLabelSet.setter
    def DefaultLibraryLabelSet(self, DefaultLibraryLabelSet):
        self._DefaultLibraryLabelSet = DefaultLibraryLabelSet

    @property
    def UserDefineLibraryLabelSet(self):
        return self._UserDefineLibraryLabelSet

    @UserDefineLibraryLabelSet.setter
    def UserDefineLibraryLabelSet(self, UserDefineLibraryLabelSet):
        self._UserDefineLibraryLabelSet = UserDefineLibraryLabelSet

    @property
    def FaceLibrary(self):
        return self._FaceLibrary

    @FaceLibrary.setter
    def FaceLibrary(self, FaceLibrary):
        self._FaceLibrary = FaceLibrary


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Score = params.get("Score")
        self._DefaultLibraryLabelSet = params.get("DefaultLibraryLabelSet")
        self._UserDefineLibraryLabelSet = params.get("UserDefineLibraryLabelSet")
        self._FaceLibrary = params.get("FaceLibrary")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FaceEnhanceInfo(AbstractModel):
    """Face enhancement configuration.

    """

    def __init__(self):
        r"""
        :param _Switch: Whether to enable face enhancement. Valid values:
<li>`ON`</li>
<li>`OFF`</li>
        :type Switch: str
        :param _Intensity: The face enhancement strength. This parameter is valid only if `Switch` is `ON`. Value range: 0.0 – 1.0.
Default value: `0.0`.
        :type Intensity: float
        """
        self._Switch = None
        self._Intensity = None

    @property
    def Switch(self):
        return self._Switch

    @Switch.setter
    def Switch(self, Switch):
        self._Switch = Switch

    @property
    def Intensity(self):
        return self._Intensity

    @Intensity.setter
    def Intensity(self, Intensity):
        self._Intensity = Intensity


    def _deserialize(self, params):
        self._Switch = params.get("Switch")
        self._Intensity = params.get("Intensity")
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileDeleteResultItem(AbstractModel):
    """The result of file deletion.

    """

    def __init__(self):
        r"""
        :param _FileId: The ID of the file deleted.
        :type FileId: str
        :param _DeleteParts: The type of the file deleted.
Note: This field may return `null`, indicating that no valid value can be obtained.
        :type DeleteParts: list of MediaDeleteItem
        """
        self._FileId = None
        self._DeleteParts = None

    @property
    def FileId(self):
        return self._FileId

    @FileId.setter
    def FileId(self, FileId):
        self._FileId = FileId

    @property
    def DeleteParts(self):
        return self._DeleteParts

    @DeleteParts.setter
    def DeleteParts(self, DeleteParts):
        self._DeleteParts = DeleteParts


    def _deserialize(self, params):
        self._FileId = params.get("FileId")
        if params.get("DeleteParts") is not None:
            self._DeleteParts = []
            for item in params.get("DeleteParts"):
                obj = MediaDeleteItem()
                obj._deserialize(item)
                self._DeleteParts.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
            property_name = name[1:]
            if property_name in memeber_set:
                memeber_set.remove(property_name)
        if len(memeber_set) > 0:
            warnings.warn("%s fileds are useless." % ",".join(memeber_set))
        


class FileDeleteTask(AbstractModel):
    """File deleting task

    """

    def __init__(self):
        r"""
        :param _FileIdSet: List of IDs of deleted files.
        :type FileIdSet: list of str
        :param _FileDeleteResultInfo: The information of the files deleted.
        :type FileDeleteResultInfo: list of FileDeleteResultItem
        """
        self._FileIdSet = None
        self._FileDeleteResultInfo = None

    @property
    def FileIdSet(self):
        return self._FileIdSet

    @FileIdSet.setter
    def FileIdSet(self, FileIdSet):
        self._FileIdSet = FileIdSet

    @property
    def FileDeleteResultInfo(self):
        return self._FileDeleteResultInfo

    @FileDeleteResultInfo.setter
    def FileDeleteResultInfo(self, FileDeleteResultInfo):
        self._FileDeleteResultInfo = FileDeleteResultInfo


    def _deserialize(self, params):
        self._FileIdSet = params.get("FileIdSet")
        if params.get("FileDeleteResultInfo") is not None:
            self._FileDeleteResultInfo = []
            for item in params.get("FileDeleteResultInfo"):
                obj = FileDeleteResultItem()
                obj._deserialize(item)
                self._FileDeleteResultInfo.append(obj)
        memeber_set = set(params.keys())
        for name, value in vars(self).items():
     