# Generated by Django 4.1.8 on 2023-04-19 05:48

import datetime
import uuid

import django.contrib.postgres.fields
import django.contrib.postgres.fields.ranges
import django.contrib.postgres.operations
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_fsm
import wbcore.contrib.directory.models.entries
import wbcore.contrib.icons.models
import wbcore.models.fields
import wbcore.utils.models
import wbcrm.models.activities
from django.db import migrations, models

# Functions from the following migrations need manual copying.
# Move them and any dependencies into this file, then update the


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("directory", "0001_initial"),
        ("directory", "0002_auto_20230414_1553"),
        ("authentication", "0003_alter_user_profile"),
        ("geography", "0001_initial"),
        ("agenda", "0002_initial"),
        ("currency", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Entry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("entry_type", models.CharField(max_length=255)),
                ("additional_fields", models.JSONField(blank=True, default=dict, null=True)),
                (
                    "rating",
                    models.IntegerField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(5),
                        ],
                    ),
                ),
                ("search_name", models.CharField(blank=True, max_length=512, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="EntryStatus",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
            ],
            options={
                "verbose_name_plural": "Entry Status",
                "verbose_name": "Entry Status",
                "ordering": ("title",),
            },
        ),
        migrations.CreateModel(
            name="PersonPrefix",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=10)),
            ],
            options={
                "verbose_name_plural": "Person Prefixes",
                "verbose_name": "Person Prefix",
                "ordering": ("title",),
            },
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("text", models.CharField(max_length=255, unique=True)),
            ],
            options={
                "verbose_name_plural": "Tags",
                "verbose_name": "Tag",
                "ordering": ("text",),
            },
        ),
        migrations.CreateModel(
            name="Company",
            fields=[
                (
                    "entry_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbcrm.entry",
                    ),
                ),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("ASSET_MANAGER", "Asset Manager"),
                            ("BANK", "Bank"),
                            ("COMPANY", "Company"),
                            ("CONSULTANT", "Consultant"),
                            ("FAMILY_OFFICE", "Family Office"),
                            ("FOUNDATION", "Foundation"),
                            ("INDEPENDANT_WEALTH_MANAGER", "Independant Wealth Manager"),
                            ("INSURANCE", "Insurance"),
                            ("PENSION_FUND", "Pension Fund"),
                            ("PRIVATE_CUSTOMER", "Private Customer"),
                            ("SERVICE_PROVIDER", "Service Provider"),
                            ("UNVERSITY", "University"),
                            ("OTHER", "Other"),
                        ],
                        default="COMPANY",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
                ("asset_allocation", models.CharField(default="", max_length=255, verbose_name="Asset Allocation")),
                ("assets_under_management", models.CharField(default="", max_length=255, verbose_name="AUM")),
                ("discretionairy_advisory", models.FloatField(default=0.0, verbose_name="Discretionairy Advisory")),
                ("geographic_focus", models.CharField(default="", max_length=255, verbose_name="Geographic Focus")),
                ("headcount", models.CharField(default="", max_length=32, verbose_name="Number of employees")),
                (
                    "tiering",
                    models.CharField(
                        choices=[("ONE", "1"), ("TWO", "2"), ("THREE", "3"), ("FOUR", "4")],
                        default="ONE",
                        max_length=16,
                        verbose_name="Tiering",
                    ),
                ),
                ("description", models.TextField(default="", verbose_name="Description")),
            ],
            options={
                "verbose_name_plural": "Companies",
                "verbose_name": "Company",
            },
            bases=("wbcrm.entry",),
        ),
        migrations.CreateModel(
            name="Person",
            fields=[
                (
                    "entry_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wbcrm.entry",
                    ),
                ),
                ("first_name", models.CharField(max_length=255, verbose_name="First Name")),
                ("last_name", models.CharField(max_length=255, verbose_name="First Name")),
                (
                    "position",
                    models.CharField(blank=True, default="", max_length=255, null=True, verbose_name="Position"),
                ),
                ("birthday", models.DateField(blank=True, null=True, verbose_name="Birthday")),
                (
                    "personality_profile_red",
                    models.FloatField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(1),
                        ],
                        verbose_name="Personality Profile: Red",
                    ),
                ),
                (
                    "personality_profile_green",
                    models.FloatField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(1),
                        ],
                        verbose_name="Personality Profile: Green",
                    ),
                ),
                (
                    "personality_profile_blue",
                    models.FloatField(
                        default=0,
                        validators=[
                            django.core.validators.MinValueValidator(0),
                            django.core.validators.MaxValueValidator(1),
                        ],
                        verbose_name="Personality Profile: Blue",
                    ),
                ),
                (
                    "prefix",
                    models.CharField(
                        choices=[
                            ("MR", "Mr."),
                            ("MRS", "Mrs."),
                            ("MS", "Ms."),
                            ("PROF", "Prof."),
                            ("DR", "Dr."),
                            ("MED", "Med."),
                            ("ME", "Me."),
                        ],
                        default="MR",
                        max_length=4,
                        verbose_name="Prefix",
                    ),
                ),
                ("active_employee", models.BooleanField(default=True, verbose_name="Available Employee")),
                ("formal", models.BooleanField(default=True, verbose_name="Format")),
                (
                    "employers",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The person's employers",
                        related_name="employees",
                        to="wbcrm.company",
                        verbose_name="Companies/Employers",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Persons",
                "verbose_name": "Person",
            },
            bases=("wbcrm.entry",),
        ),
        migrations.AddField(
            model_name="entry",
            name="status",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.SET_NULL, related_name="entries", to="wbcrm.entrystatus"
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="entries", to="wbcrm.tag"),
        ),
        migrations.AddField(
            model_name="entry",
            name="in_charge",
            field=models.ManyToManyField(blank=True, related_name="in_charge_of", to="wbcrm.person"),
        ),
        migrations.AddField(
            model_name="entry",
            name="last_change",
            field=models.DateTimeField(auto_now=True, default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name="entry",
            name="last_change_user",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.CASCADE, related_name="locked_models", to="wbcrm.entry"
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="social_charges",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="entry",
            name="vat",
            field=models.FloatField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="entry",
            name="vat_id",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterModelOptions(
            name="entry",
            options={},
        ),
        migrations.AlterField(
            model_name="entry",
            name="last_change_user",
            field=models.ForeignKey(
                null=True, on_delete=django.db.models.deletion.SET_NULL, related_name="locked_models", to="wbcrm.entry"
            ),
        ),
        migrations.AlterModelOptions(
            name="entry",
            options={
                "permissions": (
                    ("view_all_entry", "Can view all entries"),
                    ("view_employer_entry", "You can view your employer entry."),
                    ("view_colleague_entry", "You can view your colleague entry."),
                ),
                "verbose_name": "Entry",
                "verbose_name_plural": "Entries",
            },
        ),
        migrations.AddField(
            model_name="entry",
            name="management_fees_label",
            field=models.CharField(default="Management Fees", max_length=255),
        ),
        migrations.AddField(
            model_name="entry",
            name="performance_fees_label",
            field=models.CharField(default="Performance Fees", max_length=255),
        ),
        migrations.AddField(
            model_name="entry",
            name="split_invoice",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="entry",
            name="profile_image",
            field=models.FileField(blank=True, null=True, upload_to="system/profile_images"),
        ),
        migrations.AddField(
            model_name="entry",
            name="signature",
            field=models.FileField(blank=True, null=True, upload_to="system/signatures"),
        ),
        migrations.AlterModelOptions(
            name="entry",
            options={"verbose_name": "Entry", "verbose_name_plural": "Entries"},
        ),
        migrations.RemoveField(
            model_name="entry",
            name="management_fees_label",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="performance_fees_label",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="social_charges",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="split_invoice",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="vat",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="vat_id",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="last_change",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="last_change_user",
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="status",
            new_name="status_old",
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="tags",
            new_name="tags_old",
        ),
        migrations.AddField(
            model_name="entry",
            name="customer_status",
            field=models.CharField(
                choices=[
                    ("CLIENT", "Client"),
                    ("PROSPECTIVE", "Prospective"),
                    ("DEAD_END", "Dead-End"),
                    ("BUSINESS_INTRODUCER", "Business Introducer"),
                    ("INDUSTRY_EXPORT", "Industry Expert"),
                    ("SERVICE_PROVIDER", "Service Provider"),
                ],
                default="PROSPECTIVE",
                max_length=32,
                verbose_name="Status",
            ),
        ),
        migrations.CreateModel(
            name="DynamicCharField",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "linkage",
                    models.CharField(
                        choices=[("PERSON", "PERSON"), ("COMPANY", "COMPANY"), ("BOTH", "BOTH")],
                        default="BOTH",
                        max_length=10,
                    ),
                ),
                ("title", models.CharField(max_length=64)),
                ("key", models.CharField(blank=True, max_length=64, null=True, unique=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DynamicChoiceField",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "linkage",
                    models.CharField(
                        choices=[("PERSON", "PERSON"), ("COMPANY", "COMPANY"), ("BOTH", "BOTH")],
                        default="BOTH",
                        max_length=10,
                    ),
                ),
                ("title", models.CharField(max_length=64)),
                ("key", models.CharField(blank=True, max_length=64, null=True, unique=True)),
                (
                    "choices",
                    django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=32), size=None),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DynamicRangeField",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "linkage",
                    models.CharField(
                        choices=[("PERSON", "PERSON"), ("COMPANY", "COMPANY"), ("BOTH", "BOTH")],
                        default="BOTH",
                        max_length=10,
                    ),
                ),
                ("title", models.CharField(max_length=64)),
                ("key", models.CharField(blank=True, max_length=64, null=True, unique=True)),
                ("range_min", models.FloatField()),
                ("range_max", models.FloatField()),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AlterField(
            model_name="entry",
            name="in_charge",
            field=models.ManyToManyField(
                blank=True,
                help_text="People in charge of this entry",
                related_name="in_charge_of",
                to="wbcrm.person",
                verbose_name="In Charge",
            ),
        ),
        migrations.RemoveField(
            model_name="entry",
            name="status_old",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="tags_old",
        ),
        migrations.CreateModel(
            name="Activity",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("description", models.TextField(default="", verbose_name="Description")),
                ("result", models.TextField(default="", verbose_name="Review")),
                ("start", models.DateTimeField(blank=True, null=True, verbose_name="Start")),
                ("end", models.DateTimeField(blank=True, null=True, verbose_name="End")),
                (
                    "unplanned_year",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1000),
                            django.core.validators.MaxValueValidator(9999),
                        ],
                    ),
                ),
                (
                    "unplanned_quarter",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(4),
                        ],
                    ),
                ),
                (
                    "unplanned_month",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(12),
                        ],
                    ),
                ),
                (
                    "unplanned_week",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(52),
                        ],
                    ),
                ),
                (
                    "unplanned_day",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(366),
                        ],
                    ),
                ),
                (
                    "unplanned_week_day",
                    models.IntegerField(
                        blank=True,
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(7),
                        ],
                    ),
                ),
                ("location", models.CharField(blank=True, max_length=255, null=True, verbose_name="Location")),
                (
                    "location_longitude",
                    models.DecimalField(
                        blank=True, decimal_places=6, max_digits=9, null=True, verbose_name="Longitude"
                    ),
                ),
                (
                    "location_latitude",
                    models.DecimalField(
                        blank=True, decimal_places=6, max_digits=9, null=True, verbose_name="Latitude"
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
                ("edited", models.DateTimeField(auto_now=True, verbose_name="Edited")),
                (
                    "assigned_to",
                    models.ForeignKey(
                        blank=True,
                        help_text="The person in charge to handle this activity",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="activities",
                        to="wbcrm.person",
                        verbose_name="Assigned to",
                    ),
                ),
                (
                    "creator",
                    models.ForeignKey(
                        blank=True,
                        help_text="The creator of this activity",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="activities_owned",
                        to="wbcrm.person",
                        verbose_name="Creator",
                    ),
                ),
                (
                    "participants",
                    models.ManyToManyField(
                        blank=True,
                        help_text="The list of participants",
                        related_name="participates",
                        to="wbcrm.entry",
                        verbose_name="Participants",
                    ),
                ),
                (
                    "preceded_by",
                    models.ForeignKey(
                        blank=True,
                        help_text="The precedant activity",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="followed_by",
                        to="wbcrm.activity",
                        verbose_name="Preceded by",
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("CANCELLED", "Cancelled"),
                            ("UNPLANNED", "Unplanned"),
                            ("PLANNED", "Planned"),
                            ("FINISHED", "Finished"),
                            ("REVIEWED", "Reviewed"),
                        ],
                        default="PLANNED",
                        max_length=50,
                        verbose_name="Status",
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("CALL", "Call"),
                            ("EMAIL", "E-Mail"),
                            ("MEETING", "Meeting"),
                            ("EVENT", "Event"),
                            ("BUSINESS_TRAVEL", "Travel"),
                            ("HOLIDAY", "Absence"),
                            ("LUNCH", "Lunch"),
                            ("TASK", "Task"),
                            ("ENCOUNTER", "Encounter"),
                            ("OTHER", "Other"),
                        ],
                        default="CALL",
                        max_length=16,
                        verbose_name="Type",
                    ),
                ),
                (
                    "all_day",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if the activity span throughout the day",
                        verbose_name="All Day",
                    ),
                ),
                (
                    "conference_room",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if the activity takes place in the conference room",
                        verbose_name="Conference Room",
                    ),
                ),
                (
                    "all_team",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if the activity involves all employees",
                        verbose_name="Team Meeting",
                    ),
                ),
                (
                    "importance",
                    models.CharField(
                        choices=[("LOW", "Low"), ("MEDIUM", "Medium"), ("HIGH", "High")],
                        default="LOW",
                        max_length=16,
                        verbose_name="Importance",
                    ),
                ),
                (
                    "reminder_choice",
                    models.CharField(
                        choices=[
                            ("NEVER", "Never"),
                            ("EVENT_TIME", "At time of event"),
                            ("MINUTES_5", "5 minutes before"),
                            ("MINUTES_15", "15 minutes before"),
                            ("MINUTES_30", "30 minutes before"),
                            ("HOURS_1", "1 hour before"),
                            ("HOURS_2", "2 hour before"),
                            ("HOURS_12", "12 hour before"),
                            ("WEEKS_1", "1 week before"),
                        ],
                        default="MINUTES_15",
                        help_text="Send a reminder (Email and System notification)",
                        max_length=16,
                        verbose_name="Remind Me",
                    ),
                ),
                (
                    "repeat_choice",
                    models.CharField(
                        choices=[
                            ("NEVER", "Never"),
                            ("RRULE:FREQ=DAILY", "Daily"),
                            ("RRULE:FREQ=WEEKLY", "Weekly"),
                            ("RRULE:FREQ=MONTHLY", "Monthly"),
                            ("RRULE:FREQ=YEARLY", "Yearly"),
                        ],
                        default="NEVER",
                        help_text="Repeat activity at the specified frequency",
                        max_length=32,
                        verbose_name="Repeat In",
                    ),
                ),
            ],
            options={
                "verbose_name": "Activity",
                "verbose_name_plural": "Activities",
                "permissions": [("receive_global_daily_summery", "Receive daily activity summary")],
            },
        ),
        migrations.CreateModel(
            name="ActivityOccurrence",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("start", models.DateTimeField(db_index=True)),
                ("end", models.DateTimeField(blank=True, db_index=True, null=True)),
                ("repeat_until", models.DateField(blank=True, null=True)),
                (
                    "event",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="occurrences",
                        to="wbcrm.activity",
                        verbose_name="Event",
                    ),
                ),
            ],
            options={
                "ordering": ("start", "end"),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="BankingContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                ("institute", models.CharField(max_length=255, verbose_name="Institute")),
                (
                    "institute_additional",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Institute (Additional)"),
                ),
                ("iban", models.CharField(max_length=34, verbose_name="IBAN")),
                ("swift_bic", models.CharField(blank=True, max_length=11, null=True, verbose_name="SWIFT/BIC")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="banking",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Banking Contacts",
                "verbose_name": "Banking Contact",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="EmailContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                ("address", models.EmailField(max_length=254, verbose_name="Email Address")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="emails",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "E-Mail Contacts",
                "verbose_name": "E-Mail Contact",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.AlterField(
            model_name="entry",
            name="additional_fields",
            field=models.JSONField(blank=True, default=dict, null=True, verbose_name="Additional Fields"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="entry_type",
            field=models.CharField(max_length=255, verbose_name="Type"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="rating",
            field=models.IntegerField(
                default=0,
                validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(5)],
                verbose_name="Rating",
            ),
        ),
        migrations.AlterField(
            model_name="entry",
            name="search_name",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Search Name"),
        ),
        migrations.CreateModel(
            name="TelephoneContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                ("number", models.CharField(max_length=255, verbose_name="Number")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="telephones",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
                (
                    "telephone_type",
                    models.CharField(
                        choices=[("FIX", "Fix"), ("CELL", "Cell"), ("FAX", "Fax"), ("OTHER", "Other")],
                        default="FIX",
                        max_length=32,
                        verbose_name="Type",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Telephone Contacts",
                "verbose_name": "Telephone Contact",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="WebsiteContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                ("url", models.URLField(verbose_name="URL")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="websites",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Website Contacts",
                "verbose_name": "Website Contact",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="EntryInChargeRequest",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        choices=[("REMOVE", "Remove"), ("ADD", "Add")],
                        default="ADD",
                        max_length=24,
                        verbose_name="Type",
                    ),
                ),
                (
                    "changer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="in_charge_changer",
                        to="wbcrm.person",
                    ),
                ),
                (
                    "entry",
                    models.ForeignKey(
                        help_text="The entry under supervision",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="in_charge_source",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "in_charge",
                    models.ForeignKey(
                        help_text="Who is in charge of this entry",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="in_charge_target",
                        to="wbcrm.person",
                        verbose_name="In Charge",
                    ),
                ),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[("PENDING", "Pending"), ("DENIED", "Denied"), ("APPROVED", "Approved")],
                        default="PENDING",
                        max_length=50,
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, verbose_name="Created")),
            ],
            options={
                "permissions": (
                    (
                        "change_if_company_in_charge_person",
                        "If you are in charge of a company you can change the in charge fields of a person within the company and also approve changes.",
                    ),
                    ("change_in_charge_entry", "You can change in the in charge fields of everybody."),
                    ("view_all_entryinchargerequest", "View all requests."),
                ),
                "verbose_name": "In Charge Request",
                "verbose_name_plural": "In Charge Requests",
            },
        ),
        migrations.CreateModel(
            name="AddressContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                ("street", models.CharField(blank=True, max_length=255, null=True, verbose_name="Street")),
                (
                    "street_additional",
                    models.CharField(blank=True, max_length=255, null=True, verbose_name="Street (additional)"),
                ),
                ("zip", models.CharField(blank=True, max_length=255, null=True, verbose_name="ZIP")),
                ("city", models.CharField(max_length=255, verbose_name="City")),
                ("province", models.CharField(blank=True, max_length=255, null=True, verbose_name="Province")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="addresses",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Address Contacts",
                "verbose_name": "Address Contact",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.AlterField(
            model_name="activity",
            name="participants",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of participants",
                related_name="participates",
                to="wbcrm.entry",
                verbose_name="Activity Participants",
            ),
        ),
        migrations.AlterField(
            model_name="entry",
            name="in_charge",
            field=models.ManyToManyField(
                blank=True,
                help_text="People in charge of this entry",
                related_name="in_charge_of",
                to="wbcrm.person",
                verbose_name="In Charge s",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="reviewed_at",
            field=models.DateTimeField(blank=True, null=True, verbose_name="Reviewed at"),
        ),
        migrations.AddField(
            model_name="activity",
            name="latest_reviewer",
            field=models.ForeignKey(
                blank=True,
                help_text="The latest person to review the activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="activities_reviewed",
                to="wbcrm.person",
                verbose_name="Latest Reviewer",
            ),
        ),
        migrations.CreateModel(
            name="PersonGroup",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255)),
                ("persons", models.ManyToManyField(blank=True, related_name="groups", to="wbcrm.person")),
            ],
            options={
                "verbose_name": "Person Group",
                "verbose_name_plural": "Person Groups",
            },
        ),
        migrations.DeleteModel(
            name="EntryStatus",
        ),
        migrations.DeleteModel(
            name="PersonPrefix",
        ),
        migrations.DeleteModel(
            name="Tag",
        ),
        migrations.DeleteModel(
            name="DynamicCharField",
        ),
        migrations.DeleteModel(
            name="DynamicChoiceField",
        ),
        migrations.DeleteModel(
            name="DynamicRangeField",
        ),
        migrations.AlterModelTable(
            name="addresscontact",
            table="crm_addresscontact",
        ),
        migrations.AlterModelTable(
            name="bankingcontact",
            table="crm_bankingcontact",
        ),
        migrations.AlterModelTable(
            name="company",
            table="crm_company",
        ),
        migrations.AlterModelTable(
            name="emailcontact",
            table="crm_emailcontact",
        ),
        migrations.AlterModelTable(
            name="entry",
            table="crm_entry",
        ),
        migrations.AlterModelTable(
            name="entryinchargerequest",
            table="crm_entryinchargerequest",
        ),
        migrations.AlterModelTable(
            name="person",
            table="crm_person",
        ),
        migrations.AlterModelTable(
            name="persongroup",
            table="crm_persongroup",
        ),
        migrations.AlterModelTable(
            name="telephonecontact",
            table="crm_telephonecontact",
        ),
        migrations.AlterModelTable(
            name="websitecontact",
            table="crm_websitecontact",
        ),
        migrations.AlterModelTable(
            name="activity",
            table="crm_activity",
        ),
        migrations.AlterModelTable(
            name="activityoccurrence",
            table="crm_activityoccurrence",
        ),
        migrations.AlterModelOptions(
            name="activityoccurrence",
            options={},
        ),
        migrations.AlterModelOptions(
            name="entryinchargerequest",
            options={"verbose_name": "In Charge Request", "verbose_name_plural": "In Charge Requests"},
        ),
        migrations.AlterField(
            model_name="entry",
            name="profile_image",
            field=models.ImageField(blank=True, null=True, upload_to="system/profile_images"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="signature",
            field=models.ImageField(blank=True, null=True, upload_to="system/signatures"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="entry_type",
            field=models.CharField(
                choices=[("PERSON", "Person"), ("COMPANY", "Company")], default="", max_length=255, verbose_name="Type"
            ),
        ),
        migrations.AlterField(
            model_name="activityoccurrence",
            name="end",
            field=models.DateTimeField(blank=True, db_index=True, null=True, verbose_name="end"),
        ),
        migrations.AlterField(
            model_name="activityoccurrence",
            name="repeat_until",
            field=models.DateField(blank=True, null=True, verbose_name="repeat_until"),
        ),
        migrations.AlterField(
            model_name="activityoccurrence",
            name="start",
            field=models.DateTimeField(db_index=True, verbose_name="start"),
        ),
        migrations.AlterField(
            model_name="addresscontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="addresses",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="banking",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="emailcontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="emails",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="telephonecontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="telephones",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="websitecontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="websites",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="addresscontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="addresses",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="banking",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="emailcontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="emails",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="telephonecontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="telephones",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="websitecontact",
            name="entry",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="websites",
                to="wbcrm.entry",
                verbose_name="Entry",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="all_team",
            field=models.BooleanField(
                default=False,
                help_text="Check this if the activity involves all employees",
                verbose_name="Team Meeting (all employees)",
            ),
        ),
        django.contrib.postgres.operations.UnaccentExtension(),
        migrations.AlterField(
            model_name="bankingcontact",
            name="iban",
            field=models.CharField(max_length=38, verbose_name="IBAN"),
        ),
        django.contrib.postgres.operations.TrigramExtension(),
        migrations.AlterField(
            model_name="activity",
            name="all_team",
            field=models.BooleanField(
                default=False,
                help_text="Check this if the activity involves all employees",
                verbose_name="Company Meeting (i.e. All employees)",
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="last_name",
            field=models.CharField(max_length=255, verbose_name="Last Name"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="description",
            field=models.TextField(blank=True, default="", verbose_name="Description"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="result",
            field=models.TextField(blank=True, default="", verbose_name="Review"),
        ),
        migrations.AlterField(
            model_name="company",
            name="asset_allocation",
            field=models.CharField(blank=True, default="", max_length=255, verbose_name="Asset Allocation"),
        ),
        migrations.AlterField(
            model_name="company",
            name="assets_under_management",
            field=models.CharField(blank=True, default="", max_length=255, verbose_name="AUM"),
        ),
        migrations.AlterField(
            model_name="company",
            name="description",
            field=models.TextField(blank=True, default="", verbose_name="Description"),
        ),
        migrations.AlterField(
            model_name="company",
            name="geographic_focus",
            field=models.CharField(blank=True, default="", max_length=255, verbose_name="Geographic Focus"),
        ),
        migrations.AlterField(
            model_name="company",
            name="headcount",
            field=models.CharField(blank=True, default="", max_length=32, verbose_name="Number of employees"),
        ),
        migrations.AddField(
            model_name="bankingcontact",
            name="additional_information",
            field=models.TextField(
                blank=True,
                help_text="Can be used in place of IBAN to communicate baking information",
                null=True,
                verbose_name="Additional Information",
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="slugify_search_name",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Slugified Search Name"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="repeat_choice",
            field=models.CharField(
                choices=[
                    ("NEVER", "Never"),
                    ("RRULE:FREQ=DAILY", "Daily"),
                    ("RRULE:FREQ=WEEKLY", "Weekly"),
                    ("RRULE:FREQ=WEEKLY;INTERVAL=2", "Bi-Weekly"),
                    ("RRULE:FREQ=MONTHLY", "Monthly (Every Same day)"),
                    ("MONTHLY_WEEKDAY", "Monthly (Every Xth weekday of the month)"),
                    ("MONTHLY_LASTWEEKDAY", "Monthly (Every Xth weekday before the end of the month)"),
                    ("RRULE:FREQ=YEARLY", "Yearly"),
                    ("CUSTOM", "Custom"),
                ],
                default="NEVER",
                help_text="Repeat activity at the specified frequency",
                max_length=32,
                verbose_name="Repeat In",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="iban",
            field=models.CharField(blank=True, max_length=38, null=True, verbose_name="IBAN"),
        ),
        migrations.AlterModelOptions(
            name="entryinchargerequest",
            options={
                "permissions": (("can_administer_entry_in_charge_request", "Can administer Entry In Charge Request"),),
                "verbose_name": "In Charge Request",
                "verbose_name_plural": "In Charge Requests",
            },
        ),
        migrations.CreateModel(
            name="EventType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=256)),
            ],
            options={
                "verbose_name": "Event Type",
                "verbose_name_plural": "Event Types",
            },
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("description", models.TextField(blank=True, default="")),
                (
                    "entry",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="events", to="wbcrm.entry"
                    ),
                ),
                ("event_date", models.DateField(default=datetime.date.today, verbose_name="Date")),
                (
                    "event_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="events",
                        to="wbcrm.eventtype",
                        verbose_name="Type",
                    ),
                ),
            ],
            options={
                "verbose_name": "Event",
                "verbose_name_plural": "Events",
            },
        ),
        migrations.CreateModel(
            name="RelationshipType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=256, unique=True, verbose_name="Relationship Type")),
                (
                    "counter_relationship",
                    models.OneToOneField(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="reverse_counter_relationship",
                        to="wbcrm.relationshiptype",
                        verbose_name="Counter Relationship",
                    ),
                ),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=256, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
            ],
            options={
                "verbose_name": "Relationship Type",
                "verbose_name_plural": "Relationship Types",
            },
        ),
        migrations.CreateModel(
            name="Relationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "relationship_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT, to="wbcrm.relationshiptype", verbose_name="Type"
                    ),
                ),
            ],
            options={
                "verbose_name": "Relationship",
                "verbose_name_plural": "Relationships",
            },
        ),
        migrations.AddField(
            model_name="entry",
            name="activity_heat",
            field=models.FloatField(
                default=0,
                validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)],
                verbose_name="Activity Heat",
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="relationships",
            field=models.ManyToManyField(
                blank=True, through="wbcrm.Relationship", to="wbcrm.entry", verbose_name="The Entries Relationships"
            ),
        ),
        migrations.AddField(
            model_name="relationship",
            name="from_entry",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="from_entry",
                to="wbcrm.entry",
                verbose_name="Relationship From",
            ),
        ),
        migrations.AddField(
            model_name="relationship",
            name="to_entry",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="to_entry",
                to="wbcrm.entry",
                verbose_name="Relationship To",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="repeat_choice",
            field=models.CharField(
                choices=[
                    ("NEVER", "Never"),
                    ("RRULE:FREQ=DAILY", "Daily"),
                    ("RRULE:FREQ=WEEKLY", "Weekly"),
                    ("RRULE:FREQ=WEEKLY;INTERVAL=2", "Bi-Weekly"),
                    ("RRULE:FREQ=MONTHLY", "Monthly (Every Same day)"),
                    ("MONTHLY_WEEKDAY", "Monthly (Every Xth weekday of the month)"),
                    ("MONTHLY_LASTWEEKDAY", "Monthly (Every Xth weekday before the end of the month)"),
                    ("RRULE:FREQ=YEARLY", "Yearly"),
                ],
                default="NEVER",
                help_text="Repeat activity at the specified frequency",
                max_length=32,
                verbose_name="Repeat In",
            ),
        ),
        migrations.AddField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterModelOptions(
            name="bankingcontact",
            options={
                "permissions": (("can_approve_banking_contact", "Can approve Banking Contact"),),
                "verbose_name": "Banking Contact",
                "verbose_name_plural": "Banking Contacts",
            },
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PENDING", "Pending"), ("DRAFT", "Draft"), ("APPROVED", "Approved")],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterModelOptions(
            name="bankingcontact",
            options={
                "permissions": (("can_approve_bankingcontact", "Can approve Banking Contact"),),
                "verbose_name": "Banking Contact",
                "verbose_name_plural": "Banking Contacts",
            },
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies participating",
                related_name="companies",
                to="wbcrm.company",
                verbose_name="Participating company",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="disable_participant_check",
            field=models.BooleanField(default=False, verbose_name="Without participating company"),
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="status",
            field=django_fsm.FSMField(
                choices=[("DRAFT", "Draft"), ("PENDING", "Pending"), ("APPROVED", "Approved")],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.RemoveField(
            model_name="activity",
            name="participants",
        ),
        migrations.CreateModel(
            name="ClientManagerRelationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                (
                    "client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="client",
                        to="wbcrm.entry",
                        verbose_name="Client",
                    ),
                ),
                (
                    "relationship_manager",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="relationship_manager",
                        to="wbcrm.person",
                        verbose_name="Relationship Manager",
                    ),
                ),
            ],
            options={
                "verbose_name": "Client Manager Relationship",
                "verbose_name_plural": "Client Manager Relationships",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="in_charge",
            new_name="in_charge_old",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="in_charge_old",
        ),
        migrations.AddField(
            model_name="entry",
            name="in_charge",
            field=models.ManyToManyField(
                blank=True,
                help_text="People in charge of this entry",
                related_name="in_charge_of",
                through="wbcrm.ClientManagerRelationship",
                to="wbcrm.person",
                verbose_name="In Charge s",
            ),
        ),
        migrations.AlterField(
            model_name="entryinchargerequest",
            name="entry",
            field=models.ForeignKey(
                help_text="The entry under supervision",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="in_charge_source",
                to="wbcrm.entry",
                verbose_name="Client",
            ),
        ),
        migrations.AddField(
            model_name="entryinchargerequest",
            name="primary",
            field=models.BooleanField(default=False, verbose_name="Primary In Charge Person"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="preceded_by",
            field=models.ForeignKey(
                blank=True,
                help_text="The preceding activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="followed_by",
                to="wbcrm.activity",
                verbose_name="Preceded by",
            ),
        ),
        migrations.RenameField(
            model_name="company",
            old_name="tiering",
            new_name="tier",
        ),
        migrations.AlterField(
            model_name="company",
            name="tier",
            field=models.CharField(
                choices=[("ONE", "1"), ("TWO", "2"), ("THREE", "3"), ("FOUR", "4"), ("FIVE", "5")],
                default="ONE",
                max_length=16,
                verbose_name="Tiering",
            ),
        ),
        migrations.CreateModel(
            name="EmployerEmployeeRelationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                (
                    "employee",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="employer",
                        to="wbcrm.person",
                        verbose_name="Employee",
                    ),
                ),
                (
                    "employer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="employee",
                        to="wbcrm.company",
                        verbose_name="Employer",
                    ),
                ),
            ],
            options={
                "verbose_name": "Employer Employee Relationship",
            },
            bases=(wbcore.utils.models.PrimaryMixin, models.Model),
        ),
        migrations.RemoveField(
            model_name="person",
            name="employers",
        ),
        migrations.AddField(
            model_name="person",
            name="employers",
            field=models.ManyToManyField(
                blank=True,
                help_text="The person's employers",
                related_name="employees",
                through="wbcrm.EmployerEmployeeRelationship",
                to="wbcrm.company",
                verbose_name="Companies/Employers",
            ),
        ),
        migrations.CreateModel(
            name="Position",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, unique=True, verbose_name="Position Title")),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=128, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
            ],
            options={
                "verbose_name": "Position in Company",
                "verbose_name_plural": "Positions in Company",
            },
        ),
        migrations.AlterField(
            model_name="entry",
            name="in_charge",
            field=models.ManyToManyField(
                blank=True,
                help_text="People in charge of this entry",
                related_name="in_charge_of",
                through="wbcrm.ClientManagerRelationship",
                to="wbcrm.person",
                verbose_name="In Charge Person",
            ),
        ),
        migrations.AddField(
            model_name="employeremployeerelationship",
            name="position",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="position_of_employee",
                to="wbcrm.position",
                verbose_name="Position",
            ),
        ),
        migrations.CreateModel(
            name="CustomerStatus",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=32, unique=True, verbose_name="Status Title")),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=32, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
            ],
            options={
                "verbose_name": "Customer Status",
                "verbose_name_plural": "Customer Statuses",
            },
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="customer_status",
            new_name="old_customer_status",
        ),
        migrations.AddField(
            model_name="company",
            name="customer_status",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="company",
                to="wbcrm.customerstatus",
                verbose_name="Customer Status",
            ),
        ),
        migrations.RemoveField(
            model_name="entry",
            name="old_customer_status",
        ),
        migrations.RemoveField(
            model_name="person",
            name="position",
        ),
        migrations.CreateModel(
            name="CompanyType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, unique=True, verbose_name="Company Type")),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=128, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
            ],
            options={
                "verbose_name": "Company Type",
                "verbose_name_plural": "Company Types",
            },
        ),
        migrations.RemoveField(
            model_name="company",
            name="type",
        ),
        migrations.AddField(
            model_name="company",
            name="type",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="company",
                to="wbcrm.companytype",
                verbose_name="Type",
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="last_activity",
            field=models.ForeignKey(
                blank=True,
                help_text="The last activity of this entry",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_activity_of",
                to="wbcrm.activity",
                verbose_name="Last Activity",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies participating",
                related_name="company_participates",
                to="wbcrm.company",
                verbose_name="Participating company",
            ),
        ),
        migrations.AlterField(
            model_name="clientmanagerrelationship",
            name="client",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="manager_of",
                to="wbcrm.entry",
                verbose_name="Client",
            ),
        ),
        migrations.AlterField(
            model_name="clientmanagerrelationship",
            name="relationship_manager",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="client_of",
                to="wbcrm.person",
                verbose_name="Relationship Manager",
            ),
        ),
        migrations.AlterField(
            model_name="clientmanagerrelationship",
            name="client",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="client_of",
                to="wbcrm.entry",
                verbose_name="Client",
            ),
        ),
        migrations.AlterField(
            model_name="clientmanagerrelationship",
            name="relationship_manager",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="manager_of",
                to="wbcrm.person",
                verbose_name="Relationship Manager",
            ),
        ),
        migrations.AlterField(
            model_name="entryinchargerequest",
            name="status",
            field=django_fsm.FSMField(
                choices=[("PENDING", "Pending"), ("DENIED", "Denied"), ("APPROVED", "Approved")],
                default="PENDING",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.AddField(
            model_name="clientmanagerrelationship",
            name="created",
            field=models.DateTimeField(auto_now_add=True, default=django.utils.timezone.now, verbose_name="Created"),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="clientmanagerrelationship",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("DRAFT", "Draft"),
                    ("PENDINGADD", "Pending Add"),
                    ("PENDINGREMOVE", "Pending Remove"),
                    ("APPROVED", "Approved"),
                    ("REMOVED", "Removed"),
                ],
                default="DRAFT",
                max_length=50,
                verbose_name="Status",
            ),
        ),
        migrations.DeleteModel(
            name="EntryInChargeRequest",
        ),
        migrations.AddField(
            model_name="activity",
            name="external_id",
            field=models.CharField(blank=True, max_length=1000, null=True, verbose_name="External ID"),
        ),
        migrations.AddField(
            model_name="activity",
            name="parent_activity",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.DO_NOTHING,
                related_name="child_activities",
                to="wbcrm.activity",
                verbose_name="Parent Activity",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="propagate_for_all_children",
            field=models.BooleanField(
                default=False,
                help_text="If this is checked, changes will be propagated to the following activities.",
                verbose_name="Propagate for all following activities?",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="recurrence_count",
            field=models.IntegerField(
                blank=True,
                help_text="Specifies how often an activity should be repeated. Is mutually exclusive with the end date.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(365),
                ],
                verbose_name="Recurrence Count",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="recurrence_end",
            field=models.DateField(
                blank=True,
                help_text="Specifies until when an event is to be repeated. Is mutually exclusive with the Recurrence Count.",
                null=True,
                verbose_name="Repeat Until Date",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="repeat_choice",
            field=models.CharField(
                choices=[
                    ("NEVER", "Never"),
                    ("RRULE:FREQ=DAILY;INTERVAL=1;WKST=MO;BYDAY=MO,TU,WE,TH,FR", "Buisness Daily"),
                    ("RRULE:FREQ=DAILY", "Daily"),
                    ("RRULE:FREQ=WEEKLY", "Weekly"),
                    ("RRULE:FREQ=WEEKLY;INTERVAL=2", "Bi-Weekly"),
                    ("RRULE:FREQ=MONTHLY", "Monthly (Every Same day)"),
                    ("RRULE:FREQ=YEARLY", "Yearly"),
                ],
                default="NEVER",
                help_text="Repeat activity at the specified frequency",
                max_length=56,
                verbose_name="Repeat In",
            ),
        ),
        migrations.DeleteModel(
            name="ActivityOccurrence",
        ),
        migrations.AlterField(
            model_name="entry",
            name="last_activity",
            field=models.ForeignKey(
                blank=True,
                help_text="The last activity of this entry. Can be ordered by end date.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="last_activity_of",
                to="wbcrm.activity",
                verbose_name="Last Activity",
            ),
        ),
        migrations.RemoveField(
            model_name="entry",
            name="rating",
        ),
        migrations.CreateModel(
            name="ActivityType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, unique=True, verbose_name="Activity Type")),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=128, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
                (
                    "icon",
                    models.CharField(
                        choices=[
                            ("wb-icon-action", "wb-icon-action"),
                            ("wb-icon-arrows-swap-1", "wb-icon-arrows-swap-1"),
                            ("wb-icon-arrows-swap-2", "wb-icon-arrows-swap-2"),
                            ("wb-icon-arrow-down", "wb-icon-arrow-down"),
                            ("wb-icon-arrow-left", "wb-icon-arrow-left"),
                            ("wb-icon-arrow-right", "wb-icon-arrow-right"),
                            ("wb-icon-arrow-up", "wb-icon-arrow-up"),
                            ("wb-icon-bank", "wb-icon-bank"),
                            ("wb-icon-bell-inverted", "wb-icon-bell-inverted"),
                            ("wb-icon-bell", "wb-icon-bell"),
                            ("wb-icon-bold", "wb-icon-bold"),
                            ("wb-icon-bookmark", "wb-icon-bookmark"),
                            ("wb-icon-bookmark-inverted", "wb-icon-bookmark-inverted"),
                            ("wb-icon-bulleted-list", "wb-icon-bulleted-list"),
                            ("wb-icon-cake-1", "wb-icon-cake-1"),
                            ("wb-icon-cake-2", "wb-icon-cake-2"),
                            ("wb-icon-cake-3", "wb-icon-cake-3"),
                            ("wb-icon-calendar-1", "wb-icon-calendar-1"),
                            ("wb-icon-calendar-2", "wb-icon-calendar-2"),
                            ("wb-icon-calendar-3", "wb-icon-calendar-3"),
                            ("wb-icon-camera-1", "wb-icon-camera-1"),
                            ("wb-icon-camera-2", "wb-icon-camera-2"),
                            ("wb-icon-chart-bars-1", "wb-icon-chart-bars-1"),
                            ("wb-icon-chart-bars-2", "wb-icon-chart-bars-2"),
                            ("wb-icon-chart-bars-3", "wb-icon-chart-bars-3"),
                            ("wb-icon-chart-bars-4", "wb-icon-chart-bars-4"),
                            ("wb-icon-chart-line-2", "wb-icon-chart-line-2"),
                            ("wb-icon-chart-pie", "wb-icon-chart-pie"),
                            ("wb-icon-chart-piramid", "wb-icon-chart-piramid"),
                            ("wb-icon-chart-switches", "wb-icon-chart-switches"),
                            ("wb-icon-circle-check", "wb-icon-circle-check"),
                            ("wb-icon-circle-exclamation", "wb-icon-circle-exclamation"),
                            ("wb-icon-circle-exclamation-inverted", "wb-icon-circle-exclamation-inverted"),
                            ("wb-icon-circle-x-inverted", "wb-icon-circle-x-inverted"),
                            ("wb-icon-circle-question", "wb-icon-circle-question"),
                            ("wb-icon-circle-question-inverted", "wb-icon-circle-question-inverted"),
                            ("wb-icon-circle-x", "wb-icon-circle-x"),
                            ("wb-icon-circle-check-inverted", "wb-icon-circle-check-inverted"),
                            ("wb-icon-clipboard-1", "wb-icon-clipboard-1"),
                            ("wb-icon-clipboard-2", "wb-icon-clipboard-2"),
                            ("wb-icon-clipboard-3", "wb-icon-clipboard-3"),
                            ("wb-icon-clipboard-4", "wb-icon-clipboard-4"),
                            ("wb-icon-clipboard-checks-1", "wb-icon-clipboard-checks-1"),
                            ("wb-icon-clipboard-checks-2", "wb-icon-clipboard-checks-2"),
                            ("wb-icon-clock-2", "wb-icon-clock-2"),
                            ("wb-icon-clock-1", "wb-icon-clock-1"),
                            ("wb-icon-clock-3", "wb-icon-clock-3"),
                            ("wb-icon-clock-alarm", "wb-icon-clock-alarm"),
                            ("wb-icon-gear-6", "wb-icon-gear-6"),
                            ("wb-icon-contact-book", "wb-icon-contact-book"),
                            ("wb-icon-copy-1", "wb-icon-copy-1"),
                            ("wb-icon-copy-2", "wb-icon-copy-2"),
                            ("wb-icon-copy-3", "wb-icon-copy-3"),
                            ("wb-icon-copy-4", "wb-icon-copy-4"),
                            ("wb-icon-copy-5", "wb-icon-copy-5"),
                            ("wb-icon-copy-6", "wb-icon-copy-6"),
                            ("wb-icon-copy-7", "wb-icon-copy-7"),
                            ("wb-icon-copy-fat-1", "wb-icon-copy-fat-1"),
                            ("wb-icon-copy-fat-2", "wb-icon-copy-fat-2"),
                            ("wb-icon-copy-fat-3", "wb-icon-copy-fat-3"),
                            ("wb-icon-copy-fat-4", "wb-icon-copy-fat-4"),
                            ("wb-icon-copy-fat-5", "wb-icon-copy-fat-5"),
                            ("wb-icon-crosshair", "wb-icon-crosshair"),
                            ("wb-icon-dashboard-2", "wb-icon-dashboard-2"),
                            ("wb-icon-dashboard-1", "wb-icon-dashboard-1"),
                            ("wb-icon-data-grid-3", "wb-icon-data-grid-3"),
                            ("wb-icon-data-grid-1", "wb-icon-data-grid-1"),
                            ("wb-icon-data-grid-2", "wb-icon-data-grid-2"),
                            ("wb-icon-data-grid-4", "wb-icon-data-grid-4"),
                            ("wb-icon-data-grid-5", "wb-icon-data-grid-5"),
                            ("wb-icon-data-list-2", "wb-icon-data-list-2"),
                            ("wb-icon-data-list-3", "wb-icon-data-list-3"),
                            ("wb-icon-data-list-4", "wb-icon-data-list-4"),
                            ("wb-icon-data-list-5", "wb-icon-data-list-5"),
                            ("wb-icon-data-list-6", "wb-icon-data-list-6"),
                            ("wb-icon-data-list-7", "wb-icon-data-list-7"),
                            ("wb-icon-dedent", "wb-icon-dedent"),
                            ("wb-icon-disabled", "wb-icon-disabled"),
                            ("wb-icon-document-1", "wb-icon-document-1"),
                            ("wb-icon-document-2", "wb-icon-document-2"),
                            ("wb-icon-document-book", "wb-icon-document-book"),
                            ("wb-icon-document-gear", "wb-icon-document-gear"),
                            ("wb-icon-document-lock", "wb-icon-document-lock"),
                            ("wb-icon-dollar", "wb-icon-dollar"),
                            ("wb-icon-edit-2", "wb-icon-edit-2"),
                            ("wb-icon-edit-3", "wb-icon-edit-3"),
                            ("wb-icon-envelope", "wb-icon-envelope"),
                            ("wb-icon-envelope-open-1", "wb-icon-envelope-open-1"),
                            ("wb-icon-envelope-open-2", "wb-icon-envelope-open-2"),
                            ("wb-icon-envelope-open-dollar", "wb-icon-envelope-open-dollar"),
                            ("wb-icon-envelope-open-euro", "wb-icon-envelope-open-euro"),
                            ("wb-icon-envelope-open-suitcase", "wb-icon-envelope-open-suitcase"),
                            ("wb-icon-envelope-open-3", "wb-icon-envelope-open-3"),
                            ("wb-icon-envelope-open-person", "wb-icon-envelope-open-person"),
                            ("wb-icon-euro", "wb-icon-euro"),
                            ("wb-icon-eye", "wb-icon-eye"),
                            ("wb-icon-eye-crossed", "wb-icon-eye-crossed"),
                            ("wb-icon-female", "wb-icon-female"),
                            ("wb-icon-filters-1", "wb-icon-filters-1"),
                            ("wb-icon-filters-2", "wb-icon-filters-2"),
                            ("wb-icon-filters-off-1", "wb-icon-filters-off-1"),
                            ("wb-icon-filters-off-2", "wb-icon-filters-off-2"),
                            ("wb-icon-filters-off-3", "wb-icon-filters-off-3"),
                            ("wb-icon-floppy-disk", "wb-icon-floppy-disk"),
                            ("wb-icon-floppy-disk-check", "wb-icon-floppy-disk-check"),
                            ("wb-icon-floppy-disk-x", "wb-icon-floppy-disk-x"),
                            ("wb-icon-folder", "wb-icon-folder"),
                            ("wb-icon-folders", "wb-icon-folders"),
                            ("wb-icon-folder-euro", "wb-icon-folder-euro"),
                            ("wb-icon-folder-inverted", "wb-icon-folder-inverted"),
                            ("wb-icon-folder-plus", "wb-icon-folder-plus"),
                            ("wb-icon-folder-plus-inverted", "wb-icon-folder-plus-inverted"),
                            ("wb-icon-font-color", "wb-icon-font-color"),
                            ("wb-icon-gear-1", "wb-icon-gear-1"),
                            ("wb-icon-gear-2", "wb-icon-gear-2"),
                            ("wb-icon-gear-3", "wb-icon-gear-3"),
                            ("wb-icon-gear-4", "wb-icon-gear-4"),
                            ("wb-icon-gear-5", "wb-icon-gear-5"),
                            ("wb-icon-gear-7", "wb-icon-gear-7"),
                            ("wb-icon-globe-1", "wb-icon-globe-1"),
                            ("wb-icon-globe-2", "wb-icon-globe-2"),
                            ("wb-icon-handshake", "wb-icon-handshake"),
                            ("wb-icon-handshake-euro", "wb-icon-handshake-euro"),
                            ("wb-icon-home", "wb-icon-home"),
                            ("wb-icon-hourglass-empty", "wb-icon-hourglass-empty"),
                            ("wb-icon-hourglass-full", "wb-icon-hourglass-full"),
                            ("wb-icon-hourglass-middle", "wb-icon-hourglass-middle"),
                            ("wb-icon-image", "wb-icon-image"),
                            ("wb-icon-indent", "wb-icon-indent"),
                            ("wb-icon-circle-info", "wb-icon-circle-info"),
                            ("wb-icon-italic", "wb-icon-italic"),
                            ("wb-icon-link", "wb-icon-link"),
                            ("wb-icon-lock-closed-2", "wb-icon-lock-closed-2"),
                            ("wb-icon-lock-closed-1", "wb-icon-lock-closed-1"),
                            ("wb-icon-lock-closed-3", "wb-icon-lock-closed-3"),
                            ("wb-icon-lock-open-2", "wb-icon-lock-open-2"),
                            ("wb-icon-lock-open-1", "wb-icon-lock-open-1"),
                            ("wb-icon-lock-open-3", "wb-icon-lock-open-3"),
                            ("wb-icon-lunch", "wb-icon-lunch"),
                            ("wb-icon-male", "wb-icon-male"),
                            ("wb-icon-man-1", "wb-icon-man-1"),
                            ("wb-icon-man-2", "wb-icon-man-2"),
                            ("wb-icon-man-3", "wb-icon-man-3"),
                            ("wb-icon-man-4", "wb-icon-man-4"),
                            ("wb-icon-man-5", "wb-icon-man-5"),
                            ("wb-icon-man-6", "wb-icon-man-6"),
                            ("wb-icon-man-7", "wb-icon-man-7"),
                            ("wb-icon-maximize-3", "wb-icon-maximize-3"),
                            ("wb-icon-maximize-1", "wb-icon-maximize-1"),
                            ("wb-icon-maximize-2", "wb-icon-maximize-2"),
                            ("wb-icon-data-list-1", "wb-icon-data-list-1"),
                            ("wb-icon-minimize-4", "wb-icon-minimize-4"),
                            ("wb-icon-minimize-1", "wb-icon-minimize-1"),
                            ("wb-icon-minimize-2", "wb-icon-minimize-2"),
                            ("wb-icon-minimize-3", "wb-icon-minimize-3"),
                            ("wb-icon-notebook", "wb-icon-notebook"),
                            ("wb-icon-notebook-inverted", "wb-icon-notebook-inverted"),
                            ("wb-icon-numbered-list", "wb-icon-numbered-list"),
                            ("wb-icon-page-break", "wb-icon-page-break"),
                            ("wb-icon-edit-1", "wb-icon-edit-1"),
                            ("wb-icon-people", "wb-icon-people"),
                            ("wb-icon-person", "wb-icon-person"),
                            ("wb-icon-phone", "wb-icon-phone"),
                            ("wb-icon-phone-call", "wb-icon-phone-call"),
                            ("wb-icon-pin", "wb-icon-pin"),
                            ("wb-icon-pipette-empty", "wb-icon-pipette-empty"),
                            ("wb-icon-pipette-full", "wb-icon-pipette-full"),
                            ("wb-icon-plus", "wb-icon-plus"),
                            ("wb-icon-quote", "wb-icon-quote"),
                            ("wb-icon-recorder", "wb-icon-recorder"),
                            ("wb-icon-redo", "wb-icon-redo"),
                            ("wb-icon-refresh-1", "wb-icon-refresh-1"),
                            ("wb-icon-refresh-2", "wb-icon-refresh-2"),
                            ("wb-icon-refresh-24-acw", "wb-icon-refresh-24-acw"),
                            ("wb-icon-refresh-24-cw", "wb-icon-refresh-24-cw"),
                            ("wb-icon-refresh-3-acw", "wb-icon-refresh-3-acw"),
                            ("wb-icon-refresh-3-cw", "wb-icon-refresh-3-cw"),
                            ("wb-icon-refresh-clock", "wb-icon-refresh-clock"),
                            ("wb-icon-refresh-dots", "wb-icon-refresh-dots"),
                            ("wb-icon-refresh-dots-24", "wb-icon-refresh-dots-24"),
                            ("wb-icon-refresh-dots-gear", "wb-icon-refresh-dots-gear"),
                            ("wb-icon-refresh-three", "wb-icon-refresh-three"),
                            ("wb-icon-remove-formatting", "wb-icon-remove-formatting"),
                            ("wb-icon-arrows-replace", "wb-icon-arrows-replace"),
                            ("wb-icon-scissors", "wb-icon-scissors"),
                            ("wb-icon-search", "wb-icon-search"),
                            ("wb-icon-send", "wb-icon-send"),
                            ("wb-icon-sick-leave-1", "wb-icon-sick-leave-1"),
                            ("wb-icon-sick-leave-2", "wb-icon-sick-leave-2"),
                            ("wb-icon-sick-leave-3", "wb-icon-sick-leave-3"),
                            ("wb-icon-sick-leave-4", "wb-icon-sick-leave-4"),
                            ("wb-icon-share-1", "wb-icon-share-1"),
                            ("wb-icon-share-2", "wb-icon-share-2"),
                            ("wb-icon-skype", "wb-icon-skype"),
                            ("wb-icon-from-a-to-z", "wb-icon-from-a-to-z"),
                            ("wb-icon-from-z-to-a", "wb-icon-from-z-to-a"),
                            ("wb-icon-sound-off", "wb-icon-sound-off"),
                            ("wb-icon-sound-on", "wb-icon-sound-on"),
                            ("wb-icon-speech-bubble", "wb-icon-speech-bubble"),
                            ("wb-icon-spell-check", "wb-icon-spell-check"),
                            ("wb-icon-star", "wb-icon-star"),
                            ("wb-icon-chart-line-1", "wb-icon-chart-line-1"),
                            ("wb-icon-step-back-2", "wb-icon-step-back-2"),
                            ("wb-icon-step-forward-2", "wb-icon-step-forward-2"),
                            ("wb-icon-step-back-1", "wb-icon-step-back-1"),
                            ("wb-icon-step-forward-1", "wb-icon-step-forward-1"),
                            ("wb-icon-strikethrough", "wb-icon-strikethrough"),
                            ("wb-icon-subscript", "wb-icon-subscript"),
                            ("wb-icon-suitcase-1", "wb-icon-suitcase-1"),
                            ("wb-icon-suitcase-2", "wb-icon-suitcase-2"),
                            ("wb-icon-superscript", "wb-icon-superscript"),
                            ("wb-icon-table", "wb-icon-table"),
                            ("wb-icon-text-align-center", "wb-icon-text-align-center"),
                            ("wb-icon-text-align-justify", "wb-icon-text-align-justify"),
                            ("wb-icon-text-align-left", "wb-icon-text-align-left"),
                            ("wb-icon-text-align-right", "wb-icon-text-align-right"),
                            ("wb-icon-text-bg-color", "wb-icon-text-bg-color"),
                            ("wb-icon-thumb-down", "wb-icon-thumb-down"),
                            ("wb-icon-thumb-up", "wb-icon-thumb-up"),
                            ("wb-icon-trade", "wb-icon-trade"),
                            ("wb-icon-trashbin-2", "wb-icon-trashbin-2"),
                            ("wb-icon-trashbin-1", "wb-icon-trashbin-1"),
                            ("wb-icon-triangles-down", "wb-icon-triangles-down"),
                            ("wb-icon-triangles-left", "wb-icon-triangles-left"),
                            ("wb-icon-triangles-left-stop", "wb-icon-triangles-left-stop"),
                            ("wb-icon-triangles-right", "wb-icon-triangles-right"),
                            ("wb-icon-triangles-right-stop", "wb-icon-triangles-right-stop"),
                            ("wb-icon-triangles-up", "wb-icon-triangles-up"),
                            ("wb-icon-triangle-down", "wb-icon-triangle-down"),
                            ("wb-icon-triangle-left", "wb-icon-triangle-left"),
                            ("wb-icon-triangle-right", "wb-icon-triangle-right"),
                            ("wb-icon-triangle-up", "wb-icon-triangle-up"),
                            ("wb-icon-underline", "wb-icon-underline"),
                            ("wb-icon-undo", "wb-icon-undo"),
                            ("wb-icon-unlink", "wb-icon-unlink"),
                            ("wb-icon-woman-1", "wb-icon-woman-1"),
                            ("wb-icon-woman-2", "wb-icon-woman-2"),
                            ("wb-icon-woman-3", "wb-icon-woman-3"),
                            ("wb-icon-woman-4", "wb-icon-woman-4"),
                            ("wb-icon-woman-5", "wb-icon-woman-5"),
                            ("wb-icon-woman-6", "wb-icon-woman-6"),
                            ("wb-icon-woman-7", "wb-icon-woman-7"),
                            ("wb-icon-x", "wb-icon-x"),
                        ],
                        default="wb-icon-phone",
                        max_length=128,
                        verbose_name="Icon",
                    ),
                ),
                ("color", models.CharField(default="#ffffff", max_length=7, verbose_name="Color")),
                (
                    "score",
                    models.CharField(
                        choices=[("4.0", "High"), ("3.0", "Medium"), ("2.0", "Low"), ("0.0", "None")],
                        default="2.0",
                        help_text="Used for the activity heat calculation. Multipliers range from low (2, i.e. e-mail), medium (3, i.e. call) to high (4, i.e. meeting). None is used if this activity type is not used to create scores",
                        max_length=8,
                        verbose_name="Activity Heat Multiplier",
                    ),
                ),
                ("default", models.BooleanField(default=False, verbose_name="Default")),
            ],
            options={
                "verbose_name": "Activity Type",
                "verbose_name_plural": "Activity Types",
            },
        ),
        migrations.RemoveField(
            model_name="activity",
            name="type",
        ),
        migrations.AlterField(
            model_name="bankingcontact",
            name="additional_information",
            field=models.TextField(
                blank=True,
                help_text="Can be used in place of IBAN to communicate banking information",
                null=True,
                verbose_name="Additional Information",
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="activity",
                to="wbcrm.activitytype",
                verbose_name="Type",
            ),
        ),
        migrations.AlterModelOptions(
            name="entry",
            options={"ordering": ("entry_type",), "verbose_name": "Entry", "verbose_name_plural": "Entries"},
        ),
        migrations.AlterField(
            model_name="addresscontact",
            name="city",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="City"),
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="in_charge",
            new_name="relationship_managers",
        ),
        migrations.AlterField(
            model_name="entry",
            name="relationship_managers",
            field=models.ManyToManyField(
                blank=True,
                help_text="People in charge of this entry",
                related_name="clients",
                through="wbcrm.ClientManagerRelationship",
                to="wbcrm.person",
                verbose_name="Relationship Managers",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="assigned_to",
            field=models.ForeignKey(
                blank=True,
                help_text="The person in charge of handling this activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="activities",
                to="wbcrm.person",
                verbose_name="Assigned to",
            ),
        ),
        migrations.AlterField(
            model_name="company",
            name="tier",
            field=models.CharField(
                blank=True,
                choices=[("ONE", "1"), ("TWO", "2"), ("THREE", "3"), ("FOUR", "4"), ("FIVE", "5")],
                max_length=16,
                null=True,
                verbose_name="Tiering",
            ),
        ),
        migrations.AlterField(
            model_name="company",
            name="tier",
            field=models.CharField(
                blank=True,
                choices=[("ONE", "1"), ("TWO", "2"), ("THREE", "3"), ("FOUR", "4"), ("FIVE", "5")],
                max_length=16,
                null=True,
                verbose_name="Tier",
            ),
        ),
        migrations.RenameField(
            model_name="company",
            old_name="title",
            new_name="name",
        ),
        migrations.AlterField(
            model_name="company",
            name="name",
            field=models.CharField(max_length=255, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="person",
            name="formal",
            field=models.BooleanField(default=True, verbose_name="Formal"),
        ),
        migrations.CreateModel(
            name="ActivityParticipant",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "participation_status",
                    models.CharField(
                        blank=True,
                        choices=[
                            ("CANCELLED", "Cancelled"),
                            ("MAYBE", "Maybe"),
                            ("ATTENDS", "Attends"),
                            ("ATTENDS_DIGITALLY", "Attends Digitally"),
                        ],
                        default=None,
                        max_length=17,
                        null=True,
                    ),
                ),
                (
                    "activity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="wbcrm.activity", verbose_name="Activity"
                    ),
                ),
                (
                    "participant",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="wbcrm.person", verbose_name="Participant"
                    ),
                ),
            ],
            options={
                "verbose_name": "Activity Participant",
                "verbose_name_plural": "Activities Participants",
            },
        ),
        migrations.AddField(
            model_name="activity",
            name="participants",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of participants",
                related_name="participates",
                through="wbcrm.ActivityParticipant",
                to="wbcrm.person",
                verbose_name="Activity Participants",
            ),
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="activity",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="activity_participants",
                to="wbcrm.activity",
                verbose_name="Activity",
            ),
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="participant",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="activity_participants",
                to="wbcrm.person",
                verbose_name="Participant",
            ),
        ),
        migrations.CreateModel(
            name="CalendarItem",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("color", models.CharField(blank=True, max_length=7, null=True)),
                ("endpoint", models.CharField(blank=True, max_length=255, null=True)),
                ("icon", models.CharField(blank=True, max_length=64, null=True)),
                (
                    "is_private",
                    models.BooleanField(
                        default=False,
                        help_text="If this is checked only the participants, the assignee and the creator of this item can see this item.",
                        verbose_name="Private Mode",
                    ),
                ),
                (
                    "item_type",
                    models.CharField(
                        blank=True,
                        choices=[("ABSENCE_REQUEST", "Absence Request"), ("ACTIVITY", "Activity"), ("TASK", "Task")],
                        max_length=255,
                        null=True,
                        verbose_name="Type",
                    ),
                ),
                (
                    "period",
                    django.contrib.postgres.fields.ranges.DateTimeRangeField(
                        blank=True, null=True, verbose_name="Period"
                    ),
                ),
                ("title", models.CharField(max_length=255, verbose_name="Title")),
                ("entities", models.ManyToManyField(to="wbcrm.entry", verbose_name="Entities")),
                (
                    "conference_room",
                    models.BooleanField(
                        default=False,
                        help_text="Check this if it takes place in the conference room",
                        verbose_name="Conference Room",
                    ),
                ),
            ],
            options={
                "verbose_name": "Calendar Item",
                "verbose_name_plural": "Calendar Items",
            },
        ),
        migrations.RemoveField(
            model_name="activity",
            name="id",
        ),
        migrations.AddField(
            model_name="activity",
            name="calendaritem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="wbcrm.calendaritem",
            ),
        ),
        migrations.RemoveField(
            model_name="activity",
            name="title",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="conference_room",
        ),
        migrations.AddIndex(
            model_name="calendaritem",
            index=models.Index(fields=["period"], name="wbcrm_calen_period_0a0095_idx"),
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="conference_room",
            field=models.BooleanField(
                default=False,
                help_text="Check this if it takes place in the conference room",
                verbose_name="Conference Room",
            ),
        ),
        migrations.RunSQL(
            sql="SET CONSTRAINTS ALL IMMEDIATE;",
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="item_type",
            field=models.CharField(
                choices=[("ABSENCE_REQUEST", "Absence Request"), ("ACTIVITY", "Activity"), ("TASK", "Task")],
                default="ACTIVITY",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.RenameModel(
            old_name="PersonGroup",
            new_name="Group",
        ),
        migrations.AlterModelOptions(
            name="group",
            options={"verbose_name": "Group", "verbose_name_plural": "Groups"},
        ),
        migrations.AddField(
            model_name="group",
            name="members",
            field=models.ManyToManyField(related_name="groups", to="wbcrm.entry", verbose_name="Members"),
        ),
        migrations.AlterField(
            model_name="group",
            name="title",
            field=models.CharField(max_length=255, unique=True),
        ),
        migrations.AlterModelTable(
            name="group",
            table="crm_group",
        ),
        migrations.AddField(
            model_name="activity",
            name="groups",
            field=models.ManyToManyField(blank=True, related_name="activities_for_group", to="wbcrm.group"),
        ),
        migrations.RemoveField(
            model_name="group",
            name="persons",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="all_team",
        ),
        migrations.RemoveField(
            model_name="activitytype",
            name="color",
        ),
        migrations.AddField(
            model_name="activitytype",
            name="color",
            field=wbcore.contrib.color.fields.ColorField(default="#000000", verbose_name="Color"),
        ),
        migrations.RemoveField(
            model_name="calendaritem",
            name="color",
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="color",
            field=wbcore.contrib.color.fields.ColorField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="all_day",
            field=models.BooleanField(
                default=False, help_text="Check this if the activity span throughout the day", verbose_name="All Day"
            ),
        ),
        migrations.AddField(
            model_name="activity",
            name="online_meeting",
            field=models.BooleanField(
                default=False, help_text="Check this if it happens online", verbose_name="Online Meeting"
            ),
        ),
        migrations.RemoveField(
            model_name="activity",
            name="all_day",
        ),
        migrations.AddConstraint(
            model_name="activityparticipant",
            constraint=models.UniqueConstraint(fields=("activity", "participant"), name="unique_participant"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="profile_image",
            field=models.ImageField(blank=True, max_length=256, null=True, upload_to="crm/entry/profile_images"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="signature",
            field=models.ImageField(blank=True, max_length=256, null=True, upload_to="crm/entry/signatures"),
        ),
        migrations.AddField(
            model_name="entry",
            name="uuid",
            field=models.UUIDField(default=uuid.uuid4, editable=False),
        ),
        migrations.AlterField(
            model_name="entry",
            name="profile_image",
            field=models.ImageField(
                blank=True,
                max_length=256,
                null=True,
                upload_to=wbcore.contrib.directory.models.entries.upload_to_profile_images,
            ),
        ),
        migrations.AlterField(
            model_name="entry",
            name="signature",
            field=models.ImageField(
                blank=True,
                max_length=256,
                null=True,
                upload_to=wbcore.contrib.directory.models.entries.upload_to_signatures,
            ),
        ),
        migrations.AlterField(
            model_name="entry",
            name="uuid",
            field=models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
        ),
        migrations.AlterField(
            model_name="activity",
            name="recurrence_count",
            field=models.IntegerField(
                blank=True,
                help_text="Specifies how often an activity should be repeated excluding the original activity. Is mutually exclusive with the end date. Limited to a maximum of 365 recurrences.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(365),
                ],
                verbose_name="Recurrence Count",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="repeat_choice",
            field=models.CharField(
                choices=[
                    ("NEVER", "Never"),
                    ("RRULE:FREQ=DAILY;INTERVAL=1;WKST=MO;BYDAY=MO,TU,WE,TH,FR", "Business Daily"),
                    ("RRULE:FREQ=DAILY", "Daily"),
                    ("RRULE:FREQ=WEEKLY", "Weekly"),
                    ("RRULE:FREQ=WEEKLY;INTERVAL=2", "Bi-Weekly"),
                    ("RRULE:FREQ=MONTHLY", "Monthly"),
                    ("RRULE:FREQ=MONTHLY;INTERVAL=3", "Quarterly"),
                    ("RRULE:FREQ=YEARLY", "Annually"),
                ],
                default="NEVER",
                help_text="Repeat activity at the specified frequency",
                max_length=56,
                verbose_name="Frequency",
            ),
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="entities",
            field=models.ManyToManyField(related_name="calendar_entities", to="wbcrm.entry", verbose_name="Entities"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies participating",
                related_name="company_participates",
                to="wbcrm.company",
                verbose_name="Participating Companies",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="disable_participant_check",
            field=models.BooleanField(default=False, verbose_name="Without Participating Company"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="participants",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of participants",
                related_name="participates",
                through="wbcrm.ActivityParticipant",
                to="wbcrm.person",
                verbose_name="Participating Persons",
            ),
        ),
        migrations.CreateModel(
            name="Specialization",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, unique=True, verbose_name="Title")),
                (
                    "slugify_title",
                    models.CharField(
                        blank=True, max_length=128, null=True, unique=True, verbose_name="Slugified Title"
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="person",
            name="specializations",
            field=models.ManyToManyField(blank=True, to="wbcrm.specialization", verbose_name="Specializations"),
        ),
        migrations.AddField(
            model_name="entry",
            name="deletion_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="entry",
            name="is_active",
            field=models.BooleanField(default=True),
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="slugify_search_name",
            new_name="slugify_computed_str",
        ),
        migrations.RenameField(
            model_name="entry",
            old_name="search_name",
            new_name="computed_str",
        ),
        migrations.AlterField(
            model_name="entry",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AddField(
            model_name="person",
            name="initials",
            field=models.CharField(blank=True, max_length=4, null=True, verbose_name="Initials"),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="entity_list",
            field=models.JSONField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="visibility",
            field=models.CharField(
                choices=[("PUBLIC", "Public"), ("PRIVATE", "Private"), ("CONFIDENTIAL", "Confidential")],
                default="PUBLIC",
                help_text="Set to private for the activity to hide sensitive information from anyone but the assignee and participants. Set to confidential to hide from anyone but people with manager permissions.",
                max_length=255,
                verbose_name="Visibility",
            ),
        ),
        migrations.RemoveField(
            model_name="calendaritem",
            name="is_private",
        ),
        migrations.AlterField(
            model_name="activitytype",
            name="icon",
            field=models.CharField(
                choices=[
                    ("wb-icon-action", "wb-icon-action"),
                    ("wb-icon-arrows-swap-1", "wb-icon-arrows-swap-1"),
                    ("wb-icon-arrows-swap-2", "wb-icon-arrows-swap-2"),
                    ("wb-icon-arrow-down", "wb-icon-arrow-down"),
                    ("wb-icon-arrow-left", "wb-icon-arrow-left"),
                    ("wb-icon-arrow-right", "wb-icon-arrow-right"),
                    ("wb-icon-arrow-up", "wb-icon-arrow-up"),
                    ("wb-icon-bank", "wb-icon-bank"),
                    ("wb-icon-bell-inverted", "wb-icon-bell-inverted"),
                    ("wb-icon-bell", "wb-icon-bell"),
                    ("wb-icon-bold", "wb-icon-bold"),
                    ("wb-icon-bookmark", "wb-icon-bookmark"),
                    ("wb-icon-bookmark-inverted", "wb-icon-bookmark-inverted"),
                    ("wb-icon-bulleted-list", "wb-icon-bulleted-list"),
                    ("wb-icon-cake-1", "wb-icon-cake-1"),
                    ("wb-icon-cake-2", "wb-icon-cake-2"),
                    ("wb-icon-cake-3", "wb-icon-cake-3"),
                    ("wb-icon-calendar-1", "wb-icon-calendar-1"),
                    ("wb-icon-calendar-2", "wb-icon-calendar-2"),
                    ("wb-icon-calendar-3", "wb-icon-calendar-3"),
                    ("wb-icon-camera-1", "wb-icon-camera-1"),
                    ("wb-icon-camera-2", "wb-icon-camera-2"),
                    ("wb-icon-chart-bars-1", "wb-icon-chart-bars-1"),
                    ("wb-icon-chart-bars-2", "wb-icon-chart-bars-2"),
                    ("wb-icon-chart-bars-3", "wb-icon-chart-bars-3"),
                    ("wb-icon-chart-bars-4", "wb-icon-chart-bars-4"),
                    ("wb-icon-chart-line-2", "wb-icon-chart-line-2"),
                    ("wb-icon-chart-pie", "wb-icon-chart-pie"),
                    ("wb-icon-chart-piramid", "wb-icon-chart-piramid"),
                    ("wb-icon-chart-switches", "wb-icon-chart-switches"),
                    ("wb-icon-circle-check", "wb-icon-circle-check"),
                    ("wb-icon-circle-exclamation", "wb-icon-circle-exclamation"),
                    ("wb-icon-circle-exclamation-inverted", "wb-icon-circle-exclamation-inverted"),
                    ("wb-icon-circle-x-inverted", "wb-icon-circle-x-inverted"),
                    ("wb-icon-circle-question", "wb-icon-circle-question"),
                    ("wb-icon-circle-question-inverted", "wb-icon-circle-question-inverted"),
                    ("wb-icon-circle-x", "wb-icon-circle-x"),
                    ("wb-icon-circle-check-inverted", "wb-icon-circle-check-inverted"),
                    ("wb-icon-clipboard-1", "wb-icon-clipboard-1"),
                    ("wb-icon-clipboard-2", "wb-icon-clipboard-2"),
                    ("wb-icon-clipboard-3", "wb-icon-clipboard-3"),
                    ("wb-icon-clipboard-4", "wb-icon-clipboard-4"),
                    ("wb-icon-clipboard-checks-1", "wb-icon-clipboard-checks-1"),
                    ("wb-icon-clipboard-checks-2", "wb-icon-clipboard-checks-2"),
                    ("wb-icon-clock-2", "wb-icon-clock-2"),
                    ("wb-icon-clock-1", "wb-icon-clock-1"),
                    ("wb-icon-clock-3", "wb-icon-clock-3"),
                    ("wb-icon-clock-alarm", "wb-icon-clock-alarm"),
                    ("wb-icon-gear-6", "wb-icon-gear-6"),
                    ("wb-icon-contact-book", "wb-icon-contact-book"),
                    ("wb-icon-copy-1", "wb-icon-copy-1"),
                    ("wb-icon-copy-2", "wb-icon-copy-2"),
                    ("wb-icon-copy-3", "wb-icon-copy-3"),
                    ("wb-icon-copy-4", "wb-icon-copy-4"),
                    ("wb-icon-copy-5", "wb-icon-copy-5"),
                    ("wb-icon-copy-6", "wb-icon-copy-6"),
                    ("wb-icon-copy-7", "wb-icon-copy-7"),
                    ("wb-icon-copy-fat-1", "wb-icon-copy-fat-1"),
                    ("wb-icon-copy-fat-2", "wb-icon-copy-fat-2"),
                    ("wb-icon-copy-fat-3", "wb-icon-copy-fat-3"),
                    ("wb-icon-copy-fat-4", "wb-icon-copy-fat-4"),
                    ("wb-icon-copy-fat-5", "wb-icon-copy-fat-5"),
                    ("wb-icon-crosshair", "wb-icon-crosshair"),
                    ("wb-icon-dashboard-2", "wb-icon-dashboard-2"),
                    ("wb-icon-dashboard-1", "wb-icon-dashboard-1"),
                    ("wb-icon-data-grid-3", "wb-icon-data-grid-3"),
                    ("wb-icon-data-grid-1", "wb-icon-data-grid-1"),
                    ("wb-icon-data-grid-2", "wb-icon-data-grid-2"),
                    ("wb-icon-data-grid-4", "wb-icon-data-grid-4"),
                    ("wb-icon-data-grid-5", "wb-icon-data-grid-5"),
                    ("wb-icon-data-list-2", "wb-icon-data-list-2"),
                    ("wb-icon-data-list-3", "wb-icon-data-list-3"),
                    ("wb-icon-data-list-4", "wb-icon-data-list-4"),
                    ("wb-icon-data-list-5", "wb-icon-data-list-5"),
                    ("wb-icon-data-list-6", "wb-icon-data-list-6"),
                    ("wb-icon-data-list-7", "wb-icon-data-list-7"),
                    ("wb-icon-dedent", "wb-icon-dedent"),
                    ("wb-icon-disabled", "wb-icon-disabled"),
                    ("wb-icon-document-1", "wb-icon-document-1"),
                    ("wb-icon-document-2", "wb-icon-document-2"),
                    ("wb-icon-document-book", "wb-icon-document-book"),
                    ("wb-icon-document-gear", "wb-icon-document-gear"),
                    ("wb-icon-document-lock", "wb-icon-document-lock"),
                    ("wb-icon-dollar", "wb-icon-dollar"),
                    ("wb-icon-edit-2", "wb-icon-edit-2"),
                    ("wb-icon-edit-3", "wb-icon-edit-3"),
                    ("wb-icon-envelope", "wb-icon-envelope"),
                    ("wb-icon-envelope-open-1", "wb-icon-envelope-open-1"),
                    ("wb-icon-envelope-open-2", "wb-icon-envelope-open-2"),
                    ("wb-icon-envelope-open-dollar", "wb-icon-envelope-open-dollar"),
                    ("wb-icon-envelope-open-euro", "wb-icon-envelope-open-euro"),
                    ("wb-icon-envelope-open-suitcase", "wb-icon-envelope-open-suitcase"),
                    ("wb-icon-envelope-open-3", "wb-icon-envelope-open-3"),
                    ("wb-icon-envelope-open-person", "wb-icon-envelope-open-person"),
                    ("wb-icon-euro", "wb-icon-euro"),
                    ("wb-icon-eye", "wb-icon-eye"),
                    ("wb-icon-eye-crossed", "wb-icon-eye-crossed"),
                    ("wb-icon-female", "wb-icon-female"),
                    ("wb-icon-filters-1", "wb-icon-filters-1"),
                    ("wb-icon-filters-2", "wb-icon-filters-2"),
                    ("wb-icon-filters-off-1", "wb-icon-filters-off-1"),
                    ("wb-icon-filters-off-2", "wb-icon-filters-off-2"),
                    ("wb-icon-filters-off-3", "wb-icon-filters-off-3"),
                    ("wb-icon-floppy-disk", "wb-icon-floppy-disk"),
                    ("wb-icon-floppy-disk-check", "wb-icon-floppy-disk-check"),
                    ("wb-icon-floppy-disk-x", "wb-icon-floppy-disk-x"),
                    ("wb-icon-folder", "wb-icon-folder"),
                    ("wb-icon-folders", "wb-icon-folders"),
                    ("wb-icon-folder-euro", "wb-icon-folder-euro"),
                    ("wb-icon-folder-inverted", "wb-icon-folder-inverted"),
                    ("wb-icon-folder-plus", "wb-icon-folder-plus"),
                    ("wb-icon-folder-plus-inverted", "wb-icon-folder-plus-inverted"),
                    ("wb-icon-font-color", "wb-icon-font-color"),
                    ("wb-icon-gear-1", "wb-icon-gear-1"),
                    ("wb-icon-gear-2", "wb-icon-gear-2"),
                    ("wb-icon-gear-3", "wb-icon-gear-3"),
                    ("wb-icon-gear-4", "wb-icon-gear-4"),
                    ("wb-icon-gear-5", "wb-icon-gear-5"),
                    ("wb-icon-gear-7", "wb-icon-gear-7"),
                    ("wb-icon-globe-1", "wb-icon-globe-1"),
                    ("wb-icon-globe-2", "wb-icon-globe-2"),
                    ("wb-icon-handshake", "wb-icon-handshake"),
                    ("wb-icon-handshake-euro", "wb-icon-handshake-euro"),
                    ("wb-icon-home", "wb-icon-home"),
                    ("wb-icon-hourglass-empty", "wb-icon-hourglass-empty"),
                    ("wb-icon-hourglass-full", "wb-icon-hourglass-full"),
                    ("wb-icon-hourglass-middle", "wb-icon-hourglass-middle"),
                    ("wb-icon-image", "wb-icon-image"),
                    ("wb-icon-indent", "wb-icon-indent"),
                    ("wb-icon-circle-info", "wb-icon-circle-info"),
                    ("wb-icon-italic", "wb-icon-italic"),
                    ("wb-icon-link", "wb-icon-link"),
                    ("wb-icon-lock-closed-2", "wb-icon-lock-closed-2"),
                    ("wb-icon-lock-closed-1", "wb-icon-lock-closed-1"),
                    ("wb-icon-lock-closed-3", "wb-icon-lock-closed-3"),
                    ("wb-icon-lock-open-2", "wb-icon-lock-open-2"),
                    ("wb-icon-lock-open-1", "wb-icon-lock-open-1"),
                    ("wb-icon-lock-open-3", "wb-icon-lock-open-3"),
                    ("wb-icon-lunch", "wb-icon-lunch"),
                    ("wb-icon-male", "wb-icon-male"),
                    ("wb-icon-man-1", "wb-icon-man-1"),
                    ("wb-icon-man-2", "wb-icon-man-2"),
                    ("wb-icon-man-3", "wb-icon-man-3"),
                    ("wb-icon-man-4", "wb-icon-man-4"),
                    ("wb-icon-man-5", "wb-icon-man-5"),
                    ("wb-icon-man-6", "wb-icon-man-6"),
                    ("wb-icon-man-7", "wb-icon-man-7"),
                    ("wb-icon-maximize-3", "wb-icon-maximize-3"),
                    ("wb-icon-maximize-1", "wb-icon-maximize-1"),
                    ("wb-icon-maximize-2", "wb-icon-maximize-2"),
                    ("wb-icon-data-list-1", "wb-icon-data-list-1"),
                    ("wb-icon-minimize-4", "wb-icon-minimize-4"),
                    ("wb-icon-minimize-1", "wb-icon-minimize-1"),
                    ("wb-icon-minimize-2", "wb-icon-minimize-2"),
                    ("wb-icon-minimize-3", "wb-icon-minimize-3"),
                    ("wb-icon-notebook", "wb-icon-notebook"),
                    ("wb-icon-notebook-inverted", "wb-icon-notebook-inverted"),
                    ("wb-icon-numbered-list", "wb-icon-numbered-list"),
                    ("wb-icon-page-break", "wb-icon-page-break"),
                    ("wb-icon-edit-1", "wb-icon-edit-1"),
                    ("wb-icon-people", "wb-icon-people"),
                    ("wb-icon-person", "wb-icon-person"),
                    ("wb-icon-phone", "wb-icon-phone"),
                    ("wb-icon-phone-call", "wb-icon-phone-call"),
                    ("wb-icon-pin", "wb-icon-pin"),
                    ("wb-icon-pipette-empty", "wb-icon-pipette-empty"),
                    ("wb-icon-pipette-full", "wb-icon-pipette-full"),
                    ("wb-icon-plus", "wb-icon-plus"),
                    ("wb-icon-quote", "wb-icon-quote"),
                    ("wb-icon-recorder", "wb-icon-recorder"),
                    ("wb-icon-redo", "wb-icon-redo"),
                    ("wb-icon-refresh-1", "wb-icon-refresh-1"),
                    ("wb-icon-refresh-2", "wb-icon-refresh-2"),
                    ("wb-icon-refresh-24-acw", "wb-icon-refresh-24-acw"),
                    ("wb-icon-refresh-24-cw", "wb-icon-refresh-24-cw"),
                    ("wb-icon-refresh-3-acw", "wb-icon-refresh-3-acw"),
                    ("wb-icon-refresh-3-cw", "wb-icon-refresh-3-cw"),
                    ("wb-icon-refresh-clock", "wb-icon-refresh-clock"),
                    ("wb-icon-refresh-dots", "wb-icon-refresh-dots"),
                    ("wb-icon-refresh-dots-24", "wb-icon-refresh-dots-24"),
                    ("wb-icon-refresh-dots-gear", "wb-icon-refresh-dots-gear"),
                    ("wb-icon-refresh-three", "wb-icon-refresh-three"),
                    ("wb-icon-remove-formatting", "wb-icon-remove-formatting"),
                    ("wb-icon-arrows-replace", "wb-icon-arrows-replace"),
                    ("wb-icon-scissors", "wb-icon-scissors"),
                    ("wb-icon-search", "wb-icon-search"),
                    ("wb-icon-send", "wb-icon-send"),
                    ("wb-icon-sick-leave-1", "wb-icon-sick-leave-1"),
                    ("wb-icon-sick-leave-2", "wb-icon-sick-leave-2"),
                    ("wb-icon-sick-leave-3", "wb-icon-sick-leave-3"),
                    ("wb-icon-sick-leave-4", "wb-icon-sick-leave-4"),
                    ("wb-icon-share-1", "wb-icon-share-1"),
                    ("wb-icon-share-2", "wb-icon-share-2"),
                    ("wb-icon-skype", "wb-icon-skype"),
                    ("wb-icon-from-a-to-z", "wb-icon-from-a-to-z"),
                    ("wb-icon-from-z-to-a", "wb-icon-from-z-to-a"),
                    ("wb-icon-sound-off", "wb-icon-sound-off"),
                    ("wb-icon-sound-on", "wb-icon-sound-on"),
                    ("wb-icon-speech-bubble", "wb-icon-speech-bubble"),
                    ("wb-icon-spell-check", "wb-icon-spell-check"),
                    ("wb-icon-star", "wb-icon-star"),
                    ("wb-icon-chart-line-1", "wb-icon-chart-line-1"),
                    ("wb-icon-step-back-2", "wb-icon-step-back-2"),
                    ("wb-icon-step-forward-2", "wb-icon-step-forward-2"),
                    ("wb-icon-step-back-1", "wb-icon-step-back-1"),
                    ("wb-icon-step-forward-1", "wb-icon-step-forward-1"),
                    ("wb-icon-strikethrough", "wb-icon-strikethrough"),
                    ("wb-icon-subscript", "wb-icon-subscript"),
                    ("wb-icon-suitcase-1", "wb-icon-suitcase-1"),
                    ("wb-icon-suitcase-2", "wb-icon-suitcase-2"),
                    ("wb-icon-superscript", "wb-icon-superscript"),
                    ("wb-icon-table", "wb-icon-table"),
                    ("wb-icon-text-align-center", "wb-icon-text-align-center"),
                    ("wb-icon-text-align-justify", "wb-icon-text-align-justify"),
                    ("wb-icon-text-align-left", "wb-icon-text-align-left"),
                    ("wb-icon-text-align-right", "wb-icon-text-align-right"),
                    ("wb-icon-text-bg-color", "wb-icon-text-bg-color"),
                    ("wb-icon-thumb-down", "wb-icon-thumb-down"),
                    ("wb-icon-thumb-up", "wb-icon-thumb-up"),
                    ("wb-icon-trade", "wb-icon-trade"),
                    ("wb-icon-trashbin-2", "wb-icon-trashbin-2"),
                    ("wb-icon-trashbin-1", "wb-icon-trashbin-1"),
                    ("wb-icon-triangles-down", "wb-icon-triangles-down"),
                    ("wb-icon-triangles-left", "wb-icon-triangles-left"),
                    ("wb-icon-triangles-left-stop", "wb-icon-triangles-left-stop"),
                    ("wb-icon-triangles-right", "wb-icon-triangles-right"),
                    ("wb-icon-triangles-right-stop", "wb-icon-triangles-right-stop"),
                    ("wb-icon-triangles-up", "wb-icon-triangles-up"),
                    ("wb-icon-triangle-down", "wb-icon-triangle-down"),
                    ("wb-icon-triangle-left", "wb-icon-triangle-left"),
                    ("wb-icon-triangle-right", "wb-icon-triangle-right"),
                    ("wb-icon-triangle-up", "wb-icon-triangle-up"),
                    ("wb-icon-underline", "wb-icon-underline"),
                    ("wb-icon-undo", "wb-icon-undo"),
                    ("wb-icon-unlink", "wb-icon-unlink"),
                    ("wb-icon-woman-1", "wb-icon-woman-1"),
                    ("wb-icon-woman-2", "wb-icon-woman-2"),
                    ("wb-icon-woman-3", "wb-icon-woman-3"),
                    ("wb-icon-woman-4", "wb-icon-woman-4"),
                    ("wb-icon-woman-5", "wb-icon-woman-5"),
                    ("wb-icon-woman-6", "wb-icon-woman-6"),
                    ("wb-icon-woman-7", "wb-icon-woman-7"),
                    ("wb-icon-x", "wb-icon-x"),
                ],
                default="wb-icon-gear-1",
                max_length=128,
                verbose_name="Icon",
            ),
        ),
        migrations.AlterModelOptions(
            name="calendaritem",
            options={
                "permissions": [("administrate_confidential_items", "Can see confidential calendar items")],
                "verbose_name": "Calendar Item",
                "verbose_name_plural": "Calendar Items",
            },
        ),
        migrations.AlterModelOptions(
            name="activityparticipant",
            options={"verbose_name": "Activity's Participant", "verbose_name_plural": "Activities' Participants"},
        ),
        migrations.AlterModelOptions(
            name="position",
            options={"verbose_name": "Position", "verbose_name_plural": "Positions"},
        ),
        migrations.AlterModelOptions(
            name="specialization",
            options={"verbose_name": "Specialization", "verbose_name_plural": "Specializations"},
        ),
        migrations.AlterField(
            model_name="activity",
            name="groups",
            field=models.ManyToManyField(
                blank=True, related_name="activities_for_group", to="wbcrm.group", verbose_name="Groups"
            ),
        ),
        migrations.AlterField(
            model_name="activitytype",
            name="score",
            field=models.CharField(
                choices=[("4.0", "High"), ("3.0", "Medium"), ("2.0", "Low"), ("0.0", "None")],
                default="2.0",
                help_text="Used for the activity heat calculation. Multipliers range from low (i.e. e-mail) to medium (i.e. call) and high (i.e. meeting).",
                max_length=8,
                verbose_name="Activity Heat Multiplier",
            ),
        ),
        migrations.AlterField(
            model_name="activitytype",
            name="title",
            field=models.CharField(max_length=128, unique=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="addresscontact",
            name="street_additional",
            field=models.CharField(blank=True, max_length=255, null=True, verbose_name="Street (Additional)"),
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="all_day",
            field=models.BooleanField(
                default=False, help_text="Check this if the activity spans throughout the day", verbose_name="All Day"
            ),
        ),
        migrations.AlterField(
            model_name="company",
            name="discretionairy_advisory",
            field=models.FloatField(default=0.0, verbose_name="Discretionary Advisory"),
        ),
        migrations.AlterField(
            model_name="companytype",
            name="title",
            field=models.CharField(max_length=128, unique=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="customerstatus",
            name="title",
            field=models.CharField(max_length=32, unique=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="relationships",
            field=models.ManyToManyField(
                blank=True, through="wbcrm.Relationship", to="wbcrm.entry", verbose_name="The Entry's Relationships"
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="employers",
            field=models.ManyToManyField(
                blank=True,
                help_text="The person's employers",
                related_name="employees",
                through="wbcrm.EmployerEmployeeRelationship",
                to="wbcrm.company",
                verbose_name="Employers",
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="personality_profile_blue",
            field=models.FloatField(
                default=0,
                validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)],
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="personality_profile_green",
            field=models.FloatField(
                default=0,
                validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)],
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="personality_profile_red",
            field=models.FloatField(
                default=0,
                validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(1)],
            ),
        ),
        migrations.AlterField(
            model_name="person",
            name="prefix",
            field=models.CharField(
                choices=[
                    ("MR", "Mr."),
                    ("MRS", "Mrs."),
                    ("PROF", "Prof."),
                    ("DR", "Dr."),
                    ("MED", "Med."),
                    ("ME", "Me."),
                ],
                max_length=4,
                verbose_name="Prefix",
            ),
        ),
        migrations.AlterField(
            model_name="position",
            name="title",
            field=models.CharField(max_length=128, unique=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="visibility",
            field=models.CharField(
                choices=[("PUBLIC", "Public"), ("PRIVATE", "Private"), ("CONFIDENTIAL", "Confidential")],
                default="PUBLIC",
                max_length=255,
                verbose_name="Visibility",
            ),
        ),
        migrations.AlterField(
            model_name="activitytype",
            name="icon",
            field=wbcore.contrib.icons.models.IconField(default="wb-icon-gear-1", max_length=128, verbose_name="Icon"),
        ),
        migrations.AddField(
            model_name="activityparticipant",
            name="status_changed",
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="participation_status",
            field=django_fsm.FSMField(
                choices=[
                    ("CANCELLED", "Cancelled"),
                    ("MAYBE", "Maybe"),
                    ("ATTENDS", "Attends"),
                    ("NOTRESPONDED", "Not Responded"),
                ],
                default="NOTRESPONDED",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="participation_status",
            field=django_fsm.FSMField(
                choices=[
                    ("CANCELLED", "Cancelled"),
                    ("MAYBE", "Maybe"),
                    ("ATTENDS", "Attends"),
                    ("NOTRESPONDED", "Not Responded"),
                ],
                default="NOTRESPONDED",
                max_length=50,
                verbose_name="Participation Status",
            ),
        ),
        migrations.AlterField(
            model_name="group",
            name="title",
            field=models.CharField(max_length=255, unique=True, verbose_name="Title"),
        ),
        migrations.AlterField(
            model_name="entry",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="deletion_datetime",
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="is_active",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="calendaritem",
            name="is_cancelled",
            field=models.BooleanField(default=False, verbose_name="Is Cancelled"),
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_day",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_month",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_quarter",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_week",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_week_day",
        ),
        migrations.RemoveField(
            model_name="activity",
            name="unplanned_year",
        ),
        migrations.AlterField(
            model_name="calendaritem",
            name="item_type",
            field=models.CharField(
                choices=[
                    ("ABSENCE_REQUEST", "Absence Request"),
                    ("HOLIDAY", "Holiday"),
                    ("ACTIVITY", "Activity"),
                    ("TASK", "Task"),
                ],
                default="ACTIVITY",
                max_length=255,
                verbose_name="Type",
            ),
        ),
        migrations.AddField(
            model_name="bankingcontact",
            name="edited",
            field=models.DateTimeField(auto_now=True, verbose_name="Edited"),
        ),
        migrations.AlterField(
            model_name="activitytype",
            name="icon",
            field=wbcore.contrib.icons.models.IconField(default="EVENT", max_length=128, verbose_name="Icon"),
        ),
        migrations.AddField(
            model_name="entry",
            name="external_identfier",
            field=models.CharField(blank=True, max_length=128, null=True),
        ),
        migrations.CreateModel(
            name="SocialMediaContact",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "location",
                    models.CharField(
                        choices=[("WORK", "Work"), ("PRIVATE", "Private"), ("HOME", "Home"), ("OTHER", "Other")],
                        default="WORK",
                        max_length=32,
                        verbose_name="Location",
                    ),
                ),
                ("primary", models.BooleanField(default=False, verbose_name="Primary")),
                (
                    "platform",
                    models.CharField(
                        choices=[
                            ("FACEBOOK", "Facebook"),
                            ("INSTAGRAM", "Instagram"),
                            ("LINKEDIN", "LinkedIn"),
                            ("REDDIT", "Reddit"),
                            ("TIKTOK", "TikTok"),
                            ("TUMBLR", "Tumblr"),
                            ("TWITTER", "Twitter"),
                            ("XING", "Xing"),
                        ],
                        help_text="The social media platform for this contact",
                        max_length=32,
                        verbose_name="Platform",
                    ),
                ),
                ("url", models.URLField(verbose_name="URL")),
                (
                    "entry",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="social_media",
                        to="wbcrm.entry",
                        verbose_name="Entry",
                    ),
                ),
            ],
            options={
                "verbose_name": "Social Media Contact",
                "verbose_name_plural": "Social Media Contacts",
                "db_table": "crm_socialmedia",
            },
        ),
        migrations.DeleteModel(
            name="Event",
        ),
        migrations.DeleteModel(
            name="EventType",
        ),
        migrations.AlterField(
            model_name="activity",
            name="groups",
            field=models.ManyToManyField(
                blank=True,
                help_text="Each member of the group will be added to the list of participants and companies automatically.",
                related_name="activities_for_group",
                to="wbcrm.group",
                verbose_name="Groups",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="reminder_choice",
            field=models.CharField(
                choices=[
                    ("NEVER", "Never"),
                    ("EVENT_TIME", "At time of event"),
                    ("MINUTES_5", "5 minutes before"),
                    ("MINUTES_15", "15 minutes before"),
                    ("MINUTES_30", "30 minutes before"),
                    ("HOURS_1", "1 hour before"),
                    ("HOURS_2", "2 hour before"),
                    ("HOURS_12", "12 hour before"),
                    ("WEEKS_1", "1 week before"),
                ],
                default="MINUTES_15",
                help_text="Sends a mail and system notification to all participating internal employees before the start of the activity.",
                max_length=16,
                verbose_name="Reminder",
            ),
        ),
        migrations.AddField(
            model_name="relationship",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AddField(
            model_name="clientmanagerrelationship",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.AlterField(
            model_name="activity",
            name="recurrence_count",
            field=models.IntegerField(
                blank=True,
                help_text="Specifies how often an activity should be repeated excluding the original activity. Is mutually exclusive with the end date. Limited to a maximum of 365 recurrences.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(1),
                    django.core.validators.MaxValueValidator(365),
                ],
                verbose_name="Count",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="recurrence_end",
            field=models.DateField(
                blank=True,
                help_text="Specifies until when an event is to be repeated. Is mutually exclusive with the Recurrence Count.",
                null=True,
                verbose_name="Date",
            ),
        ),
        migrations.AddField(
            model_name="emailcontact",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128, verbose_name="Title")),
                (
                    "slugify_title",
                    models.CharField(blank=True, max_length=128, null=True, verbose_name="Slugified Title"),
                ),
                (
                    "is_competitor",
                    models.BooleanField(
                        default=False,
                        help_text="Indicates wether this is a competitor's product",
                        verbose_name="Is Competitor",
                    ),
                ),
            ],
            options={
                "verbose_name": "Product",
                "verbose_name_plural": "Products",
                "unique_together": {("slugify_title", "is_competitor")},
            },
        ),
        migrations.AddField(
            model_name="company",
            name="interested_competitors_products",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to={"is_competitor": True},
                related_name="competitor_prospects",
                to="wbcrm.product",
                verbose_name="Interested Competitors' Products",
            ),
        ),
        migrations.AddField(
            model_name="company",
            name="interested_products",
            field=models.ManyToManyField(
                blank=True,
                limit_choices_to={"is_competitor": False},
                related_name="prospects",
                to="wbcrm.product",
                verbose_name="Interested Products",
            ),
        ),
        migrations.AlterModelTable(
            name="activity",
            table=None,
        ),
        migrations.AlterModelTable(
            name="addresscontact",
            table=None,
        ),
        migrations.AlterModelTable(
            name="bankingcontact",
            table=None,
        ),
        migrations.AlterModelTable(
            name="company",
            table=None,
        ),
        migrations.AlterModelTable(
            name="emailcontact",
            table=None,
        ),
        migrations.AlterModelTable(
            name="entry",
            table=None,
        ),
        migrations.AlterModelTable(
            name="group",
            table=None,
        ),
        migrations.AlterModelTable(
            name="person",
            table=None,
        ),
        migrations.AlterModelTable(
            name="socialmediacontact",
            table=None,
        ),
        migrations.AlterModelTable(
            name="telephonecontact",
            table=None,
        ),
        migrations.AlterModelTable(
            name="websitecontact",
            table=None,
        ),
        migrations.AddField(
            model_name="addresscontact",
            name="geography_city",
            field=models.ForeignKey(
                blank=True,
                limit_choices_to={"level": 3},
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="contact_city",
                to="geography.geography",
                verbose_name="City",
            ),
        ),
        migrations.RemoveField(
            model_name="company",
            name="interested_competitors_products",
        ),
        migrations.RemoveField(
            model_name="company",
            name="interested_products",
        ),
        migrations.RemoveField(
            model_name="bankingcontact",
            name="entry",
        ),
        migrations.RemoveField(
            model_name="calendaritem",
            name="entities",
        ),
        migrations.RemoveField(
            model_name="clientmanagerrelationship",
            name="client",
        ),
        migrations.RemoveField(
            model_name="clientmanagerrelationship",
            name="relationship_manager",
        ),
        migrations.RemoveField(
            model_name="company",
            name="customer_status",
        ),
        migrations.RemoveField(
            model_name="company",
            name="entry_ptr",
        ),
        migrations.RemoveField(
            model_name="company",
            name="type",
        ),
        migrations.RemoveField(
            model_name="emailcontact",
            name="entry",
        ),
        migrations.RemoveField(
            model_name="employeremployeerelationship",
            name="employee",
        ),
        migrations.RemoveField(
            model_name="employeremployeerelationship",
            name="employer",
        ),
        migrations.RemoveField(
            model_name="employeremployeerelationship",
            name="position",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="last_activity",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="relationship_managers",
        ),
        migrations.RemoveField(
            model_name="entry",
            name="relationships",
        ),
        migrations.RemoveField(
            model_name="person",
            name="employers",
        ),
        migrations.RemoveField(
            model_name="person",
            name="entry_ptr",
        ),
        migrations.RemoveField(
            model_name="person",
            name="specializations",
        ),
        migrations.RemoveField(
            model_name="relationship",
            name="from_entry",
        ),
        migrations.RemoveField(
            model_name="relationship",
            name="relationship_type",
        ),
        migrations.RemoveField(
            model_name="relationship",
            name="to_entry",
        ),
        migrations.RemoveField(
            model_name="relationshiptype",
            name="counter_relationship",
        ),
        migrations.RemoveField(
            model_name="socialmediacontact",
            name="entry",
        ),
        migrations.RemoveField(
            model_name="telephonecontact",
            name="entry",
        ),
        migrations.RemoveField(
            model_name="websitecontact",
            name="entry",
        ),
        migrations.AlterField(
            model_name="activity",
            name="assigned_to",
            field=models.ForeignKey(
                blank=True,
                help_text="The person in charge of handling this activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="activities",
                to="directory.person",
                verbose_name="Assigned to",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="calendaritem_ptr",
            field=models.OneToOneField(
                auto_created=True,
                on_delete=django.db.models.deletion.CASCADE,
                parent_link=True,
                primary_key=True,
                serialize=False,
                to="agenda.calendaritem",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="companies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of companies participating",
                related_name="company_participates",
                to="directory.company",
                verbose_name="Participating Companies",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="creator",
            field=models.ForeignKey(
                blank=True,
                help_text="The creator of this activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="activities_owned",
                to="directory.person",
                verbose_name="Creator",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="latest_reviewer",
            field=models.ForeignKey(
                blank=True,
                help_text="The latest person to review the activity",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="activities_reviewed",
                to="directory.person",
                verbose_name="Latest Reviewer",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="participants",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of participants",
                related_name="participates",
                through="wbcrm.ActivityParticipant",
                to="directory.person",
                verbose_name="Participating Persons",
            ),
        ),
        migrations.AlterField(
            model_name="activity",
            name="type",
            field=models.ForeignKey(
                default=wbcrm.models.activities.ActivityType.get_default_activity_type,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="activity",
                to="wbcrm.activitytype",
                verbose_name="Type",
            ),
        ),
        migrations.AlterField(
            model_name="activityparticipant",
            name="participant",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="activity_participants",
                to="directory.person",
                verbose_name="Participant",
            ),
        ),
        migrations.AlterField(
            model_name="group",
            name="members",
            field=models.ManyToManyField(related_name="groups", to="directory.entry", verbose_name="Members"),
        ),
        migrations.DeleteModel(
            name="AddressContact",
        ),
        migrations.DeleteModel(
            name="BankingContact",
        ),
        migrations.DeleteModel(
            name="CalendarItem",
        ),
        migrations.DeleteModel(
            name="ClientManagerRelationship",
        ),
        migrations.DeleteModel(
            name="Company",
        ),
        migrations.DeleteModel(
            name="CompanyType",
        ),
        migrations.DeleteModel(
            name="CustomerStatus",
        ),
        migrations.DeleteModel(
            name="EmailContact",
        ),
        migrations.DeleteModel(
            name="EmployerEmployeeRelationship",
        ),
        migrations.DeleteModel(
            name="Position",
        ),
        migrations.DeleteModel(
            name="Relationship",
        ),
        migrations.DeleteModel(
            name="RelationshipType",
        ),
        migrations.DeleteModel(
            name="SocialMediaContact",
        ),
        migrations.DeleteModel(
            name="Specialization",
        ),
        migrations.DeleteModel(
            name="TelephoneContact",
        ),
        migrations.DeleteModel(
            name="WebsiteContact",
        ),
        migrations.DeleteModel(
            name="Person",
        ),
        migrations.DeleteModel(
            name="Entry",
        ),
        migrations.CreateModel(
            name="ProductCompanyRelationship",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "company",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_company_relationships",
                        to="directory.company",
                        verbose_name="Company",
                    ),
                ),
                (
                    "product",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="product_company_relationships",
                        to="wbcrm.product",
                        verbose_name="Product",
                    ),
                ),
            ],
            options={
                "verbose_name": "Company-Product Relationship",
                "verbose_name_plural": "Company-Product Relationships",
            },
        ),
        migrations.AddField(
            model_name="product",
            name="prospects",
            field=models.ManyToManyField(
                blank=True,
                help_text="The list of prospects",
                related_name="interested_products",
                through="wbcrm.ProductCompanyRelationship",
                to="directory.company",
                verbose_name="Prospects",
            ),
        ),
        migrations.AddConstraint(
            model_name="productcompanyrelationship",
            constraint=models.UniqueConstraint(
                fields=("product", "company"), name="unique_company_product_relationship"
            ),
        ),
        migrations.AddField(
            model_name="product",
            name="computed_str",
            field=models.CharField(blank=True, max_length=512, null=True, verbose_name="Name"),
        ),
    ]
