# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PortAssociateV2Args', 'PortAssociateV2']

@pulumi.input_type
class PortAssociateV2Args:
    def __init__(__self__, *,
                 bgpvpn_id: pulumi.Input[_builtins.str],
                 port_id: pulumi.Input[_builtins.str],
                 advertise_fixed_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]] = None):
        """
        The set of arguments for constructing a PortAssociateV2 resource.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the port will be
               associated. Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] port_id: The ID of the port to be associated with the BGP VPN.
               Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.bool] advertise_fixed_ips: A boolean flag indicating whether fixed
               IPs should be advertised. Defaults to true.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the port
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN port
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN port association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN port association.
        :param pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]] routes: A list of dictionaries containing the following keys:
        """
        pulumi.set(__self__, "bgpvpn_id", bgpvpn_id)
        pulumi.set(__self__, "port_id", port_id)
        if advertise_fixed_ips is not None:
            pulumi.set(__self__, "advertise_fixed_ips", advertise_fixed_ips)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the BGP VPN to which the port will be
        associated. Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "bgpvpn_id")

    @bgpvpn_id.setter
    def bgpvpn_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "bgpvpn_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the port to be associated with the BGP VPN.
        Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="advertiseFixedIps")
    def advertise_fixed_ips(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether fixed
        IPs should be advertised. Defaults to true.
        """
        return pulumi.get(self, "advertise_fixed_ips")

    @advertise_fixed_ips.setter
    def advertise_fixed_ips(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_fixed_ips", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project that owns the port
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN port
        association.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN port association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN port association.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]]:
        """
        A list of dictionaries containing the following keys:
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.input_type
class _PortAssociateV2State:
    def __init__(__self__, *,
                 advertise_fixed_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]] = None):
        """
        Input properties used for looking up and filtering PortAssociateV2 resources.
        :param pulumi.Input[_builtins.bool] advertise_fixed_ips: A boolean flag indicating whether fixed
               IPs should be advertised. Defaults to true.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the port will be
               associated. Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] port_id: The ID of the port to be associated with the BGP VPN.
               Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the port
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN port
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN port association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN port association.
        :param pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]] routes: A list of dictionaries containing the following keys:
        """
        if advertise_fixed_ips is not None:
            pulumi.set(__self__, "advertise_fixed_ips", advertise_fixed_ips)
        if bgpvpn_id is not None:
            pulumi.set(__self__, "bgpvpn_id", bgpvpn_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)

    @_builtins.property
    @pulumi.getter(name="advertiseFixedIps")
    def advertise_fixed_ips(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean flag indicating whether fixed
        IPs should be advertised. Defaults to true.
        """
        return pulumi.get(self, "advertise_fixed_ips")

    @advertise_fixed_ips.setter
    def advertise_fixed_ips(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "advertise_fixed_ips", value)

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the BGP VPN to which the port will be
        associated. Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "bgpvpn_id")

    @bgpvpn_id.setter
    def bgpvpn_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bgpvpn_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the port to be associated with the BGP VPN.
        Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project that owns the port
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN port
        association.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN port association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN port association.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]]:
        """
        A list of dictionaries containing the following keys:
        """
        return pulumi.get(self, "routes")

    @routes.setter
    def routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortAssociateV2RouteArgs']]]]):
        pulumi.set(self, "routes", value)


@pulumi.type_token("openstack:bgpvpn/portAssociateV2:PortAssociateV2")
class PortAssociateV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_fixed_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAssociateV2RouteArgs', 'PortAssociateV2RouteArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a V2 BGP VPN port association resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        association1 = openstack.bgpvpn.PortAssociateV2("association_1",
            bgpvpn_id="19382ec5-8098-47d9-a9c6-6270c91103f4",
            port_id="b83a95b8-c2c8-4eac-9a9e-ddc85bd1266f",
            routes=[
                {
                    "type": "prefix",
                    "prefix": "192.168.170.1/32",
                },
                {
                    "type": "bgpvpn",
                    "bgpvpn_id": "35af1cc6-3d0f-4c5d-86f8-8cdb508d3f0c",
                },
            ])
        ```

        ## Import

        BGP VPN port associations can be imported using the BGP VPN ID and BGP VPN port

        association ID separated by a slash, e.g.:

        hcl

        ```sh
        $ pulumi import openstack:bgpvpn/portAssociateV2:PortAssociateV2 association_1 5bb44ecf-f8fe-4d75-8fc5-313f96ee2696/8f8fc660-3f28-414e-896a-0c7c51162fcf
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advertise_fixed_ips: A boolean flag indicating whether fixed
               IPs should be advertised. Defaults to true.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the port will be
               associated. Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] port_id: The ID of the port to be associated with the BGP VPN.
               Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the port
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN port
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN port association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN port association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortAssociateV2RouteArgs', 'PortAssociateV2RouteArgsDict']]]] routes: A list of dictionaries containing the following keys:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PortAssociateV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 BGP VPN port association resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        association1 = openstack.bgpvpn.PortAssociateV2("association_1",
            bgpvpn_id="19382ec5-8098-47d9-a9c6-6270c91103f4",
            port_id="b83a95b8-c2c8-4eac-9a9e-ddc85bd1266f",
            routes=[
                {
                    "type": "prefix",
                    "prefix": "192.168.170.1/32",
                },
                {
                    "type": "bgpvpn",
                    "bgpvpn_id": "35af1cc6-3d0f-4c5d-86f8-8cdb508d3f0c",
                },
            ])
        ```

        ## Import

        BGP VPN port associations can be imported using the BGP VPN ID and BGP VPN port

        association ID separated by a slash, e.g.:

        hcl

        ```sh
        $ pulumi import openstack:bgpvpn/portAssociateV2:PortAssociateV2 association_1 5bb44ecf-f8fe-4d75-8fc5-313f96ee2696/8f8fc660-3f28-414e-896a-0c7c51162fcf
        ```

        :param str resource_name: The name of the resource.
        :param PortAssociateV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortAssociateV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advertise_fixed_ips: Optional[pulumi.Input[_builtins.bool]] = None,
                 bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAssociateV2RouteArgs', 'PortAssociateV2RouteArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortAssociateV2Args.__new__(PortAssociateV2Args)

            __props__.__dict__["advertise_fixed_ips"] = advertise_fixed_ips
            if bgpvpn_id is None and not opts.urn:
                raise TypeError("Missing required property 'bgpvpn_id'")
            __props__.__dict__["bgpvpn_id"] = bgpvpn_id
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["routes"] = routes
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="openstack:index/bgpvpnPortAssociateV2:BgpvpnPortAssociateV2")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(PortAssociateV2, __self__).__init__(
            'openstack:bgpvpn/portAssociateV2:PortAssociateV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advertise_fixed_ips: Optional[pulumi.Input[_builtins.bool]] = None,
            bgpvpn_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAssociateV2RouteArgs', 'PortAssociateV2RouteArgsDict']]]]] = None) -> 'PortAssociateV2':
        """
        Get an existing PortAssociateV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] advertise_fixed_ips: A boolean flag indicating whether fixed
               IPs should be advertised. Defaults to true.
        :param pulumi.Input[_builtins.str] bgpvpn_id: The ID of the BGP VPN to which the port will be
               associated. Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] port_id: The ID of the port to be associated with the BGP VPN.
               Changing this creates a new BGP VPN port association.
        :param pulumi.Input[_builtins.str] project_id: The ID of the project that owns the port
               association. Only administrative and users with `advsvc` role can specify a
               project ID other than their own. Changing this creates a new BGP VPN port
               association.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a BGP VPN port association. If
               omitted, the `region` argument of the provider is used. Changing this creates
               a new BGP VPN port association.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortAssociateV2RouteArgs', 'PortAssociateV2RouteArgsDict']]]] routes: A list of dictionaries containing the following keys:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortAssociateV2State.__new__(_PortAssociateV2State)

        __props__.__dict__["advertise_fixed_ips"] = advertise_fixed_ips
        __props__.__dict__["bgpvpn_id"] = bgpvpn_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["routes"] = routes
        return PortAssociateV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="advertiseFixedIps")
    def advertise_fixed_ips(self) -> pulumi.Output[_builtins.bool]:
        """
        A boolean flag indicating whether fixed
        IPs should be advertised. Defaults to true.
        """
        return pulumi.get(self, "advertise_fixed_ips")

    @_builtins.property
    @pulumi.getter(name="bgpvpnId")
    def bgpvpn_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the BGP VPN to which the port will be
        associated. Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "bgpvpn_id")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the port to be associated with the BGP VPN.
        Changing this creates a new BGP VPN port association.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project that owns the port
        association. Only administrative and users with `advsvc` role can specify a
        project ID other than their own. Changing this creates a new BGP VPN port
        association.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a BGP VPN port association. If
        omitted, the `region` argument of the provider is used. Changing this creates
        a new BGP VPN port association.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routes(self) -> pulumi.Output[Optional[Sequence['outputs.PortAssociateV2Route']]]:
        """
        A list of dictionaries containing the following keys:
        """
        return pulumi.get(self, "routes")

