# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RuleV2Args', 'RuleV2']

@pulumi.input_type
class RuleV2Args:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shared: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a RuleV2 resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken (must be "allow", "deny" or "reject")
               when the firewall rule matches. Changing this updates the `action` of an
               existing firewall rule. Default is `deny`.
        :param pulumi.Input[_builtins.str] description: A description for the firewall rule. Changing this
               updates the `description` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address on which the
               firewall rule operates. Changing this updates the `destination_ip_address`
               of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_port: The destination port on which the firewall
               rule operates. Changing this updates the `destination_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the firewall rule (must be "true"
               or "false" if provided - defaults to "true"). Changing this updates the
               `enabled` status of an existing firewall rule.
        :param pulumi.Input[_builtins.int] ip_version: IP version, either 4 or 6. Changing this
               updates the `ip_version` of an existing firewall rule. Default is `4`.
        :param pulumi.Input[_builtins.str] name: A unique name for the firewall rule. Changing this
               updates the `name` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] project_id: This argument conflicts and is interchangeable
               with `tenant_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another project. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.str] protocol: (Optional; Required if `source_port` or `destination_port` is not
               empty) The protocol type on which the firewall rule operates.
               Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
               `protocol` of an existing firewall rule. Default is `any`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall rule. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.bool] shared: Sharing status of the firewall rule (must be "true"
               or "false" if provided). If this is "true" the policy is visible to, and
               can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall policy. On
        :param pulumi.Input[_builtins.str] source_ip_address: The source IP address on which the firewall
               rule operates. Changing this updates the `source_ip_address` of an existing
               firewall rule.
        :param pulumi.Input[_builtins.str] source_port: The source port on which the firewall
               rule operates. Changing this updates the `source_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.str] tenant_id: This argument conflicts and is interchangeable
               with `project_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another tenant. Changing this creates a new
               firewall rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken (must be "allow", "deny" or "reject")
        when the firewall rule matches. Changing this updates the `action` of an
        existing firewall rule. Default is `deny`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the firewall rule. Changing this
        updates the `description` of an existing firewall rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination IP address on which the
        firewall rule operates. Changing this updates the `destination_ip_address`
        of an existing firewall rule.
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port on which the firewall
        rule operates. Changing this updates the `destination_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabled status for the firewall rule (must be "true"
        or "false" if provided - defaults to "true"). Changing this updates the
        `enabled` status of an existing firewall rule.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IP version, either 4 or 6. Changing this
        updates the `ip_version` of an existing firewall rule. Default is `4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name for the firewall rule. Changing this
        updates the `name` of an existing firewall rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This argument conflicts and is interchangeable
        with `tenant_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another project. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional; Required if `source_port` or `destination_port` is not
        empty) The protocol type on which the firewall rule operates.
        Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
        `protocol` of an existing firewall rule. Default is `any`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall rule. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sharing status of the firewall rule (must be "true"
        or "false" if provided). If this is "true" the policy is visible to, and
        can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall policy. On
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shared", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IP address on which the firewall
        rule operates. Changing this updates the `source_ip_address` of an existing
        firewall rule.
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port on which the firewall
        rule operates. Changing this updates the `source_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This argument conflicts and is interchangeable
        with `project_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another tenant. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _RuleV2State:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shared: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RuleV2 resources.
        :param pulumi.Input[_builtins.str] action: Action to be taken (must be "allow", "deny" or "reject")
               when the firewall rule matches. Changing this updates the `action` of an
               existing firewall rule. Default is `deny`.
        :param pulumi.Input[_builtins.str] description: A description for the firewall rule. Changing this
               updates the `description` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address on which the
               firewall rule operates. Changing this updates the `destination_ip_address`
               of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_port: The destination port on which the firewall
               rule operates. Changing this updates the `destination_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the firewall rule (must be "true"
               or "false" if provided - defaults to "true"). Changing this updates the
               `enabled` status of an existing firewall rule.
        :param pulumi.Input[_builtins.int] ip_version: IP version, either 4 or 6. Changing this
               updates the `ip_version` of an existing firewall rule. Default is `4`.
        :param pulumi.Input[_builtins.str] name: A unique name for the firewall rule. Changing this
               updates the `name` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] project_id: This argument conflicts and is interchangeable
               with `tenant_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another project. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.str] protocol: (Optional; Required if `source_port` or `destination_port` is not
               empty) The protocol type on which the firewall rule operates.
               Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
               `protocol` of an existing firewall rule. Default is `any`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall rule. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.bool] shared: Sharing status of the firewall rule (must be "true"
               or "false" if provided). If this is "true" the policy is visible to, and
               can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall policy. On
        :param pulumi.Input[_builtins.str] source_ip_address: The source IP address on which the firewall
               rule operates. Changing this updates the `source_ip_address` of an existing
               firewall rule.
        :param pulumi.Input[_builtins.str] source_port: The source port on which the firewall
               rule operates. Changing this updates the `source_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.str] tenant_id: This argument conflicts and is interchangeable
               with `project_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another tenant. Changing this creates a new
               firewall rule.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_ip_address is not None:
            pulumi.set(__self__, "destination_ip_address", destination_ip_address)
        if destination_port is not None:
            pulumi.set(__self__, "destination_port", destination_port)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if source_port is not None:
            pulumi.set(__self__, "source_port", source_port)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Action to be taken (must be "allow", "deny" or "reject")
        when the firewall rule matches. Changing this updates the `action` of an
        existing firewall rule. Default is `deny`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the firewall rule. Changing this
        updates the `description` of an existing firewall rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination IP address on which the
        firewall rule operates. Changing this updates the `destination_ip_address`
        of an existing firewall rule.
        """
        return pulumi.get(self, "destination_ip_address")

    @destination_ip_address.setter
    def destination_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The destination port on which the firewall
        rule operates. Changing this updates the `destination_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "destination_port")

    @destination_port.setter
    def destination_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_port", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enabled status for the firewall rule (must be "true"
        or "false" if provided - defaults to "true"). Changing this updates the
        `enabled` status of an existing firewall rule.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        IP version, either 4 or 6. Changing this
        updates the `ip_version` of an existing firewall rule. Default is `4`.
        """
        return pulumi.get(self, "ip_version")

    @ip_version.setter
    def ip_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ip_version", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A unique name for the firewall rule. Changing this
        updates the `name` of an existing firewall rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This argument conflicts and is interchangeable
        with `tenant_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another project. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional; Required if `source_port` or `destination_port` is not
        empty) The protocol type on which the firewall rule operates.
        Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
        `protocol` of an existing firewall rule. Default is `any`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall rule. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Sharing status of the firewall rule (must be "true"
        or "false" if provided). If this is "true" the policy is visible to, and
        can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall policy. On
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shared", value)

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source IP address on which the firewall
        rule operates. Changing this updates the `source_ip_address` of an existing
        firewall rule.
        """
        return pulumi.get(self, "source_ip_address")

    @source_ip_address.setter
    def source_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source port on which the firewall
        rule operates. Changing this updates the `source_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "source_port")

    @source_port.setter
    def source_port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_port", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        This argument conflicts and is interchangeable
        with `project_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another tenant. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.type_token("openstack:firewall/ruleV2:RuleV2")
class RuleV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shared: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a v2 firewall rule resource within OpenStack.

        > **Note:** Firewall v2 has no support for OVN currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        rule2 = openstack.firewall.RuleV2("rule_2",
            name="firewall_rule",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        ```

        ## Import

        Firewall Rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:firewall/ruleV2:RuleV2 rule_1 8dbc0c28-e49c-463f-b712-5c5d1bbac327
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken (must be "allow", "deny" or "reject")
               when the firewall rule matches. Changing this updates the `action` of an
               existing firewall rule. Default is `deny`.
        :param pulumi.Input[_builtins.str] description: A description for the firewall rule. Changing this
               updates the `description` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address on which the
               firewall rule operates. Changing this updates the `destination_ip_address`
               of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_port: The destination port on which the firewall
               rule operates. Changing this updates the `destination_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the firewall rule (must be "true"
               or "false" if provided - defaults to "true"). Changing this updates the
               `enabled` status of an existing firewall rule.
        :param pulumi.Input[_builtins.int] ip_version: IP version, either 4 or 6. Changing this
               updates the `ip_version` of an existing firewall rule. Default is `4`.
        :param pulumi.Input[_builtins.str] name: A unique name for the firewall rule. Changing this
               updates the `name` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] project_id: This argument conflicts and is interchangeable
               with `tenant_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another project. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.str] protocol: (Optional; Required if `source_port` or `destination_port` is not
               empty) The protocol type on which the firewall rule operates.
               Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
               `protocol` of an existing firewall rule. Default is `any`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall rule. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.bool] shared: Sharing status of the firewall rule (must be "true"
               or "false" if provided). If this is "true" the policy is visible to, and
               can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall policy. On
        :param pulumi.Input[_builtins.str] source_ip_address: The source IP address on which the firewall
               rule operates. Changing this updates the `source_ip_address` of an existing
               firewall rule.
        :param pulumi.Input[_builtins.str] source_port: The source port on which the firewall
               rule operates. Changing this updates the `source_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.str] tenant_id: This argument conflicts and is interchangeable
               with `project_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another tenant. Changing this creates a new
               firewall rule.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[RuleV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a v2 firewall rule resource within OpenStack.

        > **Note:** Firewall v2 has no support for OVN currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        rule2 = openstack.firewall.RuleV2("rule_2",
            name="firewall_rule",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        ```

        ## Import

        Firewall Rules can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:firewall/ruleV2:RuleV2 rule_1 8dbc0c28-e49c-463f-b712-5c5d1bbac327
        ```

        :param str resource_name: The name of the resource.
        :param RuleV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_port: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_version: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 shared: Optional[pulumi.Input[_builtins.bool]] = None,
                 source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 source_port: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleV2Args.__new__(RuleV2Args)

            __props__.__dict__["action"] = action
            __props__.__dict__["description"] = description
            __props__.__dict__["destination_ip_address"] = destination_ip_address
            __props__.__dict__["destination_port"] = destination_port
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ip_version"] = ip_version
            __props__.__dict__["name"] = name
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["region"] = region
            __props__.__dict__["shared"] = shared
            __props__.__dict__["source_ip_address"] = source_ip_address
            __props__.__dict__["source_port"] = source_port
            __props__.__dict__["tenant_id"] = tenant_id
        super(RuleV2, __self__).__init__(
            'openstack:firewall/ruleV2:RuleV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            destination_port: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ip_version: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            shared: Optional[pulumi.Input[_builtins.bool]] = None,
            source_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            source_port: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RuleV2':
        """
        Get an existing RuleV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] action: Action to be taken (must be "allow", "deny" or "reject")
               when the firewall rule matches. Changing this updates the `action` of an
               existing firewall rule. Default is `deny`.
        :param pulumi.Input[_builtins.str] description: A description for the firewall rule. Changing this
               updates the `description` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_ip_address: The destination IP address on which the
               firewall rule operates. Changing this updates the `destination_ip_address`
               of an existing firewall rule.
        :param pulumi.Input[_builtins.str] destination_port: The destination port on which the firewall
               rule operates. Changing this updates the `destination_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.bool] enabled: Enabled status for the firewall rule (must be "true"
               or "false" if provided - defaults to "true"). Changing this updates the
               `enabled` status of an existing firewall rule.
        :param pulumi.Input[_builtins.int] ip_version: IP version, either 4 or 6. Changing this
               updates the `ip_version` of an existing firewall rule. Default is `4`.
        :param pulumi.Input[_builtins.str] name: A unique name for the firewall rule. Changing this
               updates the `name` of an existing firewall rule.
        :param pulumi.Input[_builtins.str] project_id: This argument conflicts and is interchangeable
               with `tenant_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another project. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.str] protocol: (Optional; Required if `source_port` or `destination_port` is not
               empty) The protocol type on which the firewall rule operates.
               Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
               `protocol` of an existing firewall rule. Default is `any`.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall rule. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall rule.
        :param pulumi.Input[_builtins.bool] shared: Sharing status of the firewall rule (must be "true"
               or "false" if provided). If this is "true" the policy is visible to, and
               can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall policy. On
        :param pulumi.Input[_builtins.str] source_ip_address: The source IP address on which the firewall
               rule operates. Changing this updates the `source_ip_address` of an existing
               firewall rule.
        :param pulumi.Input[_builtins.str] source_port: The source port on which the firewall
               rule operates. Changing this updates the `source_port` of an existing
               firewall rule. Require not `any` or empty protocol.
        :param pulumi.Input[_builtins.str] tenant_id: This argument conflicts and is interchangeable
               with `project_id`. The owner of the firewall rule. Required if admin wants
               to create a firewall rule for another tenant. Changing this creates a new
               firewall rule.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleV2State.__new__(_RuleV2State)

        __props__.__dict__["action"] = action
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_ip_address"] = destination_ip_address
        __props__.__dict__["destination_port"] = destination_port
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ip_version"] = ip_version
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["region"] = region
        __props__.__dict__["shared"] = shared
        __props__.__dict__["source_ip_address"] = source_ip_address
        __props__.__dict__["source_port"] = source_port
        __props__.__dict__["tenant_id"] = tenant_id
        return RuleV2(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Action to be taken (must be "allow", "deny" or "reject")
        when the firewall rule matches. Changing this updates the `action` of an
        existing firewall rule. Default is `deny`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the firewall rule. Changing this
        updates the `description` of an existing firewall rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationIpAddress")
    def destination_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination IP address on which the
        firewall rule operates. Changing this updates the `destination_ip_address`
        of an existing firewall rule.
        """
        return pulumi.get(self, "destination_ip_address")

    @_builtins.property
    @pulumi.getter(name="destinationPort")
    def destination_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The destination port on which the firewall
        rule operates. Changing this updates the `destination_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "destination_port")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enabled status for the firewall rule (must be "true"
        or "false" if provided - defaults to "true"). Changing this updates the
        `enabled` status of an existing firewall rule.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        IP version, either 4 or 6. Changing this
        updates the `ip_version` of an existing firewall rule. Default is `4`.
        """
        return pulumi.get(self, "ip_version")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A unique name for the firewall rule. Changing this
        updates the `name` of an existing firewall rule.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        This argument conflicts and is interchangeable
        with `tenant_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another project. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Optional; Required if `source_port` or `destination_port` is not
        empty) The protocol type on which the firewall rule operates.
        Valid values are: `tcp`, `udp`, `icmp`, and `any`. Changing this updates the
        `protocol` of an existing firewall rule. Default is `any`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall rule. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def shared(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Sharing status of the firewall rule (must be "true"
        or "false" if provided). If this is "true" the policy is visible to, and
        can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall policy. On
        """
        return pulumi.get(self, "shared")

    @_builtins.property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source IP address on which the firewall
        rule operates. Changing this updates the `source_ip_address` of an existing
        firewall rule.
        """
        return pulumi.get(self, "source_ip_address")

    @_builtins.property
    @pulumi.getter(name="sourcePort")
    def source_port(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The source port on which the firewall
        rule operates. Changing this updates the `source_port` of an existing
        firewall rule. Require not `any` or empty protocol.
        """
        return pulumi.get(self, "source_port")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        This argument conflicts and is interchangeable
        with `project_id`. The owner of the firewall rule. Required if admin wants
        to create a firewall rule for another tenant. Changing this creates a new
        firewall rule.
        """
        return pulumi.get(self, "tenant_id")

