# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, description=None, domain_id=None, enabled=None, id=None, is_domain=None, name=None, parent_id=None, project_id=None, region=None, tags=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if enabled and not isinstance(enabled, bool):
            raise TypeError("Expected argument 'enabled' to be a bool")
        pulumi.set(__self__, "enabled", enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_domain and not isinstance(is_domain, bool):
            raise TypeError("Expected argument 'is_domain' to be a bool")
        pulumi.set(__self__, "is_domain", is_domain)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if parent_id and not isinstance(parent_id, str):
            raise TypeError("Expected argument 'parent_id' to be a str")
        pulumi.set(__self__, "parent_id", parent_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the project.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDomain")
    def is_domain(self) -> Optional[_builtins.bool]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "is_domain")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "parent_id")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence[_builtins.str]:
        """
        See Argument Reference above.
        """
        return pulumi.get(self, "tags")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            description=self.description,
            domain_id=self.domain_id,
            enabled=self.enabled,
            id=self.id,
            is_domain=self.is_domain,
            name=self.name,
            parent_id=self.parent_id,
            project_id=self.project_id,
            region=self.region,
            tags=self.tags)


def get_project(domain_id: Optional[_builtins.str] = None,
                enabled: Optional[_builtins.bool] = None,
                is_domain: Optional[_builtins.bool] = None,
                name: Optional[_builtins.str] = None,
                parent_id: Optional[_builtins.str] = None,
                project_id: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    Use this data source to get the ID of an OpenStack project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    project1 = openstack.identity.get_project(name="demo")
    ```


    :param _builtins.str domain_id: The domain this project belongs to.
    :param _builtins.bool enabled: Whether the project is enabled or disabled. Valid
           values are `true` and `false`.
    :param _builtins.bool is_domain: Whether this project is a domain. Valid values
           are `true` and `false`.
    :param _builtins.str name: The name of the project.
    :param _builtins.str parent_id: The parent of this project.
    :param _builtins.str project_id: The id of the project. Conflicts with any of the
           above arguments.
    :param _builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['enabled'] = enabled
    __args__['isDomain'] = is_domain
    __args__['name'] = name
    __args__['parentId'] = parent_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('openstack:identity/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        description=pulumi.get(__ret__, 'description'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        enabled=pulumi.get(__ret__, 'enabled'),
        id=pulumi.get(__ret__, 'id'),
        is_domain=pulumi.get(__ret__, 'is_domain'),
        name=pulumi.get(__ret__, 'name'),
        parent_id=pulumi.get(__ret__, 'parent_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        region=pulumi.get(__ret__, 'region'),
        tags=pulumi.get(__ret__, 'tags'))
def get_project_output(domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       is_domain: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                       name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       parent_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProjectResult]:
    """
    Use this data source to get the ID of an OpenStack project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_openstack as openstack

    project1 = openstack.identity.get_project(name="demo")
    ```


    :param _builtins.str domain_id: The domain this project belongs to.
    :param _builtins.bool enabled: Whether the project is enabled or disabled. Valid
           values are `true` and `false`.
    :param _builtins.bool is_domain: Whether this project is a domain. Valid values
           are `true` and `false`.
    :param _builtins.str name: The name of the project.
    :param _builtins.str parent_id: The parent of this project.
    :param _builtins.str project_id: The id of the project. Conflicts with any of the
           above arguments.
    :param _builtins.str region: The region in which to obtain the V3 Keystone client.
           If omitted, the `region` argument of the provider is used.
    """
    __args__ = dict()
    __args__['domainId'] = domain_id
    __args__['enabled'] = enabled
    __args__['isDomain'] = is_domain
    __args__['name'] = name
    __args__['parentId'] = parent_id
    __args__['projectId'] = project_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('openstack:identity/getProject:getProject', __args__, opts=opts, typ=GetProjectResult)
    return __ret__.apply(lambda __response__: GetProjectResult(
        description=pulumi.get(__response__, 'description'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        enabled=pulumi.get(__response__, 'enabled'),
        id=pulumi.get(__response__, 'id'),
        is_domain=pulumi.get(__response__, 'is_domain'),
        name=pulumi.get(__response__, 'name'),
        parent_id=pulumi.get(__response__, 'parent_id'),
        project_id=pulumi.get(__response__, 'project_id'),
        region=pulumi.get(__response__, 'region'),
        tags=pulumi.get(__response__, 'tags')))
