# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MonitorArgs', 'Monitor']

@pulumi.input_type
class MonitorArgs:
    def __init__(__self__, *,
                 delay: pulumi.Input[_builtins.int],
                 max_retries: pulumi.Input[_builtins.int],
                 pool_id: pulumi.Input[_builtins.str],
                 timeout: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries_down: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Monitor resource.
        :param pulumi.Input[_builtins.int] delay: The time, in seconds, between sending probes to members.
        :param pulumi.Input[_builtins.int] max_retries: Number of permissible ping failures before
               changing the member's status to INACTIVE. Must be a number between 1
               and 10.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[_builtins.int] timeout: Maximum number of seconds for a monitor to wait for a
               ping reply before it times out. The value must be less than the delay
               value.
        :param pulumi.Input[_builtins.str] type: The type of probe, which is PING, TCP, HTTP, HTTPS,
               TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
               verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the monitor.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[_builtins.str] domain_name: The domain name to use in the HTTP host header
               health monitor requests. Supported in Octavia API version 2.10 or later.
        :param pulumi.Input[_builtins.str] expected_codes: Required for HTTP(S) types. Expected HTTP codes
               for a passing HTTP(S) monitor. You can either specify a single status like
               "200", a list like "200, 202" or a range like "200-202". Default is "200".
        :param pulumi.Input[_builtins.str] http_method: Required for HTTP(S) types. The HTTP method that 
               the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
               OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        :param pulumi.Input[_builtins.str] http_version: Required for HTTP(S) types. The HTTP version that
               the health monitor uses for requests. One of `1.0` or 1.1` is supported
               for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
               2.10 or later.
        :param pulumi.Input[_builtins.int] max_retries_down: Number of permissible ping failures before 
               changing the member's status to ERROR. Must be a number between 1 and 10.
               The default is 3. Changing this updates the max_retries_down of the
               existing monitor.
        :param pulumi.Input[_builtins.str] name: The Name of the Monitor.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a monitor. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               monitor.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the monitor.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] url_path: Required for HTTP(S) types. URI path that will be
               accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        pulumi.set(__self__, "delay", delay)
        pulumi.set(__self__, "max_retries", max_retries)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "type", type)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if max_retries_down is not None:
            pulumi.set(__self__, "max_retries_down", max_retries_down)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> pulumi.Input[_builtins.int]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "delay", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Input[_builtins.int]:
        """
        Number of permissible ping failures before
        changing the member's status to INACTIVE. Must be a number between 1
        and 10.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Input[_builtins.int]:
        """
        Maximum number of seconds for a monitor to wait for a
        ping reply before it times out. The value must be less than the delay
        value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of probe, which is PING, TCP, HTTP, HTTPS,
        TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
        verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the monitor.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name to use in the HTTP host header
        health monitor requests. Supported in Octavia API version 2.10 or later.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. Expected HTTP codes
        for a passing HTTP(S) monitor. You can either specify a single status like
        "200", a list like "200, 202" or a range like "200-202". Default is "200".
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_codes", value)

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. The HTTP method that 
        the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
        OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_method", value)

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. The HTTP version that
        the health monitor uses for requests. One of `1.0` or 1.1` is supported
        for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
        2.10 or later.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_version", value)

    @_builtins.property
    @pulumi.getter(name="maxRetriesDown")
    def max_retries_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of permissible ping failures before 
        changing the member's status to ERROR. Must be a number between 1 and 10.
        The default is 3. Changing this updates the max_retries_down of the
        existing monitor.
        """
        return pulumi.get(self, "max_retries_down")

    @max_retries_down.setter
    def max_retries_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries_down", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a monitor. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the monitor.  Only administrative users can specify a tenant UUID
        other than their own. Changing this creates a new monitor.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. URI path that will be
        accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_path", value)


@pulumi.input_type
class _MonitorState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_down: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Monitor resources.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the monitor.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[_builtins.int] delay: The time, in seconds, between sending probes to members.
        :param pulumi.Input[_builtins.str] domain_name: The domain name to use in the HTTP host header
               health monitor requests. Supported in Octavia API version 2.10 or later.
        :param pulumi.Input[_builtins.str] expected_codes: Required for HTTP(S) types. Expected HTTP codes
               for a passing HTTP(S) monitor. You can either specify a single status like
               "200", a list like "200, 202" or a range like "200-202". Default is "200".
        :param pulumi.Input[_builtins.str] http_method: Required for HTTP(S) types. The HTTP method that 
               the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
               OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        :param pulumi.Input[_builtins.str] http_version: Required for HTTP(S) types. The HTTP version that
               the health monitor uses for requests. One of `1.0` or 1.1` is supported
               for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
               2.10 or later.
        :param pulumi.Input[_builtins.int] max_retries: Number of permissible ping failures before
               changing the member's status to INACTIVE. Must be a number between 1
               and 10.
        :param pulumi.Input[_builtins.int] max_retries_down: Number of permissible ping failures before 
               changing the member's status to ERROR. Must be a number between 1 and 10.
               The default is 3. Changing this updates the max_retries_down of the
               existing monitor.
        :param pulumi.Input[_builtins.str] name: The Name of the Monitor.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a monitor. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               monitor.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the monitor.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] timeout: Maximum number of seconds for a monitor to wait for a
               ping reply before it times out. The value must be less than the delay
               value.
        :param pulumi.Input[_builtins.str] type: The type of probe, which is PING, TCP, HTTP, HTTPS,
               TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
               verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] url_path: Required for HTTP(S) types. URI path that will be
               accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if delay is not None:
            pulumi.set(__self__, "delay", delay)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if expected_codes is not None:
            pulumi.set(__self__, "expected_codes", expected_codes)
        if http_method is not None:
            pulumi.set(__self__, "http_method", http_method)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if max_retries_down is not None:
            pulumi.set(__self__, "max_retries_down", max_retries_down)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pool_id is not None:
            pulumi.set(__self__, "pool_id", pool_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if url_path is not None:
            pulumi.set(__self__, "url_path", url_path)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The administrative state of the monitor.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin_state_up", value)

    @_builtins.property
    @pulumi.getter
    def delay(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "delay")

    @delay.setter
    def delay(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "delay", value)

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The domain name to use in the HTTP host header
        health monitor requests. Supported in Octavia API version 2.10 or later.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_name", value)

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. Expected HTTP codes
        for a passing HTTP(S) monitor. You can either specify a single status like
        "200", a list like "200, 202" or a range like "200-202". Default is "200".
        """
        return pulumi.get(self, "expected_codes")

    @expected_codes.setter
    def expected_codes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expected_codes", value)

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. The HTTP method that 
        the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
        OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        """
        return pulumi.get(self, "http_method")

    @http_method.setter
    def http_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_method", value)

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. The HTTP version that
        the health monitor uses for requests. One of `1.0` or 1.1` is supported
        for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
        2.10 or later.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "http_version", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of permissible ping failures before
        changing the member's status to INACTIVE. Must be a number between 1
        and 10.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter(name="maxRetriesDown")
    def max_retries_down(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of permissible ping failures before 
        changing the member's status to ERROR. Must be a number between 1 and 10.
        The default is 3. Changing this updates the max_retries_down of the
        existing monitor.
        """
        return pulumi.get(self, "max_retries_down")

    @max_retries_down.setter
    def max_retries_down(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries_down", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Monitor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pool_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a monitor. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        monitor.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the monitor.  Only administrative users can specify a tenant UUID
        other than their own. Changing this creates a new monitor.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of seconds for a monitor to wait for a
        ping reply before it times out. The value must be less than the delay
        value.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "timeout", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of probe, which is PING, TCP, HTTP, HTTPS,
        TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
        verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required for HTTP(S) types. URI path that will be
        accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        return pulumi.get(self, "url_path")

    @url_path.setter
    def url_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "url_path", value)


@pulumi.type_token("openstack:loadbalancer/monitor:Monitor")
class Monitor(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_down: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a V2 monitor resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        monitor1 = openstack.loadbalancer.Monitor("monitor_1",
            pool_id=pool1["id"],
            type="PING",
            delay=20,
            timeout=10,
            max_retries=5)
        ```

        ## Import

        Load Balancer Pool Monitor can be imported using the Monitor ID, e.g.:

        ```sh
        $ pulumi import openstack:loadbalancer/monitor:Monitor monitor_1 47c26fc3-2403-427a-8c79-1589bd0533c2
        ```
        In case of using OpenContrail, the import may not work properly. If you face an issue, try to import the monitor providing its parent pool ID:

        ```sh
        $ pulumi import openstack:loadbalancer/monitor:Monitor monitor_1 47c26fc3-2403-427a-8c79-1589bd0533c2/708bc224-0f8c-4981-ac82-97095fe051b6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the monitor.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[_builtins.int] delay: The time, in seconds, between sending probes to members.
        :param pulumi.Input[_builtins.str] domain_name: The domain name to use in the HTTP host header
               health monitor requests. Supported in Octavia API version 2.10 or later.
        :param pulumi.Input[_builtins.str] expected_codes: Required for HTTP(S) types. Expected HTTP codes
               for a passing HTTP(S) monitor. You can either specify a single status like
               "200", a list like "200, 202" or a range like "200-202". Default is "200".
        :param pulumi.Input[_builtins.str] http_method: Required for HTTP(S) types. The HTTP method that 
               the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
               OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        :param pulumi.Input[_builtins.str] http_version: Required for HTTP(S) types. The HTTP version that
               the health monitor uses for requests. One of `1.0` or 1.1` is supported
               for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
               2.10 or later.
        :param pulumi.Input[_builtins.int] max_retries: Number of permissible ping failures before
               changing the member's status to INACTIVE. Must be a number between 1
               and 10.
        :param pulumi.Input[_builtins.int] max_retries_down: Number of permissible ping failures before 
               changing the member's status to ERROR. Must be a number between 1 and 10.
               The default is 3. Changing this updates the max_retries_down of the
               existing monitor.
        :param pulumi.Input[_builtins.str] name: The Name of the Monitor.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a monitor. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               monitor.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the monitor.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] timeout: Maximum number of seconds for a monitor to wait for a
               ping reply before it times out. The value must be less than the delay
               value.
        :param pulumi.Input[_builtins.str] type: The type of probe, which is PING, TCP, HTTP, HTTPS,
               TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
               verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] url_path: Required for HTTP(S) types. URI path that will be
               accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 monitor resource within OpenStack.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        monitor1 = openstack.loadbalancer.Monitor("monitor_1",
            pool_id=pool1["id"],
            type="PING",
            delay=20,
            timeout=10,
            max_retries=5)
        ```

        ## Import

        Load Balancer Pool Monitor can be imported using the Monitor ID, e.g.:

        ```sh
        $ pulumi import openstack:loadbalancer/monitor:Monitor monitor_1 47c26fc3-2403-427a-8c79-1589bd0533c2
        ```
        In case of using OpenContrail, the import may not work properly. If you face an issue, try to import the monitor providing its parent pool ID:

        ```sh
        $ pulumi import openstack:loadbalancer/monitor:Monitor monitor_1 47c26fc3-2403-427a-8c79-1589bd0533c2/708bc224-0f8c-4981-ac82-97095fe051b6
        ```

        :param str resource_name: The name of the resource.
        :param MonitorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
                 delay: Optional[pulumi.Input[_builtins.int]] = None,
                 domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 expected_codes: Optional[pulumi.Input[_builtins.str]] = None,
                 http_method: Optional[pulumi.Input[_builtins.str]] = None,
                 http_version: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 max_retries_down: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 url_path: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitorArgs.__new__(MonitorArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            if delay is None and not opts.urn:
                raise TypeError("Missing required property 'delay'")
            __props__.__dict__["delay"] = delay
            __props__.__dict__["domain_name"] = domain_name
            __props__.__dict__["expected_codes"] = expected_codes
            __props__.__dict__["http_method"] = http_method
            __props__.__dict__["http_version"] = http_version
            if max_retries is None and not opts.urn:
                raise TypeError("Missing required property 'max_retries'")
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["max_retries_down"] = max_retries_down
            __props__.__dict__["name"] = name
            if pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'pool_id'")
            __props__.__dict__["pool_id"] = pool_id
            __props__.__dict__["region"] = region
            __props__.__dict__["tenant_id"] = tenant_id
            if timeout is None and not opts.urn:
                raise TypeError("Missing required property 'timeout'")
            __props__.__dict__["timeout"] = timeout
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["url_path"] = url_path
        super(Monitor, __self__).__init__(
            'openstack:loadbalancer/monitor:Monitor',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[_builtins.bool]] = None,
            delay: Optional[pulumi.Input[_builtins.int]] = None,
            domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            expected_codes: Optional[pulumi.Input[_builtins.str]] = None,
            http_method: Optional[pulumi.Input[_builtins.str]] = None,
            http_version: Optional[pulumi.Input[_builtins.str]] = None,
            max_retries: Optional[pulumi.Input[_builtins.int]] = None,
            max_retries_down: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            timeout: Optional[pulumi.Input[_builtins.int]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            url_path: Optional[pulumi.Input[_builtins.str]] = None) -> 'Monitor':
        """
        Get an existing Monitor resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] admin_state_up: The administrative state of the monitor.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[_builtins.int] delay: The time, in seconds, between sending probes to members.
        :param pulumi.Input[_builtins.str] domain_name: The domain name to use in the HTTP host header
               health monitor requests. Supported in Octavia API version 2.10 or later.
        :param pulumi.Input[_builtins.str] expected_codes: Required for HTTP(S) types. Expected HTTP codes
               for a passing HTTP(S) monitor. You can either specify a single status like
               "200", a list like "200, 202" or a range like "200-202". Default is "200".
        :param pulumi.Input[_builtins.str] http_method: Required for HTTP(S) types. The HTTP method that 
               the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
               OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        :param pulumi.Input[_builtins.str] http_version: Required for HTTP(S) types. The HTTP version that
               the health monitor uses for requests. One of `1.0` or 1.1` is supported
               for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
               2.10 or later.
        :param pulumi.Input[_builtins.int] max_retries: Number of permissible ping failures before
               changing the member's status to INACTIVE. Must be a number between 1
               and 10.
        :param pulumi.Input[_builtins.int] max_retries_down: Number of permissible ping failures before 
               changing the member's status to ERROR. Must be a number between 1 and 10.
               The default is 3. Changing this updates the max_retries_down of the
               existing monitor.
        :param pulumi.Input[_builtins.str] name: The Name of the Monitor.
        :param pulumi.Input[_builtins.str] pool_id: The id of the pool that this monitor will be assigned to.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a monitor. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               monitor.
        :param pulumi.Input[_builtins.str] tenant_id: Required for admins. The UUID of the tenant who owns
               the monitor.  Only administrative users can specify a tenant UUID
               other than their own. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.int] timeout: Maximum number of seconds for a monitor to wait for a
               ping reply before it times out. The value must be less than the delay
               value.
        :param pulumi.Input[_builtins.str] type: The type of probe, which is PING, TCP, HTTP, HTTPS,
               TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
               verify the member state. Changing this creates a new monitor.
        :param pulumi.Input[_builtins.str] url_path: Required for HTTP(S) types. URI path that will be
               accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitorState.__new__(_MonitorState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["delay"] = delay
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["expected_codes"] = expected_codes
        __props__.__dict__["http_method"] = http_method
        __props__.__dict__["http_version"] = http_version
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["max_retries_down"] = max_retries_down
        __props__.__dict__["name"] = name
        __props__.__dict__["pool_id"] = pool_id
        __props__.__dict__["region"] = region
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout"] = timeout
        __props__.__dict__["type"] = type
        __props__.__dict__["url_path"] = url_path
        return Monitor(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The administrative state of the monitor.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @_builtins.property
    @pulumi.getter
    def delay(self) -> pulumi.Output[_builtins.int]:
        """
        The time, in seconds, between sending probes to members.
        """
        return pulumi.get(self, "delay")

    @_builtins.property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The domain name to use in the HTTP host header
        health monitor requests. Supported in Octavia API version 2.10 or later.
        """
        return pulumi.get(self, "domain_name")

    @_builtins.property
    @pulumi.getter(name="expectedCodes")
    def expected_codes(self) -> pulumi.Output[_builtins.str]:
        """
        Required for HTTP(S) types. Expected HTTP codes
        for a passing HTTP(S) monitor. You can either specify a single status like
        "200", a list like "200, 202" or a range like "200-202". Default is "200".
        """
        return pulumi.get(self, "expected_codes")

    @_builtins.property
    @pulumi.getter(name="httpMethod")
    def http_method(self) -> pulumi.Output[_builtins.str]:
        """
        Required for HTTP(S) types. The HTTP method that 
        the health monitor uses for requests. One of CONNECT, DELETE, GET, HEAD,
        OPTIONS, PATCH, POST, PUT, or TRACE. The default is GET.
        """
        return pulumi.get(self, "http_method")

    @_builtins.property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Required for HTTP(S) types. The HTTP version that
        the health monitor uses for requests. One of `1.0` or 1.1` is supported
        for HTTP(S) monitors. The default is `1.0`. Supported in Octavia API version
        2.10 or later.
        """
        return pulumi.get(self, "http_version")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[_builtins.int]:
        """
        Number of permissible ping failures before
        changing the member's status to INACTIVE. Must be a number between 1
        and 10.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter(name="maxRetriesDown")
    def max_retries_down(self) -> pulumi.Output[_builtins.int]:
        """
        Number of permissible ping failures before 
        changing the member's status to ERROR. Must be a number between 1 and 10.
        The default is 3. Changing this updates the max_retries_down of the
        existing monitor.
        """
        return pulumi.get(self, "max_retries_down")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Monitor.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the pool that this monitor will be assigned to.
        """
        return pulumi.get(self, "pool_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a monitor. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        monitor.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required for admins. The UUID of the tenant who owns
        the monitor.  Only administrative users can specify a tenant UUID
        other than their own. Changing this creates a new monitor.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum number of seconds for a monitor to wait for a
        ping reply before it times out. The value must be less than the delay
        value.
        """
        return pulumi.get(self, "timeout")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of probe, which is PING, TCP, HTTP, HTTPS,
        TLS-HELLO, SCTP or UDP-CONNECT, that is sent by the loadbalancer to
        verify the member state. Changing this creates a new monitor.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="urlPath")
    def url_path(self) -> pulumi.Output[_builtins.str]:
        """
        Required for HTTP(S) types. URI path that will be
        accessed if monitor type is HTTP or HTTPS. Default is `/`.
        """
        return pulumi.get(self, "url_path")

