# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ShareArgs', 'Share']

@pulumi.input_type
class ShareArgs:
    def __init__(__self__, *,
                 share_proto: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.int],
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_type: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Share resource.
        :param pulumi.Input[_builtins.str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[_builtins.int] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[_builtins.str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[_builtins.str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Shared File System
               client. A Shared File System client is needed to create a share. Changing
               this creates a new share.
        :param pulumi.Input[_builtins.str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[_builtins.str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        pulumi.set(__self__, "share_proto", share_proto)
        pulumi.set(__self__, "size", size)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if share_network_id is not None:
            pulumi.set(__self__, "share_network_id", share_network_id)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> pulumi.Input[_builtins.str]:
        """
        The share protocol - can either be NFS, CIFS,
        CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_proto", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        The share size, in GBs. The requested share size cannot be greater
        than the allowed GB quota. Changing this resizes the existing share.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share availability zone. Changing this creates a
        new share.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable description for the share.
        Changing this updates the description of the existing share.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The level of visibility for the share. Set to true to make
        share public. Set to false to make it private. Default value is false. Changing this
        updates the existing share.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        One or more metadata key and value pairs as a dictionary of
        strings.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the share. Changing this updates the name
        of the existing share.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Shared File System
        client. A Shared File System client is needed to create a share. Changing
        this creates a new share.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="shareNetworkId")
    def share_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of a share network where the share server exists
        or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
        the share_network_id value from the snapshot is used. Changing this creates a new share.
        """
        return pulumi.get(self, "share_network_id")

    @share_network_id.setter
    def share_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_network_id", value)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share type name. If you omit this parameter, the default
        share type is used.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_type", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the share's base snapshot. Changing this creates
        a new share.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.input_type
class _ShareState:
    def __init__(__self__, *,
                 all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 export_locations: Optional[pulumi.Input[Sequence[pulumi.Input['ShareExportLocationArgs']]]] = None,
                 has_replicas: Optional[pulumi.Input[_builtins.bool]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 share_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 share_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Share resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] all_metadata: The map of metadata, assigned on the share, which has been
               explicitly and implicitly added.
        :param pulumi.Input[_builtins.str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[Sequence[pulumi.Input['ShareExportLocationArgs']]] export_locations: A list of export locations. For example, when a share server
               has more than one network interface, it can have multiple export locations.
        :param pulumi.Input[_builtins.bool] has_replicas: Indicates whether a share has replicas or not.
        :param pulumi.Input[_builtins.str] host: The share host name.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[_builtins.str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[_builtins.str] project_id: The owner of the Share.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Shared File System
               client. A Shared File System client is needed to create a share. Changing
               this creates a new share.
        :param pulumi.Input[_builtins.str] replication_type: The share replication type.
        :param pulumi.Input[_builtins.str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_server_id: The UUID of the share server.
        :param pulumi.Input[_builtins.str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[_builtins.int] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[_builtins.str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        if all_metadata is not None:
            pulumi.set(__self__, "all_metadata", all_metadata)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if export_locations is not None:
            pulumi.set(__self__, "export_locations", export_locations)
        if has_replicas is not None:
            pulumi.set(__self__, "has_replicas", has_replicas)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if is_public is not None:
            pulumi.set(__self__, "is_public", is_public)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if share_network_id is not None:
            pulumi.set(__self__, "share_network_id", share_network_id)
        if share_proto is not None:
            pulumi.set(__self__, "share_proto", share_proto)
        if share_server_id is not None:
            pulumi.set(__self__, "share_server_id", share_server_id)
        if share_type is not None:
            pulumi.set(__self__, "share_type", share_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The map of metadata, assigned on the share, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_metadata")

    @all_metadata.setter
    def all_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "all_metadata", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share availability zone. Changing this creates a
        new share.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The human-readable description for the share.
        Changing this updates the description of the existing share.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="exportLocations")
    def export_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShareExportLocationArgs']]]]:
        """
        A list of export locations. For example, when a share server
        has more than one network interface, it can have multiple export locations.
        """
        return pulumi.get(self, "export_locations")

    @export_locations.setter
    def export_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShareExportLocationArgs']]]]):
        pulumi.set(self, "export_locations", value)

    @_builtins.property
    @pulumi.getter(name="hasReplicas")
    def has_replicas(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether a share has replicas or not.
        """
        return pulumi.get(self, "has_replicas")

    @has_replicas.setter
    def has_replicas(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "has_replicas", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share host name.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        The level of visibility for the share. Set to true to make
        share public. Set to false to make it private. Default value is false. Changing this
        updates the existing share.
        """
        return pulumi.get(self, "is_public")

    @is_public.setter
    def is_public(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_public", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        One or more metadata key and value pairs as a dictionary of
        strings.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the share. Changing this updates the name
        of the existing share.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner of the Share.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to obtain the V2 Shared File System
        client. A Shared File System client is needed to create a share. Changing
        this creates a new share.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share replication type.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_type", value)

    @_builtins.property
    @pulumi.getter(name="shareNetworkId")
    def share_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of a share network where the share server exists
        or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
        the share_network_id value from the snapshot is used. Changing this creates a new share.
        """
        return pulumi.get(self, "share_network_id")

    @share_network_id.setter
    def share_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_network_id", value)

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share protocol - can either be NFS, CIFS,
        CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        """
        return pulumi.get(self, "share_proto")

    @share_proto.setter
    def share_proto(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_proto", value)

    @_builtins.property
    @pulumi.getter(name="shareServerId")
    def share_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the share server.
        """
        return pulumi.get(self, "share_server_id")

    @share_server_id.setter
    def share_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_server_id", value)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The share type name. If you omit this parameter, the default
        share type is used.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "share_type", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The share size, in GBs. The requested share size cannot be greater
        than the allowed GB quota. Changing this resizes the existing share.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The UUID of the share's base snapshot. Changing this creates
        a new share.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)


@pulumi.type_token("openstack:sharedfilesystem/share:Share")
class Share(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 share_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Use this resource to configure a share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            name="subnet_1",
            cidr="192.168.199.0/24",
            ip_version=4,
            network_id=network1.id)
        sharenetwork1 = openstack.sharedfilesystem.ShareNetwork("sharenetwork_1",
            name="test_sharenetwork",
            description="test share network with security services",
            neutron_net_id=network1.id,
            neutron_subnet_id=subnet1.id)
        share1 = openstack.sharedfilesystem.Share("share_1",
            name="nfs_share",
            description="test share description",
            share_proto="NFS",
            size=1,
            share_network_id=sharenetwork1.id)
        ```

        ## Import

        This resource can be imported by specifying the ID of the share:

        ```sh
        $ pulumi import openstack:sharedfilesystem/share:Share share_1 id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[_builtins.str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Shared File System
               client. A Shared File System client is needed to create a share. Changing
               this creates a new share.
        :param pulumi.Input[_builtins.str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[_builtins.int] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[_builtins.str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ShareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to configure a share.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            name="subnet_1",
            cidr="192.168.199.0/24",
            ip_version=4,
            network_id=network1.id)
        sharenetwork1 = openstack.sharedfilesystem.ShareNetwork("sharenetwork_1",
            name="test_sharenetwork",
            description="test share network with security services",
            neutron_net_id=network1.id,
            neutron_subnet_id=subnet1.id)
        share1 = openstack.sharedfilesystem.Share("share_1",
            name="nfs_share",
            description="test share description",
            share_proto="NFS",
            size=1,
            share_network_id=sharenetwork1.id)
        ```

        ## Import

        This resource can be imported by specifying the ID of the share:

        ```sh
        $ pulumi import openstack:sharedfilesystem/share:Share share_1 id
        ```

        :param str resource_name: The name of the resource.
        :param ShareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 is_public: Optional[pulumi.Input[_builtins.bool]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 share_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 share_proto: Optional[pulumi.Input[_builtins.str]] = None,
                 share_type: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShareArgs.__new__(ShareArgs)

            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["description"] = description
            __props__.__dict__["is_public"] = is_public
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["share_network_id"] = share_network_id
            if share_proto is None and not opts.urn:
                raise TypeError("Missing required property 'share_proto'")
            __props__.__dict__["share_proto"] = share_proto
            __props__.__dict__["share_type"] = share_type
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["snapshot_id"] = snapshot_id
            __props__.__dict__["all_metadata"] = None
            __props__.__dict__["export_locations"] = None
            __props__.__dict__["has_replicas"] = None
            __props__.__dict__["host"] = None
            __props__.__dict__["project_id"] = None
            __props__.__dict__["replication_type"] = None
            __props__.__dict__["share_server_id"] = None
        super(Share, __self__).__init__(
            'openstack:sharedfilesystem/share:Share',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            all_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            export_locations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShareExportLocationArgs', 'ShareExportLocationArgsDict']]]]] = None,
            has_replicas: Optional[pulumi.Input[_builtins.bool]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            is_public: Optional[pulumi.Input[_builtins.bool]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replication_type: Optional[pulumi.Input[_builtins.str]] = None,
            share_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            share_proto: Optional[pulumi.Input[_builtins.str]] = None,
            share_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            share_type: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.int]] = None,
            snapshot_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Share':
        """
        Get an existing Share resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] all_metadata: The map of metadata, assigned on the share, which has been
               explicitly and implicitly added.
        :param pulumi.Input[_builtins.str] availability_zone: The share availability zone. Changing this creates a
               new share.
        :param pulumi.Input[_builtins.str] description: The human-readable description for the share.
               Changing this updates the description of the existing share.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShareExportLocationArgs', 'ShareExportLocationArgsDict']]]] export_locations: A list of export locations. For example, when a share server
               has more than one network interface, it can have multiple export locations.
        :param pulumi.Input[_builtins.bool] has_replicas: Indicates whether a share has replicas or not.
        :param pulumi.Input[_builtins.str] host: The share host name.
        :param pulumi.Input[_builtins.bool] is_public: The level of visibility for the share. Set to true to make
               share public. Set to false to make it private. Default value is false. Changing this
               updates the existing share.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: One or more metadata key and value pairs as a dictionary of
               strings.
        :param pulumi.Input[_builtins.str] name: The name of the share. Changing this updates the name
               of the existing share.
        :param pulumi.Input[_builtins.str] project_id: The owner of the Share.
        :param pulumi.Input[_builtins.str] region: The region in which to obtain the V2 Shared File System
               client. A Shared File System client is needed to create a share. Changing
               this creates a new share.
        :param pulumi.Input[_builtins.str] replication_type: The share replication type.
        :param pulumi.Input[_builtins.str] share_network_id: The UUID of a share network where the share server exists
               or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
               the share_network_id value from the snapshot is used. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_proto: The share protocol - can either be NFS, CIFS,
               CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        :param pulumi.Input[_builtins.str] share_server_id: The UUID of the share server.
        :param pulumi.Input[_builtins.str] share_type: The share type name. If you omit this parameter, the default
               share type is used.
        :param pulumi.Input[_builtins.int] size: The share size, in GBs. The requested share size cannot be greater
               than the allowed GB quota. Changing this resizes the existing share.
        :param pulumi.Input[_builtins.str] snapshot_id: The UUID of the share's base snapshot. Changing this creates
               a new share.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShareState.__new__(_ShareState)

        __props__.__dict__["all_metadata"] = all_metadata
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["description"] = description
        __props__.__dict__["export_locations"] = export_locations
        __props__.__dict__["has_replicas"] = has_replicas
        __props__.__dict__["host"] = host
        __props__.__dict__["is_public"] = is_public
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["replication_type"] = replication_type
        __props__.__dict__["share_network_id"] = share_network_id
        __props__.__dict__["share_proto"] = share_proto
        __props__.__dict__["share_server_id"] = share_server_id
        __props__.__dict__["share_type"] = share_type
        __props__.__dict__["size"] = size
        __props__.__dict__["snapshot_id"] = snapshot_id
        return Share(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allMetadata")
    def all_metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The map of metadata, assigned on the share, which has been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_metadata")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        The share availability zone. Changing this creates a
        new share.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The human-readable description for the share.
        Changing this updates the description of the existing share.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="exportLocations")
    def export_locations(self) -> pulumi.Output[Sequence['outputs.ShareExportLocation']]:
        """
        A list of export locations. For example, when a share server
        has more than one network interface, it can have multiple export locations.
        """
        return pulumi.get(self, "export_locations")

    @_builtins.property
    @pulumi.getter(name="hasReplicas")
    def has_replicas(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether a share has replicas or not.
        """
        return pulumi.get(self, "has_replicas")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The share host name.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        The level of visibility for the share. Set to true to make
        share public. Set to false to make it private. Default value is false. Changing this
        updates the existing share.
        """
        return pulumi.get(self, "is_public")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        One or more metadata key and value pairs as a dictionary of
        strings.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the share. Changing this updates the name
        of the existing share.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The owner of the Share.
        """
        return pulumi.get(self, "project_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to obtain the V2 Shared File System
        client. A Shared File System client is needed to create a share. Changing
        this creates a new share.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> pulumi.Output[_builtins.str]:
        """
        The share replication type.
        """
        return pulumi.get(self, "replication_type")

    @_builtins.property
    @pulumi.getter(name="shareNetworkId")
    def share_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of a share network where the share server exists
        or will be created. If `share_network_id` is not set and you provide a `snapshot_id`,
        the share_network_id value from the snapshot is used. Changing this creates a new share.
        """
        return pulumi.get(self, "share_network_id")

    @_builtins.property
    @pulumi.getter(name="shareProto")
    def share_proto(self) -> pulumi.Output[_builtins.str]:
        """
        The share protocol - can either be NFS, CIFS,
        CEPHFS, GLUSTERFS, HDFS or MAPRFS. Changing this creates a new share.
        """
        return pulumi.get(self, "share_proto")

    @_builtins.property
    @pulumi.getter(name="shareServerId")
    def share_server_id(self) -> pulumi.Output[_builtins.str]:
        """
        The UUID of the share server.
        """
        return pulumi.get(self, "share_server_id")

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Output[_builtins.str]:
        """
        The share type name. If you omit this parameter, the default
        share type is used.
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.int]:
        """
        The share size, in GBs. The requested share size cannot be greater
        than the allowed GB quota. Changing this resizes the existing share.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The UUID of the share's base snapshot. Changing this creates
        a new share.
        """
        return pulumi.get(self, "snapshot_id")

