# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AmplifyApp <a name="AmplifyApp" id="must-cdk.AmplifyApp"></a>

#### Initializers <a name="Initializers" id="must-cdk.AmplifyApp.Initializer"></a>

```typescript
import { AmplifyApp } from 'must-cdk'

new AmplifyApp(scope: Construct, id: string, props: AmplifyAppProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.AmplifyAppProps">AmplifyAppProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.AmplifyApp.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.AmplifyApp.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.AmplifyApp.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.AmplifyAppProps">AmplifyAppProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.toString">toString</a></code> | Returns a string representation of this construct. |

---

##### `toString` <a name="toString" id="must-cdk.AmplifyApp.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.AmplifyApp.isConstruct"></a>

```typescript
import { AmplifyApp } from 'must-cdk'

AmplifyApp.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.AmplifyApp.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.AmplifyApp.property.app">app</a></code> | <code>aws-cdk-lib.aws_amplify.CfnApp</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.branches">branches</a></code> | <code>aws-cdk-lib.aws_amplify.CfnBranch[]</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.domain">domain</a></code> | <code>aws-cdk-lib.aws_amplify.CfnDomain</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.AmplifyApp.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `app`<sup>Required</sup> <a name="app" id="must-cdk.AmplifyApp.property.app"></a>

```typescript
public readonly app: CfnApp;
```

- *Type:* aws-cdk-lib.aws_amplify.CfnApp

---

##### `branches`<sup>Required</sup> <a name="branches" id="must-cdk.AmplifyApp.property.branches"></a>

```typescript
public readonly branches: CfnBranch[];
```

- *Type:* aws-cdk-lib.aws_amplify.CfnBranch[]

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.AmplifyApp.property.domain"></a>

```typescript
public readonly domain: CfnDomain;
```

- *Type:* aws-cdk-lib.aws_amplify.CfnDomain

---


### ApiGatewayToLambda <a name="ApiGatewayToLambda" id="must-cdk.ApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.ApiGatewayToLambda.Initializer"></a>

```typescript
import { ApiGatewayToLambda } from 'must-cdk'

new ApiGatewayToLambda(scope: Construct, id: string, props: ApiGatewayToLambdaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.ApiGatewayToLambdaProps">ApiGatewayToLambdaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.ApiGatewayToLambdaProps">ApiGatewayToLambdaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.ApiGatewayToLambda.addRoute">addRoute</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `toString` <a name="toString" id="must-cdk.ApiGatewayToLambda.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addRoute` <a name="addRoute" id="must-cdk.ApiGatewayToLambda.addRoute"></a>

```typescript
public addRoute(route: CustomRoute): Method
```

Add a custom route after construction (for dynamic route addition).

###### `route`<sup>Required</sup> <a name="route" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.route"></a>

- *Type:* <a href="#must-cdk.CustomRoute">CustomRoute</a>

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.ApiGatewayToLambda.isConstruct"></a>

```typescript
import { ApiGatewayToLambda } from 'must-cdk'

ApiGatewayToLambda.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.ApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGateway">apiGateway</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApi</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiUrl">apiUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup">apiGatewayLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.aRecord">aRecord</a></code> | <code>aws-cdk-lib.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.domain">domain</a></code> | <code>aws-cdk-lib.aws_apigateway.DomainName</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.usagePlan">usagePlan</a></code> | <code>aws-cdk-lib.aws_apigateway.UsagePlan</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.ApiGatewayToLambda.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGateway`<sup>Required</sup> <a name="apiGateway" id="must-cdk.ApiGatewayToLambda.property.apiGateway"></a>

```typescript
public readonly apiGateway: RestApi;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApi

---

##### `apiUrl`<sup>Required</sup> <a name="apiUrl" id="must-cdk.ApiGatewayToLambda.property.apiUrl"></a>

```typescript
public readonly apiUrl: string;
```

- *Type:* string

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.ApiGatewayToLambda.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `apiGatewayLogGroup`<sup>Optional</sup> <a name="apiGatewayLogGroup" id="must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```typescript
public readonly apiGatewayLogGroup: LogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroup

---

##### `aRecord`<sup>Optional</sup> <a name="aRecord" id="must-cdk.ApiGatewayToLambda.property.aRecord"></a>

```typescript
public readonly aRecord: ARecord;
```

- *Type:* aws-cdk-lib.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.ApiGatewayToLambda.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.ApiGatewayToLambda.property.domain"></a>

```typescript
public readonly domain: DomainName;
```

- *Type:* aws-cdk-lib.aws_apigateway.DomainName

---

##### `usagePlan`<sup>Optional</sup> <a name="usagePlan" id="must-cdk.ApiGatewayToLambda.property.usagePlan"></a>

```typescript
public readonly usagePlan: UsagePlan;
```

- *Type:* aws-cdk-lib.aws_apigateway.UsagePlan

---


### CloudFrontToOrigins <a name="CloudFrontToOrigins" id="must-cdk.CloudFrontToOrigins"></a>

#### Initializers <a name="Initializers" id="must-cdk.CloudFrontToOrigins.Initializer"></a>

```typescript
import { CloudFrontToOrigins } from 'must-cdk'

new CloudFrontToOrigins(scope: Construct, id: string, props: CloudFrontToOriginsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.CloudFrontToOriginsProps">CloudFrontToOriginsProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.CloudFrontToOriginsProps">CloudFrontToOriginsProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getHttpOrigin">getHttpOrigin</a></code> | Get HTTP origin by origin ID. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getS3Bucket">getS3Bucket</a></code> | Get S3 bucket by origin ID. |

---

##### `toString` <a name="toString" id="must-cdk.CloudFrontToOrigins.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `getHttpOrigin` <a name="getHttpOrigin" id="must-cdk.CloudFrontToOrigins.getHttpOrigin"></a>

```typescript
public getHttpOrigin(originId: string): HttpOrigin
```

Get HTTP origin by origin ID.

###### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CloudFrontToOrigins.getHttpOrigin.parameter.originId"></a>

- *Type:* string

---

##### `getS3Bucket` <a name="getS3Bucket" id="must-cdk.CloudFrontToOrigins.getS3Bucket"></a>

```typescript
public getS3Bucket(originId: string): IBucket
```

Get S3 bucket by origin ID.

###### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CloudFrontToOrigins.getS3Bucket.parameter.originId"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.CloudFrontToOrigins.isConstruct"></a>

```typescript
import { CloudFrontToOrigins } from 'must-cdk'

CloudFrontToOrigins.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.CloudFrontToOrigins.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.aRecords">aRecords</a></code> | <code>aws-cdk-lib.aws_route53.ARecord[]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distribution">distribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionDomainName">distributionDomainName</a></code> | <code>string</code> | Get the CloudFront distribution domain name. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionUrl">distributionUrl</a></code> | <code>string</code> | Get the CloudFront distribution URL with protocol. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOriginIds">httpOriginIds</a></code> | <code>string[]</code> | Get all HTTP origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOrigins">httpOrigins</a></code> | <code><a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>[]</code> | Get all HTTP origins as an array of objects with ID and origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3OriginIds">s3OriginIds</a></code> | <code>string[]</code> | Get all S3 bucket origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3Origins">s3Origins</a></code> | <code><a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>[]</code> | Get all S3 buckets as an array of objects with ID and bucket. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.customDomainUrl">customDomainUrl</a></code> | <code>string</code> | Get the custom domain URL (if configured). |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.domainNames">domainNames</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.logBucket">logBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.CloudFrontToOrigins.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `aRecords`<sup>Required</sup> <a name="aRecords" id="must-cdk.CloudFrontToOrigins.property.aRecords"></a>

```typescript
public readonly aRecords: ARecord[];
```

- *Type:* aws-cdk-lib.aws_route53.ARecord[]

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="must-cdk.CloudFrontToOrigins.property.distribution"></a>

```typescript
public readonly distribution: Distribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.Distribution

---

##### `distributionDomainName`<sup>Required</sup> <a name="distributionDomainName" id="must-cdk.CloudFrontToOrigins.property.distributionDomainName"></a>

```typescript
public readonly distributionDomainName: string;
```

- *Type:* string

Get the CloudFront distribution domain name.

---

##### `distributionUrl`<sup>Required</sup> <a name="distributionUrl" id="must-cdk.CloudFrontToOrigins.property.distributionUrl"></a>

```typescript
public readonly distributionUrl: string;
```

- *Type:* string

Get the CloudFront distribution URL with protocol.

---

##### `httpOriginIds`<sup>Required</sup> <a name="httpOriginIds" id="must-cdk.CloudFrontToOrigins.property.httpOriginIds"></a>

```typescript
public readonly httpOriginIds: string[];
```

- *Type:* string[]

Get all HTTP origin IDs.

---

##### `httpOrigins`<sup>Required</sup> <a name="httpOrigins" id="must-cdk.CloudFrontToOrigins.property.httpOrigins"></a>

```typescript
public readonly httpOrigins: HttpOriginInfo[];
```

- *Type:* <a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>[]

Get all HTTP origins as an array of objects with ID and origin.

---

##### `s3OriginIds`<sup>Required</sup> <a name="s3OriginIds" id="must-cdk.CloudFrontToOrigins.property.s3OriginIds"></a>

```typescript
public readonly s3OriginIds: string[];
```

- *Type:* string[]

Get all S3 bucket origin IDs.

---

##### `s3Origins`<sup>Required</sup> <a name="s3Origins" id="must-cdk.CloudFrontToOrigins.property.s3Origins"></a>

```typescript
public readonly s3Origins: S3OriginInfo[];
```

- *Type:* <a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>[]

Get all S3 buckets as an array of objects with ID and bucket.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `customDomainUrl`<sup>Optional</sup> <a name="customDomainUrl" id="must-cdk.CloudFrontToOrigins.property.customDomainUrl"></a>

```typescript
public readonly customDomainUrl: string;
```

- *Type:* string

Get the custom domain URL (if configured).

---

##### `domainNames`<sup>Optional</sup> <a name="domainNames" id="must-cdk.CloudFrontToOrigins.property.domainNames"></a>

```typescript
public readonly domainNames: string[];
```

- *Type:* string[]

---

##### `logBucket`<sup>Optional</sup> <a name="logBucket" id="must-cdk.CloudFrontToOrigins.property.logBucket"></a>

```typescript
public readonly logBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---


### EcsCodeDeploy <a name="EcsCodeDeploy" id="must-cdk.EcsCodeDeploy"></a>

A CDK construct that creates an ECS Fargate service with CodeDeploy blue-green deployment capability.

This construct provides a modular approach to deploy containerized applications with blue-green deployment.

#### Initializers <a name="Initializers" id="must-cdk.EcsCodeDeploy.Initializer"></a>

```typescript
import { EcsCodeDeploy } from 'must-cdk'

new EcsCodeDeploy(scope: Construct, id: string, props: EcsCodeDeployProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.EcsCodeDeployProps">EcsCodeDeployProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.EcsCodeDeploy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.EcsCodeDeploy.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.EcsCodeDeploy.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.EcsCodeDeployProps">EcsCodeDeployProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.EcsCodeDeploy.allListeners">allListeners</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.blueListener">blueListener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.greenListener">greenListener</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="must-cdk.EcsCodeDeploy.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `allListeners` <a name="allListeners" id="must-cdk.EcsCodeDeploy.allListeners"></a>

```typescript
public allListeners(): ApplicationListener[]
```

##### `blueListener` <a name="blueListener" id="must-cdk.EcsCodeDeploy.blueListener"></a>

```typescript
public blueListener(): ApplicationListener
```

##### `greenListener` <a name="greenListener" id="must-cdk.EcsCodeDeploy.greenListener"></a>

```typescript
public greenListener(): ApplicationListener
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.EcsCodeDeploy.isConstruct"></a>

```typescript
import { EcsCodeDeploy } from 'must-cdk'

EcsCodeDeploy.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.EcsCodeDeploy.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.application">application</a></code> | <code>aws-cdk-lib.aws_codedeploy.EcsApplication</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.containers">containers</a></code> | <code>aws-cdk-lib.aws_ecs.ContainerDefinition[]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.listeners">listeners</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener[]</code> | Get all listeners from the load balancer. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancer">loadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancerDnsName">loadBalancerDnsName</a></code> | <code>string</code> | Get the load balancer DNS name. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.productionListener">productionListener</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener</code> | Get the production listener. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.productionTargetGroup">productionTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.service">service</a></code> | <code>aws-cdk-lib.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.serviceArn">serviceArn</a></code> | <code>string</code> | Get the service ARN. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskDefinition">taskDefinition</a></code> | <code>aws-cdk-lib.aws_ecs.TaskDefinition</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.testListener">testListener</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener</code> | Get the test listener. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.testTargetGroup">testTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.EcsCodeDeploy.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `application`<sup>Required</sup> <a name="application" id="must-cdk.EcsCodeDeploy.property.application"></a>

```typescript
public readonly application: EcsApplication;
```

- *Type:* aws-cdk-lib.aws_codedeploy.EcsApplication

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeploy.property.containers"></a>

```typescript
public readonly containers: ContainerDefinition[];
```

- *Type:* aws-cdk-lib.aws_ecs.ContainerDefinition[]

---

##### `listeners`<sup>Required</sup> <a name="listeners" id="must-cdk.EcsCodeDeploy.property.listeners"></a>

```typescript
public readonly listeners: ApplicationListener[];
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener[]

Get all listeners from the load balancer.

---

##### `loadBalancer`<sup>Required</sup> <a name="loadBalancer" id="must-cdk.EcsCodeDeploy.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: ApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `loadBalancerDnsName`<sup>Required</sup> <a name="loadBalancerDnsName" id="must-cdk.EcsCodeDeploy.property.loadBalancerDnsName"></a>

```typescript
public readonly loadBalancerDnsName: string;
```

- *Type:* string

Get the load balancer DNS name.

---

##### `productionListener`<sup>Required</sup> <a name="productionListener" id="must-cdk.EcsCodeDeploy.property.productionListener"></a>

```typescript
public readonly productionListener: ApplicationListener;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener

Get the production listener.

---

##### `productionTargetGroup`<sup>Required</sup> <a name="productionTargetGroup" id="must-cdk.EcsCodeDeploy.property.productionTargetGroup"></a>

```typescript
public readonly productionTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `service`<sup>Required</sup> <a name="service" id="must-cdk.EcsCodeDeploy.property.service"></a>

```typescript
public readonly service: FargateService;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateService

---

##### `serviceArn`<sup>Required</sup> <a name="serviceArn" id="must-cdk.EcsCodeDeploy.property.serviceArn"></a>

```typescript
public readonly serviceArn: string;
```

- *Type:* string

Get the service ARN.

---

##### `taskDefinition`<sup>Required</sup> <a name="taskDefinition" id="must-cdk.EcsCodeDeploy.property.taskDefinition"></a>

```typescript
public readonly taskDefinition: TaskDefinition;
```

- *Type:* aws-cdk-lib.aws_ecs.TaskDefinition

---

##### `testListener`<sup>Required</sup> <a name="testListener" id="must-cdk.EcsCodeDeploy.property.testListener"></a>

```typescript
public readonly testListener: ApplicationListener;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener

Get the test listener.

---

##### `testTargetGroup`<sup>Required</sup> <a name="testTargetGroup" id="must-cdk.EcsCodeDeploy.property.testTargetGroup"></a>

```typescript
public readonly testTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---


### WebSocketApiGatewayToLambda <a name="WebSocketApiGatewayToLambda" id="must-cdk.WebSocketApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.WebSocketApiGatewayToLambda.Initializer"></a>

```typescript
import { WebSocketApiGatewayToLambda } from 'must-cdk'

new WebSocketApiGatewayToLambda(scope: Construct, id: string, props: WebSocketApiGatewayToLambdaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps">WebSocketApiGatewayToLambdaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.WebSocketApiGatewayToLambdaProps">WebSocketApiGatewayToLambdaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.addRoute">addRoute</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `toString` <a name="toString" id="must-cdk.WebSocketApiGatewayToLambda.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addRoute` <a name="addRoute" id="must-cdk.WebSocketApiGatewayToLambda.addRoute"></a>

```typescript
public addRoute(route: WebSocketRoute): WebSocketRoute
```

Add a custom route after construction (for dynamic route addition).

###### `route`<sup>Required</sup> <a name="route" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.route"></a>

- *Type:* <a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct"></a>

```typescript
import { WebSocketApiGatewayToLambda } from 'must-cdk'

WebSocketApiGatewayToLambda.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi">webSocketApi</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketApi</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage">webSocketStage</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketStage</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl">webSocketUrl</a></code> | <code>string</code> | Get the WebSocket API URL (useful for outputs). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup">apiGatewayLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.aRecord">aRecord</a></code> | <code>aws-cdk-lib.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.domain">domain</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.DomainName</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.WebSocketApiGatewayToLambda.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `webSocketApi`<sup>Required</sup> <a name="webSocketApi" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi"></a>

```typescript
public readonly webSocketApi: WebSocketApi;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketApi

---

##### `webSocketStage`<sup>Required</sup> <a name="webSocketStage" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage"></a>

```typescript
public readonly webSocketStage: WebSocketStage;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketStage

---

##### `webSocketUrl`<sup>Required</sup> <a name="webSocketUrl" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl"></a>

```typescript
public readonly webSocketUrl: string;
```

- *Type:* string

Get the WebSocket API URL (useful for outputs).

---

##### `apiGatewayLogGroup`<sup>Optional</sup> <a name="apiGatewayLogGroup" id="must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```typescript
public readonly apiGatewayLogGroup: LogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroup

---

##### `aRecord`<sup>Optional</sup> <a name="aRecord" id="must-cdk.WebSocketApiGatewayToLambda.property.aRecord"></a>

```typescript
public readonly aRecord: ARecord;
```

- *Type:* aws-cdk-lib.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.WebSocketApiGatewayToLambda.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.WebSocketApiGatewayToLambda.property.domain"></a>

```typescript
public readonly domain: DomainName;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.DomainName

---


## Structs <a name="Structs" id="Structs"></a>

### AmplifyAppProps <a name="AmplifyAppProps" id="must-cdk.AmplifyAppProps"></a>

Properties for creating an AWS Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.AmplifyAppProps.Initializer"></a>

```typescript
import { AmplifyAppProps } from 'must-cdk'

const amplifyAppProps: AmplifyAppProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyAppProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.AmplifyAppProps.property.appName">appName</a></code> | <code>string</code> | The name for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.repository">repository</a></code> | <code>string</code> | The Git repository URL for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.accessToken">accessToken</a></code> | <code>string</code> | GitHub personal access token for repository access. |
| <code><a href="#must-cdk.AmplifyAppProps.property.basicAuth">basicAuth</a></code> | <code><a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a></code> | Basic authentication configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.branches">branches</a></code> | <code><a href="#must-cdk.BranchOptions">BranchOptions</a>[]</code> | Branch configurations for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSettings">buildSettings</a></code> | <code><a href="#must-cdk.BuildSettings">BuildSettings</a></code> | Build settings for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSpec">buildSpec</a></code> | <code>string</code> | Build specification for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customDomain">customDomain</a></code> | <code><a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a></code> | Custom domain configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customRules">customRules</a></code> | <code><a href="#must-cdk.CustomRule">CustomRule</a>[]</code> | Custom rules for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.environmentVariables">environmentVariables</a></code> | <code>{[ key: string ]: string}</code> | Environment variables for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.platform">platform</a></code> | <code>string</code> | Platform for the Amplify app. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.AmplifyAppProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `appName`<sup>Required</sup> <a name="appName" id="must-cdk.AmplifyAppProps.property.appName"></a>

```typescript
public readonly appName: string;
```

- *Type:* string

The name for the Amplify app.

---

##### `repository`<sup>Required</sup> <a name="repository" id="must-cdk.AmplifyAppProps.property.repository"></a>

```typescript
public readonly repository: string;
```

- *Type:* string

The Git repository URL for the Amplify app.

Format: https://github.com/user/repo or similar.

---

##### `accessToken`<sup>Optional</sup> <a name="accessToken" id="must-cdk.AmplifyAppProps.property.accessToken"></a>

```typescript
public readonly accessToken: string;
```

- *Type:* string

GitHub personal access token for repository access.

If not provided, will attempt to use GitHub CLI token or MUFIN_PUSH_TOKEN environment variable.

Note: For production deployments, consider migrating to GitHub Apps for better security,
organization support, and higher rate limits after initial setup.

---

##### `basicAuth`<sup>Optional</sup> <a name="basicAuth" id="must-cdk.AmplifyAppProps.property.basicAuth"></a>

```typescript
public readonly basicAuth: BasicAuthConfig;
```

- *Type:* <a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a>

Basic authentication configuration for the Amplify app.

---

##### `branches`<sup>Optional</sup> <a name="branches" id="must-cdk.AmplifyAppProps.property.branches"></a>

```typescript
public readonly branches: BranchOptions[];
```

- *Type:* <a href="#must-cdk.BranchOptions">BranchOptions</a>[]

Branch configurations for the Amplify app.

If not provided, a default 'main' branch will be created.

---

##### `buildSettings`<sup>Optional</sup> <a name="buildSettings" id="must-cdk.AmplifyAppProps.property.buildSettings"></a>

```typescript
public readonly buildSettings: BuildSettings;
```

- *Type:* <a href="#must-cdk.BuildSettings">BuildSettings</a>

Build settings for the Amplify app.

---

##### `buildSpec`<sup>Optional</sup> <a name="buildSpec" id="must-cdk.AmplifyAppProps.property.buildSpec"></a>

```typescript
public readonly buildSpec: string;
```

- *Type:* string

Build specification for the Amplify app.

Defines the build commands and output artifacts.

---

##### `customDomain`<sup>Optional</sup> <a name="customDomain" id="must-cdk.AmplifyAppProps.property.customDomain"></a>

```typescript
public readonly customDomain: CustomDomainOptions;
```

- *Type:* <a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a>

Custom domain configuration for the Amplify app.

---

##### `customRules`<sup>Optional</sup> <a name="customRules" id="must-cdk.AmplifyAppProps.property.customRules"></a>

```typescript
public readonly customRules: CustomRule[];
```

- *Type:* <a href="#must-cdk.CustomRule">CustomRule</a>[]

Custom rules for the Amplify app.

Used for redirects, rewrites, and other routing rules.

---

##### `environmentVariables`<sup>Optional</sup> <a name="environmentVariables" id="must-cdk.AmplifyAppProps.property.environmentVariables"></a>

```typescript
public readonly environmentVariables: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Environment variables for the Amplify app.

These will be available during the build process.

---

##### `platform`<sup>Optional</sup> <a name="platform" id="must-cdk.AmplifyAppProps.property.platform"></a>

```typescript
public readonly platform: string;
```

- *Type:* string
- *Default:* "WEB"

Platform for the Amplify app.

---

### ApiGatewayToLambdaProps <a name="ApiGatewayToLambdaProps" id="must-cdk.ApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.ApiGatewayToLambdaProps.Initializer"></a>

```typescript
import { ApiGatewayToLambdaProps } from 'must-cdk'

const apiGatewayToLambdaProps: ApiGatewayToLambdaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.apiName">apiName</a></code> | <code>string</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.binaryMediaTypes">binaryMediaTypes</a></code> | <code>string[]</code> | Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan">createUsagePlan</a></code> | <code>boolean</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customRoutes">customRoutes</a></code> | <code><a href="#must-cdk.CustomRoute">CustomRoute</a>[]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.existingCertificate">existingCertificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps">lambdaApiProps</a></code> | <code>aws-cdk-lib.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.logGroupProps">logGroupProps</a></code> | <code>aws-cdk-lib.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.proxy">proxy</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.restApiProps">restApiProps</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.ApiGatewayToLambdaProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `apiName`<sup>Required</sup> <a name="apiName" id="must-cdk.ApiGatewayToLambdaProps.property.apiName"></a>

```typescript
public readonly apiName: string;
```

- *Type:* string

API configuration.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `binaryMediaTypes`<sup>Optional</sup> <a name="binaryMediaTypes" id="must-cdk.ApiGatewayToLambdaProps.property.binaryMediaTypes"></a>

```typescript
public readonly binaryMediaTypes: string[];
```

- *Type:* string[]

Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used.

---

##### `createUsagePlan`<sup>Optional</sup> <a name="createUsagePlan" id="must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan"></a>

```typescript
public readonly createUsagePlan: boolean;
```

- *Type:* boolean

Whether to create a Usage Plan.

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.ApiGatewayToLambdaProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Optional custom domain name for API Gateway.

---

##### `customRoutes`<sup>Optional</sup> <a name="customRoutes" id="must-cdk.ApiGatewayToLambdaProps.property.customRoutes"></a>

```typescript
public readonly customRoutes: CustomRoute[];
```

- *Type:* <a href="#must-cdk.CustomRoute">CustomRoute</a>[]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.ApiGatewayToLambdaProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean

Enable CloudWatch logging for API Gateway.

---

##### `existingCertificate`<sup>Optional</sup> <a name="existingCertificate" id="must-cdk.ApiGatewayToLambdaProps.property.existingCertificate"></a>

```typescript
public readonly existingCertificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.ApiGatewayToLambdaProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambdaApiProps`<sup>Optional</sup> <a name="lambdaApiProps" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps"></a>

```typescript
public readonly lambdaApiProps: LambdaRestApiProps;
```

- *Type:* aws-cdk-lib.aws_apigateway.LambdaRestApiProps

---

##### `logGroupProps`<sup>Optional</sup> <a name="logGroupProps" id="must-cdk.ApiGatewayToLambdaProps.property.logGroupProps"></a>

```typescript
public readonly logGroupProps: LogGroupProps;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambdaProps.property.proxy"></a>

```typescript
public readonly proxy: boolean;
```

- *Type:* boolean

---

##### `restApiProps`<sup>Optional</sup> <a name="restApiProps" id="must-cdk.ApiGatewayToLambdaProps.property.restApiProps"></a>

```typescript
public readonly restApiProps: RestApiProps;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApiProps

---

### AutoScalingProps <a name="AutoScalingProps" id="must-cdk.AutoScalingProps"></a>

Configuration for ECS service auto-scaling.

#### Initializer <a name="Initializer" id="must-cdk.AutoScalingProps.Initializer"></a>

```typescript
import { AutoScalingProps } from 'must-cdk'

const autoScalingProps: AutoScalingProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AutoScalingProps.property.maxCapacity">maxCapacity</a></code> | <code>number</code> | Maximum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.minCapacity">minCapacity</a></code> | <code>number</code> | Minimum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.cpuScale">cpuScale</a></code> | <code>aws-cdk-lib.aws_ecs.CpuUtilizationScalingProps</code> | Scale task based on CPU utilization. |
| <code><a href="#must-cdk.AutoScalingProps.property.memoryScale">memoryScale</a></code> | <code>aws-cdk-lib.aws_ecs.MemoryUtilizationScalingProps</code> | Scale task based on memory utilization. |

---

##### `maxCapacity`<sup>Required</sup> <a name="maxCapacity" id="must-cdk.AutoScalingProps.property.maxCapacity"></a>

```typescript
public readonly maxCapacity: number;
```

- *Type:* number

Maximum number of tasks to run.

---

##### `minCapacity`<sup>Required</sup> <a name="minCapacity" id="must-cdk.AutoScalingProps.property.minCapacity"></a>

```typescript
public readonly minCapacity: number;
```

- *Type:* number

Minimum number of tasks to run.

---

##### `cpuScale`<sup>Optional</sup> <a name="cpuScale" id="must-cdk.AutoScalingProps.property.cpuScale"></a>

```typescript
public readonly cpuScale: CpuUtilizationScalingProps;
```

- *Type:* aws-cdk-lib.aws_ecs.CpuUtilizationScalingProps

Scale task based on CPU utilization.

---

##### `memoryScale`<sup>Optional</sup> <a name="memoryScale" id="must-cdk.AutoScalingProps.property.memoryScale"></a>

```typescript
public readonly memoryScale: MemoryUtilizationScalingProps;
```

- *Type:* aws-cdk-lib.aws_ecs.MemoryUtilizationScalingProps

Scale task based on memory utilization.

---

### BasicAuthConfig <a name="BasicAuthConfig" id="must-cdk.BasicAuthConfig"></a>

Basic authentication configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BasicAuthConfig.Initializer"></a>

```typescript
import { BasicAuthConfig } from 'must-cdk'

const basicAuthConfig: BasicAuthConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BasicAuthConfig.property.password">password</a></code> | <code>string</code> | Password for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.username">username</a></code> | <code>string</code> | Username for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.enableBasicAuth">enableBasicAuth</a></code> | <code>boolean</code> | Whether to enable basic authentication. |

---

##### `password`<sup>Required</sup> <a name="password" id="must-cdk.BasicAuthConfig.property.password"></a>

```typescript
public readonly password: string;
```

- *Type:* string

Password for basic authentication.

---

##### `username`<sup>Required</sup> <a name="username" id="must-cdk.BasicAuthConfig.property.username"></a>

```typescript
public readonly username: string;
```

- *Type:* string

Username for basic authentication.

---

##### `enableBasicAuth`<sup>Optional</sup> <a name="enableBasicAuth" id="must-cdk.BasicAuthConfig.property.enableBasicAuth"></a>

```typescript
public readonly enableBasicAuth: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to enable basic authentication.

---

### BranchOptions <a name="BranchOptions" id="must-cdk.BranchOptions"></a>

Branch configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BranchOptions.Initializer"></a>

```typescript
import { BranchOptions } from 'must-cdk'

const branchOptions: BranchOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BranchOptions.property.branchName">branchName</a></code> | <code>string</code> | The name of the branch. |
| <code><a href="#must-cdk.BranchOptions.property.buildSpec">buildSpec</a></code> | <code>string</code> | Branch-specific build specification. |
| <code><a href="#must-cdk.BranchOptions.property.enableAutoBuild">enableAutoBuild</a></code> | <code>boolean</code> | Whether to enable automatic builds for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.environmentVariables">environmentVariables</a></code> | <code>{[ key: string ]: string}</code> | Environment variables specific to this branch. |
| <code><a href="#must-cdk.BranchOptions.property.framework">framework</a></code> | <code>string</code> | The framework for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.pullRequestPreview">pullRequestPreview</a></code> | <code>boolean</code> | Whether to enable pull request previews for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.stage">stage</a></code> | <code>string</code> | The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT). |

---

##### `branchName`<sup>Required</sup> <a name="branchName" id="must-cdk.BranchOptions.property.branchName"></a>

```typescript
public readonly branchName: string;
```

- *Type:* string

The name of the branch.

---

##### `buildSpec`<sup>Optional</sup> <a name="buildSpec" id="must-cdk.BranchOptions.property.buildSpec"></a>

```typescript
public readonly buildSpec: string;
```

- *Type:* string

Branch-specific build specification.

---

##### `enableAutoBuild`<sup>Optional</sup> <a name="enableAutoBuild" id="must-cdk.BranchOptions.property.enableAutoBuild"></a>

```typescript
public readonly enableAutoBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to enable automatic builds for this branch.

---

##### `environmentVariables`<sup>Optional</sup> <a name="environmentVariables" id="must-cdk.BranchOptions.property.environmentVariables"></a>

```typescript
public readonly environmentVariables: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Environment variables specific to this branch.

---

##### `framework`<sup>Optional</sup> <a name="framework" id="must-cdk.BranchOptions.property.framework"></a>

```typescript
public readonly framework: string;
```

- *Type:* string

The framework for this branch.

---

##### `pullRequestPreview`<sup>Optional</sup> <a name="pullRequestPreview" id="must-cdk.BranchOptions.property.pullRequestPreview"></a>

```typescript
public readonly pullRequestPreview: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable pull request previews for this branch.

---

##### `stage`<sup>Optional</sup> <a name="stage" id="must-cdk.BranchOptions.property.stage"></a>

```typescript
public readonly stage: string;
```

- *Type:* string
- *Default:* "PRODUCTION"

The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT).

---

### BuildSettings <a name="BuildSettings" id="must-cdk.BuildSettings"></a>

Build settings for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BuildSettings.Initializer"></a>

```typescript
import { BuildSettings } from 'must-cdk'

const buildSettings: BuildSettings = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BuildSettings.property.cacheType">cacheType</a></code> | <code>string</code> | Cache type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.computeType">computeType</a></code> | <code>string</code> | Compute type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchCreation">enableAutoBranchCreation</a></code> | <code>boolean</code> | Whether to enable automatic branch creation when a new branch is pushed to the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchDeletion">enableAutoBranchDeletion</a></code> | <code>boolean</code> | Whether to enable automatic branch deletion when a branch is deleted from the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableBranchAutoBuild">enableBranchAutoBuild</a></code> | <code>boolean</code> | Whether to enable automatic builds when code is pushed to a branch. |

---

##### `cacheType`<sup>Optional</sup> <a name="cacheType" id="must-cdk.BuildSettings.property.cacheType"></a>

```typescript
public readonly cacheType: string;
```

- *Type:* string
- *Default:* "AMPLIFY_MANAGED"

Cache type for the build.

---

##### `computeType`<sup>Optional</sup> <a name="computeType" id="must-cdk.BuildSettings.property.computeType"></a>

```typescript
public readonly computeType: string;
```

- *Type:* string
- *Default:* "STANDARD"

Compute type for the build.

---

##### `enableAutoBranchCreation`<sup>Optional</sup> <a name="enableAutoBranchCreation" id="must-cdk.BuildSettings.property.enableAutoBranchCreation"></a>

```typescript
public readonly enableAutoBranchCreation: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable automatic branch creation when a new branch is pushed to the repository.

---

##### `enableAutoBranchDeletion`<sup>Optional</sup> <a name="enableAutoBranchDeletion" id="must-cdk.BuildSettings.property.enableAutoBranchDeletion"></a>

```typescript
public readonly enableAutoBranchDeletion: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable automatic branch deletion when a branch is deleted from the repository.

---

##### `enableBranchAutoBuild`<sup>Optional</sup> <a name="enableBranchAutoBuild" id="must-cdk.BuildSettings.property.enableBranchAutoBuild"></a>

```typescript
public readonly enableBranchAutoBuild: boolean;
```

- *Type:* boolean
- *Default:* true

Whether to enable automatic builds when code is pushed to a branch.

---

### CacheBehaviorConfig <a name="CacheBehaviorConfig" id="must-cdk.CacheBehaviorConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.CacheBehaviorConfig.Initializer"></a>

```typescript
import { CacheBehaviorConfig } from 'must-cdk'

const cacheBehaviorConfig: CacheBehaviorConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originId">originId</a></code> | <code>string</code> | Origin ID to route this pattern to. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.pathPattern">pathPattern</a></code> | <code>string</code> | Path pattern for this behavior (e.g., "/api/*", "*.jpg"). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.allowedMethods">allowedMethods</a></code> | <code>aws-cdk-lib.aws_cloudfront.AllowedMethods</code> | Allowed HTTP methods. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachedMethods">cachedMethods</a></code> | <code>aws-cdk-lib.aws_cloudfront.CachedMethods</code> | Methods to cache. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicy">cachePolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.ICachePolicy</code> | Cache policy (alternative to cachePolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicyId">cachePolicyId</a></code> | <code>string</code> | Cache policy ID (use AWS managed policies). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.compress">compress</a></code> | <code>boolean</code> | Enable compression. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicy">originRequestPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.IOriginRequestPolicy</code> | Origin request policy (alternative to originRequestPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicyId">originRequestPolicyId</a></code> | <code>string</code> | Origin request policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy">responseHeadersPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.IResponseHeadersPolicy</code> | Response headers policy (alternative to responseHeadersPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId">responseHeadersPolicyId</a></code> | <code>string</code> | Response headers policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy">viewerProtocolPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.ViewerProtocolPolicy</code> | Viewer protocol policy. |

---

##### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CacheBehaviorConfig.property.originId"></a>

```typescript
public readonly originId: string;
```

- *Type:* string

Origin ID to route this pattern to.

---

##### `pathPattern`<sup>Required</sup> <a name="pathPattern" id="must-cdk.CacheBehaviorConfig.property.pathPattern"></a>

```typescript
public readonly pathPattern: string;
```

- *Type:* string

Path pattern for this behavior (e.g., "/api/*", "*.jpg").

---

##### `allowedMethods`<sup>Optional</sup> <a name="allowedMethods" id="must-cdk.CacheBehaviorConfig.property.allowedMethods"></a>

```typescript
public readonly allowedMethods: AllowedMethods;
```

- *Type:* aws-cdk-lib.aws_cloudfront.AllowedMethods
- *Default:* ALLOW_GET_HEAD for S3, ALLOW_ALL for HTTP

Allowed HTTP methods.

---

##### `cachedMethods`<sup>Optional</sup> <a name="cachedMethods" id="must-cdk.CacheBehaviorConfig.property.cachedMethods"></a>

```typescript
public readonly cachedMethods: CachedMethods;
```

- *Type:* aws-cdk-lib.aws_cloudfront.CachedMethods
- *Default:* CACHE_GET_HEAD_OPTIONS

Methods to cache.

---

##### `cachePolicy`<sup>Optional</sup> <a name="cachePolicy" id="must-cdk.CacheBehaviorConfig.property.cachePolicy"></a>

```typescript
public readonly cachePolicy: ICachePolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.ICachePolicy

Cache policy (alternative to cachePolicyId).

---

##### `cachePolicyId`<sup>Optional</sup> <a name="cachePolicyId" id="must-cdk.CacheBehaviorConfig.property.cachePolicyId"></a>

```typescript
public readonly cachePolicyId: string;
```

- *Type:* string

Cache policy ID (use AWS managed policies).

---

##### `compress`<sup>Optional</sup> <a name="compress" id="must-cdk.CacheBehaviorConfig.property.compress"></a>

```typescript
public readonly compress: boolean;
```

- *Type:* boolean
- *Default:* true

Enable compression.

---

##### `originRequestPolicy`<sup>Optional</sup> <a name="originRequestPolicy" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicy"></a>

```typescript
public readonly originRequestPolicy: IOriginRequestPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IOriginRequestPolicy

Origin request policy (alternative to originRequestPolicyId).

---

##### `originRequestPolicyId`<sup>Optional</sup> <a name="originRequestPolicyId" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicyId"></a>

```typescript
public readonly originRequestPolicyId: string;
```

- *Type:* string

Origin request policy ID.

---

##### `responseHeadersPolicy`<sup>Optional</sup> <a name="responseHeadersPolicy" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy"></a>

```typescript
public readonly responseHeadersPolicy: IResponseHeadersPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IResponseHeadersPolicy

Response headers policy (alternative to responseHeadersPolicyId).

---

##### `responseHeadersPolicyId`<sup>Optional</sup> <a name="responseHeadersPolicyId" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId"></a>

```typescript
public readonly responseHeadersPolicyId: string;
```

- *Type:* string

Response headers policy ID.

---

##### `viewerProtocolPolicy`<sup>Optional</sup> <a name="viewerProtocolPolicy" id="must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy"></a>

```typescript
public readonly viewerProtocolPolicy: ViewerProtocolPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.ViewerProtocolPolicy
- *Default:* REDIRECT_TO_HTTPS

Viewer protocol policy.

---

### CloudFrontToOriginsProps <a name="CloudFrontToOriginsProps" id="must-cdk.CloudFrontToOriginsProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.CloudFrontToOriginsProps.Initializer"></a>

```typescript
import { CloudFrontToOriginsProps } from 'must-cdk'

const cloudFrontToOriginsProps: CloudFrontToOriginsProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames">additionalDomainNames</a></code> | <code>string[]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors">cacheBehaviors</a></code> | <code><a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>[]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.comment">comment</a></code> | <code>string</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.createRoute53Records">createRoute53Records</a></code> | <code>boolean</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultOriginId">defaultOriginId</a></code> | <code>string</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultRootObject">defaultRootObject</a></code> | <code>string</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enabled">enabled</a></code> | <code>boolean</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableIpv6">enableIpv6</a></code> | <code>boolean</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.errorPages">errorPages</a></code> | <code>aws-cdk-lib.aws_cloudfront.ErrorResponse[]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.geoRestriction">geoRestriction</a></code> | <code>aws-cdk-lib.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpOrigins">httpOrigins</a></code> | <code><a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>[]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpVersion">httpVersion</a></code> | <code>aws-cdk-lib.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logBucket">logBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies">logIncludeCookies</a></code> | <code>boolean</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logPrefix">logPrefix</a></code> | <code>string</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.priceClass">priceClass</a></code> | <code>aws-cdk-lib.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.s3Origins">s3Origins</a></code> | <code><a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>[]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.webAclId">webAclId</a></code> | <code>string</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.CloudFrontToOriginsProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `additionalDomainNames`<sup>Optional</sup> <a name="additionalDomainNames" id="must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames"></a>

```typescript
public readonly additionalDomainNames: string[];
```

- *Type:* string[]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

CloudFront only supports one certificate per distribution.

---

##### `cacheBehaviors`<sup>Optional</sup> <a name="cacheBehaviors" id="must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors"></a>

```typescript
public readonly cacheBehaviors: CacheBehaviorConfig[];
```

- *Type:* <a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>[]

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOriginsProps.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

The certificate must cover all domains (customDomainName + additionalDomainNames).
CloudFront only supports one certificate per distribution.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOriginsProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

Comment for the distribution.

---

##### `createRoute53Records`<sup>Optional</sup> <a name="createRoute53Records" id="must-cdk.CloudFrontToOriginsProps.property.createRoute53Records"></a>

```typescript
public readonly createRoute53Records: boolean;
```

- *Type:* boolean
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.CloudFrontToOriginsProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Primary custom domain name for the CloudFront distribution.

---

##### `defaultOriginId`<sup>Optional</sup> <a name="defaultOriginId" id="must-cdk.CloudFrontToOriginsProps.property.defaultOriginId"></a>

```typescript
public readonly defaultOriginId: string;
```

- *Type:* string

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `defaultRootObject`<sup>Optional</sup> <a name="defaultRootObject" id="must-cdk.CloudFrontToOriginsProps.property.defaultRootObject"></a>

```typescript
public readonly defaultRootObject: string;
```

- *Type:* string
- *Default:* "index.html"

Default root object for the distribution.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOriginsProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the distribution is enabled.

---

##### `enableIpv6`<sup>Optional</sup> <a name="enableIpv6" id="must-cdk.CloudFrontToOriginsProps.property.enableIpv6"></a>

```typescript
public readonly enableIpv6: boolean;
```

- *Type:* boolean
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.CloudFrontToOriginsProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean
- *Default:* true

Enable CloudFront access logging.

---

##### `errorPages`<sup>Optional</sup> <a name="errorPages" id="must-cdk.CloudFrontToOriginsProps.property.errorPages"></a>

```typescript
public readonly errorPages: ErrorResponse[];
```

- *Type:* aws-cdk-lib.aws_cloudfront.ErrorResponse[]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geoRestriction`<sup>Optional</sup> <a name="geoRestriction" id="must-cdk.CloudFrontToOriginsProps.property.geoRestriction"></a>

```typescript
public readonly geoRestriction: GeoRestriction;
```

- *Type:* aws-cdk-lib.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.CloudFrontToOriginsProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `httpOrigins`<sup>Optional</sup> <a name="httpOrigins" id="must-cdk.CloudFrontToOriginsProps.property.httpOrigins"></a>

```typescript
public readonly httpOrigins: HttpOriginConfig[];
```

- *Type:* <a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>[]

HTTP origins configuration.

---

##### `httpVersion`<sup>Optional</sup> <a name="httpVersion" id="must-cdk.CloudFrontToOriginsProps.property.httpVersion"></a>

```typescript
public readonly httpVersion: HttpVersion;
```

- *Type:* aws-cdk-lib.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `logBucket`<sup>Optional</sup> <a name="logBucket" id="must-cdk.CloudFrontToOriginsProps.property.logBucket"></a>

```typescript
public readonly logBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `logIncludeCookies`<sup>Optional</sup> <a name="logIncludeCookies" id="must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies"></a>

```typescript
public readonly logIncludeCookies: boolean;
```

- *Type:* boolean
- *Default:* false

Include cookies in access logs.

---

##### `logPrefix`<sup>Optional</sup> <a name="logPrefix" id="must-cdk.CloudFrontToOriginsProps.property.logPrefix"></a>

```typescript
public readonly logPrefix: string;
```

- *Type:* string
- *Default:* "cloudfront"

Prefix for log files.

---

##### `priceClass`<sup>Optional</sup> <a name="priceClass" id="must-cdk.CloudFrontToOriginsProps.property.priceClass"></a>

```typescript
public readonly priceClass: PriceClass;
```

- *Type:* aws-cdk-lib.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3Origins`<sup>Optional</sup> <a name="s3Origins" id="must-cdk.CloudFrontToOriginsProps.property.s3Origins"></a>

```typescript
public readonly s3Origins: S3OriginConfig[];
```

- *Type:* <a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>[]

S3 origins configuration.

---

##### `webAclId`<sup>Optional</sup> <a name="webAclId" id="must-cdk.CloudFrontToOriginsProps.property.webAclId"></a>

```typescript
public readonly webAclId: string;
```

- *Type:* string

Web Application Firewall (WAF) web ACL ID.

---

### CodeDeployConfig <a name="CodeDeployConfig" id="must-cdk.CodeDeployConfig"></a>

Configuration for CodeDeploy deployment.

#### Initializer <a name="Initializer" id="must-cdk.CodeDeployConfig.Initializer"></a>

```typescript
import { CodeDeployConfig } from 'must-cdk'

const codeDeployConfig: CodeDeployConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CodeDeployConfig.property.terminationWaitTime">terminationWaitTime</a></code> | <code>aws-cdk-lib.Duration</code> | The termination wait time after deployment (default: 30 minutes). |
| <code><a href="#must-cdk.CodeDeployConfig.property.trafficRoutingInterval">trafficRoutingInterval</a></code> | <code>aws-cdk-lib.Duration</code> | The interval between traffic shifting increments (default: 1 minute). |
| <code><a href="#must-cdk.CodeDeployConfig.property.trafficRoutingStartPercent">trafficRoutingStartPercent</a></code> | <code>number</code> | The percentage of traffic to shift initially (default: 10%). |

---

##### `terminationWaitTime`<sup>Optional</sup> <a name="terminationWaitTime" id="must-cdk.CodeDeployConfig.property.terminationWaitTime"></a>

```typescript
public readonly terminationWaitTime: Duration;
```

- *Type:* aws-cdk-lib.Duration

The termination wait time after deployment (default: 30 minutes).

---

##### `trafficRoutingInterval`<sup>Optional</sup> <a name="trafficRoutingInterval" id="must-cdk.CodeDeployConfig.property.trafficRoutingInterval"></a>

```typescript
public readonly trafficRoutingInterval: Duration;
```

- *Type:* aws-cdk-lib.Duration

The interval between traffic shifting increments (default: 1 minute).

---

##### `trafficRoutingStartPercent`<sup>Optional</sup> <a name="trafficRoutingStartPercent" id="must-cdk.CodeDeployConfig.property.trafficRoutingStartPercent"></a>

```typescript
public readonly trafficRoutingStartPercent: number;
```

- *Type:* number

The percentage of traffic to shift initially (default: 10%).

---

### ContainerProps <a name="ContainerProps" id="must-cdk.ContainerProps"></a>

Configuration for the ECS Fargate task definition and container.

#### Initializer <a name="Initializer" id="must-cdk.ContainerProps.Initializer"></a>

```typescript
import { ContainerProps } from 'must-cdk'

const containerProps: ContainerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ContainerProps.property.containerPort">containerPort</a></code> | <code>number</code> | The port number the container listens on. |
| <code><a href="#must-cdk.ContainerProps.property.image">image</a></code> | <code>aws-cdk-lib.aws_ecs.ContainerImage</code> | Container image to deploy. |
| <code><a href="#must-cdk.ContainerProps.property.command">command</a></code> | <code>string[]</code> | Command to run in the container. |
| <code><a href="#must-cdk.ContainerProps.property.cpu">cpu</a></code> | <code>number</code> | CPU units for this container (default: uses task-level CPU allocation). |
| <code><a href="#must-cdk.ContainerProps.property.entryPoint">entryPoint</a></code> | <code>string[]</code> | Entry point for the container. |
| <code><a href="#must-cdk.ContainerProps.property.environment">environment</a></code> | <code>{[ key: string ]: string}</code> | Environment variables to set in the container. |
| <code><a href="#must-cdk.ContainerProps.property.essential">essential</a></code> | <code>boolean</code> | Whether this container is essential (default: true). |
| <code><a href="#must-cdk.ContainerProps.property.healthCheck">healthCheck</a></code> | <code>aws-cdk-lib.aws_ecs.HealthCheck</code> | Optional container health check configuration. |
| <code><a href="#must-cdk.ContainerProps.property.logging">logging</a></code> | <code>aws-cdk-lib.aws_ecs.LogDriver</code> | Optional log driver configuration for the container. |
| <code><a href="#must-cdk.ContainerProps.property.memoryLimit">memoryLimit</a></code> | <code>number</code> | Hard memory limit in MiB for the task (default: 2048). |
| <code><a href="#must-cdk.ContainerProps.property.memoryReservation">memoryReservation</a></code> | <code>number</code> | Soft memory reservation in MiB for the container (default: 1024). |
| <code><a href="#must-cdk.ContainerProps.property.name">name</a></code> | <code>string</code> | Optional container name (default: Container{index}). |
| <code><a href="#must-cdk.ContainerProps.property.secrets">secrets</a></code> | <code>{[ key: string ]: aws-cdk-lib.aws_ecs.Secret}</code> | Secrets to inject into the container from AWS Systems Manager Parameter Store or AWS Secrets Manager. |
| <code><a href="#must-cdk.ContainerProps.property.user">user</a></code> | <code>string</code> | User to run the container as. |
| <code><a href="#must-cdk.ContainerProps.property.workingDirectory">workingDirectory</a></code> | <code>string</code> | Working directory inside the container. |

---

##### `containerPort`<sup>Required</sup> <a name="containerPort" id="must-cdk.ContainerProps.property.containerPort"></a>

```typescript
public readonly containerPort: number;
```

- *Type:* number

The port number the container listens on.

---

##### `image`<sup>Required</sup> <a name="image" id="must-cdk.ContainerProps.property.image"></a>

```typescript
public readonly image: ContainerImage;
```

- *Type:* aws-cdk-lib.aws_ecs.ContainerImage

Container image to deploy.

---

##### `command`<sup>Optional</sup> <a name="command" id="must-cdk.ContainerProps.property.command"></a>

```typescript
public readonly command: string[];
```

- *Type:* string[]

Command to run in the container.

---

##### `cpu`<sup>Optional</sup> <a name="cpu" id="must-cdk.ContainerProps.property.cpu"></a>

```typescript
public readonly cpu: number;
```

- *Type:* number

CPU units for this container (default: uses task-level CPU allocation).

---

##### `entryPoint`<sup>Optional</sup> <a name="entryPoint" id="must-cdk.ContainerProps.property.entryPoint"></a>

```typescript
public readonly entryPoint: string[];
```

- *Type:* string[]

Entry point for the container.

---

##### `environment`<sup>Optional</sup> <a name="environment" id="must-cdk.ContainerProps.property.environment"></a>

```typescript
public readonly environment: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Environment variables to set in the container.

---

##### `essential`<sup>Optional</sup> <a name="essential" id="must-cdk.ContainerProps.property.essential"></a>

```typescript
public readonly essential: boolean;
```

- *Type:* boolean

Whether this container is essential (default: true).

---

##### `healthCheck`<sup>Optional</sup> <a name="healthCheck" id="must-cdk.ContainerProps.property.healthCheck"></a>

```typescript
public readonly healthCheck: HealthCheck;
```

- *Type:* aws-cdk-lib.aws_ecs.HealthCheck

Optional container health check configuration.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="must-cdk.ContainerProps.property.logging"></a>

```typescript
public readonly logging: LogDriver;
```

- *Type:* aws-cdk-lib.aws_ecs.LogDriver

Optional log driver configuration for the container.

---

##### `memoryLimit`<sup>Optional</sup> <a name="memoryLimit" id="must-cdk.ContainerProps.property.memoryLimit"></a>

```typescript
public readonly memoryLimit: number;
```

- *Type:* number

Hard memory limit in MiB for the task (default: 2048).

---

##### `memoryReservation`<sup>Optional</sup> <a name="memoryReservation" id="must-cdk.ContainerProps.property.memoryReservation"></a>

```typescript
public readonly memoryReservation: number;
```

- *Type:* number

Soft memory reservation in MiB for the container (default: 1024).

---

##### `name`<sup>Optional</sup> <a name="name" id="must-cdk.ContainerProps.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

Optional container name (default: Container{index}).

---

##### `secrets`<sup>Optional</sup> <a name="secrets" id="must-cdk.ContainerProps.property.secrets"></a>

```typescript
public readonly secrets: {[ key: string ]: Secret};
```

- *Type:* {[ key: string ]: aws-cdk-lib.aws_ecs.Secret}

Secrets to inject into the container from AWS Systems Manager Parameter Store or AWS Secrets Manager.

---

##### `user`<sup>Optional</sup> <a name="user" id="must-cdk.ContainerProps.property.user"></a>

```typescript
public readonly user: string;
```

- *Type:* string

User to run the container as.

---

##### `workingDirectory`<sup>Optional</sup> <a name="workingDirectory" id="must-cdk.ContainerProps.property.workingDirectory"></a>

```typescript
public readonly workingDirectory: string;
```

- *Type:* string

Working directory inside the container.

---

### CustomDomainOptions <a name="CustomDomainOptions" id="must-cdk.CustomDomainOptions"></a>

Custom domain configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomDomainOptions.Initializer"></a>

```typescript
import { CustomDomainOptions } from 'must-cdk'

const customDomainOptions: CustomDomainOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomDomainOptions.property.domainName">domainName</a></code> | <code>string</code> | The custom domain name for the Amplify app. |
| <code><a href="#must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns">autoSubdomainCreationPatterns</a></code> | <code>string[]</code> | Patterns for automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.enableAutoSubdomain">enableAutoSubdomain</a></code> | <code>boolean</code> | Whether to enable automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.subDomains">subDomains</a></code> | <code><a href="#must-cdk.SubDomainOptions">SubDomainOptions</a>[]</code> | Subdomain configurations for the custom domain. |

---

##### `domainName`<sup>Required</sup> <a name="domainName" id="must-cdk.CustomDomainOptions.property.domainName"></a>

```typescript
public readonly domainName: string;
```

- *Type:* string

The custom domain name for the Amplify app.

---

##### `autoSubdomainCreationPatterns`<sup>Optional</sup> <a name="autoSubdomainCreationPatterns" id="must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns"></a>

```typescript
public readonly autoSubdomainCreationPatterns: string[];
```

- *Type:* string[]

Patterns for automatic subdomain creation.

---

##### `enableAutoSubdomain`<sup>Optional</sup> <a name="enableAutoSubdomain" id="must-cdk.CustomDomainOptions.property.enableAutoSubdomain"></a>

```typescript
public readonly enableAutoSubdomain: boolean;
```

- *Type:* boolean
- *Default:* false

Whether to enable automatic subdomain creation.

---

##### `subDomains`<sup>Optional</sup> <a name="subDomains" id="must-cdk.CustomDomainOptions.property.subDomains"></a>

```typescript
public readonly subDomains: SubDomainOptions[];
```

- *Type:* <a href="#must-cdk.SubDomainOptions">SubDomainOptions</a>[]

Subdomain configurations for the custom domain.

---

### CustomRoute <a name="CustomRoute" id="must-cdk.CustomRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.CustomRoute.Initializer"></a>

```typescript
import { CustomRoute } from 'must-cdk'

const customRoute: CustomRoute = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRoute.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.method">method</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.path">path</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.methodOptions">methodOptions</a></code> | <code>aws-cdk-lib.aws_apigateway.MethodOptions</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.CustomRoute.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `method`<sup>Required</sup> <a name="method" id="must-cdk.CustomRoute.property.method"></a>

```typescript
public readonly method: string;
```

- *Type:* string

---

##### `path`<sup>Required</sup> <a name="path" id="must-cdk.CustomRoute.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

---

##### `methodOptions`<sup>Optional</sup> <a name="methodOptions" id="must-cdk.CustomRoute.property.methodOptions"></a>

```typescript
public readonly methodOptions: MethodOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.MethodOptions

---

### CustomRule <a name="CustomRule" id="must-cdk.CustomRule"></a>

Custom routing rule for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomRule.Initializer"></a>

```typescript
import { CustomRule } from 'must-cdk'

const customRule: CustomRule = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRule.property.source">source</a></code> | <code>string</code> | Source pattern to match in the URL. |
| <code><a href="#must-cdk.CustomRule.property.target">target</a></code> | <code>string</code> | Target URL to redirect or rewrite to. |
| <code><a href="#must-cdk.CustomRule.property.condition">condition</a></code> | <code>string</code> | Condition to apply the rule. |
| <code><a href="#must-cdk.CustomRule.property.status">status</a></code> | <code>string</code> | HTTP status code for the redirect. |

---

##### `source`<sup>Required</sup> <a name="source" id="must-cdk.CustomRule.property.source"></a>

```typescript
public readonly source: string;
```

- *Type:* string

Source pattern to match in the URL.

---

##### `target`<sup>Required</sup> <a name="target" id="must-cdk.CustomRule.property.target"></a>

```typescript
public readonly target: string;
```

- *Type:* string

Target URL to redirect or rewrite to.

---

##### `condition`<sup>Optional</sup> <a name="condition" id="must-cdk.CustomRule.property.condition"></a>

```typescript
public readonly condition: string;
```

- *Type:* string

Condition to apply the rule.

---

##### `status`<sup>Optional</sup> <a name="status" id="must-cdk.CustomRule.property.status"></a>

```typescript
public readonly status: string;
```

- *Type:* string
- *Default:* "200"

HTTP status code for the redirect.

---

### EcsCodeDeployProps <a name="EcsCodeDeployProps" id="must-cdk.EcsCodeDeployProps"></a>

Properties for the EcsCodeDeploy construct.

#### Initializer <a name="Initializer" id="must-cdk.EcsCodeDeployProps.Initializer"></a>

```typescript
import { EcsCodeDeployProps } from 'must-cdk'

const ecsCodeDeployProps: EcsCodeDeployProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.containers">containers</a></code> | <code><a href="#must-cdk.ContainerProps">ContainerProps</a>[]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.loadBalancer">loadBalancer</a></code> | <code><a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a></code> | Load balancer configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | Security group config for ECS service. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.serviceName">serviceName</a></code> | <code>string</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskSubnets">taskSubnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | Select which subnets the ECS tasks will be placed on. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.assignPublicIp">assignPublicIp</a></code> | <code>boolean</code> | Whether the Fargate tasks should be assigned public IP addresses (default: false). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.autoScaling">autoScaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.codeDeployConfig">codeDeployConfig</a></code> | <code><a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a></code> | CodeDeploy configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.desiredCount">desiredCount</a></code> | <code>number</code> | Desired count of tasks (default: 1). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.healthCheckGracePeriod">healthCheckGracePeriod</a></code> | <code>number</code> | Health check grace period in seconds (default: 300). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.memoryLimit">memoryLimit</a></code> | <code>number</code> | Memory limit for the task in MiB (default: 2048). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.targetPort">targetPort</a></code> | <code>number</code> | The port to expose on the target group (defaults to first container's port). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskCPU">taskCPU</a></code> | <code>number</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskExecRole">taskExecRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskRole">taskRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.EcsCodeDeployProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeployProps.property.cluster"></a>

```typescript
public readonly cluster: ICluster;
```

- *Type:* aws-cdk-lib.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeployProps.property.containers"></a>

```typescript
public readonly containers: ContainerProps[];
```

- *Type:* <a href="#must-cdk.ContainerProps">ContainerProps</a>[]

Configuration related to the task definition and container.

---

##### `loadBalancer`<sup>Required</sup> <a name="loadBalancer" id="must-cdk.EcsCodeDeployProps.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: LoadBalancerConfig;
```

- *Type:* <a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a>

Load balancer configuration.

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="must-cdk.EcsCodeDeployProps.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]

Security group config for ECS service.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="must-cdk.EcsCodeDeployProps.property.serviceName"></a>

```typescript
public readonly serviceName: string;
```

- *Type:* string

Base name used for resources like log groups, roles, services, etc.

---

##### `taskSubnets`<sup>Required</sup> <a name="taskSubnets" id="must-cdk.EcsCodeDeployProps.property.taskSubnets"></a>

```typescript
public readonly taskSubnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection

Select which subnets the ECS tasks will be placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeployProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `assignPublicIp`<sup>Optional</sup> <a name="assignPublicIp" id="must-cdk.EcsCodeDeployProps.property.assignPublicIp"></a>

```typescript
public readonly assignPublicIp: boolean;
```

- *Type:* boolean

Whether the Fargate tasks should be assigned public IP addresses (default: false).

This is required if your tasks need to access the internet and are in a public subnet.

---

##### `autoScaling`<sup>Optional</sup> <a name="autoScaling" id="must-cdk.EcsCodeDeployProps.property.autoScaling"></a>

```typescript
public readonly autoScaling: AutoScalingProps;
```

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `codeDeployConfig`<sup>Optional</sup> <a name="codeDeployConfig" id="must-cdk.EcsCodeDeployProps.property.codeDeployConfig"></a>

```typescript
public readonly codeDeployConfig: CodeDeployConfig;
```

- *Type:* <a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a>

CodeDeploy configuration.

---

##### `desiredCount`<sup>Optional</sup> <a name="desiredCount" id="must-cdk.EcsCodeDeployProps.property.desiredCount"></a>

```typescript
public readonly desiredCount: number;
```

- *Type:* number

Desired count of tasks (default: 1).

---

##### `healthCheckGracePeriod`<sup>Optional</sup> <a name="healthCheckGracePeriod" id="must-cdk.EcsCodeDeployProps.property.healthCheckGracePeriod"></a>

```typescript
public readonly healthCheckGracePeriod: number;
```

- *Type:* number

Health check grace period in seconds (default: 300).

---

##### `memoryLimit`<sup>Optional</sup> <a name="memoryLimit" id="must-cdk.EcsCodeDeployProps.property.memoryLimit"></a>

```typescript
public readonly memoryLimit: number;
```

- *Type:* number

Memory limit for the task in MiB (default: 2048).

---

##### `targetPort`<sup>Optional</sup> <a name="targetPort" id="must-cdk.EcsCodeDeployProps.property.targetPort"></a>

```typescript
public readonly targetPort: number;
```

- *Type:* number

The port to expose on the target group (defaults to first container's port).

---

##### `taskCPU`<sup>Optional</sup> <a name="taskCPU" id="must-cdk.EcsCodeDeployProps.property.taskCPU"></a>

```typescript
public readonly taskCPU: number;
```

- *Type:* number

CPU units for the task (default: 1024).

---

##### `taskExecRole`<sup>Optional</sup> <a name="taskExecRole" id="must-cdk.EcsCodeDeployProps.property.taskExecRole"></a>

```typescript
public readonly taskExecRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

Task execution role for the ECS task.

---

##### `taskRole`<sup>Optional</sup> <a name="taskRole" id="must-cdk.EcsCodeDeployProps.property.taskRole"></a>

```typescript
public readonly taskRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

Task role for the ECS task.

---

### HealthCheckConfig <a name="HealthCheckConfig" id="must-cdk.HealthCheckConfig"></a>

Health check configuration for target groups.

#### Initializer <a name="Initializer" id="must-cdk.HealthCheckConfig.Initializer"></a>

```typescript
import { HealthCheckConfig } from 'must-cdk'

const healthCheckConfig: HealthCheckConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HealthCheckConfig.property.healthyHttpCodes">healthyHttpCodes</a></code> | <code>string</code> | The HTTP codes to consider healthy (default: "200"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.healthyThresholdCount">healthyThresholdCount</a></code> | <code>number</code> | The number of successful health checks before considering healthy (default: 3). |
| <code><a href="#must-cdk.HealthCheckConfig.property.interval">interval</a></code> | <code>aws-cdk-lib.Duration</code> | The interval between health checks (default: 30 seconds). |
| <code><a href="#must-cdk.HealthCheckConfig.property.path">path</a></code> | <code>string</code> | The path for health checks (default: "/"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.port">port</a></code> | <code>string</code> | The port for health checks (default: "traffic-port"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.timeout">timeout</a></code> | <code>aws-cdk-lib.Duration</code> | The timeout for health checks (default: 5 seconds). |
| <code><a href="#must-cdk.HealthCheckConfig.property.unhealthyThresholdCount">unhealthyThresholdCount</a></code> | <code>number</code> | The number of failed health checks before considering unhealthy (default: 3). |

---

##### `healthyHttpCodes`<sup>Optional</sup> <a name="healthyHttpCodes" id="must-cdk.HealthCheckConfig.property.healthyHttpCodes"></a>

```typescript
public readonly healthyHttpCodes: string;
```

- *Type:* string

The HTTP codes to consider healthy (default: "200").

---

##### `healthyThresholdCount`<sup>Optional</sup> <a name="healthyThresholdCount" id="must-cdk.HealthCheckConfig.property.healthyThresholdCount"></a>

```typescript
public readonly healthyThresholdCount: number;
```

- *Type:* number

The number of successful health checks before considering healthy (default: 3).

---

##### `interval`<sup>Optional</sup> <a name="interval" id="must-cdk.HealthCheckConfig.property.interval"></a>

```typescript
public readonly interval: Duration;
```

- *Type:* aws-cdk-lib.Duration

The interval between health checks (default: 30 seconds).

---

##### `path`<sup>Optional</sup> <a name="path" id="must-cdk.HealthCheckConfig.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

The path for health checks (default: "/").

---

##### `port`<sup>Optional</sup> <a name="port" id="must-cdk.HealthCheckConfig.property.port"></a>

```typescript
public readonly port: string;
```

- *Type:* string

The port for health checks (default: "traffic-port").

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="must-cdk.HealthCheckConfig.property.timeout"></a>

```typescript
public readonly timeout: Duration;
```

- *Type:* aws-cdk-lib.Duration

The timeout for health checks (default: 5 seconds).

---

##### `unhealthyThresholdCount`<sup>Optional</sup> <a name="unhealthyThresholdCount" id="must-cdk.HealthCheckConfig.property.unhealthyThresholdCount"></a>

```typescript
public readonly unhealthyThresholdCount: number;
```

- *Type:* number

The number of failed health checks before considering unhealthy (default: 3).

---

### HttpOriginConfig <a name="HttpOriginConfig" id="must-cdk.HttpOriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginConfig.Initializer"></a>

```typescript
import { HttpOriginConfig } from 'must-cdk'

const httpOriginConfig: HttpOriginConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginConfig.property.domainName">domainName</a></code> | <code>string</code> | Domain name of the HTTP origin (required). |
| <code><a href="#must-cdk.HttpOriginConfig.property.id">id</a></code> | <code>string</code> | Unique identifier for this HTTP origin. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpOriginProps">httpOriginProps</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps</code> | Additional HTTP origin properties. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpPort">httpPort</a></code> | <code>number</code> | HTTP port (for HTTP protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpsPort">httpsPort</a></code> | <code>number</code> | HTTPS port (for HTTPS protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.originPath">originPath</a></code> | <code>string</code> | Origin path for HTTP requests (e.g., "/api/v1"). |
| <code><a href="#must-cdk.HttpOriginConfig.property.protocolPolicy">protocolPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.OriginProtocolPolicy</code> | Protocol policy for the origin. |

---

##### `domainName`<sup>Required</sup> <a name="domainName" id="must-cdk.HttpOriginConfig.property.domainName"></a>

```typescript
public readonly domainName: string;
```

- *Type:* string

Domain name of the HTTP origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginConfig.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Unique identifier for this HTTP origin.

---

##### `httpOriginProps`<sup>Optional</sup> <a name="httpOriginProps" id="must-cdk.HttpOriginConfig.property.httpOriginProps"></a>

```typescript
public readonly httpOriginProps: HttpOriginProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps

Additional HTTP origin properties.

---

##### `httpPort`<sup>Optional</sup> <a name="httpPort" id="must-cdk.HttpOriginConfig.property.httpPort"></a>

```typescript
public readonly httpPort: number;
```

- *Type:* number
- *Default:* 80

HTTP port (for HTTP protocol).

---

##### `httpsPort`<sup>Optional</sup> <a name="httpsPort" id="must-cdk.HttpOriginConfig.property.httpsPort"></a>

```typescript
public readonly httpsPort: number;
```

- *Type:* number
- *Default:* 443

HTTPS port (for HTTPS protocol).

---

##### `originPath`<sup>Optional</sup> <a name="originPath" id="must-cdk.HttpOriginConfig.property.originPath"></a>

```typescript
public readonly originPath: string;
```

- *Type:* string

Origin path for HTTP requests (e.g., "/api/v1").

---

##### `protocolPolicy`<sup>Optional</sup> <a name="protocolPolicy" id="must-cdk.HttpOriginConfig.property.protocolPolicy"></a>

```typescript
public readonly protocolPolicy: OriginProtocolPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.OriginProtocolPolicy
- *Default:* HTTPS_ONLY

Protocol policy for the origin.

---

### HttpOriginInfo <a name="HttpOriginInfo" id="must-cdk.HttpOriginInfo"></a>

HTTP origin information.

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginInfo.Initializer"></a>

```typescript
import { HttpOriginInfo } from 'must-cdk'

const httpOriginInfo: HttpOriginInfo = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginInfo.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.HttpOriginInfo.property.origin">origin</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.HttpOrigin</code> | *No description.* |

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginInfo.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `origin`<sup>Required</sup> <a name="origin" id="must-cdk.HttpOriginInfo.property.origin"></a>

```typescript
public readonly origin: HttpOrigin;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.HttpOrigin

---

### LoadBalancerConfig <a name="LoadBalancerConfig" id="must-cdk.LoadBalancerConfig"></a>

Configuration for the load balancer component.

#### Initializer <a name="Initializer" id="must-cdk.LoadBalancerConfig.Initializer"></a>

```typescript
import { LoadBalancerConfig } from 'must-cdk'

const loadBalancerConfig: LoadBalancerConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.LoadBalancerConfig.property.certificates">certificates</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate[]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.existingLoadBalancer">existingLoadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.IApplicationLoadBalancer</code> | Existing load balancer to use (if not provided, a new one will be created). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.healthCheck">healthCheck</a></code> | <code><a href="#must-cdk.HealthCheckConfig">HealthCheckConfig</a></code> | Health check configuration for target groups. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.internetFacing">internetFacing</a></code> | <code>boolean</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.productionPort">productionPort</a></code> | <code>number</code> | The production listener port (default: 443 for HTTPS, 80 for HTTP). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | Security groups for the ALB. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.subnets">subnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | Select which subnets the ALB will be placed on. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.testPort">testPort</a></code> | <code>number</code> | The test listener port (default: 8080). |

---

##### `certificates`<sup>Optional</sup> <a name="certificates" id="must-cdk.LoadBalancerConfig.property.certificates"></a>

```typescript
public readonly certificates: ICertificate[];
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate[]

Optional ACM certificates for HTTPS termination.

If not provided, HTTP listeners will be used.

---

##### `existingLoadBalancer`<sup>Optional</sup> <a name="existingLoadBalancer" id="must-cdk.LoadBalancerConfig.property.existingLoadBalancer"></a>

```typescript
public readonly existingLoadBalancer: IApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.IApplicationLoadBalancer

Existing load balancer to use (if not provided, a new one will be created).

---

##### `healthCheck`<sup>Optional</sup> <a name="healthCheck" id="must-cdk.LoadBalancerConfig.property.healthCheck"></a>

```typescript
public readonly healthCheck: HealthCheckConfig;
```

- *Type:* <a href="#must-cdk.HealthCheckConfig">HealthCheckConfig</a>

Health check configuration for target groups.

---

##### `internetFacing`<sup>Optional</sup> <a name="internetFacing" id="must-cdk.LoadBalancerConfig.property.internetFacing"></a>

```typescript
public readonly internetFacing: boolean;
```

- *Type:* boolean

Whether the load balancer should be internet-facing (default: false).

---

##### `productionPort`<sup>Optional</sup> <a name="productionPort" id="must-cdk.LoadBalancerConfig.property.productionPort"></a>

```typescript
public readonly productionPort: number;
```

- *Type:* number

The production listener port (default: 443 for HTTPS, 80 for HTTP).

---

##### `securityGroups`<sup>Optional</sup> <a name="securityGroups" id="must-cdk.LoadBalancerConfig.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]

Security groups for the ALB.

---

##### `subnets`<sup>Optional</sup> <a name="subnets" id="must-cdk.LoadBalancerConfig.property.subnets"></a>

```typescript
public readonly subnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection

Select which subnets the ALB will be placed on.

---

##### `testPort`<sup>Optional</sup> <a name="testPort" id="must-cdk.LoadBalancerConfig.property.testPort"></a>

```typescript
public readonly testPort: number;
```

- *Type:* number

The test listener port (default: 8080).

---

### S3OriginConfig <a name="S3OriginConfig" id="must-cdk.S3OriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.S3OriginConfig.Initializer"></a>

```typescript
import { S3OriginConfig } from 'must-cdk'

const s3OriginConfig: S3OriginConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginConfig.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Existing S3 bucket to use as origin (required). |
| <code><a href="#must-cdk.S3OriginConfig.property.id">id</a></code> | <code>string</code> | Unique identifier for this S3 origin. |
| <code><a href="#must-cdk.S3OriginConfig.property.originAccessIdentity">originAccessIdentity</a></code> | <code>aws-cdk-lib.aws_cloudfront.OriginAccessIdentity</code> | Existing Origin Access Identity (only used if useLegacyOAI is true). |
| <code><a href="#must-cdk.S3OriginConfig.property.originPath">originPath</a></code> | <code>string</code> | Origin path for S3 requests (e.g., "/static"). |
| <code><a href="#must-cdk.S3OriginConfig.property.s3OriginProps">s3OriginProps</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.S3OriginProps</code> | Additional S3 origin properties. |
| <code><a href="#must-cdk.S3OriginConfig.property.useLegacyOAI">useLegacyOAI</a></code> | <code>boolean</code> | Use legacy Origin Access Identity instead of modern Origin Access Control. |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginConfig.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Existing S3 bucket to use as origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginConfig.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Unique identifier for this S3 origin.

---

##### `originAccessIdentity`<sup>Optional</sup> <a name="originAccessIdentity" id="must-cdk.S3OriginConfig.property.originAccessIdentity"></a>

```typescript
public readonly originAccessIdentity: OriginAccessIdentity;
```

- *Type:* aws-cdk-lib.aws_cloudfront.OriginAccessIdentity

Existing Origin Access Identity (only used if useLegacyOAI is true).

---

##### `originPath`<sup>Optional</sup> <a name="originPath" id="must-cdk.S3OriginConfig.property.originPath"></a>

```typescript
public readonly originPath: string;
```

- *Type:* string

Origin path for S3 requests (e.g., "/static").

---

##### `s3OriginProps`<sup>Optional</sup> <a name="s3OriginProps" id="must-cdk.S3OriginConfig.property.s3OriginProps"></a>

```typescript
public readonly s3OriginProps: S3OriginProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.S3OriginProps

Additional S3 origin properties.

---

##### `useLegacyOAI`<sup>Optional</sup> <a name="useLegacyOAI" id="must-cdk.S3OriginConfig.property.useLegacyOAI"></a>

```typescript
public readonly useLegacyOAI: boolean;
```

- *Type:* boolean
- *Default:* false - uses OAC for better security

Use legacy Origin Access Identity instead of modern Origin Access Control.

---

### S3OriginInfo <a name="S3OriginInfo" id="must-cdk.S3OriginInfo"></a>

S3 origin information.

#### Initializer <a name="Initializer" id="must-cdk.S3OriginInfo.Initializer"></a>

```typescript
import { S3OriginInfo } from 'must-cdk'

const s3OriginInfo: S3OriginInfo = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginInfo.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#must-cdk.S3OriginInfo.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginInfo.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginInfo.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

### SubDomainOptions <a name="SubDomainOptions" id="must-cdk.SubDomainOptions"></a>

Subdomain configuration for a custom domain in an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.SubDomainOptions.Initializer"></a>

```typescript
import { SubDomainOptions } from 'must-cdk'

const subDomainOptions: SubDomainOptions = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.SubDomainOptions.property.branchName">branchName</a></code> | <code>string</code> | The branch name to map to this subdomain. |
| <code><a href="#must-cdk.SubDomainOptions.property.prefix">prefix</a></code> | <code>string</code> | The prefix for the subdomain. |

---

##### `branchName`<sup>Required</sup> <a name="branchName" id="must-cdk.SubDomainOptions.property.branchName"></a>

```typescript
public readonly branchName: string;
```

- *Type:* string

The branch name to map to this subdomain.

---

##### `prefix`<sup>Required</sup> <a name="prefix" id="must-cdk.SubDomainOptions.property.prefix"></a>

```typescript
public readonly prefix: string;
```

- *Type:* string

The prefix for the subdomain.

Use empty string for the root domain.

---

### TaggableProps <a name="TaggableProps" id="must-cdk.TaggableProps"></a>

Type for tag-aware construct props.

#### Initializer <a name="Initializer" id="must-cdk.TaggableProps.Initializer"></a>

```typescript
import { TaggableProps } from 'must-cdk'

const taggableProps: TaggableProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.TaggableProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.TaggableProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

### WebSocketApiGatewayToLambdaProps <a name="WebSocketApiGatewayToLambdaProps" id="must-cdk.WebSocketApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketApiGatewayToLambdaProps.Initializer"></a>

```typescript
import { WebSocketApiGatewayToLambdaProps } from 'must-cdk'

const webSocketApiGatewayToLambdaProps: WebSocketApiGatewayToLambdaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.tags">tags</a></code> | <code>{[ key: string ]: string}</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName">apiName</a></code> | <code>string</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps">apiProps</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes">customRoutes</a></code> | <code><a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>[]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate">existingCertificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps">logGroupProps</a></code> | <code>aws-cdk-lib.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName">stageName</a></code> | <code>string</code> | Stage name for the WebSocket API. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.tags"></a>

```typescript
public readonly tags: {[ key: string ]: string};
```

- *Type:* {[ key: string ]: string}

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `apiName`<sup>Required</sup> <a name="apiName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName"></a>

```typescript
public readonly apiName: string;
```

- *Type:* string

WebSocket API configuration.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `apiProps`<sup>Optional</sup> <a name="apiProps" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps"></a>

```typescript
public readonly apiProps: WebSocketApiProps;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Optional custom domain name for API Gateway.

---

##### `customRoutes`<sup>Optional</sup> <a name="customRoutes" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes"></a>

```typescript
public readonly customRoutes: WebSocketRoute[];
```

- *Type:* <a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>[]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean

Enable CloudWatch logging for API Gateway.

---

##### `existingCertificate`<sup>Optional</sup> <a name="existingCertificate" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate"></a>

```typescript
public readonly existingCertificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `logGroupProps`<sup>Optional</sup> <a name="logGroupProps" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps"></a>

```typescript
public readonly logGroupProps: LogGroupProps;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stageName`<sup>Optional</sup> <a name="stageName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName"></a>

```typescript
public readonly stageName: string;
```

- *Type:* string
- *Default:* 'dev'

Stage name for the WebSocket API.

---

### WebSocketRoute <a name="WebSocketRoute" id="must-cdk.WebSocketRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketRoute.Initializer"></a>

```typescript
import { WebSocketRoute } from 'must-cdk'

const webSocketRoute: WebSocketRoute = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketRoute.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeKey">routeKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeResponseSelectionExpression">routeResponseSelectionExpression</a></code> | <code>string</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketRoute.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `routeKey`<sup>Required</sup> <a name="routeKey" id="must-cdk.WebSocketRoute.property.routeKey"></a>

```typescript
public readonly routeKey: string;
```

- *Type:* string

---

##### `routeResponseSelectionExpression`<sup>Optional</sup> <a name="routeResponseSelectionExpression" id="must-cdk.WebSocketRoute.property.routeResponseSelectionExpression"></a>

```typescript
public readonly routeResponseSelectionExpression: string;
```

- *Type:* string

---



