# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### AmplifyApp <a name="AmplifyApp" id="must-cdk.AmplifyApp"></a>

#### Initializers <a name="Initializers" id="must-cdk.AmplifyApp.Initializer"></a>

```python
import must_cdk

must_cdk.AmplifyApp(
  scope: Construct,
  id: str,
  tags: typing.Mapping[str] = None,
  app_name: str,
  repository: str,
  access_token: str = None,
  basic_auth: BasicAuthConfig = None,
  branches: typing.List[BranchOptions] = None,
  build_settings: BuildSettings = None,
  build_spec: str = None,
  custom_domain: CustomDomainOptions = None,
  custom_rules: typing.List[CustomRule] = None,
  environment_variables: typing.Mapping[str] = None,
  platform: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.appName">app_name</a></code> | <code>str</code> | The name for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.repository">repository</a></code> | <code>str</code> | The Git repository URL for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.accessToken">access_token</a></code> | <code>str</code> | GitHub personal access token for repository access. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.basicAuth">basic_auth</a></code> | <code><a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a></code> | Basic authentication configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.branches">branches</a></code> | <code>typing.List[<a href="#must-cdk.BranchOptions">BranchOptions</a>]</code> | Branch configurations for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.buildSettings">build_settings</a></code> | <code><a href="#must-cdk.BuildSettings">BuildSettings</a></code> | Build settings for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.buildSpec">build_spec</a></code> | <code>str</code> | Build specification for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.customDomain">custom_domain</a></code> | <code><a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a></code> | Custom domain configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.customRules">custom_rules</a></code> | <code>typing.List[<a href="#must-cdk.CustomRule">CustomRule</a>]</code> | Custom rules for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables for the Amplify app. |
| <code><a href="#must-cdk.AmplifyApp.Initializer.parameter.platform">platform</a></code> | <code>str</code> | Platform for the Amplify app. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.AmplifyApp.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.AmplifyApp.Initializer.parameter.id"></a>

- *Type:* str

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.AmplifyApp.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `app_name`<sup>Required</sup> <a name="app_name" id="must-cdk.AmplifyApp.Initializer.parameter.appName"></a>

- *Type:* str

The name for the Amplify app.

---

##### `repository`<sup>Required</sup> <a name="repository" id="must-cdk.AmplifyApp.Initializer.parameter.repository"></a>

- *Type:* str

The Git repository URL for the Amplify app.

Format: https://github.com/user/repo or similar.

---

##### `access_token`<sup>Optional</sup> <a name="access_token" id="must-cdk.AmplifyApp.Initializer.parameter.accessToken"></a>

- *Type:* str

GitHub personal access token for repository access.

If not provided, will attempt to use GitHub CLI token or MUFIN_PUSH_TOKEN environment variable.

Note: For production deployments, consider migrating to GitHub Apps for better security,
organization support, and higher rate limits after initial setup.

---

##### `basic_auth`<sup>Optional</sup> <a name="basic_auth" id="must-cdk.AmplifyApp.Initializer.parameter.basicAuth"></a>

- *Type:* <a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a>

Basic authentication configuration for the Amplify app.

---

##### `branches`<sup>Optional</sup> <a name="branches" id="must-cdk.AmplifyApp.Initializer.parameter.branches"></a>

- *Type:* typing.List[<a href="#must-cdk.BranchOptions">BranchOptions</a>]

Branch configurations for the Amplify app.

If not provided, a default 'main' branch will be created.

---

##### `build_settings`<sup>Optional</sup> <a name="build_settings" id="must-cdk.AmplifyApp.Initializer.parameter.buildSettings"></a>

- *Type:* <a href="#must-cdk.BuildSettings">BuildSettings</a>

Build settings for the Amplify app.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.AmplifyApp.Initializer.parameter.buildSpec"></a>

- *Type:* str

Build specification for the Amplify app.

Defines the build commands and output artifacts.

---

##### `custom_domain`<sup>Optional</sup> <a name="custom_domain" id="must-cdk.AmplifyApp.Initializer.parameter.customDomain"></a>

- *Type:* <a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a>

Custom domain configuration for the Amplify app.

---

##### `custom_rules`<sup>Optional</sup> <a name="custom_rules" id="must-cdk.AmplifyApp.Initializer.parameter.customRules"></a>

- *Type:* typing.List[<a href="#must-cdk.CustomRule">CustomRule</a>]

Custom rules for the Amplify app.

Used for redirects, rewrites, and other routing rules.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.AmplifyApp.Initializer.parameter.environmentVariables"></a>

- *Type:* typing.Mapping[str]

Environment variables for the Amplify app.

These will be available during the build process.

---

##### `platform`<sup>Optional</sup> <a name="platform" id="must-cdk.AmplifyApp.Initializer.parameter.platform"></a>

- *Type:* str
- *Default:* "WEB"

Platform for the Amplify app.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.toString">to_string</a></code> | Returns a string representation of this construct. |

---

##### `to_string` <a name="to_string" id="must-cdk.AmplifyApp.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.AmplifyApp.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.AmplifyApp.isConstruct"></a>

```python
import must_cdk

must_cdk.AmplifyApp.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.AmplifyApp.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyApp.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.AmplifyApp.property.app">app</a></code> | <code>aws_cdk.aws_amplify.CfnApp</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.branches">branches</a></code> | <code>typing.List[aws_cdk.aws_amplify.CfnBranch]</code> | *No description.* |
| <code><a href="#must-cdk.AmplifyApp.property.domain">domain</a></code> | <code>aws_cdk.aws_amplify.CfnDomain</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.AmplifyApp.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `app`<sup>Required</sup> <a name="app" id="must-cdk.AmplifyApp.property.app"></a>

```python
app: CfnApp
```

- *Type:* aws_cdk.aws_amplify.CfnApp

---

##### `branches`<sup>Required</sup> <a name="branches" id="must-cdk.AmplifyApp.property.branches"></a>

```python
branches: typing.List[CfnBranch]
```

- *Type:* typing.List[aws_cdk.aws_amplify.CfnBranch]

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.AmplifyApp.property.domain"></a>

```python
domain: CfnDomain
```

- *Type:* aws_cdk.aws_amplify.CfnDomain

---


### ApiGatewayToLambda <a name="ApiGatewayToLambda" id="must-cdk.ApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.ApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda(
  scope: Construct,
  id: str,
  tags: typing.Mapping[str] = None,
  api_name: str,
  lambda_function: IFunction,
  binary_media_types: typing.List[str] = None,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.binaryMediaTypes">binary_media_types</a></code> | <code>typing.List[str]</code> | Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `binary_media_types`<sup>Optional</sup> <a name="binary_media_types" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.binaryMediaTypes"></a>

- *Type:* typing.List[str]

Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.createUsagePlan"></a>

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.lambdaApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.proxy"></a>

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.restApiProps"></a>

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.ApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.ApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.ApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
) -> Method
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `method`<sup>Required</sup> <a name="method" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.method"></a>

- *Type:* str

---

###### `path`<sup>Required</sup> <a name="path" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.path"></a>

- *Type:* str

---

###### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.methodOptions"></a>

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.ApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.ApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGateway">api_gateway</a></code> | <code>aws_cdk.aws_apigateway.RestApi</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiUrl">api_url</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigateway.DomainName</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.usagePlan">usage_plan</a></code> | <code>aws_cdk.aws_apigateway.UsagePlan</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.ApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `api_gateway`<sup>Required</sup> <a name="api_gateway" id="must-cdk.ApiGatewayToLambda.property.apiGateway"></a>

```python
api_gateway: RestApi
```

- *Type:* aws_cdk.aws_apigateway.RestApi

---

##### `api_url`<sup>Required</sup> <a name="api_url" id="must-cdk.ApiGatewayToLambda.property.apiUrl"></a>

```python
api_url: str
```

- *Type:* str

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.ApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.ApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.ApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigateway.DomainName

---

##### `usage_plan`<sup>Optional</sup> <a name="usage_plan" id="must-cdk.ApiGatewayToLambda.property.usagePlan"></a>

```python
usage_plan: UsagePlan
```

- *Type:* aws_cdk.aws_apigateway.UsagePlan

---


### CloudFrontToOrigins <a name="CloudFrontToOrigins" id="must-cdk.CloudFrontToOrigins"></a>

#### Initializers <a name="Initializers" id="must-cdk.CloudFrontToOrigins.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins(
  scope: Construct,
  id: str,
  tags: typing.Mapping[str] = None,
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.id"></a>

- *Type:* str

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.additionalDomainNames"></a>

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

CloudFront only supports one certificate per distribution.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.cacheBehaviors"></a>

- *Type:* typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.certificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

The certificate must cover all domains (customDomainName + additionalDomainNames).
CloudFront only supports one certificate per distribution.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.comment"></a>

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.createRoute53Records"></a>

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.customDomainName"></a>

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultOriginId"></a>

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.defaultRootObject"></a>

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enabled"></a>

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableIpv6"></a>

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.enableLogging"></a>

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.errorPages"></a>

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.geoRestriction"></a>

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpOrigins"></a>

- *Type:* typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.httpVersion"></a>

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logBucket"></a>

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logIncludeCookies"></a>

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.logPrefix"></a>

- *Type:* str
- *Default:* "cloudfront"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.priceClass"></a>

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.s3Origins"></a>

- *Type:* typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.webAclId"></a>

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getHttpOrigin">get_http_origin</a></code> | Get HTTP origin by origin ID. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getS3Bucket">get_s3_bucket</a></code> | Get S3 bucket by origin ID. |

---

##### `to_string` <a name="to_string" id="must-cdk.CloudFrontToOrigins.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `get_http_origin` <a name="get_http_origin" id="must-cdk.CloudFrontToOrigins.getHttpOrigin"></a>

```python
def get_http_origin(
  origin_id: str
) -> HttpOrigin
```

Get HTTP origin by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getHttpOrigin.parameter.originId"></a>

- *Type:* str

---

##### `get_s3_bucket` <a name="get_s3_bucket" id="must-cdk.CloudFrontToOrigins.getS3Bucket"></a>

```python
def get_s3_bucket(
  origin_id: str
) -> IBucket
```

Get S3 bucket by origin ID.

###### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CloudFrontToOrigins.getS3Bucket.parameter.originId"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.CloudFrontToOrigins.isConstruct"></a>

```python
import must_cdk

must_cdk.CloudFrontToOrigins.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.CloudFrontToOrigins.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.aRecords">a_records</a></code> | <code>typing.List[aws_cdk.aws_route53.ARecord]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distribution">distribution</a></code> | <code>aws_cdk.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionDomainName">distribution_domain_name</a></code> | <code>str</code> | Get the CloudFront distribution domain name. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionUrl">distribution_url</a></code> | <code>str</code> | Get the CloudFront distribution URL with protocol. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOriginIds">http_origin_ids</a></code> | <code>typing.List[str]</code> | Get all HTTP origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>]</code> | Get all HTTP origins as an array of objects with ID and origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3OriginIds">s3_origin_ids</a></code> | <code>typing.List[str]</code> | Get all S3 bucket origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>]</code> | Get all S3 buckets as an array of objects with ID and bucket. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.customDomainUrl">custom_domain_url</a></code> | <code>str</code> | Get the custom domain URL (if configured). |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.domainNames">domain_names</a></code> | <code>typing.List[str]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.CloudFrontToOrigins.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `a_records`<sup>Required</sup> <a name="a_records" id="must-cdk.CloudFrontToOrigins.property.aRecords"></a>

```python
a_records: typing.List[ARecord]
```

- *Type:* typing.List[aws_cdk.aws_route53.ARecord]

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="must-cdk.CloudFrontToOrigins.property.distribution"></a>

```python
distribution: Distribution
```

- *Type:* aws_cdk.aws_cloudfront.Distribution

---

##### `distribution_domain_name`<sup>Required</sup> <a name="distribution_domain_name" id="must-cdk.CloudFrontToOrigins.property.distributionDomainName"></a>

```python
distribution_domain_name: str
```

- *Type:* str

Get the CloudFront distribution domain name.

---

##### `distribution_url`<sup>Required</sup> <a name="distribution_url" id="must-cdk.CloudFrontToOrigins.property.distributionUrl"></a>

```python
distribution_url: str
```

- *Type:* str

Get the CloudFront distribution URL with protocol.

---

##### `http_origin_ids`<sup>Required</sup> <a name="http_origin_ids" id="must-cdk.CloudFrontToOrigins.property.httpOriginIds"></a>

```python
http_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all HTTP origin IDs.

---

##### `http_origins`<sup>Required</sup> <a name="http_origins" id="must-cdk.CloudFrontToOrigins.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginInfo]
```

- *Type:* typing.List[<a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>]

Get all HTTP origins as an array of objects with ID and origin.

---

##### `s3_origin_ids`<sup>Required</sup> <a name="s3_origin_ids" id="must-cdk.CloudFrontToOrigins.property.s3OriginIds"></a>

```python
s3_origin_ids: typing.List[str]
```

- *Type:* typing.List[str]

Get all S3 bucket origin IDs.

---

##### `s3_origins`<sup>Required</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOrigins.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginInfo]
```

- *Type:* typing.List[<a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>]

Get all S3 buckets as an array of objects with ID and bucket.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `custom_domain_url`<sup>Optional</sup> <a name="custom_domain_url" id="must-cdk.CloudFrontToOrigins.property.customDomainUrl"></a>

```python
custom_domain_url: str
```

- *Type:* str

Get the custom domain URL (if configured).

---

##### `domain_names`<sup>Optional</sup> <a name="domain_names" id="must-cdk.CloudFrontToOrigins.property.domainNames"></a>

```python
domain_names: typing.List[str]
```

- *Type:* typing.List[str]

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOrigins.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---


### EcsCodeDeploy <a name="EcsCodeDeploy" id="must-cdk.EcsCodeDeploy"></a>

A CDK construct that creates an ECS Fargate service with CodeDeploy blue-green deployment capability.

This construct provides a modular approach to deploy containerized applications with blue-green deployment.

#### Initializers <a name="Initializers" id="must-cdk.EcsCodeDeploy.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy(
  scope: Construct,
  id: str,
  tags: typing.Mapping[str] = None,
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  load_balancer: LoadBalancerConfig,
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  task_subnets: SubnetSelection,
  vpc: IVpc,
  assign_public_ip: bool = None,
  auto_scaling: AutoScalingProps = None,
  code_deploy_config: CodeDeployConfig = None,
  desired_count: typing.Union[int, float] = None,
  health_check_grace_period: typing.Union[int, float] = None,
  memory_limit: typing.Union[int, float] = None,
  target_port: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.containers">containers</a></code> | <code>typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.loadBalancer">load_balancer</a></code> | <code><a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a></code> | Load balancer configuration. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config for ECS service. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskSubnets">task_subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the ECS tasks will be placed on. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.assignPublicIp">assign_public_ip</a></code> | <code>bool</code> | Whether the Fargate tasks should be assigned public IP addresses (default: false). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.codeDeployConfig">code_deploy_config</a></code> | <code><a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a></code> | CodeDeploy configuration. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.desiredCount">desired_count</a></code> | <code>typing.Union[int, float]</code> | Desired count of tasks (default: 1). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.healthCheckGracePeriod">health_check_grace_period</a></code> | <code>typing.Union[int, float]</code> | Health check grace period in seconds (default: 300). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | Memory limit for the task in MiB (default: 2048). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.targetPort">target_port</a></code> | <code>typing.Union[int, float]</code> | The port to expose on the target group (defaults to first container's port). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.EcsCodeDeploy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.EcsCodeDeploy.Initializer.parameter.id"></a>

- *Type:* str

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.EcsCodeDeploy.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeploy.Initializer.parameter.cluster"></a>

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeploy.Initializer.parameter.containers"></a>

- *Type:* typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]

Configuration related to the task definition and container.

---

##### `load_balancer`<sup>Required</sup> <a name="load_balancer" id="must-cdk.EcsCodeDeploy.Initializer.parameter.loadBalancer"></a>

- *Type:* <a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a>

Load balancer configuration.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeploy.Initializer.parameter.securityGroups"></a>

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config for ECS service.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeploy.Initializer.parameter.serviceName"></a>

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `task_subnets`<sup>Required</sup> <a name="task_subnets" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskSubnets"></a>

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the ECS tasks will be placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeploy.Initializer.parameter.vpc"></a>

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `assign_public_ip`<sup>Optional</sup> <a name="assign_public_ip" id="must-cdk.EcsCodeDeploy.Initializer.parameter.assignPublicIp"></a>

- *Type:* bool

Whether the Fargate tasks should be assigned public IP addresses (default: false).

This is required if your tasks need to access the internet and are in a public subnet.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeploy.Initializer.parameter.autoScaling"></a>

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `code_deploy_config`<sup>Optional</sup> <a name="code_deploy_config" id="must-cdk.EcsCodeDeploy.Initializer.parameter.codeDeployConfig"></a>

- *Type:* <a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a>

CodeDeploy configuration.

---

##### `desired_count`<sup>Optional</sup> <a name="desired_count" id="must-cdk.EcsCodeDeploy.Initializer.parameter.desiredCount"></a>

- *Type:* typing.Union[int, float]

Desired count of tasks (default: 1).

---

##### `health_check_grace_period`<sup>Optional</sup> <a name="health_check_grace_period" id="must-cdk.EcsCodeDeploy.Initializer.parameter.healthCheckGracePeriod"></a>

- *Type:* typing.Union[int, float]

Health check grace period in seconds (default: 300).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeploy.Initializer.parameter.memoryLimit"></a>

- *Type:* typing.Union[int, float]

Memory limit for the task in MiB (default: 2048).

---

##### `target_port`<sup>Optional</sup> <a name="target_port" id="must-cdk.EcsCodeDeploy.Initializer.parameter.targetPort"></a>

- *Type:* typing.Union[int, float]

The port to expose on the target group (defaults to first container's port).

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskCPU"></a>

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskExecRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeploy.Initializer.parameter.taskRole"></a>

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.EcsCodeDeploy.allListeners">all_listeners</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.blueListener">blue_listener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.greenListener">green_listener</a></code> | *No description.* |

---

##### `to_string` <a name="to_string" id="must-cdk.EcsCodeDeploy.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `all_listeners` <a name="all_listeners" id="must-cdk.EcsCodeDeploy.allListeners"></a>

```python
def all_listeners() -> typing.List[ApplicationListener]
```

##### `blue_listener` <a name="blue_listener" id="must-cdk.EcsCodeDeploy.blueListener"></a>

```python
def blue_listener() -> ApplicationListener
```

##### `green_listener` <a name="green_listener" id="must-cdk.EcsCodeDeploy.greenListener"></a>

```python
def green_listener() -> ApplicationListener
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.EcsCodeDeploy.isConstruct"></a>

```python
import must_cdk

must_cdk.EcsCodeDeploy.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.EcsCodeDeploy.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.application">application</a></code> | <code>aws_cdk.aws_codedeploy.EcsApplication</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.containers">containers</a></code> | <code>typing.List[aws_cdk.aws_ecs.ContainerDefinition]</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.listeners">listeners</a></code> | <code>typing.List[aws_cdk.aws_elasticloadbalancingv2.ApplicationListener]</code> | Get all listeners from the load balancer. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancer">load_balancer</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancerDnsName">load_balancer_dns_name</a></code> | <code>str</code> | Get the load balancer DNS name. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.productionListener">production_listener</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationListener</code> | Get the production listener. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.productionTargetGroup">production_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.service">service</a></code> | <code>aws_cdk.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.serviceArn">service_arn</a></code> | <code>str</code> | Get the service ARN. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskDefinition">task_definition</a></code> | <code>aws_cdk.aws_ecs.TaskDefinition</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.testListener">test_listener</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationListener</code> | Get the test listener. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.testTargetGroup">test_target_group</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.EcsCodeDeploy.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `application`<sup>Required</sup> <a name="application" id="must-cdk.EcsCodeDeploy.property.application"></a>

```python
application: EcsApplication
```

- *Type:* aws_cdk.aws_codedeploy.EcsApplication

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeploy.property.containers"></a>

```python
containers: typing.List[ContainerDefinition]
```

- *Type:* typing.List[aws_cdk.aws_ecs.ContainerDefinition]

---

##### `listeners`<sup>Required</sup> <a name="listeners" id="must-cdk.EcsCodeDeploy.property.listeners"></a>

```python
listeners: typing.List[ApplicationListener]
```

- *Type:* typing.List[aws_cdk.aws_elasticloadbalancingv2.ApplicationListener]

Get all listeners from the load balancer.

---

##### `load_balancer`<sup>Required</sup> <a name="load_balancer" id="must-cdk.EcsCodeDeploy.property.loadBalancer"></a>

```python
load_balancer: ApplicationLoadBalancer
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `load_balancer_dns_name`<sup>Required</sup> <a name="load_balancer_dns_name" id="must-cdk.EcsCodeDeploy.property.loadBalancerDnsName"></a>

```python
load_balancer_dns_name: str
```

- *Type:* str

Get the load balancer DNS name.

---

##### `production_listener`<sup>Required</sup> <a name="production_listener" id="must-cdk.EcsCodeDeploy.property.productionListener"></a>

```python
production_listener: ApplicationListener
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationListener

Get the production listener.

---

##### `production_target_group`<sup>Required</sup> <a name="production_target_group" id="must-cdk.EcsCodeDeploy.property.productionTargetGroup"></a>

```python
production_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `service`<sup>Required</sup> <a name="service" id="must-cdk.EcsCodeDeploy.property.service"></a>

```python
service: FargateService
```

- *Type:* aws_cdk.aws_ecs.FargateService

---

##### `service_arn`<sup>Required</sup> <a name="service_arn" id="must-cdk.EcsCodeDeploy.property.serviceArn"></a>

```python
service_arn: str
```

- *Type:* str

Get the service ARN.

---

##### `task_definition`<sup>Required</sup> <a name="task_definition" id="must-cdk.EcsCodeDeploy.property.taskDefinition"></a>

```python
task_definition: TaskDefinition
```

- *Type:* aws_cdk.aws_ecs.TaskDefinition

---

##### `test_listener`<sup>Required</sup> <a name="test_listener" id="must-cdk.EcsCodeDeploy.property.testListener"></a>

```python
test_listener: ApplicationListener
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationListener

Get the test listener.

---

##### `test_target_group`<sup>Required</sup> <a name="test_target_group" id="must-cdk.EcsCodeDeploy.property.testTargetGroup"></a>

```python
test_target_group: ApplicationTargetGroup
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.ApplicationTargetGroup

---


### WebSocketApiGatewayToLambda <a name="WebSocketApiGatewayToLambda" id="must-cdk.WebSocketApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.WebSocketApiGatewayToLambda.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda(
  scope: Construct,
  id: str,
  tags: typing.Mapping[str] = None,
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* str

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.tags"></a>

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiName"></a>

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.lambdaFunction"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.apiProps"></a>

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customDomainName"></a>

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.customRoutes"></a>

- *Type:* typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.enableLogging"></a>

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.existingCertificate"></a>

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.hostedZone"></a>

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.logGroupProps"></a>

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.stageName"></a>

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.toString">to_string</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.addRoute">add_route</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `to_string` <a name="to_string" id="must-cdk.WebSocketApiGatewayToLambda.toString"></a>

```python
def to_string() -> str
```

Returns a string representation of this construct.

##### `add_route` <a name="add_route" id="must-cdk.WebSocketApiGatewayToLambda.addRoute"></a>

```python
def add_route(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
) -> WebSocketRoute
```

Add a custom route after construction (for dynamic route addition).

###### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.handler"></a>

- *Type:* aws_cdk.aws_lambda.IFunction

---

###### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeKey"></a>

- *Type:* str

---

###### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.routeResponseSelectionExpression"></a>

- *Type:* str

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.isConstruct">is_construct</a></code> | Checks if `x` is a construct. |

---

##### ~~`is_construct`~~ <a name="is_construct" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambda.is_construct(
  x: typing.Any
)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* typing.Any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi">web_socket_api</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApi</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage">web_socket_stage</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketStage</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl">web_socket_url</a></code> | <code>str</code> | Get the WebSocket API URL (useful for outputs). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup">api_gateway_log_group</a></code> | <code>aws_cdk.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.aRecord">a_record</a></code> | <code>aws_cdk.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.domain">domain</a></code> | <code>aws_cdk.aws_apigatewayv2.DomainName</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.WebSocketApiGatewayToLambda.property.node"></a>

```python
node: Node
```

- *Type:* constructs.Node

The tree node.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `web_socket_api`<sup>Required</sup> <a name="web_socket_api" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi"></a>

```python
web_socket_api: WebSocketApi
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApi

---

##### `web_socket_stage`<sup>Required</sup> <a name="web_socket_stage" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage"></a>

```python
web_socket_stage: WebSocketStage
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketStage

---

##### `web_socket_url`<sup>Required</sup> <a name="web_socket_url" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl"></a>

```python
web_socket_url: str
```

- *Type:* str

Get the WebSocket API URL (useful for outputs).

---

##### `api_gateway_log_group`<sup>Optional</sup> <a name="api_gateway_log_group" id="must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```python
api_gateway_log_group: LogGroup
```

- *Type:* aws_cdk.aws_logs.LogGroup

---

##### `a_record`<sup>Optional</sup> <a name="a_record" id="must-cdk.WebSocketApiGatewayToLambda.property.aRecord"></a>

```python
a_record: ARecord
```

- *Type:* aws_cdk.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.WebSocketApiGatewayToLambda.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.WebSocketApiGatewayToLambda.property.domain"></a>

```python
domain: DomainName
```

- *Type:* aws_cdk.aws_apigatewayv2.DomainName

---


## Structs <a name="Structs" id="Structs"></a>

### AmplifyAppProps <a name="AmplifyAppProps" id="must-cdk.AmplifyAppProps"></a>

Properties for creating an AWS Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.AmplifyAppProps.Initializer"></a>

```python
import must_cdk

must_cdk.AmplifyAppProps(
  tags: typing.Mapping[str] = None,
  app_name: str,
  repository: str,
  access_token: str = None,
  basic_auth: BasicAuthConfig = None,
  branches: typing.List[BranchOptions] = None,
  build_settings: BuildSettings = None,
  build_spec: str = None,
  custom_domain: CustomDomainOptions = None,
  custom_rules: typing.List[CustomRule] = None,
  environment_variables: typing.Mapping[str] = None,
  platform: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AmplifyAppProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.AmplifyAppProps.property.appName">app_name</a></code> | <code>str</code> | The name for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.repository">repository</a></code> | <code>str</code> | The Git repository URL for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.accessToken">access_token</a></code> | <code>str</code> | GitHub personal access token for repository access. |
| <code><a href="#must-cdk.AmplifyAppProps.property.basicAuth">basic_auth</a></code> | <code><a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a></code> | Basic authentication configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.branches">branches</a></code> | <code>typing.List[<a href="#must-cdk.BranchOptions">BranchOptions</a>]</code> | Branch configurations for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSettings">build_settings</a></code> | <code><a href="#must-cdk.BuildSettings">BuildSettings</a></code> | Build settings for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.buildSpec">build_spec</a></code> | <code>str</code> | Build specification for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customDomain">custom_domain</a></code> | <code><a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a></code> | Custom domain configuration for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.customRules">custom_rules</a></code> | <code>typing.List[<a href="#must-cdk.CustomRule">CustomRule</a>]</code> | Custom rules for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables for the Amplify app. |
| <code><a href="#must-cdk.AmplifyAppProps.property.platform">platform</a></code> | <code>str</code> | Platform for the Amplify app. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.AmplifyAppProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `app_name`<sup>Required</sup> <a name="app_name" id="must-cdk.AmplifyAppProps.property.appName"></a>

```python
app_name: str
```

- *Type:* str

The name for the Amplify app.

---

##### `repository`<sup>Required</sup> <a name="repository" id="must-cdk.AmplifyAppProps.property.repository"></a>

```python
repository: str
```

- *Type:* str

The Git repository URL for the Amplify app.

Format: https://github.com/user/repo or similar.

---

##### `access_token`<sup>Optional</sup> <a name="access_token" id="must-cdk.AmplifyAppProps.property.accessToken"></a>

```python
access_token: str
```

- *Type:* str

GitHub personal access token for repository access.

If not provided, will attempt to use GitHub CLI token or MUFIN_PUSH_TOKEN environment variable.

Note: For production deployments, consider migrating to GitHub Apps for better security,
organization support, and higher rate limits after initial setup.

---

##### `basic_auth`<sup>Optional</sup> <a name="basic_auth" id="must-cdk.AmplifyAppProps.property.basicAuth"></a>

```python
basic_auth: BasicAuthConfig
```

- *Type:* <a href="#must-cdk.BasicAuthConfig">BasicAuthConfig</a>

Basic authentication configuration for the Amplify app.

---

##### `branches`<sup>Optional</sup> <a name="branches" id="must-cdk.AmplifyAppProps.property.branches"></a>

```python
branches: typing.List[BranchOptions]
```

- *Type:* typing.List[<a href="#must-cdk.BranchOptions">BranchOptions</a>]

Branch configurations for the Amplify app.

If not provided, a default 'main' branch will be created.

---

##### `build_settings`<sup>Optional</sup> <a name="build_settings" id="must-cdk.AmplifyAppProps.property.buildSettings"></a>

```python
build_settings: BuildSettings
```

- *Type:* <a href="#must-cdk.BuildSettings">BuildSettings</a>

Build settings for the Amplify app.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.AmplifyAppProps.property.buildSpec"></a>

```python
build_spec: str
```

- *Type:* str

Build specification for the Amplify app.

Defines the build commands and output artifacts.

---

##### `custom_domain`<sup>Optional</sup> <a name="custom_domain" id="must-cdk.AmplifyAppProps.property.customDomain"></a>

```python
custom_domain: CustomDomainOptions
```

- *Type:* <a href="#must-cdk.CustomDomainOptions">CustomDomainOptions</a>

Custom domain configuration for the Amplify app.

---

##### `custom_rules`<sup>Optional</sup> <a name="custom_rules" id="must-cdk.AmplifyAppProps.property.customRules"></a>

```python
custom_rules: typing.List[CustomRule]
```

- *Type:* typing.List[<a href="#must-cdk.CustomRule">CustomRule</a>]

Custom rules for the Amplify app.

Used for redirects, rewrites, and other routing rules.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.AmplifyAppProps.property.environmentVariables"></a>

```python
environment_variables: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Environment variables for the Amplify app.

These will be available during the build process.

---

##### `platform`<sup>Optional</sup> <a name="platform" id="must-cdk.AmplifyAppProps.property.platform"></a>

```python
platform: str
```

- *Type:* str
- *Default:* "WEB"

Platform for the Amplify app.

---

### ApiGatewayToLambdaProps <a name="ApiGatewayToLambdaProps" id="must-cdk.ApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.ApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.ApiGatewayToLambdaProps(
  tags: typing.Mapping[str] = None,
  api_name: str,
  lambda_function: IFunction,
  binary_media_types: typing.List[str] = None,
  create_usage_plan: bool = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[CustomRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  lambda_api_props: LambdaRestApiProps = None,
  log_group_props: LogGroupProps = None,
  proxy: bool = None,
  rest_api_props: RestApiProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.binaryMediaTypes">binary_media_types</a></code> | <code>typing.List[str]</code> | Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan">create_usage_plan</a></code> | <code>bool</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps">lambda_api_props</a></code> | <code>aws_cdk.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.proxy">proxy</a></code> | <code>bool</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.restApiProps">rest_api_props</a></code> | <code>aws_cdk.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.ApiGatewayToLambdaProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.ApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `binary_media_types`<sup>Optional</sup> <a name="binary_media_types" id="must-cdk.ApiGatewayToLambdaProps.property.binaryMediaTypes"></a>

```python
binary_media_types: typing.List[str]
```

- *Type:* typing.List[str]

Binary media types for the API This setting will be applied regardless of whether LambdaRestApi or RestApi is used.

---

##### `create_usage_plan`<sup>Optional</sup> <a name="create_usage_plan" id="must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan"></a>

```python
create_usage_plan: bool
```

- *Type:* bool

Whether to create a Usage Plan.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.ApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.ApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[CustomRoute]
```

- *Type:* typing.List[<a href="#must-cdk.CustomRoute">CustomRoute</a>]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.ApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.ApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.ApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambda_api_props`<sup>Optional</sup> <a name="lambda_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps"></a>

```python
lambda_api_props: LambdaRestApiProps
```

- *Type:* aws_cdk.aws_apigateway.LambdaRestApiProps

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.ApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambdaProps.property.proxy"></a>

```python
proxy: bool
```

- *Type:* bool

---

##### `rest_api_props`<sup>Optional</sup> <a name="rest_api_props" id="must-cdk.ApiGatewayToLambdaProps.property.restApiProps"></a>

```python
rest_api_props: RestApiProps
```

- *Type:* aws_cdk.aws_apigateway.RestApiProps

---

### AutoScalingProps <a name="AutoScalingProps" id="must-cdk.AutoScalingProps"></a>

Configuration for ECS service auto-scaling.

#### Initializer <a name="Initializer" id="must-cdk.AutoScalingProps.Initializer"></a>

```python
import must_cdk

must_cdk.AutoScalingProps(
  max_capacity: typing.Union[int, float],
  min_capacity: typing.Union[int, float],
  cpu_scale: CpuUtilizationScalingProps = None,
  memory_scale: MemoryUtilizationScalingProps = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AutoScalingProps.property.maxCapacity">max_capacity</a></code> | <code>typing.Union[int, float]</code> | Maximum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.minCapacity">min_capacity</a></code> | <code>typing.Union[int, float]</code> | Minimum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.cpuScale">cpu_scale</a></code> | <code>aws_cdk.aws_ecs.CpuUtilizationScalingProps</code> | Scale task based on CPU utilization. |
| <code><a href="#must-cdk.AutoScalingProps.property.memoryScale">memory_scale</a></code> | <code>aws_cdk.aws_ecs.MemoryUtilizationScalingProps</code> | Scale task based on memory utilization. |

---

##### `max_capacity`<sup>Required</sup> <a name="max_capacity" id="must-cdk.AutoScalingProps.property.maxCapacity"></a>

```python
max_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Maximum number of tasks to run.

---

##### `min_capacity`<sup>Required</sup> <a name="min_capacity" id="must-cdk.AutoScalingProps.property.minCapacity"></a>

```python
min_capacity: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Minimum number of tasks to run.

---

##### `cpu_scale`<sup>Optional</sup> <a name="cpu_scale" id="must-cdk.AutoScalingProps.property.cpuScale"></a>

```python
cpu_scale: CpuUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.CpuUtilizationScalingProps

Scale task based on CPU utilization.

---

##### `memory_scale`<sup>Optional</sup> <a name="memory_scale" id="must-cdk.AutoScalingProps.property.memoryScale"></a>

```python
memory_scale: MemoryUtilizationScalingProps
```

- *Type:* aws_cdk.aws_ecs.MemoryUtilizationScalingProps

Scale task based on memory utilization.

---

### BasicAuthConfig <a name="BasicAuthConfig" id="must-cdk.BasicAuthConfig"></a>

Basic authentication configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BasicAuthConfig.Initializer"></a>

```python
import must_cdk

must_cdk.BasicAuthConfig(
  password: str,
  username: str,
  enable_basic_auth: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BasicAuthConfig.property.password">password</a></code> | <code>str</code> | Password for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.username">username</a></code> | <code>str</code> | Username for basic authentication. |
| <code><a href="#must-cdk.BasicAuthConfig.property.enableBasicAuth">enable_basic_auth</a></code> | <code>bool</code> | Whether to enable basic authentication. |

---

##### `password`<sup>Required</sup> <a name="password" id="must-cdk.BasicAuthConfig.property.password"></a>

```python
password: str
```

- *Type:* str

Password for basic authentication.

---

##### `username`<sup>Required</sup> <a name="username" id="must-cdk.BasicAuthConfig.property.username"></a>

```python
username: str
```

- *Type:* str

Username for basic authentication.

---

##### `enable_basic_auth`<sup>Optional</sup> <a name="enable_basic_auth" id="must-cdk.BasicAuthConfig.property.enableBasicAuth"></a>

```python
enable_basic_auth: bool
```

- *Type:* bool
- *Default:* true

Whether to enable basic authentication.

---

### BranchOptions <a name="BranchOptions" id="must-cdk.BranchOptions"></a>

Branch configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BranchOptions.Initializer"></a>

```python
import must_cdk

must_cdk.BranchOptions(
  branch_name: str,
  build_spec: str = None,
  enable_auto_build: bool = None,
  environment_variables: typing.Mapping[str] = None,
  framework: str = None,
  pull_request_preview: bool = None,
  stage: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BranchOptions.property.branchName">branch_name</a></code> | <code>str</code> | The name of the branch. |
| <code><a href="#must-cdk.BranchOptions.property.buildSpec">build_spec</a></code> | <code>str</code> | Branch-specific build specification. |
| <code><a href="#must-cdk.BranchOptions.property.enableAutoBuild">enable_auto_build</a></code> | <code>bool</code> | Whether to enable automatic builds for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.environmentVariables">environment_variables</a></code> | <code>typing.Mapping[str]</code> | Environment variables specific to this branch. |
| <code><a href="#must-cdk.BranchOptions.property.framework">framework</a></code> | <code>str</code> | The framework for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.pullRequestPreview">pull_request_preview</a></code> | <code>bool</code> | Whether to enable pull request previews for this branch. |
| <code><a href="#must-cdk.BranchOptions.property.stage">stage</a></code> | <code>str</code> | The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT). |

---

##### `branch_name`<sup>Required</sup> <a name="branch_name" id="must-cdk.BranchOptions.property.branchName"></a>

```python
branch_name: str
```

- *Type:* str

The name of the branch.

---

##### `build_spec`<sup>Optional</sup> <a name="build_spec" id="must-cdk.BranchOptions.property.buildSpec"></a>

```python
build_spec: str
```

- *Type:* str

Branch-specific build specification.

---

##### `enable_auto_build`<sup>Optional</sup> <a name="enable_auto_build" id="must-cdk.BranchOptions.property.enableAutoBuild"></a>

```python
enable_auto_build: bool
```

- *Type:* bool
- *Default:* true

Whether to enable automatic builds for this branch.

---

##### `environment_variables`<sup>Optional</sup> <a name="environment_variables" id="must-cdk.BranchOptions.property.environmentVariables"></a>

```python
environment_variables: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Environment variables specific to this branch.

---

##### `framework`<sup>Optional</sup> <a name="framework" id="must-cdk.BranchOptions.property.framework"></a>

```python
framework: str
```

- *Type:* str

The framework for this branch.

---

##### `pull_request_preview`<sup>Optional</sup> <a name="pull_request_preview" id="must-cdk.BranchOptions.property.pullRequestPreview"></a>

```python
pull_request_preview: bool
```

- *Type:* bool
- *Default:* false

Whether to enable pull request previews for this branch.

---

##### `stage`<sup>Optional</sup> <a name="stage" id="must-cdk.BranchOptions.property.stage"></a>

```python
stage: str
```

- *Type:* str
- *Default:* "PRODUCTION"

The stage for the branch (e.g., PRODUCTION, BETA, DEVELOPMENT).

---

### BuildSettings <a name="BuildSettings" id="must-cdk.BuildSettings"></a>

Build settings for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.BuildSettings.Initializer"></a>

```python
import must_cdk

must_cdk.BuildSettings(
  cache_type: str = None,
  compute_type: str = None,
  enable_auto_branch_creation: bool = None,
  enable_auto_branch_deletion: bool = None,
  enable_branch_auto_build: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.BuildSettings.property.cacheType">cache_type</a></code> | <code>str</code> | Cache type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.computeType">compute_type</a></code> | <code>str</code> | Compute type for the build. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchCreation">enable_auto_branch_creation</a></code> | <code>bool</code> | Whether to enable automatic branch creation when a new branch is pushed to the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableAutoBranchDeletion">enable_auto_branch_deletion</a></code> | <code>bool</code> | Whether to enable automatic branch deletion when a branch is deleted from the repository. |
| <code><a href="#must-cdk.BuildSettings.property.enableBranchAutoBuild">enable_branch_auto_build</a></code> | <code>bool</code> | Whether to enable automatic builds when code is pushed to a branch. |

---

##### `cache_type`<sup>Optional</sup> <a name="cache_type" id="must-cdk.BuildSettings.property.cacheType"></a>

```python
cache_type: str
```

- *Type:* str
- *Default:* "AMPLIFY_MANAGED"

Cache type for the build.

---

##### `compute_type`<sup>Optional</sup> <a name="compute_type" id="must-cdk.BuildSettings.property.computeType"></a>

```python
compute_type: str
```

- *Type:* str
- *Default:* "STANDARD"

Compute type for the build.

---

##### `enable_auto_branch_creation`<sup>Optional</sup> <a name="enable_auto_branch_creation" id="must-cdk.BuildSettings.property.enableAutoBranchCreation"></a>

```python
enable_auto_branch_creation: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic branch creation when a new branch is pushed to the repository.

---

##### `enable_auto_branch_deletion`<sup>Optional</sup> <a name="enable_auto_branch_deletion" id="must-cdk.BuildSettings.property.enableAutoBranchDeletion"></a>

```python
enable_auto_branch_deletion: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic branch deletion when a branch is deleted from the repository.

---

##### `enable_branch_auto_build`<sup>Optional</sup> <a name="enable_branch_auto_build" id="must-cdk.BuildSettings.property.enableBranchAutoBuild"></a>

```python
enable_branch_auto_build: bool
```

- *Type:* bool
- *Default:* true

Whether to enable automatic builds when code is pushed to a branch.

---

### CacheBehaviorConfig <a name="CacheBehaviorConfig" id="must-cdk.CacheBehaviorConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.CacheBehaviorConfig.Initializer"></a>

```python
import must_cdk

must_cdk.CacheBehaviorConfig(
  origin_id: str,
  path_pattern: str,
  allowed_methods: AllowedMethods = None,
  cached_methods: CachedMethods = None,
  cache_policy: ICachePolicy = None,
  cache_policy_id: str = None,
  compress: bool = None,
  origin_request_policy: IOriginRequestPolicy = None,
  origin_request_policy_id: str = None,
  response_headers_policy: IResponseHeadersPolicy = None,
  response_headers_policy_id: str = None,
  viewer_protocol_policy: ViewerProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originId">origin_id</a></code> | <code>str</code> | Origin ID to route this pattern to. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.pathPattern">path_pattern</a></code> | <code>str</code> | Path pattern for this behavior (e.g., "/api/*", "*.jpg"). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.allowedMethods">allowed_methods</a></code> | <code>aws_cdk.aws_cloudfront.AllowedMethods</code> | Allowed HTTP methods. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachedMethods">cached_methods</a></code> | <code>aws_cdk.aws_cloudfront.CachedMethods</code> | Methods to cache. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicy">cache_policy</a></code> | <code>aws_cdk.aws_cloudfront.ICachePolicy</code> | Cache policy (alternative to cachePolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicyId">cache_policy_id</a></code> | <code>str</code> | Cache policy ID (use AWS managed policies). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.compress">compress</a></code> | <code>bool</code> | Enable compression. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicy">origin_request_policy</a></code> | <code>aws_cdk.aws_cloudfront.IOriginRequestPolicy</code> | Origin request policy (alternative to originRequestPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicyId">origin_request_policy_id</a></code> | <code>str</code> | Origin request policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy">response_headers_policy</a></code> | <code>aws_cdk.aws_cloudfront.IResponseHeadersPolicy</code> | Response headers policy (alternative to responseHeadersPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId">response_headers_policy_id</a></code> | <code>str</code> | Response headers policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy">viewer_protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.ViewerProtocolPolicy</code> | Viewer protocol policy. |

---

##### `origin_id`<sup>Required</sup> <a name="origin_id" id="must-cdk.CacheBehaviorConfig.property.originId"></a>

```python
origin_id: str
```

- *Type:* str

Origin ID to route this pattern to.

---

##### `path_pattern`<sup>Required</sup> <a name="path_pattern" id="must-cdk.CacheBehaviorConfig.property.pathPattern"></a>

```python
path_pattern: str
```

- *Type:* str

Path pattern for this behavior (e.g., "/api/*", "*.jpg").

---

##### `allowed_methods`<sup>Optional</sup> <a name="allowed_methods" id="must-cdk.CacheBehaviorConfig.property.allowedMethods"></a>

```python
allowed_methods: AllowedMethods
```

- *Type:* aws_cdk.aws_cloudfront.AllowedMethods
- *Default:* ALLOW_GET_HEAD for S3, ALLOW_ALL for HTTP

Allowed HTTP methods.

---

##### `cached_methods`<sup>Optional</sup> <a name="cached_methods" id="must-cdk.CacheBehaviorConfig.property.cachedMethods"></a>

```python
cached_methods: CachedMethods
```

- *Type:* aws_cdk.aws_cloudfront.CachedMethods
- *Default:* CACHE_GET_HEAD_OPTIONS

Methods to cache.

---

##### `cache_policy`<sup>Optional</sup> <a name="cache_policy" id="must-cdk.CacheBehaviorConfig.property.cachePolicy"></a>

```python
cache_policy: ICachePolicy
```

- *Type:* aws_cdk.aws_cloudfront.ICachePolicy

Cache policy (alternative to cachePolicyId).

---

##### `cache_policy_id`<sup>Optional</sup> <a name="cache_policy_id" id="must-cdk.CacheBehaviorConfig.property.cachePolicyId"></a>

```python
cache_policy_id: str
```

- *Type:* str

Cache policy ID (use AWS managed policies).

---

##### `compress`<sup>Optional</sup> <a name="compress" id="must-cdk.CacheBehaviorConfig.property.compress"></a>

```python
compress: bool
```

- *Type:* bool
- *Default:* true

Enable compression.

---

##### `origin_request_policy`<sup>Optional</sup> <a name="origin_request_policy" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicy"></a>

```python
origin_request_policy: IOriginRequestPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IOriginRequestPolicy

Origin request policy (alternative to originRequestPolicyId).

---

##### `origin_request_policy_id`<sup>Optional</sup> <a name="origin_request_policy_id" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicyId"></a>

```python
origin_request_policy_id: str
```

- *Type:* str

Origin request policy ID.

---

##### `response_headers_policy`<sup>Optional</sup> <a name="response_headers_policy" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy"></a>

```python
response_headers_policy: IResponseHeadersPolicy
```

- *Type:* aws_cdk.aws_cloudfront.IResponseHeadersPolicy

Response headers policy (alternative to responseHeadersPolicyId).

---

##### `response_headers_policy_id`<sup>Optional</sup> <a name="response_headers_policy_id" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId"></a>

```python
response_headers_policy_id: str
```

- *Type:* str

Response headers policy ID.

---

##### `viewer_protocol_policy`<sup>Optional</sup> <a name="viewer_protocol_policy" id="must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy"></a>

```python
viewer_protocol_policy: ViewerProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.ViewerProtocolPolicy
- *Default:* REDIRECT_TO_HTTPS

Viewer protocol policy.

---

### CloudFrontToOriginsProps <a name="CloudFrontToOriginsProps" id="must-cdk.CloudFrontToOriginsProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.CloudFrontToOriginsProps.Initializer"></a>

```python
import must_cdk

must_cdk.CloudFrontToOriginsProps(
  tags: typing.Mapping[str] = None,
  additional_domain_names: typing.List[str] = None,
  cache_behaviors: typing.List[CacheBehaviorConfig] = None,
  certificate: ICertificate = None,
  comment: str = None,
  create_route53_records: bool = None,
  custom_domain_name: str = None,
  default_origin_id: str = None,
  default_root_object: str = None,
  enabled: bool = None,
  enable_ipv6: bool = None,
  enable_logging: bool = None,
  error_pages: typing.List[ErrorResponse] = None,
  geo_restriction: GeoRestriction = None,
  hosted_zone: IHostedZone = None,
  http_origins: typing.List[HttpOriginConfig] = None,
  http_version: HttpVersion = None,
  log_bucket: IBucket = None,
  log_include_cookies: bool = None,
  log_prefix: str = None,
  price_class: PriceClass = None,
  s3_origins: typing.List[S3OriginConfig] = None,
  web_acl_id: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames">additional_domain_names</a></code> | <code>typing.List[str]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors">cache_behaviors</a></code> | <code>typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.certificate">certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.comment">comment</a></code> | <code>str</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.createRoute53Records">create_route53_records</a></code> | <code>bool</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultOriginId">default_origin_id</a></code> | <code>str</code> | ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultRootObject">default_root_object</a></code> | <code>str</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enabled">enabled</a></code> | <code>bool</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableIpv6">enable_ipv6</a></code> | <code>bool</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.errorPages">error_pages</a></code> | <code>typing.List[aws_cdk.aws_cloudfront.ErrorResponse]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.geoRestriction">geo_restriction</a></code> | <code>aws_cdk.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpOrigins">http_origins</a></code> | <code>typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpVersion">http_version</a></code> | <code>aws_cdk.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logBucket">log_bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies">log_include_cookies</a></code> | <code>bool</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logPrefix">log_prefix</a></code> | <code>str</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.priceClass">price_class</a></code> | <code>aws_cdk.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.s3Origins">s3_origins</a></code> | <code>typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.webAclId">web_acl_id</a></code> | <code>str</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.CloudFrontToOriginsProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `additional_domain_names`<sup>Optional</sup> <a name="additional_domain_names" id="must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames"></a>

```python
additional_domain_names: typing.List[str]
```

- *Type:* typing.List[str]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

CloudFront only supports one certificate per distribution.

---

##### `cache_behaviors`<sup>Optional</sup> <a name="cache_behaviors" id="must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors"></a>

```python
cache_behaviors: typing.List[CacheBehaviorConfig]
```

- *Type:* typing.List[<a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>]

Cache behaviors for specific path patterns.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOriginsProps.property.certificate"></a>

```python
certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Existing ACM certificate to use for the CloudFront distribution Certificate must be in us-east-1 region for CloudFront.

The certificate must cover all domains (customDomainName + additionalDomainNames).
CloudFront only supports one certificate per distribution.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOriginsProps.property.comment"></a>

```python
comment: str
```

- *Type:* str

Comment for the distribution.

---

##### `create_route53_records`<sup>Optional</sup> <a name="create_route53_records" id="must-cdk.CloudFrontToOriginsProps.property.createRoute53Records"></a>

```python
create_route53_records: bool
```

- *Type:* bool
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.CloudFrontToOriginsProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Primary custom domain name for the CloudFront distribution.

---

##### `default_origin_id`<sup>Optional</sup> <a name="default_origin_id" id="must-cdk.CloudFrontToOriginsProps.property.defaultOriginId"></a>

```python
default_origin_id: str
```

- *Type:* str

ID of the origin to use as default behavior If not specified, will use the first HTTP origin, then first S3 origin.

---

##### `default_root_object`<sup>Optional</sup> <a name="default_root_object" id="must-cdk.CloudFrontToOriginsProps.property.defaultRootObject"></a>

```python
default_root_object: str
```

- *Type:* str
- *Default:* "index.html"

Default root object for the distribution.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOriginsProps.property.enabled"></a>

```python
enabled: bool
```

- *Type:* bool
- *Default:* true

Whether the distribution is enabled.

---

##### `enable_ipv6`<sup>Optional</sup> <a name="enable_ipv6" id="must-cdk.CloudFrontToOriginsProps.property.enableIpv6"></a>

```python
enable_ipv6: bool
```

- *Type:* bool
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.CloudFrontToOriginsProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool
- *Default:* true

Enable CloudFront access logging.

---

##### `error_pages`<sup>Optional</sup> <a name="error_pages" id="must-cdk.CloudFrontToOriginsProps.property.errorPages"></a>

```python
error_pages: typing.List[ErrorResponse]
```

- *Type:* typing.List[aws_cdk.aws_cloudfront.ErrorResponse]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geo_restriction`<sup>Optional</sup> <a name="geo_restriction" id="must-cdk.CloudFrontToOriginsProps.property.geoRestriction"></a>

```python
geo_restriction: GeoRestriction
```

- *Type:* aws_cdk.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.CloudFrontToOriginsProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `http_origins`<sup>Optional</sup> <a name="http_origins" id="must-cdk.CloudFrontToOriginsProps.property.httpOrigins"></a>

```python
http_origins: typing.List[HttpOriginConfig]
```

- *Type:* typing.List[<a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>]

HTTP origins configuration.

---

##### `http_version`<sup>Optional</sup> <a name="http_version" id="must-cdk.CloudFrontToOriginsProps.property.httpVersion"></a>

```python
http_version: HttpVersion
```

- *Type:* aws_cdk.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `log_bucket`<sup>Optional</sup> <a name="log_bucket" id="must-cdk.CloudFrontToOriginsProps.property.logBucket"></a>

```python
log_bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `log_include_cookies`<sup>Optional</sup> <a name="log_include_cookies" id="must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies"></a>

```python
log_include_cookies: bool
```

- *Type:* bool
- *Default:* false

Include cookies in access logs.

---

##### `log_prefix`<sup>Optional</sup> <a name="log_prefix" id="must-cdk.CloudFrontToOriginsProps.property.logPrefix"></a>

```python
log_prefix: str
```

- *Type:* str
- *Default:* "cloudfront"

Prefix for log files.

---

##### `price_class`<sup>Optional</sup> <a name="price_class" id="must-cdk.CloudFrontToOriginsProps.property.priceClass"></a>

```python
price_class: PriceClass
```

- *Type:* aws_cdk.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3_origins`<sup>Optional</sup> <a name="s3_origins" id="must-cdk.CloudFrontToOriginsProps.property.s3Origins"></a>

```python
s3_origins: typing.List[S3OriginConfig]
```

- *Type:* typing.List[<a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>]

S3 origins configuration.

---

##### `web_acl_id`<sup>Optional</sup> <a name="web_acl_id" id="must-cdk.CloudFrontToOriginsProps.property.webAclId"></a>

```python
web_acl_id: str
```

- *Type:* str

Web Application Firewall (WAF) web ACL ID.

---

### CodeDeployConfig <a name="CodeDeployConfig" id="must-cdk.CodeDeployConfig"></a>

Configuration for CodeDeploy deployment.

#### Initializer <a name="Initializer" id="must-cdk.CodeDeployConfig.Initializer"></a>

```python
import must_cdk

must_cdk.CodeDeployConfig(
  termination_wait_time: Duration = None,
  traffic_routing_interval: Duration = None,
  traffic_routing_start_percent: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CodeDeployConfig.property.terminationWaitTime">termination_wait_time</a></code> | <code>aws_cdk.Duration</code> | The termination wait time after deployment (default: 30 minutes). |
| <code><a href="#must-cdk.CodeDeployConfig.property.trafficRoutingInterval">traffic_routing_interval</a></code> | <code>aws_cdk.Duration</code> | The interval between traffic shifting increments (default: 1 minute). |
| <code><a href="#must-cdk.CodeDeployConfig.property.trafficRoutingStartPercent">traffic_routing_start_percent</a></code> | <code>typing.Union[int, float]</code> | The percentage of traffic to shift initially (default: 10%). |

---

##### `termination_wait_time`<sup>Optional</sup> <a name="termination_wait_time" id="must-cdk.CodeDeployConfig.property.terminationWaitTime"></a>

```python
termination_wait_time: Duration
```

- *Type:* aws_cdk.Duration

The termination wait time after deployment (default: 30 minutes).

---

##### `traffic_routing_interval`<sup>Optional</sup> <a name="traffic_routing_interval" id="must-cdk.CodeDeployConfig.property.trafficRoutingInterval"></a>

```python
traffic_routing_interval: Duration
```

- *Type:* aws_cdk.Duration

The interval between traffic shifting increments (default: 1 minute).

---

##### `traffic_routing_start_percent`<sup>Optional</sup> <a name="traffic_routing_start_percent" id="must-cdk.CodeDeployConfig.property.trafficRoutingStartPercent"></a>

```python
traffic_routing_start_percent: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The percentage of traffic to shift initially (default: 10%).

---

### ContainerProps <a name="ContainerProps" id="must-cdk.ContainerProps"></a>

Configuration for the ECS Fargate task definition and container.

#### Initializer <a name="Initializer" id="must-cdk.ContainerProps.Initializer"></a>

```python
import must_cdk

must_cdk.ContainerProps(
  container_port: typing.Union[int, float],
  image: ContainerImage,
  command: typing.List[str] = None,
  cpu: typing.Union[int, float] = None,
  entry_point: typing.List[str] = None,
  environment: typing.Mapping[str] = None,
  essential: bool = None,
  health_check: HealthCheck = None,
  logging: LogDriver = None,
  memory_limit: typing.Union[int, float] = None,
  memory_reservation: typing.Union[int, float] = None,
  name: str = None,
  secrets: typing.Mapping[Secret] = None,
  user: str = None,
  working_directory: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ContainerProps.property.containerPort">container_port</a></code> | <code>typing.Union[int, float]</code> | The port number the container listens on. |
| <code><a href="#must-cdk.ContainerProps.property.image">image</a></code> | <code>aws_cdk.aws_ecs.ContainerImage</code> | Container image to deploy. |
| <code><a href="#must-cdk.ContainerProps.property.command">command</a></code> | <code>typing.List[str]</code> | Command to run in the container. |
| <code><a href="#must-cdk.ContainerProps.property.cpu">cpu</a></code> | <code>typing.Union[int, float]</code> | CPU units for this container (default: uses task-level CPU allocation). |
| <code><a href="#must-cdk.ContainerProps.property.entryPoint">entry_point</a></code> | <code>typing.List[str]</code> | Entry point for the container. |
| <code><a href="#must-cdk.ContainerProps.property.environment">environment</a></code> | <code>typing.Mapping[str]</code> | Environment variables to set in the container. |
| <code><a href="#must-cdk.ContainerProps.property.essential">essential</a></code> | <code>bool</code> | Whether this container is essential (default: true). |
| <code><a href="#must-cdk.ContainerProps.property.healthCheck">health_check</a></code> | <code>aws_cdk.aws_ecs.HealthCheck</code> | Optional container health check configuration. |
| <code><a href="#must-cdk.ContainerProps.property.logging">logging</a></code> | <code>aws_cdk.aws_ecs.LogDriver</code> | Optional log driver configuration for the container. |
| <code><a href="#must-cdk.ContainerProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | Hard memory limit in MiB for the task (default: 2048). |
| <code><a href="#must-cdk.ContainerProps.property.memoryReservation">memory_reservation</a></code> | <code>typing.Union[int, float]</code> | Soft memory reservation in MiB for the container (default: 1024). |
| <code><a href="#must-cdk.ContainerProps.property.name">name</a></code> | <code>str</code> | Optional container name (default: Container{index}). |
| <code><a href="#must-cdk.ContainerProps.property.secrets">secrets</a></code> | <code>typing.Mapping[aws_cdk.aws_ecs.Secret]</code> | Secrets to inject into the container from AWS Systems Manager Parameter Store or AWS Secrets Manager. |
| <code><a href="#must-cdk.ContainerProps.property.user">user</a></code> | <code>str</code> | User to run the container as. |
| <code><a href="#must-cdk.ContainerProps.property.workingDirectory">working_directory</a></code> | <code>str</code> | Working directory inside the container. |

---

##### `container_port`<sup>Required</sup> <a name="container_port" id="must-cdk.ContainerProps.property.containerPort"></a>

```python
container_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The port number the container listens on.

---

##### `image`<sup>Required</sup> <a name="image" id="must-cdk.ContainerProps.property.image"></a>

```python
image: ContainerImage
```

- *Type:* aws_cdk.aws_ecs.ContainerImage

Container image to deploy.

---

##### `command`<sup>Optional</sup> <a name="command" id="must-cdk.ContainerProps.property.command"></a>

```python
command: typing.List[str]
```

- *Type:* typing.List[str]

Command to run in the container.

---

##### `cpu`<sup>Optional</sup> <a name="cpu" id="must-cdk.ContainerProps.property.cpu"></a>

```python
cpu: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

CPU units for this container (default: uses task-level CPU allocation).

---

##### `entry_point`<sup>Optional</sup> <a name="entry_point" id="must-cdk.ContainerProps.property.entryPoint"></a>

```python
entry_point: typing.List[str]
```

- *Type:* typing.List[str]

Entry point for the container.

---

##### `environment`<sup>Optional</sup> <a name="environment" id="must-cdk.ContainerProps.property.environment"></a>

```python
environment: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Environment variables to set in the container.

---

##### `essential`<sup>Optional</sup> <a name="essential" id="must-cdk.ContainerProps.property.essential"></a>

```python
essential: bool
```

- *Type:* bool

Whether this container is essential (default: true).

---

##### `health_check`<sup>Optional</sup> <a name="health_check" id="must-cdk.ContainerProps.property.healthCheck"></a>

```python
health_check: HealthCheck
```

- *Type:* aws_cdk.aws_ecs.HealthCheck

Optional container health check configuration.

---

##### `logging`<sup>Optional</sup> <a name="logging" id="must-cdk.ContainerProps.property.logging"></a>

```python
logging: LogDriver
```

- *Type:* aws_cdk.aws_ecs.LogDriver

Optional log driver configuration for the container.

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.ContainerProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Hard memory limit in MiB for the task (default: 2048).

---

##### `memory_reservation`<sup>Optional</sup> <a name="memory_reservation" id="must-cdk.ContainerProps.property.memoryReservation"></a>

```python
memory_reservation: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Soft memory reservation in MiB for the container (default: 1024).

---

##### `name`<sup>Optional</sup> <a name="name" id="must-cdk.ContainerProps.property.name"></a>

```python
name: str
```

- *Type:* str

Optional container name (default: Container{index}).

---

##### `secrets`<sup>Optional</sup> <a name="secrets" id="must-cdk.ContainerProps.property.secrets"></a>

```python
secrets: typing.Mapping[Secret]
```

- *Type:* typing.Mapping[aws_cdk.aws_ecs.Secret]

Secrets to inject into the container from AWS Systems Manager Parameter Store or AWS Secrets Manager.

---

##### `user`<sup>Optional</sup> <a name="user" id="must-cdk.ContainerProps.property.user"></a>

```python
user: str
```

- *Type:* str

User to run the container as.

---

##### `working_directory`<sup>Optional</sup> <a name="working_directory" id="must-cdk.ContainerProps.property.workingDirectory"></a>

```python
working_directory: str
```

- *Type:* str

Working directory inside the container.

---

### CustomDomainOptions <a name="CustomDomainOptions" id="must-cdk.CustomDomainOptions"></a>

Custom domain configuration for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomDomainOptions.Initializer"></a>

```python
import must_cdk

must_cdk.CustomDomainOptions(
  domain_name: str,
  auto_subdomain_creation_patterns: typing.List[str] = None,
  enable_auto_subdomain: bool = None,
  sub_domains: typing.List[SubDomainOptions] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomDomainOptions.property.domainName">domain_name</a></code> | <code>str</code> | The custom domain name for the Amplify app. |
| <code><a href="#must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns">auto_subdomain_creation_patterns</a></code> | <code>typing.List[str]</code> | Patterns for automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.enableAutoSubdomain">enable_auto_subdomain</a></code> | <code>bool</code> | Whether to enable automatic subdomain creation. |
| <code><a href="#must-cdk.CustomDomainOptions.property.subDomains">sub_domains</a></code> | <code>typing.List[<a href="#must-cdk.SubDomainOptions">SubDomainOptions</a>]</code> | Subdomain configurations for the custom domain. |

---

##### `domain_name`<sup>Required</sup> <a name="domain_name" id="must-cdk.CustomDomainOptions.property.domainName"></a>

```python
domain_name: str
```

- *Type:* str

The custom domain name for the Amplify app.

---

##### `auto_subdomain_creation_patterns`<sup>Optional</sup> <a name="auto_subdomain_creation_patterns" id="must-cdk.CustomDomainOptions.property.autoSubdomainCreationPatterns"></a>

```python
auto_subdomain_creation_patterns: typing.List[str]
```

- *Type:* typing.List[str]

Patterns for automatic subdomain creation.

---

##### `enable_auto_subdomain`<sup>Optional</sup> <a name="enable_auto_subdomain" id="must-cdk.CustomDomainOptions.property.enableAutoSubdomain"></a>

```python
enable_auto_subdomain: bool
```

- *Type:* bool
- *Default:* false

Whether to enable automatic subdomain creation.

---

##### `sub_domains`<sup>Optional</sup> <a name="sub_domains" id="must-cdk.CustomDomainOptions.property.subDomains"></a>

```python
sub_domains: typing.List[SubDomainOptions]
```

- *Type:* typing.List[<a href="#must-cdk.SubDomainOptions">SubDomainOptions</a>]

Subdomain configurations for the custom domain.

---

### CustomRoute <a name="CustomRoute" id="must-cdk.CustomRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.CustomRoute.Initializer"></a>

```python
import must_cdk

must_cdk.CustomRoute(
  handler: IFunction,
  method: str,
  path: str,
  method_options: MethodOptions = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.method">method</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.path">path</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.methodOptions">method_options</a></code> | <code>aws_cdk.aws_apigateway.MethodOptions</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.CustomRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `method`<sup>Required</sup> <a name="method" id="must-cdk.CustomRoute.property.method"></a>

```python
method: str
```

- *Type:* str

---

##### `path`<sup>Required</sup> <a name="path" id="must-cdk.CustomRoute.property.path"></a>

```python
path: str
```

- *Type:* str

---

##### `method_options`<sup>Optional</sup> <a name="method_options" id="must-cdk.CustomRoute.property.methodOptions"></a>

```python
method_options: MethodOptions
```

- *Type:* aws_cdk.aws_apigateway.MethodOptions

---

### CustomRule <a name="CustomRule" id="must-cdk.CustomRule"></a>

Custom routing rule for an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.CustomRule.Initializer"></a>

```python
import must_cdk

must_cdk.CustomRule(
  source: str,
  target: str,
  condition: str = None,
  status: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRule.property.source">source</a></code> | <code>str</code> | Source pattern to match in the URL. |
| <code><a href="#must-cdk.CustomRule.property.target">target</a></code> | <code>str</code> | Target URL to redirect or rewrite to. |
| <code><a href="#must-cdk.CustomRule.property.condition">condition</a></code> | <code>str</code> | Condition to apply the rule. |
| <code><a href="#must-cdk.CustomRule.property.status">status</a></code> | <code>str</code> | HTTP status code for the redirect. |

---

##### `source`<sup>Required</sup> <a name="source" id="must-cdk.CustomRule.property.source"></a>

```python
source: str
```

- *Type:* str

Source pattern to match in the URL.

---

##### `target`<sup>Required</sup> <a name="target" id="must-cdk.CustomRule.property.target"></a>

```python
target: str
```

- *Type:* str

Target URL to redirect or rewrite to.

---

##### `condition`<sup>Optional</sup> <a name="condition" id="must-cdk.CustomRule.property.condition"></a>

```python
condition: str
```

- *Type:* str

Condition to apply the rule.

---

##### `status`<sup>Optional</sup> <a name="status" id="must-cdk.CustomRule.property.status"></a>

```python
status: str
```

- *Type:* str
- *Default:* "200"

HTTP status code for the redirect.

---

### EcsCodeDeployProps <a name="EcsCodeDeployProps" id="must-cdk.EcsCodeDeployProps"></a>

Properties for the EcsCodeDeploy construct.

#### Initializer <a name="Initializer" id="must-cdk.EcsCodeDeployProps.Initializer"></a>

```python
import must_cdk

must_cdk.EcsCodeDeployProps(
  tags: typing.Mapping[str] = None,
  cluster: ICluster,
  containers: typing.List[ContainerProps],
  load_balancer: LoadBalancerConfig,
  security_groups: typing.List[ISecurityGroup],
  service_name: str,
  task_subnets: SubnetSelection,
  vpc: IVpc,
  assign_public_ip: bool = None,
  auto_scaling: AutoScalingProps = None,
  code_deploy_config: CodeDeployConfig = None,
  desired_count: typing.Union[int, float] = None,
  health_check_grace_period: typing.Union[int, float] = None,
  memory_limit: typing.Union[int, float] = None,
  target_port: typing.Union[int, float] = None,
  task_cp_u: typing.Union[int, float] = None,
  task_exec_role: IRole = None,
  task_role: IRole = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.cluster">cluster</a></code> | <code>aws_cdk.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.containers">containers</a></code> | <code>typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.loadBalancer">load_balancer</a></code> | <code><a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a></code> | Load balancer configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security group config for ECS service. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.serviceName">service_name</a></code> | <code>str</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskSubnets">task_subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the ECS tasks will be placed on. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.vpc">vpc</a></code> | <code>aws_cdk.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.assignPublicIp">assign_public_ip</a></code> | <code>bool</code> | Whether the Fargate tasks should be assigned public IP addresses (default: false). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.autoScaling">auto_scaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.codeDeployConfig">code_deploy_config</a></code> | <code><a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a></code> | CodeDeploy configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.desiredCount">desired_count</a></code> | <code>typing.Union[int, float]</code> | Desired count of tasks (default: 1). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.healthCheckGracePeriod">health_check_grace_period</a></code> | <code>typing.Union[int, float]</code> | Health check grace period in seconds (default: 300). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.memoryLimit">memory_limit</a></code> | <code>typing.Union[int, float]</code> | Memory limit for the task in MiB (default: 2048). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.targetPort">target_port</a></code> | <code>typing.Union[int, float]</code> | The port to expose on the target group (defaults to first container's port). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskCPU">task_cp_u</a></code> | <code>typing.Union[int, float]</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskExecRole">task_exec_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskRole">task_role</a></code> | <code>aws_cdk.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.EcsCodeDeployProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeployProps.property.cluster"></a>

```python
cluster: ICluster
```

- *Type:* aws_cdk.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeployProps.property.containers"></a>

```python
containers: typing.List[ContainerProps]
```

- *Type:* typing.List[<a href="#must-cdk.ContainerProps">ContainerProps</a>]

Configuration related to the task definition and container.

---

##### `load_balancer`<sup>Required</sup> <a name="load_balancer" id="must-cdk.EcsCodeDeployProps.property.loadBalancer"></a>

```python
load_balancer: LoadBalancerConfig
```

- *Type:* <a href="#must-cdk.LoadBalancerConfig">LoadBalancerConfig</a>

Load balancer configuration.

---

##### `security_groups`<sup>Required</sup> <a name="security_groups" id="must-cdk.EcsCodeDeployProps.property.securityGroups"></a>

```python
security_groups: typing.List[ISecurityGroup]
```

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security group config for ECS service.

---

##### `service_name`<sup>Required</sup> <a name="service_name" id="must-cdk.EcsCodeDeployProps.property.serviceName"></a>

```python
service_name: str
```

- *Type:* str

Base name used for resources like log groups, roles, services, etc.

---

##### `task_subnets`<sup>Required</sup> <a name="task_subnets" id="must-cdk.EcsCodeDeployProps.property.taskSubnets"></a>

```python
task_subnets: SubnetSelection
```

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the ECS tasks will be placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeployProps.property.vpc"></a>

```python
vpc: IVpc
```

- *Type:* aws_cdk.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `assign_public_ip`<sup>Optional</sup> <a name="assign_public_ip" id="must-cdk.EcsCodeDeployProps.property.assignPublicIp"></a>

```python
assign_public_ip: bool
```

- *Type:* bool

Whether the Fargate tasks should be assigned public IP addresses (default: false).

This is required if your tasks need to access the internet and are in a public subnet.

---

##### `auto_scaling`<sup>Optional</sup> <a name="auto_scaling" id="must-cdk.EcsCodeDeployProps.property.autoScaling"></a>

```python
auto_scaling: AutoScalingProps
```

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `code_deploy_config`<sup>Optional</sup> <a name="code_deploy_config" id="must-cdk.EcsCodeDeployProps.property.codeDeployConfig"></a>

```python
code_deploy_config: CodeDeployConfig
```

- *Type:* <a href="#must-cdk.CodeDeployConfig">CodeDeployConfig</a>

CodeDeploy configuration.

---

##### `desired_count`<sup>Optional</sup> <a name="desired_count" id="must-cdk.EcsCodeDeployProps.property.desiredCount"></a>

```python
desired_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Desired count of tasks (default: 1).

---

##### `health_check_grace_period`<sup>Optional</sup> <a name="health_check_grace_period" id="must-cdk.EcsCodeDeployProps.property.healthCheckGracePeriod"></a>

```python
health_check_grace_period: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Health check grace period in seconds (default: 300).

---

##### `memory_limit`<sup>Optional</sup> <a name="memory_limit" id="must-cdk.EcsCodeDeployProps.property.memoryLimit"></a>

```python
memory_limit: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

Memory limit for the task in MiB (default: 2048).

---

##### `target_port`<sup>Optional</sup> <a name="target_port" id="must-cdk.EcsCodeDeployProps.property.targetPort"></a>

```python
target_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The port to expose on the target group (defaults to first container's port).

---

##### `task_cp_u`<sup>Optional</sup> <a name="task_cp_u" id="must-cdk.EcsCodeDeployProps.property.taskCPU"></a>

```python
task_cp_u: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

CPU units for the task (default: 1024).

---

##### `task_exec_role`<sup>Optional</sup> <a name="task_exec_role" id="must-cdk.EcsCodeDeployProps.property.taskExecRole"></a>

```python
task_exec_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task execution role for the ECS task.

---

##### `task_role`<sup>Optional</sup> <a name="task_role" id="must-cdk.EcsCodeDeployProps.property.taskRole"></a>

```python
task_role: IRole
```

- *Type:* aws_cdk.aws_iam.IRole

Task role for the ECS task.

---

### HealthCheckConfig <a name="HealthCheckConfig" id="must-cdk.HealthCheckConfig"></a>

Health check configuration for target groups.

#### Initializer <a name="Initializer" id="must-cdk.HealthCheckConfig.Initializer"></a>

```python
import must_cdk

must_cdk.HealthCheckConfig(
  healthy_http_codes: str = None,
  healthy_threshold_count: typing.Union[int, float] = None,
  interval: Duration = None,
  path: str = None,
  port: str = None,
  timeout: Duration = None,
  unhealthy_threshold_count: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HealthCheckConfig.property.healthyHttpCodes">healthy_http_codes</a></code> | <code>str</code> | The HTTP codes to consider healthy (default: "200"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.healthyThresholdCount">healthy_threshold_count</a></code> | <code>typing.Union[int, float]</code> | The number of successful health checks before considering healthy (default: 3). |
| <code><a href="#must-cdk.HealthCheckConfig.property.interval">interval</a></code> | <code>aws_cdk.Duration</code> | The interval between health checks (default: 30 seconds). |
| <code><a href="#must-cdk.HealthCheckConfig.property.path">path</a></code> | <code>str</code> | The path for health checks (default: "/"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.port">port</a></code> | <code>str</code> | The port for health checks (default: "traffic-port"). |
| <code><a href="#must-cdk.HealthCheckConfig.property.timeout">timeout</a></code> | <code>aws_cdk.Duration</code> | The timeout for health checks (default: 5 seconds). |
| <code><a href="#must-cdk.HealthCheckConfig.property.unhealthyThresholdCount">unhealthy_threshold_count</a></code> | <code>typing.Union[int, float]</code> | The number of failed health checks before considering unhealthy (default: 3). |

---

##### `healthy_http_codes`<sup>Optional</sup> <a name="healthy_http_codes" id="must-cdk.HealthCheckConfig.property.healthyHttpCodes"></a>

```python
healthy_http_codes: str
```

- *Type:* str

The HTTP codes to consider healthy (default: "200").

---

##### `healthy_threshold_count`<sup>Optional</sup> <a name="healthy_threshold_count" id="must-cdk.HealthCheckConfig.property.healthyThresholdCount"></a>

```python
healthy_threshold_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of successful health checks before considering healthy (default: 3).

---

##### `interval`<sup>Optional</sup> <a name="interval" id="must-cdk.HealthCheckConfig.property.interval"></a>

```python
interval: Duration
```

- *Type:* aws_cdk.Duration

The interval between health checks (default: 30 seconds).

---

##### `path`<sup>Optional</sup> <a name="path" id="must-cdk.HealthCheckConfig.property.path"></a>

```python
path: str
```

- *Type:* str

The path for health checks (default: "/").

---

##### `port`<sup>Optional</sup> <a name="port" id="must-cdk.HealthCheckConfig.property.port"></a>

```python
port: str
```

- *Type:* str

The port for health checks (default: "traffic-port").

---

##### `timeout`<sup>Optional</sup> <a name="timeout" id="must-cdk.HealthCheckConfig.property.timeout"></a>

```python
timeout: Duration
```

- *Type:* aws_cdk.Duration

The timeout for health checks (default: 5 seconds).

---

##### `unhealthy_threshold_count`<sup>Optional</sup> <a name="unhealthy_threshold_count" id="must-cdk.HealthCheckConfig.property.unhealthyThresholdCount"></a>

```python
unhealthy_threshold_count: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The number of failed health checks before considering unhealthy (default: 3).

---

### HttpOriginConfig <a name="HttpOriginConfig" id="must-cdk.HttpOriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginConfig(
  domain_name: str,
  id: str,
  http_origin_props: HttpOriginProps = None,
  http_port: typing.Union[int, float] = None,
  https_port: typing.Union[int, float] = None,
  origin_path: str = None,
  protocol_policy: OriginProtocolPolicy = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginConfig.property.domainName">domain_name</a></code> | <code>str</code> | Domain name of the HTTP origin (required). |
| <code><a href="#must-cdk.HttpOriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this HTTP origin. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpOriginProps">http_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOriginProps</code> | Additional HTTP origin properties. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpPort">http_port</a></code> | <code>typing.Union[int, float]</code> | HTTP port (for HTTP protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpsPort">https_port</a></code> | <code>typing.Union[int, float]</code> | HTTPS port (for HTTPS protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for HTTP requests (e.g., "/api/v1"). |
| <code><a href="#must-cdk.HttpOriginConfig.property.protocolPolicy">protocol_policy</a></code> | <code>aws_cdk.aws_cloudfront.OriginProtocolPolicy</code> | Protocol policy for the origin. |

---

##### `domain_name`<sup>Required</sup> <a name="domain_name" id="must-cdk.HttpOriginConfig.property.domainName"></a>

```python
domain_name: str
```

- *Type:* str

Domain name of the HTTP origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this HTTP origin.

---

##### `http_origin_props`<sup>Optional</sup> <a name="http_origin_props" id="must-cdk.HttpOriginConfig.property.httpOriginProps"></a>

```python
http_origin_props: HttpOriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOriginProps

Additional HTTP origin properties.

---

##### `http_port`<sup>Optional</sup> <a name="http_port" id="must-cdk.HttpOriginConfig.property.httpPort"></a>

```python
http_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 80

HTTP port (for HTTP protocol).

---

##### `https_port`<sup>Optional</sup> <a name="https_port" id="must-cdk.HttpOriginConfig.property.httpsPort"></a>

```python
https_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]
- *Default:* 443

HTTPS port (for HTTPS protocol).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.HttpOriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for HTTP requests (e.g., "/api/v1").

---

##### `protocol_policy`<sup>Optional</sup> <a name="protocol_policy" id="must-cdk.HttpOriginConfig.property.protocolPolicy"></a>

```python
protocol_policy: OriginProtocolPolicy
```

- *Type:* aws_cdk.aws_cloudfront.OriginProtocolPolicy
- *Default:* HTTPS_ONLY

Protocol policy for the origin.

---

### HttpOriginInfo <a name="HttpOriginInfo" id="must-cdk.HttpOriginInfo"></a>

HTTP origin information.

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.HttpOriginInfo(
  id: str,
  origin: HttpOrigin
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.HttpOriginInfo.property.origin">origin</a></code> | <code>aws_cdk.aws_cloudfront_origins.HttpOrigin</code> | *No description.* |

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

##### `origin`<sup>Required</sup> <a name="origin" id="must-cdk.HttpOriginInfo.property.origin"></a>

```python
origin: HttpOrigin
```

- *Type:* aws_cdk.aws_cloudfront_origins.HttpOrigin

---

### LoadBalancerConfig <a name="LoadBalancerConfig" id="must-cdk.LoadBalancerConfig"></a>

Configuration for the load balancer component.

#### Initializer <a name="Initializer" id="must-cdk.LoadBalancerConfig.Initializer"></a>

```python
import must_cdk

must_cdk.LoadBalancerConfig(
  certificates: typing.List[ICertificate] = None,
  existing_load_balancer: IApplicationLoadBalancer = None,
  health_check: HealthCheckConfig = None,
  internet_facing: bool = None,
  production_port: typing.Union[int, float] = None,
  security_groups: typing.List[ISecurityGroup] = None,
  subnets: SubnetSelection = None,
  test_port: typing.Union[int, float] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.LoadBalancerConfig.property.certificates">certificates</a></code> | <code>typing.List[aws_cdk.aws_certificatemanager.ICertificate]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.existingLoadBalancer">existing_load_balancer</a></code> | <code>aws_cdk.aws_elasticloadbalancingv2.IApplicationLoadBalancer</code> | Existing load balancer to use (if not provided, a new one will be created). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.healthCheck">health_check</a></code> | <code><a href="#must-cdk.HealthCheckConfig">HealthCheckConfig</a></code> | Health check configuration for target groups. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.internetFacing">internet_facing</a></code> | <code>bool</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.productionPort">production_port</a></code> | <code>typing.Union[int, float]</code> | The production listener port (default: 443 for HTTPS, 80 for HTTP). |
| <code><a href="#must-cdk.LoadBalancerConfig.property.securityGroups">security_groups</a></code> | <code>typing.List[aws_cdk.aws_ec2.ISecurityGroup]</code> | Security groups for the ALB. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.subnets">subnets</a></code> | <code>aws_cdk.aws_ec2.SubnetSelection</code> | Select which subnets the ALB will be placed on. |
| <code><a href="#must-cdk.LoadBalancerConfig.property.testPort">test_port</a></code> | <code>typing.Union[int, float]</code> | The test listener port (default: 8080). |

---

##### `certificates`<sup>Optional</sup> <a name="certificates" id="must-cdk.LoadBalancerConfig.property.certificates"></a>

```python
certificates: typing.List[ICertificate]
```

- *Type:* typing.List[aws_cdk.aws_certificatemanager.ICertificate]

Optional ACM certificates for HTTPS termination.

If not provided, HTTP listeners will be used.

---

##### `existing_load_balancer`<sup>Optional</sup> <a name="existing_load_balancer" id="must-cdk.LoadBalancerConfig.property.existingLoadBalancer"></a>

```python
existing_load_balancer: IApplicationLoadBalancer
```

- *Type:* aws_cdk.aws_elasticloadbalancingv2.IApplicationLoadBalancer

Existing load balancer to use (if not provided, a new one will be created).

---

##### `health_check`<sup>Optional</sup> <a name="health_check" id="must-cdk.LoadBalancerConfig.property.healthCheck"></a>

```python
health_check: HealthCheckConfig
```

- *Type:* <a href="#must-cdk.HealthCheckConfig">HealthCheckConfig</a>

Health check configuration for target groups.

---

##### `internet_facing`<sup>Optional</sup> <a name="internet_facing" id="must-cdk.LoadBalancerConfig.property.internetFacing"></a>

```python
internet_facing: bool
```

- *Type:* bool

Whether the load balancer should be internet-facing (default: false).

---

##### `production_port`<sup>Optional</sup> <a name="production_port" id="must-cdk.LoadBalancerConfig.property.productionPort"></a>

```python
production_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The production listener port (default: 443 for HTTPS, 80 for HTTP).

---

##### `security_groups`<sup>Optional</sup> <a name="security_groups" id="must-cdk.LoadBalancerConfig.property.securityGroups"></a>

```python
security_groups: typing.List[ISecurityGroup]
```

- *Type:* typing.List[aws_cdk.aws_ec2.ISecurityGroup]

Security groups for the ALB.

---

##### `subnets`<sup>Optional</sup> <a name="subnets" id="must-cdk.LoadBalancerConfig.property.subnets"></a>

```python
subnets: SubnetSelection
```

- *Type:* aws_cdk.aws_ec2.SubnetSelection

Select which subnets the ALB will be placed on.

---

##### `test_port`<sup>Optional</sup> <a name="test_port" id="must-cdk.LoadBalancerConfig.property.testPort"></a>

```python
test_port: typing.Union[int, float]
```

- *Type:* typing.Union[int, float]

The test listener port (default: 8080).

---

### S3OriginConfig <a name="S3OriginConfig" id="must-cdk.S3OriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.S3OriginConfig.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginConfig(
  bucket: IBucket,
  id: str,
  origin_access_identity: OriginAccessIdentity = None,
  origin_path: str = None,
  s3_origin_props: S3OriginProps = None,
  use_legacy_oa_i: bool = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginConfig.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | Existing S3 bucket to use as origin (required). |
| <code><a href="#must-cdk.S3OriginConfig.property.id">id</a></code> | <code>str</code> | Unique identifier for this S3 origin. |
| <code><a href="#must-cdk.S3OriginConfig.property.originAccessIdentity">origin_access_identity</a></code> | <code>aws_cdk.aws_cloudfront.OriginAccessIdentity</code> | Existing Origin Access Identity (only used if useLegacyOAI is true). |
| <code><a href="#must-cdk.S3OriginConfig.property.originPath">origin_path</a></code> | <code>str</code> | Origin path for S3 requests (e.g., "/static"). |
| <code><a href="#must-cdk.S3OriginConfig.property.s3OriginProps">s3_origin_props</a></code> | <code>aws_cdk.aws_cloudfront_origins.S3OriginProps</code> | Additional S3 origin properties. |
| <code><a href="#must-cdk.S3OriginConfig.property.useLegacyOAI">use_legacy_oa_i</a></code> | <code>bool</code> | Use legacy Origin Access Identity instead of modern Origin Access Control. |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginConfig.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

Existing S3 bucket to use as origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginConfig.property.id"></a>

```python
id: str
```

- *Type:* str

Unique identifier for this S3 origin.

---

##### `origin_access_identity`<sup>Optional</sup> <a name="origin_access_identity" id="must-cdk.S3OriginConfig.property.originAccessIdentity"></a>

```python
origin_access_identity: OriginAccessIdentity
```

- *Type:* aws_cdk.aws_cloudfront.OriginAccessIdentity

Existing Origin Access Identity (only used if useLegacyOAI is true).

---

##### `origin_path`<sup>Optional</sup> <a name="origin_path" id="must-cdk.S3OriginConfig.property.originPath"></a>

```python
origin_path: str
```

- *Type:* str

Origin path for S3 requests (e.g., "/static").

---

##### `s3_origin_props`<sup>Optional</sup> <a name="s3_origin_props" id="must-cdk.S3OriginConfig.property.s3OriginProps"></a>

```python
s3_origin_props: S3OriginProps
```

- *Type:* aws_cdk.aws_cloudfront_origins.S3OriginProps

Additional S3 origin properties.

---

##### `use_legacy_oa_i`<sup>Optional</sup> <a name="use_legacy_oa_i" id="must-cdk.S3OriginConfig.property.useLegacyOAI"></a>

```python
use_legacy_oa_i: bool
```

- *Type:* bool
- *Default:* false - uses OAC for better security

Use legacy Origin Access Identity instead of modern Origin Access Control.

---

### S3OriginInfo <a name="S3OriginInfo" id="must-cdk.S3OriginInfo"></a>

S3 origin information.

#### Initializer <a name="Initializer" id="must-cdk.S3OriginInfo.Initializer"></a>

```python
import must_cdk

must_cdk.S3OriginInfo(
  bucket: IBucket,
  id: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginInfo.property.bucket">bucket</a></code> | <code>aws_cdk.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#must-cdk.S3OriginInfo.property.id">id</a></code> | <code>str</code> | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginInfo.property.bucket"></a>

```python
bucket: IBucket
```

- *Type:* aws_cdk.aws_s3.IBucket

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginInfo.property.id"></a>

```python
id: str
```

- *Type:* str

---

### SubDomainOptions <a name="SubDomainOptions" id="must-cdk.SubDomainOptions"></a>

Subdomain configuration for a custom domain in an Amplify application.

#### Initializer <a name="Initializer" id="must-cdk.SubDomainOptions.Initializer"></a>

```python
import must_cdk

must_cdk.SubDomainOptions(
  branch_name: str,
  prefix: str
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.SubDomainOptions.property.branchName">branch_name</a></code> | <code>str</code> | The branch name to map to this subdomain. |
| <code><a href="#must-cdk.SubDomainOptions.property.prefix">prefix</a></code> | <code>str</code> | The prefix for the subdomain. |

---

##### `branch_name`<sup>Required</sup> <a name="branch_name" id="must-cdk.SubDomainOptions.property.branchName"></a>

```python
branch_name: str
```

- *Type:* str

The branch name to map to this subdomain.

---

##### `prefix`<sup>Required</sup> <a name="prefix" id="must-cdk.SubDomainOptions.property.prefix"></a>

```python
prefix: str
```

- *Type:* str

The prefix for the subdomain.

Use empty string for the root domain.

---

### TaggableProps <a name="TaggableProps" id="must-cdk.TaggableProps"></a>

Type for tag-aware construct props.

#### Initializer <a name="Initializer" id="must-cdk.TaggableProps.Initializer"></a>

```python
import must_cdk

must_cdk.TaggableProps(
  tags: typing.Mapping[str] = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.TaggableProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.TaggableProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

### WebSocketApiGatewayToLambdaProps <a name="WebSocketApiGatewayToLambdaProps" id="must-cdk.WebSocketApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketApiGatewayToLambdaProps.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketApiGatewayToLambdaProps(
  tags: typing.Mapping[str] = None,
  api_name: str,
  lambda_function: IFunction,
  api_props: WebSocketApiProps = None,
  custom_domain_name: str = None,
  custom_routes: typing.List[WebSocketRoute] = None,
  enable_logging: bool = None,
  existing_certificate: ICertificate = None,
  hosted_zone: IHostedZone = None,
  log_group_props: LogGroupProps = None,
  stage_name: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.tags">tags</a></code> | <code>typing.Mapping[str]</code> | Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName">api_name</a></code> | <code>str</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction">lambda_function</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps">api_props</a></code> | <code>aws_cdk.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName">custom_domain_name</a></code> | <code>str</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes">custom_routes</a></code> | <code>typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging">enable_logging</a></code> | <code>bool</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate">existing_certificate</a></code> | <code>aws_cdk.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone">hosted_zone</a></code> | <code>aws_cdk.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps">log_group_props</a></code> | <code>aws_cdk.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName">stage_name</a></code> | <code>str</code> | Stage name for the WebSocket API. |

---

##### `tags`<sup>Optional</sup> <a name="tags" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.tags"></a>

```python
tags: typing.Mapping[str]
```

- *Type:* typing.Mapping[str]

Additional tags to apply to resources. Note: Tags from TAGS environment variable will take precedence over these tags.

Environment variable format: TAGS=key1=value1,key2=value2

---

##### `api_name`<sup>Required</sup> <a name="api_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName"></a>

```python
api_name: str
```

- *Type:* str

WebSocket API configuration.

---

##### `lambda_function`<sup>Required</sup> <a name="lambda_function" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction"></a>

```python
lambda_function: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `api_props`<sup>Optional</sup> <a name="api_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps"></a>

```python
api_props: WebSocketApiProps
```

- *Type:* aws_cdk.aws_apigatewayv2.WebSocketApiProps

---

##### `custom_domain_name`<sup>Optional</sup> <a name="custom_domain_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName"></a>

```python
custom_domain_name: str
```

- *Type:* str

Optional custom domain name for API Gateway.

---

##### `custom_routes`<sup>Optional</sup> <a name="custom_routes" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes"></a>

```python
custom_routes: typing.List[WebSocketRoute]
```

- *Type:* typing.List[<a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enable_logging`<sup>Optional</sup> <a name="enable_logging" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging"></a>

```python
enable_logging: bool
```

- *Type:* bool

Enable CloudWatch logging for API Gateway.

---

##### `existing_certificate`<sup>Optional</sup> <a name="existing_certificate" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate"></a>

```python
existing_certificate: ICertificate
```

- *Type:* aws_cdk.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hosted_zone`<sup>Optional</sup> <a name="hosted_zone" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone"></a>

```python
hosted_zone: IHostedZone
```

- *Type:* aws_cdk.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `log_group_props`<sup>Optional</sup> <a name="log_group_props" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps"></a>

```python
log_group_props: LogGroupProps
```

- *Type:* aws_cdk.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stage_name`<sup>Optional</sup> <a name="stage_name" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName"></a>

```python
stage_name: str
```

- *Type:* str
- *Default:* 'dev'

Stage name for the WebSocket API.

---

### WebSocketRoute <a name="WebSocketRoute" id="must-cdk.WebSocketRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketRoute.Initializer"></a>

```python
import must_cdk

must_cdk.WebSocketRoute(
  handler: IFunction,
  route_key: str,
  route_response_selection_expression: str = None
)
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketRoute.property.handler">handler</a></code> | <code>aws_cdk.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeKey">route_key</a></code> | <code>str</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeResponseSelectionExpression">route_response_selection_expression</a></code> | <code>str</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketRoute.property.handler"></a>

```python
handler: IFunction
```

- *Type:* aws_cdk.aws_lambda.IFunction

---

##### `route_key`<sup>Required</sup> <a name="route_key" id="must-cdk.WebSocketRoute.property.routeKey"></a>

```python
route_key: str
```

- *Type:* str

---

##### `route_response_selection_expression`<sup>Optional</sup> <a name="route_response_selection_expression" id="must-cdk.WebSocketRoute.property.routeResponseSelectionExpression"></a>

```python
route_response_selection_expression: str
```

- *Type:* str

---



