from aws_cdk import App, Stack, Environment
from must_cdk import CloudFrontToOrigins
import os

class CloudFrontApiStack(Stack):
    def __init__(self, scope: App, id: str, **kwargs):
        super().__init__(scope, id, **kwargs)

        CloudFrontToOrigins(self, "ApiDistribution",
            origin_configs=[
                {
                    "originPath": "/api",
                    "originDomain": "api.example.com",
                    "allowedMethods": ["GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH"],
                    "cachePolicyName": "ApiCachePolicy",
                    "originRequestPolicyName": "ApiOriginPolicy",
                    "responseHeadersPolicyName": "ApiHeadersPolicy"
                },
                {
                    "originPath": "/static",
                    "originDomain": "static.example.com",
                    "allowedMethods": ["GET", "HEAD"],
                    "cachePolicyName": "StaticCachePolicy"
                }
            ],
            custom_domain_name="cdn.example.com",
            certificate_arn="arn:aws:acm:us-east-1:123456789012:certificate/xxx",
            web_acl_id="arn:aws:wafv2:us-east-1:123456789012:global/webacl/xxx",
            price_class="PRICE_CLASS_200",
            enable_logging=True,
            log_bucket="logs-bucket",
            log_file_prefix="cdn-logs/"
        )

app = App()
CloudFrontApiStack(app, "CloudFrontApiStack",
    env=Environment(
        account=os.getenv("CDK_DEFAULT_ACCOUNT"),
        region="ap-northeast-2"
    )
)
app.synth()
