import { Construct } from "constructs";
/**
 * Reads tags from TAGS environment variable and applies them to all resources.
 */
/**
 * Parses the TAGS environment variable and returns tags as an object.
 * Expected format: key1=value1,key2=value2
 *
 * @returns Parsed tags from environment variable
 */
export declare function getTagsFromEnvironment(): Record<string, string>;
/**
 * Merges user-provided tags with environment tags.
 * Environment tags take precedence over user tags.
 *
 * @param userTags - Optional user-provided tags
 * @returns Merged tags with environment tags taking precedence
 */
export declare function mergeTags(userTags?: Record<string, string>): Record<string, string>;
/**
 * Applies tags to both the construct and the CloudFormation stack.
 * This ensures tags are visible at both the resource and stack level.
 *
 * @param construct - The construct to apply tags to
 * @param userTags - Optional user-provided tags
 * @returns Final merged tags that were applied
 */
export declare function applyTags(construct: Construct, userTags?: Record<string, string>): Record<string, string>;
/**
 * Converts tags object to AWS CDK tag format for CfnResource.
 *
 * @param tags - Tags object
 * @returns Array of tag objects in CDK format
 */
export declare function formatTagsForCfn(tags: Record<string, string>): Array<{
    key: string;
    value: string;
}>;
/**
 * Type for tag-aware construct props.
 */
export interface TaggableProps {
    /**
     * Additional tags to apply to resources.
     * Note: Tags from TAGS environment variable will take precedence over these tags.
     *
     * Environment variable format: TAGS=key1=value1,key2=value2
     */
    readonly tags?: Record<string, string>;
}
