import { aws_ecs as ecs, aws_elasticloadbalancingv2 as elbv2, aws_codedeploy as codedeploy } from "aws-cdk-lib";
import { Construct } from "constructs";
import { EcsCodeDeployProps } from "./interface";
/**
 * A CDK construct that creates an ECS Fargate service with CodeDeploy blue-green deployment capability.
 * This construct provides a modular approach to deploy containerized applications with blue-green deployment.
 */
export declare class EcsCodeDeploy extends Construct {
    private readonly _serviceBuilder;
    private readonly _albBuilder;
    private readonly _deploymentBuilder;
    readonly service: ecs.FargateService;
    readonly loadBalancer: elbv2.ApplicationLoadBalancer;
    readonly taskDefinition: ecs.TaskDefinition;
    readonly productionTargetGroup: elbv2.ApplicationTargetGroup;
    readonly testTargetGroup: elbv2.ApplicationTargetGroup;
    readonly application: codedeploy.EcsApplication;
    readonly containers: ecs.ContainerDefinition[];
    constructor(scope: Construct, id: string, props: EcsCodeDeployProps);
    /**
     * Get the production listener
     */
    get productionListener(): elbv2.ApplicationListener;
    /**
     * Get the test listener
     */
    get testListener(): elbv2.ApplicationListener;
    /**
     * Get all listeners from the load balancer
     */
    get listeners(): elbv2.ApplicationListener[];
    /**
     * Get the load balancer DNS name
     */
    get loadBalancerDnsName(): string;
    /**
     * Get the service ARN
     */
    get serviceArn(): string;
    blueListener(): elbv2.ApplicationListener;
    greenListener(): elbv2.ApplicationListener;
    allListeners(): elbv2.ApplicationListener[];
}
